import QtQuick 2.15
import QtQuick.Layouts 1.3
import QtQuick.Controls 2.5

import org.deepin.dtk 1.0 as D
import org.deepin.ds 1.0
import org.deepin.ds.dock 1.0

Rectangle {
    id: docDropArea
    width: 80
    height: 64
    color: Qt.rgba(255,255,255,0.25)
    radius: 4
    property string text: ""
    property string desc: ""
    property var titleControl
    property var imageSource

    signal droped(string url)

    ColumnLayout{
        spacing: 3
        width: parent.width
        anchors.centerIn: parent
        D.Control {
            id: docDropIconControl
            anchors.horizontalCenter: parent.horizontalCenter
            width: 24
            height: 24
            D.DciIcon {
                name: imageSource
                anchors.centerIn: parent
                palette: D.DTK.makeIconPalette(docDropIconControl.palette)
                mode: D.ColorSelector.controlState
                theme: D.DTK.themeType
                sourceSize: Qt.size(24, 24)
            }
        }

        Label {
            horizontalAlignment: Qt.AlignHCenter//文本居中
            Layout.fillHeight: true
            Layout.fillWidth: true
            font: DTK.fontManager.t10
            elide: Text.ElideRight
            text: docDropArea.text
        }

    }

    DropArea {
        anchors.fill: parent
        onEntered: function(drag) {
            console.debug("Drag entered drop area")
            if (switchToTipsTimer.running) {
                switchToTipsTimer.stop()
            }
            docArea.isInDocDropArea = true
            if (titleControl)
                titleControl.text = desc
            docScaleAnimation.stop()
            docScaleAnimation.to =1.1
            docScaleAnimation.start()
            color = Qt.rgba(255,255,255,0.5)
        }

        onExited: function() {
            console.debug("Drag exited drop area")
            docArea.isInDocDropArea = false
            if (titleControl)
                titleControl.text = titleControl.defText
            docScaleAnimation.stop()
            docScaleAnimation.to =1.0
            docScaleAnimation.start()
            color = Qt.rgba(255,255,255,0.25)
        }

        onDropped: function(drop) {
            var urls = drop.urls
            if (urls.length !== 1) {
                console.warn(`Invalid drop - expected 1 URL, got ${urls.length}`)
                return
            }

            console.info(`File dropped: ${urls[0].toString()}`)
            droped(urls[0].toString())
            docScaleAnimation.stop()
            docScaleAnimation.to =1.0
            docScaleAnimation.start()
            color = Qt.rgba(255,255,255,0.25)
        }

        NumberAnimation {
            id : docScaleAnimation
            target: docDropArea
            property : "scale"
            duration : 200
            to : 1.1
        }

    }
}
