#include "getfreeaccountbutton.h"
#include "wrapcheckbox.h"
#include "private/echatwndmanager.h"
#include "utils/esystemcontext.h"

#include <DGuiApplicationHelper>
#include <DFontSizeManager>

#include <QApplication>
#include <QPixmap>

using namespace uos_ai;

GetFreeAccountButton::GetFreeAccountButton(const QString &text, DWidget *parent)
    : DCommandLinkButton(text, parent)
{
    EWndManager()->registeWindow(this);

}

QSize GetFreeAccountButton::sizeHint() const
{
    QSize textSize = fontMetrics().size(0, text());
    QSize size = QSize(this->iconSize().width() + textSize.width() + 10, qMax(this->iconSize().height(), textSize.height()) + 2);
    return size;
}

void GetFreeAccountButton::paintEvent(QPaintEvent *e)
{
    DStyleOptionButton opt;
    initStyleOption(&opt);

    DStylePainter painter(this);

    DPalette parentPb = DGuiApplicationHelper::instance()->applicationPalette();
    QColor highlightColor = parentPb.color(DPalette::Normal, DPalette::Highlight);

    QPixmap pixmap = this->icon().pixmap(QSize(64, 64));
    QPainter iconPainter(&pixmap);
    iconPainter.setCompositionMode(QPainter::CompositionMode_SourceIn);

    bool isDarkType = false;
    if (DGuiApplicationHelper::instance()->themeType() == DGuiApplicationHelper::DarkType)
        isDarkType = true;

    if (isDarkType)
        iconPainter.setOpacity(0.7);

    if (isEnabled() && m_isHover) {
        if (isDarkType)
            iconPainter.setOpacity(1);
        else
            iconPainter.setOpacity(0.7);
    }

    if (!this->isEnabled() || !isActiveWindow()) {
        iconPainter.setOpacity(0.4);
    }

    iconPainter.fillRect(pixmap.rect(), highlightColor);
    iconPainter.end();

    QIcon coloredIcon(pixmap);
    QSize iconSize = this->iconSize();
    QRect rect = opt.rect;
    QRect iconRect(rect.left() + 3, (rect.height() - iconSize.height()) / 2, iconSize.width(), iconSize.height());
    painter.drawItemPixmap(iconRect, Qt::AlignCenter, coloredIcon.pixmap(this->iconSize()));

    QRect textRect(rect.left() + iconSize.width() + 5, rect.top(), rect.width() - iconSize.width() - 10, rect.height());
    opt.rect = textRect;
    painter.drawControl(DStyle::CE_TextButton, opt);
}

#ifdef COMPILE_ON_QT6
void GetFreeAccountButton::enterEvent(QEnterEvent *event)
#else
void GetFreeAccountButton::enterEvent(QEvent *event)
#endif
{
    m_isHover = true;
    update();
    return DCommandLinkButton::enterEvent(event);
}

void GetFreeAccountButton::leaveEvent(QEvent *event)
{
    m_isHover = false;
    update();
    return DCommandLinkButton::leaveEvent(event);
}
