#include "dragmonitor.h"


#include <QDBusConnection>

using namespace uos_ai;
DragMonitor::DragMonitor(QObject *parent)
    : QObject{parent}
{
    auto con = QDBusConnection::sessionBus();
    con.connect("org.deepin.filemanager.drag",
                "/org/deepin/filemanager/drag", "org.deepin.filemanager.drag", "DragEnter",
                this, SLOT(onDragNotify(QStringList)));

    con.connect("com.deepin.dde.desktop",
                "/org/deepin/dde/desktop/canvas", "org.deepin.dde.desktop.canvas", "DragEnter",
                this, SLOT(onDragNotify(QStringList)));
}

void DragMonitor::onDragNotify(const QStringList &urls)
{
    emit dragEnter(urls);
}
