% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{stogo}
\alias{stogo}
\title{Stochastic Global Optimization}
\usage{
stogo(
  x0,
  fn,
  gr = NULL,
  lower = NULL,
  upper = NULL,
  maxeval = 10000,
  xtol_rel = 1e-06,
  randomized = FALSE,
  nl.info = FALSE,
  ...
)
}
\arguments{
\item{x0}{initial point for searching the optimum.}

\item{fn}{objective function that is to be minimized.}

\item{gr}{optional gradient of the objective function.}

\item{lower, upper}{lower and upper bound constraints.}

\item{maxeval}{maximum number of function evaluations.}

\item{xtol_rel}{stopping criterion for relative change reached.}

\item{randomized}{logical; shall a randomizing variant be used?}

\item{nl.info}{logical; shall the original \acronym{NLopt} info be shown.}

\item{...}{additional arguments passed to the function.}
}
\value{
List with components:
\item{par}{the optimal solution found so far.}
\item{value}{the function value corresponding to \code{par}.}
\item{iter}{number of (outer) iterations, see \code{maxeval}.}
\item{convergence}{integer code indicating successful completion (> 0)
or a possible error number (< 0).}
\item{message}{character string produced by \acronym{NLopt} and giving
additional information.}
}
\description{
\acronym{StoGO} is a global optimization algorithm that works by
systematically dividing the search space---which must be
bound-constrained---into smaller hyper-rectangles via a branch-and-bound
technique, and searching them using a gradient-based local-search algorithm
(a \acronym{BFGS} variant), optionally including some randomness.
}
\note{
Only bounds-constrained problems are supported by this algorithm.
}
\examples{

## Rosenbrock Banana objective function

rbf <- function(x) {(1 - x[1]) ^ 2 + 100 * (x[2] - x[1] ^ 2) ^ 2}

x0 <- c(-1.2, 1)
lb <- c(-3, -3)
ub <- c(3,  3)

## The function as written above has a minimum of 0 at (1, 1)

stogo(x0 = x0, fn = rbf, lower = lb, upper = ub)

}
\references{
S. Zertchaninov and K. Madsen, ``A C++ Programme for Global
Optimization,'' IMM-REP-1998-04, Department of Mathematical Modelling,
Technical University of Denmark.
}
\author{
Hans W. Borchers
}
