# File Version : 3.0.0.305
# pyOCD debugger
# Copyright (c) 2020 Arm Limited
# Copyright (c) 2020 Cypress Semiconductor Corporation
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

flash_algo = {
    'load_address' : 0x08000000,

    # Flash algorithm as a hex string
    'instructions': [
    0xE00ABE00, 0x062D780D, 0x24084068, 0xD3000040, 0x1E644058, 0x1C49D1FA, 0x2A001E52, 0x4770D1F2,
    0x4604b5f8, 0x4617460e, 0xf0004620, 0x4605fd32, 0xbdf84628, 0x08801c80, 0x1c40d003, 0xd1fc1e80,
    0x4770bf00, 0x4605b570, 0x4616460c, 0xcc0fe002, 0x3e10c50f, 0xd2fa2e10, 0xd3022e08, 0xc503cc03,
    0x2e043e08, 0xcc01d307, 0x1f36c501, 0x7821e003, 0x1c647029, 0x1e761c6d, 0xbd70d2f9, 0x4605b570,
    0xfd65f000, 0x46204604, 0xb510bd70, 0xfec7f000, 0x46204604, 0xb570bd10, 0x21014604, 0x46200489,
    0xfe00f000, 0x46284605, 0xb5f8bd70, 0x460c4605, 0x46234616, 0x21004632, 0xf0004628, 0x4607ff20,
    0xbdf84638, 0x4604b5f8, 0x4617460e, 0x466b4625, 0x4631463a, 0xf0004620, 0x4605fff2, 0xd1002d00,
    0x46289d00, 0xb5f8bdf8, 0x460d4604, 0x46324616, 0x46204629, 0xf812f001, 0x46384607, 0x0000bdf8,
    0x47706001, 0x600a6802, 0x21004770, 0x1c49e000, 0x43424a02, 0xd8fa428a, 0x00004770, 0x00000d05,
    0x4669b538, 0xf7ff4840, 0x210fffed, 0x98000209, 0x28004008, 0x2001d101, 0x2000e000, 0x46204604,
    0xb510bd38, 0x48392400, 0x78004448, 0xd1632800, 0xffe6f7ff, 0x40482101, 0x44494934, 0x46087208,
    0xfa0ff000, 0x2c004604, 0x4830d14e, 0x78404448, 0xd13a2801, 0x4448482d, 0x28007880, 0x482bd109,
    0x78c04448, 0xd10428e2, 0x49282000, 0x72484449, 0x4826e02b, 0x78804448, 0xd1092802, 0x44484823,
    0x28e478c0, 0x2002d104, 0x44494920, 0xe01c7248, 0x4448481e, 0x28057880, 0x481cd109, 0x78c04448,
    0xd10428e7, 0x49192005, 0x72484449, 0x4817e00d, 0x78804448, 0xd108280e, 0x44484814, 0x28ea78c0,
    0x200ed103, 0x44494911, 0x48107248, 0x7a004448, 0xd0052800, 0xf998f000, 0xd0012800, 0xe0002001,
    0x490a2000, 0x72884449, 0xd1012c00, 0xe0002001, 0x49062000, 0x70084449, 0x44484804, 0x4803bd10,
    0x78004448, 0x00004770, 0x40210400, 0x00000004, 0x4c10b530, 0x09e31b04, 0x4d0f011c, 0x680c1962,
    0x68cc6004, 0x690c6284, 0x694c62c4, 0x688c6304, 0x684c6244, 0x698c6184, 0x69cc6344, 0x6a0c6014,
    0xbd306054, 0x4604b510, 0x186000a1, 0xfee2f7ff, 0x0000bd10, 0x40320000, 0x40310000, 0x49dcb510,
    0x48dc4449, 0xff3ef7ff, 0xb508bd10, 0x48d94669, 0xff38f7ff, 0x444848d6, 0x99006800, 0xd0054288,
    0x444848d3, 0x48d36801, 0xff2af7ff, 0xb570bd08, 0xff47f7ff, 0x28007a00, 0x2001d001, 0x2000e000,
    0x46284605, 0x24013010, 0x49c94084, 0x48c94449, 0xff18f7ff, 0x444848c6, 0x40206800, 0xd1072800,
    0x444848c3, 0x43206800, 0x48c24601, 0xff08f7ff, 0xb5f0bd70, 0x4606b085, 0x4617460c, 0x90032000,
    0x01702500, 0x184049bc, 0xbf009001, 0x90002000, 0x9801a902, 0xf7ff3010, 0x9802fef5, 0x90000fc0,
    0xd0022c00, 0x28009800, 0x2c00d104, 0x9800d104, 0xd1012800, 0xe0002001, 0x46052000, 0xd1082d00,
    0x1c409803, 0x42b89003, 0xe004d300, 0xf7ff2001, 0x2d00fedc, 0xbf00d0da, 0x21014628, 0xb0054048,
    0xb5febdf0, 0x460e4605, 0x24002700, 0x49a20168, 0x90011840, 0x4669bf00, 0xf7ff9801, 0x9800fec3,
    0x2c000fc4, 0x1c78d107, 0x42b04607, 0xe004d300, 0xf7ff2001, 0x2c00feba, 0xbf00d0ed, 0x21014620,
    0xbdfe4048, 0x460eb5f7, 0x27004614, 0xbf002500, 0x98004621, 0xfea6f7ff, 0x0f006820, 0x21050700,
    0x42880749, 0x2001d101, 0x2000e000, 0x2d004605, 0x1c78d107, 0x42b04607, 0xe004d300, 0xf7ff2001,
    0x2d00fe94, 0xbf00d0e4, 0x21014628, 0xbdfe4048, 0xb083b5f3, 0x26002400, 0xff11f7ff, 0xd0032800,
    0xfe9ff7ff, 0xe0037a00, 0xfe8af7ff, 0x40482101, 0x98029002, 0xd1022800, 0x4e772500, 0x9802e007,
    0xd1032801, 0x4e742501, 0xe0003620, 0x2c002401, 0x217dd13b, 0x462800c9, 0xff93f7ff, 0x2c004604,
    0x9803d133, 0x0fc007c0, 0x40482101, 0x98019001, 0xd0022800, 0x44484869, 0x9803e000, 0x46394607,
    0x300c4630, 0xfe4cf7ff, 0x46302101, 0xf7ff3008, 0x4a63fe47, 0x46282100, 0xff3bf7ff, 0x2c004604,
    0x9801d112, 0xd0072800, 0x31f521ff, 0x9a044638, 0xff88f7ff, 0xe0074604, 0x31f521ff, 0x300c4630,
    0xf7ff9a04, 0x4604ff7f, 0x4620bf00, 0xbdf0b005, 0xb087b5ff, 0x460e4605, 0x9c124617, 0x90062000,
    0x99102004, 0xff4df7ff, 0x68206020, 0xd1272800, 0x81054668, 0x97048146, 0x9005980a, 0x4846a902,
    0xf7ff308c, 0x2120fe0d, 0x30884843, 0xfe08f7ff, 0x20042100, 0xf7ff9a11, 0x6020fefc, 0x28006820,
    0xa901d10d, 0x308c483c, 0xfdfcf7ff, 0x90069801, 0x68409806, 0xd0012800, 0x60202001, 0xbf00bf00,
    0x68809806, 0xbdf0b00b, 0xa803b51f, 0x91002102, 0x461a2300, 0x90029101, 0x20042106, 0xffb8f7ff,
    0x28009803, 0x2001d101, 0x2000e000, 0x46204604, 0xbd10b004, 0xb085b5f0, 0x460d4604, 0x461f4616,
    0x90032000, 0x4926a803, 0x00d2227d, 0x9200463b, 0x90029101, 0x46294632, 0xf7ff4620, 0xb005ff99,
    0xb57cbdf0, 0x26004604, 0xa9011c70, 0xff30f7ff, 0x2d004605, 0x21ffd129, 0x98010209, 0x0a004008,
    0x98017060, 0x020970a0, 0x40089801, 0x71600c00, 0x360126ff, 0x46691c70, 0xff1af7ff, 0x2d004605,
    0x21ffd112, 0x98000209, 0x0a004008, 0x980070e0, 0x210f7120, 0x98000409, 0x0c004008, 0x010971a0,
    0x40089800, 0x71e00d00, 0x4628bf00, 0x0000bd7c, 0x00000010, 0x40231008, 0x40230000, 0x000002a8,
    0x00003a98, 0xbf00b530, 0x189d1e5b, 0x0a005548, 0xd1f92b00, 0xb5f8bd30, 0x20004605, 0x48fe9000,
    0x68404448, 0xd00b2800, 0x444848fb, 0x210f6840, 0x42880709, 0x48f8d204, 0x68404448, 0xd05242a8,
    0x49f52000, 0x60484449, 0x444b4bf4, 0x00d2227d, 0x48f34629, 0x68004448, 0xff42f000, 0x2e004606,
    0x49eed140, 0x48ee4449, 0x68004448, 0xf940f001, 0x444a4aea, 0x444848eb, 0x48e96801, 0x68004448,
    0xfa2bf002, 0x2e004606, 0x48e3d12c, 0x60454448, 0x444848e4, 0x88006800, 0x2400b287, 0x48e1e01f,
    0x68004448, 0x00a16840, 0x28005840, 0x48ddd016, 0x68004448, 0x00a16840, 0x69805840, 0x28006bc0,
    0x48d8d00c, 0x68004448, 0x00a26840, 0x4ad35881, 0x48d3444a, 0x68004448, 0xfbc4f002, 0x42bc1c64,
    0xbf00dbdd, 0x9800bf00, 0xb570bdf8, 0x460b4602, 0x20002401, 0x4dcbe01c, 0x682d444d, 0x0086686d,
    0x290059a9, 0x250fd013, 0x42a9072d, 0x2602d20f, 0x4035684d, 0xd00a2d00, 0x429568cd, 0x690ed807,
    0x19ad68cd, 0xd9024295, 0x24006019, 0x1c40e006, 0x444d4dbc, 0x682d682d, 0xd8dc4285, 0x4620bf00,
    0xb570bd70, 0x24002500, 0x444848b3, 0x28007840, 0x49b1d11e, 0x70484449, 0xff80f002, 0x2c004604,
    0x200fd00b, 0x42840700, 0x6820d207, 0xd0042800, 0x0709210f, 0x42886820, 0x2501d300, 0xd1072d00,
    0x444949a8, 0x60086820, 0x49a32001, 0x70484449, 0xbd704628, 0xb0a5b530, 0x489f2500, 0x78004448,
    0xd1582800, 0x444848a0, 0x21016940, 0x430807c9, 0x489d4604, 0x69404448, 0xd01842a0, 0xfcc1f7ff,
    0x28007a80, 0x2300d006, 0x21064622, 0xf7ff2003, 0xe004fec1, 0x21074895, 0x184001c9, 0x48936084,
    0x01c92107, 0x68801840, 0xd00042a0, 0x2d002501, 0x2224d130, 0x4479498e, 0xf7ffa81c, 0xa91cfc23,
    0xf7ff488c, 0x2224fd15, 0x44794989, 0xa8133110, 0xfc18f7ff, 0x4888a913, 0xfd0af7ff, 0x49842224,
    0x311e4479, 0xf7ffa80a, 0xa90afc0d, 0x30804882, 0xfcfef7ff, 0x497e2224, 0x312a4479, 0xf7ffa801,
    0xa901fc01, 0xf7ff487d, 0x2001fcf3, 0x44494972, 0xbf007008, 0x4628bf00, 0xbd30b025, 0x010a2101,
    0x18d04b77, 0x68124a75, 0x444b4b6f, 0x605a3b80, 0x6a934a72, 0x444a4a6c, 0x61133a80, 0x6ad34a6f,
    0x444a4a69, 0x61533a80, 0x6b134a6c, 0x444a4a66, 0x61933a80, 0x6a534a69, 0x444a4a63, 0x60d33a80,
    0x69934a66, 0x444a4a60, 0x60933a80, 0x6b534a63, 0x444a4a5d, 0x61d33a80, 0x62136803, 0x62536843,
    0x010a2108, 0x18d04b5e, 0x68124a5a, 0x444b4b56, 0x629a3b80, 0x3a804a59, 0x18d201cb, 0x4a526a93,
    0x3a80444a, 0x4a556353, 0x01cb3a80, 0x6ad318d2, 0x444a4a4d, 0x63933a80, 0x3a804a50, 0x18d201cb,
    0x4a496b13, 0x3a80444a, 0x4a4c63d3, 0x01cb3a80, 0x6a5318d2, 0x444a4a44, 0x63133a80, 0x3a804a47,
    0x18d201cb, 0x4a406993, 0x3a80444a, 0x4a4362d3, 0x01cb3a80, 0x6b5318d2, 0x444a4a3b, 0x64133a80,
    0x64536803, 0x64936843, 0x010a210b, 0x18d04b3c, 0x68124a39, 0x444b4b34, 0x64da3b80, 0x3a804a37,
    0x18d201cb, 0x4a306a93, 0x3a80444a, 0x4a336593, 0x01cb3a80, 0x6ad318d2, 0x444a4a2b, 0x65d33a80,
    0x3a804a2e, 0x18d201cb, 0x4a276b13, 0x3a80444a, 0x4a2a6613, 0x01cb3a80, 0x6a5318d2, 0x444a4a22,
    0x65533a80, 0x3a804a25, 0x18d201cb, 0x4a1e6993, 0x3a80444a, 0x4a216513, 0x01cb3a80, 0x6b5318d2,
    0x444a4a19, 0x66533a80, 0x66936803, 0x66d36843, 0x010a210c, 0x18d04b1a, 0x32804a17, 0x4b126812,
    0x3b80444b, 0x4a15671a, 0x01cb3a80, 0x6a9318d2, 0x444a4a0d, 0x67d33a80, 0x3a804a10, 0x18d201cb,
    0x4a096ad3, 0x3a10444a, 0x4a0c6113, 0x01cb3a80, 0x6b1318d2, 0xe0154a04, 0x000000d8, 0x000000b0,
    0x000000a8, 0x000000ac, 0x00000090, 0x40260000, 0x000030a6, 0x40320400, 0x40320580, 0x40320080,
    0x40310000, 0x3a10444a, 0x4afa6153, 0x18d201cb, 0x4af96a53, 0x6793444a, 0x01cb4af6, 0x699318d2,
    0x444a4af5, 0x4af36753, 0x18d201cb, 0x4af26b53, 0x3270444a, 0x68036193, 0x684361d3, 0x4aef6213,
    0x01db2307, 0x689318d2, 0x444a4aeb, 0x61533280, 0xb5384770, 0xf7ff4605, 0xf7fffee1, 0x4604fe7b,
    0xd1122c00, 0xfe4df7ff, 0x2c004604, 0x9000d10d, 0x46284669, 0xfe19f7ff, 0x2c004604, 0x48e0d104,
    0xf7ff4448, 0x4604fda8, 0x4620bf00, 0xb510bd38, 0x688448dc, 0x444848d8, 0x69403080, 0xd01742a0,
    0xfb2ff7ff, 0x28007a80, 0x48d3d009, 0x30804448, 0x21062300, 0x20036942, 0xfd2cf7ff, 0x48cee008,
    0x30804448, 0x49cd6940, 0x01d22207, 0x60881889, 0x444949c9, 0x48c71d09, 0xf7ff3080, 0x49c6fb89,
    0x31284449, 0xf7ff48c8, 0x49c3fb83, 0x314c4449, 0xf7ff48c6, 0x49c0fb7d, 0x31704449, 0x308048c3,
    0xfb76f7ff, 0x49c22000, 0x70084449, 0xb510bd10, 0x444848bf, 0x28006840, 0x48bed008, 0x68004448,
    0xfcf9f000, 0x49ba2000, 0x60484449, 0xffaff7ff, 0xbd102000, 0x4602b570, 0x2401460b, 0xe0172000,
    0x444d4db5, 0x686d682d, 0x59a90086, 0xd00e2900, 0x072d250f, 0xd20a42a9, 0x684d2602, 0x2d004035,
    0x694dd005, 0xd102429d, 0x24006011, 0x1c40e006, 0x444d4da9, 0x682d682d, 0xd8e14285, 0x4620bf00,
    0xb5febd70, 0x460e4604, 0x20002700, 0x90009001, 0x4aa2bf00, 0x4621444a, 0x4448489e, 0xf0026800,
    0x4605f8f2, 0x28006960, 0x2d00d00e, 0xa801d10c, 0xf7ff6961, 0x4a99ffbf, 0x4896444a, 0x99014448,
    0xf0026800, 0x4605f8e0, 0xd0092d00, 0x46071c78, 0xdb0242b0, 0x90002001, 0x2064e004, 0xfb22f7ff,
    0xd1d62d00, 0x9800bf00, 0xb530bdfe, 0x4604b085, 0xbf002500, 0x4887bf00, 0x68004448, 0xfaa5f000,
    0xd1f82800, 0x44494985, 0x78202200, 0x92039201, 0x91049200, 0x69a09002, 0x78016a80, 0x487d4613,
    0x68004448, 0xfce4f000, 0x04c02001, 0x44494979, 0x65086809, 0x4877bf00, 0x68004448, 0x6c403080,
    0xd0f82800, 0x44484873, 0x30806800, 0xb2c56d00, 0xf7ff2064, 0x69a0fae7, 0x40286b80, 0xd1c92800,
    0xbd30b005, 0xb089b5f3, 0x98092400, 0x20009008, 0x90069007, 0x9808a907, 0xfd17f7ff, 0x2c004604,
    0x9807d109, 0x28006940, 0x9807d005, 0xa8066941, 0xff50f7ff, 0x2c004604, 0x4861d10b, 0xf7ff4448,
    0x4604fc9a, 0xd1042c00, 0x9807495e, 0xff69f7ff, 0x2c004604, 0x9d0ad173, 0x69809807, 0x98076986,
    0x980968c1, 0x90051a40, 0x90049805, 0x90032000, 0x4a52e07d, 0x484f444a, 0x99074448, 0xf0016800,
    0x4607fff0, 0xd10c2f00, 0x69409807, 0xd0082800, 0x444a4a4a, 0x44484847, 0x68009906, 0xffe1f001,
    0x2f004607, 0x2401d001, 0xbf00e064, 0x44484841, 0xf0006800, 0x2800fa1a, 0x9002d1f8, 0x9a04a902,
    0xf0029807, 0x9001f930, 0x28009801, 0x493ed005, 0x42889801, 0x2401d001, 0x9802e04c, 0xd0052800,
    0x68c09802, 0xd00142b0, 0x68c69802, 0xd20042b5, 0x9807462e, 0x22006980, 0x6803a903, 0xf7ff9804,
    0x4b2efc31, 0xaa03444b, 0x4448482a, 0x68009907, 0xf939f002, 0x2f004607, 0x9807d10d, 0x28006940,
    0x4b26d009, 0xaa03444b, 0x44484822, 0x68009906, 0xf929f002, 0x2f004607, 0x2401d002, 0xe01be01a,
    0xf7ff9807, 0x9807ff22, 0x28006940, 0x9806d002, 0xff1bf7ff, 0x9807491b, 0xfee3f7ff, 0x2c004604,
    0xe007d000, 0x98041bad, 0x90041980, 0x2d00bf00, 0xe77ed000, 0xbf00bf00, 0xb00b4620, 0xb5f8bdf0,
    0x480d2600, 0x68004448, 0xb2878800, 0x90002000, 0xe05f2500, 0x40320000, 0x00000010, 0x40260000,
    0x000000f0, 0x40260380, 0x40320400, 0x40320580, 0x000000d8, 0x000000a8, 0x000000ac, 0x000000b0,
    0x000000e0, 0x000927c0, 0x00b20006, 0x444848ca, 0x68406800, 0x584000a9, 0xd0392800, 0x444848c6,
    0x68406800, 0x584400a9, 0x68602102, 0x28004008, 0x6960d02d, 0xd0112800, 0x20002100, 0x466be007,
    0x69625c1b, 0xd101429a, 0xe0022101, 0x28041c40, 0xbf00d3f5, 0xd0002900, 0xbf00e01b, 0x68e06921,
    0xfef0f7ff, 0x2e014606, 0xe015d100, 0x28006960, 0x2000d00d, 0x4669e008, 0x29005c09, 0x7d21d003,
    0x5411466a, 0x1c40e002, 0xd3f42804, 0xbf00bf00, 0x1c6dbf00, 0xdbb942bd, 0x4630bf00, 0xb5ffbdf8,
    0x2400b08d, 0x980d990e, 0x900c1840, 0x900b2000, 0xa90b900a, 0xf7ff980c, 0x4604fbe8, 0xd1092c00,
    0x6940980b, 0xd0052800, 0x6941980b, 0xf7ffa80a, 0x4604fe21, 0xd00b2c01, 0x44484898, 0xfb6bf7ff,
    0x2c014604, 0x4996d004, 0xf7ff980b, 0x4604fe3a, 0xd07d2c01, 0x980b9d10, 0x6a466980, 0x68c1980b,
    0x1a41980d, 0x1808980e, 0x98099009, 0x20009008, 0x90069007, 0x4a8be09b, 0x488b444a, 0x990b4448,
    0xf0016800, 0x4607febe, 0xd10c2f00, 0x6940980b, 0xd0082800, 0x444a4a83, 0x44484883, 0x6800990a,
    0xfeaff001, 0x2f004607, 0x2401d001, 0xbf00e082, 0x4448487d, 0xf0006800, 0x2800f8e8, 0x42b5d1f8,
    0x462ed200, 0x6980980b, 0xa9072200, 0x98086803, 0xfb18f7ff, 0x444a4a73, 0x980b2300, 0x990b7800,
    0x6a096989, 0x93037949, 0x91019204, 0x980b9002, 0x68006980, 0x980b9000, 0x6a006980, 0x980b7902,
    0x6a006980, 0xab077801, 0x44484867, 0xf0006800, 0x4607fb0f, 0xd0012f00, 0xe04b2401, 0x4862bf00,
    0x68004448, 0xf8abf000, 0xd1f82800, 0x4448485d, 0x91002100, 0x980b9001, 0x6a006980, 0x980b7d03,
    0x6a426980, 0x44484858, 0xf0006800, 0xe000fb48, 0x4607e032, 0xd0012f00, 0xe02b2401, 0x90052000,
    0x9905e014, 0x18419806, 0x5c41980f, 0x4448484e, 0x30806800, 0xbf006101, 0x4448484b, 0xf0006800,
    0x2804f87e, 0x9805d8f8, 0x90051c40, 0x6980980b, 0x98056a41, 0xd8e44281, 0xf7ff980b, 0x1badfdc6,
    0x19809806, 0x98089006, 0x90081980, 0x2d00bf00, 0xe760d000, 0xbf00bf00, 0xb0114620, 0xb5ffbdf0,
    0x4605b085, 0x4617460e, 0x44484838, 0xfaa3f7ff, 0x24009004, 0x28009804, 0x9503d11a, 0xa9029002,
    0xf7ff4628, 0x9001fb02, 0x28009801, 0x4634d001, 0x2400e00d, 0x5d39e008, 0x5d009803, 0xd0024281,
    0x90042001, 0x1c64e002, 0xd3f442b4, 0xbf00bf00, 0x98081929, 0x98046001, 0xbdf0b009, 0xb085b5f0,
    0x460f4606, 0x48214614, 0xf7ff4448, 0x9003fa74, 0x28009803, 0x9002d120, 0x04210620, 0x02214308,
    0x43204308, 0x46359001, 0xa902e011, 0xf7ff4628, 0x9000facc, 0x28009800, 0xe007d000, 0x98016829,
    0xd0024281, 0x90032001, 0xbf00e004, 0x19f01d2d, 0xd8ea42a8, 0xbf00bf00, 0xb0059803, 0x4601bdf0,
    0x58402084, 0x0f000700, 0x46014770, 0x0fc06848, 0x40502201, 0x47704050, 0x000000ac, 0x000000e0,
    0x0000c350, 0x000000b0, 0x000000a8, 0x000000f0, 0x4602b510, 0x78532000, 0x7814021b, 0x46184323,
    0xd0052900, 0x061b78d3, 0x04247894, 0x43184323, 0xb5febd10, 0x460f4604, 0x900168b8, 0xbf00683e,
    0x59002084, 0x0f000700, 0x1a082108, 0x99019002, 0x42889802, 0x9801d901, 0x9802e000, 0xe0804605,
    0xd10c2d08, 0x46302101, 0xffd2f7ff, 0x51082198, 0x1d302101, 0xffccf7ff, 0x51082198, 0x2d01e05d,
    0x7831d103, 0x51012090, 0x2d02e057, 0x2100d106, 0xf7ff4630, 0x2194ffbd, 0xe04e5108, 0xd1092d03,
    0x46302100, 0xffb4f7ff, 0x51082194, 0x209078b1, 0xe0425101, 0xd1062d04, 0x46302101, 0xffa8f7ff,
    0x51082198, 0x2d05e039, 0x2101d109, 0xf7ff4630, 0x2198ff9f, 0x79315108, 0x51012090, 0x2d06e02d,
    0x2101d10c, 0xf7ff4630, 0x2198ff93, 0x21005108, 0xf7ff1d30, 0x2194ff8d, 0xe01e5108, 0xd10f2d07,
    0x46302101, 0xff84f7ff, 0x51082198, 0x1d302100, 0xff7ef7ff, 0x51082194, 0x209079b1, 0xe00c5101,
    0x46302101, 0xff74f7ff, 0x51082198, 0x1d302101, 0xff6ef7ff, 0x51082198, 0x19762508, 0x1b409801,
    0xbf009001, 0x59002084, 0x0f000700, 0x1a082108, 0x99019002, 0x42889802, 0x9801d901, 0x9802e000,
    0x2d004605, 0xe77bd000, 0x9801603e, 0x980160b8, 0xd1112800, 0xf0004620, 0x0840fd12, 0x46010040,
    0x46209000, 0xfd06f000, 0x61b82001, 0x280069f8, 0x69f9d002, 0x47882001, 0x7008bdfe, 0x0e1b0403,
    0x2a00704b, 0x0203d004, 0x708b0e1b, 0x70cb0e03, 0xb5fe4770, 0x460f4604, 0x90016978, 0xbf0068fe,
    0x590020c4, 0x0f000700, 0x99019002, 0x42889802, 0x9801d901, 0x9802e000, 0xe07e4605, 0xd10c2d08,
    0x590821d8, 0x46312201, 0xffd7f7ff, 0x590821d8, 0x1d312201, 0xffd1f7ff, 0x2d01e05d, 0x20d0d103,
    0x70305900, 0x2d02e057, 0x21d4d106, 0x22005908, 0xf7ff4631, 0xe04effc2, 0xd1092d03, 0x590821d4,
    0x46312200, 0xffb9f7ff, 0x590020d0, 0xe04270b0, 0xd1062d04, 0x590821d8, 0x46312201, 0xffadf7ff,
    0x2d05e039, 0x21d8d109, 0x22015908, 0xf7ff4631, 0x20d0ffa4, 0x71305900, 0x2d06e02d, 0x21d8d10c,
    0x22015908, 0xf7ff4631, 0x21d4ff98, 0x22005908, 0xf7ff1d31, 0xe01eff92, 0xd10f2d07, 0x590821d8,
    0x46312201, 0xff89f7ff, 0x590821d4, 0x1d312200, 0xff83f7ff, 0x590020d0, 0xe00c71b0, 0x590821d8,
    0x46312201, 0xff79f7ff, 0x590821d8, 0x1d312201, 0xff73f7ff, 0x19762508, 0x1b409801, 0xbf009001,
    0x590020c4, 0x0f000700, 0x99019002, 0x42889802, 0x9801d901, 0x9802e000, 0x2d004605, 0xe77dd000,
    0x980160fe, 0x98016178, 0xd1112800, 0xf0004620, 0x2102fc56, 0x46014388, 0x46209000, 0xfc4af000,
    0x61b82003, 0x28006a38, 0x6a39d002, 0x47882003, 0x61789801, 0xb570bdfe, 0x25004604, 0x28006820,
    0x2001d00c, 0xfecef7fe, 0x1e406820, 0x68206020, 0xd1012800, 0xe00048f9, 0x46052000, 0xbd704628,
    0x4605b5fe, 0x4617460c, 0x48f4461e, 0x90011c80, 0xd02e2d00, 0xd02c2c00, 0xd02a2e00, 0x46286277,
    0xfc1df000, 0x00800880, 0x90004601, 0xf0004628, 0xbf00fc11, 0xbf00bf00, 0xbf00bf00, 0xbf00bf00,
    0x7820bf00, 0x0fc007c0, 0x030968a1, 0x03122203, 0x43084011, 0x040988a1, 0x04122207, 0x43084011,
    0x06097b21, 0x06122201, 0x43084011, 0x20006028, 0x98019001, 0xb510bdfe, 0x02122203, 0x23006002,
    0x50132280, 0x501322c0, 0x230f2200, 0x18c301db, 0x2100649a, 0x2200e006, 0x240101cb, 0x190402e4,
    0x1c4950e2, 0xd3f62904, 0xbf00bd10, 0x2900bf00, 0x6802d104, 0x00520852, 0xe0036002, 0x23016802,
    0x6002431a, 0x46014770, 0x680a2000, 0x0fd207d2, 0xd0002a00, 0x47702001, 0x4604b5f0, 0x4615460b,
    0xbf00bf00, 0xbf00bf00, 0x461e4621, 0xd0062e01, 0xd0082e02, 0xd00c2e04, 0xd1172e08, 0x2701e00f,
    0x19c802ff, 0x2701e014, 0x19cf02ff, 0x30804638, 0x2701e00e, 0x19cf02ff, 0x30f91df8, 0x2701e008,
    0x19cf02ff, 0x30ff4638, 0xe0013081, 0xbf002000, 0xbf00bf00, 0x2a004602, 0x6810d009, 0x04092103,
    0x04294388, 0x04362603, 0x43084031, 0xbdf06010, 0xb083b5ff, 0x9f0c4606, 0x90022000, 0xbf00bf00,
    0xbf00bf00, 0xbf00bf00, 0xbf00bf00, 0xbf00bf00, 0x980e2400, 0x210f0205, 0x400d0209, 0x6a409810,
    0x98059001, 0x21030400, 0x40080409, 0x99044328, 0x4308b2c9, 0xd1012f00, 0xe000990f, 0x03c92100,
    0x03d22201, 0x43084011, 0xe01f6530, 0xf0004630, 0x2804fb5c, 0x9806d216, 0x43285d00, 0x0409990d,
    0x04122203, 0x43084011, 0x42b91c61, 0x2100d201, 0x990fe000, 0x220103c9, 0x401103d2, 0x65304308,
    0xb2c41c60, 0xf7ffa801, 0x9002fef6, 0xd20342bc, 0x9802497a, 0xd1d94288, 0xb0079802, 0xb5ffbdf0,
    0x4607b083, 0x4615460e, 0x48749c0d, 0x90021e40, 0xbf00bf00, 0xbf00bf00, 0xf0004638, 0x2804fb26,
    0x9806d220, 0x21030400, 0x40080409, 0x04892101, 0x1e694308, 0x4308b289, 0x2e006538, 0x6026d010,
    0x60a56065, 0x61e0980c, 0x61a02002, 0xf0004638, 0x2101fb06, 0x46014308, 0x46389001, 0xfafaf000,
    0x90022000, 0xb0079802, 0xb5f0bdf0, 0x4606b08d, 0x4614460d, 0x4859461f, 0x900c1c80, 0xbf00bf00,
    0xd02f2c00, 0x900c1ec0, 0xf0004630, 0x2804faee, 0x0438d228, 0x04092103, 0x21014008, 0x43080489,
    0xb2891e61, 0x65304308, 0x900c2000, 0xd0192d00, 0x6a409812, 0x9501900b, 0x20009403, 0x20029008,
    0xe0079007, 0x4630a901, 0xfd13f7ff, 0xf7ffa80b, 0x900cfe82, 0x28029807, 0x4940d103, 0x4288980c,
    0xbf00d1f0, 0xb00d980c, 0xb5ffbdf0, 0x4607b083, 0x4614460e, 0x48399d0d, 0x90021c80, 0xbf00bf00,
    0xd0272c00, 0x90021ec0, 0xf0004638, 0x2804faae, 0x9806d220, 0x21030400, 0x40080409, 0x04c92101,
    0x1e614308, 0x4308b289, 0x2e006538, 0x60eed010, 0x616c612c, 0x6228980c, 0x61a82004, 0xf0004638,
    0x2102fa8e, 0x46014308, 0x46389001, 0xfa82f000, 0x90022000, 0xb0079802, 0xb5f0bdf0, 0x4606b08d,
    0x4614460d, 0x481d461f, 0x900c1c80, 0xbf00bf00, 0xd02f2c00, 0x900c1ec0, 0xf0004630, 0x2804fa76,
    0x0438d228, 0x04092103, 0x21014008, 0x430804c9, 0xb2891e61, 0x65304308, 0x900c2000, 0xd0192d00,
    0x6a409812, 0x9504900b, 0x20009406, 0x20049009, 0xe0079007, 0x4630a901, 0xfd5bf7ff, 0xf7ffa80b,
    0x900cfe0a, 0x28049807, 0x4904d103, 0x4288980c, 0xbf00d1f0, 0xb00d980c, 0x0000bdf0, 0x00b20002,
    0x4605b570, 0x4ef8460c, 0xd00c2c00, 0x46281ef6, 0xfa3bf000, 0xd2062804, 0xb2801e60, 0x04892103,
    0x65284308, 0x46302600, 0x4602bd70, 0x47706988, 0x600a2200, 0x608a604a, 0x610a60ca, 0x618a614a,
    0x23016802, 0x431a07db, 0x47706002, 0xb087b5ff, 0x46174604, 0x900648e4, 0x6a409810, 0xbf009005,
    0x2f00bf00, 0x9808d062, 0x0f000700, 0xd15d2800, 0x26009006, 0x0130e055, 0x01309004, 0x01090901,
    0x18099808, 0x01402011, 0x20015101, 0x59000240, 0x00490841, 0x02402001, 0x21015101, 0xe0035101,
    0xf7ffa805, 0x9006fda8, 0x02402001, 0x07c05900, 0x28000fc0, 0x49ccd004, 0x98061e89, 0xd1ef4288,
    0x1e8949c9, 0x42889806, 0xe02ed100, 0x01492113, 0x22015908, 0xf7ff4669, 0x2199fcd0, 0x59080089,
    0xa9012201, 0xfcc9f7ff, 0x00c9214d, 0x22015908, 0xf7ffa902, 0x219bfcc2, 0x59080089, 0xa9032201,
    0xfcbbf7ff, 0xe0092500, 0x19409804, 0x46695c38, 0x40485d49, 0x19499904, 0x1c6d5478, 0xd3f32d10,
    0x980a1c76, 0x42b00900, 0xbf00d8a5, 0xb00b9806, 0xb510bdf0, 0x20004602, 0xd0042901, 0xd00b2902,
    0xd1242903, 0x23ffe012, 0x589b3301, 0x07e42401, 0x0de44323, 0xe01c50a3, 0x338123ff, 0x2401589b,
    0x432307e4, 0x348124ff, 0xe01250a3, 0x330123ff, 0x2401589b, 0x432307e4, 0x50a30de4, 0x338123ff,
    0x05e4589b, 0x24ff4323, 0x50a33481, 0x4896e001, 0xbf00bf00, 0xb510bd10, 0x20004602, 0xd0042901,
    0xd00b2902, 0xd1232903, 0x23ffe011, 0x589b3301, 0x0864005c, 0x330123ff, 0xe01b509c, 0x338123ff,
    0x005c589b, 0x23ff0864, 0x509c3381, 0x23ffe012, 0x589b3301, 0x0864005c, 0x330123ff, 0x23ff509c,
    0x589b3381, 0x0864005c, 0x338123ff, 0xe001509c, 0xbf00487d, 0xbd10bf00, 0x4602b510, 0x29012000,
    0x2902d004, 0x2903d00b, 0xe012d124, 0x330123ff, 0x2401589b, 0x432307a4, 0x50a315a4, 0x23ffe01c,
    0x589b3381, 0x07a42401, 0x24ff4323, 0x50a33481, 0x23ffe012, 0x589b3301, 0x07a42401, 0x15a44323,
    0x23ff50a3, 0x589b3381, 0x432305a4, 0x348124ff, 0xe00150a3, 0xbf004864, 0xbd10bf00, 0x4602b510,
    0x29012000, 0x2902d004, 0x2903d00b, 0xe012d124, 0x330123ff, 0x2401589b, 0x43a307a4, 0x50a315a4,
    0x23ffe01c, 0x589b3381, 0x07a42401, 0x24ff43a3, 0x50a33481, 0x23ffe012, 0x589b3301, 0x07a42401,
    0x15a443a3, 0x23ff50a3, 0x589b3381, 0x43a305a4, 0x348124ff, 0xe00150a3, 0xbf00484b, 0xbd10bf00,
    0x4602b510, 0x29012000, 0x2902d004, 0x2903d00b, 0xe011d123, 0x330923ff, 0x2401589b, 0x24ff4323,
    0x50a33409, 0x23ffe01b, 0x589b3389, 0x43232401, 0x348924ff, 0xe01250a3, 0x330923ff, 0x2401589b,
    0x24ff4323, 0x50a33409, 0x338923ff, 0x2401589b, 0x24ff4323, 0x50a33489, 0x4833e001, 0xbf00bf00,
    0xb5febd10, 0x460e4604, 0x90012000, 0xbf00bf00, 0x68a06867, 0x2e019000, 0x2e02d006, 0x2e04d030,
    0x2e08d033, 0xe031d137, 0x99004638, 0xfe6df7ff, 0x2804b2c0, 0x2001d101, 0x2000e000, 0x46384605,
    0xf898f000, 0xd1012800, 0xd0012d00, 0xe0002001, 0x46052000, 0xf7ff4638, 0x2801fcb6, 0x2d00d001,
    0x2001d001, 0x2000e000, 0x2d004605, 0x4817d002, 0xe0049001, 0xf0004638, 0x2000f868, 0xe00d9001,
    0x99004638, 0xfe44f7ff, 0xe007e008, 0x99004638, 0xfe3ef7ff, 0x480de002, 0xbf009001, 0x9801bf00,
    0xb5febdfe, 0x460e4604, 0x90012000, 0xbf00bf00, 0x68a06867, 0x2e019000, 0x2e02d00a, 0x2e04d034,
    0x2e08d037, 0xe035d13b, 0x00b20004, 0x004200ff, 0x99004638, 0xfe19f7ff, 0x2804b2c0, 0x2001d101,
    0x2000e000, 0x46384605, 0xf844f000, 0xd1012800, 0xd0012d00, 0xe0002001, 0x46052000, 0xf7ff4638,
    0x2801fc62, 0x2d00d001, 0x2001d001, 0x2000e000, 0x2d004605, 0x481bd002, 0xe0049001, 0x90012000,
    0xf0004638, 0xe00df812, 0x99004638, 0xfdf0f7ff, 0xe007e008, 0x99004638, 0xfdeaf7ff, 0x4811e002,
    0xbf009001, 0x9801bf00, 0x6801bdfe, 0x08490049, 0x47706001, 0x01d2220f, 0x64911882, 0x46014770,
    0x01c0200f, 0x6c801808, 0x46014770, 0x07406c48, 0x47700f40, 0x68484601, 0x22010fc0, 0x40504050,
    0x00004770, 0x004200ff, 0x460bb5f0, 0x68a1699c, 0x68dd6a22, 0x022d0a2d, 0x691d6085, 0x1c6d43ed,
    0x022d0a2d, 0x782560c5, 0x07ad1e6d, 0x695e0fad, 0xd0022e00, 0x360126ff, 0x2600e000, 0x62054335,
    0xd03a2900, 0x43f62600, 0x42b5680d, 0x780dd009, 0x0436790e, 0x043f2703, 0x4335403e, 0x19ad03fe,
    0x2500e000, 0x794d6405, 0x2603042d, 0x40350436, 0x26006445, 0x688d43f6, 0xd00942b5, 0x7b0e7a0d,
    0x27030436, 0x403e043f, 0x03fe4335, 0xe00019ad, 0x64852500, 0x2d00690d, 0x7c0dd007, 0x06ed1e6d,
    0x26010eed, 0x19ad07f6, 0x2500e000, 0x7d0d64c5, 0x2603042d, 0x40350436, 0x2a006505, 0x2600d03a,
    0x681543f6, 0xd00942b5, 0x79167815, 0x27030436, 0x403e043f, 0x03fe4335, 0xe00019ad, 0x66052500,
    0x042d7955, 0x04362603, 0x66454035, 0x43f62600, 0x42b56895, 0x7a15d009, 0x04367b16, 0x043f2703,
    0x4335403e, 0x19ad03fe, 0x2500e000, 0x69156685, 0xd0072d00, 0x1e6d7c15, 0x0eed06ed, 0x07f62601,
    0xe00019ad, 0x66c52500, 0x042d7d15, 0x04362603, 0x67054035, 0xb5ffbdf0, 0x460cb087, 0x461e4615,
    0x48f89f12, 0x20009006, 0x97049001, 0x90039402, 0x90009811, 0x46312200, 0x98079b10, 0xfbb8f7ff,
    0x98069006, 0xd1072800, 0x22012300, 0x97004629, 0xf7ff9807, 0x9006fcb2, 0xb00b9806, 0xb5ffbdf0,
    0x460db08f, 0x900b2000, 0x2400900a, 0x90089009, 0x387a48e4, 0xe0579007, 0x5c281c60, 0x1ce0900e,
    0x900d5c28, 0x900c2000, 0x5c281ca0, 0x400821c0, 0x90080980, 0x28009808, 0x2801d004, 0x2802d005,
    0xe005d109, 0x90092000, 0x2003e009, 0xe0069009, 0x90092004, 0x9812e003, 0x90096800, 0xbf00bf00,
    0xe0082000, 0x9a091d21, 0x1a091889, 0x5c691e49, 0x5411aa0b, 0x99091c40, 0xd3f34288, 0x9909aa0b,
    0x92009819, 0x90029101, 0x9b0eaa0c, 0x980f9918, 0xff91f7ff, 0x98079007, 0xd10d2800, 0x0640980a,
    0xa9080e00, 0x9a0d7c09, 0x29004011, 0x2101d001, 0x2100e000, 0x900a4308, 0x98113408, 0xd9034284,
    0x387948b8, 0xe0049007, 0x21025d28, 0x28004008, 0xbf00d0a2, 0x28009807, 0xe00bd112, 0x5c281ca0,
    0x00801c80, 0x98111904, 0xd9034284, 0x387948ad, 0xe0049007, 0x5c291c60, 0x4281980a, 0xbf00d1ee,
    0x28009807, 0x1ca0d16f, 0x1c405c28, 0x9006b2c0, 0x98069912, 0x980664c8, 0xd8032801, 0x387a48a1,
    0xe05f9007, 0x90042000, 0x90019003, 0x9903e055, 0x18409804, 0x1d249004, 0x20012700, 0x5d289002,
    0x0f000700, 0xe00b9005, 0x06409802, 0x90020e00, 0xb2c71c78, 0xd9032f04, 0x38794892, 0xe0049007,
    0x98059902, 0x28004008, 0xbf00d0ee, 0x0a005928, 0x02001c40, 0x98129003, 0x98016d01, 0x580e0080,
    0x60309804, 0x4378200c, 0x5c08991a, 0x200c60b0, 0x991a4378, 0x68801840, 0x200c6130, 0x991a4378,
    0x68411840, 0x42819803, 0x9803d904, 0x200160f0, 0xe00e6070, 0x4378200c, 0x1840991a, 0x60f06840,
    0x4378200c, 0x18809a1a, 0x98036841, 0xfb3cf001, 0x98016070, 0xb2c01c40, 0x99069001, 0x42889801,
    0xbf00dba5, 0x9807bf00, 0xbdf0b013, 0xb085b5ff, 0x9e10460c, 0x3d7b4d6b, 0x79612200, 0xaf029808,
    0x9101c745, 0x90002003, 0x78217922, 0x98059b07, 0xfa9ef7ff, 0x2d004605, 0x6921d12d, 0xf7ff9805,
    0x4605fbdf, 0xd1262d00, 0x90009601, 0x9a0e7d23, 0x9805990f, 0xfb59f7ff, 0x2d004605, 0x6a77d11b,
    0xbf00e011, 0x90042000, 0xd00a2f00, 0xf7fe2001, 0x1e7ff899, 0xd1022f00, 0x387e4852, 0x2000e000,
    0x98049004, 0x69b04605, 0xd0032803, 0x387e484d, 0xd1e64285, 0x4628bf00, 0xbdf0b009, 0xb083b5f7,
    0x6a439804, 0x381b9803, 0x90020840, 0x0f000718, 0xbf009001, 0x2000bf00, 0xbf009000, 0x00c6e02d,
    0x461f1a36, 0x093940f7, 0x400e2660, 0x06cd0974, 0x2c000eed, 0x2c01d006, 0x2c02d007, 0x2c03d008,
    0xe008d10d, 0x96002601, 0x2610e00a, 0xe0079600, 0x96002680, 0x267de004, 0x960000f6, 0xbf00e000,
    0x1c6ebf00, 0x437e9f00, 0x1c7f9f01, 0x437e007f, 0x4347270c, 0x60be18bf, 0x28041c40, 0x9802d3cf,
    0x260c1e40, 0x18804370, 0xb0066880, 0xb5f8bdf0, 0x460c4603, 0x68194615, 0xd12b2904, 0x1e422000,
    0x6032695e, 0x261e7862, 0x08524032, 0x21009200, 0x2601e009, 0x2201408e, 0x9f00408a, 0x4296403a,
    0xe002d100, 0x29041c49, 0xbf00d9f3, 0xd2102904, 0x22001d08, 0x1d16e005, 0x270c5da6, 0x55ee4357,
    0x2a041c52, 0x5c22d3f7, 0x6032695e, 0x4610004a, 0xe00f301d, 0xe004201d, 0xd3012823, 0xe0032000,
    0x5c211c80, 0xd0f729ff, 0x2800bf00, 0x5c21d002, 0x6011695a, 0xd0072800, 0x695a2100, 0x695a7111,
    0xe0047151, 0x00b20080, 0x695a21ff, 0xbdf87111, 0x60012102, 0x71012100, 0x1e497141, 0x21006081,
    0x61017301, 0x47707501, 0x60012112, 0x71012100, 0x1e497141, 0x21006081, 0x61017301, 0x47707501,
    0x60012134, 0x71012100, 0x1e497141, 0x21006081, 0x61017301, 0x75012102, 0x213e4770, 0x21006001,
    0x21027101, 0x1ec97141, 0x21026081, 0x21007301, 0x21026101, 0x47707501, 0x4606b5f8, 0x4617460d,
    0x002b6834, 0xfabdf001, 0x36374306, 0x43042135, 0x300120ff, 0x28004020, 0x4638d003, 0xffddf7ff,
    0x2080e012, 0x28004020, 0x4638d003, 0xffc8f7ff, 0x2040e00a, 0x28004020, 0x4638d003, 0xffb4f7ff,
    0x4638e002, 0xffa4f7ff, 0x2080e024, 0x28004020, 0x4638d003, 0xffb4f7ff, 0x2040e00a, 0x28004020,
    0x4638d003, 0xffa0f7ff, 0x4638e002, 0xff90f7ff, 0xbf00e010, 0x2040bf00, 0x28004020, 0x4638d003,
    0xff92f7ff, 0x4638e002, 0xff82f7ff, 0xbf00e002, 0xbf00bf00, 0xbdf8bf00, 0x4604b510, 0x000b6820,
    0xfa6ff001, 0x19202706, 0x27040b12, 0x40032320, 0xd0012b00, 0x601323ec, 0x2310e01c, 0x2b004003,
    0x236cd001, 0xe0156013, 0x40032308, 0xd0012b00, 0x601323bc, 0x2304e00e, 0x2b004003, 0x233cd001,
    0xe0076013, 0x40032302, 0xd0012b00, 0x6013230c, 0xbf00e000, 0xbd10bf00, 0xb085b5ff, 0x461d460c,
    0x20404ef9, 0x28004020, 0x2600d000, 0x0fc007e0, 0xd02d2800, 0x40202002, 0xd0142800, 0x68c79807,
    0xd00f2f00, 0x22ff2101, 0x9502980e, 0x91039201, 0x20009004, 0x793a9000, 0x46037839, 0xf7ff9805,
    0x4606f8f7, 0x48e8bf00, 0xd0014286, 0xd10f2e00, 0x22ff2101, 0x9502980e, 0x91039201, 0x20009004,
    0x46024603, 0x900021b7, 0xf7ff9805, 0x4606f8e1, 0xb0094630, 0x2203bdf0, 0x2200600a, 0x714a710a,
    0x608a1e52, 0x610a2200, 0x4770750a, 0x600a7b42, 0x710a2200, 0x7b02714a, 0x401a23e0, 0x2a000952,
    0x1e52d102, 0xe003608a, 0x608a22ff, 0x730a2200, 0x06d27b02, 0x610a0ed2, 0x750a2201, 0x7bc24770,
    0x2200600a, 0x2201710a, 0x7b82714a, 0x401a23e0, 0x2a000952, 0x1e52d102, 0xe003608a, 0x608a22ff,
    0x730a2201, 0x06d27b82, 0x610a0ed2, 0x750a2201, 0x7ac24770, 0x2200600a, 0x714a710a, 0x23e07a82,
    0x0952401a, 0xd1022a00, 0x608a1e52, 0x22ffe003, 0x2200608a, 0x7a82730a, 0x0ed206d2, 0x2202610a,
    0x4770750a, 0x600a7a42, 0x710a2200, 0x714a2202, 0x23e07a02, 0x0952401a, 0xd1022a00, 0x608a1e52,
    0x22ffe003, 0x2202608a, 0x7a02730a, 0x0ed206d2, 0x2202610a, 0x4770750a, 0x4604b5fe, 0x4617460e,
    0x900120ff, 0x2e012502, 0x2e03d003, 0x2001d001, 0x2000e000, 0x98009000, 0xd0192800, 0x21205d60,
    0x28004008, 0x4639d006, 0xf7ff4620, 0x2005ffcb, 0xe02b9001, 0x21405d60, 0x28004008, 0x4639d006,
    0xf7ff4620, 0x2004ffa6, 0xe01f9001, 0xe01dbf00, 0x21105d60, 0x28004008, 0x4639d006, 0xf7ff4620,
    0x2003ff7e, 0xe0119001, 0x07c05d60, 0x28000fc0, 0x4639d006, 0xf7ff4620, 0x2002ff59, 0xe0059001,
    0x46204639, 0xff47f7ff, 0x90012001, 0xbdfe9801, 0x4603b5f8, 0x26016a99, 0x400e0376, 0x261f0b74,
    0x400e0236, 0x070e0a35, 0x96000f36, 0xd1012c00, 0xe0002208, 0x1c6e2240, 0x9f004356, 0x007f1c7f,
    0x43784630, 0xb5fcbdf8, 0x6a4b4601, 0x26036a8a, 0x40160776, 0x261f0f74, 0x40160636, 0x96010e36,
    0x071e2500, 0x96000f36, 0xd0062c00, 0xd0062c01, 0xd0072c02, 0xd10b2c03, 0x2510e007, 0x25ffe009,
    0xe0063501, 0x016d257d, 0x257de003, 0xe000026d, 0xbf00bf00, 0x1c769e01, 0x9f00436e, 0x007f1c7f,
    0x43784630, 0x2160bdfc, 0x21006001, 0x47707101, 0xbf00b500, 0xbf00bf00, 0x2200bf00, 0x711a6b03,
    0x5c52223a, 0x401a2370, 0x00130912, 0xf8e9f001, 0x170c0406, 0x290e0d20, 0x43d22200, 0x6b0363c2,
    0x6ac3601a, 0xe01d601a, 0xbf00bf00, 0x63c22202, 0x6b032201, 0x2235601a, 0x601a6ac3, 0x2240e012,
    0x220163c2, 0x601a6b03, 0x6ac32205, 0xe009601a, 0x63c22280, 0x6b03223e, 0x223f601a, 0x601a6ac3,
    0xbf00e000, 0xbd00bf00, 0x60012105, 0x71012100, 0x21044770, 0x21006001, 0x47707101, 0x60012106,
    0x71012100, 0x46014770, 0x5c522228, 0x401a23f0, 0x22010913, 0x4610409a, 0xb5704770, 0x24014601,
    0x794d2300, 0x790e022d, 0x462b4335, 0xd0052c00, 0x062d79cd, 0x0436798e, 0x432b4335, 0xbf00461a,
    0x07db0fd3, 0xd1022b00, 0x08d81c53, 0x1ed0e003, 0x07e42401, 0xbd704320, 0x4601b510, 0x788b2000,
    0x40232406, 0x2a00085a, 0x2a01d004, 0x2a02d004, 0xe003d106, 0xe0042003, 0xe0022004, 0xe0002004,
    0xbf00bf00, 0xb530bd10, 0x23004602, 0xe0102000, 0x341c461c, 0x24015d15, 0x250c40ac, 0x186d4345,
    0x461c606c, 0x5d15341d, 0x4344240c, 0x1c9b550d, 0x28041c40, 0xbd30d3ec, 0x4603b570, 0x2000460a,
    0x21082400, 0x0000e018, 0x00b20080, 0x5c56b2dd, 0xd11042b5, 0x0e2d041d, 0x5d961dce, 0xd10a42b5,
    0x5d551c4d, 0xd30642a5, 0x5d551c8d, 0xd1022d01, 0x5d541c4d, 0x31084608, 0x00ed7995, 0x428d3508,
    0xbd70d2e4, 0xb081b5ff, 0x4616460c, 0x48f9461f, 0x46219000, 0xf7ff9801, 0x4605ffcf, 0xd00e2d00,
    0x5c201d28, 0x1d6870b0, 0x70705c20, 0x5c201da8, 0x1ce87030, 0x00805c20, 0x20006038, 0x98009000,
    0xbdf0b005, 0xb0cdb5ff, 0x4617460c, 0xbf009e56, 0x2000bf00, 0x90329033, 0x4de69031, 0x6b603d7b,
    0x20009030, 0x2100e003, 0x5411aa34, 0x28641c40, 0x4639d3f9, 0x984d9a50, 0xfe8ef7fe, 0x28009830,
    0xa834d00b, 0x463b2138, 0x9602aa33, 0x90019100, 0x984d9930, 0xfc0af7ff, 0x2d004605, 0xa830d105,
    0x28067d80, 0x4dd3d901, 0x2d003d7b, 0xa830d17d, 0x28537c00, 0xa830d17a, 0x28467c40, 0xa830d1fa,
    0x28447c80, 0xa830d1f6, 0x28507cc0, 0xa830d1f2, 0x28067d00, 0xa830d36a, 0x28017d40, 0x48c6d1ea,
    0x20009023, 0xab229022, 0xa934aa32, 0xf7ff9823, 0x4605ff89, 0x1ec048c0, 0x20009023, 0xab219021,
    0xa934aa31, 0xf7ff9823, 0x4605ff7d, 0x428548b9, 0x2000d102, 0x652064e0, 0x020020ff, 0x20009023,
    0xab209020, 0xa934aa33, 0xf7ff9823, 0x4605ff6b, 0xd17d2d00, 0xbf00bf00, 0xbf00bf00, 0xbf00bf00,
    0xbf00bf00, 0xbf00bf00, 0xbf00bf00, 0xbf00bf00, 0x9920a834, 0xaa33463b, 0x91009602, 0x99309001,
    0xf7ff984d, 0x4605fba3, 0xa834a924, 0xff0bf7ff, 0xf7ffa834, 0x6020fef1, 0xf7ffa834, 0x6060fece,
    0xf7ffa834, 0x6260fec0, 0xf7ff68e0, 0x6920feb7, 0xfeaff7ff, 0x63a02001, 0xf7ff6aa0, 0xa934fea5,
    0xf7ff4620, 0x69e0fe65, 0xe083e001, 0xf7ffe080, 0xa834fe5a, 0xfe27f7ff, 0xa8346460, 0xfe08f7ff,
    0x68a064a0, 0xa834901f, 0x99509a1f, 0xfdb4f7ff, 0x2001901e, 0x6820901d, 0xd12a2804, 0x9600a840,
    0x463b7b01, 0x984d4622, 0xfcf6f7ff, 0x2d004605, 0xa804d10b, 0x463b9922, 0x9602aa32, 0x90019100,
    0x984d9930, 0xfb52f7ff, 0x2d004605, 0xa804d10f, 0x991e9a1f, 0xfcb0f7ff, 0xa8046a22, 0xf7ff991e,
    0xaa24fc5b, 0x4620a904, 0xfbd1f7ff, 0xe009901d, 0x6a20e03d, 0xfc1cf7ff, 0xa934aa24, 0xf7ff4620,
    0x901dfbc6, 0x2800981d, 0x981dd00c, 0xa9341e40, 0x20015c09, 0x61a04088, 0xa934aa24, 0xf7ff981d,
    0x6420fb6d, 0x28006d20, 0xa834d020, 0x463b9921, 0x9602aa31, 0x90019100, 0x984d9930, 0xfb16f7ff,
    0x2d004605, 0xa824d112, 0x97004623, 0x90029601, 0x9a21a934, 0xf7ff984d, 0x4605fa12, 0x387a4855,
    0xd1034285, 0x64e02000, 0x25006520, 0xe001bf00, 0x3d7b4d50, 0xb0514628, 0xb5f7bdf0, 0x460db086,
    0x387c484c, 0x20009005, 0x98069004, 0xd07d2800, 0xd0fc2d00, 0x28006868, 0x9808d0f9, 0xd0f62800,
    0x28006828, 0x6828d0f3, 0x68689003, 0x20009002, 0x27009005, 0x00b9e086, 0x58449802, 0xd0662c00,
    0xbf00bf00, 0xbf00bf00, 0xbf00bf00, 0x99067822, 0xd0062a01, 0xd0082a02, 0xd00c2a04, 0xd1172a08,
    0x2301e00f, 0x18c802db, 0x2301e014, 0x18cb02db, 0x30804618, 0x2301e00e, 0x18cb02db, 0x30f91dd8,
    0x2301e008, 0x18cb02db, 0x30ff4618, 0xe0013081, 0xbf002000, 0xbf00bf00, 0x2e004606, 0x6830d04e,
    0x04092103, 0x7a214388, 0x22030409, 0x40110412, 0x60304308, 0x90012000, 0x68602104, 0x28004008,
    0x9808d010, 0x7a239000, 0x69a17822, 0xf7ff9806, 0x9001fe59, 0x28009801, 0x2008d004, 0x990440b8,
    0x90044308, 0xbf00bf00, 0x28009801, 0x2102d120, 0x40086860, 0xd01b2800, 0xbf00bf00, 0xbf00bf00,
    0x46304621, 0xf8c0f7ff, 0xe0017920, 0xe018e020, 0x0fc007c0, 0x320122ff, 0x40116861, 0x7a214308,
    0x22030409, 0x40110412, 0x03d14308, 0x60301840, 0x0000e007, 0x00b20080, 0x0000ff84, 0x900548fc,
    0x1c7fe004, 0x42879803, 0xe774d200, 0xbf00bf00, 0x28009804, 0x2159d004, 0x98040449, 0x90054308,
    0xb0099805, 0xb510bdf0, 0x20004601, 0x2200e056, 0x240101c3, 0x190c02e4, 0x01c350e2, 0x02e42401,
    0x191b190c, 0x01c3609a, 0x02e42401, 0x191b190c, 0x01c360da, 0x02e42401, 0x191b190c, 0x01c3621a,
    0x02e42401, 0x191b190c, 0x01c3641a, 0x02e42401, 0x191b190c, 0x2300645a, 0x240101c2, 0x190c02e4,
    0x64931912, 0x01c32200, 0x02e42401, 0x191b190c, 0x01c364da, 0x02e42401, 0x191b190c, 0x01c3651a,
    0x02e42401, 0x191b190c, 0x01c3661a, 0x02e42401, 0x191b190c, 0x01c3665a, 0x02e42401, 0x191b190c,
    0x01c3669a, 0x02e42401, 0x191b190c, 0x01c366da, 0x02e42401, 0x191b190c, 0x1c40671a, 0xd3a62804,
    0xb5f0bd10, 0x4607b087, 0x4616460c, 0x68c569a0, 0x307c48bf, 0x2d009006, 0x2101d00e, 0x22ff7820,
    0xc343ab02, 0x20009201, 0x792a9000, 0x46037829, 0xf7fe4638, 0x9006fc7d, 0xb0079806, 0xb5f0bdf0,
    0x4607b087, 0x4616460c, 0x690569a0, 0x307c48b0, 0x2d009006, 0x2101d00e, 0x22ff7820, 0xc343ab02,
    0x20009201, 0x792a9000, 0x46037829, 0xf7fe4638, 0x9006fc5f, 0xb0079806, 0xb5ffbdf0, 0x460cb087,
    0x461e4615, 0x48a29f10, 0x9006307c, 0x78202100, 0x910322ff, 0x9704460b, 0x91009201, 0x460a9002,
    0x98074631, 0xfc44f7fe, 0x98069006, 0xd1072800, 0x22012300, 0x97004629, 0xf7fe9807, 0x9006fd3e,
    0xb00b9806, 0xb5f7bdf0, 0x460db082, 0x20014616, 0x4f8f9001, 0x69ac377c, 0x28006aa0, 0x9600d008,
    0x78036aa0, 0x4629aa01, 0xf7ff9802, 0x4607ffc6, 0xd1042f00, 0x79094669, 0x40086ba0, 0x46689001,
    0x28007900, 0x2001d002, 0xbdf0b005, 0xe7fb2000, 0xb089b5ff, 0x4615460c, 0x9f12461e, 0x4621463a,
    0xf7ff9809, 0x9008ff6e, 0x28009808, 0x69a0d117, 0x90066bc0, 0x28029806, 0xe000d100, 0x90072001,
    0x78202101, 0xab022200, 0x9201c383, 0x462b9807, 0x90004631, 0xf7fe9809, 0x9008fbeb, 0x9808bf00,
    0xbdf0b00d, 0xb086b5f7, 0x4e694614, 0x2000367c, 0x98079005, 0x6ae86985, 0xd0752800, 0x28006b28,
    0x6aa8d072, 0xd06f2800, 0x78006ae8, 0x6b289004, 0x90037800, 0x78006aa8, 0x94009002, 0x9b04aa05,
    0x98069907, 0xff69f7ff, 0x2e004606, 0x6befd15b, 0xd0132f02, 0xd0022f40, 0xd14f2f80, 0x4669e032,
    0xb2f97d08, 0x46694308, 0x94007508, 0x9b03aa05, 0x98069907, 0xff9cf7ff, 0xe0424606, 0xaa059400,
    0x99079b02, 0xf7ff9806, 0x4606ff48, 0xd1182e00, 0xaa059400, 0x9b043201, 0x98069907, 0xff3df7ff,
    0x2e004606, 0x4669d10d, 0xb2f97d48, 0x46694308, 0x94007548, 0x9b03aa05, 0x98069907, 0xff78f7ff,
    0xe01e4606, 0xaa059400, 0x9b043201, 0x98069907, 0xff23f7ff, 0x2e004606, 0x4669d10e, 0xb2f97d48,
    0x46694308, 0x94007548, 0x3201aa05, 0x99079b03, 0xf7ff9806, 0x4606ff5d, 0xe005e003, 0x1e764e2c,
    0xbf00bf00, 0xbf00bf00, 0xb0094630, 0xb5f0bdf0, 0x4607b087, 0x4616460c, 0x307c4825, 0x69a09006,
    0x2d0069c5, 0x2101d00e, 0x22ff7820, 0xc343ab02, 0x20009201, 0x792a9000, 0x46037829, 0xf7fe4638,
    0x9006fb47, 0xb0079806, 0xb510bdf0, 0x460b4602, 0x21002000, 0xe003bf00, 0x5c540200, 0x1c494320,
    0xd3f94299, 0xb5f7bd10, 0x4811b081, 0x23009000, 0xbf00bf00, 0x69819801, 0x42906848, 0x480cd320,
    0x90001c80, 0x28006d08, 0x2000d01a, 0x0087e013, 0x59f36d0e, 0x68df681c, 0x437e685e, 0x42a21935,
    0x42aad308, 0x9e02d206, 0x26006033, 0xe0059600, 0x00b20004, 0x6cce1c40, 0xd8e84286, 0xbf00bf00,
    0xb0049800, 0xb5ffbdf0, 0x460db089, 0x4ffd4616, 0xbf00bf00, 0xd0372e00, 0x900869a8, 0x69449808,
    0x90072000, 0x68019808, 0xf7ff4630, 0x4602ffae, 0x9006a907, 0xf7ff4628, 0x4607ffb6, 0xd0202c00,
    0x28ff7920, 0x48efd01d, 0xd01a4287, 0xd1022f00, 0x68809807, 0x6820e000, 0x9006b2c0, 0x78292301,
    0x980c7922, 0x92019303, 0x90049102, 0x68009808, 0x79229000, 0x99064633, 0xf7fe9809, 0x4607fac9,
    0x4fe0e001, 0xbf00377c, 0xb00d4638, 0xb5ffbdf0, 0x460db087, 0x26009f12, 0x900569a8, 0x6a049805,
    0xd1022c00, 0x367c4ed7, 0x9809e04a, 0xd0042800, 0x6a419805, 0x42819810, 0x4ed2d201, 0x6968e040,
    0xd1012800, 0xe0007828, 0x90067d28, 0x79612200, 0xab029806, 0x9101c385, 0x68009805, 0x79229000,
    0x9b097821, 0xf7fe9807, 0x4606fa93, 0xd1112e00, 0x68a01e71, 0xd00d4288, 0x22ff2100, 0xab029806,
    0x9201c383, 0x7b229100, 0x23007a21, 0xf7fe9807, 0x4606fa7f, 0xd1072e00, 0x28006920, 0x6921d004,
    0xf7fe9807, 0x4606fbbd, 0xd1092e00, 0x97019811, 0x7d239000, 0x990a9a10, 0xf7fe9807, 0x4606fac0,
    0xb00b4630, 0xb5ffbdf0, 0x460db087, 0x4ead9f12, 0x900569a8, 0x68849805, 0xd1022c00, 0x367c4ea9,
    0x9809e045, 0xd1012800, 0xe0404ea6, 0x28006968, 0x7828d101, 0x7d28e000, 0x22009006, 0x98067961,
    0xc385ab02, 0x98059101, 0x90006800, 0x78217922, 0x98079b09, 0xfa3cf7fe, 0x2e004606, 0x1e71d111,
    0x428868a0, 0x2100d00d, 0x980622ff, 0xc383ab02, 0x91009201, 0x7a217b22, 0x98072300, 0xfa28f7fe,
    0x2e004606, 0x6920d107, 0xd9042800, 0x98076921, 0xfb66f7fe, 0x2e004606, 0x9811d109, 0x90009701,
    0x9a107d23, 0x9807990a, 0xfadff7fe, 0x46304606, 0xbdf0b00b, 0xb083b5ff, 0x461f4614, 0x90022000,
    0x900208a0, 0x28009802, 0x2001d101, 0xbf009002, 0x42849802, 0x9802d901, 0x4620e000, 0x1b644605,
    0x4879bf00, 0xd9014285, 0xe0004601, 0x91014629, 0x1a6d9901, 0xb2889901, 0xf804f7fd, 0xd1f02d00,
    0x9904463a, 0xf7ff9803, 0x4606fdae, 0xd0012e00, 0xd1dd2c00, 0xd0032e00, 0x1e80486a, 0xbdf0b007,
    0xe7fb2000, 0xb083b5ff, 0x4615460c, 0x90022000, 0xbf00bf00, 0x6ac069a0, 0x90016800, 0x8f8069a0,
    0x9806b2c7, 0x98019000, 0xaa02b2c3, 0x98034621, 0xfd63f7ff, 0x20004606, 0x2e007028, 0x4668d108,
    0x40387a00, 0xd10142b8, 0xe0002001, 0x70282000, 0xb0074630, 0xb5ffbdf0, 0x4606b081, 0x461d460f,
    0xbf00bf00, 0x4639462a, 0xf7ff4630, 0x4604fd0a, 0xd10e2c00, 0x4639462a, 0xf7ff4630, 0x4604fdb3,
    0xd1062c00, 0x4639462b, 0x9a034630, 0xff82f7ff, 0x46204604, 0xbdf0b005, 0x4607b5f8, 0x4615460c,
    0x90002000, 0x00f6267d, 0x2001e003, 0xff9af7fc, 0x46291e76, 0xf7fe4638, 0x42a0fad8, 0x2e00d001,
    0x4629d1f3, 0xf7fe4638, 0x42a0fad0, 0x4835d002, 0x90001e80, 0xbdf89800, 0xbf00b530, 0x189d1e5b,
    0x0a005548, 0xd1f92b00, 0xb5ffbd30, 0x460fb085, 0x9d0e4614, 0x9004482b, 0x20002600, 0xbf009003,
    0xbf00bf00, 0x1960bf00, 0x684969b9, 0xd82f4288, 0x2001e02b, 0x42850400, 0xe000d900, 0x46064628,
    0x220069b8, 0x6803a903, 0xf7ff4620, 0x2100ffd5, 0x9600980f, 0x90029101, 0x4639aa03, 0x98059b08,
    0xfed1f7ff, 0x98049004, 0xd1052800, 0x9a0f2103, 0xf7ff9805, 0x9004ffa1, 0x28009804, 0xe006d000,
    0x19a41bad, 0x19809808, 0x2d009008, 0xbf00d1d1, 0xb0099804, 0xb5ffbdf0, 0x460cb087, 0x4d094616,
    0x90062000, 0x90042700, 0xbf00bf00, 0xbf00bf00, 0x6a4069a0, 0x98109005, 0x69a11830, 0x42886849,
    0xe04bd850, 0x00b20004, 0x0000ffff, 0x99054630, 0xf97af000, 0x99109106, 0x18419806, 0x42819805,
    0x9810d201, 0x9906e002, 0x1a409805, 0x46214607, 0x98079a11, 0xfc55f7ff, 0x2d004605, 0x69a0d124,
    0xa9042200, 0x46306803, 0xff76f7ff, 0x98112100, 0x91019700, 0xaa049002, 0x9b0a4621, 0xf7ff9807,
    0x4605fe16, 0xd10f2d00, 0x9a112101, 0xf7ff9807, 0x4605ff43, 0xd1072d00, 0x6c8269a0, 0x9b114621,
    0xf7ff9807, 0x4605feb7, 0xd0002d00, 0x980ae009, 0x900a19c0, 0x981019f6, 0x90101bc0, 0x28009810,
    0xbf00d1b4, 0xb00b4628, 0xb5ffbdf0, 0x4615b087, 0x980a4c61, 0x2000182e, 0x90059006, 0x90039004,
    0xbf00bf00, 0x69809808, 0x98029002, 0x98026987, 0x90016c00, 0xa903462a, 0xf7ff9808, 0x4604fd64,
    0xd10a2c00, 0x68009803, 0x98039005, 0x980368c7, 0x43786840, 0x18409905, 0x980a9006, 0xd1002800,
    0x99054c4d, 0x46391a68, 0xf8fef000, 0xd16b2900, 0x42844849, 0x9806d068, 0xd20c4286, 0xa9031e72,
    0xf7ff9808, 0x4604fd40, 0xd1042c00, 0x68009803, 0x98039005, 0x990568c7, 0x46391a70, 0xf8e4f000,
    0xd1512900, 0x4284483c, 0xe04ad04e, 0xa903462a, 0xf7ff9808, 0x4604fd28, 0xd1122c00, 0x69009803,
    0x98039001, 0x980368c7, 0x90056800, 0x68409803, 0x99054378, 0x90061840, 0x42869806, 0x9606d202,
    0x9606e000, 0x9a10e029, 0x98079908, 0xfba9f7ff, 0x2c004604, 0x9802d11e, 0xa9042200, 0x46286803,
    0xfecaf7ff, 0x9b10aa04, 0x98079908, 0xfd2bf7ff, 0x2c004604, 0x217dd10e, 0x980100c9, 0x46024348,
    0x99089b10, 0xf7ff9807, 0x4604fe15, 0x980a19ed, 0x900a1bc0, 0xd0002c00, 0x9806e002, 0xd3d24285,
    0x980abf00, 0xd1b12800, 0xb00b4620, 0xb5f8bdf0, 0x460d4607, 0xbf004616, 0x4632bf00, 0x46384629,
    0xfb6ff7ff, 0x2c004604, 0x4632d113, 0x46384629, 0xfc9df7ff, 0x2c004604, 0x69a8d10b, 0x217d6c40,
    0x434800c9, 0x46334602, 0x46384629, 0xfde2f7ff, 0x46204604, 0x0000bdf8, 0x00b20004, 0x44484820,
    0x44494920, 0x48206008, 0x491d4448, 0x60484449, 0x4448481e, 0x4449491c, 0x481d6008, 0x491b4448,
    0x61884449, 0x4448481b, 0x44494919, 0x481a6088, 0x60c84448, 0x44484819, 0x48196108, 0x61484448,
    0x44484818, 0x481861c8, 0x62084448, 0x44484817, 0x481762c8, 0x62884448, 0x44484816, 0x48166308,
    0x65084448, 0x44484815, 0x44494913, 0x48146008, 0x60484448, 0x44484813, 0x48026088, 0x47704448,
    0x00000294, 0x000002a4, 0x00000290, 0x00000274, 0x00000220, 0x00000100, 0x00000118, 0x00000130,
    0x00000148, 0x00000160, 0x00000178, 0x00000190, 0x000001a8, 0x000001c0, 0x00000214, 0x000001d8,
    0x000001ec, 0x00000200, 0x09032200, 0xd32c428b, 0x428b0a03, 0x2300d311, 0xe04e469c, 0x430b4603,
    0x2200d43c, 0x428b0843, 0x0903d331, 0xd31c428b, 0x428b0a03, 0x4694d301, 0x09c3e03f, 0xd301428b,
    0x1ac001cb, 0x09834152, 0xd301428b, 0x1ac0018b, 0x09434152, 0xd301428b, 0x1ac0014b, 0x09034152,
    0xd301428b, 0x1ac0010b, 0x08c34152, 0xd301428b, 0x1ac000cb, 0x08834152, 0xd301428b, 0x1ac0008b,
    0x08434152, 0xd301428b, 0x1ac0004b, 0x1a414152, 0x4601d200, 0x46104152, 0xe05d4770, 0xd0000fca,
    0x10034249, 0x4240d300, 0x22004053, 0x0903469c, 0xd32d428b, 0x428b0a03, 0x22fcd312, 0xba120189,
    0x428b0a03, 0x0189d30c, 0x428b1192, 0x0189d308, 0x428b1192, 0x0189d304, 0x1192d03a, 0x0989e000,
    0x428b09c3, 0x01cbd301, 0x41521ac0, 0x428b0983, 0x018bd301, 0x41521ac0, 0x428b0943, 0x014bd301,
    0x41521ac0, 0x428b0903, 0x010bd301, 0x41521ac0, 0x428b08c3, 0x00cbd301, 0x41521ac0, 0x428b0883,
    0x008bd301, 0x41521ac0, 0x0843d2d9, 0xd301428b, 0x1ac0004b, 0x1a414152, 0x4601d200, 0x41524663,
    0x4610105b, 0x4240d301, 0xd5002b00, 0x47704249, 0x105b4663, 0x4240d300, 0x2000b501, 0x46c046c0,
    0xb430bd02, 0x1e644674, 0x1c647825, 0xd30442ab, 0x005b5d63, 0xbc3018e3, 0x461d4718, 0x0000e7f8,
    0x00000003, 0x00000000, 0x00000000, 0x00000068, 0x00000000, 0x00000000, 0x00000000, 0x00001212,
    0x00000000, 0x000000ff, 0x00000000, 0x00000000, 0x6eeee666, 0x00000000, 0x00000000, 0x00000000,
    0x11111111, 0x11111111, 0x0000001f, 0x00000000, 0x00000000, 0x0006eeee, 0x00000000, 0x00000000,
    0x00000000, 0x11111111, 0x00000011, 0x00000001, 0x00000000, 0x00000000, 0x0000000b, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffffff00, 0xffffffff, 0x0000ffff,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001,
    0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x00000001, 0x40420000, 0xffffffff,
    0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0xffffffff, 0x00000000, 0x00000007, 0x00000001, 0x00000000,
    0x00000001, 0x00000007, 0x00000001, 0x00000000, 0x000000ec, 0x00000200, 0x00000001, 0x00000002,
    0x00000008, 0x00000002, 0x00000006, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000,
    0x00000004, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x000000dc, 0x00000000,
    0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000060, 0x00000000, 0xffffffff, 0x00000000,
    0x00000000, 0x00000000, 0x00000012, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000,
    0x00000035, 0x00000000, 0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000005, 0x00000000,
    0xffffffff, 0x00000000, 0x00000000, 0x00000000, 0x00000001, 0x00000000, 0xffffffff, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x00000021, 0x00001000, 0x000002d5, 0x00008000,
    0x00000001, 0x000000dc, 0x00038000, 0x00000b54, 0x00040000, 0x000000ff, 0x000000dc, 0x00040000,
    0x00000b54, 0xffffffff, 0xffffffff, 0xffffffff, 0x00000004, 0x04000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00001000, 0x00000000, 0x00000000, 0x00000100, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000001, 0x00000002, 0x00000b54, 0x000afc80, 0x000007d0, 0x00000003,
    0x00000000, 0x00000001, 0x00000003, 0x00000000, 0x18000000, 0x04000000, 0x00000000, 0x00000000,
    0xffffffff, 0x00000001, 0x00000000, 0x00000001, 0x00000032, 0x00000000, 0x00000000, 0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x08000021,
    'pc_unInit': 0x0800007d,
    'pc_program_page': 0x080000ab,
    'pc_erase_sector': 0x08000097,
    'pc_eraseAll': 0x0800008b,

    'static_base' : 0x08000000 + 0x00000020 + 0x00003910,
    'begin_stack' : 0x08005000,
    'begin_data' : 0x08005000 + 0x40,
    'page_size' : 0x1000,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x08005040, 0x08006040],   # Enable double buffering
    'min_program_length' : 0x1000,

    # Flash information
    'flash_start': 0x18000000,
    'flash_size': 0x4000000,
    'sector_sizes': (
        (0x0, 0x40000),
    )
}
