package sqlvirtualmachine

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// BackupScheduleType enumerates the values for backup schedule type.
type BackupScheduleType string

const (
	// BackupScheduleTypeAutomated ...
	BackupScheduleTypeAutomated BackupScheduleType = "Automated"
	// BackupScheduleTypeManual ...
	BackupScheduleTypeManual BackupScheduleType = "Manual"
)

// PossibleBackupScheduleTypeValues returns an array of possible values for the BackupScheduleType const type.
func PossibleBackupScheduleTypeValues() []BackupScheduleType {
	return []BackupScheduleType{BackupScheduleTypeAutomated, BackupScheduleTypeManual}
}

// ClusterConfiguration enumerates the values for cluster configuration.
type ClusterConfiguration string

const (
	// ClusterConfigurationDomainful ...
	ClusterConfigurationDomainful ClusterConfiguration = "Domainful"
)

// PossibleClusterConfigurationValues returns an array of possible values for the ClusterConfiguration const type.
func PossibleClusterConfigurationValues() []ClusterConfiguration {
	return []ClusterConfiguration{ClusterConfigurationDomainful}
}

// ClusterManagerType enumerates the values for cluster manager type.
type ClusterManagerType string

const (
	// ClusterManagerTypeWSFC ...
	ClusterManagerTypeWSFC ClusterManagerType = "WSFC"
)

// PossibleClusterManagerTypeValues returns an array of possible values for the ClusterManagerType const type.
func PossibleClusterManagerTypeValues() []ClusterManagerType {
	return []ClusterManagerType{ClusterManagerTypeWSFC}
}

// Commit enumerates the values for commit.
type Commit string

const (
	// CommitASYNCHRONOUSCOMMIT ...
	CommitASYNCHRONOUSCOMMIT Commit = "ASYNCHRONOUS_COMMIT"
	// CommitSYNCHRONOUSCOMMIT ...
	CommitSYNCHRONOUSCOMMIT Commit = "SYNCHRONOUS_COMMIT"
)

// PossibleCommitValues returns an array of possible values for the Commit const type.
func PossibleCommitValues() []Commit {
	return []Commit{CommitASYNCHRONOUSCOMMIT, CommitSYNCHRONOUSCOMMIT}
}

// ConnectivityType enumerates the values for connectivity type.
type ConnectivityType string

const (
	// ConnectivityTypeLOCAL ...
	ConnectivityTypeLOCAL ConnectivityType = "LOCAL"
	// ConnectivityTypePRIVATE ...
	ConnectivityTypePRIVATE ConnectivityType = "PRIVATE"
	// ConnectivityTypePUBLIC ...
	ConnectivityTypePUBLIC ConnectivityType = "PUBLIC"
)

// PossibleConnectivityTypeValues returns an array of possible values for the ConnectivityType const type.
func PossibleConnectivityTypeValues() []ConnectivityType {
	return []ConnectivityType{ConnectivityTypeLOCAL, ConnectivityTypePRIVATE, ConnectivityTypePUBLIC}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// DayOfWeekFriday ...
	DayOfWeekFriday DayOfWeek = "Friday"
	// DayOfWeekMonday ...
	DayOfWeekMonday DayOfWeek = "Monday"
	// DayOfWeekSaturday ...
	DayOfWeekSaturday DayOfWeek = "Saturday"
	// DayOfWeekSunday ...
	DayOfWeekSunday DayOfWeek = "Sunday"
	// DayOfWeekThursday ...
	DayOfWeekThursday DayOfWeek = "Thursday"
	// DayOfWeekTuesday ...
	DayOfWeekTuesday DayOfWeek = "Tuesday"
	// DayOfWeekWednesday ...
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{DayOfWeekFriday, DayOfWeekMonday, DayOfWeekSaturday, DayOfWeekSunday, DayOfWeekThursday, DayOfWeekTuesday, DayOfWeekWednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// DiskConfigurationType enumerates the values for disk configuration type.
type DiskConfigurationType string

const (
	// DiskConfigurationTypeADD ...
	DiskConfigurationTypeADD DiskConfigurationType = "ADD"
	// DiskConfigurationTypeEXTEND ...
	DiskConfigurationTypeEXTEND DiskConfigurationType = "EXTEND"
	// DiskConfigurationTypeNEW ...
	DiskConfigurationTypeNEW DiskConfigurationType = "NEW"
)

// PossibleDiskConfigurationTypeValues returns an array of possible values for the DiskConfigurationType const type.
func PossibleDiskConfigurationTypeValues() []DiskConfigurationType {
	return []DiskConfigurationType{DiskConfigurationTypeADD, DiskConfigurationTypeEXTEND, DiskConfigurationTypeNEW}
}

// Failover enumerates the values for failover.
type Failover string

const (
	// FailoverAUTOMATIC ...
	FailoverAUTOMATIC Failover = "AUTOMATIC"
	// FailoverMANUAL ...
	FailoverMANUAL Failover = "MANUAL"
)

// PossibleFailoverValues returns an array of possible values for the Failover const type.
func PossibleFailoverValues() []Failover {
	return []Failover{FailoverAUTOMATIC, FailoverMANUAL}
}

// FullBackupFrequencyType enumerates the values for full backup frequency type.
type FullBackupFrequencyType string

const (
	// FullBackupFrequencyTypeDaily ...
	FullBackupFrequencyTypeDaily FullBackupFrequencyType = "Daily"
	// FullBackupFrequencyTypeWeekly ...
	FullBackupFrequencyTypeWeekly FullBackupFrequencyType = "Weekly"
)

// PossibleFullBackupFrequencyTypeValues returns an array of possible values for the FullBackupFrequencyType const type.
func PossibleFullBackupFrequencyTypeValues() []FullBackupFrequencyType {
	return []FullBackupFrequencyType{FullBackupFrequencyTypeDaily, FullBackupFrequencyTypeWeekly}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeNone ...
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned ...
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeNone, IdentityTypeSystemAssigned}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem ...
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser ...
	OperationOriginUser OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{OperationOriginSystem, OperationOriginUser}
}

// ReadableSecondary enumerates the values for readable secondary.
type ReadableSecondary string

const (
	// ReadableSecondaryALL ...
	ReadableSecondaryALL ReadableSecondary = "ALL"
	// ReadableSecondaryNO ...
	ReadableSecondaryNO ReadableSecondary = "NO"
	// ReadableSecondaryREADONLY ...
	ReadableSecondaryREADONLY ReadableSecondary = "READ_ONLY"
)

// PossibleReadableSecondaryValues returns an array of possible values for the ReadableSecondary const type.
func PossibleReadableSecondaryValues() []ReadableSecondary {
	return []ReadableSecondary{ReadableSecondaryALL, ReadableSecondaryNO, ReadableSecondaryREADONLY}
}

// Role enumerates the values for role.
type Role string

const (
	// RolePRIMARY ...
	RolePRIMARY Role = "PRIMARY"
	// RoleSECONDARY ...
	RoleSECONDARY Role = "SECONDARY"
)

// PossibleRoleValues returns an array of possible values for the Role const type.
func PossibleRoleValues() []Role {
	return []Role{RolePRIMARY, RoleSECONDARY}
}

// ScaleType enumerates the values for scale type.
type ScaleType string

const (
	// ScaleTypeHA ...
	ScaleTypeHA ScaleType = "HA"
)

// PossibleScaleTypeValues returns an array of possible values for the ScaleType const type.
func PossibleScaleTypeValues() []ScaleType {
	return []ScaleType{ScaleTypeHA}
}

// SQLImageSku enumerates the values for sql image sku.
type SQLImageSku string

const (
	// SQLImageSkuDeveloper ...
	SQLImageSkuDeveloper SQLImageSku = "Developer"
	// SQLImageSkuEnterprise ...
	SQLImageSkuEnterprise SQLImageSku = "Enterprise"
	// SQLImageSkuExpress ...
	SQLImageSkuExpress SQLImageSku = "Express"
	// SQLImageSkuStandard ...
	SQLImageSkuStandard SQLImageSku = "Standard"
	// SQLImageSkuWeb ...
	SQLImageSkuWeb SQLImageSku = "Web"
)

// PossibleSQLImageSkuValues returns an array of possible values for the SQLImageSku const type.
func PossibleSQLImageSkuValues() []SQLImageSku {
	return []SQLImageSku{SQLImageSkuDeveloper, SQLImageSkuEnterprise, SQLImageSkuExpress, SQLImageSkuStandard, SQLImageSkuWeb}
}

// SQLManagementMode enumerates the values for sql management mode.
type SQLManagementMode string

const (
	// SQLManagementModeFull ...
	SQLManagementModeFull SQLManagementMode = "Full"
	// SQLManagementModeLightWeight ...
	SQLManagementModeLightWeight SQLManagementMode = "LightWeight"
	// SQLManagementModeNoAgent ...
	SQLManagementModeNoAgent SQLManagementMode = "NoAgent"
)

// PossibleSQLManagementModeValues returns an array of possible values for the SQLManagementMode const type.
func PossibleSQLManagementModeValues() []SQLManagementMode {
	return []SQLManagementMode{SQLManagementModeFull, SQLManagementModeLightWeight, SQLManagementModeNoAgent}
}

// SQLServerLicenseType enumerates the values for sql server license type.
type SQLServerLicenseType string

const (
	// SQLServerLicenseTypeAHUB ...
	SQLServerLicenseTypeAHUB SQLServerLicenseType = "AHUB"
	// SQLServerLicenseTypeDR ...
	SQLServerLicenseTypeDR SQLServerLicenseType = "DR"
	// SQLServerLicenseTypePAYG ...
	SQLServerLicenseTypePAYG SQLServerLicenseType = "PAYG"
)

// PossibleSQLServerLicenseTypeValues returns an array of possible values for the SQLServerLicenseType const type.
func PossibleSQLServerLicenseTypeValues() []SQLServerLicenseType {
	return []SQLServerLicenseType{SQLServerLicenseTypeAHUB, SQLServerLicenseTypeDR, SQLServerLicenseTypePAYG}
}

// SQLVMGroupImageSku enumerates the values for sqlvm group image sku.
type SQLVMGroupImageSku string

const (
	// SQLVMGroupImageSkuDeveloper ...
	SQLVMGroupImageSkuDeveloper SQLVMGroupImageSku = "Developer"
	// SQLVMGroupImageSkuEnterprise ...
	SQLVMGroupImageSkuEnterprise SQLVMGroupImageSku = "Enterprise"
)

// PossibleSQLVMGroupImageSkuValues returns an array of possible values for the SQLVMGroupImageSku const type.
func PossibleSQLVMGroupImageSkuValues() []SQLVMGroupImageSku {
	return []SQLVMGroupImageSku{SQLVMGroupImageSkuDeveloper, SQLVMGroupImageSkuEnterprise}
}

// SQLWorkloadType enumerates the values for sql workload type.
type SQLWorkloadType string

const (
	// SQLWorkloadTypeDW ...
	SQLWorkloadTypeDW SQLWorkloadType = "DW"
	// SQLWorkloadTypeGENERAL ...
	SQLWorkloadTypeGENERAL SQLWorkloadType = "GENERAL"
	// SQLWorkloadTypeOLTP ...
	SQLWorkloadTypeOLTP SQLWorkloadType = "OLTP"
)

// PossibleSQLWorkloadTypeValues returns an array of possible values for the SQLWorkloadType const type.
func PossibleSQLWorkloadTypeValues() []SQLWorkloadType {
	return []SQLWorkloadType{SQLWorkloadTypeDW, SQLWorkloadTypeGENERAL, SQLWorkloadTypeOLTP}
}

// StorageWorkloadType enumerates the values for storage workload type.
type StorageWorkloadType string

const (
	// StorageWorkloadTypeDW ...
	StorageWorkloadTypeDW StorageWorkloadType = "DW"
	// StorageWorkloadTypeGENERAL ...
	StorageWorkloadTypeGENERAL StorageWorkloadType = "GENERAL"
	// StorageWorkloadTypeOLTP ...
	StorageWorkloadTypeOLTP StorageWorkloadType = "OLTP"
)

// PossibleStorageWorkloadTypeValues returns an array of possible values for the StorageWorkloadType const type.
func PossibleStorageWorkloadTypeValues() []StorageWorkloadType {
	return []StorageWorkloadType{StorageWorkloadTypeDW, StorageWorkloadTypeGENERAL, StorageWorkloadTypeOLTP}
}
