package dataprotection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RecoveryPointsClient is the open API 2.0 Specs for Azure Data Protection service
type RecoveryPointsClient struct {
	BaseClient
}

// NewRecoveryPointsClient creates an instance of the RecoveryPointsClient client.
func NewRecoveryPointsClient(subscriptionID string) RecoveryPointsClient {
	return NewRecoveryPointsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRecoveryPointsClientWithBaseURI creates an instance of the RecoveryPointsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewRecoveryPointsClientWithBaseURI(baseURI string, subscriptionID string) RecoveryPointsClient {
	return RecoveryPointsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// GetList returns a list of Recovery Points for a DataSource in a vault.
// Parameters:
// vaultName - the name of the backup vault.
// resourceGroupName - the name of the resource group where the backup vault is present.
// backupInstanceName - the name of the backup instance
// filter - oData filter options.
// skipToken - skipToken Filter.
func (client RecoveryPointsClient) GetList(ctx context.Context, vaultName string, resourceGroupName string, backupInstanceName string, filter string, skipToken string) (result AzureBackupRecoveryPointResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPointsClient.GetList")
		defer func() {
			sc := -1
			if result.abrprl.Response.Response != nil {
				sc = result.abrprl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getListNextResults
	req, err := client.GetListPreparer(ctx, vaultName, resourceGroupName, backupInstanceName, filter, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.RecoveryPointsClient", "GetList", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetListSender(req)
	if err != nil {
		result.abrprl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.RecoveryPointsClient", "GetList", resp, "Failure sending request")
		return
	}

	result.abrprl, err = client.GetListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.RecoveryPointsClient", "GetList", resp, "Failure responding to request")
		return
	}
	if result.abrprl.hasNextLink() && result.abrprl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetListPreparer prepares the GetList request.
func (client RecoveryPointsClient) GetListPreparer(ctx context.Context, vaultName string, resourceGroupName string, backupInstanceName string, filter string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"backupInstanceName": autorest.Encode("path", backupInstanceName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
		"vaultName":          autorest.Encode("path", vaultName),
	}

	const APIVersion = "2021-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}/backupInstances/{backupInstanceName}/recoveryPoints", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetListSender sends the GetList request. The method will close the
// http.Response Body if it receives an error.
func (client RecoveryPointsClient) GetListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetListResponder handles the response to the GetList request. The method always
// closes the http.Response Body.
func (client RecoveryPointsClient) GetListResponder(resp *http.Response) (result AzureBackupRecoveryPointResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getListNextResults retrieves the next set of results, if any.
func (client RecoveryPointsClient) getListNextResults(ctx context.Context, lastResults AzureBackupRecoveryPointResourceList) (result AzureBackupRecoveryPointResourceList, err error) {
	req, err := lastResults.azureBackupRecoveryPointResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.RecoveryPointsClient", "getListNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.RecoveryPointsClient", "getListNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.RecoveryPointsClient", "getListNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetListComplete enumerates all values, automatically crossing page boundaries as required.
func (client RecoveryPointsClient) GetListComplete(ctx context.Context, vaultName string, resourceGroupName string, backupInstanceName string, filter string, skipToken string) (result AzureBackupRecoveryPointResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RecoveryPointsClient.GetList")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetList(ctx, vaultName, resourceGroupName, backupInstanceName, filter, skipToken)
	return
}
