/* pcdl.h - Definitions for parsing a Phone Category Definition Language
 *
 * This file is part of TUA.
 *
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef _PCDL_H
#define _PCDL_H

/* The time table is described by a linked list of structures of this
   kind. */
typedef struct pcdl_slots
{
  /* The seconds in the day when this slot starts. */
  short from;

  /* The seconds in the day when this slot stops. */
  short to;

  /* The cost ID of this slot. */
  short cost;

  /* The location in the PCDL file of this object. */
  short definition_line;

  /* The next slot in the table. */
  struct pcdl_slots * next;
} pcdl_slots;

/* Each cost is described by a structure of this kind. */
typedef struct pcdl_names
{
  /* The ID for this cost */
  short cost;

  /* Its name. */
  char * name;

  /* Number of seconds per unit of time. */
  float seconds_per_unit;
  
  /* The cost of one call. */
  float call_cost;

  /* The cost per unit of time. */
  float cost_per_unit;

  /* The location in the PCDL file of this object. */
  short definition_line;

  /* The next cost. */
  struct pcdl_names * next;
} pcdl_names;

/* Each country is described by a structure of this kind. */
typedef struct pcdl_country
{
  /* The name of the country. */
  char * name;

  /* The name of the currency. */
  char * currency;
  
  /* # of dec digits. It is really funny to think at a fraction of an
     Italian Lira ;-) */
  short decimals;

  /* The linked list containing the single costs. */
  pcdl_names * names;

  /* The phone time table. */
  pcdl_slots * slots[7];	/* slots[0] = sunday, ... */
} pcdl_country;

extern pcdl_slots * EXFUN(pcdl_create_new_slot, (NOARGS));
extern pcdl_slots * EXFUN(pcdl_insert_slot, (pcdl_slots * slot, pcdl_slots * slot_list));
extern pcdl_slots * EXFUN(pcdl_merge_slots, (pcdl_slots * slot_list1, pcdl_slots * slot_list2));
     
extern pcdl_names * EXFUN(pcdl_create_new_name, (NOARGS));
extern pcdl_names * EXFUN(pcdl_insert_name, (pcdl_names * name, pcdl_names * name_list));

extern int EXFUN(pcdl_lookup_rate_symbol, (CONST char * symbol, int ins_flag));
extern void EXFUN(pcdl_destroy_symbol_list, (NOARGS));

extern void EXFUN(pcdl_print_country, (CONST pcdl_country * CONST country));
extern CONST char * EXFUN(pcd_rate_name, (int rate));
extern float EXFUN(pcd_rate_call_cost, (int rate));
extern float EXFUN(pcd_calculate_cost, (int rate, float secs));

/* The name of the country to search in the PCD file */     
extern CONST char * default_country_name;

/* Current country time rates info */
extern pcdl_country current_country;

/* The number of different time rates in the current country */
extern int pcd_names_count;

/* TRUE if we want the list of the countries in the PCD file. */
extern int pcd_list_countries;

#endif /* ifdef _PCDL_H */
