/* A recursive-descent parser generated by peg 0.1.18 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#define YYRULECOUNT 41
#line 9 "parse.peg"

#if HAVE_CONFIG_H
#	include <config.h>
#endif

#include "net.h"
#include "types.h"
#include "rinetd.h"
#include "parse.h"

#define YY_CTX_LOCAL 1
#define YY_CTX_MEMBERS \
	FILE *fp; \
	int currentLine; \
	int isAuthAllow; \
	char *tmpPort, *bindPort, *connectPort; \
	int tmpProto, bindProto, connectProto; \
	int serverTimeout; \
	char *bindAddress, *connectAddress, *sourceAddress;
#define YY_INPUT(yyctx, buf, result, max_size) \
{ \
	int yyc = fgetc(yyctx->fp); \
	result = (EOF == yyc) ? 0 : (*(buf) = yyc, 1); \
}
#define PARSE_ERROR exit(1);
#define MEMORY_ERROR { \
		logError("could not allocate memory when parsing configuration.\n"); \
		exit(1); \
	}

#if defined __clang__
#pragma clang diagnostic ignored "-Wunused-parameter"
#pragma clang diagnostic ignored "-Wunused-label"
#elif defined __GNUC__
#pragma GCC diagnostic ignored "-Wunused-parameter"
#pragma GCC diagnostic ignored "-Wunused-label"
#endif


#ifndef YY_MALLOC
#define YY_MALLOC(C, N)		malloc(N)
#endif
#ifndef YY_REALLOC
#define YY_REALLOC(C, P, N)	realloc(P, N)
#endif
#ifndef YY_FREE
#define YY_FREE(C, P)		free(P)
#endif
#ifndef YY_LOCAL
#define YY_LOCAL(T)	static T
#endif
#ifndef YY_ACTION
#define YY_ACTION(T)	static T
#endif
#ifndef YY_RULE
#define YY_RULE(T)	static T
#endif
#ifndef YY_PARSE
#define YY_PARSE(T)	T
#endif
#ifndef YYPARSE
#define YYPARSE		yyparse
#endif
#ifndef YYPARSEFROM
#define YYPARSEFROM	yyparsefrom
#endif
#ifndef YYRELEASE
#define YYRELEASE	yyrelease
#endif
#ifndef YY_BEGIN
#define YY_BEGIN	( yy->__begin= yy->__pos, 1)
#endif
#ifndef YY_END
#define YY_END		( yy->__end= yy->__pos, 1)
#endif
#ifdef YY_DEBUG
# define yyprintf(args)	fprintf args
#else
# define yyprintf(args)
#endif
#ifndef YYSTYPE
#define YYSTYPE	int
#endif
#ifndef YY_STACK_SIZE
#define YY_STACK_SIZE 128
#endif

#ifndef YY_BUFFER_SIZE
#define YY_BUFFER_SIZE 1024
#endif

#ifndef YY_PART

typedef struct _yycontext yycontext;
typedef void (*yyaction)(yycontext *yy, char *yytext, int yyleng);
typedef struct _yythunk { int begin, end;  yyaction  action;  struct _yythunk *next; } yythunk;

struct _yycontext {
  char     *__buf;
  int       __buflen;
  int       __pos;
  int       __limit;
  char     *__text;
  int       __textlen;
  int       __begin;
  int       __end;
  int       __textmax;
  yythunk  *__thunks;
  int       __thunkslen;
  int       __thunkpos;
  YYSTYPE   __;
  YYSTYPE  *__val;
  YYSTYPE  *__vals;
  int       __valslen;
#ifdef YY_CTX_MEMBERS
  YY_CTX_MEMBERS
#endif
};

#ifdef YY_CTX_LOCAL
#define YY_CTX_PARAM_	yycontext *yyctx,
#define YY_CTX_PARAM	yycontext *yyctx
#define YY_CTX_ARG_	yyctx,
#define YY_CTX_ARG	yyctx
#ifndef YY_INPUT
#define YY_INPUT(yy, buf, result, max_size)		\
  {							\
    int yyc= getchar();					\
    result= (EOF == yyc) ? 0 : (*(buf)= yyc, 1);	\
    yyprintf((stderr, "<%c>", yyc));			\
  }
#endif
#else
#define YY_CTX_PARAM_
#define YY_CTX_PARAM
#define YY_CTX_ARG_
#define YY_CTX_ARG
yycontext _yyctx= { 0, 0 };
yycontext *yyctx= &_yyctx;
#ifndef YY_INPUT
#define YY_INPUT(buf, result, max_size)			\
  {							\
    int yyc= getchar();					\
    result= (EOF == yyc) ? 0 : (*(buf)= yyc, 1);	\
    yyprintf((stderr, "<%c>", yyc));			\
  }
#endif
#endif

YY_LOCAL(int) yyrefill(yycontext *yy)
{
  int yyn;
  while (yy->__buflen - yy->__pos < 512)
    {
      yy->__buflen *= 2;
      yy->__buf= (char *)YY_REALLOC(yy, yy->__buf, yy->__buflen);
    }
#ifdef YY_CTX_LOCAL
  YY_INPUT(yy, (yy->__buf + yy->__pos), yyn, (yy->__buflen - yy->__pos));
#else
  YY_INPUT((yy->__buf + yy->__pos), yyn, (yy->__buflen - yy->__pos));
#endif
  if (!yyn) return 0;
  yy->__limit += yyn;
  return 1;
}

YY_LOCAL(int) yymatchDot(yycontext *yy)
{
  if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
  ++yy->__pos;
  return 1;
}

YY_LOCAL(int) yymatchChar(yycontext *yy, int c)
{
  if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
  if ((unsigned char)yy->__buf[yy->__pos] == c)
    {
      ++yy->__pos;
      yyprintf((stderr, "  ok   yymatchChar(yy, %c) @ %s\n", c, yy->__buf+yy->__pos));
      return 1;
    }
  yyprintf((stderr, "  fail yymatchChar(yy, %c) @ %s\n", c, yy->__buf+yy->__pos));
  return 0;
}

YY_LOCAL(int) yymatchString(yycontext *yy, const char *s)
{
  int yysav= yy->__pos;
  while (*s)
    {
      if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
      if (yy->__buf[yy->__pos] != *s)
        {
          yy->__pos= yysav;
          return 0;
        }
      ++s;
      ++yy->__pos;
    }
  return 1;
}

YY_LOCAL(int) yymatchClass(yycontext *yy, unsigned char *bits)
{
  int c;
  if (yy->__pos >= yy->__limit && !yyrefill(yy)) return 0;
  c= (unsigned char)yy->__buf[yy->__pos];
  if (bits[c >> 3] & (1 << (c & 7)))
    {
      ++yy->__pos;
      yyprintf((stderr, "  ok   yymatchClass @ %s\n", yy->__buf+yy->__pos));
      return 1;
    }
  yyprintf((stderr, "  fail yymatchClass @ %s\n", yy->__buf+yy->__pos));
  return 0;
}

YY_LOCAL(void) yyDo(yycontext *yy, yyaction action, int begin, int end)
{
  while (yy->__thunkpos >= yy->__thunkslen)
    {
      yy->__thunkslen *= 2;
      yy->__thunks= (yythunk *)YY_REALLOC(yy, yy->__thunks, sizeof(yythunk) * yy->__thunkslen);
    }
  yy->__thunks[yy->__thunkpos].begin=  begin;
  yy->__thunks[yy->__thunkpos].end=    end;
  yy->__thunks[yy->__thunkpos].action= action;
  ++yy->__thunkpos;
}

YY_LOCAL(int) yyText(yycontext *yy, int begin, int end)
{
  int yyleng= end - begin;
  if (yyleng <= 0)
    yyleng= 0;
  else
    {
      while (yy->__textlen < (yyleng + 1))
	{
	  yy->__textlen *= 2;
	  yy->__text= (char *)YY_REALLOC(yy, yy->__text, yy->__textlen);
	}
      memcpy(yy->__text, yy->__buf + begin, yyleng);
    }
  yy->__text[yyleng]= '\0';
  return yyleng;
}

YY_LOCAL(void) yyDone(yycontext *yy)
{
  int pos;
  for (pos= 0;  pos < yy->__thunkpos;  ++pos)
    {
      yythunk *thunk= &yy->__thunks[pos];
      int yyleng= thunk->end ? yyText(yy, thunk->begin, thunk->end) : thunk->begin;
      yyprintf((stderr, "DO [%d] %p %s\n", pos, thunk->action, yy->__text));
      thunk->action(yy, yy->__text, yyleng);
    }
  yy->__thunkpos= 0;
}

YY_LOCAL(void) yyCommit(yycontext *yy)
{
  if ((yy->__limit -= yy->__pos))
    {
      memmove(yy->__buf, yy->__buf + yy->__pos, yy->__limit);
    }
  yy->__begin -= yy->__pos;
  yy->__end -= yy->__pos;
  yy->__pos= yy->__thunkpos= 0;
}

YY_LOCAL(int) yyAccept(yycontext *yy, int tp0)
{
  if (tp0)
    {
      fprintf(stderr, "accept denied at %d\n", tp0);
      return 0;
    }
  else
    {
      yyDone(yy);
      yyCommit(yy);
    }
  return 1;
}

YY_LOCAL(void) yyPush(yycontext *yy, char *text, int count)
{
  yy->__val += count;
  while (yy->__valslen <= yy->__val - yy->__vals)
    {
      long offset= yy->__val - yy->__vals;
      yy->__valslen *= 2;
      yy->__vals= (YYSTYPE *)YY_REALLOC(yy, yy->__vals, sizeof(YYSTYPE) * yy->__valslen);
      yy->__val= yy->__vals + offset;
    }
}
YY_LOCAL(void) yyPop(yycontext *yy, char *text, int count)   { yy->__val -= count; }
YY_LOCAL(void) yySet(yycontext *yy, char *text, int count)   { yy->__val[count]= yy->__; }

#endif /* YY_PART */

#define	YYACCEPT	yyAccept(yy, yythunkpos0)

YY_RULE(int) yy_eof(yycontext *yy); /* 41 */
YY_RULE(int) yy_id(yycontext *yy); /* 40 */
YY_RULE(int) yy_label(yycontext *yy); /* 39 */
YY_RULE(int) yy_bare_ipv6(yycontext *yy); /* 38 */
YY_RULE(int) yy_digit(yycontext *yy); /* 37 */
YY_RULE(int) yy_hexdigit(yycontext *yy); /* 36 */
YY_RULE(int) yy_hostname(yycontext *yy); /* 35 */
YY_RULE(int) yy_ipv6(yycontext *yy); /* 34 */
YY_RULE(int) yy_ipv4(yycontext *yy); /* 33 */
YY_RULE(int) yy_name(yycontext *yy); /* 32 */
YY_RULE(int) yy_filename(yycontext *yy); /* 31 */
YY_RULE(int) yy_pattern(yycontext *yy); /* 30 */
YY_RULE(int) yy_auth_key(yycontext *yy); /* 29 */
YY_RULE(int) yy_service(yycontext *yy); /* 28 */
YY_RULE(int) yy_proto(yycontext *yy); /* 27 */
YY_RULE(int) yy_port(yycontext *yy); /* 26 */
YY_RULE(int) yy_number(yycontext *yy); /* 25 */
YY_RULE(int) yy_option_source(yycontext *yy); /* 24 */
YY_RULE(int) yy_option_timeout(yycontext *yy); /* 23 */
YY_RULE(int) yy_option(yycontext *yy); /* 22 */
YY_RULE(int) yy_option_list(yycontext *yy); /* 21 */
YY_RULE(int) yy_full_port(yycontext *yy); /* 20 */
YY_RULE(int) yy_address(yycontext *yy); /* 19 */
YY_RULE(int) yy_server_options(yycontext *yy); /* 18 */
YY_RULE(int) yy_connect_port(yycontext *yy); /* 17 */
YY_RULE(int) yy_connect_address(yycontext *yy); /* 16 */
YY_RULE(int) yy_bind_port(yycontext *yy); /* 15 */
YY_RULE(int) yy_bind_address(yycontext *yy); /* 14 */
YY_RULE(int) yy_logcommon(yycontext *yy); /* 13 */
YY_RULE(int) yy_pidlogfile(yycontext *yy); /* 12 */
YY_RULE(int) yy_logfile(yycontext *yy); /* 11 */
YY_RULE(int) yy_auth_rule(yycontext *yy); /* 10 */
YY_RULE(int) yy_server_rule(yycontext *yy); /* 9 */
YY_RULE(int) yy_comment(yycontext *yy); /* 8 */
YY_RULE(int) yy_command(yycontext *yy); /* 7 */
YY_RULE(int) yy__(yycontext *yy); /* 6 */
YY_RULE(int) yy_invalid_syntax(yycontext *yy); /* 5 */
YY_RULE(int) yy_eol(yycontext *yy); /* 4 */
YY_RULE(int) yy_line(yycontext *yy); /* 3 */
YY_RULE(int) yy_sol(yycontext *yy); /* 2 */
YY_RULE(int) yy_file(yycontext *yy); /* 1 */

YY_ACTION(void) yy_1_sol(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_sol\n"));
  {
#line 161
   ++yy->currentLine; ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_invalid_syntax(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_invalid_syntax\n"));
  {
#line 135
  
	logError("invalid syntax at line %d: %s\n",
	        yy->currentLine, yytext);
	PARSE_ERROR; /* FIXME */
;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_logcommon(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_logcommon\n"));
  {
#line 130
  
	logFormatCommon = 1;
;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_pidlogfile(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_pidlogfile\n"));
  {
#line 122
  
	pidLogFileName = strdup(yytext);
	if (!pidLogFileName) {
		MEMORY_ERROR;
	}
;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_logfile(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_logfile\n"));
  {
#line 114
  
	logFileName = strdup(yytext);
	if (!logFileName) {
		MEMORY_ERROR;
	}
;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_auth_key(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_auth_key\n"));
  {
#line 111
   yy->isAuthAllow = (yytext[0] == 'a'); ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_auth_rule(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_auth_rule\n"));
  {
#line 89
  
	allRules = (Rule *)
		realloc(allRules, sizeof(Rule) * (allRulesCount + 1));
	if (!allRules) {
		MEMORY_ERROR;
	}
	allRules[allRulesCount].pattern = strdup(yytext);
	if (!allRules[allRulesCount].pattern) {
		MEMORY_ERROR;
	}
	allRules[allRulesCount].type = yy->isAuthAllow ? allowRule : denyRule;
	if (seTotal > 0) {
		if (seInfo[seTotal - 1].rulesStart == 0) {
			seInfo[seTotal - 1].rulesStart = allRulesCount;
		}
		++seInfo[seTotal - 1].rulesCount;
	} else {
		++globalRulesCount;
	}
	++allRulesCount;
;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_3_proto(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_3_proto\n"));
  {
#line 86
   yy->tmpProto = IPPROTO_TCP; ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_2_proto(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_2_proto\n"));
  {
#line 85
   yy->tmpProto = IPPROTO_UDP; ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_proto(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_proto\n"));
  {
#line 84
   yy->tmpProto = IPPROTO_TCP; ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_port(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_port\n"));
  {
#line 83
   yy->tmpPort = strdup(yytext); ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_option_source(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_option_source\n"));
  {
#line 79
   yy->sourceAddress = strdup(yytext); ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_option_timeout(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_option_timeout\n"));
  {
#line 78
   yy->serverTimeout = atoi(yytext); ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_connect_port(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_connect_port\n"));
  {
#line 73
   yy->connectPort = yy->tmpPort; yy->connectProto = yy->tmpProto; ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_bind_port(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_bind_port\n"));
  {
#line 72
   yy->bindPort = yy->tmpPort; yy->bindProto = yy->tmpProto; ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_connect_address(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_connect_address\n"));
  {
#line 71
   yy->connectAddress = strdup(yytext); ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_bind_address(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_bind_address\n"));
  {
#line 70
   yy->bindAddress = strdup(yytext); ;
  }
#undef yythunkpos
#undef yypos
#undef yy
}
YY_ACTION(void) yy_1_server_rule(yycontext *yy, char *yytext, int yyleng)
{
#define __ yy->__
#define yypos yy->__pos
#define yythunkpos yy->__thunkpos
  yyprintf((stderr, "do yy_1_server_rule\n"));
  {
#line 55
  
	addServer(yy->bindAddress, yy->bindPort, yy->bindProto,
		yy->connectAddress, yy->connectPort, yy->connectProto,
		yy->serverTimeout > 0 ? yy->serverTimeout : RINETD_DEFAULT_UDP_TIMEOUT,
		yy->sourceAddress);
	free(yy->bindAddress);
	free(yy->connectAddress);
	free(yy->sourceAddress);
	yy->bindAddress = yy->connectAddress = yy->sourceAddress = NULL;
	free(yy->bindPort);
	free(yy->connectPort);
	yy->bindPort = yy->connectPort = NULL;
	yy->serverTimeout = 0;
;
  }
#undef yythunkpos
#undef yypos
#undef yy
}

YY_RULE(int) yy_eof(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "eof"));  if (!yymatchChar(yy, '\0')) goto l1;
  yyprintf((stderr, "  ok   %s @ %s\n", "eof", yy->__buf+yy->__pos));
  return 1;
  l1:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "eof", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_id(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "id"));  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\000\000\376\377\377\207\376\377\377\007\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l2;
  yyprintf((stderr, "  ok   %s @ %s\n", "id", yy->__buf+yy->__pos));
  return 1;
  l2:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "id", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_label(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "label"));
  {  int yypos4= yy->__pos, yythunkpos4= yy->__thunkpos;  if (!yy_id(yy)) goto l5;  goto l4;
  l5:;	  yy->__pos= yypos4; yy->__thunkpos= yythunkpos4;  if (!yy_digit(yy)) goto l3;
  }
  l4:;	
  l6:;	
  {  int yypos7= yy->__pos, yythunkpos7= yy->__thunkpos;
  {  int yypos8= yy->__pos, yythunkpos8= yy->__thunkpos;  if (!yymatchChar(yy, '-')) goto l9;  goto l8;
  l9:;	  yy->__pos= yypos8; yy->__thunkpos= yythunkpos8;  if (!yy_id(yy)) goto l10;  goto l8;
  l10:;	  yy->__pos= yypos8; yy->__thunkpos= yythunkpos8;  if (!yy_digit(yy)) goto l7;
  }
  l8:;	  goto l6;
  l7:;	  yy->__pos= yypos7; yy->__thunkpos= yythunkpos7;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "label", yy->__buf+yy->__pos));
  return 1;
  l3:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "label", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_bare_ipv6(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "bare_ipv6"));
  l12:;	
  {  int yypos13= yy->__pos, yythunkpos13= yy->__thunkpos;  if (!yy_hexdigit(yy)) goto l13;  goto l12;
  l13:;	  yy->__pos= yypos13; yy->__thunkpos= yythunkpos13;
  }  if (!yymatchChar(yy, ':')) goto l11;
  l14:;	
  {  int yypos15= yy->__pos, yythunkpos15= yy->__thunkpos;
  {  int yypos16= yy->__pos, yythunkpos16= yy->__thunkpos;  if (!yy_hexdigit(yy)) goto l17;  goto l16;
  l17:;	  yy->__pos= yypos16; yy->__thunkpos= yythunkpos16;  if (!yymatchChar(yy, ':')) goto l15;
  }
  l16:;	  goto l14;
  l15:;	  yy->__pos= yypos15; yy->__thunkpos= yythunkpos15;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "bare_ipv6", yy->__buf+yy->__pos));
  return 1;
  l11:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "bare_ipv6", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_digit(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "digit"));  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l18;
  yyprintf((stderr, "  ok   %s @ %s\n", "digit", yy->__buf+yy->__pos));
  return 1;
  l18:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "digit", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_hexdigit(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "hexdigit"));  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\000\377\003\176\000\000\000\176\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l19;
  yyprintf((stderr, "  ok   %s @ %s\n", "hexdigit", yy->__buf+yy->__pos));
  return 1;
  l19:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "hexdigit", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_hostname(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "hostname"));
  l21:;	
  {  int yypos22= yy->__pos, yythunkpos22= yy->__thunkpos;  if (!yy_label(yy)) goto l22;  if (!yymatchChar(yy, '.')) goto l22;  goto l21;
  l22:;	  yy->__pos= yypos22; yy->__thunkpos= yythunkpos22;
  }  if (!yy_name(yy)) goto l20;
  {  int yypos23= yy->__pos, yythunkpos23= yy->__thunkpos;  if (!yymatchChar(yy, '.')) goto l23;  goto l24;
  l23:;	  yy->__pos= yypos23; yy->__thunkpos= yythunkpos23;
  }
  l24:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "hostname", yy->__buf+yy->__pos));
  return 1;
  l20:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "hostname", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_ipv6(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "ipv6"));
  {  int yypos26= yy->__pos, yythunkpos26= yy->__thunkpos;  if (!yymatchChar(yy, '[')) goto l27;  if (!yy_bare_ipv6(yy)) goto l27;  if (!yymatchChar(yy, ']')) goto l27;  goto l26;
  l27:;	  yy->__pos= yypos26; yy->__thunkpos= yythunkpos26;  if (!yy_bare_ipv6(yy)) goto l25;
  }
  l26:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "ipv6", yy->__buf+yy->__pos));
  return 1;
  l25:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ipv6", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_ipv4(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "ipv4"));
  {  int yypos29= yy->__pos, yythunkpos29= yy->__thunkpos;  if (!yy_number(yy)) goto l30;  if (!yymatchChar(yy, '.')) goto l30;  if (!yy_number(yy)) goto l30;  if (!yymatchChar(yy, '.')) goto l30;  if (!yy_number(yy)) goto l30;  if (!yymatchChar(yy, '.')) goto l30;  if (!yy_number(yy)) goto l30;  goto l29;
  l30:;	  yy->__pos= yypos29; yy->__thunkpos= yythunkpos29;  if (!yymatchChar(yy, '0')) goto l28;
  }
  l29:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "ipv4", yy->__buf+yy->__pos));
  return 1;
  l28:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "ipv4", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_name(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "name"));  if (!yy_id(yy)) goto l31;
  l32:;	
  {  int yypos33= yy->__pos, yythunkpos33= yy->__thunkpos;
  {  int yypos34= yy->__pos, yythunkpos34= yy->__thunkpos;  if (!yymatchChar(yy, '-')) goto l35;  goto l34;
  l35:;	  yy->__pos= yypos34; yy->__thunkpos= yythunkpos34;  if (!yy_id(yy)) goto l36;  goto l34;
  l36:;	  yy->__pos= yypos34; yy->__thunkpos= yythunkpos34;  if (!yy_digit(yy)) goto l33;
  }
  l34:;	  goto l32;
  l33:;	  yy->__pos= yypos33; yy->__thunkpos= yythunkpos33;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "name", yy->__buf+yy->__pos));
  return 1;
  l31:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "name", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_filename(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "filename"));
  {  int yypos38= yy->__pos, yythunkpos38= yy->__thunkpos;  if (!yymatchChar(yy, '"')) goto l39;  if (!yymatchClass(yy, (unsigned char *)"\377\377\377\377\373\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377")) goto l39;
  l40:;	
  {  int yypos41= yy->__pos, yythunkpos41= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\377\377\377\377\373\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377")) goto l41;  goto l40;
  l41:;	  yy->__pos= yypos41; yy->__thunkpos= yythunkpos41;
  }  if (!yymatchChar(yy, '"')) goto l39;  goto l38;
  l39:;	  yy->__pos= yypos38; yy->__thunkpos= yythunkpos38;  if (!yymatchClass(yy, (unsigned char *)"\377\331\377\377\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377")) goto l37;
  l42:;	
  {  int yypos43= yy->__pos, yythunkpos43= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\377\331\377\377\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377")) goto l43;  goto l42;
  l43:;	  yy->__pos= yypos43; yy->__thunkpos= yythunkpos43;
  }
  }
  l38:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "filename", yy->__buf+yy->__pos));
  return 1;
  l37:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "filename", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_pattern(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "pattern"));
  {  int yypos47= yy->__pos, yythunkpos47= yy->__thunkpos;  if (!yy_hexdigit(yy)) goto l48;  goto l47;
  l48:;	  yy->__pos= yypos47; yy->__thunkpos= yythunkpos47;  if (!yymatchChar(yy, '[')) goto l49;  goto l47;
  l49:;	  yy->__pos= yypos47; yy->__thunkpos= yythunkpos47;  if (!yymatchChar(yy, ']')) goto l50;  goto l47;
  l50:;	  yy->__pos= yypos47; yy->__thunkpos= yythunkpos47;  if (!yymatchChar(yy, ':')) goto l51;  goto l47;
  l51:;	  yy->__pos= yypos47; yy->__thunkpos= yythunkpos47;  if (!yymatchChar(yy, '.')) goto l52;  goto l47;
  l52:;	  yy->__pos= yypos47; yy->__thunkpos= yythunkpos47;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\004\000\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l44;
  }
  l47:;	
  l45:;	
  {  int yypos46= yy->__pos, yythunkpos46= yy->__thunkpos;
  {  int yypos53= yy->__pos, yythunkpos53= yy->__thunkpos;  if (!yy_hexdigit(yy)) goto l54;  goto l53;
  l54:;	  yy->__pos= yypos53; yy->__thunkpos= yythunkpos53;  if (!yymatchChar(yy, '[')) goto l55;  goto l53;
  l55:;	  yy->__pos= yypos53; yy->__thunkpos= yythunkpos53;  if (!yymatchChar(yy, ']')) goto l56;  goto l53;
  l56:;	  yy->__pos= yypos53; yy->__thunkpos= yythunkpos53;  if (!yymatchChar(yy, ':')) goto l57;  goto l53;
  l57:;	  yy->__pos= yypos53; yy->__thunkpos= yythunkpos53;  if (!yymatchChar(yy, '.')) goto l58;  goto l53;
  l58:;	  yy->__pos= yypos53; yy->__thunkpos= yythunkpos53;  if (!yymatchClass(yy, (unsigned char *)"\000\000\000\000\000\004\000\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l46;
  }
  l53:;	  goto l45;
  l46:;	  yy->__pos= yypos46; yy->__thunkpos= yythunkpos46;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "pattern", yy->__buf+yy->__pos));
  return 1;
  l44:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "pattern", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_auth_key(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "auth_key"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l59;
#undef yytext
#undef yyleng
  }
  {  int yypos60= yy->__pos, yythunkpos60= yy->__thunkpos;  if (!yymatchString(yy, "allow")) goto l61;  goto l60;
  l61:;	  yy->__pos= yypos60; yy->__thunkpos= yythunkpos60;  if (!yymatchString(yy, "deny")) goto l59;
  }
  l60:;	  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l59;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_auth_key, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "auth_key", yy->__buf+yy->__pos));
  return 1;
  l59:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "auth_key", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_service(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "service"));  if (!yy_name(yy)) goto l62;
  yyprintf((stderr, "  ok   %s @ %s\n", "service", yy->__buf+yy->__pos));
  return 1;
  l62:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "service", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_proto(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "proto"));
  {  int yypos64= yy->__pos, yythunkpos64= yy->__thunkpos;  if (!yymatchString(yy, "/tcp")) goto l65;  yyDo(yy, yy_1_proto, yy->__begin, yy->__end);  goto l64;
  l65:;	  yy->__pos= yypos64; yy->__thunkpos= yythunkpos64;  if (!yymatchString(yy, "/udp")) goto l66;  yyDo(yy, yy_2_proto, yy->__begin, yy->__end);  goto l64;
  l66:;	  yy->__pos= yypos64; yy->__thunkpos= yythunkpos64;  if (!yymatchString(yy, "")) goto l63;  yyDo(yy, yy_3_proto, yy->__begin, yy->__end);
  }
  l64:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "proto", yy->__buf+yy->__pos));
  return 1;
  l63:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "proto", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_port(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "port"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l67;
#undef yytext
#undef yyleng
  }
  {  int yypos68= yy->__pos, yythunkpos68= yy->__thunkpos;  if (!yy_number(yy)) goto l69;  goto l68;
  l69:;	  yy->__pos= yypos68; yy->__thunkpos= yythunkpos68;  if (!yy_service(yy)) goto l67;
  }
  l68:;	  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l67;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_port, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "port", yy->__buf+yy->__pos));
  return 1;
  l67:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "port", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_number(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "number"));  if (!yy_digit(yy)) goto l70;
  l71:;	
  {  int yypos72= yy->__pos, yythunkpos72= yy->__thunkpos;  if (!yy_digit(yy)) goto l72;  goto l71;
  l72:;	  yy->__pos= yypos72; yy->__thunkpos= yythunkpos72;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "number", yy->__buf+yy->__pos));
  return 1;
  l70:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "number", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_option_source(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "option_source"));  if (!yymatchString(yy, "src")) goto l73;
  {  int yypos74= yy->__pos, yythunkpos74= yy->__thunkpos;  if (!yy__(yy)) goto l74;  goto l75;
  l74:;	  yy->__pos= yypos74; yy->__thunkpos= yythunkpos74;
  }
  l75:;	  if (!yymatchChar(yy, '=')) goto l73;
  {  int yypos76= yy->__pos, yythunkpos76= yy->__thunkpos;  if (!yy__(yy)) goto l76;  goto l77;
  l76:;	  yy->__pos= yypos76; yy->__thunkpos= yythunkpos76;
  }
  l77:;	  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l73;
#undef yytext
#undef yyleng
  }  if (!yy_address(yy)) goto l73;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l73;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_option_source, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "option_source", yy->__buf+yy->__pos));
  return 1;
  l73:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "option_source", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_option_timeout(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "option_timeout"));  if (!yymatchString(yy, "timeout")) goto l78;
  {  int yypos79= yy->__pos, yythunkpos79= yy->__thunkpos;  if (!yy__(yy)) goto l79;  goto l80;
  l79:;	  yy->__pos= yypos79; yy->__thunkpos= yythunkpos79;
  }
  l80:;	  if (!yymatchChar(yy, '=')) goto l78;
  {  int yypos81= yy->__pos, yythunkpos81= yy->__thunkpos;  if (!yy__(yy)) goto l81;  goto l82;
  l81:;	  yy->__pos= yypos81; yy->__thunkpos= yythunkpos81;
  }
  l82:;	  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l78;
#undef yytext
#undef yyleng
  }  if (!yy_number(yy)) goto l78;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l78;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_option_timeout, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "option_timeout", yy->__buf+yy->__pos));
  return 1;
  l78:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "option_timeout", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_option(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "option"));
  {  int yypos84= yy->__pos, yythunkpos84= yy->__thunkpos;  if (!yy_option_timeout(yy)) goto l85;  goto l84;
  l85:;	  yy->__pos= yypos84; yy->__thunkpos= yythunkpos84;  if (!yy_option_source(yy)) goto l83;
  }
  l84:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "option", yy->__buf+yy->__pos));
  return 1;
  l83:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "option", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_option_list(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "option_list"));  if (!yy_option(yy)) goto l86;
  {  int yypos87= yy->__pos, yythunkpos87= yy->__thunkpos;
  {  int yypos89= yy->__pos, yythunkpos89= yy->__thunkpos;  if (!yy__(yy)) goto l89;  goto l90;
  l89:;	  yy->__pos= yypos89; yy->__thunkpos= yythunkpos89;
  }
  l90:;	  if (!yymatchChar(yy, ',')) goto l87;
  {  int yypos91= yy->__pos, yythunkpos91= yy->__thunkpos;  if (!yy__(yy)) goto l91;  goto l92;
  l91:;	  yy->__pos= yypos91; yy->__thunkpos= yythunkpos91;
  }
  l92:;	  if (!yy_option_list(yy)) goto l87;  goto l88;
  l87:;	  yy->__pos= yypos87; yy->__thunkpos= yythunkpos87;
  }
  l88:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "option_list", yy->__buf+yy->__pos));
  return 1;
  l86:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "option_list", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_full_port(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "full_port"));  if (!yy_port(yy)) goto l93;  if (!yy_proto(yy)) goto l93;
  yyprintf((stderr, "  ok   %s @ %s\n", "full_port", yy->__buf+yy->__pos));
  return 1;
  l93:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "full_port", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_address(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "address"));
  {  int yypos95= yy->__pos, yythunkpos95= yy->__thunkpos;  if (!yy_ipv4(yy)) goto l96;  goto l95;
  l96:;	  yy->__pos= yypos95; yy->__thunkpos= yythunkpos95;  if (!yy_ipv6(yy)) goto l97;  goto l95;
  l97:;	  yy->__pos= yypos95; yy->__thunkpos= yythunkpos95;  if (!yy_hostname(yy)) goto l94;
  }
  l95:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "address", yy->__buf+yy->__pos));
  return 1;
  l94:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "address", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_server_options(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "server_options"));  if (!yymatchChar(yy, '[')) goto l98;
  {  int yypos99= yy->__pos, yythunkpos99= yy->__thunkpos;  if (!yy__(yy)) goto l99;  goto l100;
  l99:;	  yy->__pos= yypos99; yy->__thunkpos= yythunkpos99;
  }
  l100:;	  if (!yy_option_list(yy)) goto l98;
  {  int yypos101= yy->__pos, yythunkpos101= yy->__thunkpos;  if (!yy__(yy)) goto l101;  goto l102;
  l101:;	  yy->__pos= yypos101; yy->__thunkpos= yythunkpos101;
  }
  l102:;	  if (!yymatchChar(yy, ']')) goto l98;
  yyprintf((stderr, "  ok   %s @ %s\n", "server_options", yy->__buf+yy->__pos));
  return 1;
  l98:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "server_options", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_connect_port(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "connect_port"));  if (!yy_full_port(yy)) goto l103;  yyDo(yy, yy_1_connect_port, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "connect_port", yy->__buf+yy->__pos));
  return 1;
  l103:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "connect_port", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_connect_address(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "connect_address"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l104;
#undef yytext
#undef yyleng
  }  if (!yy_address(yy)) goto l104;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l104;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_connect_address, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "connect_address", yy->__buf+yy->__pos));
  return 1;
  l104:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "connect_address", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_bind_port(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "bind_port"));  if (!yy_full_port(yy)) goto l105;  yyDo(yy, yy_1_bind_port, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "bind_port", yy->__buf+yy->__pos));
  return 1;
  l105:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "bind_port", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_bind_address(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "bind_address"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l106;
#undef yytext
#undef yyleng
  }  if (!yy_address(yy)) goto l106;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l106;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_bind_address, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "bind_address", yy->__buf+yy->__pos));
  return 1;
  l106:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "bind_address", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_logcommon(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "logcommon"));  if (!yymatchString(yy, "logcommon")) goto l107;  yyDo(yy, yy_1_logcommon, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "logcommon", yy->__buf+yy->__pos));
  return 1;
  l107:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "logcommon", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_pidlogfile(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "pidlogfile"));  if (!yymatchString(yy, "pidlogfile")) goto l108;  if (!yy__(yy)) goto l108;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l108;
#undef yytext
#undef yyleng
  }  if (!yy_filename(yy)) goto l108;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l108;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_pidlogfile, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "pidlogfile", yy->__buf+yy->__pos));
  return 1;
  l108:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "pidlogfile", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_logfile(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "logfile"));  if (!yymatchString(yy, "logfile")) goto l109;  if (!yy__(yy)) goto l109;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l109;
#undef yytext
#undef yyleng
  }  if (!yy_filename(yy)) goto l109;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l109;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_logfile, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "logfile", yy->__buf+yy->__pos));
  return 1;
  l109:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "logfile", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_auth_rule(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "auth_rule"));  if (!yy_auth_key(yy)) goto l110;  if (!yy__(yy)) goto l110;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l110;
#undef yytext
#undef yyleng
  }  if (!yy_pattern(yy)) goto l110;  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l110;
#undef yytext
#undef yyleng
  }  yyDo(yy, yy_1_auth_rule, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "auth_rule", yy->__buf+yy->__pos));
  return 1;
  l110:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "auth_rule", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_server_rule(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "server_rule"));  if (!yy_bind_address(yy)) goto l111;  if (!yy__(yy)) goto l111;  if (!yy_bind_port(yy)) goto l111;  if (!yy__(yy)) goto l111;  if (!yy_connect_address(yy)) goto l111;  if (!yy__(yy)) goto l111;  if (!yy_connect_port(yy)) goto l111;
  {  int yypos112= yy->__pos, yythunkpos112= yy->__thunkpos;
  {  int yypos114= yy->__pos, yythunkpos114= yy->__thunkpos;  if (!yy__(yy)) goto l114;  goto l115;
  l114:;	  yy->__pos= yypos114; yy->__thunkpos= yythunkpos114;
  }
  l115:;	  if (!yy_server_options(yy)) goto l112;  goto l113;
  l112:;	  yy->__pos= yypos112; yy->__thunkpos= yythunkpos112;
  }
  l113:;	  yyDo(yy, yy_1_server_rule, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "server_rule", yy->__buf+yy->__pos));
  return 1;
  l111:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "server_rule", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_comment(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "comment"));  if (!yymatchChar(yy, '#')) goto l116;
  l117:;	
  {  int yypos118= yy->__pos, yythunkpos118= yy->__thunkpos;
  {  int yypos119= yy->__pos, yythunkpos119= yy->__thunkpos;  if (!yy_eol(yy)) goto l119;  goto l118;
  l119:;	  yy->__pos= yypos119; yy->__thunkpos= yythunkpos119;
  }  if (!yymatchDot(yy)) goto l118;  goto l117;
  l118:;	  yy->__pos= yypos118; yy->__thunkpos= yythunkpos118;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "comment", yy->__buf+yy->__pos));
  return 1;
  l116:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "comment", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_command(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "command"));
  {  int yypos121= yy->__pos, yythunkpos121= yy->__thunkpos;  if (!yy_server_rule(yy)) goto l122;  goto l121;
  l122:;	  yy->__pos= yypos121; yy->__thunkpos= yythunkpos121;  if (!yy_auth_rule(yy)) goto l123;  goto l121;
  l123:;	  yy->__pos= yypos121; yy->__thunkpos= yythunkpos121;  if (!yy_logfile(yy)) goto l124;  goto l121;
  l124:;	  yy->__pos= yypos121; yy->__thunkpos= yythunkpos121;  if (!yy_pidlogfile(yy)) goto l125;  goto l121;
  l125:;	  yy->__pos= yypos121; yy->__thunkpos= yythunkpos121;  if (!yy_logcommon(yy)) goto l120;
  }
  l121:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "command", yy->__buf+yy->__pos));
  return 1;
  l120:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "command", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy__(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "_"));  if (!yymatchClass(yy, (unsigned char *)"\000\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l126;
  l127:;	
  {  int yypos128= yy->__pos, yythunkpos128= yy->__thunkpos;  if (!yymatchClass(yy, (unsigned char *)"\000\002\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000")) goto l128;  goto l127;
  l128:;	  yy->__pos= yypos128; yy->__thunkpos= yythunkpos128;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "_", yy->__buf+yy->__pos));
  return 1;
  l126:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "_", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_invalid_syntax(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "invalid_syntax"));  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_BEGIN)) goto l129;
#undef yytext
#undef yyleng
  }
  {  int yypos132= yy->__pos, yythunkpos132= yy->__thunkpos;  if (!yy_eol(yy)) goto l132;  goto l129;
  l132:;	  yy->__pos= yypos132; yy->__thunkpos= yythunkpos132;
  }  if (!yymatchDot(yy)) goto l129;
  l130:;	
  {  int yypos131= yy->__pos, yythunkpos131= yy->__thunkpos;
  {  int yypos133= yy->__pos, yythunkpos133= yy->__thunkpos;  if (!yy_eol(yy)) goto l133;  goto l131;
  l133:;	  yy->__pos= yypos133; yy->__thunkpos= yythunkpos133;
  }  if (!yymatchDot(yy)) goto l131;  goto l130;
  l131:;	  yy->__pos= yypos131; yy->__thunkpos= yythunkpos131;
  }  yyText(yy, yy->__begin, yy->__end);  {
#define yytext yy->__text
#define yyleng yy->__textlen
if (!(YY_END)) goto l129;
#undef yytext
#undef yyleng
  }  if (!yy_eol(yy)) goto l129;  yyDo(yy, yy_1_invalid_syntax, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "invalid_syntax", yy->__buf+yy->__pos));
  return 1;
  l129:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "invalid_syntax", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_eol(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "eol"));
  {  int yypos135= yy->__pos, yythunkpos135= yy->__thunkpos;
  {  int yypos137= yy->__pos, yythunkpos137= yy->__thunkpos;  if (!yymatchChar(yy, '\r')) goto l137;  goto l138;
  l137:;	  yy->__pos= yypos137; yy->__thunkpos= yythunkpos137;
  }
  l138:;	  if (!yymatchChar(yy, '\n')) goto l136;  goto l135;
  l136:;	  yy->__pos= yypos135; yy->__thunkpos= yythunkpos135;  if (!yy_eof(yy)) goto l134;
  }
  l135:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "eol", yy->__buf+yy->__pos));
  return 1;
  l134:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "eol", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_line(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "line"));
  {  int yypos140= yy->__pos, yythunkpos140= yy->__thunkpos;  if (!yy__(yy)) goto l140;  goto l141;
  l140:;	  yy->__pos= yypos140; yy->__thunkpos= yythunkpos140;
  }
  l141:;	
  {  int yypos142= yy->__pos, yythunkpos142= yy->__thunkpos;  if (!yy_command(yy)) goto l142;
  {  int yypos144= yy->__pos, yythunkpos144= yy->__thunkpos;  if (!yy__(yy)) goto l144;  goto l145;
  l144:;	  yy->__pos= yypos144; yy->__thunkpos= yythunkpos144;
  }
  l145:;	  goto l143;
  l142:;	  yy->__pos= yypos142; yy->__thunkpos= yythunkpos142;
  }
  l143:;	
  {  int yypos146= yy->__pos, yythunkpos146= yy->__thunkpos;  if (!yy_comment(yy)) goto l146;  goto l147;
  l146:;	  yy->__pos= yypos146; yy->__thunkpos= yythunkpos146;
  }
  l147:;	
  yyprintf((stderr, "  ok   %s @ %s\n", "line", yy->__buf+yy->__pos));
  return 1;
  l139:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "line", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_sol(yycontext *yy)
{  int yypos0= yy->__pos, yythunkpos0= yy->__thunkpos;
  yyprintf((stderr, "%s\n", "sol"));  yyDo(yy, yy_1_sol, yy->__begin, yy->__end);
  yyprintf((stderr, "  ok   %s @ %s\n", "sol", yy->__buf+yy->__pos));
  return 1;
  l148:;	  yy->__pos= yypos0; yy->__thunkpos= yythunkpos0;
  yyprintf((stderr, "  fail %s @ %s\n", "sol", yy->__buf+yy->__pos));
  return 0;
}
YY_RULE(int) yy_file(yycontext *yy)
{
  yyprintf((stderr, "%s\n", "file"));
  l150:;	
  {  int yypos151= yy->__pos, yythunkpos151= yy->__thunkpos;  if (!yy_sol(yy)) goto l151;
  {  int yypos152= yy->__pos, yythunkpos152= yy->__thunkpos;  if (!yy_line(yy)) goto l153;  if (!yy_eol(yy)) goto l153;  goto l152;
  l153:;	  yy->__pos= yypos152; yy->__thunkpos= yythunkpos152;  if (!yy_invalid_syntax(yy)) goto l151;
  }
  l152:;	  goto l150;
  l151:;	  yy->__pos= yypos151; yy->__thunkpos= yythunkpos151;
  }
  yyprintf((stderr, "  ok   %s @ %s\n", "file", yy->__buf+yy->__pos));
  return 1;
}

#ifndef YY_PART

typedef int (*yyrule)(yycontext *yy);

YY_PARSE(int) YYPARSEFROM(YY_CTX_PARAM_ yyrule yystart)
{
  int yyok;
  if (!yyctx->__buflen)
    {
      yyctx->__buflen= YY_BUFFER_SIZE;
      yyctx->__buf= (char *)YY_MALLOC(yyctx, yyctx->__buflen);
      yyctx->__textlen= YY_BUFFER_SIZE;
      yyctx->__text= (char *)YY_MALLOC(yyctx, yyctx->__textlen);
      yyctx->__thunkslen= YY_STACK_SIZE;
      yyctx->__thunks= (yythunk *)YY_MALLOC(yyctx, sizeof(yythunk) * yyctx->__thunkslen);
      yyctx->__valslen= YY_STACK_SIZE;
      yyctx->__vals= (YYSTYPE *)YY_MALLOC(yyctx, sizeof(YYSTYPE) * yyctx->__valslen);
      yyctx->__begin= yyctx->__end= yyctx->__pos= yyctx->__limit= yyctx->__thunkpos= 0;
    }
  yyctx->__begin= yyctx->__end= yyctx->__pos;
  yyctx->__thunkpos= 0;
  yyctx->__val= yyctx->__vals;
  yyok= yystart(yyctx);
  if (yyok) yyDone(yyctx);
  yyCommit(yyctx);
  return yyok;
}

YY_PARSE(int) YYPARSE(YY_CTX_PARAM)
{
  return YYPARSEFROM(YY_CTX_ARG_ yy_file);
}

YY_PARSE(yycontext *) YYRELEASE(yycontext *yyctx)
{
  if (yyctx->__buflen)
    {
      yyctx->__buflen= 0;
      YY_FREE(yyctx, yyctx->__buf);
      YY_FREE(yyctx, yyctx->__text);
      YY_FREE(yyctx, yyctx->__thunks);
      YY_FREE(yyctx, yyctx->__vals);
    }
  return yyctx;
}

#endif
#line 165 "parse.peg"


void parseConfiguration(char const *file)
{
	FILE *in = fopen(file, "r");
	if (!in) {
		logError("could not open configuration file %s.\n", file);
		exit(1);
	}

	yycontext ctx;
	memset(&ctx, 0, sizeof(yycontext));
	ctx.fp = in;
	if (!yyparse(&ctx)) {
		logError("invalid syntax in file %s, line %d.\n", file, -1);
		exit(1);
	}
	yyrelease(&ctx);

	fclose(in);

	/* Avoid warnings for these unused functions */
	(void)yySet; (void)yyPush; (void)yyPop; (void)yyAccept;
}


