#' Replication of Laptop Note Taking Study (Urry et al. 2021, Psych. Science)
#'
#' Original abstract: 
#' In this direct replication of Mueller and Oppenheimer’s (2014) Study 1,
#' participants watched a lecture while taking notes with a laptop (n = 74) or
#' longhand (n = 68). After a brief distraction and without the opportunity to
#' study, they took a quiz. As in the original study, laptop participants took
#' notes containing more words spoken verbatim by the lecturer and more words
#' overall than did longhand participants. However, laptop participants did not
#' perform better than longhand participants on the quiz.
#' 
#' Own description:
#'
#' Heather Urry and 87 of her undergraduate and graduate students (yes, all 87
#' students are co-authors!) compared the effectiveness of taking notes on a
#' laptop versus longhand (i.e., pen and paper) for learning from lectures. 142
#' participants (which differed from the 88 authors) first viewed one of several
#' 15 minutes lectures (TED talks) during which they were asked to take notes
#' either on a laptop or with pen and paper. Participants were randomly assigned
#' to either the laptop (N = 68) or longhand condition (N = 74). After a 30
#' minutes delay, participants were quizzed on the content of the lecture. There
#' were two types of questions, factual and conceptual questions. The answers
#' from each participant were then independently rated from several raters
#' (which agreed very strongly with each other) using a standardised scoring key
#' producing one memory score per participant and questions type ranging from 0
#' (= no memory) to 100 (= perfect memory). We also aggregated the two different
#' scores into one overall memory score.
#'
#'
#' @docType data
#' @keywords dataset
#' @name laptop_urry 
#' @usage laptop_urry 
#' @format A data frame with 142 rows and 6 variables:
#' \describe{
#'   \item{pid}{participant id, factor with 142 levels}
#'   \item{condition}{experimental condition (laptop, longhand), factor with 2 levels}
#'   \item{talk}{TED talk seen by participant, factor with 5 levels}
#'   \item{overall}{overall memory score ranging from 0 (= no memory) to 100 (= perfect memory).}
#'   \item{factual}{memory score on the factual questions ranging from 0 (= no memory) to 100 (= perfect memory).}
#'   \item{conceptual}{memory score on the conceptual questions ranging from 0 (= no memory) to 100 (= perfect memory).}
#' }
#' @source Urry, H. L., Crittle, C. S., Floerke, V. A., Leonard, M. Z., Perry,
#'   C. S., Akdilek, N., Albert, E. R., Block, A. J., Bollinger, C. A., Bowers,
#'   E. M., Brody, R. S., Burk, K. C., Burnstein, A., Chan, A. K., Chan, P. C.,
#'   Chang, L. J., Chen, E., Chiarawongse, C. P., Chin, G., … Zarrow, J. E.
#'   (2021). Don’t Ditch the Laptop Just Yet: A Direct Replication of Mueller
#'   and Oppenheimer’s (2014) Study 1 Plus Mini Meta-Analyses Across Similar
#'   Studies. *Psychological Science*, 0956797620965541.
#'   \doi{10.1177/0956797620965541}
#'
#' @encoding UTF-8
#'
"laptop_urry"



