% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duprateExpIdentify.R
\name{duprateExpIdentify}
\alias{duprateExpIdentify}
\title{Identify genes plotted by \code{duprateExpPlot}}
\usage{
duprateExpIdentify(DupMat, idCol = "ID")
}
\arguments{
\item{DupMat}{The duplication matrix calculated by \code{analyzeDuprates}}

\item{idCol}{The column from the duplication matrix containing the labels}
}
\value{
The identified points. \code{x} and \code{y} values match the ones 
 from \code{duprateExpPlot}
}
\description{
\code{duprateExpIdentify} Identify genes plotted by \code{duprateExpPlot}
}
\details{
This function makes a barplot showing the cumulative read counts fraction
from the duplication matrix calculated by \code{analyzeDuprates}.
}
\examples{
# dm is a duplication matrix calculated by analyzeDuprates:
# R> dm <- analyzeDuprates(bamDuprm,gtf,stranded,paired,threads)
attach(dupRadar_examples)

# call the plot and identify genes
duprateExpPlot(DupMat=dm)
duprateExpIdentify(DupMat=dm)
}
