/***************************************************************************
                                graphictext.h
                               ---------------
    begin                : Mon Nov 24 2003
    copyright            : (C) 2003 by Michael Margraf
    email                : michael.margraf@alumni.tu-berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GRAPHICTEXT_H
#define GRAPHICTEXT_H

#include "painting.h"
#include <QFont>


class GraphicText : public Painting  {
public:
  GraphicText();

  void paint(QPainter* painter) override;
  void paintScheme(Schematic*) override;

  Painting* newOne() override;
  static Element* info(QString&, char* &, bool getNewOne=false);

  bool    load(const QString&) override;
  QString save() override;
  QString saveCpp() override;
  QString saveJSON() override;

  bool getSelected(const QPoint& click, int tolerance) override;

  void MouseMoving(const QPoint& onGrid, Schematic* sch, const QPoint& cursor) override;
  bool MousePressing(Schematic* sch = nullptr) override;

  bool rotate() noexcept override;
  bool rotate(int rcx, int rcy) noexcept override;

  QRect boundingRect() const noexcept override;
  QPoint center() const noexcept override;
  bool moveCenter(int dx, int dy) noexcept override;
  bool moveCenterTo(int x, int y) noexcept;

  bool Dialog(QWidget* parent = nullptr) override;

private:
  QColor   color;
  QFont    font;
  QString  text;
  int      angle;
  QTransform getTransform() const;
  QRectF getTextBounds(QPainter* painter = nullptr) const;
};

#endif
