//start of CachedInputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * CachedInputStream.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.InputStream;

//import exceptions
import java.io.IOException;
import java.lang.IllegalArgumentException;

/**
 * LbVgpč邽߂̓̓Xg[B<br> 
 * BufferedInputStream Ƃ readn\bh synchronized
 * ĂȂ߁Aɂ郍XȂAmark/reset 
 * LbV̓ǂݍ݈ʒüړōsƂ̂݃T|[głA
 * ȏ͐ڑꂽ̓Xg[̐\ɂÄႢB
 * 
 * <pre>
 * -- revision history --
 * $Log: CachedInputStream.java,v $
 * Revision 1.3  2002/12/05 00:00:00  dangan
 * [maintenance]
 *     \[X
 *
 * Revision 1.2  2002/11/02 00:00:00  dangan
 * [bug fix]
 *     available() ŃubNɓǂݍ߂ʂ傫lԂĂB
 *
 * Revision 1.1  2002/09/05 00:00:00  dangan
 * [change]
 *     EndOfStream ɒB read( new byte[0] )  
 *     read( byte[] buf, int off, 0 ) ̖߂l
 *     InputStream Ɠ 0 ɂȂ悤ɂB
 *
 * Revision 1.0  2002/09/05 00:00:00  dangan
 * add to version control
 * [bug fix]
 *     mark()  ڑꂽ in ɓn readLimit ̌vZÂ߁A
 *     vꂽ readLimit ɒBOɃ}[Nʒuj鎖B
 *     read( buf, off, len )  System.arraycopy ̌Ăяo 
 *     dst  src tɂĂB
 * [change]
 *     EndOfStream ɒB read( new byte[0] ) 
 *     read( buf, offC0 )   -1 Ԃ悤ɏCB
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.3 $
 */
public class CachedInputStream extends InputStream{

    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  default
    //------------------------------------------------------------------
    //  private static final int DefaultCacheSize
    //------------------------------------------------------------------
    /**
     * ftHg̃LbVTCY
     */
    private static final int DefaultCacheSize = 1024;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream in
    //------------------------------------------------------------------
    /**
     * f[^̓Xg[
     */
    private InputStream in;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  cache
    //------------------------------------------------------------------
    //  private byte[] cache
    //  private int cachePosition
    //  private int cacheLimit
    //------------------------------------------------------------------
    /**
     * f[^~邽߂̃LbV
     */
    private byte[] cache;

    /**
     * cachěݏʒu
     */
    private int cachePosition;

    /**
     * cache̓ǂݍ݌Eʒu
     */
    private int cacheLimit;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  backup for mark/reset
    //------------------------------------------------------------------
    //  private boolean markPositionIsInCache
    //  private byte[] markCache
    //  private int markCachePosition
    //  private int markCacheLimit
    //------------------------------------------------------------------
    /**
     * markʒuLbV͈͓̔ɂ邩B
     * markꂽƂ true ɐݒ肳A
     *  in  LbVւ̓ǂݍ݂
     * sꂽƂ false ɐݒ肳B
     */
    private boolean markPositionIsInCache;

    /** cachẽobNAbvp */
    private byte[] markCache;

    /** cachePositioñobNAbvp */
    private int markCachePosition;

    /** cacheLimit̃obNAbvp */
    private int markCacheLimit;


    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private CachedInputStream()
    //  public CachedInputStream( InputStream in )
    //  public CachedInputStream( InputStream in, int cacheSize )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private CachedInputStream(){ }

    /**
     * ftHg̃TCỸLbV
     * CachedInputStream\zB
     * 
     * @param in LbVKvȓ̓Xg[
     * 
     * @exception IllegalArgumentException
     *                     in  null ꍇ
     */
    public CachedInputStream( InputStream in ){
        this( in, CachedInputStream.DefaultCacheSize );
    }

    /**
     * w肳ꂽTCỸLbV
     * CachedInputStream\zB
     * 
     * @param in        LbVKvȓ̓Xg[
     * @param cacheSize LbṼTCY
     * 
     * @exception IllegalArgumentException
     *                     cacheSize  0ȉł邩A
     *                     in  null ꍇ
     */
    public CachedInputStream( InputStream in, int cacheSize ){
        if( in != null && 0 < cacheSize ){
            this.in = in;

            this.cache                 = new byte[cacheSize];
            this.cachePosition         = 0;
            this.cacheLimit            = 0;

            this.markPositionIsInCache = false;
            this.markCache             = null;
            this.markCachePosition     = 0;
            this.markCacheLimit        = 0;

        }else if( in == null ){
            throw new IllegalArgumentException( "in must not be null." );
        }else{
            throw new IllegalArgumentException( "cacheSize must be one or more." );
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream 
    //------------------------------------------------------------------
    //  read
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //  public long skip( long length )
    //------------------------------------------------------------------
    /**
     * ڑꂽXg[ 1oCg̃f[^
     * 0`255 Ƀ}bvēǂݍށB
     * 
     * @return ǂݏoꂽ 1oCg̃f[^ԂB<br>
     *          EndOfStreamɒBĂꍇ -1ԂB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int read() throws IOException {
        if( this.cachePosition < this.cacheLimit ){
            return this.cache[ this.cachePosition++ ] & 0xFF;
        }else{
            this.fillCache();                                                     //throws IOException

            if( this.cachePosition < this.cacheLimit ){
                return this.cache[ this.cachePosition++ ] & 0xFF;
            }else{
                return -1;
            }
        }
    }

    /**
     * ڑꂽXg[ buffer𖞂悤
     * f[^ǂݍށB<br>
     * ̃\bh buffer 𖞂܂Ńf[^ǂݍނA
     * EndOfStreamɓB܂ŃubNB<br>
     * 
     * @param buffer ǂݍ񂾃f[^i[邽߂̃oCgz
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *          EndOfStreamɒBĂꍇ -1ԂB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int read( byte[] buffer ) throws IOException {
        return this.read( buffer, 0, buffer.length );
    }

    /**
     * ڑꂽXg[ buffer  index Ŏw肳ꂽ
     * ʒu length oCgf[^ǂݍށB<br>
     * ̃\bh length oCgǂݍނA
     * EndOfStreamɓB܂ŃubNB<br>
     * 
     * @param buffer ǂݍ񂾃f[^i[邽߂̃oCgz
     * @param index  buffer̃f[^ǂݍ݊Jnʒu
     * @param length bufferɓǂݍރf[^
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *          EndOfStreamɒBĂꍇ -1ԂB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int read( byte[] buffer, int index, int length ) 
                                                     throws IOException {
        final int requested = length;

        while( 0 < length ){
            if( this.cacheLimit <= this.cachePosition ){
                this.fillCache();                                             //throws IOException
                if( this.cacheLimit <= this.cachePosition ){
                    if( requested == length ){
                        return -1;
                    }else{
                        break;
                    }
                }
            }

            int copylen = Math.min( length,
                                    this.cacheLimit - this.cachePosition );
            System.arraycopy( this.cache, this.cachePosition,
                              buffer, index, copylen );

            index              += copylen;
            length             -= copylen;
            this.cachePosition += copylen;
        }

        return requested - length;
    }

    /**
     * ڑꂽ̓Xg[̃f[^ length oCgǂݔ΂B<br>
     * ̃\bh length oCgǂݔ΂
     * EndOfStream ɓB܂ŃubNB<br>
     * 
     * @param length ǂݔ΂oCgB<br>
     * 
     * @return ۂɓǂݔ΂ꂽoCgB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public long skip( long length ) throws IOException {
        final long requested = length;

        while( 0 < length ){
            if( this.cacheLimit <= this.cachePosition ){
                this.fillCache();                                             //throws IOException

                if( this.cacheLimit <= this.cachePosition ){
                    break;
                }
            }

            long skiplen = Math.min( length, (long)(this.cacheLimit - this.cachePosition) );

            length             -= skiplen;
            this.cachePosition += (int)skiplen;
        }

        return requested - length;
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupported()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     */
    public void mark( int readLimit ){
        readLimit -= this.cacheLimit - this.cachePosition;
        readLimit = ( readLimit / this.cache.length ) * this.cache.length
                  + ( readLimit % this.cache.length == 0 ? 0 : this.cache.length );


        this.in.mark( readLimit );

        if( this.markCache == null ){
            this.markCache = (byte[])this.cache.clone();
        }else{
            System.arraycopy( this.cache, 0, this.markCache, 0, this.cacheLimit );
        }

        this.markCacheLimit        = this.cacheLimit;
        this.markCachePosition     = this.cachePosition;
        this.markPositionIsInCache = true;
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException <br>
     *              (1) CachedInputStream  mark ȂĂȂꍇB<br>
     *              (2) ڑꂽ̓Xg[ markSupported()
     *                  false ԂꍇB<br>
     *              (3) ڑꂽ̓Xg[
     *                  o̓G[ꍇB<br>
     *              ̉ꂩB
     */
    public void reset() throws IOException {
        if( this.markPositionIsInCache ){
            this.cachePosition  = this.markCachePosition;
        }else if( !this.in.markSupported() ){
            throw new IOException( "not support mark()/reset()." );
        }else if( this.markCache == null ){ //͖̏Ƀ}[NĂȂƂBRXgN^ markCache  null ɐݒ肳̂𗘗pB 
            throw new IOException( "not marked." );
        }else{
            //in  reset() łȂꍇ
            //ŏ̍s this.in.reset() 
            //IOException 𓊂邱Ƃ҂ĂB
            this.in.reset();                                                    //throws IOException
            System.arraycopy( this.markCache, 0, this.cache, 0, this.markCacheLimit );
            this.cacheLimit    = this.markCacheLimit;
            this.cachePosition = this.markCachePosition;
        }
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean markSupported(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ubNȂ
     * ǂݍނƂ̂łoCg𓾂B<br>
     * 
     * @return ubNȂœǂݏooCgB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public int available() throws IOException {
        return this.cacheLimit - this.cachePosition
              + ( this.in.available() / this.cache.length ) * this.cache.length;//throws IOException
    }

    /**
     * ̓̓Xg[AgpĂ
     * SẴ\[XJB<br>
     * 
     * @exception IOException ڑꂽ̓Xg[
     *                        o̓G[ꍇ
     */
    public void close() throws IOException {
        this.in.close();                                                        //throws IOException
        this.in                    = null;

        this.cache                 = null;
        this.cacheLimit            = 0;
        this.cachePosition         = 0;

        this.markCache             = null;
        this.markCacheLimit        = 0;
        this.markCachePosition     = 0;
        this.markPositionIsInCache = false;
    }


    //------------------------------------------------------------------
    //  local methods
    //------------------------------------------------------------------
    //  private void fillCache()
    //------------------------------------------------------------------
    /**
     * KvꍇɁALbVpobt@Ƀf[^
     * ULbVpobt@ɕKf[^݂
     * Ƃۏ؂邽߂ɌĂ΂B<br>
     *  EndOfStream ܂œǂݍ܂Ăꍇ f[^
     * UȂƂɂ B
     * 
     * @exception IOException o̓G[ꍇ
     */
    private void fillCache() throws IOException {
        this.markPositionIsInCache = false;
        this.cacheLimit            = 0;
        this.cachePosition         = 0;

        //LbVɃf[^ǂݍ
        int read = 0;
        while( 0 <= read && this.cacheLimit < this.cache.length ){
            read = this.in.read( this.cache,
                                 this.cacheLimit, 
                                 this.cache.length - this.cacheLimit );         //throws IOException

            if( 0 < read ) this.cacheLimit += read;
        }
    }


}
//end of CachedInputStream.java
