# (C) Copyright 2018- ECMWF.
# This software is licensed under the terms of the Apache Licence Version 2.0
# which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
# In applying this licence, ECMWF does not waive the privileges and immunities
# granted to it by virtue of its status as an intergovernmental organisation
# nor does it submit to any jurisdiction.
"""
Sub-package with supported source code transformation passes.

This sub-package includes general source code transformations and
bespoke :any:`Transformation` and :any:`Pipeline` classes for
IFS-specific source-to-source recipes that target GPUs.
"""

from loki.transformations.array_indexing import * # noqa
from loki.transformations.build_system import * # noqa
from loki.transformations.argument_shape import * # noqa
from loki.transformations.data_offload import * # noqa
from loki.transformations.drhook import * # noqa
from loki.transformations.extract import * # noqa
from loki.transformations.field_api import * # noqa
from loki.transformations.hoist_variables import * # noqa
from loki.transformations.idempotence import * # noqa
from loki.transformations.inline import * # noqa
from loki.transformations.parametrise import * # noqa
from loki.transformations.raw_stack_allocator import * # noqa
from loki.transformations.remove_code import * # noqa
from loki.transformations.sanitise import * # noqa
from loki.transformations.single_column import * # noqa
from loki.transformations.transpile import * # noqa
from loki.transformations.transform_derived_types import * # noqa
from loki.transformations.transform_loop import * # noqa
from loki.transformations.transform_region import * # noqa
from loki.transformations.pool_allocator import * # noqa
from loki.transformations.utilities import * # noqa
from loki.transformations.block_index_transformations import * # noqa
from loki.transformations.split_read_write import * # noqa
from loki.transformations.loop_blocking import * # noqa
from loki.transformations.routine_signatures import * # noqa
from loki.transformations.parallel import * # noqa
from loki.transformations.dependency import * # noqa
