/*
 * J784S4 Devices Info
 *
 * Copyright (C) 2022 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_devices_info j784s4_devices_info[] = {
	{0, "J784S4_DEV_MCU_ADC12FC_16FFC0"},
	{1, "J784S4_DEV_MCU_ADC12FC_16FFC1"},
	{2, "J784S4_DEV_ATL0"},
	{3, "J784S4_DEV_C71X_0_PBIST_VD"},
	{5, "J784S4_DEV_C71X_1_PBIST_VD"},
	{6, "J784S4_DEV_COMPUTE_CLUSTER0"},
	{7, "J784S4_DEV_J7AM_PULSAR_ATB_FUNNEL0"},
	{8, "J784S4_DEV_SA2_CPSW_PSILSS0"},
	{9, "J784S4_DEV_WKUP_J7AM_WAKEUP_16FF0"},
	{10, "J784S4_DEV_GPIOMUX_INTRTR0"},
	{11, "J784S4_DEV_CMPEVENT_INTRTR0"},
	{17, "J784S4_DEV_COMPUTE_CLUSTER0_AC71_4_DFT_EMBED_PBIST_0"},
	{18, "J784S4_DEV_COMPUTE_CLUSTER0_AC71_5_DFT_EMBED_PBIST_0"},
	{19, "J784S4_DEV_COMPUTE_CLUSTER0_AC71_6_DFT_EMBED_PBIST_0"},
	{20, "J784S4_DEV_COMPUTE_CLUSTER0_AC71_7_DFT_EMBED_PBIST_0"},
	{21, "J784S4_DEV_COMPUTE_CLUSTER0_ARM0_DFT_EMBED_PBIST_0"},
	{22, "J784S4_DEV_WKUP_SMS0"},
	{23, "J784S4_DEV_COMPUTE_CLUSTER0_ARM0_DFT_EMBED_PBIST_1"},
	{24, "J784S4_DEV_COMPUTE_CLUSTER0_ARM1_DFT_EMBED_PBIST_0"},
	{25, "J784S4_DEV_COMPUTE_CLUSTER0_ARM1_DFT_EMBED_PBIST_1"},
	{26, "J784S4_DEV_COMPUTE_CLUSTER0_AW4_MSMC_DFT_EMBED_PBIST_0"},
	{27, "J784S4_DEV_COMPUTE_CLUSTER0_AW5_MSMC_DFT_EMBED_PBIST_0"},
	{28, "J784S4_DEV_COMPUTE_CLUSTER0_AW6_MSMC_DFT_EMBED_PBIST_0"},
	{29, "J784S4_DEV_COMPUTE_CLUSTER0_AW7_MSMC_DFT_EMBED_PBIST_0"},
	{30, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS0"},
	{31, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS0_CORE0"},
	{32, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS0_MMA_0"},
	{33, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS1"},
	{34, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS1_CORE0"},
	{35, "J784S4_DEV_MCU_TIMER0"},
	{36, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS1_MMA_0"},
	{37, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS2"},
	{38, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS2_CORE0"},
	{39, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS2_MMA_0"},
	{40, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS3"},
	{41, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS3_CORE0"},
	{42, "J784S4_DEV_COMPUTE_CLUSTER0_C71SS3_MMA_0"},
	{43, "J784S4_DEV_COMPUTE_CLUSTER0_CFG_WRAP_0"},
	{44, "J784S4_DEV_COMPUTE_CLUSTER0_CLEC"},
	{45, "J784S4_DEV_COMPUTE_CLUSTER0_CORE_CORE"},
	{46, "J784S4_DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF_0"},
	{47, "J784S4_DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF_1"},
	{48, "J784S4_DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF_2"},
	{49, "J784S4_DEV_COMPUTE_CLUSTER0_DDR32SS_EMIF_3"},
	{50, "J784S4_DEV_COMPUTE_CLUSTER0_DEBUG_WRAP_0"},
	{51, "J784S4_DEV_COMPUTE_CLUSTER0_DIVH2_DIVH_0"},
	{52, "J784S4_DEV_COMPUTE_CLUSTER0_DIVH2_DIVH_1"},
	{53, "J784S4_DEV_COMPUTE_CLUSTER0_DIVP_TFT_0"},
	{54, "J784S4_DEV_COMPUTE_CLUSTER0_DIVP_TFT_1"},
	{55, "J784S4_DEV_COMPUTE_CLUSTER0_DMSC_WRAP_0"},
	{57, "J784S4_DEV_COMPUTE_CLUSTER0_EN_MSMC_DOMAIN_0"},
	{58, "J784S4_DEV_COMPUTE_CLUSTER0_GIC500SS"},
	{59, "J784S4_DEV_COMPUTE_CLUSTER0_MSMC2_WRAP_0"},
	{60, "J784S4_DEV_COMPUTE_CLUSTER0_MSMC_DFT_EMBED_PBIST_0"},
	{61, "J784S4_DEV_GTC0"},
	{62, "J784S4_DEV_CPSW1"},
	{63, "J784S4_DEV_MCU_CPSW0"},
	{64, "J784S4_DEV_CPSW_9XUSS_J7AM0"},
	{65, "J784S4_DEV_CPT2_AGGR1"},
	{66, "J784S4_DEV_CPT2_AGGR5"},
	{67, "J784S4_DEV_CPT2_AGGR2"},
	{68, "J784S4_DEV_CPT2_AGGR4"},
	{69, "J784S4_DEV_CPT2_AGGR3"},
	{70, "J784S4_DEV_CPT2_AGGR0"},
	{71, "J784S4_DEV_MCU_CPT2_AGGR0"},
	{72, "J784S4_DEV_CSI_RX_IF0"},
	{73, "J784S4_DEV_CSI_RX_IF1"},
	{74, "J784S4_DEV_CSI_RX_IF2"},
	{75, "J784S4_DEV_CSI_TX_IF_V2_0"},
	{76, "J784S4_DEV_CSI_TX_IF_V2_1"},
	{77, "J784S4_DEV_STM0"},
	{78, "J784S4_DEV_DCC0"},
	{79, "J784S4_DEV_DCC1"},
	{80, "J784S4_DEV_DCC2"},
	{81, "J784S4_DEV_DCC3"},
	{82, "J784S4_DEV_DCC4"},
	{83, "J784S4_DEV_DCC5"},
	{84, "J784S4_DEV_DCC6"},
	{85, "J784S4_DEV_DCC7"},
	{86, "J784S4_DEV_DCC8"},
	{87, "J784S4_DEV_DCC9"},
	{88, "J784S4_DEV_MCU_DCC0"},
	{89, "J784S4_DEV_MCU_DCC1"},
	{90, "J784S4_DEV_MCU_DCC2"},
	{91, "J784S4_DEV_DEBUGSS_WRAP0"},
	{92, "J784S4_DEV_DMPAC0"},
	{93, "J784S4_DEV_DMPAC0_CTSET_0"},
	{94, "J784S4_DEV_DMPAC0_INTD_0"},
	{95, "J784S4_DEV_DMPAC0_UTC_0"},
	{96, "J784S4_DEV_DMPAC0_SDE_0"},
	{97, "J784S4_DEV_TIMER0"},
	{98, "J784S4_DEV_TIMER1"},
	{99, "J784S4_DEV_TIMER2"},
	{100, "J784S4_DEV_TIMER3"},
	{101, "J784S4_DEV_TIMER4"},
	{102, "J784S4_DEV_TIMER5"},
	{103, "J784S4_DEV_TIMER6"},
	{104, "J784S4_DEV_TIMER7"},
	{105, "J784S4_DEV_TIMER8"},
	{106, "J784S4_DEV_TIMER9"},
	{107, "J784S4_DEV_TIMER10"},
	{108, "J784S4_DEV_TIMER11"},
	{109, "J784S4_DEV_TIMER12"},
	{110, "J784S4_DEV_TIMER13"},
	{111, "J784S4_DEV_TIMER14"},
	{112, "J784S4_DEV_TIMER15"},
	{113, "J784S4_DEV_TIMER16"},
	{114, "J784S4_DEV_TIMER17"},
	{115, "J784S4_DEV_TIMER18"},
	{116, "J784S4_DEV_TIMER19"},
	{117, "J784S4_DEV_MCU_TIMER1"},
	{118, "J784S4_DEV_MCU_TIMER2"},
	{119, "J784S4_DEV_MCU_TIMER3"},
	{120, "J784S4_DEV_MCU_TIMER4"},
	{121, "J784S4_DEV_MCU_TIMER5"},
	{122, "J784S4_DEV_MCU_TIMER6"},
	{123, "J784S4_DEV_MCU_TIMER7"},
	{124, "J784S4_DEV_MCU_TIMER8"},
	{125, "J784S4_DEV_MCU_TIMER9"},
	{126, "J784S4_DEV_ECAP0"},
	{127, "J784S4_DEV_ECAP1"},
	{128, "J784S4_DEV_ECAP2"},
	{130, "J784S4_DEV_ELM0"},
	{131, "J784S4_DEV_EMIF_DATA_0_VD"},
	{132, "J784S4_DEV_EMIF_DATA_1_VD"},
	{133, "J784S4_DEV_EMIF_DATA_2_VD"},
	{139, "J784S4_DEV_EMIF_DATA_3_VD"},
	{140, "J784S4_DEV_MMCSD0"},
	{141, "J784S4_DEV_MMCSD1"},
	{142, "J784S4_DEV_EQEP0"},
	{143, "J784S4_DEV_EQEP1"},
	{144, "J784S4_DEV_EQEP2"},
	{145, "J784S4_DEV_ESM0"},
	{146, "J784S4_DEV_UART0"},
	{147, "J784S4_DEV_WKUP_ESM0"},
	{148, "J784S4_DEV_MCU_ESM0"},
	{149, "J784S4_DEV_MCU_UART0"},
	{150, "J784S4_DEV_FFI_MAIN_AC_CBASS_VD"},
	{151, "J784S4_DEV_FFI_MAIN_AC_QM_CBASS_VD"},
	{152, "J784S4_DEV_FFI_MAIN_HC_CBASS_VD"},
	{153, "J784S4_DEV_FFI_MAIN_INFRA_CBASS_VD"},
	{154, "J784S4_DEV_FFI_MAIN_IP_CBASS_VD"},
	{155, "J784S4_DEV_FFI_MAIN_RC_CBASS_VD"},
	{156, "J784S4_DEV_MCU_FSS0"},
	{157, "J784S4_DEV_BOARD0"},
	{158, "J784S4_DEV_MCU_FSS0_FSAS_0"},
	{160, "J784S4_DEV_MCU_FSS0_HYPERBUS1P0_0"},
	{161, "J784S4_DEV_MCU_FSS0_OSPI_0"},
	{162, "J784S4_DEV_MCU_FSS0_OSPI_1"},
	{163, "J784S4_DEV_GPIO0"},
	{164, "J784S4_DEV_GPIO2"},
	{165, "J784S4_DEV_GPIO4"},
	{166, "J784S4_DEV_GPIO6"},
	{167, "J784S4_DEV_WKUP_GPIO0"},
	{168, "J784S4_DEV_WKUP_GPIO1"},
	{169, "J784S4_DEV_GPMC0"},
	{170, "J784S4_DEV_MCU_I3C0"},
	{171, "J784S4_DEV_MCU_I3C1"},
	{172, "J784S4_DEV_LED0"},
	{173, "J784S4_DEV_MAIN2MCU_LVL_INTRTR0"},
	{174, "J784S4_DEV_MAIN2MCU_PLS_INTRTR0"},
	{175, "J784S4_DEV_WKUP_PORZ_SYNC0"},
	{176, "J784S4_DEV_TIMESYNC_INTRTR0"},
	{177, "J784S4_DEV_WKUP_GPIOMUX_INTRTR0"},
	{178, "J784S4_DEV_WKUP_PSC0"},
	{179, "J784S4_DEV_J7AEP_GPU_BXS464_WRAP0"},
	{180, "J784S4_DEV_J7AEP_GPU_BXS464_WRAP0_DFT_EMBED_PBIST_0"},
	{181, "J784S4_DEV_J7AEP_GPU_BXS464_WRAP0_GPU_SS_0"},
	{182, "J784S4_DEV_J7AEP_GPU_BXS464_WRAP0_GPUCORE_0"},
	{183, "J784S4_DEV_J7AM_32_64_ATB_FUNNEL0"},
	{184, "J784S4_DEV_J7AM_32_64_ATB_FUNNEL1"},
	{185, "J784S4_DEV_J7AM_32_64_ATB_FUNNEL2"},
	{186, "J784S4_DEV_AGGR_ATB0"},
	{187, "J784S4_DEV_J7AM_BOLT_PGD0"},
	{188, "J784S4_DEV_J7AM_BOLT_PSC_WRAP0"},
	{189, "J784S4_DEV_CSI_PSILSS0"},
	{190, "J784S4_DEV_DEBUGSUSPENDRTR0"},
	{191, "J784S4_DEV_DDR0"},
	{192, "J784S4_DEV_DDR1"},
	{193, "J784S4_DEV_DDR2"},
	{194, "J784S4_DEV_DDR3"},
	{195, "J784S4_DEV_DMPAC_VPAC_PSILSS0"},
	{197, "J784S4_DEV_J7AM_HWA_ATB_FUNNEL0"},
	{198, "J784S4_DEV_A72SS0"},
	{199, "J784S4_DEV_J7AM_MAIN_16FF0"},
	{200, "J784S4_DEV_A72SS1"},
	{201, "J784S4_DEV_PSC0"},
	{202, "J784S4_DEV_A72SS0_CORE0"},
	{203, "J784S4_DEV_A72SS0_CORE1"},
	{204, "J784S4_DEV_A72SS0_CORE2"},
	{205, "J784S4_DEV_A72SS0_CORE3"},
	{206, "J784S4_DEV_A72SS1_CORE0"},
	{207, "J784S4_DEV_A72SS1_CORE1"},
	{208, "J784S4_DEV_A72SS1_CORE2"},
	{209, "J784S4_DEV_A72SS1_CORE3"},
	{211, "J784S4_DEV_WKUP_DDPA0"},
	{212, "J784S4_DEV_DPHY_RX0"},
	{213, "J784S4_DEV_DPHY_RX1"},
	{214, "J784S4_DEV_DPHY_RX2"},
	{215, "J784S4_DEV_DSS_DSI0"},
	{216, "J784S4_DEV_DSS_DSI1"},
	{217, "J784S4_DEV_DSS_EDP0"},
	{218, "J784S4_DEV_DSS0"},
	{219, "J784S4_DEV_EPWM0"},
	{220, "J784S4_DEV_EPWM1"},
	{221, "J784S4_DEV_EPWM2"},
	{222, "J784S4_DEV_EPWM3"},
	{223, "J784S4_DEV_EPWM4"},
	{224, "J784S4_DEV_EPWM5"},
	{225, "J784S4_DEV_PBIST7"},
	{226, "J784S4_DEV_PBIST5"},
	{227, "J784S4_DEV_PBIST11"},
	{228, "J784S4_DEV_PBIST15"},
	{229, "J784S4_DEV_PBIST8"},
	{230, "J784S4_DEV_PBIST13"},
	{231, "J784S4_DEV_PBIST3"},
	{232, "J784S4_DEV_PBIST0"},
	{233, "J784S4_DEV_PBIST1"},
	{234, "J784S4_DEV_PBIST4"},
	{235, "J784S4_DEV_PBIST2"},
	{236, "J784S4_DEV_PBIST10"},
	{237, "J784S4_DEV_PBIST14"},
	{238, "J784S4_DEV_MCU_PBIST0"},
	{239, "J784S4_DEV_MCU_PBIST1"},
	{240, "J784S4_DEV_MCU_PBIST2"},
	{241, "J784S4_DEV_CODEC0"},
	{242, "J784S4_DEV_CODEC1"},
	{243, "J784S4_DEV_WKUP_VTM0"},
	{244, "J784S4_DEV_MAIN2WKUPMCU_VD"},
	{245, "J784S4_DEV_MCAN0"},
	{246, "J784S4_DEV_MCAN1"},
	{247, "J784S4_DEV_MCAN2"},
	{248, "J784S4_DEV_MCAN3"},
	{249, "J784S4_DEV_MCAN4"},
	{250, "J784S4_DEV_MCAN5"},
	{251, "J784S4_DEV_MCAN6"},
	{252, "J784S4_DEV_MCAN7"},
	{253, "J784S4_DEV_MCAN8"},
	{254, "J784S4_DEV_MCAN9"},
	{255, "J784S4_DEV_MCAN10"},
	{256, "J784S4_DEV_MCAN11"},
	{257, "J784S4_DEV_MCAN12"},
	{258, "J784S4_DEV_MCAN13"},
	{259, "J784S4_DEV_MCAN14"},
	{260, "J784S4_DEV_MCAN15"},
	{261, "J784S4_DEV_MCAN16"},
	{262, "J784S4_DEV_MCAN17"},
	{263, "J784S4_DEV_MCU_MCAN0"},
	{264, "J784S4_DEV_MCU_MCAN1"},
	{265, "J784S4_DEV_MCASP0"},
	{266, "J784S4_DEV_MCASP1"},
	{267, "J784S4_DEV_MCASP2"},
	{268, "J784S4_DEV_MCASP3"},
	{269, "J784S4_DEV_MCASP4"},
	{270, "J784S4_DEV_I2C0"},
	{271, "J784S4_DEV_I2C1"},
	{272, "J784S4_DEV_I2C2"},
	{273, "J784S4_DEV_I2C3"},
	{274, "J784S4_DEV_I2C4"},
	{275, "J784S4_DEV_I2C5"},
	{276, "J784S4_DEV_I2C6"},
	{277, "J784S4_DEV_MCU_I2C0"},
	{278, "J784S4_DEV_MCU_I2C1"},
	{279, "J784S4_DEV_WKUP_I2C0"},
	{280, "J784S4_DEV_NAVSS0"},
	{281, "J784S4_DEV_NAVSS0_BCDMA_0"},
	{282, "J784S4_DEV_NAVSS0_CPTS_0"},
	{283, "J784S4_DEV_NAVSS0_INTR_0"},
	{284, "J784S4_DEV_NAVSS0_MAILBOX1_0"},
	{285, "J784S4_DEV_NAVSS0_MAILBOX1_1"},
	{286, "J784S4_DEV_NAVSS0_MAILBOX1_2"},
	{287, "J784S4_DEV_NAVSS0_MAILBOX1_3"},
	{288, "J784S4_DEV_NAVSS0_MAILBOX1_4"},
	{289, "J784S4_DEV_NAVSS0_MAILBOX1_5"},
	{290, "J784S4_DEV_NAVSS0_MAILBOX1_6"},
	{291, "J784S4_DEV_NAVSS0_MAILBOX1_7"},
	{292, "J784S4_DEV_NAVSS0_MAILBOX1_8"},
	{293, "J784S4_DEV_NAVSS0_MAILBOX1_9"},
	{294, "J784S4_DEV_NAVSS0_MAILBOX1_10"},
	{295, "J784S4_DEV_NAVSS0_MAILBOX1_11"},
	{296, "J784S4_DEV_NAVSS0_MAILBOX_0"},
	{297, "J784S4_DEV_NAVSS0_MAILBOX_1"},
	{298, "J784S4_DEV_NAVSS0_MAILBOX_2"},
	{299, "J784S4_DEV_NAVSS0_MAILBOX_3"},
	{300, "J784S4_DEV_NAVSS0_MAILBOX_4"},
	{301, "J784S4_DEV_NAVSS0_MAILBOX_5"},
	{302, "J784S4_DEV_NAVSS0_MAILBOX_6"},
	{303, "J784S4_DEV_NAVSS0_MAILBOX_7"},
	{304, "J784S4_DEV_NAVSS0_MAILBOX_8"},
	{305, "J784S4_DEV_NAVSS0_MAILBOX_9"},
	{306, "J784S4_DEV_NAVSS0_MAILBOX_10"},
	{307, "J784S4_DEV_NAVSS0_MAILBOX_11"},
	{308, "J784S4_DEV_NAVSS0_MCRC_0"},
	{309, "J784S4_DEV_NAVSS0_MODSS"},
	{310, "J784S4_DEV_NAVSS0_MODSS_INTA_0"},
	{311, "J784S4_DEV_NAVSS0_MODSS_INTA_1"},
	{312, "J784S4_DEV_NAVSS0_PROXY_0"},
	{313, "J784S4_DEV_NAVSS0_PVU_0"},
	{314, "J784S4_DEV_NAVSS0_PVU_1"},
	{315, "J784S4_DEV_NAVSS0_RINGACC_0"},
	{316, "J784S4_DEV_NAVSS0_SPINLOCK_0"},
	{317, "J784S4_DEV_NAVSS0_TIMERMGR_0"},
	{318, "J784S4_DEV_NAVSS0_TIMERMGR_1"},
	{319, "J784S4_DEV_NAVSS0_UDMAP_0"},
	{320, "J784S4_DEV_NAVSS0_UDMASS"},
	{321, "J784S4_DEV_NAVSS0_UDMASS_INTA_0"},
	{322, "J784S4_DEV_NAVSS0_VIRTSS"},
	{323, "J784S4_DEV_MCU_NAVSS0"},
	{324, "J784S4_DEV_MCU_NAVSS0_INTR_ROUTER_0"},
	{325, "J784S4_DEV_MCU_NAVSS0_MCRC_0"},
	{326, "J784S4_DEV_MCU_NAVSS0_MODSS"},
	{327, "J784S4_DEV_MCU_NAVSS0_PROXY0"},
	{328, "J784S4_DEV_MCU_NAVSS0_RINGACC0"},
	{329, "J784S4_DEV_MCU_NAVSS0_UDMAP_0"},
	{330, "J784S4_DEV_MCU_NAVSS0_UDMASS"},
	{331, "J784S4_DEV_MCU_NAVSS0_UDMASS_INTA_0"},
	{332, "J784S4_DEV_PCIE0"},
	{333, "J784S4_DEV_PCIE1"},
	{334, "J784S4_DEV_PCIE2"},
	{335, "J784S4_DEV_PCIE3"},
	{336, "J784S4_DEV_R5FSS0"},
	{337, "J784S4_DEV_R5FSS1"},
	{338, "J784S4_DEV_R5FSS2"},
	{339, "J784S4_DEV_R5FSS0_CORE0"},
	{340, "J784S4_DEV_R5FSS0_CORE1"},
	{341, "J784S4_DEV_R5FSS1_CORE0"},
	{342, "J784S4_DEV_R5FSS1_CORE1"},
	{343, "J784S4_DEV_R5FSS2_CORE0"},
	{344, "J784S4_DEV_R5FSS2_CORE1"},
	{345, "J784S4_DEV_MCU_R5FSS0"},
	{346, "J784S4_DEV_MCU_R5FSS0_CORE0"},
	{347, "J784S4_DEV_MCU_R5FSS0_CORE1"},
	{348, "J784S4_DEV_RTI0"},
	{349, "J784S4_DEV_RTI1"},
	{350, "J784S4_DEV_RTI2"},
	{351, "J784S4_DEV_RTI3"},
	{352, "J784S4_DEV_RTI4"},
	{353, "J784S4_DEV_RTI5"},
	{354, "J784S4_DEV_RTI6"},
	{355, "J784S4_DEV_RTI7"},
	{356, "J784S4_DEV_RTI16"},
	{357, "J784S4_DEV_RTI17"},
	{358, "J784S4_DEV_RTI18"},
	{359, "J784S4_DEV_RTI19"},
	{360, "J784S4_DEV_RTI15"},
	{361, "J784S4_DEV_RTI28"},
	{362, "J784S4_DEV_RTI29"},
	{363, "J784S4_DEV_RTI30"},
	{364, "J784S4_DEV_RTI31"},
	{365, "J784S4_DEV_RTI32"},
	{366, "J784S4_DEV_RTI33"},
	{367, "J784S4_DEV_MCU_RTI0"},
	{368, "J784S4_DEV_MCU_RTI1"},
	{369, "J784S4_DEV_SA2_UL0"},
	{371, "J784S4_DEV_WKUP_HSM0"},
	{376, "J784S4_DEV_MCSPI0"},
	{377, "J784S4_DEV_MCSPI1"},
	{378, "J784S4_DEV_MCSPI2"},
	{379, "J784S4_DEV_MCSPI3"},
	{380, "J784S4_DEV_MCSPI4"},
	{381, "J784S4_DEV_MCSPI5"},
	{382, "J784S4_DEV_MCSPI6"},
	{383, "J784S4_DEV_MCSPI7"},
	{384, "J784S4_DEV_MCU_MCSPI0"},
	{385, "J784S4_DEV_MCU_MCSPI1"},
	{386, "J784S4_DEV_MCU_MCSPI2"},
	{387, "J784S4_DEV_UFS0"},
	{388, "J784S4_DEV_UART1"},
	{389, "J784S4_DEV_UART2"},
	{390, "J784S4_DEV_UART3"},
	{391, "J784S4_DEV_UART4"},
	{392, "J784S4_DEV_UART5"},
	{393, "J784S4_DEV_UART6"},
	{394, "J784S4_DEV_UART7"},
	{395, "J784S4_DEV_UART8"},
	{396, "J784S4_DEV_UART9"},
	{397, "J784S4_DEV_WKUP_UART0"},
	{398, "J784S4_DEV_USB0"},
	{399, "J784S4_DEV_VPAC0"},
	{400, "J784S4_DEV_VPAC1"},
	{401, "J784S4_DEV_VUSR_DUAL0"},
	{402, "J784S4_DEV_DPHY_TX0"},
	{403, "J784S4_DEV_DPHY_TX1"},
	{404, "J784S4_DEV_SERDES_10G0"},
	{405, "J784S4_DEV_SERDES_10G1"},
	{406, "J784S4_DEV_SERDES_10G2"},
	{407, "J784S4_DEV_SERDES_10G4"},
	{408, "J784S4_DEV_WKUPMCU2MAIN_VD"},
	{409, "J784S4_DEV_COMPUTE_CLUSTER0_DRU0"},
	{410, "J784S4_DEV_COMPUTE_CLUSTER0_DRU4"},
	{411, "J784S4_DEV_COMPUTE_CLUSTER0_DRU5"},
	{412, "J784S4_DEV_COMPUTE_CLUSTER0_DRU6"},
	{413, "J784S4_DEV_COMPUTE_CLUSTER0_DRU7"},
	{414, "J784S4_DEV_COMPUTE_CLUSTER0_DIVH4_DIVH_0"},
	{415, "J784S4_DEV_ACSPCIE0_BUFCLK_MUX"},
	{416, "J784S4_DEV_ACSPCIE1_BUFCLK_MUX"},
	{417, "J784S4_DEV_GLUELOGIC_ACSPCIE0_BUFFER"},
	{418, "J784S4_DEV_GLUELOGIC_ACSPCIE1_BUFFER"},
};
