/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */
/* eslint-disable max-len */

"use strict";

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND. SEE devtools/client/webconsole/test/README.md.
 */

const {
  parsePacketsWithFronts,
} = require("chrome://mochitests/content/browser/devtools/client/webconsole/test/browser/stub-generator-helpers.js");
const { prepareMessage } = require("resource://devtools/client/webconsole/utils/messages.js");
const {
  ConsoleMessage,
  NetworkEventMessage,
} = require("resource://devtools/client/webconsole/types.js");

const rawPackets = new Map();
rawPackets.set(`new Date(0)`, {
  "resultID": "1573832025018-0",
  "hasException": false,
  "input": "new Date(0)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj24",
      "class": "Date",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "timestamp": 0
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj24"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`asdf()`, {
  "resultID": "1573832025112-1",
  "errorMessageName": "JSMSG_NOT_DEFINED",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj26",
      "class": "ReferenceError",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "ReferenceError",
        "message": "asdf is not defined",
        "stack": "@debugger eval code:1:1\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 1
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj26"
  },
  "exceptionMessage": "ReferenceError: asdf is not defined",
  "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Not_defined?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "line": 1,
    "column": 1
  },
  "input": "asdf()",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`1 + @`, {
  "resultID": "1573832025117-2",
  "errorMessageName": "JSMSG_ILLEGAL_CHARACTER",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj27",
      "class": "SyntaxError",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "SyntaxError",
        "message": "illegal character U+0040",
        "stack": "",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 4
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj27"
  },
  "exceptionMessage": "SyntaxError: illegal character U+0040",
  "exceptionDocURL": "https://developer.mozilla.org/docs/Web/JavaScript/Reference/Errors/Illegal_character?utm_source=mozilla&utm_medium=firefox-console-errors&utm_campaign=default",
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "line": 1,
    "column": 4
  },
  "input": "1 + @",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`inspect({a: 1})`, {
  "resultID": "1573832025122-3",
  "hasException": false,
  "helperResult": {
    "type": "inspectObject",
    "input": "inspect({a: 1})",
    "object": {
      "_grip": {
        "type": "object",
        "actor": "server0.conn2.windowGlobal10737418243/obj29",
        "class": "Object",
        "ownPropertyLength": 1,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": false,
        "preview": {
          "kind": "Object",
          "ownProperties": {
            "a": {
              "configurable": true,
              "enumerable": true,
              "writable": true,
              "value": 1
            }
          },
          "ownPropertiesLength": 1
        }
      },
      "actorID": "server0.conn2.windowGlobal10737418243/obj29"
    },
    "forceExpandInConsole": false
  },
  "input": "inspect({a: 1})",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`undefined`, {
  "resultID": "1573832025127-5",
  "hasException": false,
  "input": "undefined",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`longString message Error`, {
  "resultID": "1573832025130-6",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj32",
      "class": "Error",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": {
          "_grip": {
            "type": "longString",
            "actor": "server0.conn2.windowGlobal10737418243/longstractor33",
            "length": 110000,
            "initial": "Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error"
          },
          "actorID": "server0.conn2.windowGlobal10737418243/longstractor33"
        },
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj32"
  },
  "exceptionMessage": {
    "_grip": {
      "type": "longString",
      "actor": "server0.conn2.windowGlobal10737418243/longstractor34",
      "length": 110007,
      "initial": "Error: Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Lon"
    },
    "actorID": "server0.conn2.windowGlobal10737418243/longstractor34"
  },
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"Long error \".repeat(10000))",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw ""`, {
  "resultID": "1573832025134-7",
  "exception": "",
  "exceptionMessage": "",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source24",
    "line": 1,
    "column": 1
  },
  "input": "throw \"\"",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw "tomato"`, {
  "resultID": "1573832025137-8",
  "exception": "tomato",
  "exceptionMessage": "tomato",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child1/source24",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child1/source24",
    "line": 1,
    "column": 1
  },
  "input": "throw \"tomato\"",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw false`, {
  "resultID": "1588154002962-9",
  "exception": false,
  "exceptionMessage": "false",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw false",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw 0`, {
  "resultID": "1588154002979-10",
  "exception": 0,
  "exceptionMessage": "0",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw 0",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw null`, {
  "resultID": "1588154003064-11",
  "exception": {
    "type": "null"
  },
  "exceptionMessage": "null",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw null",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw undefined`, {
  "resultID": "1588154003073-12",
  "exception": {
    "type": "undefined"
  },
  "exceptionMessage": "undefined",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw undefined",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Symbol`, {
  "resultID": "1588154003077-13",
  "exception": {
    "type": "symbol",
    "actor": "server0.conn2.windowGlobal10737418243/symbol42",
    "name": "potato"
  },
  "exceptionMessage": "Symbol(potato)",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source33",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source33",
    "line": 1,
    "column": 7
  },
  "input": "throw Symbol(\"potato\")",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Object`, {
  "resultID": "1588154003082-14",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj44",
      "class": "Object",
      "ownPropertyLength": 1,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "vegetable": {
            "configurable": true,
            "enumerable": true,
            "writable": true,
            "value": "cucumber"
          }
        },
        "ownPropertiesLength": 1
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj44"
  },
  "exceptionMessage": "[object Object]",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source26",
      "lineNumber": 1,
      "columnNumber": 1,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source26",
    "line": 1,
    "column": 1
  },
  "input": "throw {vegetable: \"cucumber\"}",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object`, {
  "resultID": "1588154003093-15",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj46",
      "class": "Error",
      "ownPropertyLength": 4,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "pumpkin",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj46"
  },
  "exceptionMessage": "Error: pumpkin",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source33",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source33",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"pumpkin\")",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with custom name`, {
  "resultID": "1588154003097-16",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj48",
      "class": "Error",
      "ownPropertyLength": 6,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "JuicyError",
        "message": "pineapple",
        "stack": "@debugger eval code:2:15\n",
        "fileName": "debugger eval code",
        "lineNumber": 2,
        "columnNumber": 15
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj48"
  },
  "exceptionMessage": "JuicyError: pineapple",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child2/source49",
      "lineNumber": 5,
      "columnNumber": 5,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child2/source49",
    "line": 5,
    "column": 5
  },
  "input": "\n    var err = new Error(\"pineapple\");\n    err.name = \"JuicyError\";\n    err.flavor = \"delicious\";\n    throw err;\n  ",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with error cause`, {
  "resultID": "1621589071246-16",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj50",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "something went wrong",
        "stack": "@debugger eval code:3:15\n",
        "fileName": "debugger eval code",
        "lineNumber": 3,
        "columnNumber": 15,
        "cause": {
          "type": "object",
          "actor": "server0.conn2.windowGlobal10737418243/obj51",
          "class": "SyntaxError",
          "ownPropertyLength": 4,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": true,
          "preview": {
            "kind": "Error",
            "name": "SyntaxError",
            "message": "original error",
            "stack": "@debugger eval code:2:25\n",
            "fileName": "debugger eval code",
            "lineNumber": 2,
            "columnNumber": 25
          }
        }
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj50"
  },
  "exceptionMessage": "Error: something went wrong",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source49",
      "lineNumber": 6,
      "columnNumber": 5,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source49",
    "line": 6,
    "column": 5
  },
  "input": "\n    var originalError = new SyntaxError(\"original error\")\n    var err = new Error(\"something went wrong\", {\n      cause: originalError\n    });\n    throw err;\n  ",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with cause chain`, {
  "resultID": "1621589071248-17",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj53",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "err-d",
        "stack": "@debugger eval code:5:16\n",
        "fileName": "debugger eval code",
        "lineNumber": 5,
        "columnNumber": 16,
        "cause": {
          "type": "object",
          "actor": "server0.conn2.windowGlobal10737418243/obj54",
          "class": "Error",
          "ownPropertyLength": 5,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": true,
          "preview": {
            "kind": "Error",
            "name": "Error",
            "message": "err-c",
            "stack": "@debugger eval code:4:16\n",
            "fileName": "debugger eval code",
            "lineNumber": 4,
            "columnNumber": 16,
            "cause": {
              "type": "object",
              "actor": "server0.conn2.windowGlobal10737418243/obj55",
              "class": "Error",
              "ownPropertyLength": 5,
              "extensible": true,
              "frozen": false,
              "sealed": false,
              "isError": true,
              "preview": {
                "kind": "Error",
                "name": "Error",
                "message": "err-b",
                "stack": "@debugger eval code:3:16\n",
                "fileName": "debugger eval code",
                "lineNumber": 3,
                "columnNumber": 16,
                "cause": {
                  "type": "object",
                  "actor": "server0.conn2.windowGlobal10737418243/obj56",
                  "class": "Error",
                  "ownPropertyLength": 4,
                  "extensible": true,
                  "frozen": false,
                  "sealed": false,
                  "isError": true,
                  "preview": {
                    "kind": "Error",
                    "name": "Error",
                    "message": "err-a",
                    "stack": "@debugger eval code:2:16\n",
                    "fileName": "debugger eval code",
                    "lineNumber": 2,
                    "columnNumber": 16
                  }
                }
              }
            }
          }
        }
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj53"
  },
  "exceptionMessage": "Error: err-d",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source49",
      "lineNumber": 6,
      "columnNumber": 5,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source49",
    "line": 6,
    "column": 5
  },
  "input": "\n    var errA = new Error(\"err-a\")\n    var errB = new Error(\"err-b\", { cause: errA })\n    var errC = new Error(\"err-c\", { cause: errB })\n    var errD = new Error(\"err-d\", { cause: errC })\n    throw errD;\n  ",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with cyclical cause chain`, {
  "resultID": "1621589071250-18",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj58",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "err-y",
        "stack": "@debugger eval code:3:16\n",
        "fileName": "debugger eval code",
        "lineNumber": 3,
        "columnNumber": 16,
        "cause": {
          "type": "object",
          "actor": "server0.conn2.windowGlobal10737418243/obj59",
          "class": "Error",
          "ownPropertyLength": 5,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": true,
          "preview": {
            "kind": "Error",
            "name": "Error",
            "message": "err-x",
            "stack": "@debugger eval code:2:16\n",
            "fileName": "debugger eval code",
            "lineNumber": 2,
            "columnNumber": 16,
            "cause": {
              "type": "undefined"
            }
          }
        }
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj58"
  },
  "exceptionMessage": "Error: err-y",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source57",
      "lineNumber": 4,
      "columnNumber": 5,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source57",
    "line": 4,
    "column": 5
  },
  "input": "\n    var errX = new Error(\"err-x\", { cause: errY})\n    var errY = new Error(\"err-y\", { cause: errX })\n    throw errY;\n  ",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with falsy cause`, {
  "resultID": "1621589071252-19",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj61",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "false cause",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7,
        "cause": false
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj61"
  },
  "exceptionMessage": "Error: false cause",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"false cause\", { cause: false });",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with null cause`, {
  "resultID": "1622039251647-20",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj63",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "null cause",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7,
        "cause": {
          "type": "null"
        }
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj63"
  },
  "exceptionMessage": "Error: null cause",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child4/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child4/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"null cause\", { cause: null });",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with undefined cause`, {
  "resultID": "1622039251649-21",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj65",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "undefined cause",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7,
        "cause": {
          "type": "undefined"
        }
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj65"
  },
  "exceptionMessage": "Error: undefined cause",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn2.child4/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn2.child4/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"undefined cause\", { cause: undefined });",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with number cause`, {
  "resultID": "1621589071253-20",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj67",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "number cause",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7,
        "cause": 0
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj67"
  },
  "exceptionMessage": "Error: number cause",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"number cause\", { cause: 0 });",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with string cause`, {
  "resultID": "1621589071255-21",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj69",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "string cause",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7,
        "cause": "cause message"
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj69"
  },
  "exceptionMessage": "Error: string cause",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"string cause\", { cause: \"cause message\" });",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval throw Error Object with object cause`, {
  "resultID": "1621589071256-22",
  "exception": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj71",
      "class": "Error",
      "ownPropertyLength": 5,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": true,
      "preview": {
        "kind": "Error",
        "name": "Error",
        "message": "object cause",
        "stack": "@debugger eval code:1:7\n",
        "fileName": "debugger eval code",
        "lineNumber": 1,
        "columnNumber": 7,
        "cause": {
          "type": "object",
          "actor": "server0.conn2.windowGlobal10737418243/obj72",
          "class": "Object",
          "ownPropertyLength": 2,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false
        }
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj71"
  },
  "exceptionMessage": "Error: object cause",
  "exceptionStack": [
    {
      "filename": "debugger eval code",
      "sourceId": "server0.conn0.child4/source31",
      "lineNumber": 1,
      "columnNumber": 7,
      "functionName": null
    }
  ],
  "hasException": true,
  "frame": {
    "source": "debugger eval code",
    "sourceId": "server0.conn0.child4/source31",
    "line": 1,
    "column": 7
  },
  "input": "throw new Error(\"object cause\", { cause: { code: 234, message: \"ERR_234\"} });",
  "result": {
    "type": "undefined"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval pending promise`, {
  "resultID": "1609858965386-17",
  "hasException": false,
  "input": "new Promise(() => {})",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj74",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "pending"
          }
        },
        "ownPropertiesLength": 1
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj74"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval Promise.resolve`, {
  "resultID": "1609858965388-18",
  "hasException": false,
  "input": "Promise.resolve(123)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj76",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "fulfilled"
          },
          "<value>": {
            "value": 123
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj76"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval Promise.reject`, {
  "resultID": "1609858965389-19",
  "hasException": false,
  "input": "Promise.reject(\"ouch\")",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj78",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "rejected"
          },
          "<reason>": {
            "value": "ouch"
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj78"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval resolved promise`, {
  "resultID": "1609858965393-20",
  "hasException": false,
  "input": "Promise.resolve().then(() => 246)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj80",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "fulfilled"
          },
          "<value>": {
            "value": 246
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj80"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval rejected promise`, {
  "resultID": "1609858965397-21",
  "hasException": false,
  "input": "Promise.resolve().then(() => a.b.c)",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj82",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "rejected"
          },
          "<reason>": {
            "value": {
              "type": "object",
              "actor": "server0.conn2.windowGlobal10737418243/obj83",
              "class": "ReferenceError",
              "ownPropertyLength": 4,
              "extensible": true,
              "frozen": false,
              "sealed": false,
              "isError": true,
              "preview": {
                "kind": "Error",
                "name": "ReferenceError",
                "message": "a is not defined",
                "stack": "@debugger eval code:1:30\npromise callback*@debugger eval code:1:19\n",
                "fileName": "debugger eval code",
                "lineNumber": 1,
                "columnNumber": 30
              }
            }
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj82"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});

rawPackets.set(`eval rejected promise with Error`, {
  "resultID": "1621589071278-28",
  "hasException": false,
  "input": "Promise.resolve().then(() => {\n      try {\n        a.b.c\n      } catch(e) {\n        throw new Error(\"something went wrong\", { cause: e })\n      }\n    })",
  "result": {
    "_grip": {
      "type": "object",
      "actor": "server0.conn2.windowGlobal10737418243/obj86",
      "class": "Promise",
      "ownPropertyLength": 0,
      "extensible": true,
      "frozen": false,
      "sealed": false,
      "isError": false,
      "preview": {
        "kind": "Object",
        "ownProperties": {
          "<state>": {
            "value": "rejected"
          },
          "<reason>": {
            "value": {
              "type": "object",
              "actor": "server0.conn2.windowGlobal10737418243/obj87",
              "class": "Error",
              "ownPropertyLength": 5,
              "extensible": true,
              "frozen": false,
              "sealed": false,
              "isError": true,
              "preview": {
                "kind": "Error",
                "name": "Error",
                "message": "something went wrong",
                "stack": "@debugger eval code:5:15\npromise callback*@debugger eval code:1:19\n",
                "fileName": "debugger eval code",
                "lineNumber": 5,
                "columnNumber": 15,
                "cause": {
                  "type": "object",
                  "actor": "server0.conn2.windowGlobal10737418243/obj88",
                  "class": "ReferenceError",
                  "ownPropertyLength": 4,
                  "extensible": true,
                  "frozen": false,
                  "sealed": false,
                  "isError": true,
                  "preview": {
                    "kind": "Error",
                    "name": "ReferenceError",
                    "message": "a is not defined",
                    "stack": "@debugger eval code:3:9\npromise callback*@debugger eval code:1:19\n",
                    "fileName": "debugger eval code",
                    "lineNumber": 3,
                    "columnNumber": 9
                  }
                }
              }
            }
          }
        },
        "ownPropertiesLength": 2
      }
    },
    "actorID": "server0.conn2.windowGlobal10737418243/obj86"
  },
  "startTime": 1572867483805,
  "timestamp": 1572867483805
});


const stubPackets = parsePacketsWithFronts(rawPackets);

const stubPreparedMessages = new Map();
for (const [key, packet] of Array.from(stubPackets.entries())) {
  const transformedPacket = prepareMessage(packet, {
    getNextId: () => "1",
  });
  const message = ConsoleMessage(transformedPacket);
  stubPreparedMessages.set(key, message);
}

module.exports = {
  rawPackets,
  stubPreparedMessages,
  stubPackets,
};
