/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_WMJACK_X11_H
#define DTK_WMJACK_X11_H

#ifdef __cplusplus
extern "C" {
#endif

#include "dtk_wmjack_p.h"

/**
 * @brief init x11 display content
 */
int xInitWmJack();

/**
 * @brief destory x11 display content
 */
void xDestoryWmJack();

/**
 * @brief Maximize Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int xMaximizeWindow(WindowId wid);

/**
 * @brief Minimize Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int xMinimizeWindow(WindowId wid);

/**
 * @brief Restore Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int xRestoreWindow(WindowId wid);

/**
 * @brief Get Window Title.
 * @param wid: window ID
 * @return -1 failure, otherwise success
 */
char *xGetWindowText(WindowId wid);

/**
 * @brief Get Window Size.
 * @param wid: window ID
 * @return x:-1,y:-1 failure, otherwise success
 */
Size xGetWindowSize(WindowId wid);

/**
 * @brief Get Window Position.
 * @param wid: window ID
 * @return w:-1,h:-1 failure, otherwise success
 */
Position xGetWindowPosition(WindowId wid);

/**
 * @brief Get Active Window ID.
 * @return 0 failure, otherwise success
 */
WindowId xGetActiveWindowID();

/**
 * @brief Get Desktop Window ID.
 * @return 0 failure, otherwise success
 */
WindowId xGetDesktopWindowID();

/**
 * @brief Get Window Title.
 * @param wid: window ID
 * @param pChildIDs: child data
 * @return -1 failure, otherwise success
 */
int xGetWindowChildren(WindowId wid, WindowId **pChildIDs);

/**
 * @brief Get Mouse Position.
 * @return w:-1,h:-1 failure, otherwise success
 */
Position xGetPointerPosition();

/**
 * @brief free data.
 * @param windownlist: windowlist
 */
void xFreeWindowList(WindowId *windownlist);

/**
 * @brief get all windows states
 */
struct dtk_array *xGetAllWindowStates();

/**
 * @brief get Window State
 * @param windowId window id
 * @return window state
 */
WindowState *xGetWindowState(WindowId wid);

/**
 * @brief Get Window PID.
 * @param wid: window ID
 * @return -1 failure, otherwise success
 */
int xGetWindowPID(WindowId wid);

WindowId xGetWindowFromPoint();

void xShowSplitMenu(int x, int y, int width, int height, WindowId wid);

void xHideSplitMenu(bool delay, WindowId wid);

char *xGetRendererString();

WindowState xGetSpecificWindowState(uint32_t wid);

int xGetAllWindowStatesList(WindowState **states);

#ifdef __cplusplus
}
#endif

#endif