/* SPDX-License-Identifier: GPL-2.0-only */

#include <mipi/panel.h>

struct panel_serializable_data STA_ER88577 = {
	.edid = {
		.ascii_string = "ER88577",
		.manufacturer_name = "STA",
		.panel_bits_per_color = 8,
		.panel_bits_per_pixel = 24,
		.mode = {
			.pixel_clock = 77380,
			.lvds_dual_channel = 0,
			.refresh = 60,
			.ha = 800, .hbl = 90, .hso = 30, .hspw = 30,
			.va = 1280, .vbl = 42, .vso = 30, .vspw = 4,
			.phsync = '-', .pvsync = '-',
			.x_mm = 135, .y_mm = 216,
		},
	},
	.init = {
		PANEL_DELAY(50),
		PANEL_DCS(0xE0, 0xAB, 0xBA),
		PANEL_DCS(0xE1, 0xBA, 0xAB),
		PANEL_DCS(0xB1, 0x10, 0x01, 0x47, 0xFF),
		PANEL_DCS(0xB2, 0x0C, 0x14, 0x04, 0x50, 0x50, 0x14),
		PANEL_DCS(0xB3, 0x56, 0x53, 0x00),
		PANEL_DCS(0xB4, 0x33, 0x30, 0x04),
		PANEL_DCS(0xB6, 0xB0, 0x00, 0x00, 0x10, 0x00, 0x10, 0x00),
		PANEL_DCS(0xB8, 0x05, 0x12, 0x29, 0x49, 0x48),
		PANEL_DCS(0xB9, 0x7C, 0x59, 0x53, 0x45, 0x43, 0x32, 0x37, 0x1F, 0x37,
			0x39, 0x3A, 0x5A, 0x48, 0x50, 0x43, 0x40, 0x30, 0x20, 0x06, 0x7C,
			0x59, 0x53, 0x45, 0x43, 0x32, 0x37, 0x1F, 0x37, 0x39, 0x3A, 0x5A,
			0x48, 0x50, 0x43, 0x40, 0x30, 0x20, 0x06),
		PANEL_DCS(0xC0, 0xFF, 0x87, 0x12, 0x34, 0x44, 0x44, 0x44, 0x44, 0x98,
			0x04, 0x98, 0x04, 0x0F, 0x00, 0x00, 0xC1),
		PANEL_DCS(0xC1, 0x54, 0x94, 0x02, 0x85, 0x9F, 0x00, 0x6F, 0x00, 0x54,
			0x00),
		PANEL_DCS(0xC2, 0x17, 0x09, 0x08, 0x89, 0x08, 0x11, 0x22, 0x20, 0x44,
			0xFF, 0x18, 0x00),
		PANEL_DCS(0xC3, 0x86, 0x46, 0x05, 0x05, 0x1C, 0x1C, 0x1D, 0x1D, 0x02,
			0x1F, 0x1F, 0x1E, 0x1E, 0x0F, 0x0F, 0x0D, 0x0D, 0x13, 0x13, 0x11,
			0x11, 0x00),
		PANEL_DCS(0xC4, 0x07, 0x07, 0x04, 0x04, 0x1C, 0x1C, 0x1D, 0x1D, 0x02,
			0x1F, 0x1F, 0x1E, 0x1E, 0x0E, 0x0E, 0x0C, 0x0C, 0x12, 0x12, 0x10,
			0x10, 0x00),
		PANEL_DCS(0xC8, 0x21, 0x00, 0x31, 0x42, 0x34, 0x16),
		PANEL_DCS(0xCA, 0xCB, 0x43),
		PANEL_DCS(0xCD, 0x0E, 0x4B, 0x4B, 0x20, 0x19, 0x6B, 0x06, 0xB3),
		PANEL_DCS(0xD2, 0xE3, 0x2B, 0x38, 0x08),
		PANEL_DCS(0xD4, 0x00, 0x01, 0x00, 0x0E, 0x04, 0x44, 0x08, 0x10, 0x00,
			0x00, 0x00),
		PANEL_DCS(0xE6, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF),
		PANEL_DCS(0xF0, 0x12, 0x03, 0x20, 0x00, 0xFF),
		PANEL_DCS(0xF3, 0x00),
		PANEL_DCS(0x11),
		PANEL_DELAY(120),
		PANEL_DCS(0x29),
		PANEL_DELAY(20),
		PANEL_END,
	},
};
