#ifndef ENCODING
# include "cp1251.enc"
# define ENCODING cp1251
#endif
!     bg_bds-ENCODING.map is Bulgarian keyboard translation table for Linux
!     console driver.  The arrangement of the Cyrillic letters is according to 
!     the State Standard of Bulgaria (BDS).  The encoding of this table is
!     ENCODING  The AltGr (RightAlt) key switches between Cyrillic and Latin
!     letters.  On extended keyboards with 104 keys both window keys and the
!     System key temporary switch to Cyrillic letters.
!
!
!
/* This file should be preprocessed with cpp */

#ifndef numerosign
# define numerosign N
#endif
#ifndef sectionsign
# define sectionsign cyr_pe
#endif
#ifndef emdash
# define emdash minus
#endif

#define LEFT_SHIFT              Shift
#define LEFT_CONTROL            Control
#define LEFT_ALT                Alt
#define LEFT_WINDOW             AltGr
#define RIGHT_SHIFT             Shift
#define RIGHT_CONTROL           Control
#define RIGHT_ALT               AltGr_Lock
#define RIGHT_WINDOW            AltGr
#define SYSTEM_MENU             AltGr

#define CC(n, a, b)             keycode n = a a a a b b b b Meta_##a Meta_##a Meta_##a Meta_##a Meta_##b Meta_##b Meta_##b Meta_##b
#define FUNC(n, a, b)           keycode n = F##a F##b F##a F##b F##a F##b F##a F##b Console_##a Console_##a Console_##a Console_##a Console_##a Console_##a Console_##a Console_##a
#define LLRR(n, a, b, c, d)     keycode n = +a +b +c +d Control_##a Control_##a Control_##a Control_##a Meta_##a Meta_##b Meta_##a Meta_##b Meta_Control_##a Meta_Control_##a Meta_Control_##a Meta_Control_##a
#define NONE(n)                 Keycode n =
#define PPPPC(n, a, b, c, d, e) keycode n = a b c d e e e e Meta_##a Meta_##b Meta_##a Meta_##b Meta_##e Meta_##e Meta_##e Meta_##e
#define LLPPC(n, a, b, c, d) keycode n = +a +b c d Control_##a Control_##a Control_##a Control_##a Meta_##a Meta_##b Meta_##a Meta_##b Meta_Control_##a Meta_Control_##a Meta_Control_##a Meta_Control_##a
#define PPRRC(n, a, b, c, d, e) keycode n = a b +c +d e e e e Meta_##a Meta_##b Meta_##a Meta_##b Meta_##e Meta_##e Meta_##e Meta_##e
#define SPEC(n, a)              keycode n = a

#define Meta_VoidSymbol         VoidSymbol
#define Meta_Return             Meta_Control_m
#define Meta_Linefeed           Meta_Control_j
#define Meta_no_break_space     Meta_nul

CC(1, Escape, Escape)
!
PPPPC(2, one, exclam, one, exclam, VoidSymbol)
PPPPC(3, two, at, two, question, nul)
PPPPC(4, three, numbersign, three, plus, Escape)
PPPPC(5, four, dollar, four, quotedbl, Control_backslash)
PPPPC(6, five, percent, five, percent, Control_bracketright)
PPPPC(7, six, asciicircum, six, equal, Control_asciicircum)
PPPPC(8, seven, ampersand, seven, colon, Control_underscore)
PPPPC(9, eight, asterisk, eight, slash, Delete)
PPPPC(10, nine, parenleft, nine, emdash, VoidSymbol)
PPPPC(11, zero, parenright, zero, nomerosign, VoidSymbol)
PPPPC(12, minus, underscore, minus, I, Control_underscore)
PPPPC(13, equal, plus, period, V, VoidSymbol)
!
CC(14, Delete, BackSpace)
CC(15, Tab, Tab)
!
LLPPC(16, q, Q, comma, cyr_yeru)
!
LLRR(17, w, W, cyr_u, CYR_U)
LLRR(18, e, E, cyr_ie, CYR_IE)
LLRR(19, r, R, cyr_i, CYR_I)
LLRR(20, t, T, cyr_sha, CYR_SHA)
LLRR(21, y, Y, cyr_shcha, CYR_SHCHA)
LLRR(22, u, U, cyr_ka, CYR_KA)
LLRR(23, i, I, cyr_es, CYR_ES)
LLRR(24, o, O, cyr_de, CYR_DE)
LLRR(25, p, P, cyr_ze, CYR_ZE)
!
PPRRC(26, bracketleft, braceleft, cyr_tse, CYR_TSE, Escape)
PPPPC(27, bracketright, braceright, semicolon, sectionsign, Control_bracketright)
!
CC(28, Return, Return)
!
SPEC(29, LEFT_CONTROL)
!
LLRR(30, a, A, cyr_soft_sign, CYR_SOFT_SIGN)
LLRR(31, s, S, cyr_ya, CYR_YA)
LLRR(32, d, D, cyr_a, CYR_A)
LLRR(33, f, F, cyr_o, CYR_O)
LLRR(34, g, G, cyr_zhe, CYR_ZHE)
LLRR(35, h, H, cyr_ghe, CYR_GHE)
LLRR(36, j, J, cyr_te, CYR_TE)
LLRR(37, k, K, cyr_en, CYR_EN)
LLRR(38, l, L, cyr_ve, CYR_VE)
!
PPRRC(39, semicolon, colon, cyr_em, CYR_EM, VoidSymbol)
PPRRC(40, apostrophe, quotedbl, cyr_che, CYR_CHE, Control_g)
PPPPC(41, grave, asciitilde, CYR_YERU, CYR_YERU, nul)
!
SPEC(42, LEFT_SHIFT)
!
PPPPC(43, backslash, bar, parenright, parenleft, Control_backslash)
!
LLRR(44, z, Z, cyr_yu, CYR_YU)
LLRR(45, x, X, cyr_short_i, CYR_SHORT_I)
LLRR(46, c, C, cyr_hard_sign, CYR_HARD_SIGN)
LLRR(47, v, V, cyr_e, CYR_E)
LLRR(48, b, B, cyr_ef, CYR_EF)
LLRR(49, n, N, cyr_ha, CYR_HA)
LLRR(50, m, M, cyr_pe, CYR_PE)
!
PPRRC(51, comma, less, cyr_er, CYR_ER, VoidSymbol)
!
PPRRC(52, period, greater, cyr_el, CYR_EL, VoidSymbol)
        control         keycode 52 = Compose
        control altgr   keycode 52 = Compose
!
PPRRC(53, slash, question, cyr_be, CYR_BE, Delete)
!
SPEC(54, RIGHT_SHIFT)
!
SPEC(55, KP_Multiply)
!
SPEC(56, LEFT_ALT)
!
CC(57, space, nul)
!
SPEC(58, Caps_Lock)
!
FUNC(59, 1, 11)
FUNC(60, 2, 12)
FUNC(61, 3, 13)
FUNC(62, 4, 14)
FUNC(63, 5, 15)
FUNC(64, 6, 16)
FUNC(65, 7, 17)
FUNC(66, 8, 18)
FUNC(67, 9, 19)
FUNC(68, 10, 20)
!
SPEC(69, Num_Lock)
!
SPEC(70, Scroll_Lock)
        shift           keycode 70 = Show_Memory
        shift   altgr   keycode 70 = Show_Memory
        control         keycode 70 = Show_State
        control altgr   keycode 70 = Show_State
        alt             keycode 70 = Show_Registers
        alt     altgr   keycode 70 = Show_Registers
!
SPEC(71, KP_7)
        alt         keycode 71 = Ascii_7
        alt altgr   keycode 71 = Ascii_7
!
SPEC(72, KP_8)
        alt         keycode 72 = Ascii_8
        alt altgr   keycode 72 = Ascii_8
!
SPEC(73, KP_9)
        alt         keycode 73 = Ascii_9
        alt altgr   keycode 73 = Ascii_9
!
SPEC(74, KP_Subtract)
!
SPEC(75, KP_4)
        alt         keycode 75 = Ascii_4
        alt altgr   keycode 75 = Ascii_4
!
SPEC(76, KP_5)
        alt         keycode 76 = Ascii_5
        alt altgr   keycode 76 = Ascii_5
!
SPEC(77, KP_6)
        alt         keycode 77 = Ascii_6
        alt altgr   keycode 77 = Ascii_6
!
SPEC(78, KP_Add)
!
SPEC(79, KP_1)
        alt         keycode 79 = Ascii_1
        alt altgr   keycode 79 = Ascii_1
!
SPEC(80, KP_2)
        alt         keycode 80 = Ascii_2
        alt altgr   keycode 80 = Ascii_2
!
SPEC(81, KP_3)
        alt         keycode 81 = Ascii_3
        alt altgr   keycode 81 = Ascii_3
!
SPEC(82, KP_0)
        alt         keycode 82 = Ascii_0
        alt altgr   keycode 82 = Ascii_0
!
SPEC(83, KP_Period)
        control alt             keycode 83 = Boot
        control alt     altgr   keycode 83 = Boot
!
SPEC(84, Last_Console)
!
NONE(85)
!
PPPPC(86, less, greater, less, greater, VoidSymbol)
!
FUNC(87, 11, 11)
FUNC(88, 12, 12)
!
NONE(89)
NONE(90)
NONE(91)
NONE(92)
NONE(93)
NONE(94)
NONE(95)
!
SPEC(96, KP_Enter)
!
SPEC(97, RIGHT_CONTROL)
!
SPEC(98, KP_Divide)
!
CC(99, Control_backslash, Control_backslash)
!
SPEC(100, RIGHT_ALT)
!
SPEC(101, Break)
SPEC(102, Home)
!
SPEC(103, Up)
!
SPEC(104, PageUp)
        shift           keycode 104 = Scroll_Backward
        shift   altgr   keycode 104 = Scroll_Backward
!
SPEC(105, Left)
        alt         keycode 105 = Decr_Console
        alt altgr   keycode 105 = Decr_Console
!
SPEC(106, Right)
        alt         keycode 106 = Incr_Console
        alt altgr   keycode 106 = Incr_Console
!
SPEC(107, End)
SPEC(108, Down)
!
SPEC(109, PageDown)
        shift           keycode 109 = Scroll_Forward
        shift   altgr   keycode 109 = Scroll_Forward
!
SPEC(110, Insert)
!
SPEC(111, Remove)
        control alt         keycode 111 = Boot
        control alt altgr   keycode 111 = Boot
!
SPEC(112, Macro)
SPEC(113, F13)
SPEC(114, F14)
SPEC(115, Help)
SPEC(116, Do)
SPEC(117, F17)
SPEC(118, KP_MinPlus)
SPEC(119, Pause)
!
NONE(120)
NONE(121)
NONE(122)
NONE(123)
NONE(124)
!
SPEC(125, LEFT_WINDOW)
SPEC(126, RIGHT_WINDOW)
SPEC(127, SYSTEM_MENU)
!
string F1 = "\033[[A"
string F2 = "\033[[B"
string F3 = "\033[[C"
string F4 = "\033[[D"
string F5 = "\033[[E"
string F6 = "\033[17~"
string F7 = "\033[18~"
string F8 = "\033[19~"
string F9 = "\033[20~"
string F10 = "\033[21~"
string F11 = "\033[23~"
string F12 = "\033[24~"
string F13 = "\033[25~"
string F14 = "\033[26~"
string F15 = "\033[28~"
string F16 = "\033[29~"
string F17 = "\033[31~"
string F18 = "\033[32~"
string F19 = "\033[33~"
string F20 = "\033[34~"
string Find = "\033[1~"
string Insert = "\033[2~"
string Remove = "\033[3~"
string Select = "\033[4~"
string Prior = "\033[5~"
string Next = "\033[6~"
string Macro = "\033[M"
string Pause = "\033[P"
