/* 
 
Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package rene.zirkel.constructors;

// file: Cicle3Constructor.java

import eric.JSelectPopup;
import java.awt.event.MouseEvent;

import rene.gui.Global;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.gui.Global;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.AngleObject;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.FixedAngleObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class AngleConstructor extends ObjectConstructor {
    PointObject P1 = null, P2 = null, P3 = null;
    boolean Fixed = false;

    public AngleConstructor(final boolean fixed) {
	Fixed = fixed;
    }

    public AngleConstructor() {
    	this(false);
    }

    FixedAngleObject A;
    ConstructionObject O;
    boolean ShowsValue, Fix;
    int Moved, ex, ey;

    @Override
    public void mousePressed(final MouseEvent e, final ZirkelCanvas zc){
	if (!zc.Visual)
	    return;
	Fix = e.isShiftDown() || Fixed;
	ex = e.getX(); ey = e.getY();
	ConstructionObject obj = null;

	if(!Fix || !waitForLastPoint()){
	    obj = select(e.getX(), e.getY(), zc, e.isAltDown());
	    if(obj!=null){
		setConstructionObject(obj, zc);
	    } else {
		Dragging = false;
	    }
	} else { //third clic for a fixed angle, obj=null but whatever
	    setConstructionObject(obj, zc);
	}
    }

    @Override
    public void setConstructionObject(ConstructionObject obj, ZirkelCanvas zc) {
	// Il y a eu ambiguité et la méthode est forcément appelée par le
        // popupmenu de sélection :
        if ((JSelectPopup.isCallerObject())&&(obj instanceof PointonObject)) {
            int x=JSelectPopup.getMouseX();
            int y=JSelectPopup.getMouseY();
            PointObject o=new PointObject(zc.getConstruction(), zc.x(x), zc.y(y), obj);
            o.setUseAlpha(true);
            zc.addObject(o);
            zc.validate();
            o.setDefaults();
            zc.repaint();
            o.edit(zc, false, false);
            obj=o;
        }

	if(P1==null){
	    if(obj instanceof PointObject){
		P1=(PointObject) obj;
                P1.setSelected(true);
                zc.repaint();
	    }
	    showStatus(zc);
	} else if(P2==null){
	    if(obj instanceof PointObject){
		P2=(PointObject) obj;
                P2.setSelected(true);
                zc.repaint();
	    }
	    showStatus(zc);
	} else {
	    if(!Fix){
		if(obj instanceof PointObject){
		    P3 = (PointObject) obj;
		    if(P3==P1 || P3==P2){
			P3=null;
			return;
		    }
		    final AngleObject a = new AngleObject(zc.getConstruction(), P1, P2, P3);
		    zc.addObject(a);
		    a.setDefaults();
		    if (P3.moveable() && !P3.isPointOn() && zc.isNewPoint()) {
			ShowsValue = a.showValue();
			if (Global.getParameter("options.movefixname", true))
			    a.setShowValue(true);
			O = a;
			Dragging = true;
			a.validate();
			zc.repaint();
		    } else {
			Dragging = false;
			//P1 = P2 = P3 = null;
			reset(zc);
			zc.validate();
			zc.repaint();
		    }
		}
	    } else {
		final FixedAngleObject a = new FixedAngleObject(zc.getConstruction(), P1, P2, zc.x(ex), zc.y(ey));
		zc.addObject(a);
		a.setDefaults();
		a.init(zc.getConstruction(), zc.x(ex), zc.y(ey));
		Moved = 0;
		Dragging = true;
		ShowsValue = a.showValue();
		if (Global.getParameter("options.movefixname", true))
		    a.setShowValue(true);
		O = A = a;
		P3 = null;
		zc.repaint();
	    }
	}
    }

	@Override
	public boolean waitForLastPoint() {
		return P1 != null && P2 != null;
	}

	@Override
	public boolean waitForPoint() {
		return !Fixed || (P1 == null || P2 == null);
	}

	@Override
	public void finishConstruction(final MouseEvent e, final ZirkelCanvas zc) {
		if (!Fixed) {
			P3 = select(e.getX(), e.getY(), zc, e.isAltDown());
			if (P3 != null) {
				final AngleObject a = new AngleObject(zc.getConstruction(), P1,
						P2, P3);
				zc.addObject(a);
				a.setDefaults();
			}
			zc.repaint();
			P3 = null;
		} else {
			final FixedAngleObject a = new FixedAngleObject(zc
					.getConstruction(), P1, P2, zc.x(e.getX()), zc.y(e.getY()));
			zc.addObject(a);
			a.setDefaults();
			a.init(zc.getConstruction(), zc.x(e.getX()), zc.y(e.getY()));
			zc.setPreviewObject(a);
			zc.repaint();
		}
	}

	@Override
	public void mouseDragged(final MouseEvent e, final ZirkelCanvas zc) {
		if (!Dragging)
			return;
		Moved++;
		if (P3 == null) {
			A.init(zc.getConstruction(), zc.x(e.getX()), zc.y(e.getY()));
			if (A instanceof FixedAngleObject)
				((FixedAngleObject) A).setDragable(Moved > 5);
		} else {
			P3.move(zc.x(e.getX()), zc.y(e.getY()));
			zc.validate();
		}
		zc.repaint();
	}

	@Override
	public void mouseReleased(final MouseEvent e, final ZirkelCanvas zc) {
		if (!Dragging)
			return;
		Dragging = false;
		O.setShowValue(ShowsValue);
		zc.repaint();
		if (P3 == null) {
			zc.clearSelected();
			A.round();
			if (Moved < 5) {
				A.edit(zc, true, true);
				if (A instanceof FixedAngleObject
						&& ((FixedAngleObject) A).isEditAborted()) {
					zc.delete(A);
					reset(zc);
					return;
				}
			}
			A.validate();
		} else
			P3.updateText();
		reset(zc);
		zc.showStatus();
	}

	public PointObject select(final int x, final int y, final ZirkelCanvas zc, boolean altdown) {
		return zc.selectCreatePoint(x, y, altdown);
	}

	@Override
	public void reset(final ZirkelCanvas zc) {
		super.reset(zc);
		if (zc.Visual) {
			P1 = P2 = P3 = null;
			showStatus(zc);
		} else {
			zc.setPrompt(Global.name("prompt.angle"));
		}
	}

	@Override
	public void showStatus(final ZirkelCanvas zc) {
		if (Fixed) {
			if (P1 == null)
				zc.showStatus(Global.name("message.fixedangle.first"));
			else if (P2 == null)
				zc.showStatus(Global.name("message.fixedangle.root"));
			else
				zc.showStatus(Global.name("message.fixedangle.second"));
		} else {
			if (P1 == null)
				zc.showStatus(Global.name("message.angle.first"));
			else if (P2 == null)
				zc.showStatus(Global.name("message.angle.root"));
			else
				zc.showStatus(Global.name("message.angle.second"));
		}
	}

	@Override
	public boolean construct(final XmlTree tree, final Construction c)
	throws ConstructionException {
		if (!testTree(tree, "Angle"))
			return false;
		final XmlTag tag = tree.getTag();
		if (!tag.hasParam("first")) {
			final AngleObject o = new AngleObject(c);
			try {
				if (tag.hasParam("display")) {
					final String type = tag.getValue("display");
					if (type.equals("small"))
						o.setDisplaySize(AngleObject.SMALL);
					if (type.equals("normalsize"))
						o.setDisplaySize(AngleObject.NORMALSIZE);
					if (type.equals("large"))
						o.setDisplaySize(AngleObject.LARGE);
					if (type.equals("larger"))
						o.setDisplaySize(AngleObject.LARGER);
					if (type.equals("rectangle"))
						o.setDisplaySize(AngleObject.RECT);
				}
				setName(tag, o);
				set(tree, o);
				c.add(o);
				setConditionals(tree, c, o);
				if (tag.hasTrueParam("filled"))
					o.setFilled(true);
				if (tag.hasParam("fixed"))
					o.setFixed(tag.getValue("fixed"));
				if (tag.hasTrueParam("acute"))
					o.setObtuse(false);
				else
					o.setObtuse(true);
			} catch (final Exception e) {
			}
		}
		if (!tag.hasParam("first") || !tag.hasParam("root"))
			throw new ConstructionException("Angle parameters missing!");
		if (tag.hasParam("second")) {
			try {
				final PointObject p1 = (PointObject) c.find(tag
						.getValue("first"));
				final PointObject p2 = (PointObject) c.find(tag
						.getValue("root"));
				final PointObject p3 = (PointObject) c.find(tag
						.getValue("second"));
				final AngleObject o = new AngleObject(c, p1, p2, p3);
				if (tag.hasParam("display")) {
					final String type = tag.getValue("display");
					if (type.equals("small"))
						o.setDisplaySize(AngleObject.SMALL);
					if (type.equals("large"))
						o.setDisplaySize(AngleObject.LARGE);
					if (type.equals("larger"))
						o.setDisplaySize(AngleObject.LARGER);
					if (type.equals("rectangle"))
						o.setDisplaySize(AngleObject.RECT);
				}
				setName(tag, o);
				set(tree, o);
				c.add(o);
				setConditionals(tree, c, o);
				if (tag.hasTrueParam("filled"))
					o.setFilled(true);
				if (tag.hasParam("fixed"))
					o.setFixed(tag.getValue("fixed"));
				if (tag.hasTrueParam("acute"))
					o.setObtuse(false);
				else
					o.setObtuse(true);
			} catch (final ConstructionException e) {
				throw e;
			} catch (final Exception e) {
				throw new ConstructionException("Angle parameters illegal!");
			}
		} else {
			try {
				final PointObject p1 = (PointObject) c.find(tag
						.getValue("first"));
				final PointObject p2 = (PointObject) c.find(tag
						.getValue("root"));
				final FixedAngleObject o = new FixedAngleObject(c, p1, p2, 0, 0);
				if (tag.hasParam("display")) {
					final String type = tag.getValue("display");
					if (type.equals("small"))
						o.setDisplaySize(FixedAngleObject.SMALL);
					if (type.equals("large"))
						o.setDisplaySize(FixedAngleObject.LARGE);
					if (type.equals("larger"))
						o.setDisplaySize(FixedAngleObject.LARGER);
					if (type.equals("rectangle"))
						o.setDisplaySize(FixedAngleObject.RECT);
				}
				setName(tag, o);
				set(tree, o);
				c.add(o);
				setConditionals(tree, c, o);
				if (tag.hasTrueParam("filled"))
					o.setFilled(true);
				if (tag.hasTrueParam("acute"))
					o.setObtuse(false);
				else
					o.setObtuse(true);
				if (tag.hasTrueParam("inverse"))
					o.setInverse(true);
				else
					o.setInverse(false);
				if (tag.hasTrueParam("reduced"))
					o.setReduced(true);
				else
					o.setReduced(false);
				if (tag.hasTrueParam("dragable"))
					o.setDragable(true);
				if (tag.hasTrueParam("drawable"))
					o.setDragable(true); // downward compatibility
				if (tag.hasParam("fixed"))
					o.setFixed(tag.getValue("fixed"));
				else
					throw new ConstructionException("");
			} catch (final ConstructionException e) {
				throw e;
			} catch (final Exception e) {
				throw new ConstructionException("Angle parameters illegal!");
			}
		}
		return true;
	}

	@Override
	public String getTag() {
		return "Angle";
	}

	@Override
	public void construct(final Construction c, final String name,
			final String params[], final int nparams)
	throws ConstructionException {
		if (nparams != 3)
			throw new ConstructionException(Global.name("exception.nparams"));
		final ConstructionObject P1 = c.find(params[0]);
		if (P1 == null)
			throw new ConstructionException(Global.name("exception.notfound")
					+ " " + params[0]);
		final ConstructionObject P2 = c.find(params[1]);
		if (P2 == null)
			throw new ConstructionException(Global.name("exception.notfound")
					+ " " + params[1]);
		final ConstructionObject P3 = c.find(params[2]);
		if (P3 == null || !(P3 instanceof PointObject)) {
			final Expression ex = new Expression(params[2], c, null);
			if (!ex.isValid())
				throw new ConstructionException(Global.name("exception.expression"));
			final FixedAngleObject s = new FixedAngleObject(c,
					(PointObject) P1, (PointObject) P2, 0, 0);
			s.setFixed(params[2]);
			if (!name.equals(""))
				s.setNameCheck(name);
			c.add(s);
			s.setDefaults();
			s.setObtuse(true);
			s.setFixed(params[2]);
			s.validate();
			return;
		}
		if (!(P1 instanceof PointObject))
			throw new ConstructionException(Global.name("exception.type") + " "
					+ params[0]);
		if (!(P2 instanceof PointObject))
			throw new ConstructionException(Global.name("exception.type") + " "
					+ params[1]);
		if (!(P3 instanceof PointObject))
			throw new ConstructionException(Global.name("exception.type") + " "
					+ params[2]);
		if (P1 == P2 || P2 == P3)
			throw new ConstructionException(Global.name("exception.parameter"));
		final AngleObject s = new AngleObject(c, (PointObject) P1,
				(PointObject) P2, (PointObject) P3);
		if (!name.equals(""))
			s.setNameCheck(name);
		c.add(s);
		s.setDefaults();
	}

}
