/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.tests.sysmem.host;

/**
 * Critical user journeys with which to exercise the system, driven from the
 * host.
 */
public class Cujs {
    private Device mDevice;

    public Cujs(Device device) {
        this.mDevice = device;
    }

    /**
     * Runs the critical user journeys.
     */
    public void run() throws TestException {
        // Do an explicit GC in the system server process as part of the test
        // case to reduce GC-related sources of noise.
        // SIGUSR1 = 10 is the magic signal to trigger the GC.
        int pid = mDevice.getProcessPid("system_server");
        mDevice.executeShellCommand("kill -10 " + pid);

        // Invoke the Device Cujs instrumentation to run the cujs.
        // TODO: Consider exercising the system in other interesting ways as
        // well.
        String command = "am instrument -w com.android.tests.sysmem.device/.Cujs";
        mDevice.executeShellCommand(command);
    }
}
