/** @file */
/******************************************************************************
 *
 * Copyright(c) 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef __INC_MAC_REG_H
#define __INC_MAC_REG_H

//
// WL_AX_REG_DMAC.xls
//

//
// TOP_OFF
//

#define R_AX_GT0_CTRL 0x8000
#define B_AX_GT0_COUNT_EN BIT(31)
#define B_AX_GT0_MODE BIT(30)
#define B_AX_GT0_EN BIT(29)
#define B_AX_GT0_SORT_EN BIT(28)
#define B_AX_GT0_DATA_SH 0
#define B_AX_GT0_DATA_MSK 0xfffffff

#define R_AX_GT0_CNT 0x8004
#define B_AX_GT0_CNT_SH 0
#define B_AX_GT0_CNT_MSK 0x1fffffff

#define R_AX_GT1_CTRL 0x8008
#define B_AX_GT1_COUNT_EN BIT(31)
#define B_AX_GT1_MODE BIT(30)
#define B_AX_GT1_EN BIT(29)
#define B_AX_GT1_SORT_EN BIT(28)
#define B_AX_GT1_DATA_SH 0
#define B_AX_GT1_DATA_MSK 0xfffffff

#define R_AX_GT1_CNT 0x800C
#define B_AX_GT1_CNT_SH 0
#define B_AX_GT1_CNT_MSK 0x1fffffff

#define R_AX_GT2_CTRL 0x8010
#define B_AX_GT2_COUNT_EN BIT(31)
#define B_AX_GT2_MODE BIT(30)
#define B_AX_GT2_EN BIT(29)
#define B_AX_GT2_SORT_EN BIT(28)
#define B_AX_GT2_DATA_SH 0
#define B_AX_GT2_DATA_MSK 0xfffffff

#define R_AX_GT2_CNT 0x8014
#define B_AX_GT2_CNT_SH 0
#define B_AX_GT2_CNT_MSK 0x1fffffff

#define R_AX_GT3_CTRL 0x8018
#define B_AX_GT3_COUNT_EN BIT(31)
#define B_AX_GT3_MODE BIT(30)
#define B_AX_GT3_EN BIT(29)
#define B_AX_GT3_SORT_EN BIT(28)
#define B_AX_GT3_DATA_SH 0
#define B_AX_GT3_DATA_MSK 0xfffffff

#define R_AX_GT3_CNT 0x801C
#define B_AX_GT3_CNT_SH 0
#define B_AX_GT3_CNT_MSK 0x1fffffff

#define R_AX_SORT_CTRL 0x8024
#define B_AX_CMAC1_SORT_EN BIT(1)
#define B_AX_CMAC0_SORT_EN BIT(0)

#define R_AX_PHYREG_SET 0x8040
#define B_AX_PHYREG_SET_SH 0
#define B_AX_PHYREG_SET_MSK 0xf

#define R_AX_FWD0IMR 0x8100
#define B_AX_FS_H2C_INT_EN BIT(8)
#define B_AX_FS_HIOE_ERR_INT_EN BIT(7)
#define B_AX_FS_SW_PLL_LEAVE_32K_INT_EN BIT(6)
#define B_AX_FS_MAILBOX_OUT_EMPTY_INT_EN BIT(5)
#define B_AX_FS_LTE_COEX_INT_EN BIT(4)
#define B_AX_FS_GT3_INT_EN BIT(3)
#define B_AX_FS_GT2_INT_EN BIT(2)
#define B_AX_FS_GT1_INT_EN BIT(1)
#define B_AX_FS_GT0_INT_EN BIT(0)

#define R_AX_FWD0ISR 0x8104
#define B_AX_FS_H2C_INT BIT(8)
#define B_AX_FS_HIOE_ERR_INT BIT(7)
#define B_AX_FS_SW_PLL_LEAVE_32K_INT BIT(6)
#define B_AX_FS_MAILBOX_OUT_EMPTY_INT BIT(5)
#define B_AX_FS_LTE_COEX_INT BIT(4)
#define B_AX_FS_GT3_INT BIT(3)
#define B_AX_FS_GT2_INT BIT(2)
#define B_AX_FS_GT1_INT BIT(1)
#define B_AX_FS_GT0_INT BIT(0)

#define R_AX_HD0IMR 0x8110
#define B_AX_WDT_PTFM_INT_EN BIT(5)
#define B_AX_CPWM_INT_EN BIT(2)
#define B_AX_GT3_INT_EN BIT(1)
#define B_AX_C2H_INT_EN BIT(0)

#define R_AX_HD0ISR 0x8114
#define B_AX_WDT_PTFM_INT BIT(5)
#define B_AX_CPWM_INT BIT(2)
#define B_AX_GT3_INT BIT(1)
#define B_AX_C2H_INT BIT(0)

#define R_AX_H2CREG_DATA0 0x8140
#define B_AX_H2CREG_D0_SH 0
#define B_AX_H2CREG_D0_MSK 0xffffffffL

#define R_AX_H2CREG_DATA1 0x8144
#define B_AX_H2CREG_D1_SH 0
#define B_AX_H2CREG_D1_MSK 0xffffffffL

#define R_AX_H2CREG_DATA2 0x8148
#define B_AX_H2CREG_D2_SH 0
#define B_AX_H2CREG_D2_MSK 0xffffffffL

#define R_AX_H2CREG_DATA3 0x814C
#define B_AX_H2CREG_D3_SH 0
#define B_AX_H2CREG_D3_MSK 0xffffffffL

#define R_AX_C2HREG_DATA0 0x8150
#define B_AX_C2HREG_D0_SH 0
#define B_AX_C2HREG_D0_MSK 0xffffffffL

#define R_AX_C2HREG_DATA1 0x8154
#define B_AX_C2HREG_D1_SH 0
#define B_AX_C2HREG_D1_MSK 0xffffffffL

#define R_AX_C2HREG_DATA2 0x8158
#define B_AX_C2HREG_D2_SH 0
#define B_AX_C2HREG_D2_MSK 0xffffffffL

#define R_AX_C2HREG_DATA3 0x815C
#define B_AX_C2HREG_D3_SH 0
#define B_AX_C2HREG_D3_MSK 0xffffffffL

#define R_AX_H2CREG_CTRL 0x8160
#define B_AX_H2CREG_TRIGGER BIT(0)

#define R_AX_C2HREG_CTRL 0x8164
#define B_AX_C2HREG_TRIGGER BIT(0)

#define R_AX_CPWM 0x8170
#define B_AX_CPWM_TOGGLE BIT(15)
#define B_AX_CPWM_VAL_SH 0
#define B_AX_CPWM_VAL_MSK 0x7fff

//
// 8852C TOP_OFF
//

#define R_AX_GT0_CTRL_V1 0x7000

#define R_AX_GT0_CNT_V1 0x7004

#define R_AX_GT1_CTRL_V1 0x7008

#define R_AX_GT1_CNT_V1 0x700C

#define R_AX_GT2_CTRL_V1 0x7010

#define R_AX_GT2_CNT_V1 0x7014

#define R_AX_GT3_CTRL_V1 0x7018

#define R_AX_GT3_CNT_V1 0x701C

#define R_AX_SORT_CTRL_V1 0x7024

#define R_AX_PHYREG_SET_V1 0x7040

#define R_AX_FWD0IMR_V1 0x7100

#define R_AX_FWD0ISR_V1 0x7104

#define R_AX_HD0IMR_V1 0x7110

#define R_AX_HD0ISR_V1 0x7114

#define R_AX_H2CREG_DATA0_V1 0x7140

#define R_AX_H2CREG_DATA1_V1 0x7144

#define R_AX_H2CREG_DATA2_V1 0x7148

#define R_AX_H2CREG_DATA3_V1 0x714C

#define R_AX_C2HREG_DATA0_V1 0x7150

#define R_AX_C2HREG_DATA1_V1 0x7154

#define R_AX_C2HREG_DATA2_V1 0x7158

#define R_AX_C2HREG_DATA3_V1 0x715C

#define R_AX_H2CREG_CTRL_V1 0x7160

#define R_AX_C2HREG_CTRL_V1 0x7164

#define R_AX_CPWM_V1 0x7170

//
// WL_PON
//

#define R_AX_FWD1IMR 0x8300
#define B_AX_FS_TM_WAKE_INT_EN BIT(16)
#define B_AX_FS_BT_MAILBOX_INT_EN BIT(1)
#define B_AX_FS_RPWM_INT_EN BIT(0)

#define R_AX_FWD1ISR 0x8304
#define B_AX_FS_TM_WAKE_INT BIT(16)
#define B_AX_FS_BT_MAILBOX_INT BIT(1)
#define B_AX_FS_RPWM_INT BIT(0)

#define R_AX_FSMIMR 0x8308
#define B_AX_FSM_RP_END_EVENT_IMR BIT(6)
#define B_AX_FSM_RX_BCN_TO_CNT_EVENT_IMR BIT(5)
#define B_AX_FSM_RX_MATCH_EVENT_IMR BIT(4)
#define B_AX_FSM_HIOE_ERR_EVENT_IMR BIT(3)
#define B_AX_FSM_OTHERS_WAKE_EVENT_IMR BIT(2)
#define B_AX_FSM_TIMER_TO_EVENT_IMR BIT(1)

#define R_AX_FSMISR 0x830C
#define B_AX_FSM_RP_END_EVENT_ISR BIT(6)
#define B_AX_FSM_RX_BCN_TO_CNT_EVENT_ISR BIT(5)
#define B_AX_FSM_RX_MATCH_EVENT_ISR BIT(4)
#define B_AX_FSM_HIOE_ERR_EVENT_ISR BIT(3)
#define B_AX_FSM_OTHERS_WAKE_EVENT_ISR BIT(2)
#define B_AX_FSM_TIMER_TO_EVENT_ISR BIT(1)

#define R_AX_TM_BKP_RES_CTRL 0x8310
#define B_AX_TM_WAKE_IND BIT(7)
#define B_AX_TM_BKP_EN_STS BIT(6)
#define B_AX_PRE_CHK_DONE BIT(3)
#define B_AX_PRE_CHK_VALID BIT(2)
#define B_AX_TM_RES_EN BIT(1)
#define B_AX_TM_BKP_EN_TRIGGER BIT(0)

#define R_AX_PRE_CHK_CTRL 0x8314
#define B_AX_PRE_CHK_THD_SH 16
#define B_AX_PRE_CHK_THD_MSK 0xffff
#define B_AX_PRE_WAKE_TIME_SH 0
#define B_AX_PRE_WAKE_TIME_MSK 0xffff

#define R_AX_LPS_WTM_SC 0x8318
#define B_AX_LPS_WTM_SC_SH 0
#define B_AX_LPS_WTM_SC_MSK 0xffffffffL

#define R_AX_LPS_WTM_CNT 0x831C

#define R_AX_TSF_32K_SEL 0x8320
#define B_AX_TSF_CLK_STABLE BIT(17)
#define B_AX_CKSL_WLTSF BIT(16)
#define B_AX_32K_SRC_SEL BIT(8)
#define B_AX_US_TIME_VALUE_SH 0
#define B_AX_US_TIME_VALUE_MSK 0xff

#define R_AX_HIOE_END_ADDR 0x8340
#define B_AX_HIOE_END_ADDR_SH 0
#define B_AX_HIOE_END_ADDR_MSK 0xffffffffL

#define R_AX_HIOE_STR_ADDR 0x8344
#define B_AX_HIOE_STR_ADDR_SH 0
#define B_AX_HIOE_STR_ADDR_MSK 0xffffffffL

#define R_AX_BKP_HIOE_CTRL 0x8348
#define B_AX_BKP_HIOE_CTRL_SH 0
#define B_AX_BKP_HIOE_CTRL_MSK 0xffffffffL

#define R_AX_RES_HIOE_CTRL 0x834C
#define B_AX_RES_HIOE_CTRL_SH 0
#define B_AX_RES_HIOE_CTRL_MSK 0xffffffffL

#define R_AX_HCI_FUNC_EN 0x8380
#define B_AX_HCI_RXDMA_EN BIT(1)
#define B_AX_HCI_TXDMA_EN BIT(0)

#define R_AX_OSC_32K_CTRL 0x8394
#define B_AX_LPOSC32K_OK BIT(31)
#define B_AX_CAL_32K_DBG_SEL BIT(3)
#define B_AX_CAL32K_XTAL_EN BIT(2)
#define B_AX_CAL32K_OSC_EN BIT(1)
#define B_AX_WL_POW_32KOSC BIT(0)

#define R_AX_32K_CAL_REG0 0x8398
#define B_AX_CAL_32K_REG_WR BIT(31)
#define B_AX_CAL_OSC_XTAL_SEL BIT(22)
#define B_AX_CAL_32K_REG_ADDR_SH 16
#define B_AX_CAL_32K_REG_ADDR_MSK 0x3f
#define B_AX_CAL_32K_REG_DATA_SH 0
#define B_AX_CAL_32K_REG_DATA_MSK 0xffff

#define R_AX_BOOT_DBG 0x83F0
#define B_AX_BOOT_STATUS_SH 16
#define B_AX_BOOT_STATUS_MSK 0xffff
#define B_AX_SECUREBOOT_STATUS_SH 0
#define B_AX_SECUREBOOT_STATUS_MSK 0xffff

//
// 8852C WL_PON
//

#define R_AX_FWD1IMR_V1 0x7800

#define R_AX_FWD1ISR_V1 0x7804

#define R_AX_FSMIMR_V1 0x7808

#define R_AX_FSMISR_V1 0x780C

#define R_AX_TM_BKP_RES_CTRL_V1 0x7810

#define R_AX_PRE_CHK_CTRL_V1 0x7814

#define R_AX_LPS_WTM_SC_V1 0x7818

#define R_AX_LPS_WTM_CNT_V1 0x781C

#define R_AX_TSF_32K_SEL_V1 0x7820

#define R_AX_HIOE_END_ADDR_V1 0x7840

#define R_AX_HIOE_STR_ADDR_V1 0x7844

#define R_AX_BKP_HIOE_CTRL_V1 0x7848

#define R_AX_RES_HIOE_CTRL_V1 0x784C

#define R_AX_HCI_FUNC_EN_V1 0x7880

#define R_AX_OSC_32K_CTRL_V1 0x7894

#define R_AX_32K_CAL_REG0_V1 0x7898

#define R_AX_BOOT_DBG_V1 0x78F0
//
// COMMON
//

#define R_AX_DMAC_FUNC_EN 0x8400
#define B_AX_DMAC_CRPRT BIT(31)
#define B_AX_MAC_FUNC_EN BIT(30)
#define B_AX_DMAC_FUNC_EN BIT(29)
#define B_AX_MPDU_PROC_EN BIT(28)
#define B_AX_WD_RLS_EN BIT(27)
#define B_AX_DLE_WDE_EN BIT(26)
#define B_AX_TXPKT_CTRL_EN BIT(25)
#define B_AX_STA_SCH_EN BIT(24)
#define B_AX_DLE_PLE_EN BIT(23)
#define B_AX_PKT_BUF_EN BIT(22)
#define B_AX_DMAC_TBL_EN BIT(21)
#define B_AX_PKT_IN_EN BIT(20)
#define B_AX_DLE_CPUIO_EN BIT(19)
#define B_AX_DISPATCHER_EN BIT(18)
#define B_AX_BBRPT_EN BIT(17)
#define B_AX_MAC_SEC_EN BIT(16)
#define B_AX_H_AXIDMA_EN BIT(14)
#define B_AX_DMAC_SER_PS BIT(13)
#define B_AX_CMAC_SER_PS BIT(12)

#define R_AX_DMAC_CLK_EN 0x8404
#define B_AX_MAC_CKEN BIT(30)
#define B_AX_DMAC_CKEN BIT(29)
#define B_AX_MPDU_CKEN BIT(28)
#define B_AX_WD_RLS_CLK_EN BIT(27)
#define B_AX_DLE_WDE_CLK_EN BIT(26)
#define B_AX_TXPKT_CTRL_CLK_EN BIT(25)
#define B_AX_STA_SCH_CLK_EN BIT(24)
#define B_AX_DLE_PLE_CLK_EN BIT(23)
#define B_AX_PKT_IN_CLK_EN BIT(20)
#define B_AX_DLE_CPUIO_CLK_EN BIT(19)
#define B_AX_DISPATCHER_CLK_EN BIT(18)
#define B_AX_BBRPT_CLK_EN BIT(17)
#define B_AX_MAC_SEC_CLK_EN BIT(16)

#define R_AX_LTR_CTRL_0 0x8410
#define B_AX_LTR_SPACE_IDX_SH 12
#define B_AX_LTR_SPACE_IDX_MSK 0x3
#define B_AX_LTR_IDLE_TIMER_IDX_SH 8
#define B_AX_LTR_IDLE_TIMER_IDX_MSK 0x7
#define B_AX_LTR_WD_NOEMP_CHK BIT(6)
#define B_AX_APP_LTR_ACT BIT(5)
#define B_AX_APP_LTR_IDLE BIT(4)
#define B_AX_LTR_EN BIT(1)
#define B_AX_LTR_HW_EN BIT(0)

#define R_AX_LTR_CTRL_1 0x8414
#define B_AX_LTR_RX0_TH_SH 16
#define B_AX_LTR_RX0_TH_MSK 0xfff
#define B_AX_LTR_RX1_TH_SH 0
#define B_AX_LTR_RX1_TH_MSK 0xfff

#define R_AX_LTR_IDLE_LATENCY 0x8418
#define B_AX_LTR_IDLE_LTCY_SH 0
#define B_AX_LTR_IDLE_LTCY_MSK 0xffffffffL

#define R_AX_LTR_ACTIVE_LATENCY 0x841C
#define B_AX_LTR_ACT_LTCY_SH 0
#define B_AX_LTR_ACT_LTCY_MSK 0xffffffffL

#define R_AX_DMAC_TABLE_CTRL 0x8420
#define B_AX_HWAMSDU_PADDING_MODE BIT(31)
#define B_AX_MACID_MPDU_PROCESSOR_OFFSET_SH 16
#define B_AX_MACID_MPDU_PROCESSOR_OFFSET_MSK 0x7ff
#define B_AX_DMAC_CTRL_INFO_OFFSET_SH 0
#define B_AX_DMAC_CTRL_INFO_OFFSET_MSK 0x7ff

#define R_AX_SER_DBG_INFO 0x8424

#define R_AX_DLE_EMPTY0 0x8430
#define B_AX_PLE_EMPTY_QTA_DMAC_CPUIO BIT(26)
#define B_AX_PLE_EMPTY_QTA_DMAC_MPDU_TX BIT(25)
#define B_AX_PLE_EMPTY_QTA_DMAC_WLAN_CPU BIT(24)
#define B_AX_PLE_EMPTY_QTA_DMAC_H2C BIT(23)
#define B_AX_PLE_EMPTY_QTA_DMAC_B1_TXPL BIT(22)
#define B_AX_PLE_EMPTY_QTA_DMAC_B0_TXPL BIT(21)
#define B_AX_WDE_EMPTY_QTA_DMAC_CPUIO BIT(20)
#define B_AX_WDE_EMPTY_QTA_DMAC_PKTIN BIT(19)
#define B_AX_WDE_EMPTY_QTA_DMAC_DATA_CPU BIT(18)
#define B_AX_WDE_EMPTY_QTA_DMAC_WLAN_CPU BIT(17)
#define B_AX_WDE_EMPTY_QTA_DMAC_HIF BIT(16)
#define B_AX_WDE_EMPTY_QUE_DMAC_PKTIN BIT(10)
#define B_AX_PLE_EMPTY_QUE_DMAC_SEC_TX BIT(9)
#define B_AX_PLE_EMPTY_QUE_DMAC_MPDU_TX BIT(8)
#define B_AX_WDE_EMPTY_QUE_OTHERS BIT(7)
#define B_AX_WDE_EMPTY_QUE_CMAC0_WMM1 BIT(4)
#define B_AX_WDE_EMPTY_QUE_CMAC0_WMM0 BIT(3)
#define B_AX_WDE_EMPTY_QUE_CMAC1_MBH BIT(2)
#define B_AX_WDE_EMPTY_QUE_CMAC0_MBH BIT(1)
#define B_AX_WDE_EMPTY_QUE_CMAC0_ALL_AC BIT(0)

#define R_AX_DLE_EMPTY1 0x8434
#define B_AX_PLE_EMPTY_QTA_DMAC_WDRLS BIT(20)
#define B_AX_PLE_EMPTY_QTA_CMAC1_DMA_BBRPT BIT(19)
#define B_AX_PLE_EMPTY_QTA_CMAC1_DMA_RX BIT(18)
#define B_AX_PLE_EMPTY_QTA_CMAC0_DMA_RX BIT(17)
#define B_AX_PLE_EMPTY_QTA_DMAC_C2H BIT(16)
#define B_AX_PLE_EMPTY_QUE_DMAC_PLRLS BIT(5)
#define B_AX_PLE_EMPTY_QUE_DMAC_CPUIO BIT(4)
#define B_AX_PLE_EMPTY_QUE_DMAC_SEC_RX BIT(3)
#define B_AX_PLE_EMPTY_QUE_DMAC_MPDU_RX BIT(2)
#define B_AX_PLE_EMPTY_QUE_DMAC_HDP BIT(1)
#define B_AX_WDE_EMPTY_QUE_DMAC_WDRLS BIT(0)

#define R_AX_FWD2IMR 0x8500
#define B_AX_FS_TXPKTIN_INT_EN BIT(5)
#define B_AX_FS_WWLAN_INT_EN BIT(4)
#define B_AX_FS_PLD_CPU_IO_PORT_Q1_INT_EN BIT(3)
#define B_AX_FS_PLD_CPU_IO_PORT_Q0_INT_EN BIT(2)
#define B_AX_FS_WD_CPU_IO_PORT_Q1_INT_EN BIT(1)
#define B_AX_FS_WD_CPU_IO_PORT_Q0_INT_EN BIT(0)

#define R_AX_FWD2ISR 0x8504
#define B_AX_FS_TXPKTIN_INT BIT(5)
#define B_AX_FS_WWLAN_INT BIT(4)
#define B_AX_FS_PLD_CPU_IO_PORT_Q1_INT BIT(3)
#define B_AX_FS_PLD_CPU_IO_PORT_Q0_INT BIT(2)
#define B_AX_FS_WD_CPU_IO_PORT_Q1_INT BIT(1)
#define B_AX_FS_WD_CPU_IO_PORT_Q0_INT BIT(0)

#define R_AX_DMAC_ERR_IMR 0x8520
#define B_AX_DLE_CPUIO_ERR_INT_EN BIT(10)
#define B_AX_APB_BRIDGE_ERR_INT_EN BIT(9)
#define B_AX_DISPATCH_ERR_INT_EN BIT(8)
#define B_AX_PKTIN_ERR_INT_EN BIT(7)
#define B_AX_PLE_DLE_ERR_INT_EN BIT(6)
#define B_AX_TXPKTCTRL_ERR_INT_EN BIT(5)
#define B_AX_WDE_DLE_ERR_INT_EN BIT(4)
#define B_AX_STA_SCHEDULER_ERR_INT_EN BIT(3)
#define B_AX_MPDU_ERR_INT_EN BIT(2)
#define B_AX_WSEC_ERR_INT_EN BIT(1)
#define B_AX_WDRLS_ERR_INT_EN BIT(0)

#define R_AX_DMAC_ERR_ISR 0x8524
#define B_AX_DLE_CPUIO_ERR_FLAG BIT(10)
#define B_AX_APB_BRIDGE_ERR_FLAG BIT(9)
#define B_AX_DISPATCH_ERR_FLAG BIT(8)
#define B_AX_PKTIN_ERR_FLAG BIT(7)
#define B_AX_PLE_DLE_ERR_FLAG BIT(6)
#define B_AX_TXPKTCTRL_ERR_FLAG BIT(5)
#define B_AX_WDE_DLE_ERR_FLAG BIT(4)
#define B_AX_STA_SCHEDULER_ERR_FLAG BIT(3)
#define B_AX_MPDU_ERR_FLAG BIT(2)
#define B_AX_WSEC_ERR_FLAG BIT(1)
#define B_AX_WDRLS_ERR_FLAG BIT(0)

#define R_AX_BIST_CTRL 0x8600
#define B_AX_BIST_DYN_READ_EN BIT(14)
#define B_AX_BIST_LOOP_MODE BIT(13)
#define B_AX_BIST_LVDRF_CLKDIS BIT(12)
#define B_AX_BIST_DRF_RESUME BIT(3)
#define B_AX_BIST_DRF_MODE BIT(2)
#define B_AX_BIST_MODE BIT(1)
#define B_AX_BIST_RSTN_ALL BIT(0)

#define R_AX_SYS_CTRL 0x8604
#define B_AX_SYM_MEM_RMV_FABDBG_SH 30
#define B_AX_SYM_MEM_RMV_FABDBG_MSK 0x3
#define B_AX_SYM_MEM_RMV_SIGN BIT(29)
#define B_AX_SYM_MEM_RMV_2PRF BIT(27)
#define B_AX_SYM_MEM_RMV_1PRF BIT(26)
#define B_AX_SYM_MEM_RMV_1PSR BIT(25)
#define B_AX_SYM_MEM_RMV_ROM BIT(24)
#define B_AX_SYM_MEM_RMV_WL_SH 4
#define B_AX_SYM_MEM_RMV_WL_MSK 0xf

#define R_AX_BIST_CTRL_1 0x8610
#define B_AX_BIST_RSTN_N_DMAC_SH 0
#define B_AX_BIST_RSTN_N_DMAC_MSK 0xfffffff

#define R_AX_BIST_CTRL_2 0x8614
#define B_AX_BIST_DONE_DMAC_SH 0
#define B_AX_BIST_DONE_DMAC_MSK 0xfffffff

#define R_AX_BIST_CTRL_3 0x8618
#define B_AX_BIST_FAIL_DMAC_SH 0
#define B_AX_BIST_FAIL_DMAC_MSK 0xfffffff

#define R_AX_BIST_CTRL_4 0x861C
#define B_AX_BIST_DRF_PAUSE_DMAC_SH 0
#define B_AX_BIST_DRF_PAUSE_DMAC_MSK 0xfffffff

//
// Dispatcher
//

#define R_AX_DISPATCHER_GLOBAL_SETTING_0 0x8800
#define B_AX_PL_PAGE_128B_SEL BIT(9)
#define B_AX_WD_PAGE_64B_SEL BIT(8)
#define B_AX_CDR_GATTING_DISABLE BIT(3)
#define B_AX_CDT_GATTING_DISABLE BIT(2)
#define B_AX_HDR_GATTING_DISABLE BIT(1)
#define B_AX_HDT_GATTING_DISABLE BIT(0)

#define R_AX_OTHER_DISPATCHER_ERR_ISR 0x8804
#define B_AX_OTHER_STF_WROQT_UNDERFLOW BIT(29)
#define B_AX_OTHER_STF_WROQT_OVERFLOW BIT(28)
#define B_AX_OTHER_STF_WRFF_UNDERFLOW BIT(27)
#define B_AX_OTHER_STF_WRFF_OVERFLOW BIT(26)
#define B_AX_OTHER_STF_CMD_UNDERFLOW BIT(25)
#define B_AX_OTHER_STF_CMD_OVERFLOW BIT(24)
#define B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR BIT(17)
#define B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR BIT(16)
#define B_AX_PLE_OUTPUT_ERR BIT(12)
#define B_AX_PLE_RESP_ERR BIT(11)
#define B_AX_PLE_BURST_NUM_ERR BIT(10)
#define B_AX_PLE_NULL_PKT_ERR BIT(9)
#define B_AX_PLE_FLOW_CTRL_ERR BIT(8)
#define B_AX_WDE_OUTPUT_ERR BIT(4)
#define B_AX_WDE_RESP_ERR BIT(3)
#define B_AX_WDE_BURST_NUM_ERR BIT(2)
#define B_AX_WDE_NULL_PKT_ERR BIT(1)
#define B_AX_WDE_FLOW_CTRL_ERR BIT(0)

#define R_AX_HOST_DISPATCHER_ERR_ISR 0x8808
#define B_AX_HDT_RX_WRITE_UNDERFLOW BIT(31)
#define B_AX_HDT_RX_WRITE_OVERFLOW BIT(30)
#define B_AX_HDT_CHKSUM_FSM_ERR BIT(29)
#define B_AX_HDT_SHIFT_DMA_CFG_ERR BIT(28)
#define B_AX_HDT_DMA_PROCESS_ERR BIT(27)
#define B_AX_HDT_TOTAL_LEN_ERR BIT(26)
#define B_AX_HDT_SHIFT_EN_ERR BIT(25)
#define B_AX_HDT_RXAGG_CFG_ERR BIT(24)
#define B_AX_HDT_OUTPUT_ERR BIT(21)
#define B_AX_HDT_RESP_ERR BIT(20)
#define B_AX_HDT_BURST_NUM_ERR BIT(19)
#define B_AX_HDT_NULLPKT_ERR BIT(18)
#define B_AX_HDT_FLOW_CTRL_ERR BIT(17)
#define B_AX_HDT_PLD_CMD_UNDERFLOW BIT(16)
#define B_AX_HDT_PLD_CMD_OVERLOW BIT(15)
#define B_AX_HDT_TX_WRITE_UNDERFLOW BIT(14)
#define B_AX_HDT_TX_WRITE_OVERFLOW BIT(13)
#define B_AX_HDT_TCP_CHK_ERR BIT(12)
#define B_AX_HDT_TXPKTSIZE_ERR BIT(11)
#define B_AX_HDT_PRE_COST_ERR BIT(10)
#define B_AX_HDT_WD_CHK_ERR BIT(9)
#define B_AX_HDT_CHANNEL_DMA_ERR BIT(8)
#define B_AX_HDT_OFFSET_UNMATCH BIT(7)
#define B_AX_HDT_PAYLOAD_UNDERFLOW BIT(6)
#define B_AX_HDT_PAYLOAD_OVERFLOW BIT(5)
#define B_AX_HDT_PERMU_UNDERFLOW BIT(4)
#define B_AX_HDT_PERMU_OVERFLOW BIT(3)
#define B_AX_HDT_PKT_FAIL_DBG BIT(2)
#define B_AX_HDT_CHANNEL_ID_ERR BIT(1)
#define B_AX_HDT_CHANNEL_DIFF_ERR BIT(0)

#define R_AX_CPU_DISPATCHER_ERR_ISR 0x880C
#define B_AX_CPU_RX_WRITE_UNDERFLOW BIT(31)
#define B_AX_CPU_RX_WRITE_OVERFLOW BIT(30)
#define B_AX_CPU_CHKSUM_FSM_ERR BIT(29)
#define B_AX_CPU_SHIFT_DMA_CFG_ERR BIT(28)
#define B_AX_CPU_DMA_PROCESS_ERR BIT(27)
#define B_AX_CPU_TOTAL_LEN_ERR BIT(26)
#define B_AX_CPU_SHIFT_EN_ERR BIT(25)
#define B_AX_CPU_RXAGG_CFG_ERR BIT(24)
#define B_AX_CPU_OUTPUT_ERR BIT(20)
#define B_AX_CPU_RESP_ERR BIT(19)
#define B_AX_CPU_BURST_NUM_ERR BIT(18)
#define B_AX_CPU_NULLPKT_ERR BIT(17)
#define B_AX_CPU_FLOW_CTRL_ERR BIT(16)
#define B_AX_CPU_F2P_SEQ_ERR BIT(15)
#define B_AX_CPU_F2P_QSEL_ERR BIT(14)
#define B_AX_CPU_PLD_CMD_UNDERFLOW BIT(13)
#define B_AX_CPU_PLD_CMD_OVERLOW BIT(12)
#define B_AX_CPU_PRE_COST_ERR BIT(11)
#define B_AX_CPU_WD_CHK_ERR BIT(10)
#define B_AX_CPU_CHANNEL_DMA_ERR BIT(9)
#define B_AX_CPU_OFFSET_UNMATCH BIT(8)
#define B_AX_CPU_PAYLOAD_CHKSUM_ERR BIT(7)
#define B_AX_CPU_PAYLOAD_UNDERFLOW BIT(6)
#define B_AX_CPU_PAYLOAD_OVERFLOW BIT(5)
#define B_AX_CPU_PERMU_UNDERFLOW BIT(4)
#define B_AX_CPU_PERMU_OVERFLOW BIT(3)
#define B_AX_CPU_CHANNEL_ID_ERR BIT(2)
#define B_AX_CPU_PKT_FAIL_DBG BIT(1)
#define B_AX_CPU_CHANNEL_DIFF_ERR BIT(0)

#define R_AX_TX_ADDRESS_INFO_MODE_SETTING 0x8810
#define B_AX_CPU_ADDR_INFO_8B_SEL BIT(8)
#define B_AX_HOST_ADDR_INFO_8B_SEL BIT(0)

#define R_AX_TX_TCPIP_CHECKSUM_FUNCTION 0x8814
#define B_AX_HDT_TCPIP_CHKSUM_EN BIT(0)

#define R_AX_TXAGG_ALIGN_CFG 0x8818
#define B_AX_TXAGG_ALIGN_SIZE_EN BIT(31)
#define B_AX_TXAGG_ALIGN_SIZE_SH 0
#define B_AX_TXAGG_ALIGN_SIZE_MSK 0xfff

#define R_AX_TX_PASTE_TIMESTAMP_SETTING 0x881C
#define B_AX_HDT_TIMESTAMP_EN BIT(0)

#define R_AX_CPU_PORT_DEBUG_SETTING 0x8820
#define B_AX_CDT_F2P_CPU_PORT_EN BIT(9)
#define B_AX_CDT_AC_CPU_PORT_EN BIT(8)
#define B_AX_HDT_AC_CPU_PORT_EN BIT(0)

#define R_AX_TX_CHECK_OFFSET_SETTING 0x8824
#define B_AX_CDT_CHK_OFFSET_EN BIT(24)
#define B_AX_CDT_CHK_OFFSET_SH 16
#define B_AX_CDT_CHK_OFFSET_MSK 0xff
#define B_AX_HDT_CHK_OFFSET_EN BIT(8)
#define B_AX_HDT_CHK_OFFSET_SH 0
#define B_AX_HDT_CHK_OFFSET_MSK 0xff

#define R_AX_TX_QUEUE_CLEAR_SETTING 0x8828
#define B_AX_HDT_TXQUE_CLR_EN BIT(0)

#define R_AX_TX_ERROR_STOP_DEBUG_SETTING 0x882C
#define B_AX_CDT_ERROR_STOP BIT(8)
#define B_AX_HDT_ERROR_STOP BIT(0)

#define R_AX_WD_CHECKSUM_FUNCTION_ENABLE 0x8830
#define B_AX_CDT_WD_CHKSUM_EN BIT(8)
#define B_AX_HDT_WD_CHKSUM_EN BIT(0)

#define R_AX_TX_DTAT_DROP_DEBUG_SETTING 0x8834
#define B_AX_CDT_DATA_DROP_EN BIT(8)
#define B_AX_HDT_DATA_DROP_EN BIT(0)

#define R_AX_REQUEST_PLE_BUFFER_SETTING 0x8838
#define B_AX_AMSDU_PADDING_SPACE_SH 8
#define B_AX_AMSDU_PADDING_SPACE_MSK 0xff
#define B_AX_RSV_PLD_SPACE_SH 0
#define B_AX_RSV_PLD_SPACE_MSK 0xff

#define R_AX_DMAC_MACID_DROP_0 0x8840
#define B_AX_DMAC_MACID31_0_DROP_SH 0
#define B_AX_DMAC_MACID31_0_DROP_MSK 0xffffffffL

#define R_AX_DMAC_MACID_DROP_1 0x8844
#define B_AX_DMAC_MACID63_32_DROP_SH 0
#define B_AX_DMAC_MACID63_32_DROP_MSK 0xffffffffL

#define R_AX_DMAC_MACID_DROP_2 0x8848
#define B_AX_DMAC_MACID95_64_DROP_SH 0
#define B_AX_DMAC_MACID95_64_DROP_MSK 0xffffffffL

#define R_AX_DMAC_MACID_DROP_3 0x884C
#define B_AX_DMAC_MACID127_96_DROP_SH 0
#define B_AX_DMAC_MACID127_96_DROP_MSK 0xffffffffL

#define R_AX_HOST_DISPATCHER_ERR_IMR 0x8850
#define B_AX_HDT_RX_WRITE_UNDERFLOW_INT_EN BIT(31)
#define B_AX_HDT_RX_WRITE_OVERFLOW_INT_EN BIT(30)
#define B_AX_HDT_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_HDT_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_HDT_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_HDT_TOTAL_LEN_ERR_INT_EN BIT(26)
#define B_AX_HDT_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_HDT_RXAGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_HDT_OUTPUT_ERR_INT_EN BIT(21)
#define B_AX_HDT_RES_ERR_INT_EN BIT(20)
#define B_AX_HDT_BURST_NUM_ERR_INT_EN BIT(19)
#define B_AX_HDT_NULLPKT_ERR_INT_EN BIT(18)
#define B_AX_HDT_FLOW_CTRL_ERR_INT_EN BIT(17)
#define B_AX_HDT_PLD_CMD_UNDERFLOW_INT_EN BIT(16)
#define B_AX_HDT_PLD_CMD_OVERLOW_INT_EN BIT(15)
#define B_AX_HDT_TX_WRITE_UNDERFLOW_INT_EN BIT(14)
#define B_AX_HDT_TX_WRITE_OVERFLOW_INT_EN BIT(13)
#define B_AX_HDT_TCP_CHK_ERR_INT_EN BIT(12)
#define B_AX_HDT_TXPKTSIZE_ERR_INT_EN BIT(11)
#define B_AX_HDT_PRE_COST_ERR_INT_EN BIT(10)
#define B_AX_HDT_WD_CHK_ERR_INT_EN BIT(9)
#define B_AX_HDT_CHANNEL_DMA_ERR_INT_EN BIT(8)
#define B_AX_HDT_OFFSET_UNMATCH_INT_EN BIT(7)
#define B_AX_HDT_PAYLOAD_UNDERFLOW_INT_EN BIT(6)
#define B_AX_HDT_PAYLOAD_OVERFLOW_INT_EN BIT(5)
#define B_AX_HDT_PERMU_UNDERFLOW_INT_EN BIT(4)
#define B_AX_HDT_PERMU_OVERFLOW_INT_EN BIT(3)
#define B_AX_HDT_PKT_FAIL_DBG_INT_EN BIT(2)
#define B_AX_HDT_CHANNEL_ID_ERR_INT_EN BIT(1)
#define B_AX_HDT_CHANNEL_DIFF_ERR_INT_EN BIT(0)

#define R_AX_CPU_DISPATCHER_ERR_IMR 0x8854
#define B_AX_CPU_RX_WRITE_UNDERFLOW_INT_EN BIT(31)
#define B_AX_CPU_RX_WRITE_OVERFLOW_INT_EN BIT(30)
#define B_AX_CPU_CHKSUM_FSM_ERR_INT_EN BIT(29)
#define B_AX_CPU_SHIFT_DMA_CFG_ERR_INT_EN BIT(28)
#define B_AX_CPU_DMA_PROCESS_ERR_INT_EN BIT(27)
#define B_AX_CPU_TOTAL_LEN_ERR_INT_EN BIT(26)
#define B_AX_CPU_SHIFT_EN_ERR_INT_EN BIT(25)
#define B_AX_CPU_RXAGG_CFG_ERR_INT_EN BIT(24)
#define B_AX_CPU_OUTPUT_ERR_INT_EN BIT(20)
#define B_AX_CPU_RESP_ERR_INT_EN BIT(19)
#define B_AX_CPU_BURST_NUM_ERR_INT_EN BIT(18)
#define B_AX_CPU_NULLPKT_ERR_INT_EN BIT(17)
#define B_AX_CPU_FLOW_CTRL_ERR_INT_EN BIT(16)
#define B_AX_CPU_F2P_SEQ_ERR_INT_EN BIT(15)
#define B_AX_CPU_F2P_QSEL_ERR_INT_EN BIT(14)
#define B_AX_CPU_PLD_CMD_UNDERFLOW_INT_EN BIT(13)
#define B_AX_CPU_PLD_CMD_OVERLOW_INT_EN BIT(12)
#define B_AX_CPU_PRE_COST_ERR_INT_EN BIT(11)
#define B_AX_CPU_WD_CHK_ERR_INT_EN BIT(10)
#define B_AX_CPU_CHANNEL_DMA_ERR_INT_EN BIT(9)
#define B_AX_CPU_OFFSET_UNMATCH_INT_EN BIT(8)
#define B_AX_CPU_PAYLOAD_CHKSUM_ERR_INT_EN BIT(7)
#define B_AX_CPU_PAYLOAD_UNDERFLOW_INT_EN BIT(6)
#define B_AX_CPU_PAYLOAD_OVERFLOW_INT_EN BIT(5)
#define B_AX_CPU_PERMU_UNDERFLOW_INT_EN BIT(4)
#define B_AX_CPU_PERMU_OVERFLOW_INT_EN BIT(3)
#define B_AX_CPU_CHANNEL_ID_ERR_INT_EN BIT(2)
#define B_AX_CPU_PKT_FAIL_DBG_INT_EN BIT(1)
#define B_AX_CPU_CHANNEL_DIFF_ERR_INT_EN BIT(0)

#define R_AX_OTHER_DISPATCHER_ERR_IMR 0x8858
#define B_AX_OTHER_STF_WROQT_UNDERFLOW_INT_EN BIT(29)
#define B_AX_OTHER_STF_WROQT_OVERFLOW_INT_EN BIT(28)
#define B_AX_OTHER_STF_WRFF_UNDERFLOW_INT_EN BIT(27)
#define B_AX_OTHER_STF_WRFF_OVERFLOW_INT_EN BIT(26)
#define B_AX_OTHER_STF_CMD_UNDERFLOW_INT_EN BIT(25)
#define B_AX_OTHER_STF_CMD_OVERFLOW_INT_EN BIT(24)
#define B_AX_HOST_ADDR_INFO_LEN_ZERO_ERR_INT_EN BIT(17)
#define B_AX_CPU_ADDR_INFO_LEN_ZERO_ERR_INT_EN BIT(16)
#define B_AX_PLE_OUTPUT_ERR_INT_EN BIT(12)
#define B_AX_PLE_RESP_ERR_INT_EN BIT(11)
#define B_AX_PLE_BURST_NUM_ERR_INT_EN BIT(10)
#define B_AX_PLE_NULL_PKT_ERR_INT_EN BIT(9)
#define B_AX_PLE_FLOW_CTRL_ERR_INT_EN BIT(8)
#define B_AX_WDE_OUTPUT_ERR_INT_EN BIT(4)
#define B_AX_WDE_RESP_ERR_INT_EN BIT(3)
#define B_AX_WDE_BURST_NUM_ERR_INT_EN BIT(2)
#define B_AX_WDE_NULL_PKT_ERR_INT_EN BIT(1)
#define B_AX_WDE_FLOW_CTRL_ERR_INT_EN BIT(0)

#define R_AX_DISPATCHER_DBG_PORT 0x8860
#define B_AX_DISPATCHER_DBG_SEL_SH 8
#define B_AX_DISPATCHER_DBG_SEL_MSK 0xf
#define B_AX_DISPATCHER_INTN_SEL_SH 4
#define B_AX_DISPATCHER_INTN_SEL_MSK 0xf
#define B_AX_DISPATCHER_CH_SEL_SH 0
#define B_AX_DISPATCHER_CH_SEL_MSK 0xf

#define R_AX_HDP_DBG_INFO_4 0x8890
#define B_AX_ADDR_INFO_CS_SH 28
#define B_AX_ADDR_INFO_CS_MSK 0xf
#define B_AX_HCI_WP_FF_FULL BIT(27)
#define B_AX_AXI_WP_FF_FULL BIT(26)
#define B_AX_HFC_CH_FULL_SH 13
#define B_AX_HFC_CH_FULL_MSK 0x1fff
#define B_AX_HFC_CH_REQ_SH 0
#define B_AX_HFC_CH_REQ_MSK 0x1fff

#define R_AX_HDP_DBG_INFO_10 0x88A8
#define B_AX_DMA_ST_HDR_HDP_SH 20
#define B_AX_DMA_ST_HDR_HDP_MSK 0x7
#define B_AX_RX_ST_HDR_HDP_SH 16
#define B_AX_RX_ST_HDR_HDP_MSK 0x7

#define R_AX_RXAGG_0 0x8900
#define B_AX_RXAGG_EN BIT(31)
#define B_AX_RXAGG_DMA_STORE BIT(30)
#define B_AX_RXAGG_SW_EN BIT(29)
#define B_AX_RXAGG_SW_TRIG BIT(28)
#define B_AX_RXAGG_PKTNUM_TH_SH 16
#define B_AX_RXAGG_PKTNUM_TH_MSK 0xff
#define B_AX_RXAGG_TIMEOUT_TH_SH 8
#define B_AX_RXAGG_TIMEOUT_TH_MSK 0xff
#define B_AX_RXAGG_LEN_TH_SH 0
#define B_AX_RXAGG_LEN_TH_MSK 0xff

#define R_AX_RXAGG_1 0x8904
#define B_AX_RXAGG_SML_PKT_SIZE_SH 8
#define B_AX_RXAGG_SML_PKT_SIZE_MSK 0x7
#define B_AX_RXAGG_SML_PKTNUM_TH_SH 0
#define B_AX_RXAGG_SML_PKTNUM_TH_MSK 0x1f

#define R_AX_RXDMA_SETTING 0x8908
#define B_AX_PLE_BURST_READ BIT(24)
#define B_AX_REQ_DEPTH_SH 16
#define B_AX_REQ_DEPTH_MSK 0x3
#define B_AX_BULK_TH_OPT BIT(10)
#define B_AX_BURST_CNT_SH 8
#define B_AX_BURST_CNT_MSK 0x3
#define B_AX_BULK_SIZE_SH 0
#define B_AX_BULK_SIZE_MSK 0x3

#define R_AX_FWDL_CHECKSUM 0x890C
#define B_AX_FWDL_CHKSUM_SH 16
#define B_AX_FWDL_CHKSUM_MSK 0xffff
#define B_AX_FWDL_CHKSUM_VALID BIT(2)
#define B_AX_FWDL_CHKSUM_RESULT BIT(1)
#define B_AX_FWDL_CHKSUM_EN BIT(0)

#define R_AX_H2C_SETTING 0x8910
#define B_AX_CDR_REMOVE_H2C_WD BIT(0)

#define R_AX_RX_PPDU_STATUS_FW_MODE 0x8914
#define B_AX_HDR_PPDU_ENQ_WLCPU_EN BIT(31)
#define B_AX_CDR_PPDU_2_WLCPU_LEN_SH 0
#define B_AX_CDR_PPDU_2_WLCPU_LEN_MSK 0x3fff

#define R_AX_RX_TCPIP_CHECKSUM_FUNCTION 0x8918
#define B_AX_HDR_TCPIP_CHKSUM_EN BIT(0)

#define R_AX_RX_FC_BD_VALID_MASK 0x891C
#define B_AX_CDR_BD_MASK_SH 8
#define B_AX_CDR_BD_MASK_MSK 0x1f
#define B_AX_HDR_BD_MASK_SH 0
#define B_AX_HDR_BD_MASK_MSK 0x3

#define R_AX_RX_FUNCTION_STOP 0x8920
#define B_AX_HDR_RX_STOP BIT(0)

#define R_AX_HCI_FC_CTRL 0x8A00
#define B_AX_HCI_FC_CH12_FULL_COND_SH 10
#define B_AX_HCI_FC_CH12_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_WP_CH811_FULL_COND_SH 8
#define B_AX_HCI_FC_WP_CH811_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_WP_CH07_FULL_COND_SH 6
#define B_AX_HCI_FC_WP_CH07_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_WD_FULL_COND_SH 4
#define B_AX_HCI_FC_WD_FULL_COND_MSK 0x3
#define B_AX_HCI_FC_CH12_EN BIT(3)
#define B_AX_HCI_FC_MODE_SH 1
#define B_AX_HCI_FC_MODE_MSK 0x3
#define B_AX_HCI_FC_EN BIT(0)

#define R_AX_CH_PAGE_CTRL 0x8A04
#define B_AX_PREC_PAGE_CH12_SH 16
#define B_AX_PREC_PAGE_CH12_MSK 0xff
#define B_AX_PREC_PAGE_CH011_SH 0
#define B_AX_PREC_PAGE_CH011_MSK 0xff

#define R_AX_ACH011_INTRPT_STAT 0x8A08
#define B_AX_ACH11_INTRPT_STAT BIT(11)
#define B_AX_ACH10_INTRPT_STAT BIT(10)
#define B_AX_ACH9_INTRPT_STAT BIT(9)
#define B_AX_ACH8_INTRPT_STAT BIT(8)
#define B_AX_ACH7_INTRPT_STAT BIT(7)
#define B_AX_ACH6_INTRPT_STAT BIT(6)
#define B_AX_ACH5_INTRPT_STAT BIT(5)
#define B_AX_ACH4_INTRPT_STAT BIT(4)
#define B_AX_ACH3_INTRPT_STAT BIT(3)
#define B_AX_ACH2_INTRPT_STAT BIT(2)
#define B_AX_ACH1_INTRPT_STAT BIT(1)
#define B_AX_ACH0_INTRPT_STAT BIT(0)

#define R_AX_HCI_FC_ERR_FLAG 0x8A0C
#define B_AX_PUB_AVAL_PG_OFW BIT(10)
#define B_AX_PUB_AVAL_PG_UFW BIT(9)
#define B_AX_PUB_USE_PG_OFW BIT(8)
#define B_AX_PUB_USE_PG_UFW BIT(7)
#define B_AX_CH011_USE_PG_OFW BIT(6)
#define B_AX_CH011_USE_PG_UFW BIT(5)
#define B_AX_CH011_AVAL_PG_OFW BIT(4)
#define B_AX_CH011_AVAL_PG_UFW BIT(3)
#define B_AX_WP_REQ_PG_ERR BIT(2)
#define B_AX_CH12_REQ_PG_ERR BIT(1)
#define B_AX_CH011_REQ_PG_ERR BIT(0)

#define R_AX_ACH0_PAGE_CTRL 0x8A10
#define B_AX_ACH0_GRP BIT(31)
#define B_AX_ACH0_MAX_PG_SH 16
#define B_AX_ACH0_MAX_PG_MSK 0xfff
#define B_AX_ACH0_MIN_PG_SH 0
#define B_AX_ACH0_MIN_PG_MSK 0xfff

#define R_AX_ACH1_PAGE_CTRL 0x8A14
#define B_AX_ACH1_GRP BIT(31)
#define B_AX_ACH1_MAX_PG_SH 16
#define B_AX_ACH1_MAX_PG_MSK 0xfff
#define B_AX_ACH1_MIN_PG_SH 0
#define B_AX_ACH1_MIN_PG_MSK 0xfff

#define R_AX_ACH2_PAGE_CTRL 0x8A18
#define B_AX_ACH2_GRP BIT(31)
#define B_AX_ACH2_MAX_PG_SH 16
#define B_AX_ACH2_MAX_PG_MSK 0xfff
#define B_AX_ACH2_MIN_PG_SH 0
#define B_AX_ACH2_MIN_PG_MSK 0xfff

#define R_AX_ACH3_PAGE_CTRL 0x8A1C
#define B_AX_ACH3_GRP BIT(31)
#define B_AX_ACH3_MAX_PG_SH 16
#define B_AX_ACH3_MAX_PG_MSK 0xfff
#define B_AX_ACH3_MIN_PG_SH 0
#define B_AX_ACH3_MIN_PG_MSK 0xfff

#define R_AX_ACH4_PAGE_CTRL 0x8A20
#define B_AX_ACH4_GRP BIT(31)
#define B_AX_ACH4_MAX_PG_SH 16
#define B_AX_ACH4_MAX_PG_MSK 0xfff
#define B_AX_ACH4_MIN_PG_SH 0
#define B_AX_ACH4_MIN_PG_MSK 0xfff

#define R_AX_ACH5_PAGE_CTRL 0x8A24
#define B_AX_ACH5_GRP BIT(31)
#define B_AX_ACH5_MAX_PG_SH 16
#define B_AX_ACH5_MAX_PG_MSK 0xfff
#define B_AX_ACH5_MIN_PG_SH 0
#define B_AX_ACH5_MIN_PG_MSK 0xfff

#define R_AX_ACH6_PAGE_CTRL 0x8A28
#define B_AX_ACH6_GRP BIT(31)
#define B_AX_ACH6_MAX_PG_SH 16
#define B_AX_ACH6_MAX_PG_MSK 0xfff
#define B_AX_ACH6_MIN_PG_SH 0
#define B_AX_ACH6_MIN_PG_MSK 0xfff

#define R_AX_ACH7_PAGE_CTRL 0x8A2C
#define B_AX_ACH7_GRP BIT(31)
#define B_AX_ACH7_MAX_PG_SH 16
#define B_AX_ACH7_MAX_PG_MSK 0xfff
#define B_AX_ACH7_MIN_PG_SH 0
#define B_AX_ACH7_MIN_PG_MSK 0xfff

#define R_AX_CH8_PAGE_CTRL 0x8A30
#define B_AX_CH8_GRP BIT(31)
#define B_AX_CH8_MAX_PG_SH 16
#define B_AX_CH8_MAX_PG_MSK 0xfff
#define B_AX_CH8_MIN_PG_SH 0
#define B_AX_CH8_MIN_PG_MSK 0xfff

#define R_AX_CH9_PAGE_CTRL 0x8A34
#define B_AX_CH9_GRP BIT(31)
#define B_AX_CH9_MAX_PG_SH 16
#define B_AX_CH9_MAX_PG_MSK 0xfff
#define B_AX_CH9_MIN_PG_SH 0
#define B_AX_CH9_MIN_PG_MSK 0xfff

#define R_AX_CH10_PAGE_CTRL 0x8A38
#define B_AX_CH10_GRP BIT(31)
#define B_AX_CH10_MAX_PG_SH 16
#define B_AX_CH10_MAX_PG_MSK 0xfff
#define B_AX_CH10_MIN_PG_SH 0
#define B_AX_CH10_MIN_PG_MSK 0xfff

#define R_AX_CH11_PAGE_CTRL 0x8A3C
#define B_AX_CH11_GRP BIT(31)
#define B_AX_CH11_MAX_PG_SH 16
#define B_AX_CH11_MAX_PG_MSK 0xfff
#define B_AX_CH11_MIN_PG_SH 0
#define B_AX_CH11_MIN_PG_MSK 0xfff

#define R_AX_ACH0_PAGE_INFO 0x8A50
#define B_AX_ACH0_AVAL_PG_SH 16
#define B_AX_ACH0_AVAL_PG_MSK 0xfff
#define B_AX_ACH0_USE_PG_SH 0
#define B_AX_ACH0_USE_PG_MSK 0xfff

#define R_AX_ACH1_PAGE_INFO 0x8A54
#define B_AX_ACH1_AVAL_PG_SH 16
#define B_AX_ACH1_AVAL_PG_MSK 0xfff
#define B_AX_ACH1_USE_PG_SH 0
#define B_AX_ACH1_USE_PG_MSK 0xfff

#define R_AX_ACH2_PAGE_INFO 0x8A58
#define B_AX_ACH2_AVAL_PG_SH 16
#define B_AX_ACH2_AVAL_PG_MSK 0xfff
#define B_AX_ACH2_USE_PG_SH 0
#define B_AX_ACH2_USE_PG_MSK 0xfff

#define R_AX_ACH3_PAGE_INFO 0x8A5C
#define B_AX_ACH3_AVAL_PG_SH 16
#define B_AX_ACH3_AVAL_PG_MSK 0xfff
#define B_AX_ACH3_USE_PG_SH 0
#define B_AX_ACH3_USE_PG_MSK 0xfff

#define R_AX_ACH4_PAGE_INFO 0x8A60
#define B_AX_ACH4_AVAL_PG_SH 16
#define B_AX_ACH4_AVAL_PG_MSK 0xfff
#define B_AX_ACH4_USE_PG_SH 0
#define B_AX_ACH4_USE_PG_MSK 0xfff

#define R_AX_ACH5_PAGE_INFO 0x8A64
#define B_AX_ACH5_AVAL_PG_SH 16
#define B_AX_ACH5_AVAL_PG_MSK 0xfff
#define B_AX_ACH5_USE_PG_SH 0
#define B_AX_ACH5_USE_PG_MSK 0xfff

#define R_AX_ACH6_PAGE_INFO 0x8A68
#define B_AX_ACH6_AVAL_PG_SH 16
#define B_AX_ACH6_AVAL_PG_MSK 0xfff
#define B_AX_ACH6_USE_PG_SH 0
#define B_AX_ACH6_USE_PG_MSK 0xfff

#define R_AX_ACH7_PAGE_INFO 0x8A6C
#define B_AX_ACH7_AVAL_PG_SH 16
#define B_AX_ACH7_AVAL_PG_MSK 0xfff
#define B_AX_ACH7_USE_PG_SH 0
#define B_AX_ACH7_USE_PG_MSK 0xfff

#define R_AX_CH8_PAGE_INFO 0x8A70
#define B_AX_CH8_AVAL_PG_SH 16
#define B_AX_CH8_AVAL_PG_MSK 0xfff
#define B_AX_CH8_USE_PG_SH 0
#define B_AX_CH8_USE_PG_MSK 0xfff

#define R_AX_CH9_PAGE_INFO 0x8A74
#define B_AX_CH9_AVAL_PG_SH 16
#define B_AX_CH9_AVAL_PG_MSK 0xfff
#define B_AX_CH9_USE_PG_SH 0
#define B_AX_CH9_USE_PG_MSK 0xfff

#define R_AX_CH10_PAGE_INFO 0x8A78
#define B_AX_CH10_AVAL_PG_SH 16
#define B_AX_CH10_AVAL_PG_MSK 0xfff
#define B_AX_CH10_USE_PG_SH 0
#define B_AX_CH10_USE_PG_MSK 0xfff

#define R_AX_CH11_PAGE_INFO 0x8A7C
#define B_AX_CH11_AVAL_PG_SH 16
#define B_AX_CH11_AVAL_PG_MSK 0xfff
#define B_AX_CH11_USE_PG_SH 0
#define B_AX_CH11_USE_PG_MSK 0xfff

#define R_AX_CH12_PAGE_INFO 0x8A80
#define B_AX_CH12_AVAL_PG_SH 16
#define B_AX_CH12_AVAL_PG_MSK 0xfff

#define R_AX_PUB_PAGE_INFO3 0x8A8C
#define B_AX_G1_AVAL_PG_SH 16
#define B_AX_G1_AVAL_PG_MSK 0x1fff
#define B_AX_G0_AVAL_PG_SH 0
#define B_AX_G0_AVAL_PG_MSK 0x1fff

#define R_AX_PUB_PAGE_CTRL1 0x8A90
#define B_AX_PUBPG_G1_SH 16
#define B_AX_PUBPG_G1_MSK 0x1fff
#define B_AX_PUBPG_G0_SH 0
#define B_AX_PUBPG_G0_MSK 0x1fff

#define R_AX_PUB_PAGE_CTRL2 0x8A94
#define B_AX_PUBPG_ALL_SH 0
#define B_AX_PUBPG_ALL_MSK 0x1fff

#define R_AX_PUB_PAGE_INFO1 0x8A98
#define B_AX_G1_USE_PG_SH 16
#define B_AX_G1_USE_PG_MSK 0x1fff
#define B_AX_G0_USE_PG_SH 0
#define B_AX_G0_USE_PG_MSK 0x1fff

#define R_AX_PUB_PAGE_INFO2 0x8A9C
#define B_AX_PUB_AVAL_PG_SH 0
#define B_AX_PUB_AVAL_PG_MSK 0x1fff

#define R_AX_WP_PAGE_CTRL1 0x8AA0
#define B_AX_PREC_PAGE_WP_CH811_SH 16
#define B_AX_PREC_PAGE_WP_CH811_MSK 0x1ff
#define B_AX_PREC_PAGE_WP_CH07_SH 0
#define B_AX_PREC_PAGE_WP_CH07_MSK 0x1ff

#define R_AX_WP_PAGE_CTRL2 0x8AA4
#define B_AX_WP_THRD_SH 0
#define B_AX_WP_THRD_MSK 0x1fff

#define R_AX_WP_PAGE_INFO1 0x8AA8
#define B_AX_WP_AVAL_PG_SH 16
#define B_AX_WP_AVAL_PG_MSK 0x1fff

#define R_AX_ACH0_THR 0x8AB0
#define B_AX_ACH0_INTRPT_EN BIT(31)
#define B_AX_ACH0_THR_WP_SH 16
#define B_AX_ACH0_THR_WP_MSK 0xfff
#define B_AX_ACH0_THR_WD_SH 0
#define B_AX_ACH0_THR_WD_MSK 0xfff

#define R_AX_ACH1_THR 0x8AB4
#define B_AX_ACH1_INTRPT_EN BIT(31)
#define B_AX_ACH1_THR_WP_SH 16
#define B_AX_ACH1_THR_WP_MSK 0xfff
#define B_AX_ACH1_THR_WD_SH 0
#define B_AX_ACH1_THR_WD_MSK 0xfff

#define R_AX_ACH2_THR 0x8AB8
#define B_AX_ACH2_INTRPT_EN BIT(31)
#define B_AX_ACH2_THR_WP_SH 16
#define B_AX_ACH2_THR_WP_MSK 0xfff
#define B_AX_ACH2_THR_WD_SH 0
#define B_AX_ACH2_THR_WD_MSK 0xfff

#define R_AX_ACH3_THR 0x8ABC
#define B_AX_ACH3_INTRPT_EN BIT(31)
#define B_AX_ACH3_THR_WP_SH 16
#define B_AX_ACH3_THR_WP_MSK 0xfff
#define B_AX_ACH3_THR_WD_SH 0
#define B_AX_ACH3_THR_WD_MSK 0xfff

#define R_AX_ACH4_THR 0x8AC0
#define B_AX_ACH4_INTRPT_EN BIT(31)
#define B_AX_ACH4_THR_WP_SH 16
#define B_AX_ACH4_THR_WP_MSK 0xfff
#define B_AX_ACH4_THR_WD_SH 0
#define B_AX_ACH4_THR_WD_MSK 0xfff

#define R_AX_ACH5_THR 0x8AC4
#define B_AX_ACH5_INTRPT_EN BIT(31)
#define B_AX_ACH5_THR_WP_SH 16
#define B_AX_ACH5_THR_WP_MSK 0xfff
#define B_AX_ACH5_THR_WD_SH 0
#define B_AX_ACH5_THR_WD_MSK 0xfff

#define R_AX_ACH6_THR 0x8AC8
#define B_AX_ACH6_INTRPT_EN BIT(31)
#define B_AX_ACH6_THR_WP_SH 16
#define B_AX_ACH6_THR_WP_MSK 0xfff
#define B_AX_ACH6_THR_WD_SH 0
#define B_AX_ACH6_THR_WD_MSK 0xfff

#define R_AX_ACH7_THR 0x8ACC
#define B_AX_ACH7_INTRPT_EN BIT(31)
#define B_AX_ACH7_THR_WP_SH 16
#define B_AX_ACH7_THR_WP_MSK 0xfff
#define B_AX_ACH7_THR_WD_SH 0
#define B_AX_ACH7_THR_WD_MSK 0xfff

#define R_AX_CH8_THR 0x8AD0
#define B_AX_CH8_INTRPT_EN BIT(31)
#define B_AX_CH8_THR_WP_SH 16
#define B_AX_CH8_THR_WP_MSK 0xfff
#define B_AX_CH8_THR_WD_SH 0
#define B_AX_CH8_THR_WD_MSK 0xfff

#define R_AX_CH9_THR 0x8AD4
#define B_AX_CH9_INTRPT_EN BIT(31)
#define B_AX_CH9_THR_WP_SH 16
#define B_AX_CH9_THR_WP_MSK 0xfff
#define B_AX_CH9_THR_WD_SH 0
#define B_AX_CH9_THR_WD_MSK 0xfff

#define R_AX_CH10_THR 0x8AD8
#define B_AX_CH10_INTRPT_EN BIT(31)
#define B_AX_CH10_THR_WP_SH 16
#define B_AX_CH10_THR_WP_MSK 0xfff
#define B_AX_CH10_THR_WD_SH 0
#define B_AX_CH10_THR_WD_MSK 0xfff

#define R_AX_CH11_THR 0x8ADC
#define B_AX_CH11_INTRPT_EN BIT(31)
#define B_AX_CH11_THR_WP_SH 16
#define B_AX_CH11_THR_WP_MSK 0xfff
#define B_AX_CH11_THR_WD_SH 0
#define B_AX_CH11_THR_WD_MSK 0xfff

//
// HCI FC 8852C
//
#define R_AX_HCI_FC_CTRL_V1 0x1700

#define R_AX_CH_PAGE_CTRL_V1 0x1704

#define R_AX_ACH011_INTRPT_STAT_V1 0x1708

#define R_AX_HCI_FC_ERR_FLAG_V1 0x170C

#define R_AX_ACH0_PAGE_CTRL_V1 0x1710

#define R_AX_ACH1_PAGE_CTRL_V1 0x1714

#define R_AX_ACH2_PAGE_CTRL_V1 0x1718

#define R_AX_ACH3_PAGE_CTRL_V1 0x171C

#define R_AX_ACH4_PAGE_CTRL_V1 0x1720

#define R_AX_ACH5_PAGE_CTRL_V1 0x1724

#define R_AX_ACH6_PAGE_CTRL_V1 0x1728

#define R_AX_ACH7_PAGE_CTRL_V1 0x172C

#define R_AX_CH8_PAGE_CTRL_V1 0x1730

#define R_AX_CH9_PAGE_CTRL_V1 0x1734

#define R_AX_CH10_PAGE_CTRL_V1 0x1738

#define R_AX_CH11_PAGE_CTRL_V1 0x173C

#define R_AX_ACH0_PAGE_INFO_V1 0x1750

#define R_AX_ACH1_PAGE_INFO_V1 0x1754

#define R_AX_ACH2_PAGE_INFO_V1 0x1758

#define R_AX_ACH3_PAGE_INFO_V1 0x175C

#define R_AX_ACH4_PAGE_INFO_V1 0x1760

#define R_AX_ACH5_PAGE_INFO_V1 0x1764

#define R_AX_ACH6_PAGE_INFO_V1 0x1768

#define R_AX_ACH7_PAGE_INFO_V1 0x176C

#define R_AX_CH8_PAGE_INFO_V1 0x1770

#define R_AX_CH9_PAGE_INFO_V1 0x1774

#define R_AX_CH10_PAGE_INFO_V1 0x1778

#define R_AX_CH11_PAGE_INFO_V1 0x177C

#define R_AX_CH12_PAGE_INFO_V1 0x1780

#define R_AX_PUB_PAGE_INFO3_V1 0x178C

#define R_AX_PUB_PAGE_CTRL1_V1 0x1790

#define R_AX_PUB_PAGE_CTRL2_V1 0x1794

#define R_AX_PUB_PAGE_INFO1_V1 0x1798

#define R_AX_PUB_PAGE_INFO2_V1 0x179C

#define R_AX_WP_PAGE_CTRL1_V1 0x17A0

#define R_AX_WP_PAGE_CTRL2_V1 0x17A4

#define R_AX_WP_PAGE_INFO1_V1 0x17A8

#define R_AX_ACH0_THR_V1 0x17B0

#define R_AX_ACH1_THR_V1 0x17B4

#define R_AX_ACH2_THR_V1 0x17B8

#define R_AX_ACH3_THR_V1 0x17BC

#define R_AX_ACH4_THR_V1 0x17C0

#define R_AX_ACH5_THR_V1 0x17C4

#define R_AX_ACH6_THR_V1 0x17C8

#define R_AX_ACH7_THR_V1 0x17CC

#define R_AX_CH8_THR_V1 0x17D0

#define R_AX_CH9_THR_V1 0x17D4

#define R_AX_CH10_THR_V1 0x17D8

#define R_AX_CH11_THR_V1 0x17DC

//
// WDE_DLE
//

#define R_AX_WDE_PKTBUF_CFG 0x8C08
#define B_AX_WDE_FREE_PAGE_NUM_SH 16
#define B_AX_WDE_FREE_PAGE_NUM_MSK 0x1fff
#define B_AX_WDE_START_BOUND_SH 8
#define B_AX_WDE_START_BOUND_MSK 0x3f
#define B_AX_WDE_PAGE_SEL_SH 0
#define B_AX_WDE_PAGE_SEL_MSK 0x3

#define R_AX_WDE_ERR_FLAG_CFG 0x8C34
#define B_AX_WDE_DATCHN_FRZTMR_MODE BIT(2)
#define B_AX_WDE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_AX_WDE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_AX_WDE_ERR_IMR 0x8C38
#define B_AX_WDE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_WDE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_AX_WDE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_AX_WDE_BUFMGN_FRZTO_ERR_INT_EN BIT(7)
#define B_AX_WDE_GETNPG_PGOFST_ERR_INT_EN BIT(6)
#define B_AX_WDE_GETNPG_STRPG_ERR_INT_EN BIT(5)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(4)
#define B_AX_WDE_BUFRTN_SIZE_ERR_INT_EN BIT(3)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(2)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR_INT_EN BIT(1)
#define B_AX_WDE_BUFREQ_QTAID_ERR_INT_EN BIT(0)

#define R_AX_WDE_ERR_ISR 0x8C3C
#define B_AX_WDE_DATCHN_FRZTO_ERR BIT(26)
#define B_AX_WDE_DATCHN_NULLPG_ERR BIT(25)
#define B_AX_WDE_DATCHN_ARBT_ERR BIT(24)
#define B_AX_WDE_QUEMGN_FRZTO_ERR BIT(19)
#define B_AX_WDE_NXTPKTLL_AD_ERR BIT(18)
#define B_AX_WDE_PREPKTLLT_AD_ERR BIT(17)
#define B_AX_WDE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_AX_WDE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_AX_WDE_QUE_SRCQUEID_ERR BIT(14)
#define B_AX_WDE_QUE_DSTQUEID_ERR BIT(13)
#define B_AX_WDE_QUE_CMDTYPE_ERR BIT(12)
#define B_AX_WDE_BUFMGN_FRZTO_ERR BIT(7)
#define B_AX_WDE_GETNPG_PGOFST_ERR BIT(6)
#define B_AX_WDE_GETNPG_STRPG_ERR BIT(5)
#define B_AX_WDE_BUFREQ_SRCHTAILPG_ERR BIT(4)
#define B_AX_WDE_BUFRTN_SIZE_ERR BIT(3)
#define B_AX_WDE_BUFRTN_INVLD_PKTID_ERR BIT(2)
#define B_AX_WDE_BUFREQ_UNAVAL_ERR BIT(1)
#define B_AX_WDE_BUFREQ_QTAID_ERR BIT(0)

#define R_AX_WDE_QTA0_CFG 0x8C40
#define B_AX_WDE_Q0_MAX_SIZE_SH 16
#define B_AX_WDE_Q0_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q0_MIN_SIZE_SH 0
#define B_AX_WDE_Q0_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA1_CFG 0x8C44
#define B_AX_WDE_Q1_MAX_SIZE_SH 16
#define B_AX_WDE_Q1_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q1_MIN_SIZE_SH 0
#define B_AX_WDE_Q1_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA2_CFG 0x8C48
#define B_AX_WDE_Q2_MAX_SIZE_SH 16
#define B_AX_WDE_Q2_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q2_MIN_SIZE_SH 0
#define B_AX_WDE_Q2_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA3_CFG 0x8C4C
#define B_AX_WDE_Q3_MAX_SIZE_SH 16
#define B_AX_WDE_Q3_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q3_MIN_SIZE_SH 0
#define B_AX_WDE_Q3_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA4_CFG 0x8C50
#define B_AX_WDE_Q4_MAX_SIZE_SH 16
#define B_AX_WDE_Q4_MAX_SIZE_MSK 0xfff
#define B_AX_WDE_Q4_MIN_SIZE_SH 0
#define B_AX_WDE_Q4_MIN_SIZE_MSK 0xfff

#define R_AX_WDE_QTA5_CFG 0x8C54

#define R_AX_WDE_QTA6_CFG 0x8C58

#define R_AX_WDE_QTA7_CFG 0x8C5C

#define R_AX_WDE_QTA8_CFG 0x8C60

#define R_AX_WDE_QTA9_CFG 0x8C64

#define R_AX_WDE_QTA10_CFG 0x8C68

#define R_AX_WDE_QTA11_CFG 0x8C6C

#define R_AX_WDE_QTA12_CFG 0x8C70

#define R_AX_WDE_QTA13_CFG 0x8C74

#define R_AX_WDE_QTA14_CFG 0x8C78

#define R_AX_WDE_QTA15_CFG 0x8C7C

#define R_AX_WDE_INI_STATUS 0x8D00
#define B_AX_WDE_Q_MGN_INI_RDY BIT(1)
#define B_AX_WDE_BUF_MGN_INI_RDY BIT(0)

#define R_AX_WDE_DBG_FUN_INTF_CTL 0x8D10
#define B_AX_WDE_DFI_ACTIVE BIT(31)
#define B_AX_WDE_DFI_TRGSEL_SH 16
#define B_AX_WDE_DFI_TRGSEL_MSK 0xf
#define B_AX_WDE_DFI_ADDR_SH 0
#define B_AX_WDE_DFI_ADDR_MSK 0xffff

#define R_AX_WDE_DBG_FUN_INTF_DATA 0x8D14
#define B_AX_WDE_DFI_DATA_SH 0
#define B_AX_WDE_DFI_DATA_MSK 0xffffffffL

#define R_AX_WDE_DBG_CTL 0x8D18
#define B_AX_WDE_DBG1_SEL_SH 8
#define B_AX_WDE_DBG1_SEL_MSK 0xff
#define B_AX_WDE_DBG0_SEL_SH 0
#define B_AX_WDE_DBG0_SEL_MSK 0xff

#define R_AX_DBG_OUT 0x8D1C
#define B_AX_WDE_DBG1_OUT_SH 16
#define B_AX_WDE_DBG1_OUT_MSK 0xffff
#define B_AX_WDE_DBG0_OUT_SH 0
#define B_AX_WDE_DBG0_OUT_MSK 0xffff

#define R_AX_WDE_Q_STATUS_CFG 0x8D80
#define B_AX_WDE_Q_STATUS_SEL_SH 0
#define B_AX_WDE_Q_STATUS_SEL_MSK 0x7

#define R_AX_WDE_Q_STATUS_VAL 0x8D84
#define B_AX_WDE_Q_STATUS_VAL_SH 0
#define B_AX_WDE_Q_STATUS_VAL_MSK 0xffffffffL

//
// PLE_DLE
//

#define R_AX_PLE_PKTBUF_CFG 0x9008
#define B_AX_PLE_FREE_PAGE_NUM_SH 16
#define B_AX_PLE_FREE_PAGE_NUM_MSK 0x1fff
#define B_AX_PLE_START_BOUND_SH 8
#define B_AX_PLE_START_BOUND_MSK 0x3f
#define B_AX_PLE_PAGE_SEL_SH 0
#define B_AX_PLE_PAGE_SEL_MSK 0x3

#define R_AX_PLE_ERR_FLAG_CFG 0x9034
#define B_AX_PLE_DATCHN_FRZTMR_MODE BIT(2)
#define B_AX_PLE_QUEMGN_FRZTMR_MODE BIT(1)
#define B_AX_PLE_BUFMGN_FRZTMR_MODE BIT(0)

#define R_AX_PLE_ERR_IMR 0x9038
#define B_AX_PLE_DATCHN_FRZTO_ERR_INT_EN BIT(26)
#define B_AX_PLE_DATCHN_NULLPG_ERR_INT_EN BIT(25)
#define B_AX_PLE_DATCHN_ARBT_ERR_INT_EN BIT(24)
#define B_AX_PLE_QUEMGN_FRZTO_ERR_INT_EN BIT(19)
#define B_AX_PLE_NXTPKTLL_AD_ERR_INT_EN BIT(18)
#define B_AX_PLE_PREPKTLLT_AD_ERR_INT_EN BIT(17)
#define B_AX_PLE_ENQ_PKTCNT_NVAL_ERR_INT_EN BIT(16)
#define B_AX_PLE_ENQ_PKTCNT_OVRF_ERR_INT_EN BIT(15)
#define B_AX_PLE_QUE_SRCQUEID_ERR_INT_EN BIT(14)
#define B_AX_PLE_QUE_DSTQUEID_ERR_INT_EN BIT(13)
#define B_AX_PLE_QUE_CMDTYPE_ERR_INT_EN BIT(12)
#define B_AX_PLE_BUFMGN_FRZTO_ERR_INT_EN BIT(7)
#define B_AX_PLE_GETNPG_PGOFST_ERR_INT_EN BIT(6)
#define B_AX_PLE_GETNPG_STRPG_ERR_INT_EN BIT(5)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR_INT_EN BIT(4)
#define B_AX_PLE_BUFRTN_SIZE_ERR_INT_EN BIT(3)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR_INT_EN BIT(2)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR_INT_EN BIT(1)
#define B_AX_PLE_BUFREQ_QTAID_ERR_INT_EN BIT(0)

#define R_AX_PLE_ERR_FLAG_ISR 0x903C
#define B_AX_PLE_DATCHN_FRZTO_ERR BIT(26)
#define B_AX_PLE_DATCHN_NULLPG_ERR BIT(25)
#define B_AX_PLE_DATCHN_ARBT_ERR BIT(24)
#define B_AX_PLE_QUEMGN_FRZTO_ERR BIT(19)
#define B_AX_PLE_NXTPKTLL_AD_ERR BIT(18)
#define B_AX_PLE_PREPKTLLT_AD_ERR BIT(17)
#define B_AX_PLE_ENQ_PKTCNT_NVAL_ERR BIT(16)
#define B_AX_PLE_ENQ_PKTCNT_OVRF_ERR BIT(15)
#define B_AX_PLE_QUE_SRCQUEID_ERR BIT(14)
#define B_AX_PLE_QUE_DSTQUEID_ERR BIT(13)
#define B_AX_PLE_QUE_CMDTYPE_ERR BIT(12)
#define B_AX_PLE_BUFMGN_FRZTO_ERR BIT(7)
#define B_AX_PLE_GETNPG_PGOFST_ERR BIT(6)
#define B_AX_PLE_GETNPG_STRPG_ERR BIT(5)
#define B_AX_PLE_BUFREQ_SRCHTAILPG_ERR BIT(4)
#define B_AX_PLE_BUFRTN_SIZE_ERR BIT(3)
#define B_AX_PLE_BUFRTN_INVLD_PKTID_ERR BIT(2)
#define B_AX_PLE_BUFREQ_UNAVAL_ERR BIT(1)
#define B_AX_PLE_BUFREQ_QTAID_ERR BIT(0)

#define R_AX_PLE_QTA0_CFG 0x9040
#define B_AX_PLE_Q0_MAX_SIZE_SH 16
#define B_AX_PLE_Q0_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q0_MIN_SIZE_SH 0
#define B_AX_PLE_Q0_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA1_CFG 0x9044
#define B_AX_PLE_Q1_MAX_SIZE_SH 16
#define B_AX_PLE_Q1_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q1_MIN_SIZE_SH 0
#define B_AX_PLE_Q1_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA2_CFG 0x9048
#define B_AX_PLE_Q2_MAX_SIZE_SH 16
#define B_AX_PLE_Q2_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q2_MIN_SIZE_SH 0
#define B_AX_PLE_Q2_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA3_CFG 0x904C
#define B_AX_PLE_Q3_MAX_SIZE_SH 16
#define B_AX_PLE_Q3_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q3_MIN_SIZE_SH 0
#define B_AX_PLE_Q3_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA4_CFG 0x9050
#define B_AX_PLE_Q4_MAX_SIZE_SH 16
#define B_AX_PLE_Q4_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q4_MIN_SIZE_SH 0
#define B_AX_PLE_Q4_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA5_CFG 0x9054
#define B_AX_PLE_Q5_MAX_SIZE_SH 16
#define B_AX_PLE_Q5_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q5_MIN_SIZE_SH 0
#define B_AX_PLE_Q5_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA6_CFG 0x9058
#define B_AX_PLE_Q6_MAX_SIZE_SH 16
#define B_AX_PLE_Q6_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q6_MIN_SIZE_SH 0
#define B_AX_PLE_Q6_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA7_CFG 0x905C
#define B_AX_PLE_Q7_MAX_SIZE_SH 16
#define B_AX_PLE_Q7_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q7_MIN_SIZE_SH 0
#define B_AX_PLE_Q7_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA8_CFG 0x9060
#define B_AX_PLE_Q8_MAX_SIZE_SH 16
#define B_AX_PLE_Q8_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q8_MIN_SIZE_SH 0
#define B_AX_PLE_Q8_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA9_CFG 0x9064
#define B_AX_PLE_Q9_MAX_SIZE_SH 16
#define B_AX_PLE_Q9_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q9_MIN_SIZE_SH 0
#define B_AX_PLE_Q9_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA10_CFG 0x9068
#define B_AX_PLE_Q10_MAX_SIZE_SH 16
#define B_AX_PLE_Q10_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q10_MIN_SIZE_SH 0
#define B_AX_PLE_Q10_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA11_CFG 0x906C
#define B_AX_PLE_Q11_MAX_SIZE_SH 16
#define B_AX_PLE_Q11_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q11_MIN_SIZE_SH 0
#define B_AX_PLE_Q11_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA12_CFG 0x9070
#define B_AX_PLE_Q12_MAX_SIZE_SH 16
#define B_AX_PLE_Q12_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q12_MIN_SIZE_SH 0
#define B_AX_PLE_Q12_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA13_CFG 0x9074
#define B_AX_PLE_Q13_MAX_SIZE_SH 16
#define B_AX_PLE_Q13_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q13_MIN_SIZE_SH 0
#define B_AX_PLE_Q13_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA14_CFG 0x9078
#define B_AX_PLE_Q14_MAX_SIZE_SH 16
#define B_AX_PLE_Q14_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q14_MIN_SIZE_SH 0
#define B_AX_PLE_Q14_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_QTA15_CFG 0x907C
#define B_AX_PLE_Q15_MAX_SIZE_SH 16
#define B_AX_PLE_Q15_MAX_SIZE_MSK 0xfff
#define B_AX_PLE_Q15_MIN_SIZE_SH 0
#define B_AX_PLE_Q15_MIN_SIZE_MSK 0xfff

#define R_AX_PLE_INI_STATUS 0x9100
#define B_AX_PLE_Q_MGN_INI_RDY BIT(1)
#define B_AX_PLE_BUF_MGN_INI_RDY BIT(0)

#define R_AX_PLE_DBG_FUN_INTF_CTL 0x9110
#define B_AX_PLE_DFI_ACTIVE BIT(31)
#define B_AX_PLE_DFI_TRGSEL_SH 16
#define B_AX_PLE_DFI_TRGSEL_MSK 0xf
#define B_AX_PLE_DFI_ADDR_SH 0
#define B_AX_PLE_DFI_ADDR_MSK 0xffff

#define R_AX_PLE_DBG_FUN_INTF_DATA 0x9114
#define B_AX_PLE_DFI_DATA_SH 0
#define B_AX_PLE_DFI_DATA_MSK 0xffffffffL

#define R_AX_PLE_DBG_CTL 0x9118
#define B_AX_PLE_DBG1_SEL_SH 8
#define B_AX_PLE_DBG1_SEL_MSK 0xff
#define B_AX_PLE_DBG0_SEL_SH 0
#define B_AX_PLE_DBG0_SEL_MSK 0xff

#define R_AX_PLE_DBG_OUT 0x911C
#define B_AX_PLE_DBG1_OUT_SH 16
#define B_AX_PLE_DBG1_OUT_MSK 0xffff
#define B_AX_PLE_DBG0_OUT_SH 0
#define B_AX_PLE_DBG0_OUT_MSK 0xffff

//
// WDRLS
//

#define R_AX_WDRLS_CFG 0x9408
#define B_AX_RLSRPT_BUFREQ_TO_SH 8
#define B_AX_RLSRPT_BUFREQ_TO_MSK 0xff
#define B_AX_WDRLS_MODE_SH 0
#define B_AX_WDRLS_MODE_MSK 0x3

#define R_AX_RLSRPT0_CFG0 0x9410
#define B_AX_RLSRPT0_FLTR_MAP_SH 24
#define B_AX_RLSRPT0_FLTR_MAP_MSK 0xf
#define B_AX_RLSRPT0_PKTTYPE_SH 16
#define B_AX_RLSRPT0_PKTTYPE_MSK 0xf
#define B_AX_RLSRPT0_PID_SH 8
#define B_AX_RLSRPT0_PID_MSK 0x7
#define B_AX_RLSRPT0_QID_SH 0
#define B_AX_RLSRPT0_QID_MSK 0x3f

#define R_AX_RLSRPT0_CFG1 0x9414
#define B_AX_RLSRPT0_TO_SH 16
#define B_AX_RLSRPT0_TO_MSK 0xff
#define B_AX_RLSRPT0_AGGNUM_SH 0
#define B_AX_RLSRPT0_AGGNUM_MSK 0xff

#define R_AX_RLSRPT1_CFG0 0x9420
#define B_AX_RLSRPT1_FLTR_MAP_SH 24
#define B_AX_RLSRPT1_FLTR_MAP_MSK 0xf
#define B_AX_RLSRPT1_PKTTYPE_SH 16
#define B_AX_RLSRPT1_PKTTYPE_MSK 0xf
#define B_AX_RLSRPT1_PID_SH 8
#define B_AX_RLSRPT1_PID_MSK 0x7
#define B_AX_RLSRPT1_QID_SH 0
#define B_AX_RLSRPT1_QID_MSK 0x3f

#define R_AX_RLSRPT1_CFG1 0x9424
#define B_AX_RLSRPT1_TO_SH 16
#define B_AX_RLSRPT1_TO_MSK 0xff
#define B_AX_RLSRPT1_AGGNUM_SH 0
#define B_AX_RLSRPT1_AGGNUM_MSK 0xff

#define R_AX_WDRLS_ERR_IMR 0x9430
#define B_AX_WDRLS_RPT1_FRZTO_ERR_INT_EN BIT(13)
#define B_AX_WDRLS_RPT1_AGGNUM0_ERR_INT_EN BIT(12)
#define B_AX_WDRLS_RPT0_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_WDRLS_RPT0_AGGNUM0_ERR_INT_EN BIT(8)
#define B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR_INT_EN BIT(5)
#define B_AX_WDRLS_PLEBREQ_TO_ERR_INT_EN BIT(4)
#define B_AX_WDRLS_CTL_FRZTO_ERR_INT_EN BIT(2)
#define B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR_INT_EN BIT(1)
#define B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR_INT_EN BIT(0)

#define R_AX_WDRLS_ERR_ISR 0x9434
#define B_AX_WDRLS_RPT1_FRZTO_ERR BIT(13)
#define B_AX_WDRLS_RPT1_AGGNUM_ERR BIT(12)
#define B_AX_WDRLS_RPT0_FRZTO_ERR BIT(9)
#define B_AX_WDRLS_RPT0_AGGNUM0_ERR BIT(8)
#define B_AX_WDRLS_PLEBREQ_PKTID_ISNULL_ERR BIT(5)
#define B_AX_WDRLS_PLEBREQ_TO_ERR BIT(4)
#define B_AX_WDRLS_CTL_FRZTO_ERR BIT(2)
#define B_AX_WDRLS_CTL_PLPKTID_ISNULL_ERR BIT(1)
#define B_AX_WDRLS_CTL_WDPKTID_ISNULL_ERR BIT(0)

#define R_AX_DBG_CTL_WDRLS 0x9438
#define B_AX_DBG1_SEL_SH 8
#define B_AX_DBG1_SEL_MSK 0xff
#define B_AX_DBG0_SEL_SH 0
#define B_AX_DBG0_SEL_MSK 0xff

#define R_AX_DBG_OUT_WDRLS 0x943C
#define B_AX_DBG1_OUT_SH 16
#define B_AX_DBG1_OUT_MSK 0xffff
#define B_AX_DBG0_OUT_SH 0
#define B_AX_DBG0_OUT_MSK 0xffff

//
// BBRPT
//

#define R_AX_COM_CFG 0x9600

#define R_AX_BB_COEX_CFG 0x9604
#define B_AX_DFS_THR_SH 8
#define B_AX_DFS_THR_MSK 0xf
#define B_AX_BBRPT_COEX_EN BIT(0)

#define R_AX_BBRPT_COM_ERR_IMR_ISR 0x960C
#define B_AX_BBRPT_COM__NULL_PLPKTID_ERR BIT(16)
#define B_AX_BBRPT_COM_NULL_PLPKTID_ERR_INT_EN BIT(0)

#define R_AX_CH_INFO 0x9620
#define B_AX_CH_INFO_QID_SH 24
#define B_AX_CH_INFO_QID_MSK 0x3f
#define B_AX_CH_INFO_PRTID_SH 20
#define B_AX_CH_INFO_PRTID_MSK 0x7
#define B_AX_CH_INFO_REQ_SH 18
#define B_AX_CH_INFO_REQ_MSK 0x3
#define B_AX_CH_INFO_SEG_SH 16
#define B_AX_CH_INFO_SEG_MSK 0x3
#define B_AX_CH_INFO_INTVL_SH 12
#define B_AX_CH_INFO_INTVL_MSK 0xf
#define B_AX_GET_CH_INFO_TO_SH 9
#define B_AX_GET_CH_INFO_TO_MSK 0x7
#define B_AX_CH_INFO_PHY BIT(8)
#define B_AX_CH_INFO_BUF_SH 6
#define B_AX_CH_INFO_BUF_MSK 0x3
#define B_AX_CH_INFO_STOP BIT(5)
#define B_AX_CH_INFO_STOP_REQ BIT(4)
#define B_AX_CH_INFO_ON BIT(3)
#define B_AX_CH_INFO_EN BIT(0)

#define R_AX_BBRPT_CHINFO_ERR_IMR_ISR 0x962C
#define B_AX_BBPRT_CHIF_TO_ERR BIT(23)
#define B_AX_BBPRT_CHIF_NULL_ERR BIT(22)
#define B_AX_BBPRT_CHIF_LEFT2_ERR BIT(21)
#define B_AX_BBPRT_CHIF_LEFT1_ERR BIT(20)
#define B_AX_BBPRT_CHIF_HDRL_ERR BIT(19)
#define B_AX_BBPRT_CHIF_BOVF_ERR BIT(18)
#define B_AX_BBPRT_CHIF_OVF_ERR BIT(17)
#define B_AX_BBPRT_CHIF_BB_TO_ERR BIT(16)
#define B_AX_BBPRT_CHIF_TO_ERR_INT_EN BIT(7)
#define B_AX_BBPRT_CHIF_NULL_ERR_INT_EN BIT(6)
#define B_AX_BBPRT_CHIF_LEFT2_ERR_INT_EN BIT(5)
#define B_AX_BBPRT_CHIF_LEFT1_ERR_INT_EN BIT(4)
#define B_AX_BBPRT_CHIF_HDRL_ERR_INT_EN BIT(3)
#define B_AX_BBPRT_CHIF_BOVF_ERR_INT_EN BIT(2)
#define B_AX_BBPRT_CHIF_OVF_ERR_INT_EN BIT(1)
#define B_AX_BBPRT_CHIF_BB_TO_ERR_INT_EN BIT(0)

#define R_AX_DFS_CFG0 0x9630
#define B_AX_DFS_QID_SH 24
#define B_AX_DFS_QID_MSK 0x3f
#define B_AX_DFS_PRTID_SH 20
#define B_AX_DFS_PRTID_MSK 0x7
#define B_AX_DFS_TIME_TH_SH 10
#define B_AX_DFS_TIME_TH_MSK 0x3
#define B_AX_DFS_NUM_TH_SH 8
#define B_AX_DFS_NUM_TH_MSK 0x3
#define B_AX_DFS_BUF_SH 6
#define B_AX_DFS_BUF_MSK 0x3
#define B_AX_DFS_IN_STOP BIT(5)
#define B_AX_STOP_DFS BIT(4)
#define B_AX_DFS_RPT_EN BIT(0)

#define R_AX_BBRPT_DFS_ERR_IMR_ISR 0x963C
#define B_AX_BBRPT_DFS_TO_ERR BIT(16)
#define B_AX_BBRPT_DFS_TO_ERR_INT_EN BIT(0)

#define R_AX_LA_CFG 0x9660
#define B_AX_LA_TRIG_TIME_VAL_SH 24
#define B_AX_LA_TRIG_TIME_VAL_MSK 0x7f
#define B_AX_LA_TRIG_TU_SEL_SH 20
#define B_AX_LA_TRIG_TU_SEL_MSK 0xf
#define B_AX_LA_BUF_SEL_SH 16
#define B_AX_LA_BUF_SEL_MSK 0xf
#define B_AX_LA_BUF_BNDY_SH 8
#define B_AX_LA_BUF_BNDY_MSK 0x3f
#define B_AX_LA_TO_VAL_SH 6
#define B_AX_LA_TO_VAL_MSK 0x3
#define B_AX_LA_TO_EN BIT(5)
#define B_AX_LA_RESTART_EN BIT(4)
#define B_AX_LA_TRIG_START BIT(3)
#define B_AX_LA_FEN BIT(0)

#define R_AX_LA_STATUS 0x9664
#define B_AX_LA_SW_FSMST_SH 17
#define B_AX_LA_SW_FSMST_MSK 0x7
#define B_AX_LA_BUF_RNDUP BIT(16)
#define B_AX_LA_BUF_WPTR_SH 0
#define B_AX_LA_BUF_WPTR_MSK 0xFFFF

#define R_AX_LA_ERRFLAG 0x966C
#define B_AX_LA_ISR_DATA_LOSS_ERR BIT(16)
#define B_AX_LA_IMR_DATA_LOSS_ERR BIT(0)

//
// CPUIO
//

#define R_AX_WD_BUF_REQ 0x9800
#define B_AX_WD_BUF_REQ_EXEC BIT(31)
#define B_AX_WD_BUF_REQ_QUOTA_ID_SH 16
#define B_AX_WD_BUF_REQ_QUOTA_ID_MSK 0xff
#define B_AX_WD_BUF_REQ_LEN_SH 0
#define B_AX_WD_BUF_REQ_LEN_MSK 0xffff

#define R_AX_WD_BUF_STATUS 0x9804
#define B_AX_WD_BUF_STAT_DONE BIT(31)
#define B_AX_WD_BUF_STAT_PKTID_SH 0
#define B_AX_WD_BUF_STAT_PKTID_MSK 0xfff

#define R_AX_WD_QUOTA_STATUS 0x9808

#define R_AX_WD_CPUQ_OP_0 0x9810
#define B_AX_WD_CPUQ_OP_EXEC BIT(31)
#define B_AX_WD_CPUQ_OP_CMD_TYPE_SH 24
#define B_AX_WD_CPUQ_OP_CMD_TYPE_MSK 0xf
#define B_AX_WD_CPUQ_OP_MACID_SH 16
#define B_AX_WD_CPUQ_OP_MACID_MSK 0xff
#define B_AX_WD_CPUQ_OP_PKTNUM_SH 0
#define B_AX_WD_CPUQ_OP_PKTNUM_MSK 0xff

#define R_AX_WD_CPUQ_OP_1 0x9814
#define B_AX_WD_CPUQ_OP_SRC_PID_SH 22
#define B_AX_WD_CPUQ_OP_SRC_PID_MSK 0x7
#define B_AX_WD_CPUQ_OP_SRC_QID_SH 16
#define B_AX_WD_CPUQ_OP_SRC_QID_MSK 0x3f
#define B_AX_WD_CPUQ_OP_DST_PID_SH 6
#define B_AX_WD_CPUQ_OP_DST_PID_MSK 0x7
#define B_AX_WD_CPUQ_OP_DST_QID_SH 0
#define B_AX_WD_CPUQ_OP_DST_QID_MSK 0x3f

#define R_AX_WD_CPUQ_OP_2 0x9818
#define B_AX_WD_CPUQ_OP_STRT_PKTID_SH 16
#define B_AX_WD_CPUQ_OP_STRT_PKTID_MSK 0xfff
#define B_AX_WD_CPUQ_OP_END_PKTID_SH 0
#define B_AX_WD_CPUQ_OP_END_PKTID_MSK 0xfff

#define R_AX_WD_CPUQ_OP_STATUS 0x981C
#define B_AX_WD_CPUQ_OP_STAT_DONE BIT(31)
#define B_AX_WD_CPUQ_OP_PKTID_SH 0
#define B_AX_WD_CPUQ_OP_PKTID_MSK 0xfff

#define R_AX_PL_BUF_REQ 0x9820
#define B_AX_PL_BUF_REQ_EXEC BIT(31)
#define B_AX_PL_BUF_REQ_QUOTA_ID_SH 16
#define B_AX_PL_BUF_REQ_QUOTA_ID_MSK 0xf
#define B_AX_PL_BUF_REQ_LEN_SH 0
#define B_AX_PL_BUF_REQ_LEN_MSK 0xffff

#define R_AX_PL_BUF_STATUS 0x9824
#define B_AX_PL_BUF_STAT_DONE BIT(31)
#define B_AX_PL_BUF_STAT_PKTID_SH 0
#define B_AX_PL_BUF_STAT_PKTID_MSK 0xfff

#define R_AX_PL_QUOTA_STATUS 0x9828

#define R_AX_PL_CPUQ_OP_0 0x9830
#define B_AX_PL_CPUQ_OP_EXEC BIT(31)
#define B_AX_PL_CPUQ_OP_CMD_TYPE_SH 24
#define B_AX_PL_CPUQ_OP_CMD_TYPE_MSK 0xf
#define B_AX_PL_CPUQ_OP_MACID_SH 16
#define B_AX_PL_CPUQ_OP_MACID_MSK 0xff
#define B_AX_PL_CPUQ_OP_PKTNUM_SH 0
#define B_AX_PL_CPUQ_OP_PKTNUM_MSK 0xff

#define R_AX_PL_CPUQ_OP_1 0x9834
#define B_AX_PL_CPUQ_OP_SRC_PID_SH 22
#define B_AX_PL_CPUQ_OP_SRC_PID_MSK 0x7
#define B_AX_PL_CPUQ_OP_SRC_QID_SH 16
#define B_AX_PL_CPUQ_OP_SRC_QID_MSK 0x3f
#define B_AX_PL_CPUQ_OP_DST_PID_SH 6
#define B_AX_PL_CPUQ_OP_DST_PID_MSK 0x7
#define B_AX_PL_CPUQ_OP_DST_QID_SH 0
#define B_AX_PL_CPUQ_OP_DST_QID_MSK 0x3f

#define R_AX_PL_CPUQ_OP_2 0x9838
#define B_AX_PL_CPUQ_OP_STRT_PKTID_SH 16
#define B_AX_PL_CPUQ_OP_STRT_PKTID_MSK 0xfff
#define B_AX_PL_CPUQ_OP_END_PKTID_SH 0
#define B_AX_PL_CPUQ_OP_END_PKTID_MSK 0xfff

#define R_AX_PL_CPUQ_OP_STATUS 0x983C
#define B_AX_PL_CPUQ_OP_STAT_DONE BIT(31)
#define B_AX_PL_CPUQ_OP_PKTID_SH 0
#define B_AX_PL_CPUQ_OP_PKTID_MSK 0xfff

#define R_AX_CPUIO_ERR_IMR 0x9840
#define B_AX_PLEQUE_OP_ERR_INT_EN BIT(12)
#define B_AX_PLEBUF_OP_ERR_INT_EN BIT(8)
#define B_AX_WDEQUE_OP_ERR_INT_EN BIT(4)
#define B_AX_WDEBUF_OP_ERR_INT_EN BIT(0)

#define R_AX_CPUIO_ERR_ISR 0x9844
#define B_AX_PLEQUE_OP_ERR BIT(12)
#define B_AX_PLEBUF_OP_ERR BIT(8)
#define B_AX_ERR_WDEQUE_OP_ERR BIT(4)
#define B_AX_ERR_WDEBUF_OP_ERR BIT(0)

#define R_AX_SEC_ERR_IMR_ISR 0x991C
#define B_AX_SEC_TRX_TIMEOUT_INT_EN BIT(3)
#define B_AX_SEC_RX_TIMEOUT_ISR BIT(2)
#define B_AX_SEC_TX_TIMEOUT_ISR BIT(1)

//
// PKTIN
//

#define R_AX_PKTIN_SETTING 0x9A00
#define B_AX_WD_ADDR_INFO_LENGTH BIT(1)
#define B_AX_PKTIN_CLK_GATING_DIS BIT(0)

#define R_AX_HWAMSDU_CTRL 0x9A04
#define B_AX_MAX_AMSDU_NUM_SH 3
#define B_AX_MAX_AMSDU_NUM_MSK 0x3
#define B_AX_SINGLE_AMSDU BIT(2)
#define B_AX_HWAMSDU_EN BIT(0)

#define R_AX_HWAMSDU_STATUS 0x9A08
#define B_AX_AMSDU_PKT_SIZE_ERR BIT(31)
#define B_AX_AMSDU_EN_ERR BIT(30)
#define B_AX_AMSDU_ADDR_INFO_ERR BIT(29)

#define R_AX_HW_SEQ_0_1 0x9A0C
#define B_AX_HW_SEQ1_SH 16
#define B_AX_HW_SEQ1_MSK 0xfff
#define B_AX_HW_SEQ0_SH 0
#define B_AX_HW_SEQ0_MSK 0xfff

#define R_AX_HW_SEQ_2_3 0x9A10
#define B_AX_HW_SEQ3_SH 16
#define B_AX_HW_SEQ3_MSK 0xfff
#define B_AX_HW_SEQ2_SH 0
#define B_AX_HW_SEQ2_MSK 0xfff

#define R_AX_TXPKTIN_CTRL 0x9A14
#define B_AX_C1P4_TXPKTIN_STS BIT(25)
#define B_AX_C1P3_TXPKTIN_STS BIT(24)
#define B_AX_C1P2_TXPKTIN_STS BIT(23)
#define B_AX_C1P1_TXPKTIN_STS BIT(22)
#define B_AX_C1P0_TXPKTIN_STS BIT(21)
#define B_AX_C0P4_TXPKTIN_STS BIT(20)
#define B_AX_C0P3_TXPKTIN_STS BIT(19)
#define B_AX_C0P2_TXPKTIN_STS BIT(18)
#define B_AX_C0P1_TXPKTIN_STS BIT(17)
#define B_AX_C0P0_TXPKTIN_STS BIT(16)
#define B_AX_TXPKTIN_CTRL_EN BIT(15)
#define B_AX_C1P4_TXPKTIN_EN BIT(9)
#define B_AX_C1P3_TXPKTIN_EN BIT(8)
#define B_AX_C1P2_TXPKTIN_EN BIT(7)
#define B_AX_C1P1_TXPKTIN_EN BIT(6)
#define B_AX_C1P0_TXPKTIN_EN BIT(5)
#define B_AX_C0P4_TXPKTIN_EN BIT(4)
#define B_AX_C0P3_TXPKTIN_EN BIT(3)
#define B_AX_C0P2_TXPKTIN_EN BIT(2)
#define B_AX_C0P1_TXPKTIN_EN BIT(1)
#define B_AX_C0P0_TXPKTIN_EN BIT(0)

#define R_AX_TXPKTIN_DBG_SEL 0x9A18
#define B_AX_TXPKTIN_DBG_SEL_SH 0
#define B_AX_TXPKTIN_DBG_SEL_MSK 0xf

#define R_AX_PKTIN_ERR_IMR 0x9A20
#define B_AX_PKTIN_GETPKTID_ERR_INT_EN BIT(0)

#define R_AX_PKTIN_ERR_ISR 0x9A24
#define B_AX_PKTIN_GETPKTID_ERR_ISR BIT(0)

//
// MPDU_Processor_1
//

#define R_AX_HDR_SHCUT_SETTING 0x9B00
#define B_AX_MAC_MPDU_PROC_EN BIT(2)
#define B_AX_SHCUT_LLC_WR_LOCK BIT(1)
#define B_AX_SHCUT_PARSE_DASA BIT(0)

#define R_AX_SHCUT_LLC_ETH_TYPE0 0x9B04
#define B_AX_SHUT_ETH_TYPE1_SH 16
#define B_AX_SHUT_ETH_TYPE1_MSK 0xffff
#define B_AX_SHUT_ETH_TYPE0_SH 0
#define B_AX_SHUT_ETH_TYPE0_MSK 0xffff

#define R_AX_SHCUT_LLC_ETH_TYPE1 0x9B08
#define B_AX_SHUT_ETH_TYPE2_SH 0
#define B_AX_SHUT_ETH_TYPE2_MSK 0xffff

#define R_AX_SHCUT_LLC_OUI0 0x9B0C
#define B_AX_SHUT_ENABLE_OUI0 BIT(24)
#define B_AX_SHUT_ETH_OUI0_SH 0
#define B_AX_SHUT_ETH_OUI0_MSK 0xffffff

#define R_AX_SHCUT_LLC_OUI1 0x9B10
#define B_AX_SHUT_ENABLE_OUI1 BIT(24)
#define B_AX_SHUT_ETH_OUI1_SH 0
#define B_AX_SHUT_ETH_OUI1_MSK 0xffffff

#define R_AX_SHCUT_LLC_OUI2 0x9B14
#define B_AX_SHUT_ENABLE_OUI2 BIT(24)
#define B_AX_SHUT_ETH_OUI2_SH 0
#define B_AX_SHUT_ETH_OUI2_MSK 0xffffff

#define R_AX_SHCUT_LLC_OUI3 0x9B18
#define B_AX_SHUT_ENABLE_OUI3 BIT(24)
#define B_AX_SHUT_ETH_OUI3_SH 0
#define B_AX_SHUT_ETH_OUI3_MSK 0xffffff

#define R_AX_TX_PTK_CNT 0x9BEC
#define B_AX_TX_PTKOUT_CNT_SH 16
#define B_AX_TX_PTKOUT_CNT_MSK 0xffff
#define B_AX_TX_PKTIN_CNT_SH 0
#define B_AX_TX_PKTIN_CNT_MSK 0xffff

#define R_AX_MPDU_TX_ERR_ISR 0x9BF0
#define B_AX_TX_HDR3_SIZE_ERR BIT(5)
#define B_AX_TX_OFFSET_ERR BIT(4)
#define B_AX_TX_MPDU_SIZE_ZERO_ERR BIT(3)
#define B_AX_TX_NXT_ERRPKTID_ERR BIT(2)
#define B_AX_TX_GET_ERRPKTID_ERR BIT(1)

#define R_AX_MPDU_TX_ERR_IMR 0x9BF4
#define B_AX_TX_HDR3_SIZE_ERR_INT_EN BIT(5)
#define B_AX_TX_OFFSET_ERR_INT_EN BIT(4)
#define B_AX_TX_MPDU_SIZE_ZERO_INT_EN BIT(3)
#define B_AX_TX_NXT_ERRPKTID_INT_EN BIT(2)
#define B_AX_TX_GET_ERRPKTID_INT_EN BIT(1)

#define R_AX_MPDU_TX_DBG 0x9BFC
#define B_AX_MPDU_TX_DBGEN BIT(8)
#define B_AX_MPDU_TX_DLAST BIT(0)

//
// MPDU_Processor_2
//

#define R_AX_MPDU_PROC 0x9C00
#define B_AX_A_ICV_ERR BIT(1)
#define B_AX_APPEND_FCS BIT(0)

#define R_AX_ACTION_FWD0 0x9C04
#define B_AX_FWD_VHT_CBFM_SH 24
#define B_AX_FWD_VHT_CBFM_MSK 0x3
#define B_AX_FWD_HT_CBFM_SH 22
#define B_AX_FWD_HT_CBFM_MSK 0x3
#define B_AX_FWD_CSI_SH 20
#define B_AX_FWD_CSI_MSK 0x3
#define B_AX_FWD_OP_MODE_SH 18
#define B_AX_FWD_OP_MODE_MSK 0x3
#define B_AX_FWD_GID_MGNT_SH 16
#define B_AX_FWD_GID_MGNT_MSK 0x3
#define B_AX_FWD_NCW_SH 14
#define B_AX_FWD_NCW_MSK 0x3
#define B_AX_FWD_DELBA_SH 12
#define B_AX_FWD_DELBA_MSK 0x3
#define B_AX_FWD_ADDBA_RES_SH 10
#define B_AX_FWD_ADDBA_RES_MSK 0x3
#define B_AX_FWD_ADDBA_REQ_SH 8
#define B_AX_FWD_ADDBA_REQ_MSK 0x3
#define B_AX_FWD_DELTS_SH 6
#define B_AX_FWD_DELTS_MSK 0x3
#define B_AX_FWD_ADDTS_RES_SH 4
#define B_AX_FWD_ADDTS_RES_MSK 0x3
#define B_AX_FWD_ADDTS_REQ_SH 2
#define B_AX_FWD_ADDTS_REQ_MSK 0x3
#define B_AX_FWD_CSA_SH 0
#define B_AX_FWD_CSA_MSK 0x3

#define R_AX_ACTION_FWD1 0x9C08
#define B_AX_FWD_ACTN_CTRL3_SH 6
#define B_AX_FWD_ACTN_CTRL3_MSK 0x3
#define B_AX_FWD_ACTN_CTRL2_SH 4
#define B_AX_FWD_ACTN_CTRL2_MSK 0x3
#define B_AX_FWD_ACTN_CTRL1_SH 2
#define B_AX_FWD_ACTN_CTRL1_MSK 0x3
#define B_AX_FWD_ACTN_CTRL0_SH 0
#define B_AX_FWD_ACTN_CTRL0_MSK 0x3

#define R_AX_ACTION_FWD_CTRL0 0x9C0C
#define B_AX_FWD_ACTN_ACTN0_SH 8
#define B_AX_FWD_ACTN_ACTN0_MSK 0xff
#define B_AX_FWD_ACTN_CAT0_SH 0
#define B_AX_FWD_ACTN_CAT0_MSK 0xff

#define R_AX_ACTION_FWD_CTRL1 0x9C0E
#define B_AX_FWD_ACTN_ACTN1_SH 8
#define B_AX_FWD_ACTN_ACTN1_MSK 0xff
#define B_AX_FWD_ACTN_CAT1_SH 0
#define B_AX_FWD_ACTN_CAT1_MSK 0xff

#define R_AX_ACTION_FWD_CTRL2 0x9C10
#define B_AX_FWD_ACTN_ACTN2_SH 8
#define B_AX_FWD_ACTN_ACTN2_MSK 0xff
#define B_AX_FWD_ACTN_CAT2_SH 0
#define B_AX_FWD_ACTN_CAT2_MSK 0xff

#define R_AX_ACTION_FWD_CTRL3 0x9C12
#define B_AX_FWD_ACTN_ACTN3_SH 8
#define B_AX_FWD_ACTN_ACTN3_MSK 0xff
#define B_AX_FWD_ACTN_CAT3_SH 0
#define B_AX_FWD_ACTN_CAT3_MSK 0xff

#define R_AX_TF_FWD 0x9C14
#define B_AX_FWD_TF15_SH 30
#define B_AX_FWD_TF15_MSK 0x3
#define B_AX_FWD_TF14_SH 28
#define B_AX_FWD_TF14_MSK 0x3
#define B_AX_FWD_TF13_SH 26
#define B_AX_FWD_TF13_MSK 0x3
#define B_AX_FWD_TF12_SH 24
#define B_AX_FWD_TF12_MSK 0x3
#define B_AX_FWD_TF11_SH 22
#define B_AX_FWD_TF11_MSK 0x3
#define B_AX_FWD_TF10_SH 20
#define B_AX_FWD_TF10_MSK 0x3
#define B_AX_FWD_TF9_SH 18
#define B_AX_FWD_TF9_MSK 0x3
#define B_AX_FWD_TF8_SH 16
#define B_AX_FWD_TF8_MSK 0x3
#define B_AX_FWD_TF7_SH 14
#define B_AX_FWD_TF7_MSK 0x3
#define B_AX_FWD_TF6_SH 12
#define B_AX_FWD_TF6_MSK 0x3
#define B_AX_FWD_TF5_SH 10
#define B_AX_FWD_TF5_MSK 0x3
#define B_AX_FWD_TF4_SH 8
#define B_AX_FWD_TF4_MSK 0x3
#define B_AX_FWD_TF3_SH 6
#define B_AX_FWD_TF3_MSK 0x3
#define B_AX_FWD_TF2_SH 4
#define B_AX_FWD_TF2_MSK 0x3
#define B_AX_FWD_TF1_SH 2
#define B_AX_FWD_TF1_MSK 0x3
#define B_AX_FWD_TF0_SH 0
#define B_AX_FWD_TF0_MSK 0x3

#define R_AX_HW_RPT_FWD 0x9C18
#define B_AX_FWD_TX_PLD_REL_WCPU_SH 16
#define B_AX_FWD_TX_PLD_REL_WCPU_MSK 0x3
#define B_AX_FWD_DFS_RPT_SH 14
#define B_AX_FWD_DFS_RPT_MSK 0x3
#define B_AX_FWD_TX_PLD_REL_HOST_SH 12
#define B_AX_FWD_TX_PLD_REL_HOST_MSK 0x3
#define B_AX_FWD_TX_RPT_SH 10
#define B_AX_FWD_TX_RPT_MSK 0x3
#define B_AX_FWD_SS2FW_RPT_SH 8
#define B_AX_FWD_SS2FW_RPT_MSK 0x3
#define B_AX_FWD_F2P_TX_CMD_RPT_SH 6
#define B_AX_FWD_F2P_TX_CMD_RPT_MSK 0x3
#define B_AX_FWD_BB_SCOPE_MODE_SH 4
#define B_AX_FWD_BB_SCOPE_MODE_MSK 0x3
#define B_AX_FWD_CH_INFO_SH 2
#define B_AX_FWD_CH_INFO_MSK 0x3
#define B_AX_FWD_PPDU_STAT_SH 0
#define B_AX_FWD_PPDU_STAT_MSK 0x3

#define R_AX_PLD_CAM_CTRL 0x9C1C
#define B_AX_PLD_CAM_EN BIT(7)
#define B_AX_PLD_CAM_ACC BIT(4)
#define B_AX_PLD_CAM_RANGE_SH 0
#define B_AX_PLD_CAM_RANGE_MSK 0xf

#define R_AX_PLD_CAM_ACCESS 0x9C20
#define B_AX_PLD_CAM_POLL BIT(31)
#define B_AX_PLD_CAM_RW BIT(30)
#define B_AX_PLD_CAM_CLR BIT(29)
#define B_AX_PLD_CAM_OFFSET_SH 0
#define B_AX_PLD_CAM_OFFSET_MSK 0xffff

#define R_AX_PLD_CAM_RDATA 0x9C24
#define B_AX_PLD_CAM_RDATA_SH 0
#define B_AX_PLD_CAM_RDATA_MSK 0xffffffffL

#define R_AX_PLD_CAM_WDATA 0x9C28
#define B_PLD_CAM_WDATA_SH 0
#define B_PLD_CAM_WDATA_MSK 0xffffffffL

#define R_AX_CUT_AMSDU_CTRL 0x9C40
#define B_AX_BIT_EN_CUT_AMSDU BIT(30)
#define B_AX_BIT_CUT_AMSDU_CHKLEN_EN BIT(24)
#define B_AX_BIT_CUT_AMSDU_CHKLEN_L_TH_SH 16
#define B_AX_BIT_CUT_AMSDU_CHKLEN_L_TH_MSK 0xff
#define B_AX_BIT_CUT_AMSDU_CHKLEN_H_TH_SH 0
#define B_AX_BIT_CUT_AMSDU_CHKLEN_H_TH_MSK 0xffff

#define R_AX_CUT_AMSDU_CTRL_2 0x9C44
#define B_AX_MSDU_DROP_SEQUENCE_NUMBER_SH 20
#define B_AX_MSDU_DROP_SEQUENCE_NUMBER_MSK 0xfff
#define B_AX_MSDU_DROP BIT(19)
#define B_AX_EXTRA_SHIFT_SH 17
#define B_AX_EXTRA_SHIFT_MSK 0x3

#define R_AX_REG_ERROR_MON 0x9C48
#define B_AX_BIT_MACRX_ERR_5 BIT(21)

#define R_AX_WOW_CTRL 0x9C50
#define B_AX_WOW_HCI BIT(5)
#define B_AX_WOW_DROP BIT(2)
#define B_AX_WOW_WOWEN BIT(1)
#define B_AX_WOW_WOWEN_SH 1
#define B_AX_WOW_FORCE_WAKEUP BIT(0)

#define R_AX_MPDU_RX_PKTCNT 0x9CE8
#define B_AX_RX_PKTOUT_CNT_SH 16
#define B_AX_RX_PKTOUT_CNT_MSK 0xffff
#define B_AX_RX_PKTIN_CNT_SH 0
#define B_AX_RX_PKTIN_CNT_MSK 0xffff

#define R_AX_MPDU_DROP_PKTCNT 0x9CEC
#define B_AX_DROP_PKTCNT_SH 0
#define B_AX_DROP_PKTCNT_MSK 0xffff

#define R_AX_MPDU_RX_ERR_ISR 0x9CF0
#define B_AX_RPT_ERR_ISR BIT(3)
#define B_AX_MHDRLEN_ERR_ISR BIT(1)
#define B_AX_GETPKTID_ERR_ISR BIT(0)

#define R_AX_MPDU_RX_ERR_IMR 0x9CF4
#define B_AX_RPT_ERR_INT_EN BIT(3)
#define B_AX_MHDRLEN_ERR_INT_EN BIT(1)
#define B_AX_GETPKTID_ERR_INT_EN BIT(0)

#define R_AX_MPDU_RX_DBG 0x9CF8
#define B_AX_MPDU_RX_CKEN_DIS BIT(15)
#define B_AX_MPDU_RX_DBG_EN BIT(8)
#define B_AX_MPDU_RX_D_LAST_EN BIT(0)

//
// SEC_ENG
//

#define R_AX_SEC_ENG_CTRL 0x9D00
#define B_AX_SEC_ENG_EN BIT(31)
#define B_AX_CCMP_SPP_MIC BIT(30)
#define B_AX_CCMP_SPP_CTR BIT(29)
#define B_AX_SEC_CAM_ACC BIT(28)
#define B_AX_SEC_CAM_CLK BIT(15)
#define B_AX_SEC_ENG_CLK BIT(14)
#define B_AX_RX_ICV_ERR BIT(13)
#define B_AX_TX_PARTIAL_MODE BIT(11)
#define B_AX_CLK_EN_CGCMP BIT(10)
#define B_AX_CLK_EN_WAPI BIT(9)
#define B_AX_CLK_EN_WEP_TKIP BIT(8)
#define B_AX_BMC_MGNT_DEC BIT(5)
#define B_AX_UC_MGNT_DEC BIT(4)
#define B_AX_MC_DEC BIT(3)
#define B_AX_BC_DEC BIT(2)
#define B_AX_SEC_RX_DEC BIT(1)
#define B_AX_SEC_TX_ENC BIT(0)

#define R_AX_SEC_MPDU_PROC 0x9D04
#define B_AX_APPEND_ICV BIT(1)
#define B_AX_APPEND_MIC BIT(0)

#define R_AX_SEC_CAM_ACCESS 0x9D10
#define B_AX_SEC_CAM_POLL BIT(15)
#define B_AX_SEC_CAM_RW BIT(14)
#define B_AX_SEC_CAM_ACC_FAIL BIT(13)
#define B_AX_SEC_CAM_OFFSET_SH 0
#define B_AX_SEC_CAM_OFFSET_MSK 0x3ff

#define R_AX_SEC_CAM_RDATA 0x9D14
#define B_AX_SEC_CAM_RDATA_SH 0
#define B_AX_SEC_CAM_RDATA_MSK 0xffffffffL

#define R_AX_SEC_CAM_WDATA 0x9D18
#define B_AX_SEC_CAM_WDATA_SH 0
#define B_AX_SEC_CAM_WDATA_MSK 0xffffffffL

#define R_AX_SEC_DEBUG 0x9D1C
#define B_AX_NON_SEC_SH 30
#define B_AX_NON_SEC_MSK 0x3
#define B_AX_TX_AMSDU_WAPI_SH 28
#define B_AX_TX_AMSDU_WAPI_MSK 0x3
#define B_AX__TX_AMSDU_RC4_SH 26
#define B_AX__TX_AMSDU_RC4_MSK 0x3
#define B_AX__TX_AMSDU__CCMP_GCMP_SH 24
#define B_AX__TX_AMSDU__CCMP_GCMP_MSK 0x3
#define B_AX_TX_WAPI_SH 22
#define B_AX_TX_WAPI_MSK 0x3
#define B_AX_TX_RC4_SH 20
#define B_AX_TX_RC4_MSK 0x3
#define B_AX_TX_CCMP_GCMP_SH 18
#define B_AX_TX_CCMP_GCMP_MSK 0x3
#define B_AX_RX_WAPI_SH 16
#define B_AX_RX_WAPI_MSK 0x3
#define B_AX_RX_RC4_SH 14
#define B_AX_RX_RC4_MSK 0x3
#define B_AX_RX_CCMP_GCMP_SH 12
#define B_AX_RX_CCMP_GCMP_MSK 0x3
#define B_AX_RX_PARSER_FSM_SH 8
#define B_AX_RX_PARSER_FSM_MSK 0xf
#define B_AX_TX_PARSER_FSM_SH 4
#define B_AX_TX_PARSER_FSM_MSK 0xf
#define B_AX_IMR_ERROR BIT(3)
#define B_AX_RX_HANG_ERROR BIT(2)
#define B_AX_TX_HANG_ERROR BIT(1)
#define B_AX_BYPASS_PKT BIT(0)

#define R_AX_SEC_TX_DEBUG 0x9D20
#define B_AX_TX_HANG BIT(22)
#define B_AX_TX_ENC_CLOCK_SH 6
#define B_AX_TX_ENC_CLOCK_MSK 0xffff
#define B_AX_TX_SEC_TYPE_SH 2
#define B_AX_TX_SEC_TYPE_MSK 0xf
#define B_AX_TX_EXKEY_ERROR BIT(1)
#define B_AX_TX_ENCRYPT BIT(0)

#define R_AX_SEC_RX_DEBUG 0x9D24
#define B_AX_RX_HANG BIT(31)
#define B_AX_RX_ENC_CLOCK_SH 15
#define B_AX_RX_ENC_CLOCK_MSK 0xffff
#define B_AX_RX_SEC_TYPE_SH 11
#define B_AX_RX_SEC_TYPE_MSK 0xf
#define B_AX_RX_MIC_ERROR BIT(10)
#define B_AX_RX_ICV_ERROR BIT(9)
#define B_AX_RX_EXKEY_INDEX_SH 1
#define B_AX_RX_EXKEY_INDEX_MSK 0x7f
#define B_AX_RX_ENCRYPT BIT(0)

#define R_AX_SEC_TRX_PKT_CNT 0x9D28
#define B_AX_TX_PKT_CLR BIT(31)
#define B_AX_TX_PKT_CNT_SH 16
#define B_AX_TX_PKT_CNT_MSK 0x7fff
#define B_AX_RX_PKT_CLR BIT(15)
#define B_AX_RX_PKT_CNT_SH 0
#define B_AX_RX_PKT_CNT_MSK 0x7fff

#define R_AX_SEC_TRX_BLK_CNT 0x9D2C
#define B_AX_TX_BLK_CNT_SH 16
#define B_AX_TX_BLK_CNT_MSK 0xffff
#define B_AX_RX_BLK_CNT_SH 0
#define B_AX_RX_BLK_CNT_MSK 0xffff

//
// STA scheduler
//

#define R_AX_SS_DBG_0 0x9E00
#define B_AX_SS_PARAM_STAT_SH 24
#define B_AX_SS_PARAM_STAT_MSK 0x7f
#define B_AX_SS_PC_STAT_SH 16
#define B_AX_SS_PC_STAT_MSK 0x3f
#define B_AX_SS_SA_STAT_SH 8
#define B_AX_SS_SA_STAT_MSK 0x3f
#define B_AX_SS_SS_INIT_DONE_0 BIT(7)
#define B_AX_SS_LM_STAT_SH 0
#define B_AX_SS_LM_STAT_MSK 0x7f

#define R_AX_SS_DBG_1 0x9E04
#define B_AX_SS_DEL_STAT_SH 28
#define B_AX_SS_DEL_STAT_MSK 0x3
#define B_AX_SS_ADD_STAT_SH 24
#define B_AX_SS_ADD_STAT_MSK 0x3
#define B_AX_SS_ULRU_STAT_SH 16
#define B_AX_SS_ULRU_STAT_MSK 0xf
#define B_AX_SS_DLTX_STAT_SH 8
#define B_AX_SS_DLTX_STAT_MSK 0x1f
#define B_AX_SS_LEN_STAT_SH 0
#define B_AX_SS_LEN_STAT_MSK 0x7f

#define R_AX_SS_DBG_2 0x9E08
#define B_AX_SS_PLEA_STAT_SH 24
#define B_AX_SS_PLEA_STAT_MSK 0xf
#define B_AX_SS_WDEA_STAT_SH 16
#define B_AX_SS_WDEA_STAT_MSK 0xf
#define B_AX_SS_RPTA_STAT_SH 8
#define B_AX_SS_RPTA_STAT_MSK 0x3f
#define B_AX_SS_FWTX_STAT_SH 0
#define B_AX_SS_FWTX_STAT_MSK 0x1f

#define R_AX_SS_DBG_3 0x9E0C
#define B_AX_SS_CLK_GATE_DIS_SH 30
#define B_AX_SS_CLK_GATE_DIS_MSK 0x3
#define B_AX_SS_HW_ADD_LEN_OVF BIT(26)
#define B_AX_SS_SW_DECR_LEN_UDN BIT(25)
#define B_AX_SS_HW_DECR_LEN_UDN BIT(24)
#define B_AX_SS_ATM_ERR BIT(18)
#define B_AX_SS_DEL_STA_ERR BIT(17)
#define B_AX_SS_ADD_STA_ERR BIT(16)
#define B_AX_SS_LEN_INIT_DONE BIT(10)
#define B_AX_SS_PARAM_INIT_DONE BIT(9)
#define B_AX_SS_LINK_INIT_DONE BIT(8)
#define B_AX_SS_MOD_DBG_SEL_SH 4
#define B_AX_SS_MOD_DBG_SEL_MSK 0x3
#define B_AX_SS_TOP_DBG_SEL_SH 0
#define B_AX_SS_TOP_DBG_SEL_MSK 0xf

#define R_AX_SS_CTRL 0x9E10
#define B_AX_SS_INIT_DONE_1 BIT(31)
#define B_AX_SS_HW_STA_DIS BIT(30)
#define B_AX_SS_WARM_INIT_FLG BIT(29)
#define B_AX_SS_NONEMPTY_SS2FINFO_EN BIT(28)
#define B_AX_SS_DELAY_TX_BAND_SEL_SH 24
#define B_AX_SS_DELAY_TX_BAND_SEL_MSK 0x3
#define B_AX_SS_WMM_SEL_3_SH 22
#define B_AX_SS_WMM_SEL_3_MSK 0x3
#define B_AX_SS_WMM_SEL_2_SH 20
#define B_AX_SS_WMM_SEL_2_MSK 0x3
#define B_AX_SS_WMM_SEL_1_SH 18
#define B_AX_SS_WMM_SEL_1_MSK 0x3
#define B_AX_SS_WMM_SEL_0_SH 16
#define B_AX_SS_WMM_SEL_0_MSK 0x3
#define B_AX_SS_HW_LEN_EN BIT(2)
#define B_AX_SS_HW_PARAM_EN BIT(1)
#define B_AX_SS_EN BIT(0)

#define R_AX_SS_DL_QUOTA_CTRL 0x9E14
#define B_AX_SS_QUOTA_MODE_3 BIT(31)
#define B_AX_SS_QUOTA_MODE_2 BIT(30)
#define B_AX_SS_QUOTA_MODE_1 BIT(29)
#define B_AX_SS_QUOTA_MODE_0 BIT(28)
#define B_AX_SS_DL_QUOTA_LOWER_LIMIT_SH 8
#define B_AX_SS_DL_QUOTA_LOWER_LIMIT_MSK 0xff
#define B_AX_SS_DL_QUOTA_INIT_SH 0
#define B_AX_SS_DL_QUOTA_INIT_MSK 0xf

#define R_AX_SS_UL_QUOTA_CTRL 0x9E18
#define B_AX_SS_QUOTA_MODE_UL BIT(31)
#define B_AX_SS_UL_QUOTA_LOWER_LIMIT_SH 8
#define B_AX_SS_UL_QUOTA_LOWER_LIMIT_MSK 0xff
#define B_AX_SS_UL_QUOTA_INIT_SH 0
#define B_AX_SS_UL_QUOTA_INIT_MSK 0xf

#define R_AX_SS_BSR_CTRL 0x9E1C
#define B_AX_SS_BSR_THR_1_SH 16
#define B_AX_SS_BSR_THR_1_MSK 0x3fff
#define B_AX_SS_BSR_THR_0_SH 0
#define B_AX_SS_BSR_THR_0_MSK 0x3fff

#define R_AX_SS_DL_RPT_CRTL 0x9E20
#define B_AX_SS_TXOP_MODE_3 BIT(30)
#define B_AX_SS_TXOP_MODE_2 BIT(22)
#define B_AX_SS_TXOP_MODE_1 BIT(14)
#define B_AX_SS_TWT_MAX_SU_NUM_1_SH 11
#define B_AX_SS_TWT_MAX_SU_NUM_1_MSK 0x7
#define B_AX_SS_MAX_SU_NUM_1_SH 8
#define B_AX_SS_MAX_SU_NUM_1_MSK 0x7
#define B_AX_SS_TXOP_MODE_0 BIT(6)
#define B_AX_SS_TWT_MAX_SU_NUM_0_SH 3
#define B_AX_SS_TWT_MAX_SU_NUM_0_MSK 0x7
#define B_AX_SS_MAX_SU_NUM_0_SH 0
#define B_AX_SS_MAX_SU_NUM_0_MSK 0x7

#define R_AX_SS_UL_RPT_CRTL 0x9E24
#define B_AX_SS_MAX_RU_NUM_UL_SH 16
#define B_AX_SS_MAX_RU_NUM_UL_MSK 0x3
#define B_AX_SS_UL_WMM_SH 8
#define B_AX_SS_UL_WMM_MSK 0x3
#define B_AX_SS_TWT_MAX_SU_NUM_UL_SH 3
#define B_AX_SS_TWT_MAX_SU_NUM_UL_MSK 0x7
#define B_AX_SS_MAX_SU_NUM_UL_SH 0
#define B_AX_SS_MAX_SU_NUM_UL_MSK 0x7

#define R_AX_SS_SEARCH_TO 0x9E28
#define B_AX_SS_SEARCH_TO_SH 0
#define B_AX_SS_SEARCH_TO_MSK 0xff

#define R_AX_SS_SEARCH_LVL 0x9E2C
#define B_AX_SS_NEG_CNT_SH 16
#define B_AX_SS_NEG_CNT_MSK 0xff
#define B_AX_SS_NEG_LVL_SH 0
#define B_AX_SS_NEG_LVL_MSK 0xff

#define R_AX_SS_SRAM_DATA 0x9E30
#define B_AX_SS_SRAM_DATA_SH 0
#define B_AX_SS_SRAM_DATA_MSK 0xffffffffL

#define R_AX_SS_SRAM_W_EN 0x9E34
#define B_AX_SS_SRAM_W_EN_SH 0
#define B_AX_SS_SRAM_W_EN_MSK 0xffffffffL

#define R_AX_SS_SRAM_CTRL_0 0x9E38
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_RW BIT(23)
#define B_AX_SS_CMD_SH 20
#define B_AX_SS_CMD_MSK 0x7
#define B_AX_SS_OFFSET_SH 8
#define B_AX_SS_OFFSET_MSK 0x3
#define B_AX_SS_PARAM_SEL_SH 0
#define B_AX_SS_PARAM_SEL_MSK 0xff

#define R_AX_SS_LINK_INFO 0x9E3C
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_STATUS_SH 29
#define B_AX_SS_STATUS_MSK 0x3
#define B_AX_SS_UL BIT(28)
#define B_AX_SS_WMM_SH 26
#define B_AX_SS_WMM_MSK 0x3
#define B_AX_SS_AC_SH 24
#define B_AX_SS_AC_MSK 0x3
#define B_AX_SS_LINK_LEN_SH 16
#define B_AX_SS_LINK_LEN_MSK 0xff
#define B_AX_SS_LINK_TAIL_SH 8
#define B_AX_SS_LINK_TAIL_MSK 0xff
#define B_AX_SS_LINK_HEAD_SH 0
#define B_AX_SS_LINK_HEAD_MSK 0xff

#define R_AX_SS_LINK_ADD 0x9E40
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_UL BIT(28)
#define B_AX_SS_MACID_2_SH 16
#define B_AX_SS_MACID_2_MSK 0xff
#define B_AX_SS_MACID_1_SH 8
#define B_AX_SS_MACID_1_MSK 0xff
#define B_AX_SS_MACID_0_SH 0
#define B_AX_SS_MACID_0_MSK 0xff

#define R_AX_SS_LINK_DEL 0x9E44
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_UL BIT(28)

#define R_AX_SS_LINK_SEARCH 0x9E48
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_UL BIT(28)
#define B_AX_SS_TWT_GROUP_SH 20
#define B_AX_SS_TWT_GROUP_MSK 0xf
#define B_AX_SS_MODE_SEL_SH 16
#define B_AX_SS_MODE_SEL_MSK 0x3

#define R_AX_SS_SRAM_CTRL_1 0x9E4C
#define B_AX_SS_OWN BIT(31)
#define B_AX_SS_CMD_SEL_SH 26
#define B_AX_SS_CMD_SEL_MSK 0x1f
#define B_AX_SS_VALUE_SH 8
#define B_AX_SS_VALUE_MSK 0xffff

#define R_AX_SS2FINFO_PATH 0x9E50
#define B_AX_SS_UL_REL BIT(31)
#define B_AX_SS_REL_QUEUE_SH 24
#define B_AX_SS_REL_QUEUE_MSK 0x3f
#define B_AX_SS_REL_PORT_SH 16
#define B_AX_SS_REL_PORT_MSK 0x7
#define B_AX_SS_DEST_QUEUE_SH 8
#define B_AX_SS_DEST_QUEUE_MSK 0x3f
#define B_AX_SS_DEST_PORT_SH 0
#define B_AX_SS_DEST_PORT_MSK 0x7

#define R_AX_WMM_LINK_EMPTY 0x9E54
#define B_AX_WMM3_VO_LINK_EMPTY BIT(15)
#define B_AX_WMM3_VI_LINK_EMPTY BIT(14)
#define B_AX_WMM3_BK_LINK_EMPTY BIT(13)
#define B_AX_WMM3_BE_LINK_EMPTY BIT(12)
#define B_AX_WMM2_VO_LINK_EMPTY BIT(11)
#define B_AX_WMM2_VI_LINK_EMPTY BIT(10)
#define B_AX_WMM2_BK_LINK_EMPTY BIT(9)
#define B_AX_WMM2_BE_LINK_EMPTY BIT(8)
#define B_AX_WMM1_VO_LINK_EMPTY BIT(7)
#define B_AX_WMM1_VI_LINK_EMPTY BIT(6)
#define B_AX_WMM1_BK_LINK_EMPTY BIT(5)
#define B_AX_WMM1_BE_LINK_EMPTY BIT(4)
#define B_AX_WMM0_VO_LINK_EMPTY BIT(3)
#define B_AX_WMM0_VI_LINK_EMPTY BIT(2)
#define B_AX_WMM0_BK_LINK_EMPTY BIT(1)
#define B_AX_WMM0_BE_LINK_EMPTY BIT(0)

#define R_AX_SS_DELAYTX_TO 0x9E60
#define B_AX_SS_BEBK_TO_1_SH 24
#define B_AX_SS_BEBK_TO_1_MSK 0xff
#define B_AX_SS_VOVI_TO_1_SH 16
#define B_AX_SS_VOVI_TO_1_MSK 0xff
#define B_AX_SS_BEBK_TO_0_SH 8
#define B_AX_SS_BEBK_TO_0_MSK 0xff
#define B_AX_SS_VOVI_TO_0_SH 0
#define B_AX_SS_VOVI_TO_0_MSK 0xff

#define R_AX_SS_DELAYTX_LEN_THR 0x9E70
#define B_AX_SS_BEBK_LEN_THR_1_SH 24
#define B_AX_SS_BEBK_LEN_THR_1_MSK 0xff
#define B_AX_SS_VOVI_LEN_THR_1_SH 16
#define B_AX_SS_VOVI_LEN_THR_1_MSK 0xff
#define B_AX_SS_BEBK_LEN_THR_0_SH 8
#define B_AX_SS_BEBK_LEN_THR_0_MSK 0xff
#define B_AX_SS_VOVI_LEN_THR_0_SH 0
#define B_AX_SS_VOVI_LEN_THR_0_MSK 0xff

#define R_AX_SS_MU_CTRL 0x9E80
#define B_AX_SS_DLRU_STATE_SH 28
#define B_AX_SS_DLRU_STATE_MSK 0xf
#define B_AX_SS_DLMU_STATE_SH 24
#define B_AX_SS_DLMU_STATE_MSK 0xf
#define B_AX_SS_MU_OPT BIT(2)
#define B_AX_SS_SCORE_THR_SH 0
#define B_AX_SS_SCORE_THR_MSK 0x3

#define R_AX_SS_MU_TBL_0 0x9E84
#define B_AX_SS_MU_MACID_SH 11
#define B_AX_SS_MU_MACID_MSK 0x7f
#define B_AX_SS_TBL_VLD BIT(10)
#define B_AX_SS_SCORE_0_SH 8
#define B_AX_SS_SCORE_0_MSK 0x3
#define B_AX_SS_SCORE_1_SH 6
#define B_AX_SS_SCORE_1_MSK 0x3
#define B_AX_SS_SCORE_2_SH 4
#define B_AX_SS_SCORE_2_MSK 0x3
#define B_AX_SS_SCORE_3_SH 2
#define B_AX_SS_SCORE_3_MSK 0x3
#define B_AX_SS_SCORE_4_SH 0
#define B_AX_SS_SCORE_4_MSK 0x3

#define R_AX_SS_MU_TBL_1 0x9E88
#define B_AX_SS_TBL_VLD BIT(10)

#define R_AX_SS_MU_TBL_2 0x9E8C
#define B_AX_SS_TBL_VLD BIT(10)

#define R_AX_SS_MU_TBL_3 0x9E90
#define B_AX_SS_TBL_VLD BIT(10)

#define R_AX_SS_MU_TBL_4 0x9E94
#define B_AX_SS_TBL_VLD BIT(10)

#define R_AX_SS_MU_TBL_5 0x9E98
#define B_AX_SS_TBL_VLD BIT(10)

#define R_AX_SS_DL_MU_RPT_CRTL 0x9E9C
#define B_AX_SS_TWT_MAX_MU_NUM_1_SH 12
#define B_AX_SS_TWT_MAX_MU_NUM_1_MSK 0xf
#define B_AX_SS_MAX_MU_NUM_1_SH 8
#define B_AX_SS_MAX_MU_NUM_1_MSK 0xf
#define B_AX_SS_TWT_MAX_MU_NUM_0_SH 4
#define B_AX_SS_TWT_MAX_MU_NUM_0_MSK 0xf
#define B_AX_SS_MAX_MU_NUM_0_SH 0
#define B_AX_SS_MAX_MU_NUM_0_MSK 0xf

#define R_AX_SS_RU_CTRL 0x9EA0
#define B_AX_SS_GROUP_VLD_SH 16
#define B_AX_SS_GROUP_VLD_MSK 0xffff
#define B_AX_SS_RU_SEARCH_MODE_SH 0
#define B_AX_SS_RU_SEARCH_MODE_MSK 0xf

#define R_AX_SS_DL_RU_RPT_CRTL 0x9EA4
#define B_AX_SS_TWT_MAX_RU_NUM_1_SH 12
#define B_AX_SS_TWT_MAX_RU_NUM_1_MSK 0xf
#define B_AX_SS_MAX_RU_NUM_1_SH 8
#define B_AX_SS_MAX_RU_NUM_1_MSK 0xf
#define B_AX_SS_TWT_MAX_RU_NUM_0_SH 4
#define B_AX_SS_TWT_MAX_RU_NUM_0_MSK 0xf
#define B_AX_SS_MAX_RU_NUM_0_SH 0
#define B_AX_SS_MAX_RU_NUM_0_MSK 0xf

#define R_AX_SS_MACID_PAUSE_0 0x9EB0
#define B_AX_SS_MACID31_0_PAUSE_SH 0
#define B_AX_SS_MACID31_0_PAUSE_MSK 0xffffffffL

#define R_AX_SS_MACID_PAUSE_1 0x9EB4
#define B_AX_SS_MACID63_32_PAUSE_SH 0
#define B_AX_SS_MACID63_32_PAUSE_MSK 0xffffffffL

#define R_AX_SS_MACID_PAUSE_2 0x9EB8
#define B_AX_SS_MACID95_64_PAUSE_SH 0
#define B_AX_SS_MACID95_64_PAUSE_MSK 0xffffffffL

#define R_AX_SS_MACID_PAUSE_3 0x9EBC
#define B_AX_SS_MACID127_96_PAUSE_SH 0
#define B_AX_SS_MACID127_96_PAUSE_MSK 0xffffffffL

#define R_AX_STA_SCHEDULER_ERR_IMR 0x9EF0
#define B_AX_PLE_B_PKTID_ERR_INT_EN BIT(2)
#define B_AX_RPT_HANG_TIMEOUT_INT_EN BIT(1)
#define B_AX_SEARCH_HANG_TIMEOUT_INT_EN BIT(0)

#define R_AX_STA_SCHEDULER_ERR_ISR 0x9EF4
#define B_AX_PLE_B_PKTID_ERR_ISR BIT(2)
#define B_AX_RPT_HANG_TIMEOUT_ISR BIT(1)
#define B_AX_SEARCH_HANG_TIMEOUT_ISR BIT(0)

//
// Tx Packet Controller
//

#define R_AX_B0_CFG 0x9F10
#define B_AX_B0_ATCPAR_REFTU_VAL_SH 8
#define B_AX_B0_ATCPAR_REFTU_VAL_MSK 0xff
#define B_AX_B0_ATCTMR_REFTU_CYC_SH 4
#define B_AX_B0_ATCTMR_REFTU_CYC_MSK 0x7
#define B_AX_B0_DIS_ACGC BIT(0)

#define R_AX_B0_CTL 0x9F14
#define B_AX_B0_CMDPSR_CTLST_REQPS BIT(7)
#define B_AX_CMDPSR_CTLST_NXTST_SH 0
#define B_AX_CMDPSR_CTLST_NXTST_MSK 0x1f

#define R_AX_TXPKTCTL_ERR_IMR_ISR 0x9F1C
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR BIT(25)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR BIT(24)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR BIT(19)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR BIT(18)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR BIT(17)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR BIT(16)
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN BIT(8)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN BIT(3)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN BIT(2)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN BIT(1)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN BIT(0)
#define B_AX_B1_ATCPAR_REFTU_VAL_SH 8
#define B_AX_B1_ATCPAR_REFTU_VAL_MSK 0xff
#define B_AX_B1_ATCTMR_REFTU_CYC_SH 4
#define B_AX_B1_ATCTMR_REFTU_CYC_MSK 0x7
#define B_AX_B1_DIS_ACGC BIT(0)
#define B_AX_B1_CMDPSR_CTLST_REQPS BIT(7)
#define B_AX_B1_CMDPSR_CTLST_NXTST_SH 0
#define B_AX_B1_CMDPSR_CTLST_NXTST_MSK 0x1f

#define R_AX_TXPKTCTL_ERR_IMR_ISR_B1 0x9F2C
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR BIT(25)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR BIT(24)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR BIT(19)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR BIT(18)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR BIT(17)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR BIT(16)
#define B_AX_TXPKTCTL_CMDPSR_FRZTO_ERR_INT_EN BIT(9)
#define B_AX_TXPKTCTL_CMDPSR_CMDTYPE_ERR_INT_EN BIT(8)
#define B_AX_TXPKTCTL_USRCTL_RLSBMPLEN_ERR_INT_EN BIT(3)
#define B_AX_TXPKTCTL_USRCTL_RDNRLSCMD_ERR_INT_EN BIT(2)
#define B_AX_TXPKTCTL_USRCTL_NOINIT_ERR_INT_EN BIT(1)
#define B_AX_TXPKTCTL_USRCTL_REINIT_ERR_INT_EN BIT(0)

#define R_AX_DBG_FUN_INTF_CTL 0x9F30
#define B_AX_DFI_ACTIVE BIT(31)
#define B_AX_DFI_TRGSEL_SH 16
#define B_AX_DFI_TRGSEL_MSK 0xf
#define B_AX_DFI_ADDR_SH 0
#define B_AX_DFI_ADDR_MSK 0xffff

#define R_AX_DBG_FUN_INTF_DATA 0x9F34
#define B_AX_DFI_DATA_SH 0
#define B_AX_DFI_DATA_MSK 0xffffffffL

#define R_AX_DBG_CTL_TXPKT 0x9F38
#define B_AX_TPC_DBG1_SEL_SH 16
#define B_AX_TPC_DBG1_SEL_MSK 0xffff
#define B_AX_TPC_DBG0_SEL_SH 0
#define B_AX_TPC_DBG0_SEL_MSK 0xffff

#define R_AX_TPC_DBG_OUT 0x9F3C
#define B_AX_DBG1_OUT_SH 16
#define B_AX_DBG1_OUT_MSK 0xffff
#define B_AX_DBG0_OUT_SH 0
#define B_AX_DBG0_OUT_MSK 0xffff

#define R_AX_TXPKTCTL_B0_CTL 0x9F44
#define B_AX_B0_CTLST_IDLE BIT(1)
#define B_AX_B0_STOP_REQ BIT(0)

#define R_AX_TXPKTCTL_B1_CTL 0x9F84
#define B_AX_B1_CTLST_IDLE BIT(1)
#define B_AX_B1_STOP_REQ BIT(0)

//
// WL_AX_Reg_AON.xls
//

//
// AON
//

#define R_AX_SYS_ISO_CTRL 0x0000
#define B_AX_PWC_EV2EF_SH 14
#define B_AX_PWC_EV2EF_MSK 0x3
#define B_AX_PA33V_EN BIT(13)
#define B_AX_PA12V_EN BIT(12)
#define B_AX_UA33V_EN BIT(11)
#define B_AX_UA12V_EN BIT(10)
#define B_AX_ISO_RFDIO BIT(9)
#define B_AX_ISO_EB2CORE BIT(8)
#define B_AX_ISO_DIOE BIT(7)
#define B_AX_ISO_WLPON2PP BIT(6)
#define B_AX_ISO_IP2MAC_WA2PP BIT(5)
#define B_AX_ISO_PD2CORE BIT(4)
#define B_AX_ISO_PA2PCIE BIT(3)
#define B_AX_ISO_UD2CORE BIT(2)
#define B_AX_ISO_UA2USB BIT(1)
#define B_AX_ISO_WD2PP BIT(0)

#define R_AX_SYS_FUNC_EN 0x0002
#define B_AX_FEN_MREGEN BIT(15)
#define B_AX_FEN_HWPDN BIT(14)
#define B_AX_FEN_ELDR BIT(12)
#define B_AX_FEN_DCORE BIT(11)
#define B_AX_FEN_CPUEN BIT(10)
#define B_AX_FEN_DIOE BIT(9)
#define B_AX_FEN_PCIED BIT(8)
#define B_AX_FEN_PPLL BIT(7)
#define B_AX_FEN_PCIEA BIT(6)
#define B_AX_FEN_USBD BIT(4)
#define B_AX_FEN_UPLL BIT(3)
#define B_AX_FEN_USBA BIT(2)
#define B_AX_FEN_BB_GLB_RSTN BIT(1)
#define B_AX_FEN_BBRSTB BIT(0)

#define R_AX_SYS_PW_CTRL 0x0004
#define B_AX_SOP_ASWRM BIT(31)
#define B_AX_SOP_EASWR BIT(30)
#define B_AX_SOP_PWMM_DSWR BIT(29)
#define B_AX_SOP_EDSWR BIT(28)
#define B_AX_SOP_ACKF BIT(27)
#define B_AX_SOP_ERCK BIT(26)
#define B_AX_SOP_ANA_CLK_DIVISION_2 BIT(25)
#define B_AX_SOP_EXTL BIT(24)
#define B_AX_ROP_SWPR BIT(21)
#define B_AX_DIS_HW_LPLDM BIT(20)
#define B_AX_RDY_SYSPWR BIT(17)
#define B_AX_EN_WLON BIT(16)
#define B_AX_APDM_HPDN BIT(15)
#define B_AX_PSUS_OFF_CAPC_EN BIT(14)
#define B_AX_AFSM_PCIE_SUS_EN BIT(12)
#define B_AX_AFSM_WLSUS_EN BIT(11)
#define B_AX_APFM_SWLPS BIT(10)
#define B_AX_APFM_OFFMAC BIT(9)
#define B_AX_APFN_ONMAC BIT(8)
#define B_AX_CHIP_PDN_EN BIT(7)
#define B_AX_RDY_MACDIS BIT(6)
#define B_AX_SW_AFE_MODE BIT(4)
#define B_AX_PFM_WOWL BIT(3)
#define B_AX_WL_HCI_ALD BIT(1)
#define B_AX_EFUSE_LDALL BIT(0)

#define R_AX_SYS_CLK_CTRL 0x0008
#define B_AX_CPU_IDMEM_CLK_EN BIT(15)
#define B_AX_CPU_CLK_EN BIT(14)
#define B_AX_SYMR_AX_CLK_EN BIT(13)
#define B_AX_MAC_CLK_EN BIT(11)
#define B_AX_EXT_32K_EN BIT(8)
#define B_AX_WL_CLK_TEST BIT(7)
#define B_AX_LOADER_CLK_EN BIT(5)
#define B_AX_ANA_CLK_DIVISION_2 BIT(1)
#define B_AX_CNTD16V_EN BIT(0)

#define R_AX_SYS_EEPROM_CTRL 0x000A
#define B_AX_AUTOLOAD_SUS BIT(5)

#define R_AX_SYS_SWR_CTRL1 0x0010
#define B_AX_SYM_CTRL_SPSANA_PWMFREQ BIT(11)
#define B_AX_SYM_CTRL_SPS_PWMFREQ BIT(10)
#define B_AX_HW_AUTO_CTRL_EXT_SWR BIT(9)
#define B_AX_USE_INTERNAL_SWR_AND_LDO BIT(8)
#define B_AX_MAC_ID_EN BIT(7)
#define B_AX_OPTION_DIS_XTAL_BG BIT(2)

#define R_AX_ANAPARSW_POW_MAC 0x0014
#define B_AX_POW_LDO15 BIT(2)
#define B_AX_POW_SW_SPSANA BIT(1)
#define B_AX_POW_LDO14_SPSANA BIT(0)

#define R_AX_ANAPARLDO_POW_MAC 0x0015
#define B_AX_R_PD12_N_LDO BIT(5)
#define B_AX_POW_SW_SPSDIG BIT(1)
#define B_AX_POW_LDO14_SPSDIG BIT(0)

#define R_AX_ANAPAR_POW_MAC 0x0016
#define B_AX_POW_PC_LDO_PORT1 BIT(3)
#define B_AX_POW_PC_LDO_PORT0 BIT(2)
#define B_AX_POW_PLL_V1 BIT(1)
#define B_AX_POW_POWER_CUT_POW_LDO BIT(0)

#define R_AX_ANAPAR_POW_XTAL 0x0017
#define B_AX_POW_XTAL BIT(1)
#define B_AX_POW_BG BIT(0)

#define R_AX_SYS_ADIE_PAD_PWR_CTRL 0x0018
#define B_AX_SYM_PADPDN_WL_RFC_1P3 BIT(5)
#define B_AX_SYM_PADPDN_WL_PTA_1P3 BIT(6)

#define R_AX_RSV_CTRL 0x001C
#define B_AX_HR_AX_DBG BIT(23)
#define B_AX_R_EN_HRST_PWRON BIT(8)
#define B_AX_LOCK_ALL_EN BIT(7)
#define B_AX_R_DIS_PRST BIT(6)
#define B_AX_WLOCK_1C_B6 BIT(5)
#define B_AX_WLOCK_40 BIT(4)
#define B_AX_WLOCK_08 BIT(3)
#define B_AX_WLOCK_04 BIT(2)
#define B_AX_WLOCK_00 BIT(1)
#define B_AX_WLOCK_ALL BIT(0)

#define R_AX_RF_CTRL 0x001F
#define B_AX_S0_RFC_WO_0 BIT(7)
#define B_AX_S0_RFC_WT_0 BIT(6)
#define B_AX_S0_RFC_RSTB BIT(1)

#define R_AX_AFE_LDO_CTRL 0x0020
#define B_AX_R_SYM_WLPOFF_P4_PC_EN BIT(28)
#define B_AX_R_SYM_WLPOFF_P3_PC_EN BIT(27)
#define B_AX_R_SYM_WLPOFF_P2_PC_EN BIT(26)
#define B_AX_R_SYM_WLPOFF_P1_PC_EN BIT(25)
#define B_AX_R_SYM_WLPOFF_PC_EN BIT(24)
#define B_AX_AON_OFF_PC_EN BIT(23)
#define B_AX_R_SYM_WLPON_P3_PC_EN BIT(21)
#define B_AX_R_SYM_WLPON_P2_PC_EN BIT(20)
#define B_AX_R_SYM_WLPON_P1_PC_EN BIT(19)
#define B_AX_R_SYM_WLPON_PC_EN BIT(18)
#define B_AX_R_SYM_DIS_WPHYBBOFF_PC BIT(10)
#define B_AX_R_SYM_WLBBOFF1_P4_PC_EN BIT(9)
#define B_AX_R_SYM_WLBBOFF1_P3_PC_EN BIT(8)
#define B_AX_R_SYM_WLBBOFF1_P2_PC_EN BIT(7)
#define B_AX_R_SYM_WLBBOFF1_P1_PC_EN BIT(6)
#define B_AX_R_SYM_WLBBOFF_P4_PC_EN BIT(4)
#define B_AX_R_SYM_WLBBOFF_P3_PC_EN BIT(3)
#define B_AX_R_SYM_WLBBOFF_P2_PC_EN BIT(2)
#define B_AX_R_SYM_WLBBOFF_P1_PC_EN BIT(1)
#define B_AX_R_SYM_WLBBOFF_PC_EN BIT(0)

#define R_AX_AFE_CTRL1 0x0024
#define B_AX_WLCPU_CLK_SEL_SH 22
#define B_AX_WLCPU_CLK_SEL_MSK 0x3
#define B_AX_CMAC_CLK_SEL BIT(21)
#define B_AX_PLL_DIV_SEL BIT(20)
#define B_AX_DMEM3_PC_EN BIT(15)
#define B_AX_DMEM2_PC_EN BIT(14)
#define B_AX_DMEM1_PC_EN BIT(13)
#define B_AX_IMEM4_PC_EN BIT(12)
#define B_AX_IMEM3_PC_EN BIT(11)
#define B_AX_IMEM2_PC_EN BIT(10)
#define B_AX_IMEM1_PC_EN BIT(9)
#define B_AX_IMEM0_PC_EN BIT(8)
#define B_AX_R_SYM_WLCMAC1_P4_PC_EN BIT(4)
#define B_AX_R_SYM_WLCMAC1_P3_PC_EN BIT(3)
#define B_AX_R_SYM_WLCMAC1_P2_PC_EN BIT(2)
#define B_AX_R_SYM_WLCMAC1_P1_PC_EN BIT(1)
#define B_AX_R_SYM_WLCMAC1_PC_EN BIT(0)

#define R_AX_SYS_OCP_CTRL 0x0028
#define B_AX_SPS_OCP_DIS BIT(31)
#define B_AX_SPS_OCP_TH_SH 16
#define B_AX_SPS_OCP_TH_MSK 0x7fff
#define B_AX_OCP_WINDOW_SH 0
#define B_AX_OCP_WINDOW_MSK 0xffff

#define R_AX_SYSANA_OCP_CTRL 0x002C
#define B_AX_SPSANA_OCP_DIS BIT(31)
#define B_AX_SPSANA_OCP_TH_SH 16
#define B_AX_SPSANA_OCP_TH_MSK 0x7fff
#define B_AX_OCPANA_WINDOW_SH 0
#define B_AX_OCPANA_WINDOW_MSK 0xffff

#define R_AX_EFUSE_CTRL 0x0030
#define B_AX_EF_MODE_SEL_SH 30
#define B_AX_EF_MODE_SEL_MSK 0x3
#define B_AX_EF_RDY BIT(29)
#define B_AX_EF_COMP_RESULT BIT(28)
#define B_AX_EF_ADDR_SH 16
#define B_AX_EF_ADDR_MSK 0x7ff
#define B_AX_EF_DATA_SH 0
#define B_AX_EF_DATA_MSK 0xffff

#define R_AX_EFUSE_TEST 0x0034
#define B_AX_EF_CRES_SEL BIT(31)
#define B_AX_EF_SCAN_SADR_SH 19
#define B_AX_EF_SCAN_SADR_MSK 0x7ff
#define B_AX_EF_SCAN_EADR_SH 8
#define B_AX_EF_SCAN_EADR_MSK 0x7ff
#define B_AX_EF_SCAN_TRPT BIT(7)
#define B_AX_EF_SCAN_FTHR_SH 0
#define B_AX_EF_SCAN_FTHR_MSK 0x7f

#define R_AX_EFUSE_CTRL_1 0x0038
#define B_AX_EF_PGPD_SH 28
#define B_AX_EF_PGPD_MSK 0x7
#define B_AX_EF_RDT BIT(27)
#define B_AX_EF_VDDQST_SH 24
#define B_AX_EF_VDDQST_MSK 0x7
#define B_AX_EF_PGTS_SH 20
#define B_AX_EF_PGTS_MSK 0xf
#define B_AX_EF_PD_DIS BIT(11)
#define B_AX_EF_POR BIT(10)
#define B_AX_EF_CELL_SEL_SH 8
#define B_AX_EF_CELL_SEL_MSK 0x3

#define R_AX_EFUSE_CTRL_1_V1 0x0038
#define B_AX_EF_ENT BIT(31)
#define B_AX_EF_BURST BIT(19)
#define B_AX_EF_TEST_SEL_SH 16
#define B_AX_EF_TEST_SEL_MSK 0x7
#define B_AX_EF_TROW_EN BIT(15)
#define B_AX_EF_ERR_FLAG BIT(14)
#define B_AX_EF_DSB_EN BIT(11)
#define B_AX_PCIE_CALIB_EN_V1 BIT(12)
#define B_AX_WDT_WAKE_PCIE_EN BIT(10)
#define B_AX_WDT_WAKE_USB_EN BIT(9)

#define R_AX_GPIO_MUXCFG 0x0040
#define B_AX_BOOT_MODE BIT(19)
#define B_AX_WL_EECS_EXT_32K_SEL BIT(18)
#define B_AX_WL_SEC_BONDING_OPT_STS BIT(17)
#define B_AX_SECSIC_SEL BIT(16)
#define B_AX_ENHTP BIT(14)
#define B_AX_BT_AOD_GPIO3 BIT(13)
#define B_AX_ENSIC BIT(12)
#define B_AX_SIC_SWRST BIT(11)
#define B_AX_PO_WIFI_PTA_PINS BIT(10)
#define B_AX_PO_BT_PTA_PINS BIT(9)
#define B_AX_ENUARTTX BIT(8)
#define B_AX_BTMODE_SH 6
#define B_AX_BTMODE_MSK 0x3
#define B_AX_ENBT BIT(5)
#define B_AX_EROM_EN BIT(4)
#define B_AX_ENUARTRX BIT(2)
#define B_AX_GPIOSEL_SH 0
#define B_AX_GPIOSEL_MSK 0x3

#define R_AX_GPIO_PIN_CTRL 0x0044
#define B_AX_GPIO_MOD_7_TO_0_SH 24
#define B_AX_GPIO_MOD_7_TO_0_MSK 0xff
#define B_AX_GPIO_IO_SEL_7_TO_0_SH 16
#define B_AX_GPIO_IO_SEL_7_TO_0_MSK 0xff
#define B_AX_GPIO_OUT_7_TO_0_SH 8
#define B_AX_GPIO_OUT_7_TO_0_MSK 0xff
#define B_AX_GPIO_IN_7_TO_0_SH 0
#define B_AX_GPIO_IN_7_TO_0_MSK 0xff

#define R_AX_GPIO_INTM 0x0048
#define B_AX_EXTWOL_SEL BIT(17)
#define B_AX_EXTWOL_EN BIT(16)
#define B_AX_GPIOF_INT_MD BIT(15)
#define B_AX_GPIOE_INT_MD BIT(14)
#define B_AX_GPIOD_INT_MD BIT(13)
#define B_AX_GPIOC_INT_MD BIT(12)
#define B_AX_GPIOB_INT_MD BIT(11)
#define B_AX_GPIOA_INT_MD BIT(10)
#define B_AX_GPIO9_INT_MD BIT(9)
#define B_AX_GPIO8_INT_MD BIT(8)
#define B_AX_GPIO7_INT_MD BIT(7)
#define B_AX_GPIO6_INT_MD BIT(6)
#define B_AX_GPIO5_INT_MD BIT(5)
#define B_AX_GPIO4_INT_MD BIT(4)
#define B_AX_GPIO3_INT_MD BIT(3)
#define B_AX_GPIO2_INT_MD BIT(2)
#define B_AX_GPIO1_INT_MD BIT(1)
#define B_AX_GPIO0_INT_MD BIT(0)

#define R_AX_LED_CFG 0x004C
#define B_AX_MAILBOX_1WIRE_GPIO_CFG BIT(31)
#define B_AX_BT_RF_GPIO_CFG BIT(30)
#define B_AX_BT_SDIO_INT_GPIO_CFG BIT(29)
#define B_AX_MAILBOX_3WIRE_GPIO_CFG BIT(28)
#define B_AX_GPIO13_14_WL_CTRL_EN BIT(22)
#define B_AX_LED2DIS BIT(21)
#define B_AX_LED2PL BIT(20)
#define B_AX_LED2SV BIT(19)
#define B_AX_LED2CM_SH 16
#define B_AX_LED2CM_MSK 0x7
#define B_AX_LED0LED1_RD_ONLY_SH 13
#define B_AX_LED0LED1_RD_ONLY_MSK 0x3

#define R_AX_PWR_OPTION_CTRL 0x0050
#define B_AX_DIS_LPS_WT_PDNSUS BIT(24)
#define B_AX_SYSON_DBG_PAD_E2 BIT(11)
#define B_AX_SYSON_LED_PAD_E2 BIT(10)
#define B_AX_SYSON_GPEE_PAD_E2 BIT(9)
#define B_AX_SYSON_PCI_PAD_E2 BIT(8)
#define B_AX_SYSON_WLPC_IDX_SH 6
#define B_AX_SYSON_WLPC_IDX_MSK 0x3
#define B_AX_SYSON_SPS0WWV_WT_SH 4
#define B_AX_SYSON_SPS0WWV_WT_MSK 0x3
#define B_AX_SYSON_SPS0LDO_WT_SH 2
#define B_AX_SYSON_SPS0LDO_WT_MSK 0x3
#define B_AX_SYSON_RCLK_SCALE_SH 0
#define B_AX_SYSON_RCLK_SCALE_MSK 0x3

#define R_AX_CAL_TIMER 0x0054
#define B_AX_UART_TX_SEL_SH 30
#define B_AX_UART_TX_SEL_MSK 0x3
#define B_AX_UART_RX_SEL BIT(29)
#define B_AX_CAL_SCAL_SH 0
#define B_AX_CAL_SCAL_MSK 0xffff

#define R_AX_DBG_CTRL 0x0058
#define B_AX_DBG_SEL1_4BIT_SH 30
#define B_AX_DBG_SEL1_4BIT_MSK 0x3
#define B_AX_DBG_SEL1_16BIT BIT(27)
#define B_AX_DBG_SEL1_SH 16
#define B_AX_DBG_SEL1_MSK 0xff
#define B_AX_DBG_SEL0_4BIT_SH 14
#define B_AX_DBG_SEL0_4BIT_MSK 0x3
#define B_AX_DBG_SEL0_16BIT BIT(11)
#define B_AX_DBG_SEL0_SH 0
#define B_AX_DBG_SEL0_MSK 0xff

#define R_AX_PWR_CUT_CTRL 0x005C
#define B_AX_WLBBPC1_WT_SH 24
#define B_AX_WLBBPC1_WT_MSK 0xff
#define B_AX_WLBBPC0_WT_SH 16
#define B_AX_WLBBPC0_WT_MSK 0xff
#define B_AX_WLMACPC1_WT_SH 12
#define B_AX_WLMACPC1_WT_MSK 0xf
#define B_AX_WLMACPC0_WT_SH 8
#define B_AX_WLMACPC0_WT_MSK 0xf
#define B_AX_WLPONPC1_WT_SH 4
#define B_AX_WLPONPC1_WT_MSK 0xf
#define B_AX_WLPONPC0_WT_SH 0
#define B_AX_WLPONPC0_WT_MSK 0xf

#define R_AX_GPIO_EXT_CTRL 0x0060
#define B_AX_GPIO_MOD_15_TO_8_SH 24
#define B_AX_GPIO_MOD_15_TO_8_MSK 0xff
#define B_AX_GPIO_IO_SEL_15_TO_8_SH 16
#define B_AX_GPIO_IO_SEL_15_TO_8_MSK 0xff
#define B_AX_GPIO_OUT_15_TO_8_SH 8
#define B_AX_GPIO_OUT_15_TO_8_MSK 0xff
#define B_AX_GPIO_IN_15_TO_8_SH 0
#define B_AX_GPIO_IN_15_TO_8_MSK 0xff

#define R_AX_PAD_CTRL1 0x0064
#define B_AX_BT_BQB_GPIO_SEL BIT(27)
#define B_AX_BTGP_GPG3_FEN BIT(26)
#define B_AX_BTGP_GPG2_FEN BIT(25)
#define B_AX_BTGP_JTAG_EN BIT(24)
#define B_AX_XTAL_CLK_EXTARNAL_EN BIT(23)
#define B_AX_BTGP_UART0_EN BIT(22)
#define B_AX_BTGP_UART1_EN BIT(21)
#define B_AX_BTGP_SPI_EN BIT(20)
#define B_AX_BTGP_GPIO_E2 BIT(19)
#define B_AX_BTGP_GPIO_EN BIT(18)
#define B_AX_BTGP_GPIO_SL_SH 16
#define B_AX_BTGP_GPIO_SL_MSK 0x3
#define B_AX_WL_JTAG_EN BIT(15)
#define B_AX_PAD_SDIO_SR BIT(14)
#define B_AX_GPIO14_OUTPUT_PL BIT(13)
#define B_AX_HOST_WAKE_PAD_PULL_EN BIT(12)
#define B_AX_HOST_WAKE_PAD_SL BIT(11)

#define R_AX_WL_BT_PWR_CTRL 0x0068
#define B_AX_ISO_BD2PP BIT(31)
#define B_AX_LDOV12B_EN BIT(30)
#define B_AX_CKEN_BT BIT(29)
#define B_AX_FEN_BT BIT(28)
#define B_AX_BTCPU_BOOTSEL BIT(27)
#define B_AX_SPI_SPEEDUP BIT(26)
#define B_AX_BT_LDO_MODE BIT(25)
#define B_AX_DEVWAKE_PAD_TYPE_SEL BIT(24)
#define B_AX_CLKREQ_PAD_TYPE_SEL BIT(23)
#define B_AX_ISO_BTPON2PP BIT(22)
#define B_AX_BT_HWROF_EN BIT(19)
#define B_AX_BT_FUNC_EN BIT(18)
#define B_AX_BT_HWPDN_SL BIT(17)
#define B_AX_BT_DISN_EN BIT(16)
#define B_AX_BT_PDN_PULL_EN BIT(15)
#define B_AX_WL_PDN_PULL_EN BIT(14)
#define B_AX_EXTERNAL_REQUEST_PL BIT(13)
#define B_AX_GPIO0_2_3_PULL_LOW_EN BIT(12)
#define B_AX_ISO_BA2PP BIT(11)
#define B_AX_BT_AFE_LDO_EN BIT(10)
#define B_AX_BT_AFE_PLL_EN BIT(9)
#define B_AX_BT_DIG_CLK_EN BIT(8)
#define B_AX_WLAN_32K_SEL BIT(6)
#define B_AX_WL_DRV_EXIST_IDX BIT(5)
#define B_AX_DOP_EHPAD BIT(4)
#define B_AX_WL_HWROF_EN BIT(3)
#define B_AX_WL_FUNC_EN BIT(2)
#define B_AX_WL_HWPDN_SL BIT(1)
#define B_AX_WL_HWPDN_EN BIT(0)

#define R_AX_SDM_DEBUG 0x006C
#define B_AX_GPIO_IE_V18 BIT(10)
#define B_AX_PCIE_IE_V18 BIT(9)
#define B_AX_UART_IE_V18 BIT(8)

#define R_AX_SYS_SDIO_CTRL 0x0070
#define B_AX_DBG_GNT_WL_BT BIT(27)
#define B_AX_LTE_MUX_CTRL_PATH BIT(26)
#define B_AX_LTE_COEX_UART BIT(25)
#define B_AX_3W_LTE_WL_GPIO BIT(24)
#define B_AX_SDIO_INT_POLARITY BIT(19)
#define B_AX_SDIO_INT BIT(18)
#define B_AX_SDIO_OFF_EN BIT(17)
#define B_AX_SDIO_ON_EN BIT(16)
#define B_AX_PCIE_DIS_L2_CTRL_LDO_HCI BIT(15)
#define B_AX_PCIE_DIS_WLSUS_AFT_PDN BIT(14)
#define B_AX_PCIE_FORCE_PWR_NGAT BIT(13)
#define B_AX_PCIE_CALIB_EN_V1 BIT(12)
#define B_AX_PCIE_AUXCLK_GATE BIT(11)
#define B_AX_PCIE_WAIT_TIMEOUT_EVENT BIT(10)
#define B_AX_PCIE_WAIT_TIME BIT(9)
#define B_AX_USBA_FORCE_PWR_NGAT BIT(7)
#define B_AX_USBD_FORCE_PWR_NGAT BIT(6)
#define B_AX_BT_CTRL_USB_PWR BIT(5)
#define B_AX_USB_D_STATE_HOLD BIT(4)
#define B_AX_R_AX_FORCE_DP BIT(3)
#define B_AX_R_AX_DP_MODE BIT(2)
#define B_AX_RES_USB_MASS_STORAGE_DESC BIT(1)
#define B_AX_USB_WAIT_TIME BIT(0)

#define R_AX_HCI_OPT_CTRL 0x0074
#define B_AX_PCIE_CPHY_CCK_XTAL_SEL BIT(20)
#define B_AX_SDIO_DATA_PAD_SMT BIT(19)
#define B_AX_SDIO_PAD_E5 BIT(18)
#define B_AX_NOPWR_CTRL_SEL BIT(13)
#define B_AX_USB_HOST_PWR_OFF_EN BIT(12)
#define B_AX_SYM_LPS_BLOCK_EN BIT(11)
#define B_AX_USB_LPM_ACT_EN BIT(10)
#define B_AX_USB_LPM_NY BIT(9)
#define B_AX_USB_SUS_DIS BIT(8)
#define B_AX_SDIO_PAD_E_SH 5
#define B_AX_SDIO_PAD_E_MSK 0x7
#define B_AX_USB_LPPLL_EN BIT(4)
#define B_AX_USB1_1_USB2_0_DECISION BIT(3)
#define B_AX_ROP_SW15 BIT(2)
#define B_AX_PCI_CKRDY_OPT BIT(1)
#define B_AX_PCI_VAUX_EN BIT(0)

#define R_AX_HCI_BG_CTRL 0x0078
#define B_AX_IBX_EN_VALUE BIT(15)
#define B_AX_IB_EN_VALUE BIT(14)
#define B_AX_FORCED_IB_EN BIT(4)
#define B_AX_EN_REGBG BIT(3)
#define B_AX_R_AX_BG_LPF BIT(2)
#define B_AX_R_AX_BG_SH 0
#define B_AX_R_AX_BG_MSK 0x3

#define R_AX_HCI_LDO_CTRL 0x007A
#define B_AX_EN_LW_PWR BIT(6)
#define B_AX_EN_REGU BIT(5)
#define B_AX_EN_PC BIT(4)
#define B_AX_R_AX_VADJ_SH 0
#define B_AX_R_AX_VADJ_MSK 0xf

#define R_AX_LDO_SWR_CTRL 0x007C
#define B_AX_DIG_ZCD_HW_AUTO_EN BIT(27)
#define B_AX_DIG_ZCD_REGSEL BIT(26)
#define B_AX_DIG_AUTO_ZCD_IN_CODE_SH 21
#define B_AX_DIG_AUTO_ZCD_IN_CODE_MSK 0x1f
#define B_AX_DIG_ZCD_CODE_IN_L_SH 16
#define B_AX_DIG_ZCD_CODE_IN_L_MSK 0x1f
#define B_AX_ANA_ZCD_HW_AUTO_EN BIT(11)
#define B_AX_ANA_ZCD_REGSEL BIT(10)
#define B_AX_ANA_AUTO_ZCD_IN_CODE_SH 5
#define B_AX_ANA_AUTO_ZCD_IN_CODE_MSK 0x1f
#define B_AX_ANA_ZCD_CODE_IN_L_SH 0
#define B_AX_ANA_ZCD_CODE_IN_L_MSK 0x1f

#define R_AX_SYS_ISO_CTRL_EXTEND 0x0080
#define B_AX_R_SYM_FEN_WLMACOFF BIT(31)
#define B_AX_CMAC1_FEN BIT(30)
#define B_AX_R_SYM_ISO_DMEM32PP BIT(28)
#define B_AX_R_SYM_ISO_DMEM22PP BIT(27)
#define B_AX_R_SYM_ISO_DMEM12PP BIT(26)
#define B_AX_R_SYM_ISO_IMEM42PP BIT(22)
#define B_AX_R_SYM_ISO_IMEM32PP BIT(21)
#define B_AX_R_SYM_ISO_IMEM22PP BIT(20)
#define B_AX_R_SYM_ISO_IMEM12PP BIT(19)
#define B_AX_R_SYM_ISO_IMEM02PP BIT(18)
#define B_AX_R_SYM_FEN_WLBBGLB_1 BIT(17)
#define B_AX_R_SYM_FEN_WLBBFUN_1 BIT(16)
#define B_AX_R_SYM_ISO_AON_OFF2PP BIT(15)
#define B_AX_R_SYM_PWC_PD12V BIT(12)
#define B_AX_R_SYM_PWC_UD12V BIT(11)
#define B_AX_R_SYM_LDOBTSDIO_EN BIT(9)
#define B_AX_R_SYM_LDOSPDIO_EN BIT(8)
#define B_AX_R_SYM_ISO_BB2PP BIT(7)
#define B_AX_R_SYM_ISO_DENG2PP BIT(6)
#define B_AX_R_SYM_ISO_CMAC12PP BIT(5)
#define B_AX_R_SYM_ISO_BTSDIO2PP BIT(1)
#define B_AX_R_SYM_ISO_SPDIO2PP BIT(0)

#define R_AX_PLATFORM_ENABLE 0x0088
#define B_AX_SYM_WLPLT_MEM_MUX_EN BIT(10)
#define B_AX_WCPU_WARM_EN BIT(9)
#define B_AX_SPIC_EN BIT(8)
#define B_AX_UART_EN BIT(7)
#define B_AX_IDDMA_EN BIT(6)
#define B_AX_IPSEC_EN BIT(5)
#define B_AX_HIOE_EN BIT(4)
#define B_AX_AXIDMA_EN BIT(3)
#define B_AX_APB_WRAP_EN BIT(2)
#define B_AX_WCPU_EN BIT(1)
#define B_AX_PLATFORM_EN BIT(0)

#define R_AX_WLLPS_CTRL 0x0090
#define B_AX_LPSOP_BBOFF BIT(29)
#define B_AX_LPSOP_MACOFF BIT(28)
#define B_AX_LPSOP_MEM_DS BIT(26)
#define B_AX_LPSOP_XTALM_LPS BIT(23)
#define B_AX_LPSOP_XTAL BIT(22)
#define B_AX_LPSOP_ACLK_DIV_2 BIT(21)
#define B_AX_LPSOP_ACLK_SEL BIT(20)
#define B_AX_LPSOP_ASWRM BIT(17)
#define B_AX_LPSOP_ASWR BIT(16)
#define B_AX_LPSOP_DSWR_ADJ_SH 12
#define B_AX_LPSOP_DSWR_ADJ_MSK 0xf
#define B_AX_LPSOP_DSWRSD BIT(10)
#define B_AX_LPSOP_DSWRM BIT(9)
#define B_AX_LPSOP_DSWR BIT(8)
#define B_AX_LPSOP_OLD_ADJ_SH 4
#define B_AX_LPSOP_OLD_ADJ_MSK 0xf
#define B_AX_FORCE_LEAVE_LPS BIT(3)
#define B_AX_LPSOP_OLDSD BIT(2)
#define B_AX_LPSOP_OLDM BIT(1)
#define B_AX_WL_LPS_EN BIT(0)

#define R_AX_WLRESUME_CTRL 0x0094
#define B_AX_LPSROP_CMAC1 BIT(20)
#define B_AX_LPSROP_XTALM BIT(19)
#define B_AX_LPSROP_AFEM BIT(18)
#define B_AX_LPSROP_HIOE BIT(17)
#define B_AX_LPSROP_CPU BIT(16)
#define B_AX_LPSROP_DSWRSD_SEL_SH 4
#define B_AX_LPSROP_DSWRSD_SEL_MSK 0x3

#define R_AX_GPIO_DEBOUNCE_CTRL 0x0098
#define B_AX_WLGP_DBC1EN BIT(15)
#define B_AX_WLGP_DBC1_SH 8
#define B_AX_WLGP_DBC1_MSK 0xf
#define B_AX_WLGP_DBC0EN BIT(7)
#define B_AX_WLGP_DBC0_SH 0
#define B_AX_WLGP_DBC0_MSK 0xf

#define R_AX_SYSON_FSM_MON 0x00A0
#define B_AX_FSM_MON_SEL_SH 24
#define B_AX_FSM_MON_SEL_MSK 0x7
#define B_AX_DOP_ELDO BIT(23)
#define B_AX_FSM_MON_UPD BIT(15)
#define B_AX_FSM_PAR_SH 0
#define B_AX_FSM_PAR_MSK 0x7fff

#define R_AX_PMC_DBG_CTRL1 0x00A8
#define B_AX_PMC_WR_OVF BIT(8)
#define B_AX_WLPMC_ERRINT_SH 0
#define B_AX_WLPMC_ERRINT_MSK 0xff

#define R_AX_SCOREBOARD  0x00AC
#define B_AX_TOGGLE BIT(31)
#define B_AX_DATA_LINE_SH 0
#define B_AX_DATA_LINE_MSK 0x7fffffffL

#define R_AX_DBG_PORT_SEL 0x00C0
#define B_AX_DEBUG_ST_SH 0
#define B_AX_DEBUG_ST_MSK 0xffffffffL

#define R_AX_PAD_CTRL2 0x00C4
#define B_AX_FORCE_CLK_U2 BIT(25)
#define B_AX_FORCE_U2_CK BIT(24)
#define B_AX_FORCE_U3_CK BIT(23)
#define B_AX_USB2_FORCE BIT(22)
#define B_AX_USB3_FORCE BIT(21)
#define B_AX_USB3_USB2_TRANSITION BIT(20)
#define B_AX_USB23_SW_MODE_V1_SH 18
#define B_AX_USB23_SW_MODE_V1_MSK 0x3
#define B_AX_NO_PDN_CHIPOFF_V1 BIT(17)
#define B_AX_RSM_EN_V1 BIT(16)
#define B_AX_MATCH_CNT_SH 8
#define B_AX_MATCH_CNT_MSK 0xff
#define B_AX_LD_B12V_EN BIT(7)
#define B_AX_EECS_IOSEL_V1 BIT(6)
#define B_AX_EECS_DATA_O_V1 BIT(5)
#define B_AX_EECS_DATA_I_V1 BIT(4)
#define B_AX_EESK_IOSEL_V1 BIT(2)
#define B_AX_EESK_DATA_O_V1 BIT(1)
#define B_AX_EESK_DATA_I_V1 BIT(0)

#define R_AX_PMC_DBG_CTRL2 0x00CC
#define B_AX_EFUSE_BURN_GNT_SH 24
#define B_AX_EFUSE_BURN_GNT_MSK 0xff
#define B_AX_DIS_IOWRAP_TIMEOUT BIT(16)
#define B_AX_STOP_WL_PMC BIT(9)
#define B_AX_STOP_SYM_PMC BIT(8)
#define B_AX_BT_ACCESS_WL_PAGE0 BIT(6)
#define B_AX_R_AX_RST_WLPMC BIT(5)
#define B_AX_R_AX_RST_PD12N BIT(4)
#define B_AX_SYSON_DIS_WLR_AX_WRMSK BIT(3)
#define B_AX_SYSON_DIS_PMCR_AX_WRMSK BIT(2)
#define B_AX_SYSON_R_AX_ARB_SH 0
#define B_AX_SYSON_R_AX_ARB_MSK 0x3

#define R_AX_MEM_PWR_CTRL 0x00D0
#define B_AX_MEM_BB_SD BIT(17)
#define B_AX_MEM_BB_DS BIT(16)
#define B_AX_MEM_BT_DS BIT(10)
#define B_AX_MEM_SDIO_LS BIT(9)
#define B_AX_MEM_SDIO_DS BIT(8)
#define B_AX_MEM_USB_LS BIT(7)
#define B_AX_MEM_USB_DS BIT(6)
#define B_AX_MEM_PCI_LS BIT(5)
#define B_AX_MEM_PCI_DS BIT(4)
#define B_AX_MEM_WLMAC_LS BIT(3)
#define B_AX_MEM_WLMAC_DS BIT(2)
#define B_AX_MEM_WLMCU_LS BIT(1)
#define B_AX_MEM_WLMCU_DS BIT(0)

#define R_AX_INDIR_ADR_SDIO 0x00D4
#define B_AX_INDIR_READY_SDIO BIT(17)
#define B_AX_INDIR_R_SDIO BIT(16)
#define B_AX_INDIR_ADR_SDIO_SH 0
#define B_AX_INDIR_ADR_SDIO_MSK 0xffff

#define R_AX_INDIR_DATA_SDIO 0x00D8
#define B_AX_INDIR_DATA_SDIO_SH 0
#define B_AX_INDIR_DATA_SDIO_MSK 0xffffffffL

#define R_AX_USB_SIE_INTF 0x00E0
#define B_AX_USB_REG_SEL BIT(31)
#define B_AX_USB_WRITE_EN BIT(30)
#define B_AX_USB_REG_EN BIT(29)
#define B_AX_USB_SIE_SEL BIT(28)
#define B_AX_USB_REG_STATUS BIT(27)
#define B_AX_USB_PHY_BYTE_SEL BIT(26)
#define B_AX_USB_SIE_INTF_ADDR_SH 16
#define B_AX_USB_SIE_INTF_ADDR_MSK 0x3ff
#define B_AX_USB_SIE_INTF_RD_SH 8
#define B_AX_USB_SIE_INTF_RD_MSK 0xff
#define B_AX_USB_SIE_INTF_WD_SH 0
#define B_AX_USB_SIE_INTF_WD_MSK 0xff

#define R_AX_PCIE_MIO_INTF 0x00E4
#define B_AX_PCIE_MIO_ADDR_PAGE_SH 16
#define B_AX_PCIE_MIO_ADDR_PAGE_MSK 0x3
#define B_AX_PCIE_MIO_BYIOREG BIT(13)
#define B_AX_PCIE_MIO_RE BIT(12)
#define B_AX_PCIE_MIO_WE_SH 8
#define B_AX_PCIE_MIO_WE_MSK 0xf
#define B_AX_PCIE_MIO_ADDR_SH 0
#define B_AX_PCIE_MIO_ADDR_MSK 0xff

#define R_AX_PCIE_MIO_INTD 0x00E8
#define B_AX_PCIE_MIO_DATA_SH 0
#define B_AX_PCIE_MIO_DATA_MSK 0xffffffffL

#define R_AX_WLRF1 0x00EC
#define B_AX_S1_RFC_WO_0 BIT(31)
#define B_AX_S1_RFC_WT_0 BIT(30)
#define B_AX_S1_RFC_RSTB BIT(25)

#define R_AX_SYS_CFG1 0x00F0
#define B_AX_TRP_ICFG_SH 28
#define B_AX_TRP_ICFG_MSK 0xf
#define B_AX_RF_TYPE_ID BIT(27)
#define B_AX_BD_HCI_SEL BIT(26)
#define B_AX_BD_PKG_SEL BIT(25)
#define B_AX_RTL_ID BIT(23)
#define B_AX_PAD_HWPD_IDN BIT(22)
#define B_AX_TESTMODE BIT(20)
#define B_AX_VENDOR_ID_SH 16
#define B_AX_VENDOR_ID_MSK 0xf
#define B_AX_CHIP_VER_SH 12
#define B_AX_CHIP_VER_MSK 0xf
#define B_AX_BD_MAC3 BIT(11)
#define B_AX_BD_MAC1 BIT(10)
#define B_AX_BD_MAC2 BIT(9)
#define B_AX_SIC_IDLE BIT(8)
#define B_AX_ANA_SPS_OCP_SHUTDN BIT(7)
#define B_AX_DIG_SPS_OCP_SHUTDN BIT(6)
#define B_AX_V15_VLD BIT(5)
#define B_AX_PCIRSTB BIT(4)
#define B_AX_PCLK_VLD BIT(3)
#define B_AX_UCLK_VLD BIT(2)
#define B_AX_ACLK_VLD BIT(1)
#define B_AX_XCLK_VLD BIT(0)

#define R_AX_SYS_STATUS1 0x00F4
#define B_AX_RF_RL_ID_SH 28
#define B_AX_RF_RL_ID_MSK 0xf
#define B_AX_BT_LPS_EN BIT(27)
#define B_AX_WLAN_LPS_EN BIT(26)
#define B_AX_HPHY_ICFG BIT(19)
#define B_AX_SEL_0XC0_SH 16
#define B_AX_SEL_0XC0_MSK 0x3
#define B_AX_HCI_SEL_V4_SH 13
#define B_AX_HCI_SEL_V4_MSK 0x7
#define B_AX_USB_OPERATION_MODE BIT(12)
#define B_AX_BT_PDN BIT(11)
#define B_AX_AUTO_WLPON BIT(10)
#define B_AX_WL_MODE_SH 8
#define B_AX_WL_MODE_MSK 0x3
#define B_AX_PKG_SEL_HCI BIT(6)
#define B_AX_PAD_HCI_SEL_V2_SH 3
#define B_AX_PAD_HCI_SEL_V2_MSK 0x7
#define B_AX_EFS_HCI_SEL_V1_SH 0
#define B_AX_EFS_HCI_SEL_V1_MSK 0x7

#define R_AX_SYS_STATUS2 0x00F8
#define B_AX_SIC_ON_TIMEOUT BIT(22)
#define B_AX_CPU_ON_TIMEOUT BIT(21)
#define B_AX_HCI_ON_TIMEOUT BIT(20)
#define B_AX_SIO_ALDN BIT(19)
#define B_AX_USB_ALDN BIT(18)
#define B_AX_PCI_ALDN BIT(17)
#define B_AX_SYS_ALDN BIT(16)
#define B_AX_EPVID1_SH 8
#define B_AX_EPVID1_MSK 0xff
#define B_AX_EPVID0_SH 0
#define B_AX_EPVID0_MSK 0xff

#define R_AX_SYS_CHIPINFO 0x00FC
#define B_AX_USB2_SEL BIT(31)
#define B_AX_U3PHY_RST_V1 BIT(30)
#define B_AX_U3_TERM_DETECT BIT(29)
#define B_AX_HW_ID_SH 0
#define B_AX_HW_ID_MSK 0xff

#define R_AX_SYS_CFG3 0x0100

#define R_AX_ANAPARSW_MAC_0 0x0110
#define B_AX_OCP_L BIT(31)
#define B_AX_POWOCP_L BIT(30)
#define B_AX_CF_L_V2_SH 28
#define B_AX_CF_L_V2_MSK 0x3
#define B_AX_CFC_L_V2_SH 26
#define B_AX_CFC_L_V2_MSK 0x3
#define B_AX_R3_L_V2_SH 24
#define B_AX_R3_L_V2_MSK 0x3
#define B_AX_R2_L_SH 22
#define B_AX_R2_L_MSK 0x3
#define B_AX_R1_L_SH 20
#define B_AX_R1_L_MSK 0x3
#define B_AX_C3_L_SH 18
#define B_AX_C3_L_MSK 0x3
#define B_AX_C2_L_SH 16
#define B_AX_C2_L_MSK 0x3
#define B_AX_C1_L_V2_SH 14
#define B_AX_C1_L_V2_MSK 0x3
#define B_AX_R_AX_OCPS_L_V2 BIT(13)
#define B_AX_R_AX_PWM_L BIT(12)
#define B_AX_V15ADJ_L_SH 9
#define B_AX_V15ADJ_L_MSK 0x7
#define B_AX_IN_L_SH 6
#define B_AX_IN_L_MSK 0x7
#define B_AX_STD_L_SH 4
#define B_AX_STD_L_MSK 0x3
#define B_AX_VOL_L_SH 0
#define B_AX_VOL_L_MSK 0xf

#define R_AX_ANAPARSW_MAC_1 0x0114
#define B_AX_OCP_L_PFM_SH 29
#define B_AX_OCP_L_PFM_MSK 0x7
#define B_AX_CFC_L_PFM_SH 27
#define B_AX_CFC_L_PFM_MSK 0x3
#define B_AX_R_AX_FREQ_L_V1_SH 20
#define B_AX_R_AX_FREQ_L_V1_MSK 0x7
#define B_AX_EN_DUTY BIT(19)
#define B_AX_R_AX_MODE_V2_SH 17
#define B_AX_R_AX_MODE_V2_MSK 0x3
#define B_AX_EN_SP BIT(16)
#define B_AX_R_AX_AUTO_L_V2 BIT(15)
#define B_AX_R_AX_LDOF_L_V2 BIT(14)
#define B_AX_R_AX_TYPE_L_V2 BIT(13)
#define B_AX_VO15_V1P05_H BIT(12)
#define B_AX_ARENB_L_V2 BIT(11)
#define B_AX_TBOX_L1_V2_SH 9
#define B_AX_TBOX_L1_V2_MSK 0x3
#define B_AX_R_AX_DELAY_L_SH 7
#define B_AX_R_AX_DELAY_L_MSK 0x3
#define B_AX_R_AX_CLAMP_D_L BIT(6)
#define B_AX_R_AX_BYPASS_L_V2 BIT(5)
#define B_AX_R_AX_AUTOZCD_L BIT(4)
#define B_AX_POW_ZCD_L_V2 BIT(3)
#define B_AX_R_AX_HALF_L BIT(2)
#define B_AX_OCP_L_V2_SH 0
#define B_AX_OCP_L_V2_MSK 0x3

#define R_AX_ANAPAR_MAC_0 0x0118
#define B_AX_R_AX_LPF_R3_SH 29
#define B_AX_R_AX_LPF_R3_MSK 0x7
#define B_AX_R_AX_LPF_R2_SH 24
#define B_AX_R_AX_LPF_R2_MSK 0x1f
#define B_AX_R_AX_LPF_C3_SH 21
#define B_AX_R_AX_LPF_C3_MSK 0x7
#define B_AX_R_AX_LPF_C2_SH 18
#define B_AX_R_AX_LPF_C2_MSK 0x7
#define B_AX_R_AX_LPF_C1_SH 15
#define B_AX_R_AX_LPF_C1_MSK 0x7
#define B_AX_R_AX_LDO_SEL_V1_SH 13
#define B_AX_R_AX_LDO_SEL_V1_MSK 0x3
#define B_AX_R_AX_CP_ICPX2 BIT(12)
#define B_AX_R_AX_CP_ICP_SEL_FAST_SH 9
#define B_AX_R_AX_CP_ICP_SEL_FAST_MSK 0x7
#define B_AX_R_AX_CP_ICP_SEL_SH 6
#define B_AX_R_AX_CP_ICP_SEL_MSK 0x7
#define B_AX_R_AX_IB_PI_SH 4
#define B_AX_R_AX_IB_PI_MSK 0x3
#define B_AX_LDO2PWRCUT BIT(3)
#define B_AX_VPULSE_LDO BIT(2)
#define B_AX_LDO_VSEL_SH 0
#define B_AX_LDO_VSEL_MSK 0x3

#define R_AX_ANAPAR_MAC_1 0x011C
#define B_AX_R_AX_CK_MON_SEL_SH 29
#define B_AX_R_AX_CK_MON_SEL_MSK 0x7
#define B_AX_R_AX_CK_MON_EN BIT(28)
#define B_AX_R_AX_XTAL_FREQ_SEL BIT(27)
#define B_AX_R_AX_XTAL_EDGE_SEL BIT(26)
#define B_AX_R_AX_VCO_KVCO BIT(25)
#define B_AX_R_AX_SDM_EDGE_SEL BIT(24)
#define B_AX_R_AX_SDM_CK_SEL BIT(23)
#define B_AX_R_AX_SDM_CK_GATED BIT(22)
#define B_AX_R_AX_PFD_RESET_GATED BIT(21)
#define B_AX_R_AX_LPF_R3_FAST_SH 16
#define B_AX_R_AX_LPF_R3_FAST_MSK 0x1f
#define B_AX_R_AX_LPF_R2_FAST_SH 11
#define B_AX_R_AX_LPF_R2_FAST_MSK 0x1f
#define B_AX_R_AX_LPF_C3_FAST_SH 8
#define B_AX_R_AX_LPF_C3_FAST_MSK 0x7
#define B_AX_R_AX_LPF_C2_FAST_SH 5
#define B_AX_R_AX_LPF_C2_FAST_MSK 0x7
#define B_AX_R_AX_LPF_C1_FAST_SH 2
#define B_AX_R_AX_LPF_C1_FAST_MSK 0x7
#define B_AX_R_AX_LPF_R3_V1_SH 0
#define B_AX_R_AX_LPF_R3_V1_MSK 0x3

#define R_AX_ANAPAR_MAC_2 0x0120
#define B_AX_AGPIO_DRV_V1_SH 30
#define B_AX_AGPIO_DRV_V1_MSK 0x3
#define B_AX_AGPIO_GPO_V1 BIT(29)
#define B_AX_AGPIO_GPE_V1 BIT(28)
#define B_AX_SEL_CLK BIT(27)
#define B_AX_LS_XTAL_SEL_SH 23
#define B_AX_LS_XTAL_SEL_MSK 0xf
#define B_AX_LS_SDM_ORDER_V1 BIT(22)
#define B_AX_LS_DELAY_PH BIT(21)
#define B_AX_DIVIDER_SEL BIT(20)
#define B_AX_PCODE_SH 15
#define B_AX_PCODE_MSK 0x1f
#define B_AX_NCODE_SH 7
#define B_AX_NCODE_MSK 0xff
#define B_AX_R_AX_BEACON BIT(6)
#define B_AX_R_AX_MBIASE BIT(5)
#define B_AX_R_AX_FAST_SEL_SH 3
#define B_AX_R_AX_FAST_SEL_MSK 0x3
#define B_AX_R_AX_CK960M_EN BIT(2)
#define B_AX_R_AX_CK320M_EN BIT(1)
#define B_AX_R_AX_CK_5M_EN BIT(0)

#define R_AX_RFE_PINMUX_CTRL 0x0140
#define B_AX__BANDSELN_5G_SEL BIT(31)
#define B_AX__BANDSELN_5G_EN BIT(30)
#define B_AX_BANDSELN_5_6G_SEL BIT(29)
#define B_AX_BANDSELN_5_6G_EN BIT(28)
#define B_AX_PAON_LNAON_6G_S1_SEL BIT(27)
#define B_AX_PAON_LNAON_6G_S1_EN BIT(26)
#define B_AX_PAON_LNAON_6G_S0_SEL BIT(25)
#define B_AX_PAON_LNAON_6G_S0_EN BIT(24)
#define B_AX_PAON_LNAON_5G_S1_SEL BIT(23)
#define B_AX_PAON_LNAON_5G_S1_EN BIT(22)
#define B_AX_PAON_LNAON_5G_S0_SEL BIT(21)
#define B_AX_PAON_LNAON_5G_S0_EN BIT(20)
#define B_AX_PAON_LNAON_2G_S1_SEL BIT(19)
#define B_AX_PAON_LNAON_2G_S1_EN BIT(18)
#define B_AX_PAON_LNAON_2G_S0_SEL BIT(17)
#define B_AX_PAON_LNAON_2G_S0_EN BIT(16)
#define B_AX__BANDSELN_5G_G7G6_SEL BIT(15)
#define B_AX__BANDSELN_5G_G7G6_EN BIT(14)

#define R_AX_RFE_PINMUX_SEL_FUNC 0x0144
#define B_AX_RFE_WLBT_FUNC_8_SEL_EN BIT(8)
#define B_AX_RFE_WLBT_FUNC_7_SEL_EN BIT(7)
#define B_AX_RFE_WLBT_FUNC_6_SEL_EN BIT(6)
#define B_AX_RFE_WLBT_FUNC_5_SEL_EN BIT(5)
#define B_AX_RFE_WLBT_FUNC_4_SEL_EN BIT(4)
#define B_AX_RFE_WLBT_FUNC_3_SEL_EN BIT(3)
#define B_AX_RFE_WLBT_FUNC_2_SEL_EN BIT(2)
#define B_AX_RFE_WLBT_FUNC_1_SEL_EN BIT(1)
#define B_AX_RFE_WLBT_FUNC_0_SEL_EN BIT(0)

#define R_AX_GPIO_EESK_EECS_HIGH_PRI_PINMUX 0x0148
#define B_AX_STD_EECS_PINMUX_HIGH_PRI_EN BIT(17)
#define B_AX_STD_EESK_PINMUX_HIGH_PRI_EN BIT(16)
#define B_AX_STD_GPIO15_PINMUX_HIGH_PRI_EN BIT(15)
#define B_AX_STD_GPIO14_PINMUX_HIGH_PRI_EN BIT(14)
#define B_AX_STD_GPIO13_PINMUX_HIGH_PRI_EN BIT(13)
#define B_AX_STD_GPIO12_PINMUX_HIGH_PRI_EN BIT(12)
#define B_AX_STD_GPIO11_PINMUX_HIGH_PRI_EN BIT(11)
#define B_AX_STD_GPIO10_PINMUX_HIGH_PRI_EN BIT(10)
#define B_AX_STD_GPIO9_PINMUX_HIGH_PRI_EN BIT(9)
#define B_AX_STD_GPIO8_PINMUX_HIGH_PRI_EN BIT(8)
#define B_AX_STD_GPIO7_PINMUX_HIGH_PRI_EN BIT(7)
#define B_AX_STD_GPIO6_PINMUX_HIGH_PRI_EN BIT(6)
#define B_AX_STD_GPIO5_PINMUX_HIGH_PRI_EN BIT(5)
#define B_AX_STD_GPIO4_PINMUX_HIGH_PRI_EN BIT(4)
#define B_AX_STD_GPIO3_PINMUX_HIGH_PRI_EN BIT(3)
#define B_AX_STD_GPIO2_PINMUX_HIGH_PRI_EN BIT(2)
#define B_AX_STD_GPIO1_PINMUX_HIGH_PRI_EN BIT(1)
#define B_AX_STD_GPIO0_PINMUX_HIGH_PRI_EN BIT(0)

#define R_AX_RFE_CTRL 0x014C
#define B_AX_SW_LNAON_6G_S1_SEL_DATA BIT(13)
#define B_AX_SW_PAON_6G_S1_SEL_DATA BIT(12)
#define B_AX_BANDSELP_5G_SEL_DATA BIT(11)
#define B_AX_BANDSELP_5 BIT(10)
#define B_AX_SW_LNAON_6G_S0_SEL_DATA BIT(9)
#define B_AX_SW_PAON_6G_S0_SEL_DATA BIT(8)
#define B_AX_SW_LNAON_5G_S1_SEL_DATA BIT(7)
#define B_AX_SW_PAON_5G_S1_SEL_DATA BIT(6)
#define B_AX_SW_LNAON_5G_S0_SEL_DATA BIT(5)
#define B_AX_SW_PAON_5G_S0_SEL_DATA BIT(4)
#define B_AX_SW_LNAON_2G_S1_SEL_DATA BIT(3)
#define B_AX_SW_PAON_2G_S1_SEL_DATA BIT(2)
#define B_AX_SW_LNAON_2G_S0_SEL_DATA BIT(1)
#define B_AX_SW_PAON_2G_S0_SEL_DATA BIT(0)

#define R_AX_ANAPAR_XTAL_AACK_0 0x0154

#define R_AX_ANAPAR_XTAL_AACK_1 0x0158

#define R_AX_HALT_H2C_CTRL 0x0160
#define B_AX_HALT_H2C_TRIGGER BIT(0)

#define R_AX_HALT_C2H_CTRL 0x0164
#define B_AX_HALT_C2H_TRIGGER BIT(0)

#define R_AX_HALT_H2C 0x0168
#define B_AX_HALT_H2C_SH 0
#define B_AX_HALT_H2C_MSK 0xffffffffL

#define R_AX_HALT_C2H 0x016C
#define DBG_SENARIO_SH 28
#define B_AX_HALT_C2H_SH 0
#define B_AX_HALT_C2H_MSK 0xffffffffL

#define R_AX_SYS_CFG5 0x0170
#define B_AX_LPS_STATUS BIT(3)
#define B_AX_HCI_TXDMA_BUSY BIT(2)
#define B_AX_HCI_TXDMA_ALLOW BIT(1)
#define B_AX_FW_CTRL_HCI_TXDMA_EN BIT(0)

#define R_AX_ANACK_CAL_CTRL 0x0180
#define B_AX_CLK_CAL_EN BIT(31)
#define B_AX_CLK_SEL_SH 24
#define B_AX_CLK_SEL_MSK 0x3
#define B_AX_CLK_CAL_RPT_SH 0
#define B_AX_CLK_CAL_RPT_MSK 0xffff

#define R_AX_FWS0IMR 0x0190
#define B_AX_FS_HALT_H2C_INT_EN BIT(31)
#define B_AX_FS_FSM_HIOE_TO_EVENT_INT_EN BIT(30)
#define B_AX_FS_HCI_SUS_INT_EN BIT(29)
#define B_AX_FS_HCI_RES_INT_EN BIT(28)
#define B_AX_FS_HCI_RESET_INT_EN BIT(27)
#define B_AX_FS_USB_SCSI_CMD_INT_EN BIT(26)
#define B_AX_FS_ACT2RECOVERY_INT_EN BIT(25)
#define B_AX_FS_GEN1GEN2_SWITCH_INT_EN BIT(24)
#define B_AX_FS_HCI_TXDMA_REQ_INT_EN BIT(23)
#define B_AX_FS_USB_LPMRSM_INT_EN BIT(22)
#define B_AX_FS_USB_LPMINT_INT_EN BIT(21)
#define B_AX_FS_PWMERR_INT_EN BIT(20)
#define B_AX_FS_PDNINT_EN BIT(19)
#define B_AX_FS_SPSA_OCP_INT_EN BIT(18)
#define B_AX_FS_SPSD_OCP_INT_EN BIT(17)
#define B_AX_FS_BT_SB_INT_EN BIT(16)
#define B_AX_FS_GPIOF_INT_EN BIT(15)
#define B_AX_FS_GPIOE_INT_EN BIT(14)
#define B_AX_FS_GPIOD_INT_EN BIT(13)
#define B_AX_FS_GPIOC_INT_EN BIT(12)
#define B_AX_FS_GPIOB_INT_EN BIT(11)
#define B_AX_FS_GPIOA_INT_EN BIT(10)
#define B_AX_FS_GPIO9_INT_EN BIT(9)
#define B_AX_FS_GPIO8_INT_EN BIT(8)
#define B_AX_FS_GPIO7_INT_EN BIT(7)
#define B_AX_FS_GPIO6_INT_EN BIT(6)
#define B_AX_FS_GPIO5_INT_EN BIT(5)
#define B_AX_FS_GPIO4_INT_EN BIT(4)
#define B_AX_FS_GPIO3_INT_EN BIT(3)
#define B_AX_FS_GPIO2_INT_EN BIT(2)
#define B_AX_FS_GPIO1_INT_EN BIT(1)
#define B_AX_FS_GPIO0_INT_EN BIT(0)

#define R_AX_FWS0ISR 0x0194
#define B_AX_FS_HALT_H2C_INT BIT(31)
#define B_AX_FS_FSM_HIOE_TO_EVENT_INT BIT(30)
#define B_AX_FS_HCI_SUS_INT BIT(29)
#define B_AX_FS_HCI_RES_INT BIT(28)
#define B_AX_FS_HCI_RESET_INT BIT(27)
#define B_AX_FS_USB_SCSI_CMD_INT BIT(26)
#define B_AX_FS_ACT2RECOVERY_INT BIT(25)
#define B_AX_FS_GEN1GEN2_SWITCH_INT BIT(24)
#define B_AX_FS_HCI_TXDMA_REQ_INT BIT(23)
#define B_AX_FS_USB_LPMRSM_INT BIT(22)
#define B_AX_FS_USB_LPMINT_INT BIT(21)
#define B_AX_FS_PWMERR_INT BIT(20)
#define B_AX_FS_PDNINT BIT(19)
#define B_AX_FS_SPSA_OCP_INT BIT(18)
#define B_AX_FS_SPSD_OCP_INT BIT(17)
#define B_AX_FS_BT_SB_INT BIT(16)
#define B_AX_FS_GPIOF_INT BIT(15)
#define B_AX_FS_GPIOE_INT BIT(14)
#define B_AX_FS_GPIOD_INT BIT(13)
#define B_AX_FS_GPIOC_INT BIT(12)
#define B_AX_FS_GPIOB_INT BIT(11)
#define B_AX_FS_GPIOA_INT BIT(10)
#define B_AX_FS_GPIO9_INT BIT(9)
#define B_AX_FS_GPIO8_INT BIT(8)
#define B_AX_FS_GPIO7_INT BIT(7)
#define B_AX_FS_GPIO6_INT BIT(6)
#define B_AX_FS_GPIO5_INT BIT(5)
#define B_AX_FS_GPIO4_INT BIT(4)
#define B_AX_FS_GPIO3_INT BIT(3)
#define B_AX_FS_GPIO2_INT BIT(2)
#define B_AX_FS_GPIO1_INT BIT(1)
#define B_AX_FS_GPIO0_INT BIT(0)

#define R_AX_HSIMR 0x0198

#define R_AX_HSISR 0x019C

#define R_AX_HIMR0 0x01A0
#define B_AX_HALT_C2H_INT_EN BIT(21)
#define B_AX_RON_INT_EN BIT(20)
#define B_AX_PDNINT_EN BIT(19)
#define B_AX_SPSANA_OCP_INT_EN BIT(18)
#define B_AX_SPS_OCP_INT_EN BIT(17)
#define B_AX_BTON_STS_UPDATE_INT_EN BIT(16)
#define B_AX_GPIOF_INT_EN BIT(15)
#define B_AX_GPIOE_INT_EN BIT(14)
#define B_AX_GPIOD_INT_EN BIT(13)
#define B_AX_GPIOC_INT_EN BIT(12)
#define B_AX_GPIOB_INT_EN BIT(11)
#define B_AX_GPIOA_INT_EN BIT(10)
#define B_AX_GPIO9_INT_EN BIT(9)
#define B_AX_GPIO8_INT_EN BIT(8)
#define B_AX_GPIO7_INT_EN BIT(7)
#define B_AX_GPIO6_INT_EN BIT(6)
#define B_AX_GPIO5_INT_EN BIT(5)
#define B_AX_GPIO4_INT_EN BIT(4)
#define B_AX_GPIO3_INT_EN BIT(3)
#define B_AX_GPIO2_INT_EN BIT(2)
#define B_AX_GPIO1_INT_EN BIT(1)
#define B_AX_GPIO0_INT_EN BIT(0)

#define R_AX_HISR0 0x01A4
#define B_AX_HALT_C2H_INT BIT(21)
#define B_AX_RON_INT BIT(20)
#define B_AX_PDNINT BIT(19)
#define B_AX_SPSANA_OCP_INT BIT(18)
#define B_AX_SPS_OCP_INT BIT(17)
#define B_AX_BTON_STS_UPDATE_INT BIT(16)
#define B_AX_GPIOF_INT BIT(15)
#define B_AX_GPIOE_INT BIT(14)
#define B_AX_GPIOD_INT BIT(13)
#define B_AX_GPIOC_INT BIT(12)
#define B_AX_GPIOB_INT BIT(11)
#define B_AX_GPIOA_INT BIT(10)
#define B_AX_GPIO9_INT BIT(9)
#define B_AX_GPIO8_INT BIT(8)
#define B_AX_GPIO7_INT BIT(7)
#define B_AX_GPIO6_INT BIT(6)
#define B_AX_GPIO5_INT BIT(5)
#define B_AX_GPIO4_INT BIT(4)
#define B_AX_GPIO3_INT BIT(3)
#define B_AX_GPIO2_INT BIT(2)
#define B_AX_GPIO1_INT BIT(1)
#define B_AX_GPIO0_INT BIT(0)

#define R_AX_HIMR1 0x01A8

#define R_AX_HISR1 0x01AC

#define R_AX_HIMR2 0x01B0

#define R_AX_HISR2 0x01B4

#define R_AX_HIMR3 0x01B8

#define R_AX_HISR3 0x01BC

#define R_AX_SW_MDIO 0x01C0
#define B_AX_DIS_TIMEOUT_IO BIT(24)

#define R_AX_H2C_PKT_READADDR 0x01D0
#define B_AX_H2C_PKT_READADDR_SH 0
#define B_AX_H2C_PKT_READADDR_MSK 0x3ffff

#define R_AX_H2C_PKT_WRITEADDR 0x01D4
#define B_AX_H2C_PKT_WRITEADDR_SH 0
#define B_AX_H2C_PKT_WRITEADDR_MSK 0x3ffff

#define R_AX_MEM_PWR_CRTL 0x01D8
#define B_AX_MEM_BB_SD BIT(17)
#define B_AX_MEM_BB_DS BIT(16)
#define B_AX_MEM_BT_DS BIT(10)
#define B_AX_MEM_SDIO_LS BIT(9)
#define B_AX_MEM_SDIO_DS BIT(8)
#define B_AX_MEM_USB_LS BIT(7)
#define B_AX_MEM_USB_DS BIT(6)
#define B_AX_MEM_PCI_LS BIT(5)
#define B_AX_MEM_PCI_DS BIT(4)
#define B_AX_MEM_WLMAC_LS BIT(3)
#define B_AX_MEM_WLMAC_DS BIT(2)
#define B_AX_MEM_WLMCU_LS BIT(1)
#define B_AX_MEM_WLMCU_DS BIT(0)

#define R_AX_WCPU_FW_CTRL 0x01E0
#define B_AX_WCPU_ROM_ENUART BIT(31)
#define B_AX_WCPU_ROM_CUT_REQ BIT(30)
#define B_AX_WCPU_ROM_CUT_SH 8
#define B_AX_WCPU_ROM_CUT_MSK 0xff
#define B_AX_WCPU_FWDL_STS_SH 5
#define B_AX_WCPU_FWDL_STS_MSK 0x7
#define B_AX_FWDL_PATH_RDY BIT(2)
#define B_AX_H2C_PATH_RDY BIT(1)
#define B_AX_WCPU_FWDL_EN BIT(0)

#define R_AX_BOOT_REASON 0x01E6
#define B_AX_BOOT_REASON_SH 0
#define B_AX_BOOT_REASON_MSK 0x7

#define R_AX_RPWM 0x01E4
#define B_AX_RPWM_TOGGLE BIT(15)
#define B_AX_RPWM_VAL_SH 0
#define B_AX_RPWM_VAL_MSK 0x7fff

#define R_AX_LDM 0x01E8
#define B_AX_LDM_SH 0
#define B_AX_LDM_MSK 0xffffffffL

#define R_AX_UDM0 0x01F0
#define B_AX_UDM0_SH 0
#define B_AX_UDM0_MSK 0xffffffffL
#define B_AX_UDM0_DBG_MODE_SH 0
#define B_AX_UDM0_FS_CODE_SH 8
#define B_AX_UDM0_FS_CODE_MSK 0xffff
#define B_AX_UDM0_TRAP_LOOP_CTRL BIT(2)
#define B_AX_UDM0_DBG_MODE_CTRL BIT(0)

#define R_AX_UDM1 0x01F4
#define B_AX_UDM1_SH 0
#define B_AX_UDM1_MSK 0xffffffffL

#define R_AX_UDM2 0x01F8
#define B_AX_UDM2_SH 0
#define B_AX_UDM2_MSK 0xffffffffL

#define R_AX_UDM3 0x01FC
#define B_AX_UDM3_SH 0
#define B_AX_UDM3_MSK 0xffffffffL

#define R_AX_SPSLDO_ON_CTRL0 0x0200
#define B_AX_PFMCMP_IQ BIT(31)
#define B_AX_OFF_END_SEL BIT(29)
#define B_AX_POW_MINOFF_L BIT(28)
#define B_AX_COT_I_L_SH 26
#define B_AX_COT_I_L_MSK 0x3
#define B_AX_VREFPFM_L_SH 22
#define B_AX_VREFPFM_L_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS BIT(21)
#define B_AX_ZCD_SDZ_L_SH 19
#define B_AX_ZCD_SDZ_L_MSK 0x3
#define B_AX_REG_ZCDC_H_SH 17
#define B_AX_REG_ZCDC_H_MSK 0x3
#define B_AX_POW_ZCD_L BIT(16)
#define B_AX_OCP_L1_SH 13
#define B_AX_OCP_L1_MSK 0x7
#define B_AX_POWOCP_L1 BIT(12)
#define B_AX_SAW_FREQ_L_SH 8
#define B_AX_SAW_FREQ_L_MSK 0xf
#define B_AX_REG_BYPASS_L BIT(7)
#define B_AX_FPWM_L1 BIT(6)
#define B_AX_STD_L1_SH 4
#define B_AX_STD_L1_MSK 0x3
#define B_AX_VOL_L1_SH 0
#define B_AX_VOL_L1_MSK 0xf

#define R_AX_SPSLDO_ON_CTRL1 0x0204
#define B_AX_SN_N_L_SH 28
#define B_AX_SN_N_L_MSK 0xf
#define B_AX_SP_N_L_SH 24
#define B_AX_SP_N_L_MSK 0xf
#define B_AX_SN_P_L_SH 20
#define B_AX_SN_P_L_MSK 0xf
#define B_AX_SP_P_L_SH 16
#define B_AX_SP_P_L_MSK 0xf
#define B_AX_VO_DISCHG_PWM_H BIT(15)
#define B_AX_REG_MODE_PREDRIVER BIT(14)
#define B_AX_REG_ADJSLDO_L_SH 10
#define B_AX_REG_ADJSLDO_L_MSK 0xf
#define B_AX_REG_LDOR_L BIT(9)
#define B_AX_PWM_FORCE BIT(8)
#define B_AX_PFM_PD_RST BIT(7)
#define B_AX_VC_PFM_RSTB BIT(6)
#define B_AX_PFM_IN_SEL BIT(5)
#define B_AX_VC_RSTB BIT(4)
#define B_AX_FPWMDELAY BIT(3)
#define B_AX_ENFPWMDELAY_H BIT(2)
#define B_AX_REG_MOS_HALF_L BIT(1)
#define B_AX_CURRENT_SENSE_MOS BIT(0)
#define B_AX_SPS_PFM_ZCDC_H_PFM_SH 4
#define B_AX_SPS_PFM_ZCDC_H_PFM_MSK 0x3
#define B_AX_SPS_PFM_OCP_L_PFM_SH 0
#define B_AX_SPS_PFM_OCP_L_PFM_MSK 0x7

#define R_AX_LDO_AON_CTRL0 0x0218
#define B_AX_CK12M_EN BIT(11)
#define B_AX_CK12M_SEL BIT(10)
#define B_AX_EN_SLEEP BIT(8)
#define B_AX_LDOH12_V12ADJ_L_SH 4
#define B_AX_LDOH12_V12ADJ_L_MSK 0xf
#define B_AX_LDOE25_V12ADJ_L_SH 0
#define B_AX_LDOE25_V12ADJ_L_MSK 0xf

#define R_AX_SPSANA_ON_CTRL0 0x0220
#define B_AX_PFMCMP_IQ BIT(31)
#define B_AX_REG_EXTERNAL_CLK_SEL_L BIT(30)
#define B_AX_OFF_END_SEL BIT(29)
#define B_AX_POW_MINOFF_L BIT(28)
#define B_AX_FORCE_ZCD_BIAS BIT(21)
#define B_AX_POW_ZCD_L BIT(16)
#define B_AX_POWOCP_L1 BIT(12)
#define B_AX_REG_BYPASS_L BIT(7)
#define B_AX_FPWM_L1 BIT(6)

#define R_AX_SPSANA_ON_CTRL1 0x0224
#define B_AX_VO_DISCHG_PWM_H BIT(15)
#define B_AX_REG_MODE_PREDRIVER BIT(14)
#define B_AX_REG_LDOR_L BIT(9)
#define B_AX_PWM_FORCE BIT(8)
#define B_AX_PFM_PD_RST BIT(7)
#define B_AX_VC_PFM_RSTB BIT(6)
#define B_AX_PFM_IN_SEL BIT(5)
#define B_AX_VC_RSTB BIT(4)
#define B_AX_FPWMDELAY BIT(3)
#define B_AX_ENFPWMDELAY_H BIT(2)
#define B_AX_REG_MOS_HALF_L BIT(1)
#define B_AX_CURRENT_SENSE_MOS BIT(0)
#define B_AX_SPS_ANA_PFM_ZCDC_H_SH 4
#define B_AX_SPS_ANA_PFM_ZCDC_H_MSK 0x3
#define B_AX_SPS_ANA_PFM_OCP_L_SH 0
#define B_AX_SPS_ANA_PFM_OCP_L_MSK 0x7

#define R_AX_AFE_ON_CTRL0 0x0240
#define B_AX_REG_LPF_R3_SH 29
#define B_AX_REG_LPF_R3_MSK 0x7
#define B_AX_REG_LPF_R2_SH 24
#define B_AX_REG_LPF_R2_MSK 0x1f
#define B_AX_REG_LPF_C3_SH 21
#define B_AX_REG_LPF_C3_MSK 0x7
#define B_AX_REG_LPF_C2_SH 18
#define B_AX_REG_LPF_C2_MSK 0x7
#define B_AX_REG_LPF_C1_SH 15
#define B_AX_REG_LPF_C1_MSK 0x7
#define B_AX_REG_LDO_SEL_SH 13
#define B_AX_REG_LDO_SEL_MSK 0x3
#define B_AX_REG_CP_ICPX2 BIT(12)
#define B_AX_REG_CP_ICP_SEL_FAST_SH 9
#define B_AX_REG_CP_ICP_SEL_FAST_MSK 0x7
#define B_AX_REG_CP_ICP_SEL_SH 6
#define B_AX_REG_CP_ICP_SEL_MSK 0x7
#define B_AX_REG_IB_PI_SH 4
#define B_AX_REG_IB_PI_MSK 0x3
#define B_AX_LDO2PWRCUT BIT(3)
#define B_AX_VPULSE_LDO BIT(2)

#define R_AX_AFE_ON_CTRL1 0x0244
#define B_AX_REG_CK_MON_SEL_SH 29
#define B_AX_REG_CK_MON_SEL_MSK 0x7
#define B_AX_REG_CK_MON_EN BIT(28)
#define B_AX_REG_XTAL_FREQ_SEL BIT(27)
#define B_AX_REG_XTAL_EDGE_SEL BIT(26)
#define B_AX_REG_VCO_KVCO BIT(25)
#define B_AX_REG_SDM_EDGE_SEL BIT(24)
#define B_AX_REG_SDM_CK_SEL BIT(23)
#define B_AX_REG_SDM_CK_GATED BIT(22)
#define B_AX_REG_PFD_RESET_GATED BIT(21)
#define B_AX_REG_LPF_R3_FAST_SH 16
#define B_AX_REG_LPF_R3_FAST_MSK 0x1f
#define B_AX_REG_LPF_R2_FAST_SH 11
#define B_AX_REG_LPF_R2_FAST_MSK 0x1f
#define B_AX_REG_LPF_C3_FAST_SH 8
#define B_AX_REG_LPF_C3_FAST_MSK 0x7
#define B_AX_REG_LPF_C2_FAST_SH 5
#define B_AX_REG_LPF_C2_FAST_MSK 0x7
#define B_AX_REG_LPF_C1_FAST_SH 2
#define B_AX_REG_LPF_C1_FAST_MSK 0x7
#define B_AX_REG_LPF_R3__SH 0
#define B_AX_REG_LPF_R3__MSK 0x3

#define R_AX_AFE_ON_CTRL2 0x0248
#define B_AX_AGPIO_DRV_SH 30
#define B_AX_AGPIO_DRV_MSK 0x3
#define B_AX_AGPIO_GPO BIT(29)
#define B_AX_AGPIO_GPE BIT(28)
#define B_AX_SEL_CLK BIT(27)
#define B_AX_LS_SDM_ORDER BIT(22)
#define B_AX_LS_DELAY_PH BIT(21)
#define B_AX_DIVIDER_SEL BIT(20)
#define B_AX_REG_BEACON BIT(6)
#define B_AX_REG_MBIASE BIT(5)
#define B_AX_REG_FAST_SEL_SH 3
#define B_AX_REG_FAST_SEL_MSK 0x3
#define B_AX_REG_CK480M_EN BIT(2)
#define B_AX_REG_CK320M_EN BIT(1)
#define B_AX_REG_CK_5M_EN BIT(0)

#define R_AX_AFE_ON_CTRL3 0x024C
#define B_AX_REG_CK640M_EN BIT(0)

#define R_AX_WLAN_XTAL_SI_CTRL 0x0270
#define B_AX_WL_XTAL_SI_CMD_POLL BIT(31)
#define B_AX_BT_XTAL_SI_ERR_FLAG BIT(30)
#define B_AX_WL_XTAL_GNT BIT(29)
#define B_AX_BT_XTAL_GNT BIT(28)
#define B_AX_WL_XTAL_SI_MODE_SH 24
#define B_AX_WL_XTAL_SI_MODE_MSK 0x3
#define B_AX_WL_XTAL_SI_BITMASK_SH 16
#define B_AX_WL_XTAL_SI_BITMASK_MSK 0xff
#define B_AX_WL_XTAL_SI_DATA_SH 8
#define B_AX_WL_XTAL_SI_DATA_MSK 0xff
#define B_AX_WL_XTAL_SI_ADDR_SH 0
#define B_AX_WL_XTAL_SI_ADDR_MSK 0xff
#define R_AX_WLAN_XTAL_SI_CONFIG 0x0274
#define B_AX_XTAL_SI_CLK_DIV2 BIT(1)
#define B_AX_XTAL_SI_ADDR_NOT_CHK BIT(0)

#define R_AX_XTAL_ON_CTRL0 0x0280
#define B_AX_XTAL_SC_LPS BIT(31)
#define B_AX_XTAL_SC_INIT_SH 24
#define B_AX_XTAL_SC_INIT_MSK 0x7f
#define B_AX_XTAL_SC_XO_SH 17
#define B_AX_XTAL_SC_XO_MSK 0x7f
#define B_AX_XTAL_SC_XI_SH 10
#define B_AX_XTAL_SC_XI_MSK 0x7f
#define B_AX_XTAL_GMN_SH 5
#define B_AX_XTAL_GMN_MSK 0x1f
#define B_AX_XTAL_GMP_SH 0
#define B_AX_XTAL_GMP_MSK 0x1f
#define B_AX_EN_XBUF_DRV_LPS BIT(6)

#define R_AX_XTAL_ON_CTRL1 0x0284
#define B_AX_XTAL_VREF_SEL_SH 29
#define B_AX_XTAL_VREF_SEL_MSK 0x7
#define B_AX_XTAL_LPS_DIVISOR BIT(28)
#define B_AX_XTAL_CKDIGI_SEL BIT(27)
#define B_AX_EN_XTAL_SCHMITT BIT(26)
#define B_AX_XTAL_SEL_TOK_SH 23
#define B_AX_XTAL_SEL_TOK_MSK 0x7
#define B_AX_EN_XTAL_LPS_CLK BIT(22)
#define B_AX_XTAL_AAC_OPCUR_SH 20
#define B_AX_XTAL_AAC_OPCUR_MSK 0x3
#define B_AX_XTAL_LDO_VREF_SH 17
#define B_AX_XTAL_LDO_VREF_MSK 0x7
#define B_AX_EN_XTAL_DRV_BT BIT(16)
#define B_AX_EN_XTAL_DRV_BCN BIT(15)
#define B_AX_EN_XTAL_DRV_IQK BIT(14)
#define B_AX_EN_XTAL_DRV_LPS BIT(13)
#define B_AX_EN_XTAL_DRV_DIGI BIT(12)
#define B_AX_EN_XTAL_DRV_USB BIT(11)
#define B_AX_EN_XTAL_DRV_AFE BIT(10)
#define B_AX_XTAL_DRV_RF2N_RELAY BIT(9)
#define B_AX_XTAL_DRV_RF2P_RELAY BIT(8)
#define B_AX_EN_XTAL_DRV_RF2 BIT(7)
#define B_AX_EN_XTAL_DRV_RF1 BIT(6)
#define B_AX_XTAL_SC_LPS_SH 0
#define B_AX_XTAL_SC_LPS_MSK 0x3f

#define R_AX_XTAL_ON_CTRL2 0x0288
#define B_AX_XTAL_VREF_SEL__SH 6
#define B_AX_XTAL_VREF_SEL__MSK 0x3
#define B_AX_AAC_MODE_SH 4
#define B_AX_AAC_MODE_MSK 0x3
#define B_AX_XTAL_CFIX_SH 0
#define B_AX_XTAL_CFIX_MSK 0xf

#define R_AX_SYM_ANAPAR_XTAL_MODE_DECODER 0x02A0
#define B_AX_WIFI_FORCE_XTAL_HPMODE BIT(31)
#define B_AX_XTAL_LDO_LPS_SH 21
#define B_AX_XTAL_LDO_LPS_MSK 0x7
#define B_AX_XTAL_WAIT_CYC_SH 15
#define B_AX_XTAL_WAIT_CYC_MSK 0x3f
#define B_AX_XTAL_LDO_OK_SH 12
#define B_AX_XTAL_LDO_OK_MSK 0x7
#define B_AX_XTAL_MD_LPOW BIT(11)
#define B_AX_XTAL_OV_RATIO_SH 9
#define B_AX_XTAL_OV_RATIO_MSK 0x3
#define B_AX_XTAL_OV_UNIT_SH 6
#define B_AX_XTAL_OV_UNIT_MSK 0x7
#define B_AX_XTAL_MODE_MANUAL_SH 4
#define B_AX_XTAL_MODE_MANUAL_MSK 0x3
#define B_AX_XTAL_MANU_SEL BIT(3)
#define B_AX_XTAL_MODE BIT(1)
#define B_AX_RESET_N_ BIT(0)

#define R_AX_GPIO0_7_FUNC_SEL 0x02D0
#define B_AX_PINMUX_GPIO7_FUNC_SEL_SH 28
#define B_AX_PINMUX_GPIO7_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO6_FUNC_SEL_SH 24
#define B_AX_PINMUX_GPIO6_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO5_FUNC_SEL_SH 20
#define B_AX_PINMUX_GPIO5_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO4_FUNC_SEL_SH 16
#define B_AX_PINMUX_GPIO4_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO3_FUNC_SEL_SH 12
#define B_AX_PINMUX_GPIO3_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO2_FUNC_SEL_SH 8
#define B_AX_PINMUX_GPIO2_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO1_FUNC_SEL_SH 4
#define B_AX_PINMUX_GPIO1_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO0_FUNC_SEL_SH 0
#define B_AX_PINMUX_GPIO0_FUNC_SEL_MSK 0xf

#define R_AX_GPIO8_15_FUNC_SEL 0x02D4
#define B_AX_PINMUX_GPIO15_FUNC_SEL_SH 28
#define B_AX_PINMUX_GPIO15_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO14_FUNC_SEL_SH 24
#define B_AX_PINMUX_GPIO14_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO13_FUNC_SEL_SH 20
#define B_AX_PINMUX_GPIO13_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO12_FUNC_SEL_SH 16
#define B_AX_PINMUX_GPIO12_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO11_FUNC_SEL_SH 12
#define B_AX_PINMUX_GPIO11_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO10_FUNC_SEL_SH 8
#define B_AX_PINMUX_GPIO10_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO9_FUNC_SEL_SH 4
#define B_AX_PINMUX_GPIO9_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_GPIO8_FUNC_SEL_SH 0
#define B_AX_PINMUX_GPIO8_FUNC_SEL_MSK 0xf

#define R_AX_EECS_EESK_FUNC_SEL 0x02D8
#define B_AX_PINMUX_LED1_FUNC_SEL_SH 8
#define B_AX_PINMUX_LED1_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_EESK_FUNC_SEL_SH 4
#define B_AX_PINMUX_EESK_FUNC_SEL_MSK 0xf
#define B_AX_PINMUX_EECS_FUNC_SEL_SH 0
#define B_AX_PINMUX_EECS_FUNC_SEL_MSK 0xf

#define R_AX_GPIO0_15_EECS_EESK_LED1_PULL_HIGH_EN 0x02E0
#define B_AX_LED1_PULL_HIGH_EN BIT(18)
#define B_AX_EESK_PULL_HIGH_EN BIT(17)
#define B_AX_EECS_PULL_HIGH_EN BIT(16)
#define B_AX_GPIO15_PULL_HIGH_EN BIT(15)
#define B_AX_GPIO14_PULL_HIGH_EN BIT(14)
#define B_AX_GPIO13_PULL_HIGH_EN BIT(13)
#define B_AX_GPIO12_PULL_HIGH_EN BIT(12)
#define B_AX_GPIO11_PULL_HIGH_EN BIT(11)
#define B_AX_GPIO10_PULL_HIGH_EN BIT(10)
#define B_AX_GPIO9_PULL_HIGH_EN BIT(9)
#define B_AX_GPIO8_PULL_HIGH_EN BIT(8)
#define B_AX_GPIO7_PULL_HIGH_EN BIT(7)
#define B_AX_GPIO6_PULL_HIGH_EN BIT(6)
#define B_AX_GPIO5_PULL_HIGH_EN BIT(5)
#define B_AX_GPIO4_PULL_HIGH_EN BIT(4)
#define B_AX_GPIO3_PULL_HIGH_EN BIT(3)
#define B_AX_GPIO2_PULL_HIGH_EN BIT(2)
#define B_AX_GPIO1_PULL_HIGH_EN BIT(1)
#define B_AX_GPIO0_PULL_HIGH_EN BIT(0)

#define R_AX_GPIO0_15_EECS_EESK_LED1_PULL_LOW_EN 0x02E4
#define B_AX_LED1_PULL_LOW_EN BIT(18)
#define B_AX_EESK_PULL_LOW_EN BIT(17)
#define B_AX_EECS_PULL_LOW_EN BIT(16)
#define B_AX_GPIO15_PULL_LOW_EN BIT(15)
#define B_AX_GPIO14_PULL_LOW_EN BIT(14)
#define B_AX_GPIO13_PULL_LOW_EN BIT(13)
#define B_AX_GPIO12_PULL_LOW_EN BIT(12)
#define B_AX_GPIO11_PULL_LOW_EN BIT(11)
#define B_AX_GPIO10_PULL_LOW_EN BIT(10)
#define B_AX_GPIO9_PULL_LOW_EN BIT(9)
#define B_AX_GPIO8_PULL_LOW_EN BIT(8)
#define B_AX_GPIO7_PULL_LOW_EN BIT(7)
#define B_AX_GPIO6_PULL_LOW_EN BIT(6)
#define B_AX_GPIO5_PULL_LOW_EN BIT(5)
#define B_AX_GPIO4_PULL_LOW_EN BIT(4)
#define B_AX_GPIO3_PULL_LOW_EN BIT(3)
#define B_AX_GPIO2_PULL_LOW_EN BIT(2)
#define B_AX_GPIO1_PULL_LOW_EN BIT(1)
#define B_AX_GPIO0_PULL_LOW_EN BIT(0)

#define R_AX_WLRF_CTRL 0x02F0
#define B_AX_AFC_AFEDIG BIT(17)
#define B_AX_WLRF1_CTRL_7 BIT(15)
#define B_AX_WLRF1_CTRL_6 BIT(14)
#define B_AX_WLRF1_CTRL_5 BIT(13)
#define B_AX_WLRF1_CTRL_4 BIT(12)
#define B_AX_WLRF1_CTRL_3 BIT(11)
#define B_AX_WLRF1_CTRL_2 BIT(10)
#define B_AX_WLRF1_CTRL_1 BIT(9)
#define B_AX_WLRF1_CTRL_0 BIT(8)
#define B_AX_WLRF_CTRL_7 BIT(7)
#define B_AX_WLRF_CTRL_6 BIT(6)
#define B_AX_WLRF_CTRL_5 BIT(5)
#define B_AX_WLRF_CTRL_4 BIT(4)
#define B_AX_WLRF_CTRL_3 BIT(3)
#define B_AX_WLRF_CTRL_2 BIT(2)
#define B_AX_WLRF_CTRL_1 BIT(1)
#define B_AX_WLRF_CTRL_0 BIT(0)

#define R_AX_TMETER 0x0390
#define B_AX_TEMP_VALID BIT(31)
#define B_AX_TEMP_VALUE_SH 24
#define B_AX_TEMP_VALUE_MSK 0x3f
#define B_AX_REG_TMETER_TIMER_SH 8
#define B_AX_REG_TMETER_TIMER_MSK 0xfff
#define B_AX_REG_TEMP_DELTA_SH 2
#define B_AX_REG_TEMP_DELTA_MSK 0x3f
#define B_AX_REG_TMETER_EN BIT(0)
#define B_AX_OSC_32K_CLKGEN_0_SH 16
#define B_AX_OSC_32K_CLKGEN_0_MSK 0xffff
#define B_AX_OSC_32K_RES_COMP_SH 4
#define B_AX_OSC_32K_RES_COMP_MSK 0x3
#define B_AX_OSC_32K_OUT_SEL BIT(3)
#define B_AX_ISO_WL_2_OSC_32K BIT(1)
#define B_AX_POW_CKGEN BIT(0)
#define B_AX_CAL_32K_DBGMOD BIT(28)
#define B_AX_CAL32K_WR BIT(23)
#define B_AX_CAL_OSC_XTAL_SEL BIT(22)

#define R_AX_32K_CAL_REG1 0x039C
#define B_AX_OSC32K_RCAL_SEL BIT(31)
#define B_AX_OSC32K_RCAL_RPT_SH 16
#define B_AX_OSC32K_RCAL_RPT_MSK 0x7fff
#define B_AX_OSC32K_RCAL_SH 0
#define B_AX_OSC32K_RCAL_MSK 0x7fff

#define R_AX_IC_PWR_STATE 0x03F0
#define B_AX_WHOLE_SYS_PWR_STE_SH 16
#define B_AX_WHOLE_SYS_PWR_STE_MSK 0x3ff
#define B_AX_WLMAC_PWR_STE_SH 8
#define B_AX_WLMAC_PWR_STE_MSK 0x3
#define B_AX_UART_HCISYS_PWR_STE_SH 6
#define B_AX_UART_HCISYS_PWR_STE_MSK 0x3
#define B_AX_SDIO_HCISYS_PWR_STE_SH 4
#define B_AX_SDIO_HCISYS_PWR_STE_MSK 0x3
#define B_AX_USB_HCISYS_PWR_STE_SH 2
#define B_AX_USB_HCISYS_PWR_STE_MSK 0x3
#define B_AX_PCIE_HCISYS_PWR_STE_SH 0
#define B_AX_PCIE_HCISYS_PWR_STE_MSK 0x3

#define R_AX_SPS_DIG_OFF_CTRL0 0x0400
#define B_AX_SDZN_L_SH 30
#define B_AX_SDZN_L_MSK 0x3
#define B_AX_REG_AUTOZCD_L BIT(29)
#define B_AX_REG_VOFB_SEL BIT(28)
#define B_AX_TBOX_L1_SH 26
#define B_AX_TBOX_L1_MSK 0x3
#define B_AX_ENOCPMUX_L BIT(25)
#define B_AX_FORCE_LDOS BIT(24)
#define B_AX_VO_DISCHG BIT(23)
#define B_AX_LDO_OC_CLAMP BIT(22)
#define B_AX_MINOFF_LIQ BIT(21)
#define B_AX_MINON_LIQ BIT(20)
#define B_AX_POW_AUTO_L BIT(19)
#define B_AX_ARENB_H BIT(18)
#define B_AX_NO_OFFTIME_L BIT(17)
#define B_AX_EN_ON_END_L BIT(16)
#define B_AX_ENCOT_L BIT(15)
#define B_AX_REG_CLK_SEL_SH 13
#define B_AX_REG_CLK_SEL_MSK 0x3
#define B_AX_REG_TYPE_L BIT(12)
#define B_AX_R3_L1_SH 10
#define B_AX_R3_L1_MSK 0x3
#define B_AX_R2_L1_SH 8
#define B_AX_R2_L1_MSK 0x3
#define B_AX_R1_L1_SH 6
#define B_AX_R1_L1_MSK 0x3
#define B_AX_C3_L1_SH 4
#define B_AX_C3_L1_MSK 0x3
#define B_AX_C2_L1_SH 2
#define B_AX_C2_L1_MSK 0x3
#define B_AX_C1_L1_SH 0
#define B_AX_C1_L1_MSK 0x3

#define R_AX_SPS_DIG_OFF_CTRL1 0x0404
#define B_AX_REG_NMOS_OFF_L BIT(5)
#define B_AX_REG_MUX_PI_L BIT(4)
#define B_AX_REG_PWM_CTRL_L BIT(3)
#define B_AX_ENSR_L BIT(2)
#define B_AX_SDZP_L_SH 0
#define B_AX_SDZP_L_MSK 0x3

#define R_AX_SPSLDO_OFF_CTRL0 0x0400
#define B_AX_SDZN_L_SH 30
#define B_AX_SDZN_L_MSK 0x3
#define B_AX_REG_AUTOZCD_L BIT(29)
#define B_AX_REG_VOFB_SEL BIT(28)
#define B_AX_TBOX_L1_SH 26
#define B_AX_TBOX_L1_MSK 0x3
#define B_AX_ENOCPMUX_L BIT(25)
#define B_AX_FORCE_LDOS BIT(24)
#define B_AX_VO_DISCHG BIT(23)
#define B_AX_LDO_OC_CLAMP BIT(22)
#define B_AX_MINOFF_LIQ BIT(21)
#define B_AX_MINON_LIQ BIT(20)
#define B_AX_POW_AUTO_L BIT(19)
#define B_AX_ARENB_H BIT(18)
#define B_AX_NO_OFFTIME_L BIT(17)
#define B_AX_EN_ON_END_L BIT(16)
#define B_AX_ENCOT_L BIT(15)
#define B_AX_REG_CLK_SEL_SH 13
#define B_AX_REG_CLK_SEL_MSK 0x3
#define B_AX_REG_TYPE_L BIT(12)
#define B_AX_R3_L1_SH 10
#define B_AX_R3_L1_MSK 0x3
#define B_AX_R2_L1_SH 8
#define B_AX_R2_L1_MSK 0x3
#define B_AX_R1_L1_SH 6
#define B_AX_R1_L1_MSK 0x3
#define B_AX_C3_L1_SH 4
#define B_AX_C3_L1_MSK 0x3
#define B_AX_C2_L1_SH 2
#define B_AX_C2_L1_MSK 0x3
#define B_AX_C1_L1_SH 0
#define B_AX_C1_L1_MSK 0x3

#define R_AX_SPSLDO_OFF_CTRL1 0x0404
#define B_AX_REG_NMOS_OFF_L BIT(5)
#define B_AX_REG_MUX_PI_L BIT(4)
#define B_AX_REG_PWM_CTRL_L BIT(3)
#define B_AX_ENSR_L BIT(2)
#define B_AX_SDZP_L_SH 0
#define B_AX_SDZP_L_MSK 0x3

#define R_AX_SPSANA_OFF_CTRL0 0x0420
#define B_AX_REG_AUTOZCD_L BIT(29)
#define B_AX_REG_VOFB_SEL BIT(28)
#define B_AX_ENOCPMUX_L BIT(25)
#define B_AX_FORCE_LDOS BIT(24)
#define B_AX_VO_DISCHG BIT(23)
#define B_AX_LDO_OC_CLAMP BIT(22)
#define B_AX_MINOFF_LIQ BIT(21)
#define B_AX_MINON_LIQ BIT(20)
#define B_AX_POW_AUTO_L BIT(19)
#define B_AX_ARENB_H BIT(18)
#define B_AX_NO_OFFTIME_L BIT(17)
#define B_AX_EN_ON_END_L BIT(16)
#define B_AX_ENCOT_L BIT(15)
#define B_AX_REG_TYPE_L BIT(12)

#define R_AX_SPSANA_OFF_CTRL1 0x0424
#define B_AX_REG_NMOS_OFF_L BIT(5)
#define B_AX_REG_MUX_PI_L BIT(4)
#define B_AX_REG_PWM_CTRL_L BIT(3)
#define B_AX_ENSR_L BIT(2)

#define R_AX_AFE_OFF_CTRL0 0x0440
#define B_AX_S1_AD0_LDO2PWRCUT BIT(31)
#define B_AX_S1_AD_SEL_Q_SH 27
#define B_AX_S1_AD_SEL_Q_MSK 0xf
#define B_AX_S1_AD_SEL_I_SH 23
#define B_AX_S1_AD_SEL_I_MSK 0xf
#define B_AX_S0_DA1_LDO_VSEL_SH 21
#define B_AX_S0_DA1_LDO_VSEL_MSK 0x3
#define B_AX_S0_DA1_LDO2PWRCUT BIT(20)
#define B_AX_S0_DA0_LDO_VSEL_SH 18
#define B_AX_S0_DA0_LDO_VSEL_MSK 0x3
#define B_AX_S0_DA0_LDO2PWRCUT BIT(17)
#define B_AX_S0_AD2_LDO_VSEL_SH 15
#define B_AX_S0_AD2_LDO_VSEL_MSK 0x3
#define B_AX_S0_AD2_LDO2PWRCUT BIT(14)
#define B_AX_S0_AD1_LDO_VSEL_SH 12
#define B_AX_S0_AD1_LDO_VSEL_MSK 0x3
#define B_AX_S0_AD1_LDO2PWRCUT BIT(11)
#define B_AX_S0_AD0_LDO_VSEL_SH 9
#define B_AX_S0_AD0_LDO_VSEL_MSK 0x3
#define B_AX_S0_AD0_LDO2PWRCUT BIT(8)
#define B_AX_S0_AD_SEL_Q_SH 4
#define B_AX_S0_AD_SEL_Q_MSK 0xf
#define B_AX_S0_AD_SEL_I_SH 0
#define B_AX_S0_AD_SEL_I_MSK 0xf

#define R_AX_AFE_OFF_CTRL1 0x0444
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_SH 24
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL_MSK 0x3
#define B_AX_S1_DAI2V_LDO2PWRCUT BIT(23)
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL__SH 21
#define B_AX_S0_DAI2V_LDO2PW__LDO_VSEL__MSK 0x3
#define B_AX_S0_DAI2V_LDO2PWRCUT BIT(20)
#define B_AX_S0_RXBB__LDO_VSEL_SH 18
#define B_AX_S0_RXBB__LDO_VSEL_MSK 0x3
#define B_AX_S0_RXBB__LDO2PWRCUT BIT(17)
#define B_AX_S0_RXBB__LDO_VSEL__SH 15
#define B_AX_S0_RXBB__LDO_VSEL__MSK 0x3
#define B_AX_S0_RXBB_LDO2PWRCUT BIT(14)
#define B_AX_S1_DA1_LDO_VSEL_SH 12
#define B_AX_S1_DA1_LDO_VSEL_MSK 0x3
#define B_AX_S1_DA1_LDO2PWRCUT BIT(11)
#define B_AX_S1_DA0_LDO_VSEL_SH 9
#define B_AX_S1_DA0_LDO_VSEL_MSK 0x3
#define B_AX_S1_DA0_LDO2PWRCUT BIT(8)
#define B_AX_S1_AD2_LDO_VSEL_SH 6
#define B_AX_S1_AD2_LDO_VSEL_MSK 0x3
#define B_AX_S1_AD2_LDO2PWRCUT BIT(5)
#define B_AX_S1_AD1_LDO_VSEL_SH 3
#define B_AX_S1_AD1_LDO_VSEL_MSK 0x3
#define B_AX_S1_AD1_LDO2PWRCUT BIT(2)
#define B_AX_S1_AD0_LDO_VSEL_SH 0
#define B_AX_S1_AD0_LDO_VSEL_MSK 0x3

#define R_AX_XTAL_OFF_CTRL0 0x0480
#define B_AX_XTAL_PK_SEL_OFFSET BIT(31)
#define B_AX_XTAL_MANU_PK_SEL_SH 29
#define B_AX_XTAL_MANU_PK_SEL_MSK 0x3
#define B_AX_XTAL_AACK_PK_MANU BIT(28)
#define B_AX_EN_XTAL_AAC_PKDET BIT(27)
#define B_AX_EN_XTAL_AAC_GM BIT(26)
#define B_AX_XTAL_LDO_OPVB_SEL BIT(25)
#define B_AX_XTAL_LDO_NC BIT(24)
#define B_AX_XTAL_LPMODE BIT(23)
#define B_AX_XTAL_DELAY_DIGI BIT(22)
#define B_AX_XTAL_DELAY_USB BIT(21)
#define B_AX_XTAL_DELAY_AFE BIT(20)
#define B_AX_XTAL_DRV_BT_SH 18
#define B_AX_XTAL_DRV_BT_MSK 0x3
#define B_AX_XTAL_DRV_DIGI_SH 16
#define B_AX_XTAL_DRV_DIGI_MSK 0x3
#define B_AX_XTAL_DRV_USB_SH 14
#define B_AX_XTAL_DRV_USB_MSK 0x3
#define B_AX_XTAL_DRV_AFE_SH 12
#define B_AX_XTAL_DRV_AFE_MSK 0x3
#define B_AX_XTAL_DRV_RF2_RELAY_SH 10
#define B_AX_XTAL_DRV_RF2_RELAY_MSK 0x3
#define B_AX_XTAL_DRV_RF2_SH 8
#define B_AX_XTAL_DRV_RF2_MSK 0x3
#define B_AX_XTAL_DRV_RF1_SH 6
#define B_AX_XTAL_DRV_RF1_MSK 0x3
#define B_AX_XTAL_DRV_RF_LATCH BIT(5)
#define B_AX_XTAL_GM_SEP BIT(4)
#define B_AX_XQSEL_RF_AWAKE BIT(3)
#define B_AX_XQSEL_RF_INITIAL BIT(2)
#define B_AX_XQSEL BIT(1)
#define B_AX_GATED_XTAL_OK0 BIT(0)

#define R_AX_XTAL_OFF_CTRL1 0x0484
#define B_AX_XTAL_LDO_VREF_UP_SH 14
#define B_AX_XTAL_LDO_VREF_UP_MSK 0x7
#define B_AX_XTAL_EN_LNBUF BIT(13)
#define B_AX_XTAL__AAC_TIE_MID BIT(12)
#define B_AX_XTAL_AAC_IOFFSET_SH 10
#define B_AX_XTAL_AAC_IOFFSET_MSK 0x3
#define B_AX_XTAL_AAC_CAP_SH 8
#define B_AX_XTAL_AAC_CAP_MSK 0x3
#define B_AX_XTAL_PDSW_SH 6
#define B_AX_XTAL_PDSW_MSK 0x3
#define B_AX_XTAL_LPS_BUF_VB_SH 4
#define B_AX_XTAL_LPS_BUF_VB_MSK 0x3
#define B_AX_XTAL_PDCK_MANU BIT(3)
#define B_AX_XTAL_PDCK_OK_MANU BIT(2)
#define B_AX_EN_XTAL_PDCK_VREF BIT(1)
#define B_AX_XTAL_SEL_PWR BIT(0)

#define R_AX_SYM_ANAPAR_XTAL_AAC_0 0x04A0
#define B_AX_XAAC_LPOW BIT(31)
#define B_AX_AAC_MODE__SH 29
#define B_AX_AAC_MODE__MSK 0x3
#define B_AX_EN_XTAL_AAC_TRIG BIT(28)
#define B_AX_EN_XTAL_AAC BIT(27)
#define B_AX_EN_XTAL_AAC_DIGI BIT(26)
#define B_AX_GM_MANUAL_SH 21
#define B_AX_GM_MANUAL_MSK 0x1f
#define B_AX_GM_STUP_SH 16
#define B_AX_GM_STUP_MSK 0x1f
#define B_AX_XTAL_CK_SET_SH 13
#define B_AX_XTAL_CK_SET_MSK 0x7
#define B_AX_GM_INIT_SH 8
#define B_AX_GM_INIT_MSK 0x1f
#define B_AX_GM_STEP BIT(7)
#define B_AX_XAAC_GM_OFFSET_SH 2
#define B_AX_XAAC_GM_OFFSET_MSK 0x1f
#define B_AX_OFFSET_PLUS BIT(1)
#define B_AX_RESET_N BIT(0)

#define R_AX_SYM_ANAPAR_XTAL_AAC_1 0x04A4
#define B_AX_PK_END_AR_SH 2
#define B_AX_PK_END_AR_MSK 0x3
#define B_AX_PK_START_AR_SH 0
#define B_AX_PK_START_AR_MSK 0x3

#define R_AX_SYM_ANAPAR_XTAL_PDCK 0x04C0
#define B_AX_EN_XTAL_PDCK_DIGI_SH 17
#define B_AX_EN_XTAL_PDCK_DIGI_MSK 0x1f
#define B_AX_PDCK_SEARCH_MODE_SH 15
#define B_AX_PDCK_SEARCH_MODE_MSK 0x3
#define B_AX_PDCK_WAIT_CYC_SH 10
#define B_AX_PDCK_WAIT_CYC_MSK 0x1f
#define B_AX_VREF_MANUAL_SH 5
#define B_AX_VREF_MANUAL_MSK 0x1f
#define B_AX_VREF_INIT_SH 3
#define B_AX_VREF_INIT_MSK 0x3
#define B_AX_XTAL_PDCK_UNIT BIT(2)
#define B_AX_XPDCK_VREF_SEL BIT(1)
#define B_AX_PDCK_LPOW BIT(0)

//
// AON_C
//

#define R_AX_SEC_CTRL 0x0C00
#define B_AX_SEC_IDMEM_SIZE_CONFIG_SH 16
#define B_AX_SEC_IDMEM_SIZE_CONFIG_MSK 0x3
#define B_AX_SEC_BT_SEC1_DIS BIT(15)
#define B_AX_SEC_BT_SEC0_DIS BIT(14)
#define B_AX_SEC_UART_RX_EN BIT(4)
#define B_AX_SEC_UART_TX_EN BIT(3)
#define B_AX_SEC_JTAG_EN BIT(2)
#define B_AX_SEC_SIC_EN BIT(1)
#define B_AX_SEC_SEC_DIS BIT(0)

#define R_AX_FILTER_MODEL_ADDR 0x0C04
#define B_AX_SEC_FILTER_MODEL_ADDR_SH 0
#define B_AX_SEC_FILTER_MODEL_ADDR_MSK 0xffffffffL

#define R_AX_EFUSE_CTRL_S 0x0C30
#define B_AX_EF_MODE_SEL_S_SH 30
#define B_AX_EF_MODE_SEL_S_MSK 0x3
#define B_AX_EF_RDY_S BIT(29)
#define B_AX_EF_ADDR_S_SH 16
#define B_AX_EF_ADDR_S_MSK 0x7ff
#define B_AX_EF_DATA_S_SH 0
#define B_AX_EF_DATA_S_MSK 0xffff

#define R_AX_EFUSE_TEST_S 0x0C34
#define B_AX_EF_CRES_SEL_S BIT(31)
#define B_AX_EF_SCAN_SADR_S_SH 19
#define B_AX_EF_SCAN_SADR_S_MSK 0x7ff
#define B_AX_EF_SCAN_EADR_S_SH 8
#define B_AX_EF_SCAN_EADR_S_MSK 0x7ff
#define B_AX_EF_SCAN_TRPT_S BIT(7)
#define B_AX_EF_SCAN_FTHR_S_SH 0
#define B_AX_EF_SCAN_FTHR_S_MSK 0x7f

//
// WL_AX_Reg_AXIDMA.xls
//

//
// AXIDMA_Reg_Spec
//

#define R_PL_AXIDMA_INIT_CFG1 0x0000
#define B_PL_AXIDMA__MASTER_STOP BIT(20)
#define B_PL_AXIDMA_RESET_KEEP_REG BIT(19)
#define B_PL_AXIDMA_RX_EN BIT(13)
#define B_PL_AXIDMA_TX_EN BIT(11)

#define R_PL_AXIDMA_DMA_STOP 0x0004
#define B_PL_AXIDMA_WPDMA_STOP BIT(12)
#define B_PL_AXIDMA_CH3_TX_STOP BIT(11)
#define B_PL_AXIDMA_CH2_TX_STOP BIT(10)
#define B_PL_AXIDMA_CH1_TX_STOP BIT(9)
#define B_PL_AXIDMA_CH0_TX_STOP BIT(8)

#define R_PL_AXIDMA_INIT_CFG2 0x0008
#define B_PL_AXIDMA_WD_ITVL_ACT_SH 24
#define B_PL_AXIDMA_WD_ITVL_ACT_MSK 0xff
#define B_PL_AXIDMA_WD_ITVL_IDLE_SH 16
#define B_PL_AXIDMA_WD_ITVL_IDLE_MSK 0xff

#define R_PL_AXIDMA_INFO 0x0100
#define B_PL_AXIDMA_MASTER_IDLE BIT(16)
#define B_PL_AXIDMA_RX_IDLE BIT(1)
#define B_PL_AXIDMA_TX_IDLE BIT(0)

#define R_PL_AXIDMA_BUSY 0x0104
#define B_PL_AXIDMA_WPDMA_BUSY BIT(12)
#define B_PL_AXIDMA_CH3_TX_BUSY BIT(11)
#define B_PL_AXIDMA_CH2_TX_BUSY BIT(10)
#define B_PL_AXIDMA_CH1_TX_BUSY BIT(9)
#define B_PL_AXIDMA_CH0_TX_BUSY BIT(8)
#define B_PL_AXIDMA_CH5_RX_BUSY BIT(5)
#define B_PL_AXIDMA_CH4_RX_BUSY BIT(4)
#define B_PL_AXIDMA_CH3_RX_BUSY BIT(3)
#define B_PL_AXIDMA_CH2_RX_BUSY BIT(2)
#define B_PL_AXIDMA_CH1_RX_BUSY BIT(1)
#define B_PL_AXIDMA_CH0_RX_BUSY BIT(0)

#define R_PL_AXIDMA_INT_MIT_TX 0x0200
#define B_PL_AXIDMA_TXMIT_CH3_SEL BIT(22)
#define B_PL_AXIDMA_TXMIT_CH2_SEL BIT(21)
#define B_PL_AXIDMA_TXMIT_CH1_SEL BIT(20)
#define B_PL_AXIDMA_TXMIT_CH0_SEL BIT(19)
#define B_PL_AXIDMA_TXTIMER_UNIT_SH 16
#define B_PL_AXIDMA_TXTIMER_UNIT_MSK 0x3
#define B_PL_AXIDMA_TXCOUNTER_MATCH_SH 8
#define B_PL_AXIDMA_TXCOUNTER_MATCH_MSK 0xff
#define B_PL_AXIDMA_TXTIMER_MATCH_SH 0
#define B_PL_AXIDMA_TXTIMER_MATCH_MSK 0xff

#define R_PL_AXIDMA_INT_MIT_RX 0x0204
#define B_PL_AXIDMA_RXMIT_CH5_SEL BIT(24)
#define B_PL_AXIDMA_RXMIT_CH4_SEL BIT(23)
#define B_PL_AXIDMA_RXMIT_CH3_SEL BIT(22)
#define B_PL_AXIDMA_RXMIT_CH2_SEL BIT(21)
#define B_PL_AXIDMA_RXMIT_CH1_SEL BIT(20)
#define B_PL_AXIDMA_RXMIT_CH0_SEL BIT(19)
#define B_PL_AXIDMA_RXTIMER_UNIT_SH 16
#define B_PL_AXIDMA_RXTIMER_UNIT_MSK 0x3
#define B_PL_AXIDMA_RXCOUNTER_MATCH_SH 8
#define B_PL_AXIDMA_RXCOUNTER_MATCH_MSK 0xff
#define B_PL_AXIDMA_RXTIMER_MATCH_SH 0
#define B_PL_AXIDMA_RXTIMER_MATCH_MSK 0xff

#define R_PL_AXIDMA_CH0_RXBD_NUM 0x0300
#define B_PL_AXIDMA_CH0_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH0_RXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH1_RXBD_NUM 0x0302
#define B_PL_AXIDMA_CH1_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH1_RXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH2_RXBD_NUM 0x0304
#define B_PL_AXIDMA_CH2_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH2_RXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH3_RXBD_NUM 0x0306
#define B_PL_AXIDMA_CH3_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH3_RXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH4_RXBD_NUM 0x0308
#define B_PL_AXIDMA_CH4_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH4_RXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH5_RXBD_NUM 0x030A
#define B_PL_AXIDMA_CH5_RXBD_NUM_SH 0
#define B_PL_AXIDMA_CH5_RXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH0_TXBD_NUM 0x0320
#define B_PL_AXIDMA_CH0_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH0_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH0_TXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH1_TXBD_NUM 0x0322
#define B_PL_AXIDMA_CH1_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH1_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH1_TXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH2_TXBD_NUM 0x0324
#define B_PL_AXIDMA_CH2_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH2_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH2_TXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH3_TXBD_NUM 0x0326
#define B_PL_AXIDMA_CH3_TXBD_FLAG BIT(14)
#define B_PL_AXIDMA_CH3_TXBD_NUM_SH 0
#define B_PL_AXIDMA_CH3_TXBD_NUM_MSK 0xfff

#define R_PL_AXIDMA_CH0_RXBD_IDX 0x0400
#define B_PL_AXIDMA_CH0_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH0_RX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH0_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH0_RX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH1_RXBD_IDX 0x0404
#define B_PL_AXIDMA_CH1_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH1_RX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH1_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH1_RX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH2_RXBD_IDX 0x0408
#define B_PL_AXIDMA_CH2_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH2_RX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH2_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH2_RX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH3_RXBD_IDX 0x040C
#define B_PL_AXIDMA_CH3_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH3_RX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH3_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH3_RX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH4_RXBD_IDX 0x0410
#define B_PL_AXIDMA_CH4_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH4_RX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH4_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH4_RX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH5_RXBD_IDX 0x0414
#define B_PL_AXIDMA_CH5_RX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH5_RX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH5_RX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH5_RX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH0_TXBD_IDX 0x0420
#define B_PL_AXIDMA_CH0_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH0_TX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH0_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH0_TX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH1_TXBD_IDX 0x0424
#define B_PL_AXIDMA_CH1_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH1_TX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH1_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH1_TX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH2_TXBD_IDX 0x0428
#define B_PL_AXIDMA_CH2_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH2_TX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH2_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH2_TX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_CH3_TXBD_IDX 0x042C
#define B_PL_AXIDMA_CH3_TX_HW_IDX_SH 16
#define B_PL_AXIDMA_CH3_TX_HW_IDX_MSK 0xfff
#define B_PL_AXIDMA_CH3_TX_HOST_IDX_SH 0
#define B_PL_AXIDMA_CH3_TX_HOST_IDX_MSK 0xfff

#define R_PL_AXIDMA_TXBD_RWPTR_CLR 0x0430
#define B_PL_AXIDMA_CLR_CH3_TX_IDX BIT(3)
#define B_PL_AXIDMA_CLR_CH2_TX_IDX BIT(2)
#define B_PL_AXIDMA_CLR_CH1_TX_IDX BIT(1)
#define B_PL_AXIDMA_CLR_CH0_TX_IDX BIT(0)

#define R_PL_AXIDMA_RXBD_RWPTR_CLR 0x0434
#define B_PL_AXIDMA_CLR_CH5_RX_IDX BIT(5)
#define B_PL_AXIDMA_CLR_CH4_RX_IDX BIT(4)
#define B_PL_AXIDMA_CLR_CH3_RX_IDX BIT(3)
#define B_PL_AXIDMA_CLR_CH2_RX_IDX BIT(2)
#define B_PL_AXIDMA_CLR_CH1_RX_IDX BIT(1)
#define B_PL_AXIDMA_CLR_CH0_RX_IDX BIT(0)

#define R_PL_AXIDMA_DBG_CTRL 0x0500
#define B_PL_AXIDMA_DBG_SEL_SH 16
#define B_PL_AXIDMA_DBG_SEL_MSK 0x1ff
#define B_PL_AXIDMA_SEC_ACCESS BIT(2)
#define B_PL_AXIDMA_EN_STUCK_DBG BIT(0)

#define R_PL_AXIDMA_DBG_ERR_FLAG 0x0504
#define B_PL_AXIDMA_CH1_RX_FULL BIT(29)
#define B_PL_AXIDMA_CH0_RX_FULL BIT(28)
#define B_PL_AXIDMA_RX_STUCK BIT(22)
#define B_PL_AXIDMA_TX_STUCK BIT(21)
#define B_PL_AXIDMA_DBG_TXERR BIT(16)
#define B_PL_AXIDMA_CH5_RX_FULL BIT(5)
#define B_PL_AXIDMA_CH4_RX_FULL BIT(4)
#define B_PL_AXIDMA_CH3_RX_FULL BIT(3)
#define B_PL_AXIDMA_CH2_RX_FULL BIT(2)
#define B_PL_AXIDMA_TXBD_LEN0 BIT(1)
#define B_PL_AXIDMA_TXBD_4KBOUD_LENERR BIT(0)

#define R_PL_AXIDMA_CH0_RXBD_DESA_L 0x0600
#define B_PL_AXIDMA_CH0_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH0_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH1_RXBD_DESA_L 0x0608
#define B_PL_AXIDMA_CH1_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH1_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH2_RXBD_DESA_L 0x0610
#define B_PL_AXIDMA_CH2_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH2_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH3_RXBD_DESA_L 0x0618
#define B_PL_AXIDMA_CH3_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH3_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH4_RXBD_DESA_L 0x0620
#define B_PL_AXIDMA_CH4_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH4_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH5_RXBD_DESA_L 0x0628
#define B_PL_AXIDMA_CH5_RXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH5_RXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH0_TXBD_DESA_L 0x0640
#define B_PL_AXIDMA_CH0_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH0_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH1_TXBD_DESA_L 0x0648
#define B_PL_AXIDMA_CH1_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH1_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH2_TXBD_DESA_L 0x0650
#define B_PL_AXIDMA_CH2_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH2_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_CH3_TXBD_DESA_L 0x0658
#define B_PL_AXIDMA_CH3_TXBD_DESA_L_SH 0
#define B_PL_AXIDMA_CH3_TXBD_DESA_L_MSK 0xffffffffL

#define R_PL_AXIDMA_FC_CTRL1 0x0700
#define B_PL_AXIDMA_FC_MODE BIT(2)
#define B_PL_AXIDMA_SET1_FC_EN BIT(1)
#define B_PL_AXIDMA_SET0_FC_EN BIT(0)

#define R_PL_AXIDMA_FC_CTRL2 0x0704
#define B_PL_AXIDMA_SET1_PREC_PAGE_SH 16
#define B_PL_AXIDMA_SET1_PREC_PAGE_MSK 0x1ff
#define B_PL_AXIDMA_SET0_PREC_PAGE_SH 0
#define B_PL_AXIDMA_SET0_PREC_PAGE_MSK 0x1ff

#define R_PL_AXIDMA_CH1_PAGE_CTRL 0x0710
#define B_PL_AXIDMA_CH1_GRP BIT(31)
#define B_PL_AXIDMA_CH1_MAX_PG_SH 16
#define B_PL_AXIDMA_CH1_MAX_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH1_MIN_PG_SH 0
#define B_PL_AXIDMA_CH1_MIN_PG_MSK 0x1fff

#define R_PL_AXIDMA_CH3_PAGE_CTRL 0x0714
#define B_PL_AXIDMA_CH3_GRP BIT(31)
#define B_PL_AXIDMA_CH3_MAX_PG_SH 16
#define B_PL_AXIDMA_CH3_MAX_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH3_MIN_PG_SH 0
#define B_PL_AXIDMA_CH3_MIN_PG_MSK 0x1fff

#define R_PL_AXIDMA_CH1_PAGE_INFO 0x0720
#define B_PL_AXIDMA_CH1_AVAIL_PG_SH 16
#define B_PL_AXIDMA_CH1_AVAIL_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH1_USE_PG_SH 0
#define B_PL_AXIDMA_CH1_USE_PG_MSK 0x1fff

#define R_PL_AXIDMA_CH3_PAGE_INFO 0x0724
#define B_PL_AXIDMA_CH3_AVAIL_PG_SH 16
#define B_PL_AXIDMA_CH3_AVAIL_PG_MSK 0x1fff
#define B_PL_AXIDMA_CH3_USE_PG_SH 0
#define B_PL_AXIDMA_CH3_USE_PG_MSK 0x1fff

#define R_PL_AXIDMA_SET0_PUB_PAGE_INFO 0x0730
#define B_PL_AXIDMA_SET0_AVAL_PUBPG_SH 0
#define B_PL_AXIDMA_SET0_AVAL_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_CTRL1 0x0740
#define B_PL_AXIDMA_SET1_G1_MAX_PUBPG_SH 16
#define B_PL_AXIDMA_SET1_G1_MAX_PUBPG_MSK 0x1fff
#define B_PL_AXIDMA_SET1_G0_MAX_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_G0_MAX_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_CTRL2 0x0744
#define B_PL_AXIDMA_SET1_ALL_MAX_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_ALL_MAX_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_INFO1 0x0748
#define B_PL_AXIDMA_SET1_G1_USE_PUBPG_SH 16
#define B_PL_AXIDMA_SET1_G1_USE_PUBPG_MSK 0x1fff
#define B_PL_AXIDMA_SET1_G0_USE_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_G0_USE_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_INFO2 0x074C
#define B_PL_AXIDMA_SET1_AVAL_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_AVAL_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_SET1_PUB_PAGE_INFO3 0x0750
#define B_PL_AXIDMA_SET1_G1_AVAL_PUBPG_SH 16
#define B_PL_AXIDMA_SET1_G1_AVAL_PUBPG_MSK 0x1fff
#define B_PL_AXIDMA_SET1_G0_AVAL_PUBPG_SH 0
#define B_PL_AXIDMA_SET1_G0_AVAL_PUBPG_MSK 0x1fff

#define R_PL_AXIDMA_WP_PAGE_CTRL1 0x0760
#define B_PL_AXIDMA_PREC_PAGE_WP_SH 16
#define B_PL_AXIDMA_PREC_PAGE_WP_MSK 0x1ff

#define R_PL_AXIDMA_WP_PAGE_CTRL2 0x0764
#define B_PL_AXIDMA_WP_THRD_SH 0
#define B_PL_AXIDMA_WP_THRD_MSK 0x1fff

#define R_PL_AXIDMA_WP_PAGE_INFO 0x0768
#define B_PL_AXIDMA_WP_AVAL_PG_SH 16
#define B_PL_AXIDMA_WP_AVAL_PG_MSK 0x1fff

#define R_PL_AXIDMA_FC_ERR_FLAG 0x0770
#define B_PL_AXIDMA_SET1_PUB_USE_PG_OFW BIT(24)
#define B_PL_AXIDMA_SET1_PUB_USE_PG_UFW BIT(23)
#define B_PL_AXIDMA_SET1_USE_PG_OFW BIT(22)
#define B_PL_AXIDMA_SET1_USE_PG_UFW BIT(21)
#define B_PL_AXIDMA_SET1_AVAL_PG_OFW BIT(20)
#define B_PL_AXIDMA_SET1_AVAL_PG_UFW BIT(19)
#define B_PL_AXIDMA_SET1_WP_REQ_PG_ERR BIT(18)
#define B_PL_AXIDMA_SET1_REQ_PG_ERR BIT(16)
#define B_PL_AXIDMA_SET0_REQ_PG_ERR BIT(0)

#define R_PL_AXIDMA_FWIMR0 0x0900
#define B_PL_AXIDMA_CH5_RX_RDU_MSK BIT(21)
#define B_PL_AXIDMA_CH4_RX_RDU_MSK BIT(20)
#define B_PL_AXIDMA_CH3_RX_RDU_MSK BIT(19)
#define B_PL_AXIDMA_CH2_RX_RDU_MSK BIT(18)
#define B_PL_AXIDMA_CH1_RX_RDU_MSK BIT(17)
#define B_PL_AXIDMA_CH0_RX_RDU_MSK BIT(16)
#define B_PL_AXIDMA_CH5_RX_DERR_MSK BIT(13)
#define B_PL_AXIDMA_CH4_RX_DERR_MSK BIT(12)
#define B_PL_AXIDMA_CH3_RX_DERR_MSK BIT(11)
#define B_PL_AXIDMA_CH2_RX_DERR_MSK BIT(10)
#define B_PL_AXIDMA_CH1_RX_DERR_MSK BIT(9)
#define B_PL_AXIDMA_CH0_RX_DERR_MSK BIT(8)
#define B_PL_AXIDMA_CH5_RX_DOK_MSK BIT(5)
#define B_PL_AXIDMA_CH4_RX_DOK_MSK BIT(4)
#define B_PL_AXIDMA_CH3_RX_DOK_MSK BIT(3)
#define B_PL_AXIDMA_CH2_RX_DOK_MSK BIT(2)
#define B_PL_AXIDMA_CH1_RX_DOK_MSK BIT(1)
#define B_PL_AXIDMA_CH0_RX_DOK_MSK BIT(0)

#define R_PL_AXIDMA_FWIMR1 0x0904
#define B_PL_AXIDMA_CH3_TX_DERR_MSK BIT(11)
#define B_PL_AXIDMA_CH2_TX_DERR_MSK BIT(10)
#define B_PL_AXIDMA_CH1_TX_DERR_MSK BIT(9)
#define B_PL_AXIDMA_CH0_TX_DERR_MSK BIT(8)
#define B_PL_AXIDMA_CH3_TX_DOK_MSK BIT(3)
#define B_PL_AXIDMA_CH2_TX_DOK_MSK BIT(2)
#define B_PL_AXIDMA_CH1_TX_DOK_MSK BIT(1)
#define B_PL_AXIDMA_CH0_TX_DOK_MSK BIT(0)

#define R_PL_AXIDMA_FWISR0 0x0908
#define B_PL_AXIDMA_CH5_RX_RDU BIT(21)
#define B_PL_AXIDMA_CH4_RX_RDU BIT(20)
#define B_PL_AXIDMA_CH3_RX_RDU BIT(19)
#define B_PL_AXIDMA_CH2_RX_RDU BIT(18)
#define B_PL_AXIDMA_CH1_RX_RDU BIT(17)
#define B_PL_AXIDMA_CH0_RX_RDU BIT(16)
#define B_PL_AXIDMA_CH5_RX_DERR BIT(13)
#define B_PL_AXIDMA_CH4_RX_DERR BIT(12)
#define B_PL_AXIDMA_CH3_RX_DERR BIT(11)
#define B_PL_AXIDMA_CH2_RX_DERR BIT(10)
#define B_PL_AXIDMA_CH1_RX_DERR BIT(9)
#define B_PL_AXIDMA_CH0_RX_DERR BIT(8)
#define B_PL_AXIDMA_CH5_RX_DOK BIT(5)
#define B_PL_AXIDMA_CH4_RX_DOK BIT(4)
#define B_PL_AXIDMA_CH3_RX_DOK BIT(3)
#define B_PL_AXIDMA_CH2_RX_DOK BIT(2)
#define B_PL_AXIDMA_CH1_RX_DOK BIT(1)
#define B_PL_AXIDMA_CH0_RX_DOK BIT(0)

#define R_PL_AXIDMA_FWISR1 0x090C
#define B_PL_AXIDMA_CH3_TX_DOK BIT(3)
#define B_PL_AXIDMA_CH2_TX_DOK BIT(2)
#define B_PL_AXIDMA_CH1_TX_DOK BIT(1)
#define B_PL_AXIDMA_CH0_TX_DOK BIT(0)

//
// WL_AX_Reg_CMAC_0.xls
//

//
// COMMON
//

#define R_AX_CMAC_FUNC_EN 0xC000
#define R_AX_CMAC_FUNC_EN_C1 0xE000
#define B_AX_CMAC_CRPRT BIT(31)
#define B_AX_CMAC_EN BIT(30)
#define B_AX_CMAC_TXEN BIT(29)
#define B_AX_CMAC_RXEN BIT(28)
#define B_AX_FORCE_CMACREG_GCKEN BIT(15)
#define B_AX_PHYINTF_EN BIT(5)
#define B_AX_CMAC_DMA_EN BIT(4)
#define B_AX_PTCLTOP_EN BIT(3)
#define B_AX_SCHEDULER_EN BIT(2)
#define B_AX_TMAC_EN BIT(1)
#define B_AX_RMAC_EN BIT(0)

#define R_AX_CK_EN 0xC004
#define R_AX_CK_EN_C1 0xE004
#define B_AX_CMAC_CKEN BIT(30)
#define B_AX_PHYINTF_CKEN BIT(5)
#define B_AX_CMAC_DMA_CKEN BIT(4)
#define B_AX_PTCLTOP_CKEN BIT(3)
#define B_AX_SCHEDULER_CKEN BIT(2)
#define B_AX_TMAC_CKEN BIT(1)
#define B_AX_RMAC_CKEN BIT(0)

#define R_AX_WMAC_RFMOD 0xC010
#define R_AX_WMAC_RFMOD_C1 0xE010
#define B_AX_WMAC_RFMOD_SH 0
#define B_AX_WMAC_RFMOD_MSK 0x3

#define R_AX_R_BIST_CTRL 0xC040
#define R_AX_R_BIST_CTRL_C1 0xE040
#define B_AX_R_BIST_DYN_READ_EN BIT(14)
#define B_AX_R_BIST_LOOP_MODE BIT(13)
#define B_AX_R_BIST_LVDRF_CLKDIS BIT(12)
#define B_AX_R_BIST_DRF_RESUME BIT(3)
#define B_AX_R_BIST_DRF_MODE BIT(2)
#define B_AX_R_BIST_MODE BIT(1)
#define B_AX_R_BIST_RSTN_ALL BIT(0)

#define R_AX_SYM_MEM_RM_CTRL 0xC044
#define R_AX_SYM_MEM_RM_CTRL_C1 0xE044
#define B_AX_R_SYM_MEM_RMV_FABDBG_SH 30
#define B_AX_R_SYM_MEM_RMV_FABDBG_MSK 0x3
#define B_AX_R_SYM_MEM_RMV_SIGN BIT(29)
#define B_AX_R_SYM_MEM_RMV_2PRF BIT(27)
#define B_AX_R_SYM_MEM_RMV_1PRF BIT(26)
#define B_AX_R_SYM_MEM_RMV_1PSR BIT(25)
#define B_AX_R_SYM_MEM_RMV_ROM BIT(24)
#define B_AX_R_SYM_MEM_RME_WL_SH 4
#define B_AX_R_SYM_MEM_RME_WL_MSK 0xf

#define R_AX_PARAM_CMAC_BIST_RSTN 0xC050
#define R_AX_PARAM_CMAC_BIST_RSTN_C1 0xE050
#define B_AX_R_BIST_RST_N_CMAC_SH 0
#define B_AX_R_BIST_RST_N_CMAC_MSK 0x1ff

#define R_AX_PARAM_CMAC_BIST_DONE 0xC054
#define R_AX_PARAM_CMAC_BIST_DONE_C1 0xE054
#define B_AX_BIST_DONE_CMAC_SH 0
#define B_AX_BIST_DONE_CMAC_MSK 0x1ff

#define R_AX_PARAM_CMAC_BIST_FAIL 0xC058
#define R_AX_PARAM_CMAC_BIST_FAIL_C1 0xE058
#define B_AX_BIST_FAIL_CMAC_SH 0
#define B_AX_BIST_FAIL_CMAC_MSK 0x1ff

#define R_AX_PARAM_CMAC_DRF_PAUSE 0xC05C
#define R_AX_PARAM_CMAC_DRF_PAUSE_C1 0xE05C
#define B_AX_BIST_DRF_PAUSE_CMAC_SH 0
#define B_AX_BIST_DRF_PAUSE_CMAC_MSK 0x1ff

#define R_AX_PARAM_CMAC_BIST_RSTN_SHARE 0xC060
#define R_AX_PARAM_CMAC_BIST_RSTN_SHARE_C1 0xE060
#define B_AX_R_BIST_RST_N_CMAC_SHARE_SH 0
#define B_AX_R_BIST_RST_N_CMAC_SHARE_MSK 0x7

#define R_AX_PARAM_CMAC_BIST_DONE_SHARE 0xC064
#define R_AX_PARAM_CMAC_BIST_DONE_SHARE_C1 0xE064
#define B_AX_BIST_DONE_CMAC_SHARE_SH 0
#define B_AX_BIST_DONE_CMAC_SHARE_MSK 0x7

#define R_AX_PARAM_CMAC_BIST_FAIL_SHARE 0xC068
#define R_AX_PARAM_CMAC_BIST_FAIL_SHARE_C1 0xE068
#define B_AX_BIST_FAIL_CMAC_SHARE_SH 0
#define B_AX_BIST_FAIL_CMAC_SHARE_MSK 0x7

#define R_AX_PARAM_CMAC_DRF_PAUSE_SHARE 0xC06C
#define R_AX_PARAM_CMAC_DRF_PAUSE_SHARE_C1 0xE06C
#define B_AX_BIST_DRF_PAUSE_CMAC_SHARE_SH 0
#define B_AX_BIST_DRF_PAUSE_CMAC_SHARE_MSK 0x7

#define R_AX_GID_POSITION0 0xC070
#define R_AX_GID_POSITION0_C1 0xE070
#define B_AX_GID_15_POSITION_SH 30
#define B_AX_GID_15_POSITION_MSK 0x3
#define B_AX_GID_14_POSITION_SH 28
#define B_AX_GID_14_POSITION_MSK 0x3
#define B_AX_GID_13_POSITION_SH 26
#define B_AX_GID_13_POSITION_MSK 0x3
#define B_AX_GID_12_POSITION_SH 24
#define B_AX_GID_12_POSITION_MSK 0x3
#define B_AX_GID_11_POSITION_SH 22
#define B_AX_GID_11_POSITION_MSK 0x3
#define B_AX_GID_10_POSITION_SH 20
#define B_AX_GID_10_POSITION_MSK 0x3
#define B_AX_GID_9_POSITION_SH 18
#define B_AX_GID_9_POSITION_MSK 0x3
#define B_AX_GID_8_POSITION_SH 16
#define B_AX_GID_8_POSITION_MSK 0x3
#define B_AX_GID_7_POSITION_SH 14
#define B_AX_GID_7_POSITION_MSK 0x3
#define B_AX_GID_6_POSITION_SH 12
#define B_AX_GID_6_POSITION_MSK 0x3
#define B_AX_GID_5_POSITION_SH 10
#define B_AX_GID_5_POSITION_MSK 0x3
#define B_AX_GID_4_POSITION_SH 8
#define B_AX_GID_4_POSITION_MSK 0x3
#define B_AX_GID_3_POSITION_SH 6
#define B_AX_GID_3_POSITION_MSK 0x3
#define B_AX_GID_2_POSITION_SH 4
#define B_AX_GID_2_POSITION_MSK 0x3
#define B_AX_GID_1_POSITION_SH 2
#define B_AX_GID_1_POSITION_MSK 0x3
#define B_AX_GID_0_POSITION_SH 0
#define B_AX_GID_0_POSITION_MSK 0x3

#define R_AX_GID_POSITION1 0xC074
#define R_AX_GID_POSITION1_C1 0xE074
#define B_AX_GID_31_POSITION_SH 30
#define B_AX_GID_31_POSITION_MSK 0x3
#define B_AX_GID_30_POSITION_SH 28
#define B_AX_GID_30_POSITION_MSK 0x3
#define B_AX_GID_29_POSITION_SH 26
#define B_AX_GID_29_POSITION_MSK 0x3
#define B_AX_GID_28_POSITION_SH 24
#define B_AX_GID_28_POSITION_MSK 0x3
#define B_AX_GID_27_POSITION_SH 22
#define B_AX_GID_27_POSITION_MSK 0x3
#define B_AX_GID_26_POSITION_SH 20
#define B_AX_GID_26_POSITION_MSK 0x3
#define B_AX_GID_25_POSITION_SH 18
#define B_AX_GID_25_POSITION_MSK 0x3
#define B_AX_GID_24_POSITION_SH 16
#define B_AX_GID_24_POSITION_MSK 0x3
#define B_AX_GID_23_POSITION_SH 14
#define B_AX_GID_23_POSITION_MSK 0x3
#define B_AX_GID_22_POSITION_SH 12
#define B_AX_GID_22_POSITION_MSK 0x3
#define B_AX_GID_21_POSITION_SH 10
#define B_AX_GID_21_POSITION_MSK 0x3
#define B_AX_GID_20_POSITION_SH 8
#define B_AX_GID_20_POSITION_MSK 0x3
#define B_AX_GID_19_POSITION_SH 6
#define B_AX_GID_19_POSITION_MSK 0x3
#define B_AX_GID_18_POSITION_SH 4
#define B_AX_GID_18_POSITION_MSK 0x3
#define B_AX_GID_17_POSITION_SH 2
#define B_AX_GID_17_POSITION_MSK 0x3
#define B_AX_GID_16_POSITION_SH 0
#define B_AX_GID_16_POSITION_MSK 0x3

#define R_AX_GID_POSITION2 0xC078
#define R_AX_GID_POSITION2_C1 0xE078
#define B_AX_GID_47_POSITION_SH 30
#define B_AX_GID_47_POSITION_MSK 0x3
#define B_AX_GID_46_POSITION_SH 28
#define B_AX_GID_46_POSITION_MSK 0x3
#define B_AX_GID_45_POSITION_SH 26
#define B_AX_GID_45_POSITION_MSK 0x3
#define B_AX_GID_44_POSITION_SH 24
#define B_AX_GID_44_POSITION_MSK 0x3
#define B_AX_GID_43_POSITION_SH 22
#define B_AX_GID_43_POSITION_MSK 0x3
#define B_AX_GID_42_POSITION_SH 20
#define B_AX_GID_42_POSITION_MSK 0x3
#define B_AX_GID_41_POSITION_SH 18
#define B_AX_GID_41_POSITION_MSK 0x3
#define B_AX_GID_40_POSITION_SH 16
#define B_AX_GID_40_POSITION_MSK 0x3
#define B_AX_GID_39_POSITION_SH 14
#define B_AX_GID_39_POSITION_MSK 0x3
#define B_AX_GID_38_POSITION_SH 12
#define B_AX_GID_38_POSITION_MSK 0x3
#define B_AX_GID_37_POSITION_SH 10
#define B_AX_GID_37_POSITION_MSK 0x3
#define B_AX_GID_36_POSITION_SH 8
#define B_AX_GID_36_POSITION_MSK 0x3
#define B_AX_GID_35_POSITION_SH 6
#define B_AX_GID_35_POSITION_MSK 0x3
#define B_AX_GID_34_POSITION_SH 4
#define B_AX_GID_34_POSITION_MSK 0x3
#define B_AX_GID_33_POSITION_SH 2
#define B_AX_GID_33_POSITION_MSK 0x3
#define B_AX_GID_32_POSITION_SH 0
#define B_AX_GID_32_POSITION_MSK 0x3

#define R_AX_GID_POSITION3 0xC07C
#define R_AX_GID_POSITION3_C1 0xE07C
#define B_AX_GID_63_POSITION_SH 30
#define B_AX_GID_63_POSITION_MSK 0x3
#define B_AX_GID_62_POSITION_SH 28
#define B_AX_GID_62_POSITION_MSK 0x3
#define B_AX_GID_61_POSITION_SH 26
#define B_AX_GID_61_POSITION_MSK 0x3
#define B_AX_GID_60_POSITION_SH 24
#define B_AX_GID_60_POSITION_MSK 0x3
#define B_AX_GID_59_POSITION_SH 22
#define B_AX_GID_59_POSITION_MSK 0x3
#define B_AX_GID_58_POSITION_SH 20
#define B_AX_GID_58_POSITION_MSK 0x3
#define B_AX_GID_57_POSITION_SH 18
#define B_AX_GID_57_POSITION_MSK 0x3
#define B_AX_GID_56_POSITION_SH 16
#define B_AX_GID_56_POSITION_MSK 0x3
#define B_AX_GID_55_POSITION_SH 14
#define B_AX_GID_55_POSITION_MSK 0x3
#define B_AX_GID_54_POSITION_SH 12
#define B_AX_GID_54_POSITION_MSK 0x3
#define B_AX_GID_53_POSITION_SH 10
#define B_AX_GID_53_POSITION_MSK 0x3
#define B_AX_GID_52_POSITION_SH 8
#define B_AX_GID_52_POSITION_MSK 0x3
#define B_AX_GID_51_POSITION_SH 6
#define B_AX_GID_51_POSITION_MSK 0x3
#define B_AX_GID_50_POSITION_SH 4
#define B_AX_GID_50_POSITION_MSK 0x3
#define B_AX_GID_49_POSITION_SH 2
#define B_AX_GID_49_POSITION_MSK 0x3
#define B_AX_GID_48_POSITION_SH 0
#define B_AX_GID_48_POSITION_MSK 0x3

#define R_AX_GID_POSITION_EN0 0xC080
#define R_AX_GID_POSITION_EN0_C1 0xE080
#define B_AX_GID_31_POSITION_EN BIT(31)
#define B_AX_GID_30_POSITION_EN BIT(30)
#define B_AX_GID_29_POSITION_EN BIT(29)
#define B_AX_GID_28_POSITION_EN BIT(28)
#define B_AX_GID_27_POSITION_EN BIT(27)
#define B_AX_GID_26_POSITION_EN BIT(26)
#define B_AX_GID_25_POSITION_EN BIT(25)
#define B_AX_GID_24_POSITION_EN BIT(24)
#define B_AX_GID_23_POSITION_EN BIT(23)
#define B_AX_GID_22_POSITION_EN BIT(22)
#define B_AX_GID_21_POSITION_EN BIT(21)
#define B_AX_GID_20_POSITION_EN BIT(20)
#define B_AX_GID_19_POSITION_EN BIT(19)
#define B_AX_GID_18_POSITION_EN BIT(18)
#define B_AX_GID_17_POSITION_EN BIT(17)
#define B_AX_GID_16_POSITION_EN BIT(16)
#define B_AX_GID_15_POSITION_EN BIT(15)
#define B_AX_GID_14_POSITION_EN BIT(14)
#define B_AX_GID_13_POSITION_EN BIT(13)
#define B_AX_GID_12_POSITION_EN BIT(12)
#define B_AX_GID_11_POSITION_EN BIT(11)
#define B_AX_GID_10_POSITION_EN BIT(10)
#define B_AX_GID_9_POSITION_EN BIT(9)
#define B_AX_GID_8_POSITION_EN BIT(8)
#define B_AX_GID_7_POSITION_EN BIT(7)
#define B_AX_GID_6_POSITION_EN BIT(6)
#define B_AX_GID_5_POSITION_EN BIT(5)
#define B_AX_GID_4_POSITION_EN BIT(4)
#define B_AX_GID_3_POSITION_EN BIT(3)
#define B_AX_GID_2_POSITION_EN BIT(2)
#define B_AX_GID_1_POSITION_EN BIT(1)
#define B_AX_GID_0_POSITION_EN BIT(0)

#define R_AX_GID_POSITION_EN1 0xC084
#define R_AX_GID_POSITION_EN1_C1 0xE084
#define B_AX_GID_63_POSITION_EN BIT(31)
#define B_AX_GID_62_POSITION_EN BIT(30)
#define B_AX_GID_61_POSITION_EN BIT(29)
#define B_AX_GID_60_POSITION_EN BIT(28)
#define B_AX_GID_59_POSITION_EN BIT(27)
#define B_AX_GID_58_POSITION_EN BIT(26)
#define B_AX_GID_57_POSITION_EN BIT(25)
#define B_AX_GID_56_POSITION_EN BIT(24)
#define B_AX_GID_55_POSITION_EN BIT(23)
#define B_AX_GID_54_POSITION_EN BIT(22)
#define B_AX_GID_53_POSITION_EN BIT(21)
#define B_AX_GID_52_POSITION_EN BIT(20)
#define B_AX_GID_51_POSITION_EN BIT(19)
#define B_AX_GID_50_POSITION_EN BIT(18)
#define B_AX_GID_49_POSITION_EN BIT(17)
#define B_AX_GID_48_POSITION_EN BIT(16)
#define B_AX_GID_47_POSITION_EN BIT(15)
#define B_AX_GID_46_POSITION_EN BIT(14)
#define B_AX_GID_45_POSITION_EN BIT(13)
#define B_AX_GID_44_POSITION_EN BIT(12)
#define B_AX_GID_43_POSITION_EN BIT(11)
#define B_AX_GID_42_POSITION_EN BIT(10)
#define B_AX_GID_41_POSITION_EN BIT(9)
#define B_AX_GID_40_POSITION_EN BIT(8)
#define B_AX_GID_39_POSITION_EN BIT(7)
#define B_AX_GID_38_POSITION_EN BIT(6)
#define B_AX_GID_37_POSITION_EN BIT(5)
#define B_AX_GID_36_POSITION_EN BIT(4)
#define B_AX_GID_35_POSITION_EN BIT(3)
#define B_AX_GID_34_POSITION_EN BIT(2)
#define B_AX_GID_33_POSITION_EN BIT(1)
#define B_AX_GID_32_POSITION_EN BIT(0)

#define R_AX_TX_SUB_CARRIER_VALUE 0xC088
#define R_AX_TX_SUB_CARRIER_VALUE_C1 0xE088
#define B_AX_TXSC_80M_SH 8
#define B_AX_TXSC_80M_MSK 0xf
#define B_AX_TXSC_40M_SH 4
#define B_AX_TXSC_40M_MSK 0xf
#define B_AX_TXSC_20M_SH 0
#define B_AX_TXSC_20M_MSK 0xf

#define R_AX_RRSR0 0xC08C
#define R_AX_RRSR0_C1 0xE08C
#define B_AX_RRSR_HE_SH 24
#define B_AX_RRSR_HE_MSK 0xff
#define B_AX_RRSR_VHT_SH 16
#define B_AX_RRSR_VHT_MSK 0xff
#define B_AX_RRSR_HT_SH 8
#define B_AX_RRSR_HT_MSK 0xff
#define B_AX_RRSR_OFDM_SH 0
#define B_AX_RRSR_OFDM_MSK 0xff

#define R_AX_PTCL_RRSR1 0xC090
#define R_AX_PTCL_RRSR1_C1 0xE090
#define B_AX_RRSR_RATE_EN_SH 8
#define B_AX_RRSR_RATE_EN_MSK 0xf
#define B_AX_RSC_SH 6
#define B_AX_RSC_MSK 0x3
#define B_AX_RRSR_CCK_SH 0
#define B_AX_RRSR_CCK_MSK 0xf

#define R_AX_FWC00IMR 0xC100
#define R_AX_FWC00IMR_C1 0xE100
#define B_AX_FS_SND_RDY_INT_EN BIT(29)
#define B_AX_FS_RP_END_INT_EN BIT(28)
#define B_AX_FS_RXBCN_TO_CNT_INT_EN BIT(27)
#define B_AX_FS_RXBCN_HIT_INT_EN BIT(26)
#define B_AX_FS_RX_MATCH_RTT_INT_EN BIT(25)
#define B_AX_FS_BCNQ_LOCK_INT_EN BIT(24)
#define B_AX_FS_P2P1_CTWEND_INT_EN BIT(23)
#define B_AX_FS_P2P1_TSF32_TOGGLE_INT_EN BIT(22)
#define B_AX_FS_P2P1_RFON_INT_EN BIT(21)
#define B_AX_FS_P2P1_RFOFF_INT_EN BIT(20)
#define B_AX_FS_P2P0_CTWEND_INT_EN BIT(19)
#define B_AX_FS_P2P0_TSF32_TOGGLE_INT_EN BIT(18)
#define B_AX_FS_P2P0_RFON_INT_EN BIT(17)
#define B_AX_FS_P2P0_RFOFF_INT_EN BIT(16)
#define B_AX_FS_MACID_PWRCHANGE3_INT_EN BIT(15)
#define B_AX_FS_MACID_PWRCHANGE2_INT_EN BIT(14)
#define B_AX_FS_MACID_PWRCHANGE1_INT_EN BIT(13)
#define B_AX_FS_MACID_PWRCHANGE0_INT_EN BIT(12)
#define B_AX_FS_RXFTMREQ_INT_EN BIT(11)
#define B_AX_FS_RXFTM_INT_EN BIT(10)
#define B_AX_FS_FTM_PTT_EN BIT(9)
#define B_AX_FS_TXFTM_INT_EN BIT(8)
#define B_AX_FS_SOUND_DONE_INT_EN BIT(7)
#define B_AX_FS_RXDONE_INT_EN BIT(6)
#define B_AX_FS_PSTIMER_5_INT_EN BIT(5)
#define B_AX_FS_PSTIMER_4_INT_EN BIT(4)
#define B_AX_FS_PSTIMER_3_INT_EN BIT(3)
#define B_AX_FS_PSTIMER_2_INT_EN BIT(2)
#define B_AX_FS_PSTIMER_1_INT_EN BIT(1)
#define B_AX_FS_PSTIMER_0_INT_EN BIT(0)

#define R_AX_FWC00ISR 0xC104
#define R_AX_FWC00ISR_C1 0xE104
#define B_AX_FS_SND_RDY_INT BIT(29)
#define B_AX_FS_RP_END_INT BIT(28)
#define B_AX_FS_RXBCN_TO_CNT_INT BIT(27)
#define B_AX_FS_RXBCN_HIT_INT BIT(26)
#define B_AX_FS_RX_MATCH_RTT_INT BIT(25)
#define B_AX_FS_BCNQ_LOCK_INT BIT(24)
#define B_AX_FS_P2P1_CTWEND_INT BIT(23)
#define B_AX_FS_P2P1_TSF32_TOGGLE_INT BIT(22)
#define B_AX_FS_P2P1_RFON_INT BIT(21)
#define B_AX_FS_P2P1_RFOFF_INT BIT(20)
#define B_AX_FS_P2P0_CTWEND_INT BIT(19)
#define B_AX_FS_P2P0_TSF32_TOGGLE_INT BIT(18)
#define B_AX_FS_P2P0_RFON_INT BIT(17)
#define B_AX_FS_P2P0_RFOFF_INT BIT(16)
#define B_AX_FS_MACID_PWRCHANGE3_INT BIT(15)
#define B_AX_FS_MACID_PWRCHANGE2_INT BIT(14)
#define B_AX_FS_MACID_PWRCHANGE1_INT BIT(13)
#define B_AX_FS_MACID_PWRCHANGE0_INT BIT(12)
#define B_AX_FS_RXFTMREQ_INT BIT(11)
#define B_AX_FS_RXFTM_INT BIT(10)
#define B_AX_FS_FTM_PTT_INT BIT(9)
#define B_AX_FS_TXFTM_INT BIT(8)
#define B_AX_FS_SOUND_DONE_INT BIT(7)
#define B_AX_FS_RXDONE_INT BIT(6)
#define B_AX_FS_PSTIMER_5_INT BIT(5)
#define B_AX_FS_PSTIMER_4_INT BIT(4)
#define B_AX_FS_PSTIMER_3_INT BIT(3)
#define B_AX_FS_PSTIMER_2_INT BIT(2)
#define B_AX_FS_PSTIMER_1_INT BIT(1)
#define B_AX_FS_PSTIMER_0_INT BIT(0)

#define R_AX_FWC01IMR 0xC108
#define R_AX_FWC01IMR_C1 0xE108
#define B_AX_FS_P0_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P0_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P0_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P0_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P0_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P0_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P0_EOSP_INT_EN BIT(16)
#define B_AX_FS_P0_TXPKTIN_EN BIT(15)
#define B_AX_FS_P0_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P0_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P0_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P0_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P0_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P0_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P0_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P0MB0_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB0_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB0_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB0_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB0_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB0_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC01ISR 0xC10C
#define R_AX_FWC01ISR_C1 0xE10C
#define B_AX_FS_P0_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P0_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P0_RXMTF0_INT BIT(20)
#define B_AX_FS_P0_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P0_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P0_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P0_EOSP_INT BIT(16)
#define B_AX_FS_P0_TXPKTIN_INT BIT(15)
#define B_AX_FS_P0_TX_NULL1_INT BIT(14)
#define B_AX_FS_P0_TX_NULL0_INT BIT(13)
#define B_AX_FS_P0_RX_UMD0_INT BIT(12)
#define B_AX_FS_P0_RX_UMD1_INT BIT(11)
#define B_AX_FS_P0_RX_BMD0_INT BIT(10)
#define B_AX_FS_P0_RX_BMD1_INT BIT(9)
#define B_AX_FS_P0_RXBCNOK_INT BIT(8)
#define B_AX_FS_P0MB0_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB0_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB0_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB0_TBTT_INT BIT(2)
#define B_AX_FS_P0MB0_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB0_BCNERLY_INT BIT(0)

#define R_AX_FWC02IMR 0xC110
#define R_AX_FWC02IMR_C1 0xE110
#define B_AX_FS_P1_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P1_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P1_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P1_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P1_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P1_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P1_EOSP_INT_EN BIT(16)
#define B_AX_FS_P1_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P1_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P1_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P1_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P1_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P1_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P1_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P1_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P1_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P1_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P1_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P1_TBTT_INT_EN BIT(2)
#define B_AX_FS_P1_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P1_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC02ISR 0xC114
#define R_AX_FWC02ISR_C1 0xE114
#define B_AX_FS_P1_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P1_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P1_RXMTF0_INT BIT(20)
#define B_AX_FS_P1_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P1_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P1_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P1_EOSP_INT BIT(16)
#define B_AX_FS_P1_TXPKTIN_INT BIT(15)
#define B_AX_FS_P1_TX_NULL1_INT BIT(14)
#define B_AX_FS_P1_TX_NULL0_INT BIT(13)
#define B_AX_FS_P1_RX_UMD0_INT BIT(12)
#define B_AX_FS_P1_RX_UMD1_INT BIT(11)
#define B_AX_FS_P1_RX_BMD0_INT BIT(10)
#define B_AX_FS_P1_RX_BMD1_INT BIT(9)
#define B_AX_FS_P1_RXBCNOK_INT BIT(8)
#define B_AX_FS_P1_TXBCNERR_INT BIT(5)
#define B_AX_FS_P1_TXBCNOK_INT BIT(4)
#define B_AX_FS_P1_HIQWND_INT BIT(3)
#define B_AX_FS_P1_TBTT_INT BIT(2)
#define B_AX_FS_P1_TBTTERLY_INT BIT(1)
#define B_AX_FS_P1_BCNERLY_INT BIT(0)

#define R_AX_FWC03IMR 0xC118
#define R_AX_FWC03IMR_C1 0xE118
#define B_AX_FS_P2_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P2_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P2_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P2_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P2_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P2_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P2_EOSP_INT_EN BIT(16)
#define B_AX_FS_P2_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P2_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P2_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P2_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P2_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P2_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P2_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P2_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P2_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P2_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P2_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P2_TBTT_INT_EN BIT(2)
#define B_AX_FS_P2_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P2_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC03ISR 0xC11C
#define R_AX_FWC03ISR_C1 0xE11C
#define B_AX_FS_P2_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P2_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P2_RXMTF0_INT BIT(20)
#define B_AX_FS_P2_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P2_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P2_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P2_EOSP_INT BIT(16)
#define B_AX_FS_P2_TXPKTIN_INT BIT(15)
#define B_AX_FS_P2_TX_NULL1_INT BIT(14)
#define B_AX_FS_P2_TX_NULL0_INT BIT(13)
#define B_AX_FS_P2_RX_UMD0_INT BIT(12)
#define B_AX_FS_P2_RX_UMD1_INT BIT(11)
#define B_AX_FS_P2_RX_BMD0_INT BIT(10)
#define B_AX_FS_P2_RX_BMD1_INT BIT(9)
#define B_AX_FS_P2_RXBCNOK_INT BIT(8)
#define B_AX_FS_P2_TXBCNERR_INT BIT(5)
#define B_AX_FS_P2_TXBCNOK_INT BIT(4)
#define B_AX_FS_P2_HIQWND_INT BIT(3)
#define B_AX_FS_P2_TBTT_INT BIT(2)
#define B_AX_FS_P2_TBTTERLY_INT BIT(1)
#define B_AX_FS_P2_BCNERLY_INT BIT(0)

#define R_AX_FWC04IMR 0xC120
#define R_AX_FWC04IMR_C1 0xE120
#define B_AX_FS_P3_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P3_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P3_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P3_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P3_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P3_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P3_EOSP_INT_EN BIT(16)
#define B_AX_FS_P3_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P3_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P3_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P3_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P3_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P3_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P3_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P3_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P3_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P3_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P3_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P3_TBTT_INT_EN BIT(2)
#define B_AX_FS_P3_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P3_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC04ISR 0xC124
#define R_AX_FWC04ISR_C1 0xE124
#define B_AX_FS_P3_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P3_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P3_RXMTF0_INT BIT(20)
#define B_AX_FS_P3_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P3_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P3_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P3_EOSP_INT BIT(16)
#define B_AX_FS_P3_TXPKTIN_INT BIT(15)
#define B_AX_FS_P3_TX_NULL1_INT BIT(14)
#define B_AX_FS_P3_TX_NULL0_INT BIT(13)
#define B_AX_FS_P3_RX_UMD0_INT BIT(12)
#define B_AX_FS_P3_RX_UMD1_INT BIT(11)
#define B_AX_FS_P3_RX_BMD0_INT BIT(10)
#define B_AX_FS_P3_RX_BMD1_INT BIT(9)
#define B_AX_FS_P3_RXBCNOK_INT BIT(8)
#define B_AX_FS_P3_TXBCNERR_INT BIT(5)
#define B_AX_FS_P3_TXBCNOK_INT BIT(4)
#define B_AX_FS_P3_HIQWND_INT BIT(3)
#define B_AX_FS_P3_TBTT_INT BIT(2)
#define B_AX_FS_P3_TBTTERLY_INT BIT(1)
#define B_AX_FS_P3_BCNERLY_INT BIT(0)

#define R_AX_FWC05IMR 0xC128
#define R_AX_FWC05IMR_C1 0xE128
#define B_AX_FS_P4_RXBCN_NOHIT_INT_EN BIT(22)
#define B_AX_FS_P4_RXMTF1MRR0_INT_EN BIT(21)
#define B_AX_FS_P4_RXMTF0_INT_EN BIT(20)
#define B_AX_FS_P4_RX_UAPSDMD1_INT_EN BIT(19)
#define B_AX_FS_P4_RX_UAPSDMD0_INT_EN BIT(18)
#define B_AX_FS_P4_TRIGGER_PKT_INT_EN BIT(17)
#define B_AX_FS_P4_EOSP_INT_EN BIT(16)
#define B_AX_FS_P4_TXPKTIN_INT_EN BIT(15)
#define B_AX_FS_P4_TX_NULL1_INT_EN BIT(14)
#define B_AX_FS_P4_TX_NULL0_INT_EN BIT(13)
#define B_AX_FS_P4_RX_UMD0_INT_EN BIT(12)
#define B_AX_FS_P4_RX_UMD1_INT_EN BIT(11)
#define B_AX_FS_P4_RX_BMD0_INT_EN BIT(10)
#define B_AX_FS_P4_RX_BMD1_INT_EN BIT(9)
#define B_AX_FS_P4_RXBCNOK_INT_EN BIT(8)
#define B_AX_FS_P4_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P4_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P4_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P4_TBTT_INT_EN BIT(2)
#define B_AX_FS_P4_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P4_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC05ISR 0xC12C
#define R_AX_FWC05ISR_C1 0xE12C
#define B_AX_FS_P4_RXBCN_NOHIT_INT BIT(22)
#define B_AX_FS_P4_RXMTF1MRR0_INT BIT(21)
#define B_AX_FS_P4_RXMTF0_INT BIT(20)
#define B_AX_FS_P4_RX_UAPSDMD1_INT BIT(19)
#define B_AX_FS_P4_RX_UAPSDMD0_INT BIT(18)
#define B_AX_FS_P4_TRIGGER_PKT_INT BIT(17)
#define B_AX_FS_P4_EOSP_INT BIT(16)
#define B_AX_FS_P4_TXPKTIN_INT BIT(15)
#define B_AX_FS_P4_TX_NULL1_INT BIT(14)
#define B_AX_FS_P4_TX_NULL0_INT BIT(13)
#define B_AX_FS_P4_RX_UMD0_INT BIT(12)
#define B_AX_FS_P4_RX_UMD1_INT BIT(11)
#define B_AX_FS_P4_RX_BMD0_INT BIT(10)
#define B_AX_FS_P4_RX_BMD1_INT BIT(9)
#define B_AX_FS_P4_RXBCNOK_INT BIT(8)
#define B_AX_FS_P4_TXBCNERR_INT BIT(5)
#define B_AX_FS_P4_TXBCNOK_INT BIT(4)
#define B_AX_FS_P4_HIQWND_INT BIT(3)
#define B_AX_FS_P4_TBTT_INT BIT(2)
#define B_AX_FS_P4_TBTTERLY_INT BIT(1)
#define B_AX_FS_P4_BCNERLY_INT BIT(0)

#define R_AX_FWC06IMR 0xC130
#define R_AX_FWC06IMR_C1 0xE130
#define B_AX_FS_P0MB4_TXBCNERR_INT_EN BIT(29)
#define B_AX_FS_P0MB4_TXBCNOK_INT_EN BIT(28)
#define B_AX_FS_P0MB4_HIQWND_INT_EN BIT(27)
#define B_AX_FS_P0MB4_TBTT_INT_EN BIT(26)
#define B_AX_FS_P0MB4_TBTTERLY_INT_EN BIT(25)
#define B_AX_FS_P0MB4_BCNERLY_INT_EN BIT(24)
#define B_AX_FS_P0MB3_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB3_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB3_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB3_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB3_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB3_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB2_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB2_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB2_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB2_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB2_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB2_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB1_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB1_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB1_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB1_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB1_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB1_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC06ISR 0xC134
#define R_AX_FWC06ISR_C1 0xE134
#define B_AX_FS_P0MB4_TXBCNERR_INT BIT(29)
#define B_AX_FS_P0MB4_TXBCNOK_INT BIT(28)
#define B_AX_FS_P0MB4_HIQWND_INT BIT(27)
#define B_AX_FS_P0MB4_TBTT_INT BIT(26)
#define B_AX_FS_P0MB4_TBTTERLY_INT BIT(25)
#define B_AX_FS_P0MB4_BCNERLY_INT BIT(24)
#define B_AX_FS_P0MB3_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB3_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB3_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB3_TBTT_INT BIT(18)
#define B_AX_FS_P0MB3_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB3_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB2_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB2_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB2_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB2_TBTT_INT BIT(10)
#define B_AX_FS_P0MB2_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB2_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB1_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB1_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB1_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB1_TBTT_INT BIT(2)
#define B_AX_FS_P0MB1_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB1_BCNERLY_INT BIT(0)

#define R_AX_FWC07IMR 0xC138
#define R_AX_FWC07IMR_C1 0xE138
#define B_AX_FS_P0MB8_TXBCNERR_INT_EN BIT(29)
#define B_AX_FS_P0MB8_TXBCNOK_INT_EN BIT(28)
#define B_AX_FS_P0MB8_HIQWND_INT_EN BIT(27)
#define B_AX_FS_P0MB8_TBTT_INT_EN BIT(26)
#define B_AX_FS_P0MB8_TBTTERLY_INT_EN BIT(25)
#define B_AX_FS_P0MB8_BCNERLY_INT_EN BIT(24)
#define B_AX_FS_P0MB7_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB7_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB7_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB7_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB7_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB7_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB6_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB6_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB6_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB6_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB6_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB6_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB5_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB5_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB5_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB5_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB5_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB5_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC07ISR 0xC13C
#define R_AX_FWC07ISR_C1 0xE13C
#define B_AX_FS_P0MB8_TXBCNERR_INT BIT(29)
#define B_AX_FS_P0MB8_TXBCNOK_INT BIT(28)
#define B_AX_FS_P0MB8_HIQWND_INT BIT(27)
#define B_AX_FS_P0MB8_TBTT_INT BIT(26)
#define B_AX_FS_P0MB8_TBTTERLY_INT BIT(25)
#define B_AX_FS_P0MB8_BCNERLY_INT BIT(24)
#define B_AX_FS_P0MB7_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB7_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB7_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB7_TBTT_INT BIT(18)
#define B_AX_FS_P0MB7_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB7_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB6_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB6_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB6_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB6_TBTT_INT BIT(10)
#define B_AX_FS_P0MB6_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB6_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB5_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB5_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB5_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB5_TBTT_INT BIT(2)
#define B_AX_FS_P0MB5_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB5_BCNERLY_INT BIT(0)

#define R_AX_FWC08IMR 0xC140
#define R_AX_FWC08IMR_C1 0xE140
#define B_AX_FS_P0MB12_TXBCNERR_INT_EN BIT(29)
#define B_AX_FS_P0MB12_TXBCNOK_INT_EN BIT(28)
#define B_AX_FS_P0MB12_HIQWND_INT_EN BIT(27)
#define B_AX_FS_P0MB12_TBTT_INT_EN BIT(26)
#define B_AX_FS_P0MB12_TBTTERLY_INT_EN BIT(25)
#define B_AX_FS_P0MB12_BCNERLY_INT_EN BIT(24)
#define B_AX_FS_P0MB11_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB11_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB11_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB11_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB11_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB11_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB10_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB10_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB10_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB10_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB10_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB10_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB9_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB9_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB9_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB9_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB9_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB9_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC08ISR 0xC144
#define R_AX_FWC08ISR_C1 0xE144
#define B_AX_FS_P0MB12_TXBCNERR_INT BIT(29)
#define B_AX_FS_P0MB12_TXBCNOK_INT BIT(28)
#define B_AX_FS_P0MB12_HIQWND_INT BIT(27)
#define B_AX_FS_P0MB12_TBTT_INT BIT(26)
#define B_AX_FS_P0MB12_TBTTERLY_INT BIT(25)
#define B_AX_FS_P0MB12_BCNERLY_INT BIT(24)
#define B_AX_FS_P0MB11_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB11_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB11_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB11_TBTT_INT BIT(18)
#define B_AX_FS_P0MB11_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB11_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB10_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB10_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB10_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB10_TBTT_INT BIT(10)
#define B_AX_FS_P0MB10_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB10_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB9_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB9_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB9_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB9_TBTT_INT BIT(2)
#define B_AX_FS_P0MB9_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB9_BCNERLY_INT BIT(0)

#define R_AX_FWC09IMR 0xC148
#define R_AX_FWC09IMR_C1 0xE148
#define B_AX_FS_P0MB15_TXBCNERR_INT_EN BIT(21)
#define B_AX_FS_P0MB15_TXBCNOK_INT_EN BIT(20)
#define B_AX_FS_P0MB15_HIQWND_INT_EN BIT(19)
#define B_AX_FS_P0MB15_TBTT_INT_EN BIT(18)
#define B_AX_FS_P0MB15_TBTTERLY_INT_EN BIT(17)
#define B_AX_FS_P0MB15_BCNERLY_INT_EN BIT(16)
#define B_AX_FS_P0MB14_TXBCNERR_INT_EN BIT(13)
#define B_AX_FS_P0MB14_TXBCNOK_INT_EN BIT(12)
#define B_AX_FS_P0MB14_HIQWND_INT_EN BIT(11)
#define B_AX_FS_P0MB14_TBTT_INT_EN BIT(10)
#define B_AX_FS_P0MB14_TBTTERLY_INT_EN BIT(9)
#define B_AX_FS_P0MB14_BCNERLY_INT_EN BIT(8)
#define B_AX_FS_P0MB13_TXBCNERR_INT_EN BIT(5)
#define B_AX_FS_P0MB13_TXBCNOK_INT_EN BIT(4)
#define B_AX_FS_P0MB13_HIQWND_INT_EN BIT(3)
#define B_AX_FS_P0MB13_TBTT_INT_EN BIT(2)
#define B_AX_FS_P0MB13_TBTTERLY_INT_EN BIT(1)
#define B_AX_FS_P0MB13_BCNERLY_INT_EN BIT(0)

#define R_AX_FWC09ISR 0xC14C
#define R_AX_FWC09ISR_C1 0xE14C
#define B_AX_FS_P0MB15_TXBCNERR_INT BIT(21)
#define B_AX_FS_P0MB15_TXBCNOK_INT BIT(20)
#define B_AX_FS_P0MB15_HIQWND_INT BIT(19)
#define B_AX_FS_P0MB15_TBTT_INT BIT(18)
#define B_AX_FS_P0MB15_TBTTERLY_INT BIT(17)
#define B_AX_FS_P0MB15_BCNERLY_INT BIT(16)
#define B_AX_FS_P0MB14_TXBCNERR_INT BIT(13)
#define B_AX_FS_P0MB14_TXBCNOK_INT BIT(12)
#define B_AX_FS_P0MB14_HIQWND_INT BIT(11)
#define B_AX_FS_P0MB14_TBTT_INT BIT(10)
#define B_AX_FS_P0MB14_TBTTERLY_INT BIT(9)
#define B_AX_FS_P0MB14_BCNERLY_INT BIT(8)
#define B_AX_FS_P0MB13_TXBCNERR_INT BIT(5)
#define B_AX_FS_P0MB13_TXBCNOK_INT BIT(4)
#define B_AX_FS_P0MB13_HIQWND_INT BIT(3)
#define B_AX_FS_P0MB13_TBTT_INT BIT(2)
#define B_AX_FS_P0MB13_TBTTERLY_INT BIT(1)
#define B_AX_FS_P0MB13_BCNERLY_INT BIT(0)

#define R_AX_CMAC_ERR_IMR 0xC160
#define R_AX_CMAC_ERR_IMR_C1 0xE160
#define B_AX_WMAC_TX_ERR_IND_EN BIT(7)
#define B_AX_WMAC_RX_ERR_IND_EN BIT(6)
#define B_AX_TXPWR_CTRL_ERR_IND_EN BIT(5)
#define B_AX_PHYINTF_ERR_IND_EN BIT(4)
#define B_AX_DMA_TOP_ERR_IND_EN BIT(3)
#define B_AX_PTCL_TOP_ERR_IND_EN BIT(1)
#define B_AX_SCHEDULE_TOP_ERR_IND_EN BIT(0)

#define R_AX_CMAC_ERR_ISR 0xC164
#define R_AX_CMAC_ERR_ISR_C1 0xE164
#define B_AX_WMAC_TX_ERR_IND BIT(7)
#define B_AX_WMAC_RX_ERR_IND BIT(6)
#define B_AX_TXPWR_CTRL_ERR_IND BIT(5)
#define B_AX_PHYINTF_ERR_IND BIT(4)
#define B_AX_DMA_TOP_ERR_IND BIT(3)
#define B_AX_PTCL_TOP_ERR_IND BIT(1)
#define B_AX_SCHEDULE_TOP_ERR_IND BIT(0)

#define R_AX_HC00IMR 0xC180
#define R_AX_HC00IMR_C1 0xE180
#define B_AX_TBTT_B0P4_INT_EN BIT(16)
#define B_AX_TBTT_B0P3_INT_EN BIT(15)
#define B_AX_TBTT_B0P2_INT_EN BIT(14)
#define B_AX_TBTT_B0P1_INT_EN BIT(13)
#define B_AX_TBTT_B0P0_INT_EN BIT(12)
#define B_AX_PKT_INFO_ERR_INT_EN BIT(11)
#define B_AX_BB_STOPRX_INT_EN BIT(10)
#define B_AX_TXERR_INT_EN BIT(9)
#define B_AX_RXERR_INT_EN BIT(8)
#define B_AX_P2P1_TSF32_TOGG_INT_EN BIT(7)
#define B_AX_P2P0_TSF32_TOGG_INT_EN BIT(6)
#define B_AX_PWR_127TO96_INT_EN BIT(5)
#define B_AX_PWR_95TO64_INT_EN BIT(4)
#define B_AX_PWR_63TO32_INT_EN BIT(3)
#define B_AX_PWR_31TO0_INT_EN BIT(2)
#define B_AX_PSTIMER_5_INT_EN BIT(1)
#define B_AX_PSTIMER_4_INT_EN BIT(0)

#define R_AX_HC00ISR 0xC184
#define R_AX_HC00ISR_C1 0xE184
#define B_AX_TBTT_B0P4_INT BIT(16)
#define B_AX_TBTT_B0P3_INT BIT(15)
#define B_AX_TBTT_B0P2_INT BIT(14)
#define B_AX_TBTT_B0P1_INT BIT(13)
#define B_AX_TBTT_B0P0_INT BIT(12)
#define B_AX_PKT_INFO_ERR_INT BIT(11)
#define B_AX_BB_STOPRX_INT BIT(10)
#define B_AX_TXERR_INT BIT(9)
#define B_AX_RXERR_INT BIT(8)
#define B_AX_P2P1_TSF32_TOGG_INT BIT(7)
#define B_AX_P2P0_TSF32_TOGG_INT BIT(6)
#define B_AX_PWR_127TO96_INT BIT(5)
#define B_AX_PWR_95TO64_INT BIT(4)
#define B_AX_PWR_63TO32_INT BIT(3)
#define B_AX_PWR_31TO0_INT BIT(2)
#define B_AX_PSTIMER_5_INT BIT(1)
#define B_AX_PSTIMER_4_INT BIT(0)

//
// SCH
//

#define R_AX_PPS0_CTRL 0xC200
#define R_AX_PPS0_CTRL_C1 0xE200
#define B_AX_PPS0_PWR_RST1 BIT(31)
#define B_AX_PPS0_PWR_RST0 BIT(30)
#define B_AX_PPS0_CTWIN_SH 16
#define B_AX_PPS0_CTWIN_MSK 0xfff
#define B_AX_PPS0_TXOP_BRK_EN BIT(15)
#define B_AX_PPS0_AGG_BRK_EN BIT(14)
#define B_AX_PPS0_POF_AND_EN BIT(13)
#define B_AX_PPS0_PSWIND_EN BIT(12)
#define B_AX_PPS0_TSFB32_RST_EN BIT(11)
#define B_AX_PPS0_PORT_SEL_SH 8
#define B_AX_PPS0_PORT_SEL_MSK 0x7
#define B_AX_PPS0_ALLSLEEP_EN BIT(7)
#define B_AX_PPS0_OFF_DISTX_EN BIT(6)
#define B_AX_PPS0_CTWIN_EN BIT(5)
#define B_AX_PPS0_BCNAREA_EN BIT(4)
#define B_AX_PPS0_WITHBCNERY BIT(3)
#define B_AX_PPS0_POF1_EN BIT(2)
#define B_AX_PPS0_POF0_EN BIT(1)
#define B_AX_PPS0_PWR_MGT_EN BIT(0)

#define R_AX_PPS0_SPEC_STATE 0xC204
#define R_AX_PPS0_SPEC_STATE_C1 0xE204
#define B_AX_PPS0_SPEC_POW_STATE BIT(7)
#define B_AX_PPS0_SPEC_CTWIN_ON BIT(6)
#define B_AX_PPS0_SPEC_BCNAREA_ON BIT(5)
#define B_AX_PPS0_SPEC_BCNERLY BIT(4)
#define B_AX_PPS0_SPEC_POF1_OFF_PERD BIT(3)
#define B_AX_PPS0_SPEC_FORCE_DOZE1 BIT(2)
#define B_AX_PPS0_SPEC_POF0_OFF_PERD BIT(1)
#define B_AX_PPS0_SPEC_FORCE_DOZE0 BIT(0)

#define R_AX_PPS0_STATE 0xC205
#define R_AX_PPS0_STATE_C1 0xE205
#define B_AX_PPS0_POW_STATE BIT(7)
#define B_AX_PPS0_CTWIN_ON BIT(6)
#define B_AX_PPS0_BCNAREA_ON BIT(5)
#define B_AX_PPS0_BCNERLY BIT(4)
#define B_AX_PPS0_POF1_OFF_PERD BIT(3)
#define B_AX_PPS0_FORCE_DOZE1 BIT(2)
#define B_AX_PPS0_POF0_OFF_PERD BIT(1)
#define B_AX_PPS0_FORCE_DOZE0 BIT(0)

#define R_AX_PPS0_PAUSE_CTRL0 0xC206
#define R_AX_PPS0_PAUSE_CTRL0_C1 0xE206
#define B_AX_PPS0_POF_STOP_TX_HANG BIT(15)
#define B_AX_PPS0_MGQ_PAUSE_EN BIT(11)
#define B_AX_PPS0_HIQ_PAUSE_EN BIT(10)
#define B_AX_PPS0_BCNQ_PAUSE_EN BIT(9)
#define B_AX_PPS0_MACID_PAUSE_EN BIT(8)
#define B_AX_PPS0_PAUSE_MACID_SH 0
#define B_AX_PPS0_PAUSE_MACID_MSK 0xff

#define R_AX_PPS0_PAUSE_CTRL1 0xC208
#define R_AX_PPS0_PAUSE_CTRL1_C1 0xE208
#define B_AX_PPS0_POWON_DISTX_SH 16
#define B_AX_PPS0_POWON_DISTX_MSK 0xffff
#define B_AX_PPS0_POWOFF_DISTX_SH 0
#define B_AX_PPS0_POWOFF_DISTX_MSK 0xffff

#define R_AX_PPS0_PAUSE_CTRL2 0xC20C
#define R_AX_PPS0_PAUSE_CTRL2_C1 0xE20C
#define B_AX_PPS0_POWOFF_ERLY_SH 16
#define B_AX_PPS0_POWOFF_ERLY_MSK 0xffff
#define B_AX_PPS0_POWON_ERLY_SH 0
#define B_AX_PPS0_POWON_ERLY_MSK 0xffff

#define R_AX_PPS0_POF0_PARAM0 0xC210
#define R_AX_PPS0_POF0_PARAM0_C1 0xE210
#define B_AX_PPS0_POF0_DUR_SH 0
#define B_AX_PPS0_POF0_DUR_MSK 0xffffffffL

#define R_AX_PPS0_POF0_PARAM1 0xC214
#define R_AX_PPS0_POF0_PARAM1_C1 0xE214
#define B_AX_PPS0_POF0_ITVL_SH 0
#define B_AX_PPS0_POF0_ITVL_MSK 0xffffffffL

#define R_AX_PPS0_POF0_PARAM2 0xC218
#define R_AX_PPS0_POF0_PARAM2_C1 0xE218
#define B_AX_PPS0_POF0_START_SH 0
#define B_AX_PPS0_POF0_START_MSK 0xffffffffL

#define R_AX_PPS0_POF0_PARAM3 0xC21C
#define R_AX_PPS0_POF0_PARAM3_C1 0xE21C
#define B_AX_PPS0_POF0_CUR_CNT_SH 8
#define B_AX_PPS0_POF0_CUR_CNT_MSK 0xff
#define B_AX_PPS0_POF0_CNT_SH 0
#define B_AX_PPS0_POF0_CNT_MSK 0xff

#define R_AX_PPS0_POF1_PARAM0 0xC220
#define R_AX_PPS0_POF1_PARAM0_C1 0xE220
#define B_AX_PPS0_POF1_DUR_SH 0
#define B_AX_PPS0_POF1_DUR_MSK 0xffffffffL

#define R_AX_PPS0_POF1_PARAM1 0xC224
#define R_AX_PPS0_POF1_PARAM1_C1 0xE224
#define B_AX_PPS0_POF1_ITVL_SH 0
#define B_AX_PPS0_POF1_ITVL_MSK 0xffffffffL

#define R_AX_PPS0_POF1_PARAM2 0xC228
#define R_AX_PPS0_POF1_PARAM2_C1 0xE228
#define B_AX_PPS0_POF1_START_SH 0
#define B_AX_PPS0_POF1_START_MSK 0xffffffffL

#define R_AX_PPS0_POF1_PARAM3 0xC22C
#define R_AX_PPS0_POF1_PARAM3_C1 0xE22C
#define B_AX_PPS0_POF1_CUR_CNT_SH 8
#define B_AX_PPS0_POF1_CUR_CNT_MSK 0xff
#define B_AX_PPS0_POF1_CNT_SH 0
#define B_AX_PPS0_POF1_CNT_MSK 0xff

#define R_AX_PPS0_CURR_DOZE0 0xC230
#define R_AX_PPS0_CURR_DOZE0_C1 0xE230
#define B_AX_PPS0_POF0_CURR_DOZE_SH 0
#define B_AX_PPS0_POF0_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PPS0_CURR_DOZE1 0xC234
#define R_AX_PPS0_CURR_DOZE1_C1 0xE234
#define B_AX_PPS0_POF1_CURR_DOZE_SH 0
#define B_AX_PPS0_POF1_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PPS1_CTRL 0xC240
#define R_AX_PPS1_CTRL_C1 0xE240
#define B_AX_PPS1_PWR_RST1 BIT(31)
#define B_AX_PPS1_PWR_RST0 BIT(30)
#define B_AX_PPS1_CTWIN_SH 16
#define B_AX_PPS1_CTWIN_MSK 0xfff
#define B_AX_PPS1_TXOP_BRK_EN BIT(15)
#define B_AX_PPS1_AGG_BRK_EN BIT(14)
#define B_AX_PPS1_POF_AND_EN BIT(13)
#define B_AX_PPS1_PSWIND_EN BIT(12)
#define B_AX_PPS1_TSFB32_RST_EN BIT(11)
#define B_AX_PPS1_PORT_SEL_SH 8
#define B_AX_PPS1_PORT_SEL_MSK 0x7
#define B_AX_PPS1_ALLSLEEP_EN BIT(7)
#define B_AX_PPS1_OFF_DISTX_EN BIT(6)
#define B_AX_PPS1_CTWIN_EN BIT(5)
#define B_AX_PPS1_BCNAREA_EN BIT(4)
#define B_AX_PPS1_WITHBCNERY BIT(3)
#define B_AX_PPS1_POF1_EN BIT(2)
#define B_AX_PPS1_POF0_EN BIT(1)
#define B_AX_PPS1_PWR_MGT_EN BIT(0)

#define R_AX_PPS1_SPEC_STATE 0xC244
#define R_AX_PPS1_SPEC_STATE_C1 0xE244
#define B_AX_PPS1_SPEC_POW_STATE BIT(7)
#define B_AX_PPS1_SPEC_CTWIN_ON BIT(6)
#define B_AX_PPS1_SPEC_BCNAREA_ON BIT(5)
#define B_AX_PPS1_SPEC_BCNERLY BIT(4)
#define B_AX_PPS1_SPEC_POF1_OFF_PERD BIT(3)
#define B_AX_PPS1_SPEC_FORCE_DOZE1 BIT(2)
#define B_AX_PPS1_SPEC_POF0_OFF_PERD BIT(1)
#define B_AX_PPS1_SPEC_FORCE_DOZE0 BIT(0)

#define R_AX_PPS1_STATE 0xC245
#define R_AX_PPS1_STATE_C1 0xE245
#define B_AX_PPS1_POW_STATE BIT(7)
#define B_AX_PPS1_CTWIN_ON BIT(6)
#define B_AX_PPS1_BCNAREA_ON BIT(5)
#define B_AX_PPS1_BCNERLY BIT(4)
#define B_AX_PPS1_POF1_OFF_PERD BIT(3)
#define B_AX_PPS1_FORCE_DOZE1 BIT(2)
#define B_AX_PPS1_POF0_OFF_PERD BIT(1)
#define B_AX_PPS1_FORCE_DOZE0 BIT(0)

#define R_AX_PPS1_PAUSE_CTRL0 0xC246
#define R_AX_PPS1_PAUSE_CTRL0_C1 0xE246
#define B_AX_PPS1_POF_STOP_TX_HANG BIT(15)
#define B_AX_PPS1_POF1_MGQ_PAUSE_EN BIT(14)
#define B_AX_PPS1_POF1_HIQ_PAUSE_EN BIT(13)
#define B_AX_PPS1_POF1_BCNQ_PAUSE_EN BIT(12)
#define B_AX_PPS1_POF0_MGQ_PAUSE_EN BIT(11)
#define B_AX_PPS1_POF0_HIQ_PAUSE_EN BIT(10)
#define B_AX_PPS1_POF0_BCNQ_PAUSE_EN BIT(9)
#define B_AX_PPS1_MACID_PAUSE_EN BIT(8)
#define B_AX_PPS1_PAUSE_MACID_SH 0
#define B_AX_PPS1_PAUSE_MACID_MSK 0xff

#define R_AX_PPS1_PAUSE_CTRL1 0xC248
#define R_AX_PPS1_PAUSE_CTRL1_C1 0xE248
#define B_AX_PPS1_POWON_DISTX_SH 16
#define B_AX_PPS1_POWON_DISTX_MSK 0xffff
#define B_AX_PPS1_POWOFF_DISTX_SH 0
#define B_AX_PPS1_POWOFF_DISTX_MSK 0xffff

#define R_AX_PPS1_PAUSE_CTRL2 0xC24C
#define R_AX_PPS1_PAUSE_CTRL2_C1 0xE24C
#define B_AX_PPS1_POWOFF_ERLY_SH 16
#define B_AX_PPS1_POWOFF_ERLY_MSK 0xffff
#define B_AX_PPS1_POWON_ERLY_SH 0
#define B_AX_PPS1_POWON_ERLY_MSK 0xffff

#define R_AX_PPS1_POF0_PARAM0 0xC250
#define R_AX_PPS1_POF0_PARAM0_C1 0xE250
#define B_AX_PPS1_POF0_DUR_SH 0
#define B_AX_PPS1_POF0_DUR_MSK 0xffffffffL

#define R_AX_PPS1_POF0_PARAM1 0xC254
#define R_AX_PPS1_POF0_PARAM1_C1 0xE254
#define B_AX_PPS1_POF0_ITVL_SH 0
#define B_AX_PPS1_POF0_ITVL_MSK 0xffffffffL

#define R_AX_PPS1_POF0_PARAM2 0xC258
#define R_AX_PPS1_POF0_PARAM2_C1 0xE258
#define B_AX_PPS1_POF0_START_SH 0
#define B_AX_PPS1_POF0_START_MSK 0xffffffffL

#define R_AX_PPS1_POF0_PARAM3 0xC25C
#define R_AX_PPS1_POF0_PARAM3_C1 0xE25C
#define B_AX_PPS1_POF0_CUR_CNT_SH 8
#define B_AX_PPS1_POF0_CUR_CNT_MSK 0xff
#define B_AX_PPS1_POF0_CNT_SH 0
#define B_AX_PPS1_POF0_CNT_MSK 0xff

#define R_AX_PPS1_POF1_PARAM0 0xC260
#define R_AX_PPS1_POF1_PARAM0_C1 0xE260
#define B_AX_PPS1_POF1_DUR_SH 0
#define B_AX_PPS1_POF1_DUR_MSK 0xffffffffL

#define R_AX_PPS1_POF1_PARAM1 0xC264
#define R_AX_PPS1_POF1_PARAM1_C1 0xE264
#define B_AX_PPS1_POF1_ITVL_SH 0
#define B_AX_PPS1_POF1_ITVL_MSK 0xffffffffL

#define R_AX_PPS1_POF1_PARAM2 0xC268
#define R_AX_PPS1_POF1_PARAM2_C1 0xE268
#define B_AX_PPS1_POF1_START_SH 0
#define B_AX_PPS1_POF1_START_MSK 0xffffffffL

#define R_AX_PPS1_POF1_PARAM3 0xC26C
#define R_AX_PPS1_POF1_PARAM3_C1 0xE26C
#define B_AX_PPS1_POF1_CUR_CNT_SH 8
#define B_AX_PPS1_POF1_CUR_CNT_MSK 0xff
#define B_AX_PPS1_POF1_CNT_SH 0
#define B_AX_PPS1_POF1_CNT_MSK 0xffffffffL

#define R_AX_PPS1_CURR_DOZE0 0xC270
#define R_AX_PPS1_CURR_DOZE0_C1 0xE270
#define B_AX_PPS1_POF0_CURR_DOZE_SH 0
#define B_AX_PPS1_POF0_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PPS1_CURR_DOZE1 0xC274
#define R_AX_PPS1_CURR_DOZE1_C1 0xE274
#define B_AX_PPS1_POF1_CURR_DOZE_SH 0
#define B_AX_PPS1_POF1_CURR_DOZE_MSK 0xffffffffL

#define R_AX_PORT_0_TSF_SYNC 0xC2A0
#define R_AX_PORT_0_TSF_SYNC_C1 0xE2A0
#define B_AX_P0_SYNC_NOW_P BIT(30)
#define B_AX_P0_SYNC_ONCE_P BIT(29)
#define B_AX_P0_AUTO_SYNC BIT(28)
#define B_AX_P0_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P0_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P0_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P0_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_1_TSF_SYNC 0xC2A4
#define R_AX_PORT_1_TSF_SYNC_C1 0xE2A4
#define B_AX_P1_SYNC_NOW_P BIT(30)
#define B_AX_P1_SYNC_ONCE_P BIT(29)
#define B_AX_P1_AUTO_SYNC BIT(28)
#define B_AX_P1_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P1_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P1_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P1_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_2_TSF_SYNC 0xC2A8
#define R_AX_PORT_2_TSF_SYNC_C1 0xE2A8
#define B_AX_P2_SYNC_NOW_P BIT(30)
#define B_AX_P2_SYNC_ONCE_P BIT(29)
#define B_AX_P2_AUTO_SYNC BIT(28)
#define B_AX_P2_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P2_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P2_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P2_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_3_TSF_SYNC 0xC2AC
#define R_AX_PORT_3_TSF_SYNC_C1 0xE2AC
#define B_AX_P3_SYNC_NOW_P BIT(30)
#define B_AX_P3_SYNC_ONCE_P BIT(29)
#define B_AX_P3_AUTO_SYNC BIT(28)
#define B_AX_P3_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P3_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P3_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P3_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_PORT_4_TSF_SYNC 0xC2B0
#define R_AX_PORT_4_TSF_SYNC_C1 0xE2B0
#define B_AX_P4_SYNC_NOW_P BIT(30)
#define B_AX_P4_SYNC_ONCE_P BIT(29)
#define B_AX_P4_AUTO_SYNC BIT(28)
#define B_AX_P4_SYNC_PORT_SRC_SEL_SH 24
#define B_AX_P4_SYNC_PORT_SRC_SEL_MSK 0x7
#define B_AX_P4_TSFTR_SYNC_OFFSET_SH 0
#define B_AX_P4_TSFTR_SYNC_OFFSET_MSK 0x7ffff

#define R_AX_MACID_SLEEP_0 0xC2C0
#define R_AX_MACID_SLEEP_0_C1 0xE2C0
#define B_AX_MACID31_0_SLEEP_SH 0
#define B_AX_MACID31_0_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_1 0xC2C4
#define R_AX_MACID_SLEEP_1_C1 0xE2C4
#define B_AX_MACID63_32_SLEEP_SH 0
#define B_AX_MACID63_32_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_2 0xC2C8
#define R_AX_MACID_SLEEP_2_C1 0xE2C8
#define B_AX_MACID95_64_SLEEP_SH 0
#define B_AX_MACID95_64_SLEEP_MSK 0xffffffffL

#define R_AX_MACID_SLEEP_3 0xC2CC
#define R_AX_MACID_SLEEP_3_C1 0xE2CC
#define B_AX_MACID127_96_SLEEP_SH 0
#define B_AX_MACID127_96_SLEEP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_0 0xC2E0
#define R_AX_CMAC_MACID_DROP_0_C1 0xE2E0
#define B_AX_CMAC_MACID31_0_DROP_SH 0
#define B_AX_CMAC_MACID31_0_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_1 0xC2E4
#define R_AX_CMAC_MACID_DROP_1_C1 0xE2E4
#define B_AX_CMAC_MACID63_32_DROP_SH 0
#define B_AX_CMAC_MACID63_32_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_2 0xC2E8
#define R_AX_CMAC_MACID_DROP_2_C1 0xE2E8
#define B_AX_CMAC_MACID95_64_DROP_SH 0
#define B_AX_CMAC_MACID95_64_DROP_MSK 0xffffffffL

#define R_AX_CMAC_MACID_DROP_3 0xC2EC
#define R_AX_CMAC_MACID_DROP_3_C1 0xE2EC
#define B_AX_CMAC_MACID127_96_DROP_SH 0
#define B_AX_CMAC_MACID127_96_DROP_MSK 0xffffffffL

#define R_AX_EDCA_BE_PARAM_0 0xC300
#define R_AX_EDCA_BE_PARAM_0_C1 0xE300
#define B_AX_BE_0_TXOPLMT_SH 16
#define B_AX_BE_0_TXOPLMT_MSK 0x7ff
#define B_AX_BE_0_CW_SH 8
#define B_AX_BE_0_CW_MSK 0xff
#define B_AX_BE_0_AIFS_SH 0
#define B_AX_BE_0_AIFS_MSK 0xff

#define R_AX_EDCA_BK_PARAM_0 0xC304
#define R_AX_EDCA_BK_PARAM_0_C1 0xE304
#define B_AX_BK_0_TXOPLMT_SH 16
#define B_AX_BK_0_TXOPLMT_MSK 0x7ff
#define B_AX_BK_0_CW_SH 8
#define B_AX_BK_0_CW_MSK 0xff
#define B_AX_BK_0_AIFS_SH 0
#define B_AX_BK_0_AIFS_MSK 0xff

#define R_AX_EDCA_VI_PARAM_0 0xC308
#define R_AX_EDCA_VI_PARAM_0_C1 0xE308
#define B_AX_VI_0_TXOPLMT_SH 16
#define B_AX_VI_0_TXOPLMT_MSK 0x7ff
#define B_AX_VI_0_CW_SH 8
#define B_AX_VI_0_CW_MSK 0xff
#define B_AX_VI_0_AIFS_SH 0
#define B_AX_VI_0_AIFS_MSK 0xff

#define R_AX_EDCA_VO_PARAM_0 0xC30C
#define R_AX_EDCA_VO_PARAM_0_C1 0xE30C
#define B_AX_VO_0_TXOPLMT_SH 16
#define B_AX_VO_0_TXOPLMT_MSK 0x7ff
#define B_AX_VO_0_CW_SH 8
#define B_AX_VO_0_CW_MSK 0xff
#define B_AX_VO_0_AIFS_SH 0
#define B_AX_VO_0_AIFS_MSK 0xff

#define R_AX_EDCA_BE_PARAM_1 0xC310
#define R_AX_EDCA_BE_PARAM_1_C1 0xE310
#define B_AX_BE_1_TXOPLMT_SH 16
#define B_AX_BE_1_TXOPLMT_MSK 0x7ff
#define B_AX_BE_1_CW_SH 8
#define B_AX_BE_1_CW_MSK 0xff
#define B_AX_BE_1_AIFS_SH 0
#define B_AX_BE_1_AIFS_MSK 0xff

#define R_AX_EDCA_BK_PARAM_1 0xC314
#define R_AX_EDCA_BK_PARAM_1_C1 0xE314
#define B_AX_BK_1_TXOPLMT_SH 16
#define B_AX_BK_1_TXOPLMT_MSK 0x7ff
#define B_AX_BK_1_CW_SH 8
#define B_AX_BK_1_CW_MSK 0xff
#define B_AX_BK_1_AIFS_SH 0
#define B_AX_BK_1_AIFS_MSK 0xff

#define R_AX_EDCA_VI_PARAM_1 0xC318
#define R_AX_EDCA_VI_PARAM_1_C1 0xE318
#define B_AX_VI_1_TXOPLMT_SH 16
#define B_AX_VI_1_TXOPLMT_MSK 0x7ff
#define B_AX_VI_1_CW_SH 8
#define B_AX_VI_1_CW_MSK 0xff
#define B_AX_VI_1_AIFS_SH 0
#define B_AX_VI_1_AIFS_MSK 0xff

#define R_AX_EDCA_VO_PARAM_1 0xC31C
#define R_AX_EDCA_VO_PARAM_1_C1 0xE31C
#define B_AX_VO_1_TXOPLMT_SH 16
#define B_AX_VO_1_TXOPLMT_MSK 0x7ff
#define B_AX_VO_1_CW_SH 8
#define B_AX_VO_1_CW_MSK 0xff
#define B_AX_VO_1_AIFS_SH 0
#define B_AX_VO_1_AIFS_MSK 0xff

#define R_AX_EDCA_MGQ_PARAM 0xC320
#define R_AX_EDCA_MGQ_PARAM_C1 0xE320
#define B_AX_CPUMGQ_CW_SH 24
#define B_AX_CPUMGQ_CW_MSK 0xff
#define B_AX_CPUMGQ_AIFS_SH 16
#define B_AX_CPUMGQ_AIFS_MSK 0xff
#define B_AX_MGQ_CW_SH 8
#define B_AX_MGQ_CW_MSK 0xff
#define B_AX_MGQ_AIFS_SH 0
#define B_AX_MGQ_AIFS_MSK 0xff

#define R_AX_EDCA_BCNQ_PARAM 0xC324
#define R_AX_EDCA_BCNQ_PARAM_C1 0xE324
#define B_AX_BCNQ_CW_SH 24
#define B_AX_BCNQ_CW_MSK 0xff
#define B_AX_BCNQ_AIFS_SH 16
#define B_AX_BCNQ_AIFS_MSK 0xff
#define B_AX_FORCE_BCN_IFS_SH 8
#define B_AX_FORCE_BCN_IFS_MSK 0xff
#define B_AX_PIFS_SH 0
#define B_AX_PIFS_MSK 0xff

#define R_AX_EDCA_ULQ_PARAM 0xC328
#define R_AX_EDCA_ULQ_PARAM_C1 0xE328
#define B_AX_ULQ_TXOPLMT_SH 16
#define B_AX_ULQ_TXOPLMT_MSK 0x7ff
#define B_AX_ULQ_CW_SH 8
#define B_AX_ULQ_CW_MSK 0xff
#define B_AX_ULQ_AIFS_SH 0
#define B_AX_ULQ_AIFS_MSK 0xff

#define R_AX_EDCA_TWT_PARAM_0 0xC32C
#define R_AX_EDCA_TWT_PARAM_0_C1 0xE32C
#define B_AX_TWT_0_TXOPLMT_SH 16
#define B_AX_TWT_0_TXOPLMT_MSK 0x7ff
#define B_AX_TWT_0_CW_SH 8
#define B_AX_TWT_0_CW_MSK 0xff
#define B_AX_TWT_0_AIFS_SH 0
#define B_AX_TWT_0_AIFS_MSK 0xff

#define R_AX_EDCA_TWT_PARAM_1 0xC330
#define R_AX_EDCA_TWT_PARAM_1_C1 0xE330
#define B_AX_TWT_1_TXOPLMT_SH 16
#define B_AX_TWT_1_TXOPLMT_MSK 0x7ff
#define B_AX_TWT_1_CW_SH 8
#define B_AX_TWT_1_CW_MSK 0xff
#define B_AX_TWT_1_AIFS_SH 0
#define B_AX_TWT_1_AIFS_MSK 0xff

#define R_AX_SLOTTIME_CFG 0xC334
#define R_AX_SLOTTIME_CFG_C1 0xE334
#define B_AX_SLOT_TIME_SH 0
#define B_AX_SLOT_TIME_MSK 0xff

#define R_AX_PREBKF_CFG_0 0xC338
#define R_AX_PREBKF_CFG_0_C1 0xE338
#define B_AX_100NS_TIME_SH 24
#define B_AX_100NS_TIME_MSK 0x1f
#define B_AX_RX_AIR_END_TIME_SH 16
#define B_AX_RX_AIR_END_TIME_MSK 0x7f
#define B_AX_MACTX_LATENCY_SH 8
#define B_AX_MACTX_LATENCY_MSK 0x3f
#define B_AX_PREBKF_TIME_SH 0
#define B_AX_PREBKF_TIME_MSK 0xff

#define R_AX_PREBKF_CFG_1 0xC33C
#define R_AX_PREBKF_CFG_1_C1 0xE33C
#define B_AX_SIFS_PREBKF_SH 16
#define B_AX_SIFS_PREBKF_MSK 0xff
#define B_AX_SIFS_TIMEOUT_T2_SH 8
#define B_AX_SIFS_TIMEOUT_T2_MSK 0x7f
#define B_AX_SIFS_MACTXEN_T1_SH 0
#define B_AX_SIFS_MACTXEN_T1_MSK 0x7f

#define R_AX_CCA_CFG_0 0xC340
#define R_AX_CCA_CFG_0_C1 0xE340
#define B_AX_R_SIFS_AGGR_TIME_SH 24
#define B_AX_R_SIFS_AGGR_TIME_MSK 0x7f
#define B_AX_BTCCA_BRK_TXOP_EN BIT(9)
#define B_AX_NAV_BRK_TXOP_EN BIT(8)
#define B_AX_TX_NAV_EN BIT(7)
#define B_AX_BCN_IGNORE_EDCCA BIT(6)
#define B_AX_BTCCA_EN BIT(5)
#define B_AX_EDCCA_EN BIT(4)
#define B_AX_SEC80_EN BIT(3)
#define B_AX_SEC40_EN BIT(2)
#define B_AX_SEC20_EN BIT(1)
#define B_AX_CCA_EN BIT(0)

#define R_AX_MISC_0 0xC344
#define R_AX_MISC_0_C1 0xE344
#define B_AX_RST_FREERUN_P BIT(15)
#define B_AX_EN_FREERUN BIT(8)
#define B_AX_EN_TBTT_AREA_FOR_AX_BB BIT(0)

#define R_AX_CTN_TXEN 0xC348
#define R_AX_CTN_TXEN_C1 0xE348
#define B_AX_CTN_TXEN_TWT_1 BIT(15)
#define B_AX_CTN_TXEN_TWT_0 BIT(14)
#define B_AX_CTN_TXEN_ULQ BIT(13)
#define B_AX_CTN_TXEN_BCNQ BIT(12)
#define B_AX_CTN_TXEN_HGQ BIT(11)
#define B_AX_CTN_TXEN_CPUMGQ BIT(10)
#define B_AX_CTN_TXEN_MGQ1 BIT(9)
#define B_AX_CTN_TXEN_MGQ BIT(8)
#define B_AX_CTN_TXEN_VO_1 BIT(7)
#define B_AX_CTN_TXEN_VI_1 BIT(6)
#define B_AX_CTN_TXEN_BK_1 BIT(5)
#define B_AX_CTN_TXEN_BE_1 BIT(4)
#define B_AX_CTN_TXEN_VO_0 BIT(3)
#define B_AX_CTN_TXEN_VI_0 BIT(2)
#define B_AX_CTN_TXEN_BK_0 BIT(1)
#define B_AX_CTN_TXEN_BE_0 BIT(0)

#define R_AX_CTN_CFG_0 0xC34C
#define R_AX_CTN_CFG_0_C1 0xE34C
#define B_AX_NAV_BLK_HGQ BIT(1)
#define B_AX_NAV_BLK_MGQ BIT(0)

#define R_AX_MUEDCA_BE_PARAM_0 0xC350
#define R_AX_MUEDCA_BE_PARAM_0_C1 0xE350
#define B_AX_MUEDCA_BE_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_BE_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_BE_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_BE_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_BE_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_BE_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_BK_PARAM_0 0xC354
#define R_AX_MUEDCA_BK_PARAM_0_C1 0xE354
#define B_AX_MUEDCA_BK_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_BK_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_BK_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_BK_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_BK_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_BK_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_VI_PARAM_0 0xC358
#define R_AX_MUEDCA_VI_PARAM_0_C1 0xE358
#define B_AX_MUEDCA_VI_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_VI_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_VI_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_VI_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_VI_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_VI_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_VO_PARAM_0 0xC35C
#define R_AX_MUEDCA_VO_PARAM_0_C1 0xE35C
#define B_AX_MUEDCA_VO_PARAM_0_TIMER_SH 16
#define B_AX_MUEDCA_VO_PARAM_0_TIMER_MSK 0xffff
#define B_AX_MUEDCA_VO_PARAM_0_CW_SH 8
#define B_AX_MUEDCA_VO_PARAM_0_CW_MSK 0xff
#define B_AX_MUEDCA_VO_PARAM_0_AIFS_SH 0
#define B_AX_MUEDCA_VO_PARAM_0_AIFS_MSK 0xff

#define R_AX_MUEDCA_EN 0xC370
#define R_AX_MUEDCA_EN_C1 0xE370
#define B_AX_MUEDCA_WMM_SEL BIT(8)
#define B_AX_SET_MUEDCATIMER_TF_0 BIT(4)
#define B_AX_MUEDCA_EN_0 BIT(0)

#define R_AX_RAND_SCR_BIT 0xC374
#define R_AX_RAND_SCR_BIT_C1 0xE374
#define B_AX_RAND_SCBITS_SH 0
#define B_AX_RAND_SCBITS_MSK 0x7fffff

#define R_AX_RANDOM_CFG 0xC378
#define R_AX_RANDOM_CFG_C1 0xE378
#define B_AX_RAND_SET_SH 0
#define B_AX_RAND_SET_MSK 0xffffff

#define R_AX_MUEDCATIMER_0 0xC380
#define R_AX_MUEDCATIMER_0_C1 0xE380
#define B_AX_MUEDCATIMER_BK_0_SH 16
#define B_AX_MUEDCATIMER_BK_0_MSK 0xffff
#define B_AX_MUEDCATIMER_BE_0_SH 0
#define B_AX_MUEDCATIMER_BE_0_MSK 0xffff

#define R_AX_MUEDCATIMER_1 0xC384
#define R_AX_MUEDCATIMER_1_C1 0xE384
#define B_AX_MUEDCATIMER_VO_0_SH 16
#define B_AX_MUEDCATIMER_VO_0_MSK 0xffff
#define B_AX_MUEDCATIMER_VI_0_SH 0
#define B_AX_MUEDCATIMER_VI_0_MSK 0xffff

#define R_AX_CCA_CONTROL 0xC390
#define R_AX_CCA_CONTROL_C1 0xE390
#define B_AX_TB_CHK_TX_NAV BIT(31)
#define B_AX_TB_CHK_BASIC_NAV BIT(30)
#define B_AX_TB_CHK_BTCCA BIT(29)
#define B_AX_TB_CHK_EDCCA BIT(28)
#define B_AX_TB_CHK_CCA_S80 BIT(27)
#define B_AX_TB_CHK_CCA_S40 BIT(26)
#define B_AX_TB_CHK_CCA_S20 BIT(25)
#define B_AX_TB_CHK_CCA_P20 BIT(24)
#define B_AX_SIFS_CHK_BTCCA BIT(21)
#define B_AX_SIFS_CHK_EDCCA BIT(20)
#define B_AX_SIFS_CHK_CCA_S80 BIT(19)
#define B_AX_SIFS_CHK_CCA_S40 BIT(18)
#define B_AX_SIFS_CHK_CCA_S20 BIT(17)
#define B_AX_SIFS_CHK_CCA_P20 BIT(16)
#define B_AX_CTN_CHK_TXNAV BIT(8)
#define B_AX_CTN_CHK_INTRA_NAV BIT(7)
#define B_AX_CTN_CHK_BASIC_NAV BIT(6)
#define B_AX_CTN_CHK_BTCCA BIT(5)
#define B_AX_CTN_CHK_EDCCA BIT(4)
#define B_AX_CTN_CHK_CCA_S80 BIT(3)
#define B_AX_CTN_CHK_CCA_S40 BIT(2)
#define B_AX_CTN_CHK_CCA_S20 BIT(1)
#define B_AX_CTN_CHK_CCA_P20 BIT(0)

#define R_AX_SCHEDULE_ERR_IMR 0xC3E8
#define R_AX_SCHEDULE_ERR_IMR_C1 0xE3E8
#define B_AX_SORT_NON_IDLE_ERR_INT_EN BIT(1)
#define B_AX_FSM_TIMEOUT_ERR_INT_EN BIT(0)

#define R_AX_SCHEDULE_ERR_ISR 0xC3EC
#define R_AX_SCHEDULE_ERR_ISR_C1 0xE3EC
#define B_AX_SORT_NON_IDLE_ERR_INT BIT(1)
#define B_AX_FSM_TIMEOUT_ERR_INT BIT(0)

#define R_AX_SCH_DBG_SEL 0xC3F4
#define R_AX_SCH_DBG_SEL_C1 0xE3F4
#define B_AX_SCH_DBG_EN BIT(16)
#define B_AX_SCH_CFG_CMD_SEL_SH 8
#define B_AX_SCH_CFG_CMD_SEL_MSK 0xff
#define B_AX_SCH_DBG_SEL_SH 0
#define B_AX_SCH_DBG_SEL_MSK 0xff

#define R_AX_SCH_DBG 0xC3F8
#define R_AX_SCH_DBG_C1 0xE3F8
#define B_AX_SCHEDULER_DBG_SH 0
#define B_AX_SCHEDULER_DBG_MSK 0xffffffffL

#define R_AX_SCH_EXT_CTRL 0xC3FC
#define R_AX_SCH_EXT_CTRL_C1 0xE3FC
#define B_AX_PORT_RST_TSF_ADV BIT(1)
#define B_AX_SCH_RESP_CTRL BIT(0)

#define R_AX_PORT_CFG_P0 0xC400
#define R_AX_PORT_CFG_P0_C1 0xE400
#define B_AX_BRK_SETUP_P0 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P0 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P0 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P0 BIT(13)
#define B_AX_BCNTX_EN_P0 BIT(12)
#define B_AX_NET_TYPE_P0_SH 10
#define B_AX_NET_TYPE_P0_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P0 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P0 BIT(8)
#define B_AX_BCNERR_CNT_EN_P0 BIT(7)
#define B_AX_BCN_AGRES_P0 BIT(6)
#define B_AX_TSFTR_RST_P0 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P0 BIT(4)
#define B_AX_TSF_UDT_EN_P0 BIT(3)
#define B_AX_PORT_FUNC_EN_P0 BIT(2)
#define B_AX_TXBCN_RPT_EN_P0 BIT(1)
#define B_AX_RXBCN_RPT_EN_P0 BIT(0)

#define R_AX_TBTT_PROHIB_P0 0xC404
#define R_AX_TBTT_PROHIB_P0_C1 0xE404
#define B_AX_TBTT_HOLD_P0_SH 16
#define B_AX_TBTT_HOLD_P0_MSK 0xfff
#define B_AX_TBTT_SETUP_P0_SH 0
#define B_AX_TBTT_SETUP_P0_MSK 0xff

#define R_AX_BCN_AREA_P0 0xC408
#define R_AX_BCN_AREA_P0_C1 0xE408
#define B_AX_BCN_MSK_AREA_P0_SH 16
#define B_AX_BCN_MSK_AREA_P0_MSK 0xfff
#define B_AX_BCN_CTN_AREA_P0_SH 0
#define B_AX_BCN_CTN_AREA_P0_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P0 0xC40C
#define R_AX_BCNERLYINT_CFG_P0_C1 0xE40C
#define B_AX_BCNERLY_P0_SH 0
#define B_AX_BCNERLY_P0_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P0 0xC40E
#define R_AX_TBTTERLYINT_CFG_P0_C1 0xE40E
#define B_AX_TBTTERLY_P0_SH 0
#define B_AX_TBTTERLY_P0_MSK 0xfff

#define R_AX_TBTT_AGG_P0 0xC412
#define R_AX_TBTT_AGG_P0_C1 0xE412
#define B_AX_TBTT_AGG_NUM_P0_SH 8
#define B_AX_TBTT_AGG_NUM_P0_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P0 0xC414
#define R_AX_BCN_SPACE_CFG_P0_C1 0xE414
#define B_AX_SUB_BCN_SPACE_P0_SH 16
#define B_AX_SUB_BCN_SPACE_P0_MSK 0xff
#define B_AX_BCN_SPACE_P0_SH 0
#define B_AX_BCN_SPACE_P0_MSK 0xffff

#define R_AX_BCN_FORCETX_P0 0xC418
#define R_AX_BCN_FORCETX_P0_C1 0xE418
#define B_AX_FORCE_BCN_CURRCNT_P0_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P0_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P0_SH 8
#define B_AX_FORCE_BCN_NUM_P0_MSK 0xff
#define B_AX_BCN_MAX_ERR_P0_SH 0
#define B_AX_BCN_MAX_ERR_P0_MSK 0xff

#define R_AX_BCN_ERR_CNT_P0 0xC420
#define R_AX_BCN_ERR_CNT_P0_C1 0xE420
#define B_AX_BCN_ERR_CNT_SUM_P0_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P0_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P0_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P0_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P0_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P0_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P0_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P0_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P0 0xC424
#define R_AX_BCN_ERR_FLAG_P0_C1 0xE424
#define B_AX_BCN_ERR_FLAG_OTHERS_P0 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P0 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P0 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P0 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P0 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P0 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P0 BIT(0)

#define R_AX_DTIM_CTRL_P0 0xC426
#define R_AX_DTIM_CTRL_P0_C1 0xE426
#define B_AX_DTIM_NUM_P0_SH 8
#define B_AX_DTIM_NUM_P0_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0_SH 0
#define B_AX_DTIM_CURRCNT_P0_MSK 0xff

#define R_AX_TBTT_SHIFT_P0 0xC428
#define R_AX_TBTT_SHIFT_P0_C1 0xE428
#define B_AX_TBTT_SHIFT_OFST_P0_SH 0
#define B_AX_TBTT_SHIFT_OFST_P0_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P0 0xC434
#define R_AX_BCN_CNT_TMR_P0_C1 0xE434
#define B_AX_BCN_CNT_TMR_P0_SH 0
#define B_AX_BCN_CNT_TMR_P0_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P0 0xC438
#define R_AX_TSFTR_LOW_P0_C1 0xE438
#define B_AX_TSFTR_LOW_P0_SH 0
#define B_AX_TSFTR_LOW_P0_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P0 0xC43C
#define R_AX_TSFTR_HIGH_P0_C1 0xE43C
#define B_AX_TSFTR_HIGH_P0_SH 0
#define B_AX_TSFTR_HIGH_P0_MSK 0xffffffffL

#define R_AX_PORT_CFG_P1 0xC440
#define R_AX_PORT_CFG_P1_C1 0xE440
#define B_AX_BRK_SETUP_P1 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P1 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P1 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P1 BIT(13)
#define B_AX_BCNTX_EN_P1 BIT(12)
#define B_AX_NET_TYPE_P1_SH 10
#define B_AX_NET_TYPE_P1_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P1 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P1 BIT(8)
#define B_AX_BCNERR_CNT_EN_P1 BIT(7)
#define B_AX_BCN_AGRES_P1 BIT(6)
#define B_AX_TSFTR_RST_P1 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P1 BIT(4)
#define B_AX_TSF_UDT_EN_P1 BIT(3)
#define B_AX_PORT_FUNC_EN_P1 BIT(2)
#define B_AX_TXBCN_RPT_EN_P1 BIT(1)
#define B_AX_RXBCN_RPT_EN_P1 BIT(0)

#define R_AX_TBTT_PROHIB_P1 0xC444
#define R_AX_TBTT_PROHIB_P1_C1 0xE444
#define B_AX_TBTT_HOLD_P1_SH 16
#define B_AX_TBTT_HOLD_P1_MSK 0xfff
#define B_AX_TBTT_SETUP_P1_SH 0
#define B_AX_TBTT_SETUP_P1_MSK 0xff

#define R_AX_BCN_AREA_P1 0xC448
#define R_AX_BCN_AREA_P1_C1 0xE448
#define B_AX_BCN_MSK_AREA_P1_SH 16
#define B_AX_BCN_MSK_AREA_P1_MSK 0xfff
#define B_AX_BCN_CTN_AREA_P1_SH 0
#define B_AX_BCN_CTN_AREA_P1_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P1 0xC44C
#define R_AX_BCNERLYINT_CFG_P1_C1 0xE44C
#define B_AX_BCNERLY_P1_SH 0
#define B_AX_BCNERLY_P1_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P1 0xC44E
#define R_AX_TBTTERLYINT_CFG_P1_C1 0xE44E
#define B_AX_TBTTERLY_P1_SH 0
#define B_AX_TBTTERLY_P1_MSK 0xfff

#define R_AX_TBTT_AGG_P1 0xC452
#define R_AX_TBTT_AGG_P1_C1 0xE452
#define B_AX_TBTT_AGG_NUM_P1_SH 8
#define B_AX_TBTT_AGG_NUM_P1_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P1 0xC454
#define R_AX_BCN_SPACE_CFG_P1_C1 0xE454
#define B_AX_BCN_SPACE_P1_SH 0
#define B_AX_BCN_SPACE_P1_MSK 0xffff

#define R_AX_BCN_FORCETX_P1 0xC458
#define R_AX_BCN_FORCETX_P1_C1 0xE458
#define B_AX_FORCE_BCN_CURRCNT_P1_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P1_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P1_SH 8
#define B_AX_FORCE_BCN_NUM_P1_MSK 0xff
#define B_AX_BCN_MAX_ERR_P1_SH 0
#define B_AX_BCN_MAX_ERR_P1_MSK 0xff

#define R_AX_BCN_ERR_CNT_P1 0xC460
#define R_AX_BCN_ERR_CNT_P1_C1 0xE460
#define B_AX_BCN_ERR_CNT_SUM_P1_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P1_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P1_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P1_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P1_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P1_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P1_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P1_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P1 0xC464
#define R_AX_BCN_ERR_FLAG_P1_C1 0xE464
#define B_AX_BCN_ERR_FLAG_OTHERS_P1 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P1 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P1 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P1 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P1 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P1 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P1 BIT(0)

#define R_AX_DTIM_CTRL_P1 0xC466
#define R_AX_DTIM_CTRL_P1_C1 0xE466
#define B_AX_DTIM_NUM_P1_SH 8
#define B_AX_DTIM_NUM_P1_MSK 0xff
#define B_AX_DTIM_CURRCNT_P1_SH 0
#define B_AX_DTIM_CURRCNT_P1_MSK 0xff

#define R_AX_TBTT_SHIFT_P1 0xC468
#define R_AX_TBTT_SHIFT_P1_C1 0xE468
#define B_AX_TBTT_SHIFT_OFST_P1_SH 0
#define B_AX_TBTT_SHIFT_OFST_P1_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P1 0xC474
#define R_AX_BCN_CNT_TMR_P1_C1 0xE474
#define B_AX_BCN_CNT_TMR_P1_SH 0
#define B_AX_BCN_CNT_TMR_P1_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P1 0xC478
#define R_AX_TSFTR_LOW_P1_C1 0xE478
#define B_AX_TSFTR_LOW_P1_SH 0
#define B_AX_TSFTR_LOW_P1_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P1 0xC47C
#define R_AX_TSFTR_HIGH_P1_C1 0xE47C
#define B_AX_TSFTR_HIGH_P1_SH 0
#define B_AX_TSFTR_HIGH_P1_MSK 0xffffffffL

#define R_AX_PORT_CFG_P2 0xC480
#define R_AX_PORT_CFG_P2_C1 0xE480
#define B_AX_BRK_SETUP_P2 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P2 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P2 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P2 BIT(13)
#define B_AX_BCNTX_EN_P2 BIT(12)
#define B_AX_NET_TYPE_P2_SH 10
#define B_AX_NET_TYPE_P2_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P2 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P2 BIT(8)
#define B_AX_BCNERR_CNT_EN_P2 BIT(7)
#define B_AX_BCN_AGRES_P2 BIT(6)
#define B_AX_TSFTR_RST_P2 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P2 BIT(4)
#define B_AX_TSF_UDT_EN_P2 BIT(3)
#define B_AX_PORT_FUNC_EN_P2 BIT(2)
#define B_AX_TXBCN_RPT_EN_P2 BIT(1)
#define B_AX_RXBCN_RPT_EN_P2 BIT(0)

#define R_AX_BCN_AREA_P2 0xC488
#define R_AX_BCN_AREA_P2_C1 0xE488
#define B_AX_BCN_MSK_AREA_P2_SH 16
#define B_AX_BCN_MSK_AREA_P2_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P2 0xC48C
#define R_AX_BCNERLYINT_CFG_P2_C1 0xE48C
#define B_AX_BCNERLY_P2_SH 0
#define B_AX_BCNERLY_P2_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P2 0xC48E
#define R_AX_TBTTERLYINT_CFG_P2_C1 0xE48E
#define B_AX_TBTTERLY_P2_SH 0
#define B_AX_TBTTERLY_P2_MSK 0xfff

#define R_AX_TBTT_AGG_P2 0xC492
#define R_AX_TBTT_AGG_P2_C1 0xE492
#define B_AX_TBTT_AGG_NUM_P2_SH 8
#define B_AX_TBTT_AGG_NUM_P2_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P2 0xC494
#define R_AX_BCN_SPACE_CFG_P2_C1 0xE494
#define B_AX_BCN_SPACE_P2_SH 0
#define B_AX_BCN_SPACE_P2_MSK 0xffff

#define R_AX_BCN_FORCETX_P2 0xC498
#define R_AX_BCN_FORCETX_P2_C1 0xE498
#define B_AX_FORCE_BCN_CURRCNT_P2_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P2_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P2_SH 8
#define B_AX_FORCE_BCN_NUM_P2_MSK 0xff
#define B_AX_BCN_MAX_ERR_P2_SH 0
#define B_AX_BCN_MAX_ERR_P2_MSK 0xff

#define R_AX_BCN_ERR_CNT_P2 0xC4A0
#define R_AX_BCN_ERR_CNT_P2_C1 0xE4A0
#define B_AX_BCN_ERR_CNT_SUM_P2_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P2_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P2_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P2_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P2_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P2_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P2_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P2_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P2 0xC4A4
#define R_AX_BCN_ERR_FLAG_P2_C1 0xE4A4
#define B_AX_BCN_ERR_FLAG_OTHERS_P2 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P2 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P2 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P2 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P2 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P2 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P2 BIT(0)

#define R_AX_DTIM_CTRL_P2 0xC4A6
#define R_AX_DTIM_CTRL_P2_C1 0xE4A6
#define B_AX_DTIM_NUM_P2_SH 8
#define B_AX_DTIM_NUM_P2_MSK 0xff
#define B_AX_DTIM_CURRCNT_P2_SH 0
#define B_AX_DTIM_CURRCNT_P2_MSK 0xff

#define R_AX_TBTT_SHIFT_P2 0xC4A8
#define R_AX_TBTT_SHIFT_P2_C1 0xE4A8
#define B_AX_TBTT_SHIFT_OFST_P2_SH 0
#define B_AX_TBTT_SHIFT_OFST_P2_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P2 0xC4B4
#define R_AX_BCN_CNT_TMR_P2_C1 0xE4B4
#define B_AX_BCN_CNT_TMR_P2_SH 0
#define B_AX_BCN_CNT_TMR_P2_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P2 0xC4B8
#define R_AX_TSFTR_LOW_P2_C1 0xE4B8
#define B_AX_TSFTR_LOW_P2_SH 0
#define B_AX_TSFTR_LOW_P2_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P2 0xC4BC
#define R_AX_TSFTR_HIGH_P2_C1 0xE4BC
#define B_AX_TSFTR_HIGH_P2_SH 0
#define B_AX_TSFTR_HIGH_P2_MSK 0xffffffffL

#define R_AX_PORT_CFG_P3 0xC4C0
#define R_AX_PORT_CFG_P3_C1 0xE4C0
#define B_AX_BRK_SETUP_P3 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P3 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P3 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P3 BIT(13)
#define B_AX_BCNTX_EN_P3 BIT(12)
#define B_AX_NET_TYPE_P3_SH 10
#define B_AX_NET_TYPE_P3_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P3 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P3 BIT(8)
#define B_AX_BCNERR_CNT_EN_P3 BIT(7)
#define B_AX_BCN_AGRES_P3 BIT(6)
#define B_AX_TSFTR_RST_P3 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P3 BIT(4)
#define B_AX_TSF_UDT_EN_P3 BIT(3)
#define B_AX_PORT_FUNC_EN_P3 BIT(2)
#define B_AX_TXBCN_RPT_EN_P3 BIT(1)
#define B_AX_RXBCN_RPT_EN_P3 BIT(0)

#define R_AX_BCN_AREA_P3 0xC4C8
#define R_AX_BCN_AREA_P3_C1 0xE4C8
#define B_AX_BCN_MSK_AREA_P3_SH 16
#define B_AX_BCN_MSK_AREA_P3_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P3 0xC4CC
#define R_AX_BCNERLYINT_CFG_P3_C1 0xE4CC
#define B_AX_BCNERLY_P3_SH 0
#define B_AX_BCNERLY_P3_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P3 0xC4CE
#define R_AX_TBTTERLYINT_CFG_P3_C1 0xE4CE
#define B_AX_TBTTERLY_P3_SH 0
#define B_AX_TBTTERLY_P3_MSK 0xfff

#define R_AX_TBTT_AGG_P3 0xC4D2
#define R_AX_TBTT_AGG_P3_C1 0xE4D2
#define B_AX_TBTT_AGG_NUM_P3_SH 8
#define B_AX_TBTT_AGG_NUM_P3_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P3 0xC4D4
#define R_AX_BCN_SPACE_CFG_P3_C1 0xE4D4
#define B_AX_BCN_SPACE_P3_SH 0
#define B_AX_BCN_SPACE_P3_MSK 0xffff

#define R_AX_BCN_FORCETX_P3 0xC4D8
#define R_AX_BCN_FORCETX_P3_C1 0xE4D8
#define B_AX_FORCE_BCN_CURRCNT_P3_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P3_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P3_SH 8
#define B_AX_FORCE_BCN_NUM_P3_MSK 0xff
#define B_AX_BCN_MAX_ERR_P3_SH 0
#define B_AX_BCN_MAX_ERR_P3_MSK 0xff

#define R_AX_BCN_ERR_CNT_P3 0xC4E0
#define R_AX_BCN_ERR_CNT_P3_C1 0xE4E0
#define B_AX_BCN_ERR_CNT_SUM_P3_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P3_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P3_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P3_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P3_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P3_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P3_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P3_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P3 0xC4E4
#define R_AX_BCN_ERR_FLAG_P3_C1 0xE4E4
#define B_AX_BCN_ERR_FLAG_OTHERS_P3 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P3 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P3 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P3 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P3 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P3 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P3 BIT(0)

#define R_AX_DTIM_CTRL_P3 0xC4E6
#define R_AX_DTIM_CTRL_P3_C1 0xE4E6
#define B_AX_DTIM_NUM_P3_SH 8
#define B_AX_DTIM_NUM_P3_MSK 0xff
#define B_AX_DTIM_CURRCNT_P3_SH 0
#define B_AX_DTIM_CURRCNT_P3_MSK 0xff

#define R_AX_TBTT_SHIFT_P3 0xC4E8
#define R_AX_TBTT_SHIFT_P3_C1 0xE4E8
#define B_AX_TBTT_SHIFT_OFST_P3_SH 0
#define B_AX_TBTT_SHIFT_OFST_P3_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P3 0xC4F4
#define R_AX_BCN_CNT_TMR_P3_C1 0xE4F4
#define B_AX_BCN_CNT_TMR_P3_SH 0
#define B_AX_BCN_CNT_TMR_P3_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P3 0xC4F8
#define R_AX_TSFTR_LOW_P3_C1 0xE4F8
#define B_AX_TSFTR_LOW_P3_SH 0
#define B_AX_TSFTR_LOW_P3_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P3 0xC4FC
#define R_AX_TSFTR_HIGH_P3_C1 0xE4FC
#define B_AX_TSFTR_HIGH_P3_SH 0
#define B_AX_TSFTR_HIGH_P3_MSK 0xffffffffL

#define R_AX_PORT_CFG_P4 0xC500
#define R_AX_PORT_CFG_P4_C1 0xE500
#define B_AX_BRK_SETUP_P4 BIT(16)
#define B_AX_TBTT_UPD_SHIFT_SEL_P4 BIT(15)
#define B_AX_BCN_DROP_ALLOW_P4 BIT(14)
#define B_AX_TBTT_PROHIB_EN_P4 BIT(13)
#define B_AX_BCNTX_EN_P4 BIT(12)
#define B_AX_NET_TYPE_P4_SH 10
#define B_AX_NET_TYPE_P4_MSK 0x3
#define B_AX_BCN_FORCETX_EN_P4 BIT(9)
#define B_AX_TXBCN_BTCCA_EN_P4 BIT(8)
#define B_AX_BCNERR_CNT_EN_P4 BIT(7)
#define B_AX_BCN_AGRES_P4 BIT(6)
#define B_AX_TSFTR_RST_P4 BIT(5)
#define B_AX_RX_BSSID_FIT_EN_P4 BIT(4)
#define B_AX_TSF_UDT_EN_P4 BIT(3)
#define B_AX_PORT_FUNC_EN_P4 BIT(2)
#define B_AX_TXBCN_RPT_EN_P4 BIT(1)
#define B_AX_RXBCN_RPT_EN_P4 BIT(0)

#define R_AX_BCN_AREA_P4 0xC508
#define R_AX_BCN_AREA_P4_C1 0xE508
#define B_AX_BCN_MSK_AREA_P4_SH 16
#define B_AX_BCN_MSK_AREA_P4_MSK 0xfff

#define R_AX_BCNERLYINT_CFG_P4 0xC50C
#define R_AX_BCNERLYINT_CFG_P4_C1 0xE50C
#define B_AX_BCNERLY_P4_SH 0
#define B_AX_BCNERLY_P4_MSK 0xfff

#define R_AX_TBTTERLYINT_CFG_P4 0xC50E
#define R_AX_TBTTERLYINT_CFG_P4_C1 0xE50E
#define B_AX_TBTTERLY_P4_SH 0
#define B_AX_TBTTERLY_P4_MSK 0xfff

#define R_AX_TBTT_AGG_P4 0xC512
#define R_AX_TBTT_AGG_P4_C1 0xE512
#define B_AX_TBTT_AGG_NUM_P4_SH 8
#define B_AX_TBTT_AGG_NUM_P4_MSK 0xff

#define R_AX_BCN_SPACE_CFG_P4 0xC514
#define R_AX_BCN_SPACE_CFG_P4_C1 0xE514
#define B_AX_BCN_SPACE_P4_SH 0
#define B_AX_BCN_SPACE_P4_MSK 0xffff

#define R_AX_BCN_FORCETX_P4 0xC518
#define R_AX_BCN_FORCETX_P4_C1 0xE518
#define B_AX_FORCE_BCN_CURRCNT_P4_SH 16
#define B_AX_FORCE_BCN_CURRCNT_P4_MSK 0xff
#define B_AX_FORCE_BCN_NUM_P4_SH 8
#define B_AX_FORCE_BCN_NUM_P4_MSK 0xff
#define B_AX_BCN_MAX_ERR_P4_SH 0
#define B_AX_BCN_MAX_ERR_P4_MSK 0xff

#define R_AX_BCN_ERR_CNT_P4 0xC520
#define R_AX_BCN_ERR_CNT_P4_C1 0xE520
#define B_AX_BCN_ERR_CNT_SUM_P4_SH 24
#define B_AX_BCN_ERR_CNT_SUM_P4_MSK 0xff
#define B_AX_BCN_ERR_CNT_NAV_P4_SH 16
#define B_AX_BCN_ERR_CNT_NAV_P4_MSK 0xff
#define B_AX_BCN_ERR_CNT_EDCCA_P4_SH 8
#define B_AX_BCN_ERR_CNT_EDCCA_P4_MSK 0xff
#define B_AX_BCN_ERR_CNT_CCA_P4_SH 0
#define B_AX_BCN_ERR_CNT_CCA_P4_MSK 0xff

#define R_AX_BCN_ERR_FLAG_P4 0xC524
#define R_AX_BCN_ERR_FLAG_P4_C1 0xE524
#define B_AX_BCN_ERR_FLAG_OTHERS_P4 BIT(6)
#define B_AX_BCN_ERR_FLAG_MAC_P4 BIT(5)
#define B_AX_BCN_ERR_FLAG_TXON_P4 BIT(4)
#define B_AX_BCN_ERR_FLAG_SRCHEND_P4 BIT(3)
#define B_AX_BCN_ERR_FLAG_INVALID_P4 BIT(2)
#define B_AX_BCN_ERR_FLAG_CMP_P4 BIT(1)
#define B_AX_BCN_ERR_FLAG_LOCK_P4 BIT(0)

#define R_AX_DTIM_CTRL_P4 0xC526
#define R_AX_DTIM_CTRL_P4_C1 0xE526
#define B_AX_DTIM_NUM_P4_SH 8
#define B_AX_DTIM_NUM_P4_MSK 0xff
#define B_AX_DTIM_CURRCNT_P4_SH 0
#define B_AX_DTIM_CURRCNT_P4_MSK 0xff

#define R_AX_TBTT_SHIFT_P4 0xC528
#define R_AX_TBTT_SHIFT_P4_C1 0xE528
#define B_AX_TBTT_SHIFT_OFST_P4_SH 0
#define B_AX_TBTT_SHIFT_OFST_P4_MSK 0xfff

#define R_AX_BCN_CNT_TMR_P4 0xC534
#define R_AX_BCN_CNT_TMR_P4_C1 0xE534
#define B_AX_BCN_CNT_TMR_P4_SH 0
#define B_AX_BCN_CNT_TMR_P4_MSK 0xffffffffL

#define R_AX_TSFTR_LOW_P4 0xC538
#define R_AX_TSFTR_LOW_P4_C1 0xE538
#define B_AX_TSFTR_LOW_P4_SH 0
#define B_AX_TSFTR_LOW_P4_MSK 0xffffffffL

#define R_AX_TSFTR_HIGH_P4 0xC53C
#define R_AX_TSFTR_HIGH_P4_C1 0xE53C
#define B_AX_TSFTR_HIGH_P4_SH 0
#define B_AX_TSFTR_HIGH_P4_MSK 0xffffffffL

#define R_AX_DTIM_NUM0 0xC540
#define R_AX_DTIM_NUM0_C1 0xE540
#define B_AX_DTIM_NUM_P0MB3_SH 24
#define B_AX_DTIM_NUM_P0MB3_MSK 0xff
#define B_AX_DTIM_NUM_P0MB2_SH 16
#define B_AX_DTIM_NUM_P0MB2_MSK 0xff
#define B_AX_DTIM_NUM_P0MB1_SH 8
#define B_AX_DTIM_NUM_P0MB1_MSK 0xff

#define R_AX_DTIM_NUM1 0xC544
#define R_AX_DTIM_NUM1_C1 0xE544
#define B_AX_DTIM_NUM_P0MB7_SH 24
#define B_AX_DTIM_NUM_P0MB7_MSK 0xff
#define B_AX_DTIM_NUM_P0MB6_SH 16
#define B_AX_DTIM_NUM_P0MB6_MSK 0xff
#define B_AX_DTIM_NUM_P0MB5_SH 8
#define B_AX_DTIM_NUM_P0MB5_MSK 0xff
#define B_AX_DTIM_NUM_P0MB4_SH 0
#define B_AX_DTIM_NUM_P0MB4_MSK 0xff

#define R_AX_DTIM_NUM2 0xC548
#define R_AX_DTIM_NUM2_C1 0xE548
#define B_AX_DTIM_NUM_P0MB11_SH 24
#define B_AX_DTIM_NUM_P0MB11_MSK 0xff
#define B_AX_DTIM_NUM_P0MB10_SH 16
#define B_AX_DTIM_NUM_P0MB10_MSK 0xff
#define B_AX_DTIM_NUM_P0MB9_SH 8
#define B_AX_DTIM_NUM_P0MB9_MSK 0xff
#define B_AX_DTIM_NUM_P0MB8_SH 0
#define B_AX_DTIM_NUM_P0MB8_MSK 0xff

#define R_AX_DTIM_NUM3 0xC54C
#define R_AX_DTIM_NUM3_C1 0xE54C
#define B_AX_DTIM_NUM_P0MB15_SH 24
#define B_AX_DTIM_NUM_P0MB15_MSK 0xff
#define B_AX_DTIM_NUM_P0MB14_SH 16
#define B_AX_DTIM_NUM_P0MB14_MSK 0xff
#define B_AX_DTIM_NUM_P0MB13_SH 8
#define B_AX_DTIM_NUM_P0MB13_MSK 0xff
#define B_AX_DTIM_NUM_P0MB12_SH 0
#define B_AX_DTIM_NUM_P0MB12_MSK 0xff

#define R_AX_DTIM_CURRCNT0 0xC550
#define R_AX_DTIM_CURRCNT0_C1 0xE550
#define B_AX_DTIM_CURRCNT_P0MB3_SH 24
#define B_AX_DTIM_CURRCNT_P0MB3_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB2_SH 16
#define B_AX_DTIM_CURRCNT_P0MB2_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB1_SH 8
#define B_AX_DTIM_CURRCNT_P0MB1_MSK 0xff

#define R_AX_DTIM_CURRCNT1 0xC554
#define R_AX_DTIM_CURRCNT1_C1 0xE554
#define B_AX_DTIM_CURRCNT_P0MB7_SH 24
#define B_AX_DTIM_CURRCNT_P0MB7_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB6_SH 16
#define B_AX_DTIM_CURRCNT_P0MB6_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB5_SH 8
#define B_AX_DTIM_CURRCNT_P0MB5_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB4_SH 0
#define B_AX_DTIM_CURRCNT_P0MB4_MSK 0xff

#define R_AX_DTIM_CURRCNT2 0xC558
#define R_AX_DTIM_CURRCNT2_C1 0xE558
#define B_AX_DTIM_CURRCNT_P0MB11_SH 24
#define B_AX_DTIM_CURRCNT_P0MB11_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB10_SH 16
#define B_AX_DTIM_CURRCNT_P0MB10_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB9_SH 8
#define B_AX_DTIM_CURRCNT_P0MB9_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB8_SH 0
#define B_AX_DTIM_CURRCNT_P0MB8_MSK 0xff

#define R_AX_DTIM_CURRCNT3 0xC55C
#define R_AX_DTIM_CURRCNT3_C1 0xE55C
#define B_AX_DTIM_CURRCNT_P0MB15_SH 24
#define B_AX_DTIM_CURRCNT_P0MB15_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB14_SH 16
#define B_AX_DTIM_CURRCNT_P0MB14_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB13_SH 8
#define B_AX_DTIM_CURRCNT_P0MB13_MSK 0xff
#define B_AX_DTIM_CURRCNT_P0MB12_SH 0
#define B_AX_DTIM_CURRCNT_P0MB12_MSK 0xff

#define R_AX_BCN_DROP_ALL0 0xC560
#define R_AX_BCN_DROP_ALL0_C1 0xE560
#define B_AX_BCN_DROP_ALL_P4 BIT(4)
#define B_AX_BCN_DROP_ALL_P3 BIT(3)
#define B_AX_BCN_DROP_ALL_P2 BIT(2)
#define B_AX_BCN_DROP_ALL_P1 BIT(1)
#define B_AX_BCN_DROP_ALL_P0 BIT(0)

#define R_AX_BCN_DROP_ALL0_P0MB 0xC564
#define R_AX_BCN_DROP_ALL0_P0MB_C1 0xE564
#define B_AX_BCN_DROP_ALL_P0MB15 BIT(15)
#define B_AX_BCN_DROP_ALL_P0MB14 BIT(14)
#define B_AX_BCN_DROP_ALL_P0MB13 BIT(13)
#define B_AX_BCN_DROP_ALL_P0MB12 BIT(12)
#define B_AX_BCN_DROP_ALL_P0MB11 BIT(11)
#define B_AX_BCN_DROP_ALL_P0MB10 BIT(10)
#define B_AX_BCN_DROP_ALL_P0MB9 BIT(9)
#define B_AX_BCN_DROP_ALL_P0MB8 BIT(8)
#define B_AX_BCN_DROP_ALL_P0MB7 BIT(7)
#define B_AX_BCN_DROP_ALL_P0MB6 BIT(6)
#define B_AX_BCN_DROP_ALL_P0MB5 BIT(5)
#define B_AX_BCN_DROP_ALL_P0MB4 BIT(4)
#define B_AX_BCN_DROP_ALL_P0MB3 BIT(3)
#define B_AX_BCN_DROP_ALL_P0MB2 BIT(2)
#define B_AX_BCN_DROP_ALL_P0MB1 BIT(1)

#define R_AX_MBSSID_CTRL 0xC568
#define R_AX_MBSSID_CTRL_C1 0xE568
#define B_AX_P0MB_NUM_SH 16
#define B_AX_P0MB_NUM_MSK 0xff
#define B_AX_P0MB15_EN BIT(15)
#define B_AX_P0MB14_EN BIT(14)
#define B_AX_P0MB13_EN BIT(13)
#define B_AX_P0MB12_EN BIT(12)
#define B_AX_P0MB11_EN BIT(11)
#define B_AX_P0MB10_EN BIT(10)
#define B_AX_P0MB9_EN BIT(9)
#define B_AX_P0MB8_EN BIT(8)
#define B_AX_P0MB7_EN BIT(7)
#define B_AX_P0MB6_EN BIT(6)
#define B_AX_P0MB5_EN BIT(5)
#define B_AX_P0MB4_EN BIT(4)
#define B_AX_P0MB3_EN BIT(3)
#define B_AX_P0MB2_EN BIT(2)
#define B_AX_P0MB1_EN BIT(1)

#define R_AX_RXTSF_OFST 0xC570
#define R_AX_RXTSF_OFST_C1 0xE570
#define B_AX_RXTSF_OFST_OFDM_SH 8
#define B_AX_RXTSF_OFST_OFDM_MSK 0xff
#define B_AX_RXTSF_OFST_CCK_SH 0
#define B_AX_RXTSF_OFST_CCK_MSK 0xff

#define R_AX_RXBCN_TIME_CTRL 0xC574
#define R_AX_RXBCN_TIME_CTRL_C1 0xE574
#define B_AX_RXBCN_TIME_PORT_SH 28
#define B_AX_RXBCN_TIME_PORT_MSK 0x7
#define B_AX_RXBCN_TIME_VLD BIT(17)
#define B_AX_RXBCN_TIME_UDFW BIT(16)
#define B_AX_RXBCN_TIME_DIFF_SH 0
#define B_AX_RXBCN_TIME_DIFF_MSK 0xffff

#define R_AX_RXBCN_TIME_SYNC 0xC578
#define R_AX_RXBCN_TIME_SYNC_C1 0xE578
#define B_AX_RXBCN_TIME_SYNC_SH 0
#define B_AX_RXBCN_TIME_SYNC_MSK 0xffffffffL

#define R_AX_TBTT_TSF_INFO 0xC57C
#define R_AX_TBTT_TSF_INFO_C1 0xE57C
#define B_AX_TBTT_TSF_INFO_SH 0
#define B_AX_TBTT_TSF_INFO_MSK 0xffffffffL

#define R_AX_P0MB_HGQ_WINDOW_CFG_0 0xC590
#define R_AX_P0MB_HGQ_WINDOW_CFG_0_C1 0xE590
#define B_AX_HGQWND_3_SH 24
#define B_AX_HGQWND_3_MSK 0xff
#define B_AX_HGQWND_2_SH 16
#define B_AX_HGQWND_2_MSK 0xff
#define B_AX_HGQWND_1_SH 8
#define B_AX_HGQWND_1_MSK 0xff
#define B_AX_HGQWND_0_SH 0
#define B_AX_HGQWND_0_MSK 0xff

#define R_AX_P0MB_HGQ_WINDOW_CFG_1 0xC594
#define R_AX_P0MB_HGQ_WINDOW_CFG_1_C1 0xE594
#define B_AX_HGQWND_7_SH 24
#define B_AX_HGQWND_7_MSK 0xff
#define B_AX_HGQWND_6_SH 16
#define B_AX_HGQWND_6_MSK 0xff
#define B_AX_HGQWND_5_SH 8
#define B_AX_HGQWND_5_MSK 0xff
#define B_AX_HGQWND_4_SH 0
#define B_AX_HGQWND_4_MSK 0xff

#define R_AX_P0MB_HGQ_WINDOW_CFG_2 0xC598
#define R_AX_P0MB_HGQ_WINDOW_CFG_2_C1 0xE598
#define B_AX_HGQWND_11_SH 24
#define B_AX_HGQWND_11_MSK 0xff
#define B_AX_HGQWND_10_SH 16
#define B_AX_HGQWND_10_MSK 0xff
#define B_AX_HGQWND_9_SH 8
#define B_AX_HGQWND_9_MSK 0xff
#define B_AX_HGQWND_8_SH 0
#define B_AX_HGQWND_8_MSK 0xff

#define R_AX_P0MB_HGQ_WINDOW_CFG_3 0xC59C
#define R_AX_P0MB_HGQ_WINDOW_CFG_3_C1 0xE59C
#define B_AX_HGQWND_15_SH 24
#define B_AX_HGQWND_15_MSK 0xff
#define B_AX_HGQWND_14_SH 16
#define B_AX_HGQWND_14_MSK 0xff
#define B_AX_HGQWND_13_SH 8
#define B_AX_HGQWND_13_MSK 0xff
#define B_AX_HGQWND_12_SH 0
#define B_AX_HGQWND_12_MSK 0xff

#define R_AX_PORT_HGQ_WINDOW_CFG 0xC5A0
#define R_AX_PORT_HGQ_WINDOW_CFG_C1 0xE5A0
#define B_AX_HGQWND_19_SH 24
#define B_AX_HGQWND_19_MSK 0xff
#define B_AX_HGQWND_18_SH 16
#define B_AX_HGQWND_18_MSK 0xff
#define B_AX_HGQWND_17_SH 8
#define B_AX_HGQWND_17_MSK 0xff
#define B_AX_HGQWND_16_SH 0
#define B_AX_HGQWND_16_MSK 0xff

#define R_AX_EN_HGQ_NOLIMIT 0xC5A4
#define R_AX_EN_HGQ_NOLIMIT_C1 0xE5A4
#define B_AX_HIQ_NO_LMT_EN_P4 BIT(19)
#define B_AX_HIQ_NO_LMT_EN_P3 BIT(18)
#define B_AX_HIQ_NO_LMT_EN_P2 BIT(17)
#define B_AX_HIQ_NO_LMT_EN_P1 BIT(16)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP15 BIT(15)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP14 BIT(14)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP13 BIT(13)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP12 BIT(12)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP11 BIT(11)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP10 BIT(10)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP9 BIT(9)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP8 BIT(8)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP7 BIT(7)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP6 BIT(6)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP5 BIT(5)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP4 BIT(4)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP3 BIT(3)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP2 BIT(2)
#define B_AX_HIQ_NO_LMT_EN_P0_VAP1 BIT(1)
#define B_AX_HIQ_NO_LMT_EN_P0_ROOT BIT(0)

#define R_AX_LPS_RX_PERIOD_CTRL 0xC5B8
#define R_AX_LPS_RX_PERIOD_CTRL_C1 0xE5B8
#define B_AX_RXBCN_PERIOD_SH 16
#define B_AX_RXBCN_PERIOD_MSK 0xff
#define B_AX_CAT_PERIOD_SH 8
#define B_AX_CAT_PERIOD_MSK 0xff
#define B_AX_LPS_RX_CTRL_EN BIT(3)
#define B_AX_LPS_PORT_SEL_SH 0
#define B_AX_LPS_PORT_SEL_MSK 0x7

#define R_AX_LPS_BCN_CNT 0xC5BC
#define R_AX_LPS_BCN_CNT_C1 0xE5BC
#define B_AX_BCN_TO_ACC_CNT_SH 24
#define B_AX_BCN_TO_ACC_CNT_MSK 0xff
#define B_AX_BCN_OK_ACC_CNT_SH 16
#define B_AX_BCN_OK_ACC_CNT_MSK 0xff
#define B_AX_BCN_TO_CNT_THD_SH 8
#define B_AX_BCN_TO_CNT_THD_MSK 0xff
#define B_AX_BCN_TO_CNT_SH 0
#define B_AX_BCN_TO_CNT_MSK 0xff

#define R_AX_FREERUN_CNT_LOW 0xC5C0
#define R_AX_FREERUN_CNT_LOW_C1 0xE5C0
#define B_AX_FREERUN_CNT_LOW_SH 0
#define B_AX_FREERUN_CNT_LOW_MSK 0xffffffffL

#define R_AX_FREERUN_CNT_HIGH 0xC5C4
#define R_AX_FREERUN_CNT_HIGH_C1 0xE5C4
#define B_AX_FREERUN_CNT_HIGH_SH 0
#define B_AX_FREERUN_CNT_HIGH_MSK 0xffffffffL

#define R_AX_PSTIMER0 0xC5CC
#define R_AX_PSTIMER0_C1 0xE5CC
#define B_AX_PSTIMER0_VAL_SH 0
#define B_AX_PSTIMER0_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER1 0xC23D
#define R_AX_PSTIMER1_C1 0xE23D
#define B_AX_PSTIMER1_VAL_SH 0
#define B_AX_PSTIMER1_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER2 0xC5D4
#define R_AX_PSTIMER2_C1 0xE5D4
#define B_AX_PSTIMER2_VAL_SH 0
#define B_AX_PSTIMER2_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER3 0xC5D8
#define R_AX_PSTIMER3_C1 0xE5D8
#define B_AX_PSTIMER3_VAL_SH 0
#define B_AX_PSTIMER3_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER4 0xC5DC
#define R_AX_PSTIMER4_C1 0xE5DC
#define B_AX_PSTIMER4_VAL_SH 0
#define B_AX_PSTIMER4_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER5 0xC5E0
#define R_AX_PSTIMER5_C1 0xE5E0
#define B_AX_PSTIMER5_VAL_SH 0
#define B_AX_PSTIMER5_VAL_MSK 0xffffffffL

#define R_AX_PSTIMER_CTRL 0xC5E4
#define R_AX_PSTIMER_CTRL_C1 0xE5E4
#define B_AX_PSTIMER5_EN BIT(23)
#define B_AX_PSTIMER5_SEL_SH 20
#define B_AX_PSTIMER5_SEL_MSK 0x7
#define B_AX_PSTIMER4_EN BIT(19)
#define B_AX_PSTIMER4_SEL_SH 16
#define B_AX_PSTIMER4_SEL_MSK 0x7
#define B_AX_PSTIMER3_EN BIT(15)
#define B_AX_PSTIMER3_SEL_SH 12
#define B_AX_PSTIMER3_SEL_MSK 0x7
#define B_AX_PSTIMER2_EN BIT(11)
#define B_AX_PSTIMER2_SEL_SH 8
#define B_AX_PSTIMER2_SEL_MSK 0x7
#define B_AX_PSTIMER1_EN BIT(7)
#define B_AX_PSTIMER1_SEL_SH 4
#define B_AX_PSTIMER1_SEL_MSK 0x7
#define B_AX_PSTIMER0_EN BIT(3)
#define B_AX_PSTIMER0_SEL_SH 0
#define B_AX_PSTIMER0_SEL_MSK 0x7

#define R_AX_TIMER_COMPARE 0xC5E8
#define R_AX_TIMER_COMPARE_C1 0xE5E8
#define B_AX_X_COMP_Y_TSFT_P BIT(7)
#define B_AX_Y_COMP_SEL_SH 4
#define B_AX_Y_COMP_SEL_MSK 0x7
#define B_AX_X_COMP_Y_OVER BIT(3)
#define B_AX_X_COMP_SEL_SH 0
#define B_AX_X_COMP_SEL_MSK 0x7

#define R_AX_TIMER_COMPARE_VALUE_LOW 0xC5EC
#define R_AX_TIMER_COMPARE_VALUE_LOW_C1 0xE5EC
#define B_AX_X_COMP_Y_VAL_LOW_SH 0
#define B_AX_X_COMP_Y_VAL_LOW_MSK 0xffffffffL

#define R_AX_TIMER_COMPARE_VALUE_HIGH 0xC5F0
#define R_AX_TIMER_COMPARE_VALUE_HIGH_C1 0xE5F0
#define B_AX_X_COMP_Y_VAL_HIGH_SH 0
#define B_AX_X_COMP_Y_VAL_HIGH_MSK 0xffffffffL

//
// PTCL
//

#define R_AX_PTCL_COMMON_SETTING_0 0xC600
#define R_AX_PTCL_COMMON_SETTING_0_C1 0xE600
#define B_AX_CPUMGQ_LIFETIME_EN BIT(8)
#define B_AX_MGQ_LIFETIME_EN BIT(7)
#define B_AX_LIFETIME_EN BIT(6)
#define B_AX_PTCL_TRIGGER_SS_EN_UL BIT(4)
#define B_AX_PTCL_TRIGGER_SS_EN_1 BIT(3)
#define B_AX_PTCL_TRIGGER_SS_EN_0 BIT(2)
#define B_AX_CMAC_TX_MODE_1 BIT(1)
#define B_AX_CMAC_TX_MODE_0 BIT(0)

#define R_AX_AGG_BK_0 0xC604
#define R_AX_AGG_BK_0_C1 0xE604
#define B_AX_DIS_SND_STS_CHECK BIT(7)
#define B_AX_NAV_PAUS_PHB_EN BIT(6)
#define B_AX_TXOP_SHT_PHB_EN BIT(5)
#define B_AX_AGG_BRK_PHB_EN BIT(4)
#define B_AX_DIS_SSN_CHK BIT(3)
#define B_AX_WDBK_CFG BIT(2)
#define B_AX_EN_RTY_BK BIT(1)
#define B_AX_EN_RTY_BK_COD BIT(0)

#define R_AX_TX_CTRL 0xC608
#define R_AX_TX_CTRL_C1 0xE608
#define B_AX_DROP_CHK_MAX_NUM_SH 24
#define B_AX_DROP_CHK_MAX_NUM_MSK 0xff
#define B_AX_DROP_CHK_TIMEOUT_SH 20
#define B_AX_DROP_CHK_TIMEOUT_MSK 0xf
#define B_AX_FWD_SRCH_TIMEOUT_SH 16
#define B_AX_FWD_SRCH_TIMEOUT_MSK 0xf
#define B_AX_PTCL_STOP_WMM BIT(7)
#define B_AX_TXOP_DELAY_TX_SH 0
#define B_AX_TXOP_DELAY_TX_MSK 0x1f

#define R_AX_TB_PPDU_CTRL 0xC60C
#define R_AX_TB_PPDU_CTRL_C1 0xE60C
#define B_AX_TB_PPDU_BK_DIS BIT(15)
#define B_AX_TB_PPDU_BE_DIS BIT(14)
#define B_AX_TB_PPDU_VI_DIS BIT(13)
#define B_AX_TB_PPDU_VO_DIS BIT(12)
#define B_AX_TB_BYPASS_TXPWR BIT(2)
#define B_AX_SW_PREFER_AC_SH 0
#define B_AX_SW_PREFER_AC_MSK 0x3

#define R_AX_AMPDU_AGG_LIMIT 0xC610
#define R_AX_AMPDU_AGG_LIMIT_C1 0xE610
#define B_AX_AMPDU_MAX_TIME_SH 24
#define B_AX_AMPDU_MAX_TIME_MSK 0xff
#define B_AX_RA_TRY_RATE_AGG_LMT_SH 16
#define B_AX_RA_TRY_RATE_AGG_LMT_MSK 0xff
#define B_AX_RTS_MAX_AGG_NUM_SH 8
#define B_AX_RTS_MAX_AGG_NUM_MSK 0xff
#define B_AX_MAX_AGG_NUM_SH 0
#define B_AX_MAX_AGG_NUM_MSK 0xff

#define R_AX_AGG_LEN_HT_0 0xC614
#define R_AX_AGG_LEN_HT_0_C1 0xE614
#define B_AX_AMPDU_MAX_LEN_HT_SH 16
#define B_AX_AMPDU_MAX_LEN_HT_MSK 0xffff
#define B_AX_RTS_TXTIME_TH_SH 8
#define B_AX_RTS_TXTIME_TH_MSK 0xff
#define B_AX_RTS_LEN_TH_SH 0
#define B_AX_RTS_LEN_TH_MSK 0xff

#define R_AX_AGG_LEN_VHT_0 0xC618
#define R_AX_AGG_LEN_VHT_0_C1 0xE618
#define B_AX_AMPDU_MAX_LEN_VHT_SH 0
#define B_AX_AMPDU_MAX_LEN_VHT_MSK 0xfffff

#define R_AX_AGG_LEN_HE_0 0xC61C
#define R_AX_AGG_LEN_HE_0_C1 0xE61C
#define B_AX_AMPDU_MAX_LEN_HE_SH 0
#define B_AX_AMPDU_MAX_LEN_HE_MSK 0x7fffff

#define R_AX_SPECIAL_TX_SETTING 0xC620
#define R_AX_SPECIAL_TX_SETTING_C1 0xE620
#define B_AX_USE_DATA_BW BIT(29)
#define B_AX_BW_SIGTA_SH 27
#define B_AX_BW_SIGTA_MSK 0x3
#define B_AX_BMC_NAV_PROTECT BIT(26)
#define B_AX_STBC_CFEND_SH 18
#define B_AX_STBC_CFEND_MSK 0x3
#define B_AX_STBC_CFEND_RATE_SH 9
#define B_AX_STBC_CFEND_RATE_MSK 0x1ff
#define B_AX_BASIC_CFEND_RATE_SH 0
#define B_AX_BASIC_CFEND_RATE_MSK 0x1ff

#define R_AX_SIFS_SETTING 0xC624
#define R_AX_SIFS_SETTING_C1 0xE624
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_SH 24
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_MSK 0xff
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_TWW_SH 18
#define B_AX_HW_CTS2SELF_PKT_LEN_TH_TWW_MSK 0x3f
#define B_AX_HW_CTS2SELF_EN BIT(16)
#define B_AX_SPEC_SIFS_OFDM_PTCL_SH 8
#define B_AX_SPEC_SIFS_OFDM_PTCL_MSK 0xff
#define B_AX_SPEC_SIFS_CCK_PTCL_SH 0
#define B_AX_SPEC_SIFS_CCK_PTCL_MSK 0xff

#define R_AX_TXRATE_CHK 0xC628
#define R_AX_TXRATE_CHK_C1 0xE628
#define B_AX_DEFT_RATE_SH 7
#define B_AX_DEFT_RATE_MSK 0x1ff
#define B_AX_BAND_MODE BIT(4)
#define B_AX_MAX_TXNSS_SH 2
#define B_AX_MAX_TXNSS_MSK 0x3
#define B_AX_RTS_LIMIT_IN_OFDM6 BIT(1)
#define B_AX_CHECK_CCK_EN BIT(0)

#define R_AX_TXCNT 0xC62C
#define R_AX_TXCNT_C1 0xE62C
#define B_AX_ADD_TXCNT_BY BIT(31)
#define B_AX_S_TXCNT_LMT_SH 24
#define B_AX_S_TXCNT_LMT_MSK 0x3f
#define B_AX_L_TXCNT_LMT_SH 16
#define B_AX_L_TXCNT_LMT_MSK 0x3f

#define R_AX_LIFETIME_0 0xC630
#define R_AX_LIFETIME_0_C1 0xE630
#define B_AX_PKT_LIFETIME_2_SH 16
#define B_AX_PKT_LIFETIME_2_MSK 0xffff
#define B_AX_PKT_LIFETIME_1_SH 0
#define B_AX_PKT_LIFETIME_1_MSK 0xffff

#define R_AX_LIFETIME_1 0xC634
#define R_AX_LIFETIME_1_C1 0xE634
#define B_AX_PKT_LIFETIME_4_SH 16
#define B_AX_PKT_LIFETIME_4_MSK 0xffff
#define B_AX_PKT_LIFETIME_3_SH 0
#define B_AX_PKT_LIFETIME_3_MSK 0xffff

#define R_AX_LIFETIME_2 0xC638
#define R_AX_LIFETIME_2_C1 0xE638
#define B_AX_CPUMGQ_LIFETIME_SH 16
#define B_AX_CPUMGQ_LIFETIME_MSK 0xffff
#define B_AX_MGQ_LIFETIME_SH 0
#define B_AX_MGQ_LIFETIME_MSK 0xffff

#define R_AX_MBSSID_DROP_0 0xC63C
#define R_AX_MBSSID_DROP_0_C1 0xE63C
#define B_AX_GI_LTF_FB_SEL BIT(30)
#define B_AX_RATE_SEL_SH 24
#define B_AX_RATE_SEL_MSK 0x3f
#define B_AX_PORT_DROP_4_0_SH 16
#define B_AX_PORT_DROP_4_0_MSK 0x1f
#define B_AX_MBSSID_DROP_15_0_SH 0
#define B_AX_MBSSID_DROP_15_0_MSK 0xffff

#define R_AX_ARFR_WT_0 0xC640
#define R_AX_ARFR_WT_0_C1 0xE640
#define B_AX_RATE7_WEIGHTING_SH 28
#define B_AX_RATE7_WEIGHTING_MSK 0xf
#define B_AX_RATE6_WEIGHTING_SH 24
#define B_AX_RATE6_WEIGHTING_MSK 0xf
#define B_AX_RATE5_WEIGHTING_SH 20
#define B_AX_RATE5_WEIGHTING_MSK 0xf
#define B_AX_RATE4_WEIGHTING_SH 16
#define B_AX_RATE4_WEIGHTING_MSK 0xf
#define B_AX_RATE3_WEIGHTING_SH 12
#define B_AX_RATE3_WEIGHTING_MSK 0xf
#define B_AX_RATE2_WEIGHTING_SH 8
#define B_AX_RATE2_WEIGHTING_MSK 0xf
#define B_AX_RATE1_WEIGHTING_SH 4
#define B_AX_RATE1_WEIGHTING_MSK 0xf
#define B_AX_RATE0_WEIGHTING_SH 0
#define B_AX_RATE0_WEIGHTING_MSK 0xf

#define R_AX_DARF_TC 0xC648
#define R_AX_DARF_TC_C1 0xE648
#define B_AX_DARF_TC9_SH 28
#define B_AX_DARF_TC9_MSK 0xf
#define B_AX_DARF_TC8_SH 24
#define B_AX_DARF_TC8_MSK 0xf
#define B_AX_DARF_TC7_SH 20
#define B_AX_DARF_TC7_MSK 0xf
#define B_AX_DARF_TC6_SH 16
#define B_AX_DARF_TC6_MSK 0xf
#define B_AX_DARF_TC5_SH 12
#define B_AX_DARF_TC5_MSK 0xf
#define B_AX_DARF_TC4_SH 8
#define B_AX_DARF_TC4_MSK 0xf
#define B_AX_DARF_TC3_SH 4
#define B_AX_DARF_TC3_MSK 0xf
#define B_AX_DARF_TC2_SH 0
#define B_AX_DARF_TC2_MSK 0xf

#define R_AX_DARF1_TC 0xC64C
#define R_AX_DARF1_TC_C1 0xE64C
#define B_AX_DARF1_TC9_SH 28
#define B_AX_DARF1_TC9_MSK 0xf
#define B_AX_DARF1_TC8_SH 24
#define B_AX_DARF1_TC8_MSK 0xf
#define B_AX_DARF1_TC7_SH 20
#define B_AX_DARF1_TC7_MSK 0xf
#define B_AX_DARF1_TC6_SH 16
#define B_AX_DARF1_TC6_MSK 0xf
#define B_AX_DARF1_TC5_SH 12
#define B_AX_DARF1_TC5_MSK 0xf
#define B_AX_DARF1_TC4_SH 8
#define B_AX_DARF1_TC4_MSK 0xf
#define B_AX_DARF1_TC3_SH 4
#define B_AX_DARF1_TC3_MSK 0xf
#define B_AX_DARF1_TC2_SH 0
#define B_AX_DARF1_TC2_MSK 0xf

#define R_AX_RARF_TC 0xC650
#define R_AX_RARF_TC_C1 0xE650
#define B_AX_RARF_TC9_SH 28
#define B_AX_RARF_TC9_MSK 0xf
#define B_AX_RARF_TC8_SH 24
#define B_AX_RARF_TC8_MSK 0xf
#define B_AX_RARF_TC7_SH 20
#define B_AX_RARF_TC7_MSK 0xf
#define B_AX_RARF_TC6_SH 16
#define B_AX_RARF_TC6_MSK 0xf
#define B_AX_RARF_TC5_SH 12
#define B_AX_RARF_TC5_MSK 0xf
#define B_AX_RARF_TC4_SH 8
#define B_AX_RARF_TC4_MSK 0xf
#define B_AX_RARF_TC3_SH 4
#define B_AX_RARF_TC3_MSK 0xf
#define B_AX_RARF_TC2_SH 0
#define B_AX_RARF_TC2_MSK 0xf

#define R_AX_PTCL_ATM 0xC654
#define R_AX_PTCL_ATM_C1 0xE654
#define B_AX_CHNL_REF_RX_BASIC_NAV BIT(31)
#define B_AX_CHNL_REF_RX_INTRA_NAV BIT(30)
#define B_AX_CHNL_REF_DATA_ON BIT(29)
#define B_AX_CHNL_REF_EDCCA_P20 BIT(28)
#define B_AX_CHNL_REF_CCA_P20 BIT(27)
#define B_AX_CHNL_REF_CCA_S20 BIT(26)
#define B_AX_CHNL_REF_CCA_S40 BIT(25)
#define B_AX_CHNL_REF_CCA_S80 BIT(24)
#define B_AX_CHNL_REF_PHY_TXON BIT(23)
#define B_AX_RST_CHNL_BUSY BIT(19)
#define B_AX_RST_CHNL_IDLE BIT(18)
#define B_AX_CHNL_INFO_EN BIT(17)
#define B_AX_ATM_AIRTIME_EN BIT(16)
#define B_AX_ATM_TF_UD BIT(12)
#define B_AX_ATM_SR_UD_1_SH 10
#define B_AX_ATM_SR_UD_1_MSK 0x3
#define B_AX_ATM_SR_UD_0_SH 8
#define B_AX_ATM_SR_UD_0_MSK 0x3
#define B_AX_ATM_TB_UD_1_SH 6
#define B_AX_ATM_TB_UD_1_MSK 0x3
#define B_AX_ATM_TB_UD_0_SH 4
#define B_AX_ATM_TB_UD_0_MSK 0x3
#define B_AX_ATM_TX_UD_1_SH 2
#define B_AX_ATM_TX_UD_1_MSK 0x3
#define B_AX_ATM_TX_UD_0_SH 0
#define B_AX_ATM_TX_UD_0_MSK 0x3

#define R_AX_CHNL_IDLE_TIME_0 0xC658
#define R_AX_CHNL_IDLE_TIME_0_C1 0xE658
#define B_AX_CHNL_IDLE_TIME_SH 0
#define B_AX_CHNL_IDLE_TIME_MSK 0xffffffffL

#define R_AX_CHNL_BUSY_TIME_0 0xC65C
#define R_AX_CHNL_BUSY_TIME_0_C1 0xE65C
#define B_AX_CHNL_BUSY_TIME_SH 0
#define B_AX_CHNL_BUSY_TIME_MSK 0xffffffffL

#define R_AX_PTCLRPT_FULL_HDL 0xC660
#define R_AX_PTCLRPT_FULL_HDL_C1 0xE660
#define B_AX_F2PCMD_RPT_EN BIT(8)
#define B_AX_BCN_RPT_PATH_SH 6
#define B_AX_BCN_RPT_PATH_MSK 0x3
#define B_AX_SPE_RPT_PATH_SH 4
#define B_AX_SPE_RPT_PATH_MSK 0x3
#define B_AX_TX_RPT_PATH_SH 2
#define B_AX_TX_RPT_PATH_MSK 0x3
#define B_AX_F2PCMDRPT_FULL_DROP BIT(1)
#define B_AX_NON_F2PCMDRPT_FULL_DROP BIT(0)

#define R_AX_PTCL_TXOP_BK 0xC670
#define R_AX_PTCL_TXOP_BK_C1 0xE670
#define B_AX_DIS_TXOP_CFE BIT(31)
#define B_AX_DIS_LSIG_CFE BIT(30)
#define B_AX_TXOP_BK_PKT_NUM_SH 12
#define B_AX_TXOP_BK_PKT_NUM_MSK 0x3f
#define B_AX_TXOP_BK_TX_TIME_SH 4
#define B_AX_TXOP_BK_TX_TIME_MSK 0xff
#define B_AX_TXOP_BK_EN_SH 0
#define B_AX_TXOP_BK_EN_MSK 0xf
#define B_AX_SPEC_MBA_HE_PTCL_SH 16
#define B_AX_SPEC_MBA_HE_PTCL_MSK 0xffff
#define B_AX_NAV_PROT_LEN_SH 0
#define B_AX_NAV_PROT_LEN_MSK 0xffff

#define R_AX_PROT_0 0xC674
#define R_AX_PROT_0_C1 0xE674
#define B_AX_SPEC_MBA_HE_PTCL_SH 16
#define B_AX_SPEC_MBA_HE_PTCL_MSK 0xffff
#define B_AX_NAV_PROT_LEN_SH 0
#define B_AX_NAV_PROT_LEN_MSK 0xffff

#define R_AX_PROT 0xC678
#define R_AX_PROT_C1 0xE678
#define B_AX_NAV_OVER_TXOP_EN BIT(16)
#define B_AX_NAV_PROT_LEN_CTN_MODE_SH 0
#define B_AX_NAV_PROT_LEN_CTN_MODE_MSK 0xffff

#define R_AX_BT_PLT 0xC67C
#define R_AX_BT_PLT_C1 0xE67C
#define B_AX_BT_PLT_PKT_CNT_SH 16
#define B_AX_BT_PLT_PKT_CNT_MSK 0xffff
#define B_AX_BT_PLT_RST BIT(9)
#define B_AX_PLT_EN BIT(8)
#define B_AX_RX_PLT_GNT_LTE_RX BIT(7)
#define B_AX_RX_PLT_GNT_BT_RX BIT(6)
#define B_AX_RX_PLT_GNT_BT_TX BIT(5)
#define B_AX_RX_PLT_GNT_WL BIT(4)
#define B_AX_TX_PLT_GNT_LTE_RX BIT(3)
#define B_AX_TX_PLT_GNT_BT_RX BIT(2)
#define B_AX_TX_PLT_GNT_BT_TX BIT(1)
#define B_AX_TX_PLT_GNT_WL BIT(0)

#define R_AX_TWTQ_CTRL1 0xC680
#define R_AX_TWTQ_CTRL1_C1 0xE680
#define B_AX_TWTQ_ULTRHD_SH 16
#define B_AX_TWTQ_ULTRHD_MSK 0xffff
#define B_AX_TWTQ_TXOPTRHD_SH 0
#define B_AX_TWTQ_TXOPTRHD_MSK 0xffff

#define R_AX_TWTQ_CTRL2 0xC684
#define R_AX_TWTQ_CTRL2_C1 0xE684
#define B_AX_TWTQ_AGGTRHD_SH 0
#define B_AX_TWTQ_AGGTRHD_MSK 0xffff

#define R_AX_BCNQ_CTRL 0xC690
#define R_AX_BCNQ_CTRL_C1 0xE690
#define B_AX_BCNQ_LOCK_STUS BIT(31)
#define B_AX_BCNQ_LOCK BIT(0)

#define R_AX_PTCL_BSS_COLOR_0 0xC6A0
#define R_AX_PTCL_BSS_COLOR_0_C1 0xE6A0
#define B_AX_BSS_COLOB_AX_PORT_3_SH 24
#define B_AX_BSS_COLOB_AX_PORT_3_MSK 0x3f
#define B_AX_BSS_COLOB_AX_PORT_2_SH 16
#define B_AX_BSS_COLOB_AX_PORT_2_MSK 0x3f
#define B_AX_BSS_COLOB_AX_PORT_1_SH 8
#define B_AX_BSS_COLOB_AX_PORT_1_MSK 0x3f
#define B_AX_BSS_COLOB_AX_PORT_0_SH 0
#define B_AX_BSS_COLOB_AX_PORT_0_MSK 0x3f

#define R_AX_PTCL_BSS_COLOR_1 0xC6A4
#define R_AX_PTCL_BSS_COLOR_1_C1 0xE6A4
#define B_AX_BSS_COLOB_AX_PORT_4_SH 0
#define B_AX_BSS_COLOB_AX_PORT_4_MSK 0x3f

#define R_AX_PTCL_F2P_TX_SETTING 0xC6B0
#define R_AX_PTCL_F2P_TX_SETTING_C1 0xE6B0
#define B_AX_TF_DATA_TF_LENGTH_SH 0
#define B_AX_TF_DATA_TF_LENGTH_MSK 0xff

#define R_AX_PTCL_IMR0 0xC6C0
#define R_AX_PTCL_IMR0_C1 0xE6C0
#define B_AX_F2PCMD_PKTID_ERR_INT_EN BIT(31)
#define B_AX_F2PCMD_RD_PKTID_ERR_INT_EN BIT(30)
#define B_AX_F2PCMD_ASSIGN_PKTID_ERR_INT_EN BIT(29)
#define B_AX_F2PCMD_USER_ALLC_ERR_INT_EN BIT(28)
#define B_AX_RX_SPF_U0_PKTID_ERR_INT_EN BIT(27)
#define B_AX_TX_SPF_U1_PKTID_ERR_INT_EN BIT(26)
#define B_AX_TX_SPF_U2_PKTID_ERR_INT_EN BIT(25)
#define B_AX_TX_SPF_U3_PKTID_ERR_INT_EN BIT(24)
#define B_AX_TX_RECORD_PKTID_ERR_INT_EN BIT(23)
#define B_AX_F2PCMD_EMPTY_ERR_INT_EN BIT(15)
#define B_AX_TWTSP_QSEL_ERR_INT_EN BIT(14)
#define B_AX_BCNQ_ORDER_ERR_INT_EN BIT(12)
#define B_AX_Q_PKTID_ERR_INT_EN BIT(11)
#define B_AX_D_PKTID_ERR_INT_EN BIT(10)
#define B_AX_TXPRT_FULL_DROP_ERR_INT_EN BIT(9)
#define B_AX_F2PCMDRPT_FULL_DROP_ERR_INT_EN BIT(8)
#define B_AX_FSM_TIMEOUT_ERR_INT_EN BIT(0)

#define R_AX_PTCL_ISR0 0xC6C4
#define R_AX_PTCL_ISR0_C1 0xE6C4
#define B_AX_F2PCMD_PKTID_ERR BIT(31)
#define B_AX_F2PCMD_RD_PKTID_ERR BIT(30)
#define B_AX_F2PCMD_ASSIGN_PKTID_ERR BIT(29)
#define B_AX_F2PCMD_USER_ALLC_ERR BIT(28)
#define B_AX_RX_SPF_U0_PKTID_ERR BIT(27)
#define B_AX_TX_SPF_U1_PKTID_ERR BIT(26)
#define B_AX_TX_SPF_U2_PKTID_ERR BIT(25)
#define B_AX_TX_SPF_U3_PKTID_ERR BIT(24)
#define B_AX_TX_RECORD_PKTID_ERR BIT(23)
#define B_AX_F2PCMD_EMPTY_ERR BIT(15)
#define B_AX_TWTSP_QSEL_ERR BIT(14)
#define B_AX_BCNQ_ORDER_ERR BIT(12)
#define B_AX_Q_PKTID_ERR BIT(11)
#define B_AX_D_PKTID_ERR BIT(10)
#define B_AX_TXPRT_FULL_DROP_ERR BIT(9)
#define B_AX_F2PCMDRPT_FULL_DROP_ERR BIT(8)
#define B_AX_FSM_TIMEOUT_ERR BIT(0)

#define R_AX_PTCL_RST_CTRL 0xC6E0
#define R_AX_PTCL_RST_CTRL_C1 0xE6E0
#define B_AX_PTCL_TX_FINISH_REQ_STATUS BIT(24)
#define B_AX_PTCL_WDE_EN BIT(1)
#define B_AX_PTCL_TX_FINISH_REQ BIT(0)

#define R_AX_PTCL_FSM_MON 0xC6E8
#define R_AX_PTCL_FSM_MON_C1 0xE6E8
#define B_AX_PTCL_FSM2_TO_MODE BIT(30)
#define B_AX_PTCL_FSM2_TO_THR_SH 24
#define B_AX_PTCL_FSM2_TO_THR_MSK 0x3f
#define B_AX_PTCL_FSM1_TO_MODE BIT(22)
#define B_AX_PTCL_FSM1_TO_THR_SH 16
#define B_AX_PTCL_FSM1_TO_THR_MSK 0x3f
#define B_AX_PTCL_FSM0_TO_MODE BIT(14)
#define B_AX_PTCL_FSM0_TO_THR_SH 8
#define B_AX_PTCL_FSM0_TO_THR_MSK 0x3f
#define B_AX_PTCL_TX_ARB_TO_MODE BIT(6)
#define B_AX_PTCL_TX_ARB_TO_THR_SH 0
#define B_AX_PTCL_TX_ARB_TO_THR_MSK 0x3f

#define R_AX_PTCL_TX_CTN_SEL 0xC6EC
#define R_AX_PTCL_TX_CTN_SEL_C1 0xE6EC
#define B_AX_PTCL_TX_ON_STAT BIT(7)
#define B_AX_PTCL_DROP BIT(5)
#define B_AX_PTCL_TX_QUEUE_IDX_SH 0
#define B_AX_PTCL_TX_QUEUE_IDX_MSK 0x1f

#define R_AX_PTCL_DBG_INFO 0xC6F0
#define R_AX_PTCL_DBG_INFO_C1 0xE6F0
#define B_AX_PTCL_DBG_INFO_SH 0
#define B_AX_PTCL_DBG_INFO_MSK 0xffffffffL

#define R_AX_NULL_PKT_STATUS 0xC6F6
#define R_AX_NULL_PKT_STATUS_C1 0xE6F6
#define B_AX_P4_NULL_1_STATUS BIT(9)
#define B_AX_P4_NULL_0_STATUS BIT(8)
#define B_AX_P3_NULL_1_STATUS BIT(7)
#define B_AX_P3_NULL_0_STATUS BIT(6)
#define B_AX_P2_NULL_1_STATUS BIT(5)
#define B_AX_P2_NULL_0_STATUS BIT(4)
#define B_AX_P1_NULL_1_STATUS BIT(3)
#define B_AX_P1_NULL_0_STATUS BIT(2)
#define B_AX_P0_NULL_1_STATUS BIT(1)
#define B_AX_P0_NULL_0_STATUS BIT(0)

#define R_AX_PTCL_DBG 0xC6F4
#define R_AX_PTCL_DBG_C1 0xE6F4
#define B_AX_PTCL_DBG_EN BIT(8)
#define B_AX_PTCL_DBG_SEL_SH 0
#define B_AX_PTCL_DBG_SEL_MSK 0xff

#define R_AX_PTCL_TX_MACID_0 0xC6FC
#define R_AX_PTCL_TX_MACID_0_C1 0xE6FC
#define B_AX_TX_MACID_3_SH 24
#define B_AX_TX_MACID_3_MSK 0xff
#define B_AX_TX_MACID_2_SH 16
#define B_AX_TX_MACID_2_MSK 0xff
#define B_AX_TX_MACID_1_SH 8
#define B_AX_TX_MACID_1_MSK 0xff
#define B_AX_TX_MACID_0_SH 0
#define B_AX_TX_MACID_0_MSK 0xff

//
// CMAC_DMA 8852C
//

#define R_AX_RX_CTRL2 0xC810
#define R_AX_RX_CTRL2_C1 0xE810
#define B_AX_DLE_WDE_STATE_V1_SH 30
#define B_AX_DLE_WDE_STATE_V1_MSK 0x3
#define B_AX_DLE_PLE_STATE_V1_SH 28
#define B_AX_DLE_PLE_STATE_V1_MSK 0x3
#define B_AX_DLE_REQ_BUF_STATE_SH 26
#define B_AX_DLE_REQ_BUF_STATE_MSK 0x3
#define B_AX_DLE_ENQ_STATE_V1 BIT(25)
#define B_AX_RX_DBG_SEL_SH 19
#define B_AX_RX_DBG_SEL_MSK 0x3f
#define B_AX_MACRX_CS_SH 14
#define B_AX_MACRX_CS_MSK 0x1f
#define B_AX_RXSTS_CS_SH 9
#define B_AX_RXSTS_CS_MSK 0x1f
#define B_AX_ERR_INDICATOR BIT(5)
#define B_AX_TXRPT_CS_SH 0
#define B_AX_TXRPT_CS_MSK 0x1f

#define R_AX_RX_INFO_RU0RU1 0xC814
#define R_AX_RX_INFO_RU0RU1_C1 0xE814
#define B_AX_RU1_IS_IDLE BIT(31)
#define B_AX_RU1_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU1_IS_REQ_BUF BIT(29)
#define B_AX_RU1_IS_ENQ BIT(28)
#define B_AX_RU1_WR_PKT_ID_SH 16
#define B_AX_RU1_WR_PKT_ID_MSK 0xfff
#define B_AX_RU0_IS_IDLE BIT(15)
#define B_AX_RU0_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU0_IS_REQ_BUF BIT(13)
#define B_AX_RU0_IS_ENQ BIT(12)
#define B_AX_RU0_WR_PKT_ID_SH 0
#define B_AX_RU0_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_RU2RU3 0xC818
#define R_AX_RX_INFO_RU2RU3_C1 0xE818
#define B_AX_RU3_IS_IDLE BIT(31)
#define B_AX_RU3_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU3_IS_REQ_BUF BIT(29)
#define B_AX_RU3_IS_ENQ BIT(28)
#define B_AX_RU3_WR_PKT_ID_SH 16
#define B_AX_RU3_WR_PKT_ID_MSK 0xfff
#define B_AX_RU2_IS_IDLE BIT(15)
#define B_AX_RU2_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU2_IS_REQ_BUF BIT(13)
#define B_AX_RU2_IS_ENQ BIT(12)
#define B_AX_RU2_WR_PKT_ID_SH 0
#define B_AX_RU2_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_RU4RU5 0xC81C
#define R_AX_RX_INFO_RU4RU5_C1 0xE81C
#define B_AX_RU5_IS_IDLE BIT(31)
#define B_AX_RU5_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU5_IS_REQ_BUF BIT(29)
#define B_AX_RU5_IS_ENQ BIT(28)
#define B_AX_RU5_WR_PKT_ID_SH 16
#define B_AX_RU5_WR_PKT_ID_MSK 0xfff
#define B_AX_RU4_IS_IDLE BIT(15)
#define B_AX_RU4_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU4_IS_REQ_BUF BIT(13)
#define B_AX_RU4_IS_ENQ BIT(12)
#define B_AX_RU4_WR_PKT_ID_SH 0
#define B_AX_RU4_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_RU6RU7 0xC820
#define R_AX_RX_INFO_RU6RU7_C1 0xE820
#define B_AX_RU7_IS_IDLE BIT(31)
#define B_AX_RU7_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU7_IS_REQ_BUF BIT(29)
#define B_AX_RU7_IS_ENQ BIT(28)
#define B_AX_RU7_WR_PKT_ID_SH 16
#define B_AX_RU7_WR_PKT_ID_MSK 0xfff
#define B_AX_RU6_IS_IDLE BIT(15)
#define B_AX_RU6_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU6_IS_REQ_BUF BIT(13)
#define B_AX_RU6_IS_ENQ BIT(12)
#define B_AX_RU6_WR_PKT_ID_SH 0
#define B_AX_RU6_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_F2P_TXRPT 0xC824
#define R_AX_RX_INFO_F2P_TXRPT_C1 0xE824
#define B_AX_F2PCMD_IS_IDLE_V1 BIT(31)
#define B_AX_F2PCMD_RXDATA_RECOVER_MANNUL_V1 BIT(30)
#define B_AX_F2PCMD_IS_REQ_BUF BIT(29)
#define B_AX_F2PCMD_IS_ENQ BIT(28)
#define B_AX_F2PCMD_WR_PKT_ID_V1_SH 16
#define B_AX_F2PCMD_WR_PKT_ID_V1_MSK 0xfff
#define B_AX_TXRPT_IS_IDLE_V1 BIT(15)
#define B_AX_TXRPT_RXDATA_RECOVER_MANNUL_V1 BIT(14)
#define B_AX_TXRPT_IS_REQ_BUF BIT(13)
#define B_AX_TXRPT_IS_ENQ BIT(12)
#define B_AX_TXRPT_WR_PKT_ID_V1_SH 0
#define B_AX_TXRPT_WR_PKT_ID_V1_MSK 0xfff

#define R_AX_RX_INFO_RXSTS 0xC828
#define R_AX_RX_INFO_RXSTS_C1 0xE828
#define B_AX_ENQ_FIFO_EMPTY BIT(31)
#define B_AX_CSI_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RXSTS_IS_IDLE BIT(15)
#define B_AX_RXSTS_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RXSTS_IS_REQ_BUF BIT(13)
#define B_AX_RXSTS_IS_ENQ BIT(12)
#define B_AX_RXSTS_WR_PKT_ID_SH 0
#define B_AX_RXSTS_WR_PKT_ID_MSK 0xfff

#define R_AX_RX_INFO_CSI 0xC82C
#define R_AX_RX_INFO_CSI_C1 0xE82C
#define B_AX_CSI_PKTID_1_VALID_V1 BIT(31)
#define B_AX_CSI_PKTID_1_V1_SH 16
#define B_AX_CSI_PKTID_1_V1_MSK 0xfff
#define B_AX_CSI_PKTID_0_VALID_V1 BIT(15)
#define B_AX_CSI_PKTID_0_V1_SH 0
#define B_AX_CSI_PKTID_0_V1_MSK 0xfff

//
// CMAC_DMA
//

#define R_AX_DLE_CTRL 0xC800
#define R_AX_DLE_CTRL_C1 0xE800
#define B_AX_NO_RESERVE_PAGE_ERR BIT(31)
#define B_AX_SET_NULL_PKT_ERROR BIT(30)
#define B_AX_PLE_SET_BURST_NUM_ERROR BIT(29)
#define B_AX_PLE_RESPONSE_ERROR BIT(28)
#define B_AX_PLE_OUTPUT_ERROR BIT(27)
#define B_AX_WDE_SET_BURST_NUM_ERROR BIT(26)
#define B_AX_WDE_RESPONSE_ERROR BIT(25)
#define B_AX_WDE_OUTPUT_ERROR BIT(24)
#define B_AX_NO_RESERVE_PAGE_ERR_IMR BIT(23)
#define B_AX_RXDATA_FSM_HANG_ERROR_IMR BIT(15)
#define B_AX_RXSTS_FSM_HANG_ERROR_IMR BIT(14)
#define B_AX_DLE_WDE_STATE_SH 11
#define B_AX_DLE_WDE_STATE_MSK 0x3
#define B_AX_DLE_PLE_STATE_SH 9
#define B_AX_DLE_PLE_STATE_MSK 0x3
#define B_AX_DLE_REQUEST_BUFF_STATE_SH 7
#define B_AX_DLE_REQUEST_BUFF_STATE_MSK 0x3
#define B_AX_DLE_ENQ_STATE BIT(6)
#define B_AX_RECOVERY_INDICATOR BIT(5)
#define B_AX_DLE_CLOCK_FORCE BIT(4)
#define B_AX_TXDMA_CLOCK_FORCE BIT(3)
#define B_AX_RXDMA_CLOCK_FORCE BIT(2)
#define B_AX_DMA_DBG_SEL BIT(1)
#define B_AX_PL_PAGE_128B BIT(0)

#define R_AX_RXDMA_CTRL_0 0xC804
#define R_AX_RXDMA_CTRL_0_C1 0xE804
#define B_AX_RXDMA_DBGOUT_EN BIT(31)
#define B_AX_RXDMA_DBG_SEL_SH 29
#define B_AX_RXDMA_DBG_SEL_MSK 0x3
#define B_AX_RXDMA_FIFO_DBG_SEL_SH 25
#define B_AX_RXDMA_FIFO_DBG_SEL_MSK 0xf
#define B_AX_RXDMA_BUFF_REQ_PRI_SH 19
#define B_AX_RXDMA_BUFF_REQ_PRI_MSK 0x3
#define B_AX_RXDMA_TGT_QUEID_SH 13
#define B_AX_RXDMA_TGT_QUEID_MSK 0x3f
#define B_AX_RXDMA_TGT_PRID_SH 10
#define B_AX_RXDMA_TGT_PRID_MSK 0x7
#define B_AX_RXDMA_DIS_CSI_RELEASE BIT(9)
#define B_AX_RXDMA_DIS_RXSTS_WAIT_PTR_CLR BIT(7)
#define B_AX_RXDMA_DIS_CSI_WAIT_PTR_CLR BIT(6)
#define B_AX_RXSTS_PTR_FULL_MODE BIT(5)
#define B_AX_CSI_PTR_FULL_MODE BIT(4)
#define B_AX_RU3_PTR_FULL_MODE BIT(3)
#define B_AX_RU2_PTR_FULL_MODE BIT(2)
#define B_AX_RU1_PTR_FULL_MODE BIT(1)
#define B_AX_RU0_PTR_FULL_MODE BIT(0)

#define R_AX_RXDMA_CTRL_1 0xC808
#define R_AX_RXDMA_CTRL_1_C1 0xE808
#define B_AX_F2PCMD_FULL_RSV_DEPTH_SH 28
#define B_AX_F2PCMD_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_TXRPT_FULL_RSV_DEPTH_SH 24
#define B_AX_TXRPT_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RXSTS_FULL_RSV_DEPTH_SH 20
#define B_AX_RXSTS_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_CSI_FULL_RSV_DEPTH_SH 16
#define B_AX_CSI_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU3_FULL_RSV_DEPTH_SH 12
#define B_AX_RU3_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU2_FULL_RSV_DEPTH_SH 8
#define B_AX_RU2_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU1_FULL_RSV_DEPTH_SH 4
#define B_AX_RU1_FULL_RSV_DEPTH_MSK 0xf
#define B_AX_RU0_FULL_RSV_DEPTH_SH 0
#define B_AX_RU0_FULL_RSV_DEPTH_MSK 0xf

#define R_AX_RXDMA_ERR_FLG_0 0xC80C
#define R_AX_RXDMA_ERR_FLG_0_C1 0xE80C
#define B_AX_RXDMA_ORDER_FIFO_FULL BIT(14)
#define B_AX_RXDMA_F2PCMD_PTR_OVERFLOW BIT(12)
#define B_AX_RXDMA_TXRPT_PTR_OVERFLOW BIT(11)
#define B_AX_RXDMA_RXSTS_PTR_OVERFLOW BIT(10)
#define B_AX_RXDMA_RU3_PTR_OVERFLOW BIT(9)
#define B_AX_RXDMA_RU2_PTR_OVERFLOW BIT(8)
#define B_AX_RXDMA_RU1_PTR_OVERFLOW BIT(7)
#define B_AX_RXDMA_RU0_PTR_OVERFLOW BIT(6)
#define B_AX_RXDMA_RXSTS_PTR_ERROR BIT(5)
#define B_AX_RXDMA_CSI_PTR_ERROR BIT(4)
#define B_AX_RXDMA_RU3_PTR_ERROR BIT(3)
#define B_AX_RXDMA_RU2_PTR_ERROR BIT(2)
#define B_AX_RXDMA_RU1_PTR_ERROR BIT(1)
#define B_AX_RXDMA_RU0_PTR_ERROR BIT(0)

#define R_AX_RXDMA_ERR_FLG_1 0xC810
#define R_AX_RXDMA_ERR_FLG_1_C1 0xE810
#define B_AX_F2PCMD_PKT_ERR_TYPE2 BIT(27)
#define B_AX_F2PCMD_PKT_ERR_TYPE1 BIT(26)
#define B_AX_F2PCMD_DMA_ERR_TYPE2 BIT(25)
#define B_AX_F2PCMD_DMA_ERR_TYPE1 BIT(24)
#define B_AX_TXRPT_PKT_ERR_TYPE2 BIT(23)
#define B_AX_TXRPT_PKT_ERR_TYPE1 BIT(22)
#define B_AX_TXRPT_DMA_ERR_TYPE2 BIT(21)
#define B_AX_TXRPT_DMA_ERR_TYPE1 BIT(20)
#define B_AX_RXSTS_PKT_ERR_TYPE2 BIT(19)
#define B_AX_RXSTS_PKT_ERR_TYPE1 BIT(18)
#define B_AX_RXSTS_DMA_ERR_TYPE2 BIT(17)
#define B_AX_RXSTS_DMA_ERR_TYPE1 BIT(16)
#define B_AX_RU3_PKT_ERR_TYPE2 BIT(15)
#define B_AX_RU3_PKT_ERR_TYPE1 BIT(14)
#define B_AX_RU3_DMA_ERR_TYPE2 BIT(13)
#define B_AX_RU3_DMA_ERR_TYPE1 BIT(12)
#define B_AX_RU2_PKT_ERR_TYPE2 BIT(11)
#define B_AX_RU2_PKT_ERR_TYPE1 BIT(10)
#define B_AX_RU2_DMA_ERR_TYPE2 BIT(9)
#define B_AX_RU2_DMA_ERR_TYPE1 BIT(8)
#define B_AX_RU1_PKT_ERR_TYPE2 BIT(7)
#define B_AX_RU1_PKT_ERR_TYPE1 BIT(6)
#define B_AX_RU1_DMA_ERR_TYPE2 BIT(5)
#define B_AX_RU1_DMA_ERR_TYPE1 BIT(4)
#define B_AX_RU0_PKT_ERR_TYPE2 BIT(3)
#define B_AX_RU0_PKT_ERR_TYPE1 BIT(2)
#define B_AX_RU0_DMA_ERR_TYPE2 BIT(1)
#define B_AX_RU0_DMA_ERR_TYPE1 BIT(0)

#define R_AX_RXDMA_PKT_INFO_0 0xC814
#define R_AX_RXDMA_PKT_INFO_0_C1 0xE814
#define B_AX_RU1_IS_IDLE BIT(31)
#define B_AX_RU1_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU1_WR_PKT_ID_SH 16
#define B_AX_RU1_WR_PKT_ID_MSK 0xfff
#define B_AX_RU0_IS_IDLE BIT(15)
#define B_AX_RU0_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU0_WR_PKT_ID_SH 0
#define B_AX_RU0_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_1 0xC818
#define R_AX_RXDMA_PKT_INFO_1_C1 0xE818
#define B_AX_RU3_IS_IDLE BIT(31)
#define B_AX_RU3_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_RU3_WR_PKT_ID_SH 16
#define B_AX_RU3_WR_PKT_ID_MSK 0xfff
#define B_AX_RU2_IS_IDLE BIT(15)
#define B_AX_RU2_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RU2_WR_PKT_ID_SH 0
#define B_AX_RU2_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_2 0xC81C
#define R_AX_RXDMA_PKT_INFO_2_C1 0xE81C
#define B_AX_TXRPT_IS_IDLE BIT(31)
#define B_AX_TXRPT_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_TXRPT_WR_PKT_ID_SH 16
#define B_AX_TXRPT_WR_PKT_ID_MSK 0xfff
#define B_AX_RXSTS_IS_IDLE BIT(15)
#define B_AX_RXSTS_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_RXSTS_WR_PKT_ID_SH 0
#define B_AX_RXSTS_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_3 0xC820
#define R_AX_RXDMA_PKT_INFO_3_C1 0xE820
#define B_AX_CSI_ENQ_FIFO_EMPTY BIT(31)
#define B_AX_CSI_RXDATA_RECOVER_MANNUL BIT(30)
#define B_AX_F2PCMD_IS_IDLE BIT(15)
#define B_AX_F2PCMD_RXDATA_RECOVER_MANNUL BIT(14)
#define B_AX_F2PCMD_WR_PKT_ID_SH 0
#define B_AX_F2PCMD_WR_PKT_ID_MSK 0xfff

#define R_AX_RXDMA_PKT_INFO_4 0xC824
#define R_AX_RXDMA_PKT_INFO_4_C1 0xE824
#define B_AX_CSI_PKTID_1_VALID BIT(31)
#define B_AX_CSI_PKTID_1_SH 16
#define B_AX_CSI_PKTID_1_MSK 0xfff
#define B_AX_CSI_PKTID_0_VALID BIT(15)
#define B_AX_CSI_PKTID_0_SH 0
#define B_AX_CSI_PKTID_0_MSK 0xfff

#define R_AX_TXDMA_FIFO_INFO_0 0xC834
#define R_AX_TXDMA_FIFO_INFO_0_C1 0xE834
#define B_AX_MACTX_ALLOT_DEPTH_1_SH 0
#define B_AX_MACTX_ALLOT_DEPTH_1_MSK 0x3fffffff

#define R_AX_TXDMA_FIFO_INFO_1 0xC838
#define R_AX_TXDMA_FIFO_INFO_1_C1 0xE838
#define B_AX_RU1_TXFIFO_COUNT_SH 20
#define B_AX_RU1_TXFIFO_COUNT_MSK 0x3ff
#define B_AX_RU0_TXFIFO_COUNT_SH 10
#define B_AX_RU0_TXFIFO_COUNT_MSK 0x3ff
#define B_AX_MACTX_ALLOT_DEPTH_2_SH 0
#define B_AX_MACTX_ALLOT_DEPTH_2_MSK 0x3ff

#define R_AX_TXDMA_FIFO_INFO_2 0xC83C
#define R_AX_TXDMA_FIFO_INFO_2_C1 0xE83C
#define B_AX_RU3_TXFIFO_COUNT_SH 10
#define B_AX_RU3_TXFIFO_COUNT_MSK 0x3ff
#define B_AX_RU2_TXFIFO_COUNT_SH 0
#define B_AX_RU2_TXFIFO_COUNT_MSK 0x3ff

#define R_AX_TXDMA_DBG 0xC840
#define R_AX_TXDMA_DBG_C1 0xE840
#define B_AX_TXDMA_DBG_SEL_SH 27
#define B_AX_TXDMA_DBG_SEL_MSK 0x1f
#define B_AX_TXDMA_DBG_EN BIT(26)
#define B_AX_TX_FINISH_REQ BIT(6)
#define B_AX_PL_ARB_RU_SH 4
#define B_AX_PL_ARB_RU_MSK 0x3
#define B_AX_WD_ARB_RU_SH 2
#define B_AX_WD_ARB_RU_MSK 0x3
#define B_AX_REQ_WD_PLD_ID_CS_SH 0
#define B_AX_REQ_WD_PLD_ID_CS_MSK 0x3

#define R_AX_TXDMA_RU_INFO_0 0xC844
#define R_AX_TXDMA_RU_INFO_0_C1 0xE844
#define B_AX_RU0_CUR_WD_ID_SH 18
#define B_AX_RU0_CUR_WD_ID_MSK 0xfff
#define B_AX_RU0_CUR_PL_ID_SH 6
#define B_AX_RU0_CUR_PL_ID_MSK 0xfff
#define B_AX_RU0_READ_CS_SH 3
#define B_AX_RU0_READ_CS_MSK 0x7
#define B_AX_RU0_WRITE_CS_SH 0
#define B_AX_RU0_WRITE_CS_MSK 0x7

#define R_AX_TXDMA_RU_INFO_1 0xC848
#define R_AX_TXDMA_RU_INFO_1_C1 0xE848
#define B_AX_RU1_CUR_WD_ID_SH 18
#define B_AX_RU1_CUR_WD_ID_MSK 0xfff
#define B_AX_RU1_CUR_PL_ID_SH 6
#define B_AX_RU1_CUR_PL_ID_MSK 0xfff
#define B_AX_RU1_READ_CS_SH 3
#define B_AX_RU1_READ_CS_MSK 0x7
#define B_AX_RU1_WRITE_CS_SH 0
#define B_AX_RU1_WRITE_CS_MSK 0x7

#define R_AX_TXDMA_RU_INFO_2 0xC84C
#define R_AX_TXDMA_RU_INFO_2_C1 0xE84C
#define B_AX_RU2_CUR_WD_ID_SH 18
#define B_AX_RU2_CUR_WD_ID_MSK 0xfff
#define B_AX_RU2_CUR_PL_ID_SH 6
#define B_AX_RU2_CUR_PL_ID_MSK 0xfff
#define B_AX_RU2_READ_CS_SH 3
#define B_AX_RU2_READ_CS_MSK 0x7
#define B_AX_RU2_WRITE_CS_SH 0
#define B_AX_RU2_WRITE_CS_MSK 0x7

#define R_AX_TXDMA_RU_INFO_3 0xC850
#define R_AX_TXDMA_RU_INFO_3_C1 0xE850
#define B_AX_RU3_CUR_WD_ID_SH 18
#define B_AX_RU3_CUR_WD_ID_MSK 0xfff
#define B_AX_RU3_CUR_PL_ID_SH 6
#define B_AX_RU3_CUR_PL_ID_MSK 0xfff
#define B_AX_RU3_READ_CS_SH 3
#define B_AX_RU3_READ_CS_MSK 0x7
#define B_AX_RU3_WRITE_CS_SH 0
#define B_AX_RU3_WRITE_CS_MSK 0x7

//
// TMAC
//

#define R_AX_TCR0 0xCA00
#define R_AX_TCR0_C1 0xEA00
#define B_AX_TCR_ZLD_NUM_SH 24
#define B_AX_TCR_ZLD_NUM_MSK 0xff
#define B_AX_TCR_UDF_EN BIT(23)
#define B_AX_TCR_UDF_THSD_SH 16
#define B_AX_TCR_UDF_THSD_MSK 0x7f
#define B_AX_TCR_ERRSTEN_SH 10
#define B_AX_TCR_ERRSTEN_MSK 0x3f
#define B_AX_TCR_VHTSIGA1_TXPS BIT(9)
#define B_AX_TCR_PLCP_ERRHDL_EN BIT(8)
#define B_AX_TCR_PADSEL BIT(7)
#define B_AX_TCR_MASK_SIGBCRC BIT(6)
#define B_AX_TCR_SR_VAL15_ALLOW BIT(5)
#define B_AX_TCR_EN_EOF BIT(4)
#define B_AX_TCR_EN_SCRAM_INC BIT(3)
#define B_AX_TCR_EN_20MST BIT(2)
#define B_AX_TCR_CRC BIT(1)
#define B_AX_TCR_DISGCLK BIT(0)

#define R_AX_TCR1 0xCA04
#define R_AX_TCR1_C1 0xEA04
#define B_AX_TXDFIFO_THRESHOLD_SH 28
#define B_AX_TXDFIFO_THRESHOLD_MSK 0xf
#define B_AX_TCR_CCK_LOCK_CLK BIT(27)
#define B_AX_TCR_FORCE_READ_TXDFIFO BIT(26)
#define B_AX_TCR_USTIME_SH 16
#define B_AX_TCR_USTIME_MSK 0xff
#define B_AX_TCR_SMOOTH_VAL BIT(15)
#define B_AX_TCR_SMOOTH_CTRL BIT(14)
#define B_AX_CS_REQ_VAL BIT(13)
#define B_AX_CS_REQ_SEL BIT(12)
#define B_AX_TCR_ZLD_USTIME_AFTERPHYTXON_SH 8
#define B_AX_TCR_ZLD_USTIME_AFTERPHYTXON_MSK 0xf
#define B_AX_TCR_TXTIMEOUT_SH 0
#define B_AX_TCR_TXTIMEOUT_MSK 0xff

#define R_AX_MD_TSFT_STMP_CTL 0xCA08
#define R_AX_MD_TSFT_STMP_CTL_C1 0xEA08
#define B_AX_TSFT_OFS_SH 16
#define B_AX_TSFT_OFS_MSK 0xffff
#define B_AX_STMP_THSD_SH 8
#define B_AX_STMP_THSD_MSK 0xff
#define B_AX_UPD_HGQMD BIT(1)
#define B_AX_UPD_TIMIE BIT(0)

#define R_AX_PPWRBIT_SETTING 0xCA0C
#define R_AX_PPWRBIT_SETTING_C1 0xEA0C
#define B_AX_P4_PWRMGT_CTRL_EN BIT(19)
#define B_AX_P4_PWRMGT_DATA_EN BIT(18)
#define B_AX_P4_PWRMGT_ACT_EN BIT(17)
#define B_AX_P4_PWR_ST BIT(16)
#define B_AX_P3_PWRMGT_CTRL_EN BIT(15)
#define B_AX_P3_PWRMGT_DATA_EN BIT(14)
#define B_AX_P3_PWRMGT_ACT_EN BIT(13)
#define B_AX_P3_PWR_ST BIT(12)
#define B_AX_P2_PWRMGT_CTRL_EN BIT(11)
#define B_AX_P2_PWRMGT_DATA_EN BIT(10)
#define B_AX_P2_PWRMGT_ACT_EN BIT(9)
#define B_AX_P2_PWR_ST BIT(8)
#define B_AX_P1_PWRMGT_CTRL_EN BIT(7)
#define B_AX_P1_PWRMGT_DATA_EN BIT(6)
#define B_AX_P1_PWRMGT_ACT_EN BIT(5)
#define B_AX_P1_PWR_ST BIT(4)
#define B_AX_P0_PWRMGT_CTRL_EN BIT(3)
#define B_AX_P0_PWRMGT_DATA_EN BIT(2)
#define B_AX_P0_PWRMGT_ACT_EN BIT(1)
#define B_AX_P0_PWR_ST BIT(0)

#define R_AX_HTC 0xCA10
#define R_AX_HTC_C1 0xEA10
#define B_AX_MHDR_HTC_SH 0
#define B_AX_MHDR_HTC_MSK 0xffffffffL

#define R_AX_SOUNDING 0xCA14
#define R_AX_SOUNDING_C1 0xEA14
#define B_AX_USE_NSTS BIT(22)
#define B_AX_RETRY_BFRPT_SEQ_UPD BIT(21)
#define B_AX_TXNDP_SIGB_SH 0
#define B_AX_TXNDP_SIGB_MSK 0x1fffff

#define R_AX_BSR_CTRL 0xCA18
#define R_AX_BSR_CTRL_C1 0xEA18
#define B_AX_RO_MIN_TX_PWR_FLAG BIT(21)
#define B_AX_RO_UPH_SH 16
#define B_AX_RO_UPH_MSK 0x1f
#define B_AX_BSR_BK_TID_SEL BIT(4)
#define B_AX_BSR_BE_TID_SEL BIT(3)
#define B_AX_BSR_VI_TID_SEL BIT(2)
#define B_AX_BSR_VO_TID_SEL BIT(1)
#define B_AX_BSR_QOS_SEL BIT(0)

#define R_AX_TXD_FIFO_CTRL 0xCA1C
#define R_AX_TXD_FIFO_CTRL_C1 0xEA1C
#define B_AX_TXDFIFO_HIGH_MCS_THRE_SH 12
#define B_AX_TXDFIFO_HIGH_MCS_THRE_MSK 0xf
#define B_AX_TXDFIFO_LOW_MCS_THRE_SH 8
#define B_AX_TXDFIFO_LOW_MCS_THRE_MSK 0xf
#define B_AX_HIGH_MCS_PHY_RATE_SH 4
#define B_AX_HIGH_MCS_PHY_RATE_MSK 0xf
#define B_AX_BW_PHY_RATE_SH 0
#define B_AX_BW_PHY_RATE_MSK 0x3

#define R_AX_MACTX_DBG_SEL_CNT 0xCA20
#define R_AX_MACTX_DBG_SEL_CNT_C1 0xEA20
#define B_AX_MACTX_MPDU_CNT_SH 24
#define B_AX_MACTX_MPDU_CNT_MSK 0xff
#define B_AX_MACTX_DMA_CNT_SH 16
#define B_AX_MACTX_DMA_CNT_MSK 0xff
#define B_AX_LENGTH_ERR_FLAG_U3 BIT(11)
#define B_AX_LENGTH_ERR_FLAG_U2 BIT(10)
#define B_AX_LENGTH_ERR_FLAG_U1 BIT(9)
#define B_AX_LENGTH_ERR_FLAG_U0 BIT(8)
#define B_AX_DBGSEL_MACTX_SH 0
#define B_AX_DBGSEL_MACTX_MSK 0x3f

#define R_AX_TX_PPDU_CNT 0xCAE0
#define R_AX_TX_PPDU_CNT_C1 0xEAE0
#define B_AX_TX_PPDU_CNT_SH 16
#define B_AX_TX_PPDU_CNT_MSK 0xffff
#define B_AX_RST_PPDU_CNT BIT(12)
#define B_AX_PPDU_CNT_RIDX_SH 8
#define B_AX_PPDU_CNT_RIDX_MSK 0xf
#define B_AX_PPDU_CNT_IDX_SH 0
#define B_AX_PPDU_CNT_IDX_MSK 0xf

#define R_AX_WMAC_TX_CTRL_DEBUG 0xCAE4
#define R_AX_WMAC_TX_CTRL_DEBUG_C1 0xEAE4
#define B_AX_TX_CTRL_DEBUG_SEL_SH 0
#define B_AX_TX_CTRL_DEBUG_SEL_MSK 0xf

#define R_AX_WMAC_TX_INFO0_DEBUG 0xCAE8
#define R_AX_WMAC_TX_INFO0_DEBUG_C1 0xEAE8
#define B_AX_TX_CTRL_INFO_P0_SH 0
#define B_AX_TX_CTRL_INFO_P0_MSK 0xffffffffL

#define R_AX_WMAC_TX_INFO1_DEBUG 0xCAEC
#define R_AX_WMAC_TX_INFO1_DEBUG_C1 0xEAEC
#define B_AX_TX_CTRL_INFO_P1_SH 0
#define B_AX_TX_CTRL_INFO_P1_MSK 0xffffffffL

//
// TRXPTCL
//

#define R_AX_RSP_CHK_SIG 0xCC00
#define R_AX_RSP_CHK_SIG_C1 0xEC00
#define B_AX_RSP_TBPPDU_CHK_PWR BIT(29)
#define B_AX_RSP_CHK_BASIC_NAV BIT(21)
#define B_AX_RSP_CHK_INTRA_NAV BIT(20)
#define B_AX_RSP_CHK_TX_NAV BIT(19)
#define B_AX_TXDATA_END_PS_OPT BIT(18)
#define B_AX_CHECK_SOUNDING_SEQ BIT(17)
#define B_AX_RXBA_IGNOREA2 BIT(16)
#define B_AX_ACKTO_CCK_SH 8
#define B_AX_ACKTO_CCK_MSK 0xff
#define B_AX_ACKTO_SH 0
#define B_AX_ACKTO_MSK 0xff

#define R_AX_TRXPTCL_RESP_0 0xCC04
#define R_AX_TRXPTCL_RESP_0_C1 0xEC04
#define B_AX_WMAC_RESP_STBC_EN BIT(31)
#define B_AX_WMAC_RXFTM_TXACK_SC BIT(30)
#define B_AX_WMAC_RXFTM_TXACKBWEQ BIT(29)
#define B_AX_RSP_CHK_SEC_CCA_80 BIT(28)
#define B_AX_RSP_CHK_SEC_CCA_40 BIT(27)
#define B_AX_RSP_CHK_SEC_CCA_20 BIT(26)
#define B_AX_RSP_CHK_BTCCA BIT(25)
#define B_AX_RSP_CHK_EDCCA BIT(24)
#define B_AX_RSP_CHK_CCA BIT(23)
#define B_AX_WMAC_LDPC_EN BIT(22)
#define B_AX_WMAC_SGIEN BIT(21)
#define B_AX_WMAC_SPLCPEN BIT(20)
#define B_AX_WMAC_BESP_CHNBUSY_SH 18
#define B_AX_WMAC_BESP_CHNBUSY_MSK 0x3
#define B_AX_WMAC_BESP_EABLY_TXBA BIT(17)
#define B_AX_WMAC_EN_TXACKBA_INTXOP BIT(16)
#define B_AX_WMAC_SPEC_SIFS_OFDM_SH 8
#define B_AX_WMAC_SPEC_SIFS_OFDM_MSK 0xff
#define B_AX_WMAC_SPEC_SIFS_CCK_SH 0
#define B_AX_WMAC_SPEC_SIFS_CCK_MSK 0xff

#define R_AX_TRXPTCL_RRSR_CTL_0 0xCC08
#define R_AX_TRXPTCL_RRSR_CTL_0_C1 0xEC08
#define B_AX_FTM_RRSR_RATE_EN_SH 24
#define B_AX_FTM_RRSR_RATE_EN_MSK 0xf
#define B_AX_NESS_SH 22
#define B_AX_NESS_MSK 0x3
#define B_AX_WMAC_RESP_DOPPLEB_AX_EN BIT(21)
#define B_AX_WMAC_RESP_DCM_EN BIT(20)
#define B_AX_WMAC_RRSB_AX_CCK_SH 16
#define B_AX_WMAC_RRSB_AX_CCK_MSK 0xf
#define B_AX_WMAC_RESP_RATE_EN_SH 12
#define B_AX_WMAC_RESP_RATE_EN_MSK 0xf
#define B_AX_WMAC_RESP_RSC_SH 10
#define B_AX_WMAC_RESP_RSC_MSK 0x3
#define B_AX_WMAC_RESP_REF_RATE_SEL BIT(9)
#define B_AX_WMAC_RESP_REF_RATE_SH 0
#define B_AX_WMAC_RESP_REF_RATE_MSK 0x1ff

#define R_AX_TRXPTCL_RRSR_CTL_1 0xCC0C
#define R_AX_TRXPTCL_RRSR_CTL_1_C1 0xEC0C
#define B_AX_WMAC_RRSR_HE_SH 24
#define B_AX_WMAC_RRSR_HE_MSK 0xff
#define B_AX_WMAC_RRSR_VHT_SH 16
#define B_AX_WMAC_RRSR_VHT_MSK 0xff
#define B_AX_WMAC_RRSR_HT_SH 8
#define B_AX_WMAC_RRSR_HT_MSK 0xff
#define B_AX_WMAC_RRSR_OFDM_SH 0
#define B_AX_WMAC_RRSR_OFDM_MSK 0xff

#define R_AX_TRXPTCL_RESP_TX_ABORT_COUNTER 0xCC1C
#define R_AX_TRXPTCL_RESP_TX_ABORT_COUNTER_C1 0xEC1C
#define B_AX_WMAC_RMAC_BUSY_ABORT_RESP_TX_SH 24
#define B_AX_WMAC_RMAC_BUSY_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_NAV_ABORT_RESP_TX_SH 16
#define B_AX_WMAC_NAV_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_SEC_CCA_ABORT_RESP_TX_SH 8
#define B_AX_WMAC_SEC_CCA_ABORT_RESP_TX_MSK 0xff
#define B_AX_WMAC_CCA_ABORT_RESP_TX_SH 0
#define B_AX_WMAC_CCA_ABORT_RESP_TX_MSK 0xff

#define R_AX_MAC_LOOPBACK 0xCC20
#define R_AX_MAC_LOOPBACK_C1 0xEC20
#define B_AX_MACLBK_RDY_PERIOD_SH 17
#define B_AX_MACLBK_RDY_PERIOD_MSK 0xfff
#define B_AX_MACLBK_PLCP_DLY_SH 8
#define B_AX_MACLBK_PLCP_DLY_MSK 0x1ff
#define B_AX_MACLBK_RDY_NUM_SH 3
#define B_AX_MACLBK_RDY_NUM_MSK 0x1f
#define B_AX_MACLBK_EN BIT(0)

#define R_AX_TRXPTCL_CTS_RRSR 0xCC24
#define R_AX_TRXPTCL_CTS_RRSR_C1 0xEC24
#define B_AX_WMAC_CTS_RRSR_RSC_SH 14
#define B_AX_WMAC_CTS_RRSR_RSC_MSK 0x3
#define B_AX_WMAC_CTS_RESP_OPT BIT(12)
#define B_AX_WMAC_CTS_RRSR_CCK_SH 8
#define B_AX_WMAC_CTS_RRSR_CCK_MSK 0xf
#define B_AX_WMAC_CTS_RRSR_OFDM_SH 0
#define B_AX_WMAC_CTS_RRSR_OFDM_MSK 0xff

#define R_AX_MAC_LOOPBACK_COUNT 0xCC28
#define R_AX_MAC_LOOPBACK_COUNT_C1 0xEC28
#define B_AX_MACLBK_COUNT_CLR BIT(0)

#define R_AX_CLIENT_OM_CTRL 0xCC40
#define R_AX_CLIENT_OM_CTRL_C1 0xEC40
#define B_AX_WMAC_DIS_SIGTA BIT(16)
#define B_AX_UL_DATA_DIS_SH 0
#define B_AX_UL_DATA_DIS_MSK 0x1f

#define R_AX_WMAC_FTM_CTL 0xCC50
#define R_AX_WMAC_FTM_CTL_C1 0xEC50
#define B_AX_FTM_RPT_ERROR BIT(15)
#define B_AX_FTM_TIMEOUT_BYPASS BIT(14)
#define B_AX_RXFTM_EN BIT(2)
#define B_AX_RXFTMREQ_EN BIT(1)
#define B_AX_FTM_EN BIT(0)

#define R_AX_GET_RTT 0xCC54
#define R_AX_GET_RTT_C1 0xEC54
#define B_AX_ACTION_FIELD_SH 16
#define B_AX_ACTION_FIELD_MSK 0xff
#define B_AX_CATEGORY_FIELD_SH 8
#define B_AX_CATEGORY_FIELD_MSK 0xff
#define B_AX_RTT_TYPE_SUBTYPE_SH 1
#define B_AX_RTT_TYPE_SUBTYPE_MSK 0x3f
#define B_AX_RTT_FILTER_EN BIT(0)

#define R_AX_FTM_PTT 0xCC58
#define R_AX_FTM_PTT_C1 0xEC58
#define B_AX_FTM_PTT_TSF_R2T_SEL_SH 3
#define B_AX_FTM_PTT_TSF_R2T_SEL_MSK 0x7
#define B_AX_FTM_PTT_TSF_T2R_SEL_SH 0
#define B_AX_FTM_PTT_TSF_T2R_SEL_MSK 0x7

#define R_AX_FTM_TSF 0xCC5C
#define R_AX_FTM_TSF_C1 0xEC5C
#define B_AX_FTM_T2_TSF_SH 16
#define B_AX_FTM_T2_TSF_MSK 0xffff
#define B_AX_FTM_T1_TSF_SH 0
#define B_AX_FTM_T1_TSF_MSK 0xffff

#define R_AX_MD_CTRL 0xCC72
#define R_AX_MD_CTRL_C1 0xEC72
#define B_AX_BC_MD_EN BIT(1)
#define B_AX_UC_MD_EN BIT(0)

#define R_AX_WMMPS_UAPSD_TID 0xCC70
#define R_AX_WMMPS_UAPSD_TID_C1 0xEC70
#define B_AX_WMMPS_UAPSD_TID7 BIT(7)
#define B_AX_WMMPS_UAPSD_TID6 BIT(6)
#define B_AX_WMMPS_UAPSD_TID5 BIT(5)
#define B_AX_WMMPS_UAPSD_TID4 BIT(4)
#define B_AX_WMMPS_UAPSD_TID3 BIT(3)
#define B_AX_WMMPS_UAPSD_TID2 BIT(2)
#define B_AX_WMMPS_UAPSD_TID1 BIT(1)
#define B_AX_WMMPS_UAPSD_TID0 BIT(0)

#define R_AX_WMAC_NAV_CTL 0xCC80
#define R_AX_WMAC_NAV_CTL_C1 0xEC80

#define R_AX_WMAC_NAV_UP_INFO 0xCC84
#define R_AX_WMAC_NAV_UP_INFO_C1 0xEC84

#define R_AX_RXTRIG_TEST_COMM_0 0xCCA0
#define R_AX_RXTRIG_TEST_COMM_0_C1 0xECA0

#define R_AX_RXTRIG_TEST_COMM_1 0xCCA4
#define R_AX_RXTRIG_TEST_COMM_1_C1 0xECA4

#define R_AX_RXTRIG_TEST_USER_0 0xCCA8
#define R_AX_RXTRIG_TEST_USER_0_C1 0xECA8

#define R_AX_RXTRIG_TEST_USER_1 0xCCAC
#define R_AX_RXTRIG_TEST_USER_1_C1 0xECAC

#define R_AX_RXTRIG_TEST_USER_2 0xCCB0
#define R_AX_RXTRIG_TEST_USER_2_C1 0xECB0
#define B_AX_RXTRIG_MACID_SH 24
#define B_AX_RXTRIG_MACID_MSK 0xff
#define B_AX_RXTRIG_RU26_DIS BIT(21)
#define B_AX_RXTRIG_FCSCHK_EN BIT(20)
#define B_AX_RXTRIG_PORT_SEL_SH 17
#define B_AX_RXTRIG_PORT_SEL_MSK 0x7
#define B_AX_RXTRIG_EN BIT(16)
#define B_AX_RXTRIG_USERINFO_2_SH 0
#define B_AX_RXTRIG_USERINFO_2_MSK 0xffff

#define R_AX_RXTRIG_TEST_CTRL1 0xCCB4
#define R_AX_RXTRIG_TEST_CTRL1_C1 0xECB4

#define R_AX_SR_CONTROL_DBG 0xCCB8
#define R_AX_SR_CONTROL_DBG_C1 0xECB8

#define R_AX_TRXPTCL_ERROR_INDICA_MASK 0xCCBC
#define R_AX_TRXPTCL_ERROR_INDICA_MASK_C1 0xECBC
#define B_AX_WMAC_MODE BIT(22)
#define B_AX_WMAC_TIMETOUT_THR_SH 16
#define B_AX_WMAC_TIMETOUT_THR_MSK 0x3f
#define B_AX_RMAC_FTM BIT(8)
#define B_AX_RMAC_CSI BIT(7)
#define B_AX_TMAC_MIMO_CTRL BIT(6)
#define B_AX_TMAC_RXTB BIT(5)
#define B_AX_TMAC_HWSIGB_GEN BIT(4)
#define B_AX_TMAC_TXPLCP BIT(3)
#define B_AX_TMAC_RESP BIT(2)
#define B_AX_TMAC_TXCTL BIT(1)
#define B_AX_TMAC_MACTX BIT(0)

#define R_AX_WMAC_TX_TF_INFO_0 0xCCD0
#define R_AX_WMAC_TX_TF_INFO_0_C1 0xECD0
#define B_AX_WMAC_TX_TF_INFO_SEL_SH 0
#define B_AX_WMAC_TX_TF_INFO_SEL_MSK 0x7

#define R_AX_WMAC_TX_TF_INFO_1 0xCCD4
#define R_AX_WMAC_TX_TF_INFO_1_C1 0xECD4
#define B_AX_WMAC_TX_TF_INFO_P0_SH 0
#define B_AX_WMAC_TX_TF_INFO_P0_MSK 0xffffffffL

#define R_AX_WMAC_TX_TF_INFO_2 0xCCD8
#define R_AX_WMAC_TX_TF_INFO_2_C1 0xECD8
#define B_AX_WMAC_TX_TF_INFO_P1_SH 0
#define B_AX_WMAC_TX_TF_INFO_P1_MSK 0xffffffffL

#define R_AX_CTRL_FRAME_CNT_CTRL 0xCCE0
#define R_AX_CTRL_FRAME_CNT_CTRL_C1 0xECE0
#define B_AX_WMAC_ALLCNT_RST BIT(16)
#define B_AX_CTRL_SUBTYPE_SH 12
#define B_AX_CTRL_SUBTYPE_MSK 0xf
#define B_AX_WMAC_WDATA_EN BIT(9)
#define B_AX_WMAC_ALLCNT_EN BIT(8)
#define B_AX_WMAC_CTRL_CNT_IDX_SH 0
#define B_AX_WMAC_CTRL_CNT_IDX_MSK 0xf

#define R_AX_CTRL_FRAME_CNT_SUBCTRL 0xCCE4
#define R_AX_CTRL_FRAME_CNT_SUBCTRL_C1 0xECE4
#define B_AX_CNT_INDEX_SH 8
#define B_AX_CNT_INDEX_MSK 0xf
#define B_AX_CNTRST BIT(1)
#define B_AX_CNTEN BIT(0)

#define R_AX_CTRL_FRAME_CNT_RPT 0xCCE8
#define R_AX_CTRL_FRAME_CNT_RPT_C1 0xECE8
#define B_AX_RX_CTRL_FRAME_CNT_SH 16
#define B_AX_RX_CTRL_FRAME_CNT_MSK 0xffff
#define B_AX_TX_CTRL_FRAME_CNT_SH 0
#define B_AX_TX_CTRL_FRAME_CNT_MSK 0xffff

#define R_AX_TMAC_ERR_IMR_ISR 0xCCEC
#define R_AX_TMAC_ERR_IMR_ISR_C1 0xECEC
#define B_AX_TMAC_TXPLCP_ERR_CLR BIT(19)
#define B_AX_TMAC_RESP_ERR_CLR BIT(18)
#define B_AX_TMAC_TXCTL_ERR_CLR BIT(17)
#define B_AX_TMAC_MACTX_ERR_CLR BIT(16)
#define B_AX_TMAC_TXPLCP_ERR BIT(14)
#define B_AX_TMAC_RESP_ERR BIT(13)
#define B_AX_TMAC_TXCTL_ERR BIT(12)
#define B_AX_TMAC_MACTX_ERR BIT(11)
#define B_AX_TMAC_TXPLCP_INT_EN BIT(10)
#define B_AX_TMAC_RESP_INT_EN BIT(9)
#define B_AX_TMAC_TXCTL_INT_EN BIT(8)
#define B_AX_TMAC_MACTX_INT_EN BIT(7)
#define B_AX_TMAC_MODE_INT_EN BIT(6)
#define B_AX_TMAC_TIMETOUT_THR_SH 0
#define B_AX_TMAC_TIMETOUT_THR_MSK 0x3f

#define R_AX_WMAC_DEBUG_PORT 0xCCF0
#define R_AX_WMAC_DEBUG_PORT_C1 0xECF0
#define B_AX_WMAC_DEBUG_SH 0
#define B_AX_WMAC_DEBUG_MSK 0xffffffffL

#define R_AX_DBGSEL_TRXPTCL 0xCCF4
#define R_AX_DBGSEL_TRXPTCL_C1 0xECF4
#define B_AX_DBGSEL_TRXPTCL_SH 0
#define B_AX_DBGSEL_TRXPTCL_MSK 0x3f

#define R_AX_PHYINFO_ERR_IMR 0xCCFE
#define R_AX_PHYINFO_ERR_IMR_C1 0xECFE
#define B_AX_CSI_ON_TIMEOUT_INT_EN BIT(5)
#define B_AX_STS_ON_TIMEOUT_INT_EN BIT(4)
#define B_AX_DATA_ON_TIMEOUT_INT_EN BIT(3)
#define B_AX_OFDM_CCA_TIMEOUT_INT_EN BIT(2)
#define B_AX_CCK_CCA_TIMEOUT_INT_EN BIT(1)
#define B_AXC_PHY_TXON_TIMEOUT_INT_EN BIT(0)

#define R_AX_PHYINFO_ERR_ISR 0xCCFF
#define R_AX_PHYINFO_ERR_ISR_C1 0xECFF
#define B_AX_CSI_ON_TIMEOUT BIT(5)
#define B_AX_STS_ON_TIMEOUT BIT(4)
#define B_AX_DATA_ON_TIMEOUT BIT(3)
#define B_AX_OFDM_CCA_TIMEOUT BIT(2)
#define B_AX_CCK_CCA_TIMEOUT BIT(1)
#define B_AXC_PHY_TXON_TIMEOUT BIT(0)

#define R_AX_BFMER_ASSOCIATED_SU0 0xCD00
#define R_AX_BFMER_ASSOCIATED_SU0_C1 0xED00
#define B_AX_MER_IGNORE_SU_BFMEE1_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE1_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE1_EN BIT(24)
#define B_AX_MER_SU_BFMEE1_MACID_SH 16
#define B_AX_MER_SU_BFMEE1_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE0_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE0_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE0_EN BIT(8)
#define B_AX_MER_SU_BFMEE0_MACID_SH 0
#define B_AX_MER_SU_BFMEE0_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU2 0xCD04
#define R_AX_BFMER_ASSOCIATED_SU2_C1 0xED04
#define B_AX_MER_IGNORE_SU_BFMEE3_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE3_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE3_EN BIT(24)
#define B_AX_MER_SU_BFMEE3_MACID_SH 16
#define B_AX_MER_SU_BFMEE3_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE2_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE2_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE2_EN BIT(8)
#define B_AX_MER_SU_BFMEE2_MACID_SH 0
#define B_AX_MER_SU_BFMEE2_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU4 0xCD08
#define R_AX_BFMER_ASSOCIATED_SU4_C1 0xED08
#define B_AX_MER_IGNORE_SU_BFMEE5_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE5_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE5_EN BIT(24)
#define B_AX_MER_SU_BFMEE5_MACID_SH 16
#define B_AX_MER_SU_BFMEE5_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE4_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE4_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE4_EN BIT(8)
#define B_AX_MER_SU_BFMEE4_MACID_SH 0
#define B_AX_MER_SU_BFMEE4_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU6 0xCD0C
#define R_AX_BFMER_ASSOCIATED_SU6_C1 0xED0C
#define B_AX_MER_IGNORE_SU_BFMEE7_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE7_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE7_EN BIT(24)
#define B_AX_MER_SU_BFMEE7_MACID_SH 16
#define B_AX_MER_SU_BFMEE7_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE6_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE6_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE6_EN BIT(8)
#define B_AX_MER_SU_BFMEE6_MACID_SH 0
#define B_AX_MER_SU_BFMEE6_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU8 0xCD10
#define R_AX_BFMER_ASSOCIATED_SU8_C1 0xED10
#define B_AX_MER_IGNORE_SU_BFMEE9_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE9_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE9_EN BIT(24)
#define B_AX_MER_SU_BFMEE9_MACID_SH 16
#define B_AX_MER_SU_BFMEE9_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE8_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE8_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE8_EN BIT(8)
#define B_AX_MER_SU_BFMEE8_MACID_SH 0
#define B_AX_MER_SU_BFMEE8_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU10 0xCD14
#define R_AX_BFMER_ASSOCIATED_SU10_C1 0xED14
#define B_AX_MER_IGNORE_SU_BFMEE11_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE11_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE11_EN BIT(24)
#define B_AX_MER_SU_BFMEE11_MACID_SH 16
#define B_AX_MER_SU_BFMEE11_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE10_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE10_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE10_EN BIT(8)
#define B_AX_MER_SU_BFMEE10_MACID_SH 0
#define B_AX_MER_SU_BFMEE10_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU12 0xCD18
#define R_AX_BFMER_ASSOCIATED_SU12_C1 0xED18
#define B_AX_MER_IGNORE_SU_BFMEE13_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE13_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE13_EN BIT(24)
#define B_AX_MER_SU_BFMEE13_MACID_SH 16
#define B_AX_MER_SU_BFMEE13_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE12_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE12_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE12_EN BIT(8)
#define B_AX_MER_SU_BFMEE12_MACID_SH 0
#define B_AX_MER_SU_BFMEE12_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_SU14 0xCD1C
#define R_AX_BFMER_ASSOCIATED_SU14_C1 0xED1C
#define B_AX_MER_IGNORE_SU_BFMEE15_SND_STS BIT(26)
#define B_AX_MER_SU_BFMEE15_SND_STS BIT(25)
#define B_AX_MER_SU_BFMEE15_EN BIT(24)
#define B_AX_MER_SU_BFMEE15_MACID_SH 16
#define B_AX_MER_SU_BFMEE15_MACID_MSK 0xff
#define B_AX_MER_IGNORE_SU_BFMEE14_SND_STS BIT(10)
#define B_AX_MER_SU_BFMEE14_SND_STS BIT(9)
#define B_AX_MER_SU_BFMEE14_EN BIT(8)
#define B_AX_MER_SU_BFMEE14_MACID_SH 0
#define B_AX_MER_SU_BFMEE14_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_MU0 0xCD20
#define R_AX_BFMER_ASSOCIATED_MU0_C1 0xED20
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE1 BIT(27)
#define B_AX_MER_IGNORE_MU_BFMEE1_SND_STS BIT(26)
#define B_AX_MER_MU_BFMEE1_SND_STS BIT(25)
#define B_AX_MER_MU_BFMEE1_EN BIT(24)
#define B_AX_MER_MU_BFMEE1_MACID_SH 16
#define B_AX_MER_MU_BFMEE1_MACID_MSK 0xff
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE0 BIT(11)
#define B_AX_MER_IGNORE_MU_BFMEE0_SND_STS BIT(10)
#define B_AX_MER_MU_BFMEE0_SND_STS BIT(9)
#define B_AX_MER_MU_BFMEE0_EN BIT(8)
#define B_AX_MER_MU_BFMEE0_MACID_SH 0
#define B_AX_MER_MU_BFMEE0_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_MU2 0xCD24
#define R_AX_BFMER_ASSOCIATED_MU2_C1 0xED24
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE3 BIT(27)
#define B_AX_MER_IGNORE_MU_BFMEE3_SND_STS BIT(26)
#define B_AX_MER_MU_BFMEE3_SND_STS BIT(25)
#define B_AX_MER_MU_BFMEE3_EN BIT(24)
#define B_AX_MER_MU_BFMEE3_MACID_SH 16
#define B_AX_MER_MU_BFMEE3_MACID_MSK 0xff
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE2 BIT(11)
#define B_AX_MER_IGNORE_MU_BFMEE2_SND_STS BIT(10)
#define B_AX_MER_MU_BFMEE2_SND_STS BIT(9)
#define B_AX_MER_MU_BFMEE2_EN BIT(8)
#define B_AX_MER_MU_BFMEE2_MACID_SH 0
#define B_AX_MER_MU_BFMEE2_MACID_MSK 0xff

#define R_AX_BFMER_ASSOCIATED_MU4 0xCD28
#define R_AX_BFMER_ASSOCIATED_MU4_C1 0xED28
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE5 BIT(27)
#define B_AX_MER_IGNORE_MU_BFMEE5_SND_STS BIT(26)
#define B_AX_MER_MU_BFMEE5_SND_STS BIT(25)
#define B_AX_MER_MU_BFMEE5_EN BIT(24)
#define B_AX_MER_MU_BFMEE5_MACID_SH 16
#define B_AX_MER_MU_BFMEE5_MACID_MSK 0xff
#define B_AX_MER_DIS_SU_TXBF_MU_BFMEE4 BIT(11)
#define B_AX_MER_IGNORE_MU_BFMEE4_SND_STS BIT(10)
#define B_AX_MER_MU_BFMEE4_SND_STS BIT(9)
#define B_AX_MER_MU_BFMEE4_EN BIT(8)
#define B_AX_MER_MU_BFMEE4_MACID_SH 0
#define B_AX_MER_MU_BFMEE4_MACID_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX0 0xCD2C
#define R_AX_BFMER_CSI_BUFF_IDX0_C1 0xED2C
#define B_AX_MER_TXBF_CSI_BUFF_IDX0_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX0_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX0_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX0_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX0_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX0_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX1 0xCD30
#define R_AX_BFMER_CSI_BUFF_IDX1_C1 0xED30
#define B_AX_MER_TXBF_CSI_BUFF_IDX1_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX1_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX1_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX1_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX1_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX1_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX2 0xCD34
#define R_AX_BFMER_CSI_BUFF_IDX2_C1 0xED34
#define B_AX_MER_TXBF_CSI_BUFF_IDX2_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX2_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX2_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX2_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX2_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX2_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX3 0xCD38
#define R_AX_BFMER_CSI_BUFF_IDX3_C1 0xED38
#define B_AX_MER_TXBF_CSI_BUFF_IDX3_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX3_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX3_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX3_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX3_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX3_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX4 0xCD3C
#define R_AX_BFMER_CSI_BUFF_IDX4_C1 0xED3C
#define B_AX_MER_TXBF_CSI_BUFF_IDX4_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX4_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX4_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX4_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX4_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX4_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX5 0xCD40
#define R_AX_BFMER_CSI_BUFF_IDX5_C1 0xED40
#define B_AX_MER_TXBF_CSI_BUFF_IDX5_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX5_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX5_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX5_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX5_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX5_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX6 0xCD44
#define R_AX_BFMER_CSI_BUFF_IDX6_C1 0xED44
#define B_AX_MER_TXBF_CSI_BUFF_IDX6_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX6_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX6_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX6_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX6_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX6_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX7 0xCD48
#define R_AX_BFMER_CSI_BUFF_IDX7_C1 0xED48
#define B_AX_MER_TXBF_CSI_BUFF_IDX7_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX7_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX7_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX7_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX7_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX7_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX8 0xCD4C
#define R_AX_BFMER_CSI_BUFF_IDX8_C1 0xED4C
#define B_AX_MER_TXBF_CSI_BUFF_IDX8_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX8_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX8_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX8_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX8_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX8_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX9 0xCD50
#define R_AX_BFMER_CSI_BUFF_IDX9_C1 0xED50
#define B_AX_MER_TXBF_CSI_BUFF_IDX9_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX9_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX9_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX9_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX9_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX9_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX10 0xCD54
#define R_AX_BFMER_CSI_BUFF_IDX10_C1 0xED54
#define B_AX_MER_TXBF_CSI_BUFF_IDX10_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX10_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX10_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX10_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX10_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX10_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX11 0xCD58
#define R_AX_BFMER_CSI_BUFF_IDX11_C1 0xED58
#define B_AX_MER_TXBF_CSI_BUFF_IDX11_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX11_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX11_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX11_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX11_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX11_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX12 0xCD5C
#define R_AX_BFMER_CSI_BUFF_IDX12_C1 0xED5C
#define B_AX_MER_TXBF_CSI_BUFF_IDX12_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX12_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX12_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX12_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX12_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX12_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX13 0xCD60
#define R_AX_BFMER_CSI_BUFF_IDX13_C1 0xED60
#define B_AX_MER_TXBF_CSI_BUFF_IDX13_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX13_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX13_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX13_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX13_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX13_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX14 0xCD64
#define R_AX_BFMER_CSI_BUFF_IDX14_C1 0xED64
#define B_AX_MER_TXBF_CSI_BUFF_IDX14_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX14_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX14_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX14_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX14_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX14_MSK 0xff

#define R_AX_BFMER_CSI_BUFF_IDX15 0xCD68
#define R_AX_BFMER_CSI_BUFF_IDX15_C1 0xED68
#define B_AX_MER_TXBF_CSI_BUFF_IDX15_SH 20
#define B_AX_MER_TXBF_CSI_BUFF_IDX15_MSK 0xfff
#define B_AX_MER_SND_CSI_BUFF_IDX15_SH 8
#define B_AX_MER_SND_CSI_BUFF_IDX15_MSK 0xfff
#define B_AX_MER_CSI_BUFF_MACID_IDX15_SH 0
#define B_AX_MER_CSI_BUFF_MACID_IDX15_MSK 0xff

#define R_AX_BFMER_SND_DEBUG_CNT 0xCD6C
#define R_AX_BFMER_SND_DEBUG_CNT_C1 0xED6C
#define B_AX_SND_DNGCNT_RST BIT(20)
#define B_AX_MER_SND_DNGCNT_SH 0
#define B_AX_MER_SND_DNGCNT_MSK 0xffff

#define R_AX_BFMER_UPD_MEE_PARA 0xCD70
#define R_AX_BFMER_UPD_MEE_PARA_C1 0xED70
#define B_AX_MER_UPDMEE_OPTION BIT(31)
#define B_AX_MER_UPDMEE_USERID_SH 16
#define B_AX_MER_UPDMEE_USERID_MSK 0xf
#define B_AX_MER_UPDMEE_FT_SH 12
#define B_AX_MER_UPDMEE_FT_MSK 0x3
#define B_AX_MER_UPDMEE_BW_SH 10
#define B_AX_MER_UPDMEE_BW_MSK 0x3
#define B_AX_MER_UPDMEE_CB_SH 8
#define B_AX_MER_UPDMEE_CB_MSK 0x3
#define B_AX_MER_UPDMEE_NG_SH 6
#define B_AX_MER_UPDMEE_NG_MSK 0x3
#define B_AX_MER_UPDMEE_NR_SH 3
#define B_AX_MER_UPDMEE_NR_MSK 0x7
#define B_AX_MER_UPDMEE_NC_SH 0
#define B_AX_MER_UPDMEE_NC_MSK 0x7

#define R_AX_BFMER_RO_MEE_PARA 0xCD74
#define R_AX_BFMER_RO_MEE_PARA_C1 0xED74
#define B_AX_BFMER_RO_MEE_PARA_FT_SH 12
#define B_AX_BFMER_RO_MEE_PARA_FT_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_BW_SH 10
#define B_AX_BFMER_RO_MEE_PARA_BW_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_CB_SH 8
#define B_AX_BFMER_RO_MEE_PARA_CB_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_NG_SH 6
#define B_AX_BFMER_RO_MEE_PARA_NG_MSK 0x3
#define B_AX_BFMER_RO_MEE_PARA_NR_SH 3
#define B_AX_BFMER_RO_MEE_PARA_NR_MSK 0x7
#define B_AX_BFMER_RO_MEE_PARA_NC_SH 0
#define B_AX_BFMER_RO_MEE_PARA_NC_MSK 0x7

#define R_AX_BFMER_CTRL_0 0xCD78
#define R_AX_BFMER_CTRL_0_C1 0xED78
#define B_AX_BFMER_HE_CSI_OFFSET_SH 24
#define B_AX_BFMER_HE_CSI_OFFSET_MSK 0xff
#define B_AX_BFMER_VHT_CSI_OFFSET_SH 16
#define B_AX_BFMER_VHT_CSI_OFFSET_MSK 0xff
#define B_AX_BFMER_HT_CSI_OFFSET_SH 8
#define B_AX_BFMER_HT_CSI_OFFSET_MSK 0xff
#define B_AX_BFMER_NDP_BFEN BIT(2)
#define B_AX_BFMER_VHT_BFPRT_CHK BIT(0)

#define R_AX_BFMER_CTRL_1 0xCD7C
#define R_AX_BFMER_CTRL_1_C1 0xED7C
#define B_AX_BFMER_CTRLINFO_MACID_SH 0
#define B_AX_BFMER_CTRLINFO_MACID_MSK 0xff

#define R_AX_BFMEE_RESP_OPTION 0xCD80
#define R_AX_BFMEE_RESP_OPTION_C1 0xED80
#define B_AX_BFMEE_NDP_RX_STANDBY_TIMER_SH 24
#define B_AX_BFMEE_NDP_RX_STANDBY_TIMER_MSK 0xff
#define B_AX_BFMEE_BFRP_RX_STANDBY_TIMER_SH 20
#define B_AX_BFMEE_BFRP_RX_STANDBY_TIMER_MSK 0xf
#define B_AX_MU_BFRPTSEG_SEL_SH 17
#define B_AX_MU_BFRPTSEG_SEL_MSK 0x3
#define B_AX_BFMEE_NDP_RXSTDBY_SEL BIT(16)

#define R_AX_BFMEE_OPTION 0xCD84
#define R_AX_BFMEE_OPTION_C1 0xED84
#define B_AX_BFMEE_MU_BFEE_DIS BIT(7)
#define B_AX_BFMEE_CHECK_RPTPOLL_MACID_DIS BIT(6)
#define B_AX_BFMEE_NOCHK_BFPOLL_BMP BIT(5)
#define B_AX_BFMEE_HE_NDPA_EN BIT(2)
#define B_AX_BFMEE_VHT_NDPA_EN BIT(1)
#define B_AX_BFMEE_HT_NDPA_EN BIT(0)

#define R_AX_TRXPTCL_RESP_CSI_CTRL_0 0xCD88
#define R_AX_TRXPTCL_RESP_CSI_CTRL_0_C1 0xED88
#define B_AX_BFMEE_CSISEQ_SEL BIT(29)
#define B_AX_BFMEE_BFPARAM_SEL BIT(28)
#define B_AX_BFMEE_OFDM_LEN_TH_SH 24
#define B_AX_BFMEE_OFDM_LEN_TH_MSK 0xf
#define B_AX_BFMEE_BF_PORT_SEL BIT(23)
#define B_AX_BFMEE_USE_NSTS BIT(22)
#define B_AX_BFMEE_CSI_RATE_FB_EN BIT(21)
#define B_AX_BFMEE_CSI_GID_SEL BIT(20)
#define B_AX_BFMEE_CSI_RSC_SH 18
#define B_AX_BFMEE_CSI_RSC_MSK 0x3
#define B_AX_BFMEE_CSI_FORCE_RETE_EN BIT(17)
#define B_AX_BFMEE_CSI_USE_NDPARATE BIT(16)
#define B_AX_BFMEE_CSI_WITHHTC_EN BIT(15)
#define B_AX_BFMEE_CSIINFO0_BF_EN BIT(14)
#define B_AX_BFMEE_CSIINFO0_STBC_EN BIT(13)
#define B_AX_BFMEE_CSIINFO0_LDPC_EN BIT(12)
#define B_AX_BFMEE_CSIINFO0_CS_SH 10
#define B_AX_BFMEE_CSIINFO0_CS_MSK 0x3
#define B_AX_BFMEE_CSIINFO0_CB_SH 8
#define B_AX_BFMEE_CSIINFO0_CB_MSK 0x3
#define B_AX_BFMEE_CSIINFO0_NG_SH 6
#define B_AX_BFMEE_CSIINFO0_NG_MSK 0x3
#define B_AX_BFMEE_CSIINFO0_NR_SH 3
#define B_AX_BFMEE_CSIINFO0_NR_MSK 0x7
#define B_AX_BFMEE_CSIINFO0_NC_SH 0
#define B_AX_BFMEE_CSIINFO0_NC_MSK 0x7

#define R_AX_TRXPTCL_RESP_CSI_RRSC 0xCD8C
#define R_AX_TRXPTCL_RESP_CSI_RRSC_C1 0xED8C
#define B_AX_BFMEE_CSI_RRSC_BMAP_SH 0
#define B_AX_BFMEE_CSI_RRSC_BMAP_MSK 0xffffffffL

#define R_AX_TRXPTCL_RESP_CSI_RATE 0xCD90
#define R_AX_TRXPTCL_RESP_CSI_RATE_C1 0xED90
#define B_AX_BFMEE_HE_CSI_RATE_SH 16
#define B_AX_BFMEE_HE_CSI_RATE_MSK 0x7f
#define B_AX_BFMEE_VHT_CSI_RATE_SH 8
#define B_AX_BFMEE_VHT_CSI_RATE_MSK 0x7f
#define B_AX_BFMEE_HT_CSI_RATE_SH 0
#define B_AX_BFMEE_HT_CSI_RATE_MSK 0x7f

#define R_AX_TRXPTCL_RESP_CSI_CTRL_1 0xCD94
#define R_AX_TRXPTCL_RESP_CSI_CTRL_1_C1 0xED94
#define B_AX_BFMEE_CSIINFO1_BF_EN BIT(14)
#define B_AX_BFMEE_CSIINFO1_STBC_EN BIT(13)
#define B_AX_BFMEE_CSIINFO1_LDPC_EN BIT(12)
#define B_AX_BFMEE_CSIINFO1_CS_SH 10
#define B_AX_BFMEE_CSIINFO1_CS_MSK 0x3
#define B_AX_BFMEE_CSIINFO1_CB_SH 8
#define B_AX_BFMEE_CSIINFO1_CB_MSK 0x3
#define B_AX_BFMEE_CSIINFO1_NG_SH 6
#define B_AX_BFMEE_CSIINFO1_NG_MSK 0x3
#define B_AX_BFMEE_CSIINFO1_NR_SH 3
#define B_AX_BFMEE_CSIINFO1_NR_MSK 0x7
#define B_AX_BFMEE_CSIINFO1_NC_SH 0
#define B_AX_BFMEE_CSIINFO1_NC_MSK 0x7

//
// RMAC
//

#define R_AX_RCR 0xCE00
#define R_AX_RCR_C1 0xEE00
#define B_AX_STOP_RX_IN BIT(11)
#define B_AX_DRV_INFO_SIZE_SH 8
#define B_AX_DRV_INFO_SIZE_MSK 0x7
#define B_AX_CH_EN_SH 0
#define B_AX_CH_EN_MSK 0xf

#define R_AX_DLK_PROTECT_CTL 0xCE02
#define R_AX_DLK_PROTECT_CTL_C1 0xEE02
#define B_AX_RX_DLK_CCA_TIME_SH 8
#define B_AX_RX_DLK_CCA_TIME_MSK 0xff
#define B_AX_RX_DLK_DATA_TIME_SH 4
#define B_AX_RX_DLK_DATA_TIME_MSK 0xf
#define B_AX_RX_DLK_RST_EN BIT(1)
#define B_AX_RX_DLK_INT_EN BIT(0)

#define R_AX_PLCP_HDR_FLTR 0xCE04
#define R_AX_PLCP_HDR_FLTR_C1 0xEE04
#define B_AX_DIS_CHK_MIN_LEN BIT(8)
#define B_AX_HE_SIGB_CRC_CHK BIT(6)
#define B_AX_VHT_MU_SIGB_CRC_CHK BIT(5)
#define B_AX_VHT_SU_SIGB_CRC_CHK BIT(4)
#define B_AX_SIGA_CRC_CHK BIT(3)
#define B_AX_LSIG_PARITY_CHK BIT(2)
#define B_AX_CCK_SIG_CHK BIT(1)
#define B_AX_CCK_CRC_CHK BIT(0)

#define R_AX_RXGCK_CTRL 0xCE06
#define R_AX_RXGCK_CTRL_C1 0xEE06
#define B_AX_RXGCK_GCK_RATE_LIMIT_SH 8
#define B_AX_RXGCK_GCK_RATE_LIMIT_MSK 0x3
#define B_AX_RXGCK_ENTRY_DELAY_SH 4
#define B_AX_RXGCK_ENTRY_DELAY_MSK 0x7
#define B_AX_RXGCK_GCK_CYCLE_SH 2
#define B_AX_RXGCK_GCK_CYCLE_MSK 0x3
#define B_AX_RXGCK_CCA_EN BIT(1)
#define B_AX_DISGCLK BIT(0)

#define R_AX_RXPSF_CTRL 0xCE08
#define R_AX_RXPSF_CTRL_C1 0xEE08
#define B_AX_RXPSF_PKTLENTHR_SH 16
#define B_AX_RXPSF_PKTLENTHR_MSK 0x7
#define B_AX_RXPSF_ERRTHR_SH 12
#define B_AX_RXPSF_ERRTHR_MSK 0x7
#define B_AX_INVALID_WIDTH_SH 8
#define B_AX_INVALID_WIDTH_MSK 0x3
#define B_AX_RXPSF_PLCP_CHKEN BIT(4)
#define B_AX_RXPSF_BSS_CHKEN BIT(3)
#define B_AX_RXPSF_MHCHKEN BIT(2)
#define B_AX_RXPSF_CONT_ERRCHKEN BIT(1)

#define R_AX_RXPSF_MGT_TYPE 0xCE0E
#define R_AX_RXPSF_MGT_TYPE_C1 0xEE0E
#define B_AX_RXPSF_MGT15_PRSV BIT(15)
#define B_AX_RXPSF_MGT14_PRSV BIT(14)
#define B_AX_RXPSF_MGT13_PRSV BIT(13)
#define B_AX_RXPSF_MGT12_PRSV BIT(12)
#define B_AX_RXPSF_MGT11_PRSV BIT(11)
#define B_AX_RXPSF_MGT10_PRSV BIT(10)
#define B_AX_RXPSF_MGT9_PRSV BIT(9)
#define B_AX_RXPSF_MGT8_PRSV BIT(8)
#define B_AX_RXPSF_MGT7_PRSV BIT(7)
#define B_AX_RXPSF_MGT6_PRSV BIT(6)
#define B_AX_RXPSF_MGT5_PRSV BIT(5)
#define B_AX_RXPSF_MGT4_PRSV BIT(4)
#define B_AX_RXPSF_MGT3_PRSV BIT(3)
#define B_AX_RXPSF_MGT2_PRSV BIT(2)
#define B_AX_RXPSF_MGT1_PRSV BIT(1)
#define B_AX_RXPSF_MGT0_PRSV BIT(0)

#define R_AX_RXPSF_DATA_TYPE 0xCE0C
#define R_AX_RXPSF_DATA_TYPE_C1 0xEE0C
#define B_AX_RXPSF_DATA15_PRSV BIT(15)
#define B_AX_RXPSF_DATA14_PRSV BIT(14)
#define B_AX_RXPSF_DATA13_PRSV BIT(13)
#define B_AX_RXPSF_DATA12_PRSV BIT(12)
#define B_AX_RXPSF_DATA11_PRSV BIT(11)
#define B_AX_RXPSF_DATA10_PRSV BIT(10)
#define B_AX_RXPSF_DATA9_PRSV BIT(9)
#define B_AX_RXPSF_DATA8_PRSV BIT(8)
#define B_AX_RXPSF_DATA7_PRSV BIT(7)
#define B_AX_RXPSF_DATA6_PRSV BIT(6)
#define B_AX_RXPSF_DATA5_PRSV BIT(5)
#define B_AX_RXPSF_DATA4_PRSV BIT(4)
#define B_AX_RXPSF_DATA3_PRSV BIT(3)
#define B_AX_RXPSF_DATA2_PRSV BIT(2)
#define B_AX_RXPSF_DATA1_PRSV BIT(1)
#define B_AX_RXPSF_DATA_PRSV BIT(0)

#define R_AX_RXPSF_CTRL_TYPE 0xCE10
#define R_AX_RXPSF_CTRL_TYPE_C1 0xEE10
#define B_AX_RXPSF_CTRL_PRSV BIT(0)

#define R_AX_RXPSF_RATE 0xCE12
#define R_AX_RXPSF_RATE_C1 0xEE12
#define B_AX_RXPSF_HETB_PRSV BIT(8)
#define B_AX_RXPSF_HEMU_PRSV BIT(7)
#define B_AX_RXPSF_HEERSU_PRSV BIT(6)
#define B_AX_RXPSF_HESU_PRSV BIT(5)
#define B_AX_RXPSF_VHTMU_PRSV BIT(4)
#define B_AX_RXPSF_VHTSU_PRSV BIT(3)
#define B_AX_RXPSF_HT_PRSV BIT(2)
#define B_AX_RXPSF_OFDM_PRSV BIT(1)
#define B_AX_RXPSF_CCK_PRSV BIT(0)

#define R_AX_RXAI_CTRL 0xCE14
#define R_AX_RXAI_CTRL_C1 0xEE14
#define B_AX_RXAI_INFO_RST BIT(7)
#define B_AX_RXAI_PRTCT_REL BIT(6)
#define B_AX_RXAI_PRTCT_VIO BIT(5)
#define B_AX_RXAI_PRTCT_SEL BIT(1)
#define B_AX_RXAI_PRTCT_EN BIT(0)

#define R_AX_RX_FIFO_CTRL 0xCE1C
#define R_AX_RX_FIFO_CTRL_C1 0xEE1C
#define B_AX_RXD_FIFO_MAX_LEV_CLR BIT(23)
#define B_AX_RXD_FIFO_MAX_LEV_SH 8
#define B_AX_RXD_FIFO_MAX_LEV_MSK 0xff
#define B_AX_RXD_FIFO_FULL_TH_SH 0
#define B_AX_RXD_FIFO_FULL_TH_MSK 0xff

#define R_AX_RX_FLTR_OPT 0xCE20
#define R_AX_RX_FLTR_OPT_C1 0xEE20
#define B_AX_UID_FILTER_SH 24
#define B_AX_UID_FILTER_MSK 0xff
#define B_AX_UNSPT_FILTER_SH 22
#define B_AX_UNSPT_FILTER_MSK 0x3
#define B_AX_RX_MPDU_MAX_LEN_SH 16
#define B_AX_RX_MPDU_MAX_LEN_MSK 0x3f
#define B_AX_A_FTM_REQ BIT(14)
#define B_AX_A_ERR_PKT BIT(13)
#define B_AX_A_UNSUP_PKT BIT(12)
#define B_AX_A_CRC32_ERR BIT(11)
#define B_AX_A_PWR_MGNT BIT(10)
#define B_AX_A_BCN_CHK_RULE_SH 8
#define B_AX_A_BCN_CHK_RULE_MSK 0x3
#define B_AX_A_BCN_CHK_EN BIT(7)
#define B_AX_A_MC_LIST_CAM_MATCH BIT(6)
#define B_AX_A_BC_CAM_MATCH BIT(5)
#define B_AX_A_UC_CAM_MATCH BIT(4)
#define B_AX_A_MC BIT(3)
#define B_AX_A_BC BIT(2)
#define B_AX_A_A1_MATCH BIT(1)
#define B_AX_SNIFFER_MODE BIT(0)

#define R_AX_CTRL_FLTR 0xCE24
#define R_AX_CTRL_FLTR_C1 0xEE24
#define B_AX_A_CTRL15_SH 30
#define B_AX_A_CTRL15_MSK 0x3
#define B_AX_A_CTRL14_SH 28
#define B_AX_A_CTRL14_MSK 0x3
#define B_AX_A_CTRL13_SH 26
#define B_AX_A_CTRL13_MSK 0x3
#define B_AX_A_CTRL12_SH 24
#define B_AX_A_CTRL12_MSK 0x3
#define B_AX_A_CTRL11_SH 22
#define B_AX_A_CTRL11_MSK 0x3
#define B_AX_A_CTRL10_SH 20
#define B_AX_A_CTRL10_MSK 0x3
#define B_AX_A_CTRL9_SH 18
#define B_AX_A_CTRL9_MSK 0x3
#define B_AX_A_CTRL8_SH 16
#define B_AX_A_CTRL8_MSK 0x3
#define B_AX_A_CTRL7_SH 14
#define B_AX_A_CTRL7_MSK 0x3
#define B_AX_A_CTRL6_SH 12
#define B_AX_A_CTRL6_MSK 0x3
#define B_AX_A_CTRL5_SH 10
#define B_AX_A_CTRL5_MSK 0x3
#define B_AX_A_CTRL4_SH 8
#define B_AX_A_CTRL4_MSK 0x3
#define B_AX_A_CTRL3_SH 6
#define B_AX_A_CTRL3_MSK 0x3
#define B_AX_A_CTRL2_SH 4
#define B_AX_A_CTRL2_MSK 0x3
#define B_AX_A_CTRL1_SH 2
#define B_AX_A_CTRL1_MSK 0x3
#define B_AX_A_CTRL0_SH 0
#define B_AX_A_CTRL0_MSK 0x3

#define R_AX_MGNT_FLTR 0xCE28
#define R_AX_MGNT_FLTR_C1 0xEE28
#define B_AX_A_MGNT15_SH 30
#define B_AX_A_MGNT15_MSK 0x3
#define B_AX_A_MGNT14_SH 28
#define B_AX_A_MGNT14_MSK 0x3
#define B_AX_A_MGNT13_SH 26
#define B_AX_A_MGNT13_MSK 0x3
#define B_AX_A_MGNT12_SH 24
#define B_AX_A_MGNT12_MSK 0x3
#define B_AX_A_MGNT11_SH 22
#define B_AX_A_MGNT11_MSK 0x3
#define B_AX_A_MGNT10_SH 20
#define B_AX_A_MGNT10_MSK 0x3
#define B_AX_A_MGNT9_SH 18
#define B_AX_A_MGNT9_MSK 0x3
#define B_AX_A_MGNT8_SH 16
#define B_AX_A_MGNT8_MSK 0x3
#define B_AX_A_MGNT7_SH 14
#define B_AX_A_MGNT7_MSK 0x3
#define B_AX_A_MGNT6_SH 12
#define B_AX_A_MGNT6_MSK 0x3
#define B_AX_A_MGNT5_SH 10
#define B_AX_A_MGNT5_MSK 0x3
#define B_AX_A_MGNT4_SH 8
#define B_AX_A_MGNT4_MSK 0x3
#define B_AX_A_MGNT3_SH 6
#define B_AX_A_MGNT3_MSK 0x3
#define B_AX_A_MGNT2_SH 4
#define B_AX_A_MGNT2_MSK 0x3
#define B_AX_A_MGNT1_SH 2
#define B_AX_A_MGNT1_MSK 0x3
#define B_AX_A_MGNT0_SH 0
#define B_AX_A_MGNT0_MSK 0x3

#define R_AX_DATA_FLTR 0xCE2C
#define R_AX_DATA_FLTR_C1 0xEE2C
#define B_AX_A_DATA15_SH 30
#define B_AX_A_DATA15_MSK 0x3
#define B_AX_A_DATA14_SH 28
#define B_AX_A_DATA14_MSK 0x3
#define B_AX_A_DATA13_SH 26
#define B_AX_A_DATA13_MSK 0x3
#define B_AX_A_DATA12_SH 24
#define B_AX_A_DATA12_MSK 0x3
#define B_AX_A_DATA11_SH 22
#define B_AX_A_DATA11_MSK 0x3
#define B_AX_A_DATA10_SH 20
#define B_AX_A_DATA10_MSK 0x3
#define B_AX_A_DATA9_SH 18
#define B_AX_A_DATA9_MSK 0x3
#define B_AX_A_DATA8_SH 16
#define B_AX_A_DATA8_MSK 0x3
#define B_AX_A_DATA7_SH 14
#define B_AX_A_DATA7_MSK 0x3
#define B_AX_A_DATA6_SH 12
#define B_AX_A_DATA6_MSK 0x3
#define B_AX_A_DATA5_SH 10
#define B_AX_A_DATA5_MSK 0x3
#define B_AX_A_DATA4_SH 8
#define B_AX_A_DATA4_MSK 0x3
#define B_AX_A_DATA3_SH 6
#define B_AX_A_DATA3_MSK 0x3
#define B_AX_A_DATA2_SH 4
#define B_AX_A_DATA2_MSK 0x3
#define B_AX_A_DATA1_SH 2
#define B_AX_A_DATA1_MSK 0x3
#define B_AX_A_DATA0_SH 0
#define B_AX_A_DATA0_MSK 0x3

#define R_AX_ZLENDEL_COUNT 0xCE30
#define R_AX_ZLENDEL_COUNT_C1 0xEE30
#define B_AX_RXD_DELI_NUM_SH 8
#define B_AX_RXD_DELI_NUM_MSK 0xff
#define B_AX_RXD_DELI_NUM_SEL_SH 4
#define B_AX_RXD_DELI_NUM_SEL_MSK 0xf
#define B_AX_RXD_DELI_UNIT_SH 1
#define B_AX_RXD_DELI_UNIT_MSK 0x3
#define B_AX_RXD_DELI_EN BIT(0)

#define R_AX_ADDR_CAM_CTRL 0xCE34
#define R_AX_ADDR_CAM_CTRL_C1 0xEE34
#define B_AX_ADDR_CAM_RANGE_SH 16
#define B_AX_ADDR_CAM_RANGE_MSK 0xff
#define B_AX_ADDR_CAM_CMPLIMT_SH 12
#define B_AX_ADDR_CAM_CMPLIMT_MSK 0xf
#define B_AX_ADDR_CAM_CLR BIT(8)
#define B_AX_ADDR_CAM_A2_B0_CHK BIT(2)
#define B_AX_ADDR_CAM_SRCH_PERPKT BIT(1)
#define B_AX_ADDR_CAM_EN BIT(0)

#define R_AX_ADDR_CAM_DIS_INFO 0xCE38
#define R_AX_ADDR_CAM_DIS_INFO_C1 0xEE38
#define B_AX_ADDR_CAM_DIS_MACID_SH 24
#define B_AX_ADDR_CAM_DIS_MACID_MSK 0xff
#define B_AX_ADDR_CAM_DIS_SEC_IDX_SH 16
#define B_AX_ADDR_CAM_DIS_SEC_IDX_MSK 0xff
#define B_AX_ADDR_CAM_DIS_PORT_SH 12
#define B_AX_ADDR_CAM_DIS_PORT_MSK 0x7
#define B_AX_ADDR_CAM_DIS_A3_HIT BIT(11)
#define B_AX_ADDR_CAM_DIS_A2_HIT BIT(10)
#define B_AX_ADDR_CAM_DIS_A1_HIT BIT(9)
#define B_AX_ADDR_CAM_DIS_CAM_HIT BIT(8)
#define B_AX_ADDR_CAM_DIS_IDX_SH 0
#define B_AX_ADDR_CAM_DIS_IDX_MSK 0xff

#define R_AX_RESPBA_CAM_CTRL 0xCE3C
#define R_AX_RESPBA_CAM_CTRL_C1 0xEE3C
#define B_AX_DEST_ENTRY_IDX_SH 12
#define B_AX_DEST_ENTRY_IDX_MSK 0xf
#define B_AX_SRC_ENTRY_IDX_SH 8
#define B_AX_SRC_ENTRY_IDX_MSK 0xf
#define B_AX_BACAM_SHIFT_POLL BIT(7)
#define B_AX_BACAM_ENT_CFG BIT(4)
#define B_AX_COMPL_VAL BIT(3)
#define B_AX_SSN_SEL BIT(2)
#define B_AX_BACAM_RST_SH 0
#define B_AX_BACAM_RST_MSK 0x3

#define R_AX_PPDU_STAT 0xCE40
#define R_AX_PPDU_STAT_C1 0xEE40
#define B_AX_PPDU_STAT_RPT_TRIG BIT(8)
#define B_AX_PPDU_STAT_RPT_CRC32 BIT(5)
#define B_AX_PPDU_STAT_RPT_A1M BIT(4)
#define B_AX_APP_PLCP_HDR_RPT BIT(3)
#define B_AX_APP_RX_CNT_RPT BIT(2)
#define B_AX_APP_MAC_INFO_RPT BIT(1)
#define B_AX_PPDU_STAT_RPT_EN BIT(0)

#define R_AX_PPDU_STAT_ERR 0xCE42
#define R_AX_PPDU_STAT_ERR_C1 0xEE42
#define B_AX_PPDU_STAT_ERR_3_CLR BIT(6)
#define B_AX_PPDU_STAT_ERR_2_CLR BIT(5)
#define B_AX_PPDU_STAT_ERR_1_CLR BIT(4)
#define B_AX_PPDU_STAT_ERR_3 BIT(2)
#define B_AX_PPDU_STAT_ERR_2 BIT(1)
#define B_AX_PPDU_STAT_ERR_1 BIT(0)

#define R_AX_CH_INFO_QRY 0xCE44
#define R_AX_CH_INFO_QRY_C1 0xEE44
#define B_AX_CH_INFO_TIME_SH 24
#define B_AX_CH_INFO_TIME_MSK 0xff
#define B_AX_CH_INFO_CNT_SH 21
#define B_AX_CH_INFO_CNT_MSK 0x7
#define B_AX_CH_INFO_REQUSTING BIT(20)
#define B_AX_CH_INFO_MGNT_FRM BIT(19)
#define B_AX_CH_INFO_CTRL_FRM BIT(18)
#define B_AX_CH_INFO_DATA_FRM BIT(17)
#define B_AX_CH_INFO_CRC_FAIL BIT(16)
#define B_AX_CH_INFO_MACID_SH 8
#define B_AX_CH_INFO_MACID_MSK 0xff
#define B_AX_CH_INFO_MODE_SH 1
#define B_AX_CH_INFO_MODE_MSK 0x7
#define B_AX_GET_CH_INFO_EN BIT(0)

#define R_AX_MACID_MATCH 0xCE48
#define R_AX_MACID_MATCH_C1 0xEE48
#define B_AX_MACID_MATCH_SH 8
#define B_AX_MACID_MATCH_MSK 0xff
#define B_AX_MACID_MATCH_MODE BIT(1)
#define B_AX_MACID_MATCH_EN BIT(0)

#define R_AX_RX_SR_CTRL 0xCE4A
#define R_AX_RX_SR_CTRL_C1 0xEE4A
#define B_AX_SR_OP_MODE_SH 4
#define B_AX_SR_OP_MODE_MSK 0x3
#define B_AX_SRG_CHK_EN BIT(2)
#define B_AX_SR_CTRL_PLCP_EN BIT(1)
#define B_AX_SR_EN BIT(0)

#define R_AX_BSSID_SRC_CTRL 0xCE4B
#define R_AX_BSSID_SRC_CTRL_C1 0xEE4B
#define B_AX_BSSID_MATCH BIT(3)
#define B_AX_PARTIAL_AID_MATCH BIT(2)
#define B_AX_BSSCOLOR_MATCH BIT(1)
#define B_AX_PLCP_SRC_EN BIT(0)

#define R_AX_SR_OBSS_PD 0xCE4C
#define R_AX_SR_OBSS_PD_C1 0xEE4C
#define B_AX_SRG_OBSS_PD_MAX_SH 24
#define B_AX_SRG_OBSS_PD_MAX_MSK 0xff
#define B_AX_SRG_OBSS_PD_MIN_SH 16
#define B_AX_SRG_OBSS_PD_MIN_MSK 0xff
#define B_AX_NONSRG_OBSS_PD_MAX_SH 8
#define B_AX_NONSRG_OBSS_PD_MAX_MSK 0xff
#define B_AX_NONSRG_OBSS_PD_MIN_SH 0
#define B_AX_NONSRG_OBSS_PD_MIN_MSK 0xff

#define R_AX_SR_BSSCOLOR_BITMAP 0xCE50
#define R_AX_SR_BSSCOLOR_BITMAP_C1 0xEE50
#define B_AX_BSSCOLOR_BITMAP_SH 0
#define B_AX_BSSCOLOR_BITMAP_MSK 0xffffffffffffffffL

#define R_AX_SR_PARTIAL_BSSCOLOR_BITMAP 0xCE58
#define R_AX_SR_PARTIAL_BSSCOLOR_BITMAP_C1 0xEE58
#define B_AX_PARTIAL_BSSID_BITMAP_SH 0
#define B_AX_PARTIAL_BSSID_BITMAP_MSK 0xffffffffffffffffL

#define R_AX_SEGMENT_CTRL 0xCE60
#define R_AX_SEGMENT_CTRL_C1 0xEE60
#define B_AX_SEG_LENGTH_SH 4
#define B_AX_SEG_LENGTH_MSK 0xf
#define B_AX_SEG_APP_ZERO BIT(1)
#define B_AX_SEG_EN BIT(0)
#define B_AX_CSIRPT_CHKSUM_ERROR BIT(31)
#define B_AX_CSIRPT_BBLEN_LT_MAC BIT(30)
#define B_AX_CSIRPT_BBLEN_GT_MAC BIT(29)
#define B_AX_CSIRPT_FIFO_RESUME_THR_SH 16
#define B_AX_CSIRPT_FIFO_RESUME_THR_MSK 0xff
#define B_AX_CSIRPT_FIFO_PAUSE_THR_SH 8
#define B_AX_CSIRPT_FIFO_PAUSE_THR_MSK 0xff
#define B_AX_CSIRPT_CHECKSUM_DIS BIT(2)
#define B_AX_CSIRPT_EMPTY_APPZERO BIT(1)
#define B_AX_CSIRPT_NDPPLCP_CHK_EN BIT(0)
#define B_AX_QSIZE_UPD BIT(0)

#define R_AX_BCN_PSR_CTRL 0xCE80
#define R_AX_BCN_PSR_CTRL_C1 0xEE80
#define B_AX_BCN_HIT_INT_PORT_SH 4
#define B_AX_BCN_HIT_INT_PORT_MSK 0xf
#define B_AX_BCAID_HIT_INT_EN BIT(3)
#define B_AX_UNIAID_HIT_INT_EN BIT(2)
#define B_AX_IE_HIT_INT_EN BIT(1)
#define B_AX_TIM_PARSER_EN BIT(0)

#define R_AX_BCN_IECAM_CTRL 0xCE82
#define R_AX_BCN_IECAM_CTRL_C1 0xEE82
#define B_AX_BCN_PSR_BUSY BIT(15)
#define B_AX_BCN_IECAM_IORST BIT(14)
#define B_AX_BCN_IE_NOHIT_FRWD_SH 10
#define B_AX_BCN_IE_NOHIT_FRWD_MSK 0x3
#define B_AX_BCN_IE_HIT_FRWD_SH 8
#define B_AX_BCN_IE_HIT_FRWD_MSK 0x3
#define B_AX_BCN_IECAM_PORT_SH 4
#define B_AX_BCN_IECAM_PORT_MSK 0xf
#define B_AX_BCN_IECAM_CLR BIT(3)
#define B_AX_BCN_IE_NOHIT_FRWD_EN BIT(2)
#define B_AX_BCN_IE_HIT_FRWD_EN BIT(1)
#define B_AX_BCN_IECAM_EN BIT(0)

#define R_AX_BCN_PSR_RPT_P0 0xCE84
#define R_AX_BCN_PSR_RPT_P0_C1 0xEE84
#define B_AX_DTIM_CNT_P0_SH 24
#define B_AX_DTIM_CNT_P0_MSK 0xff
#define B_AX_DTIM_PERIOD_P0_SH 16
#define B_AX_DTIM_PERIOD_P0_MSK 0xff
#define B_AX_BCAID_HIT_P0 BIT(15)
#define B_AX_UNIAID_HIT_P0 BIT(14)
#define B_AX_IE_HIT_P0 BIT(13)
#define B_AX_TIM_ILEGAL_P0 BIT(12)
#define B_AX_RPT_VALID_P0 BIT(11)
#define B_AX_BCAID_P0_SH 0
#define B_AX_BCAID_P0_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P1 0xCE88
#define R_AX_BCN_PSR_RPT_P1_C1 0xEE88
#define B_AX_DTIM_CNT_P1_SH 24
#define B_AX_DTIM_CNT_P1_MSK 0xff
#define B_AX_DTIM_PERIOD_P1_SH 16
#define B_AX_DTIM_PERIOD_P1_MSK 0xff
#define B_AX_BCAID_HIT_P1 BIT(15)
#define B_AX_UNIAID_HIT_P1 BIT(14)
#define B_AX_IE_HIT_P1 BIT(13)
#define B_AX_TIM_ILEGAL_P1 BIT(12)
#define B_AX_RPT_VALID_P1 BIT(11)
#define B_AX_BCAID_P1_SH 0
#define B_AX_BCAID_P1_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P2 0xCE8C
#define R_AX_BCN_PSR_RPT_P2_C1 0xEE8C
#define B_AX_DTIM_CNT_P2_SH 24
#define B_AX_DTIM_CNT_P2_MSK 0xff
#define B_AX_DTIM_PERIOD_P2_SH 16
#define B_AX_DTIM_PERIOD_P2_MSK 0xff
#define B_AX_BCAID_HIT_P2 BIT(15)
#define B_AX_UNIAID_HIT_P2 BIT(14)
#define B_AX_IE_HIT_P2 BIT(13)
#define B_AX_TIM_ILEGAL_P2 BIT(12)
#define B_AX_RPT_VALID_P2 BIT(11)
#define B_AX_BCAID_P2_SH 0
#define B_AX_BCAID_P2_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P3 0xCE90
#define R_AX_BCN_PSR_RPT_P3_C1 0xEE90
#define B_AX_DTIM_CNT_P3_SH 24
#define B_AX_DTIM_CNT_P3_MSK 0xff
#define B_AX_DTIM_PERIOD_P3_SH 16
#define B_AX_DTIM_PERIOD_P3_MSK 0xff
#define B_AX_BCAID_HIT_P3 BIT(15)
#define B_AX_UNIAID_HIT_P3 BIT(14)
#define B_AX_IE_HIT_P3 BIT(13)
#define B_AX_TIM_ILEGAL_P3 BIT(12)
#define B_AX_RPT_VALID_P3 BIT(11)
#define B_AX_BCAID_P3_SH 0
#define B_AX_BCAID_P3_MSK 0x7ff

#define R_AX_BCN_PSR_RPT_P4 0xCE94
#define R_AX_BCN_PSR_RPT_P4_C1 0xEE94
#define B_AX_DTIM_CNT_P4_SH 24
#define B_AX_DTIM_CNT_P4_MSK 0xff
#define B_AX_DTIM_PERIOD_P4_SH 16
#define B_AX_DTIM_PERIOD_P4_MSK 0xff
#define B_AX_BCAID_HIT_P4 BIT(15)
#define B_AX_UNIAID_HIT_P4 BIT(14)
#define B_AX_IE_HIT_P4 BIT(13)
#define B_AX_TIM_ILEGAL_P4 BIT(12)
#define B_AX_RPT_VALID_P4 BIT(11)
#define B_AX_BCAID_P4_SH 0
#define B_AX_BCAID_P4_MSK 0x7ff

#define R_AX_PS_RXINFO 0xCEA0
#define R_AX_PS_RXINFO_C1 0xEEA0
#define B_AX_P4_RXCTRL BIT(14)
#define B_AX_P4_RXMGT BIT(13)
#define B_AX_P4_RXDATA BIT(12)
#define B_AX_P3_RXCTRL BIT(11)
#define B_AX_P3_RXMGT BIT(10)
#define B_AX_P3_RXDATA BIT(9)
#define B_AX_P2_RXCTRL BIT(8)
#define B_AX_P2_RXMGT BIT(7)
#define B_AX_P2_RXDATA BIT(6)
#define B_AX_P1_RXCTRL BIT(5)
#define B_AX_P1_RXMGT BIT(4)
#define B_AX_P1_RXDATA BIT(3)
#define B_AX_P0_RXCTRL BIT(2)
#define B_AX_P0_RXMGT BIT(1)
#define B_AX_P0_RXDATA BIT(0)

#define R_AX_PWRINT_CTRL 0xCEAC
#define R_AX_PWRINT_CTRL_C1 0xEEAC
#define B_AX_SEQNUM_MACID_SH 16
#define B_AX_SEQNUM_MACID_MSK 0xffff
#define B_AX_REF_MACID_SH 8
#define B_AX_REF_MACID_MSK 0x7f
#define B_AX_PWRINT_EN BIT(0)

#define R_AX_SPWR0 0xCEB0
#define R_AX_SPWR0_C1 0xEEB0
#define B_AX_MID_31TO0_SH 0
#define B_AX_MID_31TO0_MSK 0xffffffffL

#define R_AX_SPWR1 0xCEB4
#define R_AX_SPWR1_C1 0xEEB4
#define B_AX_MID_63TO32_SH 0
#define B_AX_MID_63TO32_MSK 0xffffffffL

#define R_AX_SPWR2 0xCEB8
#define R_AX_SPWR2_C1 0xEEB8
#define B_AX_MID_95O64_SH 0
#define B_AX_MID_95O64_MSK 0xffffffffL

#define R_AX_SPWR3 0xCEBC
#define R_AX_SPWR3_C1 0xEEBC
#define B_AX_MID_127TO96_SH 0
#define B_AX_MID_127TO96_MSK 0xffffffffL

#define R_AX_SNIFFER_MODE_CTRL 0xCEC0
#define R_AX_SNIFFER_MODE_CTRL_C1 0xEEC0
#define B_AX_AID3_ENABLE BIT(3)
#define B_AX_AID2_ENABLE BIT(2)
#define B_AX_AID1_ENABLE BIT(1)
#define B_AX_AID0_ENABLE BIT(0)

#define R_AX_SNIFFER_MODE_AID0 0xCEC4
#define R_AX_SNIFFER_MODE_AID0_C1 0xEEC4
#define B_AX_SNIFFER_MODE_AID1_SH 16
#define B_AX_SNIFFER_MODE_AID1_MSK 0xfff
#define B_AX_SNIFFER_MODE_AID0_SH 0
#define B_AX_SNIFFER_MODE_AID0_MSK 0xfff

#define R_AX_SNIFFER_MODE_AID1 0xCEC8
#define R_AX_SNIFFER_MODE_AID1_C1 0xEEC8
#define B_AX_SNIFFER_MODE_AID3_SH 16
#define B_AX_SNIFFER_MODE_AID3_MSK 0xfff
#define B_AX_SNIFFER_MODE_AID2_SH 0
#define B_AX_SNIFFER_MODE_AID2_MSK 0xfff

#define R_AX_RX_DBG_CNT_SEL 0xCEE0
#define R_AX_RX_DBG_CNT_SEL_C1 0xEEE0
#define B_AX_RX_DBG_CNT_SH 16
#define B_AX_RX_DBG_CNT_MSK 0xffff
#define B_AX_RXERR_RPT_RST BIT(8)
#define B_AX_RX_CNT_IDX_SH 0
#define B_AX_RX_CNT_IDX_MSK 0x3f

#define R_AX_RX_DBG_CNT_UD 0xCEE4
#define R_AX_RX_DBG_CNT_UD_C1 0xEEE4
#define B_AX_UD_W1S BIT(31)
#define B_AX_UD_MSK_RUTONE BIT(30)
#define B_AX_UD_MSK_RATE BIT(29)
#define B_AX_UD_MSK_BSSID BIT(28)
#define B_AX_UD_MSK_FC BIT(27)
#define B_AX_UD_RUTONE_SH 24
#define B_AX_UD_RUTONE_MSK 0x7
#define B_AX_UD_GI_TYPE_SH 20
#define B_AX_UD_GI_TYPE_MSK 0x7
#define B_AX_UD_RATE_SH 11
#define B_AX_UD_RATE_MSK 0x1ff
#define B_AX_UD_SELECT_BSSID_SH 8
#define B_AX_UD_SELECT_BSSID_MSK 0x7
#define B_AX_UD_SUB_TYPE_SH 2
#define B_AX_UD_SUB_TYPE_MSK 0xf
#define B_AX_UD_TYPE_SH 0
#define B_AX_UD_TYPE_MSK 0x3

#define R_AX_RX_TIME_MON 0xCEEC
#define R_AX_RX_TIME_MON_C1 0xEEEC
#define B_AX_DMA_WR_TIME_SH 20
#define B_AX_DMA_WR_TIME_MSK 0xf
#define B_AX_DMA_WR_TIMEOUT_SH 16
#define B_AX_DMA_WR_TIMEOUT_MSK 0xf
#define B_AX_LATENCY_TIME_SH 8
#define B_AX_LATENCY_TIME_MSK 0xf
#define B_AX_CCA2DAT_TIME_SH 0
#define B_AX_CCA2DAT_TIME_MSK 0xff

#define R_AX_RX_STATE_MONITOR 0xCEF0
#define R_AX_RX_STATE_MONITOR_C1 0xEEF0
#define B_AX_STATE_CUR_SH 16
#define B_AX_STATE_CUR_MSK 0xffff
#define B_AX_STATE_NXT_SH 8
#define B_AX_STATE_NXT_MSK 0x3f
#define B_AX_STATE_UPD BIT(7)
#define B_AX_STATE_SEL_SH 0
#define B_AX_STATE_SEL_MSK 0x1f

#define R_AX_RMAC_ERR_ISR 0xCEF4
#define R_AX_RMAC_ERR_ISR_C1 0xEEF4
#define B_AX_RXERR_INTPS_EN BIT(31)
#define B_AX_RMAC_RX_CSI_TIMEOUT_INT_EN BIT(19)
#define B_AX_RMAC_RX_TIMEOUT_INT_EN BIT(18)
#define B_AX_RMAC_CSI_TIMEOUT_INT_EN (17)
#define B_AX_RMAC_DATA_ON_TIMEOUT_INT_EN BIT(16)
#define B_AX_RMAC_CCA_TIMEOUT_INT_EN BIT(15)
#define B_AX_RMAC_DMA_TIMEOUT_INT_EN BIT(14)
#define B_AX_RMAC_DATA_ON_TO_IDLE_TIMEOUT_INT_EN BIT(13)
#define B_AX_RMAC_CCA_TO_IDLE_TIMEOUT_INT_EN BIT(12)
#define B_AX_RMAC_RX_CSI_TIMEOUT_FLAG BIT(7)
#define B_AX_RMAC_RX_TIMEOUT_FLAG BIT(6)
#define B_AX_BMAC_CSI_TIMEOUT_FLAG BIT(5)
#define B_AX_BMAC_DATA_ON_TIMEOUT_FLAG BIT(4)
#define B_AX_BMAC_CCA_TIMEOUT_FLAG BIT(3)
#define B_AX_BMAC_DMA_TIMEOUT_FLAG BIT(2)
#define B_AX_BMAC_DATA_ON_TO_IDLE_TIMEOUT_FLAG BIT(1)
#define B_AX_BMAC_CCA_TO_IDLE_TIMEOUT_FLAG BIT(0)

#define R_AX_RMAC_PLCP_MON 0xCEF8
#define R_AX_RMAC_PLCP_MON_C1 0xEEF8
#define B_AX_PCLP_MON_SEL_SH 28
#define B_AX_PCLP_MON_SEL_MSK 0xf
#define B_AX_PCLP_MON_CONT_SH 0
#define B_AX_PCLP_MON_CONT_MSK 0xfffffff

#define R_AX_RX_DEBUG_SELECT 0xCEFC
#define R_AX_RX_DEBUG_SELECT_C1 0xEEFC
#define B_AX_DEBUG_SEL_SH 0
#define B_AX_DEBUG_SEL_MSK 0xff

//
// PWR
//

#define R_AX_PWR_RATE_CTRL 0xD200
#define R_AX_PWR_RATE_CTRL_C1 0xF200
#define B_AX_TXPWR_CTRL_CLR BIT(31)
#define B_AX_FORCE_MODE_IDX_SH 28
#define B_AX_FORCE_MODE_IDX_MSK 0x7
#define B_AX_TXAGC_OFDM_REF_SH 19
#define B_AX_TXAGC_OFDM_REF_MSK 0x1ff
#define B_AX_TXAGC_CCK_REF_SH 10
#define B_AX_TXAGC_CCK_REF_MSK 0x1ff
#define B_AX_FORCE_PWR_BY_RATE_EN BIT(9)
#define B_AX_FORCE_PWR_BY_RATE_VALUE_SH 0
#define B_AX_FORCE_PWR_BY_RATE_VALUE_MSK 0x1ff

#define R_AX_PWR_RATE_OFST_CTRL 0xD204
#define R_AX_PWR_RATE_OFST_CTRL_C1 0xF204
#define B_AX_TXAGC_TBL_RD BIT(26)
#define B_AX_TXAGC_TBL_RA_SH 20
#define B_AX_TXAGC_TBL_RA_MSK 0x3f
#define B_AX_TXAGC_CCK_HT_OFFSET_SH 16
#define B_AX_TXAGC_CCK_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_LEGACY_HT_OFFSET_SH 12
#define B_AX_TXAGC_LEGACY_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_HT_OFFSET_SH 8
#define B_AX_TXAGC_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_VHT_HT_OFFSET_SH 4
#define B_AX_TXAGC_VHT_HT_OFFSET_MSK 0xf
#define B_AX_TXAGC_HE_HT_OFFSET_SH 0
#define B_AX_TXAGC_HE_HT_OFFSET_MSK 0xf

#define R_AX_PWR_LMT_CTRL 0xD208
#define R_AX_PWR_LMT_CTRL_C1 0xF208
#define B_AX_FORCE_NORM_RSP_HE_TB_EN_ON BIT(24)
#define B_AX_FORCE_PWR_BY_LIMIT_BF0_EN BIT(23)
#define B_AX_FORCE_PWR_BY_LIMIT_BF1_EN BIT(22)
#define B_AX_TXAGC_PWR_LIM_BF0_EN BIT(21)
#define B_AX_TXAGC_PWR_LIM_BF1_EN BIT(20)
#define B_AX_TXAGC_BW20_BW40_OFFSET_SH 16
#define B_AX_TXAGC_BW20_BW40_OFFSET_MSK 0xf
#define B_AX_TXAGC_RFBW_40M_OFFSET_SH 12
#define B_AX_TXAGC_RFBW_40M_OFFSET_MSK 0xf
#define B_AX_TXAGC_BW80_BW40_OFFSET_SH 8
#define B_AX_TXAGC_BW80_BW40_OFFSET_MSK 0xf
#define B_AX_TXAGC_BW160_BW40_OFFSET_SH 4
#define B_AX_TXAGC_BW160_BW40_OFFSET_MSK 0xf
#define B_AX_TXAGC_BW80_80_BW40_OFFSET_SH 0
#define B_AX_TXAGC_BW80_80_BW40_OFFSET_MSK 0xf

#define R_AX_PWR_MACID_CTRL 0xD20C
#define R_AX_PWR_MACID_CTRL_C1 0xF20C
#define B_AX_TXAGC_PWR_BY_MACID_EN BIT(29)
#define B_AX_FORCE_CCA_PWR_TH_VALUE_EN BIT(28)
#define B_AX_FORCE_CCA_PWR_TH_VALUE_SH 20
#define B_AX_FORCE_CCA_PWR_TH_VALUE_MSK 0xff
#define B_AX_FORCE_CCA_PWR_TH_EN BIT(17)
#define B_AX_FORCE_PWR_BY_MACID_EN BIT(16)
#define B_AX_FORCE_PWR_BY_MACID_VALUE_SH 8
#define B_AX_FORCE_PWR_BY_MACID_VALUE_MSK 0xff
#define B_AX_FORCE_PWR_BY_MACID_VALUE_EN BIT(7)
#define B_AX_TXPWR_LIM_TBL_RD BIT(6)
#define B_AX_TXPWR_LIM_TBL_RA_SH 0
#define B_AX_TXPWR_LIM_TBL_RA_MSK 0x3f

#define R_AX_PWR_BF_CTRL 0xD210
#define R_AX_PWR_BF_CTRL_C1 0xF210
#define B_AX_TXAGC_BF_PWR_BOOST_EN BIT(31)
#define B_AX_HE_ER_SU_PWR_REDUCE_VAL_SH 19
#define B_AX_HE_ER_SU_PWR_REDUCE_VAL_MSK 0x1f
#define B_AX_HE_ER_SU_PWR_REDUCE_EN BIT(18)
#define B_AX_FORCE_PWR_BY_LIMIT_BFOFF_VALUE_SH 9
#define B_AX_FORCE_PWR_BY_LIMIT_BFOFF_VALUE_MSK 0x1ff
#define B_AX_FORCE_PWR_BY_LIMIT_BFON_VALUE_SH 0
#define B_AX_FORCE_PWR_BY_LIMIT_BFON_VALUE_MSK 0x1ff

#define R_AX_PWR_MACID_REG 0xD214
#define R_AX_PWR_MACID_REG_C1 0xF214
#define B_AX_TXPWR_REG3_SH 24
#define B_AX_TXPWR_REG3_MSK 0xff
#define B_AX_TXPWR_REG2_SH 16
#define B_AX_TXPWR_REG2_MSK 0xff
#define B_AX_TXPWR_REG1_SH 8
#define B_AX_TXPWR_REG1_MSK 0xff
#define B_AX_TXPWR_REG0_SH 0
#define B_AX_TXPWR_REG0_MSK 0xff

#define R_AX_PWR_MACID_REG2 0xD218
#define R_AX_PWR_MACID_REG2_C1 0xF218
#define B_AX_TXPWR_BY_MACID_TBL_RD BIT(31)
#define B_AX_TXPWR_BY_MACID_TBL_RA_SH 24
#define B_AX_TXPWR_BY_MACID_TBL_RA_MSK 0x7f
#define B_AX_TXPWR_REG5_EN BIT(21)
#define B_AX_TXPWR_REG4_EN BIT(20)
#define B_AX_TXPWR_REG3_EN BIT(19)
#define B_AX_TXPWR_REG2_EN BIT(18)
#define B_AX_TXPWR_REG1_EN BIT(17)
#define B_AX_TXPWR_REG0_EN BIT(16)
#define B_AX_TXPWR_REG5_SH 8
#define B_AX_TXPWR_REG5_MSK 0xff
#define B_AX_TXPWR_REG4_SH 0
#define B_AX_TXPWR_REG4_MSK 0xff

#define R_AX_PWR_RU_LMT_CTRL 0xD21C
#define R_AX_PWR_RU_LMT_CTRL_C1 0xF21C
#define B_AX_TXAGC_LTE_SH 18
#define B_AX_TXAGC_LTE_MSK 0x1ff
#define B_AX_TXPWR_RU_LIM_EN BIT(17)
#define B_AX_TXPWR_RU_LIM_TBL_RD BIT(16)
#define B_AX_TXPWR_RU_LIM_TBL_RA_SH 11
#define B_AX_TXPWR_RU_LIM_TBL_RA_MSK 0x1f
#define B_AX_FORCE_PWR_BY_RU_LIMIT_EN BIT(10)
#define B_AX_FORCE_PWR_BY_RU_LIMIT_EN_VALUE BIT(9)
#define B_AX_FORCE_PWR_BY_RU_LIMIT_VALUE_SH 0
#define B_AX_FORCE_PWR_BY_RU_LIMIT_VALUE_MSK 0x1ff

#define R_AX_PWR_COEXT_CTRL 0xD220
#define R_AX_PWR_COEXT_CTRL_C1 0xF220
#define B_AX_CCK_NORM_TERM_SH 18
#define B_AX_CCK_NORM_TERM_MSK 0x7f
#define B_AX_TXPWR_MAC_MAX_BND_SH 12
#define B_AX_TXPWR_MAC_MAX_BND_MSK 0x3f
#define B_AX_TXAGC_BT_SH 3
#define B_AX_TXAGC_BT_MSK 0x1ff
#define B_AX_TXAGC_LTE_EN BIT(2)
#define B_AX_TXAGC_BT_EN BIT(1)

#define R_AX_PWR_SWING_LEG_CTRL 0xD224
#define R_AX_PWR_SWING_LEG_CTRL_C1 0xF224
#define B_AX_TXBIAS_LEGACY_BELOW_TH_VAL_SH 29
#define B_AX_TXBIAS_LEGACY_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_LEGACY_OV_TH_VAL_SH 27
#define B_AX_TXBIAS_LEGACY_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_LEGACY_BELOW_TH_VAL_SH 23
#define B_AX_TXBBSWING_LEGACY_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_LEGACY_OV_TH_VAL_SH 19
#define B_AX_TXBBSWING_LEGACY_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_LEGACY_TH_SH 15
#define B_AX_TXBBSWING_TXBIAS_LEGACY_TH_MSK 0xf
#define B_AX_TXBIAS_CCK_BELOW_TH_VAL_SH 13
#define B_AX_TXBIAS_CCK_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_CCK_OV_TH_VAL_SH 11
#define B_AX_TXBIAS_CCK_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_CCK_BELOW_TH_VAL_SH 7
#define B_AX_TXBBSWING_CCK_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_CCK_OV_TH_VAL_SH 3
#define B_AX_TXBBSWING_CCK_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_CCK_TH_SH 0
#define B_AX_TXBBSWING_TXBIAS_CCK_TH_MSK 0x7

#define R_AX_PWR_SWING_VHT_CTRL 0xD228
#define R_AX_PWR_SWING_VHT_CTRL_C1 0xF228
#define B_AX_TXBIAS_VHT_OV_TH_VAL_SH 30
#define B_AX_TXBIAS_VHT_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_VHT_BELOW_TH_VAL_SH 26
#define B_AX_TXBBSWING_VHT_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_VHT_OV_TH_VAL_SH 22
#define B_AX_TXBBSWING_VHT_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_VHT_TH_SH 18
#define B_AX_TXBBSWING_TXBIAS_VHT_TH_MSK 0xf
#define B_AX_TXBIAS_HT_BELOW_TH_VAL_SH 16
#define B_AX_TXBIAS_HT_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_HT_OV_TH_VAL_SH 14
#define B_AX_TXBIAS_HT_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_HT_BELOW_TH_VAL_SH 10
#define B_AX_TXBBSWING_HT_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_HT_OV_TH_VAL_SH 6
#define B_AX_TXBBSWING_HT_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_HT_TH_SH 2
#define B_AX_TXBBSWING_TXBIAS_HT_TH_MSK 0xf

#define R_AX_PWR_SWING_HE_CTRL 0xD22C
#define R_AX_PWR_SWING_HE_CTRL_C1 0xF22C
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_BELOW_TH_VAL BIT(28)
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_OV_TH_VAL BIT(27)
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_TH_SH 23
#define B_AX_CFIR_BY_RATE_OFF_LEGACY_TH_MSK 0xf
#define B_AX_CFIR_BY_RATE_OFF_CCK_BELOW_TH_VAL BIT(22)
#define B_AX_CFIR_BY_RATE_OFF_CCK_OV_TH_VAL BIT(21)
#define B_AX_CFIR_BY_RATE_OFF_CCK_TH_SH 18
#define B_AX_CFIR_BY_RATE_OFF_CCK_TH_MSK 0x7
#define B_AX_TXBIAS_HE_BELOW_TH_VAL_SH 16
#define B_AX_TXBIAS_HE_BELOW_TH_VAL_MSK 0x3
#define B_AX_TXBIAS_HE_OV_TH_VAL_SH 14
#define B_AX_TXBIAS_HE_OV_TH_VAL_MSK 0x3
#define B_AX_TXBBSWING_HE_BELOW_TH_VAL_SH 10
#define B_AX_TXBBSWING_HE_BELOW_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_HE_OV_TH_VAL_SH 6
#define B_AX_TXBBSWING_HE_OV_TH_VAL_MSK 0xf
#define B_AX_TXBBSWING_TXBIAS_HE_TH_SH 2
#define B_AX_TXBBSWING_TXBIAS_HE_TH_MSK 0xf
#define B_AX_TXBIAS_VHT_BELOW_TH_VAL_SH 0
#define B_AX_TXBIAS_VHT_BELOW_TH_VAL_MSK 0x3

#define R_AX_PWR_SWING_OTHER_CTRL0 0xD230
#define R_AX_PWR_SWING_OTHER_CTRL0_C1 0xF230
#define B_AX_DPD_BY_RATE_OFF_LEGACY_BELOW_TH_VAL BIT(28)
#define B_AX_DPD_BY_RATE_OFF_LEGACY_OV_TH_VAL BIT(27)
#define B_AX_DPD_BY_RATE_OFF_LEGACY_TH_SH 23
#define B_AX_DPD_BY_RATE_OFF_LEGACY_TH_MSK 0xf
#define B_AX_DPD_BY_RATE_OFF_CCK_BELOW_TH_VAL BIT(22)
#define B_AX_DPD_BY_RATE_OFF_CCK_OV_TH_VAL BIT(21)
#define B_AX_DPD_BY_RATE_OFF_CCK_TH_SH 18
#define B_AX_DPD_BY_RATE_OFF_CCK_TH_MSK 0x7
#define B_AX_CFIR_BY_RATE_OFF_HE_BELOW_TH_VAL BIT(17)
#define B_AX_CFIR_BY_RATE_OFF_HE_OV_TH_VAL BIT(16)
#define B_AX_CFIR_BY_RATE_OFF_HE_TH_SH 12
#define B_AX_CFIR_BY_RATE_OFF_HE_TH_MSK 0xf
#define B_AX_CFIR_BY_RATE_OFF_VHT_BELOW_TH_VAL BIT(11)
#define B_AX_CFIR_BY_RATE_OFF_VHT_OV_TH_VAL BIT(10)
#define B_AX_CFIR_BY_RATE_OFF_VHT_TH_SH 6
#define B_AX_CFIR_BY_RATE_OFF_VHT_TH_MSK 0xf
#define B_AX_CFIR_BY_RATE_OFF_HT_BELOW_TH_VAL BIT(5)
#define B_AX_CFIR_BY_RATE_OFF_HT_OV_TH_VAL BIT(4)
#define B_AX_CFIR_BY_RATE_OFF_HT_TH_SH 0
#define B_AX_CFIR_BY_RATE_OFF_HT_TH_MSK 0xf

#define R_AX_PWR_SWING_OTHER_CTRL1 0xD234
#define R_AX_PWR_SWING_OTHER_CTRL1_C1 0xF234
#define B_AX_DPD_BY_RATE_OFF_SR_DONT_APPLY BIT(30)
#define B_AX_CFIR_BY_RATE_OFF_SR_DONT_APPLY BIT(29)
#define B_AX_TXBBSWING_TXBIAS_SR_DONT_APPLY BIT(28)
#define B_AX_DPD_BY_RATE_OFF_HE_BELOW_TH_VAL BIT(17)
#define B_AX_DPD_BY_RATE_OFF_HE_OV_TH_VAL BIT(16)
#define B_AX_DPD_BY_RATE_OFF_HE_TH_SH 12
#define B_AX_DPD_BY_RATE_OFF_HE_TH_MSK 0xf
#define B_AX_DPD_BY_RATE_OFF_VHT_BELOW_TH_VAL BIT(11)
#define B_AX_DPD_BY_RATE_OFF_VHT_OV_TH_VAL BIT(10)
#define B_AX_DPD_BY_RATE_OFF_VHT_TH_SH 6
#define B_AX_DPD_BY_RATE_OFF_VHT_TH_MSK 0xf
#define B_AX_DPD_BY_RATE_OFF_HT_BELOW_TH_VAL BIT(5)
#define B_AX_DPD_BY_RATE_OFF_HT_OV_TH_VAL BIT(4)
#define B_AX_DPD_BY_RATE_OFF_HT_TH_SH 0
#define B_AX_DPD_BY_RATE_OFF_HT_TH_MSK 0xf

#define R_AX_PWR_SR_CTRL0 0xD238
#define R_AX_PWR_SR_CTRL0_C1 0xF238
#define B_AX_SR_PWR_CTRL_DBG_EN BIT(31)
#define B_AX_SR_RATE_TBL_RD_MCS_TXDIFF_SH 20
#define B_AX_SR_RATE_TBL_RD_MCS_TXDIFF_MSK 0x1f
#define B_AX_SR_RATE_MAP_TBL_RD_MCS_SEL BIT(19)
#define B_AX_TXPWR_SR_FORCE_OFF BIT(18)
#define B_AX_TXPWR_STA_UL_FORCE_OFF BIT(17)
#define B_AX_SR_TXPWR_PD_WITH_PD_MACID BIT(16)
#define B_AX_SR_RATE_MAP_TBL_RD BIT(15)
#define B_AX_SR_RATE_MAP_TBL_RD_MCS_SH 11
#define B_AX_SR_RATE_MAP_TBL_RD_MCS_MSK 0xf
#define B_AX_TXPWR_CTRL_NORM_RESP_DBG_EN BIT(10)
#define B_AX_TXAGC_PSEUDO_PWR_EN BIT(9)
#define B_AX_TXAGC_PSEUDO_PWR_SH 0
#define B_AX_TXAGC_PSEUDO_PWR_MSK 0x1ff

#define R_AX_PWR_SR_CTRL1 0xD23C
#define R_AX_PWR_SR_CTRL1_C1 0xF23C
#define B_AX_MCS_TH_HE_SH 24
#define B_AX_MCS_TH_HE_MSK 0xf
#define B_AX_MCS_TH_VHT_SH 20
#define B_AX_MCS_TH_VHT_MSK 0xf
#define B_AX_MCS_TH_HT_MOD8_SH 16
#define B_AX_MCS_TH_HT_MOD8_MSK 0xf
#define B_AX_MCS_TH_LEGACY_SH 12
#define B_AX_MCS_TH_LEGACY_MSK 0xf
#define B_AX_MCS_TH_CCK_SH 8
#define B_AX_MCS_TH_CCK_MSK 0xf
#define B_AX_TXPWR_REF_SH 0
#define B_AX_TXPWR_REF_MSK 0x7f

#define R_AX_PWR_UL_CTRL0 0xD240
#define R_AX_PWR_UL_CTRL0_C1 0xF240
#define B_AX_PL_TOLER_RANGE_SH 20
#define B_AX_PL_TOLER_RANGE_MSK 0x1ff
#define B_AX_PWR_BB_MIN_DBM_SH 9
#define B_AX_PWR_BB_MIN_DBM_MSK 0x1ff
#define B_AX_PWR_ERROR_TOLER_SH 0
#define B_AX_PWR_ERROR_TOLER_MSK 0xff

#define R_AX_PWR_UL_CTRL1 0xD244
#define R_AX_PWR_UL_CTRL1_C1 0xF244
#define B_AX_MACID3_SH 24
#define B_AX_MACID3_MSK 0x7f
#define B_AX_MACID2_SH 16
#define B_AX_MACID2_MSK 0x7f
#define B_AX_MACID1_SH 8
#define B_AX_MACID1_MSK 0x7f
#define B_AX_MACID0_SH 0
#define B_AX_MACID0_MSK 0x7f

#define R_AX_PWR_UL_CTRL2 0xD248
#define R_AX_PWR_UL_CTRL2_C1 0xF248
#define B_AX_CFO_COMP_SR_SH 24
#define B_AX_CFO_COMP_SR_MSK 0x7
#define B_AX_CFO_COMP_NORM_RESP_SH 20
#define B_AX_CFO_COMP_NORM_RESP_MSK 0x7
#define B_AX_CFO_COMP4_SH 16
#define B_AX_CFO_COMP4_MSK 0x7
#define B_AX_CFO_COMP3_SH 12
#define B_AX_CFO_COMP3_MSK 0x7
#define B_AX_CFO_COMP2_SH 8
#define B_AX_CFO_COMP2_MSK 0x7
#define B_AX_CFO_COMP1_SH 4
#define B_AX_CFO_COMP1_MSK 0x7
#define B_AX_CFO_COMP0_SH 0
#define B_AX_CFO_COMP0_MSK 0x7

#define R_AX_PWR_UL_CTRL3 0xD24C
#define R_AX_PWR_UL_CTRL3_C1 0xF24C
#define B_AX_TF_RDY_TXBF_FORCE_OFF BIT(22)
#define B_AX_FORCE_PL_UPPER_EN_EQUL_N_TX_DIVIDE2 BIT(21)
#define B_AX_FORCE_N_TX_DIVIDE2_OFF BIT(20)
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MAX_SH 11
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MAX_MSK 0x1ff
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MIN_SH 0
#define B_AX_STA_PWR_CTRL_PWRMAX_LIM_MIN_MSK 0x1ff

#define R_AX_PWR_UL_CTRL4 0xD250
#define R_AX_PWR_UL_CTRL4_C1 0xF250
#define B_AX_STA_PWR_CTRL_RPL_LIM_MIN_SH 16
#define B_AX_STA_PWR_CTRL_RPL_LIM_MIN_MSK 0x3ff
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MAX_SH 8
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MAX_MSK 0xff
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MIN_SH 0
#define B_AX_STA_PWR_CTRL_RSSI_TARGET_LIM_MIN_MSK 0xff

#define R_AX_PWR_UL_CTRL5 0xD254
#define R_AX_PWR_UL_CTRL5_C1 0xF254
#define B_AX_FORCE_PL_UPPER_EN_VAL BIT(23)
#define B_AX_FORCE_PL_UPPER_EN_ON BIT(22)
#define B_AX_SR_TXPWR_RESP_RDY_FORCE_OFF BIT(15)
#define B_AX_SR_TXPWR_PD_RDY_FORCE_OFF BIT(14)
#define B_AX_SR_TXPWR_RATE_RDY_FORCE_OFF BIT(13)
#define B_AX_TF_RDY_FORCE_OFF BIT(12)
#define B_AX_TXCTRL_INFO_RDY_FORCE_OFF BIT(11)
#define B_AX_STA_PWR_CTRL_DBG_EN BIT(10)
#define B_AX_STA_PWR_CTRL_RPL_LIM_MAX_SH 0
#define B_AX_STA_PWR_CTRL_RPL_LIM_MAX_MSK 0x3ff

#define R_AX_PWR_UL_CTRL6 0xD258
#define R_AX_PWR_UL_CTRL6_C1 0xF258
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MIN_SH 24
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MIN_MSK 0x7f
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MAX_SH 16
#define B_AX_STA_PWR_CTRL_AP_TXPWR_LIM_MAX_MSK 0x7f
#define B_AX_TXPWR_FORCE_RATE_EN BIT(12)
#define B_AX_TXPWR_FORCE_RATE_SH 0
#define B_AX_TXPWR_FORCE_RATE_MSK 0xfff

#define R_AX_PWR_NORM_FORCE0 0xD25C
#define R_AX_PWR_NORM_FORCE0_C1 0xF25C
#define B_AX_FORCE_MACID_EN BIT(30)
#define B_AX_FORCE_MACID_VALUE_SH 23
#define B_AX_FORCE_MACID_VALUE_MSK 0x7f
#define B_AX_FORCE_BW80P80_EN_EN BIT(22)
#define B_AX_FORCE_BW80P80_EN_VALUE BIT(21)
#define B_AX_FORCE_RF_BW_IDX_EN BIT(20)
#define B_AX_FORCE_RF_BW_IDX_VALUE_SH 18
#define B_AX_FORCE_RF_BW_IDX_VALUE_MSK 0x3
#define B_AX_FORCE_DCM_EN BIT(17)
#define B_AX_FORCE_DCM_VALUE BIT(16)
#define B_AX_FORCE_DBW_IDX_EN BIT(15)
#define B_AX_FORCE_DBW_IDX_VALUE_SH 13
#define B_AX_FORCE_DBW_IDX_VALUE_MSK 0x3
#define B_AX_FORCE_MAX_RATE_EN BIT(12)
#define B_AX_FORCE_MAX_RATE_VALUE_SH 0
#define B_AX_FORCE_MAX_RATE_VALUE_MSK 0xfff

#define R_AX_PWR_NORM_FORCE1 0xD260
#define R_AX_PWR_NORM_FORCE1_C1 0xF260
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_EN BIT(29)
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_SH 24
#define B_AX_TXAGC_BF_PWR_BOOST_FORCE_VAL_MSK 0x1f
#define B_AX_FORCE_HE_ER_SU_EN_EN BIT(23)
#define B_AX_FORCE_HE_ER_SU_EN_VALUE BIT(22)
#define B_AX_FORCE_MACID_CCA_TH_EN_EN BIT(21)
#define B_AX_FORCE_MACID_CCA_TH_EN_VALUE BIT(20)
#define B_AX_FORCE_BT_GRANT_EN BIT(19)
#define B_AX_FORCE_BT_GRANT_VALUE BIT(18)
#define B_AX_FORCE_RX_LTE_EN BIT(17)
#define B_AX_FORCE_RX_LTE_VALUE BIT(16)
#define B_AX_FORCE_TXBF_EN_EN BIT(15)
#define B_AX_FORCE_TXBF_EN_VALUE BIT(14)
#define B_AX_FORCE_TXSC_EN BIT(13)
#define B_AX_FORCE_TXSC_VALUE_SH 9
#define B_AX_FORCE_TXSC_VALUE_MSK 0xf
#define B_AX_FORCE_NTX_EN BIT(6)
#define B_AX_FORCE_NTX_VALUE BIT(5)
#define B_AX_FORCE_PWR_MODE_EN BIT(3)
#define B_AX_FORCE_PWR_MODE_VALUE_SH 0
#define B_AX_FORCE_PWR_MODE_VALUE_MSK 0x7

#define R_AX_PWR_SR_FORCE0 0xD264
#define R_AX_PWR_SR_FORCE0_C1 0xF264
#define B_AX_FORCE_SR_RESP_DCM_EN BIT(30)
#define B_AX_FORCE_SR_RESP_DCM_VALUE BIT(29)
#define B_AX_FORCE_SR_RATE_DCM_EN BIT(28)
#define B_AX_FORCE_SR_RATE_DCM_VALUE BIT(27)
#define B_AX_FORCE_SR_TXPWR_PD_EN BIT(26)
#define B_AX_FORCE_SR_TXPWR_PD_VALUE_SH 20
#define B_AX_FORCE_SR_TXPWR_PD_VALUE_MSK 0x3f
#define B_AX_FORCE_SR_RATE_IDX_EN BIT(19)
#define B_AX_FORCE_SR_RATE_IDX_VALUE_SH 7
#define B_AX_FORCE_SR_RATE_IDX_VALUE_MSK 0xfff
#define B_AX_FORCE_SR_TXPWR_TOLERANCE_EN BIT(6)
#define B_AX_FORCE_SR_TXPWR_TOLERANCE_VALUE_SH 0
#define B_AX_FORCE_SR_TXPWR_TOLERANCE_VALUE_MSK 0x3f

#define R_AX_PWR_SR_FORCE1 0xD268
#define R_AX_PWR_SR_FORCE1_C1 0xF268
#define B_AX_FORCE_RPL_EN BIT(29)
#define B_AX_FORCE_RPL_VALUE_SH 20
#define B_AX_FORCE_RPL_VALUE_MSK 0x1ff
#define B_AX_FORCE_SR_RESP_RATE_IDX_EN BIT(19)
#define B_AX_FORCE_SR_RESP_RATE_IDX_VALUE_SH 7
#define B_AX_FORCE_SR_RESP_RATE_IDX_VALUE_MSK 0xfff
#define B_AX_FORCE_SR_RESP_TXPWR_PD_EN BIT(6)
#define B_AX_FORCE_SR_RESP_TXPWR_PD_VALUE_SH 0
#define B_AX_FORCE_SR_RESP_TXPWR_PD_VALUE_MSK 0x3f

#define R_AX_PWR_SR_FORCE2 0xD26C
#define R_AX_PWR_SR_FORCE2_C1 0xF26C
#define B_AX_FORCE_TF_AP_TX_PWR_EN BIT(31)
#define B_AX_FORCE_TF_AP_TX_PWR_VALUE_SH 25
#define B_AX_FORCE_TF_AP_TX_PWR_VALUE_MSK 0x3f
#define B_AX_FORCE_TF_RATE_IDX_EN BIT(24)
#define B_AX_FORCE_TF_RATE_IDX_VALUE_SH 12
#define B_AX_FORCE_TF_RATE_IDX_VALUE_MSK 0xfff
#define B_AX_FORCE_RPL_UPPER_EN_EN BIT(11)
#define B_AX_FORCE_RPL_UPPER_EN_VALUE BIT(10)
#define B_AX_FORCE_RPL_UPPER_EN BIT(9)
#define B_AX_FORCE_RPL_UPPER_VALUE_SH 0
#define B_AX_FORCE_RPL_UPPER_VALUE_MSK 0x1ff

#define R_AX_PWR_UL_FORCE0 0xD270
#define R_AX_PWR_UL_FORCE0_C1 0xF270
#define B_AX_FORCE_RU_ALLOC_EN BIT(24)
#define B_AX_FORCE_RU_ALLOC_VALUE_SH 16
#define B_AX_FORCE_RU_ALLOC_VALUE_MSK 0xff
#define B_AX_FORCE_TF_MACID_EN BIT(15)
#define B_AX_FORCE_TF_MACID_VALUE_SH 8
#define B_AX_FORCE_TF_MACID_VALUE_MSK 0x7f
#define B_AX_FORCE_TF_RSSI_TARGET_EN BIT(7)
#define B_AX_FORCE_TF_RSSI_TARGET_VALUE_SH 0
#define B_AX_FORCE_TF_RSSI_TARGET_VALUE_MSK 0x7f

#define R_AX_PWR_NORM_FORCE2 0xD274
#define R_AX_PWR_NORM_FORCE2_C1 0xF274
#define B_AX_FORCE_OUT_CCA_PWR_TH_EN_ON BIT(18)
#define B_AX_FORCE_OUT_CCA_PWR_TH_EN BIT(17)
#define B_AX_FORCE_OUT_CCA_PWR_TH_ON BIT(16)
#define B_AX_FORCE_OUT_CCA_PWR_TH_SH 8
#define B_AX_FORCE_OUT_CCA_PWR_TH_MSK 0xff
#define B_AX_TXPWR_CTRL_DBG_SEL_SH 0
#define B_AX_TXPWR_CTRL_DBG_SEL_MSK 0x3f

#define R_AX_PWR_UL_FORCE1 0xD278
#define R_AX_PWR_UL_FORCE1_C1 0xF278
#define B_AX_FORCE_OUT_CFO_COMP_ON BIT(31)
#define B_AX_FORCE_OUT_CFO_COMP_SH 28
#define B_AX_FORCE_OUT_CFO_COMP_MSK 0x7
#define B_AX_FORCE_OUT_ABORT_TX_IDX_ON BIT(27)
#define B_AX_FORCE_OUT_ABORT_TX_IDX_SH 25
#define B_AX_FORCE_OUT_ABORT_TX_IDX_MSK 0x3
#define B_AX_FORCE_OUT_MIN_TX_PWR_FLAG_ON BIT(24)
#define B_AX_FORCE_OUT_MIN_TX_PWR_FLAG BIT(23)
#define B_AX_FORCE_OUT_UPH_ON BIT(22)
#define B_AX_FORCE_OUT_UPH_SH 17
#define B_AX_FORCE_OUT_UPH_MSK 0x1f
#define B_AX_FORCE_OUT_STA_TXPWR_MAC_ON BIT(16)
#define B_AX_FORCE_OUT_STA_TXPWR_MAC_SH 10
#define B_AX_FORCE_OUT_STA_TXPWR_MAC_MSK 0x3f
#define B_AX_FORCE_OUT_STA_TXPWR_BB_ON BIT(9)
#define B_AX_FORCE_OUT_STA_TXPWR_BB_SH 0
#define B_AX_FORCE_OUT_STA_TXPWR_BB_MSK 0x1ff

#define R_AX_PWR_NORM_FORCE3 0xD27C
#define R_AX_PWR_NORM_FORCE3_C1 0xF27C
#define B_AX_FORCE_OUT_TXAGC_BBSWING_ON BIT(31)
#define B_AX_FORCE_OUT_TXAGC_BBSWING_SH 27
#define B_AX_FORCE_OUT_TXAGC_BBSWING_MSK 0xf
#define B_AX_FORCE_OUT_TXBIAS_ON BIT(26)
#define B_AX_FORCE_OUT_TXBIAS_SH 24
#define B_AX_FORCE_OUT_TXBIAS_MSK 0x3
#define B_AX_FORCE_OUT_TXPWR_BFON_BOOST_DB_SEG0_ON BIT(23)
#define B_AX_FORCE_OUT_TXPWR_BFON_BOOST_DB_SEG0_SH 18
#define B_AX_FORCE_OUT_TXPWR_BFON_BOOST_DB_SEG0_MSK 0x1f
#define B_AX_FORCE_OUT_TXPWR_BB_ON BIT(17)
#define B_AX_FORCE_OUT_TXPWR_BB_SH 8
#define B_AX_FORCE_OUT_TXPWR_BB_MSK 0x1ff
#define B_AX_FORCE_OUT_TXPWR_MAC_ON BIT(6)
#define B_AX_FORCE_OUT_TXPWR_MAC_SH 0
#define B_AX_FORCE_OUT_TXPWR_MAC_MSK 0x3f

#define R_AX_PWR_NORM_FORCE4 0xD280
#define R_AX_PWR_NORM_FORCE4_C1 0xF280
#define B_AX_FORCE_OUT_SR_DCM_ON BIT(25)
#define B_AX_FORCE_OUT_SR_DCM BIT(24)
#define B_AX_FORCE_OUT_SR_MCS_ON BIT(23)
#define B_AX_FORCE_OUT_SR_MCS_SH 11
#define B_AX_FORCE_OUT_SR_MCS_MSK 0xfff
#define B_AX_FORCE_OUT_SR_PD_THREHOLD_ON BIT(10)
#define B_AX_FORCE_OUT_SR_PD_THREHOLD_SH 4
#define B_AX_FORCE_OUT_SR_PD_THREHOLD_MSK 0x3f
#define B_AX_FORCE_OUT_CFIR_BY_RATE_OFF_ON BIT(3)
#define B_AX_FORCE_OUT_CFIR_BY_RATE_OFF BIT(2)
#define B_AX_FORCE_OUT_DPD_BY_RATE_OFF_ON BIT(1)
#define B_AX_FORCE_OUT_DPD_BY_RATE_OFF BIT(0)

#define R_AX_PWR_RATE_TABLE0 0xD2C0
#define R_AX_PWR_RATE_TABLE0_C1 0xF2C0
#define B_AX_TXAGC_CCK11M_SH 24
#define B_AX_TXAGC_CCK11M_MSK 0x1f
#define B_AX_TXAGC_CCK5P5M_SH 16
#define B_AX_TXAGC_CCK5P5M_MSK 0x1f
#define B_AX_TXAGC_CCK2M_SH 8
#define B_AX_TXAGC_CCK2M_MSK 0xf
#define B_AX_TXAGC_CCK1M_SH 0
#define B_AX_TXAGC_CCK1M_MSK 0x1f

#define R_AX_PWR_RATE_TABLE1 0xD2C4
#define R_AX_PWR_RATE_TABLE1_C1 0xF2C4
#define B_AX_TXAGC_LEGACY18M_SH 24
#define B_AX_TXAGC_LEGACY18M_MSK 0x1f
#define B_AX_TXAGC_LEGACY12M_SH 16
#define B_AX_TXAGC_LEGACY12M_MSK 0x1f
#define B_AX_TXAGC_LEGACY9M_SH 8
#define B_AX_TXAGC_LEGACY9M_MSK 0xf
#define B_AX_TXAGC_LEGACY6M_SH 0
#define B_AX_TXAGC_LEGACY6M_MSK 0x1f

#define R_AX_PWR_RATE_TABLE2 0xD2C8
#define R_AX_PWR_RATE_TABLE2_C1 0xF2C8
#define B_AX_TXAGC_LEGACY54M_SH 24
#define B_AX_TXAGC_LEGACY54M_MSK 0x1f
#define B_AX_TXAGC_LEGACY48M_SH 16
#define B_AX_TXAGC_LEGACY48M_MSK 0x1f
#define B_AX_TXAGC_LEGACY36M_SH 8
#define B_AX_TXAGC_LEGACY36M_MSK 0xf
#define B_AX_TXAGC_LEGACY24M_SH 0
#define B_AX_TXAGC_LEGACY24M_MSK 0x1f

#define R_AX_PWR_RATE_TABLE3 0xD2CC
#define R_AX_PWR_RATE_TABLE3_C1 0xF2CC
#define B_AX_TXAGC_NONLEGACY_MCS3_NSS1_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS3_NSS1_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS2_NSS1_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS2_NSS1_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS1_NSS1_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS1_NSS1_MSK 0xf
#define B_AX_TXAGC_NONLEGACY_MCS0_NSS1_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS0_NSS1_MSK 0x1f

#define R_AX_PWR_RATE_TABLE4 0xD2D0
#define R_AX_PWR_RATE_TABLE4_C1 0xF2D0
#define B_AX_TXAGC_NONLEGACY_MCS7_NSS1_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS7_NSS1_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS6_NSS1_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS6_NSS1_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS5_NSS1_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS5_NSS1_MSK 0xf
#define B_AX_TXAGC_NONLEGACY_MCS4_NSS1_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS4_NSS1_MSK 0x1f

#define R_AX_PWR_RATE_TABLE5 0xD2D4
#define R_AX_PWR_RATE_TABLE5_C1 0xF2D4
#define B_AX_TXAGC_NONLEGACY_MCS11_NSS1_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS11_NSS1_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS10_NSS1_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS10_NSS1_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS9_NSS1_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS9_NSS1_MSK 0xf
#define B_AX_TXAGC_NONLEGACY_MCS8_NSS1_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS8_NSS1_MSK 0x1f

#define R_AX_PWR_RATE_TABLE6 0xD2D8
#define R_AX_PWR_RATE_TABLE6_C1 0xF2D8
#define B_AX_TXAGC_DCM_MCS4_NSS1_SH 24
#define B_AX_TXAGC_DCM_MCS4_NSS1_MSK 0x1f
#define B_AX_TXAGC_DCM_MCS3_NSS1_SH 16
#define B_AX_TXAGC_DCM_MCS3_NSS1_MSK 0x1f
#define B_AX_TXAGC_DCM_MCS1_NSS1_SH 8
#define B_AX_TXAGC_DCM_MCS1_NSS1_MSK 0xf
#define B_AX_TXAGC_DCM_MCS0_NSS1_SH 0
#define B_AX_TXAGC_DCM_MCS0_NSS1_MSK 0x1f

#define R_AX_PWR_RATE_TABLE7 0xD2DC
#define R_AX_PWR_RATE_TABLE7_C1 0xF2DC
#define B_AX_TXAGC_NONLEGACY_MCS3_NSS2_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS3_NSS2_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS2_NSS2_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS2_NSS2_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS1_NSS2_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS1_NSS2_MSK 0xf
#define B_AX_TXAGC_NONLEGACY_MCS0_NSS2_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS0_NSS2_MSK 0x1f

#define R_AX_PWR_RATE_TABLE8 0xD2E0
#define R_AX_PWR_RATE_TABLE8_C1 0xF2E0
#define B_AX_TXAGC_NONLEGACY_MCS7_NSS2_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS7_NSS2_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS6_NSS2_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS6_NSS2_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS5_NSS2_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS5_NSS2_MSK 0xf
#define B_AX_TXAGC_NONLEGACY_MCS4_NSS2_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS4_NSS2_MSK 0x1f

#define R_AX_PWR_RATE_TABLE9 0xD2E4
#define R_AX_PWR_RATE_TABLE9_C1 0xF2E4
#define B_AX_TXAGC_NONLEGACY_MCS11_NSS2_SH 24
#define B_AX_TXAGC_NONLEGACY_MCS11_NSS2_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS10_NSS2_SH 16
#define B_AX_TXAGC_NONLEGACY_MCS10_NSS2_MSK 0x1f
#define B_AX_TXAGC_NONLEGACY_MCS9_NSS2_SH 8
#define B_AX_TXAGC_NONLEGACY_MCS9_NSS2_MSK 0xf
#define B_AX_TXAGC_NONLEGACY_MCS8_NSS2_SH 0
#define B_AX_TXAGC_NONLEGACY_MCS8_NSS2_MSK 0x1f

#define R_AX_PWR_RATE_TABLE10 0xD2E8
#define R_AX_PWR_RATE_TABLE10_C1 0xF2E8
#define B_AX_TXAGC_DCM_MCS4_NSS2_SH 24
#define B_AX_TXAGC_DCM_MCS4_NSS2_MSK 0x1f
#define B_AX_TXAGC_DCM_MCS3_NSS2_SH 16
#define B_AX_TXAGC_DCM_MCS3_NSS2_MSK 0x1f
#define B_AX_TXAGC_DCM_MCS1_NSS2_SH 8
#define B_AX_TXAGC_DCM_MCS1_NSS2_MSK 0xf
#define B_AX_TXAGC_DCM_MCS0_NSS2_SH 0
#define B_AX_TXAGC_DCM_MCS0_NSS2_MSK 0x1f

#define R_AX_PWR_LMT_TABLE0 0xD2EC
#define R_AX_PWR_LMT_TABLE0_C1 0xF2EC
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW40M_SH 24
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_1TX_BW40M_SH 15
#define B_AX_TXAGC_MAX_CCK_1TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW20M_SH 8
#define B_AX_TXAGC_MAX_CCK_BF_1TX_BW20M_MSK 0x3f
#define B_AX_TXAGC_MAX_CCK_1TX_BW20M_SH 0
#define B_AX_TXAGC_MAX_CCK_1TX_BW20M_MSK 0x7f

#define R_AX_PWR_LMT_TABLE1 0xD2F0
#define R_AX_PWR_LMT_TABLE1_C1 0xF2F0
#define B_AX_TXAGC_MAX_1TX_BF_BW20_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_0_SH 15
#define B_AX_TXAGC_MAX_1TX_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_1TX_SH 8
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_1TX_MSK 0x3f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_1TX_SH 0
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_1TX_MSK 0x7f

#define R_AX_PWR_LMT_TABLE2 0xD2F4
#define R_AX_PWR_LMT_TABLE2_C1 0xF2F4
#define B_AX_TXAGC_MAX_1TX_BF_BW20_2_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_2_SH 15
#define B_AX_TXAGC_MAX_1TX_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_1_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_1_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW20_1_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE3 0xD2F8
#define R_AX_PWR_LMT_TABLE3_C1 0xF2F8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_4_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_4_SH 15
#define B_AX_TXAGC_MAX_1TX_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_3_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_3_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW20_3_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE4 0xD2FC
#define R_AX_PWR_LMT_TABLE4_C1 0xF2FC
#define B_AX_TXAGC_MAX_1TX_BF_BW20_6_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW20_6_SH 15
#define B_AX_TXAGC_MAX_1TX_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_5_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_5_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW20_5_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_5_MSK 0x7f

#define R_AX_PWR_LMT_TABLE5 0xD300
#define R_AX_PWR_LMT_TABLE5_C1 0xF300
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_0_SH 15
#define B_AX_TXAGC_MAX_1TX_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW20_7_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW20_7_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW20_7_SH 0
#define B_AX_TXAGC_MAX_1TX_BW20_7_MSK 0x7f

#define R_AX_PWR_LMT_TABLE6 0xD304
#define R_AX_PWR_LMT_TABLE6_C1 0xF304
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_2_SH 15
#define B_AX_TXAGC_MAX_1TX_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW40_1_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW40_1_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW40_1_SH 0
#define B_AX_TXAGC_MAX_1TX_BW40_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE7 0xD308
#define R_AX_PWR_LMT_TABLE7_C1 0xF308
#define B_AX_TXAGC_MAX_1TX_BF_BW80_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW80_0_SH 15
#define B_AX_TXAGC_MAX_1TX_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW40_3_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW40_3_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW40_3_SH 0
#define B_AX_TXAGC_MAX_1TX_BW40_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE8 0xD30C
#define R_AX_PWR_LMT_TABLE8_C1 0xF30C
#define B_AX_TXAGC_MAX_1TX_BF_BW160_0_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW160_0_SH 15
#define B_AX_TXAGC_MAX_1TX_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW80_1_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW80_1_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW80_1_SH 0
#define B_AX_TXAGC_MAX_1TX_BW80_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE9 0xD310
#define R_AX_PWR_LMT_TABLE9_C1 0xF310
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2P5_SH 24
#define B_AX_TXAGC_MAX_1TX_BF_BW40_2P5_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BW40_2P5_SH 15
#define B_AX_TXAGC_MAX_1TX_BW40_2P5_MSK 0x7f
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0P5_SH 8
#define B_AX_TXAGC_MAX_1TX_BF_BW40_0P5_MSK 0x3f
#define B_AX_TXAGC_MAX_1TX_BW40_0P5_SH 0
#define B_AX_TXAGC_MAX_1TX_BW40_0P5_MSK 0x7f

#define R_AX_PWR_LMT_TABLE10 0xD314
#define R_AX_PWR_LMT_TABLE10_C1 0xF314
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW40M_SH 24
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_2TX_BW40M_SH 15
#define B_AX_TXAGC_MAX_CCK_2TX_BW40M_MSK 0x7f
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW20M_SH 8
#define B_AX_TXAGC_MAX_CCK_BF_2TX_BW20M_MSK 0x3f
#define B_AX_TXAGC_MAX_CCK_2TX_BW20M_SH 0
#define B_AX_TXAGC_MAX_CCK_2TX_BW20M_MSK 0x7f

#define R_AX_PWR_LMT_TABLE11 0xD318
#define R_AX_PWR_LMT_TABLE11_C1 0xF318
#define B_AX_TXAGC_MAX_2TX_BF_BW20_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_0_SH 15
#define B_AX_TXAGC_MAX_2TX_BW20_0_MSK 0x7f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_2TX_SH 8
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_BF_2TX_MSK 0x3f
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_2TX_SH 0
#define B_AX_TXAGC_MAX_LEGACY_NON_DUP_2TX_MSK 0x7f

#define R_AX_PWR_LMT_TABLE12 0xD31C
#define R_AX_PWR_LMT_TABLE12_C1 0xF31C
#define B_AX_TXAGC_MAX_2TX_BF_BW20_2_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_2_SH 15
#define B_AX_TXAGC_MAX_2TX_BW20_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_1_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_1_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW20_1_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE13 0xD320
#define R_AX_PWR_LMT_TABLE13_C1 0xF320
#define B_AX_TXAGC_MAX_2TX_BF_BW20_4_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_4_SH 15
#define B_AX_TXAGC_MAX_2TX_BW20_4_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_3_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_3_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW20_3_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE14 0xD324
#define R_AX_PWR_LMT_TABLE14_C1 0xF324
#define B_AX_TXAGC_MAX_2TX_BF_BW20_6_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW20_6_SH 15
#define B_AX_TXAGC_MAX_2TX_BW20_6_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_5_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_5_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW20_5_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_5_MSK 0x7f

#define R_AX_PWR_LMT_TABLE15 0xD328
#define R_AX_PWR_LMT_TABLE15_C1 0xF328
#define B_AX_TXAGC_MAX_2TX_BF_BW40_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_0_SH 15
#define B_AX_TXAGC_MAX_2TX_BW40_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW20_7_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW20_7_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW20_7_SH 0
#define B_AX_TXAGC_MAX_2TX_BW20_7_MSK 0x7f

#define R_AX_PWR_LMT_TABLE16 0xD32C
#define R_AX_PWR_LMT_TABLE16_C1 0xF32C
#define B_AX_TXAGC_MAX_2TX_BF_BW40_2_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW40_2_SH 15
#define B_AX_TXAGC_MAX_2TX_BW40_2_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW40_1_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW40_1_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW40_1_SH 0
#define B_AX_TXAGC_MAX_2TX_BW40_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE17 0xD330
#define R_AX_PWR_LMT_TABLE17_C1 0xF330
#define B_AX_TXAGC_MAX_2TX_BF_BW80_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW80_0_SH 15
#define B_AX_TXAGC_MAX_2TX_BW80_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW40_3_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW40_3_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW40_3_SH 0
#define B_AX_TXAGC_MAX_2TX_BW40_3_MSK 0x7f

#define R_AX_PWR_LMT_TABLE18 0xD334
#define R_AX_PWR_LMT_TABLE18_C1 0xF334
#define B_AX_TXAGC_MAX_2TX_BF_BW160_0_SH 24
#define B_AX_TXAGC_MAX_2TX_BF_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BW160_0_SH 15
#define B_AX_TXAGC_MAX_2TX_BW160_0_MSK 0x7f
#define B_AX_TXAGC_MAX_2TX_BF_BW80_1_SH 8
#define B_AX_TXAGC_MAX_2TX_BF_BW80_1_MSK 0x3f
#define B_AX_TXAGC_MAX_2TX_BW80_1_SH 0
#define B_AX_TXAGC_MAX_2TX_BW80_1_MSK 0x7f

#define R_AX_PWR_LMT_TABLE19 0xD338
#define R_AX_PWR_LMT_TABLE19_C1 0xF338

#define R_AX_PWR_RU_LMT_TABLE0 0xD33C
#define R_AX_PWR_RU_LMT_TABLE0_C1 0xF33C
#define B_AX_TXAGC_RU_1TX_RFBW80_0_SH 24
#define B_AX_TXAGC_RU_1TX_RFBW80_0_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW40_1_SH 15
#define B_AX_TXAGC_RU_1TX_RFBW40_1_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW40_0_SH 8
#define B_AX_TXAGC_RU_1TX_RFBW40_0_MSK 0x3f
#define B_AX_TXAGC_RU_1TX_RFBW20_0_SH 0
#define B_AX_TXAGC_RU_1TX_RFBW20_0_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE1 0xD340
#define R_AX_PWR_RU_LMT_TABLE1_C1 0xF340
#define B_AX_TXAGC_RU_1TX_RFBW160_0_SH 24
#define B_AX_TXAGC_RU_1TX_RFBW160_0_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW80_3_SH 15
#define B_AX_TXAGC_RU_1TX_RFBW80_3_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW80_2_SH 8
#define B_AX_TXAGC_RU_1TX_RFBW80_2_MSK 0x3f
#define B_AX_TXAGC_RU_1TX_RFBW80_1_SH 0
#define B_AX_TXAGC_RU_1TX_RFBW80_1_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE2 0xD344
#define R_AX_PWR_RU_LMT_TABLE2_C1 0xF344
#define B_AX_TXAGC_RU_1TX_RFBW160_4_SH 24
#define B_AX_TXAGC_RU_1TX_RFBW160_4_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW160_3_SH 15
#define B_AX_TXAGC_RU_1TX_RFBW160_3_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW160_2_SH 8
#define B_AX_TXAGC_RU_1TX_RFBW160_2_MSK 0x3f
#define B_AX_TXAGC_RU_1TX_RFBW160_1_SH 0
#define B_AX_TXAGC_RU_1TX_RFBW160_1_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE3 0xD348
#define R_AX_PWR_RU_LMT_TABLE3_C1 0xF348
#define B_AX_TXAGC_RU_2TX_RFBW20_0_SH 24
#define B_AX_TXAGC_RU_2TX_RFBW20_0_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW160_7_SH 15
#define B_AX_TXAGC_RU_1TX_RFBW160_7_MSK 0x7f
#define B_AX_TXAGC_RU_1TX_RFBW160_6_SH 8
#define B_AX_TXAGC_RU_1TX_RFBW160_6_MSK 0x3f
#define B_AX_TXAGC_RU_1TX_RFBW160_5_SH 0
#define B_AX_TXAGC_RU_1TX_RFBW160_5_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE4 0xD34C
#define R_AX_PWR_RU_LMT_TABLE4_C1 0xF34C
#define B_AX_TXAGC_RU_2TX_RFBW80_2_SH 24
#define B_AX_TXAGC_RU_2TX_RFBW80_2_MSK 0x7f
#define B_AX_TXAGC_RU_2TX_RFBW80_1_SH 15
#define B_AX_TXAGC_RU_2TX_RFBW80_1_MSK 0x7f
#define B_AX_TXAGC_RU_2TX_RFBW80_0_SH 8
#define B_AX_TXAGC_RU_2TX_RFBW80_0_MSK 0x3f
#define B_AX_TXAGC_RU_2TX_RFBW40_1_SH 0
#define B_AX_TXAGC_RU_2TX_RFBW40_1_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE5 0xD350
#define R_AX_PWR_RU_LMT_TABLE5_C1 0xF350
#define B_AX_TXAGC_RU_2TX_RFBW160_2_SH 24
#define B_AX_TXAGC_RU_2TX_RFBW160_2_MSK 0x7f
#define B_AX_TXAGC_RU_2TX_RFBW160_1_SH 15
#define B_AX_TXAGC_RU_2TX_RFBW160_1_MSK 0x7f
#define B_AX_TXAGC_RU_2TX_RFBW160_0_SH 8
#define B_AX_TXAGC_RU_2TX_RFBW160_0_MSK 0x3f
#define B_AX_TXAGC_RU_2TX_RFBW80_3_SH 0
#define B_AX_TXAGC_RU_2TX_RFBW80_3_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE6 0xD354
#define R_AX_PWR_RU_LMT_TABLE6_C1 0xF354
#define B_AX_TXAGC_RU_2TX_RFBW160_6_SH 24
#define B_AX_TXAGC_RU_2TX_RFBW160_6_MSK 0x7f
#define B_AX_TXAGC_RU_2TX_RFBW160_5_SH 15
#define B_AX_TXAGC_RU_2TX_RFBW160_5_MSK 0x7f
#define B_AX_TXAGC_RU_2TX_RFBW160_4_SH 8
#define B_AX_TXAGC_RU_2TX_RFBW160_4_MSK 0x3f
#define B_AX_TXAGC_RU_2TX_RFBW160_3_SH 0
#define B_AX_TXAGC_RU_2TX_RFBW160_3_MSK 0x7f

#define R_AX_PWR_RU_LMT_TABLE7 0xD358
#define R_AX_PWR_RU_LMT_TABLE7_C1 0xF358
#define B_AX_TXAGC_RU_2TX_RFBW160_7_SH 0
#define B_AX_TXAGC_RU_2TX_RFBW160_7_MSK 0x7f

#define R_AX_PWR_MACID_TABLE0 0xD35C
#define R_AX_PWR_MACID_TABLE0_C1 0xF35C
#define B_AX_MACID_0_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_0_TXPWR1_EN BIT(25)
#define B_AX_MACID_0_TXPWR0_EN BIT(24)
#define B_AX_MACID_0_CCA_PWR_TH_SH 16
#define B_AX_MACID_0_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_0_TXPWR1_SH 8
#define B_AX_MACID_0_TXPWR1_MSK 0xff
#define B_AX_MACID_0_TXPWR0_SH 0
#define B_AX_MACID_0_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE1 0xD360
#define R_AX_PWR_MACID_TABLE1_C1 0xF360
#define B_AX_MACID_1_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_1_TXPWR1_EN BIT(25)
#define B_AX_MACID_1_TXPWR0_EN BIT(24)
#define B_AX_MACID_1_CCA_PWR_TH_SH 16
#define B_AX_MACID_1_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_1_TXPWR1_SH 8
#define B_AX_MACID_1_TXPWR1_MSK 0xff
#define B_AX_MACID_1_TXPWR0_SH 0
#define B_AX_MACID_1_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE2 0xD364
#define R_AX_PWR_MACID_TABLE2_C1 0xF364
#define B_AX_MACID_2_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_2_TXPWR1_EN BIT(25)
#define B_AX_MACID_2_TXPWR0_EN BIT(24)
#define B_AX_MACID_2_CCA_PWR_TH_SH 16
#define B_AX_MACID_2_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_2_TXPWR1_SH 8
#define B_AX_MACID_2_TXPWR1_MSK 0xff
#define B_AX_MACID_2_TXPWR0_SH 0
#define B_AX_MACID_2_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE3 0xD368
#define R_AX_PWR_MACID_TABLE3_C1 0xF368
#define B_AX_MACID_3_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_3_TXPWR1_EN BIT(25)
#define B_AX_MACID_3_TXPWR0_EN BIT(24)
#define B_AX_MACID_3_CCA_PWR_TH_SH 16
#define B_AX_MACID_3_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_3_TXPWR1_SH 8
#define B_AX_MACID_3_TXPWR1_MSK 0xff
#define B_AX_MACID_3_TXPWR0_SH 0
#define B_AX_MACID_3_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE4 0xD36C
#define R_AX_PWR_MACID_TABLE4_C1 0xF36C
#define B_AX_MACID_4_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_4_TXPWR1_EN BIT(25)
#define B_AX_MACID_4_TXPWR0_EN BIT(24)
#define B_AX_MACID_4_CCA_PWR_TH_SH 16
#define B_AX_MACID_4_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_4_TXPWR1_SH 8
#define B_AX_MACID_4_TXPWR1_MSK 0xff
#define B_AX_MACID_4_TXPWR0_SH 0
#define B_AX_MACID_4_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE5 0xD370
#define R_AX_PWR_MACID_TABLE5_C1 0xF370
#define B_AX_MACID_5_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_5_TXPWR1_EN BIT(25)
#define B_AX_MACID_5_TXPWR0_EN BIT(24)
#define B_AX_MACID_5_CCA_PWR_TH_SH 16
#define B_AX_MACID_5_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_5_TXPWR1_SH 8
#define B_AX_MACID_5_TXPWR1_MSK 0xff
#define B_AX_MACID_5_TXPWR0_SH 0
#define B_AX_MACID_5_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE6 0xD374
#define R_AX_PWR_MACID_TABLE6_C1 0xF374
#define B_AX_MACID_6_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_6_TXPWR1_EN BIT(25)
#define B_AX_MACID_6_TXPWR0_EN BIT(24)
#define B_AX_MACID_6_CCA_PWR_TH_SH 16
#define B_AX_MACID_6_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_6_TXPWR1_SH 8
#define B_AX_MACID_6_TXPWR1_MSK 0xff
#define B_AX_MACID_6_TXPWR0_SH 0
#define B_AX_MACID_6_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE7 0xD378
#define R_AX_PWR_MACID_TABLE7_C1 0xF378
#define B_AX_MACID_7_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_7_TXPWR1_EN BIT(25)
#define B_AX_MACID_7_TXPWR0_EN BIT(24)
#define B_AX_MACID_7_CCA_PWR_TH_SH 16
#define B_AX_MACID_7_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_7_TXPWR1_SH 8
#define B_AX_MACID_7_TXPWR1_MSK 0xff
#define B_AX_MACID_7_TXPWR0_SH 0
#define B_AX_MACID_7_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE8 0xD37C
#define R_AX_PWR_MACID_TABLE8_C1 0xF37C
#define B_AX_MACID_8_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_8_TXPWR1_EN BIT(25)
#define B_AX_MACID_8_TXPWR0_EN BIT(24)
#define B_AX_MACID_8_CCA_PWR_TH_SH 16
#define B_AX_MACID_8_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_8_TXPWR1_SH 8
#define B_AX_MACID_8_TXPWR1_MSK 0xff
#define B_AX_MACID_8_TXPWR0_SH 0
#define B_AX_MACID_8_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE9 0xD380
#define R_AX_PWR_MACID_TABLE9_C1 0xF380
#define B_AX_MACID_9_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_9_TXPWR1_EN BIT(25)
#define B_AX_MACID_9_TXPWR0_EN BIT(24)
#define B_AX_MACID_9_CCA_PWR_TH_SH 16
#define B_AX_MACID_9_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_9_TXPWR1_SH 8
#define B_AX_MACID_9_TXPWR1_MSK 0xff
#define B_AX_MACID_9_TXPWR0_SH 0
#define B_AX_MACID_9_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE10 0xD384
#define R_AX_PWR_MACID_TABLE10_C1 0xF384
#define B_AX_MACID_10_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_10_TXPWR1_EN BIT(25)
#define B_AX_MACID_10_TXPWR0_EN BIT(24)
#define B_AX_MACID_10_CCA_PWR_TH_SH 16
#define B_AX_MACID_10_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_10_TXPWR1_SH 8
#define B_AX_MACID_10_TXPWR1_MSK 0xff
#define B_AX_MACID_10_TXPWR0_SH 0
#define B_AX_MACID_10_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE11 0xD388
#define R_AX_PWR_MACID_TABLE11_C1 0xF388
#define B_AX_MACID_11_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_11_TXPWR1_EN BIT(25)
#define B_AX_MACID_11_TXPWR0_EN BIT(24)
#define B_AX_MACID_11_CCA_PWR_TH_SH 16
#define B_AX_MACID_11_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_11_TXPWR1_SH 8
#define B_AX_MACID_11_TXPWR1_MSK 0xff
#define B_AX_MACID_11_TXPWR0_SH 0
#define B_AX_MACID_11_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE12 0xD38C
#define R_AX_PWR_MACID_TABLE12_C1 0xF38C
#define B_AX_MACID_12_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_12_TXPWR1_EN BIT(25)
#define B_AX_MACID_12_TXPWR0_EN BIT(24)
#define B_AX_MACID_12_CCA_PWR_TH_SH 16
#define B_AX_MACID_12_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_12_TXPWR1_SH 8
#define B_AX_MACID_12_TXPWR1_MSK 0xff
#define B_AX_MACID_12_TXPWR0_SH 0
#define B_AX_MACID_12_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE13 0xD390
#define R_AX_PWR_MACID_TABLE13_C1 0xF390
#define B_AX_MACID_13_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_13_TXPWR1_EN BIT(25)
#define B_AX_MACID_13_TXPWR0_EN BIT(24)
#define B_AX_MACID_13_CCA_PWR_TH_SH 16
#define B_AX_MACID_13_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_13_TXPWR1_SH 8
#define B_AX_MACID_13_TXPWR1_MSK 0xff
#define B_AX_MACID_13_TXPWR0_SH 0
#define B_AX_MACID_13_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE14 0xD394
#define R_AX_PWR_MACID_TABLE14_C1 0xF394
#define B_AX_MACID_14_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_14_TXPWR1_EN BIT(25)
#define B_AX_MACID_14_TXPWR0_EN BIT(24)
#define B_AX_MACID_14_CCA_PWR_TH_SH 16
#define B_AX_MACID_14_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_14_TXPWR1_SH 8
#define B_AX_MACID_14_TXPWR1_MSK 0xff
#define B_AX_MACID_14_TXPWR0_SH 0
#define B_AX_MACID_14_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE15 0xD398
#define R_AX_PWR_MACID_TABLE15_C1 0xF398
#define B_AX_MACID_15_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_15_TXPWR1_EN BIT(25)
#define B_AX_MACID_15_TXPWR0_EN BIT(24)
#define B_AX_MACID_15_CCA_PWR_TH_SH 16
#define B_AX_MACID_15_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_15_TXPWR1_SH 8
#define B_AX_MACID_15_TXPWR1_MSK 0xff
#define B_AX_MACID_15_TXPWR0_SH 0
#define B_AX_MACID_15_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE16 0xD39C
#define R_AX_PWR_MACID_TABLE16_C1 0xF39C
#define B_AX_MACID_16_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_16_TXPWR1_EN BIT(25)
#define B_AX_MACID_16_TXPWR0_EN BIT(24)
#define B_AX_MACID_16_CCA_PWR_TH_SH 16
#define B_AX_MACID_16_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_16_TXPWR1_SH 8
#define B_AX_MACID_16_TXPWR1_MSK 0xff
#define B_AX_MACID_16_TXPWR0_SH 0
#define B_AX_MACID_16_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE17 0xD3A0
#define R_AX_PWR_MACID_TABLE17_C1 0xF3A0
#define B_AX_MACID_17_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_17_TXPWR1_EN BIT(25)
#define B_AX_MACID_17_TXPWR0_EN BIT(24)
#define B_AX_MACID_17_CCA_PWR_TH_SH 16
#define B_AX_MACID_17_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_17_TXPWR1_SH 8
#define B_AX_MACID_17_TXPWR1_MSK 0xff
#define B_AX_MACID_17_TXPWR0_SH 0
#define B_AX_MACID_17_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE18 0xD3A4
#define R_AX_PWR_MACID_TABLE18_C1 0xF3A4
#define B_AX_MACID_18_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_18_TXPWR1_EN BIT(25)
#define B_AX_MACID_18_TXPWR0_EN BIT(24)
#define B_AX_MACID_18_CCA_PWR_TH_SH 16
#define B_AX_MACID_18_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_18_TXPWR1_SH 8
#define B_AX_MACID_18_TXPWR1_MSK 0xff
#define B_AX_MACID_18_TXPWR0_SH 0
#define B_AX_MACID_18_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE19 0xD3A8
#define R_AX_PWR_MACID_TABLE19_C1 0xF3A8
#define B_AX_MACID_19_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_19_TXPWR1_EN BIT(25)
#define B_AX_MACID_19_TXPWR0_EN BIT(24)
#define B_AX_MACID_19_CCA_PWR_TH_SH 16
#define B_AX_MACID_19_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_19_TXPWR1_SH 8
#define B_AX_MACID_19_TXPWR1_MSK 0xff
#define B_AX_MACID_19_TXPWR0_SH 0
#define B_AX_MACID_19_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE20 0xD3AC
#define R_AX_PWR_MACID_TABLE20_C1 0xF3AC
#define B_AX_MACID_20_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_20_TXPWR1_EN BIT(25)
#define B_AX_MACID_20_TXPWR0_EN BIT(24)
#define B_AX_MACID_20_CCA_PWR_TH_SH 16
#define B_AX_MACID_20_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_20_TXPWR1_SH 8
#define B_AX_MACID_20_TXPWR1_MSK 0xff
#define B_AX_MACID_20_TXPWR0_SH 0
#define B_AX_MACID_20_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE21 0xD3B0
#define R_AX_PWR_MACID_TABLE21_C1 0xF3B0
#define B_AX_MACID_21_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_21_TXPWR1_EN BIT(25)
#define B_AX_MACID_21_TXPWR0_EN BIT(24)
#define B_AX_MACID_21_CCA_PWR_TH_SH 16
#define B_AX_MACID_21_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_21_TXPWR1_SH 8
#define B_AX_MACID_21_TXPWR1_MSK 0xff
#define B_AX_MACID_21_TXPWR0_SH 0
#define B_AX_MACID_21_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE22 0xD3B4
#define R_AX_PWR_MACID_TABLE22_C1 0xF3B4
#define B_AX_MACID_22_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_22_TXPWR1_EN BIT(25)
#define B_AX_MACID_22_TXPWR0_EN BIT(24)
#define B_AX_MACID_22_CCA_PWR_TH_SH 16
#define B_AX_MACID_22_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_22_TXPWR1_SH 8
#define B_AX_MACID_22_TXPWR1_MSK 0xff
#define B_AX_MACID_22_TXPWR0_SH 0
#define B_AX_MACID_22_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE23 0xD3B8
#define R_AX_PWR_MACID_TABLE23_C1 0xF3B8
#define B_AX_MACID_23_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_23_TXPWR1_EN BIT(25)
#define B_AX_MACID_23_TXPWR0_EN BIT(24)
#define B_AX_MACID_23_CCA_PWR_TH_SH 16
#define B_AX_MACID_23_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_23_TXPWR1_SH 8
#define B_AX_MACID_23_TXPWR1_MSK 0xff
#define B_AX_MACID_23_TXPWR0_SH 0
#define B_AX_MACID_23_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE24 0xD3BC
#define R_AX_PWR_MACID_TABLE24_C1 0xF3BC
#define B_AX_MACID_24_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_24_TXPWR1_EN BIT(25)
#define B_AX_MACID_24_TXPWR0_EN BIT(24)
#define B_AX_MACID_24_CCA_PWR_TH_SH 16
#define B_AX_MACID_24_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_24_TXPWR1_SH 8
#define B_AX_MACID_24_TXPWR1_MSK 0xff
#define B_AX_MACID_24_TXPWR0_SH 0
#define B_AX_MACID_24_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE25 0xD3C0
#define R_AX_PWR_MACID_TABLE25_C1 0xF3C0
#define B_AX_MACID_25_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_25_TXPWR1_EN BIT(25)
#define B_AX_MACID_25_TXPWR0_EN BIT(24)
#define B_AX_MACID_25_CCA_PWR_TH_SH 16
#define B_AX_MACID_25_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_25_TXPWR1_SH 8
#define B_AX_MACID_25_TXPWR1_MSK 0xff
#define B_AX_MACID_25_TXPWR0_SH 0
#define B_AX_MACID_25_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE26 0xD3C4
#define R_AX_PWR_MACID_TABLE26_C1 0xF3C4
#define B_AX_MACID_26_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_26_TXPWR1_EN BIT(25)
#define B_AX_MACID_26_TXPWR0_EN BIT(24)
#define B_AX_MACID_26_CCA_PWR_TH_SH 16
#define B_AX_MACID_26_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_26_TXPWR1_SH 8
#define B_AX_MACID_26_TXPWR1_MSK 0xff
#define B_AX_MACID_26_TXPWR0_SH 0
#define B_AX_MACID_26_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE27 0xD3C8
#define R_AX_PWR_MACID_TABLE27_C1 0xF3C8
#define B_AX_MACID_27_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_27_TXPWR1_EN BIT(25)
#define B_AX_MACID_27_TXPWR0_EN BIT(24)
#define B_AX_MACID_27_CCA_PWR_TH_SH 16
#define B_AX_MACID_27_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_27_TXPWR1_SH 8
#define B_AX_MACID_27_TXPWR1_MSK 0xff
#define B_AX_MACID_27_TXPWR0_SH 0
#define B_AX_MACID_27_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE28 0xD3CC
#define R_AX_PWR_MACID_TABLE28_C1 0xF3CC
#define B_AX_MACID_28_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_28_TXPWR1_EN BIT(25)
#define B_AX_MACID_28_TXPWR0_EN BIT(24)
#define B_AX_MACID_28_CCA_PWR_TH_SH 16
#define B_AX_MACID_28_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_28_TXPWR1_SH 8
#define B_AX_MACID_28_TXPWR1_MSK 0xff
#define B_AX_MACID_28_TXPWR0_SH 0
#define B_AX_MACID_28_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE29 0xD3D0
#define R_AX_PWR_MACID_TABLE29_C1 0xF3D0
#define B_AX_MACID_29_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_29_TXPWR1_EN BIT(25)
#define B_AX_MACID_29_TXPWR0_EN BIT(24)
#define B_AX_MACID_29_CCA_PWR_TH_SH 16
#define B_AX_MACID_29_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_29_TXPWR1_SH 8
#define B_AX_MACID_29_TXPWR1_MSK 0xff
#define B_AX_MACID_29_TXPWR0_SH 0
#define B_AX_MACID_29_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE30 0xD3D4
#define R_AX_PWR_MACID_TABLE30_C1 0xF3D4
#define B_AX_MACID_30_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_30_TXPWR1_EN BIT(25)
#define B_AX_MACID_30_TXPWR0_EN BIT(24)
#define B_AX_MACID_30_CCA_PWR_TH_SH 16
#define B_AX_MACID_30_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_30_TXPWR1_SH 8
#define B_AX_MACID_30_TXPWR1_MSK 0xff
#define B_AX_MACID_30_TXPWR0_SH 0
#define B_AX_MACID_30_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE31 0xD3D8
#define R_AX_PWR_MACID_TABLE31_C1 0xF3D8
#define B_AX_MACID_31_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_31_TXPWR1_EN BIT(25)
#define B_AX_MACID_31_TXPWR0_EN BIT(24)
#define B_AX_MACID_31_CCA_PWR_TH_SH 16
#define B_AX_MACID_31_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_31_TXPWR1_SH 8
#define B_AX_MACID_31_TXPWR1_MSK 0xff
#define B_AX_MACID_31_TXPWR0_SH 0
#define B_AX_MACID_31_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE32 0xD3DC
#define R_AX_PWR_MACID_TABLE32_C1 0xF3DC
#define B_AX_MACID_32_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_32_TXPWR1_EN BIT(25)
#define B_AX_MACID_32_TXPWR0_EN BIT(24)
#define B_AX_MACID_32_CCA_PWR_TH_SH 16
#define B_AX_MACID_32_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_32_TXPWR1_SH 8
#define B_AX_MACID_32_TXPWR1_MSK 0xff
#define B_AX_MACID_32_TXPWR0_SH 0
#define B_AX_MACID_32_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE33 0xD3E0
#define R_AX_PWR_MACID_TABLE33_C1 0xF3E0
#define B_AX_MACID_33_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_33_TXPWR1_EN BIT(25)
#define B_AX_MACID_33_TXPWR0_EN BIT(24)
#define B_AX_MACID_33_CCA_PWR_TH_SH 16
#define B_AX_MACID_33_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_33_TXPWR1_SH 8
#define B_AX_MACID_33_TXPWR1_MSK 0xff
#define B_AX_MACID_33_TXPWR0_SH 0
#define B_AX_MACID_33_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE34 0xD3E4
#define R_AX_PWR_MACID_TABLE34_C1 0xF3E4
#define B_AX_MACID_34_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_34_TXPWR1_EN BIT(25)
#define B_AX_MACID_34_TXPWR0_EN BIT(24)
#define B_AX_MACID_34_CCA_PWR_TH_SH 16
#define B_AX_MACID_34_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_34_TXPWR1_SH 8
#define B_AX_MACID_34_TXPWR1_MSK 0xff
#define B_AX_MACID_34_TXPWR0_SH 0
#define B_AX_MACID_34_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE35 0xD3E8
#define R_AX_PWR_MACID_TABLE35_C1 0xF3E8
#define B_AX_MACID_35_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_35_TXPWR1_EN BIT(25)
#define B_AX_MACID_35_TXPWR0_EN BIT(24)
#define B_AX_MACID_35_CCA_PWR_TH_SH 16
#define B_AX_MACID_35_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_35_TXPWR1_SH 8
#define B_AX_MACID_35_TXPWR1_MSK 0xff
#define B_AX_MACID_35_TXPWR0_SH 0
#define B_AX_MACID_35_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE36 0xD3EC
#define R_AX_PWR_MACID_TABLE36_C1 0xF3EC
#define B_AX_MACID_36_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_36_TXPWR1_EN BIT(25)
#define B_AX_MACID_36_TXPWR0_EN BIT(24)
#define B_AX_MACID_36_CCA_PWR_TH_SH 16
#define B_AX_MACID_36_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_36_TXPWR1_SH 8
#define B_AX_MACID_36_TXPWR1_MSK 0xff
#define B_AX_MACID_36_TXPWR0_SH 0
#define B_AX_MACID_36_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE37 0xD3F0
#define R_AX_PWR_MACID_TABLE37_C1 0xF3F0
#define B_AX_MACID_37_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_37_TXPWR1_EN BIT(25)
#define B_AX_MACID_37_TXPWR0_EN BIT(24)
#define B_AX_MACID_37_CCA_PWR_TH_SH 16
#define B_AX_MACID_37_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_37_TXPWR1_SH 8
#define B_AX_MACID_37_TXPWR1_MSK 0xff
#define B_AX_MACID_37_TXPWR0_SH 0
#define B_AX_MACID_37_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE38 0xD3F4
#define R_AX_PWR_MACID_TABLE38_C1 0xF3F4
#define B_AX_MACID_38_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_38_TXPWR1_EN BIT(25)
#define B_AX_MACID_38_TXPWR0_EN BIT(24)
#define B_AX_MACID_38_CCA_PWR_TH_SH 16
#define B_AX_MACID_38_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_38_TXPWR1_SH 8
#define B_AX_MACID_38_TXPWR1_MSK 0xff
#define B_AX_MACID_38_TXPWR0_SH 0
#define B_AX_MACID_38_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE39 0xD3F8
#define R_AX_PWR_MACID_TABLE39_C1 0xF3F8
#define B_AX_MACID_39_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_39_TXPWR1_EN BIT(25)
#define B_AX_MACID_39_TXPWR0_EN BIT(24)
#define B_AX_MACID_39_CCA_PWR_TH_SH 16
#define B_AX_MACID_39_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_39_TXPWR1_SH 8
#define B_AX_MACID_39_TXPWR1_MSK 0xff
#define B_AX_MACID_39_TXPWR0_SH 0
#define B_AX_MACID_39_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE40 0xD3FC
#define R_AX_PWR_MACID_TABLE40_C1 0xF3FC
#define B_AX_MACID_40_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_40_TXPWR1_EN BIT(25)
#define B_AX_MACID_40_TXPWR0_EN BIT(24)
#define B_AX_MACID_40_CCA_PWR_TH_SH 16
#define B_AX_MACID_40_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_40_TXPWR1_SH 8
#define B_AX_MACID_40_TXPWR1_MSK 0xff
#define B_AX_MACID_40_TXPWR0_SH 0
#define B_AX_MACID_40_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE41 0xD400
#define R_AX_PWR_MACID_TABLE41_C1 0xF400
#define B_AX_MACID_41_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_41_TXPWR1_EN BIT(25)
#define B_AX_MACID_41_TXPWR0_EN BIT(24)
#define B_AX_MACID_41_CCA_PWR_TH_SH 16
#define B_AX_MACID_41_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_41_TXPWR1_SH 8
#define B_AX_MACID_41_TXPWR1_MSK 0xff
#define B_AX_MACID_41_TXPWR0_SH 0
#define B_AX_MACID_41_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE42 0xD404
#define R_AX_PWR_MACID_TABLE42_C1 0xF404
#define B_AX_MACID_42_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_42_TXPWR1_EN BIT(25)
#define B_AX_MACID_42_TXPWR0_EN BIT(24)
#define B_AX_MACID_42_CCA_PWR_TH_SH 16
#define B_AX_MACID_42_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_42_TXPWR1_SH 8
#define B_AX_MACID_42_TXPWR1_MSK 0xff
#define B_AX_MACID_42_TXPWR0_SH 0
#define B_AX_MACID_42_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE43 0xD408
#define R_AX_PWR_MACID_TABLE43_C1 0xF408
#define B_AX_MACID_43_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_43_TXPWR1_EN BIT(25)
#define B_AX_MACID_43_TXPWR0_EN BIT(24)
#define B_AX_MACID_43_CCA_PWR_TH_SH 16
#define B_AX_MACID_43_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_43_TXPWR1_SH 8
#define B_AX_MACID_43_TXPWR1_MSK 0xff
#define B_AX_MACID_43_TXPWR0_SH 0
#define B_AX_MACID_43_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE44 0xD40C
#define R_AX_PWR_MACID_TABLE44_C1 0xF40C
#define B_AX_MACID_44_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_44_TXPWR1_EN BIT(25)
#define B_AX_MACID_44_TXPWR0_EN BIT(24)
#define B_AX_MACID_44_CCA_PWR_TH_SH 16
#define B_AX_MACID_44_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_44_TXPWR1_SH 8
#define B_AX_MACID_44_TXPWR1_MSK 0xff
#define B_AX_MACID_44_TXPWR0_SH 0
#define B_AX_MACID_44_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE45 0xD410
#define R_AX_PWR_MACID_TABLE45_C1 0xF410
#define B_AX_MACID_45_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_45_TXPWR1_EN BIT(25)
#define B_AX_MACID_45_TXPWR0_EN BIT(24)
#define B_AX_MACID_45_CCA_PWR_TH_SH 16
#define B_AX_MACID_45_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_45_TXPWR1_SH 8
#define B_AX_MACID_45_TXPWR1_MSK 0xff
#define B_AX_MACID_45_TXPWR0_SH 0
#define B_AX_MACID_45_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE46 0xD414
#define R_AX_PWR_MACID_TABLE46_C1 0xF414
#define B_AX_MACID_46_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_46_TXPWR1_EN BIT(25)
#define B_AX_MACID_46_TXPWR0_EN BIT(24)
#define B_AX_MACID_46_CCA_PWR_TH_SH 16
#define B_AX_MACID_46_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_46_TXPWR1_SH 8
#define B_AX_MACID_46_TXPWR1_MSK 0xff
#define B_AX_MACID_46_TXPWR0_SH 0
#define B_AX_MACID_46_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE47 0xD418
#define R_AX_PWR_MACID_TABLE47_C1 0xF418
#define B_AX_MACID_47_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_47_TXPWR1_EN BIT(25)
#define B_AX_MACID_47_TXPWR0_EN BIT(24)
#define B_AX_MACID_47_CCA_PWR_TH_SH 16
#define B_AX_MACID_47_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_47_TXPWR1_SH 8
#define B_AX_MACID_47_TXPWR1_MSK 0xff
#define B_AX_MACID_47_TXPWR0_SH 0
#define B_AX_MACID_47_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE48 0xD41C
#define R_AX_PWR_MACID_TABLE48_C1 0xF41C
#define B_AX_MACID_48_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_48_TXPWR1_EN BIT(25)
#define B_AX_MACID_48_TXPWR0_EN BIT(24)
#define B_AX_MACID_48_CCA_PWR_TH_SH 16
#define B_AX_MACID_48_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_48_TXPWR1_SH 8
#define B_AX_MACID_48_TXPWR1_MSK 0xff
#define B_AX_MACID_48_TXPWR0_SH 0
#define B_AX_MACID_48_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE49 0xD420
#define R_AX_PWR_MACID_TABLE49_C1 0xF420
#define B_AX_MACID_49_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_49_TXPWR1_EN BIT(25)
#define B_AX_MACID_49_TXPWR0_EN BIT(24)
#define B_AX_MACID_49_CCA_PWR_TH_SH 16
#define B_AX_MACID_49_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_49_TXPWR1_SH 8
#define B_AX_MACID_49_TXPWR1_MSK 0xff
#define B_AX_MACID_49_TXPWR0_SH 0
#define B_AX_MACID_49_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE50 0xD424
#define R_AX_PWR_MACID_TABLE50_C1 0xF424
#define B_AX_MACID_50_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_50_TXPWR1_EN BIT(25)
#define B_AX_MACID_50_TXPWR0_EN BIT(24)
#define B_AX_MACID_50_CCA_PWR_TH_SH 16
#define B_AX_MACID_50_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_50_TXPWR1_SH 8
#define B_AX_MACID_50_TXPWR1_MSK 0xff
#define B_AX_MACID_50_TXPWR0_SH 0
#define B_AX_MACID_50_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE51 0xD428
#define R_AX_PWR_MACID_TABLE51_C1 0xF428
#define B_AX_MACID_51_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_51_TXPWR1_EN BIT(25)
#define B_AX_MACID_51_TXPWR0_EN BIT(24)
#define B_AX_MACID_51_CCA_PWR_TH_SH 16
#define B_AX_MACID_51_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_51_TXPWR1_SH 8
#define B_AX_MACID_51_TXPWR1_MSK 0xff
#define B_AX_MACID_51_TXPWR0_SH 0
#define B_AX_MACID_51_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE52 0xD42C
#define R_AX_PWR_MACID_TABLE52_C1 0xF42C
#define B_AX_MACID_52_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_52_TXPWR1_EN BIT(25)
#define B_AX_MACID_52_TXPWR0_EN BIT(24)
#define B_AX_MACID_52_CCA_PWR_TH_SH 16
#define B_AX_MACID_52_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_52_TXPWR1_SH 8
#define B_AX_MACID_52_TXPWR1_MSK 0xff
#define B_AX_MACID_52_TXPWR0_SH 0
#define B_AX_MACID_52_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE53 0xD430
#define R_AX_PWR_MACID_TABLE53_C1 0xF430
#define B_AX_MACID_53_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_53_TXPWR1_EN BIT(25)
#define B_AX_MACID_53_TXPWR0_EN BIT(24)
#define B_AX_MACID_53_CCA_PWR_TH_SH 16
#define B_AX_MACID_53_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_53_TXPWR1_SH 8
#define B_AX_MACID_53_TXPWR1_MSK 0xff
#define B_AX_MACID_53_TXPWR0_SH 0
#define B_AX_MACID_53_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE54 0xD434
#define R_AX_PWR_MACID_TABLE54_C1 0xF434
#define B_AX_MACID_54_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_54_TXPWR1_EN BIT(25)
#define B_AX_MACID_54_TXPWR0_EN BIT(24)
#define B_AX_MACID_54_CCA_PWR_TH_SH 16
#define B_AX_MACID_54_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_54_TXPWR1_SH 8
#define B_AX_MACID_54_TXPWR1_MSK 0xff
#define B_AX_MACID_54_TXPWR0_SH 0
#define B_AX_MACID_54_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE55 0xD438
#define R_AX_PWR_MACID_TABLE55_C1 0xF438
#define B_AX_MACID_55_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_55_TXPWR1_EN BIT(25)
#define B_AX_MACID_55_TXPWR0_EN BIT(24)
#define B_AX_MACID_55_CCA_PWR_TH_SH 16
#define B_AX_MACID_55_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_55_TXPWR1_SH 8
#define B_AX_MACID_55_TXPWR1_MSK 0xff
#define B_AX_MACID_55_TXPWR0_SH 0
#define B_AX_MACID_55_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE56 0xD43C
#define R_AX_PWR_MACID_TABLE56_C1 0xF43C
#define B_AX_MACID_56_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_56_TXPWR1_EN BIT(25)
#define B_AX_MACID_56_TXPWR0_EN BIT(24)
#define B_AX_MACID_56_CCA_PWR_TH_SH 16
#define B_AX_MACID_56_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_56_TXPWR1_SH 8
#define B_AX_MACID_56_TXPWR1_MSK 0xff
#define B_AX_MACID_56_TXPWR0_SH 0
#define B_AX_MACID_56_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE57 0xD440
#define R_AX_PWR_MACID_TABLE57_C1 0xF440
#define B_AX_MACID_57_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_57_TXPWR1_EN BIT(25)
#define B_AX_MACID_57_TXPWR0_EN BIT(24)
#define B_AX_MACID_57_CCA_PWR_TH_SH 16
#define B_AX_MACID_57_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_57_TXPWR1_SH 8
#define B_AX_MACID_57_TXPWR1_MSK 0xff
#define B_AX_MACID_57_TXPWR0_SH 0
#define B_AX_MACID_57_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE58 0xD444
#define R_AX_PWR_MACID_TABLE58_C1 0xF444
#define B_AX_MACID_58_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_58_TXPWR1_EN BIT(25)
#define B_AX_MACID_58_TXPWR0_EN BIT(24)
#define B_AX_MACID_58_CCA_PWR_TH_SH 16
#define B_AX_MACID_58_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_58_TXPWR1_SH 8
#define B_AX_MACID_58_TXPWR1_MSK 0xff
#define B_AX_MACID_58_TXPWR0_SH 0
#define B_AX_MACID_58_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE59 0xD448
#define R_AX_PWR_MACID_TABLE59_C1 0xF448
#define B_AX_MACID_59_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_59_TXPWR1_EN BIT(25)
#define B_AX_MACID_59_TXPWR0_EN BIT(24)
#define B_AX_MACID_59_CCA_PWR_TH_SH 16
#define B_AX_MACID_59_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_59_TXPWR1_SH 8
#define B_AX_MACID_59_TXPWR1_MSK 0xff
#define B_AX_MACID_59_TXPWR0_SH 0
#define B_AX_MACID_59_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE60 0xD44C
#define R_AX_PWR_MACID_TABLE60_C1 0xF44C
#define B_AX_MACID_60_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_60_TXPWR1_EN BIT(25)
#define B_AX_MACID_60_TXPWR0_EN BIT(24)
#define B_AX_MACID_60_CCA_PWR_TH_SH 16
#define B_AX_MACID_60_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_60_TXPWR1_SH 8
#define B_AX_MACID_60_TXPWR1_MSK 0xff
#define B_AX_MACID_60_TXPWR0_SH 0
#define B_AX_MACID_60_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE61 0xD450
#define R_AX_PWR_MACID_TABLE61_C1 0xF450
#define B_AX_MACID_61_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_61_TXPWR1_EN BIT(25)
#define B_AX_MACID_61_TXPWR0_EN BIT(24)
#define B_AX_MACID_61_CCA_PWR_TH_SH 16
#define B_AX_MACID_61_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_61_TXPWR1_SH 8
#define B_AX_MACID_61_TXPWR1_MSK 0xff
#define B_AX_MACID_61_TXPWR0_SH 0
#define B_AX_MACID_61_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE62 0xD454
#define R_AX_PWR_MACID_TABLE62_C1 0xF454
#define B_AX_MACID_62_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_62_TXPWR1_EN BIT(25)
#define B_AX_MACID_62_TXPWR0_EN BIT(24)
#define B_AX_MACID_62_CCA_PWR_TH_SH 16
#define B_AX_MACID_62_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_62_TXPWR1_SH 8
#define B_AX_MACID_62_TXPWR1_MSK 0xff
#define B_AX_MACID_62_TXPWR0_SH 0
#define B_AX_MACID_62_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE63 0xD458
#define R_AX_PWR_MACID_TABLE63_C1 0xF458
#define B_AX_MACID_63_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_63_TXPWR1_EN BIT(25)
#define B_AX_MACID_63_TXPWR0_EN BIT(24)
#define B_AX_MACID_63_CCA_PWR_TH_SH 16
#define B_AX_MACID_63_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_63_TXPWR1_SH 8
#define B_AX_MACID_63_TXPWR1_MSK 0xff
#define B_AX_MACID_63_TXPWR0_SH 0
#define B_AX_MACID_63_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE64 0xD45C
#define R_AX_PWR_MACID_TABLE64_C1 0xF45C
#define B_AX_MACID_64_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_64_TXPWR1_EN BIT(25)
#define B_AX_MACID_64_TXPWR0_EN BIT(24)
#define B_AX_MACID_64_CCA_PWR_TH_SH 16
#define B_AX_MACID_64_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_64_TXPWR1_SH 8
#define B_AX_MACID_64_TXPWR1_MSK 0xff
#define B_AX_MACID_64_TXPWR0_SH 0
#define B_AX_MACID_64_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE65 0xD460
#define R_AX_PWR_MACID_TABLE65_C1 0xF460
#define B_AX_MACID_65_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_65_TXPWR1_EN BIT(25)
#define B_AX_MACID_65_TXPWR0_EN BIT(24)
#define B_AX_MACID_65_CCA_PWR_TH_SH 16
#define B_AX_MACID_65_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_65_TXPWR1_SH 8
#define B_AX_MACID_65_TXPWR1_MSK 0xff
#define B_AX_MACID_65_TXPWR0_SH 0
#define B_AX_MACID_65_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE66 0xD464
#define R_AX_PWR_MACID_TABLE66_C1 0xF464
#define B_AX_MACID_66_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_66_TXPWR1_EN BIT(25)
#define B_AX_MACID_66_TXPWR0_EN BIT(24)
#define B_AX_MACID_66_CCA_PWR_TH_SH 16
#define B_AX_MACID_66_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_66_TXPWR1_SH 8
#define B_AX_MACID_66_TXPWR1_MSK 0xff
#define B_AX_MACID_66_TXPWR0_SH 0
#define B_AX_MACID_66_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE67 0xD468
#define R_AX_PWR_MACID_TABLE67_C1 0xF468
#define B_AX_MACID_67_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_67_TXPWR1_EN BIT(25)
#define B_AX_MACID_67_TXPWR0_EN BIT(24)
#define B_AX_MACID_67_CCA_PWR_TH_SH 16
#define B_AX_MACID_67_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_67_TXPWR1_SH 8
#define B_AX_MACID_67_TXPWR1_MSK 0xff
#define B_AX_MACID_67_TXPWR0_SH 0
#define B_AX_MACID_67_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE68 0xD46C
#define R_AX_PWR_MACID_TABLE68_C1 0xF46C
#define B_AX_MACID_68_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_68_TXPWR1_EN BIT(25)
#define B_AX_MACID_68_TXPWR0_EN BIT(24)
#define B_AX_MACID_68_CCA_PWR_TH_SH 16
#define B_AX_MACID_68_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_68_TXPWR1_SH 8
#define B_AX_MACID_68_TXPWR1_MSK 0xff
#define B_AX_MACID_68_TXPWR0_SH 0
#define B_AX_MACID_68_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE69 0xD470
#define R_AX_PWR_MACID_TABLE69_C1 0xF470
#define B_AX_MACID_69_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_69_TXPWR1_EN BIT(25)
#define B_AX_MACID_69_TXPWR0_EN BIT(24)
#define B_AX_MACID_69_CCA_PWR_TH_SH 16
#define B_AX_MACID_69_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_69_TXPWR1_SH 8
#define B_AX_MACID_69_TXPWR1_MSK 0xff
#define B_AX_MACID_69_TXPWR0_SH 0
#define B_AX_MACID_69_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE70 0xD474
#define R_AX_PWR_MACID_TABLE70_C1 0xF474
#define B_AX_MACID_70_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_70_TXPWR1_EN BIT(25)
#define B_AX_MACID_70_TXPWR0_EN BIT(24)
#define B_AX_MACID_70_CCA_PWR_TH_SH 16
#define B_AX_MACID_70_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_70_TXPWR1_SH 8
#define B_AX_MACID_70_TXPWR1_MSK 0xff
#define B_AX_MACID_70_TXPWR0_SH 0
#define B_AX_MACID_70_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE71 0xD478
#define R_AX_PWR_MACID_TABLE71_C1 0xF478
#define B_AX_MACID_71_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_71_TXPWR1_EN BIT(25)
#define B_AX_MACID_71_TXPWR0_EN BIT(24)
#define B_AX_MACID_71_CCA_PWR_TH_SH 16
#define B_AX_MACID_71_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_71_TXPWR1_SH 8
#define B_AX_MACID_71_TXPWR1_MSK 0xff
#define B_AX_MACID_71_TXPWR0_SH 0
#define B_AX_MACID_71_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE72 0xD47C
#define R_AX_PWR_MACID_TABLE72_C1 0xF47C
#define B_AX_MACID_72_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_72_TXPWR1_EN BIT(25)
#define B_AX_MACID_72_TXPWR0_EN BIT(24)
#define B_AX_MACID_72_CCA_PWR_TH_SH 16
#define B_AX_MACID_72_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_72_TXPWR1_SH 8
#define B_AX_MACID_72_TXPWR1_MSK 0xff
#define B_AX_MACID_72_TXPWR0_SH 0
#define B_AX_MACID_72_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE73 0xD480
#define R_AX_PWR_MACID_TABLE73_C1 0xF480
#define B_AX_MACID_73_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_73_TXPWR1_EN BIT(25)
#define B_AX_MACID_73_TXPWR0_EN BIT(24)
#define B_AX_MACID_73_CCA_PWR_TH_SH 16
#define B_AX_MACID_73_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_73_TXPWR1_SH 8
#define B_AX_MACID_73_TXPWR1_MSK 0xff
#define B_AX_MACID_73_TXPWR0_SH 0
#define B_AX_MACID_73_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE74 0xD484
#define R_AX_PWR_MACID_TABLE74_C1 0xF484
#define B_AX_MACID_74_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_74_TXPWR1_EN BIT(25)
#define B_AX_MACID_74_TXPWR0_EN BIT(24)
#define B_AX_MACID_74_CCA_PWR_TH_SH 16
#define B_AX_MACID_74_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_74_TXPWR1_SH 8
#define B_AX_MACID_74_TXPWR1_MSK 0xff
#define B_AX_MACID_74_TXPWR0_SH 0
#define B_AX_MACID_74_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE75 0xD488
#define R_AX_PWR_MACID_TABLE75_C1 0xF488
#define B_AX_MACID_75_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_75_TXPWR1_EN BIT(25)
#define B_AX_MACID_75_TXPWR0_EN BIT(24)
#define B_AX_MACID_75_CCA_PWR_TH_SH 16
#define B_AX_MACID_75_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_75_TXPWR1_SH 8
#define B_AX_MACID_75_TXPWR1_MSK 0xff
#define B_AX_MACID_75_TXPWR0_SH 0
#define B_AX_MACID_75_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE76 0xD48C
#define R_AX_PWR_MACID_TABLE76_C1 0xF48C
#define B_AX_MACID_76_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_76_TXPWR1_EN BIT(25)
#define B_AX_MACID_76_TXPWR0_EN BIT(24)
#define B_AX_MACID_76_CCA_PWR_TH_SH 16
#define B_AX_MACID_76_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_76_TXPWR1_SH 8
#define B_AX_MACID_76_TXPWR1_MSK 0xff
#define B_AX_MACID_76_TXPWR0_SH 0
#define B_AX_MACID_76_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE77 0xD490
#define R_AX_PWR_MACID_TABLE77_C1 0xF490
#define B_AX_MACID_77_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_77_TXPWR1_EN BIT(25)
#define B_AX_MACID_77_TXPWR0_EN BIT(24)
#define B_AX_MACID_77_CCA_PWR_TH_SH 16
#define B_AX_MACID_77_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_77_TXPWR1_SH 8
#define B_AX_MACID_77_TXPWR1_MSK 0xff
#define B_AX_MACID_77_TXPWR0_SH 0
#define B_AX_MACID_77_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE78 0xD494
#define R_AX_PWR_MACID_TABLE78_C1 0xF494
#define B_AX_MACID_78_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_78_TXPWR1_EN BIT(25)
#define B_AX_MACID_78_TXPWR0_EN BIT(24)
#define B_AX_MACID_78_CCA_PWR_TH_SH 16
#define B_AX_MACID_78_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_78_TXPWR1_SH 8
#define B_AX_MACID_78_TXPWR1_MSK 0xff
#define B_AX_MACID_78_TXPWR0_SH 0
#define B_AX_MACID_78_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE79 0xD498
#define R_AX_PWR_MACID_TABLE79_C1 0xF498
#define B_AX_MACID_79_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_79_TXPWR1_EN BIT(25)
#define B_AX_MACID_79_TXPWR0_EN BIT(24)
#define B_AX_MACID_79_CCA_PWR_TH_SH 16
#define B_AX_MACID_79_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_79_TXPWR1_SH 8
#define B_AX_MACID_79_TXPWR1_MSK 0xff
#define B_AX_MACID_79_TXPWR0_SH 0
#define B_AX_MACID_79_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE80 0xD49C
#define R_AX_PWR_MACID_TABLE80_C1 0xF49C
#define B_AX_MACID_80_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_80_TXPWR1_EN BIT(25)
#define B_AX_MACID_80_TXPWR0_EN BIT(24)
#define B_AX_MACID_80_CCA_PWR_TH_SH 16
#define B_AX_MACID_80_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_80_TXPWR1_SH 8
#define B_AX_MACID_80_TXPWR1_MSK 0xff
#define B_AX_MACID_80_TXPWR0_SH 0
#define B_AX_MACID_80_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE81 0xD4A0
#define R_AX_PWR_MACID_TABLE81_C1 0xF4A0
#define B_AX_MACID_81_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_81_TXPWR1_EN BIT(25)
#define B_AX_MACID_81_TXPWR0_EN BIT(24)
#define B_AX_MACID_81_CCA_PWR_TH_SH 16
#define B_AX_MACID_81_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_81_TXPWR1_SH 8
#define B_AX_MACID_81_TXPWR1_MSK 0xff
#define B_AX_MACID_81_TXPWR0_SH 0
#define B_AX_MACID_81_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE82 0xD4A4
#define R_AX_PWR_MACID_TABLE82_C1 0xF4A4
#define B_AX_MACID_82_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_82_TXPWR1_EN BIT(25)
#define B_AX_MACID_82_TXPWR0_EN BIT(24)
#define B_AX_MACID_82_CCA_PWR_TH_SH 16
#define B_AX_MACID_82_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_82_TXPWR1_SH 8
#define B_AX_MACID_82_TXPWR1_MSK 0xff
#define B_AX_MACID_82_TXPWR0_SH 0
#define B_AX_MACID_82_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE83 0xD4A8
#define R_AX_PWR_MACID_TABLE83_C1 0xF4A8
#define B_AX_MACID_83_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_83_TXPWR1_EN BIT(25)
#define B_AX_MACID_83_TXPWR0_EN BIT(24)
#define B_AX_MACID_83_CCA_PWR_TH_SH 16
#define B_AX_MACID_83_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_83_TXPWR1_SH 8
#define B_AX_MACID_83_TXPWR1_MSK 0xff
#define B_AX_MACID_83_TXPWR0_SH 0
#define B_AX_MACID_83_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE84 0xD4AC
#define R_AX_PWR_MACID_TABLE84_C1 0xF4AC
#define B_AX_MACID_84_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_84_TXPWR1_EN BIT(25)
#define B_AX_MACID_84_TXPWR0_EN BIT(24)
#define B_AX_MACID_84_CCA_PWR_TH_SH 16
#define B_AX_MACID_84_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_84_TXPWR1_SH 8
#define B_AX_MACID_84_TXPWR1_MSK 0xff
#define B_AX_MACID_84_TXPWR0_SH 0
#define B_AX_MACID_84_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE85 0xD4B0
#define R_AX_PWR_MACID_TABLE85_C1 0xF4B0
#define B_AX_MACID_85_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_85_TXPWR1_EN BIT(25)
#define B_AX_MACID_85_TXPWR0_EN BIT(24)
#define B_AX_MACID_85_CCA_PWR_TH_SH 16
#define B_AX_MACID_85_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_85_TXPWR1_SH 8
#define B_AX_MACID_85_TXPWR1_MSK 0xff
#define B_AX_MACID_85_TXPWR0_SH 0
#define B_AX_MACID_85_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE86 0xD4B4
#define R_AX_PWR_MACID_TABLE86_C1 0xF4B4
#define B_AX_MACID_86_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_86_TXPWR1_EN BIT(25)
#define B_AX_MACID_86_TXPWR0_EN BIT(24)
#define B_AX_MACID_86_CCA_PWR_TH_SH 16
#define B_AX_MACID_86_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_86_TXPWR1_SH 8
#define B_AX_MACID_86_TXPWR1_MSK 0xff
#define B_AX_MACID_86_TXPWR0_SH 0
#define B_AX_MACID_86_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE87 0xD4B8
#define R_AX_PWR_MACID_TABLE87_C1 0xF4B8
#define B_AX_MACID_87_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_87_TXPWR1_EN BIT(25)
#define B_AX_MACID_87_TXPWR0_EN BIT(24)
#define B_AX_MACID_87_CCA_PWR_TH_SH 16
#define B_AX_MACID_87_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_87_TXPWR1_SH 8
#define B_AX_MACID_87_TXPWR1_MSK 0xff
#define B_AX_MACID_87_TXPWR0_SH 0
#define B_AX_MACID_87_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE88 0xD4BC
#define R_AX_PWR_MACID_TABLE88_C1 0xF4BC
#define B_AX_MACID_88_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_88_TXPWR1_EN BIT(25)
#define B_AX_MACID_88_TXPWR0_EN BIT(24)
#define B_AX_MACID_88_CCA_PWR_TH_SH 16
#define B_AX_MACID_88_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_88_TXPWR1_SH 8
#define B_AX_MACID_88_TXPWR1_MSK 0xff
#define B_AX_MACID_88_TXPWR0_SH 0
#define B_AX_MACID_88_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE89 0xD4C0
#define R_AX_PWR_MACID_TABLE89_C1 0xF4C0
#define B_AX_MACID_89_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_89_TXPWR1_EN BIT(25)
#define B_AX_MACID_89_TXPWR0_EN BIT(24)
#define B_AX_MACID_89_CCA_PWR_TH_SH 16
#define B_AX_MACID_89_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_89_TXPWR1_SH 8
#define B_AX_MACID_89_TXPWR1_MSK 0xff
#define B_AX_MACID_89_TXPWR0_SH 0
#define B_AX_MACID_89_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE90 0xD4C4
#define R_AX_PWR_MACID_TABLE90_C1 0xF4C4
#define B_AX_MACID_90_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_90_TXPWR1_EN BIT(25)
#define B_AX_MACID_90_TXPWR0_EN BIT(24)
#define B_AX_MACID_90_CCA_PWR_TH_SH 16
#define B_AX_MACID_90_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_90_TXPWR1_SH 8
#define B_AX_MACID_90_TXPWR1_MSK 0xff
#define B_AX_MACID_90_TXPWR0_SH 0
#define B_AX_MACID_90_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE91 0xD4C8
#define R_AX_PWR_MACID_TABLE91_C1 0xF4C8
#define B_AX_MACID_91_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_91_TXPWR1_EN BIT(25)
#define B_AX_MACID_91_TXPWR0_EN BIT(24)
#define B_AX_MACID_91_CCA_PWR_TH_SH 16
#define B_AX_MACID_91_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_91_TXPWR1_SH 8
#define B_AX_MACID_91_TXPWR1_MSK 0xff
#define B_AX_MACID_91_TXPWR0_SH 0
#define B_AX_MACID_91_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE92 0xD4CC
#define R_AX_PWR_MACID_TABLE92_C1 0xF4CC
#define B_AX_MACID_92_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_92_TXPWR1_EN BIT(25)
#define B_AX_MACID_92_TXPWR0_EN BIT(24)
#define B_AX_MACID_92_CCA_PWR_TH_SH 16
#define B_AX_MACID_92_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_92_TXPWR1_SH 8
#define B_AX_MACID_92_TXPWR1_MSK 0xff
#define B_AX_MACID_92_TXPWR0_SH 0
#define B_AX_MACID_92_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE93 0xD4D0
#define R_AX_PWR_MACID_TABLE93_C1 0xF4D0
#define B_AX_MACID_93_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_93_TXPWR1_EN BIT(25)
#define B_AX_MACID_93_TXPWR0_EN BIT(24)
#define B_AX_MACID_93_CCA_PWR_TH_SH 16
#define B_AX_MACID_93_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_93_TXPWR1_SH 8
#define B_AX_MACID_93_TXPWR1_MSK 0xff
#define B_AX_MACID_93_TXPWR0_SH 0
#define B_AX_MACID_93_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE94 0xD4D4
#define R_AX_PWR_MACID_TABLE94_C1 0xF4D4
#define B_AX_MACID_94_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_94_TXPWR1_EN BIT(25)
#define B_AX_MACID_94_TXPWR0_EN BIT(24)
#define B_AX_MACID_94_CCA_PWR_TH_SH 16
#define B_AX_MACID_94_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_94_TXPWR1_SH 8
#define B_AX_MACID_94_TXPWR1_MSK 0xff
#define B_AX_MACID_94_TXPWR0_SH 0
#define B_AX_MACID_94_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE95 0xD4D8
#define R_AX_PWR_MACID_TABLE95_C1 0xF4D8
#define B_AX_MACID_95_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_95_TXPWR1_EN BIT(25)
#define B_AX_MACID_95_TXPWR0_EN BIT(24)
#define B_AX_MACID_95_CCA_PWR_TH_SH 16
#define B_AX_MACID_95_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_95_TXPWR1_SH 8
#define B_AX_MACID_95_TXPWR1_MSK 0xff
#define B_AX_MACID_95_TXPWR0_SH 0
#define B_AX_MACID_95_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE96 0xD4DC
#define R_AX_PWR_MACID_TABLE96_C1 0xF4DC
#define B_AX_MACID_96_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_96_TXPWR1_EN BIT(25)
#define B_AX_MACID_96_TXPWR0_EN BIT(24)
#define B_AX_MACID_96_CCA_PWR_TH_SH 16
#define B_AX_MACID_96_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_96_TXPWR1_SH 8
#define B_AX_MACID_96_TXPWR1_MSK 0xff
#define B_AX_MACID_96_TXPWR0_SH 0
#define B_AX_MACID_96_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE97 0xD4E0
#define R_AX_PWR_MACID_TABLE97_C1 0xF4E0
#define B_AX_MACID_97_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_97_TXPWR1_EN BIT(25)
#define B_AX_MACID_97_TXPWR0_EN BIT(24)
#define B_AX_MACID_97_CCA_PWR_TH_SH 16
#define B_AX_MACID_97_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_97_TXPWR1_SH 8
#define B_AX_MACID_97_TXPWR1_MSK 0xff
#define B_AX_MACID_97_TXPWR0_SH 0
#define B_AX_MACID_97_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE98 0xD4E4
#define R_AX_PWR_MACID_TABLE98_C1 0xF4E4
#define B_AX_MACID_98_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_98_TXPWR1_EN BIT(25)
#define B_AX_MACID_98_TXPWR0_EN BIT(24)
#define B_AX_MACID_98_CCA_PWR_TH_SH 16
#define B_AX_MACID_98_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_98_TXPWR1_SH 8
#define B_AX_MACID_98_TXPWR1_MSK 0xff
#define B_AX_MACID_98_TXPWR0_SH 0
#define B_AX_MACID_98_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE99 0xD4E8
#define R_AX_PWR_MACID_TABLE99_C1 0xF4E8
#define B_AX_MACID_99_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_99_TXPWR1_EN BIT(25)
#define B_AX_MACID_99_TXPWR0_EN BIT(24)
#define B_AX_MACID_99_CCA_PWR_TH_SH 16
#define B_AX_MACID_99_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_99_TXPWR1_SH 8
#define B_AX_MACID_99_TXPWR1_MSK 0xff
#define B_AX_MACID_99_TXPWR0_SH 0
#define B_AX_MACID_99_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE100 0xD4EC
#define R_AX_PWR_MACID_TABLE100_C1 0xF4EC
#define B_AX_MACID_100_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_100_TXPWR1_EN BIT(25)
#define B_AX_MACID_100_TXPWR0_EN BIT(24)
#define B_AX_MACID_100_CCA_PWR_TH_SH 16
#define B_AX_MACID_100_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_100_TXPWR1_SH 8
#define B_AX_MACID_100_TXPWR1_MSK 0xff
#define B_AX_MACID_100_TXPWR0_SH 0
#define B_AX_MACID_100_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE101 0xD4F0
#define R_AX_PWR_MACID_TABLE101_C1 0xF4F0
#define B_AX_MACID_101_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_101_TXPWR1_EN BIT(25)
#define B_AX_MACID_101_TXPWR0_EN BIT(24)
#define B_AX_MACID_101_CCA_PWR_TH_SH 16
#define B_AX_MACID_101_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_101_TXPWR1_SH 8
#define B_AX_MACID_101_TXPWR1_MSK 0xff
#define B_AX_MACID_101_TXPWR0_SH 0
#define B_AX_MACID_101_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE102 0xD4F4
#define R_AX_PWR_MACID_TABLE102_C1 0xF4F4
#define B_AX_MACID_102_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_102_TXPWR1_EN BIT(25)
#define B_AX_MACID_102_TXPWR0_EN BIT(24)
#define B_AX_MACID_102_CCA_PWR_TH_SH 16
#define B_AX_MACID_102_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_102_TXPWR1_SH 8
#define B_AX_MACID_102_TXPWR1_MSK 0xff
#define B_AX_MACID_102_TXPWR0_SH 0
#define B_AX_MACID_102_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE103 0xD4F8
#define R_AX_PWR_MACID_TABLE103_C1 0xF4F8
#define B_AX_MACID_103_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_103_TXPWR1_EN BIT(25)
#define B_AX_MACID_103_TXPWR0_EN BIT(24)
#define B_AX_MACID_103_CCA_PWR_TH_SH 16
#define B_AX_MACID_103_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_103_TXPWR1_SH 8
#define B_AX_MACID_103_TXPWR1_MSK 0xff
#define B_AX_MACID_103_TXPWR0_SH 0
#define B_AX_MACID_103_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE104 0xD4FC
#define R_AX_PWR_MACID_TABLE104_C1 0xF4FC
#define B_AX_MACID_104_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_104_TXPWR1_EN BIT(25)
#define B_AX_MACID_104_TXPWR0_EN BIT(24)
#define B_AX_MACID_104_CCA_PWR_TH_SH 16
#define B_AX_MACID_104_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_104_TXPWR1_SH 8
#define B_AX_MACID_104_TXPWR1_MSK 0xff
#define B_AX_MACID_104_TXPWR0_SH 0
#define B_AX_MACID_104_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE105 0xD500
#define R_AX_PWR_MACID_TABLE105_C1 0xF500
#define B_AX_MACID_105_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_105_TXPWR1_EN BIT(25)
#define B_AX_MACID_105_TXPWR0_EN BIT(24)
#define B_AX_MACID_105_CCA_PWR_TH_SH 16
#define B_AX_MACID_105_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_105_TXPWR1_SH 8
#define B_AX_MACID_105_TXPWR1_MSK 0xff
#define B_AX_MACID_105_TXPWR0_SH 0
#define B_AX_MACID_105_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE106 0xD504
#define R_AX_PWR_MACID_TABLE106_C1 0xF504
#define B_AX_MACID_106_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_106_TXPWR1_EN BIT(25)
#define B_AX_MACID_106_TXPWR0_EN BIT(24)
#define B_AX_MACID_106_CCA_PWR_TH_SH 16
#define B_AX_MACID_106_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_106_TXPWR1_SH 8
#define B_AX_MACID_106_TXPWR1_MSK 0xff
#define B_AX_MACID_106_TXPWR0_SH 0
#define B_AX_MACID_106_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE107 0xD508
#define R_AX_PWR_MACID_TABLE107_C1 0xF508
#define B_AX_MACID_107_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_107_TXPWR1_EN BIT(25)
#define B_AX_MACID_107_TXPWR0_EN BIT(24)
#define B_AX_MACID_107_CCA_PWR_TH_SH 16
#define B_AX_MACID_107_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_107_TXPWR1_SH 8
#define B_AX_MACID_107_TXPWR1_MSK 0xff
#define B_AX_MACID_107_TXPWR0_SH 0
#define B_AX_MACID_107_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE108 0xD50C
#define R_AX_PWR_MACID_TABLE108_C1 0xF50C
#define B_AX_MACID_108_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_108_TXPWR1_EN BIT(25)
#define B_AX_MACID_108_TXPWR0_EN BIT(24)
#define B_AX_MACID_108_CCA_PWR_TH_SH 16
#define B_AX_MACID_108_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_108_TXPWR1_SH 8
#define B_AX_MACID_108_TXPWR1_MSK 0xff
#define B_AX_MACID_108_TXPWR0_SH 0
#define B_AX_MACID_108_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE109 0xD510
#define R_AX_PWR_MACID_TABLE109_C1 0xF510
#define B_AX_MACID_109_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_109_TXPWR1_EN BIT(25)
#define B_AX_MACID_109_TXPWR0_EN BIT(24)
#define B_AX_MACID_109_CCA_PWR_TH_SH 16
#define B_AX_MACID_109_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_109_TXPWR1_SH 8
#define B_AX_MACID_109_TXPWR1_MSK 0xff
#define B_AX_MACID_109_TXPWR0_SH 0
#define B_AX_MACID_109_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE110 0xD514
#define R_AX_PWR_MACID_TABLE110_C1 0xF514
#define B_AX_MACID_110_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_110_TXPWR1_EN BIT(25)
#define B_AX_MACID_110_TXPWR0_EN BIT(24)
#define B_AX_MACID_110_CCA_PWR_TH_SH 16
#define B_AX_MACID_110_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_110_TXPWR1_SH 8
#define B_AX_MACID_110_TXPWR1_MSK 0xff
#define B_AX_MACID_110_TXPWR0_SH 0
#define B_AX_MACID_110_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE111 0xD518
#define R_AX_PWR_MACID_TABLE111_C1 0xF518
#define B_AX_MACID_111_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_111_TXPWR1_EN BIT(25)
#define B_AX_MACID_111_TXPWR0_EN BIT(24)
#define B_AX_MACID_111_CCA_PWR_TH_SH 16
#define B_AX_MACID_111_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_111_TXPWR1_SH 8
#define B_AX_MACID_111_TXPWR1_MSK 0xff
#define B_AX_MACID_111_TXPWR0_SH 0
#define B_AX_MACID_111_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE112 0xD51C
#define R_AX_PWR_MACID_TABLE112_C1 0xF51C
#define B_AX_MACID_112_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_112_TXPWR1_EN BIT(25)
#define B_AX_MACID_112_TXPWR0_EN BIT(24)
#define B_AX_MACID_112_CCA_PWR_TH_SH 16
#define B_AX_MACID_112_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_112_TXPWR1_SH 8
#define B_AX_MACID_112_TXPWR1_MSK 0xff
#define B_AX_MACID_112_TXPWR0_SH 0
#define B_AX_MACID_112_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE113 0xD520
#define R_AX_PWR_MACID_TABLE113_C1 0xF520
#define B_AX_MACID_113_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_113_TXPWR1_EN BIT(25)
#define B_AX_MACID_113_TXPWR0_EN BIT(24)
#define B_AX_MACID_113_CCA_PWR_TH_SH 16
#define B_AX_MACID_113_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_113_TXPWR1_SH 8
#define B_AX_MACID_113_TXPWR1_MSK 0xff
#define B_AX_MACID_113_TXPWR0_SH 0
#define B_AX_MACID_113_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE114 0xD524
#define R_AX_PWR_MACID_TABLE114_C1 0xF524
#define B_AX_MACID_114_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_114_TXPWR1_EN BIT(25)
#define B_AX_MACID_114_TXPWR0_EN BIT(24)
#define B_AX_MACID_114_CCA_PWR_TH_SH 16
#define B_AX_MACID_114_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_114_TXPWR1_SH 8
#define B_AX_MACID_114_TXPWR1_MSK 0xff
#define B_AX_MACID_114_TXPWR0_SH 0
#define B_AX_MACID_114_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE115 0xD528
#define R_AX_PWR_MACID_TABLE115_C1 0xF528
#define B_AX_MACID_115_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_115_TXPWR1_EN BIT(25)
#define B_AX_MACID_115_TXPWR0_EN BIT(24)
#define B_AX_MACID_115_CCA_PWR_TH_SH 16
#define B_AX_MACID_115_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_115_TXPWR1_SH 8
#define B_AX_MACID_115_TXPWR1_MSK 0xff
#define B_AX_MACID_115_TXPWR0_SH 0
#define B_AX_MACID_115_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE116 0xD52C
#define R_AX_PWR_MACID_TABLE116_C1 0xF52C
#define B_AX_MACID_116_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_116_TXPWR1_EN BIT(25)
#define B_AX_MACID_116_TXPWR0_EN BIT(24)
#define B_AX_MACID_116_CCA_PWR_TH_SH 16
#define B_AX_MACID_116_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_116_TXPWR1_SH 8
#define B_AX_MACID_116_TXPWR1_MSK 0xff
#define B_AX_MACID_116_TXPWR0_SH 0
#define B_AX_MACID_116_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE117 0xD530
#define R_AX_PWR_MACID_TABLE117_C1 0xF530
#define B_AX_MACID_117_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_117_TXPWR1_EN BIT(25)
#define B_AX_MACID_117_TXPWR0_EN BIT(24)
#define B_AX_MACID_117_CCA_PWR_TH_SH 16
#define B_AX_MACID_117_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_117_TXPWR1_SH 8
#define B_AX_MACID_117_TXPWR1_MSK 0xff
#define B_AX_MACID_117_TXPWR0_SH 0
#define B_AX_MACID_117_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE118 0xD534
#define R_AX_PWR_MACID_TABLE118_C1 0xF534
#define B_AX_MACID_118_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_118_TXPWR1_EN BIT(25)
#define B_AX_MACID_118_TXPWR0_EN BIT(24)
#define B_AX_MACID_118_CCA_PWR_TH_SH 16
#define B_AX_MACID_118_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_118_TXPWR1_SH 8
#define B_AX_MACID_118_TXPWR1_MSK 0xff
#define B_AX_MACID_118_TXPWR0_SH 0
#define B_AX_MACID_118_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE119 0xD538
#define R_AX_PWR_MACID_TABLE119_C1 0xF538
#define B_AX_MACID_119_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_119_TXPWR1_EN BIT(25)
#define B_AX_MACID_119_TXPWR0_EN BIT(24)
#define B_AX_MACID_119_CCA_PWR_TH_SH 16
#define B_AX_MACID_119_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_119_TXPWR1_SH 8
#define B_AX_MACID_119_TXPWR1_MSK 0xff
#define B_AX_MACID_119_TXPWR0_SH 0
#define B_AX_MACID_119_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE120 0xD53C
#define R_AX_PWR_MACID_TABLE120_C1 0xF53C
#define B_AX_MACID_120_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_120_TXPWR1_EN BIT(25)
#define B_AX_MACID_120_TXPWR0_EN BIT(24)
#define B_AX_MACID_120_CCA_PWR_TH_SH 16
#define B_AX_MACID_120_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_120_TXPWR1_SH 8
#define B_AX_MACID_120_TXPWR1_MSK 0xff
#define B_AX_MACID_120_TXPWR0_SH 0
#define B_AX_MACID_120_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE121 0xD540
#define R_AX_PWR_MACID_TABLE121_C1 0xF540
#define B_AX_MACID_121_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_121_TXPWR1_EN BIT(25)
#define B_AX_MACID_121_TXPWR0_EN BIT(24)
#define B_AX_MACID_121_CCA_PWR_TH_SH 16
#define B_AX_MACID_121_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_121_TXPWR1_SH 8
#define B_AX_MACID_121_TXPWR1_MSK 0xff
#define B_AX_MACID_121_TXPWR0_SH 0
#define B_AX_MACID_121_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE122 0xD544
#define R_AX_PWR_MACID_TABLE122_C1 0xF544
#define B_AX_MACID_122_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_122_TXPWR1_EN BIT(25)
#define B_AX_MACID_122_TXPWR0_EN BIT(24)
#define B_AX_MACID_122_CCA_PWR_TH_SH 16
#define B_AX_MACID_122_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_122_TXPWR1_SH 8
#define B_AX_MACID_122_TXPWR1_MSK 0xff
#define B_AX_MACID_122_TXPWR0_SH 0
#define B_AX_MACID_122_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE123 0xD548
#define R_AX_PWR_MACID_TABLE123_C1 0xF548
#define B_AX_MACID_123_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_123_TXPWR1_EN BIT(25)
#define B_AX_MACID_123_TXPWR0_EN BIT(24)
#define B_AX_MACID_123_CCA_PWR_TH_SH 16
#define B_AX_MACID_123_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_123_TXPWR1_SH 8
#define B_AX_MACID_123_TXPWR1_MSK 0xff
#define B_AX_MACID_123_TXPWR0_SH 0
#define B_AX_MACID_123_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE124 0xD54C
#define R_AX_PWR_MACID_TABLE124_C1 0xF54C
#define B_AX_MACID_124_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_124_TXPWR1_EN BIT(25)
#define B_AX_MACID_124_TXPWR0_EN BIT(24)
#define B_AX_MACID_124_CCA_PWR_TH_SH 16
#define B_AX_MACID_124_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_124_TXPWR1_SH 8
#define B_AX_MACID_124_TXPWR1_MSK 0xff
#define B_AX_MACID_124_TXPWR0_SH 0
#define B_AX_MACID_124_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE125 0xD550
#define R_AX_PWR_MACID_TABLE125_C1 0xF550
#define B_AX_MACID_125_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_125_TXPWR1_EN BIT(25)
#define B_AX_MACID_125_TXPWR0_EN BIT(24)
#define B_AX_MACID_125_CCA_PWR_TH_SH 16
#define B_AX_MACID_125_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_125_TXPWR1_SH 8
#define B_AX_MACID_125_TXPWR1_MSK 0xff
#define B_AX_MACID_125_TXPWR0_SH 0
#define B_AX_MACID_125_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE126 0xD554
#define R_AX_PWR_MACID_TABLE126_C1 0xF554
#define B_AX_MACID_126_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_126_TXPWR1_EN BIT(25)
#define B_AX_MACID_126_TXPWR0_EN BIT(24)
#define B_AX_MACID_126_CCA_PWR_TH_SH 16
#define B_AX_MACID_126_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_126_TXPWR1_SH 8
#define B_AX_MACID_126_TXPWR1_MSK 0xff
#define B_AX_MACID_126_TXPWR0_SH 0
#define B_AX_MACID_126_TXPWR0_MSK 0xff

#define R_AX_PWR_MACID_TABLE127 0xD558
#define R_AX_PWR_MACID_TABLE127_C1 0xF558
#define B_AX_MACID_127_CCA_PWR_TH_EN BIT(26)
#define B_AX_MACID_127_TXPWR1_EN BIT(25)
#define B_AX_MACID_127_TXPWR0_EN BIT(24)
#define B_AX_MACID_127_CCA_PWR_TH_SH 16
#define B_AX_MACID_127_CCA_PWR_TH_MSK 0xff
#define B_AX_MACID_127_TXPWR1_SH 8
#define B_AX_MACID_127_TXPWR1_MSK 0xff
#define B_AX_MACID_127_TXPWR0_SH 0
#define B_AX_MACID_127_TXPWR0_MSK 0xff

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE0 0xD55C
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE0_C1 0xF55C
#define B_AX_MCS0_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE1 0xD560
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE1_C1 0xF560
#define B_AX_MCS0_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE2 0xD564
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE2_C1 0xF564
#define B_AX_MCS0_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE3 0xD568
#define R_AX_PWR_SR_MCS0_TXDIFF_TABLE3_C1 0xF568
#define B_AX_MCS0_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS0_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS0_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS0_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS0_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS0_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS0_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE0 0xD56C
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE0_C1 0xF56C
#define B_AX_MCS1_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE1 0xD570
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE1_C1 0xF570
#define B_AX_MCS1_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE2 0xD574
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE2_C1 0xF574
#define B_AX_MCS1_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE3 0xD578
#define R_AX_PWR_SR_MCS1_TXDIFF_TABLE3_C1 0xF578
#define B_AX_MCS1_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS1_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS1_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS1_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS1_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS1_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS1_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE0 0xD57C
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE0_C1 0xF57C
#define B_AX_MCS2_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE1 0xD580
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE1_C1 0xF580
#define B_AX_MCS2_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE2 0xD584
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE2_C1 0xF584
#define B_AX_MCS2_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE3 0xD588
#define R_AX_PWR_SR_MCS2_TXDIFF_TABLE3_C1 0xF588
#define B_AX_MCS2_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS2_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS2_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS2_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS2_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS2_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS2_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE0 0xD58C
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE0_C1 0xF58C
#define B_AX_MCS3_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE1 0xD590
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE1_C1 0xF590
#define B_AX_MCS3_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE2 0xD594
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE2_C1 0xF594
#define B_AX_MCS3_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE3 0xD598
#define R_AX_PWR_SR_MCS3_TXDIFF_TABLE3_C1 0xF598
#define B_AX_MCS3_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS3_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS3_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS3_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS3_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS3_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS3_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE0 0xD59C
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE0_C1 0xF59C
#define B_AX_MCS4_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE1 0xD5A0
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE1_C1 0xF5A0
#define B_AX_MCS4_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE2 0xD5A4
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE2_C1 0xF5A4
#define B_AX_MCS4_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE3 0xD5A8
#define R_AX_PWR_SR_MCS4_TXDIFF_TABLE3_C1 0xF5A8
#define B_AX_MCS4_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS4_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS4_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS4_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS4_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS4_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS4_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE0 0xD5AC
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE0_C1 0xF5AC
#define B_AX_MCS5_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE1 0xD5B0
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE1_C1 0xF5B0
#define B_AX_MCS5_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE2 0xD5B4
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE2_C1 0xF5B4
#define B_AX_MCS5_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE3 0xD5B8
#define R_AX_PWR_SR_MCS5_TXDIFF_TABLE3_C1 0xF5B8
#define B_AX_MCS5_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS5_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS5_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS5_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS5_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS5_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS5_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE0 0xD5BC
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE0_C1 0xF5BC
#define B_AX_MCS6_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE1 0xD5C0
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE1_C1 0xF5C0
#define B_AX_MCS6_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE2 0xD5C4
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE2_C1 0xF5C4
#define B_AX_MCS6_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE3 0xD5C8
#define R_AX_PWR_SR_MCS6_TXDIFF_TABLE3_C1 0xF5C8
#define B_AX_MCS6_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS6_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS6_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS6_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS6_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS6_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS6_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE0 0xD5CC
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE0_C1 0xF5CC
#define B_AX_MCS7_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE1 0xD5D0
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE1_C1 0xF5D0
#define B_AX_MCS7_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE2 0xD5D4
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE2_C1 0xF5D4
#define B_AX_MCS7_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE3 0xD5D8
#define R_AX_PWR_SR_MCS7_TXDIFF_TABLE3_C1 0xF5D8
#define B_AX_MCS7_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS7_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS7_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS7_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS7_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS7_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS7_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE0 0xD5DC
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE0_C1 0xF5DC
#define B_AX_MCS8_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE1 0xD5E0
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE1_C1 0xF5E0
#define B_AX_MCS8_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE2 0xD5E4
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE2_C1 0xF5E4
#define B_AX_MCS8_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE3 0xD5E8
#define R_AX_PWR_SR_MCS8_TXDIFF_TABLE3_C1 0xF5E8
#define B_AX_MCS8_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS8_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS8_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS8_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS8_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS8_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS8_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE0 0xD5EC
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE0_C1 0xF5EC
#define B_AX_MCS9_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE1 0xD5F0
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE1_C1 0xF5F0
#define B_AX_MCS9_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE2 0xD5F4
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE2_C1 0xF5F4
#define B_AX_MCS9_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE3 0xD5F8
#define R_AX_PWR_SR_MCS9_TXDIFF_TABLE3_C1 0xF5F8
#define B_AX_MCS9_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS9_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS9_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS9_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS9_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS9_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS9_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE0 0xD5FC
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE0_C1 0xF5FC
#define B_AX_MCS10_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE1 0xD600
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE1_C1 0xF600
#define B_AX_MCS10_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE2 0xD604
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE2_C1 0xF604
#define B_AX_MCS10_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE3 0xD608
#define R_AX_PWR_SR_MCS10_TXDIFF_TABLE3_C1 0xF608
#define B_AX_MCS10_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS10_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS10_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS10_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS10_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS10_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS10_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE0 0xD60C
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE0_C1 0xF60C
#define B_AX_MCS11_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE1 0xD610
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE1_C1 0xF610
#define B_AX_MCS11_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE2 0xD614
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE2_C1 0xF614
#define B_AX_MCS11_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE3 0xD618
#define R_AX_PWR_SR_MCS11_TXDIFF_TABLE3_C1 0xF618
#define B_AX_MCS11_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_MCS11_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_MCS11_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_MCS11_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_MCS11_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_MCS11_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_MCS11_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE0 0xD61C
#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE0_C1 0xF61C
#define B_AX_CCK1M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE1 0xD620
#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE1_C1 0xF620
#define B_AX_CCK1M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE2 0xD624
#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE2_C1 0xF624
#define B_AX_CCK1M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE3 0xD628
#define R_AX_PWR_SR_CCK1M_TXDIFF_TABLE3_C1 0xF628
#define B_AX_CCK1M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_CCK1M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_CCK1M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_CCK1M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_CCK1M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK1M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_CCK1M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE0 0xD62C
#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE0_C1 0xF62C
#define B_AX_CCK2M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE1 0xD630
#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE1_C1 0xF630
#define B_AX_CCK2M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE2 0xD634
#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE2_C1 0xF634
#define B_AX_CCK2M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE3 0xD638
#define R_AX_PWR_SR_CCK2M_TXDIFF_TABLE3_C1 0xF638
#define B_AX_CCK2M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_CCK2M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_CCK2M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_CCK2M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_CCK2M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK2M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_CCK2M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE0 0xD63C
#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE0_C1 0xF63C
#define B_AX_CCK5P5M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE1 0xD640
#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE1_C1 0xF640
#define B_AX_CCK5P5M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE2 0xD644
#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE2_C1 0xF644
#define B_AX_CCK5P5M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE3 0xD648
#define R_AX_PWR_SR_CCK5P5M_TXDIFF_TABLE3_C1 0xF648
#define B_AX_CCK5P5M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_CCK5P5M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_CCK5P5M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_CCK5P5M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_CCK5P5M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK5P5M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_CCK5P5M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE0 0xD64C
#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE0_C1 0xF64C
#define B_AX_CCK11M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE1 0xD650
#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE1_C1 0xF650
#define B_AX_CCK11M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE2 0xD654
#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE2_C1 0xF654
#define B_AX_CCK11M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE3 0xD658
#define R_AX_PWR_SR_CCK11M_TXDIFF_TABLE3_C1 0xF658
#define B_AX_CCK11M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_CCK11M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_CCK11M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_CCK11M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_CCK11M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_CCK11M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_CCK11M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE0 0xD65C
#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE0_C1 0xF65C
#define B_AX_LEGACY6M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE1 0xD660
#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE1_C1 0xF660
#define B_AX_LEGACY6M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE2 0xD664
#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE2_C1 0xF664
#define B_AX_LEGACY6M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE3 0xD668
#define R_AX_PWR_SR_LEGACY6M_TXDIFF_TABLE3_C1 0xF668
#define B_AX_LEGACY6M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY6M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY6M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY6M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY6M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY6M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY6M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE0 0xD66C
#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE0_C1 0xF66C
#define B_AX_LEGACY9M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE1 0xD670
#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE1_C1 0xF670
#define B_AX_LEGACY9M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE2 0xD674
#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE2_C1 0xF674
#define B_AX_LEGACY9M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE3 0xD678
#define R_AX_PWR_SR_LEGACY9M_TXDIFF_TABLE3_C1 0xF678
#define B_AX_LEGACY9M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY9M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY9M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY9M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY9M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY9M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY9M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE0 0xD67C
#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE0_C1 0xF67C
#define B_AX_LEGACY12M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE1 0xD680
#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE1_C1 0xF680
#define B_AX_LEGACY12M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE2 0xD684
#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE2_C1 0xF684
#define B_AX_LEGACY12M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE3 0xD688
#define R_AX_PWR_SR_LEGACY12M_TXDIFF_TABLE3_C1 0xF688
#define B_AX_LEGACY12M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY12M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY12M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY12M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY12M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY12M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY12M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE0 0xD68C
#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE0_C1 0xF68C
#define B_AX_LEGACY18M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE1 0xD690
#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE1_C1 0xF690
#define B_AX_LEGACY18M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE2 0xD694
#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE2_C1 0xF694
#define B_AX_LEGACY18M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE3 0xD698
#define R_AX_PWR_SR_LEGACY18M_TXDIFF_TABLE3_C1 0xF698
#define B_AX_LEGACY18M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY18M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY18M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY18M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY18M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY18M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY18M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE0 0xD69C
#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE0_C1 0xF69C
#define B_AX_LEGACY24M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE1 0xD6A0
#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE1_C1 0xF6A0
#define B_AX_LEGACY24M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE2 0xD6A4
#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE2_C1 0xF6A4
#define B_AX_LEGACY24M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE3 0xD6A8
#define R_AX_PWR_SR_LEGACY24M_TXDIFF_TABLE3_C1 0xF6A8
#define B_AX_LEGACY24M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY24M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY24M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY24M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY24M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY24M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY24M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE0 0xD6AC
#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE0_C1 0xF6AC
#define B_AX_LEGACY36M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE1 0xD6B0
#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE1_C1 0xF6B0
#define B_AX_LEGACY36M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE2 0xD6B4
#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE2_C1 0xF6B4
#define B_AX_LEGACY36M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE3 0xD6B8
#define R_AX_PWR_SR_LEGACY36M_TXDIFF_TABLE3_C1 0xF6B8
#define B_AX_LEGACY36M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY36M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY36M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY36M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY36M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY36M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY36M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE0 0xD6BC
#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE0_C1 0xF6BC
#define B_AX_LEGACY48M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE1 0xD6C0
#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE1_C1 0xF6C0
#define B_AX_LEGACY48M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE2 0xD6C4
#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE2_C1 0xF6C4
#define B_AX_LEGACY48M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE3 0xD6C8
#define R_AX_PWR_SR_LEGACY48M_TXDIFF_TABLE3_C1 0xF6C8
#define B_AX_LEGACY48M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY48M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY48M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY48M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY48M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY48M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY48M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE0 0xD6CC
#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE0_C1 0xF6CC
#define B_AX_LEGACY54M_TXDIFF_5DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_5DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_4DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_4DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_3DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_3DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_2DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_2DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_1DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_1DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE1 0xD6D0
#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE1_C1 0xF6D0
#define B_AX_LEGACY54M_TXDIFF_10DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_10DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_9DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_9DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_8DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_8DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_7DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_7DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_6DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_6DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE2 0xD6D4
#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE2_C1 0xF6D4
#define B_AX_LEGACY54M_TXDIFF_15DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_15DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_14DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_14DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_13DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_13DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_12DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_12DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_11DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_11DB_MCS_OFFSET_MSK 0xf

#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE3 0xD6D8
#define R_AX_PWR_SR_LEGACY54M_TXDIFF_TABLE3_C1 0xF6D8
#define B_AX_LEGACY54M_TXDIFF_20DB_MCS_OFFSET_SH 16
#define B_AX_LEGACY54M_TXDIFF_20DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_19DB_MCS_OFFSET_SH 12
#define B_AX_LEGACY54M_TXDIFF_19DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_18DB_MCS_OFFSET_SH 8
#define B_AX_LEGACY54M_TXDIFF_18DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_17DB_MCS_OFFSET_SH 4
#define B_AX_LEGACY54M_TXDIFF_17DB_MCS_OFFSET_MSK 0xf
#define B_AX_LEGACY54M_TXDIFF_16DB_MCS_OFFSET_SH 0
#define B_AX_LEGACY54M_TXDIFF_16DB_MCS_OFFSET_MSK 0xf

#define R_AX_TXPWR_IMR 0xD9E0
#define R_AX_TXPWR_IMR_C1 0xF9E0
#define B_AX_TXPWR_FSM_TIMEOUT_INT_EN BIT(0)

#define R_AX_TXPWR_ISR 0xD9E4
#define R_AX_TXPWR_ISR_C1 0xF9E4
#define B_AX_TXPWR_FSM_TIMEOUT_ISR BIT(0)

#define R_AX_TXPWR_DBG_CFG 0xD9F8
#define R_AX_TXPWR_DBG_CFG_C1 0xF9F8
#define B_AX_TXPWR_DBG_SEL_SH 24
#define B_AX_TXPWR_DBG_SEL_MSK 0xff
#define B_AX_TXPWR_DBG_EN BIT(17)
#define B_AX_TXPWR_CLK_GATING_DIS BIT(16)
#define B_AX_TXPWR_TB_NTX BIT(8)

#define R_AX_TXPWR_DBG 0xD9FC
#define R_AX_TXPWR_DBG_C1 0xF9FC
#define B_AX_TXPWR_CTRL_DBG_SH 0
#define B_AX_TXPWR_CTRL_DBG_MSK 0xffffffffL

//
// BTCOEX
//

#define R_AX_BTC_CFG 0xDA00
#define R_AX_BTC_CFG_C1 0xFA00
#define B_AX_DIS_BTC_CLK_G BIT(2)
#define B_AX_GNT_WL_RX_CTRL BIT(1)
#define B_AX_WL_SRC BIT(0)

#define R_AX_WL_PRI_MSK 0xDA10
#define R_AX_WL_PRI_MSK_C1 0xFA10
#define B_AX_PTA_WL_PRI_MASK_BCNQ BIT(8)
#define B_AX_PTA_WL_PRI_MASK_HIQ BIT(7)
#define B_AX_PTA_WL_PRI_MASK_CPUMGQ BIT(6)
#define B_AX_PTA_WL_PRI_MASK_PSMGQ BIT(5)
#define B_AX_PTA_WL_PRI_MASK_MGQ BIT(4)
#define B_AX_PTA_WL_PRI_MASK_BK BIT(3)
#define B_AX_PTA_WL_PRI_MASK_BE BIT(2)
#define B_AX_PTA_WL_PRI_MASK_VI BIT(1)
#define B_AX_PTA_WL_PRI_MASK_VO BIT(0)

#define R_AX_BTC_FUNC_EN 0xDA20
#define R_AX_BTC_FUNC_EN_C1 0xFA20
#define B_AX_PTA_EDCCA_EN BIT(1)
#define B_AX_PTA_WL_TX_EN BIT(0)

#define R_AX_COEX_TABLE_1 0xDA24
#define R_AX_COEX_TABLE_1_C1 0xFA24
#define B_AX_COEX_TABLE_1_SH 0
#define B_AX_COEX_TABLE_1_MSK 0xffffffffL

#define R_AX_COEX_TABLE_2 0xDA28
#define R_AX_COEX_TABLE_2_C1 0xFA28
#define B_AX_COEX_TABLE_2_SH 0
#define B_AX_COEX_TABLE_2_MSK 0xffffffffL

#define R_AX_BREAK_TABLE 0xDA2C
#define R_AX_BREAK_TABLE_C1 0xFA2C
#define B_AX_COEX_BREAK_TABLE_2_SH 16
#define B_AX_COEX_BREAK_TABLE_2_MSK 0xffff
#define B_AX_COEX_BREAK_TABLE_1_SH 0
#define B_AX_COEX_BREAK_TABLE_1_MSK 0xffff

#define R_AX_BT_COEX_MSK_TABLE 0xDA30
#define R_AX_BT_COEX_MSK_TABLE_C1 0xFA30
#define B_AX_PRI_MASK_RX_RESP_V1 BIT(30)
#define B_AX_PRI_MASK_RXOFDM_V1 BIT(29)
#define B_AX_PRI_MASK_RXCCK_V1 BIT(28)
#define B_AX_PRI_MASK_TXAC_SH 21
#define B_AX_PRI_MASK_TXAC_MSK 0x7f
#define B_AX_PRI_MASK_NAV_SH 13
#define B_AX_PRI_MASK_NAV_MSK 0xff
#define B_AX_PRI_MASK_CCK_V1 BIT(12)
#define B_AX_PRI_MASK_OFDM_V1 BIT(11)
#define B_AX_PRI_MASK_RTY_V1 BIT(10)
#define B_AX_PRI_MASK_NUM_SH 6
#define B_AX_PRI_MASK_NUM_MSK 0xf
#define B_AX_PRI_MASK_TYPE_SH 2
#define B_AX_PRI_MASK_TYPE_MSK 0xf
#define B_AX_OOB_V1 BIT(1)
#define B_AX_ANT_SEL_V1 BIT(0)

#define R_AX_BT_COEX_CFG_2 0xDA34
#define R_AX_BT_COEX_CFG_2_C1 0xFA34
#define B_AX_GNT_BT_POLARITY BIT(12)
#define B_AX_GNT_BT_BYPASS_PRIORITY BIT(8)
#define B_AX_TIMER_SH 0
#define B_AX_TIMER_MSK 0xff

#define R_AX_BT_COEX_CFG_3 0xDA38
#define R_AX_BT_COEX_CFG_3_C1 0xFA38
#define B_AX_R_BT_CNT_THREN BIT(8)
#define B_AX_R_BT_CNT_THR_SH 0
#define B_AX_R_BT_CNT_THR_MSK 0xff

#define R_AX_BT_COEX_CFG_4 0xDA3C
#define R_AX_BT_COEX_CFG_4_C1 0xFA3C
#define B_AX_ANT_DIVERSITY_SEL_1 BIT(9)
#define B_AX_ANTSEL_FOR_BT_CTRL_EN_1 BIT(8)
#define B_AX_WLACT_LOW_GNTWL_EN_1 BIT(2)
#define B_AX_WLACT_HIGH_GNTBT_EN_1 BIT(1)
#define B_AX_NAV_UPPER_1_V1 BIT(0)

#define R_AX_CSR_MODE 0xDA40
#define R_AX_CSR_MODE_C1 0xFA40
#define B_AX_BT_CNT_REST BIT(16)
#define B_AX_BT_STAT_DELAY_SH 12
#define B_AX_BT_STAT_DELAY_MSK 0xf
#define B_AX_BT_TRX_INIT_DETECT_SH 8
#define B_AX_BT_TRX_INIT_DETECT_MSK 0xf
#define B_AX_BT_PRI_DETECT_TO_SH 4
#define B_AX_BT_PRI_DETECT_TO_MSK 0xf
#define B_AX_WL_ACT_MSK BIT(3)
#define B_AX_STATIS_BT_EN BIT(2)
#define B_AX_WL_ACT_MASK_ENABLE BIT(1)
#define B_AX_ENHANCED_BT BIT(0)

#define R_AX_BT_STAST_HIGH 0xDA44
#define R_AX_BT_STAST_HIGH_C1 0xFA44
#define B_AX_STATIS_BT_HI_RX_SH 16
#define B_AX_STATIS_BT_HI_RX_MSK 0xffff
#define B_AX_STATIS_BT_HI_TX_SH 0
#define B_AX_STATIS_BT_HI_TX_MSK 0xffff

#define R_AX_GNT_SW_CTRL 0xDA48
#define R_AX_BT_STAST_LOW 0xDA48
#define R_AX_BT_STAST_LOW_C1 0xFA48
#define B_AX_STATIS_BT_LO_RX_1_SH 16
#define B_AX_STATIS_BT_LO_RX_1_MSK 0xffff
#define B_AX_STATIS_BT_LO_TX_1_SH 0
#define B_AX_STATIS_BT_LO_TX_1_MSK 0xffff

#define R_AX_TDMA_MODE 0xDA4C
#define R_AX_TDMA_MODE_C1 0xFA4C
#define B_AX_R_BT_CMD_RPT_SH 16
#define B_AX_R_BT_CMD_RPT_MSK 0xffff
#define B_AX_R_RPT_FROM_BT_SH 8
#define B_AX_R_RPT_FROM_BT_MSK 0xff
#define B_AX_BT_HID_ISR_SET_SH 6
#define B_AX_BT_HID_ISR_SET_MSK 0x3
#define B_AX_TDMA_BT_START_NOTIFY BIT(5)
#define B_AX_ENABLE_TDMA_FW_MODE BIT(4)
#define B_AX_ENABLE_PTA_TDMA_MODE BIT(3)
#define B_AX_ENABLE_COEXIST_TAB_IN_TDMA BIT(2)
#define B_AX_GPIO2_GPIO3_EXANGE_OR_NO_BT_CCA BIT(1)
#define B_AX_RTK_BT_ENABLE BIT(0)

#define R_AX_RTK_MODE_RPT 0xDA50
#define R_AX_RTK_MODE_RPT_C1 0xFA50
#define B_AX_BT_PROFILE_SH 24
#define B_AX_BT_PROFILE_MSK 0xff
#define B_AX_BT_POWER_SH 16
#define B_AX_BT_POWER_MSK 0xff
#define B_AX_BT_PREDECT_STATUS_SH 8
#define B_AX_BT_PREDECT_STATUS_MSK 0xff
#define B_AX_BT_CMD_INFO_SH 0
#define B_AX_BT_CMD_INFO_MSK 0xff

#define R_AX_RTK_MODE_CFG 0xDA54
#define R_AX_RTK_MODE_CFG_C1 0xFA54
#define B_AX_EN_MAC_NULL_PKT_NOTIFY BIT(31)
#define B_AX_EN_WLAN_RPT_AND_BT_QUERY BIT(30)
#define B_AX_EN_BT_STSTUS_RPT BIT(29)
#define B_AX_EN_BT_POWER BIT(28)
#define B_AX_EN_BT_CHANNEL BIT(27)
#define B_AX_EN_BT_SLOT_CHANGE BIT(26)
#define B_AX_EN_BT_PROFILE_OR_HID BIT(25)
#define B_AX_WLAN_RPT_NOTIFY BIT(24)
#define B_AX_WLAN_RPT_DATA_SH 16
#define B_AX_WLAN_RPT_DATA_MSK 0xff
#define B_AX_CMD_ID_SH 8
#define B_AX_CMD_ID_MSK 0xff
#define B_AX_BT_DATA_SH 0
#define B_AX_BT_DATA_MSK 0xff

#define R_AX_RTK_MODE_TO 0xDA58
#define R_AX_RTK_MODE_TO_C1 0xFA58
#define B_AX_WLAN_RPT_TO_SH 0
#define B_AX_WLAN_RPT_TO_MSK 0xff

#define R_AX_BT_COEX_ISO 0xDA5C
#define R_AX_BT_COEX_ISO_C1 0xFA5C
#define B_AX_ISOLATION_CHK_0_SH 1
#define B_AX_ISOLATION_CHK_0_MSK 0x7fffff
#define B_AX_ISOLATION_EN BIT(0)

#define R_AX_BT_COEX_ISO_CHK_1 0xDA60
#define R_AX_BT_COEX_ISO_CHK_1_C1 0xFA60
#define B_AX_ISOLATION_CHK_1_SH 0
#define B_AX_ISOLATION_CHK_1_MSK 0xffffffffL

#define R_AX_BT_COEX_ISO_CHK_2 0xDA64
#define R_AX_BT_COEX_ISO_CHK_2_C1 0xFA64
#define B_AX_BT_HID_ISR BIT(31)
#define B_AX_BT_QUERY_ISR BIT(30)
#define B_AX_MAC_NULL_PKT_NOTIFY_ISR BIT(29)
#define B_AX_WLAN_RPT_ISR BIT(28)
#define B_AX_BT_POWER_ISR BIT(27)
#define B_AX_BT_CHANNEL_ISR BIT(26)
#define B_AX_BT_SLOT_CHANGE_ISR BIT(25)
#define B_AX_BT_PROFILE_ISR BIT(24)
#define B_AX_ISOLATION_CHK_2_SH 0
#define B_AX_ISOLATION_CHK_2_MSK 0xffffff

#define R_AX_BT_COEX_CFG_5 0xDA6C
#define R_AX_BT_COEX_CFG_5_C1 0xFA6C
#define B_AX_BT_TIME_SH 6
#define B_AX_BT_TIME_MSK 0x3ffffff
#define B_AX_BT_RPT_SAMPLE_RATE_SH 0
#define B_AX_BT_RPT_SAMPLE_RATE_MSK 0x3f

#define R_AX_BT_ACT_CFG 0xDA70
#define R_AX_BT_ACT_CFG_C1 0xFA70
#define B_AX_BT_EISR_EN_SH 16
#define B_AX_BT_EISR_EN_MSK 0xff
#define B_AX_BT_ACT_FALLING_ISR BIT(10)
#define B_AX_BT_ACT_RISING_ISR BIT(9)
#define B_AX_TDMA_TO_ISR BIT(8)
#define B_AX_BT_CH_SH 0
#define B_AX_BT_CH_MSK 0x7f

#define R_AX_BT_TIME_CNT 0xDA74
#define R_AX_BT_TIME_CNT_C1 0xFA74
#define B_AX_BT_TIME_CNT_SH 0
#define B_AX_BT_TIME_CNT_MSK 0xff

#define R_AX_WLACT_MASK_CTRL 0xDA7C
#define R_AX_WLACT_MASK_CTRL_C1 0xFA7C
#define B_AX_RX_RTS_NAV_SH 8
#define B_AX_RX_RTS_NAV_MSK 0xff
#define B_AX_RESET_RTS_SH 0
#define B_AX_RESET_RTS_MSK 0xff

#define R_AX_LTE_CTRL 0xDAF0
#define R_AX_LTE_CTRL_C1 0xFAF0
#define B_AX_LTE_SET BIT(31)
#define B_AX_LTE_RW BIT(30)
#define B_AX_LTE_RDY BIT(29)
#define B_AX_LTE_BYTE_EN_SH 16
#define B_AX_LTE_BYTE_EN_MSK 0xf
#define B_AX_LTE_ADDR_SH 0
#define B_AX_LTE_ADDR_MSK 0xffff

#define R_AX_LTE_WDATA 0xDAF4
#define R_AX_LTE_WDATA_C1 0xFAF4
#define B_AX_LTE_WDATA_SH 0
#define B_AX_LTE_WDATA_MSK 0xffffffffL

#define R_AX_LTE_RDATA 0xDAF8
#define R_AX_LTE_RDATA_C1 0xFAF8
#define B_AX_LTE_RDATA_SH 0
#define B_AX_LTE_RDATA_MSK 0xffffffffL

//
// LTECOEX
//

#define R_AX_LTE_SW_CFG_1 0x0038
#define R_AX_LTE_SW_CFG_1_C1 0x2038
#define B_AX_GNT_BT_RFC_S1_SW_VAL BIT(31)
#define B_AX_GNT_BT_RFC_S1_SW_CTRL BIT(30)
#define B_AX_GNT_WL_RFC_S1_SW_VAL BIT(29)
#define B_AX_GNT_WL_RFC_S1_SW_CTRL BIT(28)
#define B_AX_GNT_BT_BB_S1_SW_VAL BIT(27)
#define B_AX_GNT_BT_BB_S1_SW_CTRL BIT(26)
#define B_AX_GNT_WL_BB_S1_SW_VAL BIT(25)
#define B_AX_GNT_WL_BB_S1_SW_CTRL BIT(24)
#define B_AX_BT_SW_CTRL_WL_PRIORITY BIT(19)
#define B_AX_WL_SW_CTRL_WL_PRIORITY BIT(18)
#define B_AX_LTE_PATTERN_2_EN BIT(17)
#define B_AX_LTE_PATTERN_1_EN BIT(16)
#define B_AX_GNT_BT_RFC_S0_SW_VAL BIT(15)
#define B_AX_GNT_BT_RFC_S0_SW_CTRL BIT(14)
#define B_AX_GNT_WL_RFC_S0_SW_VAL BIT(13)
#define B_AX_GNT_WL_RFC_S0_SW_CTRL BIT(12)
#define B_AX_GNT_BT_BB_S0_SW_VAL BIT(11)
#define B_AX_GNT_BT_BB_S0_SW_CTRL BIT(10)
#define B_AX_GNT_WL_BB_S0_SW_VAL BIT(9)
#define B_AX_GNT_WL_BB_S0_SW_CTRL BIT(8)
#define B_AX_LTECOEX_FUN_EN BIT(7)
#define B_AX_LTECOEX_3WIRE_CTRL_MUX BIT(6)
#define B_AX_LTECOEX_OP_MODE_SEL_SH 4
#define B_AX_LTECOEX_OP_MODE_SEL_MSK 0x3
#define B_AX_LTECOEX_UART_MUX BIT(3)
#define B_AX_LTECOEX_UART_MODE_SEL_SH 0
#define B_AX_LTECOEX_UART_MODE_SEL_MSK 0x7

#define R_AX_LTE_SW_CFG_2 0x003C
#define R_AX_LTE_SW_CFG_2_C1 0x203C
#define B_AX_WL_RX_CTRL BIT(8)
#define B_AX_GNT_WL_RX_SW_VAL BIT(7)
#define B_AX_GNT_WL_RX_SW_CTRL BIT(6)
#define B_AX_GNT_WL_TX_SW_VAL BIT(5)
#define B_AX_GNT_WL_TX_SW_CTRL BIT(4)
#define B_AX_GNT_BT_RX_SW_VAL BIT(3)
#define B_AX_GNT_BT_RX_SW_CTRL BIT(2)
#define B_AX_GNT_BT_TX_SW_VAL BIT(1)
#define B_AX_GNT_BT_TX_SW_CTRL BIT(0)

//
// WL_AX_Reg_HIOE.xls
//

//
// HIOE_Reg_Spec
//

#define R_PL_HIOE_CTRL 0x0000
#define B_PL_HIOE_RESTORE_REQ BIT(31)
#define B_PL_HIOE_RETAIN_REQ BIT(30)
#define B_PL_HIOE_DDMA_CH1_REQ BIT(29)
#define B_PL_HIOE_DDMA_CH2_REQ BIT(28)
#define B_PL_HIOE_DDMA_CH1_CHKSUM_STATUS BIT(27)
#define B_PL_HIOE_DDMA_CH2_CHKSUM_STATUS BIT(26)
#define B_PL_HIOE_INST_FORMAT_ERR BIT(25)
#define B_PL_HIOE_OP_TIMEOUT_ERR BIT(24)
#define B_PL_HIOE_OP_TIMEOUT_SH 16
#define B_PL_HIOE_OP_TIMEOUT_MSK 0xff
#define B_PL_HIOE_ADDR_CHECKSUM_SH 0
#define B_PL_HIOE_ADDR_CHECKSUM_MSK 0xffff

#define R_PL_HIOE_CFG_FILE_START 0x0004
#define B_PL_HIOE_CFG_FILE_START_SH 0
#define B_PL_HIOE_CFG_FILE_START_MSK 0xffffffffL

#define R_PL_HIOE_CFG_FILE_END 0x0008
#define B_PL_HIOE_CFG_FILE_END_SH 0
#define B_PL_HIOE_CFG_FILE_END_MSK 0xffffffffL

#define R_PL_HIOE_CUR_INST_ADDR 0x000C
#define B_PL_HIOE_CUR_INST_ADDR_SH 0
#define B_PL_HIOE_CUR_INST_ADDR_MSK 0xffffffffL

//
// WL_AX_Reg_IDDMA.xls
//

//
// IDDMA_Reg_Spec
//

#define R_PL_IDDMA_CH0_SA 0x0000
#define B_PL_IDDMA_CH0_SA_SH 0
#define B_PL_IDDMA_CH0_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH0_DA 0x0004
#define B_PL_IDDMA_CH0_DA_SH 0
#define B_PL_IDDMA_CH0_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH0_CTRL 0x0008
#define B_PL_IDDMA_CH0_OWN BIT(31)
#define B_PL_IDDMA_CH0_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH0_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH0_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH0_CHKSUM_CONT BIT(24)
#define B_PL_IDDMA_CH0_DLEN_SH 0
#define B_PL_IDDMA_CH0_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH1_SA 0x0010
#define B_PL_IDDMA_CH1_SA_SH 0
#define B_PL_IDDMA_CH1_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH1_DA 0x0014
#define B_PL_IDDMA_CH1_DA_SH 0
#define B_PL_IDDMA_CH1_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH1_CTRL 0x0018
#define B_PL_IDDMA_CH1_OWN BIT(31)
#define B_PL_IDDMA_CH1_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH1_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH1_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH1_DLEN_SH 0
#define B_PL_IDDMA_CH1_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH2_SA 0x0020
#define B_PL_IDDMA_CH2_SA_SH 0
#define B_PL_IDDMA_CH2_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH2_DA 0x0024
#define B_PL_IDDMA_CH2_DA_SH 0
#define B_PL_IDDMA_CH2_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH2_CTRL 0x0028
#define B_PL_IDDMA_CH2_OWN BIT(31)
#define B_PL_IDDMA_CH2_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH2_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH2_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH2_DLEN_SH 0
#define B_PL_IDDMA_CH2_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH3_SA 0x0030
#define B_PL_IDDMA_CH3_SA_SH 0
#define B_PL_IDDMA_CH3_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH3_DA 0x0034
#define B_PL_IDDMA_CH3_DA_SH 0
#define B_PL_IDDMA_CH3_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH3_CTRL 0x0038
#define B_PL_IDDMA_CH3_OWN BIT(31)
#define B_PL_IDDMA_CH3_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH3_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH3_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH3_DLEN_SH 0
#define B_PL_IDDMA_CH3_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH4_SA 0x0040
#define B_PL_IDDMA_CH4_SA_SH 0
#define B_PL_IDDMA_CH4_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH4_DA 0x0044
#define B_PL_IDDMA_CH4_DA_SH 0
#define B_PL_IDDMA_CH4_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH4_CTRL 0x0048
#define B_PL_IDDMA_CH4_OWN BIT(31)
#define B_PL_IDDMA_CH4_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH4_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH4_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH4_DLEN_SH 0
#define B_PL_IDDMA_CH4_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_CH5_SA 0x0050
#define B_PL_IDDMA_CH5_SA_SH 0
#define B_PL_IDDMA_CH5_SA_MSK 0xffffffffL

#define R_PL_IDDMA_CH5_DA 0x0054
#define B_PL_IDDMA_CH5_DA_SH 0
#define B_PL_IDDMA_CH5_DA_MSK 0xffffffffL

#define R_PL_IDDMA_CH5_CTRL 0x0058
#define B_PL_IDDMA_CH5_OWN BIT(31)
#define B_PL_IDDMA_CH5_CHKSUM_EN BIT(29)
#define B_PL_IDDMA_CH5_DA_W_DISABLE BIT(28)
#define B_PL_IDDMA_CH5_CHKSUM_STATUS BIT(27)
#define B_PL_IDDMA_CH5_DLEN_SH 0
#define B_PL_IDDMA_CH5_DLEN_MSK 0x3ffff

#define R_PL_IDDMA_FWIMR 0x00E0
#define B_PL_IDDMA_CH5_INT_MSK BIT(5)
#define B_PL_IDDMA_CH4_INT_MSK BIT(4)
#define B_PL_IDDMA_CH3_INT_MSK BIT(3)
#define B_PL_IDDMA_CH2_INT_MSK BIT(2)
#define B_PL_IDDMA_CH1_INT_MSK BIT(1)
#define B_PL_IDDMA_CH0_INT_MSK BIT(0)

#define R_PL_IDDMA_FWISR 0x00E4
#define B_PL_IDDMA_CH5_INT BIT(5)
#define B_PL_IDDMA_CH4_INT BIT(4)
#define B_PL_IDDMA_CH3_INT BIT(3)
#define B_PL_IDDMA_CH2_INT BIT(2)
#define B_PL_IDDMA_CH1_INT BIT(1)
#define B_PL_IDDMA_CH0_INT BIT(0)

#define R_PL_IDDMA_CH_STATUS 0x00E8
#define B_PL_IDDMA_CH5_BUSY BIT(5)
#define B_PL_IDDMA_CH4_BUSY BIT(4)
#define B_PL_IDDMA_CH3_BUSY BIT(3)
#define B_PL_IDDMA_CH2_BUSY BIT(2)
#define B_PL_IDDMA_CH1_BUSY BIT(1)
#define B_PL_IDDMA_CH0_BUSY BIT(0)

#define R_PL_IDDMA_CHKSUM_CONTROL 0x00EC
#define B_PL_IDDMA_CHKSUM_RESET BIT(0)

#define R_PL_IDDMA_CHKSUM 0x00F0
#define B_PL_IDDMA_CHKSUM_RESULT_SH 0
#define B_PL_IDDMA_CHKSUM_RESULT_MSK 0xffff

#define R_PL_IDDMA_MONITOR 0x00FC
#define B_PL_IDDMA_CH5_DOK BIT(21)
#define B_PL_IDDMA_CH4_DOK BIT(20)
#define B_PL_IDDMA_CH3_DOK BIT(19)
#define B_PL_IDDMA_CH2_DOK BIT(18)
#define B_PL_IDDMA_CH1_DOK BIT(17)
#define B_PL_IDDMA_CH0_DOK BIT(16)
#define B_PL_IDDMA_DATA_UNDERFLOW BIT(14)
#define B_PL_IDDMA_FIFO_UNDERFLOW BIT(13)
#define B_PL_IDDMA_FIFO_OVERFLOW BIT(12)
#define B_PL_IDDMA_CH5_ERROR BIT(5)
#define B_PL_IDDMA_CH4_ERROR BIT(4)
#define B_PL_IDDMA_CH3_ERROR BIT(3)
#define B_PL_IDDMA_CH2_ERROR BIT(2)
#define B_PL_IDDMA_CH1_ERROR BIT(1)
#define B_PL_IDDMA_CH0_ERROR BIT(0)

//
// WL_AX_Reg_IPSec.xls
//

//
// IPSec_Reg
//

#define R_PL_REG_SDSR 0x0000
#define B_PL_SRC_RST BIT(31)
#define B_PL_PK_UP BIT(30)
#define B_PL_SRC_FAIL_STATUS_SH 25
#define B_PL_SRC_FAIL_STATUS_MSK 0x3
#define B_PL_SRC_FAIL BIT(24)
#define B_PL_SRPTR_SH 16
#define B_PL_SRPTR_MSK 0xff
#define B_PL_SWPTR_SH 8
#define B_PL_SWPTR_MSK 0xff
#define B_PL_FIFO_EMPTY_CNT_SH 0
#define B_PL_FIFO_EMPTY_CNT_MSK 0xff

#define R_PL_REG_SDFWR 0x0004
#define B_PL_SDFW_SH 0
#define B_PL_SDFW_MSK 0xffffffffL

#define R_PL_REG_SDSWR 0x0008
#define B_PL_SDSW_SH 0
#define B_PL_SDSW_MSK 0xffffffffL

#define R_PL_REG_IPSCSR_RSTEACONFISR 0x0010
#define B_PL_IPSEC_RST BIT(31)
#define B_PL_CLEAR_OK_INT_NUM_SH 16
#define B_PL_CLEAR_OK_INT_NUM_MSK 0xff
#define B_PL_OK_INTR_CNT_SH 8
#define B_PL_OK_INTR_CNT_MSK 0xff
#define B_PL_INTR_MODE BIT(7)
#define B_PL_CMD_OK BIT(4)
#define B_PL_DMA_BUSY BIT(3)
#define B_PL_SOFT_RST BIT(0)

#define R_PL_REG_IPSCSR_INTM 0x0014
#define B_PL_DES_ERR5_M BIT(18)
#define B_PL_DES_ERR4_M BIT(17)
#define B_PL_DES_ERR3_M BIT(16)
#define B_PL_DES_ERR2_M BIT(15)
#define B_PL_DES_ERR1_M BIT(14)
#define B_PL_DES_ERR0_M BIT(13)
#define B_PL_SRC_ERR9_M BIT(12)
#define B_PL_SRC_ERR8_M BIT(11)
#define B_PL_SRC_ERR7_M BIT(10)
#define B_PL_SRC_ERR6_M BIT(9)
#define B_PL_SRC_ERR5_M BIT(8)
#define B_PL_SRC_ERR4_M BIT(7)
#define B_PL_SRC_ERR3_M BIT(6)
#define B_PL_SRC_ERR2_M BIT(5)
#define B_PL_SRC_ERR1_M BIT(4)
#define B_PL_SRC_ERR0_M BIT(3)
#define B_PL_DES_FAIL_M BIT(2)
#define B_PL_SRC_FAIL_M BIT(1)
#define B_PL_CMD_OK_M BIT(0)

#define R_PL_REG_IPSCSR_DBG 0x0018
#define B_PL_DEBUG_WB BIT(31)
#define B_PL_MST_BAD_SEL_SH 28
#define B_PL_MST_BAD_SEL_MSK 0x3
#define B_PL_ENGINE_CLK_EN BIT(24)
#define B_PL_DEBUG_PORT_SEL_SH 20
#define B_PL_DEBUG_PORT_SEL_MSK 0xf
#define B_PL_ARBITER_MODE BIT(16)
#define B_PL_DMA_WAIT_CYCLE_SH 0
#define B_PL_DMA_WAIT_CYCLE_MSK 0xffff

#define R_PL_REG_IPSCSR_ERR_INT 0x001C
#define B_PL_DES_ERR5 BIT(15)
#define B_PL_DES_ERR4 BIT(14)
#define B_PL_DES_ERR3 BIT(13)
#define B_PL_DES_ERR2 BIT(12)
#define B_PL_DES_ERR1 BIT(11)
#define B_PL_DES_ERR0 BIT(10)
#define B_PL_SRC_ERR9 BIT(9)
#define B_PL_SRC_ERR8 BIT(8)
#define B_PL_SRC_ERR7 BIT(7)
#define B_PL_SRC_ERR6 BIT(6)
#define B_PL_SRC_ERR5 BIT(5)
#define B_PL_SRC_ERR4 BIT(4)
#define B_PL_SRC_ERR3 BIT(3)
#define B_PL_SRC_ERR2 BIT(2)
#define B_PL_SRC_ERR1 BIT(1)
#define B_PL_SRC_ERR0 BIT(0)

#define R_PL_REG_IPSCSR_SAADLR 0x0020
#define B_PL_A2EO_SUM_SH 0
#define B_PL_A2EO_SUM_MSK 0x7ff

#define R_PL_REG_IPSCSR_SENLR 0x0024
#define B_PL_ENL_SUM_SH 0
#define B_PL_ENL_SUM_MSK 0xffffff

#define R_PL_REG_IPSCSR_SAPLR 0x0028
#define B_PL_APL_SUM_SH 0
#define B_PL_APL_SUM_MSK 0xfff

#define R_PL_REG_IPSCSR_SEPLR 0x002C
#define B_PL_EPL_SUM_SH 0
#define B_PL_EPL_SUM_MSK 0x3f

#define R_PL_REG_IPSCSR_SWAPABURSTR 0x0030
#define B_PL_MD5_INPUT_DATA_BYTE_SWAP BIT(25)
#define B_PL_MD5_OUTPUT_DATA_BYTE_SWAP BIT(24)
#define B_PL_DMA_BURST_LENGTH_SH 16
#define B_PL_DMA_BURST_LENGTH_MSK 0x3f
#define B_PL_AUTO_PADDING_SWAP BIT(13)
#define B_PL_TX_WD_SWAP BIT(12)
#define B_PL_RX_WD_SWAP BIT(11)
#define B_PL_MAC_OUT_LITTLE_ENDIAN BIT(10)
#define B_PL_DATA_OUT_LITTLE_ENDIAN BIT(9)
#define B_PL_TX_BYTE_SWAP BIT(8)
#define B_PL_DATA_IN_LITTLE_ENDIAN BIT(4)
#define B_PL_HASH_INITIAL_VALUE_SWAP BIT(3)
#define B_PL_KEY_PAD_SWAP BIT(2)
#define B_PL_KEY_IV_SWAP BIT(1)
#define B_PL_SET_SWAP BIT(0)

#define R_PL_REG_DDSR 0x1000
#define B_PL_DES_RST BIT(31)
#define B_PL_DES_FAIL_STATUS_SH 25
#define B_PL_DES_FAIL_STATUS_MSK 0x3
#define B_PL_DES_FAIL BIT(24)
#define B_PL_DRPTR_SH 16
#define B_PL_DRPTR_MSK 0xff
#define B_PL_DWPTR_SH 8
#define B_PL_DWPTR_MSK 0xff

#define R_PL_REG_DDFWR 0x1004
#define B_PL_DDFW_SH 0
#define B_PL_DDFW_MSK 0xffffffffL

#define R_PL_REG_DDSWR 0x1008
#define B_PL_DDSW_SH 0
#define B_PL_DDSW_MSK 0xffffffffL

#define R_PL_REG_DES_PKTCONF 0x100C
#define B_PL_DBG_DPTR_SH 8
#define B_PL_DBG_DPTR_MSK 0xff
#define B_PL_DBG_SPTR_SH 0
#define B_PL_DBG_SPTR_MSK 0xff

#define R_PL_REG_DBGSDR 0x1010
#define B_PL_DBG_SD_SH 0
#define B_PL_DBG_SD_MSK 0xffffffffL

#define R_PL_REG_DBGDDR 0x1014
#define B_PL_DBG_DD_SH 0
#define B_PL_DBG_DD_MSK 0xffffffffL

//
// WL_AX_Reg_HAXIDMA.xls
//

//
// PCIE
//

#define R_AX_HAXI_INIT_CFG1 0x1000
#define B_AX_WD_ITVL_IDLE_V1_SH 28
#define B_AX_WD_ITVL_IDLE_V1_MSK 0xf
#define B_AX_WD_ITVL_ACT_V1_SH 24
#define B_AX_WD_ITVL_ACT_V1_MSK 0xf
#define B_AX_DMA_MODE_SH 18
#define B_AX_DMA_MODE_MSK 0x3
#define B_AX_STOP_AXI_MST BIT(17)
#define B_AX_HAXI_RST_KEEP_REG BIT(16)
#define B_AX_RXHCI_EN_V1 BIT(15)
#define B_AX_RXBD_MODE_V1 BIT(14)
#define B_AX_HAXI_MAX_RXDMA_SH 8
#define B_AX_HAXI_MAX_RXDMA_MSK 0x3
#define B_AX_TXHCI_EN_V1 BIT(7)
#define B_AX_FLUSH_AXI_MST BIT(4)
#define B_AX_RST_BDRAM BIT(3)
#define B_AX_HAXI_MAX_TXDMA_SH 0
#define B_AX_HAXI_MAX_TXDMA_MSK 0x3

#define R_AX_HAXI_DMA_STOP1 0x1010
#define B_AX_STOP_WPDMA BIT(19)
#define B_AX_STOP_CH12 BIT(18)
#define B_AX_STOP_CH9 BIT(17)
#define B_AX_STOP_CH8 BIT(16)
#define B_AX_STOP_ACH7 BIT(15)
#define B_AX_STOP_ACH6 BIT(14)
#define B_AX_STOP_ACH5 BIT(13)
#define B_AX_STOP_ACH4 BIT(12)
#define B_AX_STOP_ACH3 BIT(11)
#define B_AX_STOP_ACH2 BIT(10)
#define B_AX_STOP_ACH1 BIT(9)
#define B_AX_STOP_ACH0 BIT(8)

#define R_AX_TXBD_RWPTR_CLR1 0x1014
#define B_AX_CLR_CH12_IDX BIT(10)
#define B_AX_CLR_CH9_IDX BIT(9)
#define B_AX_CLR_CH8_IDX BIT(8)
#define B_AX_CLR_ACH7_IDX BIT(7)
#define B_AX_CLR_ACH6_IDX BIT(6)
#define B_AX_CLR_ACH5_IDX BIT(5)
#define B_AX_CLR_ACH4_IDX BIT(4)
#define B_AX_CLR_ACH3_IDX BIT(3)
#define B_AX_CLR_ACH2_IDX BIT(2)
#define B_AX_CLR_ACH1_IDX BIT(1)
#define B_AX_CLR_ACH0_IDX BIT(0)

#define R_AX_HAXI_DMA_BUSY1 0x101C
#define B_AX_HAXIIO_BUSY BIT(20)
#define B_AX_WPDMA_BUSY BIT(19)
#define B_AX_CH12_BUSY BIT(18)
#define B_AX_CH9_BUSY BIT(17)
#define B_AX_CH8_BUSY BIT(16)
#define B_AX_ACH7_BUSY BIT(15)
#define B_AX_ACH6_BUSY BIT(14)
#define B_AX_ACH5_BUSY BIT(13)
#define B_AX_ACH4_BUSY BIT(12)
#define B_AX_ACH3_BUSY BIT(11)
#define B_AX_ACH2_BUSY BIT(10)
#define B_AX_ACH1_BUSY BIT(9)
#define B_AX_ACH0_BUSY BIT(8)

#define R_AX_HAXI_DMA_STOP2 0x11C0
#define B_AX_STOP_CH11 BIT(1)
#define B_AX_STOP_CH10 BIT(0)

#define R_AX_TXBD_RWPTR_CLR2_V1 0x11C4
#define B_AX_CLR_CH11_IDX BIT(1)
#define B_AX_CLR_CH10_IDX BIT(0)

#define R_AX_HAXI_DMA_BUSY2 0x11C8
#define B_AX_CH11_BUSY BIT(1)
#define B_AX_CH10_BUSY BIT(0)

#define R_AX_RXBD_RWPTR_CLR_V1 0x1200
#define B_AX_CLR_RPQ_IDX BIT(1)
#define B_AX_CLR_RXQ_IDX BIT(0)

#define R_AX_HAXI_EXP_CTRL 0x1204
#define B_AX_MAX_TAG_NUM_V1_SH 0
#define B_AX_MAX_TAG_NUM_V1_MSK 0x7

#define R_AX_HAXI_DMA_BUSY3 0x1208
#define B_AX_RPQ_BUSY BIT(1)
#define B_AX_RXQ_BUSY BIT(0)

#define R_AX_RXQ_RXBD_NUM_V1 0x1210

#define R_AX_RPQ_RXBD_NUM_V1 0x1212

#define R_AX_RXQ_RXBD_IDX_V1 0x1218

#define R_AX_RPQ_RXBD_IDX_V1 0x121C

#define R_AX_RXQ_RXBD_DESA_L_V1 0x1220

#define R_AX_RXQ_RXBD_DESA_H_V1 0x1224

#define R_AX_RPQ_RXBD_DESA_L_V1 0x1228

#define R_AX_RPQ_RXBD_DESA_H_V1 0x122C

#define R_AX_ACH0_TXBD_DESA_L_V1 0x1230

#define R_AX_ACH0_TXBD_DESA_H_V1 0x1234

#define R_AX_ACH1_TXBD_DESA_L_V1 0x1238

#define R_AX_ACH1_TXBD_DESA_H_V1 0x123C

#define R_AX_ACH2_TXBD_DESA_L_V1 0x1240

#define R_AX_ACH2_TXBD_DESA_H_V1 0x1244

#define R_AX_ACH3_TXBD_DESA_L_V1 0x1248

#define R_AX_ACH3_TXBD_DESA_H_V1 0x124C

#define R_AX_ACH4_TXBD_DESA_L_V1 0x1250

#define R_AX_ACH4_TXBD_DESA_H_V1 0x1254

#define R_AX_ACH5_TXBD_DESA_L_V1 0x1258

#define R_AX_ACH5_TXBD_DESA_H_V1 0x125C

#define R_AX_ACH6_TXBD_DESA_L_V1 0x1260

#define R_AX_ACH6_TXBD_DESA_H_V1 0x1264

#define R_AX_ACH7_TXBD_DESA_L_V1 0x1268

#define R_AX_ACH7_TXBD_DESA_H_V1 0x126C

#define R_AX_CH8_TXBD_DESA_L_V1 0x1270

#define R_AX_CH8_TXBD_DESA_H_V1 0x1274

#define R_AX_CH9_TXBD_DESA_L_V1 0x1278

#define R_AX_CH9_TXBD_DESA_H_V1 0x127C

#define R_AX_CH12_TXBD_DESA_L_V1 0x1280

#define R_AX_CH12_TXBD_DESA_H_V1 0x1284

#define R_AX_ACH0_BDRAM_CTRL_V1 0x1300

#define R_AX_ACH1_BDRAM_CTRL_V1 0x1304

#define R_AX_ACH2_BDRAM_CTRL_V1 0x1308

#define R_AX_ACH3_BDRAM_CTRL_V1 0x130C

#define R_AX_ACH4_BDRAM_CTRL_V1 0x1310

#define R_AX_ACH5_BDRAM_CTRL_V1 0x1314

#define R_AX_ACH6_BDRAM_CTRL_V1 0x1318

#define R_AX_ACH7_BDRAM_CTRL_V1 0x131C

#define R_AX_CH8_BDRAM_CTRL_V1 0x1320

#define R_AX_CH9_BDRAM_CTRL_V1 0x1324

#define R_AX_CH12_BDRAM_CTRL_V1 0x1328

#define R_AX_CH10_BDRAM_CTRL_V1 0x1420

#define R_AX_CH11_BDRAM_CTRL_V1 0x1424

#define R_AX_CH10_TXBD_NUM_V1 0x1438

#define R_AX_CH11_TXBD_NUM_V1 0x143A

#define R_AX_CH10_TXBD_DESA_L_V1 0x1458

#define R_AX_CH10_TXBD_DESA_H_V1 0x145C

#define R_AX_CH11_TXBD_DESA_L_V1 0x1460

#define R_AX_CH11_TXBD_DESA_H_V1 0x1464

//
// WL_AX_Reg_PCIE.xls
//

//
// PCIE
//

#define R_AX_PCIE_INIT_CFG1 0x1000
#define B_AX_PCIE_RXRST_KEEP_REG BIT(23)
#define B_AX_PCIE_TXRST_KEEP_REG BIT(22)
#define B_AX_PCIE_PERST_KEEP_REG BIT(21)
#define B_AX_PCIE_FLR_KEEP_REG BIT(20)
#define B_AX_PCIE_TRAIN_KEEP_REG BIT(19)
#define B_AX_RXBD_MODE BIT(18)
#define B_AX_PCIE_MAX_RXDMA_SH 14
#define B_AX_PCIE_MAX_RXDMA_MSK 0x7
#define B_AX_RXHCI_EN BIT(13)
#define B_AX_LATENCY_CONTROL BIT(12)
#define B_AX_TXHCI_EN BIT(11)
#define B_AX_PCIE_MAX_TXDMA_SH 8
#define B_AX_PCIE_MAX_TXDMA_MSK 0x7
#define B_AX_TX_TRUNC_MODE BIT(5)
#define B_AX_RX_TRUNC_MODE BIT(4)
#define B_AX_RST_BDRAM BIT(3)
#define B_AX_DIS_RXDMA_PRE BIT(2)

#define R_AX_PCIE_INIT_CFG2 0x1004
#define B_AX_WD_ITVL_IDLE_SH 24
#define B_AX_WD_ITVL_IDLE_MSK 0xf
#define B_AX_WD_ITVL_ACT_SH 16
#define B_AX_WD_ITVL_ACT_MSK 0xf
#define B_AX_PCIE_RX_APPLEN_SH 0
#define B_AX_PCIE_RX_APPLEN_MSK 0x3fff

#define R_AX_PCIE_PS_CTRL 0x1008
#define B_AX_TXON_EXIT_L1_EN BIT(7)
#define B_AX_WD_NO_EMP_EXIT_L1_EN BIT(6)
#define B_AX_L1OFF_PWR_OFF_EN BIT(5)
#define B_AX_PCIE_FORCE_L0 BIT(4)
#define B_AX_TXFLAG_EXIT_L1_EN BIT(3)
#define B_AX_EN_HWENTR_L1 BIT(2)
#define B_AX_PCIE_EN_SWENT_L23 BIT(1)
#define B_AX_PCIE_EN_HWEXT_L1 BIT(0)

#define R_AX_PCIE_MIX_CFG 0x100C
#define B_AX_PCIE_T3_TIME_SH 22
#define B_AX_PCIE_T3_TIME_MSK 0x3
#define B_AX_PCIE_T2_TIME_SH 20
#define B_AX_PCIE_T2_TIME_MSK 0x3
#define B_AX_HOTRST_EN BIT(19)
#define B_AX_MDIO_MODE BIT(18)
#define B_AX_CHANGE_PCIE_SPEED BIT(16)
#define B_AX_GEN1_GEN2_SH 14
#define B_AX_GEN1_GEN2_MSK 0x3
#define B_AX_HPS_CLKR_PCIE_SH 12
#define B_AX_HPS_CLKR_PCIE_MSK 0x3
#define B_AX_PCIE_INT BIT(11)
#define B_AX_PCIEIO_PERSTB_SEL BIT(10)
#define B_AX_EPHY_RX50_EN BIT(8)
#define B_AX_MSI_TIMEOUT_ID_V1_SH 5
#define B_AX_MSI_TIMEOUT_ID_V1_MSK 0x7
#define B_AX_RADDR_RD BIT(4)
#define B_AX_ECRC_EN BIT(3)
#define B_AX_EN_SLOW_MAC_TX BIT(2)
#define B_AX_EN_SLOW_MAC_RX BIT(1)
#define B_AX_EN_SLOW_MAC_HW BIT(0)

#define R_AX_PCIE_DMA_STOP1 0x1010
#define B_AX_STOP_PCIEIO BIT(20)
#define B_AX_STOP_WPDMA BIT(19)
#define B_AX_STOP_CH12 BIT(18)
#define B_AX_STOP_CH9 BIT(17)
#define B_AX_STOP_CH8 BIT(16)
#define B_AX_STOP_ACH7 BIT(15)
#define B_AX_STOP_ACH6 BIT(14)
#define B_AX_STOP_ACH5 BIT(13)
#define B_AX_STOP_ACH4 BIT(12)
#define B_AX_STOP_ACH3 BIT(11)
#define B_AX_STOP_ACH2 BIT(10)
#define B_AX_STOP_ACH1 BIT(9)
#define B_AX_STOP_ACH0 BIT(8)

#define R_AX_TXBD_RWPTR_CLR1 0x1014
#define B_AX_CLR_CH12_IDX BIT(10)
#define B_AX_CLR_CH9_IDX BIT(9)
#define B_AX_CLR_CH8_IDX BIT(8)
#define B_AX_CLR_ACH7_IDX BIT(7)
#define B_AX_CLR_ACH6_IDX BIT(6)
#define B_AX_CLR_ACH5_IDX BIT(5)
#define B_AX_CLR_ACH4_IDX BIT(4)
#define B_AX_CLR_ACH3_IDX BIT(3)
#define B_AX_CLR_ACH2_IDX BIT(2)
#define B_AX_CLR_ACH1_IDX BIT(1)
#define B_AX_CLR_ACH0_IDX BIT(0)

#define R_AX_RXBD_RWPTR_CLR 0x1018
#define B_AX_CLR_RPQ_IDX BIT(1)
#define B_AX_CLR_RXQ_IDX BIT(0)

#define R_AX_PCIE_DMA_BUSY1 0x101C
#define B_AX_PCIEIO_RX_BUSY BIT(22)
#define B_AX_PCIEIO_TX_BUSY BIT(21)
#define B_AX_PCIEIO_BUSY BIT(20)
#define B_AX_WPDMA_BUSY BIT(19)
#define B_AX_CH12_BUSY BIT(18)
#define B_AX_CH9_BUSY BIT(17)
#define B_AX_CH8_BUSY BIT(16)
#define B_AX_ACH7_BUSY BIT(15)
#define B_AX_ACH6_BUSY BIT(14)
#define B_AX_ACH5_BUSY BIT(13)
#define B_AX_ACH4_BUSY BIT(12)
#define B_AX_ACH3_BUSY BIT(11)
#define B_AX_ACH2_BUSY BIT(10)
#define B_AX_ACH1_BUSY BIT(9)
#define B_AX_ACH0_BUSY BIT(8)
#define B_AX_RPQ_BUSY BIT(1)
#define B_AX_RXQ_BUSY BIT(0)

#define R_AX_RXQ_RXBD_NUM 0x1020
#define B_AX_RXQ_DESC_NUM_SH 0
#define B_AX_RXQ_DESC_NUM_MSK 0xfff

#define R_AX_RPQ_RXBD_NUM 0x1022
#define B_AX_RPQ_DESC_NUM_SH 0
#define B_AX_RPQ_DESC_NUM_MSK 0xfff

#define R_AX_ACH0_TXBD_NUM 0x1024
#define B_AX_PCIE_ACH0_FLAG BIT(14)
#define B_AX_ACH0_DESC_NUM_SH 0
#define B_AX_ACH0_DESC_NUM_MSK 0xfff

#define R_AX_ACH1_TXBD_NUM 0x1026
#define B_AX_PCIE_ACH1_FLAG BIT(14)
#define B_AX_ACH1_DESC_NUM_SH 0
#define B_AX_ACH1_DESC_NUM_MSK 0xfff

#define R_AX_ACH2_TXBD_NUM 0x1028
#define B_AX_PCIE_ACH2_FLAG BIT(14)
#define B_AX_ACH2_DESC_NUM_SH 0
#define B_AX_ACH2_DESC_NUM_MSK 0xfff

#define R_AX_ACH3_TXBD_NUM 0x102A
#define B_AX_PCIE_ACH3_FLAG BIT(14)
#define B_AX_ACH3_DESC_NUM_SH 0
#define B_AX_ACH3_DESC_NUM_MSK 0xfff

#define R_AX_ACH4_TXBD_NUM 0x102C
#define B_AX_PCIE_ACH4_FLAG BIT(14)
#define B_AX_ACH4_DESC_NUM_SH 0
#define B_AX_ACH4_DESC_NUM_MSK 0xfff

#define R_AX_ACH5_TXBD_NUM 0x102E
#define B_AX_PCIE_ACH5_FLAG BIT(14)
#define B_AX_ACH5_DESC_NUM_SH 0
#define B_AX_ACH5_DESC_NUM_MSK 0xfff

#define R_AX_ACH6_TXBD_NUM 0x1030
#define B_AX_PCIE_ACH6_FLAG BIT(14)
#define B_AX_ACH6_DESC_NUM_SH 0
#define B_AX_ACH6_DESC_NUM_MSK 0xfff

#define R_AX_ACH7_TXBD_NUM 0x1032
#define B_AX_PCIE_ACH7_FLAG BIT(14)
#define B_AX_ACH7_DESC_NUM_SH 0
#define B_AX_ACH7_DESC_NUM_MSK 0xfff

#define R_AX_CH8_TXBD_NUM 0x1034
#define B_AX_PCIE_CH8_FLAG BIT(14)
#define B_AX_CH8_DESC_NUM_SH 0
#define B_AX_CH8_DESC_NUM_MSK 0xfff

#define R_AX_CH9_TXBD_NUM 0x1036
#define B_AX_PCIE_CH9_FLAG BIT(14)
#define B_AX_CH9_DESC_NUM_SH 0
#define B_AX_CH9_DESC_NUM_MSK 0xfff

#define R_AX_CH12_TXBD_NUM 0x1038
#define B_AX_PCIE_CH12_FLAG BIT(14)
#define B_AX_CH12_DESC_NUM_SH 0
#define B_AX_CH12_DESC_NUM_MSK 0xfff

#define R_AX_RXQ_RXBD_IDX 0x1050
#define B_AX_RXQ_HW_IDX_SH 16
#define B_AX_RXQ_HW_IDX_MSK 0xfff
#define B_AX_RXQ_HOST_IDX_SH 0
#define B_AX_RXQ_HOST_IDX_MSK 0xfff

#define R_AX_RPQ_RXBD_IDX 0x1054
#define B_AX_RPQ_HW_IDX_SH 16
#define B_AX_RPQ_HW_IDX_MSK 0xfff
#define B_AX_RPQ_HOST_IDX_SH 0
#define B_AX_RPQ_HOST_IDX_MSK 0xfff

#define R_AX_ACH0_TXBD_IDX 0x1058
#define B_AX_ACH0_HW_IDX_SH 16
#define B_AX_ACH0_HW_IDX_MSK 0xfff
#define B_AX_ACH0_HOST_IDX_SH 0
#define B_AX_ACH0_HOST_IDX_MSK 0xfff

#define R_AX_ACH1_TXBD_IDX 0x105C
#define B_AX_ACH1_HW_IDX_SH 16
#define B_AX_ACH1_HW_IDX_MSK 0xfff
#define B_AX_ACH1_HOST_IDX_SH 0
#define B_AX_ACH1_HOST_IDX_MSK 0xfff

#define R_AX_ACH2_TXBD_IDX 0x1060
#define B_AX_ACH2_HW_IDX_SH 16
#define B_AX_ACH2_HW_IDX_MSK 0xfff
#define B_AX_ACH2_HOST_IDX_SH 0
#define B_AX_ACH2_HOST_IDX_MSK 0xfff

#define R_AX_ACH3_TXBD_IDX 0x1064
#define B_AX_ACH3_HW_IDX_SH 16
#define B_AX_ACH3_HW_IDX_MSK 0xfff
#define B_AX_ACH3_HOST_IDX_SH 0
#define B_AX_ACH3_HOST_IDX_MSK 0xfff

#define R_AX_ACH4_TXBD_IDX 0x1068
#define B_AX_ACH4_HW_IDX_SH 16
#define B_AX_ACH4_HW_IDX_MSK 0xfff
#define B_AX_ACH4_HOST_IDX_SH 0
#define B_AX_ACH4_HOST_IDX_MSK 0xfff

#define R_AX_ACH5_TXBD_IDX 0x106C
#define B_AX_ACH5_HW_IDX_SH 16
#define B_AX_ACH5_HW_IDX_MSK 0xfff
#define B_AX_ACH5_HOST_IDX_SH 0
#define B_AX_ACH5_HOST_IDX_MSK 0xfff

#define R_AX_ACH6_TXBD_IDX 0x1070
#define B_AX_ACH6_HW_IDX_SH 16
#define B_AX_ACH6_HW_IDX_MSK 0xfff
#define B_AX_ACH6_HOST_IDX_SH 0
#define B_AX_ACH6_HOST_IDX_MSK 0xfff

#define R_AX_ACH7_TXBD_IDX 0x1074
#define B_AX_ACH7_HW_IDX_SH 16
#define B_AX_ACH7_HW_IDX_MSK 0xfff
#define B_AX_ACH7_HOST_IDX_SH 0
#define B_AX_ACH7_HOST_IDX_MSK 0xfff

#define R_AX_CH8_TXBD_IDX 0x1078
#define B_AX_CH8_HW_IDX_SH 16
#define B_AX_CH8_HW_IDX_MSK 0xfff
#define B_AX_CH8_HOST_IDX_SH 0
#define B_AX_CH8_HOST_IDX_MSK 0xfff

#define R_AX_CH9_TXBD_IDX 0x107C
#define B_AX_CH9_HW_IDX_SH 16
#define B_AX_CH9_HW_IDX_MSK 0xfff
#define B_AX_CH9_HOST_IDX_SH 0
#define B_AX_CH9_HOST_IDX_MSK 0xfff

#define R_AX_CH12_TXBD_IDX 0x1080
#define B_AX_CH12_HW_IDX_SH 16
#define B_AX_CH12_HW_IDX_MSK 0xfff
#define B_AX_CH12_HOST_IDX_SH 0
#define B_AX_CH12_HOST_IDX_MSK 0xfff

#define R_AX_DBI_FLAG 0x1090
#define B_AX_DBI_RFLAG BIT(17)
#define B_AX_DBI_WFLAG BIT(16)
#define B_AX_DBI_WREN_SH 12
#define B_AX_DBI_WREN_MSK 0xf
#define B_AX_DBI_ADDR_SH 0
#define B_AX_DBI_ADDR_MSK 0xfff

#define R_AX_DBI_WDATA  0x1094
#define B_AX_DBI_WDATA_SH 0
#define B_AX_DBI_WDATA_MSK 0xffffffffL

#define R_AX_DBI_RDATA 0x1098
#define B_AX_DBI_RDATA_SH 0
#define B_AX_DBI_RDATA_MSK 0xffffffffL

#define R_AX_MDIO_CFG 0x10A0
#define B_AX_MDIO_PHY_ADDR_SH 12
#define B_AX_MDIO_PHY_ADDR_MSK 0x3
#define B_AX_MDIO_RFLAG BIT(9)
#define B_AX_MDIO_WFLAG BIT(8)
#define B_AX_MDIO_ADDR_SH 0
#define B_AX_MDIO_ADDR_MSK 0x1f

#define R_AX_MDIO_WDATA 0x10A4
#define B_AX_MDIO_WDATA_SH 0
#define B_AX_MDIO_WDATA_MSK 0xffff

#define R_AX_MDIO_RDATA 0x10A6
#define B_AX_MDIO_RDATA_SH 0
#define B_AX_MDIO_RDATA_MSK 0xffff

#define R_AX_PCIE_HIMR00 0x10B0
#define B_AX_HC00ISR_IND_INT_EN BIT(27)
#define B_AX_HD1ISR_IND_INT_EN BIT(26)
#define B_AX_HD0ISR_IND_INT_EN BIT(25)
#define B_AX_HS0ISR_IND_INT_EN BIT(24)
#define B_AX_RETRAIN_INT_EN BIT(21)
#define B_AX_RPQBD_FULL_INT_EN BIT(20)
#define B_AX_RDU_INT_EN BIT(19)
#define B_AX_RXDMA_STUCK_INT_EN BIT(18)
#define B_AX_TXDMA_STUCK_INT_EN BIT(17)
#define B_AX_PCIE_HOTRST_INT_EN BIT(16)
#define B_AX_PCIE_FLR_INT_EN BIT(15)
#define B_AX_PCIE_PERST_INT_EN BIT(14)
#define B_AX_TXDMA_CH12_INT_EN BIT(13)
#define B_AX_TXDMA_CH9_INT_EN BIT(12)
#define B_AX_TXDMA_CH8_INT_EN BIT(11)
#define B_AX_TXDMA_ACH7_INT_EN BIT(10)
#define B_AX_TXDMA_ACH6_INT_EN BIT(9)
#define B_AX_TXDMA_ACH5_INT_EN BIT(8)
#define B_AX_TXDMA_ACH4_INT_EN BIT(7)
#define B_AX_TXDMA_ACH3_INT_EN BIT(6)
#define B_AX_TXDMA_ACH2_INT_EN BIT(5)
#define B_AX_TXDMA_ACH1_INT_EN BIT(4)
#define B_AX_TXDMA_ACH0_INT_EN BIT(3)
#define B_AX_RPQDMA_INT_EN BIT(2)
#define B_AX_RXP1DMA_INT_EN BIT(1)
#define B_AX_RXDMA_INT_EN BIT(0)

#define R_AX_PCIE_HISR00 0x10B4
#define B_AX_HC00ISR_IND_INT BIT(27)
#define B_AX_HD1ISR_IND_INT BIT(26)
#define B_AX_HD0ISR_IND_INT BIT(25)
#define B_AX_HS0ISR_IND_INT BIT(24)
#define B_AX_RETRAIN_INT BIT(21)
#define B_AX_RPQBD_FULL_INT BIT(20)
#define B_AX_RDU_INT BIT(19)
#define B_AX_RXDMA_STUCK_INT BIT(18)
#define B_AX_TXDMA_STUCK_INT BIT(17)
#define B_AX_PCIE_HOTRST_INT BIT(16)
#define B_AX_PCIE_FLR_INT BIT(15)
#define B_AX_PCIE_PERST_INT BIT(14)
#define B_AX_TXDMA_CH12_INT BIT(13)
#define B_AX_TXDMA_CH9_INT BIT(12)
#define B_AX_TXDMA_CH8_INT BIT(11)
#define B_AX_TXDMA_ACH7_INT BIT(10)
#define B_AX_TXDMA_ACH6_INT BIT(9)
#define B_AX_TXDMA_ACH5_INT BIT(8)
#define B_AX_TXDMA_ACH4_INT BIT(7)
#define B_AX_TXDMA_ACH3_INT BIT(6)
#define B_AX_TXDMA_ACH2_INT BIT(5)
#define B_AX_TXDMA_ACH1_INT BIT(4)
#define B_AX_TXDMA_ACH0_INT BIT(3)
#define B_AX_RPQDMA_INT BIT(2)
#define B_AX_RXP1DMA_INT BIT(1)
#define B_AX_RXDMA_INT BIT(0)

#define R_AX_PCIE_HRPWM 0x10C0
#define B_AX_PCIE_HRPWM_SH 0
#define B_AX_PCIE_HRPWM_MSK 0xffff

#define R_AX_INT_MIT_TX 0x10D0
#define B_AX_TXMIT_CH12_SEL BIT(31)
#define B_AX_TXMIT_CH11_SEL BIT(30)
#define B_AX_TXMIT_CH10_SEL BIT(29)
#define B_AX_TXMIT_CH9_SEL BIT(28)
#define B_AX_TXMIT_CH8_SEL BIT(27)
#define B_AX_TXMIT_ACH7_SEL BIT(26)
#define B_AX_TXMIT_ACH6_SEL BIT(25)
#define B_AX_TXMIT_ACH5_SEL BIT(24)
#define B_AX_TXMIT_ACH4_SEL BIT(23)
#define B_AX_TXMIT_ACH3_SEL BIT(22)
#define B_AX_TXMIT_ACH2_SEL BIT(21)
#define B_AX_TXMIT_ACH1_SEL BIT(20)
#define B_AX_TXMIT_ACH0_SEL BIT(19)
#define B_AX_TXTIMER_UNIT_SH 16
#define B_AX_TXTIMER_UNIT_MSK 0x3
#define B_AX_TXCOUNTER_MATCH_SH 8
#define B_AX_TXCOUNTER_MATCH_MSK 0xff
#define B_AX_TXTIMER_MATCH_SH 0
#define B_AX_TXTIMER_MATCH_MSK 0xff

#define R_AX_INT_MIT_RX 0x10D4
#define B_AX_RXMIT_RXP2_SEL BIT(19)
#define B_AX_RXMIT_RXP1_SEL BIT(18)
#define B_AX_RXTIMER_UNIT_SH 16
#define B_AX_RXTIMER_UNIT_MSK 0x3
#define B_AX_RXCOUNTER_MATCH_SH 8
#define B_AX_RXCOUNTER_MATCH_MSK 0xff
#define B_AX_RXTIMER_MATCH_SH 0
#define B_AX_RXTIMER_MATCH_MSK 0xff

#define R_AX_TXDMA_ADDR_H 0x10F0
#define B_AX_TXDMA_ADDR_H_SH 0
#define B_AX_TXDMA_ADDR_H_MSK 0xffffffffL

#define R_AX_RXDMA_ADDR_H 0x10F4
#define B_AX_RXDMA_ADDR_H_SH 0
#define B_AX_RXDMA_ADDR_H_MSK 0xffffffffL

#define R_AX_PCIE_INFO 0x10F8
#define B_AX_HOST_GEN2_SUPPORT BIT(4)
#define B_AX_ACT_LINK_OFF BIT(2)
#define B_AX_PCIERX_IDLE BIT(1)
#define B_AX_PCIETX_IDLE BIT(0)

#define R_AX_TSFTIMER_HCI 0x10FC
#define B_AX_TSFT2_HCI_SH 16
#define B_AX_TSFT2_HCI_MSK 0xffff
#define B_AX_TSFT1_HCI_SH 0
#define B_AX_TSFT1_HCI_MSK 0xffff

#define R_AX_RXQ_RXBD_DESA_L 0x1100
#define B_AX_RXQ_RXBD_DESA_L_SH 0
#define B_AX_RXQ_RXBD_DESA_L_MSK 0xffffffffL

#define R_AX_RXQ_RXBD_DESA_H 0x1104
#define B_AX_RXQ_RXBD_DESA_H_SH 0
#define B_AX_RXQ_RXBD_DESA_H_MSK 0xffffffffL

#define R_AX_RPQ_RXBD_DESA_L 0x1108
#define B_AX_RPQ_RXBD_DESA_L_SH 0
#define B_AX_RPQ_RXBD_DESA_L_MSK 0xffffffffL

#define R_AX_RPQ_RXBD_DESA_H 0x110C
#define B_AX_RPQ_RXBD_DESA_H_SH 0
#define B_AX_RPQ_RXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH0_TXBD_DESA_L 0x1110
#define B_AX_ACH0_TXBD_DESA_L_SH 0
#define B_AX_ACH0_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH0_TXBD_DESA_H 0x1114
#define B_AX_ACH0_TXBD_DESA_H_SH 0
#define B_AX_ACH0_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH1_TXBD_DESA_L 0x1118
#define B_AX_ACH1_TXBD_DESA_L_SH 0
#define B_AX_ACH1_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH1_TXBD_DESA_H 0x111C
#define B_AX_ACH1_TXBD_DESA_H_SH 0
#define B_AX_ACH1_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH2_TXBD_DESA_L 0x1120
#define B_AX_ACH2_TXBD_DESA_L_SH 0
#define B_AX_ACH2_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH2_TXBD_DESA_H 0x1124
#define B_AX_ACH2_TXBD_DESA_H_SH 0
#define B_AX_ACH2_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH3_TXBD_DESA_L 0x1128
#define B_AX_ACH3_TXBD_DESA_L_SH 0
#define B_AX_ACH3_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH3_TXBD_DESA_H 0x112C
#define B_AX_ACH3_TXBD_DESA_H_SH 0
#define B_AX_ACH3_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH4_TXBD_DESA_L 0x1130
#define B_AX_ACH4_TXBD_DESA_L_SH 0
#define B_AX_ACH4_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH4_TXBD_DESA_H 0x1134
#define B_AX_ACH4_TXBD_DESA_H_SH 0
#define B_AX_ACH4_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH5_TXBD_DESA_L 0x1138
#define B_AX_ACH5_TXBD_DESA_L_SH 0
#define B_AX_ACH5_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH5_TXBD_DESA_H 0x113C
#define B_AX_ACH5_TXBD_DESA_H_SH 0
#define B_AX_ACH5_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH6_TXBD_DESA_L 0x1140
#define B_AX_ACH6_TXBD_DESA_L_SH 0
#define B_AX_ACH6_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH6_TXBD_DESA_H 0x1144
#define B_AX_ACH6_TXBD_DESA_H_SH 0
#define B_AX_ACH6_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_ACH7_TXBD_DESA_L 0x1148
#define B_AX_ACH7_TXBD_DESA_L_SH 0
#define B_AX_ACH7_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_ACH7_TXBD_DESA_H 0x114C
#define B_AX_ACH7_TXBD_DESA_H_SH 0
#define B_AX_ACH7_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_CH8_TXBD_DESA_L 0x1150
#define B_AX_CH8_TXBD_DESA_L_SH 0
#define B_AX_CH8_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH8_TXBD_DESA_H 0x1154
#define B_AX_CH8_TXBD_DESA_H_SH 0
#define B_AX_CH8_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_CH9_TXBD_DESA_L 0x1158
#define B_AX_CH9_TXBD_DESA_L_SH 0
#define B_AX_CH9_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH9_TXBD_DESA_H 0x115C
#define B_AX_CH9_TXBD_DESA_H_SH 0
#define B_AX_CH9_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_CH12_TXBD_DESA_L 0x1160
#define B_AX_CH12_TXBD_DESA_L_SH 0
#define B_AX_CH12_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH12_TXBD_DESA_H 0x1164
#define B_AX_CH12_TXBD_DESA_H_SH 0
#define B_AX_CH12_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_PCIE_DBG_CTRL 0x11C0
#define B_AX_DBG_DUMMY_SH 16
#define B_AX_DBG_DUMMY_MSK 0xff
#define B_AX_DBG_SEL_SH 13
#define B_AX_DBG_SEL_MSK 0x7
#define B_AX_PCIE_DBG_SEL BIT(12)
#define B_AX_MRD_TIMEOUT_EN BIT(10)
#define B_AX_ASFF_FULL_NO_STK BIT(1)
#define B_AX_EN_STUCK_DBG BIT(0)

#define R_AX_DBG_ERR_FLAG 0x11C4
#define B_AX_PCIE_RPQ_FULL BIT(29)
#define B_AX_PCIE_RXQ_FULL BIT(28)
#define B_AX_CPL_STATUS_SH 25
#define B_AX_CPL_STATUS_MSK 0x7
#define B_AX_RX_STUCK BIT(22)
#define B_AX_TX_STUCK BIT(21)
#define B_AX_PCIEDBG_TXERR0 BIT(16)
#define B_AX_PCIE_RXP1_ERR0 BIT(4)
#define B_AX_PCIE_TXBD_LEN0 BIT(1)
#define B_AX_PCIE_TXBD_4KBOUD_LENERR BIT(0)

#define R_AX_PCIE_LPWR_DBG 0x11C8
#define B_AX_PCIE_L1_COND_CFG_SPC BIT(10)
#define B_AX_PCIE_L1_COND_MAC_REG BIT(9)
#define B_AX_PCIE_L1_COND_HISR BIT(8)
#define B_AX_PCIE_L1_COND_RX BIT(7)
#define B_AX_PCIE_L1_COND_TX BIT(6)
#define B_AX_PCIE_L1_COND_HDP_RX BIT(5)
#define B_AX_PCIE_L1_COND_LTR BIT(4)
#define B_AX_PCIE_L1_COND_FORC_L0 BIT(3)
#define B_AX_PCIE_L1_COND_WD_EMPY BIT(2)
#define B_AX_PCIE_L1_COND_TXFLAG1 BIT(1)
#define B_AX_PCIE_L1_COND_TXFLAG0 BIT(0)

#define R_AX_STC_INT_CS 0x11D0
#define B_AX_STC_INT_EN BIT(31)
#define B_AX_STC_INT_FLAG_SH 16
#define B_AX_STC_INT_FLAG_MSK 0xff
#define B_AX_STC_INT_IDX_SH 8
#define B_AX_STC_INT_IDX_MSK 0x7
#define B_AX_STC_INT_REALTIME_CS_SH 0
#define B_AX_STC_INT_REALTIME_CS_MSK 0x3f

#define R_AX_ST_INT_CFG 0x11D4
#define B_AX_STC_INT_GRP_EN BIT(31)
#define B_AX_STC_INT_EXPECT_LS_SH 8
#define B_AX_STC_INT_EXPECT_LS_MSK 0x3f
#define B_AX_STC_INT_EXPECT_CS_SH 0
#define B_AX_STC_INT_EXPECT_CS_MSK 0x3f

#define R_AX_LBC_WATCHDOG 0x11D8
#define B_AX_LBC_ADDR_SH 10
#define B_AX_LBC_ADDR_MSK 0x3ffff
#define B_AX_LBC_TIMER_SH 4
#define B_AX_LBC_TIMER_MSK 0xf
#define B_AX_LBC_FLAG BIT(1)
#define B_AX_LBC_EN BIT(0)

#define R_AX_DEBUG_STATE1 0x11E0
#define B_AX_DEBUG_STATE1_SH 0
#define B_AX_DEBUG_STATE1_MSK 0xffffffffL

#define R_AX_DEBUG_STATE2 0x11E4
#define B_AX_DEBUG_STATE2_SH 0
#define B_AX_DEBUG_STATE2_MSK 0xffffffffL

#define R_AX_DEBUG_STATE3 0x11E8
#define B_AX_DEBUG_STATE3_SH 0
#define B_AX_DEBUG_STATE3_MSK 0xffffffffL

#define R_AX_ACH0_BDRAM_CTRL 0x1200
#define B_AX_ACH0_BDRAM_MIN_SH 16
#define B_AX_ACH0_BDRAM_MIN_MSK 0xff
#define B_AX_ACH0_BDRAM_MAX_SH 8
#define B_AX_ACH0_BDRAM_MAX_MSK 0xff
#define B_AX_ACH0_BDRAM_SIDX_SH 0
#define B_AX_ACH0_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH1_BDRAM_CTRL 0x1204
#define B_AX_ACH1_BDRAM_MIN_SH 16
#define B_AX_ACH1_BDRAM_MIN_MSK 0xff
#define B_AX_ACH1_BDRAM_MAX_SH 8
#define B_AX_ACH1_BDRAM_MAX_MSK 0xff
#define B_AX_ACH1_BDRAM_SIDX_SH 0
#define B_AX_ACH1_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH2_BDRAM_CTRL 0x1208
#define B_AX_ACH2_BDRAM_MIN_SH 16
#define B_AX_ACH2_BDRAM_MIN_MSK 0xff
#define B_AX_ACH2_BDRAM_MAX_SH 8
#define B_AX_ACH2_BDRAM_MAX_MSK 0xff
#define B_AX_ACH2_BDRAM_SIDX_SH 0
#define B_AX_ACH2_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH3_BDRAM_CTRL 0x120C
#define B_AX_ACH3_BDRAM_MIN_SH 16
#define B_AX_ACH3_BDRAM_MIN_MSK 0xff
#define B_AX_ACH3_BDRAM_MAX_SH 8
#define B_AX_ACH3_BDRAM_MAX_MSK 0xff
#define B_AX_ACH3_BDRAM_SIDX_SH 0
#define B_AX_ACH3_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH4_BDRAM_CTRL 0x1210
#define B_AX_ACH4_BDRAM_MIN_SH 16
#define B_AX_ACH4_BDRAM_MIN_MSK 0xff
#define B_AX_ACH4_BDRAM_MAX_SH 8
#define B_AX_ACH4_BDRAM_MAX_MSK 0xff
#define B_AX_ACH4_BDRAM_SIDX_SH 0
#define B_AX_ACH4_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH5_BDRAM_CTRL 0x1214
#define B_AX_ACH5_BDRAM_MIN_SH 16
#define B_AX_ACH5_BDRAM_MIN_MSK 0xff
#define B_AX_ACH5_BDRAM_MAX_SH 8
#define B_AX_ACH5_BDRAM_MAX_MSK 0xff
#define B_AX_ACH5_BDRAM_SIDX_SH 0
#define B_AX_ACH5_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH6_BDRAM_CTRL 0x1218
#define B_AX_ACH6_BDRAM_MIN_SH 16
#define B_AX_ACH6_BDRAM_MIN_MSK 0xff
#define B_AX_ACH6_BDRAM_MAX_SH 8
#define B_AX_ACH6_BDRAM_MAX_MSK 0xff
#define B_AX_ACH6_BDRAM_SIDX_SH 0
#define B_AX_ACH6_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH7_BDRAM_CTRL 0x121C
#define B_AX_ACH7_BDRAM_MIN_SH 16
#define B_AX_ACH7_BDRAM_MIN_MSK 0xff
#define B_AX_ACH7_BDRAM_MAX_SH 8
#define B_AX_ACH7_BDRAM_MAX_MSK 0xff
#define B_AX_ACH7_BDRAM_SIDX_SH 0
#define B_AX_ACH7_BDRAM_SIDX_MSK 0xff

#define R_AX_CH8_BDRAM_CTRL 0x1220
#define B_AX_CH8_BDRAM_MIN_SH 16
#define B_AX_CH8_BDRAM_MIN_MSK 0xff
#define B_AX_CH8_BDRAM_MAX_SH 8
#define B_AX_CH8_BDRAM_MAX_MSK 0xff
#define B_AX_CH8_BDRAM_SIDX_SH 0
#define B_AX_CH8_BDRAM_SIDX_MSK 0xff

#define R_AX_CH9_BDRAM_CTRL 0x1224
#define B_AX_CH9_BDRAM_MIN_SH 16
#define B_AX_CH9_BDRAM_MIN_MSK 0xff
#define B_AX_CH9_BDRAM_MAX_SH 8
#define B_AX_CH9_BDRAM_MAX_MSK 0xff
#define B_AX_CH9_BDRAM_SIDX_SH 0
#define B_AX_CH9_BDRAM_SIDX_MSK 0xff

#define R_AX_CH12_BDRAM_CTRL 0x1228
#define B_AX_CH12_BDRAM_MIN_SH 16
#define B_AX_CH12_BDRAM_MIN_MSK 0xff
#define B_AX_CH12_BDRAM_MAX_SH 8
#define B_AX_CH12_BDRAM_MAX_MSK 0xff
#define B_AX_CH12_BDRAM_SIDX_SH 0
#define B_AX_CH12_BDRAM_SIDX_MSK 0xff

#define R_AX_ACH0_BDRAM_RWPTR 0x1230
#define B_AX_ACH0_BDRAM_WPTR_SH 8
#define B_AX_ACH0_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH0_BDRAM_RPTR_SH 0
#define B_AX_ACH0_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH1_BDRAM_RWPTR 0x1232
#define B_AX_ACH1_BDRAM_WPTR_SH 8
#define B_AX_ACH1_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH1_BDRAM_RPTR_SH 0
#define B_AX_ACH1_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH2_BDRAM_RWPTR 0x1234
#define B_AX_ACH2_BDRAM_WPTR_SH 8
#define B_AX_ACH2_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH2_BDRAM_RPTR_SH 0
#define B_AX_ACH2_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH3_BDRAM_RWPTR 0x1236
#define B_AX_ACH3_BDRAM_WPTR_SH 8
#define B_AX_ACH3_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH3_BDRAM_RPTR_SH 0
#define B_AX_ACH3_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH4_BDRAM_RWPTR 0x1238
#define B_AX_ACH4_BDRAM_WPTR_SH 8
#define B_AX_ACH4_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH4_BDRAM_RPTR_SH 0
#define B_AX_ACH4_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH5_BDRAM_RWPTR 0x123A
#define B_AX_ACH5_BDRAM_WPTR_SH 8
#define B_AX_ACH5_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH5_BDRAM_RPTR_SH 0
#define B_AX_ACH5_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH6_BDRAM_RWPTR 0x123C
#define B_AX_ACH6_BDRAM_WPTR_SH 8
#define B_AX_ACH6_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH6_BDRAM_RPTR_SH 0
#define B_AX_ACH6_BDRAM_RPTR_MSK 0xff

#define R_AX_ACH7_BDRAM_RWPTR 0x123E
#define B_AX_ACH7_BDRAM_WPTR_SH 8
#define B_AX_ACH7_BDRAM_WPTR_MSK 0xff
#define B_AX_ACH7_BDRAM_RPTR_SH 0
#define B_AX_ACH7_BDRAM_RPTR_MSK 0xff

#define R_AX_CH8_BDRAM_RWPTR 0x1240
#define B_AX_CH8_BDRAM_WPTR_SH 8
#define B_AX_CH8_BDRAM_WPTR_MSK 0xff
#define B_AX_CH8_BDRAM_RPTR_SH 0
#define B_AX_CH8_BDRAM_RPTR_MSK 0xff

#define R_AX_CH9_BDRAM_RWPTR 0x1242
#define B_AX_CH9_BDRAM_WPTR_SH 8
#define B_AX_CH9_BDRAM_WPTR_MSK 0xff
#define B_AX_CH9_BDRAM_RPTR_SH 0
#define B_AX_CH9_BDRAM_RPTR_MSK 0xff

#define R_AX_CH12_BDRAM_RWPTR 0x1244
#define B_AX_CH12_BDRAM_WPTR_SH 8
#define B_AX_CH12_BDRAM_WPTR_MSK 0xff
#define B_AX_CH12_BDRAM_RPTR_SH 0
#define B_AX_CH12_BDRAM_RPTR_MSK 0xff

#define R_AX_PCIE_DMA_STOP2 0x1310
#define B_AX_STOP_CH11 BIT(1)
#define B_AX_STOP_CH10 BIT(0)

#define R_AX_TXBD_RWPTR_CLR2 0x1314
#define B_AX_CLR_CH11_IDX BIT(1)
#define B_AX_CLR_CH10_IDX BIT(0)

#define R_AX_PCIE_DMA_BUSY2 0x131C
#define B_AX_CH11_BUSY BIT(1)
#define B_AX_CH10_BUSY BIT(0)

#define R_AX_CH10_BDRAM_CTRL 0x1320
#define B_AX_CH10_BDRAM_MIN_SH 16
#define B_AX_CH10_BDRAM_MIN_MSK 0xff
#define B_AX_CH10_BDRAM_MAX_SH 8
#define B_AX_CH10_BDRAM_MAX_MSK 0xff
#define B_AX_CH10_BDRAM_SIDX_SH 0
#define B_AX_CH10_BDRAM_SIDX_MSK 0xff

#define R_AX_CH11_BDRAM_CTRL 0x1324
#define B_AX_CH11_BDRAM_MIN_SH 16
#define B_AX_CH11_BDRAM_MIN_MSK 0xff
#define B_AX_CH11_BDRAM_MAX_SH 8
#define B_AX_CH11_BDRAM_MAX_MSK 0xff
#define B_AX_CH11_BDRAM_SIDX_SH 0
#define B_AX_CH11_BDRAM_SIDX_MSK 0xff

#define R_AX_CH10_BDRAM_RWPTR 0x1340
#define B_AX_CH10_BDRAM_WPTR_SH 8
#define B_AX_CH10_BDRAM_WPTR_MSK 0xff
#define B_AX_CH10_BDRAM_RPTR_SH 0
#define B_AX_CH10_BDRAM_RPTR_MSK 0xff

#define R_AX_CH11_BDRAM_RWPTR 0x1342
#define B_AX_CH11_BDRAM_WPTR_SH 8
#define B_AX_CH11_BDRAM_WPTR_MSK 0xff
#define B_AX_CH11_BDRAM_RPTR_SH 0
#define B_AX_CH11_BDRAM_RPTR_MSK 0xff

#define R_AX_CH10_TXBD_NUM 0x1338
#define B_AX_PCIE_CH10_FLAG BIT(14)
#define B_AX_CH10_DESC_NUM_SH 0
#define B_AX_CH10_DESC_NUM_MSK 0xfff

#define R_AX_CH11_TXBD_NUM 0x133A
#define B_AX_PCIE_CH11_FLAG BIT(14)
#define B_AX_CH11_DESC_NUM_SH 0
#define B_AX_CH11_DESC_NUM_MSK 0xfff

#define R_AX_CH10_TXBD_DESA_L 0x1358
#define B_AX_CH10_TXBD_DESA_L_SH 0
#define B_AX_CH10_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH10_TXBD_DESA_H 0x135C
#define B_AX_CH10_TXBD_DESA_H_SH 0
#define B_AX_CH10_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_CH11_TXBD_DESA_L 0x1360
#define B_AX_CH11_TXBD_DESA_L_SH 0
#define B_AX_CH11_TXBD_DESA_L_MSK 0xffffffffL

#define R_AX_CH11_TXBD_DESA_H 0x1364
#define B_AX_CH11_TXBD_DESA_H_SH 0
#define B_AX_CH11_TXBD_DESA_H_MSK 0xffffffffL

#define R_AX_CH10_TXBD_IDX 0x137C
#define B_AX_CH10_HW_IDX_SH 16
#define B_AX_CH10_HW_IDX_MSK 0xfff
#define B_AX_CH10_HOST_IDX_SH 0
#define B_AX_CH10_HOST_IDX_MSK 0xfff

#define R_AX_CH11_TXBD_IDX 0x1380
#define B_AX_CH11_HW_IDX_SH 16
#define B_AX_CH11_HW_IDX_MSK 0xfff
#define B_AX_CH11_HOST_IDX_SH 0
#define B_AX_CH11_HOST_IDX_MSK 0xfff

#define R_AX_PCIE_HIMR10 0x13B0
#define B_AX_HC10ISR_IND_INT_EN BIT(28)
#define B_AX_TXDMA_CH11_INT_EN BIT(12)
#define B_AX_TXDMA_CH10_INT_EN BIT(11)

#define R_AX_PCIE_HISR10 0x13B4
#define B_AX_HC10ISR_IND_INT BIT(28)
#define B_AX_TXDMA_CH11_INT BIT(12)
#define B_AX_TXDMA_CH10_INT BIT(11)

#define R_AX_PCIE_EXP_CTRL 0x13F0
#define B_AX_EN_CHKDSC_NO_RX_STUCK BIT(20)
#define B_AX_MAX_TAG_NUM_SH 16
#define B_AX_MAX_TAG_NUM_MSK 0x7
#define B_AX_RET_STICKY_RST_N_KEEP_REG_PERST BIT(14)
#define B_AX_RET_NON_STICKY_RST_N_KEEP_REG_PERST BIT(13)
#define B_AX_RET_NON_STICKY_RST_N_KEEP_REG_LINKRST BIT(12)
#define B_AX_EN_LAT_PHYSTATUS BIT(11)
#define B_AX_EN_OLD_WAKE_MODE BIT(10)
#define B_AX_EN_TIMEOUT_T_PCLKACK BIT(9)
#define B_AX_EN_DIS_IO_MEM_EN BIT(8)
#define B_AX_FORCE_REG_CLK_EN BIT(5)
#define B_AX_SIC_EN_FORCE_CLKREQ BIT(4)
#define B_AX_DIS_L1_2_SUS BIT(3)
#define B_AX_IB_EN_FORCE BIT(2)
#define B_AX_PCIE_ACTIVE_FORCE BIT(1)

#define R_AX_PCIE_RX_PREF_ADV 0x13F4
#define B_AX_RXDMA_PREF_ADV_TH_SH 1
#define B_AX_RXDMA_PREF_ADV_TH_MSK 0x3
#define B_AX_RXDMA_PREF_ADV_EN BIT(0)

#define R_AX_PCIE_IO_RCY_M1 0x3100
#define B_AX_PCIE_IO_RCY_P_M1 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_P_M1 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_M1 BIT(3)
#define B_AX_PCIE_IO_RCY_TRIG_M1 BIT(0)

#define R_AX_PCIE_WDT_TIMER_M1 0x3104
#define B_AX_PCIE_WDT_TIMER_M1_SH 0
#define B_AX_PCIE_WDT_TIMER_M1_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_M1 0x3108
#define B_AX_PCIE_PADDR_M1_SH 0
#define B_AX_PCIE_PADDR_M1_MSK 0xffffffffL

#define R_AX_PCIE_IO_RCY_M2 0x310C
#define B_AX_PCIE_IO_RCY_P_M2 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_P_M2 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_M2 BIT(3)
#define B_AX_PCIE_IO_RCY_TRIG_M2 BIT(0)

#define R_AX_PCIE_WDT_TIMER_M2 0x3110
#define B_AX_PCIE_WDT_TIMER_M2_SH 0
#define B_AX_PCIE_WDT_TIMER_M2_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_M2 0x3114
#define B_AX_PCIE_PADDR_M2_SH 0
#define B_AX_PCIE_PADDR_M2_MSK 0xffffffffL

#define R_AX_PCIE_IO_RCY_E0 0x3118
#define B_AX_PCIE_IO_RCY_P_E0 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_P_E0 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_E0 BIT(3)
#define B_AX_PCIE_IO_RCY_TRIG_E0 BIT(0)

#define R_AX_PCIE_WDT_TIMER_E0 0x311C
#define B_AX_PCIE_WDT_TIMER_E0_SH 0
#define B_AX_PCIE_WDT_TIMER_E0_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_E0 0x3120
#define B_AX_PCIE_PADDR_E0_SH 0
#define B_AX_PCIE_PADDR_E0_MSK 0xffffffffL

#define R_AX_PCIE_IO_RCY_S1 0x3124
#define B_AX_PCIE_IO_RCY_RP_S1 BIT(7)
#define B_AX_PCIE_IO_RCY_WP_S1 BIT(6)
#define B_AX_PCIE_IO_RCY_WDT_RP_S1 BIT(5)
#define B_AX_PCIE_IO_RCY_WDT_WP_S1 BIT(4)
#define B_AX_PCIE_IO_RCY_WDT_MODE_S1 BIT(3)
#define B_AX_PCIE_IO_RCY_RTRIG_S1 BIT(1)
#define B_AX_PCIE_IO_RCY_WTRIG_S1 BIT(0)

#define R_AX_PCIE_WDT_TIMER_S1 0x3128
#define B_AX_PCIE_WDT_TIMER_S1_SH 0
#define B_AX_PCIE_WDT_TIMER_S1_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_W_S1 0x312C
#define B_AX_PCIE_PADDR_W_S1_SH 0
#define B_AX_PCIE_PADDR_W_S1_MSK 0xffffffffL

#define R_AX_PCIE_PADDR_R_S1 0x3130
#define B_AX_PCIE_PADDR_R_S1_SH 0
#define B_AX_PCIE_PADDR_R_S1_MSK 0xffffffffL

//
// WL_AX_Reg_Page_SDIO.xls
//

//
// SDIO_Local_Reg_Spec
//

#define R_AX_SDIO_TX_CTRL 0x1000
#define B_AX_SDIO_INT_TIMEOUT_SH 16
#define B_AX_SDIO_INT_TIMEOUT_MSK 0xffff
#define B_AX_IO_ERR_STATUS BIT(15)
#define B_AX_CMD53_W_MIX BIT(14)
#define B_AX_CMD53_TX_FORMAT BIT(13)
#define B_AX_CMD53_R_TIMEOUT_MASK BIT(12)
#define B_AX_CMD53_R_TIMEOUT_UNIT_SH 10
#define B_AX_CMD53_R_TIMEOUT_UNIT_MSK 0x3
#define B_AX_REPLY_ERRCRC_IN_DATA BIT(9)
#define B_AX_EN_CMD53_OVERLAP BIT(8)
#define B_AX_REPLY_ERR_IN_R5 BIT(7)
#define B_AX_R18A_EN BIT(6)
#define B_AX_SDIO_CMD_FORCE_VLD BIT(5)
#define B_AX_INIT_CMD_EN BIT(4)
#define B_AX_RXINT_READ_MASK_DIS BIT(3)
#define B_AX_EN_RXDMA_MASK_INT BIT(2)
#define B_AX_EN_MASK_TIMER BIT(1)
#define B_AX_CMD_ERR_STOP_INT_EN BIT(0)

#define R_AX_SDIO_CTRL 0x1004
#define B_AX_SDIO_DRV_TYPE_D_SH 28
#define B_AX_SDIO_DRV_TYPE_D_MSK 0xf
#define B_AX_SDIO_DRV_TYPE_C_SH 24
#define B_AX_SDIO_DRV_TYPE_C_MSK 0xf
#define B_AX_SDIO_DRV_TYPE_B_SH 20
#define B_AX_SDIO_DRV_TYPE_B_MSK 0xf
#define B_AX_SDIO_DRV_TYPE_A_SH 16
#define B_AX_SDIO_DRV_TYPE_A_MSK 0xf
#define B_AX_SIG_OUT_PH BIT(8)
#define B_AX_CMD11_SEQ_END_DELAY_SH 4
#define B_AX_CMD11_SEQ_END_DELAY_MSK 0xf
#define B_AX_CMD11_SEQ_SAMPLE_INTERVAL_SH 1
#define B_AX_CMD11_SEQ_SAMPLE_INTERVAL_MSK 0x7
#define B_AX_CMD11_SEQ_EN BIT(0)

#define R_AX_SDIO_MONITOR 0x1008
#define B_AX_SDIO_INT_START_SH 0
#define B_AX_SDIO_INT_START_MSK 0xffffffffL

#define R_AX_SDIO_MONITOR_2 0x100C
#define B_AX_CMD53_WT_EN BIT(23)
#define B_AX_SDIO_CLK_MONITOR_SH 21
#define B_AX_SDIO_CLK_MONITOR_MSK 0x3
#define B_AX_SDIO_CLK_CNT_SH 0
#define B_AX_SDIO_CLK_CNT_MSK 0x1fffff

#define R_AX_SDIO_CTRL_2 0x1010
#define B_AX_SDIO_CLK_SMT BIT(1)
#define B_AX_SDIO_DATA_SMT BIT(0)

#define R_AX_SDIO_MONITOR_3 0x1014
#define B_AX_SDIO_USER_DEF_SH 0
#define B_AX_SDIO_USER_DEF_MSK 0xffffffffL

#define R_AX_SDIO_HTSFR_INFO 0x1030
#define B_AX_HTSFR0_SH 0
#define B_AX_HTSFR0_MSK 0xffff

#define R_AX_SDIO_INDIRECT_ADDR 0x1040
#define B_AX_INDIRECT_RDY BIT(31)
#define B_AX_INDIRECT_ADDR_SH 0
#define B_AX_INDIRECT_ADDR_MSK 0x7fffffffL

#define R_AX_SDIO_INDIRECT_DATA 0x1044
#define B_AX_INDIRECT_DATA_SH 0
#define B_AX_INDIRECT_DATA_MSK 0xffffffffL

#define R_AX_SDIO_INDIRECT_CTRL 0x1048
#define B_AX_INDIRECT_REG_R BIT(3)
#define B_AX_INDIRECT_REG_W BIT(2)
#define B_AX_INDIRECT_REG_SIZE_SH 0
#define B_AX_INDIRECT_REG_SIZE_MSK 0x3

#define R_AX_SDIO_HRPWM1 0x1080
#define B_AX_HRPWM_SH 16
#define B_AX_HRPWM_MSK 0xffff

#define R_AX_SDIO_BUS_CTRL 0x1084
#define B_AX_SPI_PHASE BIT(21)
#define B_AX_INTR_CTRL BIT(20)
#define B_AX_SDIO_VOLTAGE BIT(19)
#define B_AX_BYPASS_INIT BIT(18)
#define B_AX_HCI_RESUME_RDY BIT(17)
#define B_AX_HCI_SUS_REQ BIT(16)
#define B_AX_CMD53_RDATA_EARLY BIT(14)
#define B_AX_HISR_W_CLR_EN BIT(13)
#define B_AX_INT_MASK_DIS BIT(12)
#define B_AX_PAD_CLK_XHGE_EN BIT(11)
#define B_AX_INTER_CLK_EN BIT(10)
#define B_AX_EN_RPT_TXCRC BIT(9)
#define B_AX_DIS_RXDMA_STS BIT(8)

#define R_AX_SDIO_RESPONSE_TIMER 0x1088
#define B_AX_SDIO_CMD_CRC_SH 16
#define B_AX_SDIO_CMD_CRC_MSK 0xff
#define B_AX_CMDIN_2RESP_TIMER_SH 0
#define B_AX_CMDIN_2RESP_TIMER_MSK 0xffff

#define R_AX_SDIO_HSISR 0x1090
#define B_AX_HISR_MASK BIT(8)
#define B_AX_DRV_WLAN_INT_CLR BIT(1)
#define B_AX_DRV_WLAN_INT BIT(0)

#define R_AX_SDIO_EXTEND_RBLOK_GAP 0x1094
#define B_AX_EXTEND_RBLOCK_GAP_SH 0
#define B_AX_EXTEND_RBLOCK_GAP_MSK 0x3f

#define R_AX_SDIO_DIOERR_RPT 0x10C0
#define B_AX_DATA_CRC_ERR_CNT_SH 24
#define B_AX_DATA_CRC_ERR_CNT_MSK 0xff
#define B_AX_CMD_CRC_ERR_CNT_SH 16
#define B_AX_CMD_CRC_ERR_CNT_MSK 0xff
#define B_AX_SDIO_PAGE_ERR BIT(0)

#define R_AX_SDIO_CMD_ERR_CONTENT_L 0x10C4
#define B_AX_SDIO_CMD_ERR_CONTENT_L_SH 0
#define B_AX_SDIO_CMD_ERR_CONTENT_L_MSK 0xffffffffL

#define R_AX_SDIO_CMD_ERR_CONTENT 0x10C8
#define B_AX_SDIO_DATA_CRC_SH 16
#define B_AX_SDIO_DATA_CRC_MSK 0xffff
#define B_AX_FN1_WDATA_TO_FLG BIT(15)
#define B_AX_FN1_WDATA_LEN_SHORT_FLG BIT(14)
#define B_AX_D3_CRC_ERR BIT(12)
#define B_AX_D2_CRC_ERR BIT(11)
#define B_AX_D1_CRC_ERR BIT(10)
#define B_AX_D0_CRC_ERR BIT(9)
#define B_AX_CMD_CRC_ERR BIT(8)
#define B_AX_SDIO_CMD_ERR_CONTENT_H_SH 0
#define B_AX_SDIO_CMD_ERR_CONTENT_H_MSK 0xff

//#define R_AX_SDIO_TRANS_FIFO_STATUS 0x10CC
//#define B_AX_TRANS_FIFO_UNDERFLOW BIT(1)
//#define B_AX_TRANS_FIFO_OVERFLOW BIT(0)
#define R_AX_SDIO_TXDMA_FIFO_STATUS 0x10CC
#define B_AX_TXDMA_FIFO_UNDERFLOW BIT(4)
#define B_AX_TXDMA_FIFO_OVERFLOW BIT(3)

#define R_AX_SDIO_HIMR 0x1100
#define B_AX_SDIO_BT_INT_EN BIT(24)
#define B_AX_SDIO_HS0ISR_IND_EN BIT(16)
#define B_AX_SDIO_HC10ISR_IND_EN BIT(9)
#define B_AX_SDIO_HC00ISR_IND_EN BIT(8)
#define B_AX_SDIO_HD1ISR_IND_EN BIT(3)
#define B_AX_SDIO_HD0ISR_IND_EN BIT(2)
#define B_AX_SDIO_AVAL_INT_EN BIT(1)
#define B_AX_RX_REQUEST_INT_EN BIT(0)

#define R_AX_SDIO_HISR 0x1104
#define B_AX_SDIO_BT_INT BIT(24)
#define B_AX_SDIO_HS0ISR_IND BIT(16)
#define B_AX_SDIO_HC10ISR_IND BIT(9)
#define B_AX_SDIO_HC00ISR_IND BIT(8)
#define B_AX_SDIO_HD1ISR_IND BIT(3)
#define B_AX_SDIO_HD0ISR_IND BIT(2)
#define B_AX_SDIO_AVAL_INT BIT(1)
#define B_AX_RX_REQUEST_INT BIT(0)

#define R_AX_SDIO_RX_REQ_LEN 0x1108
#define B_AX_RX_REQ_LEN_SH 0
#define B_AX_RX_REQ_LEN_MSK 0x3ffff

#define R_AX_SDIO_AVAL_INTRPT_STAT 0x110C
#define B_AX_SDIO_ACH11_INTRPT_STAT BIT(11)
#define B_AX_SDIO_ACH10_INTRPT_STAT BIT(10)
#define B_AX_SDIO_ACH9_INTRPT_STAT BIT(9)
#define B_AX_SDIO_ACH8_INTRPT_STAT BIT(8)
#define B_AX_SDIO_ACH7_INTRPT_STAT BIT(7)
#define B_AX_SDIO_ACH6_INTRPT_STAT BIT(6)
#define B_AX_SDIO_ACH5_INTRPT_STAT BIT(5)
#define B_AX_SDIO_ACH4_INTRPT_STAT BIT(4)
#define B_AX_SDIO_ACH3_INTRPT_STAT BIT(3)
#define B_AX_SDIO_ACH2_INTRPT_STAT BIT(2)
#define B_AX_SDIO_ACH1_INTRPT_STAT BIT(1)
#define B_AX_SDIO_ACH0_INTRPT_STAT BIT(0)

#define R_AX_SDIO_TXPG_WP 0x1110
#define B_AX_SDIO_ACH12_AVAL_PG_SH 16
#define B_AX_SDIO_ACH12_AVAL_PG_MSK 0x1fff
#define B_AX_SDIO_WP_AVAL_PG_SH 0
#define B_AX_SDIO_WP_AVAL_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_0 0x1114
#define B_AX_SDIO_ACH1_USE_PG_SH 16
#define B_AX_SDIO_ACH1_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH0_USE_PG_SH 0
#define B_AX_SDIO_ACH0_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_1 0x1118
#define B_AX_SDIO_ACH3_USE_PG_SH 16
#define B_AX_SDIO_ACH3_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH2_USE_PG_SH 0
#define B_AX_SDIO_ACH2_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_2 0x111C
#define B_AX_SDIO_ACH5_USE_PG_SH 16
#define B_AX_SDIO_ACH5_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH4_USE_PG_SH 0
#define B_AX_SDIO_ACH4_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_3 0x1120
#define B_AX_SDIO_ACH7_USE_PG_SH 16
#define B_AX_SDIO_ACH7_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH6_USE_PG_SH 0
#define B_AX_SDIO_ACH6_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_4 0x1124
#define B_AX_SDIO_ACH9_USE_PG_SH 16
#define B_AX_SDIO_ACH9_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH8_USE_PG_SH 0
#define B_AX_SDIO_ACH8_USE_PG_MSK 0x1fff

#define R_AX_SDIO_TXPG_5 0x1128
#define B_AX_SDIO_ACH11_USE_PG_SH 16
#define B_AX_SDIO_ACH11_USE_PG_MSK 0x1fff
#define B_AX_SDIO_ACH10_USE_PG_SH 0
#define B_AX_SDIO_ACH10_USE_PG_MSK 0x1fff

//
// WL_AX_Reg_RXI300.xls
//

//
// RXI300
//

#define R_AX_RXI300_NAME 0x0000
#define B_AX_RXI300_NAME_SH 0
#define B_AX_RXI300_NAME_MSK 0xffffffffL

#define R_AX_RXI300_VER 0x0004
#define B_AX_RXI300_VER_SH 0
#define B_AX_RXI300_VER_MSK 0xffffffffL

#define R_AX_RXI300_REV 0x0008
#define B_AX_RXI300_REV_SH 0
#define B_AX_RXI300_REV_MSK 0xffffffffL

#define R_AX_RXI300_INST 0x000C
#define B_AX_RXI300_INST_SH 0
#define B_AX_RXI300_INST_MSK 0xffffffffL

#define R_AX_RXI300_IMPL_Y 0x0010
#define B_AX_RXI300_IMPL_Y_SH 0
#define B_AX_RXI300_IMPL_Y_MSK 0xffffffffL

#define R_AX_RXI300_IMPL_D 0x0014
#define B_AX_RXI300_IMPL_D_SH 0
#define B_AX_RXI300_IMPL_D_MSK 0xffffffffL

#define R_AX_RXI300_DEV 0x0018
#define B_AX_RXI300_DEV_SH 0
#define B_AX_RXI300_DEV_MSK 0xffffffffL

#define R_AX_RXI300_PRO_NUM 0x001C
#define B_AX_RXI300_PRO_NUM_SH 0
#define B_AX_RXI300_PRO_NUM_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_PLD0 0x0200
#define B_AX_ERR_BSTINDEX_SH 24
#define B_AX_ERR_BSTINDEX_MSK 0xff
#define B_AX_ERR_BSTLEN_SH 16
#define B_AX_ERR_BSTLEN_MSK 0xff
#define B_AX_ERR_BSTTYPE_SH 11
#define B_AX_ERR_BSTTYPE_MSK 0x7
#define B_AX_ERR_CMD_SH 8
#define B_AX_ERR_CMD_MSK 0x7
#define B_AX_ERR_SRC_SH 0
#define B_AX_ERR_SRC_MSK 0xff

#define R_AX_RXI300_ELR_0_PLD1 0x0204
#define B_AX_ERR_MREQINFO_SH 23
#define B_AX_ERR_MREQINFO_MSK 0x1ff
#define B_AX_ERR_SIZE_SH 16
#define B_AX_ERR_SIZE_MSK 0x7
#define B_AX_ERR_BYTEEN_SH 0
#define B_AX_ERR_BYTEEN_MSK 0xffff

#define R_AX_RXI300_ELR_0_ID 0x0208
#define B_AX_ERR_ID_SH 0
#define B_AX_ERR_ID_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_ADR0 0x020C
#define B_AX_ERR_ADR0_SH 0
#define B_AX_ERR_ADR0_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_ADR1 0x0210
#define B_AX_ERR_ADR1_SH 0
#define B_AX_ERR_ADR1_MSK 0xffffffffL

#define R_AX_RXI300_ELR_0_CODE 0x0230
#define B_AX_ELR_CODE_SH 0
#define B_AX_ELR_CODE_MSK 0xff

#define R_AX_RXI300_ELR_0_INTR_CLR 0x023C
#define B_AX_ELR_INTR_CLR BIT(0)

#define R_AX_RXI300_ICG_CTRL0 0x0300
#define B_AX_RXI300_ICG_CTRL0_SH 0
#define B_AX_RXI300_ICG_CTRL0_MSK 0xffffffffL

#define R_AX_RXI300_ICG_CTRL1 0x0304
#define B_AX_RXI300_ICG_CTRL1_SH 0
#define B_AX_RXI300_ICG_CTRL1_MSK 0xffffffffL

#define R_AX_RXI300_TIME_MON 0x0308
#define B_AX_RXI300_TM_AXI_APB_BBRF_RST BIT(26)
#define B_AX_RXI300_TM_AXI_APB_SA_RST BIT(25)
#define B_AX_RXI300_TM_AXI2AHB_RST BIT(24)
#define B_AX_RXI300_TM_AXI_APB_BBRF_EN BIT(18)
#define B_AX_RXI300_TM_AXI_APB_SA_EN BIT(17)
#define B_AX_RXI300_TM_AXI2AHB_EN BIT(16)
#define B_AX_RXI300_TM_GRADE_SH 8
#define B_AX_RXI300_TM_GRADE_MSK 0xf
#define B_AX_RXI300_TM_TRSH_SH 0
#define B_AX_RXI300_TM_TRSH_MSK 0xff

#define R_AX_RXI300_ICG_STAT0 0x0320
#define B_AX_RXI300_ICG_STAT0_SH 0
#define B_AX_RXI300_ICG_STAT0_MSK 0xffffffffL

#define R_AX_RXI300_ICG_STAT1 0x0324
#define B_AX_RXI300_ICG_STAT1_SH 0
#define B_AX_RXI300_ICG_STAT1_MSK 0xffffffffL

//
// WL_AX_Reg_SPIC.xls
//

//
// SPIC
//

#define R_AX_SPIC_CTRLR0 0x0000
#define B_AX_PRM_2ND_PHASE BIT(31)
#define B_AX_DDR_EN_SH 28
#define B_AX_DDR_EN_MSK 0x7
#define B_AX_CK_MTIMES_SH 23
#define B_AX_CK_MTIMES_MSK 0x1f
#define B_AX_FAST_RD BIT(22)
#define B_AX_CMD_CH_SH 20
#define B_AX_CMD_CH_MSK 0x3
#define B_AX_DATA_CH_SH 18
#define B_AX_DATA_CH_MSK 0x3
#define B_AX_ADDR_CH_SH 16
#define B_AX_ADDR_CH_MSK 0x3
#define B_AX_TMOD_SH 8
#define B_AX_TMOD_MSK 0x3
#define B_AX_SCPOL BIT(7)
#define B_AX_SCPH BIT(6)

#define R_AX_SPIC_CTRLR1 0x0004
#define B_AX_NDF_SH 0
#define B_AX_NDF_MSK 0xffff

#define R_AX_SPIC_SSIENR 0x0008
#define B_AX_PGM_RST_TEST_EN BIT(4)
#define B_AX_ATCK_CMD BIT(1)
#define B_AX_SPIC_FUNC_EN BIT(0)

#define R_AX_SPIC_SER 0x0010
#define B_AX_SER_SH 0
#define B_AX_SER_MSK 0xffffffffL

#define R_AX_SPIC_BAUDR 0x0014
#define B_AX_SCKDV_SH 0
#define B_AX_SCKDV_MSK 0xfff

#define R_AX_SPIC_TXFTLR 0x0018
#define B_AX_TFT_SH 0
#define B_AX_TFT_MSK 0xffffffffL

#define R_AX_SPIC_RXFTLR 0x001C
#define B_AX_RFT_SH 0
#define B_AX_RFT_MSK 0xffffffffL

#define R_AX_SPIC_TXFLR 0x0020
#define B_AX_TXFLR_SH 0
#define B_AX_TXFLR_MSK 0xffffffffL

#define R_AX_SPIC_RXFLR 0x0024
#define B_AX_RXFLR_SH 0
#define B_AX_RXFLR_MSK 0xffffffffL

#define R_AX_SPIC_SR 0x0028
#define B_AX_BOOT_FIN BIT(7)
#define B_AX_DCOL BIT(6)
#define B_AX_TXE BIT(5)
#define B_AX_RFF BIT(4)
#define B_AX_RFNE BIT(3)
#define B_AX_TFE BIT(2)
#define B_AX_TFNF BIT(1)
#define B_AX_BUSY BIT(0)

#define R_AX_SPIC_IMR 0x002C
#define B_AX_ACSIM BIT(11)
#define B_AX_RXSIM BIT(10)
#define B_AX_TXSIM BIT(9)
#define B_AX_ACEIM BIT(8)
#define B_AX_BYEIM BIT(7)
#define B_AX_WBEIM BIT(6)
#define B_AX_FSEIM BIT(5)
#define B_AX_RXFIM BIT(4)
#define B_AX_RXOIM BIT(3)
#define B_AX_RXUIM BIT(2)
#define B_AX_TXOIM BIT(1)
#define B_AX_TXEIM BIT(0)

#define R_AX_SPIC_ISR 0x0030
#define B_AX_ACSIS BIT(11)
#define B_AX_RXSIS BIT(10)
#define B_AX_TXSIS BIT(9)
#define B_AX_ACEIS BIT(8)
#define B_AX_BYEIS BIT(7)
#define B_AX_WBEIS BIT(6)
#define B_AX_FSEIS BIT(5)
#define B_AX_RXFIS BIT(4)
#define B_AX_RXOIS BIT(3)
#define B_AX_RXUIS BIT(2)
#define B_AX_TXOIS BIT(1)
#define B_AX_TXEIS BIT(0)

#define R_AX_SPIC_RISR 0x0034
#define B_AX_ACSIR BIT(11)
#define B_AX_RXSIR BIT(10)
#define B_AX_TXSIR BIT(9)
#define B_AX_ACEIR BIT(8)
#define B_AX_BYEIR BIT(7)
#define B_AX_WBEIR BIT(6)
#define B_AX_FSEIR BIT(5)
#define B_AX_RXFIR BIT(4)
#define B_AX_RXOIR BIT(3)
#define B_AX_RXUIR BIT(2)
#define B_AX_TXOIR BIT(1)
#define B_AX_TXEIR BIT(0)

#define R_AX_SPIC_TXOICR 0x0038
#define B_AX_TXOICR BIT(0)

#define R_AX_SPIC_RXOICR 0x003C
#define B_AX_RXOICR BIT(0)

#define R_AX_SPIC_RXUICR 0x0040
#define B_AX_RXUICR BIT(0)

#define R_AX_SPIC_MSTICR 0x0044
#define B_AX_MSTICR BIT(0)

#define R_AX_SPIC_ICR 0x0048
#define B_AX_ICR BIT(0)

#define R_AX_SPIC_DMACR 0x004C
#define B_AX_TX_DMAC_EN BIT(1)
#define B_AX_RX_DMAC_EN BIT(0)

#define R_AX_SPIC_DMATDLR 0x0050
#define B_AX_DMATDL_SH 0
#define B_AX_DMATDL_MSK 0xffffffffL

#define R_AX_SPIC_DMARDLR 0x0054
#define B_AX_DMARDL_SH 0
#define B_AX_DMARDL_MSK 0xffffffffL

#define R_AX_SPIC_IDR 0x0058
#define B_AX_IDCODE_SH 0
#define B_AX_IDCODE_MSK 0xffffffffL

#define R_AX_SPIC_VERSION 0x005C
#define B_AX_SPIC_VERSION_SH 0
#define B_AX_SPIC_VERSION_MSK 0xffffffffL

#define R_AX_SPIC_DR_WORD 0x0060
#define B_AX_DR_WORD_SH 0
#define B_AX_DR_WORD_MSK 0xffffffffL

#define R_AX_SPIC_DR_HALF_WORD 0x0060
#define B_AX_DR_HALF_WORD_SH 0
#define B_AX_DR_HALF_WORD_MSK 0xffff

#define R_AX_SPIC_DR_BYTE 0x0060
#define B_AX_DR_BYTE_SH 0
#define B_AX_DR_BYTE_MSK 0xff

#define R_AX_SPIC_READ_FAST_SINGLE 0x00E0
#define B_AX_FRD_CMD_SH 0
#define B_AX_FRD_CMD_MSK 0xffff

#define R_AX_SPIC_READ_DUAL_DATA 0x00E4
#define B_AX_RD_DUAL_O_CMD_SH 0
#define B_AX_RD_DUAL_O_CMD_MSK 0xff

#define R_AX_SPIC_READ_DUAL_ADDR_DATA 0x00E8
#define B_AX_RD_DUAL_IO_CMD_SH 0
#define B_AX_RD_DUAL_IO_CMD_MSK 0xff

#define R_AX_SPIC_READ_QUAD_DATA 0x00EC
#define B_AX_RD_QUAD_O_CMD_SH 0
#define B_AX_RD_QUAD_O_CMD_MSK 0xff

#define R_AX_SPIC_READ_QUAD_ADDR_DATA 0x00F0
#define B_AX_SPIC_PRM_VALUE_SH 16
#define B_AX_SPIC_PRM_VALUE_MSK 0xff
#define B_AX_RD_QUAD_IO_CMD_SH 0
#define B_AX_RD_QUAD_IO_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_SINGLE 0x00F4
#define B_AX_WR_CMD_SH 0
#define B_AX_WR_CMD_MSK 0xffff

#define R_AX_SPIC_WRITE_DUAL_DATA 0x00F8
#define B_AX_WR_DUAL_I_CMD_SH 0
#define B_AX_WR_DUAL_I_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_DUAL_ADDR_DATA 0x00FC
#define B_AX_SPIC_WR_DUAL_II_CMD_SH 0
#define B_AX_SPIC_WR_DUAL_II_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_QUAD_DATA 0x0100
#define B_AX_WR_QUAD_I_CMD_SH 0
#define B_AX_WR_QUAD_I_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_QUAD_ADDR_DATA 0x0104
#define B_AX_WR_QUAD_II_CMD_SH 0
#define B_AX_WR_QUAD_II_CMD_MSK 0xff

#define R_AX_SPIC_WRITE_ENABLE 0x0108
#define B_AX_WR_EN_CMD_SH 0
#define B_AX_WR_EN_CMD_MSK 0xffff

#define R_AX_SPIC_READ_STATUS 0x010C
#define B_AX_ADDR_EN BIT(31)
#define B_AX_ADDR_LEN_SH 29
#define B_AX_ADDR_LEN_MSK 0x3
#define B_AX_ADDR_SEL BIT(28)
#define B_AX_INTERVAL_EN BIT(27)
#define B_AX_RD_ST_CMD_SH 0
#define B_AX_RD_ST_CMD_MSK 0xffff

#define R_AX_SPIC_CTRLR2 0x0110
#define B_AX_CS_ACTIVE_HOLD_SH 12
#define B_AX_CS_ACTIVE_HOLD_MSK 0x3
#define B_AX_RX_FIFO_ENTRY_SH 8
#define B_AX_RX_FIFO_ENTRY_MSK 0xf
#define B_AX_FIFO_ENTRY_SH 4
#define B_AX_FIFO_ENTRY_MSK 0xf
#define B_AX_SEQ_EN BIT(3)
#define B_AX_WPN_DNUM BIT(2)
#define B_AX_WPN_SET BIT(1)
#define B_AX_SO_DNUM BIT(0)

#define R_AX_SPIC_FBAUDR 0x0114
#define B_AX_FSCKDV_SH 0
#define B_AX_FSCKDV_MSK 0xfff

#define R_AX_SPIC_ADDR_LENGTH 0x0118
#define B_AX_ADDR_PHASE_LENGTH_SH 0
#define B_AX_ADDR_PHASE_LENGTH_MSK 0x7

#define R_AX_SPIC_AUTO_LENGTH 0x011C
#define B_AX_ADDR_CS_H_WR_DUM_LEN_SH 28
#define B_AX_ADDR_CS_H_WR_DUM_LEN_MSK 0xf
#define B_AX_ADDR_CS_H_RD_DUM_LEN_SH 26
#define B_AX_ADDR_CS_H_RD_DUM_LEN_MSK 0x3
#define B_AX_ADDR_AUTO_DUM_LEN_SH 18
#define B_AX_ADDR_AUTO_DUM_LEN_MSK 0xff
#define B_AX_ADDR_AUTO_ADDR_LENGTH_SH 16
#define B_AX_ADDR_AUTO_ADDR_LENGTH_MSK 0x3
#define B_AX_ADDR_IN_PHYSICAL_CYC_SH 12
#define B_AX_ADDR_IN_PHYSICAL_CYC_MSK 0xf

#define R_AX_SPIC_VALID_CMD 0x0120
#define B_AX_ADDR_SEQ_TRANS_EN BIT(14)
#define B_AX_ADDR_CTRLR0_CH BIT(12)
#define B_AX_ADDR_PRM_EN BIT(11)
#define B_AX_ADDR_WR_BLOCKING BIT(9)
#define B_AX_ADDR_WR_QUAD_II BIT(8)
#define B_AX_ADDR_WR_QUAD_I BIT(7)
#define B_AX_ADDR_WR_DUAL_II BIT(6)
#define B_AX_ADDR_WR_DUAL_I BIT(5)
#define B_AX_ADDR_RD_QUAD_IO BIT(4)
#define B_AX_ADDR_RD_QUAD_O BIT(3)
#define B_AX_ADDR_RD_DUAL_IO BIT(2)
#define B_AX_ADDR_RD_DUAL_I BIT(1)
#define B_AX_ADDR_FRD_SINGEL BIT(0)

#define R_AX_SPIC_FLASH_SIZE 0x0124
#define B_AX_FLASH_SIZE_SH 0
#define B_AX_FLASH_SIZE_MSK 0xfff

#define R_AX_SPIC_FLUSH_FIFO 0x0128
#define B_AX_FLUSH_PGM_RST_FIFO BIT(1)
#define B_AX_FLUSH_FIFO BIT(0)

#define R_AX_SPIC_PGM_RST_FIFO 0x0140
#define B_AX_PGM_RST_FIFO_SH 0
#define B_AX_PGM_RST_FIFO_MSK 0xffff

//
// WL_AX_Reg_UART.xls
//

//
// UART
//

#define R_AX_UART_RBR 0x0000
#define B_AX_RBR_SH 0
#define B_AX_RBR_MSK 0xff

#define R_AX_UART_THR 0x0000
#define B_AX_THR_SH 0
#define B_AX_THR_MSK 0xff

#define R_AX_UART_DLH 0x0004
#define B_AX_DLH_SH 0
#define B_AX_DLH_MSK 0xff

#define R_AX_UART_DLL 0x0000
#define B_AX_DLL_SH 0
#define B_AX_DLL_MSK 0xff

#define R_AX_UART_IER 0x0004
#define B_AX_IER_PTIME BIT(7)
#define B_AX_IER_EDSSI BIT(3)
#define B_AX_IER_ELSI BIT(2)
#define B_AX_IER_ETBEI BIT(1)
#define B_AX_IER_ERBFI BIT(0)

#define R_AX_UART_IIR 0x0008
#define B_AX_FIFOSE_SH 6
#define B_AX_FIFOSE_MSK 0x3
#define B_AX_IID_SH 0
#define B_AX_IID_MSK 0xf

#define R_AX_UART_FCR 0x0008
#define B_AX_RT_SH 6
#define B_AX_RT_MSK 0x3
#define B_AX_TET_SH 4
#define B_AX_TET_MSK 0x3
#define B_AX_DMAM BIT(3)
#define B_AX_XFIFOR BIT(2)
#define B_AX_RFIFOR BIT(1)
#define B_AX_FIFOE BIT(0)

#define R_AX_UART_LCR 0x000C
#define B_AX_DLAB BIT(7)
#define B_AX_BC BIT(6)
#define B_AX_EPS BIT(4)
#define B_AX_PEN BIT(3)
#define B_AX_STOP BIT(2)
#define B_AX_DLS_SH 0
#define B_AX_DLS_MSK 0x3

#define R_AX_UART_MCR 0x0010
#define B_AX_SIRE BIT(6)
#define B_AX_AFCE BIT(5)
#define B_AX_LB BIT(4)
#define B_AX_OUT2 BIT(3)
#define B_AX_OUT1 BIT(2)
#define B_AX_RTS BIT(1)
#define B_AX_DTR BIT(0)

#define R_AX_UART_LSR 0x0014
#define B_AX_RFE BIT(7)
#define B_AX_TEMT BIT(6)
#define B_AX_THRE BIT(5)
#define B_AX_BI BIT(4)
#define B_AX_FE BIT(3)
#define B_AX_PE BIT(2)
#define B_AX_OE BIT(1)
#define B_AX_DR BIT(0)

#define R_AX_UART_MSR 0x0018
#define B_AX_DCD BIT(7)
#define B_AX_RI BIT(6)
#define B_AX_DSR BIT(5)
#define B_AX_CTS BIT(4)
#define B_AX_DDCD BIT(3)
#define B_AX_TERI BIT(2)
#define B_AX_DDSR BIT(1)
#define B_AX_DCTS BIT(0)

#define R_AX_UART_SCR 0x001C
#define B_AX_SCR_SH 0
#define B_AX_SCR_MSK 0xff

#define R_AX_UART_LPDLL 0x001C
#define B_AX_LPDLL_SH 0
#define B_AX_LPDLL_MSK 0xff

#define R_AX_UART_LPDLH 0x001C
#define B_AX_LPDLH_SH 0
#define B_AX_LPDLH_MSK 0xff

#define R_AX_UART_FAR 0x0070
#define B_AX_FAR BIT(0)

#define R_AX_UART_TFR 0x0074
#define B_AX_TFR_SH 0
#define B_AX_TFR_MSK 0xff

#define R_AX_UART_RFW 0x0078
#define B_AX_RFFE BIT(9)
#define B_AX_RFPE BIT(8)
#define B_AX_RFWD_SH 0
#define B_AX_RFWD_MSK 0xff

#define R_AX_UART_USR 0x007C
#define B_AX_RFF BIT(4)
#define B_AX_RFNE BIT(3)
#define B_AX_TFE BIT(2)
#define B_AX_TFNF BIT(1)
#define B_AX_BUSY BIT(0)

#define R_AX_UART_TFL 0x0080
#define B_AX_TFL_SH 0
#define B_AX_TFL_MSK 0xffffffffL

#define R_AX_UART_RFL 0x0084
#define B_AX_RFL_SH 0
#define B_AX_RFL_MSK 0xffffffffL

#define R_AX_UART_SRR 0x0088
#define B_AX_XFR BIT(2)
#define B_AX_RFR BIT(1)
#define B_AX_UR BIT(0)

#define R_AX_UART_HTX 0x00A4
#define B_AX_HTX BIT(0)

#define R_AX_UART_DMASA 0x00A8
#define B_AX_DMASA BIT(0)

#define R_AX_UART_CPR 0x00F4
#define B_AX_FIFO_MODE_SH 16
#define B_AX_FIFO_MODE_MSK 0xff
#define B_AX_DMA_EXTRA BIT(13)
#define B_AX_UART_ADD_ENCODED_PARAMS BIT(12)
#define B_AX_SHADOW BIT(11)
#define B_AX_FIFO_STAT BIT(10)
#define B_AX_FIFO_ACCESS BIT(9)
#define B_AX_ADDITIONAL_FEAT BIT(8)
#define B_AX_SIR_LP_MODE BIT(7)
#define B_AX_SIR_MODE BIT(6)
#define B_AX_THRE_MODE BIT(5)
#define B_AX_AFCE_MODE BIT(4)
#define B_AX_APB_DATA_WIDTH_SH 0
#define B_AX_APB_DATA_WIDTH_MSK 0x3

#define R_AX_UART_UCV 0x00F8
#define B_AX_UCV_SH 0
#define B_AX_UCV_MSK 0xffffffffL

#define R_AX_UART_CTR 0x00FC
#define B_AX_PID_SH 0
#define B_AX_PID_MSK 0xffffffffL

//
// WL_AX_Reg_USB.xlsx
//

//
// USB_REG
//

#define R_AX_USB2_MAC_0 0x1000
#define B_AX_TOUT_DELAY_FS_SH 24
#define B_AX_TOUT_DELAY_FS_MSK 0xff
#define B_AX_TOUT_DELAY_HS_SH 16
#define B_AX_TOUT_DELAY_HS_MSK 0xff
#define B_AX_TOUT_DIS BIT(15)
#define B_AX_CRC_CHK_OPT BIT(14)
#define B_AX_FORCE_PCERST BIT(13)
#define B_AX_FORCE_TOGL BIT(12)
#define B_AX_FORCE_TOGLSEL BIT(11)
#define B_AX_FORCE_PIDSW BIT(10)
#define B_AX_FORCE_PCE_IN BIT(9)
#define B_AX_FORCE_PCE_OUT BIT(8)
#define B_AX_PID_FORCE_SH 0
#define B_AX_PID_FORCE_MSK 0xff

#define R_AX_USB2_MAC_1 0x1004
#define B_AX_FORCE_PCE_CMD BIT(31)

#define R_AX_USB2_LINK_PORT 0x1008
#define B_AX_R_HOST_PWR_CTRL BIT(23)
#define B_AX_R_USB2_CLR_TXVLD BIT(22)
#define B_AX_R_USB2_SE0 BIT(21)
#define B_AX_HOST_RESUME_EDGE_EN BIT(20)
#define B_AX_RESUME_SEL_SH 16
#define B_AX_RESUME_SEL_MSK 0xf
#define B_AX_DELAY_CHIRP_K_SH 14
#define B_AX_DELAY_CHIRP_K_MSK 0x3
#define B_AX_FORCE_TXVLD1 BIT(13)
#define B_AX_FORCE_TXVLD0 BIT(12)
#define B_AX_DORCE_DAT1 BIT(11)
#define B_AX_FORCE_DAT0 BIT(10)
#define B_AX_LS_TEST BIT(9)
#define B_AX_LS_CHANGE BIT(8)
#define B_AX_FORCE_HS_SW BIT(7)
#define B_AX_FORCE_FS_SW BIT(6)
#define B_AX_FORCE_HSXCVR BIT(5)
#define B_AX_FORCE_FSXCVR BIT(4)
#define B_AX_FORCE_HSTERM BIT(3)
#define B_AX_FORCE_FSTERM BIT(2)
#define B_AX_FORCE_NORM_SW BIT(1)
#define B_AX_FORCE_DBSN BIT(0)

#define R_AX_USB2_LPM_0 0x1010
#define B_AX_USBPHY_PLL_ALIVE BIT(17)
#define B_AX_USB_LPM_MAX_EN BIT(16)
#define B_AX_USB_LPM_MIN_EN BIT(15)
#define B_AX_BESL_EN BIT(14)
#define B_AX_USB_LPM_NYET_EN BIT(13)
#define B_AX_USB_LPM_MAX_ACK BIT(12)
#define B_AX_USB_LPM_EN BIT(11)
#define B_AX_USB2_SUSB BIT(10)
#define B_AX_LPM_PLL_ALIVE BIT(9)
#define B_AX_USB_LPS_OUT BIT(8)
#define B_AX_USB_LPM_WAKEUP_EN BIT(6)
#define B_AX_NEVER_SUSPEND BIT(5)
#define B_AX_SUSPND_EN BIT(4)
#define B_AX_WAKEUP_EN BIT(3)
#define B_AX_USB_SUS_WAKEUP_EN BIT(2)
#define B_AX_RESUME_SND BIT(1)
#define B_AX_CONNECT_EN BIT(0)

#define R_AX_USB2_LPM_1 0x1014
#define B_AX_USB_LPM_MAX_SH 20
#define B_AX_USB_LPM_MAX_MSK 0xf
#define B_AX_USB_LPM_MIN_SH 16
#define B_AX_USB_LPM_MIN_MSK 0xf
#define B_AX_R_WAKE_HOST_WT_H_SH 8
#define B_AX_R_WAKE_HOST_WT_H_MSK 0xff
#define B_AX_R_WAKE_HOST_WT_L_SH 0
#define B_AX_R_WAKE_HOST_WT_L_MSK 0xff

#define R_AX_USB2_MACRO_TEST_MODE 0x1018
#define B_AX_TXRDY_SLB_SEL BIT(14)
#define B_AX_SLB_EN BIT(13)
#define B_AX_SLB_RST BIT(12)
#define B_AX_SLB_FAIL BIT(11)
#define B_AX_SLB_DONE BIT(10)
#define B_AX_SLB_PS1_SW_SH 8
#define B_AX_SLB_PS1_SW_MSK 0x3
#define B_AX_PHY_LOOP_TEST BIT(3)
#define B_AX_USBTMOD_SH 0
#define B_AX_USBTMOD_MSK 0x7

#define R_AX_USB2_PHY_REG_0 0x1020
#define B_AX_USB2PHY_REG_EN BIT(17)
#define B_AX_VLPADM BIT(16)
#define B_AX_VSTATUS_IN_SH 8
#define B_AX_VSTATUS_IN_MSK 0xff
#define B_AX_VCONTROL_SH 0
#define B_AX_VCONTROL_MSK 0xff

#define R_AX_USB2_PHY_REG_1 0x1024
#define B_AX_USB2PHY_DELAY_SH 8
#define B_AX_USB2PHY_DELAY_MSK 0xff
#define B_AX_VSTATUS_OUT_SH 0
#define B_AX_VSTATUS_OUT_MSK 0xff

#define R_AX_USB2_PHY_REG_2 0x1028
#define B_AX_USB2_PHY_P0_E3_SH 24
#define B_AX_USB2_PHY_P0_E3_MSK 0xff
#define B_AX_USB2_PHY_P0_E2_SH 16
#define B_AX_USB2_PHY_P0_E2_MSK 0xff
#define B_AX_USB2_PHY_P0_E1_SH 8
#define B_AX_USB2_PHY_P0_E1_MSK 0xff
#define B_AX_USB2_PHY_P0_E0_SH 0
#define B_AX_USB2_PHY_P0_E0_MSK 0xff

#define R_AX_USB2_PHY_REG_3 0x102C
#define B_AX_USB2_PHY_P0_E7_SH 24
#define B_AX_USB2_PHY_P0_E7_MSK 0xff
#define B_AX_USB2_PHY_P0_E6_SH 16
#define B_AX_USB2_PHY_P0_E6_MSK 0xff
#define B_AX_USB2_PHY_P0_E5_SH 8
#define B_AX_USB2_PHY_P0_E5_MSK 0xff
#define B_AX_USB2_PHY_P0_E4_SH 0
#define B_AX_USB2_PHY_P0_E4_MSK 0xff

#define R_AX_USB2_PHY_REG_4 0x1030
#define B_AX_USB2_PHY_P1_E3_SH 24
#define B_AX_USB2_PHY_P1_E3_MSK 0xff
#define B_AX_USB2_PHY_P1_E2_SH 16
#define B_AX_USB2_PHY_P1_E2_MSK 0xff
#define B_AX_USB2_PHY_P1_E1_SH 8
#define B_AX_USB2_PHY_P1_E1_MSK 0xff
#define B_AX_USB2_PHY_P1_E0_SH 0
#define B_AX_USB2_PHY_P1_E0_MSK 0xff

#define R_AX_USB2_PHY_REG_5 0x1034
#define B_AX_USB2_PHY_P1_E7_SH 24
#define B_AX_USB2_PHY_P1_E7_MSK 0xff
#define B_AX_USB2_PHY_P1_E6_SH 16
#define B_AX_USB2_PHY_P1_E6_MSK 0xff
#define B_AX_USB2_PHY_P1_E5_SH 8
#define B_AX_USB2_PHY_P1_E5_MSK 0xff
#define B_AX_USB2_PHY_P1_E4_SH 0
#define B_AX_USB2_PHY_P1_E4_MSK 0xff

#define R_AX_USB2_PHY_REG_6 0x1038
#define B_AX_USB2_PHY_F3_SH 24
#define B_AX_USB2_PHY_F3_MSK 0xff
#define B_AX_USB2_PHY_F2_SH 16
#define B_AX_USB2_PHY_F2_MSK 0xff
#define B_AX_USB2_PHY_F1_SH 8
#define B_AX_USB2_PHY_F1_MSK 0xff
#define B_AX_USB2_PHY_F0_SH 0
#define B_AX_USB2_PHY_F0_MSK 0xff

#define R_AX_USB2_PHY_REG_7 0x103C
#define B_AX_USB2_PHY_F7_SH 24
#define B_AX_USB2_PHY_F7_MSK 0xff
#define B_AX_USB2_PHY_F6_SH 16
#define B_AX_USB2_PHY_F6_MSK 0xff
#define B_AX_USB2_PHY_F5_SH 8
#define B_AX_USB2_PHY_F5_MSK 0xff
#define B_AX_USB2_PHY_F4_SH 0
#define B_AX_USB2_PHY_F4_MSK 0xff

#define R_AX_USB2_PHY_REG_8 0x1040

#define R_AX_USB2_INTERRUPT_0 0x1050
#define B_AX_IE_ATTACHF BIT(30)
#define B_AX_IE_INITF BIT(29)
#define B_AX_IE_SE0RSTF BIT(28)
#define B_AX_IE_RESUMEF BIT(27)
#define B_AX_IE_SUSPNDF BIT(26)
#define B_AX_IE_EP0CSF BIT(25)
#define B_AX_IE_SOFF BIT(24)
#define B_AX_I_ATTACHF BIT(22)
#define B_AX_I_INITF BIT(21)
#define B_AX_I_SE0RSTF BIT(20)
#define B_AX_I_RESUMEF BIT(19)
#define B_AX_I_SUSPNDF BIT(18)
#define B_AX_I_EP0CSF BIT(17)
#define B_AX_I_SOFF BIT(16)
#define B_AX_IE_SETUP BIT(11)
#define B_AX_IE_EXREG_DMA BIT(10)
#define B_AX_I_SETUPF BIT(9)
#define B_AX_I_EXREG_DMA BIT(8)
#define B_AX_I_STANDARD_REQ BIT(7)
#define B_AX_I_CLASS_REQ BIT(6)
#define B_AX_I_DWEN_REQ BIT(5)
#define B_AX_I_VEND_REQ BIT(4)
#define B_AX_IE_STANDARD_REQ BIT(3)
#define B_AX_IE_CLASS_REQ BIT(2)
#define B_AX_IE_DWEN_REQ BIT(1)
#define B_AX_IE_VEND_REQ BIT(0)

#define R_AX_USB2_INTERRUPT_1 0x1054
#define B_AX_USB2_IB_LDO_DELAY_TIME_SH 8
#define B_AX_USB2_IB_LDO_DELAY_TIME_MSK 0xff
#define B_AX_VENDOR_INDEX_SH 0
#define B_AX_VENDOR_INDEX_MSK 0xff

#define R_AX_USB_ENDPOINT_0 0x1060
#define B_AX_EP_MAXPKT_SH 16
#define B_AX_EP_MAXPKT_MSK 0x3ff
#define B_AX_EP_EN BIT(15)
#define B_AX_EP_TYPE_SH 13
#define B_AX_EP_TYPE_MSK 0x3
#define B_AX_EP_ISTALL BIT(12)
#define B_AX_EP_OSTALL BIT(11)
#define B_AX_EP_STREAMEN BIT(10)
#define B_AX_EP_OUT BIT(9)
#define B_AX_EP_IN BIT(8)
#define B_AX_BT_INTR_SEL BIT(5)
#define B_AX_R_SIE_INIT_DONE BIT(4)
#define B_AX_EP_IDX_SH 0
#define B_AX_EP_IDX_MSK 0xf

#define R_AX_USB_ENDPOINT_1 0x1064
#define B_AX_EP_MAX_STREAM_SH 16
#define B_AX_EP_MAX_STREAM_MSK 0xff
#define B_AX_EP_MAX_BURST_SH 8
#define B_AX_EP_MAX_BURST_MSK 0xff
#define B_AX_EP_INT_INTERVAL_SH 0
#define B_AX_EP_INT_INTERVAL_MSK 0xff

#define R_AX_USB_ENDPOINT_2 0x1068
#define B_AX_EP_BPI_SH 16
#define B_AX_EP_BPI_MSK 0xffff
#define B_AX_USB3_EP_IN_ST_SH 8
#define B_AX_USB3_EP_IN_ST_MSK 0xff
#define B_AX_USB3_EP_OUT_ST_SH 0
#define B_AX_USB3_EP_OUT_ST_MSK 0xff

#define R_AX_USB_ENDPOINT_3 0x106C
#define B_AX_EP12_PAUSE_STATE BIT(31)
#define B_AX_EP11_PAUSE_STATE BIT(30)
#define B_AX_EP10_PAUSE_STATE BIT(29)
#define B_AX_EP9_PAUSE_STATE BIT(28)
#define B_AX_EP8_PAUSE_STATE BIT(27)
#define B_AX_EP7_PAUSE_STATE BIT(26)
#define B_AX_EP6_PAUSE_STATE BIT(25)
#define B_AX_EP5_PAUSE_STATE BIT(24)
#define B_AX_EP4_PAUSE_STATE BIT(23)
#define B_AX_EP12_TX_PAUSE BIT(22)
#define B_AX_EP11_TX_PAUSE BIT(21)
#define B_AX_EP10_TX_PAUSE BIT(20)
#define B_AX_EP9_TX_PAUSE BIT(19)
#define B_AX_EP8_RX_PAUSE BIT(18)
#define B_AX_EP7_TX_PAUSE BIT(17)
#define B_AX_EP6_TX_PAUSE BIT(16)
#define B_AX_EP5_TX_PAUSE BIT(15)
#define B_AX_EP4_RX_PAUSE BIT(14)
#define B_AX_INTERRUPT_BULK_IN BIT(11)
#define B_AX_BULKOUT1 BIT(9)
#define B_AX_BULKOUT0 BIT(8)
#define B_AX_AC_BULKOUT_SH 10
#define B_AX_AC_BULKOUT_MSK 0x3
#define B_AX_INTERRUPT_INTERVAL_SH 0
#define B_AX_INTERRUPT_INTERVAL_MSK 0xf

//
// 8852C ENDPOINT
//
#define R_AX_USB_ENDPOINT_3_V1 0x506C

#define R_AX_USB_HOST_REQUEST_0 0x1070
#define B_AX_ERR_STR2_LEN_SH 24
#define B_AX_ERR_STR2_LEN_MSK 0xff
#define B_AX_ERR_STR1_LEN_SH 8
#define B_AX_ERR_STR1_LEN_MSK 0xffff
#define B_AX_DEVADDR_SH 0
#define B_AX_DEVADDR_MSK 0x7f

#define R_AX_USB_HOST_REQUEST_1 0x1074
#define B_AX_USB_PID_SH 16
#define B_AX_USB_PID_MSK 0xffff
#define B_AX_USB_VID_SH 0
#define B_AX_USB_VID_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_2 0x1078
#define B_AX_MAC_ADDR_1_SH 24
#define B_AX_MAC_ADDR_1_MSK 0xff
#define B_AX_MAC_ADDR_0_SH 16
#define B_AX_MAC_ADDR_0_MSK 0xff
#define B_AX_FORCE_LPM_BCD201 BIT(15)
#define B_AX_SELF_POWER_EN BIT(14)
#define B_AX_R_FORCE_U3MAC_HS_MODE BIT(13)
#define B_AX_LOAD_LTM_CAP BIT(12)
#define B_AX_USB3_DEV_CAP_DESC_EN BIT(11)
#define B_AX_AUTOLOAD_STRING_EN BIT(10)
#define B_AX_REMOTE_WAKEUP BIT(9)
#define B_AX_SQNUM_ROM BIT(8)
#define B_AX_ERR_STR2_LEN_FLAG BIT(7)
#define B_AX_ERR_STR1_LEN_FLAG_1 BIT(6)
#define B_AX_ERR_STR1_LEN_FLAG_0 BIT(5)
#define B_AX_R_USBIO_MODE BIT(4)
#define B_AX_EXREG_TO_EN BIT(3)
#define B_AX_EXREG_TO_SEL_SH 0
#define B_AX_EXREG_TO_SEL_MSK 0x7

#define R_AX_USB_HOST_REQUEST_3 0x107C
#define B_AX_MAC_ADDR_5_SH 24
#define B_AX_MAC_ADDR_5_MSK 0xff
#define B_AX_MAC_ADDR_4_SH 16
#define B_AX_MAC_ADDR_4_MSK 0xff
#define B_AX_MAC_ADDR_3_SH 8
#define B_AX_MAC_ADDR_3_MSK 0xff
#define B_AX_MAC_ADDR_2_SH 0
#define B_AX_MAC_ADDR_2_MSK 0xff

#define R_AX_USB_HOST_REQUEST_4 0x1080
#define B_AX__MANUFACTURE_STRING_3_SH 24
#define B_AX__MANUFACTURE_STRING_3_MSK 0xff
#define B_AX__MANUFACTURE_STRING_2_SH 16
#define B_AX__MANUFACTURE_STRING_2_MSK 0xff
#define B_AX__MANUFACTURE_STRING_1_SH 8
#define B_AX__MANUFACTURE_STRING_1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_0_SH 0
#define B_AX__MANUFACTURE_STRING_0_MSK 0xff

#define R_AX_USB_HOST_REQUEST_5 0x1084
#define B_AX_MANUFACTURE_STRING_7_SH 24
#define B_AX_MANUFACTURE_STRING_7_MSK 0xff
#define B_AX_MANUFACTURE_STRING_6_SH 16
#define B_AX_MANUFACTURE_STRING_6_MSK 0xff
#define B_AX_MANUFACTURE_STRING_5_SH 8
#define B_AX_MANUFACTURE_STRING_5_MSK 0xff
#define B_AX_MANUFACTURE_STRING_4_SH 0
#define B_AX_MANUFACTURE_STRING_4_MSK 0xff

#define R_AX_USB_HOST_REQUEST_6 0x1088
#define B_AX_MANUFACTURE_STRING_B_SH 24
#define B_AX_MANUFACTURE_STRING_B_MSK 0xff
#define B_AX_MANUFACTURE_STRING_A_SH 16
#define B_AX_MANUFACTURE_STRING_A_MSK 0xff
#define B_AX_MANUFACTURE_STRING_9_SH 8
#define B_AX_MANUFACTURE_STRING_9_MSK 0xff
#define B_AX_MANUFACTURE_STRING_8_SH 0
#define B_AX_MANUFACTURE_STRING_8_MSK 0xff

#define R_AX_USB_HOST_REQUEST_7 0x108C
#define B_AX_MANUFACTURE_STRING_F_SH 24
#define B_AX_MANUFACTURE_STRING_F_MSK 0xff
#define B_AX_MANUFACTURE_STRING_E_SH 16
#define B_AX_MANUFACTURE_STRING_E_MSK 0xff
#define B_AX_MANUFACTURE_STRING_D_SH 8
#define B_AX_MANUFACTURE_STRING_D_MSK 0xff
#define B_AX_MANUFACTURE_STRING_C_SH 0
#define B_AX_MANUFACTURE_STRING_C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_8 0x1090
#define B_AX_MANUFACTURE_STRING_13_SH 24
#define B_AX_MANUFACTURE_STRING_13_MSK 0xff
#define B_AX_MANUFACTURE_STRING_12_SH 16
#define B_AX_MANUFACTURE_STRING_12_MSK 0xff
#define B_AX_MANUFACTURE_STRING_11_SH 8
#define B_AX_MANUFACTURE_STRING_11_MSK 0xff
#define B_AX_MANUFACTURE_STRING_10_SH 0
#define B_AX_MANUFACTURE_STRING_10_MSK 0xff

#define R_AX_USB_HOST_REQUEST_9 0x1094
#define B_AX_MANUFACTURE_STRING_17_SH 24
#define B_AX_MANUFACTURE_STRING_17_MSK 0xff
#define B_AX_MANUFACTURE_STRING_16_SH 16
#define B_AX_MANUFACTURE_STRING_16_MSK 0xff
#define B_AX_MANUFACTURE_STRING_15_SH 8
#define B_AX_MANUFACTURE_STRING_15_MSK 0xff
#define B_AX_MANUFACTURE_STRING_14_SH 0
#define B_AX_MANUFACTURE_STRING_14_MSK 0xff

#define R_AX_USB_HOST_REQUEST_A 0x1098
#define B_AX_MANUFACTURE_STRING_1B_SH 24
#define B_AX_MANUFACTURE_STRING_1B_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1A_SH 16
#define B_AX_MANUFACTURE_STRING_1A_MSK 0xff
#define B_AX_MANUFACTURE_STRING_19_SH 8
#define B_AX_MANUFACTURE_STRING_19_MSK 0xff
#define B_AX_MANUFACTURE_STRING_18_SH 0
#define B_AX_MANUFACTURE_STRING_18_MSK 0xff

#define R_AX_USB_HOST_REQUEST_B 0x109C
#define B_AX_MANUFACTURE_STRING_1F_SH 24
#define B_AX_MANUFACTURE_STRING_1F_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1E_SH 16
#define B_AX_MANUFACTURE_STRING_1E_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1D_SH 8
#define B_AX_MANUFACTURE_STRING_1D_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1C_SH 0
#define B_AX_MANUFACTURE_STRING_1C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_C 0x10A0
#define B_AX_PRODUCT_STRING_3_SH 24
#define B_AX_PRODUCT_STRING_3_MSK 0xff
#define B_AX_PRODUCT_STRING_2_SH 16
#define B_AX_PRODUCT_STRING_2_MSK 0xff
#define B_AX_PRODUCT_STRING_1_SH 8
#define B_AX_PRODUCT_STRING_1_MSK 0xff
#define B_AX_PRODUCT_STRING_0_SH 0
#define B_AX_PRODUCT_STRING_0_MSK 0xff

#define R_AX_USB_HOST_REQUEST_D 0x10A4
#define B_AX_PRODUCT_STRING_7_SH 24
#define B_AX_PRODUCT_STRING_7_MSK 0xff
#define B_AX_PRODUCT_STRING_6_SH 16
#define B_AX_PRODUCT_STRING_6_MSK 0xff
#define B_AX_PRODUCT_STRING_5_SH 8
#define B_AX_PRODUCT_STRING_5_MSK 0xff
#define B_AX_PRODUCT_STRING_4_SH 0
#define B_AX_PRODUCT_STRING_4_MSK 0xff

#define R_AX_USB_HOST_REQUEST_E 0x10A8
#define B_AX_PRODUCT_STRING_B_SH 24
#define B_AX_PRODUCT_STRING_B_MSK 0xff
#define B_AX_PRODUCT_STRING_A_SH 16
#define B_AX_PRODUCT_STRING_A_MSK 0xff
#define B_AX_PRODUCT_STRING_9_SH 8
#define B_AX_PRODUCT_STRING_9_MSK 0xff
#define B_AX_PRODUCT_STRING_8_SH 0
#define B_AX_PRODUCT_STRING_8_MSK 0xff

#define R_AX_USB_HOST_REQUEST_F 0x10AC
#define B_AX_PRODUCT_STRING_F_SH 24
#define B_AX_PRODUCT_STRING_F_MSK 0xff
#define B_AX_PRODUCT_STRING_E_SH 16
#define B_AX_PRODUCT_STRING_E_MSK 0xff
#define B_AX_PRODUCT_STRING_D_SH 8
#define B_AX_PRODUCT_STRING_D_MSK 0xff
#define B_AX_PRODUCT_STRING_C_SH 0
#define B_AX_PRODUCT_STRING_C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_10 0x10B0
#define B_AX_PRODUCT_STRING_13_SH 24
#define B_AX_PRODUCT_STRING_13_MSK 0xff
#define B_AX_PRODUCT_STRING_12_SH 16
#define B_AX_PRODUCT_STRING_12_MSK 0xff
#define B_AX_PRODUCT_STRING_11_SH 8
#define B_AX_PRODUCT_STRING_11_MSK 0xff
#define B_AX_PRODUCT_STRING_10_SH 0
#define B_AX_PRODUCT_STRING_10_MSK 0xff

#define R_AX_USB_HOST_REQUEST_11 0x10B4
#define B_AX_PRODUCT_STRING_17_SH 24
#define B_AX_PRODUCT_STRING_17_MSK 0xff
#define B_AX_PRODUCT_STRING_16_SH 16
#define B_AX_PRODUCT_STRING_16_MSK 0xff
#define B_AX_PRODUCT_STRING_15_SH 8
#define B_AX_PRODUCT_STRING_15_MSK 0xff
#define B_AX_PRODUCT_STRING_14_SH 0
#define B_AX_PRODUCT_STRING_14_MSK 0xff

#define R_AX_USB_HOST_REQUEST_12 0x10B8
#define B_AX_PRODUCT_STRING_1B_SH 24
#define B_AX_PRODUCT_STRING_1B_MSK 0xff
#define B_AX_PRODUCT_STRING_1A_SH 16
#define B_AX_PRODUCT_STRING_1A_MSK 0xff
#define B_AX_PRODUCT_STRING_19_SH 8
#define B_AX_PRODUCT_STRING_19_MSK 0xff
#define B_AX_PRODUCT_STRING_18_SH 0
#define B_AX_PRODUCT_STRING_18_MSK 0xff

#define R_AX_USB_HOST_REQUEST_13 0x10BC
#define B_AX_PRODUCT_STRING_1F_SH 24
#define B_AX_PRODUCT_STRING_1F_MSK 0xff
#define B_AX_PRODUCT_STRING_1E_SH 16
#define B_AX_PRODUCT_STRING_1E_MSK 0xff
#define B_AX_PRODUCT_STRING_1D_SH 8
#define B_AX_PRODUCT_STRING_1D_MSK 0xff
#define B_AX_PRODUCT_STRING_1C_SH 0
#define B_AX_PRODUCT_STRING_1C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_14 0x10C0
#define B_AX_PRODUCT_STRING_23_SH 24
#define B_AX_PRODUCT_STRING_23_MSK 0xff
#define B_AX_PRODUCT_STRING_22_SH 16
#define B_AX_PRODUCT_STRING_22_MSK 0xff
#define B_AX_PRODUCT_STRING_21_SH 8
#define B_AX_PRODUCT_STRING_21_MSK 0xff
#define B_AX_PRODUCT_STRING_20_SH 0
#define B_AX_PRODUCT_STRING_20_MSK 0xff

#define R_AX_USB_HOST_REQUEST_15 0x10C4
#define B_AX_PRODUCT_STRING_27_SH 24
#define B_AX_PRODUCT_STRING_27_MSK 0xff
#define B_AX_PRODUCT_STRING_26_SH 16
#define B_AX_PRODUCT_STRING_26_MSK 0xff
#define B_AX_PRODUCT_STRING_25_SH 8
#define B_AX_PRODUCT_STRING_25_MSK 0xff
#define B_AX_PRODUCT_STRING_24_SH 0
#define B_AX_PRODUCT_STRING_24_MSK 0xff

#define R_AX_USB_HOST_REQUEST_16 0x10C8
#define B_AX_PRODUCT_STRING_2B_SH 24
#define B_AX_PRODUCT_STRING_2B_MSK 0xff
#define B_AX_PRODUCT_STRING_2A_SH 16
#define B_AX_PRODUCT_STRING_2A_MSK 0xff
#define B_AX_PRODUCT_STRING_29_SH 8
#define B_AX_PRODUCT_STRING_29_MSK 0xff
#define B_AX_PRODUCT_STRING_28_SH 0
#define B_AX_PRODUCT_STRING_28_MSK 0xff

#define R_AX_USB_HOST_REQUEST_17 0x10CC
#define B_AX_PRODUCT_STRING_2F_SH 24
#define B_AX_PRODUCT_STRING_2F_MSK 0xff
#define B_AX_PRODUCT_STRING_2E_SH 16
#define B_AX_PRODUCT_STRING_2E_MSK 0xff
#define B_AX_PRODUCT_STRING_2D_SH 8
#define B_AX_PRODUCT_STRING_2D_MSK 0xff
#define B_AX_PRODUCT_STRING_2C_SH 0
#define B_AX_PRODUCT_STRING_2C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_18 0x10D0
#define B_AX_SERIAL_NUMBER_STRING_3_SH 24
#define B_AX_SERIAL_NUMBER_STRING_3_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_2_SH 16
#define B_AX_SERIAL_NUMBER_STRING_2_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_0_SH 0
#define B_AX_SERIAL_NUMBER_STRING_0_MSK 0xff

#define R_AX_USB_HOST_REQUEST_19 0x10D4
#define B_AX_SERIAL_NUMBER_STRING_7_SH 24
#define B_AX_SERIAL_NUMBER_STRING_7_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_6_SH 16
#define B_AX_SERIAL_NUMBER_STRING_6_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_5_SH 8
#define B_AX_SERIAL_NUMBER_STRING_5_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_4_SH 0
#define B_AX_SERIAL_NUMBER_STRING_4_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1A 0x10D8
#define B_AX_SERIAL_NUMBER_STRING_B_SH 24
#define B_AX_SERIAL_NUMBER_STRING_B_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_A_SH 16
#define B_AX_SERIAL_NUMBER_STRING_A_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_9_SH 8
#define B_AX_SERIAL_NUMBER_STRING_9_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_8_SH 0
#define B_AX_SERIAL_NUMBER_STRING_8_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1B 0x10DC
#define B_AX_SERIAL_NUMBER_STRING_F_SH 24
#define B_AX_SERIAL_NUMBER_STRING_F_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_E_SH 16
#define B_AX_SERIAL_NUMBER_STRING_E_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_D_SH 8
#define B_AX_SERIAL_NUMBER_STRING_D_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_C_SH 0
#define B_AX_SERIAL_NUMBER_STRING_C_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1C 0x10E0
#define B_AX_USB3_U2SEL_SH 16
#define B_AX_USB3_U2SEL_MSK 0xffff
#define B_AX_USB3_U1PEL_SH 0
#define B_AX_USB3_U1PEL_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_1D 0x10E4
#define B_AX_HW_VENDOR_INDEX_SH 16
#define B_AX_HW_VENDOR_INDEX_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1E 0x10E8
#define B_AX_DIS_STALL_FUNC_WAKE BIT(24)
#define B_AX_USB3_U2_DEV_EXIT_LAT_SH 8
#define B_AX_USB3_U2_DEV_EXIT_LAT_MSK 0xffff
#define B_AX_USB3_U1_DEV_EXIT_LAT_SH 0
#define B_AX_USB3_U1_DEV_EXIT_LAT_MSK 0xff

#define R_AX_USB3_MAC_LINK_0 0x1100
#define B_AX_INTS_USB3_HRESET_EN BIT(31)
#define B_AX_INTS_USB3_RECOV_EN BIT(30)
#define B_AX_INTS_USB3_LPBK_EN BIT(29)
#define B_AX_INTS_USB3_RXDET_EN BIT(28)
#define B_AX_INTS_USB3_POLL_EN BIT(27)
#define B_AX_INTS_USB3_U3_EN BIT(26)
#define B_AX_INTS_USB3_U1U2_EN BIT(25)
#define B_AX_INTS_USB3_U0_EN BIT(24)
#define B_AX_INTS_USB3_RECOV2U0_EN BIT(23)
#define B_AX_INTS_USB3_SSINACT_EN BIT(22)
#define B_AX_INTS_USB3_SSDIS_EN BIT(21)
#define B_AX_INTS_USB3_CMPLY_EN BIT(20)
#define B_AX_INTS_USB3_RECOV2U0 BIT(19)
#define B_AX_INTS_USB3_SSINACT BIT(18)
#define B_AX_INTS_USB3_SSDIS BIT(17)
#define B_AX_INTS_USB3_CMPLY BIT(16)
#define B_AX_INTS_USB3_HRESET BIT(15)
#define B_AX_INTS_USB3_RECOV BIT(14)
#define B_AX_INTS_USB3_LPBK BIT(13)
#define B_AX_INTS_USB3_RXDET BIT(12)
#define B_AX_INTS_USB3_POLL BIT(11)
#define B_AX_INTS_USB3_U3 BIT(10)
#define B_AX_INTS_USB3_U1U2 BIT(9)
#define B_AX_INTS_USB3_U0 BIT(8)
#define B_AX_EN_ROVIDLE_TIMEOUT BIT(6)
#define B_AX_EN_UNFIN_RTY BIT(5)
#define B_AX_SSPHY_U1_QUICK_LFPS BIT(4)
#define B_AX_USB3_DIS_ISOC_TIME_GT BIT(3)
#define B_AX_R_DIS_USB3_U2_EN BIT(2)
#define B_AX_R_DIS_USB3_U1_EN BIT(1)
#define B_AX_LINK_ST_DETECT_TERM BIT(0)

#define R_AX_USB3_MAC_LINK_1 0x1104
#define B_AX_WARM_RESET_TIME_SH 0
#define B_AX_WARM_RESET_TIME_MSK 0x3

#define R_AX_USB3_MAC_PIU 0x1108
#define B_AX_SSPHY_CLR_TERM BIT(1)
#define B_AX_SSPHY_SET_TERM BIT(0)

#define R_AX_USB3_MAC_PTL 0x110C
#define B_AX_WLAN0_BUF_NUMP_EN BIT(1)
#define B_AX_IGNORE_RETRY_BIT BIT(0)

#define R_AX_USB3_MAC_PRTSM 0x1110
#define B_AX_EN_IMMED_POP_CREDIT BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_0 0x1114
#define B_AX_SSPHY_LFPS_FILTER BIT(31)
#define B_AX_SSPHY_TX_SWING BIT(30)
#define B_AX_SSPHY_TXMARGIN_SH 27
#define B_AX_SSPHY_TXMARGIN_MSK 0x7
#define B_AX_SSPHY_TXDEEMPHASIS_SH 25
#define B_AX_SSPHY_TXDEEMPHASIS_MSK 0x3
#define B_AX_SSPHY_ELASTIC_BUF BIT(24)
#define B_AX_HIRD_THR_SH 19
#define B_AX_HIRD_THR_MSK 0x1f
#define B_AX_DEV_SPEED_SH 16
#define B_AX_DEV_SPEED_MSK 0x7
#define B_AX_U1_ACTIVE_TIMEOUT_SH 8
#define B_AX_U1_ACTIVE_TIMEOUT_MSK 0xff
#define B_AX_USB3_TARGET_LINK_STATE_SH 4
#define B_AX_USB3_TARGET_LINK_STATE_MSK 0xf
#define B_AX_APPL1RSP BIT(3)
#define B_AX_LPM_CAPABLE BIT(2)
#define B_AX_USB3_EOF_SH 0
#define B_AX_USB3_EOF_MSK 0x3

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_1 0x1118
#define B_AX_NPI_SCALEDOWN_MODE_SH 24
#define B_AX_NPI_SCALEDOWN_MODE_MSK 0x3
#define B_AX_SSPHY_POWERDOWN_SCALE_SH 8
#define B_AX_SSPHY_POWERDOWN_SCALE_MSK 0x1fff
#define B_AX_SSPHY_U1_FAST_OUT BIT(7)
#define B_AX_SSPHY_P3_FOR_P2 BIT(6)
#define B_AX_SSPHY_U1_RXVALID BIT(5)
#define B_AX_SSPHY_DIS_SCAMBLE BIT(4)
#define B_AX_SSPHY_SKIP_RXDETECT BIT(3)
#define B_AX_SSPHY_LFPS_P0_ALIGN BIT(2)
#define B_AX_SSPHY_P3P2_TRANS BIT(1)
#define B_AX_SSPHY_P3_EXITIN_P2 BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_2 0x111C
#define B_AX_SSPHY_U2EXIT_LPFS BIT(18)
#define B_AX_SSPHY_PHYSOFTRST BIT(17)
#define B_AX_SSPHY_HSTPRTCMPL BIT(16)
#define B_AX_SSPHY_U2SSINACTP3OK BIT(15)
#define B_AX_SSPHY_DISRXDETP3 BIT(14)
#define B_AX_SSPHY_UX_EXIT_IN_PX BIT(13)
#define B_AX_SSPHY_PING_ENH_EN BIT(12)
#define B_AX_SSPHY_U1U2EXITFAIL_TO_RECOV BIT(11)
#define B_AX_SSPHY_ALWAYS_REQ BIT(10)
#define B_AX_SSPHY_START_RX_DET BIT(9)
#define B_AX_SSPHY_DIS_RX_DET BIT(8)
#define B_AX_SSPHY_DELAY_P1P2P3_SH 5
#define B_AX_SSPHY_DELAY_P1P2P3_MSK 0x7
#define B_AX_SSPHY_SUSPEND_EN BIT(4)
#define B_AX_SSPHY_DATWIDTH_SH 2
#define B_AX_SSPHY_DATWIDTH_MSK 0x3
#define B_AX_SSPHY_ABORTRXDETLNU2 BIT(1)
#define B_AX_SSPHY_RX_DETECT_LPFS BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_0 0x1120
#define B_AX_U3_LTM_EN BIT(28)
#define B_AX_LINK_STATE_REQ_SH 24
#define B_AX_LINK_STATE_REQ_MSK 0xf
#define B_AX_SUSCLK_RATIO_SH 8
#define B_AX_SUSCLK_RATIO_MSK 0x1fff
#define B_AX_TEST_CTRL_SH 4
#define B_AX_TEST_CTRL_MSK 0xf
#define B_AX_UFRAME_SCALE_SH 2
#define B_AX_UFRAME_SCALE_MSK 0x3
#define B_AX_LOCAL_LBK BIT(1)
#define B_AX_USB_EN_SLEEP BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_1 0x1124
#define B_AX_WAKE_WAIT_XTAL BIT(27)
#define B_AX_WAKE_WAIT_CURRENT BIT(26)
#define B_AX_WAKEUP_NEG_SEL BIT(25)
#define B_AX_SSPHY_USB3_ATTEMPT BIT(24)
#define B_AX_WAIT_IDLE_TIME_SH 20
#define B_AX_WAIT_IDLE_TIME_MSK 0xf
#define B_AX_U2_EN_MAC_IDLE BIT(18)
#define B_AX_U1_EN_MAC_IDLE BIT(17)
#define B_AX_SWITCH_CLK_EN BIT(16)
#define B_AX_USB3_SAMPLE_RXELECIDLE_SH 8
#define B_AX_USB3_SAMPLE_RXELECIDLE_MSK 0xff
#define B_AX_U3_INIT_U2 BIT(7)
#define B_AX_U3_INIT_U1 BIT(6)
#define B_AX_SET_U3_WAKE BIT(5)
#define B_AX_U3_U2_EN BIT(4)
#define B_AX_U3_U1_EN BIT(3)
#define B_AX_U3_INIT_U2_EN BIT(2)
#define B_AX_U3_INIT_U1_EN BIT(1)
#define B_AX_USB3_RUN BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_2 0x1128
#define B_AX_NPI_LINK_STATE_LATCH_SH 16
#define B_AX_NPI_LINK_STATE_LATCH_MSK 0xff
#define B_AX_NPI_HOST_RESUME_DETECTED BIT(15)
#define B_AX_NPI_DEV_CONNECT_SPEED_SH 12
#define B_AX_NPI_DEV_CONNECT_SPEED_MSK 0x7
#define B_AX_NPI_LINK_STATE_SH 8
#define B_AX_NPI_LINK_STATE_MSK 0xf
#define B_AX_POLL_EN BIT(7)
#define B_AX_POLL_SAMPLE_ON BIT(6)
#define B_AX_POLL_ACT_SH 4
#define B_AX_POLL_ACT_MSK 0x3
#define B_AX_POLL_NOACT_SH 0
#define B_AX_POLL_NOACT_MSK 0xf

#define R_AX_USB3_MAC_NPI_POWER_3 0x112C
#define B_AX_R_CNT_SWITCH_USB32_PARA_SH 0
#define B_AX_R_CNT_SWITCH_USB32_PARA_MSK 0xffff

#define R_AX_USB3_MAC_NPI_STATUS 0x1130
#define B_AX_NPI_DEV_CONNECTED BIT(0)

#define R_AX_USB3_MAC_NPI_DEVICE_NOTIFICATION 0x1134
#define B_AX_DEVNOTE_BIA_SH 16
#define B_AX_DEVNOTE_BIA_MSK 0xffff
#define B_AX_DEVNOTE_BELT_SH 0
#define B_AX_DEVNOTE_BELT_MSK 0xfff

#define R_AX_USB3_MAC_NPI_TRANSMIT 0x1138
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_SH 0
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_MSK 0xf

#define R_AX_USB3_MAC_NPI_OTHERS 0x113C
#define B_AX_EN_FIX_RX_ABORT BIT(8)
#define B_AX_FLADJ_30MHZ_REG_SH 0
#define B_AX_FLADJ_30MHZ_REG_MSK 0x3f

#define R_AX_USB3_WRAP_0 0x1140
#define B_AX_U1TOU2_TIMER_SH 24
#define B_AX_U1TOU2_TIMER_MSK 0xff
#define B_AX_WAKE_ST_DBG_SH 20
#define B_AX_WAKE_ST_DBG_MSK 0xf
#define B_AX_ARB_ST_DBG_SH 18
#define B_AX_ARB_ST_DBG_MSK 0x3
#define B_AX_BIA_REQ BIT(17)
#define B_AX_BELT_REQ BIT(16)
#define B_AX_USB3_VENDOR_LEN_TH_SH 0
#define B_AX_USB3_VENDOR_LEN_TH_MSK 0xffff

#define R_AX_USB3_WRAP_1 0x1144
#define B_AX_DIS_PKT_FUNC_WAKE BIT(0)

#define R_AX_USB3_PHY 0x1148
#define B_AX_USB3_PHY_RWDATA_SH 16
#define B_AX_USB3_PHY_RWDATA_MSK 0xffff
#define B_AX_USB3_PHY_ADR_SH 8
#define B_AX_USB3_PHY_ADR_MSK 0x1f
#define B_AX_USB3_PHY_REG_WRFLAG BIT(7)
#define B_AX_USB3_PHY_REG_RDFLAG BIT(6)
#define B_AX_USB3_PHY_REG_ADR_SH 0
#define B_AX_USB3_PHY_REG_ADR_MSK 0x1f

#define R_AX_USB3_OTHERS 0x1150
#define B_AX_R_REATTACH_TIMER_SH 28
#define B_AX_R_REATTACH_TIMER_MSK 0xf
#define B_AX_R_CNT_MS_SEL_SH 24
#define B_AX_R_CNT_MS_SEL_MSK 0x7
#define B_AX_VENDOR_LPM_TEST_SH 16
#define B_AX_VENDOR_LPM_TEST_MSK 0xff
#define B_AX_ISOC_DELAY_VALUE_SH 0
#define B_AX_ISOC_DELAY_VALUE_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_0 0x1160
#define B_AX_BTRX0_BUFFER_WADDR_SH 24
#define B_AX_BTRX0_BUFFER_WADDR_MSK 0xff
#define B_AX_USB_INTOKEN_TIMEOUT_SH 20
#define B_AX_USB_INTOKEN_TIMEOUT_MSK 0x7
#define B_AX_BRX_BUF_CHK_SH 16
#define B_AX_BRX_BUF_CHK_MSK 0x7
#define B_AX_BTRX0_RPKT_SIZE_SH 0
#define B_AX_BTRX0_RPKT_SIZE_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_1 0x1164
#define B_AX_USB2BT_PWR_INFO_REG_MASK_SH 20
#define B_AX_USB2BT_PWR_INFO_REG_MASK_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_BT BIT(19)
#define B_AX_LOWPOWER_BT BIT(18)
#define B_AX_FUNCTION_WAKE_EN_BT BIT(17)
#define B_AX_FUNCTION_WAKE_CAPABLE_BT BIT(16)
#define B_AX_BT_ISO_ZERO_EN BIT(14)
#define B_AX_R_RXDMA_MODE_SH 12
#define B_AX_R_RXDMA_MODE_MSK 0x3
#define B_AX_GPS_USB_ACTIVE BIT(11)
#define B_AX_BT_TXQ_STOP_SH 8
#define B_AX_BT_TXQ_STOP_MSK 0x7

#define R_AX_USB_APPLICATION_BT_2 0x1168
#define B_AX_BT_TX BIT(17)
#define B_AX_BT_RX BIT(16)
#define B_AX_BTTX_FIFO_OVER_EP3 BIT(13)
#define B_AX_BTTX_FIFO_OVER_EP2 BIT(12)
#define B_AX_BTTX_FIFO_OVER_EP0 BIT(11)
#define B_AX_BTRX_FIFO_OVER_EP3 BIT(10)
#define B_AX_BTRX_FIFO_OVER_EP2 BIT(9)
#define B_AX_BTRX_FIFO_OVER_EP1 BIT(8)
#define B_AX_BTTX_FIFO_UNDR_EP3 BIT(5)
#define B_AX_BTTX_FIFO_UNDR_EP2 BIT(4)
#define B_AX_BTTX_FIFO_UNDR_EP0 BIT(3)
#define B_AX_BTRX_FIFO_UNDR_EP3 BIT(2)
#define B_AX_BTRX_FIFO_UNDR_EP2 BIT(1)
#define B_AX_BTRX_FIFO_UNDR_EP1 BIT(0)

#define R_AX_USB_APPLICATION_BT_3 0x116C
#define B_AX_DBG_BTRX_WADDR_SH 16
#define B_AX_DBG_BTRX_WADDR_MSK 0xfff
#define B_AX_DBG_BTRX_RPKT_SIZE_SH 0
#define B_AX_DBG_BTRX_RPKT_SIZE_MSK 0xffff

#define R_AX_USB_WLAN0_0 0x1170
#define B_AX_WLAN_INT_LEN_SH 16
#define B_AX_WLAN_INT_LEN_MSK 0xffff
#define B_AX_WLAN0_TXQ_STALL_DIS BIT(4)
#define B_AX_FUNCTION_SUSB_EN_WLAN0 BIT(3)
#define B_AX_LOWPOWER_WLAN0 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN0 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN0 BIT(0)

#define R_AX_USB_WLAN0_1 0x1174
#define B_AX_USBRX_RST BIT(9)
#define B_AX_USBTX_RST BIT(8)
#define B_AX_R_USBRX_SRAM_LS BIT(7)
#define B_AX_R_USBRX_SRAM_DS BIT(6)
#define B_AX_R_USBTX_SRAM_LS BIT(5)
#define B_AX_R_USBTX_SRAM_DS BIT(4)
#define B_AX_WLRX_FIFO_OVER_SH 2
#define B_AX_WLRX_FIFO_OVER_MSK 0x3
#define B_AX_WLRX_FIFO_UNDR_SH 0
#define B_AX_WLRX_FIFO_UNDR_MSK 0x3

#define R_AX_USB_AUTO_INSTALL_0 0x1180
#define B_AX_AINST_POLL_1 BIT(28)
#define B_AX_AINST_POLL_0 BIT(27)
#define B_AX_AINST_TX1_CLR_BUF BIT(26)
#define B_AX_AINST_TX0_CLR_BUF BIT(25)
#define B_AX_WLAN_FW_RDY BIT(24)
#define B_AX_RECONF_USBEP BIT(23)
#define B_AX_RECONF_USBEP_EN BIT(22)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET BIT(21)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET_EN BIT(20)
#define B_AX_AINST_RXLEN_SH 8
#define B_AX_AINST_RXLEN_MSK 0xfff
#define B_AX_AINST_RX1_INTR BIT(7)
#define B_AX_AINST_RX0_INTR BIT(6)
#define B_AX_AINXT_TX1_INTR BIT(5)
#define B_AX_AINST_TX0_INTR BIT(4)
#define B_AX_AUTO_INST_TXQ_STALL_DIS BIT(3)
#define B_AX_LOWPOWER_AINST BIT(2)
#define B_AX_FUNCTION_WANE_EN_AINST BIT(1)

#define R_AX_USB_AUTO_INSTALL_1 0x1184
#define B_AX_AINST_TX1LEN_SH 16
#define B_AX_AINST_TX1LEN_MSK 0xfff
#define B_AX_AINST_TX0LEN_SH 0
#define B_AX_AINST_TX0LEN_MSK 0xfff

#define R_AX_USB_AUTO_INSTALL_2 0x1188
#define B_AX_AINST_PID_SH 16
#define B_AX_AINST_PID_MSK 0xffff
#define B_AX_AINST_VID_SH 0
#define B_AX_AINST_VID_MSK 0xffff

#define R_AX_USB_AUTO_INSTALL_3 0x118C
#define B_AX_AINST_TXSTATUS_SH 8
#define B_AX_AINST_TXSTATUS_MSK 0xff
#define B_AX_AINST_RXSTATUS_SH 0
#define B_AX_AINST_RXSTATUS_MSK 0xff

#define R_AX_USB_BRIDGE_UART_0 0x1190
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_SH 16
#define B_AX_BRIDGE_XFACTOR_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB2_SH 0
#define B_AX_BRIDGE_BAUD_USB2_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_1 0x1194
#define B_AX_BRIDGE_WAKEUP_EN_SH 30
#define B_AX_BRIDGE_WAKEUP_EN_MSK 0x3
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_SH 16
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_MSK 0xfff
#define B_AX_BRIDGE_LE_CON_HAN_VLD BIT(9)
#define B_AX_BRIDGE_LE_ON BIT(8)
#define B_AX_BRIDGE_DEBUG_PKTCNT_EN BIT(6)
#define B_AX_BRIDGE_RESET_RCV_SEL BIT(5)
#define B_AX_BRIDGE_WLS0 BIT(4)
#define B_AX_BRIDGE_STB BIT(3)
#define B_AX_BRIDGE_PEN BIT(2)
#define B_AX_BRIDGE_EPS BIT(1)
#define B_AX_BRIDGE_STKP BIT(0)

#define R_AX_USB_BRIDGE_UART_2 0x1198
#define B_AX_BRIDGE_DEBUG_SEL_SH 24
#define B_AX_BRIDGE_DEBUG_SEL_MSK 0xff
#define B_AX_R_BRIDGE_UARTEN BIT(23)
#define B_AX_BRIDGE_LPM_EN BIT(22)
#define B_AX_BRIDGE_TXSCO_TIME_INTERVAL_EN BIT(21)
#define B_AX_BRIDGE_TXSCO_PKT_LEN_MAT_EN BIT(20)
#define B_AX_BRIDGE_TXSCO_CON_HAN_MAT_EN BIT(19)
#define B_AX_BRIDGE_USB_TX_HCICMDLEN_SEL BIT(18)
#define B_AX_R_BRIDGE_JCIRXEN BIT(17)
#define B_AX_R_BRIDGE_HCITXEN BIT(16)
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_SH 0
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_3 0x119C
#define B_AX_BRIDGE_URT_RXINDIC_ERR BIT(31)
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_SH 24
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_MSK 0x7f
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_SH 16
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_MSK 0xff
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_SH 8
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_MSK 0xff
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_SH 0
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_MSK 0xff

#define R_AX_USB_BRIDGE_UART_4 0x11A0
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_USB3_SH 16
#define B_AX_BRIDGE_XFACTOR_USB3_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB3_SH 0
#define B_AX_BRIDGE_BAUD_USB3_MSK 0xfff

#define R_AX_USB_BT_BRIDGE 0x11A8
#define B_AX_R_DIS_BTBRI_SS_SYSON BIT(2)
#define B_AX_R_DIS_BTBRI_SS_STS BIT(1)
#define B_AX_R_DIS_BTBRI_L1U2_STS BIT(0)

#define R_AX_USB_DMA_WRAPPER 0x11B0
#define B_AX_PKT_BASE_EN BIT(11)
#define B_AX_FUNCTION_SUSB_OPT BIT(8)
#define B_AX_TX7LEN_MISMATCH BIT(7)
#define B_AX_TX6LEN_MISMATCH BIT(6)
#define B_AX_TX5LEN_MISMATCH BIT(5)
#define B_AX_TX4LEN_MISMATCH BIT(4)
#define B_AX_TX3LEN_MISMATCH BIT(3)
#define B_AX_TX2LEN_MISMATCH BIT(2)
#define B_AX_TX1LEN_MISMATCH BIT(1)
#define B_AX_TX0LEN_MISMATCH BIT(0)

#define R_AX_USB_WLAN1 0x11B8
#define B_AX_WLAN_TX BIT(12)
#define B_AX_WLAN_RX BIT(11)
#define B_AX_WLAN1_TXQ_STALL_DIS BIT(10)
#define B_AX_WLAN1_RXQ_STOP_SH 8
#define B_AX_WLAN1_RXQ_STOP_MSK 0x3
#define B_AX_WLAN1_TXQ_STOP_SH 4
#define B_AX_WLAN1_TXQ_STOP_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_WLAN1 BIT(3)
#define B_AX_LOWPOWER_WLAN1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN1 BIT(0)

#define R_AX_USB_GPS 0x11C0
#define B_AX_FUNCTION_SUSB_EN_GPS BIT(3)
#define B_AX_LOWPOWER_GPS BIT(2)
#define B_AX_FUNCTION_WAKE_EN_GPS BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_GPS BIT(0)

#define R_AX_USB_DEBUG_0 0x11D0
#define B_AX_SLEEP_GNT_BT BIT(17)
#define B_AX_SLEEP_REQ_BT BIT(16)
#define B_AX_DEBUG_SIGNAL_001_SH 8
#define B_AX_DEBUG_SIGNAL_001_MSK 0xff
#define B_AX_USB_DBGO_SEL_SH 0
#define B_AX_USB_DBGO_SEL_MSK 0xff

#define R_AX_USB_DEBUG_1 0x11D4
#define B_AX_RXDMA_ENDPOINT_COUNTER_SH 24
#define B_AX_RXDMA_ENDPOINT_COUNTER_MSK 0xff
#define B_AX_RXDMA_DMA_COUNTER_SH 16
#define B_AX_RXDMA_DMA_COUNTER_MSK 0xff
#define B_AX_TXDMA_ENDPOINT_COUNTER_SH 8
#define B_AX_TXDMA_ENDPOINT_COUNTER_MSK 0xff
#define B_AX_TXDMA_DMA_COUNTER_SH 0
#define B_AX_TXDMA_DMA_COUNTER_MSK 0xff

#define R_AX_USB_DEBUG_2 0x11D8
#define B_AX_REGISTER_READ_COUNTER_SH 8
#define B_AX_REGISTER_READ_COUNTER_MSK 0xff
#define B_AX_REGISTER_WRITE_COUNTER_SH 0
#define B_AX_REGISTER_WRITE_COUNTER_MSK 0xff

#define R_AX_USB_DEBUG_3 0x11DC
#define B_AX_RX_PATH_STATE_MACHINE_SH 24
#define B_AX_RX_PATH_STATE_MACHINE_MSK 0xff
#define B_AX_TX_PATH_STATE_MACHINE_SH 16
#define B_AX_TX_PATH_STATE_MACHINE_MSK 0xff
#define B_AX_IO_PATH_STATE_MACHINE_SH 8
#define B_AX_IO_PATH_STATE_MACHINE_MSK 0xffffff
#define B_AX_TXVLD_TOGGLE_VAL_SH 8
#define B_AX_TXVLD_TOGGLE_VAL_MSK 0xf
#define B_AX_TXVLD_TOUT_VAL_SH 0
#define B_AX_TXVLD_TOUT_VAL_MSK 0xff

#define R_AX_USB_STATUS 0x11F0
#define B_AX_USB_EP_NUM_SH 4
#define B_AX_USB_EP_NUM_MSK 0xf
#define B_AX_R_SSIC_EN BIT(2)
#define B_AX_R_USB2_SEL BIT(1)
#define B_AX_MODE_HS BIT(0)

#define R_AX_USB_D2F_F2D_INFO 0x1200
#define B_AX_HRPWM2_SH 16
#define B_AX_HRPWM2_MSK 0xffff
#define B_AX_CPWM2_SH 0
#define B_AX_CPWM2_MSK 0xffff

#define R_AX_USB3 0x1220
#define B_AX_U3_STATE_SH 12
#define B_AX_U3_STATE_MSK 0xf
#define B_AX_U3_SUB_STATE_SH 8
#define B_AX_U3_SUB_STATE_MSK 0xf
#define B_AX_HPS_CLKR_USB_SH 0
#define B_AX_HPS_CLKR_USB_MSK 0xff

#define R_AX_USB_OTHERS_0 0x1230
#define B_AX_USBTX_EP3IF_OK_CNT_SH 24
#define B_AX_USBTX_EP3IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP2IF_OK_CNT_SH 16
#define B_AX_USBTX_EP2IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP1IF_OK_CNT_SH 8
#define B_AX_USBTX_EP1IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP0IF_OK_CNT_SH 0
#define B_AX_USBTX_EP0IF_OK_CNT_MSK 0xff

#define R_AX_USB_OTHERS_1 0x1234
#define B_AX_USBTX_EP7IF_OK_CNT_SH 24
#define B_AX_USBTX_EP7IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP6IF_OK_CNT_SH 16
#define B_AX_USBTX_EP6IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP5IF_OK_CNT_SH 8
#define B_AX_USBTX_EP5IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP4IF_OK_CNT_SH 0
#define B_AX_USBTX_EP4IF_OK_CNT_MSK 0xff

#define R_AX_USB_OTHERS_2 0x1238
#define B_AX_USBRX_DMAIF_OK_CNT_SH 24
#define B_AX_USBRX_DMAIF_OK_CNT_MSK 0xff
#define B_AX_USBRX_EPIF_OK_CNT_SH 16
#define B_AX_USBRX_EPIF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP9IF_OK_CNT_SH 8
#define B_AX_USBTX_EP9IF_OK_CNT_MSK 0xff
#define B_AX_USBTX_EP8IF_OK_CNT_SH 0
#define B_AX_USBTX_EP8IF_OK_CNT_MSK 0xff

#define R_AX_USB_OTHERS_3 0x123C
#define B_AX_VENDOR_LMP_LATCH_DATA_L_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_L_MSK 0xffffffffL

#define R_AX_USB_OTHERS_4 0x1240
#define B_AX_VENDOR_LMP_LATCH_DATA_H_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_H_MSK 0xffffffffL

#define R_AX_USB_OTHERS_5 0x1244
#define B_AX_APPEND_ZERO_PKT_SH 24
#define B_AX_APPEND_ZERO_PKT_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_7_SH 21
#define B_AX_USB_AUTO_LOAD_EXTE_7_MSK 0x3
#define B_AX_USB_AUTO_LOAD_EXTE_0_SH 16
#define B_AX_USB_AUTO_LOAD_EXTE_0_MSK 0x1f
#define B_AX_USB_AUTO_LOAD_EXTE_2_SH 8
#define B_AX_USB_AUTO_LOAD_EXTE_2_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_1_SH 0
#define B_AX_USB_AUTO_LOAD_EXTE_1_MSK 0xff

#define R_AX_USB_OTHERS_6 0x1248
#define B_AX_USB_AUTO_LOAD_STRING_3_SH 24
#define B_AX_USB_AUTO_LOAD_STRING_3_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_2_SH 16
#define B_AX_USB_AUTO_LOAD_STRING_2_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_1_SH 8
#define B_AX_USB_AUTO_LOAD_STRING_1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_0_SH 0
#define B_AX_USB_AUTO_LOAD_STRING_0_MSK 0xff

#define R_AX_USB_OTHERS_7 0x124C
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_SH 22
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_SH 14
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_FLAG BIT(13)
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_SH 7
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_MSK 0x3f
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_SH 0
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_MSK 0x7f

#define R_AX_USB_WATCHDOG 0x1260
#define B_AX_USBIO_WD_FLAG BIT(31)
#define B_AX_USBIO_WD_EN BIT(30)
#define B_AX_USBIO_WD_TIMER_SH 24
#define B_AX_USBIO_WD_TIMER_MSK 0xf
#define B_AX_USBIO_WD_ADDR_SH 0
#define B_AX_USBIO_WD_ADDR_MSK 0xffffff

#define R_AX_HUSBIMR 0x1270
#define B_AX_HD1ISR_B00_IND_INT_EN BIT(26)
#define B_AX_USBRX_INT_EN BIT(7)
#define B_AX_PUSBTX_CH12_INT_EN BIT(6)
#define B_AX_USBTX_CH10_INT_EN BIT(5)
#define B_AX_USBTX_CH8_INT_EN BIT(4)
#define B_AX_USBTX_ACH6_INT_EN BIT(3)
#define B_AX_USBTX_ACH4_INT_EN BIT(2)
#define B_AX_USBTX_ACH2_INT_EN BIT(1)
#define B_AX_USBTX_ACH0_INT_EN BIT(0)

#define R_AX_HUSBISR 0x1274
#define B_AX_HD1ISR_B00_IND_INT BIT(26)
#define B_AX_USBRX_INT BIT(7)
#define B_AX_PUSBTX_CH12_INT BIT(6)
#define B_AX_USBTX_CH10_INT BIT(5)
#define B_AX_USBTX_CH8_INT BIT(4)
#define B_AX_USBTX_ACH6_INT BIT(3)
#define B_AX_USBTX_ACH4_INT BIT(2)
#define B_AX_USBTX_ACH2_INT BIT(1)
#define B_AX_USBTX_ACH0_INT BIT(0)

//
// WL_AX_Reg_USB.xls
//

//
// 8852C USB_REG
//

#define R_AX_USB2_MAC_0_V1 0x5000
#define B_AX_TOUT_DELAY_FS_V1_SH 24
#define B_AX_TOUT_DELAY_FS_V1_MSK 0xff
#define B_AX_TOUT_DELAY_HS_V1_SH 16
#define B_AX_TOUT_DELAY_HS_V1_MSK 0xff
#define B_AX_TOUT_DIS_V1 BIT(15)
#define B_AX_CRC_CHK_OPT_V1 BIT(14)
#define B_AX_FORCE_PCERST_V1 BIT(13)
#define B_AX_FORCE_TOGL_V1 BIT(12)
#define B_AX_FORCE_TOGLSEL_V1 BIT(11)
#define B_AX_FORCE_PIDSW_V1 BIT(10)
#define B_AX_FORCE_PCE_IN_V1 BIT(9)
#define B_AX_FORCE_PCE_OUT_V1 BIT(8)
#define B_AX_PID_FORCE_V1_SH 0
#define B_AX_PID_FORCE_V1_MSK 0xff

#define R_AX_USB2_MAC_1_V1 0x5004
#define B_AX_FORCE_PCE_CMD_V1 BIT(31)

#define R_AX_USB2_LINK_PORT_V1 0x5008
#define B_AX_R_HOST_PWR_CTRL_V1 BIT(23)
#define B_AX_R_USB2_CLR_TXVLD_V1 BIT(22)
#define B_AX_R_USB2_SE0_V1 BIT(21)
#define B_AX_HOST_RESUME_EDGE_EN_V1 BIT(20)
#define B_AX_RESUME_SEL_V1_SH 16
#define B_AX_RESUME_SEL_V1_MSK 0xf
#define B_AX_DELAY_CHIRP_K_V1_SH 14
#define B_AX_DELAY_CHIRP_K_V1_MSK 0x3
#define B_AX_FORCE_TXVLD1_V1 BIT(13)
#define B_AX_FORCE_TXVLD0_V1 BIT(12)
#define B_AX_DORCE_DAT1_V1 BIT(11)
#define B_AX_FORCE_DAT0_V1 BIT(10)
#define B_AX_LS_TEST_V1 BIT(9)
#define B_AX_LS_CHANGE_V1 BIT(8)
#define B_AX_FORCE_HS_SW_V1 BIT(7)
#define B_AX_FORCE_FS_SW_V1 BIT(6)
#define B_AX_FORCE_HSXCVR_V1 BIT(5)
#define B_AX_FORCE_FSXCVR_V1 BIT(4)
#define B_AX_FORCE_HSTERM_V1 BIT(3)
#define B_AX_FORCE_FSTERM_V1 BIT(2)
#define B_AX_FORCE_NORM_SW_V1 BIT(1)
#define B_AX_FORCE_DBSN_V1 BIT(0)

#define R_AX_USB2_LPM_0_V1 0x5010
#define B_AX_USBPHY_PLL_ALIVE_V1 BIT(17)
#define B_AX_USB_LPM_MAX_EN_V1 BIT(16)
#define B_AX_USB_LPM_MIN_EN_V1 BIT(15)
#define B_AX_BESL_EN_V1 BIT(14)
#define B_AX_USB_LPM_NYET_EN_V1 BIT(13)
#define B_AX_USB_LPM_MAX_ACK_V1 BIT(12)
#define B_AX_USB_LPM_EN_V1 BIT(11)
#define B_AX_USB2_SUSB_V1 BIT(10)
#define B_AX_LPM_PLL_ALIVE_V1 BIT(9)
#define B_AX_USB_LPS_OUT_V1 BIT(8)
#define B_AX_USB_LPM_WAKEUP_EN_V1 BIT(6)
#define B_AX_NEVER_SUSPEND_V1 BIT(5)
#define B_AX_SUSPND_EN_V1 BIT(4)
#define B_AX_WAKEUP_EN_V1 BIT(3)
#define B_AX_USB_SUS_WAKEUP_EN_V1 BIT(2)
#define B_AX_RESUME_SND_V1 BIT(1)
#define B_AX_CONNECT_EN_V1 BIT(0)

#define R_AX_USB2_LPM_1_V1 0x5014
#define B_AX_USB_LPM_MAX_V1_SH 20
#define B_AX_USB_LPM_MAX_V1_MSK 0xf
#define B_AX_USB_LPM_MIN_V1_SH 16
#define B_AX_USB_LPM_MIN_V1_MSK 0xf
#define B_AX_R_WAKE_HOST_WT_H_V1_SH 8
#define B_AX_R_WAKE_HOST_WT_H_V1_MSK 0xff
#define B_AX_R_WAKE_HOST_WT_L_V1_SH 0
#define B_AX_R_WAKE_HOST_WT_L_V1_MSK 0xff

#define R_AX_USB2_MACRO_TEST_MODE_V1 0x5018
#define B_AX_TXRDY_SLB_SEL_V1 BIT(14)
#define B_AX_SLB_EN_V1 BIT(13)
#define B_AX_SLB_RST_V1 BIT(12)
#define B_AX_SLB_FAIL_V1 BIT(11)
#define B_AX_SLB_DONE_V1 BIT(10)
#define B_AX_SLB_PS1_SW_V1_SH 8
#define B_AX_SLB_PS1_SW_V1_MSK 0x3
#define B_AX_PHY_LOOP_TEST_V1 BIT(3)
#define B_AX_USBTMOD_V1_SH 0
#define B_AX_USBTMOD_V1_MSK 0x7

#define R_AX_USB2_PHY_REG_0_V1 0x5020
#define B_AX_USB2PHY_REG_EN_V1 BIT(17)
#define B_AX_VLPADM_V1 BIT(16)
#define B_AX_VSTATUS_IN_V1_SH 8
#define B_AX_VSTATUS_IN_V1_MSK 0xff
#define B_AX_VCONTROL_V1_SH 0
#define B_AX_VCONTROL_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_1_V1 0x5024
#define B_AX_USB2PHY_DELAY_V1_SH 8
#define B_AX_USB2PHY_DELAY_V1_MSK 0xff
#define B_AX_VSTATUS_OUT_V1_SH 0
#define B_AX_VSTATUS_OUT_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_2_V1 0x5028
#define B_AX_USB2_PHY_P0_E3_V1_SH 24
#define B_AX_USB2_PHY_P0_E3_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E2_V1_SH 16
#define B_AX_USB2_PHY_P0_E2_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E1_V1_SH 8
#define B_AX_USB2_PHY_P0_E1_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E0_V1_SH 0
#define B_AX_USB2_PHY_P0_E0_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_3_V1 0x502C
#define B_AX_USB2_PHY_P0_E7_V1_SH 24
#define B_AX_USB2_PHY_P0_E7_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E6_V1_SH 16
#define B_AX_USB2_PHY_P0_E6_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E5_V1_SH 8
#define B_AX_USB2_PHY_P0_E5_V1_MSK 0xff
#define B_AX_USB2_PHY_P0_E4_V1_SH 0
#define B_AX_USB2_PHY_P0_E4_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_4_V1 0x5030
#define B_AX_USB2_PHY_P1_E3_V1_SH 24
#define B_AX_USB2_PHY_P1_E3_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E2_V1_SH 16
#define B_AX_USB2_PHY_P1_E2_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E1_V1_SH 8
#define B_AX_USB2_PHY_P1_E1_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E0_V1_SH 0
#define B_AX_USB2_PHY_P1_E0_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_5_V1 0x5034
#define B_AX_USB2_PHY_P1_E7_V1_SH 24
#define B_AX_USB2_PHY_P1_E7_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E6_V1_SH 16
#define B_AX_USB2_PHY_P1_E6_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E5_V1_SH 8
#define B_AX_USB2_PHY_P1_E5_V1_MSK 0xff
#define B_AX_USB2_PHY_P1_E4_V1_SH 0
#define B_AX_USB2_PHY_P1_E4_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_6_V1 0x5038
#define B_AX_USB2_PHY_F3_V1_SH 24
#define B_AX_USB2_PHY_F3_V1_MSK 0xff
#define B_AX_USB2_PHY_F2_V1_SH 16
#define B_AX_USB2_PHY_F2_V1_MSK 0xff
#define B_AX_USB2_PHY_F1_V1_SH 8
#define B_AX_USB2_PHY_F1_V1_MSK 0xff
#define B_AX_USB2_PHY_F0_V1_SH 0
#define B_AX_USB2_PHY_F0_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_7_V1 0x503C
#define B_AX_USB2_PHY_F7_V1_SH 24
#define B_AX_USB2_PHY_F7_V1_MSK 0xff
#define B_AX_USB2_PHY_F6_V1_SH 16
#define B_AX_USB2_PHY_F6_V1_MSK 0xff
#define B_AX_USB2_PHY_F5_V1_SH 8
#define B_AX_USB2_PHY_F5_V1_MSK 0xff
#define B_AX_USB2_PHY_F4_V1_SH 0
#define B_AX_USB2_PHY_F4_V1_MSK 0xff

#define R_AX_USB2_PHY_REG_8_V1 0x5040
#define B_AX_USB2PHY_UPDATE_2_V1_SH 16
#define B_AX_USB2PHY_UPDATE_2_V1_MSK 0xff
#define B_AX_USB2PHY_UPDATE_1_V1_SH 8
#define B_AX_USB2PHY_UPDATE_1_V1_MSK 0xff
#define B_AX_USB2PHY_UPDATE_0_V1_SH 0
#define B_AX_USB2PHY_UPDATE_0_V1_MSK 0xff

#define R_AX_USB_ENDPOINT_0_V1 0x5060
#define B_AX_EP_MAXPKT_V1_SH 16
#define B_AX_EP_MAXPKT_V1_MSK 0x3ff
#define B_AX_EP_EN_V1 BIT(15)
#define B_AX_EP_TYPE_V1_SH 13
#define B_AX_EP_TYPE_V1_MSK 0x3
#define B_AX_EP_ISTALL_V1 BIT(12)
#define B_AX_EP_OSTALL_V1 BIT(11)
#define B_AX_EP_STREAMEN_V1 BIT(10)
#define B_AX_EP_OUT_V1 BIT(9)
#define B_AX_EP_IN_V1 BIT(8)
#define B_AX_BT_INTR_SEL_V1 BIT(5)
#define B_AX_R_SIE_INIT_DONE_V1 BIT(4)
#define B_AX_EP_IDX_V1_SH 0
#define B_AX_EP_IDX_V1_MSK 0xf

#define R_AX_USB_ENDPOINT_1_V1 0x5064
#define B_AX_EP_MAX_STREAM_V1_SH 16
#define B_AX_EP_MAX_STREAM_V1_MSK 0xff
#define B_AX_EP_MAX_BURST_V1_SH 8
#define B_AX_EP_MAX_BURST_V1_MSK 0xff
#define B_AX_EP_INT_INTERVAL_V1_SH 0
#define B_AX_EP_INT_INTERVAL_V1_MSK 0xff

#define R_AX_USB_ENDPOINT_2_V1 0x5068
#define B_AX_EP_BPI_V1_SH 16
#define B_AX_EP_BPI_V1_MSK 0xffff
#define B_AX_USB3_EP_IN_ST_V1_SH 8
#define B_AX_USB3_EP_IN_ST_V1_MSK 0xff
#define B_AX_USB3_EP_OUT_ST_V1_SH 0
#define B_AX_USB3_EP_OUT_ST_V1_MSK 0xff

#define R_AX_USB_ENDPOINT_3_V1 0x506C
#define B_AX_EP12_PAUSE_STATE_V1 BIT(31)
#define B_AX_EP11_PAUSE_STATE_V1 BIT(30)
#define B_AX_EP10_PAUSE_STATE_V1 BIT(29)
#define B_AX_EP9_PAUSE_STATE_V1 BIT(28)
#define B_AX_EP8_PAUSE_STATE_V1 BIT(27)
#define B_AX_EP7_PAUSE_STATE_V1 BIT(26)
#define B_AX_EP6_PAUSE_STATE_V1 BIT(25)
#define B_AX_EP5_PAUSE_STATE_V1 BIT(24)
#define B_AX_EP4_PAUSE_STATE_V1 BIT(23)
#define B_AX_EP12_TX_PAUSE_V1 BIT(22)
#define B_AX_EP11_TX_PAUSE_V1 BIT(21)
#define B_AX_EP10_TX_PAUSE_V1 BIT(20)
#define B_AX_EP9_TX_PAUSE_V1 BIT(19)
#define B_AX_EP8_RX_PAUSE_V1 BIT(18)
#define B_AX_EP7_TX_PAUSE_V1 BIT(17)
#define B_AX_EP6_TX_PAUSE_V1 BIT(16)
#define B_AX_EP5_TX_PAUSE_V1 BIT(15)
#define B_AX_EP4_RX_PAUSE_V1 BIT(14)
#define B_AX_INTERRUPT_BULK_IN_V1 BIT(12)
#define B_AX_AC_BULKOUT_V1_SH 10
#define B_AX_AC_BULKOUT_V1_MSK 0x3
#define B_AX_BULKOUT1_V1 BIT(9)
#define B_AX_BULKOUT0_V1 BIT(8)
#define B_AX_INTERRUPT_INTERVAL_V1_SH 0
#define B_AX_INTERRUPT_INTERVAL_V1_MSK 0xf

#define R_AX_USB_HOST_REQUEST_0_V1 0x5070
#define B_AX_ERR_STR2_LEN_V1_SH 24
#define B_AX_ERR_STR2_LEN_V1_MSK 0xff
#define B_AX_ERR_STR1_LEN_V1_SH 8
#define B_AX_ERR_STR1_LEN_V1_MSK 0xffff
#define B_AX_DEVADDR_V1_SH 0
#define B_AX_DEVADDR_V1_MSK 0x7f

#define R_AX_USB_HOST_REQUEST_1_V1 0x5074
#define B_AX_USB_PID_V1_SH 16
#define B_AX_USB_PID_V1_MSK 0xffff
#define B_AX_USB_VID_V1_SH 0
#define B_AX_USB_VID_V1_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_2_V1 0x5078
#define B_AX_MAC_ADDR_1_V1_SH 24
#define B_AX_MAC_ADDR_1_V1_MSK 0xff
#define B_AX_MAC_ADDR_0_V1_SH 16
#define B_AX_MAC_ADDR_0_V1_MSK 0xff
#define B_AX_FORCE_LPM_BCD201_V1 BIT(15)
#define B_AX_SELF_POWER_EN_V1 BIT(14)
#define B_AX_R_FORCE_U3MAC_HS_MODE_V1 BIT(13)
#define B_AX_LOAD_LTM_CAP_V1 BIT(12)
#define B_AX_USB3_DEV_CAP_DESC_EN_V1 BIT(11)
#define B_AX_AUTOLOAD_STRING_EN_V1 BIT(10)
#define B_AX_REMOTE_WAKEUP_V1 BIT(9)
#define B_AX_SQNUM_ROM_V1 BIT(8)
#define B_AX_ERR_STR2_LEN_FLAG_V1 BIT(7)
#define B_AX_ERR_STR1_LEN_FLAG_V1 BIT(6)
#define B_AX_ERR_STR0_LEN_FLAG_V1 BIT(5)
#define B_AX_R_USBIO_MODE_V1 BIT(4)
#define B_AX_EXREG_TO_EN_V1 BIT(3)
#define B_AX_EXREG_TO_SEL_V1_SH 0
#define B_AX_EXREG_TO_SEL_V1_MSK 0x7

#define R_AX_USB_HOST_REQUEST_3_V1 0x507C
#define B_AX_MAC_ADDR_5_V1_SH 24
#define B_AX_MAC_ADDR_5_V1_MSK 0xff
#define B_AX_MAC_ADDR_4_V1_SH 16
#define B_AX_MAC_ADDR_4_V1_MSK 0xff
#define B_AX_MAC_ADDR_3_V1_SH 8
#define B_AX_MAC_ADDR_3_V1_MSK 0xff
#define B_AX_MAC_ADDR_2_V1_SH 0
#define B_AX_MAC_ADDR_2_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_4_V1 0x5080
#define B_AX__MANUFACTURE_STRING_3_V1_SH 24
#define B_AX__MANUFACTURE_STRING_3_V1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_2_V1_SH 16
#define B_AX__MANUFACTURE_STRING_2_V1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_1_V1_SH 8
#define B_AX__MANUFACTURE_STRING_1_V1_MSK 0xff
#define B_AX__MANUFACTURE_STRING_0_V1_SH 0
#define B_AX__MANUFACTURE_STRING_0_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_5_V1 0x5084
#define B_AX_MANUFACTURE_STRING_7_V1_SH 24
#define B_AX_MANUFACTURE_STRING_7_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_6_V1_SH 16
#define B_AX_MANUFACTURE_STRING_6_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_5_V1_SH 8
#define B_AX_MANUFACTURE_STRING_5_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_4_V1_SH 0
#define B_AX_MANUFACTURE_STRING_4_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_6_V1 0x5088
#define B_AX_MANUFACTURE_STRING_B_V1_SH 24
#define B_AX_MANUFACTURE_STRING_B_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_A_V1_SH 16
#define B_AX_MANUFACTURE_STRING_A_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_9_V1_SH 8
#define B_AX_MANUFACTURE_STRING_9_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_8_V1_SH 0
#define B_AX_MANUFACTURE_STRING_8_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_7_V1 0x508C
#define B_AX_MANUFACTURE_STRING_F_V1_SH 24
#define B_AX_MANUFACTURE_STRING_F_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_E_V1_SH 16
#define B_AX_MANUFACTURE_STRING_E_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_D_V1_SH 8
#define B_AX_MANUFACTURE_STRING_D_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_C_V1_SH 0
#define B_AX_MANUFACTURE_STRING_C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_8_V1 0x5090
#define B_AX_MANUFACTURE_STRING_13_V1_SH 24
#define B_AX_MANUFACTURE_STRING_13_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_12_V1_SH 16
#define B_AX_MANUFACTURE_STRING_12_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_11_V1_SH 8
#define B_AX_MANUFACTURE_STRING_11_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_10_V1_SH 0
#define B_AX_MANUFACTURE_STRING_10_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_9_V1 0x5094
#define B_AX_MANUFACTURE_STRING_17_V1_SH 24
#define B_AX_MANUFACTURE_STRING_17_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_16_V1_SH 16
#define B_AX_MANUFACTURE_STRING_16_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_15_V1_SH 8
#define B_AX_MANUFACTURE_STRING_15_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_14_V1_SH 0
#define B_AX_MANUFACTURE_STRING_14_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_A_V1 0x5098
#define B_AX_MANUFACTURE_STRING_1B_V1_SH 24
#define B_AX_MANUFACTURE_STRING_1B_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1A_V1_SH 16
#define B_AX_MANUFACTURE_STRING_1A_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_19_V1_SH 8
#define B_AX_MANUFACTURE_STRING_19_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_18_V1_SH 0
#define B_AX_MANUFACTURE_STRING_18_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_B_V1 0x509C
#define B_AX_MANUFACTURE_STRING_1F_V1_SH 24
#define B_AX_MANUFACTURE_STRING_1F_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1E_V1_SH 16
#define B_AX_MANUFACTURE_STRING_1E_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1D_V1_SH 8
#define B_AX_MANUFACTURE_STRING_1D_V1_MSK 0xff
#define B_AX_MANUFACTURE_STRING_1C_V1_SH 0
#define B_AX_MANUFACTURE_STRING_1C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_C_V1 0x50A0
#define B_AX_PRODUCT_STRING_3_V1_SH 24
#define B_AX_PRODUCT_STRING_3_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2_V1_SH 16
#define B_AX_PRODUCT_STRING_2_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1_V1_SH 8
#define B_AX_PRODUCT_STRING_1_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_0_V1_SH 0
#define B_AX_PRODUCT_STRING_0_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_D_V1 0x50A4
#define B_AX_PRODUCT_STRING_7_V1_SH 24
#define B_AX_PRODUCT_STRING_7_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_6_V1_SH 16
#define B_AX_PRODUCT_STRING_6_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_5_V1_SH 8
#define B_AX_PRODUCT_STRING_5_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_4_V1_SH 0
#define B_AX_PRODUCT_STRING_4_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_E_V1 0x50A8
#define B_AX_PRODUCT_STRING_B_V1_SH 24
#define B_AX_PRODUCT_STRING_B_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_A_V1_SH 16
#define B_AX_PRODUCT_STRING_A_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_9_V1_SH 8
#define B_AX_PRODUCT_STRING_9_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_8_V1_SH 0
#define B_AX_PRODUCT_STRING_8_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_F_V1 0x50AC
#define B_AX_PRODUCT_STRING_F_V1_SH 24
#define B_AX_PRODUCT_STRING_F_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_E_V1_SH 16
#define B_AX_PRODUCT_STRING_E_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_D_V1_SH 8
#define B_AX_PRODUCT_STRING_D_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_C_V1_SH 0
#define B_AX_PRODUCT_STRING_C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_10_V1 0x50B0
#define B_AX_PRODUCT_STRING_13_V1_SH 24
#define B_AX_PRODUCT_STRING_13_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_12_V1_SH 16
#define B_AX_PRODUCT_STRING_12_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_11_V1_SH 8
#define B_AX_PRODUCT_STRING_11_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_10_V1_SH 0
#define B_AX_PRODUCT_STRING_10_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_11_V1 0x50B4
#define B_AX_PRODUCT_STRING_17_V1_SH 24
#define B_AX_PRODUCT_STRING_17_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_16_V1_SH 16
#define B_AX_PRODUCT_STRING_16_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_15_V1_SH 8
#define B_AX_PRODUCT_STRING_15_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_14_V1_SH 0
#define B_AX_PRODUCT_STRING_14_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_12_V1 0x50B8
#define B_AX_PRODUCT_STRING_1B_V1_SH 24
#define B_AX_PRODUCT_STRING_1B_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1A_V1_SH 16
#define B_AX_PRODUCT_STRING_1A_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_19_V1_SH 8
#define B_AX_PRODUCT_STRING_19_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_18_V1_SH 0
#define B_AX_PRODUCT_STRING_18_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_13_V1 0x50BC
#define B_AX_PRODUCT_STRING_1F_V1_SH 24
#define B_AX_PRODUCT_STRING_1F_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1E_V1_SH 16
#define B_AX_PRODUCT_STRING_1E_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1D_V1_SH 8
#define B_AX_PRODUCT_STRING_1D_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_1C_V1_SH 0
#define B_AX_PRODUCT_STRING_1C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_14_V1 0x50C0
#define B_AX_PRODUCT_STRING_23_V1_SH 24
#define B_AX_PRODUCT_STRING_23_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_22_V1_SH 16
#define B_AX_PRODUCT_STRING_22_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_21_V1_SH 8
#define B_AX_PRODUCT_STRING_21_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_20_V1_SH 0
#define B_AX_PRODUCT_STRING_20_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_15_V1 0x50C4
#define B_AX_PRODUCT_STRING_27_V1_SH 24
#define B_AX_PRODUCT_STRING_27_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_26_V1_SH 16
#define B_AX_PRODUCT_STRING_26_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_25_V1_SH 8
#define B_AX_PRODUCT_STRING_25_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_24_V1_SH 0
#define B_AX_PRODUCT_STRING_24_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_16_V1 0x50C8
#define B_AX_PRODUCT_STRING_2B_V1_SH 24
#define B_AX_PRODUCT_STRING_2B_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2A_V1_SH 16
#define B_AX_PRODUCT_STRING_2A_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_29_V1_SH 8
#define B_AX_PRODUCT_STRING_29_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_28_V1_SH 0
#define B_AX_PRODUCT_STRING_28_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_17_V1 0x50CC
#define B_AX_PRODUCT_STRING_2F_V1_SH 24
#define B_AX_PRODUCT_STRING_2F_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2E_V1_SH 16
#define B_AX_PRODUCT_STRING_2E_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2D_V1_SH 8
#define B_AX_PRODUCT_STRING_2D_V1_MSK 0xff
#define B_AX_PRODUCT_STRING_2C_V1_SH 0
#define B_AX_PRODUCT_STRING_2C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_18_V1 0x50D0
#define B_AX_SERIAL_NUMBER_STRING_3_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_3_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_2_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_2_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_1_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_1_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_0_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_0_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_19_V1 0x50D4
#define B_AX_SERIAL_NUMBER_STRING_7_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_7_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_6_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_6_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_5_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_5_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_4_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_4_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1A_V1 0x50D8
#define B_AX_SERIAL_NUMBER_STRING_B_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_B_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_A_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_A_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_9_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_9_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_8_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_8_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1B_V1 0x50DC
#define B_AX_SERIAL_NUMBER_STRING_F_V1_SH 24
#define B_AX_SERIAL_NUMBER_STRING_F_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_E_V1_SH 16
#define B_AX_SERIAL_NUMBER_STRING_E_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_D_V1_SH 8
#define B_AX_SERIAL_NUMBER_STRING_D_V1_MSK 0xff
#define B_AX_SERIAL_NUMBER_STRING_C_V1_SH 0
#define B_AX_SERIAL_NUMBER_STRING_C_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1C_V1 0x50E0
#define B_AX_USB3_U2SEL_V1_SH 16
#define B_AX_USB3_U2SEL_V1_MSK 0xffff
#define B_AX_USB3_U1PEL_V1_SH 0
#define B_AX_USB3_U1PEL_V1_MSK 0xffff

#define R_AX_USB_HOST_REQUEST_1D_V1 0x50E4
#define B_AX_HW_VENDOR_INDEX_V1_SH 16
#define B_AX_HW_VENDOR_INDEX_V1_MSK 0xff

#define R_AX_USB_HOST_REQUEST_1E_V1 0x50E8
#define B_AX_DIS_STALL_FUNC_WAKE_V1 BIT(24)
#define B_AX_USB3_U2_DEV_EXIT_LAT_V1_SH 8
#define B_AX_USB3_U2_DEV_EXIT_LAT_V1_MSK 0xffff
#define B_AX_USB3_U1_DEV_EXIT_LAT_V1_SH 0
#define B_AX_USB3_U1_DEV_EXIT_LAT_V1_MSK 0xff

#define R_AX_USB3_MAC_LINK_0_V1 0x5100
#define B_AX_INTS_USB3_HRESET_EN_V1 BIT(31)
#define B_AX_INTS_USB3_RECOV_EN_V1 BIT(30)
#define B_AX_INTS_USB3_LPBK_EN_V1 BIT(29)
#define B_AX_INTS_USB3_RXDET_EN_V1 BIT(28)
#define B_AX_INTS_USB3_POLL_EN_V1 BIT(27)
#define B_AX_INTS_USB3_U3_EN_V1 BIT(26)
#define B_AX_INTS_USB3_U1U2_EN_V1 BIT(25)
#define B_AX_INTS_USB3_U0_EN_V1 BIT(24)
#define B_AX_INTS_USB3_RECOV2U0_EN_V1 BIT(23)
#define B_AX_INTS_USB3_SSINACT_EN_V1 BIT(22)
#define B_AX_INTS_USB3_SSDIS_EN_V1 BIT(21)
#define B_AX_INTS_USB3_CMPLY_EN_V1 BIT(20)
#define B_AX_INTS_USB3_RECOV2U0_V1 BIT(19)
#define B_AX_INTS_USB3_SSINACT_V1 BIT(18)
#define B_AX_INTS_USB3_SSDIS_V1 BIT(17)
#define B_AX_INTS_USB3_CMPLY_V1 BIT(16)
#define B_AX_INTS_USB3_HRESET_V1 BIT(15)
#define B_AX_INTS_USB3_RECOV_V1 BIT(14)
#define B_AX_INTS_USB3_LPBK_V1 BIT(13)
#define B_AX_INTS_USB3_RXDET_V1 BIT(12)
#define B_AX_INTS_USB3_POLL_V1 BIT(11)
#define B_AX_INTS_USB3_U3_V1 BIT(10)
#define B_AX_INTS_USB3_U1U2_V1 BIT(9)
#define B_AX_INTS_USB3_U0_V1 BIT(8)
#define B_AX_EN_ROVIDLE_TIMEOUT_V1 BIT(6)
#define B_AX_EN_UNFIN_RTY_V1 BIT(5)
#define B_AX_SSPHY_U1_QUICK_LFPS_V1 BIT(4)
#define B_AX_USB3_DIS_ISOC_TIME_GT_V1 BIT(3)
#define B_AX_R_DIS_USB3_U2_EN_V1 BIT(2)
#define B_AX_R_DIS_USB3_U1_EN_V1 BIT(1)
#define B_AX_LINK_ST_DETECT_TERM_V1 BIT(0)

#define R_AX_USB3_MAC_LINK_1_V1 0x5104
#define B_AX_WARM_RESET_TIME_V1_SH 0
#define B_AX_WARM_RESET_TIME_V1_MSK 0x3

#define R_AX_USB3_MAC_PIU_V1 0x5108
#define B_AX_SSPHY_CLR_TERM_V1 BIT(1)
#define B_AX_SSPHY_SET_TERM_V1 BIT(0)

#define R_AX_USB3_MAC_PTL_V1 0x510C
#define B_AX_BCDVALUE_V1_SH 2
#define B_AX_BCDVALUE_V1_MSK 0x3
#define B_AX_WLAN0_BUF_NUMP_EN_V1 BIT(1)
#define B_AX_IGNORE_RETRY_BIT_V1 BIT(0)

#define R_AX_USB3_MAC_PRTSM_V1 0x5110
#define B_AX_EN_IMMED_POP_CREDIT_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_0_V1 0x5114
#define B_AX_SSPHY_LFPS_FILTER_V1 BIT(31)
#define B_AX_SSPHY_TX_SWING_V1 BIT(30)
#define B_AX_SSPHY_TXMARGIN_V1_SH 27
#define B_AX_SSPHY_TXMARGIN_V1_MSK 0x7
#define B_AX_SSPHY_TXDEEMPHASIS_V1_SH 25
#define B_AX_SSPHY_TXDEEMPHASIS_V1_MSK 0x3
#define B_AX_SSPHY_ELASTIC_BUF_V1 BIT(24)
#define B_AX_HIRD_THR_V1_SH 19
#define B_AX_HIRD_THR_V1_MSK 0x1f
#define B_AX_DEV_SPEED_V1_SH 16
#define B_AX_DEV_SPEED_V1_MSK 0x7
#define B_AX_U1_ACTIVE_TIMEOUT_V1_SH 8
#define B_AX_U1_ACTIVE_TIMEOUT_V1_MSK 0xff
#define B_AX_USB3_TARGET_LINK_STATE_V1_SH 4
#define B_AX_USB3_TARGET_LINK_STATE_V1_MSK 0xf
#define B_AX_APPL1RSP_V1 BIT(3)
#define B_AX_LPM_CAPABLE_V1 BIT(2)
#define B_AX_USB3_EOF_V1_SH 0
#define B_AX_USB3_EOF_V1_MSK 0x3

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_1_V1 0x5118
#define B_AX_NPI_SCALEDOWN_MODE_V1_SH 24
#define B_AX_NPI_SCALEDOWN_MODE_V1_MSK 0x3
#define B_AX_SSPHY_POWERDOWN_SCALE_V1_SH 8
#define B_AX_SSPHY_POWERDOWN_SCALE_V1_MSK 0x1fff
#define B_AX_SSPHY_U1_FAST_OUT_V1 BIT(7)
#define B_AX_SSPHY_P3_FOR_P2_V1 BIT(6)
#define B_AX_SSPHY_U1_RXVALID_V1 BIT(5)
#define B_AX_SSPHY_DIS_SCAMBLE_V1 BIT(4)
#define B_AX_SSPHY_SKIP_RXDETECT_V1 BIT(3)
#define B_AX_SSPHY_LFPS_P0_ALIGN_V1 BIT(2)
#define B_AX_SSPHY_P3P2_TRANS_V1 BIT(1)
#define B_AX_SSPHY_P3_EXITIN_P2_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_CONFIG_INTF_2_V1 0x511C
#define B_AX_SSPHY_U2EXIT_LPFS_V1 BIT(18)
#define B_AX_SSPHY_PHYSOFTRST_V1 BIT(17)
#define B_AX_SSPHY_HSTPRTCMPL_V1 BIT(16)
#define B_AX_SSPHY_U2SSINACTP3OK_V1 BIT(15)
#define B_AX_SSPHY_DISRXDETP3_V1 BIT(14)
#define B_AX_SSPHY_UX_EXIT_IN_PX_V1 BIT(13)
#define B_AX_SSPHY_PING_ENH_EN_V1 BIT(12)
#define B_AX_SSPHY_U1U2EXITFAIL_TO_RECOV_V1 BIT(11)
#define B_AX_SSPHY_ALWAYS_REQ_V1 BIT(10)
#define B_AX_SSPHY_START_RX_DET_V1 BIT(9)
#define B_AX_SSPHY_DIS_RX_DET_V1 BIT(8)
#define B_AX_SSPHY_DELAY_P1P2P3_V1_SH 5
#define B_AX_SSPHY_DELAY_P1P2P3_V1_MSK 0x7
#define B_AX_SSPHY_SUSPEND_EN_V1 BIT(4)
#define B_AX_SSPHY_DATWIDTH_V1_SH 2
#define B_AX_SSPHY_DATWIDTH_V1_MSK 0x3
#define B_AX_SSPHY_ABORTRXDETLNU2_V1 BIT(1)
#define B_AX_SSPHY_RX_DETECT_LPFS_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_0_V1 0x5120
#define B_AX_U3_LTM_EN_V1 BIT(28)
#define B_AX_LINK_STATE_REQ_V1_SH 24
#define B_AX_LINK_STATE_REQ_V1_MSK 0xf
#define B_AX_SUSCLK_RATIO_V1_SH 8
#define B_AX_SUSCLK_RATIO_V1_MSK 0x1fff
#define B_AX_TEST_CTRL_V1_SH 4
#define B_AX_TEST_CTRL_V1_MSK 0xf
#define B_AX_UFRAME_SCALE_V1_SH 2
#define B_AX_UFRAME_SCALE_V1_MSK 0x3
#define B_AX_LOCAL_LBK_V1 BIT(1)
#define B_AX_EN_SLEEP_USB_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_1_V1 0x5124
#define B_AX_WAKE_WAIT_XTAL_V1 BIT(27)
#define B_AX_WAKE_WAIT_CURRENT_V1 BIT(26)
#define B_AX_WAKEUP_NEG_SEL_V1 BIT(25)
#define B_AX_SSPHY_USB3_ATTEMPT_V1 BIT(24)
#define B_AX_WAIT_IDLE_TIME_V1_SH 20
#define B_AX_WAIT_IDLE_TIME_V1_MSK 0xf
#define B_AX_U2_EN_MAC_IDLE_V1 BIT(18)
#define B_AX_U1_EN_MAC_IDLE_V1 BIT(17)
#define B_AX_SWITCH_CLK_EN_V1 BIT(16)
#define B_AX_USB3_SAMPLE_RXELECIDLE_V1_SH 8
#define B_AX_USB3_SAMPLE_RXELECIDLE_V1_MSK 0xff
#define B_AX_U3_INIT_U2_V1 BIT(7)
#define B_AX_U3_INIT_U1_V1 BIT(6)
#define B_AX_SET_U3_WAKE_V1 BIT(5)
#define B_AX_U3_U2_EN_V1 BIT(4)
#define B_AX_U3_U1_EN_V1 BIT(3)
#define B_AX_U3_INIT_U2_EN_V1 BIT(2)
#define B_AX_U3_INIT_U1_EN_V1 BIT(1)
#define B_AX_USB3_RUN_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_POWER_2_V1 0x5128
#define B_AX_NPI_LINK_STATE_LATCH_V1_SH 16
#define B_AX_NPI_LINK_STATE_LATCH_V1_MSK 0xff
#define B_AX_NPI_HOST_RESUME_DETECTED_V1 BIT(15)
#define B_AX_NPI_DEV_CONNECT_SPEED_V1_SH 12
#define B_AX_NPI_DEV_CONNECT_SPEED_V1_MSK 0x7
#define B_AX_NPI_LINK_STATE_V1_SH 8
#define B_AX_NPI_LINK_STATE_V1_MSK 0xf
#define B_AX_POLL_EN_V1 BIT(7)
#define B_AX_POLL_SAMPLE_ON_V1 BIT(6)
#define B_AX_POLL_ACT_V1_SH 4
#define B_AX_POLL_ACT_V1_MSK 0x3
#define B_AX_POLL_NOACT_V1_SH 0
#define B_AX_POLL_NOACT_V1_MSK 0xf

#define R_AX_USB3_MAC_NPI_POWER_3_V1 0x512C
#define B_AX_R_CNT_SWITCH_USB32_PARA_V1_SH 0
#define B_AX_R_CNT_SWITCH_USB32_PARA_V1_MSK 0xffff

#define R_AX_USB3_MAC_NPI_STATUS_V1 0x5130
#define B_AX_NPI_DEV_CONNECTED_V1 BIT(0)

#define R_AX_USB3_MAC_NPI_DEVICE_NOTIFICATION_V1 0x5134
#define B_AX_DEVNOTE_BIA_V1_SH 16
#define B_AX_DEVNOTE_BIA_V1_MSK 0xffff
#define B_AX_DEVNOTE_BELT_V1_SH 0
#define B_AX_DEVNOTE_BELT_V1_MSK 0xfff

#define R_AX_USB3_MAC_NPI_TRANSMIT_V1 0x5138
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_V1_SH 0
#define B_AX_NPI_TX_ACK_TP_DATA_WAIT_V1_MSK 0xf

#define R_AX_USB3_MAC_NPI_OTHERS_V1 0x513C
#define B_AX_EN_FIX_RX_ABORT_V1 BIT(8)
#define B_AX_FLADJ_30MHZ_REG_V1_SH 0
#define B_AX_FLADJ_30MHZ_REG_V1_MSK 0x3f

#define R_AX_USB3_WRAP_0_V1 0x5140
#define B_AX_U1TOU2_TIMER_V1_SH 24
#define B_AX_U1TOU2_TIMER_V1_MSK 0xff
#define B_AX_WAKE_ST_DBG_V1_SH 20
#define B_AX_WAKE_ST_DBG_V1_MSK 0xf
#define B_AX_ARB_ST_DBG_V1_SH 18
#define B_AX_ARB_ST_DBG_V1_MSK 0x3
#define B_AX_BIA_REQ_V1 BIT(17)
#define B_AX_BELT_REQ_V1 BIT(16)
#define B_AX_USB3_VENDOR_LEN_TH_V1_SH 0
#define B_AX_USB3_VENDOR_LEN_TH_V1_MSK 0xffff

#define R_AX_USB3_WRAP_1_V1 0x5144
#define B_AX_DIS_PKT_FUNC_WAKE_V1 BIT(0)

#define R_AX_USB3_PHY_V1 0x5148
#define B_AX_USB3_PHY_RWDATA_V1_SH 16
#define B_AX_USB3_PHY_RWDATA_V1_MSK 0xffff
#define B_AX_USB3_PHY_ADR_V1_SH 8
#define B_AX_USB3_PHY_ADR_V1_MSK 0x1f
#define B_AX_USB3_PHY_REG_WRFLAG_V1 BIT(7)
#define B_AX_USB3_PHY_REG_RDFLAG_V1 BIT(6)
#define B_AX_USB3_PHY_REG_ADR_V1_SH 0
#define B_AX_USB3_PHY_REG_ADR_V1_MSK 0x1f

#define R_AX_USB3_OTHERS_V1 0x5150
#define B_AX_R_REATTACH_TIMER_V1_SH 28
#define B_AX_R_REATTACH_TIMER_V1_MSK 0xf
#define B_AX_R_CNT_MS_SEL_V1_SH 24
#define B_AX_R_CNT_MS_SEL_V1_MSK 0x7
#define B_AX_VENDOR_LPM_TEST_V1_SH 16
#define B_AX_VENDOR_LPM_TEST_V1_MSK 0xff
#define B_AX_ISOC_DELAY_VALUE_V1_SH 0
#define B_AX_ISOC_DELAY_VALUE_V1_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_0_V1 0x5160
#define B_AX_BTRX0_BUFFER_WADDR_V1_SH 24
#define B_AX_BTRX0_BUFFER_WADDR_V1_MSK 0xff
#define B_AX_USB_INTOKEN_TIMEOUT_V1_SH 20
#define B_AX_USB_INTOKEN_TIMEOUT_V1_MSK 0x7
#define B_AX_BRX_BUF_CHK_V1_SH 16
#define B_AX_BRX_BUF_CHK_V1_MSK 0x7
#define B_AX_BTRX0_RPKT_SIZE_V1_SH 0
#define B_AX_BTRX0_RPKT_SIZE_V1_MSK 0xffff

#define R_AX_USB_APPLICATION_BT_1_V1 0x5164
#define B_AX_USB2BT_PWR_INFO_REG_MASK_V1_SH 20
#define B_AX_USB2BT_PWR_INFO_REG_MASK_V1_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_BT_V1 BIT(19)
#define B_AX_LOWPOWER_BT_V1 BIT(18)
#define B_AX_FUNCTION_WAKE_EN_BT_V1 BIT(17)
#define B_AX_FUNCTION_WAKE_CAPABLE_BT_V1 BIT(16)
#define B_AX_BT_ISO_ZERO_EN_V1 BIT(14)
#define B_AX_R_RXDMA_MODE_V1_SH 12
#define B_AX_R_RXDMA_MODE_V1_MSK 0x3
#define B_AX_GPS_USB_ACTIVE_V1 BIT(11)
#define B_AX_BT_TXQ_STOP_V1_SH 8
#define B_AX_BT_TXQ_STOP_V1_MSK 0x7

#define R_AX_USB_APPLICATION_BT_2_V1 0x5168
#define B_AX_BT_TX_V1 BIT(17)
#define B_AX_BT_RX_V1 BIT(16)
#define B_AX_BTTX_FIFO_OVER_EP3_V1 BIT(13)
#define B_AX_BTTX_FIFO_OVER_EP2_V1 BIT(12)
#define B_AX_BTTX_FIFO_OVER_EP0_V1 BIT(11)
#define B_AX_BTRX_FIFO_OVER_EP3_V1 BIT(10)
#define B_AX_BTRX_FIFO_OVER_EP2_V1 BIT(9)
#define B_AX_BTRX_FIFO_OVER_EP1_V1 BIT(8)
#define B_AX_BTTX_FIFO_UNDR_EP3_V1 BIT(5)
#define B_AX_BTTX_FIFO_UNDR_EP2_V1 BIT(4)
#define B_AX_BTTX_FIFO_UNDR_EP0_V1 BIT(3)
#define B_AX_BTRX_FIFO_UNDR_EP3_V1 BIT(2)
#define B_AX_BTRX_FIFO_UNDR_EP2_V1 BIT(1)
#define B_AX_BTRX_FIFO_UNDR_EP1_V1 BIT(0)

#define R_AX_USB_APPLICATION_BT_3_V1 0x516C
#define B_AX_DBG_BTRX_WADDR_V1_SH 16
#define B_AX_DBG_BTRX_WADDR_V1_MSK 0xfff
#define B_AX_DBG_BTRX_RPKT_V1_SH 0
#define B_AX_DBG_BTRX_RPKT_V1_MSK 0xffff

#define R_AX_USB_WLAN0_0_V1 0x5170
#define B_AX_WLAN_INT_LEN_V1_SH 16
#define B_AX_WLAN_INT_LEN_V1_MSK 0xffff
#define B_AX_WLAN0_TXQ_STALL_DIS_V1 BIT(4)
#define B_AX_FUNCTION_SUSB_EN_WLAN0_V1 BIT(3)
#define B_AX_LOWPOWER_WLAN0_V1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN0_V1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN0_V1 BIT(0)

#define R_AX_USB_WLAN0_1_V1 0x5174
#define B_AX_USBRX_RST_V1 BIT(9)
#define B_AX_USBTX_RST_V1 BIT(8)
#define B_AX_R_USBRX_SRAM_LS_V1 BIT(7)
#define B_AX_R_USBRX_SRAM_DS_V1 BIT(6)
#define B_AX_R_USBTX_SRAM_LS_V1 BIT(5)
#define B_AX_R_USBTX_SRAM_DS_V1 BIT(4)
#define B_AX_WLRX_FIFO_OVER_V1_SH 2
#define B_AX_WLRX_FIFO_OVER_V1_MSK 0x3
#define B_AX_WLRX_FIFO_UNDR_V1_SH 0
#define B_AX_WLRX_FIFO_UNDR_V1_MSK 0x3

#define R_AX_USB_AUTO_INSTALL_0_V1 0x5180
#define B_AX_AINST_POLL_1_V1 BIT(28)
#define B_AX_AINST_POLL_0_V1 BIT(27)
#define B_AX_AINST_TX1_CLR_BUF_V1 BIT(26)
#define B_AX_AINST_TX0_CLR_BUF_V1 BIT(25)
#define B_AX_WLAN_FW_RDY_V1 BIT(24)
#define B_AX_RECONF_USBEP_V1 BIT(23)
#define B_AX_RECONF_USBEP_EN_V1 BIT(22)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET_V1 BIT(21)
#define B_AX_BULK_ONLY_MASS_STORAGE_RESET_EN_V1 BIT(20)
#define B_AX_AINST_RXLEN_V1_SH 8
#define B_AX_AINST_RXLEN_V1_MSK 0xfff
#define B_AX_AINST_RX1_INTR_V1 BIT(7)
#define B_AX_AINST_RX0_INTR_V1 BIT(6)
#define B_AX_AINXT_TX1_INTR_V1 BIT(5)
#define B_AX_AINST_TX0_INTR_V1 BIT(4)
#define B_AX_AUTO_INST_TXQ_STALL_DIS_V1 BIT(3)
#define B_AX_LOWPOWER_AINST_V1 BIT(2)
#define B_AX_FUNCTION_WANE_EN_AINST_V1 BIT(1)

#define R_AX_USB_AUTO_INSTALL_1_V1 0x5184
#define B_AX_AINST_TX1LEN_V1_SH 16
#define B_AX_AINST_TX1LEN_V1_MSK 0xfff
#define B_AX_AINST_TX0LEN_V1_SH 0
#define B_AX_AINST_TX0LEN_V1_MSK 0xfff

#define R_AX_USB_AUTO_INSTALL_2_V1 0x5188
#define B_AX_AINST_PID_V1_SH 16
#define B_AX_AINST_PID_V1_MSK 0xffff
#define B_AX_AINST_VID_V1_SH 0
#define B_AX_AINST_VID_V1_MSK 0xffff

#define R_AX_USB_AUTO_INSTALL_3_V1 0x518C
#define B_AX_AINST_TXSTATUS_V1_SH 8
#define B_AX_AINST_TXSTATUS_V1_MSK 0xff
#define B_AX_AINST_RXSTATUS_V1_SH 0
#define B_AX_AINST_RXSTATUS_V1_MSK 0xff

#define R_AX_USB_BRIDGE_UART_0_V1 0x5190
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_V1_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB2_V1_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_V1_SH 16
#define B_AX_BRIDGE_XFACTOR_V1_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB2_V1_SH 0
#define B_AX_BRIDGE_BAUD_USB2_V1_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_1_V1 0x5194
#define B_AX_BRIDGE_WAKEUP_EN_V1_SH 30
#define B_AX_BRIDGE_WAKEUP_EN_V1_MSK 0x3
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_V1_SH 16
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_LOWERBOUND_V1_MSK 0xfff
#define B_AX_BRIDGE_LE_CON_HAN_VLD_V1 BIT(9)
#define B_AX_BRIDGE_LE_ON_V1 BIT(8)
#define B_AX_BRIDGE_DEBUG_PKTCNT_EN_V1 BIT(6)
#define B_AX_BRIDGE_RESET_RCV_SEL_V1 BIT(5)
#define B_AX_BRIDGE_WLS0_V1 BIT(4)
#define B_AX_BRIDGE_STB_V1 BIT(3)
#define B_AX_BRIDGE_PEN_V1 BIT(2)
#define B_AX_BRIDGE_EPS_V1 BIT(1)
#define B_AX_BRIDGE_STKP_V1 BIT(0)

#define R_AX_USB_BRIDGE_UART_2_V1 0x5198
#define B_AX_BRIDGE_DEBUG_SEL_V1_SH 24
#define B_AX_BRIDGE_DEBUG_SEL_V1_MSK 0xff
#define B_AX_R_BRIDGE_UARTEN_V1 BIT(23)
#define B_AX_BRIDGE_LPM_EN_V1 BIT(22)
#define B_AX_BRIDGE_TXSCO_TIME_INTERVAL_EN_V1 BIT(21)
#define B_AX_BRIDGE_TXSCO_PKT_LEN_MAT_EN_V1 BIT(20)
#define B_AX_BRIDGE_TXSCO_CON_HAN_MAT_EN_V1 BIT(19)
#define B_AX_BRIDGE_USB_TX_HCICMDLEN_SEL_V1 BIT(18)
#define B_AX_R_BRIDGE_JCIRXEN_V1 BIT(17)
#define B_AX_R_BRIDGE_HCITXEN_V1 BIT(16)
#define B_AX_BRIDGE_RXSCOBUF_FLOW_SEL_V1_SH 12
#define B_AX_BRIDGE_RXSCOBUF_FLOW_SEL_V1_MSK 0xf
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_V1_SH 0
#define B_AX_BRIDGE_LE_CON_HAN_VALUE_UPPERBOUND_V1_MSK 0xfff

#define R_AX_USB_BRIDGE_UART_3_V1 0x519C
#define B_AX_BRIDGE_URT_RXINDIC_ERR_V1 BIT(31)
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_V1_SH 24
#define B_AX_BRIDGE_LE_SHORTPKTERR_CNT_V1_MSK 0x7f
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_V1_SH 16
#define B_AX_BRIDGE_ACL_SHORTPKTERR_CNT_V1_MSK 0xff
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_V1_SH 8
#define B_AX_BRIDGE_LE_LONGPKTERR_CNT_V1_MSK 0xff
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_V1_SH 0
#define B_AX_BRIDGE_ACL_LONGPKTERR_CNT_V1_MSK 0xff

#define R_AX_USB_BRIDGE_UART_4_V1 0x51A0
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_V1_SH 20
#define B_AX_BRIDGE_XFACTOR_ADJ_USB3_V1_MSK 0xfff
#define B_AX_BRIDGE_XFACTOR_USB3_V1_SH 16
#define B_AX_BRIDGE_XFACTOR_USB3_V1_MSK 0xf
#define B_AX_BRIDGE_BAUD_USB3_V1_SH 0
#define B_AX_BRIDGE_BAUD_USB3_V1_MSK 0xfff

#define R_AX_USB_BT_BRIDGE_V1 0x51A8
#define B_AX_R_DIS_BTBRI_SS_SYSON_V1 BIT(2)
#define B_AX_R_DIS_BTBRI_SS_STS_V1 BIT(1)
#define B_AX_R_DIS_BTBRI_L1U2_STS_V1 BIT(0)

#define R_AX_USB_DMA_WRAPPER_V1 0x51B0
#define B_AX_PKT_BASE_EN_V1 BIT(11)
#define B_AX_FUNCTION_SUSB_OPT_V1 BIT(8)
#define B_AX_TX7LEN_MISMATCH_V1 BIT(7)
#define B_AX_TX6LEN_MISMATCH_V1 BIT(6)
#define B_AX_TX5LEN_MISMATCH_V1 BIT(5)
#define B_AX_TX4LEN_MISMATCH_V1 BIT(4)
#define B_AX_TX3LEN_MISMATCH_V1 BIT(3)
#define B_AX_TX2LEN_MISMATCH_V1 BIT(2)
#define B_AX_TX1LEN_MISMATCH_V1 BIT(1)
#define B_AX_TX0LEN_MISMATCH_V1 BIT(0)

#define R_AX_USB_WLAN1_V1 0x51B8
#define B_AX_WLAN_TX_V1 BIT(12)
#define B_AX_WLAN_RX_V1 BIT(11)
#define B_AX_WLAN1_TXQ_STALL_DIS_V1 BIT(10)
#define B_AX_WLAN1_RXQ_STOP_V1_SH 8
#define B_AX_WLAN1_RXQ_STOP_V1_MSK 0x3
#define B_AX_WLAN1_TXQ_STOP_V1_SH 4
#define B_AX_WLAN1_TXQ_STOP_V1_MSK 0xf
#define B_AX_FUNCTION_SUSB_EN_WLAN1_V1 BIT(3)
#define B_AX_LOWPOWER_WLAN1_V1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_WLAN1_V1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_WLAN1_V1 BIT(0)

#define R_AX_USB_GPS_V1 0x51C0
#define B_AX_FUNCTION_SUSB_EN_GPS_V1 BIT(3)
#define B_AX_LOWPOWER_GPS_V1 BIT(2)
#define B_AX_FUNCTION_WAKE_EN_GPS_V1 BIT(1)
#define B_AX_FUNCTION_WAKE_CAPABLE_GPS_V1 BIT(0)

#define R_AX_USB_DEBUG_0_V1 0x51D0
#define B_AX_SLEEP_GNT_BT_V1 BIT(17)
#define B_AX_SLEEP_REQ_BT_V1 BIT(16)
#define B_AX_DEBUG_SIGNAL_001_V1_SH 8
#define B_AX_DEBUG_SIGNAL_001_V1_MSK 0xff
#define B_AX_USB_DBGO_SEL_V1_SH 0
#define B_AX_USB_DBGO_SEL_V1_MSK 0xff

#define R_AX_USB_DEBUG_1_V1 0x51D4
#define B_AX_EP7_COUNTER_V1_SH 28
#define B_AX_EP7_COUNTER_V1_MSK 0xf
#define B_AX_EP6_COUNTER_V1_SH 24
#define B_AX_EP6_COUNTER_V1_MSK 0xf
#define B_AX_EP5_COUNTER_V1_SH 20
#define B_AX_EP5_COUNTER_V1_MSK 0xf
#define B_AX_EP4_COUNTER_V1_SH 16
#define B_AX_EP4_COUNTER_V1_MSK 0xf
#define B_AX_EP3_COUNTER_V1_SH 12
#define B_AX_EP3_COUNTER_V1_MSK 0xf
#define B_AX_EP2_COUNTER_V1_SH 8
#define B_AX_EP2_COUNTER_V1_MSK 0xf
#define B_AX_EP1_COUNTER_V1_SH 4
#define B_AX_EP1_COUNTER_V1_MSK 0xf
#define B_AX_EP0_COUNTER_V1_SH 0
#define B_AX_EP0_COUNTER_V1_MSK 0xf

#define R_AX_USB_DEBUG_2_V1 0x51D8
#define B_AX_EP15_COUNTER_V1_SH 28
#define B_AX_EP15_COUNTER_V1_MSK 0xf
#define B_AX_EP14_COUNTER_V1_SH 24
#define B_AX_EP14_COUNTER_V1_MSK 0xf
#define B_AX_EP13_COUNTER_V1_SH 20
#define B_AX_EP13_COUNTER_V1_MSK 0xf
#define B_AX_EP12_COUNTER_V1_SH 16
#define B_AX_EP12_COUNTER_V1_MSK 0xf
#define B_AX_EP11_COUNTER_V1_SH 12
#define B_AX_EP11_COUNTER_V1_MSK 0xf
#define B_AX_EP10_COUNTER_V1_SH 8
#define B_AX_EP10_COUNTER_V1_MSK 0xf
#define B_AX_EP9_COUNTER_V1_SH 4
#define B_AX_EP9_COUNTER_V1_MSK 0xf
#define B_AX_EP8_COUNTER_V1_SH 0
#define B_AX_EP8_COUNTER_V1_MSK 0xf

#define R_AX_USB_DEBUG_3_V1 0x51DC
#define B_AX_RX_STATE_MACHINE_V1_SH 24
#define B_AX_RX_STATE_MACHINE_V1_MSK 0xff
#define B_AX_TX_STATE_MACHINE_V1_SH 16
#define B_AX_TX_STATE_MACHINE_V1_MSK 0xff
#define B_AX_IO_STATE_MACHINE_V1_SH 8
#define B_AX_IO_STATE_MACHINE_V1_MSK 0xff
#define B_AX_REG_WRITE_COUNTER_V1_SH 4
#define B_AX_REG_WRITE_COUNTER_V1_MSK 0xf
#define B_AX_REG_READ_COUNTER_V1_SH 0
#define B_AX_REG_READ_COUNTER_V1_MSK 0xf

#define R_AX_USB_DEBUG_4_V1 0x51E0
#define B_AX_EP15_CNT_DIRECT_V1 BIT(31)
#define B_AX_EP14_CNT_DIRECT_V1 BIT(30)
#define B_AX_EP13_CNT_DIRECT_V1 BIT(29)
#define B_AX_EP12_CNT_DIRECT_V1 BIT(28)
#define B_AX_EP11_CNT_DIRECT_V1 BIT(27)
#define B_AX_EP10_CNT_DIRECT_V1 BIT(26)
#define B_AX_EP9_CNT_DIRECT_V1 BIT(25)
#define B_AX_EP8_CNT_DIRECT_V1 BIT(24)
#define B_AX_EP7_CNT_DIRECT_V1 BIT(23)
#define B_AX_EP6_CNT_DIRECT_V1 BIT(22)
#define B_AX_EP5_CNT_DIRECT_V1 BIT(21)
#define B_AX_EP4_CNT_DIRECT_V1 BIT(20)
#define B_AX_EP3_CNT_DIRECT_V1 BIT(19)
#define B_AX_EP2_CNT_DIRECT_V1 BIT(18)
#define B_AX_EP1_CNT_DIRECT_V1 BIT(17)
#define B_AX_EP0_CNT_DIRECT_V1 BIT(16)
#define B_AX_HW_TXVLD_TOGGLE_EN_V1 BIT(15)
#define B_AX_HW_FORCE_TXRDY_EN_V1 BIT(14)
#define B_AX_TXVLD_TOGGLE_VAL_V1_SH 8
#define B_AX_TXVLD_TOGGLE_VAL_V1_MSK 0xf
#define B_AX_TXVLD_TOUT_VAL_V1_SH 0
#define B_AX_TXVLD_TOUT_VAL_V1_MSK 0xff

#define R_AX_USB_DEBUG_5_V1 0x51E4
#define B_AX_ON_IOH_ADDR_V1_SH 8
#define B_AX_ON_IOH_ADDR_V1_MSK 0xffffff
#define B_AX_ON_IOH_TIMER_V1_SH 4
#define B_AX_ON_IOH_TIMER_V1_MSK 0xf
#define B_AX_ON_IOH_EMPTY_V1 BIT(2)
#define B_AX_ON_IOH_FLAG_V1 BIT(1)
#define B_AX_ON_IOH_EN_V1 BIT(0)

#define R_AX_USB_DEBUG_6_V1 0x51E8
#define B_AX_OFF_IOH_ADDR_V1_SH 8
#define B_AX_OFF_IOH_ADDR_V1_MSK 0xffffff
#define B_AX_OFF_IOH_TIMER_V1_SH 4
#define B_AX_OFF_IOH_TIMER_V1_MSK 0xf
#define B_AX_OFF_IOH_FLAG_V1 BIT(1)
#define B_AX_OFF_IOH_EN_V1 BIT(0)

#define R_AX_USB_STATUS_V1 0x51F0
#define B_AX_USB_EP_NUM_V1_SH 4
#define B_AX_USB_EP_NUM_V1_MSK 0xf
#define B_AX_R_SSIC_EN_V1 BIT(2)
#define B_AX_R_USB2_SEL_V1 BIT(1)
#define B_AX_MODE_HS_V1 BIT(0)

#define R_AX_USB_D2F_F2D_INFO_V1 0x5200
#define B_AX_HRPWM2_V1_SH 16
#define B_AX_HRPWM2_V1_MSK 0xffff
#define B_AX_CPWM2_V1_SH 0
#define B_AX_CPWM2_V1_MSK 0xffff

#define R_AX_USB3_V1 0x5220
#define B_AX_U3_STATE_V1_SH 12
#define B_AX_U3_STATE_V1_MSK 0xf
#define B_AX_U3_SUB_STATE_V1_SH 8
#define B_AX_U3_SUB_STATE_V1_MSK 0xf
#define B_AX_HPS_CLKR_USB_V1_SH 0
#define B_AX_HPS_CLKR_USB_V1_MSK 0xff

#define R_AX_USB_OTHERS_0_V1 0x5230
#define B_AX_USBTX_EP3IF_OK_CNT_V1_SH 24
#define B_AX_USBTX_EP3IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP2IF_OK_CNT_V1_SH 16
#define B_AX_USBTX_EP2IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP1IF_OK_CNT_V1_SH 8
#define B_AX_USBTX_EP1IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP0IF_OK_CNT_V1_SH 0
#define B_AX_USBTX_EP0IF_OK_CNT_V1_MSK 0xff

#define R_AX_USB_OTHERS_1_V1 0x5234
#define B_AX_USBTX_EP7IF_OK_CNT_V1_SH 24
#define B_AX_USBTX_EP7IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP6IF_OK_CNT_V1_SH 16
#define B_AX_USBTX_EP6IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP5IF_OK_CNT_V1_SH 8
#define B_AX_USBTX_EP5IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP4IF_OK_CNT_V1_SH 0
#define B_AX_USBTX_EP4IF_OK_CNT_V1_MSK 0xff

#define R_AX_USB_OTHERS_2_V1 0x5238
#define B_AX_USBRX_DMAIF_OK_CNT_V1_SH 24
#define B_AX_USBRX_DMAIF_OK_CNT_V1_MSK 0xff
#define B_AX_USBRX_EPIF_OK_CNT_V1_SH 16
#define B_AX_USBRX_EPIF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP9IF_OK_CNT_V1_SH 8
#define B_AX_USBTX_EP9IF_OK_CNT_V1_MSK 0xff
#define B_AX_USBTX_EP8IF_OK_CNT_V1_SH 0
#define B_AX_USBTX_EP8IF_OK_CNT_V1_MSK 0xff

#define R_AX_USB_OTHERS_3_V1 0x523C
#define B_AX_VENDOR_LMP_LATCH_DATA_L_V1_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_L_V1_MSK 0xffffffffL

#define R_AX_USB_OTHERS_4_V1 0x5240
#define B_AX_VENDOR_LMP_LATCH_DATA_H_V1_SH 0
#define B_AX_VENDOR_LMP_LATCH_DATA_H_V1_MSK 0xffffffffL

#define R_AX_USB_OTHERS_5_V1 0x5244
#define B_AX_APPEND_ZERO_PKT_V1_SH 24
#define B_AX_APPEND_ZERO_PKT_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_7_V1_SH 21
#define B_AX_USB_AUTO_LOAD_EXTE_7_V1_MSK 0x3
#define B_AX_USB_AUTO_LOAD_EXTE_0_V1_SH 16
#define B_AX_USB_AUTO_LOAD_EXTE_0_V1_MSK 0x1f
#define B_AX_USB_AUTO_LOAD_EXTE_2_V1_SH 8
#define B_AX_USB_AUTO_LOAD_EXTE_2_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_1_V1_SH 0
#define B_AX_USB_AUTO_LOAD_EXTE_1_V1_MSK 0xff

#define R_AX_USB_OTHERS_6_V1 0x5248
#define B_AX_USB_AUTO_LOAD_STRING_3_V1_SH 24
#define B_AX_USB_AUTO_LOAD_STRING_3_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_2_V1_SH 16
#define B_AX_USB_AUTO_LOAD_STRING_2_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_1_V1_SH 8
#define B_AX_USB_AUTO_LOAD_STRING_1_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_0_V1_SH 0
#define B_AX_USB_AUTO_LOAD_STRING_0_V1_MSK 0xff

#define R_AX_USB_OTHERS_7_V1 0x524C
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_V1_SH 22
#define B_AX_USB_AUTO_LOAD_BRIDGE_FLAG_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_V1_SH 14
#define B_AX_USB_AUTO_LOAD_EXTE_FLAG_V1_MSK 0xff
#define B_AX_USB_AUTO_LOAD_STRING_FLAG_V1 BIT(13)
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_V1_SH 7
#define B_AX_USB_AUTO_LOAD_INIT2_FLAG_V1_MSK 0x3f
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_V1_SH 0
#define B_AX_USB_AUTO_LOAD_INIT1_FLAG_V1_MSK 0x7f

#define R_AX_USB_WATCHDOG_V1 0x5260
#define B_AX_USBIO_WD_FLAG_V1 BIT(31)
#define B_AX_USBIO_WD_EN_V1 BIT(30)
#define B_AX_USBIO_WD_TIMER_V1_SH 24
#define B_AX_USBIO_WD_TIMER_V1_MSK 0xf
#define B_AX_USBIO_WD_ADDR_V1_SH 0
#define B_AX_USBIO_WD_ADDR_V1_MSK 0xffffff

#define R_AX_HUSBIMR_V1 0x5270
#define B_AX_USB_CPUIO_TIMEOUT_INT_EN_V1 BIT(29)
#define B_AX_USB_HC1ISR_IDCT_INT_EN_V1 BIT(28)
#define B_AX_USB_HC0ISR_IDCT_INT_EN_V1 BIT(27)
#define B_AX_USB_HD1ISR_IDCT_INT_EN_V1 BIT(26)
#define B_AX_USB_HD0ISR_IDCT_INT_EN_V1 BIT(25)
#define B_AX_USB_HS1ISR_IDCT_INT_EN_V1 BIT(24)
#define B_AX_USB_HS0ISR_IDCT_INT_EN_V1 BIT(23)
#define B_AX_USB_TX_CH12_INT_EN_V1 BIT(7)
#define B_AX_USB_TX_CH10_INT_EN_V1 BIT(6)
#define B_AX_USB_TX_CH8_INT_EN_V1 BIT(5)
#define B_AX_USB_TX_CH6_INT_EN_V1 BIT(4)
#define B_AX_USB_TX_CH4_INT_EN_V1 BIT(3)
#define B_AX_USB_TX_CH2_INT_EN_V1 BIT(2)
#define B_AX_USB_TX_CH0_INT_EN_V1 BIT(1)
#define B_AX_USB_RX_INT_EN_V1 BIT(0)

#define R_AX_HUSBISR_V1 0x5274
#define B_AX_USB_CPUIO_TIMEOUT_INT_V1 BIT(29)
#define B_AX_USB_HC1ISR_IDCT_INT_V1 BIT(28)
#define B_AX_USB_HC0ISR_IDCT_INT_V1 BIT(27)
#define B_AX_USB_HD1ISR_IDCT_INT_V1 BIT(26)
#define B_AX_USB_HD0ISR_IDCT_INT_V1 BIT(25)
#define B_AX_USB_HS1ISR_IDCT_INT_V1 BIT(24)
#define B_AX_USB_HS0ISR_IDCT_INT_V1 BIT(23)
#define B_AX_USB_TX_CH12_INT_V1 BIT(7)
#define B_AX_USB_TX_CH10_INT_V1 BIT(6)
#define B_AX_USB_TX_CH8_INT_V1 BIT(5)
#define B_AX_USB_TX_CH6_INT_V1 BIT(4)
#define B_AX_USB_TX_CH4_INT_V1 BIT(3)
#define B_AX_USB_TX_CH2_INT_V1 BIT(2)
#define B_AX_USB_TX_CH0_INT_V1 BIT(1)
#define B_AX_USB_RX_INT_V1 BIT(0)
//
// WL_AX_Reg_WLCPU_Local.xls
//

//
// WLCPU_Local_Reg
//

#define R_AX_MAILBOX_WIFI2BT_DATA_L 0x0000
#define B_AX_MBOX_WIFI2BT_DATA_L_SH 0
#define B_AX_MBOX_WIFI2BT_DATA_L_MSK 0xffffffffL

#define R_AX_MAILBOX_WIFI2BT_DATA_H 0x0004
#define B_AX_MBOX_WIFI2BT_DATA_H_SH 0
#define B_AX_MBOX_WIFI2BT_DATA_H_MSK 0xffffffffL

#define R_AX_MAILBOX_WIFI2BT_READY 0x0008
#define B_AX_MBOX_OUT_ABORT BIT(7)
#define B_AX_MBOX_ACK_WIFI2BT BIT(0)

#define R_AX_MAILBOX_BT2WIFI_DATA_L 0x0010
#define B_AX_MBOX_BT2WIFI_DATA_L_SH 0
#define B_AX_MBOX_BT2WIFI_DATA_L_MSK 0xffffffffL

#define R_AX_MAILBOX_BT2WIFI_DATA_H 0x0014
#define B_AX_MBOX_BT2WIFI_DATA_H_SH 0
#define B_AX_MBOX_BT2WIFI_DATA_H_MSK 0xffffffffL

#define R_AX_MAILBOX_CTRL 0x0018
#define B_AX_I2C_MAILBOX_EN BIT(31)

#define R_AX_EXC_JUMP_ADDR 0x0020
#define B_AX_WLCPU_EXC_JUMP_ADDR_SH 0
#define B_AX_WLCPU_EXC_JUMP_ADDR_MSK 0xffffffffL

#define R_AX_CPU_BOOT_ADDR 0x0024
#define B_AX_WLCPU_BOOT_ADDR_SH 0
#define B_AX_WLCPU_BOOT_ADDR_MSK 0xffffffffL

#define R_AX_CPU_IDMEM_TO_CNT 0x0030
#define B_AX_CPU_DMEM_TO_CNT_TH_SH 16
#define B_AX_CPU_DMEM_TO_CNT_TH_MSK 0xffff
#define B_AX_CPU_IMEM_TO_CNT_TH_SH 0
#define B_AX_CPU_IMEM_TO_CNT_TH_MSK 0xffff

#define R_AX_WDT_CTRL 0x0040
#define B_AX_WDT_EN BIT(31)
#define B_AX_WDT_OPT_RESET_PLATFORM_EN BIT(29)
#define B_AX_WDT_CLR BIT(16)
#define B_AX_WDT_COUNT_SH 0
#define B_AX_WDT_COUNT_MSK 0xffff
#define B_AX_WDT_CTRL_ALL_DIS 0

#define R_AX_WDT_STATUS 0x0044
#define B_AX_FS_WDT_INT BIT(8)
#define B_AX_FS_WDT_INT_MSK BIT(0)

#define R_AX_WDT_CDC 0x0048
#define B_AX_WDT_CDC_SH 0
#define B_AX_WDT_CDC_MSK 0xffff

#define R_AX_INT1_CTRL_IND 0x0050
#define B_AX_FWC_INT_IND_SH 0
#define B_AX_FWC_INT_IND_MSK 0xfffff

#define R_AX_INT2_CTRL_IND 0x0054
#define B_AX_FWD_INT_IND_SH 0
#define B_AX_FWD_INT_IND_MSK 0x7

#define R_AX_INT3_CTRL_IND 0x0058
#define B_AX_FWS_INT_IND BIT(0)

#define R_AX_INT4_CTRL_IND 0x005C
#define B_AX_FWDA_INT_IND_SH 0
#define B_AX_FWDA_INT_IND_MSK 0x7

#define R_AX_INT5_CTRL_IND 0x0060
#define B_AX_SUB_SYS_ERR_IND_SH 29
#define B_AX_SUB_SYS_ERR_IND_MSK 0x7
#define B_AX_FWP_INT_IND_SH 0
#define B_AX_FWP_INT_IND_MSK 0x7

#define R_AX_USB_CTRL 0x0080
#define B_AX_USB2_SUSB_STS BIT(7)
#define B_AX_USB3_SUSB_STS BIT(6)
#define B_AX_ALLOW_WAKE_HOST BIT(5)
#define B_AX_WLCPU_WAKE_USB BIT(4)

#define B_AX_PD_REGU_L BIT(16)
#define B_AX_XTAL_OFF_A_DIE BIT(22)
#define B_AX_R_SYM_ISO_DMEM62PP BIT(29)
#define B_AX_R_SYM_ISO_DMEM52PP BIT(28)
#define B_AX_R_SYM_ISO_DMEM42PP BIT(27)
#define B_AX_R_SYM_ISO_DMEM32PP_V1 BIT(26)
#define B_AX_R_SYM_ISO_DMEM22PP_V1 BIT(25)
#define B_AX_R_SYM_ISO_DMEM12PP_V1 BIT(24)

#define R_AX_SDIO_HRPWM1_V1 0x4080

#define R_AX_FWD1ISR_V1 0x7804

#define R_AX_PCIE_HRPWM_V1 0x30C0

#define B_AX_DIS_WLBT_PDNSUSEN_SOPC BIT(18)
#define B_AX_DIS_WLBT_LPSEN_LOPC BIT(1)

#define R_AX_SPSLDO_ON_CTRL0 0x0200
#define B_AX_PFMCMP_IQ BIT(31)
#define B_AX_OFF_END_SEL BIT(29)
#define B_AX_POW_MINOFF_L BIT(28)
#define B_AX_COT_I_L_SH 26
#define B_AX_COT_I_L_MSK 0x3
#define B_AX_VREFPFM_L_SH 22
#define B_AX_VREFPFM_L_MSK 0xf
#define B_AX_FORCE_ZCD_BIAS BIT(21)
#define B_AX_ZCD_SDZ_L_SH 19
#define B_AX_ZCD_SDZ_L_MSK 0x3
#define B_AX_REG_ZCDC_H_SH 17
#define B_AX_REG_ZCDC_H_MSK 0x3
#define B_AX_POW_ZCD_L BIT(16)
#define B_AX_OCP_L1_SH 13
#define B_AX_OCP_L1_MSK 0x7
#define B_AX_POWOCP_L1 BIT(12)
#define B_AX_SAW_FREQ_L_SH 8
#define B_AX_SAW_FREQ_L_MSK 0xf
#define B_AX_REG_BYPASS_L BIT(7)
#define B_AX_FPWM_L1 BIT(6)
#define B_AX_STD_L1_SH 4
#define B_AX_STD_L1_MSK 0x3
#define B_AX_VOL_L1_SH 0
#define B_AX_VOL_L1_MSK 0xf

#define R_AX_SPS_DIG_ON_CTRL0 0x0200
#define B_AX_REG_BG_H BIT(30)

#endif
