% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-gitlab.R
\name{install_gitlab}
\alias{install_gitlab}
\title{Install a package from GitLab}
\usage{
install_gitlab(repo, auth_token = gitlab_pat(), host = "gitlab.com",
  dependencies = NA, upgrade = c("ask", "always", "never"),
  force = FALSE, quiet = FALSE, build = TRUE,
  build_opts = c("--no-resave-data", "--no-manual",
  "--no-build-vignettes"), repos = getOption("repos"),
  type = getOption("pkgType"), ...)
}
\arguments{
\item{repo}{Repository address in the format
\code{username/repo[/subdir][@ref]}.}

\item{auth_token}{To install from a private repo, generate a personal
access token (PAT) in \url{https://github.com/settings/applications} and
supply to this argument. This is safer than using a password because
you can easily delete a PAT without affecting any others. Defaults to
the \code{GITHUB_PAT} environment variable.}

\item{host}{GitLab API host to use. Override with your GitLab enterprise
hostname, for example, \code{"gitlab.hostname.com"}.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).}

\item{upgrade}{One of "ask", "always" or "never". "ask" prompts the user for
which out of date packages to upgrade. For non-interactive sessions "ask" is
equivalent to "always". \code{TRUE} and \code{FALSE} are also accepted and
correspond to "always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \code{R CMD build}, only used when \code{build}
is \code{TRUE}.}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.}

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This function is vectorised on \code{repo} so you can install multiple
packages in a single command. Like other remotes the repository will skip
installation if \code{force == FALSE} (the default) and the remote state has
not changed since the previous installation.
}
\examples{
\dontrun{
install_gitlab("jimhester/covr")
}
}
\seealso{
Other package installation: \code{\link{install_bioc}},
  \code{\link{install_bitbucket}},
  \code{\link{install_cran}}, \code{\link{install_dev}},
  \code{\link{install_github}}, \code{\link{install_git}},
  \code{\link{install_local}}, \code{\link{install_svn}},
  \code{\link{install_url}}, \code{\link{install_version}}
}
\concept{package installation}
