; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P10
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-PREP10,CHECK-P8

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_0___int128___int128(i64 %ptr) {
; CHECK-LABEL: ld_0___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r5, 0(r3)
; CHECK-NEXT:    ld r4, 8(r3)
; CHECK-NEXT:    mr r3, r5
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_unalign16___int128___int128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign16___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    li r4, 1
; CHECK-P10-NEXT:    ldx r5, r3, r4
; CHECK-P10-NEXT:    li r4, 9
; CHECK-P10-NEXT:    ldx r4, r3, r4
; CHECK-P10-NEXT:    mr r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_unalign16___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 1
; CHECK-P9-NEXT:    ldx r5, r3, r4
; CHECK-P9-NEXT:    li r4, 9
; CHECK-P9-NEXT:    ldx r4, r3, r4
; CHECK-P9-NEXT:    mr r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_unalign16___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 1
; CHECK-P8-NEXT:    li r6, 9
; CHECK-P8-NEXT:    ldx r5, r3, r4
; CHECK-P8-NEXT:    ldx r4, r3, r6
; CHECK-P8-NEXT:    mr r3, r5
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_align16___int128___int128(i8* nocapture readonly %ptr) {
; CHECK-LABEL: ld_align16___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r5, 8(r3)
; CHECK-NEXT:    ld r4, 16(r3)
; CHECK-NEXT:    mr r3, r5
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_unalign32___int128___int128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign32___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    ldux r5, r3, r4
; CHECK-P10-NEXT:    ld r4, 8(r3)
; CHECK-P10-NEXT:    mr r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign32___int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1
; CHECK-PREP10-NEXT:    ori r4, r4, 34463
; CHECK-PREP10-NEXT:    ldux r5, r3, r4
; CHECK-PREP10-NEXT:    ld r4, 8(r3)
; CHECK-PREP10-NEXT:    mr r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_align32___int128___int128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align32___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 99999000
; CHECK-P10-NEXT:    ldux r5, r3, r4
; CHECK-P10-NEXT:    ld r4, 8(r3)
; CHECK-P10-NEXT:    mr r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align32___int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 1525
; CHECK-PREP10-NEXT:    ori r4, r4, 56600
; CHECK-PREP10-NEXT:    ldux r5, r3, r4
; CHECK-PREP10-NEXT:    ld r4, 8(r3)
; CHECK-PREP10-NEXT:    mr r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_unalign64___int128___int128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_unalign64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    ldux r5, r3, r5
; CHECK-P10-NEXT:    ld r4, 8(r3)
; CHECK-P10-NEXT:    mr r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_unalign64___int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    ldux r5, r3, r4
; CHECK-PREP10-NEXT:    ld r4, 8(r3)
; CHECK-PREP10-NEXT:    mr r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000001
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_align64___int128___int128(i8* nocapture readonly %ptr) {
; CHECK-P10-LABEL: ld_align64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    ldux r5, r3, r4
; CHECK-P10-NEXT:    ld r4, 8(r3)
; CHECK-P10-NEXT:    mr r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_align64___int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, 3725
; CHECK-PREP10-NEXT:    ori r4, r4, 19025
; CHECK-PREP10-NEXT:    rldic r4, r4, 12, 24
; CHECK-PREP10-NEXT:    ldux r5, r3, r4
; CHECK-PREP10-NEXT:    ld r4, 8(r3)
; CHECK-PREP10-NEXT:    mr r3, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_reg___int128___int128(i8* nocapture readonly %ptr, i64 %off) {
; CHECK-LABEL: ld_reg___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ldux r5, r3, r4
; CHECK-NEXT:    ld r4, 8(r3)
; CHECK-NEXT:    mr r3, r5
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_or___int128___int128(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r4, r4, r3
; CHECK-NEXT:    ld r3, 0(r4)
; CHECK-NEXT:    ld r4, 8(r4)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_or2___int128___int128(i64 %ptr, i8 zeroext %off) {
; CHECK-LABEL: ld_or2___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r5, r3, 0, 51
; CHECK-NEXT:    rotldi r6, r3, 52
; CHECK-NEXT:    ldx r3, r5, r4
; CHECK-NEXT:    rldimi r4, r6, 12, 0
; CHECK-NEXT:    ld r4, 8(r4)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %off to i64
  %or = or i64 %and, %conv
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_not_disjoint16___int128___int128(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint16___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r4, r3, 6
; CHECK-NEXT:    ld r3, 0(r4)
; CHECK-NEXT:    ld r4, 8(r4)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_disjoint_unalign16___int128___int128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign16___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r4, r3, 0, 51
; CHECK-P10-NEXT:    li r3, 6
; CHECK-P10-NEXT:    li r5, 14
; CHECK-P10-NEXT:    ldx r3, r4, r3
; CHECK-P10-NEXT:    ldx r4, r4, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_unalign16___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    rldicr r4, r3, 0, 51
; CHECK-P9-NEXT:    li r3, 6
; CHECK-P9-NEXT:    li r5, 14
; CHECK-P9-NEXT:    ldx r3, r4, r3
; CHECK-P9-NEXT:    ldx r4, r4, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_unalign16___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 6
; CHECK-P8-NEXT:    rldicr r5, r3, 0, 51
; CHECK-P8-NEXT:    li r6, 14
; CHECK-P8-NEXT:    ldx r3, r5, r4
; CHECK-P8-NEXT:    ldx r4, r5, r6
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 6
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_disjoint_align16___int128___int128(i64 %ptr) {
; CHECK-LABEL: ld_disjoint_align16___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r4, r3, 0, 51
; CHECK-NEXT:    ld r3, 24(r4)
; CHECK-NEXT:    ld r4, 32(r4)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_not_disjoint32___int128___int128(i64 %ptr) {
; CHECK-LABEL: ld_not_disjoint32___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r4, r3, 1
; CHECK-NEXT:    ld r3, 0(r4)
; CHECK-NEXT:    ld r4, 8(r4)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_disjoint_unalign32___int128___int128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign32___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r4, r3, 0, 43
; CHECK-P10-NEXT:    pli r3, 99999
; CHECK-P10-NEXT:    pli r5, 100007
; CHECK-P10-NEXT:    ldx r3, r4, r3
; CHECK-P10-NEXT:    ldx r4, r4, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_unalign32___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, 1
; CHECK-P9-NEXT:    rldicr r4, r3, 0, 43
; CHECK-P9-NEXT:    ori r3, r5, 34463
; CHECK-P9-NEXT:    ori r5, r5, 34471
; CHECK-P9-NEXT:    ldx r3, r4, r3
; CHECK-P9-NEXT:    ldx r4, r4, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_unalign32___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r4, 1
; CHECK-P8-NEXT:    rldicr r5, r3, 0, 43
; CHECK-P8-NEXT:    ori r3, r4, 34463
; CHECK-P8-NEXT:    ori r4, r4, 34471
; CHECK-P8-NEXT:    ldx r3, r5, r3
; CHECK-P8-NEXT:    ldx r4, r5, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1048576
  %or = or i64 %and, 99999
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_disjoint_align32___int128___int128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align32___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r4, -15264
; CHECK-P10-NEXT:    pli r5, 999990008
; CHECK-P10-NEXT:    and r4, r3, r4
; CHECK-P10-NEXT:    pli r3, 999990000
; CHECK-P10-NEXT:    ldx r3, r4, r3
; CHECK-P10-NEXT:    ldx r4, r4, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_disjoint_align32___int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r4, -15264
; CHECK-PREP10-NEXT:    lis r5, 15258
; CHECK-PREP10-NEXT:    and r4, r3, r4
; CHECK-PREP10-NEXT:    ori r3, r5, 41712
; CHECK-PREP10-NEXT:    ori r5, r5, 41720
; CHECK-PREP10-NEXT:    ldx r3, r4, r3
; CHECK-PREP10-NEXT:    ldx r4, r4, r5
; CHECK-PREP10-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_not_disjoint64___int128___int128(i64 %ptr) {
; CHECK-P10-LABEL: ld_not_disjoint64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    or r4, r3, r5
; CHECK-P10-NEXT:    ld r3, 0(r4)
; CHECK-P10-NEXT:    ld r4, 8(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: ld_not_disjoint64___int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r4, 29
; CHECK-PREP10-NEXT:    rldic r4, r4, 35, 24
; CHECK-PREP10-NEXT:    oris r4, r4, 54437
; CHECK-PREP10-NEXT:    ori r4, r4, 4097
; CHECK-PREP10-NEXT:    or r4, r3, r4
; CHECK-PREP10-NEXT:    ld r3, 0(r4)
; CHECK-PREP10-NEXT:    ld r4, 8(r4)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_disjoint_unalign64___int128___int128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_unalign64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r4, r3, 0, 23
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r3, 3567587329
; CHECK-P10-NEXT:    pli r6, 3567587337
; CHECK-P10-NEXT:    rldimi r3, r5, 32, 0
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    ldx r3, r4, r3
; CHECK-P10-NEXT:    ldx r4, r4, r6
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_unalign64___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    rldicr r4, r3, 0, 23
; CHECK-P9-NEXT:    li r3, 29
; CHECK-P9-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-NEXT:    oris r5, r3, 54437
; CHECK-P9-NEXT:    ori r3, r5, 4097
; CHECK-P9-NEXT:    ori r5, r5, 4105
; CHECK-P9-NEXT:    ldx r3, r4, r3
; CHECK-P9-NEXT:    ldx r4, r4, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_unalign64___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldicr r5, r3, 0, 23
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    oris r3, r4, 54437
; CHECK-P8-NEXT:    ori r4, r3, 4097
; CHECK-P8-NEXT:    ori r6, r3, 4105
; CHECK-P8-NEXT:    ldx r3, r5, r4
; CHECK-P8-NEXT:    ldx r4, r5, r6
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 16
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_disjoint_align64___int128___int128(i64 %ptr) {
; CHECK-P10-LABEL: ld_disjoint_align64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r4, r3, 0, 23
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587336
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    ldx r3, r4, r3
; CHECK-P10-NEXT:    ldx r4, r4, r6
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_disjoint_align64___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r5, 29
; CHECK-P9-NEXT:    rldicr r4, r3, 0, 23
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    rldic r5, r5, 35, 24
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    oris r5, r5, 54437
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    ori r5, r5, 4104
; CHECK-P9-NEXT:    ldx r3, r4, r3
; CHECK-P9-NEXT:    ldx r4, r4, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_disjoint_align64___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r4, 29
; CHECK-P8-NEXT:    rldicr r5, r3, 0, 23
; CHECK-P8-NEXT:    lis r3, 3725
; CHECK-P8-NEXT:    rldic r4, r4, 35, 24
; CHECK-P8-NEXT:    ori r3, r3, 19025
; CHECK-P8-NEXT:    oris r4, r4, 54437
; CHECK-P8-NEXT:    rldic r3, r3, 12, 24
; CHECK-P8-NEXT:    ori r4, r4, 4104
; CHECK-P8-NEXT:    ldx r3, r5, r3
; CHECK-P8-NEXT:    ldx r4, r5, r4
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i128*
  %1 = load i128, i128* %0, align 4096
  ret i128 %1
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_cst_unalign16___int128___int128() {
; CHECK-LABEL: ld_cst_unalign16___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li r3, 255
; CHECK-NEXT:    li r4, 263
; CHECK-NEXT:    ld r3, 0(r3)
; CHECK-NEXT:    ld r4, 0(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i128, i128* inttoptr (i64 255 to i128*), align 16
  ret i128 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_cst_align16___int128___int128() {
; CHECK-LABEL: ld_cst_align16___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ld r3, 4080(0)
; CHECK-NEXT:    ld r4, 4088(0)
; CHECK-NEXT:    blr
entry:
  %0 = load i128, i128* inttoptr (i64 4080 to i128*), align 16
  ret i128 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_cst_unalign32___int128___int128() {
; CHECK-P10-LABEL: ld_cst_unalign32___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 99999
; CHECK-P10-NEXT:    pli r4, 100007
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    ld r4, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_unalign32___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r4, 1
; CHECK-P9-NEXT:    ori r3, r4, 34463
; CHECK-P9-NEXT:    ori r4, r4, 34471
; CHECK-P9-NEXT:    ld r3, 0(r3)
; CHECK-P9-NEXT:    ld r4, 0(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_unalign32___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r3, 1
; CHECK-P8-NEXT:    ori r4, r3, 34463
; CHECK-P8-NEXT:    ori r5, r3, 34471
; CHECK-P8-NEXT:    ld r3, 0(r4)
; CHECK-P8-NEXT:    ld r4, 0(r5)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i128, i128* inttoptr (i64 99999 to i128*), align 16
  ret i128 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_cst_align32___int128___int128() {
; CHECK-LABEL: ld_cst_align32___int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r4, 153
; CHECK-NEXT:    ld r3, -27108(r4)
; CHECK-NEXT:    ld r4, -27100(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i128, i128* inttoptr (i64 9999900 to i128*), align 16
  ret i128 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_cst_unalign64___int128___int128() {
; CHECK-P10-LABEL: ld_cst_unalign64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r4, 232
; CHECK-P10-NEXT:    pli r3, 3567587329
; CHECK-P10-NEXT:    pli r5, 3567587337
; CHECK-P10-NEXT:    rldimi r3, r4, 32, 0
; CHECK-P10-NEXT:    rldimi r5, r4, 32, 0
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    ld r4, 0(r5)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_unalign64___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r3, 29
; CHECK-P9-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-NEXT:    oris r4, r3, 54437
; CHECK-P9-NEXT:    ori r3, r4, 4097
; CHECK-P9-NEXT:    ori r4, r4, 4105
; CHECK-P9-NEXT:    ld r3, 0(r3)
; CHECK-P9-NEXT:    ld r4, 0(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_unalign64___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r3, 29
; CHECK-P8-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-NEXT:    oris r3, r3, 54437
; CHECK-P8-NEXT:    ori r4, r3, 4097
; CHECK-P8-NEXT:    ori r5, r3, 4105
; CHECK-P8-NEXT:    ld r3, 0(r4)
; CHECK-P8-NEXT:    ld r4, 0(r5)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i128, i128* inttoptr (i64 1000000000001 to i128*), align 16
  ret i128 %0
}

; Function Attrs: norecurse nounwind readonly uwtable willreturn
define dso_local i128 @ld_cst_align64___int128___int128() {
; CHECK-P10-LABEL: ld_cst_align64___int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r3, 232
; CHECK-P10-NEXT:    pli r4, 3567587336
; CHECK-P10-NEXT:    rldimi r4, r3, 32, 0
; CHECK-P10-NEXT:    pli r3, 244140625
; CHECK-P10-NEXT:    rldic r3, r3, 12, 24
; CHECK-P10-NEXT:    ld r4, 0(r4)
; CHECK-P10-NEXT:    ld r3, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: ld_cst_align64___int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    lis r3, 3725
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    ori r3, r3, 19025
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    rldic r3, r3, 12, 24
; CHECK-P9-NEXT:    ori r4, r4, 4104
; CHECK-P9-NEXT:    ld r3, 0(r3)
; CHECK-P9-NEXT:    ld r4, 0(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: ld_cst_align64___int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r3, 29
; CHECK-P8-NEXT:    lis r4, 3725
; CHECK-P8-NEXT:    rldic r3, r3, 35, 24
; CHECK-P8-NEXT:    ori r4, r4, 19025
; CHECK-P8-NEXT:    oris r3, r3, 54437
; CHECK-P8-NEXT:    rldic r4, r4, 12, 24
; CHECK-P8-NEXT:    ori r5, r3, 4104
; CHECK-P8-NEXT:    ld r3, 0(r4)
; CHECK-P8-NEXT:    ld r4, 0(r5)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i128, i128* inttoptr (i64 1000000000000 to i128*), align 4096
  ret i128 %0
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_0__int128___int128(i64 %ptr, i128 %str) {
; CHECK-LABEL: st_0__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r5, 8(r3)
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %0 = inttoptr i64 %ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_unalign16__int128___int128(i8* nocapture %ptr, i128 %str) {
; CHECK-P10-LABEL: st_unalign16__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    li r6, 9
; CHECK-P10-NEXT:    stdx r5, r3, r6
; CHECK-P10-NEXT:    li r5, 1
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_unalign16__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r6, 9
; CHECK-P9-NEXT:    stdx r5, r3, r6
; CHECK-P9-NEXT:    li r5, 1
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_unalign16__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r6, 9
; CHECK-P8-NEXT:    li r7, 1
; CHECK-P8-NEXT:    stdx r5, r3, r6
; CHECK-P8-NEXT:    stdx r4, r3, r7
; CHECK-P8-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align16__int128___int128(i8* nocapture %ptr, i128 %str) {
; CHECK-LABEL: st_align16__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r5, 16(r3)
; CHECK-NEXT:    std r4, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 8
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_unalign32__int128___int128(i8* nocapture %ptr, i128 %str) {
; CHECK-P10-LABEL: st_unalign32__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 99999
; CHECK-P10-NEXT:    stdux r4, r3, r6
; CHECK-P10-NEXT:    std r5, 8(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_unalign32__int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r6, 1
; CHECK-PREP10-NEXT:    ori r6, r6, 34463
; CHECK-PREP10-NEXT:    stdux r4, r3, r6
; CHECK-PREP10-NEXT:    std r5, 8(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align32__int128___int128(i8* nocapture %ptr, i128 %str) {
; CHECK-P10-LABEL: st_align32__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 99999000
; CHECK-P10-NEXT:    stdux r4, r3, r6
; CHECK-P10-NEXT:    std r5, 8(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align32__int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r6, 1525
; CHECK-PREP10-NEXT:    ori r6, r6, 56600
; CHECK-PREP10-NEXT:    stdux r4, r3, r6
; CHECK-PREP10-NEXT:    std r5, 8(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 99999000
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_unalign64__int128___int128(i8* nocapture %ptr, i128 %str) {
; CHECK-P10-LABEL: st_unalign64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 232
; CHECK-P10-NEXT:    pli r7, 3567587329
; CHECK-P10-NEXT:    rldimi r7, r6, 32, 0
; CHECK-P10-NEXT:    stdux r4, r3, r7
; CHECK-P10-NEXT:    std r5, 8(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_unalign64__int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r6, 29
; CHECK-PREP10-NEXT:    rldic r6, r6, 35, 24
; CHECK-PREP10-NEXT:    oris r6, r6, 54437
; CHECK-PREP10-NEXT:    ori r6, r6, 4097
; CHECK-PREP10-NEXT:    stdux r4, r3, r6
; CHECK-PREP10-NEXT:    std r5, 8(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000001
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_align64__int128___int128(i8* nocapture %ptr, i128 %str) {
; CHECK-P10-LABEL: st_align64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 244140625
; CHECK-P10-NEXT:    rldic r6, r6, 12, 24
; CHECK-P10-NEXT:    stdux r4, r3, r6
; CHECK-P10-NEXT:    std r5, 8(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_align64__int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    lis r6, 3725
; CHECK-PREP10-NEXT:    ori r6, r6, 19025
; CHECK-PREP10-NEXT:    rldic r6, r6, 12, 24
; CHECK-PREP10-NEXT:    stdux r4, r3, r6
; CHECK-PREP10-NEXT:    std r5, 8(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 1000000000000
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_reg__int128___int128(i8* nocapture %ptr, i64 %off, i128 %str) {
; CHECK-LABEL: st_reg__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    stdux r5, r3, r4
; CHECK-NEXT:    std r6, 8(r3)
; CHECK-NEXT:    blr
entry:
  %add.ptr = getelementptr inbounds i8, i8* %ptr, i64 %off
  %0 = bitcast i8* %add.ptr to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or1__int128___int128(i64 %ptr, i8 zeroext %off, i128 %str) {
; CHECK-LABEL: st_or1__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or r3, r4, r3
; CHECK-NEXT:    std r6, 8(r3)
; CHECK-NEXT:    std r5, 0(r3)
; CHECK-NEXT:    blr
entry:
  %conv = zext i8 %off to i64
  %or = or i64 %conv, %ptr
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_or2__int128___int128(i64 %ptr, i8 zeroext %off, i128 %str) {
; CHECK-LABEL: st_or2__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r7, r3, 0, 51
; CHECK-NEXT:    rotldi r3, r3, 52
; CHECK-NEXT:    stdx r5, r7, r4
; CHECK-NEXT:    rldimi r4, r3, 12, 0
; CHECK-NEXT:    std r6, 8(r4)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %conv = zext i8 %off to i64
  %or = or i64 %and, %conv
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint16__int128___int128(i64 %ptr, i128 %str) {
; CHECK-LABEL: st_not_disjoint16__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 6
; CHECK-NEXT:    std r5, 8(r3)
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 6
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_unalign16__int128___int128(i64 %ptr, i128 %str) {
; CHECK-P10-LABEL: st_disjoint_unalign16__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P10-NEXT:    li r6, 14
; CHECK-P10-NEXT:    stdx r5, r3, r6
; CHECK-P10-NEXT:    li r5, 6
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_unalign16__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P9-NEXT:    li r6, 14
; CHECK-P9-NEXT:    stdx r5, r3, r6
; CHECK-P9-NEXT:    li r5, 6
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_unalign16__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r6, 14
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 51
; CHECK-P8-NEXT:    li r7, 6
; CHECK-P8-NEXT:    stdx r5, r3, r6
; CHECK-P8-NEXT:    stdx r4, r3, r7
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 6
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align16__int128___int128(i64 %ptr, i128 %str) {
; CHECK-LABEL: st_disjoint_align16__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rldicr r3, r3, 0, 51
; CHECK-NEXT:    std r5, 32(r3)
; CHECK-NEXT:    std r4, 24(r3)
; CHECK-NEXT:    blr
entry:
  %and = and i64 %ptr, -4096
  %or = or i64 %and, 24
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint32__int128___int128(i64 %ptr, i128 %str) {
; CHECK-LABEL: st_not_disjoint32__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori r3, r3, 34463
; CHECK-NEXT:    oris r3, r3, 1
; CHECK-NEXT:    std r5, 8(r3)
; CHECK-NEXT:    std r4, 0(r3)
; CHECK-NEXT:    blr
entry:
  %or = or i64 %ptr, 99999
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_unalign32__int128___int128(i64 %ptr, i128 %str) {
; CHECK-P10-LABEL: st_disjoint_unalign32__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P10-NEXT:    pli r6, 100007
; CHECK-P10-NEXT:    stdx r5, r3, r6
; CHECK-P10-NEXT:    pli r5, 99999
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_unalign32__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r6, 1
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P9-NEXT:    ori r7, r6, 34471
; CHECK-P9-NEXT:    stdx r5, r3, r7
; CHECK-P9-NEXT:    ori r5, r6, 34463
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_unalign32__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r6, 1
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 43
; CHECK-P8-NEXT:    ori r7, r6, 34471
; CHECK-P8-NEXT:    ori r6, r6, 34463
; CHECK-P8-NEXT:    stdx r5, r3, r7
; CHECK-P8-NEXT:    stdx r4, r3, r6
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1048576
  %or = or i64 %and, 99999
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align32__int128___int128(i64 %ptr, i128 %str) {
; CHECK-P10-LABEL: st_disjoint_align32__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    lis r6, -15264
; CHECK-P10-NEXT:    and r3, r3, r6
; CHECK-P10-NEXT:    pli r6, 999990008
; CHECK-P10-NEXT:    stdx r5, r3, r6
; CHECK-P10-NEXT:    pli r5, 999990000
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align32__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r6, -15264
; CHECK-P9-NEXT:    and r3, r3, r6
; CHECK-P9-NEXT:    lis r6, 15258
; CHECK-P9-NEXT:    ori r7, r6, 41720
; CHECK-P9-NEXT:    stdx r5, r3, r7
; CHECK-P9-NEXT:    ori r5, r6, 41712
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align32__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r6, -15264
; CHECK-P8-NEXT:    lis r7, 15258
; CHECK-P8-NEXT:    and r3, r3, r6
; CHECK-P8-NEXT:    ori r6, r7, 41720
; CHECK-P8-NEXT:    ori r7, r7, 41712
; CHECK-P8-NEXT:    stdx r5, r3, r6
; CHECK-P8-NEXT:    stdx r4, r3, r7
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1000341504
  %or = or i64 %and, 999990000
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_not_disjoint64__int128___int128(i64 %ptr, i128 %str) {
; CHECK-P10-LABEL: st_not_disjoint64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 232
; CHECK-P10-NEXT:    pli r7, 3567587329
; CHECK-P10-NEXT:    rldimi r7, r6, 32, 0
; CHECK-P10-NEXT:    or r3, r3, r7
; CHECK-P10-NEXT:    std r5, 8(r3)
; CHECK-P10-NEXT:    std r4, 0(r3)
; CHECK-P10-NEXT:    blr
;
; CHECK-PREP10-LABEL: st_not_disjoint64__int128___int128:
; CHECK-PREP10:       # %bb.0: # %entry
; CHECK-PREP10-NEXT:    li r6, 29
; CHECK-PREP10-NEXT:    rldic r6, r6, 35, 24
; CHECK-PREP10-NEXT:    oris r6, r6, 54437
; CHECK-PREP10-NEXT:    ori r6, r6, 4097
; CHECK-PREP10-NEXT:    or r3, r3, r6
; CHECK-PREP10-NEXT:    std r5, 8(r3)
; CHECK-PREP10-NEXT:    std r4, 0(r3)
; CHECK-PREP10-NEXT:    blr
entry:
  %or = or i64 %ptr, 1000000000001
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_unalign64__int128___int128(i64 %ptr, i128 %str) {
; CHECK-P10-LABEL: st_disjoint_unalign64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 232
; CHECK-P10-NEXT:    pli r7, 3567587337
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r7, r6, 32, 0
; CHECK-P10-NEXT:    stdx r5, r3, r7
; CHECK-P10-NEXT:    pli r5, 3567587329
; CHECK-P10-NEXT:    rldimi r5, r6, 32, 0
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_unalign64__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r6, 29
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    rldic r6, r6, 35, 24
; CHECK-P9-NEXT:    oris r6, r6, 54437
; CHECK-P9-NEXT:    ori r7, r6, 4105
; CHECK-P9-NEXT:    stdx r5, r3, r7
; CHECK-P9-NEXT:    ori r5, r6, 4097
; CHECK-P9-NEXT:    stdx r4, r3, r5
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_unalign64__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r6, 29
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    rldic r6, r6, 35, 24
; CHECK-P8-NEXT:    oris r6, r6, 54437
; CHECK-P8-NEXT:    ori r7, r6, 4105
; CHECK-P8-NEXT:    ori r6, r6, 4097
; CHECK-P8-NEXT:    stdx r5, r3, r7
; CHECK-P8-NEXT:    stdx r4, r3, r6
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000001
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_disjoint_align64__int128___int128(i64 %ptr, i128 %str) {
; CHECK-P10-LABEL: st_disjoint_align64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r6, 232
; CHECK-P10-NEXT:    pli r7, 3567587336
; CHECK-P10-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P10-NEXT:    rldimi r7, r6, 32, 0
; CHECK-P10-NEXT:    stdx r5, r3, r7
; CHECK-P10-NEXT:    pli r5, 244140625
; CHECK-P10-NEXT:    rldic r5, r5, 12, 24
; CHECK-P10-NEXT:    stdx r4, r3, r5
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_disjoint_align64__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r6, 3725
; CHECK-P9-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P9-NEXT:    ori r6, r6, 19025
; CHECK-P9-NEXT:    rldic r6, r6, 12, 24
; CHECK-P9-NEXT:    stdx r4, r3, r6
; CHECK-P9-NEXT:    li r4, 29
; CHECK-P9-NEXT:    rldic r4, r4, 35, 24
; CHECK-P9-NEXT:    oris r4, r4, 54437
; CHECK-P9-NEXT:    ori r4, r4, 4104
; CHECK-P9-NEXT:    stdx r5, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_disjoint_align64__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r6, 29
; CHECK-P8-NEXT:    lis r7, 3725
; CHECK-P8-NEXT:    rldic r6, r6, 35, 24
; CHECK-P8-NEXT:    ori r7, r7, 19025
; CHECK-P8-NEXT:    oris r6, r6, 54437
; CHECK-P8-NEXT:    rldicr r3, r3, 0, 23
; CHECK-P8-NEXT:    rldic r7, r7, 12, 24
; CHECK-P8-NEXT:    ori r6, r6, 4104
; CHECK-P8-NEXT:    stdx r4, r3, r7
; CHECK-P8-NEXT:    stdx r5, r3, r6
; CHECK-P8-NEXT:    blr
entry:
  %and = and i64 %ptr, -1099511627776
  %or = or i64 %and, 1000000000000
  %0 = inttoptr i64 %or to i128*
  store i128 %str, i128* %0, align 4096
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_unalign16__int128___int128(i128 %str) {
; CHECK-P10-LABEL: st_cst_unalign16__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    li r5, 263
; CHECK-P10-NEXT:    std r4, 0(r5)
; CHECK-P10-NEXT:    li r4, 255
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_unalign16__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r5, 263
; CHECK-P9-NEXT:    std r4, 0(r5)
; CHECK-P9-NEXT:    li r4, 255
; CHECK-P9-NEXT:    std r3, 0(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_unalign16__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 263
; CHECK-P8-NEXT:    li r6, 255
; CHECK-P8-NEXT:    std r4, 0(r5)
; CHECK-P8-NEXT:    std r3, 0(r6)
; CHECK-P8-NEXT:    blr
entry:
  store i128 %str, i128* inttoptr (i64 255 to i128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align16__int128___int128(i128 %str) {
; CHECK-LABEL: st_cst_align16__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    std r4, 4088(0)
; CHECK-NEXT:    std r3, 4080(0)
; CHECK-NEXT:    blr
entry:
  store i128 %str, i128* inttoptr (i64 4080 to i128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_unalign32__int128___int128(i128 %str) {
; CHECK-P10-LABEL: st_cst_unalign32__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 100007
; CHECK-P10-NEXT:    std r4, 0(r5)
; CHECK-P10-NEXT:    pli r4, 99999
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_unalign32__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, 1
; CHECK-P9-NEXT:    ori r6, r5, 34471
; CHECK-P9-NEXT:    std r4, 0(r6)
; CHECK-P9-NEXT:    ori r4, r5, 34463
; CHECK-P9-NEXT:    std r3, 0(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_unalign32__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    lis r5, 1
; CHECK-P8-NEXT:    ori r6, r5, 34471
; CHECK-P8-NEXT:    ori r5, r5, 34463
; CHECK-P8-NEXT:    std r4, 0(r6)
; CHECK-P8-NEXT:    std r3, 0(r5)
; CHECK-P8-NEXT:    blr
entry:
  store i128 %str, i128* inttoptr (i64 99999 to i128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align32__int128___int128(i128 %str) {
; CHECK-LABEL: st_cst_align32__int128___int128:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lis r5, 153
; CHECK-NEXT:    std r4, -27100(r5)
; CHECK-NEXT:    std r3, -27108(r5)
; CHECK-NEXT:    blr
entry:
  store i128 %str, i128* inttoptr (i64 9999900 to i128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_unalign64__int128___int128(i128 %str) {
; CHECK-P10-LABEL: st_cst_unalign64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587337
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    std r4, 0(r6)
; CHECK-P10-NEXT:    pli r4, 3567587329
; CHECK-P10-NEXT:    rldimi r4, r5, 32, 0
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_unalign64__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    li r5, 29
; CHECK-P9-NEXT:    rldic r5, r5, 35, 24
; CHECK-P9-NEXT:    oris r5, r5, 54437
; CHECK-P9-NEXT:    ori r6, r5, 4105
; CHECK-P9-NEXT:    std r4, 0(r6)
; CHECK-P9-NEXT:    ori r4, r5, 4097
; CHECK-P9-NEXT:    std r3, 0(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_unalign64__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 29
; CHECK-P8-NEXT:    rldic r5, r5, 35, 24
; CHECK-P8-NEXT:    oris r5, r5, 54437
; CHECK-P8-NEXT:    ori r6, r5, 4105
; CHECK-P8-NEXT:    ori r5, r5, 4097
; CHECK-P8-NEXT:    std r4, 0(r6)
; CHECK-P8-NEXT:    std r3, 0(r5)
; CHECK-P8-NEXT:    blr
entry:
  store i128 %str, i128* inttoptr (i64 1000000000001 to i128*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn writeonly
define dso_local void @st_cst_align64__int128___int128(i128 %str) {
; CHECK-P10-LABEL: st_cst_align64__int128___int128:
; CHECK-P10:       # %bb.0: # %entry
; CHECK-P10-NEXT:    pli r5, 232
; CHECK-P10-NEXT:    pli r6, 3567587336
; CHECK-P10-NEXT:    rldimi r6, r5, 32, 0
; CHECK-P10-NEXT:    std r4, 0(r6)
; CHECK-P10-NEXT:    pli r4, 244140625
; CHECK-P10-NEXT:    rldic r4, r4, 12, 24
; CHECK-P10-NEXT:    std r3, 0(r4)
; CHECK-P10-NEXT:    blr
;
; CHECK-P9-LABEL: st_cst_align64__int128___int128:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    lis r5, 3725
; CHECK-P9-NEXT:    ori r5, r5, 19025
; CHECK-P9-NEXT:    rldic r5, r5, 12, 24
; CHECK-P9-NEXT:    std r3, 0(r5)
; CHECK-P9-NEXT:    li r3, 29
; CHECK-P9-NEXT:    rldic r3, r3, 35, 24
; CHECK-P9-NEXT:    oris r3, r3, 54437
; CHECK-P9-NEXT:    ori r3, r3, 4104
; CHECK-P9-NEXT:    std r4, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: st_cst_align64__int128___int128:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    li r5, 29
; CHECK-P8-NEXT:    lis r6, 3725
; CHECK-P8-NEXT:    rldic r5, r5, 35, 24
; CHECK-P8-NEXT:    ori r6, r6, 19025
; CHECK-P8-NEXT:    oris r5, r5, 54437
; CHECK-P8-NEXT:    rldic r6, r6, 12, 24
; CHECK-P8-NEXT:    ori r5, r5, 4104
; CHECK-P8-NEXT:    std r3, 0(r6)
; CHECK-P8-NEXT:    std r4, 0(r5)
; CHECK-P8-NEXT:    blr
entry:
  store i128 %str, i128* inttoptr (i64 1000000000000 to i128*), align 4096
  ret void
}
