// Code generated by "./generator ./org.freedesktop.login1"; DO NOT EDIT.

package login1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type Manager interface {
	manager // interface org.freedesktop.login1.Manager
	proxy.Object
}

type objectManager struct {
	interfaceManager // interface org.freedesktop.login1.Manager
	proxy.ImplObject
}

func NewManager(conn *dbus.Conn) Manager {
	obj := new(objectManager)
	obj.ImplObject.Init_(conn, "org.freedesktop.login1", "/org/freedesktop/login1")
	return obj
}

type manager interface {
	GoGetSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	GetSession(flags dbus.Flags, sessionId string) (dbus.ObjectPath, error)
	GoGetSessionByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call
	GetSessionByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error)
	GoGetUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call
	GetUser(flags dbus.Flags, uid uint32) (dbus.ObjectPath, error)
	GoGetUserByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call
	GetUserByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error)
	GoGetSeat(flags dbus.Flags, ch chan *dbus.Call, seatId string) *dbus.Call
	GetSeat(flags dbus.Flags, seatId string) (dbus.ObjectPath, error)
	GoListSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListSessions(flags dbus.Flags) ([]SessionDetail, error)
	GoListUsers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListUsers(flags dbus.Flags) ([]UserDetail, error)
	GoListSeats(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListSeats(flags dbus.Flags) ([]SeatInfo, error)
	GoListInhibitors(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ListInhibitors(flags dbus.Flags) ([]InhibitorInfo, error)
	GoCreateSession(flags dbus.Flags, ch chan *dbus.Call, uid uint32, pid uint32, service string, type0 string, class string, desktop string, seatId string, vtnr uint32, tty string, display string, remote bool, remoteUser string, remoteHost string, properties [][]interface{}) *dbus.Call
	CreateSession(flags dbus.Flags, uid uint32, pid uint32, service string, type0 string, class string, desktop string, seatId string, vtnr uint32, tty string, display string, remote bool, remoteUser string, remoteHost string, properties [][]interface{}) (string, dbus.ObjectPath, string, dbus.UnixFD, uint32, string, uint32, bool, error)
	GoReleaseSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	ReleaseSession(flags dbus.Flags, sessionId string) error
	GoActivateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	ActivateSession(flags dbus.Flags, sessionId string) error
	GoActivateSessionOnSeat(flags dbus.Flags, ch chan *dbus.Call, sessionId string, seatId string) *dbus.Call
	ActivateSessionOnSeat(flags dbus.Flags, sessionId string, seatId string) error
	GoLockSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	LockSession(flags dbus.Flags, sessionId string) error
	GoUnlockSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	UnlockSession(flags dbus.Flags, sessionId string) error
	GoLockSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	LockSessions(flags dbus.Flags) error
	GoUnlockSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	UnlockSessions(flags dbus.Flags) error
	GoKillSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string, who string, signo int32) *dbus.Call
	KillSession(flags dbus.Flags, sessionId string, who string, signo int32) error
	GoKillUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32, signo int32) *dbus.Call
	KillUser(flags dbus.Flags, uid uint32, signo int32) error
	GoTerminateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	TerminateSession(flags dbus.Flags, sessionId string) error
	GoTerminateUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call
	TerminateUser(flags dbus.Flags, uid uint32) error
	GoTerminateSeat(flags dbus.Flags, ch chan *dbus.Call, seatId string) *dbus.Call
	TerminateSeat(flags dbus.Flags, seatId string) error
	GoSetUserLinger(flags dbus.Flags, ch chan *dbus.Call, uid uint32, linger bool, interactive bool) *dbus.Call
	SetUserLinger(flags dbus.Flags, uid uint32, linger bool, interactive bool) error
	GoAttachDevice(flags dbus.Flags, ch chan *dbus.Call, seatId string, sysfs string, interactive bool) *dbus.Call
	AttachDevice(flags dbus.Flags, seatId string, sysfs string, interactive bool) error
	GoFlushDevices(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call
	FlushDevices(flags dbus.Flags, interactive bool) error
	GoPowerOff(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call
	PowerOff(flags dbus.Flags, interactive bool) error
	GoReboot(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call
	Reboot(flags dbus.Flags, interactive bool) error
	GoSuspend(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call
	Suspend(flags dbus.Flags, interactive bool) error
	GoHibernate(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call
	Hibernate(flags dbus.Flags, interactive bool) error
	GoHybridSleep(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call
	HybridSleep(flags dbus.Flags, interactive bool) error
	GoCanPowerOff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CanPowerOff(flags dbus.Flags) (string, error)
	GoCanReboot(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CanReboot(flags dbus.Flags) (string, error)
	GoCanSuspend(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CanSuspend(flags dbus.Flags) (string, error)
	GoCanHibernate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CanHibernate(flags dbus.Flags) (string, error)
	GoCanHybridSleep(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CanHybridSleep(flags dbus.Flags) (string, error)
	GoScheduleShutdown(flags dbus.Flags, ch chan *dbus.Call, type0 string, usec uint64) *dbus.Call
	ScheduleShutdown(flags dbus.Flags, type0 string, usec uint64) error
	GoCancelScheduledShutdown(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CancelScheduledShutdown(flags dbus.Flags) (bool, error)
	GoInhibit(flags dbus.Flags, ch chan *dbus.Call, what string, who string, why string, mode string) *dbus.Call
	Inhibit(flags dbus.Flags, what string, who string, why string, mode string) (dbus.UnixFD, error)
	GoCanRebootToFirmwareSetup(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	CanRebootToFirmwareSetup(flags dbus.Flags) (string, error)
	GoSetRebootToFirmwareSetup(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call
	SetRebootToFirmwareSetup(flags dbus.Flags, enable bool) error
	GoSetWallMessage(flags dbus.Flags, ch chan *dbus.Call, wallMessage string, enable bool) *dbus.Call
	SetWallMessage(flags dbus.Flags, wallMessage string, enable bool) error
	ConnectSessionNew(cb func(sessionId string, sessionPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSessionRemoved(cb func(sessionId string, sessionPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectUserNew(cb func(uid uint32, userPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectUserRemoved(cb func(uid uint32, userPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSeatNew(cb func(seatId string, seatPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectSeatRemoved(cb func(seatId string, seatPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectPrepareForShutdown(cb func(start bool)) (dbusutil.SignalHandlerId, error)
	ConnectPrepareForSleep(cb func(start bool)) (dbusutil.SignalHandlerId, error)
	EnableWallMessages() proxy.PropBool
	WallMessage() proxy.PropString
	NAutoVTs() proxy.PropUint32
	KillOnlyUsers() proxy.PropStringArray
	KillExcludeUsers() proxy.PropStringArray
	KillUserProcesses() proxy.PropBool
	RebootToFirmwareSetup() proxy.PropBool
	IdleHint() proxy.PropBool
	IdleSinceHint() proxy.PropUint64
	IdleSinceHintMonotonic() proxy.PropUint64
	BlockInhibited() proxy.PropString
	DelayInhibited() proxy.PropString
	InhibitDelayMaxUSec() proxy.PropUint64
	HandlePowerKey() proxy.PropString
	HandleSuspendKey() proxy.PropString
	HandleHibernateKey() proxy.PropString
	HandleLidSwitch() proxy.PropString
	HandleLidSwitchDocked() proxy.PropString
	HoldoffTimeoutUSec() proxy.PropUint64
	IdleAction() proxy.PropString
	IdleActionUSec() proxy.PropUint64
	PreparingForShutdown() proxy.PropBool
	PreparingForSleep() proxy.PropBool
	ScheduledShutdown() PropManagerScheduledShutdown
	Docked() proxy.PropBool
	RemoveIPC() proxy.PropBool
	RuntimeDirectorySize() proxy.PropUint64
	InhibitorsMax() proxy.PropUint64
	NCurrentInhibitors() proxy.PropUint64
	SessionsMax() proxy.PropUint64
	NCurrentSessions() proxy.PropUint64
	UserTasksMax() proxy.PropUint64
}

type interfaceManager struct{}

func (v *interfaceManager) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceManager) GetInterfaceName_() string {
	return "org.freedesktop.login1.Manager"
}

// method GetSession

func (v *interfaceManager) GoGetSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSession", flags, ch, sessionId)
}

func (*interfaceManager) StoreGetSession(call *dbus.Call) (sessionPath dbus.ObjectPath, err error) {
	err = call.Store(&sessionPath)
	return
}

func (v *interfaceManager) GetSession(flags dbus.Flags, sessionId string) (dbus.ObjectPath, error) {
	return v.StoreGetSession(
		<-v.GoGetSession(flags, make(chan *dbus.Call, 1), sessionId).Done)
}

// method GetSessionByPID

func (v *interfaceManager) GoGetSessionByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSessionByPID", flags, ch, pid)
}

func (*interfaceManager) StoreGetSessionByPID(call *dbus.Call) (sessionPath dbus.ObjectPath, err error) {
	err = call.Store(&sessionPath)
	return
}

func (v *interfaceManager) GetSessionByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error) {
	return v.StoreGetSessionByPID(
		<-v.GoGetSessionByPID(flags, make(chan *dbus.Call, 1), pid).Done)
}

// method GetUser

func (v *interfaceManager) GoGetUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUser", flags, ch, uid)
}

func (*interfaceManager) StoreGetUser(call *dbus.Call) (userPath dbus.ObjectPath, err error) {
	err = call.Store(&userPath)
	return
}

func (v *interfaceManager) GetUser(flags dbus.Flags, uid uint32) (dbus.ObjectPath, error) {
	return v.StoreGetUser(
		<-v.GoGetUser(flags, make(chan *dbus.Call, 1), uid).Done)
}

// method GetUserByPID

func (v *interfaceManager) GoGetUserByPID(flags dbus.Flags, ch chan *dbus.Call, pid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetUserByPID", flags, ch, pid)
}

func (*interfaceManager) StoreGetUserByPID(call *dbus.Call) (userPath dbus.ObjectPath, err error) {
	err = call.Store(&userPath)
	return
}

func (v *interfaceManager) GetUserByPID(flags dbus.Flags, pid uint32) (dbus.ObjectPath, error) {
	return v.StoreGetUserByPID(
		<-v.GoGetUserByPID(flags, make(chan *dbus.Call, 1), pid).Done)
}

// method GetSeat

func (v *interfaceManager) GoGetSeat(flags dbus.Flags, ch chan *dbus.Call, seatId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".GetSeat", flags, ch, seatId)
}

func (*interfaceManager) StoreGetSeat(call *dbus.Call) (seatPath dbus.ObjectPath, err error) {
	err = call.Store(&seatPath)
	return
}

func (v *interfaceManager) GetSeat(flags dbus.Flags, seatId string) (dbus.ObjectPath, error) {
	return v.StoreGetSeat(
		<-v.GoGetSeat(flags, make(chan *dbus.Call, 1), seatId).Done)
}

// method ListSessions

func (v *interfaceManager) GoListSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListSessions", flags, ch)
}

func (*interfaceManager) StoreListSessions(call *dbus.Call) (sessionList []SessionDetail, err error) {
	err = call.Store(&sessionList)
	return
}

func (v *interfaceManager) ListSessions(flags dbus.Flags) ([]SessionDetail, error) {
	return v.StoreListSessions(
		<-v.GoListSessions(flags, make(chan *dbus.Call, 1)).Done)
}

// method ListUsers

func (v *interfaceManager) GoListUsers(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListUsers", flags, ch)
}

func (*interfaceManager) StoreListUsers(call *dbus.Call) (userList []UserDetail, err error) {
	err = call.Store(&userList)
	return
}

func (v *interfaceManager) ListUsers(flags dbus.Flags) ([]UserDetail, error) {
	return v.StoreListUsers(
		<-v.GoListUsers(flags, make(chan *dbus.Call, 1)).Done)
}

// method ListSeats

func (v *interfaceManager) GoListSeats(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListSeats", flags, ch)
}

func (*interfaceManager) StoreListSeats(call *dbus.Call) (seatList []SeatInfo, err error) {
	err = call.Store(&seatList)
	return
}

func (v *interfaceManager) ListSeats(flags dbus.Flags) ([]SeatInfo, error) {
	return v.StoreListSeats(
		<-v.GoListSeats(flags, make(chan *dbus.Call, 1)).Done)
}

// method ListInhibitors

func (v *interfaceManager) GoListInhibitors(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ListInhibitors", flags, ch)
}

func (*interfaceManager) StoreListInhibitors(call *dbus.Call) (inhibitorList []InhibitorInfo, err error) {
	err = call.Store(&inhibitorList)
	return
}

func (v *interfaceManager) ListInhibitors(flags dbus.Flags) ([]InhibitorInfo, error) {
	return v.StoreListInhibitors(
		<-v.GoListInhibitors(flags, make(chan *dbus.Call, 1)).Done)
}

// method CreateSession

func (v *interfaceManager) GoCreateSession(flags dbus.Flags, ch chan *dbus.Call, uid uint32, pid uint32, service string, type0 string, class string, desktop string, seatId string, vtnr uint32, tty string, display string, remote bool, remoteUser string, remoteHost string, properties [][]interface{}) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CreateSession", flags, ch, uid, pid, service, type0, class, desktop, seatId, vtnr, tty, display, remote, remoteUser, remoteHost, properties)
}

func (*interfaceManager) StoreCreateSession(call *dbus.Call) (sessionId string, sessionPath dbus.ObjectPath, runtimePath string, fifoFd dbus.UnixFD, uid0 uint32, seatId0 string, vtnr0 uint32, existing bool, err error) {
	err = call.Store(&sessionId, &sessionPath, &runtimePath, &fifoFd, &uid0, &seatId0, &vtnr0, &existing)
	return
}

func (v *interfaceManager) CreateSession(flags dbus.Flags, uid uint32, pid uint32, service string, type0 string, class string, desktop string, seatId string, vtnr uint32, tty string, display string, remote bool, remoteUser string, remoteHost string, properties [][]interface{}) (string, dbus.ObjectPath, string, dbus.UnixFD, uint32, string, uint32, bool, error) {
	return v.StoreCreateSession(
		<-v.GoCreateSession(flags, make(chan *dbus.Call, 1), uid, pid, service, type0, class, desktop, seatId, vtnr, tty, display, remote, remoteUser, remoteHost, properties).Done)
}

// method ReleaseSession

func (v *interfaceManager) GoReleaseSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReleaseSession", flags, ch, sessionId)
}

func (v *interfaceManager) ReleaseSession(flags dbus.Flags, sessionId string) error {
	return (<-v.GoReleaseSession(flags, make(chan *dbus.Call, 1), sessionId).Done).Err
}

// method ActivateSession

func (v *interfaceManager) GoActivateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActivateSession", flags, ch, sessionId)
}

func (v *interfaceManager) ActivateSession(flags dbus.Flags, sessionId string) error {
	return (<-v.GoActivateSession(flags, make(chan *dbus.Call, 1), sessionId).Done).Err
}

// method ActivateSessionOnSeat

func (v *interfaceManager) GoActivateSessionOnSeat(flags dbus.Flags, ch chan *dbus.Call, sessionId string, seatId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActivateSessionOnSeat", flags, ch, sessionId, seatId)
}

func (v *interfaceManager) ActivateSessionOnSeat(flags dbus.Flags, sessionId string, seatId string) error {
	return (<-v.GoActivateSessionOnSeat(flags, make(chan *dbus.Call, 1), sessionId, seatId).Done).Err
}

// method LockSession

func (v *interfaceManager) GoLockSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LockSession", flags, ch, sessionId)
}

func (v *interfaceManager) LockSession(flags dbus.Flags, sessionId string) error {
	return (<-v.GoLockSession(flags, make(chan *dbus.Call, 1), sessionId).Done).Err
}

// method UnlockSession

func (v *interfaceManager) GoUnlockSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnlockSession", flags, ch, sessionId)
}

func (v *interfaceManager) UnlockSession(flags dbus.Flags, sessionId string) error {
	return (<-v.GoUnlockSession(flags, make(chan *dbus.Call, 1), sessionId).Done).Err
}

// method LockSessions

func (v *interfaceManager) GoLockSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".LockSessions", flags, ch)
}

func (v *interfaceManager) LockSessions(flags dbus.Flags) error {
	return (<-v.GoLockSessions(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method UnlockSessions

func (v *interfaceManager) GoUnlockSessions(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".UnlockSessions", flags, ch)
}

func (v *interfaceManager) UnlockSessions(flags dbus.Flags) error {
	return (<-v.GoUnlockSessions(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method KillSession

func (v *interfaceManager) GoKillSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string, who string, signo int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".KillSession", flags, ch, sessionId, who, signo)
}

func (v *interfaceManager) KillSession(flags dbus.Flags, sessionId string, who string, signo int32) error {
	return (<-v.GoKillSession(flags, make(chan *dbus.Call, 1), sessionId, who, signo).Done).Err
}

// method KillUser

func (v *interfaceManager) GoKillUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32, signo int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".KillUser", flags, ch, uid, signo)
}

func (v *interfaceManager) KillUser(flags dbus.Flags, uid uint32, signo int32) error {
	return (<-v.GoKillUser(flags, make(chan *dbus.Call, 1), uid, signo).Done).Err
}

// method TerminateSession

func (v *interfaceManager) GoTerminateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TerminateSession", flags, ch, sessionId)
}

func (v *interfaceManager) TerminateSession(flags dbus.Flags, sessionId string) error {
	return (<-v.GoTerminateSession(flags, make(chan *dbus.Call, 1), sessionId).Done).Err
}

// method TerminateUser

func (v *interfaceManager) GoTerminateUser(flags dbus.Flags, ch chan *dbus.Call, uid uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TerminateUser", flags, ch, uid)
}

func (v *interfaceManager) TerminateUser(flags dbus.Flags, uid uint32) error {
	return (<-v.GoTerminateUser(flags, make(chan *dbus.Call, 1), uid).Done).Err
}

// method TerminateSeat

func (v *interfaceManager) GoTerminateSeat(flags dbus.Flags, ch chan *dbus.Call, seatId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TerminateSeat", flags, ch, seatId)
}

func (v *interfaceManager) TerminateSeat(flags dbus.Flags, seatId string) error {
	return (<-v.GoTerminateSeat(flags, make(chan *dbus.Call, 1), seatId).Done).Err
}

// method SetUserLinger

func (v *interfaceManager) GoSetUserLinger(flags dbus.Flags, ch chan *dbus.Call, uid uint32, linger bool, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetUserLinger", flags, ch, uid, linger, interactive)
}

func (v *interfaceManager) SetUserLinger(flags dbus.Flags, uid uint32, linger bool, interactive bool) error {
	return (<-v.GoSetUserLinger(flags, make(chan *dbus.Call, 1), uid, linger, interactive).Done).Err
}

// method AttachDevice

func (v *interfaceManager) GoAttachDevice(flags dbus.Flags, ch chan *dbus.Call, seatId string, sysfs string, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".AttachDevice", flags, ch, seatId, sysfs, interactive)
}

func (v *interfaceManager) AttachDevice(flags dbus.Flags, seatId string, sysfs string, interactive bool) error {
	return (<-v.GoAttachDevice(flags, make(chan *dbus.Call, 1), seatId, sysfs, interactive).Done).Err
}

// method FlushDevices

func (v *interfaceManager) GoFlushDevices(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".FlushDevices", flags, ch, interactive)
}

func (v *interfaceManager) FlushDevices(flags dbus.Flags, interactive bool) error {
	return (<-v.GoFlushDevices(flags, make(chan *dbus.Call, 1), interactive).Done).Err
}

// method PowerOff

func (v *interfaceManager) GoPowerOff(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PowerOff", flags, ch, interactive)
}

func (v *interfaceManager) PowerOff(flags dbus.Flags, interactive bool) error {
	return (<-v.GoPowerOff(flags, make(chan *dbus.Call, 1), interactive).Done).Err
}

// method Reboot

func (v *interfaceManager) GoReboot(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Reboot", flags, ch, interactive)
}

func (v *interfaceManager) Reboot(flags dbus.Flags, interactive bool) error {
	return (<-v.GoReboot(flags, make(chan *dbus.Call, 1), interactive).Done).Err
}

// method Suspend

func (v *interfaceManager) GoSuspend(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Suspend", flags, ch, interactive)
}

func (v *interfaceManager) Suspend(flags dbus.Flags, interactive bool) error {
	return (<-v.GoSuspend(flags, make(chan *dbus.Call, 1), interactive).Done).Err
}

// method Hibernate

func (v *interfaceManager) GoHibernate(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Hibernate", flags, ch, interactive)
}

func (v *interfaceManager) Hibernate(flags dbus.Flags, interactive bool) error {
	return (<-v.GoHibernate(flags, make(chan *dbus.Call, 1), interactive).Done).Err
}

// method HybridSleep

func (v *interfaceManager) GoHybridSleep(flags dbus.Flags, ch chan *dbus.Call, interactive bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".HybridSleep", flags, ch, interactive)
}

func (v *interfaceManager) HybridSleep(flags dbus.Flags, interactive bool) error {
	return (<-v.GoHybridSleep(flags, make(chan *dbus.Call, 1), interactive).Done).Err
}

// method CanPowerOff

func (v *interfaceManager) GoCanPowerOff(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CanPowerOff", flags, ch)
}

func (*interfaceManager) StoreCanPowerOff(call *dbus.Call) (result string, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CanPowerOff(flags dbus.Flags) (string, error) {
	return v.StoreCanPowerOff(
		<-v.GoCanPowerOff(flags, make(chan *dbus.Call, 1)).Done)
}

// method CanReboot

func (v *interfaceManager) GoCanReboot(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CanReboot", flags, ch)
}

func (*interfaceManager) StoreCanReboot(call *dbus.Call) (result string, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CanReboot(flags dbus.Flags) (string, error) {
	return v.StoreCanReboot(
		<-v.GoCanReboot(flags, make(chan *dbus.Call, 1)).Done)
}

// method CanSuspend

func (v *interfaceManager) GoCanSuspend(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CanSuspend", flags, ch)
}

func (*interfaceManager) StoreCanSuspend(call *dbus.Call) (result string, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CanSuspend(flags dbus.Flags) (string, error) {
	return v.StoreCanSuspend(
		<-v.GoCanSuspend(flags, make(chan *dbus.Call, 1)).Done)
}

// method CanHibernate

func (v *interfaceManager) GoCanHibernate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CanHibernate", flags, ch)
}

func (*interfaceManager) StoreCanHibernate(call *dbus.Call) (result string, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CanHibernate(flags dbus.Flags) (string, error) {
	return v.StoreCanHibernate(
		<-v.GoCanHibernate(flags, make(chan *dbus.Call, 1)).Done)
}

// method CanHybridSleep

func (v *interfaceManager) GoCanHybridSleep(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CanHybridSleep", flags, ch)
}

func (*interfaceManager) StoreCanHybridSleep(call *dbus.Call) (result string, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CanHybridSleep(flags dbus.Flags) (string, error) {
	return v.StoreCanHybridSleep(
		<-v.GoCanHybridSleep(flags, make(chan *dbus.Call, 1)).Done)
}

// method ScheduleShutdown

func (v *interfaceManager) GoScheduleShutdown(flags dbus.Flags, ch chan *dbus.Call, type0 string, usec uint64) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ScheduleShutdown", flags, ch, type0, usec)
}

func (v *interfaceManager) ScheduleShutdown(flags dbus.Flags, type0 string, usec uint64) error {
	return (<-v.GoScheduleShutdown(flags, make(chan *dbus.Call, 1), type0, usec).Done).Err
}

// method CancelScheduledShutdown

func (v *interfaceManager) GoCancelScheduledShutdown(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CancelScheduledShutdown", flags, ch)
}

func (*interfaceManager) StoreCancelScheduledShutdown(call *dbus.Call) (cancelled bool, err error) {
	err = call.Store(&cancelled)
	return
}

func (v *interfaceManager) CancelScheduledShutdown(flags dbus.Flags) (bool, error) {
	return v.StoreCancelScheduledShutdown(
		<-v.GoCancelScheduledShutdown(flags, make(chan *dbus.Call, 1)).Done)
}

// method Inhibit

func (v *interfaceManager) GoInhibit(flags dbus.Flags, ch chan *dbus.Call, what string, who string, why string, mode string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Inhibit", flags, ch, what, who, why, mode)
}

func (*interfaceManager) StoreInhibit(call *dbus.Call) (pipeFd dbus.UnixFD, err error) {
	err = call.Store(&pipeFd)
	return
}

func (v *interfaceManager) Inhibit(flags dbus.Flags, what string, who string, why string, mode string) (dbus.UnixFD, error) {
	return v.StoreInhibit(
		<-v.GoInhibit(flags, make(chan *dbus.Call, 1), what, who, why, mode).Done)
}

// method CanRebootToFirmwareSetup

func (v *interfaceManager) GoCanRebootToFirmwareSetup(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".CanRebootToFirmwareSetup", flags, ch)
}

func (*interfaceManager) StoreCanRebootToFirmwareSetup(call *dbus.Call) (result string, err error) {
	err = call.Store(&result)
	return
}

func (v *interfaceManager) CanRebootToFirmwareSetup(flags dbus.Flags) (string, error) {
	return v.StoreCanRebootToFirmwareSetup(
		<-v.GoCanRebootToFirmwareSetup(flags, make(chan *dbus.Call, 1)).Done)
}

// method SetRebootToFirmwareSetup

func (v *interfaceManager) GoSetRebootToFirmwareSetup(flags dbus.Flags, ch chan *dbus.Call, enable bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetRebootToFirmwareSetup", flags, ch, enable)
}

func (v *interfaceManager) SetRebootToFirmwareSetup(flags dbus.Flags, enable bool) error {
	return (<-v.GoSetRebootToFirmwareSetup(flags, make(chan *dbus.Call, 1), enable).Done).Err
}

// method SetWallMessage

func (v *interfaceManager) GoSetWallMessage(flags dbus.Flags, ch chan *dbus.Call, wallMessage string, enable bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetWallMessage", flags, ch, wallMessage, enable)
}

func (v *interfaceManager) SetWallMessage(flags dbus.Flags, wallMessage string, enable bool) error {
	return (<-v.GoSetWallMessage(flags, make(chan *dbus.Call, 1), wallMessage, enable).Done).Err
}

// signal SessionNew

func (v *interfaceManager) ConnectSessionNew(cb func(sessionId string, sessionPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SessionNew", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SessionNew",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var sessionId string
		var sessionPath dbus.ObjectPath
		err := dbus.Store(sig.Body, &sessionId, &sessionPath)
		if err == nil {
			cb(sessionId, sessionPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SessionRemoved

func (v *interfaceManager) ConnectSessionRemoved(cb func(sessionId string, sessionPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SessionRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SessionRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var sessionId string
		var sessionPath dbus.ObjectPath
		err := dbus.Store(sig.Body, &sessionId, &sessionPath)
		if err == nil {
			cb(sessionId, sessionPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UserNew

func (v *interfaceManager) ConnectUserNew(cb func(uid uint32, userPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UserNew", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UserNew",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var uid uint32
		var userPath dbus.ObjectPath
		err := dbus.Store(sig.Body, &uid, &userPath)
		if err == nil {
			cb(uid, userPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal UserRemoved

func (v *interfaceManager) ConnectUserRemoved(cb func(uid uint32, userPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "UserRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".UserRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var uid uint32
		var userPath dbus.ObjectPath
		err := dbus.Store(sig.Body, &uid, &userPath)
		if err == nil {
			cb(uid, userPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SeatNew

func (v *interfaceManager) ConnectSeatNew(cb func(seatId string, seatPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SeatNew", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SeatNew",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var seatId string
		var seatPath dbus.ObjectPath
		err := dbus.Store(sig.Body, &seatId, &seatPath)
		if err == nil {
			cb(seatId, seatPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal SeatRemoved

func (v *interfaceManager) ConnectSeatRemoved(cb func(seatId string, seatPath dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "SeatRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".SeatRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var seatId string
		var seatPath dbus.ObjectPath
		err := dbus.Store(sig.Body, &seatId, &seatPath)
		if err == nil {
			cb(seatId, seatPath)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PrepareForShutdown

func (v *interfaceManager) ConnectPrepareForShutdown(cb func(start bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PrepareForShutdown", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PrepareForShutdown",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var start bool
		err := dbus.Store(sig.Body, &start)
		if err == nil {
			cb(start)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal PrepareForSleep

func (v *interfaceManager) ConnectPrepareForSleep(cb func(start bool)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PrepareForSleep", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PrepareForSleep",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var start bool
		err := dbus.Store(sig.Body, &start)
		if err == nil {
			cb(start)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property EnableWallMessages b

func (v *interfaceManager) EnableWallMessages() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "EnableWallMessages",
	}
}

// property WallMessage s

func (v *interfaceManager) WallMessage() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "WallMessage",
	}
}

// property NAutoVTs u

func (v *interfaceManager) NAutoVTs() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "NAutoVTs",
	}
}

// property KillOnlyUsers as

func (v *interfaceManager) KillOnlyUsers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "KillOnlyUsers",
	}
}

// property KillExcludeUsers as

func (v *interfaceManager) KillExcludeUsers() proxy.PropStringArray {
	return &proxy.ImplPropStringArray{
		Impl: v,
		Name: "KillExcludeUsers",
	}
}

// property KillUserProcesses b

func (v *interfaceManager) KillUserProcesses() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "KillUserProcesses",
	}
}

// property RebootToFirmwareSetup b

func (v *interfaceManager) RebootToFirmwareSetup() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RebootToFirmwareSetup",
	}
}

// property IdleHint b

func (v *interfaceManager) IdleHint() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IdleHint",
	}
}

// property IdleSinceHint t

func (v *interfaceManager) IdleSinceHint() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHint",
	}
}

// property IdleSinceHintMonotonic t

func (v *interfaceManager) IdleSinceHintMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHintMonotonic",
	}
}

// property BlockInhibited s

func (v *interfaceManager) BlockInhibited() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BlockInhibited",
	}
}

// property DelayInhibited s

func (v *interfaceManager) DelayInhibited() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DelayInhibited",
	}
}

// property InhibitDelayMaxUSec t

func (v *interfaceManager) InhibitDelayMaxUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InhibitDelayMaxUSec",
	}
}

// property HandlePowerKey s

func (v *interfaceManager) HandlePowerKey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HandlePowerKey",
	}
}

// property HandleSuspendKey s

func (v *interfaceManager) HandleSuspendKey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HandleSuspendKey",
	}
}

// property HandleHibernateKey s

func (v *interfaceManager) HandleHibernateKey() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HandleHibernateKey",
	}
}

// property HandleLidSwitch s

func (v *interfaceManager) HandleLidSwitch() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HandleLidSwitch",
	}
}

// property HandleLidSwitchDocked s

func (v *interfaceManager) HandleLidSwitchDocked() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "HandleLidSwitchDocked",
	}
}

// property HoldoffTimeoutUSec t

func (v *interfaceManager) HoldoffTimeoutUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "HoldoffTimeoutUSec",
	}
}

// property IdleAction s

func (v *interfaceManager) IdleAction() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "IdleAction",
	}
}

// property IdleActionUSec t

func (v *interfaceManager) IdleActionUSec() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleActionUSec",
	}
}

// property PreparingForShutdown b

func (v *interfaceManager) PreparingForShutdown() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PreparingForShutdown",
	}
}

// property PreparingForSleep b

func (v *interfaceManager) PreparingForSleep() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "PreparingForSleep",
	}
}

type PropManagerScheduledShutdown interface {
	Get(flags dbus.Flags) (value ScheduledShutdown, err error)
	Set(flags dbus.Flags, value ScheduledShutdown) error
	ConnectChanged(cb func(hasValue bool, value ScheduledShutdown)) error
}

type implPropManagerScheduledShutdown struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropManagerScheduledShutdown) Get(flags dbus.Flags) (value ScheduledShutdown, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropManagerScheduledShutdown) Set(flags dbus.Flags, value ScheduledShutdown) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropManagerScheduledShutdown) ConnectChanged(cb func(hasValue bool, value ScheduledShutdown)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v ScheduledShutdown
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, ScheduledShutdown{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property ScheduledShutdown (st)

func (v *interfaceManager) ScheduledShutdown() PropManagerScheduledShutdown {
	return &implPropManagerScheduledShutdown{
		Impl: v,
		Name: "ScheduledShutdown",
	}
}

// property Docked b

func (v *interfaceManager) Docked() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Docked",
	}
}

// property RemoveIPC b

func (v *interfaceManager) RemoveIPC() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "RemoveIPC",
	}
}

// property RuntimeDirectorySize t

func (v *interfaceManager) RuntimeDirectorySize() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "RuntimeDirectorySize",
	}
}

// property InhibitorsMax t

func (v *interfaceManager) InhibitorsMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "InhibitorsMax",
	}
}

// property NCurrentInhibitors t

func (v *interfaceManager) NCurrentInhibitors() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "NCurrentInhibitors",
	}
}

// property SessionsMax t

func (v *interfaceManager) SessionsMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "SessionsMax",
	}
}

// property NCurrentSessions t

func (v *interfaceManager) NCurrentSessions() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "NCurrentSessions",
	}
}

// property UserTasksMax t

func (v *interfaceManager) UserTasksMax() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "UserTasksMax",
	}
}

type Seat interface {
	seat // interface org.freedesktop.login1.Seat
	proxy.Object
}

type objectSeat struct {
	interfaceSeat // interface org.freedesktop.login1.Seat
	proxy.ImplObject
}

func NewSeat(conn *dbus.Conn, path dbus.ObjectPath) (Seat, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectSeat)
	obj.ImplObject.Init_(conn, "org.freedesktop.login1", path)
	return obj, nil
}

type seat interface {
	GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Terminate(flags dbus.Flags) error
	GoActivateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call
	ActivateSession(flags dbus.Flags, sessionId string) error
	GoSwitchTo(flags dbus.Flags, ch chan *dbus.Call, vtnr uint32) *dbus.Call
	SwitchTo(flags dbus.Flags, vtnr uint32) error
	GoSwitchToNext(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SwitchToNext(flags dbus.Flags) error
	GoSwitchToPrevious(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	SwitchToPrevious(flags dbus.Flags) error
	Id() proxy.PropString
	ActiveSession() PropSessionInfo
	CanMultiSession() proxy.PropBool
	CanTTY() proxy.PropBool
	CanGraphical() proxy.PropBool
	Sessions() PropSessionInfoSlice
	IdleHint() proxy.PropBool
	IdleSinceHint() proxy.PropUint64
	IdleSinceHintMonotonic() proxy.PropUint64
}

type interfaceSeat struct{}

func (v *interfaceSeat) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceSeat) GetInterfaceName_() string {
	return "org.freedesktop.login1.Seat"
}

// method Terminate

func (v *interfaceSeat) GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Terminate", flags, ch)
}

func (v *interfaceSeat) Terminate(flags dbus.Flags) error {
	return (<-v.GoTerminate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method ActivateSession

func (v *interfaceSeat) GoActivateSession(flags dbus.Flags, ch chan *dbus.Call, sessionId string) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ActivateSession", flags, ch, sessionId)
}

func (v *interfaceSeat) ActivateSession(flags dbus.Flags, sessionId string) error {
	return (<-v.GoActivateSession(flags, make(chan *dbus.Call, 1), sessionId).Done).Err
}

// method SwitchTo

func (v *interfaceSeat) GoSwitchTo(flags dbus.Flags, ch chan *dbus.Call, vtnr uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SwitchTo", flags, ch, vtnr)
}

func (v *interfaceSeat) SwitchTo(flags dbus.Flags, vtnr uint32) error {
	return (<-v.GoSwitchTo(flags, make(chan *dbus.Call, 1), vtnr).Done).Err
}

// method SwitchToNext

func (v *interfaceSeat) GoSwitchToNext(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SwitchToNext", flags, ch)
}

func (v *interfaceSeat) SwitchToNext(flags dbus.Flags) error {
	return (<-v.GoSwitchToNext(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SwitchToPrevious

func (v *interfaceSeat) GoSwitchToPrevious(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SwitchToPrevious", flags, ch)
}

func (v *interfaceSeat) SwitchToPrevious(flags dbus.Flags) error {
	return (<-v.GoSwitchToPrevious(flags, make(chan *dbus.Call, 1)).Done).Err
}

// property Id s

func (v *interfaceSeat) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

// property ActiveSession (so)

func (v *interfaceSeat) ActiveSession() PropSessionInfo {
	return &implPropSessionInfo{
		Impl: v,
		Name: "ActiveSession",
	}
}

// property CanMultiSession b

func (v *interfaceSeat) CanMultiSession() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanMultiSession",
	}
}

// property CanTTY b

func (v *interfaceSeat) CanTTY() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanTTY",
	}
}

// property CanGraphical b

func (v *interfaceSeat) CanGraphical() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "CanGraphical",
	}
}

// property Sessions a(so)

func (v *interfaceSeat) Sessions() PropSessionInfoSlice {
	return &implPropSessionInfoSlice{
		Impl: v,
		Name: "Sessions",
	}
}

// property IdleHint b

func (v *interfaceSeat) IdleHint() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IdleHint",
	}
}

// property IdleSinceHint t

func (v *interfaceSeat) IdleSinceHint() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHint",
	}
}

// property IdleSinceHintMonotonic t

func (v *interfaceSeat) IdleSinceHintMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHintMonotonic",
	}
}

type Session interface {
	session // interface org.freedesktop.login1.Session
	proxy.Object
}

type objectSession struct {
	interfaceSession // interface org.freedesktop.login1.Session
	proxy.ImplObject
}

func NewSession(conn *dbus.Conn, path dbus.ObjectPath) (Session, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectSession)
	obj.ImplObject.Init_(conn, "org.freedesktop.login1", path)
	return obj, nil
}

type session interface {
	GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Terminate(flags dbus.Flags) error
	GoActivate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Activate(flags dbus.Flags) error
	GoLock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Lock(flags dbus.Flags) error
	GoUnlock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Unlock(flags dbus.Flags) error
	GoSetIdleHint(flags dbus.Flags, ch chan *dbus.Call, idle bool) *dbus.Call
	SetIdleHint(flags dbus.Flags, idle bool) error
	GoSetLockedHint(flags dbus.Flags, ch chan *dbus.Call, locked bool) *dbus.Call
	SetLockedHint(flags dbus.Flags, locked bool) error
	GoKill(flags dbus.Flags, ch chan *dbus.Call, who string, signo int32) *dbus.Call
	Kill(flags dbus.Flags, who string, signo int32) error
	GoTakeControl(flags dbus.Flags, ch chan *dbus.Call, force bool) *dbus.Call
	TakeControl(flags dbus.Flags, force bool) error
	GoReleaseControl(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	ReleaseControl(flags dbus.Flags) error
	GoTakeDevice(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call
	TakeDevice(flags dbus.Flags, major uint32, minor uint32) (dbus.UnixFD, bool, error)
	GoReleaseDevice(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call
	ReleaseDevice(flags dbus.Flags, major uint32, minor uint32) error
	GoPauseDeviceComplete(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call
	PauseDeviceComplete(flags dbus.Flags, major uint32, minor uint32) error
	ConnectPauseDevice(cb func(major uint32, minor uint32, type0 string)) (dbusutil.SignalHandlerId, error)
	ConnectResumeDevice(cb func(major uint32, minor uint32, fd dbus.UnixFD)) (dbusutil.SignalHandlerId, error)
	ConnectLock(cb func()) (dbusutil.SignalHandlerId, error)
	ConnectUnlock(cb func()) (dbusutil.SignalHandlerId, error)
	Id() proxy.PropString
	User() PropSessionUser
	Name() proxy.PropString
	Timestamp() proxy.PropUint64
	TimestampMonotonic() proxy.PropUint64
	VTNr() proxy.PropUint32
	Seat() PropSessionSeat
	TTY() proxy.PropString
	Display() proxy.PropString
	Remote() proxy.PropBool
	RemoteHost() proxy.PropString
	RemoteUser() proxy.PropString
	Service() proxy.PropString
	Desktop() proxy.PropString
	Scope() proxy.PropString
	Leader() proxy.PropUint32
	Audit() proxy.PropUint32
	Type() proxy.PropString
	Class() proxy.PropString
	Active() proxy.PropBool
	State() proxy.PropString
	IdleHint() proxy.PropBool
	IdleSinceHint() proxy.PropUint64
	IdleSinceHintMonotonic() proxy.PropUint64
	LockedHint() proxy.PropBool
}

type interfaceSession struct{}

func (v *interfaceSession) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceSession) GetInterfaceName_() string {
	return "org.freedesktop.login1.Session"
}

// method Terminate

func (v *interfaceSession) GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Terminate", flags, ch)
}

func (v *interfaceSession) Terminate(flags dbus.Flags) error {
	return (<-v.GoTerminate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Activate

func (v *interfaceSession) GoActivate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Activate", flags, ch)
}

func (v *interfaceSession) Activate(flags dbus.Flags) error {
	return (<-v.GoActivate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Lock

func (v *interfaceSession) GoLock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Lock", flags, ch)
}

func (v *interfaceSession) Lock(flags dbus.Flags) error {
	return (<-v.GoLock(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Unlock

func (v *interfaceSession) GoUnlock(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Unlock", flags, ch)
}

func (v *interfaceSession) Unlock(flags dbus.Flags) error {
	return (<-v.GoUnlock(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method SetIdleHint

func (v *interfaceSession) GoSetIdleHint(flags dbus.Flags, ch chan *dbus.Call, idle bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetIdleHint", flags, ch, idle)
}

func (v *interfaceSession) SetIdleHint(flags dbus.Flags, idle bool) error {
	return (<-v.GoSetIdleHint(flags, make(chan *dbus.Call, 1), idle).Done).Err
}

// method SetLockedHint

func (v *interfaceSession) GoSetLockedHint(flags dbus.Flags, ch chan *dbus.Call, locked bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetLockedHint", flags, ch, locked)
}

func (v *interfaceSession) SetLockedHint(flags dbus.Flags, locked bool) error {
	return (<-v.GoSetLockedHint(flags, make(chan *dbus.Call, 1), locked).Done).Err
}

// method Kill

func (v *interfaceSession) GoKill(flags dbus.Flags, ch chan *dbus.Call, who string, signo int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Kill", flags, ch, who, signo)
}

func (v *interfaceSession) Kill(flags dbus.Flags, who string, signo int32) error {
	return (<-v.GoKill(flags, make(chan *dbus.Call, 1), who, signo).Done).Err
}

// method TakeControl

func (v *interfaceSession) GoTakeControl(flags dbus.Flags, ch chan *dbus.Call, force bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TakeControl", flags, ch, force)
}

func (v *interfaceSession) TakeControl(flags dbus.Flags, force bool) error {
	return (<-v.GoTakeControl(flags, make(chan *dbus.Call, 1), force).Done).Err
}

// method ReleaseControl

func (v *interfaceSession) GoReleaseControl(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReleaseControl", flags, ch)
}

func (v *interfaceSession) ReleaseControl(flags dbus.Flags) error {
	return (<-v.GoReleaseControl(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method TakeDevice

func (v *interfaceSession) GoTakeDevice(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".TakeDevice", flags, ch, major, minor)
}

func (*interfaceSession) StoreTakeDevice(call *dbus.Call) (fd dbus.UnixFD, inactive bool, err error) {
	err = call.Store(&fd, &inactive)
	return
}

func (v *interfaceSession) TakeDevice(flags dbus.Flags, major uint32, minor uint32) (dbus.UnixFD, bool, error) {
	return v.StoreTakeDevice(
		<-v.GoTakeDevice(flags, make(chan *dbus.Call, 1), major, minor).Done)
}

// method ReleaseDevice

func (v *interfaceSession) GoReleaseDevice(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".ReleaseDevice", flags, ch, major, minor)
}

func (v *interfaceSession) ReleaseDevice(flags dbus.Flags, major uint32, minor uint32) error {
	return (<-v.GoReleaseDevice(flags, make(chan *dbus.Call, 1), major, minor).Done).Err
}

// method PauseDeviceComplete

func (v *interfaceSession) GoPauseDeviceComplete(flags dbus.Flags, ch chan *dbus.Call, major uint32, minor uint32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".PauseDeviceComplete", flags, ch, major, minor)
}

func (v *interfaceSession) PauseDeviceComplete(flags dbus.Flags, major uint32, minor uint32) error {
	return (<-v.GoPauseDeviceComplete(flags, make(chan *dbus.Call, 1), major, minor).Done).Err
}

// signal PauseDevice

func (v *interfaceSession) ConnectPauseDevice(cb func(major uint32, minor uint32, type0 string)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "PauseDevice", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".PauseDevice",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var major uint32
		var minor uint32
		var type0 string
		err := dbus.Store(sig.Body, &major, &minor, &type0)
		if err == nil {
			cb(major, minor, type0)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal ResumeDevice

func (v *interfaceSession) ConnectResumeDevice(cb func(major uint32, minor uint32, fd dbus.UnixFD)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "ResumeDevice", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".ResumeDevice",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var major uint32
		var minor uint32
		var fd dbus.UnixFD
		err := dbus.Store(sig.Body, &major, &minor, &fd)
		if err == nil {
			cb(major, minor, fd)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Lock

func (v *interfaceSession) ConnectLock(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Lock", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Lock",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal Unlock

func (v *interfaceSession) ConnectUnlock(cb func()) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "Unlock", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".Unlock",
	}
	handlerFunc := func(sig *dbus.Signal) {
		cb()
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Id s

func (v *interfaceSession) Id() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Id",
	}
}

type PropSessionUser interface {
	Get(flags dbus.Flags) (value UserInfo, err error)
	Set(flags dbus.Flags, value UserInfo) error
	ConnectChanged(cb func(hasValue bool, value UserInfo)) error
}

type implPropSessionUser struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropSessionUser) Get(flags dbus.Flags) (value UserInfo, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropSessionUser) Set(flags dbus.Flags, value UserInfo) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropSessionUser) ConnectChanged(cb func(hasValue bool, value UserInfo)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v UserInfo
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, UserInfo{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property User (uo)

func (v *interfaceSession) User() PropSessionUser {
	return &implPropSessionUser{
		Impl: v,
		Name: "User",
	}
}

// property Name s

func (v *interfaceSession) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Timestamp t

func (v *interfaceSession) Timestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Timestamp",
	}
}

// property TimestampMonotonic t

func (v *interfaceSession) TimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimestampMonotonic",
	}
}

// property VTNr u

func (v *interfaceSession) VTNr() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "VTNr",
	}
}

type PropSessionSeat interface {
	Get(flags dbus.Flags) (value SeatInfo, err error)
	Set(flags dbus.Flags, value SeatInfo) error
	ConnectChanged(cb func(hasValue bool, value SeatInfo)) error
}

type implPropSessionSeat struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropSessionSeat) Get(flags dbus.Flags) (value SeatInfo, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropSessionSeat) Set(flags dbus.Flags, value SeatInfo) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropSessionSeat) ConnectChanged(cb func(hasValue bool, value SeatInfo)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v SeatInfo
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, SeatInfo{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

// property Seat (so)

func (v *interfaceSession) Seat() PropSessionSeat {
	return &implPropSessionSeat{
		Impl: v,
		Name: "Seat",
	}
}

// property TTY s

func (v *interfaceSession) TTY() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "TTY",
	}
}

// property Display s

func (v *interfaceSession) Display() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Display",
	}
}

// property Remote b

func (v *interfaceSession) Remote() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Remote",
	}
}

// property RemoteHost s

func (v *interfaceSession) RemoteHost() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RemoteHost",
	}
}

// property RemoteUser s

func (v *interfaceSession) RemoteUser() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RemoteUser",
	}
}

// property Service s

func (v *interfaceSession) Service() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Service",
	}
}

// property Desktop s

func (v *interfaceSession) Desktop() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Desktop",
	}
}

// property Scope s

func (v *interfaceSession) Scope() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Scope",
	}
}

// property Leader u

func (v *interfaceSession) Leader() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Leader",
	}
}

// property Audit u

func (v *interfaceSession) Audit() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "Audit",
	}
}

// property Type s

func (v *interfaceSession) Type() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Type",
	}
}

// property Class s

func (v *interfaceSession) Class() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Class",
	}
}

// property Active b

func (v *interfaceSession) Active() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Active",
	}
}

// property State s

func (v *interfaceSession) State() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "State",
	}
}

// property IdleHint b

func (v *interfaceSession) IdleHint() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IdleHint",
	}
}

// property IdleSinceHint t

func (v *interfaceSession) IdleSinceHint() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHint",
	}
}

// property IdleSinceHintMonotonic t

func (v *interfaceSession) IdleSinceHintMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHintMonotonic",
	}
}

// property LockedHint b

func (v *interfaceSession) LockedHint() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "LockedHint",
	}
}

type User interface {
	user // interface org.freedesktop.login1.User
	proxy.Object
}

type objectUser struct {
	interfaceUser // interface org.freedesktop.login1.User
	proxy.ImplObject
}

func NewUser(conn *dbus.Conn, path dbus.ObjectPath) (User, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectUser)
	obj.ImplObject.Init_(conn, "org.freedesktop.login1", path)
	return obj, nil
}

type user interface {
	GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call
	Terminate(flags dbus.Flags) error
	GoKill(flags dbus.Flags, ch chan *dbus.Call, signo int32) *dbus.Call
	Kill(flags dbus.Flags, signo int32) error
	UID() proxy.PropUint32
	GID() proxy.PropUint32
	Name() proxy.PropString
	Timestamp() proxy.PropUint64
	TimestampMonotonic() proxy.PropUint64
	RuntimePath() proxy.PropString
	Service() proxy.PropString
	Slice() proxy.PropString
	Display() PropSessionInfo
	State() proxy.PropString
	Sessions() PropSessionInfoSlice
	IdleHint() proxy.PropBool
	IdleSinceHint() proxy.PropUint64
	IdleSinceHintMonotonic() proxy.PropUint64
	Linger() proxy.PropBool
}

type interfaceUser struct{}

func (v *interfaceUser) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceUser) GetInterfaceName_() string {
	return "org.freedesktop.login1.User"
}

// method Terminate

func (v *interfaceUser) GoTerminate(flags dbus.Flags, ch chan *dbus.Call) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Terminate", flags, ch)
}

func (v *interfaceUser) Terminate(flags dbus.Flags) error {
	return (<-v.GoTerminate(flags, make(chan *dbus.Call, 1)).Done).Err
}

// method Kill

func (v *interfaceUser) GoKill(flags dbus.Flags, ch chan *dbus.Call, signo int32) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".Kill", flags, ch, signo)
}

func (v *interfaceUser) Kill(flags dbus.Flags, signo int32) error {
	return (<-v.GoKill(flags, make(chan *dbus.Call, 1), signo).Done).Err
}

// property UID u

func (v *interfaceUser) UID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "UID",
	}
}

// property GID u

func (v *interfaceUser) GID() proxy.PropUint32 {
	return &proxy.ImplPropUint32{
		Impl: v,
		Name: "GID",
	}
}

// property Name s

func (v *interfaceUser) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Timestamp t

func (v *interfaceUser) Timestamp() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "Timestamp",
	}
}

// property TimestampMonotonic t

func (v *interfaceUser) TimestampMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "TimestampMonotonic",
	}
}

// property RuntimePath s

func (v *interfaceUser) RuntimePath() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "RuntimePath",
	}
}

// property Service s

func (v *interfaceUser) Service() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Service",
	}
}

// property Slice s

func (v *interfaceUser) Slice() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Slice",
	}
}

// property Display (so)

func (v *interfaceUser) Display() PropSessionInfo {
	return &implPropSessionInfo{
		Impl: v,
		Name: "Display",
	}
}

// property State s

func (v *interfaceUser) State() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "State",
	}
}

// property Sessions a(so)

func (v *interfaceUser) Sessions() PropSessionInfoSlice {
	return &implPropSessionInfoSlice{
		Impl: v,
		Name: "Sessions",
	}
}

// property IdleHint b

func (v *interfaceUser) IdleHint() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "IdleHint",
	}
}

// property IdleSinceHint t

func (v *interfaceUser) IdleSinceHint() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHint",
	}
}

// property IdleSinceHintMonotonic t

func (v *interfaceUser) IdleSinceHintMonotonic() proxy.PropUint64 {
	return &proxy.ImplPropUint64{
		Impl: v,
		Name: "IdleSinceHintMonotonic",
	}
}

// property Linger b

func (v *interfaceUser) Linger() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Linger",
	}
}

type PropSessionInfo interface {
	Get(flags dbus.Flags) (value SessionInfo, err error)
	Set(flags dbus.Flags, value SessionInfo) error
	ConnectChanged(cb func(hasValue bool, value SessionInfo)) error
}

type implPropSessionInfo struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropSessionInfo) Get(flags dbus.Flags) (value SessionInfo, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropSessionInfo) Set(flags dbus.Flags, value SessionInfo) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropSessionInfo) ConnectChanged(cb func(hasValue bool, value SessionInfo)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v SessionInfo
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, SessionInfo{})
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}

type PropSessionInfoSlice interface {
	Get(flags dbus.Flags) (value []SessionInfo, err error)
	Set(flags dbus.Flags, value []SessionInfo) error
	ConnectChanged(cb func(hasValue bool, value []SessionInfo)) error
}

type implPropSessionInfoSlice struct {
	Impl proxy.Implementer
	Name string
}

func (p implPropSessionInfoSlice) Get(flags dbus.Flags) (value []SessionInfo, err error) {
	err = p.Impl.GetObject_().GetProperty_(flags, p.Impl.GetInterfaceName_(),
		p.Name, &value)
	return
}

func (p implPropSessionInfoSlice) Set(flags dbus.Flags, value []SessionInfo) error {
	return p.Impl.GetObject_().SetProperty_(flags, p.Impl.GetInterfaceName_(), p.Name, value)
}

func (p implPropSessionInfoSlice) ConnectChanged(cb func(hasValue bool, value []SessionInfo)) error {
	if cb == nil {
		return errors.New("nil callback")
	}
	cb0 := func(hasValue bool, value interface{}) {
		if hasValue {
			var v []SessionInfo
			err := dbus.Store([]interface{}{value}, &v)
			if err != nil {
				return
			}
			cb(true, v)
		} else {
			cb(false, nil)
		}
	}
	return p.Impl.GetObject_().ConnectPropertyChanged_(p.Impl.GetInterfaceName_(),
		p.Name, cb0)
}
