/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

struct cpssp {
	char name[1024];
	struct sig_std_logic_merge *m[N];
};

#if DEBUG
static void
NAME_(N_set)(void *_cpssp, int n, unsigned int val)
{
	char c;

	switch (val) {
	case SIG_STD_LOGIC_U: c = 'U'; break;
	case SIG_STD_LOGIC_X: c = 'X'; break;
	case SIG_STD_LOGIC_0: c = '0'; break;
	case SIG_STD_LOGIC_1: c = '1'; break;
	case SIG_STD_LOGIC_Z: c = 'Z'; break;
	case SIG_STD_LOGIC_W: c = 'W'; break;
	case SIG_STD_LOGIC_L: c = 'L'; break;
	case SIG_STD_LOGIC_H: c = 'H'; break;
	default: c = '?'; break;
	};
	struct cpssp *cpssp = _cpssp;

	fprintf(stderr, "%s(%u): val='%c'\n", cpssp->name, n, c);
}
#endif /* DEBUG */

void *
NAME_(create)(
	const char *name
	, struct sig_manage *manage
	, struct sig_std_logic *port_a00
#if 2 <= N
	, struct sig_std_logic *port_a01
#endif
#if 3 <= N
	, struct sig_std_logic *port_a02
#endif
#if 4 <= N
	, struct sig_std_logic *port_a03
#endif
#if 5 <= N
	, struct sig_std_logic *port_a04
#endif
#if 6 <= N
	, struct sig_std_logic *port_a05
#endif
#if 7 <= N
	, struct sig_std_logic *port_a06
#endif
#if 8 <= N
	, struct sig_std_logic *port_a07
#endif
#if 9 <= N
	, struct sig_std_logic *port_a08
#endif
#if 10 <= N
	, struct sig_std_logic *port_a09
#endif
#if 11 <= N
	, struct sig_std_logic *port_a10
#endif
#if 12 <= N
	, struct sig_std_logic *port_a11
#endif
#if 13 <= N
	, struct sig_std_logic *port_a12
#endif
#if 14 <= N
	, struct sig_std_logic *port_a13
#endif
#if 15 <= N
	, struct sig_std_logic *port_a14
#endif
#if 16 <= N
	, struct sig_std_logic *port_a15
#endif
#if 17 <= N
	, struct sig_std_logic *port_a16
#endif
#if 18 <= N
	, struct sig_std_logic *port_a17
#endif
#if 19 <= N
	, struct sig_std_logic *port_a18
#endif
#if 20 <= N
	, struct sig_std_logic *port_a19
#endif
#if 21 <= N
	, struct sig_std_logic *port_a20
#endif
#if 22 <= N
	, struct sig_std_logic *port_a21
#endif
#if 23 <= N
	, struct sig_std_logic *port_a22
#endif
#if 24 <= N
	, struct sig_std_logic *port_a23
#endif
#if 25 <= N
	, struct sig_std_logic *port_a24
#endif
#if 26 <= N
	, struct sig_std_logic *port_a25
#endif
#if 27 <= N
	, struct sig_std_logic *port_a26
#endif
#if 28 <= N
	, struct sig_std_logic *port_a27
#endif
#if 29 <= N
	, struct sig_std_logic *port_a28
#endif
#if 30 <= N
	, struct sig_std_logic *port_a29
#endif
	, struct sig_std_logic *port_b00
#if 2 <= N
	, struct sig_std_logic *port_b01
#endif
#if 3 <= N
	, struct sig_std_logic *port_b02
#endif
#if 4 <= N
	, struct sig_std_logic *port_b03
#endif
#if 5 <= N
	, struct sig_std_logic *port_b04
#endif
#if 6 <= N
	, struct sig_std_logic *port_b05
#endif
#if 7 <= N
	, struct sig_std_logic *port_b06
#endif
#if 8 <= N
	, struct sig_std_logic *port_b07
#endif
#if 9 <= N
	, struct sig_std_logic *port_b08
#endif
#if 10 <= N
	, struct sig_std_logic *port_b09
#endif
#if 11 <= N
	, struct sig_std_logic *port_b10
#endif
#if 12 <= N
	, struct sig_std_logic *port_b11
#endif
#if 13 <= N
	, struct sig_std_logic *port_b12
#endif
#if 14 <= N
	, struct sig_std_logic *port_b13
#endif
#if 15 <= N
	, struct sig_std_logic *port_b14
#endif
#if 16 <= N
	, struct sig_std_logic *port_b15
#endif
#if 17 <= N
	, struct sig_std_logic *port_b16
#endif
#if 18 <= N
	, struct sig_std_logic *port_b17
#endif
#if 19 <= N
	, struct sig_std_logic *port_b18
#endif
#if 20 <= N
	, struct sig_std_logic *port_b19
#endif
#if 21 <= N
	, struct sig_std_logic *port_b20
#endif
#if 22 <= N
	, struct sig_std_logic *port_b21
#endif
#if 23 <= N
	, struct sig_std_logic *port_b22
#endif
#if 24 <= N
	, struct sig_std_logic *port_b23
#endif
#if 25 <= N
	, struct sig_std_logic *port_b24
#endif
#if 26 <= N
	, struct sig_std_logic *port_b25
#endif
#if 27 <= N
	, struct sig_std_logic *port_b26
#endif
#if 28 <= N
	, struct sig_std_logic *port_b27
#endif
#if 29 <= N
	, struct sig_std_logic *port_b28
#endif
#if 30 <= N
	, struct sig_std_logic *port_b29
#endif
)
{
#if DEBUG
	static const struct sig_std_logic_funcs port_func = {
		.std_logic_setN = NAME_(N_set),
	};
#endif /* DEBUG */
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	system_name_push(name);
	strcpy(cpssp->name, system_path());

#if DEBUG
	sig_std_logic_connect_inN(port_a00, cpssp, 0, &port_func);
#if 2 <= N
	sig_std_logic_connect_inN(port_a01, cpssp, 1, &port_func);
#endif
#if 3 <= N
	sig_std_logic_connect_inN(port_a02, cpssp, 2, &port_func);
#endif
#if 4 <= N
	sig_std_logic_connect_inN(port_a03, cpssp, 3, &port_func);
#endif
#if 5 <= N
	sig_std_logic_connect_inN(port_a04, cpssp, 4, &port_func);
#endif
#if 6 <= N
	sig_std_logic_connect_inN(port_a05, cpssp, 5, &port_func);
#endif
#if 7 <= N
	sig_std_logic_connect_inN(port_a06, cpssp, 6, &port_func);
#endif
#if 8 <= N
	sig_std_logic_connect_inN(port_a07, cpssp, 7, &port_func);
#endif
#if 9 <= N
	sig_std_logic_connect_inN(port_a08, cpssp, 8, &port_func);
#endif
#if 10 <= N
	sig_std_logic_connect_inN(port_a09, cpssp, 9, &port_func);
#endif
#if 11 <= N
	sig_std_logic_connect_inN(port_a10, cpssp, 10, &port_func);
#endif
#if 12 <= N
	sig_std_logic_connect_inN(port_a11, cpssp, 11, &port_func);
#endif
#if 13 <= N
	sig_std_logic_connect_inN(port_a12, cpssp, 12, &port_func);
#endif
#if 14 <= N
	sig_std_logic_connect_inN(port_a13, cpssp, 13, &port_func);
#endif
#if 15 <= N
	sig_std_logic_connect_inN(port_a14, cpssp, 14, &port_func);
#endif
#if 16 <= N
	sig_std_logic_connect_inN(port_a15, cpssp, 15, &port_func);
#endif
#if 17 <= N
	sig_std_logic_connect_inN(port_a16, cpssp, 16, &port_func);
#endif
#if 18 <= N
	sig_std_logic_connect_inN(port_a17, cpssp, 17, &port_func);
#endif
#if 19 <= N
	sig_std_logic_connect_inN(port_a18, cpssp, 18, &port_func);
#endif
#if 20 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 19, &port_func);
#endif
#if 21 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 20, &port_func);
#endif
#if 22 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 21, &port_func);
#endif
#if 23 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 22, &port_func);
#endif
#if 24 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 23, &port_func);
#endif
#if 25 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 24, &port_func);
#endif
#if 26 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 25, &port_func);
#endif
#if 27 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 26, &port_func);
#endif
#if 28 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 27, &port_func);
#endif
#if 29 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 28, &port_func);
#endif
#if 30 <= N
	sig_std_logic_connect_inN(port_a19, cpssp, 29, &port_func);
#endif
#endif /* DEBUG */

	cpssp->m[0] = sig_std_logic_merge(port_a00, port_b00);
#if 2 <= N
	cpssp->m[1] = sig_std_logic_merge(port_a01, port_b01);
#endif
#if 3 <= N
	cpssp->m[2] = sig_std_logic_merge(port_a02, port_b02);
#endif
#if 4 <= N
	cpssp->m[3] = sig_std_logic_merge(port_a03, port_b03);
#endif
#if 5 <= N
	cpssp->m[4] = sig_std_logic_merge(port_a04, port_b04);
#endif
#if 6 <= N
	cpssp->m[5] = sig_std_logic_merge(port_a05, port_b05);
#endif
#if 7 <= N
	cpssp->m[6] = sig_std_logic_merge(port_a06, port_b06);
#endif
#if 8 <= N
	cpssp->m[7] = sig_std_logic_merge(port_a07, port_b07);
#endif
#if 9 <= N
	cpssp->m[8] = sig_std_logic_merge(port_a08, port_b08);
#endif
#if 10 <= N
	cpssp->m[9] = sig_std_logic_merge(port_a09, port_b09);
#endif
#if 11 <= N
	cpssp->m[10] = sig_std_logic_merge(port_a10, port_b10);
#endif
#if 12 <= N
	cpssp->m[11] = sig_std_logic_merge(port_a11, port_b11);
#endif
#if 13 <= N
	cpssp->m[12] = sig_std_logic_merge(port_a12, port_b12);
#endif
#if 14 <= N
	cpssp->m[13] = sig_std_logic_merge(port_a13, port_b13);
#endif
#if 15 <= N
	cpssp->m[14] = sig_std_logic_merge(port_a14, port_b14);
#endif
#if 16 <= N
	cpssp->m[15] = sig_std_logic_merge(port_a15, port_b15);
#endif
#if 17 <= N
	cpssp->m[16] = sig_std_logic_merge(port_a16, port_b16);
#endif
#if 18 <= N
	cpssp->m[17] = sig_std_logic_merge(port_a17, port_b17);
#endif
#if 19 <= N
	cpssp->m[18] = sig_std_logic_merge(port_a18, port_b18);
#endif
#if 20 <= N
	cpssp->m[19] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 21 <= N
	cpssp->m[20] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 22 <= N
	cpssp->m[21] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 23 <= N
	cpssp->m[22] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 24 <= N
	cpssp->m[23] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 25 <= N
	cpssp->m[24] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 26 <= N
	cpssp->m[25] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 27 <= N
	cpssp->m[26] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 28 <= N
	cpssp->m[27] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 29 <= N
	cpssp->m[28] = sig_std_logic_merge(port_a19, port_b19);
#endif
#if 30 <= N
	cpssp->m[29] = sig_std_logic_merge(port_a19, port_b19);
#endif

	system_name_pop();

	return cpssp;
}

void
NAME_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

#if 0 /* FIXME */
	sig_std_logic_split(cpssp->m[0]);
	sig_std_logic_split(cpssp->m[1]);
	sig_std_logic_split(cpssp->m[2]);
	sig_std_logic_split(cpssp->m[3]);
	sig_std_logic_split(cpssp->m[4]);
	sig_std_logic_split(cpssp->m[5]);
	sig_std_logic_split(cpssp->m[6]);
	sig_std_logic_split(cpssp->m[7]);
	sig_std_logic_split(cpssp->m[8]);
	sig_std_logic_split(cpssp->m[9]);
	sig_std_logic_split(cpssp->m[10]);
	sig_std_logic_split(cpssp->m[11]);
	sig_std_logic_split(cpssp->m[12]);
	sig_std_logic_split(cpssp->m[13]);
	sig_std_logic_split(cpssp->m[14]);
	sig_std_logic_split(cpssp->m[15]);
	sig_std_logic_split(cpssp->m[16]);
	sig_std_logic_split(cpssp->m[17]);
	sig_std_logic_split(cpssp->m[18]);
	sig_std_logic_split(cpssp->m[19]);
#endif

	shm_free(cpssp);
}

void
NAME_(suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
NAME_(resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
