/*******************************************************************************
 * Copyright (c) 2000, 2013 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.ui.tests;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.jdt.ui.tests.leaks.JavaLeakTest;
import org.eclipse.jdt.ui.tests.leaks.TextViewerUndoManagerLeakTest;
import org.eclipse.jdt.ui.tests.leaks.UndoManagerLeakTest;
import org.eclipse.jdt.ui.tests.search.SearchLeakTestWrapper;


/**
 * Test for leaks
 */
public class LeakTestSuite extends TestSuite {

	/**
	 * Returns the suite.  This is required to
	 * use the JUnit Launcher.
	 *
	 * @return the test suite.
	 */
	public static Test suite() {
		return new LeakTestSuite();
	}

	public LeakTestSuite() {
		super(LeakTestSuite.class.getName());
		addTest(JavaLeakTest.suite());
		addTest(SearchLeakTestWrapper.suite());
		addTest(UndoManagerLeakTest.suite());
		addTest(TextViewerUndoManagerLeakTest.suite());
	}

}

