/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.jci.compilers;

import junit.framework.AssertionFailedError;

public final class EclipseJavaCompilerTestCase extends AbstractCompilerTestCase {

    @Override
    public String getCompilerName() {
        return "eclipse";
    }

    @Override
    public JavaCompiler createJavaCompiler() {
        return new EclipseJavaCompiler();
    }

    @Override
    public void testAdditionalTopLevelClassCompile() throws Exception {
        try {
            super.testAdditionalTopLevelClassCompile();
        } catch (AssertionFailedError e) {
            if (e.getMessage().contains("The type AdditionalTopLevel collides")) {
                System.err.println("WARNING: See JCI-59 - EclipseJavaCompile#isPackage() is not yet working correctly - ignoring the failure for now");
            } else {
                throw e;
            }
        }
    }
}
