#
# Author:: Joe Williams (<joe@joetify.com>)
# Author:: Tyler Cloke (<tyler@chef.io>)
# Copyright:: Copyright 2009-2016, Joe Williams
# License:: Apache License, Version 2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require "chef/resource"
require "chef/provider/erl_call"

class Chef
  class Resource
    class ErlCall < Chef::Resource

      # erl_call : http://erlang.org/doc/man/erl_call.html

      identity_attr :code

      default_action :run

      def initialize(name, run_context = nil)
        super

        @code = "q()." # your erlang code goes here
        @cookie = nil # cookie of the erlang node
        @distributed = false # if you want to have a distributed erlang node
        @name_type = "sname" # type of erlang hostname name or sname
        @node_name = "chef@localhost" # the erlang node hostname
      end

      def code(arg = nil)
        set_or_return(
          :code,
          arg,
          :kind_of => [ String ]
        )
      end

      def cookie(arg = nil)
        set_or_return(
          :cookie,
          arg,
          :kind_of => [ String ]
        )
      end

      def distributed(arg = nil)
        set_or_return(
          :distributed,
          arg,
          :kind_of => [ TrueClass, FalseClass ]
        )
      end

      def name_type(arg = nil)
        set_or_return(
          :name_type,
          arg,
          :kind_of => [ String ]
        )
      end

      def node_name(arg = nil)
        set_or_return(
          :node_name,
          arg,
          :kind_of => [ String ]
        )
      end

      # This resource is deprecated.
      def after_created
        Chef.deprecated(:erl_resource, "The #{resource_name} resource (#{source_line}) is deprecated and will be removed from Chef core in 14.0 (April 2018).")
      end

    end
  end
end
