/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.ArrangeMeasurement;
import WIMSchem.ArrangeMolecule;
import WIMSchem.Molecule;
import WIMSchem.SVGBuilder;
import java.io.PrintWriter;
import java.io.StringWriter;

public class SVGMolecule
implements ArrangeMeasurement {
    private SVGBuilder svg = new SVGBuilder();
    private Molecule mol;
    private double scale = 20.0;
    private ArrangeMolecule arrmol;

    public SVGMolecule(Molecule mol) {
        this.mol = mol;
        this.arrmol = new ArrangeMolecule(mol, this);
        this.arrmol.setDevRounding(false);
    }

    public void draw() {
        int n;
        this.arrmol.arrange();
        for (n = 0; n < this.arrmol.numLines(); ++n) {
            double oy;
            double ox;
            int btype = this.arrmol.lineType(n);
            double x1 = this.arrmol.lineX1(n);
            double y1 = this.arrmol.lineY1(n);
            double x2 = this.arrmol.lineX2(n);
            double y2 = this.arrmol.lineY2(n);
            double dx = x2 - x1;
            double dy = y2 - y1;
            if (btype == 1) {
                this.svg.drawLine(x1, y1, x2, y2, this.arrmol.lineCol(n), this.arrmol.lineSize(n));
                continue;
            }
            if (btype == 2) {
                double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                double ox2 = norm * dy;
                double oy2 = -norm * dx;
                this.svg.drawPoly(new double[]{x1, x2 - ox2, x2 + ox2}, new double[]{y1, y2 - oy2, y2 + oy2}, -1, 0.0, this.arrmol.lineCol(n), true);
                continue;
            }
            if (btype == 3) {
                int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.15);
                double norm = 0.15 * this.scale / Math.sqrt(dx * dx + dy * dy);
                ox = norm * dy;
                oy = -norm * dx;
                for (int i = 0; i <= nsteps + 1; ++i) {
                    double cx = x1 + (double)i * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)i * dy / (double)(nsteps + 1);
                    double ix = ox * (double)i / (double)(nsteps + 1);
                    double iy = oy * (double)i / (double)(nsteps + 1);
                    this.svg.drawLine(cx - ix, cy - iy, cx + ix, cy + iy, this.arrmol.lineCol(n), this.arrmol.lineSize(n));
                }
                continue;
            }
            if (btype == 4) {
                int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.2);
                double norm = 0.2 * this.scale / Math.sqrt(dx * dx + dy * dy);
                ox = norm * dy;
                oy = -norm * dx;
                int sz = 1 + 3 * (nsteps + 1);
                double[] x = new double[sz];
                double[] y = new double[sz];
                boolean[] ctrl = new boolean[sz];
                x[0] = x1;
                y[0] = y1;
                ctrl[0] = false;
                int i = 0;
                int j = 1;
                while (i <= nsteps) {
                    double ax = x1 + (double)i * dx / (double)(nsteps + 1);
                    double ay = y1 + (double)i * dy / (double)(nsteps + 1);
                    double cx = x1 + (double)(i + 1) * dx / (double)(nsteps + 1);
                    double cy = y1 + (double)(i + 1) * dy / (double)(nsteps + 1);
                    double bx = (ax + cx) / 2.0;
                    double by = (ay + cy) / 2.0;
                    int sign = i % 2 == 0 ? 1 : -1;
                    x[j] = ax;
                    x[j + 1] = bx + (double)sign * ox;
                    x[j + 2] = cx;
                    y[j] = ay;
                    y[j + 1] = by + (double)sign * oy;
                    y[j + 2] = cy;
                    ctrl[j] = true;
                    ctrl[j + 1] = true;
                    ctrl[j + 2] = false;
                    ++i;
                    j += 3;
                }
                this.svg.drawCurve(x, y, ctrl, this.arrmol.lineCol(n), this.arrmol.lineSize(n), -1, false);
                continue;
            }
            if (btype != 5) continue;
            int nsteps = (int)Math.ceil(Math.sqrt(dx * dx + dy * dy) * 0.1);
            float radius = (float)this.arrmol.lineSize(n);
            for (int i = 0; i <= nsteps + 1; ++i) {
                double cx = x1 + (double)i * dx / (double)(nsteps + 1);
                double cy = y1 + (double)i * dy / (double)(nsteps + 1);
                this.svg.drawOval(cx, cy, radius, radius, -1, 0.0, this.arrmol.lineCol(n));
            }
        }
        for (n = 0; n < this.arrmol.numPoints(); ++n) {
            String txt = this.arrmol.pointText(n);
            if (txt == null) continue;
            int fstyle = this.arrmol.pointBold(n) ? 1 : 0;
            this.svg.drawText(this.arrmol.pointCX(n), this.arrmol.pointCY(n) + this.arrmol.pointRH(n), txt, this.arrmol.pointFontSize(n), this.arrmol.pointCol(n), fstyle, 0);
        }
    }

    public void build(PrintWriter out) {
        int w = (int)Math.ceil(this.svg.highX() - this.svg.lowX());
        int h = (int)Math.ceil(this.svg.highY() - this.svg.lowY());
        this.svg.build(out, w, h, -this.svg.lowX(), -this.svg.lowY(), 1.0, 1.0);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.build(new PrintWriter(sw));
        return sw.toString();
    }

    public double scale() {
        return this.scale;
    }

    public double angToX(double AX) {
        return AX * this.scale;
    }

    public double angToY(double AY) {
        return -AY * this.scale;
    }

    public double xToAng(double PX) {
        return PX * this.scale;
    }

    public double yToAng(double PY) {
        return -PY * this.scale;
    }

    public double[] measureText(String str, double fontSize) {
        return this.svg.measureText(str, fontSize, 0);
    }
}

