/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class BoundedPointConstructor
extends ObjectConstructor
implements Selector {
    boolean Control;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        this.Control = mouseEvent.isControlDown();
        ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        if (constructionObject == null) {
            return;
        }
        PointObject pointObject = new PointObject(zirkelCanvas.getConstruction(), zirkelCanvas.x(mouseEvent.getX()), zirkelCanvas.y(mouseEvent.getY()), constructionObject);
        if (!mouseEvent.isShiftDown()) {
            pointObject.setUseAlpha(true);
        }
        if (this.Control && constructionObject instanceof InsideObject) {
            pointObject.setInside(true);
        }
        zirkelCanvas.addObject(pointObject);
        pointObject.validate();
        pointObject.setDefaults();
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        this.Control = mouseEvent.isControlDown();
        zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.boundedpoint", "Bounded Point: Choose a circle or line!"));
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        if (this.Control && constructionObject instanceof InsideObject) {
            return true;
        }
        return !this.Control && constructionObject instanceof PointonObject;
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "PointOn")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        if (!xmlTag.hasParam("on")) {
            throw new ConstructionException("Point bound missing!");
        }
        try {
            PointObject pointObject;
            ConstructionObject constructionObject = construction.find(xmlTag.getValue("on"));
            if (constructionObject != null && !(constructionObject instanceof PointonObject) && !(constructionObject instanceof InsideObject)) {
                throw new ConstructionException("");
            }
            double d2 = 0.0;
            double d3 = 0.0;
            try {
                d2 = new Double(xmlTag.getValue("x"));
                d3 = new Double(xmlTag.getValue("y"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (constructionObject != null) {
                pointObject = new PointObject(construction, d2, d3, constructionObject);
            } else {
                pointObject = new PointObject(construction, d2, d3);
                pointObject.setLaterBind(xmlTag.getValue("on"));
            }
            pointObject.setInside(xmlTag.hasTrueParam("inside"));
            try {
                ConstructionObject constructionObject2;
                double d4 = new Double(xmlTag.getValue("alpha"));
                pointObject.setAlpha(d4);
                pointObject.setUseAlpha(true);
                if (xmlTag.hasParam("on") && (constructionObject2 = construction.find(xmlTag.getValue("on"))) != null) {
                    pointObject.project(constructionObject2, d4);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (xmlTag.hasParam("shape")) {
                String string = xmlTag.getValue("shape");
                if (string.equals("square")) {
                    pointObject.setType(0);
                }
                if (string.equals("diamond")) {
                    pointObject.setType(1);
                }
                if (string.equals("circle")) {
                    pointObject.setType(2);
                }
                if (string.equals("dot")) {
                    pointObject.setType(3);
                }
                if (string.equals("cross")) {
                    pointObject.setType(4);
                }
                if (string.equals("dcross")) {
                    pointObject.setType(5);
                }
            }
            this.setName(xmlTag, pointObject);
            this.set(xmlTree, pointObject);
            construction.add(pointObject);
            this.setConditionals(xmlTree, construction, pointObject);
            if (xmlTag.hasParam("fixed")) {
                pointObject.setFixed(xmlTag.getValue("x"), xmlTag.getValue("y"));
            }
            if (xmlTag.hasParam("increment")) {
                try {
                    pointObject.setIncrement(new Double(xmlTag.getValue("increment")));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ConstructionException("Illegal point bound!");
        }
        return true;
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setPrompt(Zirkel.name("prompt.pointon"));
    }
}

