/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef DIRECTOR_DETECTION_PATHS_H
#define DIRECTOR_DETECTION_PATHS_H

namespace Director {

const char *const directoryGlobs[] = {
	"install",
	"win_data",						// L-ZONE
	"data",
	"program",						// Arc Media products
	"media",						// Gundam
	"mvm",							// Master of the Elements
	"datas",						// O!KAY! subscription from Domino Verlag
	"numbers",						// JumpStart Learning Games
	"blender",						// Blender CD-ROM magazines
	"cd_data",						// Polis
	"ojo2000",						// Abrapalabra
	"bb",							// Blinky Bill
	"fctdata",
	"fct",					   		// Felix the Cat
	"95instal",						// Fisher-Price Little People
//	"mfile",
	"lingo expo",					// D4 sample movies
	"main",							// Meet MediaBand
//	"abc",							// Alphabet Train
//	"123",							// Ktar Alarkam
	"fl1",							// Flipper & Lopaka
	"cipdemo",
	"cipher",						// Jewels of the Oracle
	"gems",							// Gems of Darkness / Jewels II
	"maccurio",
	"wincurio",						// Curio City
	"_A.D.A.M. Data",				// ADAM Software Products
	"_A.D.A.M.  Data",				// ADAM Software Products with more space
	"_setup",
	"bin",
	"adam resources",				// ADAM Software Products
	"NAV",
	"Daedalus Max",					// The Daedalus Encounter
	0
};

} // End of namespace Director

#endif
