% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-measures.R, R/geom-transformers.R
\name{st_line_project_point}
\alias{st_line_project_point}
\alias{st_line_project}
\alias{st_line_interpolate}
\title{Project point on linestring, interpolate along a linestring}
\usage{
st_line_project(line, point, normalized = FALSE)

st_line_interpolate(line, dist, normalized = FALSE)
}
\arguments{
\item{line}{object of class \code{sfc} with \code{LINESTRING} geometry}

\item{point}{object of class \code{sfc} with \code{POINT} geometry}

\item{normalized}{logical; if \code{TRUE}, use or return distance normalised to 0-1}

\item{dist}{numeric or units, vector with distance value(s), in units of the coordinates}
}
\value{
\code{st_line_project} returns the distance(s) of point(s) along line(s), when projected on the line(s)

\code{st_line_interpolate} returns the point(s) at dist(s), when measured along (interpolated on) the line(s)
}
\description{
Project point on linestring, interpolate along a linestring
}
\details{
arguments \code{line}, \code{point} and \code{dist} are recycled to common length when needed
}
\examples{
st_line_project(st_as_sfc("LINESTRING (0 0, 10 10)"), st_as_sfc(c("POINT (0 0)", "POINT (5 5)")))
st_line_project(st_as_sfc("LINESTRING (0 0, 10 10)"), st_as_sfc("POINT (5 5)"), TRUE)
st_line_interpolate(st_as_sfc("LINESTRING (0 0, 1 1)"), 1)
st_line_interpolate(st_as_sfc("LINESTRING (0 0, 1 1)"), 1, TRUE)
# https://github.com/r-spatial/sf/issues/2542; use for geographic coordinates:
l1 <- st_as_sfc("LINESTRING (10.1 50.1, 10.2 50.2)", crs = 'OGC:CRS84')
dists = units::set_units(seq(0, sqrt(2)/10, length.out = 5), degrees)
st_line_interpolate(l1, dists)
}
