% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_pipe_linter.R
\name{nested_pipe_linter}
\alias{nested_pipe_linter}
\title{Block usage of pipes nested inside other calls}
\usage{
nested_pipe_linter(
  allow_inline = TRUE,
  allow_outer_calls = c("try", "tryCatch", "withCallingHandlers")
)
}
\arguments{
\item{allow_inline}{Logical, default \code{TRUE}, in which case only "inner"
pipelines which span more than one line are linted. If \code{FALSE}, even
"inner" pipelines that fit in one line are linted.}

\item{allow_outer_calls}{Character vector dictating which "outer"
calls to exempt from the requirement to unnest (see examples). Defaults
to \code{\link[=try]{try()}}, \code{\link[=tryCatch]{tryCatch()}}, and \code{\link[=withCallingHandlers]{withCallingHandlers()}}.}
}
\description{
Nesting pipes harms readability; extract sub-steps to separate variables,
append further pipeline steps, or otherwise refactor such usage away.
}
\examples{
# will produce lints
code <- "df1 \%>\%\n  inner_join(df2 \%>\%\n    select(a, b)\n  )"
writeLines(code)
lint(
  text = code,
  linters = nested_pipe_linter()
)

lint(
  text = "df1 \%>\% inner_join(df2 \%>\% select(a, b))",
  linters = nested_pipe_linter(allow_inline = FALSE)
)

lint(
  text = "tryCatch(x \%>\% filter(grp == 'a'), error = identity)",
  linters = nested_pipe_linter(allow_outer_calls = character())
)

# okay
lint(
  text = "df1 \%>\% inner_join(df2 \%>\% select(a, b))",
  linters = nested_pipe_linter()
)

code <- "df1 \%>\%\n  inner_join(df2 \%>\%\n    select(a, b)\n  )"
writeLines(code)
lint(
  text = code,
  linters = nested_pipe_linter(allow_outer_calls = "inner_join")
)

lint(
  text = "tryCatch(x \%>\% filter(grp == 'a'), error = identity)",
  linters = nested_pipe_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=consistency_linters]{consistency}, \link[=readability_linters]{readability}
}
