#compdef onedrive
#
# ZSH completion code for OneDrive Linux Client
# (c) 2019 Norbert Preining
# License: GPLv3+ (as with the rest of the OneDrive Linux client project)

local -a all_opts
all_opts=(
  '--auth-files[Perform authentication via file exchange]:auth files:'
  '--auth-response[Perform authentication via response URL]:auth response:'
  '--check-for-nomount[Check for the presence of .nosync in the syncdir root. If found, do not perform sync.]'
  '--check-for-nosync[Check for the presence of .nosync in each directory. If found, skip directory from sync.]'
  '--classify-as-big-delete[Number of children removed to trigger big delete logic]:threshold:'
  '--cleanup-local-files[Remove local files when using --download-only]'
  '--confdir[Set the directory used to store the configuration files]:config directory:_files -/'
  '--create-directory[Create a directory on OneDrive - no sync will be performed.]:directory name:'
  '--create-share-link[Create a shareable link for a file]:file name:'
  '--debug-https[Debug OneDrive HTTPS communication.]'
  '--destination-directory[Destination directory for renamed or move on OneDrive - no sync will be performed.]:directory name:'
  '--disable-download-validation[Disable download validation when downloading from OneDrive]'
  '--disable-notifications[Do not use desktop notifications in monitor mode.]'
  '--disable-upload-validation[Disable upload validation when uploading to OneDrive]'
  '--display-config[Display what options the client will use as currently configured - no sync will be performed.]'
  '--display-quota[Display the quota status of the client - no sync will be performed.]'
  '--display-running-config[Display options configured on application startup.]'
  '--display-sync-status[Display the sync status of the client - no sync will be performed.]'
  '--download-file[Download a single file from Microsoft OneDrive]:file name:'
  '--download-only[Only download remote changes]'
  '--dry-run[Perform a trial sync with no changes made]'
  '--enable-logging[Enable client activity to a separate log file]'
  '--file-fragment-size[Specify the file fragment size for large file uploads (in MB)]:MB:'
  '--force[Force the deletion of data when a '\''big delete'\'' is detected]'
  '--force-http-11[Force the use of HTTP 1.1 for all operations]'
  '--force-sync[Force a synchronization of a specific folder]'
  '--get-O365-drive-id[Query and return the Office 365 Drive ID for a given Office 365 SharePoint Shared Library]:site URL:'
  '--get-file-link[Display the file link of a synced file]:file name:'
  '--get-sharepoint-drive-id[Query and return the SharePoint Drive ID]:site URL:'
  '--help[Show this help screen]'
  '--list-shared-items[List OneDrive Business Shared Items]'
  '--local-first[Synchronize from the local directory source first, before downloading changes from OneDrive.]'
  '--log-dir[Directory where logging output is saved]:log directory:_files -/'
  '--logout[Logout the current user]'
  '--modified-by[Display the last modified-by details]:file or directory:'
  '--monitor[Keep monitoring for local and remote changes]'
  '--monitor-fullscan-frequency[Sync runs before full local scan]:N:'
  '--monitor-interval[Seconds between syncs when idle in monitor mode]:seconds:'
  '--monitor-log-frequency[Frequency of logging in monitor mode]:seconds:'
  '--no-remote-delete[Do not delete remote files when using --upload-only]'
  '--print-access-token[Print the access token, useful for debugging]'
  '--reauth[Reauthenticate the client with OneDrive]'
  '--remove-directory[Remove a directory on OneDrive - no sync will be performed.]:directory name:'
  '--remove-source-files[Remove source file after upload when using --upload-only]'
  '--remove-source-folders[Remove the local directory structure post successful file transfer when using --upload-only --remove-source-files]'
  '--resync[Forget the last saved state, perform a full sync]'
  '--resync-auth[Approve the use of performing a --resync action]'
  '--share-password[Password to protect share link]:password:'
  '--single-directory[Sync a single local directory within the OneDrive root]:source directory:_files -/'
  '--skip-dir[Skip any directories matching this pattern]:pattern:'
  '--skip-dir-strict-match[Strict matching for --skip-dir]'
  '--skip-dot-files[Skip dot files and folders from syncing]'
  '--skip-file[Skip any files matching this pattern]:pattern:'
  '--skip-size[Skip new files larger than this size (in MB)]:MB:'
  '--skip-symlinks[Skip syncing of symlinks]'
  '--source-directory[Source directory to rename or move on OneDrive]:source directory:'
  '--space-reservation[Disk space (MB) to reserve]:MB:'
  '--sync[Perform a synchronisation with Microsoft OneDrive]'
  '--sync-root-files[Sync all files in sync_dir root when using sync_list.]'
  '--sync-shared-files[Sync OneDrive Business Shared Files to the local filesystem]'
  '--syncdir[Specify the local directory used for synchronisation to OneDrive]:sync directory:_files -/'
  '--synchronize[Perform a synchronisation (deprecated)]'
  '--threads[Number of threads to use for multi-threaded transfers]:N:'
  '--upload-only[Only upload to OneDrive, do not sync changes from OneDrive locally]'
  '--verbose[Print more details, useful for debugging (repeat for extra debugging)]'
  '--version[Print the version and exit]'
  '--with-editing-perms[Create a read-write shareable link for a file]'
)

_arguments -S "$all_opts[@]" && return 0
