/* vim: set ts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file is generated from sources in nss/gtests/common/wycheproof
 * automatically and should not be touched manually.
 * Generation is trigged by calling python3 genTestVectors.py */

#ifndef p384ecdsa_sha384_vectors_h__
#define p384ecdsa_sha384_vectors_h__

#include "testvectors_base/test-structs.h"

const EcdsaTestVector kP384EcdsaSha384Vectors[] = {

    // Comment: signature malleability
    // tcID: 1
    {SEC_OID_SHA384,
     1,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x30, 0x18, 0x40, 0xda, 0x9f, 0xc1, 0xd2,
      0xf8, 0xf8, 0x90, 0x0c, 0xf4, 0x85, 0xd5, 0x41, 0x3b, 0x8c, 0x25, 0x74,
      0xee, 0x3a, 0x8d, 0x4c, 0xa0, 0x39, 0x95, 0xca, 0x30, 0x24, 0x0e, 0x09,
      0x51, 0x38, 0x05, 0xbf, 0x62, 0x09, 0xb5, 0x8a, 0xc7, 0xaa, 0x9c, 0xff,
      0x54, 0xee, 0xcd, 0x82, 0xb9, 0xf1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: Legacy:ASN encoding of s misses leading 0
    // tcID: 2
    {SEC_OID_SHA384,
     2,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x30, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d,
      0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b,
      0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d,
      0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec,
      0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: valid
    // tcID: 3
    {SEC_OID_SHA384,
     3,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: long form encoding of length of sequence
    // tcID: 4
    {SEC_OID_SHA384,
     4,
     {0x30, 0x81, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30,
      0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33,
      0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence contains leading 0
    // tcID: 5
    {SEC_OID_SHA384,
     5,
     {0x30, 0x82, 0x00, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 6
    {SEC_OID_SHA384,
     6,
     {0x30, 0x66, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of sequence
    // tcID: 7
    {SEC_OID_SHA384,
     7,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of sequence
    // tcID: 8
    {SEC_OID_SHA384,
     8,
     {0x30, 0x85, 0x01, 0x00, 0x00, 0x00, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a,
      0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04,
      0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca,
      0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0,
      0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of sequence
    // tcID: 9
    {SEC_OID_SHA384,
     9,
     {0x30, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x02,
      0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12,
      0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe,
      0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a,
      0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48,
      0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07,
      0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5,
      0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7,
      0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b,
      0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**31 - 1
    // tcID: 10
    {SEC_OID_SHA384,
     10,
     {0x30, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**32 - 1
    // tcID: 11
    {SEC_OID_SHA384,
     11,
     {0x30, 0x84, 0xff, 0xff, 0xff, 0xff, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**40 - 1
    // tcID: 12
    {SEC_OID_SHA384,
     12,
     {0x30, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x30, 0x12, 0xb3, 0x0a,
      0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04,
      0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca,
      0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0,
      0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of sequence = 2**64 - 1
    // tcID: 13
    {SEC_OID_SHA384,
     13,
     {0x30, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x30,
      0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae,
      0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19,
      0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4,
      0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7,
      0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of sequence
    // tcID: 14
    {SEC_OID_SHA384,
     14,
     {0x30, 0xff, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 15
    {SEC_OID_SHA384,
     15,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 16
    {SEC_OID_SHA384,
     16,
     {0x30, 0x65, 0x02, 0x80, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length without termination
    // tcID: 17
    {SEC_OID_SHA384,
     17,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x80, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing sequence
    // tcID: 18
    {SEC_OID_SHA384,
     18,
     {},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely sequence tag
    // tcID: 19
    {SEC_OID_SHA384,
     19,
     {0x30},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to sequence
    // tcID: 20
    {SEC_OID_SHA384,
     20,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to sequence
    // tcID: 21
    {SEC_OID_SHA384,
     21,
     {0x30, 0x67, 0x00, 0x00, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to sequence
    // tcID: 22
    {SEC_OID_SHA384,
     22,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to sequence
    // tcID: 23
    {SEC_OID_SHA384,
     23,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x05, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 24
    {SEC_OID_SHA384,
     24,
     {0x30, 0x6a, 0x49, 0x81, 0x77, 0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a,
      0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04,
      0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca,
      0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0,
      0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 25
    {SEC_OID_SHA384,
     25,
     {0x30, 0x69, 0x25, 0x00, 0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 26
    {SEC_OID_SHA384,
     26,
     {0x30, 0x67, 0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x04, 0xde,
      0xad, 0xbe, 0xef},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 27
    {SEC_OID_SHA384,
     27,
     {0x30, 0x6a, 0x22, 0x35, 0x49, 0x81, 0x77, 0x02, 0x30, 0x12, 0xb3, 0x0a,
      0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04,
      0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca,
      0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0,
      0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 28
    {SEC_OID_SHA384,
     28,
     {0x30, 0x69, 0x22, 0x34, 0x25, 0x00, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 29
    {SEC_OID_SHA384,
     29,
     {0x30, 0x6d, 0x22, 0x32, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x00, 0x04, 0xde, 0xad, 0xbe, 0xef,
      0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 30
    {SEC_OID_SHA384,
     30,
     {0x30, 0x6a, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x36, 0x49, 0x81, 0x77, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 31
    {SEC_OID_SHA384,
     31,
     {0x30, 0x69, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x35, 0x25, 0x00, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including garbage
    // tcID: 32
    {SEC_OID_SHA384,
     32,
     {0x30, 0x6d, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x33, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x04, 0xde,
      0xad, 0xbe, 0xef},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 33
    {SEC_OID_SHA384,
     33,
     {0x30, 0x6d, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x30, 0x65, 0x02, 0x30,
      0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae,
      0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19,
      0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4,
      0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7,
      0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 34
    {SEC_OID_SHA384,
     34,
     {0x30, 0x6b, 0xaa, 0x02, 0xaa, 0xbb, 0x30, 0x65, 0x02, 0x30, 0x12,
      0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae,
      0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe,
      0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e,
      0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1,
      0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25,
      0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 35
    {SEC_OID_SHA384,
     35,
     {0x30, 0x6d, 0x22, 0x38, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00, 0x02, 0x30,
      0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae,
      0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19,
      0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4,
      0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7,
      0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 36
    {SEC_OID_SHA384,
     36,
     {0x30, 0x6b, 0x22, 0x36, 0xaa, 0x02, 0xaa, 0xbb, 0x02, 0x30, 0x12,
      0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae,
      0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe,
      0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e,
      0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1,
      0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25,
      0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 37
    {SEC_OID_SHA384,
     37,
     {0x30, 0x6d, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x39, 0xaa, 0x00, 0xbb, 0x00, 0xcd, 0x00,
      0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: including undefined tags
    // tcID: 38
    {SEC_OID_SHA384,
     38,
     {0x30, 0x6b, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x37, 0xaa,
      0x02, 0xaa, 0xbb, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25,
      0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of sequence
    // tcID: 39
    {SEC_OID_SHA384,
     39,
     {0x30, 0x81},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 40
    {SEC_OID_SHA384,
     40,
     {0x30, 0x80, 0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 41
    {SEC_OID_SHA384,
     41,
     {0x30, 0x69, 0x22, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x00, 0x00, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with indefinite length
    // tcID: 42
    {SEC_OID_SHA384,
     42,
     {0x30, 0x69, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x80, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 43
    {SEC_OID_SHA384,
     43,
     {0x30, 0x80, 0x31, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 44
    {SEC_OID_SHA384,
     44,
     {0x30, 0x69, 0x22, 0x80, 0x03, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x00, 0x00, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition with wrong tag
    // tcID: 45
    {SEC_OID_SHA384,
     45,
     {0x30, 0x69, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x80, 0x03, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing sequence with NULL
    // tcID: 46
    {SEC_OID_SHA384,
     46,
     {0x05, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 47
    {SEC_OID_SHA384,
     47,
     {0x2e, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 48
    {SEC_OID_SHA384,
     48,
     {0x2f, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 49
    {SEC_OID_SHA384,
     49,
     {0x31, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 50
    {SEC_OID_SHA384,
     50,
     {0x32, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of sequence
    // tcID: 51
    {SEC_OID_SHA384,
     51,
     {0xff, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of sequence
    // tcID: 52
    {SEC_OID_SHA384,
     52,
     {0x30, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for sequence
    // tcID: 53
    {SEC_OID_SHA384,
     53,
     {0x30, 0x69, 0x30, 0x01, 0x02, 0x30, 0x64, 0x30, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 54
    {SEC_OID_SHA384,
     54,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence
    // tcID: 55
    {SEC_OID_SHA384,
     55,
     {0x30, 0x64, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6,
      0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b,
      0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba,
      0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1,
      0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d,
      0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b,
      0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d,
      0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec,
      0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length
    // tcID: 56
    {SEC_OID_SHA384,
     56,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated delimiter
    // tcID: 57
    {SEC_OID_SHA384,
     57,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with additional element
    // tcID: 58
    {SEC_OID_SHA384,
     58,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x05, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with truncated element
    // tcID: 59
    {SEC_OID_SHA384,
     59,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b,
      0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3,
      0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b,
      0xff, 0x42, 0x6f, 0x82, 0x06, 0x08, 0x11, 0x22, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with garbage
    // tcID: 60
    {SEC_OID_SHA384,
     60,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b,
      0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3,
      0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b,
      0xff, 0x42, 0x6f, 0x82, 0x00, 0x00, 0xfe, 0x02, 0xbe, 0xef},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: indefinite length with nonempty EOC
    // tcID: 61
    {SEC_OID_SHA384,
     61,
     {0x30, 0x80, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x02, 0xbe, 0xef},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepend empty sequence
    // tcID: 62
    {SEC_OID_SHA384,
     62,
     {0x30, 0x67, 0x30, 0x00, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append empty sequence
    // tcID: 63
    {SEC_OID_SHA384,
     63,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x30, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: append garbage with high tag number
    // tcID: 64
    {SEC_OID_SHA384,
     64,
     {0x30, 0x68, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0xbf, 0x7f, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: sequence of sequence
    // tcID: 65
    {SEC_OID_SHA384,
     65,
     {0x30, 0x67, 0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated sequence: removed last 1 elements
    // tcID: 66
    {SEC_OID_SHA384,
     66,
     {0x30, 0x32, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: repeating element in sequence
    // tcID: 67
    {SEC_OID_SHA384,
     67,
     {0x30, 0x81, 0x98, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30,
      0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33,
      0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 68
    {SEC_OID_SHA384,
     68,
     {0x30, 0x66, 0x02, 0x81, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30,
      0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33,
      0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: long form encoding of length of integer
    // tcID: 69
    {SEC_OID_SHA384,
     69,
     {0x30, 0x66, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x81, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 70
    {SEC_OID_SHA384,
     70,
     {0x30, 0x67, 0x02, 0x82, 0x00, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer contains leading 0
    // tcID: 71
    {SEC_OID_SHA384,
     71,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x82, 0x00, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 72
    {SEC_OID_SHA384,
     72,
     {0x30, 0x65, 0x02, 0x31, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 73
    {SEC_OID_SHA384,
     73,
     {0x30, 0x65, 0x02, 0x2f, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 74
    {SEC_OID_SHA384,
     74,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x32, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: wrong length of integer
    // tcID: 75
    {SEC_OID_SHA384,
     75,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x30, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 76
    {SEC_OID_SHA384,
     76,
     {0x30, 0x6a, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x30, 0x12, 0xb3, 0x0a,
      0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04,
      0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca,
      0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0,
      0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint32 overflow in length of integer
    // tcID: 77
    {SEC_OID_SHA384,
     77,
     {0x30, 0x6a, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x85, 0x01, 0x00, 0x00, 0x00, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 78
    {SEC_OID_SHA384,
     78,
     {0x30, 0x6e, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12,
      0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe,
      0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a,
      0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48,
      0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07,
      0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5,
      0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7,
      0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b,
      0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: uint64 overflow in length of integer
    // tcID: 79
    {SEC_OID_SHA384,
     79,
     {0x30, 0x6e, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x89, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07,
      0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5,
      0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7,
      0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b,
      0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 80
    {SEC_OID_SHA384,
     80,
     {0x30, 0x69, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**31 - 1
    // tcID: 81
    {SEC_OID_SHA384,
     81,
     {0x30, 0x69, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x84, 0x7f, 0xff, 0xff, 0xff, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 82
    {SEC_OID_SHA384,
     82,
     {0x30, 0x69, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x12, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**32 - 1
    // tcID: 83
    {SEC_OID_SHA384,
     83,
     {0x30, 0x69, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x84, 0xff, 0xff, 0xff, 0xff, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 84
    {SEC_OID_SHA384,
     84,
     {0x30, 0x6a, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12, 0xb3, 0x0a,
      0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04,
      0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca,
      0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0,
      0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**40 - 1
    // tcID: 85
    {SEC_OID_SHA384,
     85,
     {0x30, 0x6a, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x85, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
      0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a,
      0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6,
      0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8,
      0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 86
    {SEC_OID_SHA384,
     86,
     {0x30, 0x6d, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae,
      0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19,
      0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4,
      0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7,
      0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: length of integer = 2**64 - 1
    // tcID: 87
    {SEC_OID_SHA384,
     87,
     {0x30, 0x6d, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x88, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f,
      0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72,
      0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52,
      0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff,
      0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 88
    {SEC_OID_SHA384,
     88,
     {0x30, 0x65, 0x02, 0xff, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: incorrect length of integer
    // tcID: 89
    {SEC_OID_SHA384,
     89,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0xff, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: removing integer
    // tcID: 90
    {SEC_OID_SHA384,
     90,
     {0x30, 0x33, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d,
      0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 91
    {SEC_OID_SHA384,
     91,
     {0x30, 0x34, 0x02, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25,
      0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: lonely integer tag
    // tcID: 92
    {SEC_OID_SHA384,
     92,
     {0x30, 0x33, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 93
    {SEC_OID_SHA384,
     93,
     {0x30, 0x67, 0x02, 0x32, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x00, 0x00, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending 0's to integer
    // tcID: 94
    {SEC_OID_SHA384,
     94,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x33, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 95
    {SEC_OID_SHA384,
     95,
     {0x30, 0x67, 0x02, 0x32, 0x00, 0x00, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5,
      0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11,
      0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd,
      0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: prepending 0's to integer
    // tcID: 96
    {SEC_OID_SHA384,
     96,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x33, 0x00, 0x00, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending unused 0's to integer
    // tcID: 97
    {SEC_OID_SHA384,
     97,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x00, 0x00, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 98
    {SEC_OID_SHA384,
     98,
     {0x30, 0x67, 0x02, 0x32, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x05, 0x00, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25,
      0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d,
      0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf,
      0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: appending null value to integer
    // tcID: 99
    {SEC_OID_SHA384,
     99,
     {0x30, 0x67, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x33, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82, 0x05, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 100
    {SEC_OID_SHA384,
     100,
     {0x30, 0x35, 0x02, 0x81, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99,
      0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated length of integer
    // tcID: 101
    {SEC_OID_SHA384,
     101,
     {0x30, 0x34, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x81},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 102
    {SEC_OID_SHA384,
     102,
     {0x30, 0x35, 0x05, 0x00, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99,
      0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Replacing integer with NULL
    // tcID: 103
    {SEC_OID_SHA384,
     103,
     {0x30, 0x34, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x05, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 104
    {SEC_OID_SHA384,
     104,
     {0x30, 0x65, 0x00, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 105
    {SEC_OID_SHA384,
     105,
     {0x30, 0x65, 0x01, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 106
    {SEC_OID_SHA384,
     106,
     {0x30, 0x65, 0x03, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 107
    {SEC_OID_SHA384,
     107,
     {0x30, 0x65, 0x04, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 108
    {SEC_OID_SHA384,
     108,
     {0x30, 0x65, 0xff, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 109
    {SEC_OID_SHA384,
     109,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x00, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 110
    {SEC_OID_SHA384,
     110,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x01, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 111
    {SEC_OID_SHA384,
     111,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x03, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 112
    {SEC_OID_SHA384,
     112,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x04, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: changing tag value of integer
    // tcID: 113
    {SEC_OID_SHA384,
     113,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0xff, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 114
    {SEC_OID_SHA384,
     114,
     {0x30, 0x35, 0x02, 0x00, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4,
      0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99,
      0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: dropping value of integer
    // tcID: 115
    {SEC_OID_SHA384,
     115,
     {0x30, 0x34, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 116
    {SEC_OID_SHA384,
     116,
     {0x30, 0x69, 0x22, 0x34, 0x02, 0x01, 0x12, 0x02, 0x2f, 0xb3, 0x0a, 0xbe,
      0xf6, 0xb5, 0x47, 0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25,
      0x66, 0x1e, 0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28,
      0xe3, 0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: using composition for integer
    // tcID: 117
    {SEC_OID_SHA384,
     117,
     {0x30, 0x69, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x22, 0x35, 0x02, 0x01, 0x00, 0x02, 0x30, 0xe7,
      0xbf, 0x25, 0x60, 0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a,
      0xbe, 0xc4, 0x73, 0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31,
      0x99, 0x1d, 0x5d, 0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93,
      0x25, 0xdf, 0xd0, 0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 118
    {SEC_OID_SHA384,
     118,
     {0x30, 0x65, 0x02, 0x30, 0x10, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify first byte of integer
    // tcID: 119
    {SEC_OID_SHA384,
     119,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x02, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 120
    {SEC_OID_SHA384,
     120,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0x57, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: modify last byte of integer
    // tcID: 121
    {SEC_OID_SHA384,
     121,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x02},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 122
    {SEC_OID_SHA384,
     122,
     {0x30, 0x64, 0x02, 0x2f, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d,
      0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b,
      0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d,
      0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec,
      0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 123
    {SEC_OID_SHA384,
     123,
     {0x30, 0x64, 0x02, 0x2f, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f, 0xe6,
      0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4, 0x4b,
      0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83, 0xba,
      0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94, 0xf1,
      0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d,
      0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b,
      0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6, 0x2d,
      0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f, 0xec,
      0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: truncated integer
    // tcID: 124
    {SEC_OID_SHA384,
     124,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x30, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 125
    {SEC_OID_SHA384,
     125,
     {0x30, 0x66, 0x02, 0x31, 0xff, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30,
      0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33,
      0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: leading ff in integer
    // tcID: 126
    {SEC_OID_SHA384,
     126,
     {0x30, 0x66, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x32, 0xff, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 127
    {SEC_OID_SHA384,
     127,
     {0x30, 0x36, 0x09, 0x01, 0x80, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replaced integer by infinity
    // tcID: 128
    {SEC_OID_SHA384,
     128,
     {0x30, 0x35, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x09, 0x01, 0x80},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 129
    {SEC_OID_SHA384,
     129,
     {0x30, 0x36, 0x02, 0x01, 0x00, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: replacing integer with zero
    // tcID: 130
    {SEC_OID_SHA384,
     130,
     {0x30, 0x35, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e,
      0x26, 0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3,
      0x11, 0x30, 0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32,
      0x0a, 0xbd, 0x33, 0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 131
    {SEC_OID_SHA384,
     131,
     {0x30, 0x66, 0x02, 0x31, 0x01, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xa2, 0x56, 0x17, 0xaa, 0xd7, 0x48, 0x5e,
      0x63, 0x12, 0xa8, 0x58, 0x97, 0x14, 0xf6, 0x47, 0xac, 0xf7, 0xa9, 0x4c,
      0xff, 0xbe, 0x8a, 0x72, 0x4a, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 132
    {SEC_OID_SHA384,
     132,
     {0x30, 0x66, 0x02, 0x31, 0xff, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x1a, 0x13, 0x8f, 0x7c, 0xa6, 0xee, 0xda, 0x02,
      0xa4, 0x62, 0x74, 0x3d, 0x32, 0x83, 0x94, 0xf8, 0xb7, 0x1d, 0xd1, 0x1a,
      0x2a, 0x25, 0x00, 0x1f, 0x64, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 133
    {SEC_OID_SHA384,
     133,
     {0x30, 0x65, 0x02, 0x30, 0xed, 0x4c, 0xf5, 0x41, 0x09, 0x4a, 0xb8, 0x90,
      0x19, 0x49, 0xed, 0x51, 0xaa, 0x83, 0xfb, 0xda, 0x99, 0xe1, 0xd9, 0x4b,
      0xb4, 0xe4, 0x01, 0xe6, 0x25, 0x0d, 0x35, 0xd7, 0x1c, 0xee, 0xcf, 0x7c,
      0x45, 0x71, 0xb5, 0x1b, 0x33, 0xba, 0x5f, 0xcd, 0xf5, 0x42, 0xcc, 0x6b,
      0x0e, 0x3a, 0xb7, 0x29, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 134
    {SEC_OID_SHA384,
     134,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xed, 0x4c, 0xf5, 0x41, 0x09, 0x4a, 0xb8,
      0x90, 0x19, 0x49, 0xed, 0x51, 0xaa, 0x83, 0xfb, 0xda, 0x99, 0xe1, 0xd9,
      0x4b, 0xb4, 0xe4, 0x01, 0xe5, 0xec, 0x70, 0x83, 0x59, 0x11, 0x25, 0xfd,
      0x5b, 0x9d, 0x8b, 0xc2, 0xcd, 0x7c, 0x6b, 0x07, 0x48, 0xe2, 0x2e, 0xe5,
      0xd5, 0xda, 0xff, 0xe0, 0x9c, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 135
    {SEC_OID_SHA384,
     135,
     {0x30, 0x66, 0x02, 0x31, 0xfe, 0xed, 0x4c, 0xf5, 0x41, 0x09, 0x4a, 0xb8,
      0x90, 0x19, 0x49, 0xed, 0x51, 0xaa, 0x83, 0xfb, 0xda, 0x99, 0xe1, 0xd9,
      0x4b, 0xb4, 0xe4, 0x01, 0xe6, 0x5d, 0xa9, 0xe8, 0x55, 0x28, 0xb7, 0xa1,
      0x9c, 0xed, 0x57, 0xa7, 0x68, 0xeb, 0x09, 0xb8, 0x53, 0x08, 0x56, 0xb3,
      0x00, 0x41, 0x75, 0x8d, 0xb6, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 136
    {SEC_OID_SHA384,
     136,
     {0x30, 0x66, 0x02, 0x31, 0x01, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47,
      0x6f, 0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26,
      0xb4, 0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30,
      0x83, 0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33,
      0x94, 0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 137
    {SEC_OID_SHA384,
     137,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xed, 0x4c, 0xf5, 0x41, 0x09, 0x4a, 0xb8,
      0x90, 0x19, 0x49, 0xed, 0x51, 0xaa, 0x83, 0xfb, 0xda, 0x99, 0xe1, 0xd9,
      0x4b, 0xb4, 0xe4, 0x01, 0xe6, 0x25, 0x0d, 0x35, 0xd7, 0x1c, 0xee, 0xcf,
      0x7c, 0x45, 0x71, 0xb5, 0x1b, 0x33, 0xba, 0x5f, 0xcd, 0xf5, 0x42, 0xcc,
      0x6b, 0x0e, 0x3a, 0xb7, 0x29, 0x02, 0x31, 0x00, 0xe7, 0xbf, 0x25, 0x60,
      0x3e, 0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73,
      0xda, 0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d,
      0xe6, 0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0,
      0x4f, 0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 138
    {SEC_OID_SHA384,
     138,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x01, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc5, 0xf8, 0xfc, 0x6a, 0xdf, 0xda,
      0x65, 0x0a, 0x86, 0xaa, 0x74, 0xb9, 0x5a, 0xdb, 0xd6, 0x87, 0x4b, 0x3c,
      0xd8, 0xdd, 0xe6, 0xcc, 0x07, 0x98, 0xf5},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 139
    {SEC_OID_SHA384,
     139,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x30, 0xe7, 0xbf, 0x25, 0x60, 0x3e, 0x2d,
      0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda, 0x8b,
      0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x6a, 0x35, 0xcf, 0xdb, 0xf1, 0xf6,
      0xae, 0xc7, 0xfa, 0x40, 0x9d, 0xf6, 0x4a, 0x75, 0x38, 0x55, 0x63, 0x00,
      0xab, 0x11, 0x32, 0x7d, 0x46, 0x0f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 140
    {SEC_OID_SHA384,
     140,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0xff, 0x18, 0x40, 0xda, 0x9f, 0xc1,
      0xd2, 0xf8, 0xf8, 0x90, 0x0c, 0xf4, 0x85, 0xd5, 0x41, 0x3b, 0x8c, 0x25,
      0x74, 0xee, 0x3a, 0x8d, 0x4c, 0xa0, 0x39, 0xce, 0x66, 0xe2, 0xa2, 0x19,
      0xd2, 0x23, 0x58, 0xad, 0xa5, 0x54, 0x57, 0x6c, 0xda, 0x20, 0x2f, 0xb0,
      0x13, 0x3b, 0x84, 0x00, 0xbd, 0x90, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 141
    {SEC_OID_SHA384,
     141,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0xfe, 0x18, 0x40, 0xda, 0x9f, 0xc1,
      0xd2, 0xf8, 0xf8, 0x90, 0x0c, 0xf4, 0x85, 0xd5, 0x41, 0x3b, 0x8c, 0x25,
      0x74, 0xee, 0x3a, 0x8d, 0x4c, 0xa0, 0x3a, 0x07, 0x03, 0x95, 0x20, 0x25,
      0x9a, 0xf5, 0x79, 0x55, 0x8b, 0x46, 0xa5, 0x24, 0x29, 0x78, 0xb4, 0xc3,
      0x27, 0x22, 0x19, 0x33, 0xf8, 0x67, 0x0b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 142
    {SEC_OID_SHA384,
     142,
     {0x30, 0x65, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x31, 0x01, 0xe7, 0xbf, 0x25, 0x60, 0x3e,
      0x2d, 0x07, 0x07, 0x6f, 0xf3, 0x0b, 0x7a, 0x2a, 0xbe, 0xc4, 0x73, 0xda,
      0x8b, 0x11, 0xc5, 0x72, 0xb3, 0x5f, 0xc6, 0x31, 0x99, 0x1d, 0x5d, 0xe6,
      0x2d, 0xdc, 0xa7, 0x52, 0x5a, 0xab, 0xa8, 0x93, 0x25, 0xdf, 0xd0, 0x4f,
      0xec, 0xc4, 0x7b, 0xff, 0x42, 0x6f, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Modified r or s, e.g. by adding or subtracting the order of the
    // group
    // tcID: 143
    {SEC_OID_SHA384,
     143,
     {0x30, 0x64, 0x02, 0x30, 0x12, 0xb3, 0x0a, 0xbe, 0xf6, 0xb5, 0x47, 0x6f,
      0xe6, 0xb6, 0x12, 0xae, 0x55, 0x7c, 0x04, 0x25, 0x66, 0x1e, 0x26, 0xb4,
      0x4b, 0x1b, 0xfe, 0x19, 0xda, 0xf2, 0xca, 0x28, 0xe3, 0x11, 0x30, 0x83,
      0xba, 0x8e, 0x4a, 0xe4, 0xcc, 0x45, 0xa0, 0x32, 0x0a, 0xbd, 0x33, 0x94,
      0xf1, 0xc5, 0x48, 0xd7, 0x02, 0x30, 0x18, 0x40, 0xda, 0x9f, 0xc1, 0xd2,
      0xf8, 0xf8, 0x90, 0x0c, 0xf4, 0x85, 0xd5, 0x41, 0x3b, 0x8c, 0x25, 0x74,
      0xee, 0x3a, 0x8d, 0x4c, 0xa0, 0x39, 0xce, 0x66, 0xe2, 0xa2, 0x19, 0xd2,
      0x23, 0x58, 0xad, 0xa5, 0x54, 0x57, 0x6c, 0xda, 0x20, 0x2f, 0xb0, 0x13,
      0x3b, 0x84, 0x00, 0xbd, 0x90, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 144
    {SEC_OID_SHA384,
     144,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 145
    {SEC_OID_SHA384,
     145,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 146
    {SEC_OID_SHA384,
     146,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 147
    {SEC_OID_SHA384,
     147,
     {0x30, 0x36, 0x02, 0x01, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 148
    {SEC_OID_SHA384,
     148,
     {0x30, 0x36, 0x02, 0x01, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 149
    {SEC_OID_SHA384,
     149,
     {0x30, 0x36, 0x02, 0x01, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 150
    {SEC_OID_SHA384,
     150,
     {0x30, 0x36, 0x02, 0x01, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 151
    {SEC_OID_SHA384,
     151,
     {0x30, 0x36, 0x02, 0x01, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 152
    {SEC_OID_SHA384,
     152,
     {0x30, 0x08, 0x02, 0x01, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 153
    {SEC_OID_SHA384,
     153,
     {0x30, 0x06, 0x02, 0x01, 0x00, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 154
    {SEC_OID_SHA384,
     154,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 155
    {SEC_OID_SHA384,
     155,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 156
    {SEC_OID_SHA384,
     156,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 157
    {SEC_OID_SHA384,
     157,
     {0x30, 0x36, 0x02, 0x01, 0x01, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 158
    {SEC_OID_SHA384,
     158,
     {0x30, 0x36, 0x02, 0x01, 0x01, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 159
    {SEC_OID_SHA384,
     159,
     {0x30, 0x36, 0x02, 0x01, 0x01, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 160
    {SEC_OID_SHA384,
     160,
     {0x30, 0x36, 0x02, 0x01, 0x01, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 161
    {SEC_OID_SHA384,
     161,
     {0x30, 0x36, 0x02, 0x01, 0x01, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 162
    {SEC_OID_SHA384,
     162,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 163
    {SEC_OID_SHA384,
     163,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 164
    {SEC_OID_SHA384,
     164,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 165
    {SEC_OID_SHA384,
     165,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 166
    {SEC_OID_SHA384,
     166,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 167
    {SEC_OID_SHA384,
     167,
     {0x30, 0x36, 0x02, 0x01, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 168
    {SEC_OID_SHA384,
     168,
     {0x30, 0x36, 0x02, 0x01, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 169
    {SEC_OID_SHA384,
     169,
     {0x30, 0x36, 0x02, 0x01, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 170
    {SEC_OID_SHA384,
     170,
     {0x30, 0x36, 0x02, 0x01, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 171
    {SEC_OID_SHA384,
     171,
     {0x30, 0x36, 0x02, 0x01, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 172
    {SEC_OID_SHA384,
     172,
     {0x30, 0x08, 0x02, 0x01, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 173
    {SEC_OID_SHA384,
     173,
     {0x30, 0x06, 0x02, 0x01, 0xff, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 174
    {SEC_OID_SHA384,
     174,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 175
    {SEC_OID_SHA384,
     175,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 176
    {SEC_OID_SHA384,
     176,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 177
    {SEC_OID_SHA384,
     177,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 178
    {SEC_OID_SHA384,
     178,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 179
    {SEC_OID_SHA384,
     179,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 180
    {SEC_OID_SHA384,
     180,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 181
    {SEC_OID_SHA384,
     181,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 182
    {SEC_OID_SHA384,
     182,
     {0x30, 0x38, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 183
    {SEC_OID_SHA384,
     183,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x73, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 184
    {SEC_OID_SHA384,
     184,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 185
    {SEC_OID_SHA384,
     185,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 186
    {SEC_OID_SHA384,
     186,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 187
    {SEC_OID_SHA384,
     187,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 188
    {SEC_OID_SHA384,
     188,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 189
    {SEC_OID_SHA384,
     189,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 190
    {SEC_OID_SHA384,
     190,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 191
    {SEC_OID_SHA384,
     191,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 192
    {SEC_OID_SHA384,
     192,
     {0x30, 0x38, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 193
    {SEC_OID_SHA384,
     193,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 194
    {SEC_OID_SHA384,
     194,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 195
    {SEC_OID_SHA384,
     195,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 196
    {SEC_OID_SHA384,
     196,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 197
    {SEC_OID_SHA384,
     197,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 198
    {SEC_OID_SHA384,
     198,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 199
    {SEC_OID_SHA384,
     199,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 200
    {SEC_OID_SHA384,
     200,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 201
    {SEC_OID_SHA384,
     201,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 202
    {SEC_OID_SHA384,
     202,
     {0x30, 0x38, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 203
    {SEC_OID_SHA384,
     203,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x74, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 204
    {SEC_OID_SHA384,
     204,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 205
    {SEC_OID_SHA384,
     205,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 206
    {SEC_OID_SHA384,
     206,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 207
    {SEC_OID_SHA384,
     207,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 208
    {SEC_OID_SHA384,
     208,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 209
    {SEC_OID_SHA384,
     209,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 210
    {SEC_OID_SHA384,
     210,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 211
    {SEC_OID_SHA384,
     211,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 212
    {SEC_OID_SHA384,
     212,
     {0x30, 0x38, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 213
    {SEC_OID_SHA384,
     213,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xff, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 214
    {SEC_OID_SHA384,
     214,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 215
    {SEC_OID_SHA384,
     215,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 216
    {SEC_OID_SHA384,
     216,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 217
    {SEC_OID_SHA384,
     217,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 218
    {SEC_OID_SHA384,
     218,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 219
    {SEC_OID_SHA384,
     219,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x74},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 220
    {SEC_OID_SHA384,
     220,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 221
    {SEC_OID_SHA384,
     221,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 222
    {SEC_OID_SHA384,
     222,
     {0x30, 0x38, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x09, 0x03, 0x80, 0xfe, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature with special case values for r and s
    // tcID: 223
    {SEC_OID_SHA384,
     223,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x00, 0x09, 0x01, 0x42},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 224
    {SEC_OID_SHA384,
     224,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x0c, 0x01, 0x30},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 225
    {SEC_OID_SHA384,
     225,
     {0x30, 0x05, 0x02, 0x01, 0x01, 0x0c, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 226
    {SEC_OID_SHA384,
     226,
     {0x30, 0x09, 0x0c, 0x02, 0x25, 0x73, 0x0c, 0x03, 0x73, 0x25, 0x73},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 227
    {SEC_OID_SHA384,
     227,
     {0x30, 0x08, 0x02, 0x01, 0x01, 0x30, 0x03, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 228
    {SEC_OID_SHA384,
     228,
     {0x30, 0x03, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Signature encoding contains wrong types.
    // tcID: 229
    {SEC_OID_SHA384,
     229,
     {0x30, 0x06, 0x02, 0x01, 0x01, 0x01, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: Edge case for Shamir multiplication
    // tcID: 230
    {SEC_OID_SHA384,
     230,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xac, 0x04, 0x2e, 0x13, 0xab, 0x83, 0x39,
      0x46, 0x92, 0x01, 0x91, 0x70, 0x70, 0x7b, 0xc2, 0x1d, 0xd3, 0xd7, 0xb8,
      0xd2, 0x33, 0xd1, 0x1b, 0x65, 0x17, 0x57, 0x08, 0x5b, 0xdd, 0x57, 0x67,
      0xea, 0xbb, 0xb8, 0x53, 0x22, 0x98, 0x4f, 0x14, 0x43, 0x73, 0x35, 0xde,
      0x0c, 0xdf, 0x56, 0x56, 0x84, 0x02, 0x31, 0x00, 0xbd, 0x77, 0x0d, 0x3e,
      0xe4, 0xbe, 0xad, 0xba, 0xbe, 0x7c, 0xa4, 0x6e, 0x8c, 0x47, 0x02, 0x78,
      0x34, 0x35, 0x22, 0x8d, 0x46, 0xe2, 0xdd, 0x36, 0x0e, 0x32, 0x2f, 0xe6,
      0x1c, 0x86, 0x92, 0x6f, 0xa4, 0x9c, 0x81, 0x16, 0xec, 0x94, 0x0f, 0x72,
      0xac, 0x8c, 0x30, 0xd9, 0xbe, 0xb3, 0xe1, 0x2f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x33, 0x32, 0x32, 0x37},
     true},

    // Comment: special case hash
    // tcID: 231
    {SEC_OID_SHA384,
     231,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd3, 0x29, 0x8a, 0x01, 0x93, 0xc4, 0x31,
      0x6b, 0x34, 0xe3, 0x83, 0x3f, 0xf7, 0x64, 0xa8, 0x2c, 0xff, 0x4e, 0xf5,
      0x7b, 0x5d, 0xd7, 0x9e, 0xd6, 0x23, 0x7b, 0x51, 0xff, 0x76, 0xce, 0xab,
      0x13, 0xbf, 0x92, 0x13, 0x1f, 0x41, 0x03, 0x05, 0x15, 0xb7, 0xe0, 0x12,
      0xd2, 0xba, 0x85, 0x78, 0x30, 0x02, 0x31, 0x00, 0xbf, 0xc7, 0x51, 0x8d,
      0x2a, 0xd2, 0x0e, 0xd5, 0xf5, 0x8f, 0x3b, 0xe7, 0x97, 0x20, 0xf1, 0x86,
      0x6f, 0x7a, 0x23, 0xb3, 0xbd, 0x1b, 0xf9, 0x13, 0xd3, 0x91, 0x68, 0x19,
      0xd0, 0x08, 0x49, 0x7a, 0x07, 0x10, 0x46, 0x31, 0x1d, 0x3c, 0x2f, 0xd0,
      0x5f, 0xc2, 0x84, 0xc9, 0x64, 0xa3, 0x96, 0x17},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x37, 0x35, 0x30, 0x35, 0x35, 0x31, 0x38, 0x31, 0x35},
     true},

    // Comment: special case hash
    // tcID: 232
    {SEC_OID_SHA384,
     232,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xe1, 0x4f, 0x41, 0xa5, 0xfc, 0x83, 0xaa,
      0x47, 0x25, 0xa9, 0xea, 0x60, 0xab, 0x5b, 0x0b, 0x9d, 0xe2, 0x7f, 0x51,
      0x9a, 0xf4, 0xb5, 0x57, 0xa6, 0x01, 0xf1, 0xfe, 0xe0, 0x24, 0x3f, 0x8e,
      0xee, 0x51, 0x80, 0xf8, 0xc5, 0x31, 0x41, 0x4f, 0x34, 0x73, 0xf4, 0x45,
      0x74, 0x30, 0xcb, 0x7a, 0x26, 0x02, 0x30, 0x10, 0x47, 0xed, 0x2b, 0xf1,
      0xf9, 0x8e, 0x3c, 0xe9, 0x3e, 0x8f, 0xdb, 0xdc, 0x63, 0xcc, 0x79, 0xf2,
      0x38, 0x99, 0x8f, 0xee, 0x74, 0xe1, 0xbb, 0x6c, 0xd7, 0x08, 0x69, 0x49,
      0x50, 0xbb, 0xff, 0xe3, 0x94, 0x50, 0x66, 0x06, 0x4d, 0xa0, 0x43, 0xf0,
      0x4d, 0x70, 0x83, 0xd0, 0xa5, 0x96, 0xec},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x30, 0x33, 0x36, 0x33, 0x30, 0x37, 0x31},
     true},

    // Comment: special case hash
    // tcID: 233
    {SEC_OID_SHA384,
     233,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xb7, 0xc8, 0xb5, 0xcf, 0x63, 0x1a, 0x96,
      0xad, 0x90, 0x8d, 0x6a, 0x8c, 0x8d, 0x0e, 0x0a, 0x35, 0xfc, 0xc2, 0x2a,
      0x5a, 0x36, 0x05, 0x02, 0x30, 0xb6, 0x65, 0x93, 0x27, 0x64, 0xae, 0x45,
      0xbd, 0x84, 0xcb, 0x87, 0xeb, 0xba, 0x8e, 0x44, 0x4a, 0xbd, 0x89, 0xe4,
      0x48, 0x3f, 0xc9, 0xc4, 0xa8, 0x02, 0x31, 0x00, 0xa1, 0x16, 0x36, 0xc0,
      0x95, 0xaa, 0x9b, 0xc6, 0x9c, 0xf2, 0x4b, 0x50, 0xa0, 0xa9, 0xe5, 0x37,
      0x7d, 0x0f, 0xfb, 0xba, 0x4f, 0xab, 0x54, 0x33, 0x15, 0x9f, 0x00, 0x6a,
      0xb4, 0x56, 0x3d, 0x55, 0xe9, 0x18, 0x49, 0x30, 0x20, 0xa1, 0x96, 0x91,
      0x57, 0x4e, 0x4d, 0x1e, 0x66, 0xe3, 0x97, 0x5e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x33, 0x36, 0x32, 0x34, 0x32, 0x31, 0x33, 0x32, 0x31},
     true},

    // Comment: special case hash
    // tcID: 234
    {SEC_OID_SHA384,
     234,
     {0x30, 0x64, 0x02, 0x30, 0x4a, 0x7d, 0xf2, 0xdf, 0x6a, 0x32, 0xd5, 0x9b,
      0x6b, 0xfe, 0xd5, 0x4f, 0x03, 0x2c, 0x3d, 0x6f, 0x3a, 0xcd, 0x3a, 0xc4,
      0x06, 0x37, 0x04, 0x09, 0x9c, 0xd1, 0x62, 0xab, 0x39, 0x08, 0xe8, 0xee,
      0xba, 0x4e, 0x97, 0x3e, 0xe7, 0x5b, 0x5e, 0x28, 0x5d, 0xd5, 0x72, 0x06,
      0x23, 0x38, 0xfe, 0x58, 0x02, 0x30, 0x35, 0x36, 0x5b, 0xe3, 0x27, 0xe2,
      0x46, 0x3d, 0xc7, 0x59, 0x95, 0x1c, 0x5c, 0x0b, 0xe5, 0xe3, 0xd0, 0x94,
      0xcb, 0x70, 0x69, 0x12, 0xfd, 0xf7, 0xd2, 0x6b, 0x15, 0xd4, 0xa5, 0xc4,
      0x2f, 0xfe, 0xbe, 0xca, 0x5a, 0xe7, 0x3a, 0x18, 0x23, 0xf5, 0xe6, 0x5d,
      0x57, 0x1b, 0x4c, 0xcf, 0x1a, 0x82},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x35, 0x38, 0x38, 0x30, 0x31, 0x34, 0x36, 0x35, 0x36},
     true},

    // Comment: special case hash
    // tcID: 235
    {SEC_OID_SHA384,
     235,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x9a, 0xd3, 0x63, 0xa1, 0xbb, 0xc6, 0x7c,
      0x57, 0xc8, 0x2a, 0x37, 0x8e, 0x98, 0x8c, 0xc0, 0x83, 0xcc, 0x91, 0xf8,
      0xb3, 0x27, 0x39, 0xec, 0x64, 0x7c, 0x0c, 0xb3, 0x48, 0xfb, 0x5c, 0x86,
      0x47, 0x20, 0x15, 0x13, 0x1a, 0x7d, 0x90, 0x83, 0xbf, 0x47, 0x40, 0xaf,
      0x33, 0x51, 0x75, 0x51, 0x95, 0x02, 0x31, 0x00, 0xd3, 0x10, 0xdc, 0x15,
      0x09, 0xf8, 0xc0, 0x02, 0x81, 0xef, 0xe5, 0x71, 0x76, 0x8d, 0x48, 0x80,
      0x27, 0xea, 0x76, 0x0f, 0xe3, 0x29, 0x71, 0xf6, 0xcb, 0x7b, 0x57, 0xcd,
      0xf9, 0x06, 0x21, 0xb7, 0xd0, 0x08, 0x6e, 0x26, 0x44, 0x3d, 0x37, 0x61,
      0xdf, 0x7a, 0xa3, 0xa4, 0xec, 0xcc, 0x6c, 0x58},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x31, 0x34, 0x36, 0x36, 0x30, 0x35, 0x36, 0x34, 0x32},
     true},

    // Comment: special case hash
    // tcID: 236
    {SEC_OID_SHA384,
     236,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0x95, 0x07, 0x8a, 0xf5, 0xc2, 0xac, 0x23,
      0x02, 0x39, 0x55, 0x7f, 0x5f, 0xce, 0xe2, 0xe7, 0x12, 0xa7, 0x03, 0x4e,
      0x95, 0x43, 0x7a, 0x9b, 0x34, 0xc1, 0x69, 0x2a, 0x81, 0x27, 0x0e, 0xdc,
      0xf8, 0xdd, 0xd5, 0xab, 0xa1, 0x13, 0x8a, 0x42, 0x01, 0x26, 0x63, 0xe5,
      0xf8, 0x1c, 0x9b, 0xea, 0xe2, 0x02, 0x30, 0x40, 0xee, 0x51, 0x0a, 0x0c,
      0xce, 0xb8, 0x51, 0x8a, 0xd4, 0xf6, 0x18, 0x59, 0x91, 0x64, 0xda, 0x0f,
      0x3b, 0xa7, 0x5e, 0xce, 0xea, 0xc2, 0x16, 0x21, 0x6e, 0xc6, 0x2b, 0xcc,
      0xea, 0xe8, 0xdc, 0x98, 0xb5, 0xe3, 0x5b, 0x2e, 0x7e, 0xd4, 0x7c, 0x4b,
      0x8e, 0xba, 0xcf, 0xe8, 0x4a, 0x74, 0xe6},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x33, 0x33, 0x35, 0x33, 0x30, 0x30, 0x38, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 237
    {SEC_OID_SHA384,
     237,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xa5, 0x38, 0x07, 0x63, 0x62, 0x04, 0x3d,
      0xe5, 0x48, 0x64, 0x46, 0x4c, 0x14, 0xa6, 0xc1, 0xc3, 0xa4, 0x78, 0x44,
      0x37, 0x26, 0xc1, 0x30, 0x9a, 0x36, 0xb9, 0xe9, 0xea, 0x15, 0x92, 0xb4,
      0x0c, 0x3f, 0x3f, 0x90, 0xd1, 0x95, 0xbd, 0x29, 0x80, 0x04, 0xa7, 0x1e,
      0x8f, 0x28, 0x5e, 0x09, 0x3a, 0x02, 0x31, 0x00, 0xd7, 0x4f, 0x97, 0xef,
      0x38, 0x46, 0x85, 0x15, 0xa8, 0xc9, 0x27, 0xa4, 0x50, 0x27, 0x5c, 0x14,
      0xdc, 0x16, 0xdd, 0xbd, 0xd9, 0x2b, 0x3a, 0x5c, 0xae, 0x80, 0x4b, 0xe2,
      0x0d, 0x29, 0xc6, 0x82, 0x12, 0x92, 0x47, 0xd2, 0xe0, 0x1d, 0x37, 0xda,
      0xbe, 0x38, 0xff, 0xb7, 0x48, 0x08, 0xa8, 0xb7},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x36, 0x33, 0x39, 0x36, 0x36, 0x30, 0x33, 0x36, 0x33, 0x31},
     true},

    // Comment: special case hash
    // tcID: 238
    {SEC_OID_SHA384,
     238,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xbb, 0xe8, 0x35, 0x11, 0x3f, 0x8e, 0xa4,
      0xdc, 0x46, 0x9f, 0x02, 0x83, 0xaf, 0x66, 0x03, 0xf3, 0xd7, 0xa3, 0xa2,
      0x22, 0xb3, 0xab, 0x5a, 0x93, 0xdb, 0x56, 0x00, 0x7e, 0xf2, 0xdc, 0x07,
      0xc9, 0x79, 0x88, 0xfc, 0x7b, 0x8b, 0x83, 0x30, 0x57, 0xfa, 0x3f, 0xbf,
      0x97, 0x41, 0x3b, 0x6c, 0x15, 0x02, 0x30, 0x73, 0x7c, 0x31, 0x63, 0x20,
      0xb6, 0x10, 0x02, 0xc2, 0xac, 0xb1, 0x84, 0xd8, 0x2e, 0x60, 0xe4, 0x6b,
      0xd2, 0x12, 0x9a, 0x9b, 0xbf, 0x56, 0x3c, 0x80, 0xda, 0x42, 0x31, 0x21,
      0xc1, 0x61, 0xde, 0xcd, 0x36, 0x35, 0x18, 0xb2, 0x60, 0xaa, 0xac, 0xf3,
      0x73, 0x4c, 0x1e, 0xf9, 0xfa, 0xa9, 0x25},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x33, 0x33, 0x39, 0x31, 0x36, 0x36, 0x30, 0x37, 0x39, 0x35},
     true},

    // Comment: special case hash
    // tcID: 239
    {SEC_OID_SHA384,
     239,
     {0x30, 0x65, 0x02, 0x30, 0x67, 0x9c, 0x36, 0x40, 0xad, 0x8f, 0xfe, 0x95,
      0x77, 0xd9, 0xb5, 0x9b, 0x18, 0xff, 0x55, 0x98, 0xdb, 0xfe, 0x61, 0x12,
      0x2b, 0xba, 0xb8, 0x23, 0x8d, 0x26, 0x89, 0x07, 0xc9, 0x89, 0xcd, 0x94,
      0xdc, 0x7f, 0x60, 0x1d, 0x17, 0x48, 0x6a, 0xf9, 0x3f, 0x6d, 0x18, 0x62,
      0x4a, 0xa5, 0x24, 0xa3, 0x02, 0x31, 0x00, 0xe8, 0x4d, 0xd1, 0x95, 0x50,
      0x2b, 0xdc, 0xdd, 0x77, 0xb7, 0xf5, 0x1d, 0x8c, 0x1e, 0xa7, 0x89, 0x00,
      0x69, 0x05, 0x84, 0x4a, 0x0e, 0x18, 0x54, 0x74, 0xaf, 0x1a, 0x58, 0x3b,
      0xab, 0x56, 0x4e, 0xe2, 0x3b, 0xe0, 0xbc, 0x49, 0x50, 0x03, 0x90, 0xdc,
      0xeb, 0x3d, 0x39, 0x48, 0xf0, 0x67, 0x30},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x34, 0x34, 0x36, 0x39, 0x37, 0x35, 0x39, 0x36, 0x34},
     true},

    // Comment: special case hash
    // tcID: 240
    {SEC_OID_SHA384,
     240,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xf6, 0xf1, 0xaf, 0xe6, 0xfe, 0xbc, 0xe7,
      0x99, 0xcc, 0x9b, 0x75, 0x42, 0x79, 0xf2, 0x49, 0x9f, 0x38, 0x25, 0xc3,
      0xe7, 0x89, 0xac, 0xce, 0xf4, 0x6d, 0x3f, 0x06, 0x8e, 0x2b, 0x67, 0x81,
      0xfd, 0x50, 0x66, 0x9e, 0x80, 0xc3, 0xc7, 0x29, 0x3a, 0x5c, 0x0c, 0x0a,
      0xf4, 0x8e, 0x06, 0x8e, 0x35, 0x02, 0x31, 0x00, 0xf5, 0x9c, 0xc8, 0xc2,
      0x22, 0x2e, 0xd6, 0x3b, 0x45, 0x53, 0xf8, 0x14, 0x9e, 0xbe, 0xcc, 0x43,
      0xb8, 0x66, 0x71, 0x9b, 0x29, 0x4e, 0xf0, 0x83, 0x2a, 0x12, 0xb3, 0xe3,
      0xdb, 0xc8, 0x25, 0xee, 0xab, 0x68, 0xb5, 0x77, 0x96, 0x25, 0xb1, 0x0a,
      0xe5, 0x54, 0x14, 0x12, 0xec, 0x29, 0x53, 0x54},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x35, 0x31, 0x35, 0x39, 0x34, 0x37, 0x38, 0x36, 0x34, 0x31},
     true},

    // Comment: special case hash
    // tcID: 241
    {SEC_OID_SHA384,
     241,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xf4, 0x64, 0x96, 0xf6, 0xd4, 0x73, 0xf3,
      0xc0, 0x91, 0xa6, 0x8a, 0xaa, 0x37, 0x49, 0x22, 0x0c, 0x84, 0x00, 0x61,
      0xcd, 0x4f, 0x88, 0x86, 0x13, 0xcc, 0xfe, 0xac, 0x0a, 0xa0, 0x41, 0x1b,
      0x45, 0x1e, 0xdb, 0xd4, 0xfa, 0xcb, 0xe3, 0x8d, 0x2d, 0xd9, 0xd6, 0xd0,
      0xd0, 0xd2, 0x55, 0xed, 0x34, 0x02, 0x30, 0x00, 0xc3, 0xa7, 0x4f, 0xa6,
      0x66, 0x6f, 0x58, 0xc4, 0x79, 0x8f, 0x30, 0xc3, 0x77, 0x98, 0x13, 0xe5,
      0xc6, 0xd0, 0x8a, 0xc3, 0x1a, 0x79, 0x2c, 0x2d, 0x0f, 0x9c, 0xb7, 0x08,
      0x73, 0x3f, 0x26, 0xad, 0x6b, 0xf3, 0xb1, 0xe4, 0x68, 0x15, 0xae, 0x53,
      0x6a, 0xa1, 0x51, 0x68, 0x0b, 0xde, 0xe2},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x35, 0x32, 0x34, 0x31, 0x37, 0x39, 0x32, 0x33, 0x33, 0x31},
     true},

    // Comment: special case hash
    // tcID: 242
    {SEC_OID_SHA384,
     242,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xdf, 0x8b, 0x8e, 0x4c, 0xb1, 0xbc, 0x4e,
      0xc6, 0x9c, 0xb1, 0x47, 0x2f, 0xa5, 0xa8, 0x1c, 0x36, 0x64, 0x2e, 0xd4,
      0x7f, 0xc6, 0xce, 0x56, 0x00, 0x33, 0xc4, 0xf7, 0xcb, 0x0b, 0xc8, 0x45,
      0x9b, 0x57, 0x88, 0xe3, 0x4c, 0xaa, 0x7d, 0x96, 0xe6, 0x07, 0x11, 0x88,
      0xe4, 0x49, 0xf0, 0x20, 0x7a, 0x02, 0x31, 0x00, 0x8b, 0x8e, 0xe0, 0x17,
      0x79, 0x62, 0xa4, 0x89, 0x93, 0x8f, 0x3f, 0xef, 0xfa, 0xe5, 0x57, 0x29,
      0xd9, 0xd4, 0x46, 0xfe, 0x43, 0x8c, 0x7c, 0xb9, 0x1e, 0xa5, 0xf6, 0x32,
      0xc8, 0x0a, 0xa7, 0x2a, 0x43, 0xb9, 0xb0, 0x4e, 0x6d, 0xe7, 0xff, 0x34,
      0xf7, 0x6f, 0x44, 0x25, 0x10, 0x7f, 0xd6, 0x97},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x31, 0x34, 0x37, 0x32, 0x39, 0x30, 0x32, 0x30, 0x34},
     true},

    // Comment: special case hash
    // tcID: 243
    {SEC_OID_SHA384,
     243,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x8b, 0xb6, 0xa8, 0xec, 0xdc, 0x8b, 0x48,
      0x3a, 0xd7, 0xb9, 0xc9, 0x4b, 0xb3, 0x9f, 0x63, 0xb5, 0xfc, 0x13, 0x78,
      0xef, 0xe8, 0xc0, 0x20, 0x4a, 0x74, 0x63, 0x1d, 0xde, 0xd7, 0x15, 0x96,
      0x43, 0x82, 0x14, 0x19, 0xaf, 0x33, 0x86, 0x3b, 0x04, 0x14, 0xbd, 0x87,
      0xec, 0xf7, 0x3b, 0xa3, 0xfb, 0x02, 0x31, 0x00, 0x89, 0x28, 0x44, 0x9f,
      0x2d, 0x6d, 0xb2, 0xb2, 0xc6, 0x5d, 0x44, 0xd9, 0x8b, 0xeb, 0x77, 0xee,
      0xad, 0xcb, 0xda, 0x83, 0xff, 0x33, 0xe5, 0x7e, 0xb1, 0x83, 0xe1, 0xfc,
      0x29, 0xad, 0x86, 0xf0, 0xba, 0x29, 0xee, 0x66, 0xe7, 0x50, 0xe8, 0x17,
      0x0c, 0xcc, 0x43, 0x4c, 0xf7, 0x0a, 0xe1, 0x99},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x30, 0x38, 0x37, 0x38, 0x37, 0x32, 0x35, 0x36, 0x34, 0x35},
     true},

    // Comment: special case hash
    // tcID: 244
    {SEC_OID_SHA384,
     244,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xe3, 0x83, 0x28, 0x77, 0xc8, 0x0c, 0x4e,
      0xd4, 0x39, 0xd8, 0xea, 0xdc, 0xf6, 0x15, 0xc0, 0x28, 0x6f, 0xf5, 0x49,
      0x43, 0xe3, 0xae, 0x2f, 0x66, 0xa3, 0xb9, 0xf8, 0x86, 0x24, 0x5f, 0xea,
      0x47, 0x0e, 0x6d, 0x58, 0x12, 0xce, 0xf8, 0x0c, 0x23, 0xe4, 0xf5, 0x68,
      0xd0, 0x21, 0x5a, 0x3b, 0xfc, 0x02, 0x30, 0x31, 0x77, 0xa7, 0xdb, 0xf0,
      0xab, 0x8f, 0x8f, 0x5f, 0xc1, 0xd0, 0x1b, 0x19, 0xd6, 0xa5, 0xe8, 0x96,
      0x42, 0x89, 0x9f, 0x36, 0x9d, 0xfe, 0x21, 0x3b, 0x7c, 0xc5, 0x5d, 0x8e,
      0xaf, 0x21, 0xdd, 0x28, 0x85, 0xef, 0xce, 0x52, 0xb5, 0x95, 0x9c, 0x1f,
      0x06, 0xb7, 0xca, 0xc5, 0x77, 0x3e, 0x5b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x37, 0x33, 0x34, 0x33, 0x33, 0x30, 0x36, 0x35, 0x36, 0x33},
     true},

    // Comment: special case hash
    // tcID: 245
    {SEC_OID_SHA384,
     245,
     {0x30, 0x65, 0x02, 0x30, 0x62, 0x75, 0x73, 0x8f, 0x08, 0x80, 0x02, 0x32,
      0x86, 0xa9, 0xb6, 0xf2, 0x8e, 0xa0, 0xa9, 0x77, 0x9e, 0x8d, 0x64, 0x4c,
      0x3d, 0xec, 0x48, 0x29, 0x3c, 0x64, 0xf1, 0x56, 0x6b, 0x34, 0xe1, 0x5c,
      0x71, 0x19, 0xbd, 0x9d, 0x02, 0xfa, 0x23, 0x57, 0x77, 0x4c, 0xab, 0xc9,
      0xe5, 0x3e, 0xf7, 0xe6, 0x02, 0x31, 0x00, 0xd2, 0xf0, 0xa5, 0x2b, 0x10,
      0x16, 0x08, 0x2b, 0xd5, 0x51, 0x76, 0x09, 0xee, 0x81, 0xc0, 0x76, 0x4d,
      0xc3, 0x8a, 0x8f, 0x32, 0xd9, 0xa5, 0x07, 0x4e, 0x71, 0x7e, 0xe1, 0xd8,
      0x32, 0xf9, 0xea, 0x0e, 0x4c, 0x6b, 0x10, 0x0b, 0x1f, 0xd5, 0xe7, 0xf4,
      0xbc, 0x74, 0x68, 0xc7, 0x9d, 0x39, 0x33},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x39, 0x37, 0x34, 0x34, 0x36, 0x30, 0x39, 0x37, 0x38},
     true},

    // Comment: special case hash
    // tcID: 246
    {SEC_OID_SHA384,
     246,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd3, 0x16, 0xfe, 0x51, 0x68, 0xcf, 0x13,
      0x75, 0x3c, 0x8c, 0x3b, 0xbe, 0xf8, 0x38, 0x69, 0xa6, 0x70, 0x3d, 0xc0,
      0xd5, 0xaf, 0xa8, 0x2a, 0xf4, 0x9c, 0x88, 0xff, 0x35, 0x55, 0x66, 0x0f,
      0x57, 0x91, 0x9a, 0x6f, 0x36, 0xe8, 0x44, 0x51, 0xc3, 0xe8, 0xe5, 0x78,
      0x3e, 0x3b, 0x83, 0xfe, 0x3b, 0x02, 0x31, 0x00, 0x99, 0x5f, 0x08, 0xc8,
      0xfe, 0xc7, 0xcd, 0x82, 0xce, 0x27, 0xe7, 0x50, 0x93, 0x93, 0xf5, 0xa3,
      0x80, 0x3a, 0x48, 0xfe, 0x25, 0x5f, 0xcb, 0x16, 0x03, 0x21, 0xc6, 0xe1,
      0x89, 0x0e, 0xb3, 0x6e, 0x37, 0xbc, 0xda, 0x15, 0x8f, 0x0f, 0xa6, 0x89,
      0x9e, 0x7d, 0x10, 0x7e, 0x52, 0xde, 0x8c, 0x3c},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x33, 0x32, 0x32, 0x37, 0x30, 0x38, 0x36, 0x38, 0x33, 0x39},
     true},

    // Comment: special case hash
    // tcID: 247
    {SEC_OID_SHA384,
     247,
     {0x30, 0x64, 0x02, 0x30, 0x0b, 0x13, 0xb8, 0xfd, 0x10, 0xfa, 0x7b, 0x42,
      0x16, 0x91, 0x37, 0x58, 0x8a, 0xd3, 0xf5, 0x57, 0x53, 0x9a, 0x4e, 0x92,
      0x06, 0xf3, 0xa1, 0xf1, 0xfe, 0x92, 0x02, 0xb0, 0x69, 0x0d, 0xef, 0xde,
      0xd2, 0xbe, 0x18, 0x14, 0x7f, 0x5b, 0x2d, 0xa9, 0x28, 0x5c, 0x0e, 0x73,
      0x49, 0x73, 0x5e, 0xa3, 0x02, 0x30, 0x04, 0x78, 0xad, 0x31, 0x7b, 0x22,
      0xa2, 0x47, 0xbf, 0x93, 0x34, 0x71, 0x9b, 0x4c, 0x8e, 0xe8, 0x4a, 0xcf,
      0x13, 0x45, 0x15, 0xdb, 0x77, 0xe6, 0x14, 0x1c, 0x75, 0xd0, 0x89, 0x61,
      0xe1, 0xe5, 0x1e, 0xac, 0xa2, 0x98, 0x36, 0x74, 0x41, 0x03, 0xde, 0x0f,
      0x6a, 0x4c, 0x79, 0x8d, 0x3e, 0xeb},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x33, 0x32, 0x39, 0x37, 0x36, 0x34, 0x31, 0x30},
     true},

    // Comment: special case hash
    // tcID: 248
    {SEC_OID_SHA384,
     248,
     {0x30, 0x65, 0x02, 0x30, 0x15, 0x80, 0x44, 0x29, 0xbc, 0xb5, 0x27, 0x7d,
      0x4f, 0x0a, 0xf7, 0x3b, 0xd5, 0x4c, 0x8a, 0x17, 0x74, 0x99, 0xa7, 0xb6,
      0x4f, 0x18, 0xaf, 0xc5, 0x66, 0xc3, 0xce, 0x70, 0x96, 0xbd, 0xc6, 0xc2,
      0x75, 0xe3, 0x85, 0x48, 0xed, 0xcf, 0xa0, 0xb7, 0x8d, 0xd7, 0xf5, 0x7b,
      0x6f, 0x39, 0x3e, 0x49, 0x02, 0x31, 0x00, 0xd5, 0x95, 0x1f, 0x24, 0x3e,
      0x65, 0xb8, 0x2b, 0xa5, 0xc0, 0xc7, 0x55, 0x2d, 0x33, 0xb1, 0x1f, 0x1e,
      0x90, 0xfd, 0xe0, 0xc3, 0xfd, 0x01, 0x4a, 0xac, 0x1b, 0xb2, 0x7d, 0xb2,
      0xaa, 0xf0, 0x9b, 0x66, 0x7c, 0x8b, 0x24, 0x7c, 0x4c, 0xdd, 0x5b, 0x07,
      0x23, 0xfb, 0xa8, 0x3b, 0x4f, 0x99, 0x9e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x39, 0x34, 0x30, 0x34, 0x37, 0x33, 0x38, 0x31},
     true},

    // Comment: special case hash
    // tcID: 249
    {SEC_OID_SHA384,
     249,
     {0x30, 0x65, 0x02, 0x30, 0x35, 0x92, 0x47, 0xc9, 0x57, 0x76, 0xbb, 0x17,
      0x49, 0x2b, 0x7b, 0xf8, 0x27, 0xf5, 0xf3, 0x30, 0xfa, 0x9f, 0x9d, 0xe7,
      0xcc, 0x10, 0x44, 0x1a, 0x14, 0x79, 0xc8, 0x17, 0x76, 0xce, 0x36, 0xcd,
      0xc6, 0xa1, 0x3c, 0x5f, 0x51, 0x49, 0xc4, 0xe3, 0x91, 0x47, 0xa1, 0x96,
      0xbb, 0x02, 0xed, 0x34, 0x02, 0x31, 0x00, 0xf6, 0xed, 0x92, 0x52, 0xa7,
      0x3d, 0xe4, 0x85, 0x16, 0xf4, 0xea, 0xba, 0xb6, 0x36, 0x8f, 0xbf, 0xf6,
      0x87, 0x51, 0x28, 0xaf, 0x4e, 0x12, 0x26, 0xd5, 0x4d, 0xb5, 0x58, 0xbd,
      0x76, 0xee, 0xc3, 0x69, 0xcc, 0x9b, 0x28, 0x5b, 0xc1, 0x96, 0xd5, 0x12,
      0xe5, 0x31, 0xf8, 0x48, 0x64, 0xd3, 0x3f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x33, 0x32, 0x32, 0x30, 0x35, 0x36, 0x39, 0x31, 0x32, 0x33},
     true},

    // Comment: special case hash
    // tcID: 250
    {SEC_OID_SHA384,
     250,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xa5, 0x57, 0xd1, 0xf6, 0x3a, 0x20, 0x94,
      0xf6, 0x83, 0x42, 0x9e, 0xcb, 0x35, 0xa6, 0x53, 0x3b, 0xac, 0x89, 0x76,
      0x82, 0x77, 0x5c, 0x00, 0x51, 0xe1, 0x11, 0xee, 0xd6, 0xe0, 0x76, 0xc4,
      0x88, 0x67, 0xca, 0xe0, 0x05, 0xc5, 0xe0, 0x80, 0x38, 0x00, 0xb0, 0x50,
      0x31, 0x1e, 0x38, 0x1c, 0xd6, 0x02, 0x30, 0x2a, 0x2f, 0x87, 0x1e, 0xfc,
      0xf0, 0x3c, 0xf1, 0xc8, 0xf5, 0x09, 0xe0, 0x76, 0xaa, 0xa2, 0xa7, 0x6f,
      0x1e, 0xa7, 0x8d, 0x1c, 0x64, 0x80, 0x4e, 0xa5, 0xb0, 0x63, 0xb0, 0x32,
      0x4b, 0x8e, 0x98, 0xeb, 0x58, 0x25, 0xd0, 0x43, 0x70, 0x10, 0x60, 0x20,
      0xee, 0x15, 0x80, 0x5d, 0xbe, 0xdf, 0x81},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x31, 0x34, 0x30, 0x35, 0x33, 0x39, 0x39, 0x34},
     true},

    // Comment: special case hash
    // tcID: 251
    {SEC_OID_SHA384,
     251,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xf2, 0x2b, 0xf9, 0x11, 0x69, 0xb4, 0xae,
      0xc8, 0x4c, 0xa8, 0x40, 0x41, 0xcb, 0x82, 0x6f, 0x7d, 0xfc, 0x6f, 0x33,
      0xd9, 0x73, 0xf3, 0xc7, 0x24, 0x33, 0xb8, 0xa0, 0xca, 0x20, 0x3a, 0xac,
      0x93, 0xf7, 0xee, 0xd6, 0x2b, 0xe9, 0xbe, 0xa0, 0x17, 0x06, 0x40, 0x2d,
      0x5b, 0x5d, 0x3b, 0x0e, 0x65, 0x02, 0x30, 0x78, 0x41, 0xd3, 0xbc, 0x34,
      0xaa, 0x47, 0xe8, 0x13, 0xa5, 0x5c, 0x25, 0x20, 0x3c, 0x5e, 0xc2, 0x34,
      0x2d, 0x83, 0x8d, 0x5b, 0x46, 0x38, 0xc2, 0x70, 0x5d, 0xcf, 0x4b, 0xac,
      0x9c, 0x24, 0xf7, 0x65, 0xb5, 0xd4, 0xc2, 0x8f, 0xa3, 0xc7, 0xfd, 0xa7,
      0xa3, 0x8e, 0xd5, 0x04, 0x8c, 0x7d, 0xe3},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x39, 0x35, 0x31, 0x35, 0x36, 0x38, 0x36, 0x34, 0x39},
     true},

    // Comment: special case hash
    // tcID: 252
    {SEC_OID_SHA384,
     252,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x9c, 0x19, 0x6e, 0x39, 0xa2, 0xd6, 0x1a,
      0x3c, 0x25, 0x65, 0xf5, 0x93, 0x2f, 0x35, 0x7e, 0x24, 0x28, 0x92, 0x73,
      0x7e, 0x9a, 0xdf, 0xc8, 0x6c, 0x66, 0x09, 0xf2, 0x91, 0xe5, 0xe6, 0xfd,
      0xbb, 0x23, 0x02, 0x9f, 0xf9, 0x15, 0xa0, 0x32, 0xb0, 0xc5, 0x39, 0x0b,
      0xa9, 0xd1, 0x5f, 0x20, 0x3e, 0x02, 0x31, 0x00, 0xd7, 0x21, 0xe2, 0x8e,
      0x52, 0x69, 0xd7, 0x81, 0x3e, 0x8a, 0x9a, 0xed, 0x53, 0xa3, 0x7e, 0x65,
      0x2f, 0xec, 0x15, 0x60, 0xca, 0x61, 0xf2, 0x8f, 0x55, 0xab, 0x4c, 0x26,
      0x2c, 0xc6, 0x21, 0x4e, 0xee, 0x8d, 0x3c, 0x4c, 0x2b, 0xa9, 0xd1, 0xba,
      0x0b, 0xa1, 0x9e, 0x5e, 0x3c, 0x74, 0x84, 0xa7},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x35, 0x39, 0x35, 0x39, 0x30, 0x37, 0x31, 0x36, 0x33, 0x35},
     true},

    // Comment: special case hash
    // tcID: 253
    {SEC_OID_SHA384,
     253,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x8b, 0xa1, 0xe9, 0xde, 0xc1, 0x4d, 0x30,
      0x0b, 0x0e, 0x25, 0x0e, 0xa0, 0xbc, 0xd4, 0x41, 0x9c, 0x3d, 0x95, 0x59,
      0x62, 0x2c, 0xc7, 0xb8, 0x37, 0x5b, 0xd7, 0x3f, 0x7d, 0x70, 0x13, 0x32,
      0x42, 0xe3, 0xd5, 0xbf, 0x70, 0xbc, 0x78, 0x28, 0x08, 0x73, 0x46, 0x54,
      0xba, 0xcd, 0x12, 0xda, 0xea, 0x02, 0x31, 0x00, 0xd8, 0x93, 0xd3, 0x97,
      0x0f, 0x72, 0xcc, 0xab, 0x35, 0x55, 0x5a, 0xe9, 0x1e, 0xbc, 0xfe, 0xd3,
      0xc5, 0xbf, 0xc5, 0xd3, 0x91, 0x81, 0x07, 0x1b, 0xc0, 0x6b, 0xa3, 0x82,
      0x58, 0x7a, 0x69, 0x5e, 0x02, 0xed, 0x48, 0x2f, 0x1a, 0x74, 0xfe, 0x30,
      0x9a, 0x39, 0x9e, 0xae, 0xe5, 0xf5, 0xbc, 0x52},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x31, 0x35, 0x33, 0x34, 0x36, 0x39, 0x35, 0x33},
     true},

    // Comment: special case hash
    // tcID: 254
    {SEC_OID_SHA384,
     254,
     {0x30, 0x64, 0x02, 0x30, 0x2f, 0x52, 0x1d, 0x9d, 0x83, 0xe1, 0xbf, 0xf8,
      0xd2, 0x52, 0x55, 0xa9, 0xbd, 0xca, 0x90, 0xe1, 0x5d, 0x78, 0xa8, 0xc9,
      0xea, 0x78, 0x85, 0xb8, 0x84, 0x02, 0x4a, 0x40, 0xde, 0x9a, 0x31, 0x5b,
      0xed, 0x7f, 0x74, 0x6b, 0x5d, 0xa4, 0xce, 0x96, 0xb0, 0x70, 0x20, 0x8e,
      0x9a, 0xe0, 0xcf, 0xa5, 0x02, 0x30, 0x41, 0x85, 0xc6, 0xf4, 0x22, 0x5b,
      0x8c, 0x25, 0x5a, 0x4d, 0x31, 0xab, 0xb5, 0xc9, 0xb6, 0xc6, 0x86, 0xa6,
      0xee, 0x50, 0xa8, 0xeb, 0x71, 0x03, 0xaa, 0xef, 0x90, 0x24, 0x5a, 0x47,
      0x22, 0xfc, 0x89, 0x96, 0xf2, 0x66, 0xf2, 0x62, 0x10, 0x9c, 0x3b, 0x59,
      0x57, 0xba, 0x73, 0x28, 0x9a, 0x20},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x38, 0x30, 0x37, 0x31, 0x30, 0x39, 0x38, 0x33, 0x30},
     true},

    // Comment: special case hash
    // tcID: 255
    {SEC_OID_SHA384,
     255,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xd4, 0x90, 0x0f, 0x54, 0xc1, 0xbc, 0x84,
      0x1d, 0x38, 0xeb, 0x2f, 0x13, 0xe0, 0xba, 0xfb, 0xb1, 0x2b, 0x56, 0x67,
      0x39, 0x3b, 0x07, 0x10, 0x2d, 0xb9, 0x06, 0x39, 0x74, 0x4f, 0x54, 0xd7,
      0x89, 0x60, 0xb3, 0x44, 0xc8, 0xfb, 0xfb, 0xf3, 0x54, 0x0b, 0x38, 0xd0,
      0x02, 0x78, 0xe1, 0x77, 0xaa, 0x02, 0x30, 0x3a, 0x16, 0xef, 0xf0, 0x39,
      0x97, 0x00, 0x00, 0x9b, 0x69, 0x49, 0xf3, 0xf5, 0x06, 0xc5, 0x43, 0x49,
      0x5b, 0xf8, 0xe0, 0xf3, 0xa3, 0x4f, 0xeb, 0x8e, 0xdd, 0x63, 0x64, 0x87,
      0x47, 0xb5, 0x31, 0xad, 0xc4, 0xe7, 0x53, 0x98, 0xe4, 0xda, 0x80, 0x83,
      0xb8, 0x8b, 0x34, 0xc2, 0xfb, 0x97, 0xa8},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x39, 0x32, 0x39, 0x33, 0x39, 0x36, 0x39, 0x30},
     true},

    // Comment: special case hash
    // tcID: 256
    {SEC_OID_SHA384,
     256,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xc0, 0x16, 0x9e, 0x2b, 0x8b, 0x97, 0xee,
      0xb0, 0x65, 0x0e, 0x27, 0x65, 0x3f, 0x2e, 0x47, 0x3b, 0x97, 0xa0, 0x6e,
      0x1e, 0x88, 0x8b, 0x07, 0xc1, 0x01, 0x8c, 0x73, 0x0c, 0xab, 0xfd, 0xee,
      0xec, 0x4a, 0x62, 0x6c, 0x3e, 0xde, 0xe0, 0x76, 0x7d, 0x44, 0xe8, 0xed,
      0x07, 0x08, 0x0c, 0x2a, 0xc4, 0x02, 0x30, 0x13, 0xf4, 0x64, 0x75, 0xf9,
      0x55, 0xf9, 0x70, 0x19, 0x28, 0x06, 0x7e, 0x39, 0x82, 0xd4, 0xba, 0x5a,
      0x58, 0xa3, 0x79, 0xa6, 0x6f, 0x91, 0xb7, 0x4f, 0xad, 0x9a, 0xc8, 0xae,
      0xe3, 0x00, 0x86, 0xbe, 0x6f, 0x41, 0xc9, 0xc2, 0xd8, 0xfb, 0x80, 0xe0,
      0x92, 0x4d, 0xed, 0xbe, 0x67, 0xe9, 0x68},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x31, 0x31, 0x32, 0x33, 0x35, 0x35, 0x39, 0x36, 0x30},
     true},

    // Comment: special case hash
    // tcID: 257
    {SEC_OID_SHA384,
     257,
     {0x30, 0x64, 0x02, 0x30, 0x2e, 0x86, 0x88, 0x71, 0xea, 0x8b, 0x27, 0xa8,
      0xa7, 0x46, 0x88, 0x21, 0x52, 0x05, 0x1f, 0x2b, 0x14, 0x6a, 0xf4, 0xac,
      0x9d, 0x84, 0x73, 0xb4, 0xb6, 0x85, 0x2f, 0x80, 0xa1, 0xd0, 0xc7, 0xca,
      0xb5, 0x74, 0x89, 0xaa, 0x43, 0xf8, 0x90, 0x24, 0x38, 0x8a, 0xec, 0x06,
      0x05, 0xb0, 0x26, 0x37, 0x02, 0x30, 0x6d, 0x8c, 0x89, 0xee, 0xd8, 0xa5,
      0xa6, 0x25, 0x2c, 0x5c, 0xea, 0xd1, 0xc5, 0x53, 0x91, 0xc6, 0x74, 0x3d,
      0x88, 0x16, 0x09, 0xe3, 0xdb, 0x24, 0xd7, 0x0e, 0xad, 0x80, 0xa6, 0x63,
      0x57, 0x00, 0x20, 0x79, 0x8f, 0xbf, 0x41, 0xd4, 0xc6, 0x24, 0xfc, 0xb1,
      0xce, 0x36, 0xc5, 0x36, 0xfe, 0x38},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x33, 0x39, 0x32, 0x37, 0x35, 0x37, 0x30, 0x34},
     true},

    // Comment: special case hash
    // tcID: 258
    {SEC_OID_SHA384,
     258,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xab, 0xe6, 0xa5, 0x11, 0x79, 0xee, 0x87,
      0xc9, 0x57, 0x80, 0x5e, 0xca, 0xd5, 0xcc, 0xeb, 0xca, 0x30, 0xc6, 0xe3,
      0xa3, 0xe6, 0xdb, 0xe4, 0xeb, 0x4d, 0x13, 0x0b, 0x71, 0xdf, 0x2b, 0xf5,
      0x90, 0xb9, 0xd6, 0x7c, 0x8f, 0x49, 0xe8, 0x1b, 0xf9, 0x0c, 0xe0, 0x90,
      0x9d, 0x3c, 0x2d, 0xab, 0x4c, 0x02, 0x30, 0x71, 0x10, 0x58, 0x2f, 0xab,
      0x49, 0x5b, 0x21, 0xbd, 0x9d, 0xda, 0x06, 0x4f, 0xbd, 0x7a, 0xcc, 0x09,
      0xd0, 0x54, 0x4d, 0xcf, 0x76, 0x99, 0xbe, 0x35, 0xad, 0x16, 0x20, 0x7f,
      0xfa, 0x10, 0xe8, 0x90, 0x4f, 0x92, 0x41, 0xa7, 0x09, 0x48, 0x7b, 0xa2,
      0xba, 0x7e, 0x34, 0x43, 0x0b, 0x81, 0xc3},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x30, 0x38, 0x31, 0x31, 0x38, 0x38, 0x37, 0x36, 0x38},
     true},

    // Comment: special case hash
    // tcID: 259
    {SEC_OID_SHA384,
     259,
     {0x30, 0x64, 0x02, 0x30, 0x50, 0x25, 0x2c, 0x19, 0xe6, 0x0e, 0x41, 0x20,
      0xb7, 0xc2, 0x8b, 0x2c, 0x2e, 0x0a, 0x58, 0x8e, 0x5d, 0x10, 0x75, 0x18,
      0xcd, 0x61, 0xe5, 0xc7, 0x99, 0x9c, 0x6d, 0x46, 0x5e, 0xa1, 0x34, 0xf7,
      0x52, 0x32, 0x2d, 0x8b, 0x83, 0xf5, 0x98, 0x8f, 0xcd, 0xc6, 0x2b, 0xd9,
      0xad, 0xb3, 0x6c, 0xcd, 0x02, 0x30, 0x19, 0x38, 0x99, 0x35, 0x24, 0x91,
      0xda, 0xbf, 0xe4, 0xfc, 0x94, 0x2e, 0x14, 0xdd, 0xac, 0xb2, 0x00, 0x67,
      0x37, 0x29, 0xd6, 0x16, 0x02, 0xcc, 0x0b, 0xaf, 0x57, 0x32, 0xd2, 0x62,
      0xf3, 0x6e, 0x52, 0x79, 0x86, 0x5a, 0x81, 0x0c, 0xe2, 0xf9, 0x77, 0xf5,
      0x76, 0x86, 0xa0, 0xd0, 0x13, 0x7a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x35, 0x34, 0x36, 0x30, 0x38, 0x39, 0x36, 0x33},
     true},

    // Comment: special case hash
    // tcID: 260
    {SEC_OID_SHA384,
     260,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xeb, 0x72, 0x5f, 0xdd, 0x53, 0x9d, 0x7d,
      0xe8, 0xea, 0x02, 0xfa, 0xc8, 0xdb, 0x6e, 0xc4, 0x64, 0xf4, 0x0c, 0x27,
      0x2a, 0x63, 0xe6, 0xb2, 0x71, 0x8c, 0x4e, 0x02, 0x66, 0xbf, 0x12, 0x35,
      0xda, 0xe3, 0x30, 0xf7, 0x47, 0xa6, 0x05, 0x2f, 0x43, 0x19, 0xec, 0xbe,
      0x7b, 0xda, 0xde, 0x9b, 0xd0, 0x02, 0x31, 0x00, 0xae, 0x84, 0x50, 0x76,
      0x48, 0xba, 0x2d, 0x19, 0x44, 0xbb, 0x67, 0x72, 0x2c, 0xcd, 0x2c, 0xb9,
      0x4b, 0x92, 0xb5, 0x9e, 0x89, 0xa1, 0xae, 0x69, 0x8c, 0x66, 0x8b, 0xb5,
      0x7f, 0x48, 0x1c, 0x42, 0xb2, 0x16, 0xc2, 0x3d, 0xa4, 0xb1, 0xd8, 0xc0,
      0xe5, 0x02, 0xef, 0x97, 0xfd, 0xa0, 0x5a, 0xd0},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x33, 0x38, 0x37, 0x36, 0x38, 0x37, 0x31, 0x31, 0x31},
     true},

    // Comment: special case hash
    // tcID: 261
    {SEC_OID_SHA384,
     261,
     {0x30, 0x64, 0x02, 0x30, 0x25, 0xaa, 0x56, 0xfc, 0xbd, 0x92, 0xf2, 0xcf,
      0x53, 0xbd, 0xdb, 0xaa, 0x0d, 0xb5, 0x37, 0xde, 0x58, 0x43, 0x29, 0x07,
      0x31, 0xc1, 0xdd, 0x78, 0x03, 0x6f, 0xcb, 0xde, 0xd4, 0xa8, 0xf7, 0x18,
      0x7d, 0xdf, 0xed, 0x9f, 0x5c, 0xa9, 0xd9, 0x8e, 0xa7, 0xb1, 0x2d, 0x24,
      0xb8, 0xd2, 0x9d, 0x57, 0x02, 0x30, 0x02, 0x8f, 0x68, 0x37, 0x2d, 0x66,
      0x16, 0x48, 0x10, 0xbf, 0x79, 0xc3, 0x0a, 0x19, 0x11, 0x16, 0xd4, 0x96,
      0xfe, 0x32, 0x31, 0x46, 0x05, 0xdc, 0x16, 0x68, 0x28, 0x94, 0x25, 0xfb,
      0x3a, 0x15, 0xd7, 0x53, 0x2d, 0xde, 0x10, 0x52, 0xa4, 0x9a, 0x35, 0x86,
      0x6c, 0x14, 0x7a, 0xbd, 0xe1, 0xd9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x30, 0x33, 0x31, 0x33, 0x38, 0x31, 0x38, 0x37, 0x35},
     true},

    // Comment: special case hash
    // tcID: 262
    {SEC_OID_SHA384,
     262,
     {0x30, 0x65, 0x02, 0x30, 0x54, 0xbf, 0x7a, 0xdc, 0x85, 0x48, 0xe7, 0xca,
      0xe2, 0x70, 0xe7, 0xb0, 0x97, 0xf1, 0x6b, 0x5e, 0x31, 0x51, 0x58, 0xd2,
      0x1b, 0x0e, 0x65, 0x2c, 0xe1, 0xcf, 0xe4, 0xb3, 0x31, 0x26, 0xba, 0x4a,
      0x65, 0xbf, 0x22, 0x7b, 0x4c, 0xdd, 0xca, 0xf2, 0x2d, 0x33, 0xd8, 0x24,
      0x78, 0x93, 0x7b, 0x20, 0x02, 0x31, 0x00, 0xbf, 0xc1, 0xb8, 0xf1, 0xd0,
      0x28, 0x46, 0xa4, 0x2f, 0x31, 0xe1, 0xbd, 0x10, 0xba, 0x33, 0x40, 0x65,
      0x45, 0x9f, 0x71, 0x2a, 0x3b, 0xbc, 0x76, 0x00, 0x5d, 0x6c, 0x64, 0x88,
      0x88, 0x9f, 0x88, 0xc0, 0x98, 0x3f, 0x48, 0x34, 0xd0, 0xbf, 0x22, 0x49,
      0xdb, 0xf0, 0xa6, 0xdb, 0x76, 0x07, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x35, 0x35, 0x33, 0x35, 0x38, 0x33, 0x33, 0x33},
     true},

    // Comment: special case hash
    // tcID: 263
    {SEC_OID_SHA384,
     263,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd3, 0xbb, 0x29, 0xac, 0x0b, 0xd1, 0xf6,
      0x05, 0x8a, 0x51, 0x97, 0xf7, 0x66, 0xd6, 0xea, 0x32, 0x16, 0xc5, 0x72,
      0xde, 0xd6, 0x2a, 0xf4, 0x63, 0x18, 0xc8, 0xc7, 0xf9, 0x54, 0x7b, 0xb2,
      0x46, 0x55, 0x36, 0x54, 0x27, 0x9d, 0x69, 0x98, 0x9d, 0x9a, 0xf5, 0xef,
      0x4c, 0xca, 0xcf, 0x64, 0xda, 0x02, 0x31, 0x00, 0xe1, 0x02, 0x81, 0x12,
      0x2c, 0x21, 0x12, 0xa2, 0xa5, 0xa9, 0xd8, 0x7a, 0xc5, 0x8f, 0x64, 0xfb,
      0x07, 0xc9, 0x96, 0xa2, 0xd0, 0x92, 0x92, 0x11, 0x9e, 0x8f, 0x24, 0xd5,
      0x49, 0x9b, 0x2e, 0x85, 0x24, 0xeb, 0xd0, 0x57, 0x00, 0x97, 0xf6, 0xcc,
      0x7f, 0x9c, 0x26, 0x09, 0x4a, 0x35, 0xc8, 0x57},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x36, 0x31, 0x38, 0x38, 0x34, 0x31, 0x34, 0x37, 0x32},
     true},

    // Comment: special case hash
    // tcID: 264
    {SEC_OID_SHA384,
     264,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xbc, 0x32, 0xe8, 0x5e, 0x31, 0x12, 0x47,
      0x24, 0x08, 0xf9, 0x32, 0x45, 0x86, 0xe5, 0x25, 0x32, 0x51, 0x28, 0xa3,
      0x83, 0x13, 0xc3, 0x4b, 0x79, 0x70, 0x0c, 0xb0, 0xa3, 0xf7, 0x26, 0x2a,
      0x90, 0xa1, 0xfc, 0xc4, 0x0e, 0xef, 0x1f, 0x1a, 0x38, 0x84, 0x03, 0x2a,
      0x7a, 0x21, 0x81, 0x0e, 0x0a, 0x02, 0x31, 0x00, 0xc0, 0x2f, 0x52, 0x54,
      0x13, 0x60, 0x35, 0x81, 0x07, 0xa1, 0x3d, 0xbe, 0xa3, 0x1f, 0x83, 0xd8,
      0x03, 0x97, 0x71, 0x09, 0x01, 0x73, 0x4b, 0x7a, 0xdb, 0x78, 0xb1, 0xfc,
      0x90, 0x44, 0x54, 0xa2, 0x8a, 0x37, 0x85, 0x14, 0xcc, 0xef, 0x80, 0xec,
      0xc7, 0x0c, 0x1d, 0x8e, 0x55, 0xf1, 0x13, 0x11},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x30, 0x30, 0x39, 0x32, 0x34, 0x35, 0x38, 0x35, 0x34},
     true},

    // Comment: special case hash
    // tcID: 265
    {SEC_OID_SHA384,
     265,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xf0, 0x4b, 0x9e, 0x17, 0xc7, 0x1d, 0x2d,
      0x21, 0x33, 0xea, 0x38, 0x0d, 0x71, 0xb6, 0xb8, 0x2c, 0x8a, 0x8e, 0x33,
      0x32, 0x70, 0x3e, 0x9d, 0x53, 0x5b, 0x2c, 0x2b, 0xca, 0x9b, 0x0a, 0xd5,
      0x86, 0xd1, 0x76, 0xa6, 0x04, 0x9a, 0xfa, 0x35, 0xed, 0xd9, 0x72, 0x2e,
      0xdb, 0x5c, 0x33, 0xda, 0xa3, 0x02, 0x31, 0x00, 0xbd, 0x44, 0xd4, 0xa6,
      0x26, 0x33, 0x80, 0xca, 0x6f, 0x22, 0xe7, 0x6c, 0x26, 0xd5, 0xf7, 0x0f,
      0x41, 0xf4, 0xd7, 0xca, 0xe7, 0xd4, 0xb9, 0xc1, 0xb8, 0xdc, 0x2b, 0xa5,
      0x29, 0x8d, 0x9d, 0x12, 0x40, 0x8b, 0x04, 0x61, 0x4e, 0x2f, 0x37, 0x96,
      0xcc, 0x19, 0xc9, 0x50, 0xc8, 0xc8, 0x8a, 0x10},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x37, 0x35, 0x36, 0x34, 0x36, 0x36, 0x35, 0x32, 0x38},
     true},

    // Comment: special case hash
    // tcID: 266
    {SEC_OID_SHA384,
     266,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xc8, 0x80, 0x73, 0x51, 0xd8, 0xe2, 0x61,
      0x33, 0x8e, 0x75, 0x0c, 0xb9, 0xa5, 0x2f, 0x4b, 0xe4, 0x47, 0x0b, 0x63,
      0xf6, 0xf1, 0x81, 0xcb, 0xe0, 0xe8, 0x1d, 0x43, 0xb6, 0x08, 0x24, 0xba,
      0x4b, 0xe1, 0xbb, 0xa4, 0x2b, 0x17, 0x83, 0x89, 0x7a, 0x0d, 0x72, 0xb0,
      0x61, 0x40, 0x18, 0xb0, 0x2f, 0x02, 0x30, 0x52, 0xe3, 0xa5, 0x98, 0xc8,
      0xbe, 0x98, 0x21, 0x27, 0xe9, 0x61, 0xee, 0xd2, 0xb0, 0x4f, 0x21, 0xc8,
      0x6d, 0xf4, 0xeb, 0xca, 0xb0, 0xd9, 0x55, 0xa7, 0xc6, 0x6e, 0xc7, 0xf8,
      0x18, 0x89, 0x87, 0x98, 0xee, 0x75, 0x36, 0x7a, 0x85, 0x02, 0x22, 0x76,
      0xb9, 0x12, 0xc0, 0xa0, 0x72, 0xbf, 0xf7},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x31, 0x39, 0x36, 0x39, 0x37, 0x31, 0x30, 0x32},
     true},

    // Comment: special case hash
    // tcID: 267
    {SEC_OID_SHA384,
     267,
     {0x30, 0x64, 0x02, 0x30, 0x61, 0x52, 0x84, 0x1b, 0x6f, 0xb4, 0x60, 0x54,
      0x6e, 0xeb, 0x41, 0x58, 0xa3, 0xe5, 0xff, 0xa5, 0x4f, 0x51, 0xaa, 0x6a,
      0x20, 0x89, 0x87, 0xbe, 0x89, 0x9b, 0x70, 0x60, 0x55, 0xcd, 0x59, 0xd8,
      0xec, 0x7c, 0x01, 0xf4, 0x63, 0x42, 0x54, 0xfe, 0x05, 0x0e, 0x1d, 0x4e,
      0xc5, 0x25, 0xa1, 0x73, 0x02, 0x30, 0x73, 0xf0, 0xc5, 0xf1, 0x36, 0x40,
      0xd8, 0x92, 0xc2, 0x8f, 0x70, 0x14, 0x28, 0xe8, 0xfb, 0xfb, 0x73, 0x6b,
      0x64, 0x78, 0xbb, 0xd9, 0x72, 0xc8, 0xc6, 0x84, 0x97, 0x75, 0x56, 0xed,
      0x59, 0x9a, 0x70, 0xd3, 0x13, 0xe0, 0x6b, 0x12, 0x60, 0x80, 0xe1, 0x30,
      0x68, 0xd5, 0x6e, 0x1c, 0x10, 0xbe},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x33, 0x33, 0x31, 0x34, 0x32, 0x31, 0x37, 0x32},
     true},

    // Comment: special case hash
    // tcID: 268
    {SEC_OID_SHA384,
     268,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x84, 0x2f, 0x8d, 0x28, 0x14, 0xf5, 0xb7,
      0x16, 0x3f, 0x4b, 0x21, 0xbd, 0x97, 0x27, 0x24, 0x6e, 0x07, 0x8a, 0xd1,
      0xe7, 0x43, 0x5d, 0xfe, 0x1b, 0xc5, 0xf9, 0xe0, 0xe7, 0x37, 0x42, 0x32,
      0xe6, 0x86, 0xb9, 0xb9, 0x8b, 0x73, 0xde, 0xab, 0x9e, 0x43, 0xb3, 0xb7,
      0xf2, 0x54, 0x16, 0xc2, 0xbe, 0x02, 0x31, 0x00, 0x85, 0x2c, 0x10, 0x6c,
      0x41, 0x23, 0x00, 0xba, 0xc3, 0xba, 0x26, 0x59, 0x90, 0xb4, 0x28, 0xa2,
      0x60, 0x76, 0xab, 0x3f, 0x00, 0xfd, 0x76, 0x57, 0xbb, 0xd9, 0x31, 0x5f,
      0xa1, 0xcd, 0x2a, 0x12, 0x30, 0xa9, 0xa6, 0x0d, 0x06, 0xb7, 0xaf, 0x87,
      0xaa, 0x0a, 0x6c, 0xf3, 0xf4, 0x8b, 0x34, 0x4c},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x36, 0x37, 0x33, 0x34, 0x38, 0x31, 0x38, 0x39, 0x38},
     true},

    // Comment: special case hash
    // tcID: 269
    {SEC_OID_SHA384,
     269,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xe1, 0x3f, 0x6d, 0x63, 0x8b, 0x9d, 0x4f,
      0xba, 0x54, 0xaa, 0x43, 0x6a, 0x94, 0x5c, 0xfe, 0xa6, 0x6d, 0xec, 0x05,
      0x8f, 0xab, 0x6f, 0x02, 0x62, 0x93, 0x26, 0x58, 0x84, 0x45, 0x7b, 0x5a,
      0x86, 0xe8, 0xe9, 0x27, 0xd6, 0x99, 0xbc, 0x64, 0x43, 0x1b, 0x71, 0xe3,
      0xd4, 0x1d, 0xf2, 0x00, 0x44, 0x02, 0x31, 0x00, 0x98, 0x32, 0xcd, 0x1b,
      0x41, 0x77, 0x11, 0x8e, 0xd2, 0x47, 0xb4, 0xf3, 0x12, 0x77, 0xda, 0x15,
      0xf4, 0x20, 0x17, 0x9f, 0x45, 0xc7, 0x1a, 0x23, 0x7d, 0x77, 0xf5, 0x99,
      0xa4, 0x5d, 0xf6, 0x82, 0x47, 0xba, 0xc3, 0xdc, 0xef, 0x08, 0x68, 0xec,
      0xd1, 0x66, 0x50, 0x05, 0xc2, 0x5b, 0x7c, 0x6c},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x34, 0x36, 0x30, 0x31, 0x35, 0x39, 0x38, 0x32, 0x37},
     true},

    // Comment: special case hash
    // tcID: 270
    {SEC_OID_SHA384,
     270,
     {0x30, 0x64, 0x02, 0x30, 0x09, 0xff, 0xf1, 0xc2, 0xe4, 0xff, 0x86, 0x43,
      0xcb, 0xfa, 0xd5, 0x88, 0x62, 0x0c, 0x2b, 0xf7, 0xaa, 0xca, 0x5c, 0xf4,
      0x24, 0x29, 0x69, 0x14, 0x2c, 0x71, 0x45, 0xb9, 0x27, 0xbd, 0x82, 0xed,
      0x14, 0xf3, 0xae, 0x8c, 0x6e, 0x2c, 0xe2, 0xda, 0x63, 0xb9, 0x90, 0xb9,
      0xf1, 0xbe, 0x6d, 0x64, 0x02, 0x30, 0x78, 0x0c, 0x81, 0x6f, 0x6c, 0x86,
      0x34, 0x3b, 0x00, 0x82, 0x35, 0xee, 0x98, 0x6a, 0xbf, 0x21, 0x36, 0x12,
      0x3e, 0xd2, 0x47, 0xe4, 0x75, 0x1e, 0x4d, 0x54, 0x67, 0x33, 0x4f, 0x08,
      0xe5, 0xe2, 0xca, 0x11, 0x61, 0x25, 0x4f, 0x68, 0xc3, 0xe6, 0x67, 0x8e,
      0x2d, 0x0b, 0x87, 0xd1, 0xcc, 0x7c},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x38, 0x39, 0x39, 0x30, 0x38, 0x35, 0x39, 0x39, 0x32, 0x39},
     true},

    // Comment: special case hash
    // tcID: 271
    {SEC_OID_SHA384,
     271,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xae, 0x6e, 0x7d, 0x2c, 0xea, 0x71,
      0xb5, 0xa9, 0xc7, 0x3c, 0xbc, 0x12, 0x85, 0xa8, 0xd2, 0x52, 0x94, 0x97,
      0x72, 0xaf, 0xe1, 0xaa, 0x27, 0xfb, 0x13, 0x77, 0x40, 0xfc, 0x42, 0x9c,
      0x2a, 0x8c, 0x86, 0x48, 0xc9, 0xa5, 0xba, 0x67, 0x8a, 0x32, 0xf7, 0xae,
      0x76, 0x89, 0xb3, 0x95, 0xca, 0x02, 0x31, 0x00, 0x89, 0xd5, 0x4c, 0xd1,
      0x3a, 0x16, 0x2c, 0x34, 0x18, 0x9f, 0xf5, 0x24, 0x81, 0x36, 0x90, 0xe7,
      0x97, 0x68, 0xaf, 0x8e, 0xbe, 0x79, 0x4c, 0xc9, 0x41, 0xdf, 0xe7, 0xfd,
      0xf2, 0xcb, 0x8d, 0xd0, 0xb4, 0x25, 0x19, 0xf0, 0x34, 0xea, 0x4d, 0x4f,
      0x1c, 0x87, 0x00, 0x46, 0xd1, 0x32, 0x10, 0xe1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x33, 0x32, 0x36, 0x34, 0x34, 0x30, 0x39, 0x38, 0x31},
     true},

    // Comment: special case hash
    // tcID: 272
    {SEC_OID_SHA384,
     272,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xef, 0xa3, 0xc5, 0xfc, 0x3c, 0x8b, 0xe1,
      0x00, 0x74, 0x75, 0xa2, 0xdb, 0xd4, 0x6e, 0x35, 0x78, 0xbb, 0x30, 0x57,
      0x94, 0x45, 0x90, 0x9c, 0x24, 0x45, 0xf8, 0x50, 0xfb, 0x8a, 0xa6, 0x0a,
      0xa5, 0xb1, 0x74, 0x9c, 0xc3, 0x40, 0x0d, 0x8f, 0xfd, 0x81, 0xcb, 0x88,
      0x32, 0xb5, 0x0d, 0x27, 0xb4, 0x02, 0x31, 0x00, 0xb3, 0x6a, 0x08, 0xdb,
      0x38, 0x45, 0xb3, 0xd2, 0xeb, 0xd2, 0xc3, 0x35, 0x48, 0x0f, 0x12, 0xfb,
      0x83, 0xf2, 0xa7, 0x35, 0x18, 0x41, 0xea, 0x38, 0x42, 0xec, 0x62, 0xad,
      0x90, 0x4b, 0x09, 0x8e, 0xfb, 0xf9, 0xfa, 0xa7, 0x82, 0x8b, 0x9c, 0x18,
      0x57, 0x46, 0xd9, 0xc8, 0xbd, 0x04, 0x7d, 0x76},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x33, 0x37, 0x36, 0x34, 0x33, 0x37, 0x35, 0x35, 0x37},
     true},

    // Comment: special case hash
    // tcID: 273
    {SEC_OID_SHA384,
     273,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xf5, 0x77, 0x09, 0x5f, 0x7c, 0x74, 0x59,
      0x4a, 0xa1, 0xc6, 0x9a, 0xca, 0x9b, 0xb2, 0x6e, 0x0c, 0x74, 0x75, 0xae,
      0x51, 0x63, 0x05, 0x8e, 0xcc, 0x07, 0x4b, 0x03, 0xaf, 0x89, 0xe5, 0x6b,
      0x12, 0xb6, 0xa7, 0x24, 0x50, 0x58, 0x9d, 0xac, 0xf0, 0xd7, 0xe6, 0xb1,
      0x72, 0xd0, 0x01, 0x7a, 0x0e, 0x02, 0x31, 0x00, 0xbe, 0xe7, 0x56, 0xa0,
      0xb5, 0xd0, 0xa6, 0x77, 0xbf, 0x95, 0xf9, 0x8d, 0xa5, 0x12, 0x85, 0x4f,
      0x3e, 0xcb, 0x71, 0x2f, 0x94, 0x57, 0x0e, 0x1a, 0xd2, 0x30, 0xea, 0xb1,
      0x7c, 0x52, 0x7b, 0x6a, 0x8b, 0xcc, 0x9a, 0xe2, 0x02, 0xb6, 0x57, 0xa3,
      0x61, 0x1e, 0xcf, 0xfa, 0x94, 0xba, 0x0d, 0x54},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x38, 0x36, 0x30, 0x33, 0x39, 0x37, 0x37, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 274
    {SEC_OID_SHA384,
     274,
     {0x30, 0x65, 0x02, 0x30, 0x0a, 0xe7, 0x68, 0x8c, 0x7d, 0xe5, 0x88, 0x2e,
      0xb9, 0xc3, 0x17, 0x2f, 0x55, 0x00, 0x01, 0x55, 0x52, 0xf9, 0x98, 0xfb,
      0x53, 0x70, 0x2c, 0x6c, 0xd4, 0xb0, 0x34, 0x04, 0xd5, 0xa0, 0x51, 0x0a,
      0x80, 0x73, 0xdb, 0x95, 0xdb, 0x54, 0x48, 0x08, 0xdb, 0xd7, 0x66, 0x59,
      0xfd, 0x20, 0xcf, 0x12, 0x02, 0x31, 0x00, 0xbc, 0x61, 0x0f, 0xe5, 0xf0,
      0x4d, 0x89, 0x09, 0xcc, 0x43, 0x96, 0x15, 0xfb, 0x7e, 0x30, 0x2d, 0x3d,
      0x82, 0x99, 0x28, 0x17, 0x64, 0x7c, 0x50, 0xc1, 0xf4, 0x67, 0x09, 0x0a,
      0x52, 0xb3, 0x28, 0xcb, 0xbc, 0x02, 0x62, 0xf1, 0x8f, 0xfb, 0x6f, 0xd9,
      0xf3, 0xbd, 0x60, 0x01, 0x3c, 0xea, 0x08},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x35, 0x38, 0x30, 0x37, 0x37, 0x37, 0x33, 0x39, 0x38, 0x37},
     true},

    // Comment: special case hash
    // tcID: 275
    {SEC_OID_SHA384,
     275,
     {0x30, 0x65, 0x02, 0x30, 0x5d, 0xc8, 0xa6, 0xd8, 0x4a, 0xfa, 0xaf, 0x90,
      0x0d, 0x78, 0xc6, 0xa9, 0x1d, 0xc5, 0xe1, 0x2e, 0x7d, 0x17, 0x89, 0x1a,
      0x52, 0xc1, 0x46, 0x82, 0x53, 0x06, 0x1d, 0x70, 0x4b, 0x89, 0x40, 0xbe,
      0xf8, 0x5b, 0x9f, 0xe8, 0x07, 0xa0, 0xe0, 0x2b, 0x56, 0xe8, 0xdd, 0x37,
      0xc2, 0x2f, 0xbb, 0x82, 0x02, 0x31, 0x00, 0x91, 0x42, 0x58, 0xde, 0x52,
      0x93, 0x2c, 0x46, 0x04, 0xdc, 0xeb, 0x5c, 0xe7, 0xcc, 0x0a, 0x92, 0xe0,
      0x21, 0xed, 0xca, 0x9b, 0x81, 0x9b, 0x84, 0xa9, 0xf2, 0x56, 0x52, 0xf9,
      0xaf, 0x13, 0xf9, 0x56, 0xa1, 0x13, 0x9e, 0xe9, 0x5c, 0x7a, 0xa7, 0xa0,
      0x79, 0xe3, 0xad, 0x83, 0x17, 0xfb, 0xdb},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x35, 0x37, 0x31, 0x38, 0x36, 0x36, 0x38, 0x35, 0x37},
     true},

    // Comment: special case hash
    // tcID: 276
    {SEC_OID_SHA384,
     276,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xda, 0x55, 0xa6, 0xdb, 0xb8, 0x45, 0x20,
      0x5c, 0x87, 0xc9, 0x95, 0xb0, 0xbb, 0xc8, 0x44, 0x4f, 0xfc, 0xba, 0x6e,
      0xb1, 0xf4, 0xeb, 0x9d, 0x30, 0xf7, 0x21, 0xd2, 0xda, 0xcc, 0x19, 0x8f,
      0xb1, 0xa8, 0x29, 0x60, 0x75, 0xe6, 0x8e, 0xb3, 0xd2, 0x5e, 0xf5, 0x96,
      0xa9, 0x52, 0xb8, 0xea, 0x19, 0x02, 0x31, 0x00, 0x82, 0x9f, 0x67, 0x1d,
      0xcc, 0xad, 0x6d, 0x7b, 0x0b, 0x8c, 0x4b, 0x39, 0xff, 0x3f, 0x42, 0x59,
      0x79, 0x65, 0xd5, 0x5c, 0x64, 0x5f, 0xb8, 0x80, 0xa6, 0x6f, 0xe1, 0x98,
      0xd9, 0x34, 0x4c, 0x93, 0x11, 0xf1, 0x59, 0x89, 0x30, 0x39, 0x24, 0x70,
      0x37, 0x9f, 0xa5, 0xff, 0x43, 0xc7, 0x5d, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x38, 0x36, 0x37, 0x37, 0x33, 0x30, 0x39, 0x33, 0x36, 0x32},
     true},

    // Comment: special case hash
    // tcID: 277
    {SEC_OID_SHA384,
     277,
     {0x30, 0x64, 0x02, 0x30, 0x37, 0x30, 0xdf, 0xd0, 0x98, 0x5d, 0xe7, 0x7d,
      0xec, 0xdd, 0x35, 0x8a, 0x54, 0x4b, 0x47, 0xf4, 0x18, 0xd3, 0xfa, 0xb4,
      0x24, 0x81, 0x53, 0x0d, 0x5d, 0x51, 0x48, 0x59, 0x89, 0x4c, 0x6f, 0x23,
      0xb7, 0x29, 0xaf, 0x72, 0xb4, 0x46, 0x86, 0x05, 0x8d, 0xe2, 0x96, 0x87,
      0xb3, 0x4b, 0x3b, 0x0c, 0x02, 0x30, 0x65, 0xbd, 0xfa, 0xf0, 0xac, 0x21,
      0x7a, 0x80, 0xb8, 0x2e, 0xb0, 0x9c, 0x9f, 0x59, 0xc5, 0xc8, 0xcf, 0xbf,
      0x50, 0xa6, 0xeb, 0x97, 0x9a, 0x8f, 0x5f, 0x63, 0xea, 0xb9, 0xbd, 0x38,
      0xee, 0x09, 0x38, 0xe4, 0xb2, 0x31, 0x02, 0x11, 0x20, 0x33, 0xb2, 0x30,
      0xa1, 0x4a, 0xd2, 0x79, 0x0e, 0x3f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x34, 0x37, 0x35, 0x35, 0x31, 0x35, 0x30, 0x36, 0x30},
     true},

    // Comment: special case hash
    // tcID: 278
    {SEC_OID_SHA384,
     278,
     {0x30, 0x65, 0x02, 0x30, 0x55, 0x21, 0x0d, 0xf2, 0x12, 0x4c, 0x17, 0x0e,
      0x25, 0x9a, 0xf1, 0xda, 0xfa, 0x73, 0xe6, 0x66, 0x13, 0xaa, 0x18, 0xce,
      0xd8, 0xeb, 0x40, 0xa7, 0xf6, 0x61, 0x55, 0xd5, 0x0d, 0x5f, 0x31, 0x24,
      0xed, 0xfa, 0x55, 0x27, 0x6d, 0xe4, 0x79, 0x70, 0x13, 0x17, 0x72, 0x91,
      0xe8, 0xaf, 0xef, 0xf6, 0x02, 0x31, 0x00, 0xc3, 0x14, 0xd3, 0xa3, 0x10,
      0xa6, 0x06, 0x47, 0xda, 0xd3, 0x31, 0x8e, 0xd7, 0xf0, 0x40, 0x5a, 0x64,
      0xc3, 0xf9, 0x4b, 0x5a, 0xc9, 0x8e, 0x6b, 0xe1, 0x22, 0x08, 0xc8, 0xad,
      0x98, 0x35, 0xfa, 0x6b, 0x81, 0xa0, 0xea, 0x59, 0xf4, 0x76, 0x60, 0x86,
      0x34, 0x65, 0x7b, 0x66, 0xe0, 0x0f, 0xfd},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x39, 0x37, 0x33, 0x31, 0x37, 0x36, 0x38, 0x37, 0x34},
     true},

    // Comment: special case hash
    // tcID: 279
    {SEC_OID_SHA384,
     279,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xf6, 0xc9, 0x89, 0x71, 0x44, 0xb5, 0xd8,
      0x49, 0x64, 0x51, 0x5e, 0xb0, 0xc8, 0xc3, 0xd0, 0xd9, 0xc6, 0x68, 0x7c,
      0x95, 0x78, 0x87, 0xe9, 0x3c, 0x29, 0xb2, 0xa2, 0x18, 0x04, 0xb4, 0x03,
      0x07, 0xfb, 0x88, 0xbf, 0xd5, 0xcc, 0xa1, 0x1c, 0x95, 0x88, 0x5d, 0x28,
      0x86, 0x7c, 0xb3, 0x3a, 0x74, 0x02, 0x30, 0x65, 0x6b, 0xaf, 0xca, 0x24,
      0x22, 0x90, 0xf7, 0xd7, 0xe9, 0x80, 0x1b, 0x6c, 0xfd, 0x4b, 0xd1, 0xb0,
      0x7e, 0x8d, 0x7c, 0x6c, 0x1c, 0x59, 0xfd, 0x3d, 0x8e, 0x82, 0xe9, 0x84,
      0x6a, 0x1b, 0x28, 0x55, 0xc8, 0x54, 0x20, 0xe4, 0xee, 0x6e, 0xc2, 0xd9,
      0x7f, 0xec, 0x21, 0x61, 0xee, 0xb2, 0x43},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x33, 0x36, 0x39, 0x38, 0x30, 0x39, 0x35, 0x31, 0x34, 0x38},
     true},

    // Comment: special case hash
    // tcID: 280
    {SEC_OID_SHA384,
     280,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xbf, 0xbc, 0xc5, 0xf3, 0x43, 0xe2, 0xab,
      0x39, 0x2c, 0xe6, 0xc1, 0xc0, 0x2d, 0x91, 0xc0, 0x06, 0x50, 0xc4, 0x71,
      0x36, 0x83, 0x6a, 0x5d, 0x06, 0x22, 0xd4, 0x76, 0xac, 0x2b, 0x32, 0x74,
      0x39, 0x57, 0x21, 0xb1, 0xab, 0x21, 0x88, 0x2e, 0xd5, 0xca, 0xbe, 0xd0,
      0x93, 0xb4, 0x3b, 0x13, 0x3f, 0x02, 0x30, 0x04, 0x3e, 0x9f, 0xc6, 0x4c,
      0x61, 0x08, 0xdf, 0x73, 0xf9, 0xec, 0xed, 0x90, 0xf9, 0x11, 0x85, 0xf8,
      0x3d, 0x89, 0x66, 0x2f, 0x5a, 0x9d, 0x81, 0x0c, 0x18, 0x24, 0xfb, 0xfd,
      0x97, 0xb8, 0x42, 0xf7, 0x84, 0x30, 0x5f, 0xd6, 0xb9, 0xc2, 0x8c, 0x80,
      0xd3, 0x2d, 0x52, 0xb1, 0x53, 0x8d, 0x12},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x30, 0x37, 0x35, 0x30, 0x32, 0x36, 0x38, 0x35, 0x37, 0x36},
     true},

    // Comment: special case hash
    // tcID: 281
    {SEC_OID_SHA384,
     281,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xb8, 0xf7, 0x93, 0xdd, 0xd4, 0x7e, 0x65,
      0x7a, 0x90, 0x81, 0xcb, 0xed, 0x16, 0x00, 0xfb, 0x22, 0xb3, 0x8a, 0xd6,
      0xa1, 0x55, 0xf9, 0xc0, 0x06, 0xba, 0x98, 0xde, 0x1f, 0x38, 0x3b, 0x4c,
      0x09, 0x18, 0xce, 0xea, 0x72, 0x25, 0x3e, 0x0f, 0x86, 0x95, 0x24, 0xb2,
      0x36, 0x9c, 0xd9, 0xbd, 0x8c, 0x02, 0x31, 0x00, 0x96, 0xc4, 0x52, 0xff,
      0x58, 0xf4, 0x2e, 0x08, 0x53, 0x04, 0x0a, 0x6d, 0x5c, 0x7e, 0x75, 0x0b,
      0x57, 0xdd, 0x4a, 0xf0, 0x6e, 0x2d, 0xf8, 0x19, 0x4e, 0x8d, 0x52, 0x4e,
      0x81, 0xac, 0x00, 0x0e, 0xe3, 0x31, 0x5b, 0xbe, 0xab, 0xbf, 0x6a, 0x21,
      0xf6, 0x1b, 0x89, 0x04, 0xc5, 0x53, 0x78, 0xd9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x38, 0x36, 0x39, 0x31, 0x34, 0x39, 0x35, 0x35, 0x38},
     true},

    // Comment: special case hash
    // tcID: 282
    {SEC_OID_SHA384,
     282,
     {0x30, 0x64, 0x02, 0x30, 0x26, 0x3a, 0xb1, 0xc9, 0x35, 0x67, 0xe9, 0x3b,
      0x5e, 0xc4, 0xe3, 0x80, 0xb0, 0xd3, 0xbb, 0x5e, 0xa1, 0xce, 0x69, 0x3c,
      0x14, 0xa4, 0x7a, 0xfc, 0xcc, 0x53, 0x9a, 0xaf, 0x19, 0x7f, 0x09, 0x9d,
      0x33, 0x1e, 0xa9, 0xe2, 0x6f, 0x1a, 0x00, 0x57, 0x14, 0x8d, 0x46, 0x72,
      0x7a, 0xcb, 0x61, 0x88, 0x02, 0x30, 0x62, 0x1d, 0xb0, 0x7c, 0xe9, 0x41,
      0x10, 0xe2, 0xbe, 0x74, 0xfa, 0x95, 0x3a, 0x00, 0xa8, 0xa5, 0x54, 0x22,
      0x5b, 0x3f, 0x2c, 0x0f, 0x6c, 0x56, 0xb4, 0xeb, 0xd4, 0xdb, 0x2f, 0x57,
      0xca, 0x25, 0x65, 0xed, 0x33, 0x23, 0xfd, 0x70, 0x8b, 0xb5, 0x6a, 0xc6,
      0xe2, 0x8b, 0xfb, 0x40, 0xf2, 0xe7},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x31, 0x37, 0x34, 0x36, 0x35, 0x35, 0x34, 0x33, 0x35},
     true},

    // Comment: special case hash
    // tcID: 283
    {SEC_OID_SHA384,
     283,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0x96, 0xf4, 0xa2, 0xb3, 0x52, 0x9c, 0x65,
      0xe4, 0x5a, 0x0b, 0x4c, 0x19, 0xc5, 0x82, 0xdc, 0x8d, 0xb6, 0x35, 0xd4,
      0xe7, 0x4f, 0x0b, 0x81, 0x30, 0x96, 0x96, 0xb2, 0x3b, 0xe9, 0x20, 0xba,
      0x8e, 0xc5, 0x53, 0xd4, 0xb3, 0x70, 0xdf, 0x4c, 0x59, 0xd7, 0x4d, 0xd6,
      0x54, 0xba, 0xc6, 0xdf, 0x58, 0x02, 0x30, 0x15, 0x73, 0xba, 0x1b, 0x28,
      0x0c, 0x73, 0x5a, 0x34, 0x01, 0xd9, 0x57, 0xec, 0xd3, 0xb8, 0x90, 0x8e,
      0x4e, 0x0b, 0x7d, 0x80, 0x23, 0x9c, 0xe0, 0x42, 0x59, 0x4d, 0x18, 0x2f,
      0xaf, 0x2d, 0xdf, 0x81, 0x1c, 0x90, 0x56, 0xaa, 0xc4, 0xc8, 0x7f, 0x4f,
      0x85, 0x04, 0x37, 0x66, 0xa2, 0x66, 0x14},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x36, 0x34, 0x34, 0x35, 0x35, 0x30, 0x37, 0x39, 0x32},
     true},

    // Comment: special case hash
    // tcID: 284
    {SEC_OID_SHA384,
     284,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x96, 0xa6, 0x91, 0xb1, 0x9a, 0x62, 0x94,
      0xb3, 0x11, 0xa4, 0x38, 0xf8, 0xda, 0x34, 0x5e, 0x48, 0x0b, 0x1d, 0xea,
      0xa1, 0xe9, 0x40, 0xcf, 0xbf, 0x02, 0x17, 0x7d, 0x5f, 0x08, 0x47, 0x99,
      0x76, 0xea, 0x58, 0xae, 0xe3, 0x10, 0x11, 0xd5, 0x0b, 0x55, 0x42, 0xbe,
      0x18, 0x8c, 0x9d, 0x63, 0xdf, 0x02, 0x31, 0x00, 0x8f, 0x67, 0xdc, 0x9e,
      0x15, 0x88, 0xae, 0xb8, 0xbe, 0x18, 0x00, 0x13, 0xd4, 0x1a, 0x03, 0x6f,
      0x9b, 0xad, 0xfa, 0xd9, 0xfe, 0x93, 0x40, 0x91, 0x0c, 0xbf, 0x87, 0x24,
      0x37, 0x76, 0xf5, 0x4b, 0xef, 0x7d, 0xa2, 0xeb, 0xf3, 0xa7, 0x64, 0x38,
      0x66, 0xeb, 0x9a, 0x3b, 0x23, 0xfe, 0x59, 0xb9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x35, 0x33, 0x32, 0x38, 0x31, 0x38, 0x33, 0x33, 0x38},
     true},

    // Comment: special case hash
    // tcID: 285
    {SEC_OID_SHA384,
     285,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xcf, 0xf2, 0x79, 0x48, 0xc6, 0xd9, 0x02,
      0xc7, 0x3d, 0x10, 0x3d, 0x08, 0x02, 0xeb, 0x14, 0x4d, 0xd8, 0x9c, 0x1b,
      0x0e, 0x3b, 0x9f, 0x9a, 0x5e, 0x49, 0x8b, 0x03, 0x61, 0xdc, 0x12, 0x2a,
      0x0d, 0x55, 0x51, 0x60, 0xd8, 0xc6, 0x4d, 0x61, 0x53, 0x9c, 0x1d, 0xbb,
      0xd4, 0xbc, 0x18, 0x97, 0x1f, 0x02, 0x31, 0x00, 0xb6, 0x08, 0x27, 0x48,
      0x8c, 0x9f, 0x16, 0xba, 0x28, 0x37, 0x8f, 0xd5, 0x9b, 0x1a, 0x29, 0xc6,
      0x50, 0x73, 0x33, 0x5a, 0x7f, 0x23, 0x61, 0x31, 0x13, 0x46, 0x74, 0xc6,
      0x2c, 0x83, 0x96, 0xf1, 0x93, 0xc7, 0x6f, 0x23, 0x95, 0xdd, 0xaa, 0xa4,
      0xf2, 0x4b, 0x69, 0x16, 0x1e, 0xb6, 0x9b, 0x4d},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x31, 0x39, 0x32, 0x30, 0x37, 0x36, 0x33, 0x38, 0x32},
     true},

    // Comment: special case hash
    // tcID: 286
    {SEC_OID_SHA384,
     286,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xe9, 0x0e, 0x22, 0xd9, 0xe5, 0x35, 0xdf,
      0xdf, 0xd8, 0x6e, 0x09, 0x8d, 0x5d, 0x6a, 0x0a, 0xe0, 0x8f, 0x69, 0xd4,
      0xa3, 0xff, 0xaa, 0x39, 0xf6, 0x93, 0x0b, 0xcf, 0x5f, 0x5a, 0xd0, 0x2e,
      0xe0, 0xd0, 0x47, 0x2a, 0xe9, 0x84, 0xed, 0xd9, 0xf0, 0xbb, 0xe5, 0xe7,
      0xd6, 0x3f, 0xd4, 0xf6, 0xac, 0x02, 0x31, 0x00, 0xe3, 0xf5, 0x7b, 0x0a,
      0x46, 0x29, 0xec, 0xaa, 0x21, 0xf2, 0xd3, 0x4a, 0x7a, 0x08, 0x34, 0xd5,
      0x7b, 0xa2, 0x0f, 0x99, 0xc6, 0xe3, 0x1b, 0x43, 0xc3, 0x78, 0x11, 0xcc,
      0x23, 0xb9, 0x95, 0x7c, 0x8f, 0x33, 0x56, 0xf4, 0x46, 0x22, 0x14, 0xd3,
      0xc8, 0xe5, 0x87, 0x45, 0xe5, 0x0f, 0x23, 0xf6},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x35, 0x33, 0x32, 0x38, 0x34, 0x32, 0x32, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 287
    {SEC_OID_SHA384,
     287,
     {0x30, 0x64, 0x02, 0x30, 0x18, 0xb7, 0x0e, 0x27, 0x2a, 0x98, 0xcc, 0x48,
      0xe1, 0xe0, 0xaf, 0x73, 0x14, 0x6f, 0x0f, 0x97, 0x2b, 0xbf, 0xbe, 0xb6,
      0xb9, 0x85, 0xfe, 0xb2, 0xc4, 0xac, 0xd6, 0x95, 0xa7, 0xa4, 0x1b, 0x99,
      0xc4, 0x15, 0xbe, 0x9c, 0x46, 0xae, 0xda, 0xf3, 0xdd, 0xff, 0x67, 0xa6,
      0x5a, 0x89, 0xe3, 0x87, 0x02, 0x30, 0x47, 0xd6, 0xbc, 0xea, 0x08, 0x8f,
      0x62, 0x2a, 0xd3, 0x5d, 0x88, 0xbc, 0xf4, 0x6d, 0x71, 0x82, 0x7b, 0xcb,
      0xa2, 0xf5, 0x7c, 0x36, 0xd6, 0xfb, 0x8a, 0x4b, 0xf2, 0xbe, 0xfd, 0xc0,
      0xd4, 0xe3, 0xef, 0x36, 0x6d, 0x59, 0x66, 0xc4, 0xd0, 0x76, 0xd3, 0xcf,
      0xa4, 0x3d, 0x66, 0x26, 0x71, 0x7b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x35, 0x36, 0x37, 0x31, 0x37, 0x37, 0x33, 0x39},
     true},

    // Comment: special case hash
    // tcID: 288
    {SEC_OID_SHA384,
     288,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xac, 0xfd, 0x98, 0x1c, 0x55, 0xfd, 0x52,
      0x86, 0xcf, 0xce, 0x17, 0x37, 0x26, 0xd5, 0x1c, 0x3d, 0x25, 0xf6, 0x5b,
      0x11, 0xb7, 0x67, 0x37, 0x29, 0xa6, 0x21, 0x67, 0x25, 0x67, 0x74, 0xf7,
      0xc8, 0x94, 0xb7, 0x46, 0x62, 0xa2, 0x12, 0xc7, 0x06, 0xe0, 0x0c, 0xef,
      0x09, 0x60, 0x74, 0x16, 0x2f, 0x02, 0x31, 0x00, 0xf4, 0xd4, 0x71, 0xc9,
      0x77, 0x97, 0xc2, 0x4d, 0x96, 0xae, 0xc1, 0xde, 0x85, 0xa2, 0x49, 0xef,
      0x46, 0x8d, 0x60, 0x36, 0xcd, 0x71, 0x25, 0x63, 0xae, 0xb6, 0x5c, 0xea,
      0x49, 0x95, 0xf3, 0xee, 0x85, 0xe7, 0x69, 0xb8, 0x74, 0xf0, 0x9a, 0x08,
      0x63, 0x7a, 0x44, 0xa9, 0x60, 0x84, 0xbe, 0x7a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x33, 0x30, 0x33, 0x30, 0x39, 0x31, 0x31, 0x32, 0x30},
     true},

    // Comment: special case hash
    // tcID: 289
    {SEC_OID_SHA384,
     289,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xf1, 0x5f, 0xcb, 0xee, 0xa8, 0xb6, 0x4d,
      0xad, 0x5e, 0x85, 0x66, 0xa2, 0xc3, 0x79, 0x13, 0xc8, 0x2d, 0x6b, 0xe9,
      0xd9, 0x66, 0x8d, 0xf4, 0x69, 0xbd, 0x0b, 0x59, 0x1c, 0x39, 0x23, 0xa6,
      0xe1, 0x26, 0x44, 0xea, 0xf6, 0x97, 0xd4, 0x66, 0xfa, 0x7c, 0xd5, 0x13,
      0x98, 0x3d, 0x94, 0x6a, 0x40, 0x02, 0x30, 0x70, 0x06, 0x39, 0x66, 0x80,
      0x10, 0x79, 0x35, 0x15, 0x26, 0x99, 0x9e, 0x5c, 0x5c, 0x2c, 0x5f, 0x62,
      0x7e, 0x4c, 0x8b, 0xc9, 0x67, 0x84, 0xbc, 0xbe, 0x71, 0x5f, 0xe7, 0xc7,
      0xaf, 0xcf, 0x69, 0x78, 0x5d, 0x1c, 0x8c, 0x7c, 0xcd, 0x37, 0x25, 0xe3,
      0x64, 0x10, 0x16, 0x38, 0x39, 0x65, 0x97},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x37, 0x37, 0x33, 0x35, 0x39, 0x31, 0x35, 0x35, 0x38, 0x31},
     true},

    // Comment: special case hash
    // tcID: 290
    {SEC_OID_SHA384,
     290,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd9, 0x95, 0x14, 0x79, 0x39, 0xae, 0x6d,
      0x8f, 0x62, 0xbb, 0x57, 0x37, 0x22, 0x27, 0x39, 0x58, 0x39, 0xe2, 0x5a,
      0x0d, 0x43, 0x08, 0xb8, 0x99, 0xd5, 0xf5, 0x06, 0xcf, 0x9e, 0x0a, 0x01,
      0xe8, 0x11, 0x5b, 0x7e, 0x4b, 0x82, 0x2f, 0x03, 0x7e, 0xc9, 0x57, 0x52,
      0xbd, 0x9e, 0x89, 0x2f, 0x5e, 0x02, 0x31, 0x00, 0x9b, 0xb4, 0xd0, 0x73,
      0x33, 0xe4, 0x68, 0xf8, 0x48, 0x2a, 0x79, 0x0a, 0x2a, 0x2e, 0x65, 0x0e,
      0x2c, 0x42, 0xda, 0x82, 0x40, 0xec, 0x5e, 0x40, 0x25, 0x06, 0xb3, 0x68,
      0x12, 0x2f, 0x04, 0x66, 0x80, 0xcd, 0x71, 0xe0, 0x11, 0x78, 0x97, 0xcc,
      0xe3, 0xdf, 0x4a, 0x15, 0x55, 0xfc, 0x88, 0x76},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x34, 0x33, 0x39, 0x36, 0x36, 0x37, 0x34, 0x30},
     true},

    // Comment: special case hash
    // tcID: 291
    {SEC_OID_SHA384,
     291,
     {0x30, 0x64, 0x02, 0x30, 0x43, 0xc6, 0xce, 0x51, 0x84, 0x47, 0x6f, 0x3f,
      0x49, 0x6a, 0xfe, 0xae, 0x3c, 0xb9, 0x6a, 0x3f, 0x9f, 0x03, 0x89, 0x57,
      0x68, 0x6c, 0x93, 0x43, 0x7b, 0x82, 0x66, 0xa2, 0x33, 0x02, 0x23, 0x71,
      0xd2, 0x66, 0xe9, 0x04, 0xaa, 0x09, 0x6c, 0x35, 0x66, 0xcb, 0x33, 0x82,
      0x4b, 0x88, 0x07, 0x5e, 0x02, 0x30, 0x68, 0x0c, 0x13, 0x24, 0x5a, 0x8b,
      0xc5, 0x60, 0xb6, 0x38, 0xd2, 0x6f, 0x0c, 0x5f, 0x26, 0x19, 0x64, 0x13,
      0x02, 0x56, 0x93, 0x95, 0x52, 0xd3, 0xff, 0xfb, 0x07, 0xb6, 0x58, 0x35,
      0x56, 0x11, 0x61, 0x2c, 0x26, 0x8a, 0x89, 0x54, 0x10, 0x55, 0xd3, 0xc2,
      0xbf, 0x9e, 0x82, 0xcf, 0x4d, 0xa3},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x33, 0x32, 0x37, 0x36, 0x30, 0x32, 0x38, 0x32, 0x33},
     true},

    // Comment: special case hash
    // tcID: 292
    {SEC_OID_SHA384,
     292,
     {0x30, 0x63, 0x02, 0x30, 0x44, 0x75, 0x39, 0x94, 0x1d, 0xc3, 0x50, 0x76,
      0x7f, 0xc8, 0x41, 0x08, 0x3d, 0x25, 0xd9, 0x24, 0x7a, 0x08, 0x07, 0xe1,
      0xe2, 0x2e, 0x0b, 0xb9, 0xd9, 0x4f, 0x50, 0x4f, 0x72, 0x19, 0x81, 0xb4,
      0x13, 0xd5, 0x21, 0xef, 0xbd, 0x75, 0xe4, 0xfe, 0x83, 0x1e, 0xe2, 0x63,
      0x38, 0xcf, 0x3d, 0xe3, 0x02, 0x2f, 0x39, 0x5a, 0xb2, 0x7e, 0xa7, 0x82,
      0xce, 0xe4, 0xbe, 0x53, 0xe0, 0x6c, 0x76, 0x16, 0xbb, 0xd4, 0x1d, 0x69,
      0x26, 0xb1, 0x8d, 0x21, 0x9d, 0x75, 0xd5, 0x97, 0x9f, 0x13, 0xcb, 0xa2,
      0xf5, 0x21, 0x01, 0x01, 0x9b, 0x0e, 0xc0, 0xa4, 0x1f, 0xfd, 0xbf, 0x29,
      0xef, 0x73, 0xdd, 0xba, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x39, 0x33, 0x32, 0x30, 0x30, 0x32, 0x35, 0x39, 0x32},
     true},

    // Comment: special case hash
    // tcID: 293
    {SEC_OID_SHA384,
     293,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xa0, 0xba, 0x8e, 0x8b, 0x97, 0x9c, 0x20,
      0x34, 0x5e, 0x34, 0xfc, 0xa9, 0x85, 0x31, 0x90, 0x01, 0x64, 0xa8, 0x59,
      0x92, 0x3b, 0xd6, 0x98, 0x6a, 0x9c, 0x39, 0x23, 0x6a, 0x2f, 0x5d, 0xe0,
      0x53, 0xa2, 0x52, 0x99, 0x7f, 0x35, 0xe5, 0xb8, 0x4b, 0x0d, 0x48, 0xba,
      0x0f, 0x8d, 0x09, 0xae, 0xdd, 0x02, 0x31, 0x00, 0xfa, 0xcd, 0x6d, 0xf0,
      0x43, 0x58, 0xfc, 0xd9, 0x5f, 0xa9, 0x01, 0x8a, 0x6f, 0xc0, 0x82, 0x8d,
      0xfe, 0x31, 0x98, 0x12, 0xff, 0x65, 0x92, 0x9c, 0x06, 0x0b, 0x18, 0xad,
      0x4b, 0x9f, 0x06, 0xe7, 0xfc, 0x0a, 0xdd, 0xd1, 0xb6, 0x95, 0x31, 0x5d,
      0x71, 0xc1, 0x5e, 0x51, 0xdc, 0x51, 0xd7, 0x19},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x36, 0x34, 0x30, 0x39, 0x38, 0x37, 0x37, 0x32, 0x38, 0x34},
     true},

    // Comment: special case hash
    // tcID: 294
    {SEC_OID_SHA384,
     294,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xb8, 0x37, 0x83, 0x90, 0xf7, 0x1f, 0x0b,
      0xb6, 0x66, 0x3f, 0x18, 0x46, 0xda, 0xf6, 0x90, 0x8f, 0x8c, 0x84, 0xf7,
      0x70, 0xae, 0x74, 0x0c, 0xc8, 0x05, 0x41, 0x22, 0x49, 0x4c, 0xf0, 0xff,
      0xa9, 0x43, 0x7a, 0xb2, 0x60, 0x40, 0xca, 0x22, 0x80, 0x8f, 0xb2, 0x9a,
      0x81, 0x0b, 0x70, 0x12, 0x6e, 0x02, 0x30, 0x42, 0x76, 0x36, 0xb9, 0x29,
      0xa5, 0x00, 0xab, 0xc3, 0x4d, 0x9f, 0x22, 0x97, 0x7b, 0x81, 0xe7, 0x34,
      0x91, 0x9a, 0xfa, 0xf3, 0xed, 0x2c, 0x91, 0xee, 0xad, 0xa7, 0x07, 0x4e,
      0x0c, 0x16, 0xbd, 0xc5, 0x2f, 0x96, 0x0e, 0xae, 0xc9, 0xdb, 0x5a, 0x87,
      0x9c, 0x1e, 0x64, 0x14, 0x03, 0x51, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x36, 0x30, 0x37, 0x35, 0x36, 0x39, 0x30, 0x34, 0x31, 0x32},
     true},

    // Comment: special case hash
    // tcID: 295
    {SEC_OID_SHA384,
     295,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xf3, 0x6a, 0x90, 0x48, 0xfd, 0x94, 0x80,
      0x3d, 0x3d, 0x6d, 0x1b, 0x11, 0x43, 0x0b, 0x90, 0xb9, 0x4e, 0xf8, 0xd5,
      0xd2, 0xad, 0x89, 0x01, 0x8c, 0x69, 0x47, 0x3c, 0xe9, 0xcf, 0xe0, 0xd6,
      0x10, 0x5b, 0x3c, 0x2f, 0xb2, 0xe7, 0x55, 0x5c, 0xcd, 0x25, 0xf6, 0x5a,
      0xf8, 0xc8, 0x72, 0xbd, 0xc6, 0x02, 0x31, 0x00, 0x81, 0x25, 0x48, 0x41,
      0xe7, 0xec, 0xbf, 0xd0, 0xd8, 0x10, 0xaf, 0xaa, 0xf5, 0xaf, 0xd6, 0xd6,
      0xc5, 0xd0, 0x54, 0x2b, 0xb0, 0x0c, 0xc1, 0x83, 0xb1, 0xdb, 0x01, 0x76,
      0x71, 0x20, 0xaf, 0xbc, 0xc0, 0x00, 0x6d, 0xdc, 0xba, 0x8d, 0xb7, 0xba,
      0xf6, 0x5f, 0x30, 0x27, 0x23, 0xda, 0xbc, 0x4d},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x33, 0x32, 0x31, 0x36, 0x32, 0x33, 0x31, 0x33, 0x35},
     true},

    // Comment: special case hash
    // tcID: 296
    {SEC_OID_SHA384,
     296,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd8, 0xa4, 0xd9, 0x64, 0x09, 0xc1, 0x91,
      0xba, 0xa9, 0x54, 0x0b, 0xf3, 0x5f, 0x1d, 0x51, 0x92, 0xf9, 0x35, 0x2d,
      0x7f, 0x0e, 0x14, 0xf9, 0x2c, 0x0e, 0x8e, 0x1f, 0x19, 0xf5, 0x59, 0xb4,
      0x2e, 0xd3, 0xc6, 0xb7, 0xbd, 0xb6, 0xbe, 0xcc, 0x56, 0x58, 0x4f, 0xb5,
      0xc0, 0x94, 0x21, 0xe2, 0xe4, 0x02, 0x31, 0x00, 0xd9, 0x66, 0xba, 0x13,
      0xd4, 0x24, 0x5e, 0x24, 0x8e, 0xaf, 0xb4, 0x6f, 0x2a, 0x3d, 0xf9, 0x2c,
      0x20, 0x37, 0xd5, 0x96, 0x9c, 0x7d, 0xb6, 0xdb, 0xcb, 0x0f, 0xf4, 0xb2,
      0x18, 0x50, 0xe1, 0x6a, 0x18, 0xa2, 0x97, 0x85, 0x26, 0x72, 0x39, 0x88,
      0x63, 0x65, 0xcf, 0x72, 0x1a, 0x21, 0x25, 0x36},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x36, 0x34, 0x31, 0x30, 0x31, 0x35, 0x32, 0x31, 0x37, 0x31},
     true},

    // Comment: special case hash
    // tcID: 297
    {SEC_OID_SHA384,
     297,
     {0x30, 0x64, 0x02, 0x30, 0x1d, 0x5d, 0x86, 0xfd, 0x48, 0xe6, 0x5b, 0x0c,
      0xf0, 0xb0, 0xb4, 0x60, 0x62, 0x24, 0x1f, 0x89, 0xcf, 0x65, 0x78, 0x5d,
      0xd8, 0x18, 0xf9, 0x3f, 0x11, 0x62, 0x77, 0x1a, 0x38, 0xa1, 0x5f, 0x20,
      0xfe, 0xbc, 0x26, 0x18, 0x12, 0xec, 0xaa, 0xf6, 0xf4, 0xf2, 0xb8, 0x6b,
      0x33, 0x62, 0xd7, 0xeb, 0x02, 0x30, 0x0c, 0x76, 0xe3, 0x63, 0xde, 0x14,
      0x32, 0x51, 0x3c, 0xb9, 0xda, 0xd6, 0x49, 0x39, 0x31, 0x38, 0x1e, 0xcd,
      0x25, 0xf1, 0x42, 0xe6, 0x19, 0x68, 0xb6, 0xf2, 0x0d, 0x7b, 0x12, 0x70,
      0xcb, 0x9e, 0x38, 0xa7, 0xae, 0x54, 0xe4, 0x77, 0x8a, 0xff, 0x40, 0x25,
      0xeb, 0x00, 0xc6, 0xa6, 0x7a, 0xef},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x38, 0x33, 0x37, 0x32, 0x38, 0x35, 0x37, 0x34, 0x38},
     true},

    // Comment: special case hash
    // tcID: 298
    {SEC_OID_SHA384,
     298,
     {0x30, 0x64, 0x02, 0x30, 0x05, 0x08, 0xee, 0xd1, 0x48, 0xf0, 0x61, 0x11,
      0x4b, 0xe1, 0x8e, 0x8a, 0x86, 0x18, 0x8f, 0xea, 0xbf, 0x76, 0xb8, 0x73,
      0xb3, 0x6e, 0xad, 0xcc, 0xa9, 0xc2, 0xc6, 0x0e, 0x24, 0xa2, 0x00, 0x2f,
      0xe4, 0x56, 0x23, 0x1d, 0xec, 0xf7, 0xa8, 0xf6, 0xf0, 0x32, 0xc0, 0x8d,
      0xbe, 0x0a, 0xb5, 0xa9, 0x02, 0x30, 0x69, 0x4c, 0x0a, 0xd7, 0x81, 0xb2,
      0x34, 0x1e, 0x30, 0xe1, 0xd0, 0x73, 0x9a, 0xc9, 0x96, 0x72, 0x06, 0x4f,
      0x48, 0x82, 0x1a, 0x69, 0x85, 0x2c, 0x79, 0x40, 0xcf, 0x1d, 0x62, 0x17,
      0x38, 0x19, 0x9c, 0x98, 0x0d, 0x56, 0xd2, 0xa0, 0xb7, 0x1b, 0x3f, 0xc6,
      0x01, 0x1c, 0x6b, 0x24, 0x44, 0xba},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x33, 0x33, 0x32, 0x34, 0x37, 0x30, 0x34, 0x35, 0x32, 0x35},
     true},

    // Comment: special case hash
    // tcID: 299
    {SEC_OID_SHA384,
     299,
     {0x30, 0x65, 0x02, 0x30, 0x72, 0x6e, 0xf8, 0x8b, 0xb7, 0x94, 0x7a, 0x04,
      0x31, 0x16, 0xc1, 0x11, 0xcb, 0x51, 0x9d, 0xde, 0xda, 0x3e, 0x6f, 0xfb,
      0xf7, 0x24, 0x88, 0x4a, 0x1b, 0x22, 0xc2, 0x44, 0x09, 0xcd, 0xf2, 0x77,
      0x9d, 0x93, 0xce, 0x61, 0x0c, 0x8c, 0x07, 0x41, 0x1c, 0x2b, 0x00, 0x13,
      0x99, 0x10, 0x3d, 0x6d, 0x02, 0x31, 0x00, 0x95, 0xdc, 0x1d, 0x65, 0x04,
      0x6c, 0xaf, 0x0e, 0x8d, 0xad, 0x07, 0xb2, 0x24, 0x79, 0x8d, 0x6f, 0x78,
      0x07, 0x27, 0x8e, 0x73, 0x78, 0x83, 0xe7, 0xc7, 0xbf, 0x0b, 0x44, 0x67,
      0x91, 0xd4, 0xee, 0x14, 0x4c, 0x26, 0xf7, 0x10, 0x13, 0x48, 0x61, 0xaf,
      0x4e, 0x67, 0x71, 0xd4, 0x08, 0x28, 0x96},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x34, 0x30, 0x33, 0x39, 0x36, 0x36, 0x38, 0x37, 0x32},
     true},

    // Comment: special case hash
    // tcID: 300
    {SEC_OID_SHA384,
     300,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xeb, 0x0e, 0x8e, 0x3c, 0x63, 0x9f, 0x5e,
      0xba, 0x8e, 0xcc, 0xd9, 0x02, 0x0d, 0x0e, 0xc6, 0x2d, 0x8a, 0xc7, 0x3f,
      0x3f, 0xdd, 0xbd, 0xfa, 0x08, 0xfd, 0xb2, 0x15, 0x5d, 0xeb, 0x0a, 0x53,
      0x69, 0x23, 0xeb, 0xd5, 0x5e, 0x20, 0x02, 0x0c, 0xab, 0x9f, 0x8e, 0x39,
      0xa4, 0x3a, 0x88, 0xbe, 0x11, 0x02, 0x31, 0x00, 0xc7, 0x96, 0xdf, 0x39,
      0x9f, 0xc3, 0x58, 0x83, 0xdd, 0x5d, 0xae, 0x68, 0x17, 0xd0, 0x2d, 0x3d,
      0x67, 0xa8, 0xee, 0xc6, 0x60, 0x15, 0x85, 0xe5, 0xe3, 0x6f, 0xd2, 0xc1,
      0x34, 0xed, 0xdb, 0x14, 0x47, 0xec, 0x12, 0xb1, 0x44, 0xdd, 0xdc, 0x9a,
      0xae, 0x28, 0xa8, 0x4f, 0x22, 0x60, 0x26, 0x41},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x32, 0x32, 0x37, 0x36, 0x30, 0x35, 0x31, 0x32, 0x38},
     true},

    // Comment: special case hash
    // tcID: 301
    {SEC_OID_SHA384,
     301,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xe8, 0xf8, 0xc6, 0x9d, 0x03, 0x96, 0xea,
      0x90, 0x0f, 0x97, 0x57, 0x73, 0x6d, 0x2b, 0x19, 0xdb, 0xc2, 0xd2, 0xa8,
      0xc0, 0x1d, 0xcc, 0xf4, 0x90, 0xc8, 0xb9, 0x45, 0x5b, 0xd6, 0x3b, 0x34,
      0xc0, 0x95, 0x86, 0x7e, 0x7c, 0xf3, 0xb8, 0x4d, 0xc7, 0xc3, 0xc3, 0xd6,
      0xb5, 0x1b, 0xeb, 0xf4, 0x05, 0x02, 0x30, 0x58, 0x15, 0x2a, 0x75, 0x64,
      0xee, 0xb2, 0x2a, 0x3e, 0x26, 0x59, 0x70, 0x26, 0xd0, 0xcd, 0x78, 0x35,
      0x72, 0x5b, 0xd5, 0x12, 0x24, 0x54, 0x48, 0xcb, 0x50, 0x16, 0xeb, 0x48,
      0xea, 0x75, 0x98, 0x09, 0xfd, 0x69, 0x49, 0xd0, 0xee, 0x5d, 0x57, 0x96,
      0x43, 0xf7, 0x2f, 0x90, 0x8c, 0x16, 0xbb},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x39, 0x35, 0x31, 0x34, 0x38, 0x38, 0x33, 0x36, 0x32},
     true},

    // Comment: special case hash
    // tcID: 302
    {SEC_OID_SHA384,
     302,
     {0x30, 0x65, 0x02, 0x30, 0x38, 0x0b, 0x4e, 0x48, 0xb3, 0xff, 0x01, 0x2a,
      0xf7, 0xc0, 0x8b, 0xf8, 0x71, 0xd9, 0xf4, 0xda, 0x0c, 0x70, 0x8b, 0x54,
      0x94, 0xa9, 0x86, 0xd3, 0xd8, 0x0b, 0x19, 0x79, 0xe5, 0x79, 0xd0, 0xdb,
      0xee, 0x61, 0xdb, 0x9b, 0xc3, 0xc0, 0x4c, 0x39, 0x61, 0x76, 0x41, 0x07,
      0x88, 0xe1, 0x5a, 0x0f, 0x02, 0x31, 0x00, 0xe6, 0x97, 0x1c, 0x01, 0x3c,
      0x96, 0x5a, 0x7e, 0x4d, 0xf1, 0x0f, 0x95, 0x62, 0x0a, 0x50, 0x92, 0xfa,
      0xb0, 0x96, 0xbd, 0x5b, 0x50, 0x82, 0x8f, 0x4b, 0xc9, 0x1c, 0x5e, 0x47,
      0x9b, 0xcc, 0xf6, 0xe0, 0xda, 0xf2, 0x87, 0xe7, 0xef, 0x58, 0x0f, 0xa9,
      0xea, 0x15, 0x3f, 0xa1, 0xa5, 0x07, 0xa2},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x34, 0x35, 0x32, 0x31, 0x32, 0x37, 0x30, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 303
    {SEC_OID_SHA384,
     303,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0x80, 0x61, 0xde, 0x12, 0x02, 0x9e, 0x2b,
      0x00, 0x0d, 0x15, 0x7a, 0x45, 0x5e, 0xcf, 0x23, 0x01, 0x22, 0x2f, 0x09,
      0x2d, 0xf9, 0x5b, 0x95, 0x51, 0xb7, 0x8c, 0xf0, 0xef, 0x3a, 0x64, 0xf1,
      0x22, 0x12, 0xb5, 0x7e, 0xc7, 0xb1, 0x6d, 0x2c, 0x0f, 0x25, 0x89, 0x46,
      0xf5, 0x1c, 0xb1, 0x63, 0x3a, 0x02, 0x30, 0x0a, 0xc2, 0xca, 0x6a, 0xd9,
      0x9b, 0x29, 0xca, 0x29, 0xa0, 0xdc, 0x38, 0xb3, 0x44, 0x43, 0xee, 0x41,
      0x02, 0x0f, 0x81, 0xed, 0x90, 0x87, 0xce, 0xf7, 0x68, 0x1a, 0x00, 0xc4,
      0xfe, 0x60, 0x65, 0x3a, 0x57, 0x29, 0x44, 0xba, 0x37, 0xf1, 0xfe, 0x51,
      0xd1, 0x12, 0xbf, 0xff, 0xbd, 0xd7, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x37, 0x33, 0x31, 0x35, 0x35, 0x30, 0x37, 0x30, 0x36},
     true},

    // Comment: special case hash
    // tcID: 304
    {SEC_OID_SHA384,
     304,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xe7, 0x4f, 0x2a, 0x79, 0x1e, 0xeb, 0x73,
      0x41, 0xcf, 0xf6, 0xcc, 0x1c, 0x24, 0xf4, 0x59, 0xe6, 0xc0, 0x10, 0x99,
      0x24, 0xf7, 0x98, 0x46, 0x39, 0xae, 0x38, 0x7e, 0x3c, 0xeb, 0x58, 0x75,
      0x8a, 0x1b, 0xc3, 0x83, 0x9d, 0xea, 0x1f, 0xc3, 0xa3, 0x79, 0x95, 0x62,
      0x22, 0x5e, 0x70, 0xa7, 0x33, 0x02, 0x31, 0x00, 0xd9, 0x0e, 0x4d, 0x0f,
      0x47, 0x34, 0x32, 0x68, 0xe5, 0x6b, 0xbc, 0xb0, 0x11, 0xbd, 0x47, 0x34,
      0x39, 0x0a, 0xbc, 0x9a, 0xa1, 0x30, 0x4b, 0x62, 0x53, 0xe7, 0x8f, 0x5a,
      0x78, 0xb6, 0x90, 0x5a, 0xa6, 0xbf, 0x6a, 0x38, 0x92, 0xa4, 0xae, 0x1a,
      0x87, 0x5c, 0x82, 0x3a, 0xe5, 0xa8, 0x3e, 0x87},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x36, 0x36, 0x37, 0x30, 0x36, 0x39, 0x38, 0x37, 0x38},
     true},

    // Comment: special case hash
    // tcID: 305
    {SEC_OID_SHA384,
     305,
     {0x30, 0x64, 0x02, 0x30, 0x6a, 0x1c, 0xd0, 0xff, 0x79, 0x06, 0xbe, 0x20,
      0x7b, 0x56, 0x86, 0x2e, 0xdc, 0xbc, 0x0d, 0x0b, 0xbf, 0xb2, 0x6d, 0x43,
      0x25, 0x5c, 0x99, 0xf6, 0xab, 0x77, 0x63, 0x9f, 0x5e, 0x61, 0x03, 0xa0,
      0x7a, 0xa3, 0x22, 0xb2, 0x2e, 0xd4, 0x38, 0x70, 0xd1, 0xce, 0x6d, 0xf6,
      0x8a, 0xa0, 0xa8, 0xc1, 0x02, 0x30, 0x65, 0x55, 0x58, 0xb1, 0x29, 0xaa,
      0x23, 0x18, 0x45, 0x00, 0xbd, 0x4a, 0xab, 0x4f, 0x03, 0x55, 0xd3, 0x19,
      0x2e, 0x9b, 0x88, 0x60, 0xf6, 0x0b, 0x05, 0xa1, 0xc2, 0x92, 0x61, 0xf4,
      0x48, 0x6a, 0x6a, 0xe2, 0x35, 0xa5, 0x26, 0x33, 0x9b, 0x86, 0xc0, 0x5f,
      0x5f, 0xac, 0x47, 0x7b, 0x67, 0x23},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x34, 0x31, 0x35, 0x34, 0x37, 0x36, 0x31, 0x37},
     true},

    // Comment: special case hash
    // tcID: 306
    {SEC_OID_SHA384,
     306,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x81, 0x11, 0x1f, 0xdc, 0x5f, 0x0d, 0xe6,
      0x55, 0x83, 0xc7, 0xa5, 0x66, 0x8d, 0x26, 0xc0, 0x4e, 0xe5, 0x2e, 0x08,
      0xda, 0xc2, 0x27, 0x75, 0x31, 0x32, 0xcf, 0xf1, 0x74, 0x1c, 0xb7, 0x21,
      0xe1, 0x12, 0xaa, 0x79, 0x3c, 0x0d, 0x5f, 0xa0, 0x47, 0xfa, 0xf1, 0x4c,
      0xb4, 0x5d, 0xd1, 0x3e, 0x1f, 0x02, 0x31, 0x00, 0x9a, 0x25, 0xcf, 0x1e,
      0x6c, 0x15, 0x2b, 0xc3, 0xe2, 0x16, 0xe0, 0x21, 0x56, 0x1d, 0x19, 0x49,
      0x79, 0xf1, 0xc1, 0x1f, 0xe1, 0x70, 0x19, 0xed, 0x7b, 0xac, 0x2c, 0x13,
      0xc4, 0x01, 0x0f, 0x20, 0x96, 0x65, 0xe3, 0xb6, 0xf3, 0x3b, 0x86, 0x64,
      0x17, 0x04, 0xd9, 0x22, 0xb4, 0x07, 0x81, 0x8f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x32, 0x33, 0x39, 0x34, 0x34, 0x39, 0x39, 0x38},
     true},

    // Comment: special case hash
    // tcID: 307
    {SEC_OID_SHA384,
     307,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x9b, 0x66, 0xd1, 0x22, 0xa3, 0x15, 0x09,
      0x5b, 0x2b, 0x66, 0xcc, 0xb9, 0x72, 0x72, 0xc4, 0x76, 0xa2, 0xd7, 0x60,
      0xe8, 0x27, 0xfd, 0xea, 0x05, 0x73, 0x2d, 0x63, 0x4d, 0xf3, 0xd0, 0x66,
      0x56, 0x9c, 0x98, 0x4d, 0xd9, 0x41, 0xaa, 0xd5, 0xf5, 0xde, 0xc4, 0xc2,
      0xe1, 0xb7, 0xb9, 0x4a, 0x00, 0x02, 0x31, 0x00, 0x96, 0xc3, 0x24, 0x03,
      0xc8, 0x5b, 0xc3, 0xd0, 0xee, 0x87, 0xf9, 0x6a, 0x60, 0x01, 0x82, 0x79,
      0x6d, 0xce, 0x53, 0xd5, 0x4d, 0x74, 0x67, 0xae, 0x66, 0x0a, 0x42, 0xb8,
      0x7b, 0xb7, 0x07, 0x92, 0xf1, 0x46, 0x50, 0xac, 0x28, 0xa5, 0xfa, 0x47,
      0xce, 0x9c, 0xa4, 0xd3, 0xb2, 0xc2, 0x58, 0x78},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x38, 0x30, 0x37, 0x36, 0x32, 0x30, 0x37, 0x31, 0x32},
     true},

    // Comment: special case hash
    // tcID: 308
    {SEC_OID_SHA384,
     308,
     {0x30, 0x64, 0x02, 0x30, 0x2b, 0xb0, 0x62, 0xa0, 0x02, 0x08, 0x8d, 0x62,
      0xa0, 0xb7, 0x33, 0x8d, 0x04, 0x84, 0xfe, 0xdf, 0xe2, 0xaf, 0x7e, 0x20,
      0xce, 0xbf, 0x6a, 0x47, 0x88, 0x26, 0x4e, 0xb2, 0x7c, 0xb4, 0xeb, 0xc3,
      0xcc, 0x81, 0xc8, 0x16, 0xe6, 0xa3, 0x57, 0x22, 0xcf, 0x9b, 0x46, 0x47,
      0x83, 0x09, 0x4c, 0xb8, 0x02, 0x30, 0x46, 0xcc, 0x21, 0xb7, 0x0f, 0x21,
      0x33, 0xf8, 0x5a, 0xb0, 0x44, 0x3b, 0xeb, 0xe9, 0xc6, 0xfc, 0x62, 0xc6,
      0xe2, 0xec, 0x1f, 0xd9, 0xc4, 0xdd, 0xf4, 0xa6, 0xd5, 0xf3, 0xf4, 0x8e,
      0xb7, 0xab, 0xf1, 0xee, 0x7b, 0xdf, 0x67, 0x25, 0x87, 0x9f, 0xd1, 0xb7,
      0xda, 0xaf, 0xb4, 0x4f, 0x6e, 0x04},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x31, 0x36, 0x34, 0x36, 0x36, 0x36, 0x32, 0x38, 0x39},
     true},

    // Comment: special case hash
    // tcID: 309
    {SEC_OID_SHA384,
     309,
     {0x30, 0x65, 0x02, 0x30, 0x33, 0xe8, 0x70, 0x61, 0xee, 0x9a, 0x82, 0xeb,
      0x74, 0xd8, 0xbb, 0x4a, 0xe9, 0x16, 0x06, 0x56, 0x3c, 0x2e, 0x4d, 0xb8,
      0xb0, 0x91, 0x83, 0xcc, 0x00, 0xd1, 0x11, 0x9a, 0xb4, 0xf5, 0x03, 0x3d,
      0x28, 0x7a, 0x1f, 0xc9, 0x0a, 0x23, 0x48, 0x16, 0x3f, 0xdf, 0x68, 0xd3,
      0x50, 0x06, 0xfd, 0x7f, 0x02, 0x31, 0x00, 0x96, 0xdb, 0x97, 0xc9, 0x47,
      0xee, 0x2e, 0x96, 0xe6, 0x13, 0x9d, 0x3b, 0xcb, 0xf5, 0xa4, 0x36, 0x06,
      0xba, 0xe1, 0xad, 0x3c, 0xa2, 0x82, 0x90, 0xfb, 0xad, 0x43, 0xb2, 0x81,
      0xef, 0x11, 0x5e, 0xc1, 0xb9, 0x8b, 0xc5, 0x81, 0xef, 0x48, 0x09, 0x4f,
      0x8c, 0x1a, 0xa8, 0xe3, 0x6c, 0x28, 0x2a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x31, 0x39, 0x34, 0x32, 0x38, 0x35, 0x33, 0x38, 0x36, 0x35},
     true},

    // Comment: special case hash
    // tcID: 310
    {SEC_OID_SHA384,
     310,
     {0x30, 0x64, 0x02, 0x30, 0x70, 0xf8, 0x0b, 0x43, 0x84, 0x24, 0xba, 0x22,
      0x8a, 0x7d, 0x80, 0xf2, 0x6e, 0x22, 0xff, 0x6a, 0x89, 0x62, 0x43, 0xc9,
      0xd4, 0x9c, 0x75, 0x57, 0x34, 0x89, 0xee, 0x0d, 0xe5, 0x8e, 0xc6, 0x0e,
      0xfd, 0x10, 0x38, 0x38, 0x14, 0x34, 0x65, 0xbd, 0x8f, 0xe3, 0x46, 0x72,
      0xba, 0x94, 0x96, 0x17, 0x02, 0x30, 0x11, 0x54, 0x92, 0xbd, 0x93, 0x65,
      0xb9, 0x6f, 0x38, 0x74, 0x75, 0x36, 0x31, 0x8b, 0xff, 0xb8, 0x19, 0xe7,
      0xc1, 0x46, 0xdf, 0x3a, 0x5a, 0x7a, 0x46, 0xd6, 0x28, 0x8c, 0x7f, 0xdf,
      0x31, 0xcf, 0xf5, 0x70, 0xb2, 0x21, 0x76, 0xaa, 0x39, 0x8d, 0xab, 0xa9,
      0x07, 0x3a, 0xb1, 0xe7, 0xb9, 0xbf},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x32, 0x31, 0x39, 0x33, 0x38, 0x33, 0x35, 0x32, 0x31},
     true},

    // Comment: special case hash
    // tcID: 311
    {SEC_OID_SHA384,
     311,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0x16, 0xca, 0x03, 0x89, 0xea, 0x69,
      0x48, 0xf4, 0x30, 0x5b, 0x43, 0x4f, 0xe0, 0xaa, 0x58, 0x9f, 0x88, 0x0f,
      0x5a, 0xa9, 0x37, 0x76, 0x7c, 0x31, 0x17, 0x0e, 0xe8, 0xda, 0x6c, 0x1a,
      0xd6, 0x20, 0xc9, 0x93, 0xd4, 0x0d, 0xdf, 0x14, 0x1b, 0x7f, 0xda, 0x37,
      0x42, 0x4d, 0x51, 0xb5, 0xcd, 0x02, 0x31, 0x00, 0xba, 0x0f, 0x86, 0x98,
      0x5d, 0xff, 0xc6, 0x1d, 0x6e, 0x35, 0xa3, 0x7d, 0xe0, 0x69, 0x18, 0xb1,
      0x1e, 0x43, 0x1b, 0x72, 0x40, 0x31, 0x61, 0xac, 0xfb, 0x8f, 0x05, 0xc4,
      0x69, 0xf1, 0xfc, 0xfa, 0x6e, 0x21, 0x5c, 0x6f, 0x7e, 0xb5, 0xa0, 0xa5,
      0xe0, 0xcc, 0x9e, 0x7b, 0xe7, 0x9c, 0xe1, 0x8b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x39, 0x32, 0x36, 0x39, 0x33, 0x33, 0x34, 0x31, 0x39},
     true},

    // Comment: special case hash
    // tcID: 312
    {SEC_OID_SHA384,
     312,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xd6, 0x0c, 0x24, 0xbe, 0xe0, 0x5f, 0x51,
      0x98, 0xcd, 0x15, 0x5a, 0xd0, 0x95, 0xff, 0xb9, 0x56, 0xbb, 0xcf, 0xb6,
      0x6b, 0x82, 0xfc, 0x0d, 0x37, 0x55, 0x11, 0x99, 0x15, 0xa6, 0x2f, 0x2f,
      0x92, 0x35, 0x57, 0xb8, 0x5d, 0xdc, 0x1d, 0x12, 0xe6, 0xa7, 0x57, 0xf2,
      0x30, 0x42, 0xcb, 0x60, 0x1b, 0x02, 0x30, 0x2c, 0x4d, 0x96, 0x8b, 0x5e,
      0xac, 0x93, 0x0b, 0x51, 0xd2, 0x83, 0xb4, 0x18, 0xfc, 0xff, 0x6d, 0xf3,
      0xa9, 0xd6, 0xd6, 0x6e, 0x38, 0x12, 0xcd, 0x1b, 0xf5, 0xfd, 0xe7, 0x97,
      0xfd, 0x20, 0x3a, 0x7c, 0x43, 0x9b, 0x1b, 0x38, 0x1e, 0x4f, 0xe8, 0xb4,
      0x4e, 0x6f, 0x10, 0x87, 0x64, 0xa7, 0xdd},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x37, 0x36, 0x39, 0x33, 0x38, 0x36, 0x33, 0x36, 0x34},
     true},

    // Comment: special case hash
    // tcID: 313
    {SEC_OID_SHA384,
     313,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xbd, 0xf6, 0x34, 0xd9, 0x15, 0xa4, 0xfa,
      0xe7, 0xa1, 0x55, 0x53, 0x2c, 0xa2, 0x84, 0x7c, 0x33, 0xa6, 0xba, 0xbe,
      0x7e, 0xf8, 0xdb, 0x0a, 0xf5, 0x0f, 0x48, 0x5d, 0xb3, 0xdd, 0x2c, 0x8b,
      0xff, 0xe7, 0x22, 0x39, 0x45, 0x83, 0x93, 0x2f, 0x6e, 0xb5, 0xcd, 0x97,
      0xf6, 0xdb, 0x75, 0x61, 0xd9, 0x02, 0x31, 0x00, 0xbb, 0x42, 0x5c, 0xae,
      0x2e, 0x54, 0x83, 0x17, 0x4b, 0x5e, 0xd8, 0x73, 0xaf, 0x43, 0x29, 0xda,
      0x46, 0x18, 0xc1, 0x44, 0x58, 0x14, 0x18, 0x50, 0xbe, 0xe3, 0xc7, 0xbf,
      0x1f, 0xfb, 0x3f, 0x20, 0x30, 0x15, 0x90, 0x43, 0x27, 0x7d, 0xac, 0xc7,
      0x08, 0xe9, 0xd3, 0x2f, 0x63, 0x40, 0x00, 0x83},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x32, 0x37, 0x33, 0x35, 0x39, 0x33, 0x30, 0x35, 0x37, 0x33},
     true},

    // Comment: special case hash
    // tcID: 314
    {SEC_OID_SHA384,
     314,
     {0x30, 0x65, 0x02, 0x30, 0x06, 0x13, 0x20, 0xa3, 0xbc, 0xeb, 0xac, 0x33,
      0xcf, 0x39, 0x9d, 0x45, 0xd1, 0xe1, 0xe1, 0xb3, 0x4f, 0x37, 0x28, 0x8f,
      0xe4, 0x75, 0x3f, 0x4f, 0xdd, 0xfd, 0x49, 0x6e, 0xff, 0x42, 0x7e, 0x1d,
      0x26, 0xb1, 0xb9, 0x1d, 0x74, 0x9c, 0xc3, 0x4c, 0x12, 0xf4, 0xec, 0xef,
      0x83, 0x7c, 0x0e, 0x8f, 0x02, 0x31, 0x00, 0xfd, 0x5c, 0xf4, 0x68, 0xcd,
      0xa3, 0x19, 0xfe, 0x06, 0xe7, 0x73, 0xa1, 0x90, 0xc3, 0x8d, 0xe6, 0xe1,
      0x50, 0xa3, 0x21, 0xac, 0x1c, 0x41, 0x6a, 0xd8, 0x75, 0x43, 0x2c, 0xdb,
      0x7a, 0x07, 0x13, 0x4c, 0x44, 0x6f, 0x13, 0x06, 0x8e, 0x71, 0xa1, 0xa9,
      0x6e, 0x35, 0xda, 0x92, 0x39, 0x74, 0xad},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x38, 0x33, 0x30, 0x30, 0x35, 0x36, 0x34, 0x30, 0x36, 0x35},
     true},

    // Comment: special case hash
    // tcID: 315
    {SEC_OID_SHA384,
     315,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xd6, 0x20, 0xf0, 0x63, 0xd3, 0x3e, 0xfa,
      0x85, 0x9b, 0x62, 0x3f, 0x6c, 0x9a, 0x92, 0x34, 0x0e, 0x4c, 0xdd, 0x85,
      0x4f, 0xfb, 0xe3, 0xe5, 0xe0, 0x13, 0x79, 0x17, 0x7a, 0xee, 0x31, 0x71,
      0x5c, 0xe5, 0x87, 0xb0, 0x0b, 0xd0, 0xae, 0xa9, 0x8f, 0xdd, 0xf2, 0x36,
      0xd2, 0xfc, 0x8a, 0x7a, 0x74, 0x02, 0x30, 0x67, 0x1f, 0x4b, 0x7c, 0x18,
      0x72, 0x97, 0xdc, 0x23, 0x6c, 0x61, 0x88, 0x8b, 0x6d, 0x93, 0x97, 0xe9,
      0x77, 0x83, 0x07, 0x7c, 0xc4, 0x10, 0x18, 0x07, 0xd7, 0x9e, 0xe6, 0x2e,
      0x4a, 0x53, 0xa7, 0x8c, 0x4b, 0x6a, 0x3a, 0x31, 0xb0, 0x31, 0x78, 0x66,
      0x8a, 0xf8, 0x94, 0xa3, 0xd8, 0x90, 0x2e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x34, 0x33, 0x30, 0x37, 0x36, 0x35, 0x35, 0x37, 0x33, 0x38},
     true},

    // Comment: special case hash
    // tcID: 316
    {SEC_OID_SHA384,
     316,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0x91, 0xc5, 0x56, 0xc5, 0xbd, 0xdd, 0x52,
      0x9f, 0xe9, 0x03, 0xb8, 0x6a, 0xfc, 0x0e, 0xb8, 0xfa, 0x1f, 0x49, 0x42,
      0x5b, 0x77, 0x9a, 0x39, 0x11, 0x4a, 0xe5, 0x63, 0xbe, 0xbc, 0x94, 0x7e,
      0x63, 0x3b, 0xa4, 0xee, 0x98, 0x94, 0x8f, 0xaa, 0x89, 0x40, 0xdf, 0xe2,
      0x56, 0x2c, 0x63, 0xe1, 0xc5, 0x02, 0x30, 0x19, 0x8b, 0x00, 0x07, 0x9d,
      0x8d, 0xb0, 0x72, 0xd2, 0x5b, 0x0a, 0x49, 0xbc, 0x8b, 0xc3, 0x64, 0x57,
      0x92, 0x6f, 0x3c, 0x10, 0x15, 0x27, 0x52, 0x8d, 0xf6, 0x67, 0x9f, 0x92,
      0xc7, 0x6f, 0x1b, 0x48, 0x7e, 0x66, 0x95, 0xd4, 0xb9, 0x2f, 0xe3, 0x3b,
      0x4e, 0xe7, 0x04, 0x6a, 0x6a, 0x5d, 0xf9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x2d, 0xa5, 0x7d, 0xda, 0x10, 0x89, 0x27, 0x6a, 0x54, 0x3f, 0x9f, 0xfd,
      0xac, 0x0b, 0xff, 0x0d, 0x97, 0x6c, 0xad, 0x71, 0xeb, 0x72, 0x80, 0xe7,
      0xd9, 0xbf, 0xd9, 0xfe, 0xe4, 0xbd, 0xb2, 0xf2, 0x0f, 0x47, 0xff, 0x88,
      0x82, 0x74, 0x38, 0x97, 0x72, 0xd9, 0x8c, 0xc5, 0x75, 0x21, 0x38, 0xaa,
      0x4b, 0x6d, 0x05, 0x4d, 0x69, 0xdc, 0xf3, 0xe2, 0x5e, 0xc4, 0x9d, 0xf8,
      0x70, 0x71, 0x5e, 0x34, 0x88, 0x3b, 0x18, 0x36, 0x19, 0x7d, 0x76, 0xf8,
      0xad, 0x96, 0x2e, 0x78, 0xf6, 0x57, 0x1b, 0xbc, 0x74, 0x07, 0xb0, 0xd6,
      0x09, 0x1f, 0x9e, 0x4d, 0x88, 0xf0, 0x14, 0x27, 0x44, 0x06, 0x17, 0x4f},
     {0x39, 0x36, 0x35, 0x37, 0x30, 0x31, 0x38, 0x31, 0x37, 0x35},
     true},

    // Comment: k*G has a large x-coordinate
    // tcID: 317
    {SEC_OID_SHA384,
     317,
     {0x30, 0x4d, 0x02, 0x18, 0x38, 0x9c, 0xb2, 0x7e, 0x0b, 0xc8, 0xd2, 0x1f,
      0xa7, 0xe5, 0xf2, 0x4c, 0xb7, 0x4f, 0x58, 0x85, 0x13, 0x13, 0xe6, 0x96,
      0x33, 0x3a, 0xd6, 0x8b, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4,
      0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec,
      0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x4b, 0xf4, 0xe5, 0x2f, 0x95, 0x84, 0x27, 0xeb, 0xb5, 0x91, 0x5f, 0xb8,
      0xc9, 0x59, 0x55, 0x51, 0xb4, 0xd3, 0xa3, 0xfd, 0xab, 0x67, 0xba, 0xdd,
      0x9d, 0x6c, 0x30, 0x93, 0xf4, 0x25, 0xba, 0x43, 0x63, 0x0d, 0xf7, 0x1f,
      0x42, 0xf0, 0xeb, 0x7c, 0xea, 0xa9, 0x4d, 0x9f, 0x64, 0x48, 0xa8, 0x5d,
      0xd3, 0x03, 0x31, 0x58, 0x82, 0x49, 0xfd, 0x2f, 0xdc, 0x0b, 0x30, 0x9e,
      0xc7, 0xed, 0x84, 0x81, 0xbc, 0x16, 0xf2, 0x78, 0x00, 0xc1, 0x3d, 0x7d,
      0xb7, 0x00, 0xfc, 0x82, 0xe1, 0xb1, 0xc8, 0x54, 0x5a, 0xa0, 0xc0, 0xd3,
      0xb5, 0x6e, 0x3b, 0xfe, 0x78, 0x9f, 0xc1, 0x8a, 0x91, 0x68, 0x87, 0xc2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r too large
    // tcID: 318
    {SEC_OID_SHA384,
     318,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0xff, 0xff, 0xff, 0xfe, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x70},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x4b, 0xf4, 0xe5, 0x2f, 0x95, 0x84, 0x27, 0xeb, 0xb5, 0x91, 0x5f, 0xb8,
      0xc9, 0x59, 0x55, 0x51, 0xb4, 0xd3, 0xa3, 0xfd, 0xab, 0x67, 0xba, 0xdd,
      0x9d, 0x6c, 0x30, 0x93, 0xf4, 0x25, 0xba, 0x43, 0x63, 0x0d, 0xf7, 0x1f,
      0x42, 0xf0, 0xeb, 0x7c, 0xea, 0xa9, 0x4d, 0x9f, 0x64, 0x48, 0xa8, 0x5d,
      0xd3, 0x03, 0x31, 0x58, 0x82, 0x49, 0xfd, 0x2f, 0xdc, 0x0b, 0x30, 0x9e,
      0xc7, 0xed, 0x84, 0x81, 0xbc, 0x16, 0xf2, 0x78, 0x00, 0xc1, 0x3d, 0x7d,
      0xb7, 0x00, 0xfc, 0x82, 0xe1, 0xb1, 0xc8, 0x54, 0x5a, 0xa0, 0xc0, 0xd3,
      0xb5, 0x6e, 0x3b, 0xfe, 0x78, 0x9f, 0xc1, 0x8a, 0x91, 0x68, 0x87, 0xc2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: r,s are large
    // tcID: 319
    {SEC_OID_SHA384,
     319,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x72, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x71},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x36, 0x23, 0xbb, 0x29, 0x6b, 0x88, 0xf6, 0x26, 0xd0, 0xf9, 0x26, 0x56,
      0xbf, 0x01, 0x6f, 0x11, 0x5b, 0x72, 0x12, 0x77, 0xcc, 0xb4, 0x93, 0x07,
      0x39, 0xbf, 0xbd, 0x81, 0xf9, 0xc1, 0xe7, 0x34, 0x63, 0x0e, 0x06, 0x85,
      0xd3, 0x2e, 0x15, 0x4e, 0x0b, 0x4a, 0x5c, 0x62, 0xe4, 0x38, 0x51, 0xf6,
      0x76, 0x83, 0x56, 0xb4, 0xa5, 0x76, 0x4c, 0x12, 0x8c, 0x7b, 0x11, 0x05,
      0xe3, 0xd7, 0x78, 0xa8, 0x9d, 0x1e, 0x01, 0xda, 0x29, 0x7e, 0xde, 0x1b,
      0xc4, 0x31, 0x2c, 0x25, 0x83, 0xe0, 0xbb, 0xdd, 0xd2, 0x16, 0x13, 0x58,
      0x3d, 0xd0, 0x9a, 0xb8, 0x95, 0xc6, 0x3b, 0xe4, 0x79, 0xf9, 0x45, 0x76},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 have a large Hamming weight
    // tcID: 320
    {SEC_OID_SHA384,
     320,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xd1, 0xae, 0xe5, 0x5f, 0xdc,
      0x2a, 0x71, 0x6b, 0xa2, 0xfa, 0xbc, 0xb5, 0x70, 0x20, 0xb7, 0x2e, 0x53,
      0x9b, 0xf0, 0x5c, 0x79, 0x02, 0xf9, 0x8e, 0x10, 0x5b, 0xf8, 0x3d, 0x4c,
      0xc1, 0x0c, 0x2a, 0x15, 0x9a, 0x3c, 0xf7, 0xe0, 0x1d, 0x74, 0x9d, 0x22,
      0x05, 0xf4, 0xda, 0x6b, 0xd8, 0xfc, 0xf1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd5, 0x16, 0xcb, 0x8a, 0xc8, 0xe4, 0x45, 0x7b, 0x69, 0x3d, 0x51, 0x92,
      0xbe, 0xeb, 0x6c, 0xe7, 0xd9, 0xa4, 0x6b, 0xef, 0x48, 0xee, 0xcf, 0x3e,
      0xa8, 0x23, 0x28, 0x6f, 0x10, 0x1f, 0x98, 0xd1, 0x30, 0xf5, 0xa2, 0x6d,
      0xc6, 0xfe, 0xc2, 0x36, 0x62, 0xef, 0xf0, 0x7f, 0x14, 0x48, 0x6f, 0xd5,
      0x84, 0x56, 0x93, 0x2e, 0x74, 0x89, 0x4b, 0x7f, 0x0e, 0x3b, 0xb0, 0xdf,
      0xd3, 0x62, 0x50, 0x2b, 0x37, 0x65, 0xdd, 0x80, 0xa3, 0x17, 0x72, 0x09,
      0xfb, 0x22, 0x1d, 0xc9, 0xb5, 0x1a, 0xaf, 0x44, 0x70, 0xb2, 0x45, 0x39,
      0x14, 0x05, 0xbe, 0xf5, 0x14, 0x17, 0x6b, 0x13, 0xa2, 0x67, 0xa7, 0x20},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 have a large Hamming weight
    // tcID: 321
    {SEC_OID_SHA384,
     321,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xb6, 0xb6, 0x81, 0xdc, 0x48,
      0x4f, 0x4f, 0x02, 0x0f, 0xd3, 0xf7, 0xe6, 0x26, 0xd8, 0x8e, 0xdc, 0x6d,
      0xed, 0x1b, 0x38, 0x2e, 0xf3, 0xe1, 0x43, 0xd6, 0x08, 0x87, 0xb5, 0x13,
      0x94, 0x26, 0x08, 0x32, 0xd4, 0xd8, 0xf2, 0xef, 0x70, 0x45, 0x8f, 0x9f,
      0xa9, 0x0e, 0x38, 0xc2, 0xe1, 0x9e, 0x4f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xa8, 0x38, 0x0c, 0xd3, 0x50, 0x26, 0xe1, 0x3b, 0xf8, 0x7b, 0xe6, 0x93,
      0xcd, 0xb6, 0xe7, 0x5a, 0x82, 0xd7, 0x65, 0xb4, 0x01, 0x9b, 0x52, 0x9e,
      0x8d, 0x27, 0x7c, 0x4a, 0xf6, 0xc9, 0xdb, 0x27, 0xeb, 0xb5, 0xd3, 0xf8,
      0x6e, 0x88, 0xad, 0xd9, 0xd5, 0xb6, 0x11, 0x86, 0xf0, 0x4c, 0x83, 0xa9,
      0x92, 0xa1, 0x87, 0x50, 0x7c, 0x73, 0x73, 0x25, 0xd2, 0xcc, 0x62, 0x4a,
      0xce, 0xf3, 0xcd, 0x03, 0x6b, 0xfa, 0x99, 0xe0, 0xc1, 0x51, 0x8b, 0xe6,
      0x5c, 0x88, 0xbb, 0x51, 0xf9, 0x00, 0xf9, 0x41, 0x23, 0xac, 0xab, 0xad,
      0x81, 0xd1, 0x51, 0x30, 0xd3, 0xad, 0xe7, 0xff, 0x7e, 0x43, 0x64, 0xe1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 322
    {SEC_OID_SHA384,
     322,
     {0x30, 0x06, 0x02, 0x01, 0x02, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x55, 0x4f, 0x2f, 0xd0, 0xb7, 0x00, 0xa9, 0xf4, 0x56, 0x87, 0x52, 0xb6,
      0x73, 0xd9, 0xc0, 0xd2, 0x9d, 0xc9, 0x6c, 0x10, 0xfe, 0x67, 0xe3, 0x8c,
      0x6d, 0x6d, 0x33, 0x9b, 0xfa, 0xfe, 0x05, 0xf9, 0x70, 0xda, 0x8c, 0x3d,
      0x21, 0x64, 0xe8, 0x20, 0x31, 0x30, 0x7a, 0x44, 0xbd, 0x32, 0x25, 0x11,
      0x71, 0x31, 0x2b, 0x61, 0xb5, 0x91, 0x13, 0xff, 0x0b, 0xd3, 0xb8, 0xa9,
      0xa4, 0x93, 0x4d, 0xf2, 0x62, 0xaa, 0x80, 0x96, 0xf8, 0x40, 0xe9, 0xd8,
      0xbf, 0xfa, 0x5d, 0x74, 0x91, 0xde, 0xd8, 0x7b, 0x38, 0xc4, 0x96, 0xf9,
      0xb9, 0xe4, 0xf0, 0xba, 0x10, 0x89, 0xf8, 0xd3, 0xff, 0xc8, 0x8a, 0x9f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 323
    {SEC_OID_SHA384,
     323,
     {0x30, 0x06, 0x02, 0x01, 0x02, 0x02, 0x01, 0x02},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x44, 0xee, 0x33, 0x35, 0xfa, 0x77, 0xd2, 0xfb, 0x02, 0xe4, 0xbd, 0x70,
      0x74, 0xf4, 0x5e, 0x59, 0x8a, 0x87, 0x9c, 0x0f, 0xa8, 0x22, 0xec, 0x71,
      0x8c, 0x21, 0xdc, 0x13, 0xb8, 0x34, 0x40, 0xed, 0xc4, 0xe3, 0xc1, 0x0a,
      0x18, 0x58, 0x42, 0x3e, 0x03, 0x04, 0x4c, 0x9e, 0xff, 0x22, 0x59, 0x1c,
      0xd0, 0x27, 0xc4, 0x99, 0x33, 0xe5, 0x51, 0x05, 0x57, 0xd6, 0xb4, 0xb2,
      0xc6, 0xf6, 0x6f, 0xe5, 0xdc, 0xb9, 0x30, 0x2a, 0x3b, 0x13, 0xfd, 0xc6,
      0x80, 0x48, 0xc3, 0xfc, 0xac, 0x88, 0xba, 0x15, 0x2b, 0x6a, 0x98, 0x33,
      0xc8, 0x7f, 0xdc, 0x62, 0x80, 0xaf, 0xc5, 0xd1, 0x1a, 0xb7, 0xc1, 0x07},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and s
    // tcID: 324
    {SEC_OID_SHA384,
     324,
     {0x30, 0x06, 0x02, 0x01, 0x02, 0x02, 0x01, 0x03},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe2, 0xf8, 0x7f, 0x72, 0xe3, 0xc6, 0x6c, 0x73, 0x03, 0x7f, 0xe7, 0x76,
      0x07, 0xd4, 0x2a, 0xd2, 0xd9, 0xc4, 0xcc, 0x15, 0x98, 0x93, 0xb4, 0xb9,
      0xb8, 0xb0, 0x36, 0x5d, 0x3a, 0x77, 0x66, 0xdb, 0xe8, 0x67, 0x8b, 0x02,
      0xe2, 0xb6, 0x8f, 0x58, 0xe5, 0xa4, 0xf7, 0x68, 0x10, 0x61, 0xa3, 0x90,
      0xe3, 0x8f, 0x21, 0x42, 0x81, 0x85, 0x42, 0xbe, 0xf6, 0xb2, 0xbc, 0x3a,
      0x2c, 0x4f, 0x43, 0xc9, 0x5e, 0x52, 0x59, 0xd6, 0xbd, 0x54, 0x01, 0x53,
      0x13, 0x78, 0xc7, 0xca, 0x12, 0x5a, 0x1f, 0x6c, 0xc6, 0x09, 0xd4, 0xfa,
      0xdf, 0xc5, 0xc9, 0xa9, 0x93, 0x58, 0xee, 0x77, 0xff, 0x78, 0x0c, 0x8d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r is larger than n
    // tcID: 325
    {SEC_OID_SHA384,
     325,
     {0x30, 0x36, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x29, 0x75, 0x02, 0x01, 0x03},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe2, 0xf8, 0x7f, 0x72, 0xe3, 0xc6, 0x6c, 0x73, 0x03, 0x7f, 0xe7, 0x76,
      0x07, 0xd4, 0x2a, 0xd2, 0xd9, 0xc4, 0xcc, 0x15, 0x98, 0x93, 0xb4, 0xb9,
      0xb8, 0xb0, 0x36, 0x5d, 0x3a, 0x77, 0x66, 0xdb, 0xe8, 0x67, 0x8b, 0x02,
      0xe2, 0xb6, 0x8f, 0x58, 0xe5, 0xa4, 0xf7, 0x68, 0x10, 0x61, 0xa3, 0x90,
      0xe3, 0x8f, 0x21, 0x42, 0x81, 0x85, 0x42, 0xbe, 0xf6, 0xb2, 0xbc, 0x3a,
      0x2c, 0x4f, 0x43, 0xc9, 0x5e, 0x52, 0x59, 0xd6, 0xbd, 0x54, 0x01, 0x53,
      0x13, 0x78, 0xc7, 0xca, 0x12, 0x5a, 0x1f, 0x6c, 0xc6, 0x09, 0xd4, 0xfa,
      0xdf, 0xc5, 0xc9, 0xa9, 0x93, 0x58, 0xee, 0x77, 0xff, 0x78, 0x0c, 0x8d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: s is larger than n
    // tcID: 326
    {SEC_OID_SHA384,
     326,
     {0x30, 0x36, 0x02, 0x01, 0x02, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81,
      0xf4, 0x37, 0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
      0xec, 0xec, 0x19, 0x6a, 0xcc, 0xd7, 0xff, 0xfa},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x05, 0xe6, 0x7c, 0x44, 0xfc, 0x0c, 0xbc, 0x9a, 0x8e, 0xb3, 0x43, 0xb4,
      0xd6, 0xf5, 0x96, 0xc7, 0xd0, 0x0c, 0xac, 0x5d, 0xa8, 0x59, 0x4c, 0xaf,
      0x45, 0xb7, 0x20, 0x93, 0x97, 0x49, 0x62, 0x14, 0xc4, 0x2d, 0x85, 0x6a,
      0x01, 0x5c, 0xe5, 0x89, 0xbc, 0x9b, 0xa8, 0x65, 0xa4, 0xfa, 0xb5, 0xab,
      0x88, 0xa0, 0x1c, 0x7b, 0x5d, 0x09, 0xef, 0xaf, 0x87, 0x8f, 0xcb, 0x91,
      0x02, 0xfb, 0x38, 0x75, 0xa8, 0x38, 0x1a, 0xf2, 0x34, 0xd1, 0xc5, 0x93,
      0x07, 0x6e, 0x45, 0x22, 0x25, 0xa5, 0x6f, 0x51, 0x67, 0x4f, 0x34, 0x71,
      0x26, 0xd3, 0x00, 0x9b, 0x44, 0xdc, 0xbb, 0x00, 0x3a, 0x64, 0xd9, 0x5f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: small r and s^-1
    // tcID: 327
    {SEC_OID_SHA384,
     327,
     {0x30, 0x36, 0x02, 0x02, 0x01, 0x00, 0x02, 0x30, 0x48, 0x91, 0x22, 0x44,
      0x89, 0x12, 0x24, 0x48, 0x91, 0x22, 0x44, 0x89, 0x12, 0x24, 0x48, 0x91,
      0x22, 0x44, 0x89, 0x12, 0x24, 0x48, 0x91, 0x22, 0x34, 0x7c, 0xe7, 0x9b,
      0xc4, 0x37, 0xf4, 0xd0, 0x71, 0xaa, 0xa9, 0x2c, 0x7d, 0x6c, 0x88, 0x2a,
      0xe8, 0x73, 0x4d, 0xc1, 0x8c, 0xb0, 0xd5, 0x53},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x0b, 0xb0, 0x3f, 0xce, 0x3c, 0x01, 0xeb, 0xcf, 0x08, 0x73, 0xab, 0xd1,
      0x34, 0xa8, 0x68, 0x2f, 0x5f, 0xb8, 0xdb, 0xff, 0xa2, 0x2d, 0xa6, 0x74,
      0x04, 0x7e, 0x5c, 0x3e, 0x71, 0xe4, 0x3d, 0xe5, 0x82, 0xed, 0x6a, 0xbb,
      0x90, 0x8c, 0x2e, 0x4f, 0xaa, 0x5d, 0x96, 0x18, 0x62, 0x78, 0xb6, 0xc1,
      0xba, 0x3b, 0x22, 0x12, 0x3e, 0x68, 0xcc, 0xc5, 0x6f, 0x17, 0xdd, 0x79,
      0xff, 0x15, 0x56, 0x57, 0x06, 0xf7, 0x1a, 0x0b, 0x61, 0x23, 0xc7, 0x7a,
      0xf3, 0xcd, 0x88, 0xf0, 0xaf, 0x02, 0x4c, 0xc5, 0x25, 0x97, 0x81, 0x51,
      0x6e, 0xdc, 0xaf, 0x5f, 0xe9, 0x90, 0x64, 0x6e, 0x7b, 0x66, 0x99, 0x9d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: smallish r and s^-1
    // tcID: 328
    {SEC_OID_SHA384,
     328,
     {0x30, 0x3c, 0x02, 0x07, 0x2d, 0x9b, 0x4d, 0x34, 0x79, 0x52, 0xcd,
      0x02, 0x31, 0x00, 0xce, 0x75, 0x15, 0x12, 0x56, 0x1b, 0x6f, 0x57,
      0xc7, 0x53, 0x42, 0x84, 0x8a, 0x3f, 0xf9, 0x8c, 0xcf, 0x9c, 0x3f,
      0x02, 0x19, 0xb6, 0xb6, 0x8d, 0x00, 0x44, 0x9e, 0x6c, 0x97, 0x1a,
      0x85, 0xd2, 0xe2, 0xce, 0x73, 0x55, 0x4b, 0x59, 0x21, 0x9d, 0x54,
      0xd2, 0x08, 0x3b, 0x46, 0x32, 0x73, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x58, 0xf2, 0x46, 0x09, 0x0d, 0x5e, 0x49, 0x86, 0x3b, 0xc0, 0xbf, 0x2d,
      0x50, 0x1f, 0xf7, 0x2f, 0x55, 0x1c, 0x5f, 0x1c, 0x5e, 0x67, 0x9e, 0xb4,
      0x90, 0x64, 0xfd, 0x02, 0xe2, 0x21, 0xa2, 0x70, 0x73, 0x26, 0xec, 0x2d,
      0x14, 0x0b, 0xcc, 0x81, 0x7a, 0xfa, 0xad, 0x50, 0x65, 0x76, 0x15, 0x66,
      0x49, 0x7c, 0x82, 0x3f, 0xd7, 0x36, 0x88, 0x2c, 0xbf, 0x78, 0xfb, 0x92,
      0xb1, 0xa5, 0x58, 0x9b, 0x67, 0xe8, 0x06, 0x74, 0x97, 0xc7, 0x10, 0xa4,
      0xcb, 0xb3, 0x9d, 0xee, 0x2c, 0x54, 0x31, 0xbc, 0x45, 0xcf, 0xb9, 0x6c,
      0x9f, 0x84, 0x54, 0x38, 0x5c, 0x9f, 0x2b, 0x3e, 0xf2, 0xd3, 0xd3, 0x1a},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: 100-bit r and small s^-1
    // tcID: 329
    {SEC_OID_SHA384,
     329,
     {0x30, 0x41, 0x02, 0x0d, 0x10, 0x33, 0xe6, 0x7e, 0x37, 0xb3, 0x2b, 0x44,
      0x55, 0x80, 0xbf, 0x4e, 0xfb, 0x02, 0x30, 0x2a, 0xd5, 0x2a, 0xd5, 0x2a,
      0xd5, 0x2a, 0xd5, 0x2a, 0xd5, 0x2a, 0xd5, 0x2a, 0xd5, 0x2a, 0xd5, 0x2a,
      0xd5, 0x2a, 0xd5, 0x2a, 0xd5, 0x2a, 0xd5, 0x21, 0x5c, 0x51, 0xb3, 0x20,
      0xe4, 0x60, 0x54, 0x2f, 0x9c, 0xc3, 0x89, 0x68, 0xcc, 0xdf, 0x42, 0x63,
      0x68, 0x40, 0x04, 0xeb, 0x79, 0xa4, 0x52},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfc, 0x69, 0x84, 0xdd, 0x68, 0x30, 0xd1, 0x48, 0x5f, 0xb2, 0x58, 0x1a,
      0x45, 0xa7, 0x91, 0xd8, 0xdc, 0xa2, 0xc7, 0x27, 0xc7, 0x3d, 0x3d, 0x44,
      0xc8, 0x9f, 0x00, 0x82, 0xc1, 0x86, 0x8a, 0xf5, 0xca, 0x74, 0xb4, 0xca,
      0x4a, 0xe2, 0x28, 0x02, 0x64, 0x0a, 0x9e, 0xbf, 0xe8, 0xc7, 0xae, 0x12,
      0x99, 0x8d, 0x63, 0xa5, 0xb5, 0xad, 0x1b, 0x72, 0xb8, 0x99, 0xf0, 0xb1,
      0x32, 0xe4, 0x95, 0x2a, 0xaa, 0x19, 0xd4, 0x1f, 0xde, 0xea, 0x48, 0xb1,
      0xed, 0x6b, 0x83, 0x58, 0xdd, 0x1d, 0xb2, 0x07, 0xfd, 0x66, 0xe0, 0x14,
      0x53, 0xad, 0x40, 0xf6, 0x7b, 0x83, 0x6a, 0xdc, 0x80, 0x2d, 0x5f, 0xe8},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: small r and 100 bit s^-1
    // tcID: 330
    {SEC_OID_SHA384,
     330,
     {0x30, 0x36, 0x02, 0x02, 0x01, 0x00, 0x02, 0x30, 0x77, 0xa1, 0x72, 0xdf,
      0xe3, 0x7a, 0x2c, 0x53, 0xf0, 0xb9, 0x2a, 0xb6, 0x0f, 0x0a, 0x8f, 0x08,
      0x5f, 0x49, 0xdb, 0xfd, 0x93, 0x07, 0x19, 0xd6, 0xf9, 0xe5, 0x87, 0xea,
      0x68, 0xae, 0x57, 0xcb, 0x49, 0xcd, 0x35, 0xa8, 0x8c, 0xf8, 0xc6, 0xac,
      0xec, 0x02, 0xf0, 0x57, 0xa3, 0x80, 0x7a, 0x5b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x1b, 0x8d, 0xef, 0x59, 0x22, 0x30, 0x3d, 0x64, 0x7e, 0x8e, 0xb0, 0x7e,
      0x3b, 0xad, 0x92, 0xf9, 0x24, 0xb7, 0x9b, 0x76, 0x9e, 0xef, 0x16, 0x8e,
      0x75, 0x41, 0xde, 0x1f, 0x4e, 0x0d, 0x28, 0xae, 0x97, 0x33, 0xeb, 0x98,
      0xcf, 0x8a, 0x1f, 0xb6, 0xdd, 0x52, 0xca, 0x02, 0xc8, 0xc7, 0x5b, 0x51,
      0xc7, 0xaa, 0x4b, 0xf6, 0x79, 0xd4, 0x9d, 0x81, 0x14, 0x12, 0x20, 0x74,
      0xda, 0x8f, 0x60, 0x44, 0xa4, 0x27, 0x37, 0x17, 0x96, 0xa5, 0x65, 0x4a,
      0x61, 0x06, 0x16, 0x2d, 0x5f, 0x68, 0x6a, 0xbb, 0x73, 0xeb, 0xd8, 0x96,
      0xab, 0x08, 0xc7, 0x06, 0x26, 0x87, 0xf1, 0x21, 0x71, 0xfb, 0xe4, 0xa3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: 100-bit r and s^-1
    // tcID: 331
    {SEC_OID_SHA384,
     331,
     {0x30, 0x41, 0x02, 0x0d, 0x06, 0x25, 0x22, 0xbb, 0xd3, 0xec, 0xbe, 0x7c,
      0x39, 0xe9, 0x3e, 0x7c, 0x24, 0x02, 0x30, 0x77, 0xa1, 0x72, 0xdf, 0xe3,
      0x7a, 0x2c, 0x53, 0xf0, 0xb9, 0x2a, 0xb6, 0x0f, 0x0a, 0x8f, 0x08, 0x5f,
      0x49, 0xdb, 0xfd, 0x93, 0x07, 0x19, 0xd6, 0xf9, 0xe5, 0x87, 0xea, 0x68,
      0xae, 0x57, 0xcb, 0x49, 0xcd, 0x35, 0xa8, 0x8c, 0xf8, 0xc6, 0xac, 0xec,
      0x02, 0xf0, 0x57, 0xa3, 0x80, 0x7a, 0x5b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x17, 0x34, 0xa0, 0x39, 0xa8, 0x8a, 0x16, 0xc2, 0xff, 0x4a, 0xa9, 0x7d,
      0x23, 0x99, 0x12, 0x1f, 0x56, 0xf5, 0x2e, 0xf0, 0x1e, 0xd5, 0xe5, 0x08,
      0x87, 0xf7, 0x36, 0xf6, 0x5b, 0x6e, 0x51, 0xd6, 0xe8, 0x78, 0x6a, 0xbb,
      0x4e, 0x06, 0x3d, 0xa5, 0xd1, 0xba, 0x81, 0x2d, 0xff, 0x99, 0x84, 0x03,
      0xcc, 0xd6, 0x98, 0xe6, 0xc2, 0x96, 0xd5, 0xcd, 0x69, 0x17, 0x8f, 0x8a,
      0x82, 0x48, 0x1a, 0x86, 0x5d, 0xa3, 0x31, 0x62, 0x7f, 0x1c, 0x4b, 0x32,
      0x4f, 0xbc, 0x02, 0xb3, 0x6e, 0x8b, 0x5e, 0xd5, 0x8a, 0x31, 0xf7, 0x28,
      0xe9, 0x04, 0xd2, 0x03, 0xa3, 0x88, 0x75, 0x53, 0x02, 0x19, 0x57, 0x65},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: r and s^-1 are close to n
    // tcID: 332
    {SEC_OID_SHA384,
     332,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37, 0x2d,
      0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a, 0xec, 0xec, 0x19,
      0x6a, 0xcc, 0xc5, 0x28, 0xf3, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51,
      0x67, 0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9,
      0xa4, 0x08, 0x78, 0xee, 0xec, 0x63, 0x26},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x52, 0xca, 0x47, 0xdd, 0xa9, 0x91, 0x72, 0xcb, 0x83, 0x21, 0x49, 0x5a,
      0xcf, 0x98, 0x85, 0x48, 0x29, 0x59, 0x88, 0xec, 0x97, 0x3c, 0x1b, 0x4e,
      0xa9, 0x46, 0x2c, 0x53, 0xe5, 0x76, 0x8a, 0x70, 0x4a, 0x93, 0x64, 0x10,
      0xee, 0x84, 0x7b, 0x5d, 0xbf, 0x1e, 0x9d, 0x0c, 0x13, 0x1d, 0xa6, 0xc7,
      0x87, 0xa4, 0x70, 0x27, 0xe6, 0x65, 0x57, 0x92, 0xeb, 0x00, 0x2d, 0x42,
      0x28, 0xee, 0x72, 0xf7, 0xc8, 0x14, 0xc9, 0xa0, 0xce, 0xcb, 0xff, 0x26,
      0x79, 0x48, 0xf8, 0x1c, 0x99, 0x03, 0xac, 0x10, 0xeb, 0x35, 0xf6, 0xcb,
      0x86, 0x36, 0x92, 0x24, 0xed, 0x60, 0x98, 0x11, 0xcd, 0xf3, 0x90, 0xf4},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: s == 1
    // tcID: 333
    {SEC_OID_SHA384,
     333,
     {0x30, 0x35, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51,
      0x67, 0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28,
      0xf9, 0xa4, 0x08, 0x78, 0xee, 0xec, 0x63, 0x26, 0x02, 0x01, 0x01},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbd, 0x3d, 0x91, 0xf0, 0x03, 0xe1, 0x8a, 0xdb, 0xea, 0x73, 0x07, 0x9d,
      0x4e, 0xba, 0x23, 0xb9, 0x1f, 0xc1, 0x7f, 0xce, 0xc1, 0x4c, 0x9e, 0xb1,
      0x5a, 0x19, 0x3f, 0xbc, 0x9c, 0xa3, 0x9c, 0x8c, 0x74, 0x7c, 0xd7, 0xa2,
      0xc9, 0x62, 0x3e, 0x05, 0xdd, 0x58, 0x7c, 0xcb, 0xb8, 0xab, 0x4c, 0x44,
      0x3a, 0xdb, 0x0a, 0x07, 0x06, 0xaa, 0x5e, 0xa7, 0xa6, 0x80, 0x42, 0x08,
      0x2f, 0xcc, 0xef, 0xc9, 0x79, 0x61, 0x2a, 0x7a, 0x1a, 0x3d, 0x69, 0x4b,
      0x00, 0x79, 0x3b, 0x03, 0xf8, 0x9b, 0xff, 0x86, 0x6a, 0x8b, 0x97, 0xc8,
      0xe7, 0x79, 0x90, 0xc2, 0x93, 0x60, 0xce, 0x79, 0x50, 0x36, 0xc7, 0x64},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: s == 0
    // tcID: 334
    {SEC_OID_SHA384,
     334,
     {0x30, 0x35, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51,
      0x67, 0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28,
      0xf9, 0xa4, 0x08, 0x78, 0xee, 0xec, 0x63, 0x26, 0x02, 0x01, 0x00},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbd, 0x3d, 0x91, 0xf0, 0x03, 0xe1, 0x8a, 0xdb, 0xea, 0x73, 0x07, 0x9d,
      0x4e, 0xba, 0x23, 0xb9, 0x1f, 0xc1, 0x7f, 0xce, 0xc1, 0x4c, 0x9e, 0xb1,
      0x5a, 0x19, 0x3f, 0xbc, 0x9c, 0xa3, 0x9c, 0x8c, 0x74, 0x7c, 0xd7, 0xa2,
      0xc9, 0x62, 0x3e, 0x05, 0xdd, 0x58, 0x7c, 0xcb, 0xb8, 0xab, 0x4c, 0x44,
      0x3a, 0xdb, 0x0a, 0x07, 0x06, 0xaa, 0x5e, 0xa7, 0xa6, 0x80, 0x42, 0x08,
      0x2f, 0xcc, 0xef, 0xc9, 0x79, 0x61, 0x2a, 0x7a, 0x1a, 0x3d, 0x69, 0x4b,
      0x00, 0x79, 0x3b, 0x03, 0xf8, 0x9b, 0xff, 0x86, 0x6a, 0x8b, 0x97, 0xc8,
      0xe7, 0x79, 0x90, 0xc2, 0x93, 0x60, 0xce, 0x79, 0x50, 0x36, 0xc7, 0x64},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point at infinity during verify
    // tcID: 335
    {SEC_OID_SHA384,
     335,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xe3, 0xb1, 0xa6, 0xc0, 0xfa, 0x1b, 0x96, 0xef,
      0xac, 0x0d, 0x06, 0xd9, 0x24, 0x58, 0x53, 0xbd, 0x76, 0x76, 0x0c, 0xb5,
      0x66, 0x62, 0x94, 0xb9, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67,
      0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4,
      0x08, 0x78, 0xee, 0xec, 0x63, 0x26},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf8, 0x96, 0x35, 0x3c, 0xc3, 0xa8, 0xaf, 0xdd, 0x54, 0x3e, 0xc3, 0xae,
      0xf0, 0x62, 0xca, 0x97, 0xbc, 0x32, 0xed, 0x17, 0x24, 0xea, 0x38, 0xb9,
      0x40, 0xb8, 0xc0, 0xea, 0x0e, 0x23, 0xb3, 0x41, 0x87, 0xaf, 0xbe, 0x70,
      0xda, 0xf8, 0xdb, 0xaa, 0x5b, 0x51, 0x15, 0x57, 0xe5, 0xd2, 0xbd, 0xda,
      0xc4, 0xbd, 0x26, 0x5d, 0xa6, 0x7c, 0xee, 0xaf, 0xca, 0x63, 0x6f, 0x6f,
      0x4c, 0x04, 0x72, 0xf2, 0x2a, 0x9d, 0x02, 0xe2, 0x28, 0x91, 0x84, 0xf7,
      0x3b, 0xbb, 0x70, 0x0a, 0xe8, 0xfc, 0x92, 0x1e, 0xff, 0x49, 0x20, 0xf2,
      0x90, 0xbf, 0xcb, 0x49, 0xfb, 0xb2, 0x32, 0xcc, 0x13, 0xa2, 0x10, 0x28},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: edge case for signature malleability
    // tcID: 336
    {SEC_OID_SHA384,
     336,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xe3, 0xb1, 0xa6, 0xc0, 0xfa, 0x1b, 0x96, 0xef,
      0xac, 0x0d, 0x06, 0xd9, 0x24, 0x58, 0x53, 0xbd, 0x76, 0x76, 0x0c, 0xb5,
      0x66, 0x62, 0x94, 0xb9, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xb1, 0xa6, 0xc0, 0xfa, 0x1b,
      0x96, 0xef, 0xac, 0x0d, 0x06, 0xd9, 0x24, 0x58, 0x53, 0xbd, 0x76, 0x76,
      0x0c, 0xb5, 0x66, 0x62, 0x94, 0xb9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x37, 0x0d, 0x9e, 0x2e, 0x31, 0xc7, 0x12, 0xc8, 0x02, 0x80, 0x92, 0xf8,
      0x02, 0x31, 0x9d, 0x7f, 0xdf, 0x5b, 0x33, 0x19, 0xa8, 0x51, 0x8d, 0x08,
      0xbe, 0xd3, 0x89, 0x15, 0x08, 0xc7, 0x06, 0x0c, 0xfe, 0x22, 0x36, 0xe1,
      0x8f, 0xa1, 0x4f, 0xe0, 0x77, 0x09, 0x3c, 0xea, 0xe6, 0x33, 0xe5, 0x43,
      0x0f, 0xd7, 0x9a, 0xac, 0xf9, 0xd1, 0x6e, 0xcc, 0x19, 0xb1, 0x2d, 0x60,
      0xfb, 0xa4, 0x99, 0x8d, 0xfc, 0x68, 0x27, 0x02, 0xec, 0x7c, 0x8b, 0xdd,
      0x4a, 0x59, 0x00, 0x35, 0x77, 0x3b, 0x8c, 0x9c, 0x57, 0x0a, 0xc7, 0xdc,
      0xd4, 0x14, 0xe0, 0x32, 0x52, 0xf7, 0xa0, 0xe6, 0xf5, 0x3b, 0x58, 0x63},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for signature malleability
    // tcID: 337
    {SEC_OID_SHA384,
     337,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xe3, 0xb1, 0xa6, 0xc0, 0xfa, 0x1b, 0x96, 0xef,
      0xac, 0x0d, 0x06, 0xd9, 0x24, 0x58, 0x53, 0xbd, 0x76, 0x76, 0x0c, 0xb5,
      0x66, 0x62, 0x94, 0xb9, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xb1, 0xa6, 0xc0, 0xfa, 0x1b,
      0x96, 0xef, 0xac, 0x0d, 0x06, 0xd9, 0x24, 0x58, 0x53, 0xbd, 0x76, 0x76,
      0x0c, 0xb5, 0x66, 0x62, 0x94, 0xba},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x94, 0x1e, 0x6c, 0xfa, 0x35, 0x6e, 0x57, 0x2d, 0xcc, 0xca, 0xeb, 0x59,
      0x4b, 0x06, 0x95, 0x5d, 0x99, 0xdc, 0x4b, 0xf0, 0x79, 0x58, 0xfc, 0x98,
      0xff, 0xa1, 0x7d, 0xe1, 0x1c, 0x75, 0x21, 0xbf, 0x2c, 0x7a, 0xa8, 0xff,
      0x26, 0x09, 0x52, 0xfc, 0xb7, 0xaa, 0xc0, 0x78, 0xed, 0xe6, 0x7b, 0x47,
      0x90, 0xa7, 0x8a, 0x02, 0x96, 0xb0, 0x41, 0xa1, 0x0f, 0x00, 0x3d, 0xf1,
      0x99, 0x8d, 0xa4, 0xcc, 0x4a, 0x16, 0x14, 0xeb, 0xcb, 0xf5, 0xd2, 0x39,
      0x43, 0x1f, 0x33, 0xd9, 0x0d, 0x30, 0x23, 0xed, 0xc1, 0x80, 0x2e, 0x8d,
      0xb6, 0xda, 0xbc, 0xba, 0xe6, 0x7c, 0xc3, 0x14, 0xda, 0x2a, 0xab, 0xab},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u1 == 1
    // tcID: 338
    {SEC_OID_SHA384,
     338,
     {0x30, 0x65, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67, 0xb9, 0xf5,
      0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4, 0x08, 0x78,
      0xee, 0xec, 0x63, 0x26, 0x02, 0x31, 0x00, 0xf9, 0xb1, 0x27, 0xf0, 0xd8,
      0x1e, 0xbc, 0xd1, 0x7b, 0x7b, 0xa0, 0xea, 0x13, 0x1c, 0x66, 0x0d, 0x34,
      0x0b, 0x05, 0xce, 0x55, 0x7c, 0x82, 0x16, 0x0e, 0x0f, 0x79, 0x3d, 0xe0,
      0x7d, 0x38, 0x17, 0x90, 0x23, 0x94, 0x28, 0x71, 0xac, 0xb7, 0x00, 0x2d,
      0xfa, 0xfd, 0xff, 0xfc, 0x8d, 0xea, 0xce},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x3e, 0xcf, 0xd5, 0x8a, 0x3c, 0xe5, 0x83, 0x86, 0x6e, 0x04, 0x71, 0xd1,
      0x6e, 0xb3, 0xc1, 0x0a, 0x41, 0x1e, 0xc3, 0xb8, 0x67, 0x1f, 0x3a, 0x04,
      0x76, 0x9b, 0x1e, 0xd8, 0x46, 0x4a, 0x71, 0xcf, 0x1c, 0x76, 0xd8, 0xd9,
      0xb7, 0xe3, 0x67, 0x0b, 0xbe, 0x71, 0x2d, 0x6f, 0x55, 0x4a, 0x93, 0x83,
      0xd9, 0x80, 0xd8, 0xbe, 0xdf, 0x57, 0x47, 0x0d, 0x6b, 0x45, 0xcc, 0x1a,
      0xd0, 0xc6, 0x42, 0x6d, 0xc7, 0x0a, 0x0e, 0x4b, 0xe9, 0x01, 0x10, 0x6a,
      0x36, 0x66, 0x3b, 0xfc, 0xab, 0x04, 0xfc, 0xb8, 0x60, 0x08, 0x77, 0x7b,
      0x92, 0x44, 0x51, 0x20, 0xd5, 0xe3, 0x64, 0x1d, 0x97, 0x39, 0x63, 0x62},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u1 == n - 1
    // tcID: 339
    {SEC_OID_SHA384,
     339,
     {0x30, 0x64, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67, 0xb9, 0xf5,
      0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4, 0x08, 0x78,
      0xee, 0xec, 0x63, 0x26, 0x02, 0x30, 0x06, 0x4e, 0xd8, 0x0f, 0x27, 0xe1,
      0x43, 0x2e, 0x84, 0x84, 0x5f, 0x15, 0xec, 0xe3, 0x99, 0xf2, 0xcb, 0xf4,
      0xfa, 0x31, 0xaa, 0x83, 0x7d, 0xe9, 0xb9, 0x53, 0xd4, 0x44, 0x13, 0xb9,
      0xf5, 0xc7, 0xc7, 0xf6, 0x79, 0x89, 0xd7, 0x03, 0xf0, 0x7a, 0xbe, 0xf1,
      0x1b, 0x6a, 0xd0, 0x37, 0x3e, 0xa5},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x41, 0x50, 0xcc, 0xd0, 0xfa, 0x45, 0xaa, 0x2e, 0xf6, 0xb5, 0x04, 0x2d,
      0xdb, 0xb1, 0xb8, 0x7c, 0x5f, 0xfd, 0x11, 0x15, 0xa8, 0xfe, 0x59, 0x95,
      0x64, 0x19, 0x48, 0xac, 0xda, 0x82, 0xa7, 0xb1, 0x90, 0x76, 0x2d, 0x84,
      0x35, 0x2c, 0xd7, 0x4d, 0x1c, 0xa0, 0x1e, 0x79, 0xf6, 0x8f, 0x9c, 0xb4,
      0xeb, 0x11, 0xbe, 0x9d, 0x49, 0x4c, 0x18, 0x1c, 0x15, 0x6e, 0x23, 0xe7,
      0x7e, 0x53, 0x2b, 0xdf, 0x0a, 0x20, 0xc3, 0xcc, 0x74, 0xba, 0x8c, 0x29,
      0xb1, 0xf3, 0xeb, 0x2b, 0xd9, 0x91, 0x29, 0xee, 0x0d, 0x70, 0xff, 0x0d,
      0x59, 0x3f, 0x0d, 0x7a, 0x6d, 0x68, 0x87, 0xe7, 0xc5, 0x59, 0x30, 0xd2},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u2 == 1
    // tcID: 340
    {SEC_OID_SHA384,
     340,
     {0x30, 0x64, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67, 0xb9, 0xf5,
      0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4, 0x08, 0x78,
      0xee, 0xec, 0x63, 0x26, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67,
      0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4,
      0x08, 0x78, 0xee, 0xec, 0x63, 0x26},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe7, 0x8f, 0xe2, 0xc1, 0x1b, 0xea, 0xc7, 0x09, 0x0e, 0xe0, 0xaf, 0x7f,
      0xed, 0x46, 0x9a, 0x8c, 0xce, 0xbd, 0x3c, 0xcc, 0xc4, 0xee, 0x9f, 0xcc,
      0xc8, 0xef, 0x3f, 0xc0, 0x45, 0x5b, 0x69, 0xaa, 0xa0, 0x82, 0xdc, 0x13,
      0xe1, 0xd8, 0x4f, 0x34, 0x02, 0x6c, 0xb6, 0xf0, 0xaf, 0x9e, 0x99, 0x2f,
      0xf3, 0x4e, 0xbb, 0xa7, 0x1b, 0xf3, 0xa4, 0x05, 0x0b, 0xf2, 0x8e, 0x40,
      0x84, 0xb5, 0xc5, 0xf5, 0xd4, 0x09, 0x8e, 0xc4, 0x6f, 0x10, 0xa3, 0x1b,
      0x02, 0xfb, 0x4b, 0xf2, 0x0c, 0xc9, 0x36, 0x2f, 0x6f, 0x02, 0xa6, 0x6e,
      0x80, 0x2f, 0x81, 0x75, 0x07, 0x53, 0x5f, 0xac, 0x3e, 0xc0, 0xb0, 0x99},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: u2 == n - 1
    // tcID: 341
    {SEC_OID_SHA384,
     341,
     {0x30, 0x65, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67, 0xb9, 0xf5,
      0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4, 0x08, 0x78,
      0xee, 0xec, 0x63, 0x26, 0x02, 0x31, 0x00, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
      0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x84, 0xec, 0xde, 0x56, 0xa2,
      0xcf, 0x73, 0xea, 0x3a, 0xbc, 0x09, 0x21, 0x85, 0xcb, 0x1a, 0x51, 0xf3,
      0x48, 0x10, 0xf1, 0xdd, 0xd8, 0xc6, 0x4d},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xee, 0x24, 0xab, 0x8a, 0x34, 0xd0, 0x5a, 0xf6, 0x84, 0x93, 0x93, 0x57,
      0xf3, 0x27, 0x59, 0xcc, 0x5a, 0x14, 0xf3, 0xc7, 0x17, 0x52, 0x9a, 0x20,
      0xae, 0xa8, 0xe0, 0xc5, 0x96, 0x5d, 0x8a, 0x41, 0xe6, 0x89, 0x25, 0xf6,
      0x88, 0x47, 0x19, 0x94, 0xb7, 0x20, 0x21, 0xba, 0x51, 0xb2, 0x8c, 0x09,
      0x0a, 0x55, 0x69, 0x3c, 0x92, 0xad, 0x0c, 0xba, 0xe9, 0xed, 0xcf, 0x51,
      0x5e, 0x2b, 0x4c, 0x06, 0x0b, 0x88, 0x8d, 0x82, 0xc8, 0x1e, 0x4a, 0x3b,
      0x6a, 0x17, 0x3b, 0x62, 0xed, 0x04, 0xa4, 0x6f, 0xa9, 0x5d, 0xb1, 0xa2,
      0xf3, 0x94, 0x99, 0x80, 0xfb, 0xa2, 0xe3, 0x71, 0x26, 0x3c, 0x4f, 0xa9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 342
    {SEC_OID_SHA384,
     342,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x53, 0x3b, 0x0d, 0x50, 0x48, 0x0a,
      0x3e, 0xf0, 0x7e, 0x7e, 0x8a, 0xf8, 0xb1, 0x09, 0x77, 0x59, 0xbc, 0x03,
      0xac, 0x9a, 0x1c, 0x7e, 0xd6, 0x07, 0x5a, 0x05, 0x28, 0x69, 0xf5, 0x7f,
      0x12, 0xb2, 0x85, 0x61, 0x31, 0x62, 0xd0, 0x8e, 0xe7, 0xaa, 0xb9, 0xfe,
      0x54, 0xaa, 0xa9, 0x84, 0xa3, 0x9a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x3d, 0x2e, 0x91, 0x60, 0x55, 0xc9, 0x2e, 0x1b, 0x36, 0x13, 0x3f, 0x59,
      0x37, 0xb3, 0x7c, 0x1b, 0x01, 0x02, 0x83, 0x4e, 0xb7, 0x70, 0x08, 0xa3,
      0xba, 0x9c, 0x3d, 0xa4, 0x46, 0xe9, 0x06, 0x59, 0x71, 0xd6, 0x8b, 0xa9,
      0x13, 0x09, 0x18, 0x51, 0xe1, 0x0c, 0xff, 0x5b, 0x4c, 0xd8, 0x75, 0xc1,
      0x39, 0xaa, 0x7a, 0xad, 0xfc, 0x2c, 0xaf, 0x71, 0x07, 0xb1, 0x7a, 0xe1,
      0xae, 0xa8, 0xb2, 0x99, 0xd6, 0x1b, 0xf1, 0x5a, 0xca, 0x0c, 0xb3, 0xfd,
      0x6f, 0x1f, 0xfd, 0xe8, 0x19, 0x2b, 0xfe, 0x58, 0xf0, 0x82, 0x2b, 0xbb,
      0xc1, 0xf5, 0x5b, 0xdd, 0xf6, 0xb4, 0xfe, 0x9c, 0x8f, 0x2b, 0x0e, 0xac},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 343
    {SEC_OID_SHA384,
     343,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xd4, 0x9a, 0x25, 0x39, 0x86,
      0xbb, 0xaa, 0x8c, 0xe9, 0xc3, 0xd3, 0x80, 0x83, 0x13, 0xd3, 0x9c, 0x3b,
      0x95, 0x0a, 0x47, 0x83, 0x72, 0xed, 0xc0, 0x09, 0xbc, 0x05, 0x66, 0xb7,
      0x3b, 0xe7, 0xb0, 0x5d, 0xad, 0x07, 0x37, 0xe1, 0x69, 0x60, 0x25, 0x7c,
      0xc1, 0x6d, 0xb6, 0xec, 0x6c, 0x62, 0x0f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xae, 0x59, 0x66, 0x97, 0x42, 0x7a, 0xa2, 0x50, 0x15, 0x6c, 0x05, 0xac,
      0x43, 0x38, 0xe4, 0x89, 0x80, 0xa7, 0xf0, 0x93, 0xea, 0x1f, 0x1f, 0xe6,
      0x70, 0x98, 0xb4, 0x3f, 0x65, 0x39, 0xc1, 0xb2, 0x0a, 0xe7, 0x43, 0x38,
      0xf9, 0xbf, 0x27, 0x0d, 0x33, 0x66, 0x3c, 0x50, 0xab, 0xe8, 0xfd, 0x00,
      0x1c, 0xa6, 0xa5, 0x27, 0x32, 0xdb, 0x74, 0xab, 0x15, 0xd2, 0xf2, 0x49,
      0xa3, 0xd8, 0x39, 0x08, 0x0f, 0x89, 0x83, 0x67, 0xdf, 0xd6, 0x49, 0x92,
      0xcd, 0xce, 0x27, 0x08, 0xde, 0xaa, 0xd5, 0x23, 0xa2, 0xa2, 0x36, 0xb4,
      0x34, 0x00, 0x42, 0x42, 0x41, 0xc9, 0x1a, 0x35, 0xb5, 0x30, 0xfa, 0x50},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 344
    {SEC_OID_SHA384,
     344,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x28, 0x50, 0x90, 0xb0, 0xd6, 0xa6,
      0x82, 0x0b, 0xbb, 0xa3, 0x94, 0xef, 0xbe, 0xe5, 0xc2, 0x4a, 0x22, 0x81,
      0xe8, 0x25, 0xd2, 0xf6, 0xc5, 0x5f, 0xb7, 0xa8, 0x5b, 0x82, 0x51, 0xdb,
      0x00, 0xf7, 0x5a, 0xb0, 0x7c, 0xc9, 0x93, 0xce, 0xaf, 0x66, 0x4f, 0x3c,
      0x11, 0x6b, 0xaf, 0x34, 0xb0, 0x21},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x88, 0x73, 0x8f, 0x99, 0x81, 0xdd, 0x4d, 0x1f, 0xab, 0xb6, 0x0a, 0xd8,
      0x3c, 0x2d, 0xd6, 0xdf, 0xc9, 0xda, 0x30, 0x22, 0x09, 0xae, 0x3e, 0x53,
      0x49, 0x8a, 0x88, 0x3b, 0x6e, 0x39, 0xa3, 0x8b, 0xea, 0xd9, 0xb0, 0x27,
      0x09, 0xf3, 0x52, 0xd3, 0xe6, 0xb6, 0x57, 0x81, 0x54, 0xea, 0xb2, 0x52,
      0x93, 0x88, 0xa0, 0x5c, 0x6b, 0x9f, 0x3a, 0x40, 0x28, 0xab, 0xb9, 0x95,
      0x0a, 0x51, 0xf5, 0x26, 0x4e, 0xcd, 0x75, 0x80, 0xa4, 0x23, 0xfd, 0xec,
      0x94, 0x72, 0xfa, 0xee, 0xb5, 0x7f, 0x92, 0xe3, 0x1c, 0x46, 0xbe, 0xf2,
      0xa7, 0x81, 0xfe, 0x5e, 0xda, 0xd0, 0x26, 0x00, 0x9f, 0x19, 0x82, 0x62},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 345
    {SEC_OID_SHA384,
     345,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xb3, 0x9a, 0xf4, 0xa8, 0x1e,
      0xe4, 0xae, 0x79, 0x06, 0x4e, 0xd8, 0x0f, 0x27, 0xe1, 0x43, 0x2e, 0x84,
      0x84, 0x5f, 0x15, 0xec, 0xe3, 0x99, 0xf2, 0xa4, 0x3d, 0x25, 0x05, 0xa0,
      0xa8, 0xc7, 0x2c, 0x57, 0x31, 0xf4, 0xfd, 0x96, 0x74, 0x20, 0xb1, 0x00,
      0x0e, 0x3f, 0x75, 0x50, 0x2e, 0xd7, 0xb7},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf4, 0x21, 0x54, 0x13, 0x11, 0xc9, 0x4f, 0xdd, 0x79, 0xfc, 0x29, 0x8f,
      0x8a, 0xb1, 0xa3, 0xad, 0xfd, 0x08, 0x02, 0x9f, 0xda, 0xd4, 0x39, 0xa9,
      0x4d, 0x4c, 0xea, 0x11, 0xf7, 0xe7, 0x99, 0xbc, 0x43, 0x96, 0x09, 0xf2,
      0xfb, 0x7b, 0xe3, 0xf3, 0x49, 0xd5, 0x5e, 0x48, 0x4d, 0x0a, 0x0d, 0x36,
      0xb3, 0x53, 0x30, 0xbb, 0xdb, 0xec, 0x1e, 0x75, 0xf2, 0x98, 0x44, 0x83,
      0xd9, 0x6b, 0xf2, 0x10, 0xd7, 0x22, 0xc1, 0x83, 0x02, 0x92, 0xff, 0xc3,
      0x5a, 0x2f, 0x6a, 0x21, 0xa4, 0xb5, 0x05, 0x19, 0xf5, 0x65, 0xf0, 0x24,
      0xbb, 0xcc, 0xc9, 0x72, 0x28, 0xa2, 0xf8, 0xad, 0x8f, 0xad, 0xc0, 0xd5},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 346
    {SEC_OID_SHA384,
     346,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xaf, 0x4a, 0x81, 0xee, 0x4a,
      0xe7, 0x90, 0x64, 0xed, 0x80, 0xf2, 0x7e, 0x14, 0x32, 0xe8, 0x48, 0x45,
      0xf1, 0x5e, 0xce, 0x39, 0x9f, 0x2c, 0xbf, 0x28, 0xdf, 0x82, 0x9c, 0xcd,
      0x30, 0xf5, 0xef, 0x62, 0xec, 0x23, 0x95, 0x7b, 0x83, 0x7d, 0x73, 0xfe,
      0x4e, 0x15, 0x6e, 0xdc, 0xcd, 0x44, 0x65},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x39, 0x9b, 0xe4, 0xcf, 0xc4, 0x39, 0xf9, 0x4f, 0x24, 0x21, 0xcb, 0xd3,
      0x4c, 0x2c, 0xd9, 0x0b, 0xae, 0x53, 0xeb, 0x60, 0xdd, 0xfa, 0xfc, 0xa5,
      0x2f, 0x72, 0x75, 0xd1, 0x65, 0xd1, 0x4f, 0xa6, 0x59, 0xb6, 0x36, 0x71,
      0x3b, 0x5d, 0x4b, 0x39, 0xe6, 0x2f, 0xd4, 0x8b, 0xae, 0x14, 0x1d, 0x0e,
      0x1b, 0x23, 0xe3, 0xb4, 0xf0, 0xc2, 0x02, 0xed, 0x7b, 0x59, 0xdb, 0x78,
      0xa3, 0x5c, 0x12, 0xac, 0x69, 0x8c, 0x60, 0x3e, 0xab, 0x14, 0x4f, 0xd0,
      0x9a, 0xc2, 0xed, 0x8f, 0x44, 0x95, 0xf6, 0x07, 0xe4, 0xd2, 0xc8, 0x7a,
      0x23, 0xce, 0x2e, 0xc3, 0x3e, 0x41, 0x0c, 0xa4, 0x7e, 0xcc, 0x25, 0x55},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 347
    {SEC_OID_SHA384,
     347,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x5e, 0x95, 0x03, 0xdc, 0x95, 0xcf,
      0x20, 0xc9, 0xdb, 0x01, 0xe4, 0xfc, 0x28, 0x65, 0xd0, 0x90, 0x8b, 0xe2,
      0xbd, 0x9c, 0x73, 0x3e, 0x59, 0x7e, 0x8a, 0x5b, 0xb7, 0xb7, 0xa6, 0x2a,
      0xbd, 0xff, 0x6d, 0xbe, 0x39, 0x78, 0xae, 0x56, 0x53, 0x6d, 0x0f, 0xb0,
      0x11, 0x72, 0xec, 0xd5, 0x5f, 0x57},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x15, 0x78, 0xbb, 0xff, 0x72, 0x13, 0x7c, 0x4b, 0xca, 0x33, 0xd7, 0x38,
      0x5a, 0x89, 0x2b, 0xe9, 0x4c, 0xb0, 0x59, 0xf9, 0x09, 0x1d, 0xdf, 0xe8,
      0x90, 0x34, 0x5f, 0x71, 0x2a, 0x9f, 0xba, 0x5f, 0xc7, 0x70, 0x84, 0xce,
      0xc1, 0x10, 0x84, 0xed, 0x04, 0x84, 0x91, 0x60, 0x4a, 0x07, 0xf6, 0x6c,
      0x76, 0xbb, 0xaa, 0x87, 0x2f, 0x07, 0x10, 0xd8, 0x2a, 0x08, 0xd9, 0xdd,
      0xdd, 0x83, 0x3c, 0x7b, 0xe7, 0xc7, 0xe8, 0xe2, 0x65, 0xf4, 0x91, 0x45,
      0x15, 0x7e, 0xb4, 0xe8, 0xe8, 0x28, 0x00, 0x76, 0xa3, 0x7e, 0xe5, 0x87,
      0x32, 0x71, 0xdb, 0x51, 0x00, 0x34, 0xda, 0x19, 0xda, 0x24, 0x41, 0x5b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 348
    {SEC_OID_SHA384,
     348,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x1e, 0xe4, 0xae, 0x79, 0x06, 0x4e,
      0xd8, 0x0f, 0x27, 0xe1, 0x43, 0x2e, 0x84, 0x84, 0x5f, 0x15, 0xec, 0xe3,
      0x99, 0xf2, 0xcb, 0xf4, 0xfa, 0x31, 0xa3, 0xae, 0x8e, 0xda, 0xb8, 0x4d,
      0xc3, 0x33, 0x0a, 0x39, 0xf7, 0x09, 0x38, 0xe3, 0x91, 0x2b, 0xd5, 0x97,
      0x53, 0xde, 0x5a, 0xed, 0x30, 0x88},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x33, 0xba, 0x45, 0x1c, 0x85, 0xe7, 0x29, 0x05, 0x8f, 0x83, 0x04, 0x10,
      0x77, 0xa4, 0x69, 0x5e, 0xb4, 0x7d, 0xf9, 0x3e, 0x71, 0x8b, 0x09, 0xa4,
      0x61, 0x8c, 0x75, 0x3a, 0xc8, 0x03, 0xcd, 0x75, 0xc1, 0xa9, 0x12, 0x90,
      0xc2, 0xff, 0x5a, 0x63, 0x53, 0x89, 0xd0, 0x71, 0x49, 0x57, 0x1d, 0xab,
      0x1f, 0xc7, 0xd8, 0xa7, 0x17, 0x76, 0x85, 0x1f, 0xf2, 0x44, 0xff, 0x63,
      0x2f, 0xe6, 0xf9, 0x2e, 0x16, 0x52, 0xe5, 0x28, 0x48, 0x93, 0xc4, 0x24,
      0x4f, 0xe7, 0x75, 0xd8, 0xef, 0xc5, 0x89, 0xd8, 0x23, 0xdd, 0x03, 0xf3,
      0x91, 0x90, 0x27, 0xf0, 0x04, 0x53, 0x7b, 0xd8, 0xee, 0x09, 0xf3, 0xa3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 349
    {SEC_OID_SHA384,
     349,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xbb, 0x51, 0xcd, 0x3b, 0xa8,
      0xeb, 0x20, 0x1f, 0x53, 0xdd, 0xb4, 0xe3, 0x4e, 0x08, 0xc0, 0xff, 0x7d,
      0xff, 0x93, 0x78, 0x10, 0x67, 0x84, 0xd7, 0x98, 0xd5, 0xa3, 0x44, 0x0b,
      0xd6, 0xdc, 0x34, 0xbe, 0x3a, 0x0e, 0xae, 0xf8, 0x77, 0x66, 0x19, 0xa0,
      0xc9, 0x7f, 0xef, 0xb1, 0x57, 0x20, 0xb3},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x04, 0x07, 0x71, 0xe3, 0x39, 0x02, 0x16, 0xfe, 0xd2, 0xc6, 0x20, 0x8b,
      0xdf, 0x5b, 0xfe, 0xa8, 0x3a, 0xb1, 0x91, 0x5b, 0x16, 0x6e, 0x62, 0x65,
      0x69, 0xf1, 0x2e, 0xfd, 0x41, 0x0a, 0x39, 0xb7, 0xe7, 0xc7, 0x6f, 0x70,
      0xf0, 0x01, 0x28, 0x43, 0xa2, 0x6d, 0xeb, 0xf4, 0xcc, 0xc3, 0x3d, 0xda,
      0xe5, 0xbc, 0x5f, 0x7e, 0x62, 0xd0, 0x54, 0xea, 0xc3, 0x1c, 0xd0, 0x22,
      0xaf, 0xdb, 0x71, 0xb7, 0xc6, 0x38, 0xf2, 0x4c, 0x30, 0xcb, 0xad, 0x0e,
      0xf3, 0x5e, 0xd2, 0xfc, 0x99, 0x17, 0xf3, 0x56, 0xe9, 0xc3, 0xf0, 0x43,
      0x91, 0xb2, 0x1d, 0x10, 0x35, 0x27, 0x4b, 0x81, 0x53, 0x7f, 0xcb, 0xf3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 350
    {SEC_OID_SHA384,
     350,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xe7, 0x07, 0xe2, 0x67, 0xea,
      0x63, 0x53, 0x84, 0xa6, 0xda, 0x09, 0x82, 0x31, 0x49, 0xf5, 0xcb, 0x7a,
      0xcb, 0xb2, 0x9e, 0x91, 0x0d, 0x26, 0x30, 0xc5, 0xfb, 0x5a, 0xfb, 0xc4,
      0x2a, 0xa8, 0x43, 0x63, 0x49, 0xb2, 0x14, 0xa3, 0xb8, 0xfb, 0x94, 0x81,
      0xec, 0x99, 0x9e, 0x00, 0x50, 0x91, 0xf8},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x98, 0xd3, 0xf1, 0x6e, 0x1c, 0x51, 0x0a, 0x93, 0x3e, 0x64, 0x8e, 0x78,
      0xd0, 0x15, 0x88, 0x31, 0x9f, 0x00, 0x2e, 0x94, 0x75, 0xdf, 0x89, 0x42,
      0xa2, 0xa8, 0x9d, 0xb0, 0x66, 0x6b, 0xb7, 0xc8, 0x8b, 0x32, 0xbb, 0x24,
      0x81, 0x40, 0xe4, 0x4a, 0xc4, 0xab, 0x28, 0x11, 0x1b, 0x2b, 0x79, 0x23,
      0x99, 0xa9, 0x26, 0xf4, 0xa6, 0x6f, 0xbe, 0x28, 0xff, 0x65, 0xc0, 0x9f,
      0x83, 0x06, 0x89, 0x3a, 0xec, 0x09, 0x4b, 0x89, 0xd0, 0xfe, 0x52, 0x9e,
      0x35, 0x77, 0xc5, 0xec, 0xf3, 0x0a, 0x79, 0x44, 0xca, 0xaf, 0x53, 0x0f,
      0x45, 0x75, 0xeb, 0x11, 0x3f, 0xcf, 0x4c, 0x20, 0x0d, 0x2d, 0xd4, 0xbd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 351
    {SEC_OID_SHA384,
     351,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xac, 0xc4, 0xf2, 0xaf, 0xb7,
      0xf5, 0xc1, 0x0f, 0x81, 0x81, 0x75, 0x07, 0x4e, 0xf6, 0x88, 0xa6, 0x43,
      0xfc, 0x53, 0x65, 0xe3, 0x81, 0x29, 0xf8, 0x6d, 0x5e, 0x25, 0x17, 0xfe,
      0xb8, 0x1b, 0x2c, 0xd2, 0xb8, 0xdc, 0x4f, 0x78, 0x21, 0xbf, 0xd0, 0x32,
      0xed, 0xc4, 0xc0, 0x23, 0x40, 0x85, 0xd9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd1, 0xfd, 0x60, 0x2f, 0xee, 0xf8, 0x0b, 0xe9, 0xe5, 0x5a, 0x19, 0xd1,
      0xa9, 0x79, 0x9c, 0x72, 0xa8, 0x99, 0x11, 0x0c, 0x6a, 0xc2, 0x1f, 0xb3,
      0xc2, 0x13, 0x57, 0x06, 0x98, 0x09, 0xd5, 0x91, 0xa8, 0x77, 0x5b, 0x64,
      0xd1, 0x86, 0x7a, 0x8c, 0xff, 0xf1, 0x24, 0xf6, 0xa5, 0xe3, 0xa4, 0xf5,
      0xf9, 0x54, 0x80, 0x64, 0xf0, 0x1b, 0x9a, 0xf8, 0x86, 0x87, 0x05, 0x49,
      0x3a, 0x37, 0xa0, 0x37, 0x19, 0x3b, 0x48, 0xf5, 0x3b, 0x7c, 0x79, 0x73,
      0x02, 0x3f, 0x53, 0xe6, 0xce, 0xff, 0x68, 0x30, 0xca, 0x2f, 0x7a, 0x14,
      0xef, 0x51, 0x53, 0x6d, 0x45, 0x3a, 0xf4, 0x3b, 0x30, 0x58, 0xd8, 0xa9},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 352
    {SEC_OID_SHA384,
     352,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0x83, 0x27, 0x6c, 0x07, 0x93,
      0xf0, 0xa1, 0x97, 0x42, 0x42, 0x2f, 0x8a, 0xf6, 0x71, 0xcc, 0xf9, 0x65,
      0xfa, 0x7d, 0x18, 0xd5, 0x41, 0xbe, 0xf4, 0xc0, 0x5b, 0x90, 0xe3, 0x03,
      0xf8, 0x91, 0xd3, 0x90, 0x08, 0x43, 0x9e, 0x0f, 0xda, 0x4b, 0xfa, 0xd5,
      0xee, 0x9a, 0x6a, 0xce, 0x7e, 0x34, 0x0c},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x82, 0xf3, 0x76, 0x04, 0xf6, 0x66, 0x64, 0xc2, 0x88, 0x3d, 0xba, 0x6d,
      0x98, 0x39, 0x7c, 0x28, 0x10, 0x45, 0xcb, 0xf5, 0x9f, 0x1d, 0x16, 0xdd,
      0xdb, 0x13, 0x81, 0x12, 0x6a, 0x24, 0x65, 0x53, 0xa8, 0xb4, 0xd2, 0xaa,
      0xea, 0x48, 0xad, 0x91, 0x85, 0xa1, 0x64, 0x5f, 0x65, 0x56, 0x7d, 0x31,
      0x8a, 0x4d, 0x7b, 0x19, 0xf1, 0xd2, 0xe4, 0x43, 0x4c, 0x9a, 0x8e, 0xca,
      0xd3, 0x96, 0x30, 0x4a, 0xbc, 0x82, 0x22, 0x1b, 0xba, 0xb0, 0x67, 0x99,
      0x35, 0x07, 0x1c, 0x72, 0xfd, 0x97, 0x5e, 0x7b, 0x02, 0x1c, 0x04, 0xb1,
      0xd1, 0x6e, 0xa3, 0x6f, 0xc2, 0xd0, 0x51, 0xef, 0x5a, 0x8e, 0x11, 0x7c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u1
    // tcID: 353
    {SEC_OID_SHA384,
     353,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0x94, 0x28, 0x48, 0x58, 0x6b,
      0x53, 0x41, 0x05, 0xdd, 0xd1, 0xca, 0x77, 0xdf, 0x72, 0xe1, 0x25, 0x11,
      0x40, 0xf4, 0x12, 0xe9, 0x7b, 0x62, 0xaf, 0xbf, 0x85, 0xd4, 0x82, 0x23,
      0x09, 0x17, 0x6b, 0x59, 0x65, 0x45, 0x3d, 0xee, 0x3f, 0xab, 0x70, 0x9e,
      0x14, 0x15, 0x6b, 0x3d, 0xfc, 0xec, 0xca},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf0, 0x52, 0xdf, 0xc2, 0x7b, 0xf8, 0xa6, 0xd3, 0x6f, 0x37, 0x39, 0xf2,
      0x39, 0xb9, 0x81, 0xf5, 0xb5, 0x3f, 0xe0, 0x8d, 0x99, 0x9e, 0xc6, 0x83,
      0xb0, 0x1e, 0x43, 0xe7, 0x59, 0x61, 0x56, 0x20, 0x6b, 0xa0, 0x8b, 0x8b,
      0x9f, 0x59, 0x22, 0x9e, 0x2f, 0xbd, 0xce, 0x05, 0xf1, 0xe4, 0x0f, 0x99,
      0x90, 0xf0, 0xfd, 0xfb, 0x70, 0x29, 0xf9, 0xb3, 0xe8, 0xc6, 0x14, 0x4d,
      0xad, 0x03, 0x39, 0x20, 0x8b, 0x7c, 0xdc, 0xb3, 0x82, 0x0a, 0x55, 0x42,
      0x59, 0xdb, 0x9d, 0x27, 0xaf, 0xdd, 0x18, 0xf4, 0xa7, 0x50, 0x29, 0x6c,
      0x59, 0xba, 0xd6, 0xb6, 0x2d, 0xf0, 0x76, 0xf9, 0x0d, 0x53, 0xbe, 0x0d},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 354
    {SEC_OID_SHA384,
     354,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0x21, 0x19, 0xd5, 0xfc, 0x12,
      0x64, 0x9f, 0xc8, 0x08, 0xaf, 0x3b, 0x6d, 0x90, 0x37, 0xd3, 0xa4, 0x4e,
      0xb3, 0x23, 0x99, 0x97, 0x0d, 0xd0},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xf8, 0x77, 0xbd, 0x6e, 0x2a, 0x92, 0x73, 0xe3, 0x22, 0xa3, 0x29, 0x8e,
      0xa3, 0xad, 0xd1, 0x3d, 0x11, 0x04, 0xb3, 0x21, 0x72, 0x28, 0x36, 0x69,
      0xca, 0x66, 0x88, 0xf0, 0xcb, 0x59, 0x15, 0x24, 0xa7, 0xf1, 0x5d, 0xd4,
      0x14, 0x96, 0x68, 0x1e, 0xda, 0x98, 0x93, 0x9a, 0xae, 0x72, 0x9f, 0xed,
      0xe8, 0x5c, 0xa3, 0x7c, 0x81, 0xef, 0x19, 0xe3, 0xdc, 0x9a, 0xb1, 0x69,
      0x08, 0xa3, 0x72, 0x0d, 0x86, 0x87, 0x5a, 0x51, 0xa6, 0xa6, 0xd9, 0x32,
      0xe3, 0x74, 0x92, 0xa6, 0xec, 0x7a, 0x34, 0x4e, 0xab, 0xc4, 0x82, 0x37,
      0x7f, 0x14, 0x89, 0x1f, 0xbd, 0x1d, 0xa7, 0xfa, 0xef, 0xfa, 0x11, 0x78},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 355
    {SEC_OID_SHA384,
     355,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x79, 0xb9, 0x5c, 0x01, 0x3b, 0x04,
      0x72, 0xde, 0x04, 0xd8, 0xfa, 0xee, 0xc3, 0xb7, 0x79, 0xc3, 0x9f, 0xe7,
      0x29, 0xea, 0x84, 0xfb, 0x55, 0x4c, 0xd0, 0x91, 0xc7, 0x17, 0x8c, 0x2f,
      0x05, 0x4e, 0xab, 0xbc, 0x62, 0xc3, 0xe1, 0xcf, 0xba, 0xc2, 0xc2, 0xe6,
      0x9d, 0x7a, 0xa4, 0x5d, 0x90, 0x72},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x14, 0x24, 0x9b, 0xbc, 0xfe, 0xec, 0xea, 0xb0, 0x6c, 0x75, 0x65, 0x4d,
      0x36, 0x1c, 0x0d, 0xf8, 0xd5, 0x6b, 0x32, 0x0e, 0xa3, 0xbc, 0x1d, 0x46,
      0x27, 0xec, 0x0a, 0x2f, 0x4b, 0x8f, 0xa3, 0x57, 0x74, 0x45, 0x69, 0x46,
      0x64, 0xf5, 0x69, 0xa9, 0x1f, 0x48, 0x07, 0x41, 0x38, 0x1e, 0x49, 0x4a,
      0x28, 0x47, 0x9f, 0x21, 0x86, 0xd7, 0x15, 0xa5, 0x67, 0x88, 0xf6, 0x70,
      0x73, 0x05, 0x6a, 0xa0, 0xcb, 0x0b, 0x6a, 0x7f, 0x78, 0x93, 0xe7, 0x7b,
      0x9a, 0x69, 0x76, 0xef, 0x66, 0x63, 0xd8, 0x02, 0x26, 0x89, 0x6d, 0x7f,
      0x43, 0xbb, 0x50, 0x2e, 0x1b, 0x4d, 0x49, 0x55, 0x8a, 0x27, 0xdd, 0x8b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 356
    {SEC_OID_SHA384,
     356,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xbf, 0xd4, 0x0d, 0x0c, 0xaa,
      0x4d, 0x9d, 0x42, 0x38, 0x1f, 0x3d, 0x72, 0xa2, 0x56, 0x83, 0xf5, 0x2b,
      0x03, 0xa1, 0xed, 0x96, 0xfb, 0x72, 0xd0, 0x3f, 0x08, 0xdc, 0xb9, 0xa8,
      0xbc, 0x8f, 0x23, 0xc1, 0xa4, 0x59, 0xde, 0xab, 0x03, 0xbc, 0xd3, 0x93,
      0x96, 0xc0, 0xd1, 0xe9, 0x05, 0x3c, 0x81},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x50, 0xa4, 0x38, 0xc9, 0x8e, 0xe9, 0x40, 0x25, 0xce, 0x13, 0xe2, 0x7d,
      0x36, 0xb8, 0x28, 0x0d, 0x48, 0x43, 0x58, 0x58, 0x36, 0xeb, 0x47, 0x01,
      0x1a, 0x07, 0x0c, 0xd7, 0x77, 0x29, 0x24, 0x56, 0x84, 0xa0, 0xdb, 0x31,
      0xfd, 0xe9, 0x80, 0x62, 0x03, 0x49, 0xc7, 0x96, 0x83, 0x2b, 0x2c, 0x6c,
      0xbd, 0xb7, 0x2d, 0xba, 0x9f, 0x3f, 0x9c, 0xc8, 0x78, 0x55, 0x9f, 0x50,
      0xb6, 0xbd, 0x12, 0x90, 0xf1, 0x0a, 0x6b, 0xcc, 0xbc, 0x1e, 0xee, 0xf7,
      0x70, 0x8b, 0x1b, 0x72, 0x05, 0x90, 0x22, 0x98, 0x79, 0x79, 0xe3, 0x52,
      0x21, 0xc5, 0x12, 0x59, 0xf3, 0x37, 0xc7, 0x28, 0x8a, 0x2f, 0x86, 0xbc},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 357
    {SEC_OID_SHA384,
     357,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x4c, 0x7d, 0x21, 0x9d, 0xb9, 0xaf,
      0x94, 0xce, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x15, 0xcf, 0x10, 0x58, 0xc8,
      0xd8, 0xba, 0x1e, 0x63, 0x4c, 0x41, 0x22, 0xdb, 0x95, 0xec, 0x1f, 0xac,
      0xd4, 0xbb, 0x13, 0xeb, 0xf0, 0x9a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x4d, 0x3f, 0xc5, 0xdc, 0xfa, 0xf7, 0x41, 0x11, 0x3c, 0xda, 0x3c, 0xe2,
      0xf8, 0xdf, 0xf4, 0xc9, 0x12, 0x14, 0x3e, 0x4d, 0x36, 0x31, 0x4c, 0x36,
      0x1d, 0x7e, 0xd5, 0x65, 0x6b, 0x68, 0x44, 0x8b, 0xcc, 0xa1, 0x14, 0xba,
      0x9e, 0x81, 0x24, 0x28, 0x12, 0x34, 0x66, 0x0b, 0x77, 0x26, 0xdd, 0xcd,
      0x68, 0x0d, 0xdf, 0xef, 0x7e, 0xa0, 0x7b, 0xfb, 0xce, 0xde, 0x10, 0x80,
      0x3d, 0x38, 0xd7, 0x21, 0x16, 0x31, 0xca, 0x11, 0x46, 0x60, 0x78, 0x81,
      0x9e, 0xb6, 0x6e, 0x11, 0x92, 0x1a, 0xb7, 0xff, 0xa3, 0xc4, 0x56, 0x0c,
      0x73, 0x2e, 0x77, 0x59, 0x5f, 0xd4, 0x08, 0xe9, 0x17, 0xdd, 0x9a, 0xfc},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 358
    {SEC_OID_SHA384,
     358,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xd2, 0x19, 0xdb, 0x9a, 0xf9,
      0x4c, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd1, 0x89, 0xbd, 0xb6, 0xd9,
      0xef, 0x7b, 0xe8, 0x50, 0x4c, 0xa3, 0x74, 0x75, 0x6e, 0xa5, 0xb8, 0xf1,
      0x5e, 0x44, 0x06, 0x7d, 0x20, 0x9b, 0x9b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x63, 0xd6, 0x5c, 0xdf, 0xeb, 0x1f, 0x1a, 0x42, 0x00, 0x0f, 0x43, 0xbd,
      0x1d, 0xdd, 0x13, 0x05, 0x37, 0xa7, 0xb6, 0xf6, 0x35, 0xe8, 0xd2, 0xbd,
      0x81, 0xa9, 0x7d, 0xa1, 0x68, 0x22, 0x11, 0x83, 0xda, 0x43, 0x3c, 0xa7,
      0x84, 0x29, 0xfd, 0x2b, 0x33, 0xc5, 0xf9, 0x48, 0x95, 0xa9, 0xc1, 0x3a,
      0xa9, 0xd1, 0xd5, 0xea, 0x32, 0x87, 0x25, 0x65, 0x3a, 0x5a, 0x9d, 0x00,
      0xf8, 0x5a, 0x55, 0x16, 0x23, 0x6f, 0x3b, 0x14, 0x28, 0xa8, 0x62, 0x92,
      0x87, 0xd3, 0xb0, 0x48, 0x7a, 0x2e, 0x82, 0xdd, 0x57, 0xf9, 0x3b, 0xb2,
      0xaa, 0x3d, 0x97, 0x83, 0xdc, 0x74, 0x13, 0x1e, 0x13, 0x75, 0x60, 0x34},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 359
    {SEC_OID_SHA384,
     359,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xa4, 0x33, 0xb7, 0x35, 0xf2,
      0x99, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdb, 0xb0, 0x2d, 0xeb, 0xbf,
      0xa7, 0xc9, 0xf1, 0x48, 0x7f, 0x39, 0x36, 0xa2, 0x2c, 0xa3, 0xf6, 0xf5,
      0xd0, 0x6e, 0xa2, 0x2d, 0x7c, 0x0d, 0xc3},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd2, 0x2c, 0x9c, 0x34, 0x8b, 0x97, 0x45, 0x71, 0x1f, 0x57, 0xde, 0xba,
      0xc3, 0xa0, 0x7d, 0xf9, 0x0a, 0x52, 0x7c, 0x06, 0xbd, 0x02, 0xa8, 0x45,
      0x4f, 0x41, 0x43, 0x7d, 0x54, 0x22, 0x4e, 0x07, 0x16, 0x98, 0xf0, 0x3f,
      0xdc, 0x64, 0xb1, 0xd6, 0x52, 0x41, 0x4e, 0xdc, 0x3f, 0x22, 0x39, 0xc4,
      0x9a, 0xe9, 0x81, 0x2a, 0x4b, 0x92, 0xf0, 0x99, 0xd6, 0x65, 0x9a, 0x65,
      0x96, 0x91, 0x76, 0x8d, 0x57, 0xe5, 0x30, 0xed, 0x3c, 0x91, 0xd5, 0x45,
      0x57, 0x81, 0x60, 0x58, 0x50, 0x99, 0x7a, 0x58, 0x22, 0x1f, 0x22, 0xa2,
      0x45, 0x1c, 0x39, 0x32, 0x47, 0x06, 0x06, 0xc2, 0x3f, 0x3a, 0xb1, 0xb8},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 360
    {SEC_OID_SHA384,
     360,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xb9, 0xaf, 0x94, 0xce, 0x7f,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd6, 0xef, 0xee, 0xfc, 0x87,
      0x6c, 0x9f, 0x23, 0x21, 0x7b, 0x44, 0x3c, 0x80, 0x63, 0x7e, 0xf9, 0x39,
      0xe9, 0x11, 0x21, 0x9f, 0x96, 0xc1, 0x79},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x31, 0xf0, 0x5c, 0x0c, 0x29, 0xe9, 0xda, 0x49, 0xaa, 0x2f, 0xbb, 0xed,
      0xee, 0x77, 0x0c, 0x68, 0xd1, 0x0f, 0x85, 0xe7, 0xf7, 0x7e, 0x72, 0xac,
      0x3c, 0xfa, 0x9c, 0x86, 0x23, 0xa2, 0xbb, 0x42, 0xee, 0xb2, 0xf2, 0x4a,
      0xc8, 0xf2, 0xae, 0xf7, 0xab, 0x0c, 0x4b, 0x47, 0x82, 0x31, 0x40, 0x03,
      0x5b, 0xb3, 0x2f, 0xc1, 0xec, 0x04, 0xbb, 0xff, 0x5e, 0xab, 0x96, 0xe0,
      0x70, 0xc9, 0x38, 0xba, 0x1b, 0x53, 0xfe, 0x63, 0x97, 0x0f, 0x64, 0x9a,
      0xe0, 0x2e, 0x2a, 0x4a, 0xda, 0x42, 0x0a, 0x24, 0x9b, 0x6f, 0x7c, 0x52,
      0x5e, 0x2c, 0x4b, 0x9b, 0x0d, 0x55, 0x62, 0xae, 0x26, 0xf2, 0x27, 0x8c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 361
    {SEC_OID_SHA384,
     361,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xa2, 0x76, 0x27, 0x62, 0x76,
      0x27, 0x62, 0x76, 0x27, 0x62, 0x76, 0x27, 0x62, 0x76, 0x27, 0x62, 0x76,
      0x27, 0x62, 0x76, 0x27, 0x62, 0x76, 0x27, 0x3d, 0x72, 0x28, 0xd4, 0xf8,
      0x4b, 0x76, 0x9b, 0xe0, 0xfd, 0x57, 0xb9, 0x7e, 0x4c, 0x1e, 0xbc, 0xae,
      0x9a, 0x5f, 0x63, 0x5e, 0x80, 0xe9, 0xdf},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xbc, 0x26, 0xee, 0xc9, 0x5e, 0x26, 0xc9, 0x80, 0xbc, 0x03, 0x34, 0x26,
      0x4c, 0xbc, 0xfc, 0x26, 0xb8, 0x97, 0xc3, 0x57, 0x1c, 0x96, 0xce, 0x9a,
      0xb2, 0xa6, 0x7b, 0x49, 0xbb, 0x0f, 0x26, 0xa6, 0x27, 0x2f, 0xdc, 0x27,
      0x80, 0x6d, 0x7a, 0x4c, 0x57, 0x2a, 0xe0, 0xf7, 0x81, 0x49, 0xf1, 0xf3,
      0xc8, 0xaf, 0x5f, 0x41, 0xb9, 0x9d, 0x20, 0x66, 0x01, 0x81, 0x65, 0x51,
      0x3f, 0xb3, 0xb5, 0x5e, 0x42, 0x55, 0xdc, 0xd0, 0x65, 0x96, 0x47, 0xed,
      0x55, 0xe1, 0xe2, 0x60, 0x2c, 0xae, 0x4e, 0xfb, 0xd6, 0xea, 0xe1, 0xdf,
      0xe2, 0xff, 0x63, 0xe2, 0xc7, 0x48, 0xd4, 0xac, 0xc7, 0x43, 0x01, 0x39},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 362
    {SEC_OID_SHA384,
     362,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x73, 0x33, 0x33, 0x33, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x16, 0xe4, 0xd9, 0xf4, 0x2d, 0x4e,
      0xca, 0x22, 0xdf, 0x40, 0x3a, 0x0c, 0x57, 0x8b, 0x86, 0xf0, 0xa9, 0xa9,
      0x3f, 0xe8, 0x99, 0x95, 0xc7, 0xed},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x6f, 0xa0, 0x96, 0x4d, 0xd0, 0x54, 0x25, 0x0a, 0xf1, 0x76, 0x89, 0x1c,
      0x0c, 0x82, 0x2b, 0x01, 0x3b, 0x70, 0xf0, 0x59, 0xc3, 0x47, 0x17, 0x2c,
      0xaf, 0xc6, 0xb3, 0x6c, 0xd1, 0x6c, 0xf3, 0xb0, 0xf9, 0xd1, 0x9f, 0x25,
      0x98, 0xbd, 0x0d, 0x58, 0x0a, 0xc1, 0x6c, 0x46, 0xac, 0xb1, 0x67, 0xd4,
      0x37, 0x5b, 0xef, 0x70, 0x1c, 0x00, 0x2d, 0xcc, 0x04, 0x0f, 0xd5, 0x48,
      0x24, 0xb1, 0x4c, 0xc2, 0xdf, 0x01, 0x54, 0xeb, 0x20, 0xe7, 0x44, 0x64,
      0xe1, 0xfe, 0x7b, 0x83, 0x34, 0x26, 0xdd, 0x7d, 0x63, 0x6b, 0xf2, 0xd7,
      0x96, 0x03, 0xfd, 0xde, 0x5d, 0xda, 0xab, 0x23, 0xab, 0x0c, 0xf4, 0x26},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 363
    {SEC_OID_SHA384,
     363,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xda, 0x42, 0x33, 0xab, 0xf8, 0x24,
      0xc9, 0x3f, 0x90, 0x11, 0x5e, 0x76, 0xdb, 0x20, 0x6f, 0xa7, 0x48, 0x9d,
      0x66, 0x47, 0x33, 0x2e, 0x1b, 0xa3},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xba, 0xa4, 0xe7, 0x12, 0xee, 0x07, 0x86, 0xa5, 0xab, 0x0e, 0x5a, 0x5d,
      0xaf, 0xdc, 0xdc, 0xf8, 0x7b, 0x38, 0x83, 0x0a, 0xb2, 0xec, 0x86, 0xfa,
      0xed, 0xda, 0x9f, 0xdf, 0x65, 0x33, 0x2f, 0x6a, 0x96, 0x88, 0x26, 0x94,
      0x12, 0xf0, 0x50, 0x35, 0x65, 0x30, 0xd4, 0x66, 0x4a, 0x7f, 0xb8, 0xcd,
      0xec, 0xc4, 0x6a, 0x90, 0x1b, 0x01, 0x6e, 0x6b, 0xb8, 0xa3, 0x36, 0xad,
      0x9a, 0xa6, 0xf1, 0x9a, 0xbf, 0x9a, 0xda, 0x69, 0x70, 0x5d, 0x1c, 0x90,
      0x5b, 0xea, 0xfb, 0x95, 0xa4, 0x4f, 0x52, 0xaf, 0x43, 0xde, 0x4b, 0xf8,
      0x0c, 0x05, 0x0c, 0xf9, 0x96, 0xb7, 0x79, 0x6d, 0xfc, 0xee, 0x8e, 0x1b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 364
    {SEC_OID_SHA384,
     364,
     {0x30, 0x64, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x30, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xb1, 0xa6, 0xc0, 0xfa, 0x1b,
      0x96, 0xef, 0xac, 0x0d, 0x06, 0xd9, 0x24, 0x58, 0x53, 0xbd, 0x76, 0x76,
      0x0c, 0xb5, 0x66, 0x62, 0x94, 0xbb},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x81, 0xe7, 0x8a, 0x52, 0xae, 0x06, 0x95, 0x58, 0x3f, 0x7a, 0x60, 0x1a,
      0xb9, 0xb6, 0xfb, 0xfa, 0xf4, 0x34, 0xf2, 0xbe, 0xfa, 0x1f, 0x8c, 0x83,
      0x3d, 0x59, 0xde, 0xb6, 0x27, 0xa9, 0x27, 0xc2, 0xf4, 0x2d, 0x48, 0xeb,
      0x61, 0x7f, 0xe0, 0x42, 0xf5, 0x84, 0xe1, 0x05, 0xc2, 0x3c, 0x23, 0x17,
      0xcf, 0x22, 0xd5, 0x65, 0xf5, 0xf3, 0xb4, 0x25, 0xef, 0x79, 0x37, 0xdf,
      0x62, 0x9b, 0x68, 0x64, 0xda, 0xc7, 0x12, 0x64, 0xb2, 0x88, 0xc1, 0xa9,
      0x87, 0x21, 0x0f, 0x52, 0x30, 0x71, 0x31, 0x9c, 0xe3, 0xf6, 0x44, 0x11,
      0x91, 0x0a, 0xc2, 0x37, 0x65, 0xc4, 0x26, 0x6e, 0x61, 0x51, 0x12, 0xbc},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: edge case for u2
    // tcID: 365
    {SEC_OID_SHA384,
     365,
     {0x30, 0x65, 0x02, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
      0xff, 0xff, 0xff, 0xfd, 0x02, 0x31, 0x00, 0xdf, 0xea, 0x06, 0x86, 0x55,
      0x26, 0xce, 0xa1, 0x1c, 0x0f, 0x9e, 0xb9, 0x51, 0x2b, 0x41, 0xfa, 0x95,
      0x81, 0xd0, 0xf6, 0xcb, 0x7d, 0xb9, 0x68, 0x03, 0x36, 0x15, 0x1d, 0xce,
      0x79, 0xde, 0x81, 0x8c, 0xdf, 0x33, 0xc8, 0x79, 0xda, 0x32, 0x27, 0x40,
      0x41, 0x6d, 0x1e, 0x5a, 0xe5, 0x32, 0xfa},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x41, 0xfa, 0x87, 0x65, 0xb1, 0x9d, 0x31, 0x08, 0x03, 0x1e, 0x28, 0xc9,
      0xa7, 0x81, 0xa3, 0x85, 0xc9, 0xc1, 0x0b, 0x2b, 0xfd, 0x42, 0xe6, 0x43,
      0x7e, 0x5c, 0x4b, 0xd7, 0x11, 0xcf, 0x2a, 0x03, 0x17, 0x50, 0x84, 0x7d,
      0x17, 0xa8, 0x2f, 0x93, 0x76, 0xa3, 0x0a, 0xe1, 0x82, 0xa6, 0xd6, 0xe7,
      0x1c, 0x20, 0xaf, 0x96, 0x32, 0x41, 0x47, 0xd4, 0x15, 0x5a, 0x4d, 0x0c,
      0x86, 0x7c, 0xa8, 0xe3, 0x6e, 0xba, 0x20, 0x4f, 0xbe, 0xd2, 0x08, 0x7e,
      0x0f, 0xcb, 0xdc, 0x8b, 0xaa, 0xbe, 0x07, 0xbb, 0x31, 0x23, 0xf9, 0xf7,
      0x25, 0x9e, 0x77, 0x1c, 0xd9, 0xf1, 0xad, 0x17, 0xd1, 0xa2, 0x37, 0x87},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: point duplication during verification
    // tcID: 366
    {SEC_OID_SHA384,
     366,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xb3, 0x76, 0x99, 0xe0, 0xd5, 0x18, 0xa4,
      0xd3, 0x70, 0xdb, 0xda, 0xaa, 0xea, 0x37, 0x88, 0x85, 0x0f, 0xa0, 0x3f,
      0x81, 0x86, 0xd1, 0xf7, 0x8f, 0xdf, 0xba, 0xe6, 0x54, 0x0a, 0xa6, 0x70,
      0xb3, 0x1c, 0x8a, 0xda, 0x0f, 0xff, 0x3e, 0x73, 0x7b, 0xd6, 0x95, 0x20,
      0x56, 0x0f, 0xe0, 0xce, 0x60, 0x02, 0x30, 0x64, 0xad, 0xb4, 0xd5, 0x1a,
      0x93, 0xf9, 0x6b, 0xed, 0x46, 0x65, 0xde, 0x2d, 0x4e, 0x11, 0x69, 0xcc,
      0x95, 0x81, 0x9e, 0xc6, 0xe9, 0x33, 0x3e, 0xdf, 0xd5, 0xc0, 0x7c, 0xa1,
      0x34, 0xce, 0xef, 0x7c, 0x95, 0x95, 0x7b, 0x71, 0x9a, 0xe3, 0x49, 0xfc,
      0x43, 0x9e, 0xaa, 0x49, 0xfb, 0xbe, 0x34},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe5, 0x85, 0xa0, 0x67, 0xd6, 0xdf, 0xf3, 0x7a, 0xe7, 0xf1, 0x7f, 0x81,
      0x58, 0x31, 0x19, 0xb6, 0x12, 0x91, 0x59, 0x73, 0x45, 0xf1, 0x07, 0xac,
      0xff, 0xe2, 0x37, 0xa0, 0x8f, 0x48, 0x86, 0xd4, 0xfd, 0xf9, 0x4f, 0xe6,
      0x31, 0x82, 0xe6, 0x14, 0x3c, 0x99, 0xbe, 0x25, 0xa7, 0xb7, 0xd8, 0x6b,
      0x57, 0x2c, 0x1e, 0x06, 0xdd, 0x2c, 0x7b, 0x94, 0xb8, 0x73, 0xf0, 0x57,
      0x8f, 0xcb, 0x2b, 0x99, 0xd6, 0x0e, 0x24, 0x6e, 0x51, 0x24, 0x5d, 0x08,
      0x04, 0xed, 0xd4, 0x4b, 0x32, 0xf0, 0xf0, 0x00, 0xc8, 0xf8, 0xf8, 0x8f,
      0x1d, 0x4a, 0x65, 0xfe, 0xa5, 0x1d, 0xbb, 0xb4, 0xab, 0x1e, 0x28, 0x23},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: duplication bug
    // tcID: 367
    {SEC_OID_SHA384,
     367,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xb3, 0x76, 0x99, 0xe0, 0xd5, 0x18, 0xa4,
      0xd3, 0x70, 0xdb, 0xda, 0xaa, 0xea, 0x37, 0x88, 0x85, 0x0f, 0xa0, 0x3f,
      0x81, 0x86, 0xd1, 0xf7, 0x8f, 0xdf, 0xba, 0xe6, 0x54, 0x0a, 0xa6, 0x70,
      0xb3, 0x1c, 0x8a, 0xda, 0x0f, 0xff, 0x3e, 0x73, 0x7b, 0xd6, 0x95, 0x20,
      0x56, 0x0f, 0xe0, 0xce, 0x60, 0x02, 0x30, 0x64, 0xad, 0xb4, 0xd5, 0x1a,
      0x93, 0xf9, 0x6b, 0xed, 0x46, 0x65, 0xde, 0x2d, 0x4e, 0x11, 0x69, 0xcc,
      0x95, 0x81, 0x9e, 0xc6, 0xe9, 0x33, 0x3e, 0xdf, 0xd5, 0xc0, 0x7c, 0xa1,
      0x34, 0xce, 0xef, 0x7c, 0x95, 0x95, 0x7b, 0x71, 0x9a, 0xe3, 0x49, 0xfc,
      0x43, 0x9e, 0xaa, 0x49, 0xfb, 0xbe, 0x34},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xe5, 0x85, 0xa0, 0x67, 0xd6, 0xdf, 0xf3, 0x7a, 0xe7, 0xf1, 0x7f, 0x81,
      0x58, 0x31, 0x19, 0xb6, 0x12, 0x91, 0x59, 0x73, 0x45, 0xf1, 0x07, 0xac,
      0xff, 0xe2, 0x37, 0xa0, 0x8f, 0x48, 0x86, 0xd4, 0xfd, 0xf9, 0x4f, 0xe6,
      0x31, 0x82, 0xe6, 0x14, 0x3c, 0x99, 0xbe, 0x25, 0xa7, 0xb7, 0xd8, 0x6b,
      0xa8, 0xd3, 0xe1, 0xf9, 0x22, 0xd3, 0x84, 0x6b, 0x47, 0x8c, 0x0f, 0xa8,
      0x70, 0x34, 0xd4, 0x66, 0x29, 0xf1, 0xdb, 0x91, 0xae, 0xdb, 0xa2, 0xf7,
      0xfb, 0x12, 0x2b, 0xb4, 0xcd, 0x0f, 0x0f, 0xfe, 0x37, 0x07, 0x07, 0x6f,
      0xe2, 0xb5, 0x9a, 0x01, 0x5a, 0xe2, 0x44, 0x4c, 0x54, 0xe1, 0xd7, 0xdc},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point with x-coordinate 0
    // tcID: 368
    {SEC_OID_SHA384,
     368,
     {0x30, 0x35, 0x02, 0x01, 0x01, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76,
      0x6f, 0x2b, 0x51, 0x67, 0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2,
      0xe5, 0x8d, 0x28, 0xf9, 0xa4, 0x08, 0x78, 0xee, 0xec, 0x63, 0x26},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xb4, 0xd7, 0x8c, 0xcc, 0xbc, 0xed, 0x80, 0x65, 0xc0, 0xeb, 0xdc, 0x33,
      0x0b, 0x46, 0x70, 0xec, 0x99, 0x30, 0x92, 0x73, 0xe4, 0x42, 0xb9, 0xbe,
      0x34, 0x11, 0x96, 0xc1, 0x04, 0x3e, 0x44, 0x41, 0xfc, 0x57, 0xb9, 0x14,
      0x08, 0x55, 0x95, 0xbf, 0xc7, 0x55, 0xc6, 0x4f, 0xc4, 0x09, 0xf0, 0xba,
      0x01, 0xfe, 0xe3, 0x1c, 0xbb, 0xba, 0xed, 0x5c, 0x13, 0x23, 0xf0, 0x9c,
      0x87, 0xdf, 0x9b, 0x07, 0x12, 0xc1, 0x2e, 0x99, 0x73, 0x3f, 0xa2, 0x3e,
      0xf9, 0x1b, 0x4e, 0x6c, 0xa6, 0x66, 0xb0, 0x9d, 0xd7, 0x54, 0x0e, 0xbf,
      0x10, 0x68, 0xa1, 0x51, 0x55, 0xbc, 0x06, 0x9e, 0x3d, 0x59, 0x5c, 0x8c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: point with x-coordinate 0
    // tcID: 369
    {SEC_OID_SHA384,
     369,
     {0x30, 0x65, 0x02, 0x31, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x30, 0x33, 0x33, 0x33, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x27, 0xe0, 0xa9, 0x19, 0xfd,
      0xa4, 0xa2, 0xc6, 0x44, 0xd2, 0x02, 0xbd, 0x41, 0xbc, 0xee, 0x4b, 0xc8,
      0xfc, 0x05, 0x15, 0x5c, 0x27, 0x6e, 0xb0},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x6e, 0x3c, 0x68, 0xbe, 0x53, 0xaa, 0xde, 0x81, 0xef, 0x89, 0xe0, 0x96,
      0xd8, 0x41, 0xe2, 0x84, 0x5a, 0x23, 0x33, 0x1e, 0x7e, 0xc8, 0xa6, 0xa8,
      0x39, 0xd5, 0x8d, 0x07, 0xfa, 0x01, 0x6c, 0x09, 0x73, 0xed, 0x75, 0xde,
      0x4f, 0x99, 0x17, 0x7b, 0xfd, 0xc7, 0x4d, 0xb5, 0x66, 0xe9, 0xd1, 0x5a,
      0x49, 0x72, 0xea, 0x08, 0xe5, 0x77, 0xce, 0x1f, 0x61, 0xc1, 0x3a, 0x6c,
      0xa1, 0xba, 0xd1, 0xde, 0xef, 0x29, 0x82, 0xee, 0x01, 0xa2, 0x82, 0x6f,
      0x00, 0x2b, 0x76, 0x9f, 0x2c, 0x46, 0x09, 0x8d, 0x3b, 0xaf, 0xf0, 0x68,
      0xa4, 0x05, 0xd0, 0x9c, 0xa3, 0x84, 0x0d, 0x2f, 0xaf, 0xe4, 0xe4, 0x6e},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: comparison with point at infinity
    // tcID: 370
    {SEC_OID_SHA384,
     370,
     {0x30, 0x64, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67, 0xb9, 0xf5,
      0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4, 0x08, 0x78,
      0xee, 0xec, 0x63, 0x26, 0x02, 0x30, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
      0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x27, 0xe0, 0xa9, 0x19, 0xfd, 0xa4,
      0xa2, 0xc6, 0x44, 0xd2, 0x02, 0xbd, 0x41, 0xbc, 0xee, 0x4b, 0xc8, 0xfc,
      0x05, 0x15, 0x5c, 0x27, 0x6e, 0xb0},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xb1, 0x01, 0xcd, 0xb3, 0xeb, 0xa2, 0x0e, 0x11, 0x2a, 0xdb, 0xb4, 0xbb,
      0xd2, 0xcb, 0x47, 0x9a, 0x69, 0xe5, 0x90, 0xa4, 0x4e, 0xa9, 0x02, 0x63,
      0x18, 0x32, 0xab, 0xfa, 0xb8, 0xaf, 0x2c, 0x30, 0x41, 0xb3, 0xdf, 0x7f,
      0x16, 0x65, 0xb2, 0xc6, 0xeb, 0x53, 0x3f, 0x54, 0x62, 0x17, 0x10, 0x0a,
      0x1a, 0x61, 0xaa, 0x99, 0x51, 0x57, 0x8a, 0xd4, 0xf0, 0x0a, 0xe1, 0x73,
      0x39, 0xa8, 0xa6, 0xf1, 0x35, 0x9b, 0xbd, 0x0a, 0xc3, 0x55, 0x67, 0x8e,
      0xd4, 0xdf, 0x21, 0x33, 0x8f, 0x08, 0x76, 0x3c, 0x1d, 0x37, 0x02, 0xec,
      0x13, 0x2b, 0x63, 0x4c, 0x7b, 0xcc, 0x01, 0x18, 0xef, 0xb1, 0xd0, 0xdd},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: extreme value for k and edgecase s
    // tcID: 371
    {SEC_OID_SHA384,
     371,
     {0x30, 0x64, 0x02, 0x30, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2, 0xd9,
      0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59, 0x59,
      0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e, 0x9e,
      0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9, 0xc7,
      0x52, 0x95, 0xdf, 0x61, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51, 0x67,
      0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9, 0xa4,
      0x08, 0x78, 0xee, 0xec, 0x63, 0x26},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x67, 0x61, 0x04, 0x4a, 0x04, 0x0a, 0x49, 0x79, 0xdb, 0x26, 0x9b, 0x4a,
      0x37, 0x7e, 0x42, 0xf1, 0x1b, 0x4b, 0xe0, 0xce, 0x24, 0x61, 0x1f, 0x67,
      0x76, 0x74, 0xdc, 0xf7, 0x70, 0xf5, 0x88, 0x7c, 0xa4, 0xdb, 0x56, 0x53,
      0x03, 0x28, 0x38, 0x09, 0xe6, 0xd6, 0x5f, 0x7f, 0xc6, 0xbc, 0x27, 0x36,
      0x05, 0xc7, 0xda, 0xa4, 0x03, 0xfc, 0xa5, 0x35, 0x49, 0xf7, 0x5f, 0xf3,
      0x37, 0x29, 0x09, 0x64, 0x2d, 0x02, 0xb7, 0xfd, 0xca, 0xc1, 0xe6, 0x82,
      0x42, 0x81, 0x4d, 0x6e, 0x92, 0x5a, 0xb0, 0x1a, 0x80, 0x83, 0x6c, 0xfb,
      0xb3, 0x55, 0x81, 0x96, 0x00, 0x79, 0xe2, 0xfb, 0x44, 0xc0, 0xd1, 0x86},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 372
    {SEC_OID_SHA384,
     372,
     {0x30, 0x64, 0x02, 0x30, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2, 0xd9,
      0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59, 0x59,
      0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e, 0x9e,
      0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9, 0xc7,
      0x52, 0x95, 0xdf, 0x61, 0x02, 0x30, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x1c, 0x7b, 0xe6, 0x80, 0x47, 0x75,
      0x98, 0xd6, 0xc3, 0x71, 0x6f, 0xab, 0xc1, 0x3d, 0xce, 0xc8, 0x6a, 0xfd,
      0x28, 0x33, 0xd4, 0x1c, 0x2a, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x69, 0x22, 0xc5, 0x91, 0x50, 0x2f, 0x01, 0x04, 0x6f, 0xee, 0x56, 0x17,
      0xbf, 0x16, 0x49, 0x6f, 0x58, 0x39, 0x88, 0x22, 0xe6, 0x9a, 0xfa, 0x83,
      0x35, 0x30, 0x8f, 0x36, 0xc0, 0x9a, 0x8e, 0xd4, 0x37, 0x20, 0x9f, 0xef,
      0xcf, 0xfb, 0xbd, 0xf0, 0xa4, 0x87, 0x6b, 0x35, 0xa3, 0xc7, 0xab, 0x26,
      0x55, 0x85, 0x4d, 0xb8, 0x25, 0xb9, 0x4b, 0x3f, 0x27, 0xe5, 0xf8, 0x92,
      0xd3, 0xbb, 0xb6, 0xc7, 0x24, 0x0e, 0xc9, 0x22, 0x89, 0x4d, 0xd3, 0x59,
      0x8e, 0x91, 0xfc, 0xc6, 0x13, 0x4a, 0x2b, 0x8f, 0xd1, 0x54, 0xe1, 0x79,
      0x04, 0x66, 0x90, 0x62, 0x06, 0xf0, 0xf6, 0x23, 0x41, 0x6e, 0x63, 0xa1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 373
    {SEC_OID_SHA384,
     373,
     {0x30, 0x64, 0x02, 0x30, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2, 0xd9,
      0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59, 0x59,
      0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e, 0x9e,
      0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9, 0xc7,
      0x52, 0x95, 0xdf, 0x61, 0x02, 0x30, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x4f, 0xc1, 0x52, 0x33, 0xfb, 0x49,
      0x45, 0x8c, 0x89, 0xa4, 0x05, 0x7a, 0x83, 0x79, 0xdc, 0x97, 0x91, 0xf8,
      0x0a, 0x2a, 0xb8, 0x4e, 0xdd, 0x61},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x89, 0x2d, 0xac, 0x0e, 0x70, 0x0f, 0xc2, 0x9d, 0x18, 0x02, 0xd9, 0xa4,
      0x49, 0xa6, 0xf5, 0x6b, 0x21, 0x72, 0xcb, 0x1b, 0x7d, 0x88, 0x10, 0x13,
      0xcd, 0x3b, 0x31, 0xc0, 0xed, 0xb0, 0x52, 0xf2, 0xd3, 0x40, 0xc8, 0x99,
      0x5a, 0x44, 0x77, 0xbc, 0xb9, 0x22, 0x5f, 0xec, 0x15, 0x66, 0x72, 0x33,
      0xcc, 0x6c, 0x34, 0xae, 0x17, 0x44, 0x54, 0x44, 0x51, 0x6f, 0xd8, 0xfd,
      0x22, 0xee, 0x83, 0xf7, 0x9e, 0xb0, 0x77, 0x1e, 0xbf, 0xf6, 0x67, 0x7a,
      0xc5, 0xd4, 0xe0, 0x89, 0xf8, 0x7a, 0x1c, 0x72, 0xdf, 0x95, 0x7a, 0xcb,
      0x24, 0x49, 0x2a, 0xdc, 0xd7, 0xc3, 0x81, 0x6b, 0x8e, 0x0c, 0x75, 0xb1},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 374
    {SEC_OID_SHA384,
     374,
     {0x30, 0x65, 0x02, 0x30, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2, 0xd9,
      0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59, 0x59,
      0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e, 0x9e,
      0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9, 0xc7,
      0x52, 0x95, 0xdf, 0x61, 0x02, 0x31, 0x00, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x77, 0xa1, 0xfb, 0x4d, 0xf8,
      0xed, 0xe8, 0x52, 0xce, 0x76, 0x08, 0x37, 0xc5, 0x36, 0xca, 0xe3, 0x5a,
      0xf4, 0x0f, 0x40, 0x14, 0x76, 0x4c, 0x12},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x01, 0x63, 0x41, 0x17, 0xe6, 0x47, 0x8c, 0xe0, 0x56, 0x8b, 0x0a, 0x24,
      0x69, 0x23, 0x7b, 0xba, 0xc6, 0xff, 0x09, 0x6a, 0xcb, 0x7e, 0x51, 0x40,
      0x72, 0xbf, 0x77, 0x12, 0x3c, 0xb5, 0x1b, 0xa0, 0xcc, 0x3e, 0x8d, 0x69,
      0x28, 0x4d, 0x53, 0x4d, 0x8e, 0x6d, 0x1e, 0x87, 0x6c, 0xec, 0xf2, 0x22,
      0x31, 0xe5, 0xef, 0x04, 0xdc, 0x96, 0x76, 0x2c, 0xe7, 0xd5, 0xef, 0x33,
      0x48, 0xad, 0x1e, 0x24, 0x1a, 0xc7, 0x97, 0xae, 0x3b, 0x63, 0x0e, 0xa2,
      0x49, 0xaf, 0xc5, 0x13, 0x9a, 0xf4, 0x9b, 0x8e, 0xf6, 0x8b, 0x32, 0xf8,
      0x12, 0xd6, 0xb5, 0x14, 0x21, 0x03, 0x63, 0xd4, 0x98, 0xef, 0xc2, 0x8c},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 375
    {SEC_OID_SHA384,
     375,
     {0x30, 0x65, 0x02, 0x30, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2, 0xd9,
      0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59, 0x59,
      0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e, 0x9e,
      0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9, 0xc7,
      0x52, 0x95, 0xdf, 0x61, 0x02, 0x31, 0x00, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d,
      0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d,
      0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xaa, 0xe7, 0x67, 0x01, 0xac,
      0xc1, 0x95, 0x08, 0x94, 0xa8, 0x9e, 0x06, 0x87, 0x72, 0xd8, 0xb2, 0x81,
      0xee, 0xf1, 0x36, 0xf8, 0xa8, 0xfe, 0xf5},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x67, 0x5b, 0xdc, 0x79, 0xd8, 0x24, 0x38, 0x87, 0xfe, 0x1b, 0x30, 0x5d,
      0x12, 0xac, 0x10, 0xd2, 0xe9, 0xc0, 0xbd, 0xe0, 0x70, 0xa6, 0xe3, 0x39,
      0x4c, 0xd5, 0xf6, 0xad, 0xfb, 0xce, 0xda, 0x75, 0x49, 0x8b, 0x0e, 0x7a,
      0x79, 0x4c, 0x72, 0x12, 0xf4, 0x2b, 0xe9, 0x3f, 0x61, 0x67, 0x44, 0x56,
      0x3e, 0x96, 0xd1, 0xbf, 0x6f, 0x95, 0xcd, 0xbe, 0xfa, 0x77, 0x49, 0x11,
      0xba, 0x06, 0x46, 0x3d, 0x8a, 0x90, 0xa0, 0xc9, 0xd7, 0x3c, 0x96, 0x99,
      0xb0, 0x61, 0xd7, 0x79, 0xdc, 0x52, 0x49, 0x6e, 0x8e, 0xe9, 0xb9, 0xae,
      0x9c, 0x5d, 0x4d, 0x90, 0xe8, 0x9c, 0xd1, 0x15, 0x7d, 0x81, 0x18, 0x95},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k
    // tcID: 376
    {SEC_OID_SHA384,
     376,
     {0x30, 0x64, 0x02, 0x30, 0x08, 0xd9, 0x99, 0x05, 0x7b, 0xa3, 0xd2, 0xd9,
      0x69, 0x26, 0x00, 0x45, 0xc5, 0x5b, 0x97, 0xf0, 0x89, 0x02, 0x59, 0x59,
      0xa6, 0xf4, 0x34, 0xd6, 0x51, 0xd2, 0x07, 0xd1, 0x9f, 0xb9, 0x6e, 0x9e,
      0x4f, 0xe0, 0xe8, 0x6e, 0xbe, 0x0e, 0x64, 0xf8, 0x5b, 0x96, 0xa9, 0xc7,
      0x52, 0x95, 0xdf, 0x61, 0x02, 0x30, 0x0e, 0xb1, 0x0e, 0x5a, 0xb9, 0x5f,
      0x2f, 0x26, 0xa4, 0x07, 0x00, 0xb1, 0x30, 0x0f, 0xb8, 0xc3, 0xe7, 0x54,
      0xd5, 0xc4, 0x53, 0xd9, 0x38, 0x4e, 0xcc, 0xe1, 0xda, 0xa3, 0x81, 0x35,
      0xa4, 0x8a, 0x0a, 0x96, 0xc2, 0x4e, 0xfc, 0x2a, 0x76, 0xd0, 0x0b, 0xde,
      0x1d, 0x7a, 0xee, 0xdf, 0x7f, 0x6a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x0f, 0xd1, 0xaa, 0xb8, 0x9f, 0x47, 0xb5, 0x65, 0xb8, 0x16, 0x0d, 0xfc,
      0xc4, 0x33, 0xb6, 0x40, 0x8a, 0xde, 0xb1, 0x47, 0x3c, 0x03, 0x6b, 0x26,
      0xb7, 0xdd, 0xec, 0x71, 0x4f, 0xb4, 0xd0, 0xe7, 0xdd, 0x75, 0x6c, 0x88,
      0x46, 0x9e, 0x86, 0xe2, 0x18, 0x81, 0x3e, 0xad, 0x8e, 0x8e, 0x76, 0x76,
      0xf1, 0xcc, 0x95, 0x5c, 0x41, 0x39, 0xe0, 0x07, 0x1c, 0x00, 0x79, 0xec,
      0x1d, 0x77, 0x16, 0x4e, 0x05, 0x69, 0xbd, 0xf4, 0x53, 0x83, 0x7e, 0x8b,
      0x33, 0xc9, 0x85, 0x35, 0xa0, 0xe7, 0xc9, 0xc6, 0x1e, 0xf2, 0x47, 0x62,
      0x06, 0x7b, 0xb4, 0x6b, 0x61, 0x16, 0xea, 0x79, 0x09, 0xa6, 0x9b, 0x23},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and edgecase s
    // tcID: 377
    {SEC_OID_SHA384,
     377,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05,
      0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b,
      0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a,
      0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e,
      0x38, 0x72, 0x76, 0x0a, 0xb7, 0x02, 0x30, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x42, 0x76, 0x6f, 0x2b, 0x51,
      0x67, 0xb9, 0xf5, 0x1d, 0x5e, 0x04, 0x90, 0xc2, 0xe5, 0x8d, 0x28, 0xf9,
      0xa4, 0x08, 0x78, 0xee, 0xec, 0x63, 0x26},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x34, 0xd7, 0x4e, 0xc0, 0x88, 0xba, 0xb6, 0xc6, 0x32, 0x39, 0x68, 0xd1,
      0xf4, 0x68, 0x99, 0x38, 0x12, 0xf6, 0x90, 0xd6, 0xed, 0xca, 0x5b, 0x97,
      0x60, 0x4d, 0x71, 0x8e, 0x12, 0xb8, 0xcd, 0xfd, 0xd9, 0x6d, 0x42, 0xe5,
      0x7d, 0x33, 0xaf, 0xe3, 0x12, 0xf0, 0xee, 0x3c, 0x3d, 0x0a, 0x13, 0xf7,
      0x86, 0xf4, 0x92, 0x2b, 0xb2, 0xc1, 0x3b, 0xdf, 0x77, 0x52, 0xa3, 0xec,
      0xb6, 0x93, 0x93, 0xe9, 0x97, 0xbd, 0x65, 0x46, 0x1c, 0x46, 0x86, 0x7e,
      0xbe, 0xef, 0x62, 0x96, 0xb2, 0x3f, 0x2c, 0x56, 0xdf, 0x63, 0xac, 0xfd,
      0xe6, 0x48, 0xf3, 0xf5, 0x00, 0x2d, 0xbc, 0x23, 0x9f, 0xfd, 0x15, 0x82},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 378
    {SEC_OID_SHA384,
     378,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05,
      0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b,
      0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a,
      0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e,
      0x38, 0x72, 0x76, 0x0a, 0xb7, 0x02, 0x30, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x1c, 0x7b, 0xe6, 0x80, 0x47,
      0x75, 0x98, 0xd6, 0xc3, 0x71, 0x6f, 0xab, 0xc1, 0x3d, 0xce, 0xc8, 0x6a,
      0xfd, 0x28, 0x33, 0xd4, 0x1c, 0x2a, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x43, 0x76, 0xc9, 0x89, 0x3e, 0x92, 0x77, 0x29, 0x6c, 0x76, 0x6a, 0x83,
      0xab, 0xbe, 0x36, 0xb3, 0x4d, 0xa7, 0xa6, 0x31, 0xf8, 0xcb, 0xfd, 0x32,
      0xa1, 0x88, 0x8d, 0xe0, 0xdd, 0x14, 0x55, 0xa2, 0x1a, 0x15, 0x3e, 0xa2,
      0xd6, 0x1c, 0xfa, 0x50, 0x71, 0xfc, 0x6b, 0xe1, 0x2a, 0x65, 0x8f, 0x6b,
      0x29, 0x0b, 0xa1, 0xa8, 0xee, 0x8c, 0x78, 0xb5, 0xdd, 0x58, 0xf9, 0xff,
      0xca, 0xcb, 0x22, 0x95, 0x56, 0x82, 0xee, 0xa0, 0x24, 0x29, 0xc3, 0xfa,
      0x8c, 0xdc, 0xb6, 0x49, 0xfa, 0x4d, 0x00, 0x7c, 0x86, 0x93, 0xe3, 0xf8,
      0xf3, 0xc0, 0xa5, 0xf3, 0xc4, 0xde, 0x7a, 0x51, 0xbe, 0xaa, 0x98, 0x09},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 379
    {SEC_OID_SHA384,
     379,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05,
      0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b,
      0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a,
      0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e,
      0x38, 0x72, 0x76, 0x0a, 0xb7, 0x02, 0x30, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
      0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x4f, 0xc1, 0x52, 0x33, 0xfb,
      0x49, 0x45, 0x8c, 0x89, 0xa4, 0x05, 0x7a, 0x83, 0x79, 0xdc, 0x97, 0x91,
      0xf8, 0x0a, 0x2a, 0xb8, 0x4e, 0xdd, 0x61},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x10, 0x87, 0x8f, 0xc4, 0x80, 0x7f, 0x67, 0x32, 0xa2, 0x3c, 0x88, 0x3e,
      0x83, 0x8e, 0x38, 0xc7, 0x87, 0xf7, 0x08, 0x8f, 0x94, 0xc1, 0x82, 0x4b,
      0x84, 0x67, 0x3e, 0x8b, 0x9e, 0xab, 0x16, 0xde, 0x15, 0x44, 0xae, 0x4b,
      0xf2, 0xc6, 0xfe, 0x3f, 0xe4, 0xfb, 0x34, 0x3b, 0x74, 0x87, 0xe2, 0xb4,
      0x30, 0x36, 0xff, 0x43, 0x95, 0x33, 0xd2, 0x2f, 0x95, 0x1d, 0xae, 0x96,
      0x65, 0x84, 0xba, 0xfb, 0x23, 0xb2, 0x17, 0xdc, 0xad, 0x2f, 0x8f, 0x4e,
      0x0e, 0x69, 0x99, 0xc0, 0xc4, 0xd0, 0xf0, 0x76, 0x63, 0x4b, 0xe8, 0x05,
      0xf6, 0x76, 0xfd, 0x2a, 0x59, 0xc2, 0x7f, 0x9f, 0xe7, 0xc5, 0xd9, 0x5b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 380
    {SEC_OID_SHA384,
     380,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05,
      0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b,
      0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a,
      0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e,
      0x38, 0x72, 0x76, 0x0a, 0xb7, 0x02, 0x31, 0x00, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
      0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x77, 0xa1, 0xfb, 0x4d,
      0xf8, 0xed, 0xe8, 0x52, 0xce, 0x76, 0x08, 0x37, 0xc5, 0x36, 0xca, 0xe3,
      0x5a, 0xf4, 0x0f, 0x40, 0x14, 0x76, 0x4c, 0x12},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x03, 0x6b, 0x25, 0x3e, 0x3b, 0x4a, 0xc8, 0x8b, 0xb8, 0x58, 0x5a, 0x2b,
      0x32, 0xb9, 0x78, 0x76, 0x6a, 0x93, 0x1e, 0x5a, 0xd0, 0xd0, 0xe6, 0x53,
      0xa2, 0xe3, 0x4b, 0x44, 0xd6, 0xdd, 0xcc, 0x0d, 0x38, 0x6e, 0x20, 0xc4,
      0xde, 0xf2, 0xd8, 0xbb, 0x3f, 0x8d, 0xa1, 0x28, 0xc1, 0xea, 0xc6, 0x9f,
      0x9c, 0x8e, 0x3b, 0x5f, 0xf5, 0xdd, 0xe2, 0x20, 0x5a, 0xf3, 0x59, 0xb3,
      0x97, 0x4d, 0x52, 0x75, 0x8d, 0x7a, 0xba, 0xe8, 0x12, 0xb8, 0xb2, 0x75,
      0xe1, 0x45, 0x2c, 0x4e, 0x59, 0xcb, 0x62, 0xe9, 0xb6, 0x77, 0x1d, 0x34,
      0x7d, 0xbd, 0x1d, 0xea, 0x76, 0x1c, 0x70, 0x29, 0x1c, 0xc5, 0xe0, 0xa6},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k and s^-1
    // tcID: 381
    {SEC_OID_SHA384,
     381,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05,
      0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b,
      0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a,
      0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e,
      0x38, 0x72, 0x76, 0x0a, 0xb7, 0x02, 0x31, 0x00, 0xdb, 0x6d, 0xb6, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb,
      0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xdb, 0x6d, 0xb6, 0xaa, 0xe7, 0x67, 0x01,
      0xac, 0xc1, 0x95, 0x08, 0x94, 0xa8, 0x9e, 0x06, 0x87, 0x72, 0xd8, 0xb2,
      0x81, 0xee, 0xf1, 0x36, 0xf8, 0xa8, 0xfe, 0xf5},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x27, 0x83, 0xc1, 0xbe, 0x92, 0x2f, 0xce, 0x15, 0x58, 0x64, 0xec, 0xb4,
      0x1d, 0x0a, 0x31, 0x6e, 0x19, 0x3a, 0x55, 0x84, 0x3e, 0x80, 0x19, 0x2f,
      0x1f, 0xe5, 0x56, 0x77, 0x2f, 0x3d, 0xeb, 0xd0, 0x4b, 0x9f, 0xc9, 0x3c,
      0x27, 0xbc, 0x6f, 0x35, 0x39, 0x38, 0x88, 0x6a, 0x40, 0x44, 0x19, 0x94,
      0x1a, 0x35, 0x2c, 0xec, 0x33, 0x69, 0x46, 0x42, 0x4f, 0xa3, 0xc2, 0x08,
      0xea, 0x71, 0x05, 0xf5, 0x54, 0x9e, 0xdd, 0xe8, 0x68, 0x8a, 0xbd, 0x30,
      0x53, 0x44, 0xbf, 0x4f, 0x66, 0xdd, 0xa7, 0xea, 0xbc, 0xda, 0x6f, 0x85,
      0x57, 0xc9, 0xaf, 0x88, 0x10, 0x98, 0x04, 0xd7, 0x02, 0xe9, 0x67, 0x0b},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: extreme value for k
    // tcID: 382
    {SEC_OID_SHA384,
     382,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05,
      0x37, 0x8e, 0xb1, 0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b,
      0x62, 0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a,
      0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e,
      0x38, 0x72, 0x76, 0x0a, 0xb7, 0x02, 0x30, 0x0e, 0xb1, 0x0e, 0x5a, 0xb9,
      0x5f, 0x2f, 0x26, 0xa4, 0x07, 0x00, 0xb1, 0x30, 0x0f, 0xb8, 0xc3, 0xe7,
      0x54, 0xd5, 0xc4, 0x53, 0xd9, 0x38, 0x4e, 0xcc, 0xe1, 0xda, 0xa3, 0x81,
      0x35, 0xa4, 0x8a, 0x0a, 0x96, 0xc2, 0x4e, 0xfc, 0x2a, 0x76, 0xd0, 0x0b,
      0xde, 0x1d, 0x7a, 0xee, 0xdf, 0x7f, 0x6a},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfa, 0x92, 0x53, 0x8c, 0xdc, 0x74, 0x03, 0x68, 0xca, 0xf1, 0x64, 0x80,
      0xff, 0x13, 0x04, 0xce, 0xbb, 0xbe, 0x59, 0xa4, 0x6a, 0x7a, 0x84, 0x60,
      0x37, 0x26, 0xb9, 0x59, 0x2d, 0x10, 0x5b, 0xe0, 0x69, 0xdf, 0x1c, 0x61,
      0xb5, 0x97, 0x4f, 0x27, 0xe7, 0x55, 0x2f, 0x79, 0x7d, 0xe9, 0x7c, 0xdb,
      0x62, 0x0e, 0x03, 0xa4, 0x6d, 0xa8, 0x62, 0xe4, 0xb0, 0x89, 0xba, 0xfb,
      0xb8, 0x0d, 0xf8, 0xf0, 0x55, 0xc8, 0xf4, 0x79, 0x91, 0xb3, 0xa3, 0xdd,
      0xb2, 0xb0, 0x89, 0xae, 0xdb, 0x2f, 0x15, 0x84, 0x1a, 0x6a, 0x5b, 0x5e,
      0x14, 0xc1, 0xdc, 0x36, 0xb3, 0xc1, 0x55, 0xc4, 0xf7, 0x4d, 0x34, 0x09},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: testing point duplication
    // tcID: 383
    {SEC_OID_SHA384,
     383,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xf9, 0xb1, 0x27, 0xf0, 0xd8, 0x1e, 0xbc,
      0xd1, 0x7b, 0x7b, 0xa0, 0xea, 0x13, 0x1c, 0x66, 0x0d, 0x34, 0x0b, 0x05,
      0xce, 0x55, 0x7c, 0x82, 0x16, 0x0e, 0x0f, 0x79, 0x3d, 0xe0, 0x7d, 0x38,
      0x17, 0x90, 0x23, 0x94, 0x28, 0x71, 0xac, 0xb7, 0x00, 0x2d, 0xfa, 0xfd,
      0xff, 0xfc, 0x8d, 0xea, 0xce, 0x02, 0x30, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x1c, 0x7b, 0xe6, 0x80, 0x47,
      0x75, 0x98, 0xd6, 0xc3, 0x71, 0x6f, 0xab, 0xc1, 0x3d, 0xce, 0xc8, 0x6a,
      0xfd, 0x28, 0x33, 0xd4, 0x1c, 0x2a, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e,
      0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
      0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d,
      0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7,
      0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf,
      0x92, 0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c,
      0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce,
      0x1d, 0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 384
    {SEC_OID_SHA384,
     384,
     {0x30, 0x64, 0x02, 0x30, 0x06, 0x4e, 0xd8, 0x0f, 0x27, 0xe1, 0x43, 0x2e,
      0x84, 0x84, 0x5f, 0x15, 0xec, 0xe3, 0x99, 0xf2, 0xcb, 0xf4, 0xfa, 0x31,
      0xaa, 0x83, 0x7d, 0xe9, 0xb9, 0x53, 0xd4, 0x44, 0x13, 0xb9, 0xf5, 0xc7,
      0xc7, 0xf6, 0x79, 0x89, 0xd7, 0x03, 0xf0, 0x7a, 0xbe, 0xf1, 0x1b, 0x6a,
      0xd0, 0x37, 0x3e, 0xa5, 0x02, 0x30, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x1c, 0x7b, 0xe6, 0x80, 0x47, 0x75,
      0x98, 0xd6, 0xc3, 0x71, 0x6f, 0xab, 0xc1, 0x3d, 0xce, 0xc8, 0x6a, 0xfd,
      0x28, 0x33, 0xd4, 0x1c, 0x2a, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e,
      0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
      0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d,
      0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7,
      0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e, 0x98, 0xbf,
      0x92, 0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd, 0x28, 0x9a, 0x14, 0x7c,
      0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0, 0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce,
      0x1d, 0x7e, 0x81, 0x9d, 0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 385
    {SEC_OID_SHA384,
     385,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xf9, 0xb1, 0x27, 0xf0, 0xd8, 0x1e, 0xbc,
      0xd1, 0x7b, 0x7b, 0xa0, 0xea, 0x13, 0x1c, 0x66, 0x0d, 0x34, 0x0b, 0x05,
      0xce, 0x55, 0x7c, 0x82, 0x16, 0x0e, 0x0f, 0x79, 0x3d, 0xe0, 0x7d, 0x38,
      0x17, 0x90, 0x23, 0x94, 0x28, 0x71, 0xac, 0xb7, 0x00, 0x2d, 0xfa, 0xfd,
      0xff, 0xfc, 0x8d, 0xea, 0xce, 0x02, 0x30, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92,
      0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x1c, 0x7b, 0xe6, 0x80, 0x47,
      0x75, 0x98, 0xd6, 0xc3, 0x71, 0x6f, 0xab, 0xc1, 0x3d, 0xce, 0xc8, 0x6a,
      0xfd, 0x28, 0x33, 0xd4, 0x1c, 0x2a, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e,
      0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
      0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d,
      0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7,
      0xc9, 0xe8, 0x21, 0xb5, 0x69, 0xd9, 0xd3, 0x90, 0xa2, 0x61, 0x67, 0x40,
      0x6d, 0x6d, 0x23, 0xd6, 0x07, 0x0b, 0xe2, 0x42, 0xd7, 0x65, 0xeb, 0x83,
      0x16, 0x25, 0xce, 0xec, 0x4a, 0x0f, 0x47, 0x3e, 0xf5, 0x9f, 0x4e, 0x30,
      0xe2, 0x81, 0x7e, 0x62, 0x85, 0xbc, 0xe2, 0x84, 0x6f, 0x15, 0xf1, 0xa0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: testing point duplication
    // tcID: 386
    {SEC_OID_SHA384,
     386,
     {0x30, 0x64, 0x02, 0x30, 0x06, 0x4e, 0xd8, 0x0f, 0x27, 0xe1, 0x43, 0x2e,
      0x84, 0x84, 0x5f, 0x15, 0xec, 0xe3, 0x99, 0xf2, 0xcb, 0xf4, 0xfa, 0x31,
      0xaa, 0x83, 0x7d, 0xe9, 0xb9, 0x53, 0xd4, 0x44, 0x13, 0xb9, 0xf5, 0xc7,
      0xc7, 0xf6, 0x79, 0x89, 0xd7, 0x03, 0xf0, 0x7a, 0xbe, 0xf1, 0x1b, 0x6a,
      0xd0, 0x37, 0x3e, 0xa5, 0x02, 0x30, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x24, 0x92, 0x49,
      0x24, 0x92, 0x49, 0x24, 0x92, 0x49, 0x1c, 0x7b, 0xe6, 0x80, 0x47, 0x75,
      0x98, 0xd6, 0xc3, 0x71, 0x6f, 0xab, 0xc1, 0x3d, 0xce, 0xc8, 0x6a, 0xfd,
      0x28, 0x33, 0xd4, 0x1c, 0x2a, 0x7e},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1, 0xc7, 0x1e,
      0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62, 0x8b, 0xa7, 0x9b, 0x98,
      0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54, 0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d,
      0xbf, 0x55, 0x29, 0x6c, 0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7,
      0xc9, 0xe8, 0x21, 0xb5, 0x69, 0xd9, 0xd3, 0x90, 0xa2, 0x61, 0x67, 0x40,
      0x6d, 0x6d, 0x23, 0xd6, 0x07, 0x0b, 0xe2, 0x42, 0xd7, 0x65, 0xeb, 0x83,
      0x16, 0x25, 0xce, 0xec, 0x4a, 0x0f, 0x47, 0x3e, 0xf5, 0x9f, 0x4e, 0x30,
      0xe2, 0x81, 0x7e, 0x62, 0x85, 0xbc, 0xe2, 0x84, 0x6f, 0x15, 0xf1, 0xa0},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     false},

    // Comment: pseudorandom signature
    // tcID: 387
    {SEC_OID_SHA384,
     387,
     {0x30, 0x64, 0x02, 0x30, 0x32, 0x40, 0x12, 0x49, 0x71, 0x4e, 0x90, 0x91,
      0xf0, 0x5a, 0x5e, 0x10, 0x9d, 0x5c, 0x12, 0x16, 0xfd, 0xc0, 0x5e, 0x98,
      0x61, 0x42, 0x61, 0xaa, 0x0d, 0xbd, 0x9e, 0x9c, 0xd4, 0x41, 0x5d, 0xee,
      0x29, 0x23, 0x8a, 0xfb, 0xd3, 0xb1, 0x03, 0xc1, 0xe4, 0x0e, 0xe5, 0xc9,
      0x14, 0x4a, 0xee, 0x0f, 0x02, 0x30, 0x43, 0x26, 0x75, 0x6f, 0xb2, 0xc4,
      0xfd, 0x72, 0x63, 0x60, 0xdd, 0x64, 0x79, 0xb5, 0x84, 0x94, 0x78, 0xc7,
      0xa9, 0xd0, 0x54, 0xa8, 0x33, 0xa5, 0x8c, 0x16, 0x31, 0xc3, 0x3b, 0x63,
      0xc3, 0x44, 0x13, 0x36, 0xdd, 0xf2, 0xc7, 0xfe, 0x0e, 0xd1, 0x29, 0xaa,
      0xe6, 0xd4, 0xdd, 0xfe, 0xb7, 0x53},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x29, 0xbd, 0xb7, 0x6d, 0x5f, 0xa7, 0x41, 0xbf, 0xd7, 0x02, 0x33, 0xcb,
      0x3a, 0x66, 0xcc, 0x7d, 0x44, 0xbe, 0xb3, 0xb0, 0x66, 0x3d, 0x92, 0xa8,
      0x13, 0x66, 0x50, 0x47, 0x8b, 0xce, 0xfb, 0x61, 0xef, 0x18, 0x2e, 0x15,
      0x5a, 0x54, 0x34, 0x5a, 0x5e, 0x8e, 0x5e, 0x88, 0xf0, 0x64, 0xe5, 0xbc,
      0x9a, 0x52, 0x5a, 0xb7, 0xf7, 0x64, 0xda, 0xd3, 0xda, 0xe1, 0x46, 0x8c,
      0x2b, 0x41, 0x9f, 0x3b, 0x62, 0xb9, 0xba, 0x91, 0x7d, 0x5e, 0x8c, 0x4f,
      0xb1, 0xec, 0x47, 0x40, 0x4a, 0x3f, 0xc7, 0x64, 0x74, 0xb2, 0x71, 0x30,
      0x81, 0xbe, 0x9d, 0xb4, 0xc0, 0x0e, 0x04, 0x3a, 0xda, 0x9f, 0xc4, 0xa3},
     {},
     true},

    // Comment: pseudorandom signature
    // tcID: 388
    {SEC_OID_SHA384,
     388,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd7, 0x14, 0x3a, 0x83, 0x66, 0x08, 0xb2,
      0x55, 0x99, 0xa7, 0xf2, 0x8d, 0xec, 0x66, 0x35, 0x49, 0x4c, 0x29, 0x92,
      0xad, 0x1e, 0x2b, 0xbe, 0xec, 0xb7, 0xef, 0x60, 0x1a, 0x9c, 0x01, 0x74,
      0x6e, 0x71, 0x0c, 0xe0, 0xd9, 0xc4, 0x8a, 0xcc, 0xb3, 0x8a, 0x79, 0xed,
      0xe5, 0xb9, 0x63, 0x8f, 0x34, 0x02, 0x31, 0x00, 0x80, 0xf9, 0xe1, 0x65,
      0xe8, 0xc6, 0x10, 0x35, 0xbf, 0x8a, 0xa7, 0xb5, 0x53, 0x39, 0x60, 0xe4,
      0x6d, 0xd0, 0xe2, 0x11, 0xc9, 0x04, 0xa0, 0x64, 0xed, 0xb6, 0xde, 0x41,
      0xf7, 0x97, 0xc0, 0xea, 0xe4, 0xe3, 0x27, 0x61, 0x2e, 0xe3, 0xf8, 0x16,
      0xf4, 0x15, 0x72, 0x72, 0xbb, 0x4f, 0xab, 0xc9},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x29, 0xbd, 0xb7, 0x6d, 0x5f, 0xa7, 0x41, 0xbf, 0xd7, 0x02, 0x33, 0xcb,
      0x3a, 0x66, 0xcc, 0x7d, 0x44, 0xbe, 0xb3, 0xb0, 0x66, 0x3d, 0x92, 0xa8,
      0x13, 0x66, 0x50, 0x47, 0x8b, 0xce, 0xfb, 0x61, 0xef, 0x18, 0x2e, 0x15,
      0x5a, 0x54, 0x34, 0x5a, 0x5e, 0x8e, 0x5e, 0x88, 0xf0, 0x64, 0xe5, 0xbc,
      0x9a, 0x52, 0x5a, 0xb7, 0xf7, 0x64, 0xda, 0xd3, 0xda, 0xe1, 0x46, 0x8c,
      0x2b, 0x41, 0x9f, 0x3b, 0x62, 0xb9, 0xba, 0x91, 0x7d, 0x5e, 0x8c, 0x4f,
      0xb1, 0xec, 0x47, 0x40, 0x4a, 0x3f, 0xc7, 0x64, 0x74, 0xb2, 0x71, 0x30,
      0x81, 0xbe, 0x9d, 0xb4, 0xc0, 0x0e, 0x04, 0x3a, 0xda, 0x9f, 0xc4, 0xa3},
     {0x4d, 0x73, 0x67},
     true},

    // Comment: pseudorandom signature
    // tcID: 389
    {SEC_OID_SHA384,
     389,
     {0x30, 0x65, 0x02, 0x30, 0x23, 0x45, 0x03, 0xfc, 0xca, 0x57, 0x81, 0x21,
      0x98, 0x6d, 0x96, 0xbe, 0x07, 0xfb, 0xc8, 0xda, 0x5d, 0x89, 0x4e, 0xd8,
      0x58, 0x8c, 0x6d, 0xbc, 0xdb, 0xe9, 0x74, 0xb4, 0xb8, 0x13, 0xb2, 0x1c,
      0x52, 0xd2, 0x0a, 0x89, 0x28, 0xf2, 0xe2, 0xfd, 0xac, 0x14, 0x70, 0x5b,
      0x07, 0x05, 0x49, 0x8c, 0x02, 0x31, 0x00, 0xcd, 0x7b, 0x9b, 0x76, 0x6b,
      0x97, 0xb5, 0x3d, 0x1a, 0x80, 0xfc, 0x0b, 0x76, 0x0a, 0xf1, 0x6a, 0x11,
      0xbf, 0x4a, 0x59, 0xc7, 0xc3, 0x67, 0xc6, 0xc7, 0x27, 0x5d, 0xfb, 0x6e,
      0x18, 0xa8, 0x80, 0x91, 0xee, 0xd3, 0x73, 0x4b, 0xf5, 0xcf, 0x41, 0xb3,
      0xdc, 0x6f, 0xec, 0xd6, 0xd3, 0xba, 0xaf},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x29, 0xbd, 0xb7, 0x6d, 0x5f, 0xa7, 0x41, 0xbf, 0xd7, 0x02, 0x33, 0xcb,
      0x3a, 0x66, 0xcc, 0x7d, 0x44, 0xbe, 0xb3, 0xb0, 0x66, 0x3d, 0x92, 0xa8,
      0x13, 0x66, 0x50, 0x47, 0x8b, 0xce, 0xfb, 0x61, 0xef, 0x18, 0x2e, 0x15,
      0x5a, 0x54, 0x34, 0x5a, 0x5e, 0x8e, 0x5e, 0x88, 0xf0, 0x64, 0xe5, 0xbc,
      0x9a, 0x52, 0x5a, 0xb7, 0xf7, 0x64, 0xda, 0xd3, 0xda, 0xe1, 0x46, 0x8c,
      0x2b, 0x41, 0x9f, 0x3b, 0x62, 0xb9, 0xba, 0x91, 0x7d, 0x5e, 0x8c, 0x4f,
      0xb1, 0xec, 0x47, 0x40, 0x4a, 0x3f, 0xc7, 0x64, 0x74, 0xb2, 0x71, 0x30,
      0x81, 0xbe, 0x9d, 0xb4, 0xc0, 0x0e, 0x04, 0x3a, 0xda, 0x9f, 0xc4, 0xa3},
     {0x31, 0x32, 0x33, 0x34, 0x30, 0x30},
     true},

    // Comment: pseudorandom signature
    // tcID: 390
    {SEC_OID_SHA384,
     390,
     {0x30, 0x65, 0x02, 0x30, 0x5c, 0xad, 0x9a, 0xe1, 0x56, 0x5f, 0x25, 0x88,
      0xf8, 0x6d, 0x82, 0x1c, 0x2c, 0xc1, 0xb4, 0xd0, 0xfd, 0xf8, 0x74, 0x33,
      0x13, 0x26, 0x56, 0x8f, 0x5b, 0x0e, 0x13, 0x0e, 0x4e, 0x0c, 0x0e, 0xc4,
      0x97, 0xf8, 0xf5, 0xf5, 0x64, 0x21, 0x2b, 0xd2, 0xa2, 0x6e, 0xcb, 0x78,
      0x2c, 0xf0, 0xa1, 0x8d, 0x02, 0x31, 0x00, 0xbf, 0x2e, 0x9d, 0x09, 0x80,
      0xfb, 0xb0, 0x06, 0x96, 0x67, 0x3e, 0x7f, 0xbb, 0x03, 0xe1, 0xf8, 0x54,
      0xb9, 0xd7, 0x59, 0x6b, 0x75, 0x9a, 0x17, 0xbf, 0x6e, 0x6e, 0x67, 0xa9,
      0x5e, 0xa6, 0xc1, 0x66, 0x4f, 0x82, 0xdc, 0x44, 0x9a, 0xe5, 0xea, 0x77,
      0x9a, 0xbd, 0x99, 0xc7, 0x8e, 0x68, 0x40},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x29, 0xbd, 0xb7, 0x6d, 0x5f, 0xa7, 0x41, 0xbf, 0xd7, 0x02, 0x33, 0xcb,
      0x3a, 0x66, 0xcc, 0x7d, 0x44, 0xbe, 0xb3, 0xb0, 0x66, 0x3d, 0x92, 0xa8,
      0x13, 0x66, 0x50, 0x47, 0x8b, 0xce, 0xfb, 0x61, 0xef, 0x18, 0x2e, 0x15,
      0x5a, 0x54, 0x34, 0x5a, 0x5e, 0x8e, 0x5e, 0x88, 0xf0, 0x64, 0xe5, 0xbc,
      0x9a, 0x52, 0x5a, 0xb7, 0xf7, 0x64, 0xda, 0xd3, 0xda, 0xe1, 0x46, 0x8c,
      0x2b, 0x41, 0x9f, 0x3b, 0x62, 0xb9, 0xba, 0x91, 0x7d, 0x5e, 0x8c, 0x4f,
      0xb1, 0xec, 0x47, 0x40, 0x4a, 0x3f, 0xc7, 0x64, 0x74, 0xb2, 0x71, 0x30,
      0x81, 0xbe, 0x9d, 0xb4, 0xc0, 0x0e, 0x04, 0x3a, 0xda, 0x9f, 0xc4, 0xa3},
     {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 391
    {SEC_OID_SHA384,
     391,
     {0x30, 0x65, 0x02, 0x30, 0x07, 0x64, 0x8b, 0x66, 0x60, 0xd0, 0x1b, 0xa2,
      0x52, 0x0a, 0x09, 0xd2, 0x98, 0xad, 0xf3, 0xb1, 0xa0, 0x2c, 0x32, 0x74,
      0x4b, 0xd2, 0x87, 0x72, 0x08, 0xf5, 0xa4, 0x16, 0x2f, 0x6c, 0x98, 0x43,
      0x73, 0x13, 0x9d, 0x80, 0x0a, 0x4c, 0xdc, 0x1f, 0xfe, 0xa1, 0x5b, 0xce,
      0x48, 0x71, 0xa0, 0xed, 0x02, 0x31, 0x00, 0x99, 0xfd, 0x36, 0x70, 0x12,
      0xcb, 0x9e, 0x02, 0xcd, 0xe2, 0x74, 0x94, 0x55, 0xe0, 0xd4, 0x95, 0xc5,
      0x28, 0x18, 0xf3, 0xc1, 0x4f, 0x6e, 0x6a, 0xad, 0x10, 0x5b, 0x09, 0x25,
      0xe2, 0xa7, 0x29, 0x0a, 0xc4, 0xa0, 0x6d, 0x9f, 0xad, 0xf4, 0xb1, 0x5b,
      0x57, 0x85, 0x56, 0xfe, 0x33, 0x2a, 0x5f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xaa, 0x63, 0xf1, 0xa2, 0x39, 0xac, 0x70, 0x19,
      0x7c, 0x6e, 0xbf, 0xce, 0xa5, 0x75, 0x6d, 0xc0, 0x12, 0x12, 0x3f, 0x82,
      0xc5, 0x1f, 0xa8, 0x74, 0xd6, 0x60, 0x28, 0xbe, 0x00, 0xe9, 0x76, 0xa1,
      0x08, 0x06, 0x06, 0x73, 0x7c, 0xc7, 0x5c, 0x40, 0xbd, 0xfe, 0x4a, 0xac,
      0xac, 0xbd, 0x85, 0x38, 0x90, 0x88, 0xa6, 0x2a, 0x63, 0x98, 0x38, 0x4c,
      0x22, 0xb5, 0x2d, 0x49, 0x2f, 0x23, 0xf4, 0x6e, 0x4a, 0x27, 0xa4, 0x72,
      0x4a, 0xd5, 0x55, 0x51, 0xda, 0x5c, 0x48, 0x34, 0x38, 0x09, 0x5a, 0x24,
      0x7c, 0xb0, 0xc3, 0x37, 0x8f, 0x1f, 0x52, 0xc3, 0x42, 0x5f, 0xf9, 0xf1},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 392
    {SEC_OID_SHA384,
     392,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xa0, 0x49, 0xdc, 0xd9, 0x6c, 0x72, 0xe4,
      0xf3, 0x61, 0x44, 0xa5, 0x1b, 0xba, 0x30, 0x41, 0x7b, 0x45, 0x1a, 0x30,
      0x5d, 0xd0, 0x1c, 0x9e, 0x30, 0xa5, 0xe0, 0x4d, 0xf9, 0x43, 0x42, 0x61,
      0x7d, 0xc3, 0x83, 0xf1, 0x77, 0x27, 0x70, 0x8e, 0x32, 0x77, 0xcd, 0x72,
      0x46, 0xca, 0x44, 0x07, 0x41, 0x02, 0x30, 0x39, 0x70, 0xe2, 0x64, 0xd8,
      0x5b, 0x22, 0x8b, 0xf9, 0xe9, 0xb9, 0xc4, 0x94, 0x7c, 0x5d, 0xd0, 0x41,
      0xea, 0x8b, 0x5b, 0xde, 0x30, 0xb9, 0x3a, 0xa5, 0x9f, 0xed, 0xf2, 0xc4,
      0x28, 0xd3, 0xe2, 0x54, 0x0a, 0x54, 0xe0, 0x53, 0x06, 0x88, 0xac, 0xcc,
      0xb8, 0x3a, 0xc7, 0xb2, 0x9b, 0x79, 0xa2},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xaa, 0x63, 0xf1, 0xa2, 0x39, 0xac, 0x70, 0x19,
      0x7c, 0x6e, 0xbf, 0xce, 0xa5, 0x75, 0x6d, 0xc0, 0x12, 0x12, 0x3f, 0x82,
      0xc5, 0x1f, 0xa8, 0x74, 0xd6, 0x60, 0x28, 0xbe, 0x00, 0xe9, 0x76, 0xa1,
      0x08, 0x06, 0x06, 0x73, 0x7c, 0xc7, 0x5c, 0x40, 0xbd, 0xfe, 0x4a, 0xac,
      0xac, 0xbd, 0x85, 0x38, 0x90, 0x88, 0xa6, 0x2a, 0x63, 0x98, 0x38, 0x4c,
      0x22, 0xb5, 0x2d, 0x49, 0x2f, 0x23, 0xf4, 0x6e, 0x4a, 0x27, 0xa4, 0x72,
      0x4a, 0xd5, 0x55, 0x51, 0xda, 0x5c, 0x48, 0x34, 0x38, 0x09, 0x5a, 0x24,
      0x7c, 0xb0, 0xc3, 0x37, 0x8f, 0x1f, 0x52, 0xc3, 0x42, 0x5f, 0xf9, 0xf1},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is large
    // tcID: 393
    {SEC_OID_SHA384,
     393,
     {0x30, 0x65, 0x02, 0x30, 0x44, 0x18, 0x00, 0xea, 0x93, 0x77, 0xc2, 0x78,
      0x65, 0xbe, 0x00, 0x0a, 0xd0, 0x08, 0xeb, 0x3d, 0x75, 0x02, 0xbd, 0xd1,
      0x05, 0x82, 0x4b, 0x26, 0xd1, 0x5c, 0xf3, 0xd0, 0x64, 0x52, 0x96, 0x9a,
      0x9d, 0x06, 0x07, 0xa9, 0x15, 0xa8, 0xfe, 0x98, 0x92, 0x15, 0xfc, 0x4d,
      0x61, 0xaf, 0x6e, 0x05, 0x02, 0x31, 0x00, 0xdc, 0xe2, 0x9f, 0xaa, 0x51,
      0x37, 0xf7, 0x5a, 0xd7, 0x7e, 0x03, 0x91, 0x8c, 0x8e, 0xe6, 0x74, 0x7c,
      0xc7, 0xa3, 0x9b, 0x0a, 0x69, 0xf8, 0xb9, 0x15, 0x65, 0x4c, 0xac, 0x4c,
      0xf4, 0xbf, 0xd9, 0xc8, 0x7c, 0xc4, 0x6a, 0xe1, 0x63, 0x1b, 0x5c, 0x6b,
      0xae, 0xbd, 0x4f, 0xc0, 0x8f, 0xf8, 0xfd},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xff, 0xff, 0xff, 0xff, 0xaa, 0x63, 0xf1, 0xa2, 0x39, 0xac, 0x70, 0x19,
      0x7c, 0x6e, 0xbf, 0xce, 0xa5, 0x75, 0x6d, 0xc0, 0x12, 0x12, 0x3f, 0x82,
      0xc5, 0x1f, 0xa8, 0x74, 0xd6, 0x60, 0x28, 0xbe, 0x00, 0xe9, 0x76, 0xa1,
      0x08, 0x06, 0x06, 0x73, 0x7c, 0xc7, 0x5c, 0x40, 0xbd, 0xfe, 0x4a, 0xac,
      0xac, 0xbd, 0x85, 0x38, 0x90, 0x88, 0xa6, 0x2a, 0x63, 0x98, 0x38, 0x4c,
      0x22, 0xb5, 0x2d, 0x49, 0x2f, 0x23, 0xf4, 0x6e, 0x4a, 0x27, 0xa4, 0x72,
      0x4a, 0xd5, 0x55, 0x51, 0xda, 0x5c, 0x48, 0x34, 0x38, 0x09, 0x5a, 0x24,
      0x7c, 0xb0, 0xc3, 0x37, 0x8f, 0x1f, 0x52, 0xc3, 0x42, 0x5f, 0xf9, 0xf1},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 394
    {SEC_OID_SHA384,
     394,
     {0x30, 0x64, 0x02, 0x30, 0x32, 0x44, 0x76, 0x80, 0x16, 0x45, 0x7c, 0x46,
      0x3b, 0x74, 0xf2, 0x09, 0x7f, 0x21, 0x6d, 0x96, 0x70, 0xb1, 0x91, 0xf7,
      0x62, 0x81, 0xc7, 0x4b, 0xc6, 0xa1, 0xa1, 0x97, 0x1d, 0x19, 0xf2, 0x09,
      0xbf, 0x46, 0x96, 0x46, 0x8f, 0x5e, 0xb7, 0x5d, 0x63, 0x26, 0xa0, 0xa4,
      0x3c, 0x0a, 0x65, 0x29, 0x02, 0x30, 0x50, 0x1e, 0x0a, 0xd9, 0x85, 0xed,
      0x9f, 0x95, 0x69, 0x7b, 0xd1, 0x7f, 0xdb, 0xe3, 0xf9, 0xca, 0x92, 0xe0,
      0xf7, 0x64, 0x26, 0xd3, 0x66, 0x4e, 0x68, 0x96, 0x64, 0x8d, 0x9c, 0x75,
      0x0b, 0xf5, 0x88, 0xd0, 0xce, 0x7d, 0x01, 0x1c, 0x1a, 0x1e, 0x8d, 0x6c,
      0x2e, 0x08, 0x24, 0x22, 0xdc, 0x93},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd1, 0x82, 0x7f, 0xc6, 0xf6, 0xf1, 0x2f, 0x21, 0x99, 0x2c, 0x5a, 0x40,
      0x9a, 0x06, 0x53, 0xb1, 0x21, 0xd2, 0xef, 0x02, 0xb2, 0xb0, 0xab, 0x01,
      0xa9, 0x16, 0x1c, 0xe9, 0x56, 0x28, 0x07, 0x40, 0xb1, 0xe3, 0x56, 0xb2,
      0x55, 0x70, 0x1b, 0x0a, 0x6d, 0xdc, 0x9e, 0xc2, 0xca, 0x8a, 0x94, 0x22,
      0xc6, 0xed, 0x5d, 0x2c, 0xed, 0x8d, 0x8a, 0xb7, 0x56, 0x0f, 0xa5, 0xbb,
      0x88, 0xc7, 0x38, 0xe7, 0x45, 0x41, 0x88, 0x3d, 0x8a, 0x2b, 0x1c, 0x0e,
      0x2b, 0xa7, 0xe3, 0x6d, 0x03, 0x0f, 0xc4, 0xd9, 0xbf, 0xb8, 0xb2, 0x2f,
      0x24, 0xdb, 0x89, 0x7e, 0xba, 0xc4, 0x9d, 0xd4, 0x00, 0x00, 0x00, 0x00},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 395
    {SEC_OID_SHA384,
     395,
     {0x30, 0x64, 0x02, 0x30, 0x5e, 0x1a, 0xf4, 0x0f, 0x24, 0x80, 0xe3, 0xd9,
      0x7c, 0x4a, 0xe4, 0xbf, 0xd3, 0x4a, 0x9f, 0x45, 0x26, 0x92, 0x41, 0x35,
      0x6f, 0x3a, 0x46, 0xbe, 0xcd, 0x86, 0xa4, 0xa7, 0xc9, 0x71, 0x6d, 0x73,
      0xca, 0x5a, 0xeb, 0xdb, 0x3d, 0xb1, 0xa7, 0x76, 0x56, 0x50, 0x66, 0x66,
      0x83, 0xbc, 0x85, 0x6b, 0x02, 0x30, 0x7e, 0x7c, 0x4b, 0x47, 0x3a, 0x2b,
      0xaa, 0xa4, 0x95, 0x37, 0x85, 0xbe, 0x8a, 0xa2, 0xa1, 0x00, 0x06, 0xf6,
      0xd3, 0x6b, 0x40, 0x0a, 0xb9, 0x81, 0x86, 0x4d, 0x69, 0xce, 0xce, 0xc0,
      0x46, 0x71, 0x8d, 0x04, 0x04, 0xb9, 0x64, 0x74, 0x54, 0xb1, 0x59, 0xaa,
      0x5a, 0x92, 0xd7, 0x6d, 0x79, 0x55},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd1, 0x82, 0x7f, 0xc6, 0xf6, 0xf1, 0x2f, 0x21, 0x99, 0x2c, 0x5a, 0x40,
      0x9a, 0x06, 0x53, 0xb1, 0x21, 0xd2, 0xef, 0x02, 0xb2, 0xb0, 0xab, 0x01,
      0xa9, 0x16, 0x1c, 0xe9, 0x56, 0x28, 0x07, 0x40, 0xb1, 0xe3, 0x56, 0xb2,
      0x55, 0x70, 0x1b, 0x0a, 0x6d, 0xdc, 0x9e, 0xc2, 0xca, 0x8a, 0x94, 0x22,
      0xc6, 0xed, 0x5d, 0x2c, 0xed, 0x8d, 0x8a, 0xb7, 0x56, 0x0f, 0xa5, 0xbb,
      0x88, 0xc7, 0x38, 0xe7, 0x45, 0x41, 0x88, 0x3d, 0x8a, 0x2b, 0x1c, 0x0e,
      0x2b, 0xa7, 0xe3, 0x6d, 0x03, 0x0f, 0xc4, 0xd9, 0xbf, 0xb8, 0xb2, 0x2f,
      0x24, 0xdb, 0x89, 0x7e, 0xba, 0xc4, 0x9d, 0xd4, 0x00, 0x00, 0x00, 0x00},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key has many trailing 0's
    // tcID: 396
    {SEC_OID_SHA384,
     396,
     {0x30, 0x65, 0x02, 0x30, 0x66, 0x88, 0xe3, 0x6a, 0x26, 0xf1, 0x5b, 0xdc,
      0x1c, 0x3f, 0x91, 0x36, 0x7f, 0x8a, 0x76, 0x67, 0xf7, 0xbb, 0x3e, 0x30,
      0xa3, 0x35, 0xd6, 0xf0, 0x90, 0x0e, 0x95, 0x34, 0xeb, 0x88, 0xb2, 0x60,
      0xcb, 0x29, 0x34, 0x4c, 0x72, 0x3f, 0xed, 0xfb, 0xe7, 0xac, 0x9c, 0x5a,
      0x33, 0xf4, 0xbf, 0x0d, 0x02, 0x31, 0x00, 0xaa, 0x35, 0xfd, 0xdf, 0x0f,
      0xdc, 0x90, 0x17, 0x86, 0x0b, 0x37, 0x8f, 0x80, 0x1c, 0xd8, 0x06, 0xf3,
      0xe2, 0xd7, 0x54, 0xcd, 0x2f, 0xd9, 0x4e, 0xb7, 0xbb, 0x36, 0xa4, 0x6c,
      0xe8, 0x28, 0xce, 0xf8, 0x7e, 0x9e, 0xbb, 0xf4, 0x47, 0x06, 0x8e, 0x63,
      0x0b, 0x87, 0xfe, 0xe3, 0x85, 0xad, 0x8f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xd1, 0x82, 0x7f, 0xc6, 0xf6, 0xf1, 0x2f, 0x21, 0x99, 0x2c, 0x5a, 0x40,
      0x9a, 0x06, 0x53, 0xb1, 0x21, 0xd2, 0xef, 0x02, 0xb2, 0xb0, 0xab, 0x01,
      0xa9, 0x16, 0x1c, 0xe9, 0x56, 0x28, 0x07, 0x40, 0xb1, 0xe3, 0x56, 0xb2,
      0x55, 0x70, 0x1b, 0x0a, 0x6d, 0xdc, 0x9e, 0xc2, 0xca, 0x8a, 0x94, 0x22,
      0xc6, 0xed, 0x5d, 0x2c, 0xed, 0x8d, 0x8a, 0xb7, 0x56, 0x0f, 0xa5, 0xbb,
      0x88, 0xc7, 0x38, 0xe7, 0x45, 0x41, 0x88, 0x3d, 0x8a, 0x2b, 0x1c, 0x0e,
      0x2b, 0xa7, 0xe3, 0x6d, 0x03, 0x0f, 0xc4, 0xd9, 0xbf, 0xb8, 0xb2, 0x2f,
      0x24, 0xdb, 0x89, 0x7e, 0xba, 0xc4, 0x9d, 0xd4, 0x00, 0x00, 0x00, 0x00},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 0's
    // tcID: 397
    {SEC_OID_SHA384,
     397,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xd4, 0xa8, 0xf3, 0xb0, 0xb4, 0xd3, 0xa5,
      0x76, 0x9e, 0x3a, 0x0b, 0xbc, 0x64, 0x4b, 0x35, 0xf1, 0xd5, 0x09, 0x35,
      0x5e, 0xd1, 0xfe, 0x40, 0x1e, 0x17, 0x0f, 0x66, 0x7b, 0x66, 0x1f, 0x69,
      0x3b, 0x32, 0x59, 0x8e, 0x8c, 0x14, 0x3a, 0x81, 0x7a, 0x95, 0x89, 0x82,
      0x84, 0x50, 0x42, 0xbb, 0x48, 0x02, 0x30, 0x04, 0xcc, 0x07, 0x57, 0x8b,
      0xbd, 0x19, 0x81, 0xdb, 0xf6, 0xe8, 0xa9, 0x7a, 0x35, 0x4c, 0x98, 0xd4,
      0x1b, 0x8b, 0x6f, 0x6e, 0x8a, 0x2c, 0x2b, 0x17, 0x63, 0xc7, 0xc2, 0xa2,
      0x9d, 0x79, 0xe2, 0x4f, 0x84, 0x76, 0x07, 0x5c, 0x9a, 0xed, 0x9a, 0xec,
      0x6c, 0x64, 0xdf, 0xf5, 0x04, 0x61, 0xae},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x10, 0x99, 0xbb, 0x45, 0x10, 0x0f, 0x55, 0xf5, 0xa8, 0x5c, 0xca, 0x3d,
      0xe2, 0xb3, 0xbd, 0x5e, 0x25, 0x0f, 0x4f, 0x6f, 0xad, 0x66, 0x31, 0xa3,
      0x15, 0x6c, 0x2e, 0x52, 0xa3, 0x3d, 0x7d, 0x61, 0x5d, 0xd2, 0x79, 0xf7,
      0x9f, 0x8b, 0x4b, 0xaf, 0xf7, 0xc7, 0x13, 0xac, 0x00, 0x00, 0x00, 0x00,
      0xe6, 0xc9, 0xb7, 0x36, 0xa8, 0x92, 0x9f, 0x2e, 0xd7, 0xbe, 0x0c, 0x75,
      0x3a, 0x54, 0xcb, 0xb4, 0x8b, 0x84, 0x69, 0xe0, 0x41, 0x1e, 0xaf, 0x93,
      0xa4, 0xa8, 0x24, 0x59, 0xba, 0x0b, 0x68, 0x1b, 0xba, 0x8f, 0x5f, 0xb3,
      0x83, 0xb4, 0x90, 0x6d, 0x49, 0x01, 0xa3, 0x30, 0x3e, 0x2f, 0x15, 0x57},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 0's
    // tcID: 398
    {SEC_OID_SHA384,
     398,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xc2, 0x86, 0xd1, 0x92, 0x8e, 0x9c, 0x79,
      0xfd, 0xd3, 0xbe, 0xbd, 0xf2, 0x2a, 0x1d, 0xbd, 0x37, 0xc8, 0x10, 0x5e,
      0x8e, 0xcf, 0x41, 0xe9, 0xe3, 0x77, 0x7f, 0xe3, 0x41, 0xb6, 0xb8, 0xd5,
      0xa8, 0x9b, 0x9d, 0x98, 0x68, 0x27, 0xd6, 0xd1, 0xdb, 0xb3, 0x81, 0xcd,
      0x82, 0x39, 0x48, 0x4a, 0x22, 0x02, 0x30, 0x20, 0x11, 0x19, 0xae, 0x30,
      0x5b, 0x93, 0x60, 0xaa, 0x9b, 0x5e, 0x5d, 0x15, 0x67, 0xe0, 0x67, 0x4c,
      0x09, 0xe4, 0xf0, 0x25, 0x55, 0x6e, 0xbf, 0x81, 0xb9, 0x87, 0x46, 0x6b,
      0x0f, 0x42, 0x1b, 0x8d, 0x31, 0xf7, 0x2b, 0xbe, 0x95, 0xf3, 0xce, 0x2a,
      0xa9, 0x87, 0x4a, 0x84, 0xed, 0xfd, 0x40},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x10, 0x99, 0xbb, 0x45, 0x10, 0x0f, 0x55, 0xf5, 0xa8, 0x5c, 0xca, 0x3d,
      0xe2, 0xb3, 0xbd, 0x5e, 0x25, 0x0f, 0x4f, 0x6f, 0xad, 0x66, 0x31, 0xa3,
      0x15, 0x6c, 0x2e, 0x52, 0xa3, 0x3d, 0x7d, 0x61, 0x5d, 0xd2, 0x79, 0xf7,
      0x9f, 0x8b, 0x4b, 0xaf, 0xf7, 0xc7, 0x13, 0xac, 0x00, 0x00, 0x00, 0x00,
      0xe6, 0xc9, 0xb7, 0x36, 0xa8, 0x92, 0x9f, 0x2e, 0xd7, 0xbe, 0x0c, 0x75,
      0x3a, 0x54, 0xcb, 0xb4, 0x8b, 0x84, 0x69, 0xe0, 0x41, 0x1e, 0xaf, 0x93,
      0xa4, 0xa8, 0x24, 0x59, 0xba, 0x0b, 0x68, 0x1b, 0xba, 0x8f, 0x5f, 0xb3,
      0x83, 0xb4, 0x90, 0x6d, 0x49, 0x01, 0xa3, 0x30, 0x3e, 0x2f, 0x15, 0x57},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key has many trailing 0's
    // tcID: 399
    {SEC_OID_SHA384,
     399,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xd9, 0xc6, 0x78, 0x55, 0x01, 0x67, 0xf1,
      0x0c, 0x51, 0x1e, 0x62, 0xac, 0xb4, 0xbd, 0x0a, 0x3f, 0x7f, 0x33, 0x6b,
      0xc0, 0x90, 0xc9, 0x4e, 0x6c, 0x6b, 0x02, 0x62, 0x24, 0x39, 0xc3, 0x48,
      0xa2, 0x15, 0x9c, 0x5f, 0x41, 0xf9, 0xb5, 0xaa, 0x4b, 0x47, 0x05, 0x90,
      0xd4, 0x0d, 0xcd, 0x7c, 0xc2, 0x02, 0x30, 0x1f, 0xd5, 0xea, 0xee, 0x29,
      0x5a, 0xbb, 0x40, 0x81, 0xcb, 0x62, 0x67, 0x45, 0xf4, 0xad, 0x27, 0x9c,
      0xeb, 0x44, 0x60, 0x40, 0x62, 0x83, 0x0b, 0x58, 0xe6, 0xc0, 0x46, 0x5c,
      0x56, 0x2d, 0x41, 0xf0, 0x2b, 0xa5, 0x88, 0xfc, 0x0d, 0xb1, 0xeb, 0xbe,
      0x33, 0x9c, 0xdc, 0x00, 0x8d, 0x7a, 0x1b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x10, 0x99, 0xbb, 0x45, 0x10, 0x0f, 0x55, 0xf5, 0xa8, 0x5c, 0xca, 0x3d,
      0xe2, 0xb3, 0xbd, 0x5e, 0x25, 0x0f, 0x4f, 0x6f, 0xad, 0x66, 0x31, 0xa3,
      0x15, 0x6c, 0x2e, 0x52, 0xa3, 0x3d, 0x7d, 0x61, 0x5d, 0xd2, 0x79, 0xf7,
      0x9f, 0x8b, 0x4b, 0xaf, 0xf7, 0xc7, 0x13, 0xac, 0x00, 0x00, 0x00, 0x00,
      0xe6, 0xc9, 0xb7, 0x36, 0xa8, 0x92, 0x9f, 0x2e, 0xd7, 0xbe, 0x0c, 0x75,
      0x3a, 0x54, 0xcb, 0xb4, 0x8b, 0x84, 0x69, 0xe0, 0x41, 0x1e, 0xaf, 0x93,
      0xa4, 0xa8, 0x24, 0x59, 0xba, 0x0b, 0x68, 0x1b, 0xba, 0x8f, 0x5f, 0xb3,
      0x83, 0xb4, 0x90, 0x6d, 0x49, 0x01, 0xa3, 0x30, 0x3e, 0x2f, 0x15, 0x57},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 400
    {SEC_OID_SHA384,
     400,
     {0x30, 0x65, 0x02, 0x30, 0x20, 0xfe, 0xe7, 0xc7, 0x1b, 0x6c, 0xb0, 0xd1,
      0xda, 0x36, 0x41, 0xec, 0x66, 0x22, 0xc0, 0x55, 0xa3, 0xb1, 0x6a, 0x1f,
      0x59, 0x6c, 0x64, 0xb3, 0x4d, 0xa1, 0xb2, 0xd0, 0xb8, 0x68, 0xb6, 0x6a,
      0x8f, 0x0a, 0x0d, 0x0d, 0xb9, 0x83, 0xb3, 0xdc, 0x7e, 0x53, 0xbb, 0x72,
      0x95, 0xda, 0x81, 0x97, 0x02, 0x31, 0x00, 0x81, 0x41, 0xa9, 0x31, 0xd3,
      0x57, 0x9a, 0xec, 0x1c, 0xac, 0x98, 0x87, 0xd2, 0xff, 0xf9, 0xc6, 0xf1,
      0x2d, 0x47, 0xa2, 0x7e, 0x4a, 0xab, 0x8c, 0xf2, 0x62, 0xa9, 0xd1, 0x4a,
      0x71, 0x5b, 0xca, 0x0b, 0x20, 0x57, 0xcb, 0xc3, 0xf1, 0x8b, 0x6f, 0xd3,
      0xd1, 0xdf, 0x76, 0xf7, 0x41, 0x0f, 0x16},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x2b, 0x08, 0x9e, 0xdd, 0x75, 0x41, 0x69, 0x01,
      0x01, 0x45, 0xf2, 0x63, 0xf3, 0x34, 0xfc, 0x16, 0x7c, 0xc1, 0x9d, 0xae,
      0x82, 0x25, 0x97, 0x0a, 0xe1, 0x9c, 0xc8, 0xcb, 0x7e, 0xc7, 0x35, 0x93,
      0xd6, 0xa4, 0x65, 0xc3, 0x70, 0xf5, 0x47, 0x8b, 0x0e, 0x53, 0x9d, 0x69,
      0xd1, 0x95, 0x1d, 0x59, 0x7b, 0x56, 0xa6, 0x73, 0x45, 0xac, 0xb2, 0x58,
      0x09, 0x58, 0x1f, 0x07, 0xcd, 0x0e, 0xb7, 0x8d, 0x95, 0x38, 0xa3, 0xf8,
      0xa6, 0x5f, 0x30, 0x0e, 0x68, 0xa1, 0xeb, 0x78, 0x50, 0x7d, 0xf7, 0x6d,
      0xe6, 0x50, 0xe8, 0xf8, 0xee, 0x63, 0xa5, 0xf0, 0xc5, 0x68, 0x7c, 0x98},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 401
    {SEC_OID_SHA384,
     401,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0x91, 0x3e, 0xec, 0xc5, 0x59, 0xb3, 0xcf,
      0x71, 0x08, 0xa6, 0x5d, 0x6c, 0xc3, 0x07, 0x6b, 0xfd, 0xf3, 0x6c, 0x6f,
      0x94, 0xdc, 0xc6, 0x69, 0x3d, 0x06, 0x69, 0x04, 0x70, 0xf3, 0x4a, 0x2e,
      0x81, 0x56, 0x42, 0x41, 0xe1, 0xde, 0x5f, 0x5f, 0x51, 0x42, 0x1d, 0xe3,
      0x0a, 0xf4, 0x67, 0xf1, 0x0f, 0x02, 0x30, 0x64, 0x9b, 0xd3, 0x71, 0x72,
      0x44, 0xe8, 0xef, 0x3c, 0x6b, 0x0e, 0xda, 0x98, 0x3f, 0x84, 0xdc, 0xa5,
      0xea, 0x86, 0xd1, 0xbe, 0xc1, 0x53, 0x86, 0xb9, 0xc4, 0x73, 0xec, 0x43,
      0xa8, 0xcd, 0x0b, 0xa5, 0x58, 0xee, 0xe8, 0x19, 0xf7, 0x91, 0xd9, 0xff,
      0x92, 0x72, 0xb9, 0xaf, 0xd5, 0x95, 0x51},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x2b, 0x08, 0x9e, 0xdd, 0x75, 0x41, 0x69, 0x01,
      0x01, 0x45, 0xf2, 0x63, 0xf3, 0x34, 0xfc, 0x16, 0x7c, 0xc1, 0x9d, 0xae,
      0x82, 0x25, 0x97, 0x0a, 0xe1, 0x9c, 0xc8, 0xcb, 0x7e, 0xc7, 0x35, 0x93,
      0xd6, 0xa4, 0x65, 0xc3, 0x70, 0xf5, 0x47, 0x8b, 0x0e, 0x53, 0x9d, 0x69,
      0xd1, 0x95, 0x1d, 0x59, 0x7b, 0x56, 0xa6, 0x73, 0x45, 0xac, 0xb2, 0x58,
      0x09, 0x58, 0x1f, 0x07, 0xcd, 0x0e, 0xb7, 0x8d, 0x95, 0x38, 0xa3, 0xf8,
      0xa6, 0x5f, 0x30, 0x0e, 0x68, 0xa1, 0xeb, 0x78, 0x50, 0x7d, 0xf7, 0x6d,
      0xe6, 0x50, 0xe8, 0xf8, 0xee, 0x63, 0xa5, 0xf0, 0xc5, 0x68, 0x7c, 0x98},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: x-coordinate of the public key is small
    // tcID: 402
    {SEC_OID_SHA384,
     402,
     {0x30, 0x64, 0x02, 0x30, 0x23, 0x85, 0x5c, 0x46, 0x40, 0x3a, 0x97, 0xb7,
      0x6c, 0xbb, 0x31, 0x6e, 0xc3, 0xfe, 0x7e, 0x2c, 0x42, 0x2b, 0x81, 0x83,
      0x87, 0x60, 0x4b, 0xda, 0x8c, 0x3d, 0x91, 0x12, 0x1b, 0x4f, 0x20, 0x17,
      0x9d, 0x91, 0x07, 0xc5, 0xf9, 0x2d, 0xed, 0xc8, 0xb6, 0x20, 0xd7, 0xdb,
      0x87, 0xfc, 0xcc, 0xcd, 0x02, 0x30, 0x50, 0xf5, 0x73, 0x43, 0xab, 0x14,
      0x8e, 0x50, 0x66, 0x23, 0x20, 0xc4, 0x16, 0x1e, 0x44, 0x54, 0x3c, 0x35,
      0xbc, 0x99, 0x20, 0x11, 0xea, 0x5b, 0x16, 0x80, 0xb9, 0x43, 0x82, 0xcf,
      0x22, 0x4e, 0xa0, 0xec, 0x5d, 0xa5, 0x11, 0xe1, 0x02, 0xf5, 0x66, 0xcb,
      0x67, 0x20, 0x1f, 0x30, 0xa2, 0xee},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x2b, 0x08, 0x9e, 0xdd, 0x75, 0x41, 0x69, 0x01,
      0x01, 0x45, 0xf2, 0x63, 0xf3, 0x34, 0xfc, 0x16, 0x7c, 0xc1, 0x9d, 0xae,
      0x82, 0x25, 0x97, 0x0a, 0xe1, 0x9c, 0xc8, 0xcb, 0x7e, 0xc7, 0x35, 0x93,
      0xd6, 0xa4, 0x65, 0xc3, 0x70, 0xf5, 0x47, 0x8b, 0x0e, 0x53, 0x9d, 0x69,
      0xd1, 0x95, 0x1d, 0x59, 0x7b, 0x56, 0xa6, 0x73, 0x45, 0xac, 0xb2, 0x58,
      0x09, 0x58, 0x1f, 0x07, 0xcd, 0x0e, 0xb7, 0x8d, 0x95, 0x38, 0xa3, 0xf8,
      0xa6, 0x5f, 0x30, 0x0e, 0x68, 0xa1, 0xeb, 0x78, 0x50, 0x7d, 0xf7, 0x6d,
      0xe6, 0x50, 0xe8, 0xf8, 0xee, 0x63, 0xa5, 0xf0, 0xc5, 0x68, 0x7c, 0x98},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 403
    {SEC_OID_SHA384,
     403,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xd2, 0x00, 0x95, 0x8d, 0x49, 0x1f, 0xce,
      0xbd, 0xe6, 0x67, 0xcd, 0x73, 0x6c, 0x9d, 0xba, 0x09, 0x61, 0xc7, 0x0d,
      0xb2, 0xec, 0xaf, 0x57, 0x3c, 0x31, 0xdd, 0x7f, 0xa4, 0x1e, 0xcc, 0xa3,
      0x2b, 0x40, 0xb5, 0x89, 0x6f, 0x9a, 0x0d, 0xdf, 0x27, 0x21, 0x10, 0xe3,
      0xd2, 0x1e, 0x84, 0x59, 0x3a, 0x02, 0x31, 0x00, 0xc2, 0xec, 0xf7, 0x39,
      0x43, 0xb9, 0xad, 0xce, 0x59, 0x6b, 0xac, 0x14, 0xfc, 0xe6, 0x24, 0x95,
      0xae, 0x93, 0x82, 0x5c, 0x5f, 0xf6, 0xf6, 0x1c, 0x24, 0x7d, 0x1d, 0x8a,
      0xfc, 0xba, 0x52, 0x08, 0x2f, 0xc9, 0x6f, 0x63, 0xa2, 0x6e, 0x55, 0xbc,
      0xcf, 0xc3, 0x77, 0x9f, 0x88, 0xcf, 0xd7, 0x99},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfb, 0x01, 0xba, 0xad, 0x5f, 0x0b, 0x8f, 0x79, 0xb9, 0xcd, 0x10, 0x4d,
      0x12, 0xaa, 0xb9, 0x31, 0x01, 0x46, 0xad, 0xd7, 0xd6, 0xb4, 0xc0, 0x22,
      0xd8, 0x7a, 0xe6, 0x71, 0x11, 0x78, 0xb9, 0x4d, 0x61, 0x8c, 0xa7, 0xb3,
      0xaf, 0x13, 0x85, 0x4b, 0x1c, 0x58, 0x88, 0x79, 0xe8, 0x77, 0xb3, 0x36,
      0x00, 0x00, 0x00, 0x00, 0x20, 0x8b, 0x3f, 0x5a, 0xd3, 0xb3, 0x93, 0x7a,
      0xcc, 0x9d, 0x60, 0x6c, 0xc5, 0xec, 0xec, 0xab, 0x4a, 0x70, 0x1f, 0x75,
      0xed, 0x42, 0x95, 0x7e, 0xa4, 0xd7, 0x85, 0x8d, 0x33, 0xf5, 0xc2, 0x6c,
      0x6a, 0xe2, 0x0a, 0x9c, 0xcc, 0xda, 0x56, 0x99, 0x67, 0x00, 0xd6, 0xb4},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 404
    {SEC_OID_SHA384,
     404,
     {0x30, 0x64, 0x02, 0x30, 0x6a, 0xc1, 0x7d, 0x71, 0x26, 0x0c, 0x79, 0xf8,
      0x1a, 0x75, 0x66, 0x12, 0x47, 0x38, 0xcb, 0x3e, 0xe5, 0xd0, 0xaa, 0x69,
      0x0e, 0x73, 0xa9, 0x8a, 0xe9, 0xe7, 0x66, 0xf1, 0x33, 0x66, 0x91, 0xe5,
      0x00, 0xca, 0xd5, 0x1b, 0xa1, 0x30, 0x23, 0x66, 0xc0, 0x9c, 0xc0, 0x6b,
      0x8f, 0x70, 0x49, 0xe0, 0x02, 0x30, 0x32, 0xca, 0x96, 0x5d, 0x6d, 0x70,
      0x12, 0xec, 0x18, 0x7c, 0x7c, 0xab, 0x95, 0x44, 0x33, 0x4d, 0x66, 0xc2,
      0xa7, 0x65, 0x8d, 0xde, 0xfa, 0x67, 0xe4, 0xad, 0x40, 0x42, 0x98, 0x15,
      0x51, 0x8e, 0xcc, 0x87, 0xb1, 0x49, 0x2d, 0xdd, 0x57, 0x33, 0x3b, 0xd2,
      0x30, 0x0b, 0x46, 0x60, 0xa8, 0x35},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfb, 0x01, 0xba, 0xad, 0x5f, 0x0b, 0x8f, 0x79, 0xb9, 0xcd, 0x10, 0x4d,
      0x12, 0xaa, 0xb9, 0x31, 0x01, 0x46, 0xad, 0xd7, 0xd6, 0xb4, 0xc0, 0x22,
      0xd8, 0x7a, 0xe6, 0x71, 0x11, 0x78, 0xb9, 0x4d, 0x61, 0x8c, 0xa7, 0xb3,
      0xaf, 0x13, 0x85, 0x4b, 0x1c, 0x58, 0x88, 0x79, 0xe8, 0x77, 0xb3, 0x36,
      0x00, 0x00, 0x00, 0x00, 0x20, 0x8b, 0x3f, 0x5a, 0xd3, 0xb3, 0x93, 0x7a,
      0xcc, 0x9d, 0x60, 0x6c, 0xc5, 0xec, 0xec, 0xab, 0x4a, 0x70, 0x1f, 0x75,
      0xed, 0x42, 0x95, 0x7e, 0xa4, 0xd7, 0x85, 0x8d, 0x33, 0xf5, 0xc2, 0x6c,
      0x6a, 0xe2, 0x0a, 0x9c, 0xcc, 0xda, 0x56, 0x99, 0x67, 0x00, 0xd6, 0xb4},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is small
    // tcID: 405
    {SEC_OID_SHA384,
     405,
     {0x30, 0x65, 0x02, 0x31, 0x00, 0xe1, 0x9a, 0x46, 0x46, 0xf0, 0xed, 0x8a,
      0x27, 0x1f, 0xe8, 0x6b, 0xa5, 0x33, 0xf8, 0xbe, 0x4f, 0xd8, 0x1b, 0xbf,
      0x46, 0x74, 0x71, 0x6f, 0x66, 0x8e, 0xfa, 0x89, 0xa4, 0x0c, 0xac, 0x51,
      0xee, 0xc2, 0xa6, 0xcf, 0xbd, 0x92, 0x32, 0x7d, 0x25, 0xef, 0xe9, 0x1c,
      0xa4, 0xff, 0x71, 0x2b, 0xc5, 0x02, 0x30, 0x4a, 0x86, 0xb2, 0xe8, 0xe1,
      0x23, 0x78, 0xe6, 0x33, 0xde, 0xc2, 0x69, 0x1e, 0x3b, 0x1e, 0xed, 0x4e,
      0x93, 0x2c, 0xc4, 0x8b, 0x28, 0xe4, 0x5f, 0xa3, 0xd4, 0x64, 0xcc, 0x0e,
      0x94, 0x8c, 0x02, 0xcc, 0x9d, 0xec, 0xf2, 0xbb, 0x43, 0xb2, 0x59, 0x37,
      0xfc, 0xf3, 0x7e, 0x9a, 0xd8, 0x6e, 0xf0},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfb, 0x01, 0xba, 0xad, 0x5f, 0x0b, 0x8f, 0x79, 0xb9, 0xcd, 0x10, 0x4d,
      0x12, 0xaa, 0xb9, 0x31, 0x01, 0x46, 0xad, 0xd7, 0xd6, 0xb4, 0xc0, 0x22,
      0xd8, 0x7a, 0xe6, 0x71, 0x11, 0x78, 0xb9, 0x4d, 0x61, 0x8c, 0xa7, 0xb3,
      0xaf, 0x13, 0x85, 0x4b, 0x1c, 0x58, 0x88, 0x79, 0xe8, 0x77, 0xb3, 0x36,
      0x00, 0x00, 0x00, 0x00, 0x20, 0x8b, 0x3f, 0x5a, 0xd3, 0xb3, 0x93, 0x7a,
      0xcc, 0x9d, 0x60, 0x6c, 0xc5, 0xec, 0xec, 0xab, 0x4a, 0x70, 0x1f, 0x75,
      0xed, 0x42, 0x95, 0x7e, 0xa4, 0xd7, 0x85, 0x8d, 0x33, 0xf5, 0xc2, 0x6c,
      0x6a, 0xe2, 0x0a, 0x9c, 0xcc, 0xda, 0x56, 0x99, 0x67, 0x00, 0xd6, 0xb4},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 406
    {SEC_OID_SHA384,
     406,
     {0x30, 0x64, 0x02, 0x30, 0x15, 0xaa, 0xc6, 0xc0, 0xf4, 0x35, 0xcb, 0x66,
      0x2d, 0x11, 0x0d, 0xb5, 0xcf, 0x68, 0x6c, 0xae, 0xe5, 0x3c, 0x64, 0xfe,
      0x2d, 0x6d, 0x60, 0x0a, 0x83, 0xeb, 0xe5, 0x05, 0xa0, 0xe6, 0xfc, 0x62,
      0xdc, 0x57, 0x05, 0x16, 0x04, 0x77, 0xc4, 0x75, 0x28, 0xc8, 0xc9, 0x03,
      0xfa, 0x86, 0x5b, 0x5d, 0x02, 0x30, 0x7f, 0x94, 0xdd, 0xc0, 0x1a, 0x60,
      0x3f, 0x9b, 0xec, 0x5d, 0x10, 0xc9, 0xf2, 0xc8, 0x9f, 0xb2, 0x3b, 0x3f,
      0xfa, 0xb6, 0xb2, 0xb6, 0x8d, 0x0f, 0x04, 0x33, 0x6d, 0x49, 0x90, 0x85,
      0xe3, 0x2d, 0x22, 0xbf, 0x3a, 0xb6, 0x7a, 0x49, 0xa7, 0x4c, 0x74, 0x3f,
      0x72, 0x47, 0x31, 0x72, 0xb5, 0x9f},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfb, 0x01, 0xba, 0xad, 0x5f, 0x0b, 0x8f, 0x79, 0xb9, 0xcd, 0x10, 0x4d,
      0x12, 0xaa, 0xb9, 0x31, 0x01, 0x46, 0xad, 0xd7, 0xd6, 0xb4, 0xc0, 0x22,
      0xd8, 0x7a, 0xe6, 0x71, 0x11, 0x78, 0xb9, 0x4d, 0x61, 0x8c, 0xa7, 0xb3,
      0xaf, 0x13, 0x85, 0x4b, 0x1c, 0x58, 0x88, 0x79, 0xe8, 0x77, 0xb3, 0x36,
      0xff, 0xff, 0xff, 0xff, 0xdf, 0x74, 0xc0, 0xa5, 0x2c, 0x4c, 0x6c, 0x85,
      0x33, 0x62, 0x9f, 0x93, 0x3a, 0x13, 0x13, 0x54, 0xb5, 0x8f, 0xe0, 0x8a,
      0x12, 0xbd, 0x6a, 0x81, 0x5b, 0x28, 0x7a, 0x71, 0xcc, 0x0a, 0x3d, 0x92,
      0x95, 0x1d, 0xf5, 0x63, 0x33, 0x25, 0xa9, 0x67, 0x98, 0xff, 0x29, 0x4b},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 407
    {SEC_OID_SHA384,
     407,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0x90, 0xb9, 0x5a, 0x7d, 0x19, 0x4b, 0x73,
      0x49, 0x8f, 0xba, 0x5a, 0xfc, 0x95, 0xc1, 0xae, 0xa9, 0xbe, 0x07, 0x31,
      0x62, 0xa9, 0xed, 0xc5, 0x7c, 0x4d, 0x12, 0xf4, 0x59, 0xf0, 0xa1, 0x73,
      0x0b, 0xaf, 0x2f, 0x87, 0xd7, 0xd6, 0x62, 0x4a, 0xea, 0x7b, 0x93, 0x1e,
      0xc5, 0x33, 0x70, 0xfe, 0x47, 0x02, 0x31, 0x00, 0xcb, 0xc1, 0xef, 0x47,
      0x0e, 0x66, 0x60, 0x10, 0x60, 0x4c, 0x60, 0x93, 0x84, 0xb8, 0x72, 0xdb,
      0x7f, 0xa7, 0xb8, 0xa5, 0xa9, 0xf2, 0x0f, 0xde, 0xfd, 0x65, 0x6b, 0xe2,
      0xfc, 0xc7, 0x5d, 0xb5, 0x39, 0x48, 0x10, 0x2f, 0x7a, 0xb2, 0x03, 0xea,
      0x18, 0x60, 0xa6, 0xa3, 0x2a, 0xf2, 0x46, 0xa1},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfb, 0x01, 0xba, 0xad, 0x5f, 0x0b, 0x8f, 0x79, 0xb9, 0xcd, 0x10, 0x4d,
      0x12, 0xaa, 0xb9, 0x31, 0x01, 0x46, 0xad, 0xd7, 0xd6, 0xb4, 0xc0, 0x22,
      0xd8, 0x7a, 0xe6, 0x71, 0x11, 0x78, 0xb9, 0x4d, 0x61, 0x8c, 0xa7, 0xb3,
      0xaf, 0x13, 0x85, 0x4b, 0x1c, 0x58, 0x88, 0x79, 0xe8, 0x77, 0xb3, 0x36,
      0xff, 0xff, 0xff, 0xff, 0xdf, 0x74, 0xc0, 0xa5, 0x2c, 0x4c, 0x6c, 0x85,
      0x33, 0x62, 0x9f, 0x93, 0x3a, 0x13, 0x13, 0x54, 0xb5, 0x8f, 0xe0, 0x8a,
      0x12, 0xbd, 0x6a, 0x81, 0x5b, 0x28, 0x7a, 0x71, 0xcc, 0x0a, 0x3d, 0x92,
      0x95, 0x1d, 0xf5, 0x63, 0x33, 0x25, 0xa9, 0x67, 0x98, 0xff, 0x29, 0x4b},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true},

    // Comment: y-coordinate of the public key is large
    // tcID: 408
    {SEC_OID_SHA384,
     408,
     {0x30, 0x66, 0x02, 0x31, 0x00, 0xdd, 0x43, 0x91, 0xce, 0x75, 0x57, 0xcb,
      0xd0, 0x05, 0xe3, 0xd5, 0xd7, 0x27, 0xcd, 0x26, 0x43, 0x99, 0xdc, 0xc3,
      0xc6, 0x50, 0x1e, 0x45, 0x47, 0x50, 0x5b, 0x6d, 0x57, 0xb4, 0x0b, 0xbf,
      0x0a, 0x7f, 0xac, 0x79, 0x4d, 0xcc, 0x8d, 0x42, 0x33, 0x15, 0x9d, 0xd0,
      0xaa, 0x40, 0xd4, 0xe0, 0xb9, 0x02, 0x31, 0x00, 0xa7, 0x7f, 0xa1, 0x37,
      0x4f, 0xd6, 0x0a, 0xa9, 0x16, 0x00, 0x91, 0x22, 0x00, 0xfc, 0x83, 0xc6,
      0xaa, 0x44, 0x7f, 0x81, 0x71, 0xec, 0xea, 0x72, 0xae, 0x32, 0x2d, 0xf3,
      0x2d, 0xcc, 0xd6, 0x89, 0x51, 0xdc, 0x5c, 0xaf, 0x6c, 0x50, 0x38, 0x0e,
      0x40, 0x0e, 0x45, 0xbf, 0x5c, 0x0e, 0x62, 0x6b},
     {0x30, 0x76, 0x30, 0x10, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02,
      0x01, 0x06, 0x05, 0x2b, 0x81, 0x04, 0x00, 0x22, 0x03, 0x62, 0x00, 0x04,
      0xfb, 0x01, 0xba, 0xad, 0x5f, 0x0b, 0x8f, 0x79, 0xb9, 0xcd, 0x10, 0x4d,
      0x12, 0xaa, 0xb9, 0x31, 0x01, 0x46, 0xad, 0xd7, 0xd6, 0xb4, 0xc0, 0x22,
      0xd8, 0x7a, 0xe6, 0x71, 0x11, 0x78, 0xb9, 0x4d, 0x61, 0x8c, 0xa7, 0xb3,
      0xaf, 0x13, 0x85, 0x4b, 0x1c, 0x58, 0x88, 0x79, 0xe8, 0x77, 0xb3, 0x36,
      0xff, 0xff, 0xff, 0xff, 0xdf, 0x74, 0xc0, 0xa5, 0x2c, 0x4c, 0x6c, 0x85,
      0x33, 0x62, 0x9f, 0x93, 0x3a, 0x13, 0x13, 0x54, 0xb5, 0x8f, 0xe0, 0x8a,
      0x12, 0xbd, 0x6a, 0x81, 0x5b, 0x28, 0x7a, 0x71, 0xcc, 0x0a, 0x3d, 0x92,
      0x95, 0x1d, 0xf5, 0x63, 0x33, 0x25, 0xa9, 0x67, 0x98, 0xff, 0x29, 0x4b},
     {0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65},
     true}};

#endif  // p384ecdsa_sha384_vectors_h__
