#!/usr/bin/perl
use 5.016;
use strict;
use warnings;

use DateTime;
use DateTime::Format::Mail;
use DateTime::Format::RFC3339;

while (my $l = <>) {
    chomp $l;
    my $mail = DateTime::Format::Mail->new->loose;
    my $dt = $mail->parse_datetime($l);
    my $rfc = DateTime::Format::RFC3339->new;
    say $rfc->format_datetime($dt);
}

1;

# vim: expandtab shiftwidth=4
