# getDirectoryToWatchFailedLookupLocation

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for UncDos root: //vda1cs4850/c$

## RootDirForResolution: //vda1cs4850/c$

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot/dir                                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot/folder1                                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot/folder1/dir                                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                                | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir                                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                                | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | false     |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot/dir                                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir                                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | false     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username                                                                               | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | false     |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user/dir                                                                                    | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user/username                                                                               | false     |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user/username/dir                                                                           | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | false     |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username                                                                                | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | false     |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr/dir                                                                                     | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr/username                                                                                | false     |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr/username/dir                                                                            | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr/username/folderAtRoot                                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr/username/folderAtRoot/dir                                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir                                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | false     |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home                                                                                        | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home                                                                                        | true      |

## RootDirForResolution: //vda1cs4850/c$/home

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home/username                                                                               | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username                                                                               | true      |

## RootDirForResolution: //vda1cs4850/c$/home/username

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home/username/dir                                                                           | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir                                                                           | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | true      |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home/username/dir                                                                           | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir                                                                           | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | true      |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                                                          | //vda1cs4850/c$/home                                                                                        | false     |
| //vda1cs4850/c$/home/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/home/dir                                                                                    | true      |
| //vda1cs4850/c$/home/username/somefile.d.ts                                                                 | //vda1cs4850/c$/home/username                                                                               | false     |
| //vda1cs4850/c$/home/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/home/username/dir                                                                           | true      |
| //vda1cs4850/c$/home/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/home/username/dir                                                                           | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/home/username/folderAtRoot                                                                  | false     |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/home/username/folderAtRoot/dir                                                              | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                          | false     |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/dir                                                      | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                                  | true      |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2

| Location                                                                                                    | getDirectoryToWatchFailedLookupLocation                                                                     | Recursive |
| ----------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------- | --------- |
| //vda1cs4850/c$/somefile.d.ts                                                                               |                                                                                                             |           |
| //vda1cs4850/c$/dir/somefile.d.ts                                                                           | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/dir/subdir/somefile.d.ts                                                                    | //vda1cs4850/c$/dir                                                                                         | true      |
| //vda1cs4850/c$/folderAtRoot/somefile.d.ts                                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/somefile.d.ts                                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/somefile.d.ts                                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/somefile.d.ts                                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/somefile.d.ts                                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                                  | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                              | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts                          | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts                      | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | //vda1cs4850/c$/folderAtRoot                                                                                | true      |
| //vda1cs4850/c$/users/somefile.d.ts                                                                         |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/somefile.d.ts                                                                     |                                                                                                             |           |
| //vda1cs4850/c$/users/dir/subdir/somefile.d.ts                                                              | //vda1cs4850/c$/users/dir/subdir                                                                            | true      |
| //vda1cs4850/c$/users/username/somefile.d.ts                                                                |                                                                                                             |           |
| //vda1cs4850/c$/users/username/dir/somefile.d.ts                                                            | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/dir/subdir/somefile.d.ts                                                     | //vda1cs4850/c$/users/username/dir                                                                          | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/somefile.d.ts                                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/somefile.d.ts                                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/somefile.d.ts                                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/somefile.d.ts                                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/somefile.d.ts                                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                   | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts               | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts           | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts       | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/users/username/folderAtRoot                                                                 | true      |
| //vda1cs4850/c$/user/somefile.d.ts                                                                          | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/somefile.d.ts                                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/dir/subdir/somefile.d.ts                                                               | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/somefile.d.ts                                                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/somefile.d.ts                                                             | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/dir/subdir/somefile.d.ts                                                      | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/somefile.d.ts                                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/somefile.d.ts                                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/somefile.d.ts                                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/somefile.d.ts                                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/somefile.d.ts                                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                    | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts            | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts        | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | //vda1cs4850/c$/user                                                                                        | true      |
| //vda1cs4850/c$/usr/somefile.d.ts                                                                           | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/somefile.d.ts                                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/dir/subdir/somefile.d.ts                                                                | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/somefile.d.ts                                                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/somefile.d.ts                                                              | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/dir/subdir/somefile.d.ts                                                       | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/somefile.d.ts                                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/somefile.d.ts                                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/somefile.d.ts                                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/somefile.d.ts                                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/somefile.d.ts                                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/somefile.d.ts                                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/somefile.d.ts                             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/somefile.d.ts                         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/somefile.d.ts                     | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/somefile.d.ts                 | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/somefile.d.ts             | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/somefile.d.ts         | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | //vda1cs4850/c$/usr                                                                                         | true      |
| //vda1cs4850/c$/home/somefile.d.ts                                     