#include "qpointfjs.h"
#include "jsclassregistrar.h"


namespace pappso
{

QPointFJs::QPointFJs(QObject *parent) : QObject(parent), m_pointf()
{
}

QPointFJs::QPointFJs(double x, double y, QObject *parent) : QObject(parent), m_pointf(x, y)
{
}

QPointFJs::QPointFJs(const QPointF &pointf, QObject *parent) : QObject(parent), m_pointf(pointf)
{
}

void
QPointFJs::setX(double x)
{
  if(m_pointf.x() != x)
    {
      m_pointf.rx() = x;
      emit xChanged();
    }
}

double
QPointFJs::x() const
{
  return m_pointf.x();
}


void
QPointFJs::setY(double y)
{
  if(m_pointf.y() != y)
    {
      m_pointf.ry() = y;
      emit yChanged();
    }
}

double
QPointFJs::y() const
{
  return m_pointf.y();
}

const QPointF &
QPointFJs::point() const
{
  return m_pointf;
}

void
QPointFJs::setPointF(const QPointF &pointf)
{
  m_pointf = pointf;
  emit xChanged();
  emit yChanged();
}

void
QPointFJs::registerJsConstructor(QJSEngine *engine)
{
  if(!engine)
    {
      qWarning() << "Cannot register class: engine is null";
      return;
    }

  // Register the meta object as a constructor
  QJSValue jsMetaObject = engine->newQMetaObject(&QPointFJs::staticMetaObject);
  engine->globalObject().setProperty("QPointF", jsMetaObject);
}

} // namespace pappso
