// Copyright (c) Meta Platforms, Inc. and affiliates.

#include "tests/utils.h"

#include "openzl/zl_compressor.h"
#include "openzl/zl_data.h"
#include "openzl/zl_reflection.h"

namespace zstrong {
namespace tests {

const std::string kEmptyTestInput = "";
const std::string kFooTestInput   = "foo";
const std::string kLoremTestInput =
        R"(Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec rhoncus augue. Proin ut diam tempus, egestas odio nec, placerat metus. Mauris fringilla neque vel ultricies malesuada. Maecenas tempor egestas leo, et imperdiet eros interdum quis. Nunc fringilla nisl a venenatis malesuada. Integer aliquet dolor et pharetra rutrum. Nullam sed elit congue, efficitur lorem a, convallis ligula. Etiam accumsan ligula tempus lacinia ultricies. Aliquam ipsum urna, ultricies non purus a, tempus rhoncus tortor. Quisque a quam est.

Nulla in ornare magna, quis auctor est. Nulla eget lectus a eros laoreet ornare. Mauris et arcu sed elit faucibus elementum sed non odio. In interdum a lacus vel iaculis. Sed feugiat sem at risus dignissim accumsan. Aliquam in est at erat finibus pharetra. Duis volutpat ullamcorper enim eu rhoncus.

Nulla neque mauris, maximus id massa a, interdum tempor urna. Fusce velit tortor, auctor ut ante ac, accumsan condimentum ex. Fusce nec convallis justo. Vestibulum maximus placerat pellentesque. Maecenas diam eros, aliquam quis vestibulum at, interdum et nulla. Morbi euismod ipsum vel hendrerit eleifend. Nunc gravida hendrerit felis ac faucibus. Nunc eget nunc sed purus placerat hendrerit in quis nulla. Nunc ipsum nisi, tempor scelerisque scelerisque nec, faucibus a nisl. Quisque ac nunc nunc. Nullam scelerisque ultricies est, sed elementum ex molestie ut.

Pellentesque aliquam tortor in velit porttitor, eu ullamcorper quam dictum. Morbi et orci ac libero vehicula facilisis. Etiam viverra in risus molestie ornare. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quisque vulputate ex sit amet urna imperdiet, et dapibus mauris malesuada. Sed sollicitudin sem felis, id gravida libero auctor eu. Nullam sit amet hendrerit nibh. Aenean sed turpis finibus, accumsan massa sit amet, ornare urna. Phasellus consectetur odio enim, quis hendrerit ligula tempus laoreet. Praesent nec sollicitudin massa. Ut nec elit a quam tempor pharetra. Mauris dignissim justo vel ante volutpat rutrum.

Donec pharetra pharetra justo, sit amet consequat velit. Vestibulum volutpat sapien ullamcorper lacinia iaculis. Suspendisse potenti. Etiam mattis tincidunt rutrum. Vivamus ac aliquet neque. Vestibulum vulputate vulputate ullamcorper. Nullam nec dui at elit pharetra vestibulum sed iaculis risus. Curabitur et tortor mollis, eleifend eros eget, lacinia urna. Integer vitae nibh tempus, congue dolor eu, bibendum nunc. Maecenas a sapien ultricies, placerat eros et, luctus quam. Nulla vel efficitur urna, ac viverra mauris. Donec id ultrices mauris, eu consectetur sapien. Integer in tempus augue. Fusce scelerisque tellus libero, tempor consectetur justo lobortis a. Ut urna sem, gravida nec nulla non, dignissim porta arcu.)";

const std::string kUniqueCharsTestInput =
        "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ!@#$%^&*()<>,./?;:'\"";

const std::string kMoviesCsvFormatInput =
        R"("Year","Score","Title" 
1968,86,"Greetings"
1970,17,"Bloody Mama"
1970,73,"Hi, Mom!"
1971,40,"Born to Win"
1973,98,"Mean Streets"
1973,88,"Bang the Drum Slowly"
1974,97,"The Godfather, Part II"
1976,41,"The Last Tycoon"
1976,99,"Taxi Driver"
1977,47,"1900"
1977,67,"New York, New York"
1978,93,"The Deer Hunter"
1980,97,"Raging Bull"
1981,75,True Confessions
1983,90,"The King of Comedy"
1984,89,"Once Upon a Time in America"
1984,60,"Falling in Love"
1985,98,"Brazil"
1986,65,"The Mission"
1987,100,"Dear America: Letters Home From Vietnam"
1987,80,"The Untouchables"
1987,78,"Angel Heart"
1988,96,"Midnight Run"
1989,64,"Jacknife"
1989,47,"We're No Angels"
1990,88,"Awakenings"
1990,29,"Stanley & Iris"
1990,96,"Goodfellas"
1991,76,"Cape Fear"
1991,69,"Mistress"
1991,65,"Guilty by Suspicion"
1991,71,"Backdraft"
1992,87,"Thunderheart"
1992,67,"Night and the City"
1993,75,"This Boy's Life"
1993,78,"Mad Dog and Glory"
1993,96,"A Bronx Tale"
1994,39,"Mary Shelley's Frankenstein"
1995,80,"Casino"
1995,86,"Heat"
1996,74,"Sleepers"
1996,38,"The Fan"
1996,80,"Marvin's Room"
1997,85,"Wag the Dog"
1997,87,"Jackie Brown"
1997,72,"Cop Land"
1998,68,"Ronin"
1998,38,"Great Expectations"
1999,69,"Analyze This"
1999,43,"Flawless"
2000,43,"The Adventures of Rocky & Bullwinkle"
2000,84,"Meet the Parents"
2000,41,"Men of Honor"
2001,73,"The Score"
2001,33,"15 Minutes"
2002,48,"City by the Sea"
2002,27,"Analyze That"
2003,4,"Godsend"
2004,35,"Shark Tale"
2004,38,"Meet the Fockers"
2005,4,"The Bridge of San Luis Rey"
2005,46,"Rent"
2005,13,"Hide and Seek"
2006,54,"The Good Shepherd"
2007,21,"Arthur and the Invisibles"
2007,76,"Captain Shakespeare"
2008,19,"Righteous Kill"
2008,51,"What Just Happened?"
2009,46,"Everybody's Fine"
2010,72,"Machete"
2010,10,"Little Fockers"
2010,50,"Stone"
2011,25,"Killer Elite"
2011,7,"New Year's Eve"
2011,70,"Limitless"
2012,92,"Silver Linings Playbook"
2012,51,"Being Flynn"
2012,29,"Red Lights"
2013,46,"Last Vegas"
2013,7,"The Big Wedding"
2013,29,"Grudge Match"
2013,11,"Killing Season"
2014,9,"The Bag Man"
2015,60,"Joy"
2015,26,"Heist"
2015,61,"The Intern"
2016,11,"Dirty Grandpa"
)";

const std::string kStudentGradesCsvFormatInput =
        R"("Last name","First name","SSN","Test1","Test2","Test3","Test4","Final","Grade"
"Alfalfa","Aloysius","123-45-6789",40,90,100,83,49,"D-"
"Alfred","University","123-12-1234",41,97,96,97,48,"D+"
"Gerty","Gramma","567-89-0123",41,80,60,40,44,"C"
"Android","Electric","087-65-4321",42,23,36,45,47,"B-"
"Bumpkin","Fred","456-78-9012",43,78,88,77,45,"A-"
"Rubble","Betty","234-56-7890",44,90,80,90,46,"C-"
"Noshow","Cecil","345-67-8901",45,11,-1,4,43,"F"
"Buff","Bif","632-79-9939",46,20,30,40,50,"B+"
"Airpump","Andrew","223-45-6789",49,1,90,100,83,"A"
"Backus","Jim","143-12-1234",48,1,97,96,97,"A+"
"Carnivore","Art","565-89-0123",44,1,80,60,40,"D+"
"Dandy","Jim","087-75-4321",47,1,23,36,45,"C+"
"Elephant","Ima","456-71-9012",45,1,78,88,77,"B-"
"Franklin","Benny","234-56-2890",50,1,90,80,90,"B-"
"George","Boy","345-67-3901",40,1,11,-1, 4,"B"
"Heffalump","Harvey","632-79-9439",30,1,20,30,40,"C"
)";

const uint32_t kSampleTrainedCsvColumnMapping[] = { 0, 1, 2, 3, 3, 4, 4, 3, 5 };

static const unsigned char kAudioPCMS32LETestInputChars[] = {
    0x00, 0x80, 0x2c, 0xfc, 0x00, 0x80, 0x36, 0xfc, 0x00, 0x00, 0x46, 0xfc,
    0x00, 0x80, 0x47, 0xfc, 0x00, 0x00, 0x37, 0xfc, 0x00, 0x00, 0x44, 0xfc,
    0x00, 0x00, 0x64, 0xfc, 0x00, 0x80, 0x77, 0xfc, 0x00, 0x80, 0xa1, 0xfc,
    0x00, 0x80, 0xdc, 0xfc, 0x00, 0x80, 0xfb, 0xfc, 0x00, 0x00, 0x0b, 0xfd,
    0x00, 0x80, 0x20, 0xfd, 0x00, 0x00, 0x42, 0xfd, 0x00, 0x00, 0x78, 0xfd,
    0x00, 0x80, 0xa7, 0xfd, 0x00, 0x00, 0xc3, 0xfd, 0x00, 0x00, 0xeb, 0xfd,
    0x00, 0x00, 0x11, 0xfe, 0x00, 0x00, 0x1e, 0xfe, 0x00, 0x80, 0x39, 0xfe,
    0x00, 0x80, 0x68, 0xfe, 0x00, 0x00, 0x8b, 0xfe, 0x00, 0x00, 0xa2, 0xfe,
    0x00, 0x80, 0xbf, 0xfe, 0x00, 0x80, 0xdf, 0xfe, 0x00, 0x00, 0x03, 0xff,
    0x00, 0x80, 0x2d, 0xff, 0x00, 0x80, 0x5f, 0xff, 0x00, 0x00, 0x97, 0xff,
    0x00, 0x00, 0xdb, 0xff, 0x00, 0x80, 0x2e, 0x00, 0x00, 0x80, 0x83, 0x00,
    0x00, 0x80, 0xca, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x37, 0x01,
    0x00, 0x80, 0x60, 0x01, 0x00, 0x00, 0x8a, 0x01, 0x00, 0x80, 0xbb, 0x01,
    0x00, 0x80, 0xe7, 0x01, 0x00, 0x00, 0x10, 0x02, 0x00, 0x80, 0x39, 0x02,
    0x00, 0x80, 0x3e, 0x02, 0x00, 0x00, 0x1f, 0x02, 0x00, 0x80, 0x0b, 0x02,
    0x00, 0x00, 0x0a, 0x02, 0x00, 0x00, 0x04, 0x02, 0x00, 0x80, 0x05, 0x02,
    0x00, 0x00, 0x08, 0x02, 0x00, 0x80, 0xfc, 0x01, 0x00, 0x00, 0xef, 0x01,
    0x00, 0x80, 0xeb, 0x01, 0x00, 0x00, 0xf1, 0x01, 0x00, 0x80, 0xfe, 0x01,
    0x00, 0x00, 0x09, 0x02, 0x00, 0x80, 0x0d, 0x02, 0x00, 0x00, 0x1a, 0x02,
    0x00, 0x80, 0x2b, 0x02, 0x00, 0x80, 0x32, 0x02, 0x00, 0x80, 0x34, 0x02,
    0x00, 0x00, 0x3e, 0x02, 0x00, 0x00, 0x42, 0x02, 0x00, 0x00, 0x37, 0x02,
    0x00, 0x00, 0x33, 0x02, 0x00, 0x80, 0x37, 0x02, 0x00, 0x80, 0x24, 0x02,
    0x00, 0x80, 0xf8, 0x01, 0x00, 0x80, 0xc9, 0x01, 0x00, 0x80, 0xa0, 0x01,
    0x00, 0x00, 0x85, 0x01, 0x00, 0x80, 0x70, 0x01, 0x00, 0x00, 0x5a, 0x01,
    0x00, 0x00, 0x48, 0x01, 0x00, 0x80, 0x30, 0x01, 0x00, 0x80, 0x09, 0x01,
    0x00, 0x80, 0xe7, 0x00, 0x00, 0x80, 0xd3, 0x00, 0x00, 0x80, 0xbf, 0x00,
    0x00, 0x80, 0xae, 0x00, 0x00, 0x80, 0xa9, 0x00, 0x00, 0x00, 0xa5, 0x00,
    0x00, 0x80, 0x9c, 0x00, 0x00, 0x80, 0x9a, 0x00, 0x00, 0x00, 0x9c, 0x00,
    0x00, 0x00, 0x95, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x80, 0x8d, 0x00,
    0x00, 0x00, 0x85, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x77, 0x00,
    0x00, 0x80, 0x64, 0x00, 0x00, 0x80, 0x4a, 0x00, 0x00, 0x80, 0x37, 0x00,
    0x00, 0x00, 0x27, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x80, 0xe9, 0xff,
    0x00, 0x00, 0xc3, 0xff, 0x00, 0x80, 0xa4, 0xff, 0x00, 0x80, 0x88, 0xff,
    0x00, 0x00, 0x75, 0xff, 0x00, 0x00, 0x6e, 0xff, 0x00, 0x80, 0x61, 0xff,
    0x00, 0x00, 0x43, 0xff, 0x00, 0x00, 0x2d, 0xff, 0x00, 0x00, 0x25, 0xff,
    0x00, 0x00, 0x1b, 0xff, 0x00, 0x00, 0x10, 0xff, 0x00, 0x80, 0x02, 0xff,
    0x00, 0x80, 0xf4, 0xfe, 0x00, 0x80, 0xf2, 0xfe, 0x00, 0x00, 0xf1, 0xfe,
    0x00, 0x00, 0xe2, 0xfe, 0x00, 0x80, 0xd7, 0xfe, 0x00, 0x00, 0xd3, 0xfe,
    0x00, 0x80, 0xb8, 0xfe, 0x00, 0x80, 0x97, 0xfe, 0x00, 0x00, 0x89, 0xfe,
    0x00, 0x00, 0x77, 0xfe, 0x00, 0x00, 0x5f, 0xfe, 0x00, 0x80, 0x56, 0xfe,
    0x00, 0x00, 0x4a, 0xfe, 0x00, 0x80, 0x32, 0xfe, 0x00, 0x80, 0x24, 0xfe,
    0x00, 0x00, 0x18, 0xfe, 0x00, 0x00, 0x12, 0xfe, 0x00, 0x00, 0x13, 0xfe,
    0x00, 0x80, 0x11, 0xfe, 0x00, 0x00, 0x17, 0xfe, 0x00, 0x00, 0x25, 0xfe,
    0x00, 0x80, 0x1b, 0xfe, 0x00, 0x80, 0x0e, 0xfe, 0x00, 0x00, 0x18, 0xfe,
    0x00, 0x80, 0x22, 0xfe, 0x00, 0x00, 0x27, 0xfe, 0x00, 0x00, 0x35, 0xfe,
    0x00, 0x80, 0x3c, 0xfe, 0x00, 0x00, 0x44, 0xfe, 0x00, 0x80, 0x56, 0xfe,
    0x00, 0x00, 0x5b, 0xfe, 0x00, 0x00, 0x56, 0xfe, 0x00, 0x00, 0x5d, 0xfe,
    0x00, 0x00, 0x67, 0xfe, 0x00, 0x80, 0x6b, 0xfe, 0x00, 0x80, 0x71, 0xfe,
    0x00, 0x00, 0x81, 0xfe, 0x00, 0x80, 0x9d, 0xfe, 0x00, 0x00, 0xb8, 0xfe,
    0x00, 0x80, 0xcf, 0xfe, 0x00, 0x80, 0xf8, 0xfe, 0x00, 0x00, 0x2e, 0xff,
    0x00, 0x80, 0x63, 0xff, 0x00, 0x00, 0x99, 0xff, 0x00, 0x00, 0xc3, 0xff,
    0x00, 0x80, 0xf1, 0xff, 0x00, 0x80, 0x30, 0x00, 0x00, 0x80, 0x5a, 0x00,
    0x00, 0x00, 0x75, 0x00, 0x00, 0x80, 0x97, 0x00, 0x00, 0x00, 0xaa, 0x00,
    0x00, 0x80, 0xb2, 0x00, 0x00, 0x80, 0xc6, 0x00, 0x00, 0x00, 0xc7, 0x00,
    0x00, 0x80, 0xc4, 0x00, 0x00, 0x80, 0xc6, 0x00, 0x00, 0x00, 0xad, 0x00,
    0x00, 0x00, 0x96, 0x00, 0x00, 0x80, 0x95, 0x00, 0x00, 0x00, 0x87, 0x00,
    0x00, 0x00, 0x7f, 0x00, 0x00, 0x80, 0x8b, 0x00, 0x00, 0x00, 0x84, 0x00,
    0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x80, 0x65, 0x00,
    0x00, 0x00, 0x5a, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x40, 0x00,
    0x00, 0x80, 0x31, 0x00, 0x00, 0x80, 0x25, 0x00, 0x00, 0x00, 0x11, 0x00,
    0x00, 0x00, 0xfa, 0xff, 0x00, 0x00, 0xe1, 0xff, 0x00, 0x80, 0xd5, 0xff,
    0x00, 0x80, 0xd7, 0xff, 0x00, 0x00, 0xd4, 0xff, 0x00, 0x80, 0xd5, 0xff,
    0x00, 0x80, 0xd8, 0xff, 0x00, 0x00, 0xcf, 0xff, 0x00, 0x80, 0xd3, 0xff,
    0x00, 0x00, 0xe4, 0xff, 0x00, 0x80, 0xee, 0xff, 0x00, 0x00, 0xfc, 0xff,
    0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0xfb, 0xff, 0x00, 0x00, 0x04, 0x00,
    0x00, 0x80, 0x0c, 0x00, 0x00, 0x80, 0x08, 0x00, 0x00, 0x80, 0xf7, 0xff,
    0x00, 0x00, 0xd6, 0xff, 0x00, 0x80, 0xc0, 0xff, 0x00, 0x00, 0xc0, 0xff,
    0x00, 0x00, 0xb6, 0xff, 0x00, 0x80, 0xa4, 0xff, 0x00, 0x00, 0x8a, 0xff,
    0x00, 0x80, 0x62, 0xff, 0x00, 0x80, 0x51, 0xff, 0x00, 0x00, 0x54, 0xff,
    0x00, 0x80, 0x50, 0xff, 0x00, 0x00, 0x59, 0xff, 0x00, 0x00, 0x69, 0xff,
    0x00, 0x80, 0x61, 0xff, 0x00, 0x80, 0x53, 0xff, 0x00, 0x00, 0x58, 0xff,
    0x00, 0x00, 0x67, 0xff, 0x00, 0x80, 0x79, 0xff, 0x00, 0x80, 0x8d, 0xff,
    0x00, 0x00, 0xad, 0xff, 0x00, 0x00, 0xd9, 0xff, 0x00, 0x80, 0xf9, 0xff,
    0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x80, 0x34, 0x00,
    0x00, 0x00, 0x55, 0x00, 0x00, 0x80, 0x5b, 0x00, 0x00, 0x80, 0x66, 0x00,
    0x00, 0x80, 0x84, 0x00, 0x00, 0x80, 0xac, 0x00, 0x00, 0x80, 0xd2, 0x00,
    0x00, 0x00, 0xea, 0x00, 0x00, 0x80, 0x09, 0x01, 0x00, 0x80, 0x31, 0x01,
    0x00, 0x00, 0x4c, 0x01, 0x00, 0x80, 0x6f, 0x01, 0x00, 0x80, 0x9c, 0x01,
    0x00, 0x80, 0xb4, 0x01, 0x00, 0x00, 0xd4, 0x01, 0x00, 0x80, 0x0f, 0x02,
    0x00, 0x80, 0x33, 0x02, 0x00, 0x00, 0x3e, 0x02, 0x00, 0x80, 0x55, 0x02,
    0x00, 0x80, 0x79, 0x02, 0x00, 0x00, 0x9a, 0x02, 0x00, 0x80, 0xb7, 0x02,
    0x00, 0x00, 0xd7, 0x02, 0x00, 0x00, 0xf8, 0x02, 0x00, 0x00, 0x09, 0x03,
    0x00, 0x00, 0x15, 0x03, 0x00, 0x00, 0x2c, 0x03, 0x00, 0x00, 0x41, 0x03,
    0x00, 0x00, 0x5a, 0x03, 0x00, 0x00, 0x86, 0x03, 0x00, 0x80, 0xab, 0x03,
    0x00, 0x80, 0xc7, 0x03, 0x00, 0x80, 0xec, 0x03, 0x00, 0x00, 0x11, 0x04,
    0x00, 0x80, 0x3a, 0x04, 0x00, 0x80, 0x76, 0x04, 0x00, 0x00, 0xab, 0x04,
    0x00, 0x00, 0xd7, 0x04, 0x00, 0x00, 0x16, 0x05, 0x00, 0x00, 0x50, 0x05,
    0x00, 0x00, 0x6e, 0x05, 0x00, 0x80, 0x86, 0x05, 0x00, 0x00, 0x95, 0x05,
    0x00, 0x80, 0x93, 0x05, 0x00, 0x00, 0x91, 0x05, 0x00, 0x00, 0x8c, 0x05,
    0x00, 0x00, 0x80, 0x05, 0x00, 0x80, 0x78, 0x05, 0x00, 0x80, 0x6b, 0x05,
    0x00, 0x00, 0x48, 0x05, 0x00, 0x80, 0x1d, 0x05, 0x00, 0x00, 0x00, 0x05,
    0x00, 0x80, 0xf2, 0x04, 0x00, 0x00, 0xde, 0x04, 0x00, 0x00, 0xc2, 0x04,
    0x00, 0x80, 0xba, 0x04, 0x00, 0x80, 0xb3, 0x04, 0x00, 0x80, 0x99, 0x04,
    0x00, 0x80, 0x81, 0x04, 0x00, 0x80, 0x66, 0x04, 0x00, 0x80, 0x4a, 0x04,
    0x00, 0x80, 0x4a, 0x04, 0x00, 0x00, 0x47, 0x04, 0x00, 0x00, 0x27, 0x04,
    0x00, 0x00, 0x04, 0x04, 0x00, 0x80, 0xde, 0x03, 0x00, 0x80, 0xae, 0x03,
    0x00, 0x00, 0x7b, 0x03, 0x00, 0x00, 0x41, 0x03, 0x00, 0x80, 0x08, 0x03,
    0x00, 0x80, 0xd0, 0x02, 0x00, 0x00, 0x94, 0x02, 0x00, 0x00, 0x5f, 0x02,
    0x00, 0x00, 0x22, 0x02, 0x00, 0x00, 0xd9, 0x01, 0x00, 0x80, 0xa4, 0x01,
    0x00, 0x80, 0x65, 0x01, 0x00, 0x00, 0x17, 0x01, 0x00, 0x80, 0xe5, 0x00,
    0x00, 0x00, 0xc2, 0x00, 0x00, 0x00, 0x8b, 0x00, 0x00, 0x00, 0x51, 0x00,
    0x00, 0x00, 0x0f, 0x00, 0x00, 0x80, 0xc8, 0xff, 0x00, 0x80, 0x8e, 0xff,
    0x00, 0x00, 0x53, 0xff, 0x00, 0x00, 0x18, 0xff, 0x00, 0x00, 0xe4, 0xfe,
    0x00, 0x00, 0xa1, 0xfe, 0x00, 0x80, 0x54, 0xfe, 0x00, 0x80, 0x07, 0xfe,
    0x00, 0x80, 0xbc, 0xfd, 0x00, 0x00, 0x73, 0xfd, 0x00, 0x80, 0x24, 0xfd,
    0x00, 0x80, 0xd9, 0xfc, 0x00, 0x80, 0x9a, 0xfc, 0x00, 0x80, 0x54, 0xfc,
    0x00, 0x00, 0x0f, 0xfc, 0x00, 0x80, 0xda, 0xfb, 0x00, 0x00, 0xb0, 0xfb,
    0x00, 0x00, 0x83, 0xfb, 0x00, 0x80, 0x47, 0xfb, 0x00, 0x80, 0x07, 0xfb,
    0x00, 0x00, 0xe3, 0xfa, 0x00, 0x80, 0xc7, 0xfa, 0x00, 0x00, 0x9e, 0xfa,
    0x00, 0x00, 0x79, 0xfa, 0x00, 0x80, 0x51, 0xfa, 0x00, 0x80, 0x1f, 0xfa,
    0x00, 0x80, 0xf4, 0xf9, 0x00, 0x80, 0xd3, 0xf9, 0x00, 0x80, 0xb6, 0xf9,
    0x00, 0x80, 0xa2, 0xf9, 0x00, 0x80, 0x8c, 0xf9, 0x00, 0x00, 0x79, 0xf9,
    0x00, 0x80, 0x71, 0xf9, 0x00, 0x80, 0x73, 0xf9, 0x00, 0x80, 0x85, 0xf9,
    0x00, 0x80, 0xac, 0xf9, 0x00, 0x00, 0xd4, 0xf9, 0x00, 0x00, 0xf1, 0xf9,
    0x00, 0x80, 0x0b, 0xfa, 0x00, 0x80, 0x2e, 0xfa, 0x00, 0x00, 0x5d, 0xfa,
    0x00, 0x00, 0x89, 0xfa, 0x00, 0x00, 0xac, 0xfa, 0x00, 0x80, 0xc9, 0xfa,
    0x00, 0x00, 0xe9, 0xfa, 0x00, 0x80, 0x01, 0xfb, 0x00, 0x80, 0x14, 0xfb,
    0x00, 0x00, 0x2d, 0xfb, 0x00, 0x00, 0x43, 0xfb, 0x00, 0x80, 0x49, 0xfb,
    0x00, 0x00, 0x52, 0xfb, 0x00, 0x80, 0x63, 0xfb, 0x00, 0x80, 0x79, 0xfb,
    0x00, 0x00, 0x93, 0xfb, 0x00, 0x00, 0xa2, 0xfb, 0x00, 0x00, 0xa9, 0xfb,
    0x00, 0x00, 0xb2, 0xfb, 0x00, 0x80, 0xb8, 0xfb, 0x00, 0x00, 0xd3, 0xfb,
    0x00, 0x80, 0x08, 0xfc, 0x00, 0x80, 0x35, 0xfc, 0x00, 0x00, 0x57, 0xfc,
    0x00, 0x80, 0x79, 0xfc, 0x00, 0x00, 0x89, 0xfc, 0x00, 0x80, 0x8c, 0xfc,
    0x00, 0x80, 0xa0, 0xfc, 0x00, 0x80, 0xc1, 0xfc, 0x00, 0x80, 0xe5, 0xfc,
    0x00, 0x80, 0x09, 0xfd, 0x00, 0x00, 0x31, 0xfd, 0x00, 0x00, 0x56, 0xfd,
    0x00, 0x80, 0x6f, 0xfd, 0x00, 0x00, 0x8f, 0xfd, 0x00, 0x80, 0xbd, 0xfd,
    0x00, 0x80, 0xf1, 0xfd, 0x00, 0x00, 0x29, 0xfe, 0x00, 0x00, 0x6c, 0xfe,
    0x00, 0x80, 0xb9, 0xfe, 0x00, 0x80, 0x0f, 0xff, 0x00, 0x80, 0x5d, 0xff,
    0x00, 0x80, 0xa9, 0xff, 0x00, 0x80, 0xf4, 0xff, 0x00, 0x80, 0x37, 0x00,
    0x00, 0x80, 0x88, 0x00, 0x00, 0x00, 0xe6, 0x00, 0x00, 0x80, 0x27, 0x01,
    0x00, 0x80, 0x61, 0x01, 0x00, 0x80, 0x9b, 0x01, 0x00, 0x80, 0xba, 0x01,
    0x00, 0x80, 0xd3, 0x01, 0x00, 0x00, 0xf9, 0x01, 0x00, 0x80, 0x1d, 0x02,
    0x00, 0x80, 0x4b, 0x02, 0x00, 0x00, 0x76, 0x02, 0x00, 0x00, 0x87, 0x02,
    0x00, 0x80, 0x90, 0x02, 0x00, 0x00, 0x9b, 0x02, 0x00, 0x00, 0xaa, 0x02,
    0x00, 0x00, 0xcb, 0x02, 0x00, 0x00, 0xeb, 0x02, 0x00, 0x80, 0xfd, 0x02,
    0x00, 0x00, 0x14, 0x03, 0x00, 0x00, 0x2c, 0x03, 0x00, 0x80, 0x36, 0x03,
    0x00, 0x00, 0x44, 0x03, 0x00, 0x80, 0x5f, 0x03, 0x00, 0x00, 0x76, 0x03,
    0x00, 0x00, 0x85, 0x03, 0x00, 0x00, 0xa0, 0x03, 0x00, 0x80, 0xb7, 0x03,
    0x00, 0x00, 0xbf, 0x03, 0x00, 0x80, 0xc6, 0x03, 0x00, 0x00, 0xc3, 0x03,
    0x00, 0x00, 0xb7, 0x03, 0x00, 0x00, 0xb5, 0x03, 0x00, 0x80, 0xa9, 0x03,
    0x00, 0x00, 0x9e, 0x03, 0x00, 0x00, 0xa2, 0x03, 0x00, 0x80, 0x86, 0x03,
    0x00, 0x00, 0x56, 0x03, 0x00, 0x00, 0x3a, 0x03, 0x00, 0x00, 0x19, 0x03,
    0x00, 0x00, 0xf8, 0x02, 0x00, 0x00, 0xeb, 0x02, 0x00, 0x80, 0xd8, 0x02,
    0x00, 0x00, 0xcd, 0x02, 0x00, 0x00, 0xcc, 0x02, 0x00, 0x00, 0xaf, 0x02,
    0x00, 0x00, 0x94, 0x02, 0x00, 0x80, 0x93, 0x02, 0x00, 0x00, 0x87, 0x02,
    0x00, 0x80, 0x7e, 0x02, 0x00, 0x80, 0x86, 0x02, 0x00, 0x00, 0x7e, 0x02,
    0x00, 0x00, 0x71, 0x02, 0x00, 0x00, 0x67, 0x02, 0x00, 0x00, 0x4c, 0x02,
    0x00, 0x00, 0x3a, 0x02, 0x00, 0x80, 0x37, 0x02, 0x00, 0x00, 0x23, 0x02,
    0x00, 0x80, 0x07, 0x02, 0x00, 0x80, 0xf8, 0x01, 0x00, 0x80, 0xdb, 0x01,
    0x00, 0x00, 0xab, 0x01, 0x00, 0x80, 0x83, 0x01, 0x00, 0x00, 0x64, 0x01,
    0x00, 0x80, 0x41, 0x01, 0x00, 0x80, 0x21, 0x01, 0x00, 0x80, 0x01, 0x01,
    0x00, 0x80, 0xdc, 0x00, 0x00, 0x00, 0xba, 0x00, 0x00, 0x00, 0x9f, 0x00,
    0x00, 0x00, 0x8b, 0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x67, 0x00,
    0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x80, 0x2a, 0x00,
    0x00, 0x00, 0x15, 0x00, 0x00, 0x80, 0xfb, 0xff, 0x00, 0x00, 0xd7, 0xff,
    0x00, 0x00, 0xb2, 0xff, 0x00, 0x00, 0x8c, 0xff, 0x00, 0x00, 0x60, 0xff,
    0x00, 0x00, 0x30, 0xff, 0x00, 0x80, 0x02, 0xff, 0x00, 0x80, 0xde, 0xfe,
    0x00, 0x00, 0xc3, 0xfe, 0x00, 0x00, 0xa9, 0xfe, 0x00, 0x80, 0x8d, 0xfe,
    0x00, 0x00, 0x6f, 0xfe, 0x00, 0x00, 0x58, 0xfe, 0x00, 0x80, 0x47, 0xfe,
    0x00, 0x00, 0x32, 0xfe, 0x00, 0x00, 0x22, 0xfe, 0x00, 0x80, 0x1d, 0xfe,
    0x00, 0x00, 0x1c, 0xfe, 0x00, 0x80, 0x26, 0xfe, 0x00, 0x80, 0x31, 0xfe,
    0x00, 0x80, 0x2f, 0xfe, 0x00, 0x80, 0x2f, 0xfe, 0x00, 0x80, 0x2c, 0xfe,
    0x00, 0x00, 0x1e, 0xfe, 0x00, 0x00, 0x1c, 0xfe, 0x00, 0x80, 0x1d, 0xfe,
    0x00, 0x80, 0x18, 0xfe, 0x00, 0x00, 0x15, 0xfe, 0x00, 0x00, 0x02, 0xfe,
    0x00, 0x00, 0xeb, 0xfd, 0x00, 0x00, 0xed, 0xfd, 0x00, 0x80, 0xf3, 0xfd,
    0x00, 0x00, 0xff, 0xfd, 0x00, 0x80, 0x18, 0xfe, 0x00, 0x80, 0x2a, 0xfe,
    0x00, 0x00, 0x40, 0xfe, 0x00, 0x80, 0x5f, 0xfe, 0x00, 0x80, 0x79, 0xfe,
    0x00, 0x00, 0x9b, 0xfe, 0x00, 0x00, 0xc7, 0xfe, 0x00, 0x80, 0xef, 0xfe,
    0x00, 0x80, 0x28, 0xff, 0x00, 0x80, 0x6c, 0xff, 0x00, 0x00, 0xa1, 0xff,
    0x00, 0x00, 0xcd, 0xff, 0x00, 0x80, 0xfa, 0xff, 0x00, 0x00, 0x25, 0x00,
    0x00, 0x80, 0x4b, 0x00, 0x00, 0x00, 0x72, 0x00, 0x00, 0x80, 0xa2, 0x00,
    0x00, 0x00, 0xcf, 0x00, 0x00, 0x00, 0xe5, 0x00, 0x00, 0x00, 0xf5, 0x00,
    0x00, 0x00, 0x0a, 0x01, 0x00, 0x80, 0x1c, 0x01, 0x00, 0x80, 0x30, 0x01,
    0x00, 0x00, 0x49, 0x01, 0x00, 0x80, 0x59, 0x01, 0x00, 0x00, 0x62, 0x01,
    0x00, 0x80, 0x6e, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x89, 0x01,
    0x00, 0x00, 0x8d, 0x01, 0x00, 0x00, 0x96, 0x01, 0x00, 0x80, 0x9b, 0x01,
    0x00, 0x80, 0x98, 0x01, 0x00, 0x80, 0x98, 0x01, 0x00, 0x00, 0xa3, 0x01,
    0x00, 0x00, 0xb0, 0x01, 0x00, 0x00, 0xbc, 0x01, 0x00, 0x00, 0xc7, 0x01,
    0x00, 0x00, 0xc8, 0x01, 0x00, 0x80, 0xc2, 0x01, 0x00, 0x00, 0xc3, 0x01,
    0x00, 0x00, 0xca, 0x01, 0x00, 0x80, 0xd5, 0x01, 0x00, 0x00, 0xe9, 0x01,
    0x00, 0x00, 0xf2, 0x01, 0x00, 0x00, 0xf3, 0x01, 0x00, 0x00, 0x04, 0x02,
    0x00, 0x00, 0x0a, 0x02, 0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x10, 0x02,
    0x00, 0x00, 0x23, 0x02, 0x00, 0x80, 0x25, 0x02, 0x00, 0x00, 0x2b, 0x02,
    0x00, 0x80, 0x28, 0x02, 0x00, 0x80, 0x22, 0x02, 0x00, 0x80, 0x2c, 0x02,
    0x00, 0x00, 0x28, 0x02, 0x00, 0x00, 0x17, 0x02, 0x00, 0x00, 0x11, 0x02,
    0x00, 0x00, 0x0c, 0x02, 0x00, 0x00, 0x11, 0x02, 0x00, 0x00, 0x23, 0x02,
    0x00, 0x80, 0x16, 0x02, 0x00, 0x80, 0xf7, 0x01, 0x00, 0x00, 0xde, 0x01,
    0x00, 0x00, 0xc0, 0x01, 0x00, 0x80, 0xac, 0x01, 0x00, 0x00, 0xb4, 0x01,
    0x00, 0x80, 0xbb, 0x01, 0x00, 0x00, 0xae, 0x01, 0x00, 0x80, 0xa2, 0x01,
    0x00, 0x80, 0xa2, 0x01, 0x00, 0x00, 0x9e, 0x01, 0x00, 0x00, 0xa4, 0x01,
    0x00, 0x80, 0xbb, 0x01, 0x00, 0x80, 0xc2, 0x01, 0x00, 0x80, 0xd1, 0x01,
    0x00, 0x80, 0x02, 0x02, 0x00, 0x80, 0x18, 0x02, 0x00, 0x80, 0x0b, 0x02,
    0x00, 0x80, 0x1d, 0x02, 0x00, 0x00, 0x3f, 0x02, 0x00, 0x00, 0x4d, 0x02,
    0x00, 0x80, 0x54, 0x02, 0x00, 0x00, 0x5b, 0x02, 0x00, 0x80, 0x6a, 0x02,
    0x00, 0x00, 0x7a, 0x02, 0x00, 0x00, 0x7d, 0x02, 0x00, 0x80, 0x8c, 0x02,
    0x00, 0x00, 0x9e, 0x02, 0x00, 0x80, 0xa5, 0x02, 0x00, 0x00, 0xbc, 0x02,
    0x00, 0x80, 0xd3, 0x02, 0x00, 0x00, 0xd7, 0x02, 0x00, 0x80, 0xe2, 0x02,
    0x00, 0x80, 0xf6, 0x02, 0x00, 0x00, 0x08, 0x03, 0x00, 0x80, 0x13, 0x03,
    0x00, 0x80, 0x14, 0x03, 0x00, 0x00, 0x1b, 0x03, 0x00, 0x00, 0x27, 0x03,
    0x00, 0x00, 0x25, 0x03, 0x00, 0x00, 0x21, 0x03, 0x00, 0x00, 0x21, 0x03,
    0x00, 0x00, 0x28, 0x03, 0x00, 0x80, 0x42, 0x03, 0x00, 0x80, 0x59, 0x03,
    0x00, 0x80, 0x5f, 0x03, 0x00, 0x00, 0x72, 0x03, 0x00, 0x00, 0x93, 0x03,
    0x00, 0x00, 0xb1, 0x03, 0x00, 0x00, 0xc6, 0x03, 0x00, 0x00, 0xdd, 0x03,
    0x00, 0x80, 0x02, 0x04, 0x00, 0x80, 0x24, 0x04, 0x00, 0x00, 0x33, 0x04,
    0x00, 0x00, 0x43, 0x04, 0x00, 0x00, 0x5a, 0x04, 0x00, 0x00, 0x73, 0x04,
    0x00, 0x80, 0x92, 0x04, 0x00, 0x00, 0x9d, 0x04, 0x00, 0x00, 0x93, 0x04,
    0x00, 0x80, 0x84, 0x04, 0x00, 0x80, 0x66, 0x04, 0x00, 0x00, 0x51, 0x04,
    0x00, 0x80, 0x49, 0x04, 0x00, 0x80, 0x29, 0x04, 0x00, 0x80, 0x09, 0x04,
    0x00, 0x80, 0x07, 0x04, 0x00, 0x80, 0xfb, 0x03, 0x00, 0x00, 0xdc, 0x03,
    0x00, 0x00, 0xc2, 0x03, 0x00, 0x80, 0xb0, 0x03, 0x00, 0x00, 0xa3, 0x03,
    0x00, 0x00, 0x96, 0x03, 0x00, 0x80, 0x87, 0x03, 0x00, 0x00, 0x80, 0x03,
    0x00, 0x00, 0x6e, 0x03, 0x00, 0x00, 0x4e, 0x03, 0x00, 0x00, 0x28, 0x03,
    0x00, 0x80, 0xff, 0x02, 0x00, 0x00, 0xe0, 0x02, 0x00, 0x80, 0xc0, 0x02,
    0x00, 0x00, 0x90, 0x02, 0x00, 0x80, 0x5a, 0x02, 0x00, 0x80, 0x27, 0x02,
    0x00, 0x80, 0xee, 0x01, 0x00, 0x80, 0xb7, 0x01, 0x00, 0x00, 0x7f, 0x01,
    0x00, 0x00, 0x44, 0x01, 0x00, 0x80, 0x12, 0x01, 0x00, 0x00, 0xe5, 0x00,
    0x00, 0x00, 0xb7, 0x00, 0x00, 0x00, 0x8c, 0x00, 0x00, 0x00, 0x61, 0x00,
    0x00, 0x80, 0x3b, 0x00, 0x00, 0x80, 0x17, 0x00, 0x00, 0x80, 0xe6, 0xff,
    0x00, 0x80, 0xba, 0xff, 0x00, 0x80, 0x94, 0xff, 0x00, 0x00, 0x60, 0xff,
    0x00, 0x80, 0x27, 0xff, 0x00, 0x00, 0xf2, 0xfe, 0x00, 0x00, 0xb9, 0xfe,
    0x00, 0x80, 0x7d, 0xfe, 0x00, 0x00, 0x3d, 0xfe, 0x00, 0x00, 0xfd, 0xfd,
    0x00, 0x80, 0xc7, 0xfd, 0x00, 0x80, 0x96, 0xfd, 0x00, 0x80, 0x5c, 0xfd,
    0x00, 0x00, 0x24, 0xfd, 0x00, 0x00, 0xf8, 0xfc, 0x00, 0x80, 0xcf, 0xfc,
    0x00, 0x80, 0x9c, 0xfc, 0x00, 0x00, 0x6a, 0xfc, 0x00, 0x80, 0x3f, 0xfc,
    0x00, 0x80, 0x0b, 0xfc, 0x00, 0x80, 0xd8, 0xfb, 0x00, 0x80, 0xbc, 0xfb,
    0x00, 0x80, 0xaa, 0xfb, 0x00, 0x80, 0x9a, 0xfb, 0x00, 0x80, 0x82, 0xfb,
    0x00, 0x80, 0x54, 0xfb, 0x00, 0x80, 0x21, 0xfb, 0x00, 0x80, 0xfe, 0xfa,
    0x00, 0x80, 0xe1, 0xfa, 0x00, 0x00, 0xc1, 0xfa, 0x00, 0x00, 0xa6, 0xfa,
    0x00, 0x00, 0x93, 0xfa, 0x00, 0x80, 0x7c, 0xfa, 0x00, 0x00, 0x62, 0xfa,
    0x00, 0x80, 0x50, 0xfa, 0x00, 0x80, 0x49, 0xfa, 0x00, 0x00, 0x48, 0xfa,
    0x00, 0x80, 0x54, 0xfa, 0x00, 0x80, 0x5d, 0xfa, 0x00, 0x00, 0x64, 0xfa,
    0x00, 0x80, 0x86, 0xfa, 0x00, 0x80, 0xb2, 0xfa, 0x00, 0x80, 0xca, 0xfa,
    0x00, 0x00, 0xea, 0xfa, 0x00, 0x00, 0x16, 0xfb, 0x00, 0x80, 0x3a, 0xfb,
    0x00, 0x00, 0x6c, 0xfb, 0x00, 0x80, 0xa6, 0xfb, 0x00, 0x00, 0xd3, 0xfb,
    0x00, 0x80, 0xf7, 0xfb, 0x00, 0x00, 0x17, 0xfc, 0x00, 0x80, 0x32, 0xfc,
    0x00, 0x00, 0x4a, 0xfc, 0x00, 0x00, 0x5e, 0xfc, 0x00, 0x80, 0x7c, 0xfc,
    0x00, 0x00, 0xa2, 0xfc, 0x00, 0x00, 0xbf, 0xfc, 0x00, 0x80, 0xde, 0xfc,
    0x00, 0x00, 0xff, 0xfc, 0x00, 0x80, 0x18, 0xfd, 0x00, 0x00, 0x3a, 0xfd,
    0x00, 0x00, 0x57, 0xfd, 0x00, 0x80, 0x5c, 0xfd, 0x00, 0x00, 0x67, 0xfd,
    0x00, 0x80, 0x7f, 0xfd, 0x00, 0x00, 0x96, 0xfd, 0x00, 0x80, 0xb4, 0xfd,
    0x00, 0x00, 0xe2, 0xfd, 0x00, 0x80, 0x04, 0xfe, 0x00, 0x80, 0x14, 0xfe,
    0x00, 0x80, 0x22, 0xfe, 0x00, 0x00, 0x32, 0xfe, 0x00, 0x00, 0x48, 0xfe,
    0x00, 0x80, 0x6e, 0xfe, 0x00, 0x80, 0x96, 0xfe, 0x00, 0x00, 0xb6, 0xfe,
    0x00, 0x80, 0xd2, 0xfe, 0x00, 0x00, 0xe3, 0xfe, 0x00, 0x00, 0xf6, 0xfe,
    0x00, 0x00, 0x21, 0xff, 0x00, 0x80, 0x48, 0xff, 0x00, 0x00, 0x65, 0xff,
    0x00, 0x00, 0x90, 0xff, 0x00, 0x00, 0xc0, 0xff, 0x00, 0x00, 0xe7, 0xff,
    0x00, 0x00, 0x1b, 0x00, 0x00, 0x80, 0x55, 0x00, 0x00, 0x80, 0x90, 0x00,
    0x00, 0x80, 0xcb, 0x00, 0x00, 0x80, 0x05, 0x01, 0x00, 0x80, 0x42, 0x01,
    0x00, 0x80, 0x83, 0x01, 0x00, 0x80, 0xb4, 0x01, 0x00, 0x80, 0xd9, 0x01,
    0x00, 0x00, 0xef, 0x01, 0x00, 0x00, 0xfb, 0x01, 0x00, 0x80, 0x10, 0x02,
    0x00, 0x80, 0x2f, 0x02, 0x00, 0x00, 0x4a, 0x02, 0x00, 0x80, 0x68, 0x02,
    0x00, 0x80, 0x83, 0x02, 0x00, 0x00, 0x83, 0x02, 0x00, 0x00, 0x6b, 0x02,
    0x00, 0x00, 0x5c, 0x02, 0x00, 0x80, 0x63, 0x02, 0x00, 0x00, 0x6d, 0x02,
    0x00, 0x00, 0x77, 0x02, 0x00, 0x80, 0x88, 0x02, 0x00, 0x00, 0x89, 0x02,
    0x00, 0x80, 0x7d, 0x02, 0x00, 0x80, 0x81, 0x02, 0x00, 0x80, 0x87, 0x02,
    0x00, 0x00, 0x8f, 0x02, 0x00, 0x80, 0xa1, 0x02, 0x00, 0x80, 0xa8, 0x02,
    0x00, 0x80, 0xa3, 0x02, 0x00, 0x00, 0xa1, 0x02, 0x00, 0x00, 0x99, 0x02,
    0x00, 0x80, 0x8b, 0x02, 0x00, 0x80, 0x75, 0x02, 0x00, 0x00, 0x58, 0x02,
    0x00, 0x00, 0x43, 0x02, 0x00, 0x80, 0x2f, 0x02, 0x00, 0x80, 0x18, 0x02,
    0x00, 0x80, 0x03, 0x02, 0x00, 0x80, 0xdd, 0x01, 0x00, 0x00, 0xa8, 0x01,
    0x00, 0x00, 0x79, 0x01, 0x00, 0x80, 0x4c, 0x01, 0x00, 0x00, 0x25, 0x01,
    0x00, 0x00, 0x10, 0x01, 0x00, 0x80, 0x00, 0x01, 0x00, 0x00, 0xf6, 0x00,
    0x00, 0x80, 0xe9, 0x00, 0x00, 0x80, 0xcb, 0x00, 0x00, 0x80, 0xb3, 0x00,
    0x00, 0x80, 0xae, 0x00, 0x00, 0x80, 0xa4, 0x00, 0x00, 0x00, 0x99, 0x00,
    0x00, 0x00, 0x8f, 0x00, 0x00, 0x80, 0x7d, 0x00, 0x00, 0x80, 0x69, 0x00,
    0x00, 0x80, 0x4d, 0x00, 0x00, 0x80, 0x33, 0x00, 0x00, 0x80, 0x25, 0x00,
    0x00, 0x80, 0x0b, 0x00, 0x00, 0x00, 0xef, 0xff, 0x00, 0x80, 0xe2, 0xff,
    0x00, 0x00, 0xcd, 0xff, 0x00, 0x00, 0xad, 0xff, 0x00, 0x00, 0x97, 0xff,
    0x00, 0x80, 0x80, 0xff, 0x00, 0x80, 0x6d, 0xff, 0x00, 0x80, 0x6a, 0xff,
    0x00, 0x80, 0x62, 0xff, 0x00, 0x80, 0x4e, 0xff, 0x00, 0x80, 0x35, 0xff,
    0x00, 0x00, 0x11, 0xff, 0x00, 0x80, 0xf4, 0xfe, 0x00, 0x80, 0xe9, 0xfe,
    0x00, 0x00, 0xd7, 0xfe, 0x00, 0x80, 0xba, 0xfe, 0x00, 0x00, 0xa6, 0xfe,
    0x00, 0x00, 0x95, 0xfe, 0x00, 0x00, 0x81, 0xfe, 0x00, 0x00, 0x72, 0xfe,
    0x00, 0x00, 0x66, 0xfe, 0x00, 0x80, 0x54, 0xfe, 0x00, 0x80, 0x3d, 0xfe,
    0x00, 0x00, 0x26, 0xfe, 0x00, 0x00, 0x12, 0xfe, 0x00, 0x00, 0x04, 0xfe,
    0x00, 0x80, 0xfc, 0xfd, 0x00, 0x00, 0xfc, 0xfd, 0x00, 0x80, 0xf7, 0xfd,
    0x00, 0x80, 0xf2, 0xfd, 0x00, 0x00, 0xec, 0xfd, 0x00, 0x80, 0xdd, 0xfd,
    0x00, 0x00, 0xd9, 0xfd, 0x00, 0x80, 0xdd, 0xfd, 0x00, 0x80, 0xd0, 0xfd,
    0x00, 0x80, 0xbc, 0xfd, 0x00, 0x80, 0xb4, 0xfd, 0x00, 0x00, 0xab, 0xfd,
    0x00, 0x80, 0xa6, 0xfd, 0x00, 0x00, 0xae, 0xfd, 0x00, 0x00, 0xac, 0xfd,
    0x00, 0x80, 0xa4, 0xfd, 0x00, 0x80, 0xa9, 0xfd, 0x00, 0x00, 0xb2, 0xfd,
    0x00, 0x80, 0xbf, 0xfd, 0x00, 0x80, 0xd9, 0xfd, 0x00, 0x00, 0xf2, 0xfd,
    0x00, 0x80, 0x0b, 0xfe, 0x00, 0x00, 0x25, 0xfe, 0x00, 0x00, 0x2e, 0xfe,
    0x00, 0x00, 0x36, 0xfe, 0x00, 0x00, 0x45, 0xfe, 0x00, 0x80, 0x50, 0xfe,
    0x00, 0x80, 0x61, 0xfe, 0x00, 0x00, 0x7d, 0xfe, 0x00, 0x00, 0x90, 0xfe,
    0x00, 0x00, 0xa4, 0xfe, 0x00, 0x80, 0xbc, 0xfe, 0x00, 0x80, 0xd2, 0xfe,
    0x00, 0x00, 0xf2, 0xfe, 0x00, 0x00, 0x1c, 0xff, 0x00, 0x00, 0x49, 0xff,
    0x00, 0x00, 0x81, 0xff, 0x00, 0x00, 0xb8, 0xff, 0x00, 0x80, 0xe7, 0xff,
    0x00, 0x00, 0x1f, 0x00, 0x00, 0x80, 0x58, 0x00, 0x00, 0x80, 0x8b, 0x00,
    0x00, 0x80, 0xba, 0x00, 0x00, 0x00, 0xe9, 0x00, 0x00, 0x80, 0x14, 0x01,
    0x00, 0x80, 0x35, 0x01, 0x00, 0x00, 0x50, 0x01, 0x00, 0x00, 0x6c, 0x01,
    0x00, 0x80, 0x79, 0x01, 0x00, 0x00, 0x78, 0x01, 0x00, 0x80, 0x80, 0x01,
    0x00, 0x80, 0x89, 0x01, 0x00, 0x00, 0x8d, 0x01, 0x00, 0x00, 0x9a, 0x01,
    0x00, 0x00, 0x98, 0x01, 0x00, 0x00, 0x89, 0x01, 0x00, 0x00, 0x8e, 0x01,
    0x00, 0x80, 0x8e, 0x01, 0x00, 0x00, 0x7a, 0x01, 0x00, 0x00, 0x6e, 0x01,
    0x00, 0x00, 0x6d, 0x01, 0x00, 0x80, 0x6e, 0x01, 0x00, 0x80, 0x6f, 0x01,
    0x00, 0x80, 0x75, 0x01, 0x00, 0x00, 0x81, 0x01, 0x00, 0x00, 0x7e, 0x01,
    0x00, 0x00, 0x6e, 0x01, 0x00, 0x80, 0x6a, 0x01, 0x00, 0x80, 0x6c, 0x01,
    0x00, 0x80, 0x67, 0x01, 0x00, 0x80, 0x62, 0x01, 0x00, 0x80, 0x62, 0x01,
    0x00, 0x00, 0x6d, 0x01, 0x00, 0x80, 0x6c, 0x01, 0x00, 0x00, 0x5c, 0x01,
    0x00, 0x80, 0x58, 0x01, 0x00, 0x80, 0x59, 0x01, 0x00, 0x80, 0x49, 0x01,
    0x00, 0x80, 0x47, 0x01, 0x00, 0x80, 0x4e, 0x01, 0x00, 0x80, 0x49, 0x01,
    0x00, 0x80, 0x4d, 0x01, 0x00, 0x80, 0x52, 0x01, 0x00, 0x80, 0x45, 0x01,
    0x00, 0x00, 0x2f, 0x01, 0x00, 0x80, 0x12, 0x01, 0x00, 0x00, 0xfd, 0x00,
    0x00, 0x80, 0xf7, 0x00, 0x00, 0x80, 0xf3, 0x00, 0x00, 0x00, 0xea, 0x00,
    0x00, 0x80, 0xd2, 0x00, 0x00, 0x80, 0xa8, 0x00, 0x00, 0x80, 0x8f, 0x00,
    0x00, 0x00, 0x8c, 0x00, 0x00, 0x00, 0x92, 0x00, 0x00, 0x80, 0xa0, 0x00,
    0x00, 0x80, 0xac, 0x00, 0x00, 0x00, 0xad, 0x00, 0x00, 0x80, 0xad, 0x00,
    0x00, 0x00, 0xb2, 0x00, 0x00, 0x00, 0xb9, 0x00, 0x00, 0x00, 0xb8, 0x00,
    0x00, 0x80, 0xb0, 0x00, 0x00, 0x00, 0xbb, 0x00, 0x00, 0x00, 0xcf, 0x00,
    0x00, 0x80, 0xce, 0x00, 0x00, 0x00, 0xc6, 0x00, 0x00, 0x00, 0xc9, 0x00,
    0x00, 0x80, 0xd5, 0x00, 0x00, 0x00, 0xdb, 0x00, 0x00, 0x80, 0xde, 0x00,
    0x00, 0x80, 0xf1, 0x00, 0x00, 0x00, 0x10, 0x01, 0x00, 0x80, 0x30, 0x01,
    0x00, 0x80, 0x52, 0x01, 0x00, 0x00, 0x6f, 0x01, 0x00, 0x00, 0x95, 0x01,
    0x00, 0x80, 0xc7, 0x01, 0x00, 0x00, 0xee, 0x01, 0x00, 0x00, 0x10, 0x02,
    0x00, 0x00, 0x30, 0x02, 0x00, 0x00, 0x3a, 0x02, 0x00, 0x00, 0x47, 0x02,
    0x00, 0x00, 0x60, 0x02, 0x00, 0x80, 0x67, 0x02, 0x00, 0x80, 0x65, 0x02,
    0x00, 0x80, 0x66, 0x02, 0x00, 0x80, 0x68, 0x02, 0x00, 0x80, 0x70, 0x02,
    0x00, 0x80, 0x6f, 0x02, 0x00, 0x80, 0x73, 0x02, 0x00, 0x00, 0x91, 0x02,
    0x00, 0x00, 0xab, 0x02, 0x00, 0x80, 0xc1, 0x02, 0x00, 0x00, 0xe6, 0x02,
    0x00, 0x80, 0x07, 0x03, 0x00, 0x00, 0x3b, 0x03, 0x00, 0x80, 0x83, 0x03,
    0x00, 0x00, 0xb3, 0x03, 0x00, 0x00, 0xd9, 0x03, 0x00, 0x80, 0x07, 0x04,
    0x00, 0x80, 0x28, 0x04, 0x00, 0x80, 0x3c, 0x04, 0x00, 0x80, 0x50, 0x04,
    0x00, 0x00, 0x63, 0x04, 0x00, 0x80, 0x79, 0x04, 0x00, 0x80, 0x86, 0x04,
    0x00, 0x00, 0x8c, 0x04, 0x00, 0x00, 0x8f, 0x04, 0x00, 0x80, 0x7c, 0x04,
    0x00, 0x00, 0x67, 0x04, 0x00, 0x00, 0x5f, 0x04, 0x00, 0x00, 0x53, 0x04,
    0x00, 0x80, 0x4b, 0x04, 0x00, 0x00, 0x4d, 0x04, 0x00, 0x00, 0x4d, 0x04,
    0x00, 0x80, 0x50, 0x04, 0x00, 0x00, 0x4b, 0x04, 0x00, 0x80, 0x38, 0x04,
    0x00, 0x80, 0x33, 0x04, 0x00, 0x80, 0x2d, 0x04, 0x00, 0x00, 0x1e, 0x04,
    0x00, 0x80, 0x17, 0x04, 0x00, 0x80, 0x0a, 0x04, 0x00, 0x00, 0xee, 0x03,
    0x00, 0x00, 0xd6, 0x03, 0x00, 0x00, 0xb4, 0x03, 0x00, 0x80, 0x7a, 0x03,
    0x00, 0x80, 0x48, 0x03, 0x00, 0x00, 0x25, 0x03, 0x00, 0x80, 0xfa, 0x02,
    0x00, 0x00, 0xc4, 0x02, 0x00, 0x80, 0x8d, 0x02, 0x00, 0x00, 0x5b, 0x02,
    0x00, 0x80, 0x2d, 0x02, 0x00, 0x80, 0x06, 0x02, 0x00, 0x80, 0xd5, 0x01,
    0x00, 0x00, 0x98, 0x01, 0x00, 0x00, 0x58, 0x01, 0x00, 0x80, 0x1a, 0x01,
    0x00, 0x00, 0xe0, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x80, 0x7b, 0x00,
    0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x80, 0xc2, 0xff,
    0x00, 0x80, 0x76, 0xff, 0x00, 0x80, 0x39, 0xff, 0x00, 0x80, 0x07, 0xff,
    0x00, 0x00, 0xc6, 0xfe, 0x00, 0x80, 0x79, 0xfe, 0x00, 0x80, 0x35, 0xfe,
    0x00, 0x80, 0xfa, 0xfd, 0x00, 0x80, 0xc1, 0xfd, 0x00, 0x80, 0x90, 0xfd,
    0x00, 0x80, 0x60, 0xfd, 0x00, 0x00, 0x26, 0xfd, 0x00, 0x00, 0xdf, 0xfc,
    0x00, 0x00, 0x9c, 0xfc, 0x00, 0x80, 0x69, 0xfc, 0x00, 0x80, 0x36, 0xfc,
    0x00, 0x00, 0xf5, 0xfb, 0x00, 0x00, 0xb3, 0xfb, 0x00, 0x00, 0x76, 0xfb,
    0x00, 0x80, 0x39, 0xfb, 0x00, 0x00, 0x08, 0xfb, 0x00, 0x80, 0xd9, 0xfa,
    0x00, 0x80, 0xaa, 0xfa, 0x00, 0x00, 0x79, 0xfa, 0x00, 0x00, 0x32, 0xfa,
    0x00, 0x00, 0xe7, 0xf9, 0x00, 0x80, 0xb2, 0xf9, 0x00, 0x00, 0x7c, 0xf9,
    0x00, 0x80, 0x41, 0xf9, 0x00, 0x00, 0x14, 0xf9, 0x00, 0x00, 0xf6, 0xf8,
    0x00, 0x00, 0xe1, 0xf8, 0x00, 0x00, 0xc8, 0xf8, 0x00, 0x00, 0xb0, 0xf8,
    0x00, 0x80, 0xb0, 0xf8, 0x00, 0x80, 0xbd, 0xf8, 0x00, 0x00, 0xc7, 0xf8,
    0x00, 0x00, 0xd1, 0xf8, 0x00, 0x00, 0xd2, 0xf8, 0x00, 0x80, 0xda, 0xf8,
    0x00, 0x80, 0xfb, 0xf8, 0x00, 0x00, 0x1d, 0xf9, 0x00, 0x00, 0x41, 0xf9,
    0x00, 0x00, 0x66, 0xf9, 0x00, 0x00, 0x7c, 0xf9, 0x00, 0x00, 0x97, 0xf9,
    0x00, 0x80, 0xbc, 0xf9, 0x00, 0x80, 0xd9, 0xf9, 0x00, 0x00, 0xfd, 0xf9,
    0x00, 0x00, 0x24, 0xfa, 0x00, 0x00, 0x3b, 0xfa, 0x00, 0x80, 0x53, 0xfa,
    0x00, 0x00, 0x78, 0xfa, 0x00, 0x80, 0xa3, 0xfa, 0x00, 0x00, 0xcb, 0xfa,
    0x00, 0x00, 0xe5, 0xfa, 0x00, 0x80, 0xfd, 0xfa, 0x00, 0x00, 0x1f, 0xfb,
    0x00, 0x00, 0x3e, 0xfb, 0x00, 0x80, 0x5f, 0xfb, 0x00, 0x00, 0x81, 0xfb,
    0x00, 0x80, 0x9a, 0xfb, 0x00, 0x80, 0xab, 0xfb, 0x00, 0x80, 0xbc, 0xfb,
    0x00, 0x80, 0xdd, 0xfb, 0x00, 0x80, 0x08, 0xfc, 0x00, 0x00, 0x2f, 0xfc,
    0x00, 0x80, 0x58, 0xfc, 0x00, 0x80, 0x81, 0xfc, 0x00, 0x00, 0xa1, 0xfc,
    0x00, 0x80, 0xc0, 0xfc, 0x00, 0x80, 0xd8, 0xfc, 0x00, 0x80, 0xf8, 0xfc,
    0x00, 0x00, 0x2c, 0xfd, 0x00, 0x80, 0x54, 0xfd, 0x00, 0x80, 0x72, 0xfd,
    0x00, 0x00, 0xa4, 0xfd, 0x00, 0x80, 0xd4, 0xfd, 0x00, 0x00, 0x05, 0xfe,
    0x00, 0x80, 0x42, 0xfe, 0x00, 0x80, 0x78, 0xfe, 0x00, 0x80, 0xa3, 0xfe,
    0x00, 0x00, 0xdb, 0xfe, 0x00, 0x00, 0x21, 0xff, 0x00, 0x00, 0x6c, 0xff,
    0x00, 0x00, 0xb3, 0xff, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x52, 0x00,
    0x00, 0x80, 0x91, 0x00, 0x00, 0x80, 0xdc, 0x00, 0x00, 0x00, 0x31, 0x01,
    0x00, 0x00, 0x6b, 0x01, 0x00, 0x00, 0x9b, 0x01, 0x00, 0x00, 0xc8, 0x01,
    0x00, 0x00, 0xd6, 0x01, 0x00, 0x00, 0xe4, 0x01, 0x00, 0x00, 0x0a, 0x02,
    0x00, 0x00, 0x37, 0x02, 0x00, 0x00, 0x66, 0x02, 0x00, 0x80, 0x8c, 0x02,
    0x00, 0x80, 0xa3, 0x02, 0x00, 0x00, 0xb6, 0x02, 0x00, 0x80, 0xbc, 0x02,
    0x00, 0x80, 0xc8, 0x02, 0x00, 0x00, 0xf3, 0x02, 0x00, 0x80, 0x18, 0x03,
    0x00, 0x00, 0x2e, 0x03, 0x00, 0x00, 0x4c, 0x03, 0x00, 0x00, 0x66, 0x03,
    0x00, 0x00, 0x73, 0x03, 0x00, 0x80, 0x8d, 0x03, 0x00, 0x00, 0xb0, 0x03,
    0x00, 0x00, 0xc7, 0x03, 0x00, 0x80, 0xcf, 0x03, 0x00, 0x80, 0xce, 0x03,
    0x00, 0x80, 0xc4, 0x03, 0x00, 0x80, 0xb5, 0x03, 0x00, 0x00, 0xa3, 0x03,
    0x00, 0x00, 0x89, 0x03, 0x00, 0x80, 0x71, 0x03, 0x00, 0x80, 0x5a, 0x03,
    0x00, 0x80, 0x39, 0x03, 0x00, 0x00, 0x27, 0x03, 0x00, 0x00, 0x27, 0x03,
    0x00, 0x00, 0x16, 0x03, 0x00, 0x00, 0xf0, 0x02, 0x00, 0x00, 0xcb, 0x02,
    0x00, 0x80, 0xaf, 0x02, 0x00, 0x00, 0xa2, 0x02, 0x00, 0x00, 0x90, 0x02,
    0x00, 0x80, 0x74, 0x02, 0x00, 0x80, 0x62, 0x02, 0x00, 0x80, 0x46, 0x02,
    0x00, 0x80, 0x1a, 0x02, 0x00, 0x80, 0xf8, 0x01, 0x00, 0x80, 0xd4, 0x01,
    0x00, 0x80, 0xb3, 0x01, 0x00, 0x80, 0x9e, 0x01, 0x00, 0x80, 0x7d, 0x01,
    0x00, 0x00, 0x5e, 0x01, 0x00, 0x00, 0x56, 0x01, 0x00, 0x80, 0x3f, 0x01,
    0x00, 0x80, 0x25, 0x01, 0x00, 0x80, 0x1f, 0x01, 0x00, 0x00, 0x0e, 0x01,
    0x00, 0x00, 0xf9, 0x00, 0x00, 0x80, 0xed, 0x00, 0x00, 0x80, 0xd5, 0x00,
    0x00, 0x00, 0xae, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 0x80, 0x54, 0x00,
    0x00, 0x80, 0x2f, 0x00, 0x00, 0x80, 0x0c, 0x00, 0x00, 0x80, 0xe6, 0xff,
    0x00, 0x80, 0xba, 0xff, 0x00, 0x00, 0x87, 0xff, 0x00, 0x80, 0x59, 0xff,
    0x00, 0x00, 0x26, 0xff, 0x00, 0x00, 0xe4, 0xfe, 0x00, 0x80, 0xb0, 0xfe,
    0x00, 0x80, 0x8e, 0xfe, 0x00, 0x80, 0x68, 0xfe, 0x00, 0x00, 0x4e, 0xfe,
    0x00, 0x80, 0x3f, 0xfe, 0x00, 0x00, 0x29, 0xfe, 0x00, 0x80, 0x0e, 0xfe,
    0x00, 0x00, 0xf3, 0xfd, 0x00, 0x00, 0xd5, 0xfd, 0x00, 0x00, 0xc0, 0xfd,
    0x00, 0x80, 0xb1, 0xfd, 0x00, 0x80, 0xa3, 0xfd, 0x00, 0x80, 0x97, 0xfd,
    0x00, 0x00, 0x84, 0xfd, 0x00, 0x80, 0x67, 0xfd, 0x00, 0x00, 0x4b, 0xfd,
    0x00, 0x80, 0x28, 0xfd, 0x00, 0x80, 0x00, 0xfd, 0x00, 0x00, 0xe5, 0xfc,
    0x00, 0x00, 0xcf, 0xfc, 0x00, 0x80, 0xa6, 0xfc, 0x00, 0x80, 0x7a, 0xfc,
    0x00, 0x00, 0x5e, 0xfc, 0x00, 0x80, 0x46, 0xfc, 0x00, 0x00, 0x35, 0xfc,
    0x00, 0x80, 0x34, 0xfc, 0x00, 0x80, 0x35, 0xfc, 0x00, 0x80, 0x2e, 0xfc,
    0x00, 0x00, 0x27, 0xfc, 0x00, 0x80, 0x27, 0xfc, 0x00, 0x00, 0x32, 0xfc,
    0x00, 0x80, 0x3f, 0xfc, 0x00, 0x80, 0x4e, 0xfc, 0x00, 0x00, 0x5e, 0xfc,
    0x00, 0x00, 0x64, 0xfc, 0x00, 0x80, 0x6b, 0xfc, 0x00, 0x00, 0x79, 0xfc,
    0x00, 0x80, 0x81, 0xfc, 0x00, 0x80, 0x93, 0xfc, 0x00, 0x00, 0xb3, 0xfc,
    0x00, 0x00, 0xc3, 0xfc, 0x00, 0x00, 0xca, 0xfc, 0x00, 0x00, 0xdd, 0xfc,
    0x00, 0x80, 0xf0, 0xfc, 0x00, 0x80, 0x00, 0xfd, 0x00, 0x00, 0x1f, 0xfd,
    0x00, 0x00, 0x4c, 0xfd, 0x00, 0x00, 0x85, 0xfd, 0x00, 0x80, 0xbd, 0xfd,
    0x00, 0x00, 0xf0, 0xfd, 0x00, 0x80, 0x26, 0xfe, 0x00, 0x80, 0x5f, 0xfe,
    0x00, 0x00, 0x9b, 0xfe, 0x00, 0x80, 0xdc, 0xfe, 0x00, 0x00, 0x20, 0xff,
    0x00, 0x00, 0x64, 0xff, 0x00, 0x80, 0xa3, 0xff, 0x00, 0x80, 0xce, 0xff,
    0x00, 0x80, 0xed, 0xff, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x00, 0x32, 0x00,
    0x00, 0x00, 0x4d, 0x00, 0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x78, 0x00,
    0x00, 0x80, 0x8a, 0x00, 0x00, 0x80, 0x86, 0x00, 0x00, 0x00, 0x80, 0x00,
    0x00, 0x80, 0x8e, 0x00, 0x00, 0x00, 0x9d, 0x00, 0x00, 0x00, 0xa6, 0x00,
    0x00, 0x80, 0xb6, 0x00, 0x00, 0x80, 0xc8, 0x00, 0x00, 0x80, 0xd5, 0x00,
    0x00, 0x80, 0xe5, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x21, 0x01,
    0x00, 0x80, 0x39, 0x01, 0x00, 0x00, 0x49, 0x01, 0x00, 0x00, 0x61, 0x01,
    0x00, 0x80, 0x78, 0x01, 0x00, 0x00, 0x87, 0x01, 0x00, 0x80, 0x96, 0x01,
    0x00, 0x00, 0xaa, 0x01, 0x00, 0x00, 0xc2, 0x01, 0x00, 0x00, 0xe2, 0x01,
    0x00, 0x00, 0x00, 0x02, 0x00, 0x80, 0x13, 0x02, 0x00, 0x80, 0x18, 0x02,
    0x00, 0x00, 0x1c, 0x02, 0x00, 0x00, 0x1e, 0x02, 0x00, 0x80, 0x0f, 0x02,
    0x00, 0x00, 0x08, 0x02, 0x00, 0x80, 0x15, 0x02, 0x00, 0x00, 0x19, 0x02,
    0x00, 0x80, 0x12, 0x02, 0x00, 0x80, 0x0f, 0x02, 0x00, 0x00, 0xf8, 0x01,
    0x00, 0x80, 0xdd, 0x01, 0x00, 0x00, 0xdc, 0x01, 0x00, 0x00, 0xd9, 0x01,
    0x00, 0x00, 0xd8, 0x01, 0x00, 0x80, 0xdc, 0x01, 0x00, 0x80, 0xce, 0x01,
    0x00, 0x00, 0xc0, 0x01, 0x00, 0x00, 0xca, 0x01, 0x00, 0x80, 0xdb, 0x01,
    0x00, 0x80, 0xf4, 0x01, 0x00, 0x00, 0x09, 0x02, 0x00, 0x00, 0x06, 0x02,
    0x00, 0x80, 0xfc, 0x01, 0x00, 0x00, 0xf3, 0x01, 0x00, 0x00, 0xe4, 0x01,
    0x00, 0x00, 0xdd, 0x01, 0x00, 0x80, 0xd4, 0x01, 0x00, 0x80, 0xc9, 0x01,
    0x00, 0x00, 0xd7, 0x01, 0x00, 0x80, 0xeb, 0x01, 0x00, 0x00, 0xe0, 0x01,
    0x00, 0x80, 0xcf, 0x01, 0x00, 0x00, 0xda, 0x01, 0x00, 0x80, 0xef, 0x01,
    0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x18, 0x02, 0x00, 0x00, 0x34, 0x02,
    0x00, 0x80, 0x4b, 0x02, 0x00, 0x80, 0x6f, 0x02, 0x00, 0x00, 0x90, 0x02,
    0x00, 0x00, 0x97, 0x02, 0x00, 0x80, 0x9d, 0x02, 0x00, 0x00, 0xb3, 0x02,
    0x00, 0x00, 0xc7, 0x02, 0x00, 0x80, 0xd1, 0x02, 0x00, 0x80, 0xce, 0x02,
    0x00, 0x80, 0xc1, 0x02, 0x00, 0x80, 0xbb, 0x02, 0x00, 0x80, 0xaf, 0x02,
    0x00, 0x80, 0x9a, 0x02, 0x00, 0x00, 0x93, 0x02, 0x00, 0x80, 0x8e, 0x02,
    0x00, 0x80, 0x86, 0x02, 0x00, 0x80, 0x89, 0x02, 0x00, 0x00, 0x8f, 0x02,
    0x00, 0x80, 0x9f, 0x02, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x80, 0xde, 0x02,
    0x00, 0x00, 0xfc, 0x02, 0x00, 0x00, 0x1e, 0x03, 0x00, 0x80, 0x41, 0x03,
    0x00, 0x80, 0x69, 0x03, 0x00, 0x00, 0x86, 0x03, 0x00, 0x80, 0x98, 0x03,
    0x00, 0x00, 0xb4, 0x03, 0x00, 0x80, 0xcc, 0x03, 0x00, 0x00, 0xdd, 0x03,
    0x00, 0x80, 0xf0, 0x03, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x80, 0xfd, 0x03,
    0x00, 0x00, 0x0a, 0x04, 0x00, 0x80, 0x0f, 0x04, 0x00, 0x80, 0x12, 0x04,
    0x00, 0x80, 0x0c, 0x04, 0x00, 0x80, 0xf8, 0x03, 0x00, 0x00, 0xf6, 0x03,
    0x00, 0x00, 0xf2, 0x03, 0x00, 0x00, 0xd8, 0x03, 0x00, 0x80, 0xd3, 0x03,
    0x00, 0x00, 0xe6, 0x03, 0x00, 0x00, 0xea, 0x03, 0x00, 0x00, 0xde, 0x03,
    0x00, 0x80, 0xc6, 0x03, 0x00, 0x00, 0xaa, 0x03, 0x00, 0x80, 0x97, 0x03,
    0x00, 0x80, 0x90, 0x03, 0x00, 0x00, 0x8c, 0x03, 0x00, 0x00, 0x79, 0x03,
    0x00, 0x80, 0x54, 0x03, 0x00, 0x00, 0x2f, 0x03, 0x00, 0x00, 0x00, 0x03,
    0x00, 0x00, 0xcd, 0x02, 0x00, 0x80, 0xab, 0x02, 0x00, 0x80, 0x8a, 0x02,
    0x00, 0x80, 0x64, 0x02, 0x00, 0x80, 0x43, 0x02, 0x00, 0x80, 0x15, 0x02,
    0x00, 0x00, 0xea, 0x01, 0x00, 0x00, 0xd4, 0x01, 0x00, 0x00, 0xa9, 0x01,
    0x00, 0x80, 0x6d, 0x01, 0x00, 0x00, 0x43, 0x01, 0x00, 0x00, 0x1a, 0x01,
    0x00, 0x00, 0xf4, 0x00, 0x00, 0x80, 0xd2, 0x00, 0x00, 0x80, 0x9e, 0x00,
    0x00, 0x00, 0x66, 0x00, 0x00, 0x00, 0x33, 0x00, 0x00, 0x00, 0xf2, 0xff,
    0x00, 0x00, 0xab, 0xff, 0x00, 0x80, 0x6d, 0xff, 0x00, 0x80, 0x37, 0xff,
    0x00, 0x80, 0x09, 0xff, 0x00, 0x80, 0xcf, 0xfe, 0x00, 0x80, 0x8a, 0xfe,
    0x00, 0x00, 0x4a, 0xfe, 0x00, 0x00, 0x12, 0xfe, 0x00, 0x80, 0xe6, 0xfd,
    0x00, 0x80, 0xc9, 0xfd, 0x00, 0x00, 0xae, 0xfd, 0x00, 0x00, 0x8a, 0xfd,
    0x00, 0x00, 0x5a, 0xfd, 0x00, 0x00, 0x2e, 0xfd, 0x00, 0x00, 0x0e, 0xfd,
    0x00, 0x80, 0xea, 0xfc, 0x00, 0x80, 0xc2, 0xfc, 0x00, 0x80, 0x9f, 0xfc,
    0x00, 0x80, 0x77, 0xfc, 0x00, 0x80, 0x3d, 0xfc, 0x00, 0x80, 0xf9, 0xfb,
    0x00, 0x00, 0xc2, 0xfb, 0x00, 0x00, 0x9d, 0xfb, 0x00, 0x00, 0x73, 0xfb,
    0x00, 0x00, 0x3b, 0xfb, 0x00, 0x80, 0xfd, 0xfa, 0x00, 0x00, 0xc2, 0xfa,
    0x00, 0x00, 0x8f, 0xfa, 0x00, 0x00, 0x5c, 0xfa, 0x00, 0x00, 0x28, 0xfa,
    0x00, 0x00, 0x08, 0xfa, 0x00, 0x80, 0xf3, 0xf9, 0x00, 0x80, 0xde, 0xf9,
    0x00, 0x00, 0xd7, 0xf9, 0x00, 0x80, 0xd4, 0xf9, 0x00, 0x00, 0xdf, 0xf9,
    0x00, 0x00, 0x05, 0xfa, 0x00, 0x80, 0x23, 0xfa, 0x00, 0x00, 0x3a, 0xfa,
    0x00, 0x80, 0x5f, 0xfa, 0x00, 0x00, 0x83, 0xfa, 0x00, 0x80, 0xaa, 0xfa,
    0x00, 0x00, 0xd5, 0xfa, 0x00, 0x80, 0xf0, 0xfa, 0x00, 0x80, 0x0f, 0xfb,
    0x00, 0x80, 0x37, 0xfb, 0x00, 0x80, 0x53, 0xfb, 0x00, 0x00, 0x7c, 0xfb,
    0x00, 0x80, 0x9f, 0xfb, 0x00, 0x00, 0xa5, 0xfb, 0x00, 0x80, 0xb0, 0xfb,
    0x00, 0x80, 0xbb, 0xfb, 0x00, 0x00, 0xc1, 0xfb, 0x00, 0x00, 0xea, 0xfb,
    0x00, 0x80, 0x22, 0xfc, 0x00, 0x00, 0x4d, 0xfc, 0x00, 0x80, 0x76, 0xfc,
    0x00, 0x80, 0x90, 0xfc, 0x00, 0x00, 0xa9, 0xfc, 0x00, 0x00, 0xd4, 0xfc,
    0x00, 0x80, 0xfc, 0xfc, 0x00, 0x00, 0x24, 0xfd, 0x00, 0x00, 0x50, 0xfd,
    0x00, 0x00, 0x6b, 0xfd, 0x00, 0x00, 0x87, 0xfd, 0x00, 0x80, 0xb5, 0xfd,
    0x00, 0x00, 0xd9, 0xfd, 0x00, 0x80, 0xf2, 0xfd, 0x00, 0x00, 0x11, 0xfe,
    0x00, 0x00, 0x26, 0xfe, 0x00, 0x00, 0x2c, 0xfe, 0x00, 0x00, 0x33, 0xfe,
    0x00, 0x80, 0x40, 0xfe, 0x00, 0x00, 0x4b, 0xfe, 0x00, 0x00, 0x5c, 0xfe,
    0x00, 0x00, 0x72, 0xfe, 0x00, 0x80, 0x7e, 0xfe, 0x00, 0x00, 0x98, 0xfe,
    0x00, 0x80, 0xbc, 0xfe, 0x00, 0x00, 0xd2, 0xfe, 0x00, 0x80, 0xf3, 0xfe,
    0x00, 0x00, 0x2c, 0xff, 0x00, 0x80, 0x5c, 0xff, 0x00, 0x00, 0x96, 0xff,
    0x00, 0x80, 0xde, 0xff, 0x00, 0x00, 0x16, 0x00, 0x00, 0x80, 0x52, 0x00,
    0x00, 0x80, 0x92, 0x00, 0x00, 0x00, 0xbc, 0x00, 0x00, 0x00, 0xea, 0x00,
    0x00, 0x80, 0x2c, 0x01, 0x00, 0x80, 0x67, 0x01, 0x00, 0x80, 0x8e, 0x01,
    0x00, 0x00, 0x9b, 0x01, 0x00, 0x00, 0x9b, 0x01, 0x00, 0x80, 0xa2, 0x01,
    0x00, 0x00, 0xad, 0x01, 0x00, 0x00, 0xbc, 0x01, 0x00, 0x00, 0xd3, 0x01,
    0x00, 0x80, 0xe7, 0x01, 0x00, 0x80, 0xf1, 0x01, 0x00, 0x00, 0xf2, 0x01,
    0x00, 0x80, 0xed, 0x01, 0x00, 0x80, 0xee, 0x01, 0x00, 0x00, 0xfb, 0x01,
    0x00, 0x80, 0x15, 0x02, 0x00, 0x00, 0x3d, 0x02, 0x00, 0x80, 0x5b, 0x02,
    0x00, 0x80, 0x6c, 0x02, 0x00, 0x00, 0x75, 0x02, 0x00, 0x80, 0x7e, 0x02,
    0x00, 0x80, 0x93, 0x02, 0x00, 0x80, 0xa5, 0x02, 0x00, 0x00, 0xaa, 0x02,
    0x00, 0x00, 0xab, 0x02, 0x00, 0x80, 0xa2, 0x02, 0x00, 0x00, 0x90, 0x02,
    0x00, 0x00, 0x82, 0x02, 0x00, 0x00, 0x6c, 0x02, 0x00, 0x80, 0x4a, 0x02,
    0x00, 0x80, 0x34, 0x02, 0x00, 0x80, 0x25, 0x02, 0x00, 0x80, 0x11, 0x02,
    0x00, 0x00, 0x02, 0x02, 0x00, 0x80, 0xee, 0x01, 0x00, 0x80, 0xc7, 0x01,
    0x00, 0x00, 0x90, 0x01, 0x00, 0x80, 0x61, 0x01, 0x00, 0x00, 0x42, 0x01,
    0x00, 0x00, 0x2a, 0x01, 0x00, 0x00, 0x1a, 0x01, 0x00, 0x00, 0x0b, 0x01,
    0x00, 0x80, 0xf6, 0x00, 0x00, 0x00, 0xe4, 0x00, 0x00, 0x80, 0xca, 0x00,
    0x00, 0x80, 0xab, 0x00, 0x00, 0x00, 0x9d, 0x00, 0x00, 0x00, 0x97, 0x00,
    0x00, 0x00, 0x8d, 0x00, 0x00, 0x80, 0x88, 0x00, 0x00, 0x80, 0x85, 0x00,
    0x00, 0x00, 0x85, 0x00, 0x00, 0x80, 0x8a, 0x00, 0x00, 0x80, 0x83, 0x00,
    0x00, 0x80, 0x74, 0x00, 0x00, 0x00, 0x6a, 0x00, 0x00, 0x80, 0x64, 0x00,
    0x00, 0x80, 0x5d, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x80, 0x1f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xe0, 0xff, 0x00, 0x80, 0xba, 0xff,
    0x00, 0x00, 0x9b, 0xff, 0x00, 0x80, 0x75, 0xff, 0x00, 0x80, 0x47, 0xff,
    0x00, 0x80, 0x1f, 0xff, 0x00, 0x00, 0xfe, 0xfe, 0x00, 0x80, 0xe5, 0xfe,
    0x00, 0x00, 0xd8, 0xfe, 0x00, 0x00, 0xd0, 0xfe, 0x00, 0x80, 0xd1, 0xfe,
    0x00, 0x80, 0xd4, 0xfe, 0x00, 0x80, 0xd4, 0xfe, 0x00, 0x00, 0xd8, 0xfe,
    0x00, 0x80, 0xcf, 0xfe, 0x00, 0x00, 0xc2, 0xfe, 0x00, 0x80, 0xbe, 0xfe,
    0x00, 0x80, 0xb2, 0xfe, 0x00, 0x80, 0xa8, 0xfe, 0x00, 0x80, 0xa9, 0xfe,
    0x00, 0x00, 0x9f, 0xfe, 0x00, 0x00, 0x85, 0xfe, 0x00, 0x00, 0x64, 0xfe,
    0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x2c, 0xfe, 0x00, 0x80, 0x21, 0xfe,
    0x00, 0x00, 0x0c, 0xfe, 0x00, 0x80, 0xfc, 0xfd, 0x00, 0x00, 0xea, 0xfd,
    0x00, 0x80, 0xc0, 0xfd, 0x00, 0x00, 0xa1, 0xfd, 0x00, 0x00, 0x9b, 0xfd,
    0x00, 0x00, 0x9b, 0xfd, 0x00, 0x80, 0xa5, 0xfd, 0x00, 0x80, 0xb1, 0xfd,
    0x00, 0x80, 0xb1, 0xfd, 0x00, 0x00, 0xb2, 0xfd, 0x00, 0x80, 0xbf, 0xfd,
    0x00, 0x80, 0xd8, 0xfd, 0x00, 0x80, 0xf2, 0xfd, 0x00, 0x00, 0x05, 0xfe,
    0x00, 0x00, 0x14, 0xfe, 0x00, 0x00, 0x26, 0xfe, 0x00, 0x00, 0x25, 0xfe,
    0x00, 0x80, 0x1a, 0xfe, 0x00, 0x80, 0x1e, 0xfe, 0x00, 0x80, 0x24, 0xfe,
    0x00, 0x00, 0x22, 0xfe, 0x00, 0x00, 0x2a, 0xfe, 0x00, 0x80, 0x35, 0xfe,
    0x00, 0x00, 0x3e, 0xfe, 0x00, 0x80, 0x50, 0xfe, 0x00, 0x00, 0x62, 0xfe,
    0x00, 0x00, 0x70, 0xfe, 0x00, 0x00, 0x94, 0xfe, 0x00, 0x80, 0xca, 0xfe,
    0x00, 0x80, 0x01, 0xff, 0x00, 0x00, 0x41, 0xff, 0x00, 0x80, 0x86, 0xff,
    0x00, 0x00, 0xc5, 0xff, 0x00, 0x00, 0xfc, 0xff, 0x00, 0x00, 0x3f, 0x00,
    0x00, 0x80, 0x8f, 0x00, 0x00, 0x00, 0xcb, 0x00, 0x00, 0x80, 0xee, 0x00,
    0x00, 0x80, 0x18, 0x01, 0x00, 0x80, 0x31, 0x01, 0x00, 0x80, 0x37, 0x01,
    0x00, 0x00, 0x4d, 0x01, 0x00, 0x80, 0x5e, 0x01, 0x00, 0x80, 0x5f, 0x01,
    0x00, 0x00, 0x5e, 0x01, 0x00, 0x80, 0x4c, 0x01, 0x00, 0x80, 0x34, 0x01,
    0x00, 0x80, 0x29, 0x01, 0x00, 0x80, 0x1c, 0x01, 0x00, 0x00, 0x16, 0x01,
    0x00, 0x00, 0x15, 0x01, 0x00, 0x80, 0x0e, 0x01, 0x00, 0x00, 0x15, 0x01,
    0x00, 0x00, 0x1e, 0x01, 0x00, 0x00, 0x25, 0x01, 0x00, 0x80, 0x47, 0x01,
    0x00, 0x00, 0x64, 0x01, 0x00, 0x00, 0x6d, 0x01, 0x00, 0x80, 0x86, 0x01,
    0x00, 0x80, 0x95, 0x01, 0x00, 0x00, 0x93, 0x01, 0x00, 0x00, 0xa4, 0x01,
    0x00, 0x00, 0xb3, 0x01, 0x00, 0x80, 0xbe, 0x01, 0x00, 0x80, 0xd5, 0x01,
    0x00, 0x80, 0xd6, 0x01, 0x00, 0x80, 0xcd, 0x01, 0x00, 0x00, 0xca, 0x01,
    0x00, 0x80, 0xae, 0x01, 0x00, 0x00, 0x93, 0x01, 0x00, 0x80, 0x82, 0x01,
    0x00, 0x00, 0x6b, 0x01, 0x00, 0x80, 0x5e, 0x01, 0x00, 0x00, 0x5a, 0x01,
    0x00, 0x00, 0x4e, 0x01, 0x00, 0x80, 0x49, 0x01, 0x00, 0x00, 0x41, 0x01,
    0x00, 0x00, 0x2e, 0x01, 0x00, 0x00, 0x1e, 0x01, 0x00, 0x00, 0x13, 0x01,
    0x00, 0x00, 0x23, 0x01, 0x00, 0x00, 0x46, 0x01, 0x00, 0x00, 0x4e, 0x01,
    0x00, 0x00, 0x43, 0x01, 0x00, 0x00, 0x3b, 0x01, 0x00, 0x80, 0x23, 0x01,
    0x00, 0x00, 0x12, 0x01, 0x00, 0x80, 0x1d, 0x01, 0x00, 0x80, 0x2b, 0x01,
    0x00, 0x00, 0x26, 0x01, 0x00, 0x00, 0x13, 0x01, 0x00, 0x00, 0xf3, 0x00,
    0x00, 0x80, 0xcd, 0x00, 0x00, 0x80, 0xb2, 0x00, 0x00, 0x80, 0x9c, 0x00,
    0x00, 0x00, 0x78, 0x00, 0x00, 0x80, 0x61, 0x00, 0x00, 0x80, 0x72, 0x00,
    0x00, 0x80, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x8e, 0x00,
    0x00, 0x00, 0xab, 0x00, 0x00, 0x80, 0xd0, 0x00, 0x00, 0x00, 0xfb, 0x00,
    0x00, 0x00, 0x20, 0x01, 0x00, 0x00, 0x53, 0x01, 0x00, 0x80, 0x8b, 0x01,
    0x00, 0x80, 0xaf, 0x01, 0x00, 0x80, 0xd0, 0x01, 0x00, 0x00, 0xf3, 0x01,
    0x00, 0x80, 0xfc, 0x01, 0x00, 0x80, 0xf6, 0x01, 0x00, 0x00, 0xfa, 0x01,
    0x00, 0x00, 0x02, 0x02, 0x00, 0x80, 0xfc, 0x01, 0x00, 0x80, 0xec, 0x01,
    0x00, 0x00, 0xea, 0x01, 0x00, 0x00, 0xe7, 0x01, 0x00, 0x80, 0xd7, 0x01,
    0x00, 0x00, 0xe6, 0x01, 0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x13, 0x02,
    0x00, 0x80, 0x2a, 0x02, 0x00, 0x00, 0x49, 0x02, 0x00, 0x00, 0x5b, 0x02,
    0x00, 0x80, 0x86, 0x02, 0x00, 0x00, 0xc8, 0x02, 0x00, 0x80, 0xf6, 0x02,
    0x00, 0x00, 0x1a, 0x03, 0x00, 0x00, 0x48, 0x03, 0x00, 0x80, 0x82, 0x03,
    0x00, 0x80, 0xbd, 0x03, 0x00, 0x00, 0xdf, 0x03, 0x00, 0x80, 0xec, 0x03,
    0x00, 0x00, 0x03, 0x04, 0x00, 0x00, 0x20, 0x04, 0x00, 0x00, 0x29, 0x04,
    0x00, 0x00, 0x25, 0x04, 0x00, 0x80, 0x34, 0x04, 0x00, 0x00, 0x4e, 0x04,
    0x00, 0x00, 0x59, 0x04, 0x00, 0x80, 0x63, 0x04, 0x00, 0x00, 0x6c, 0x04,
    0x00, 0x80, 0x5f, 0x04, 0x00, 0x00, 0x58, 0x04, 0x00, 0x80, 0x5b, 0x04,
    0x00, 0x00, 0x53, 0x04, 0x00, 0x00, 0x51, 0x04, 0x00, 0x80, 0x65, 0x04,
    0x00, 0x80, 0x75, 0x04, 0x00, 0x00, 0x77, 0x04, 0x00, 0x00, 0x6e, 0x04,
    0x00, 0x80, 0x63, 0x04, 0x00, 0x80, 0x5f, 0x04, 0x00, 0x80, 0x57, 0x04,
    0x00, 0x00, 0x47, 0x04, 0x00, 0x80, 0x2f, 0x04, 0x00, 0x80, 0x10, 0x04,
    0x00, 0x00, 0xf6, 0x03, 0x00, 0x80, 0xd8, 0x03, 0x00, 0x00, 0xa5, 0x03,
    0x00, 0x80, 0x75, 0x03, 0x00, 0x80, 0x5e, 0x03, 0x00, 0x80, 0x47, 0x03,
    0x00, 0x00, 0x22, 0x03, 0x00, 0x80, 0xf3, 0x02, 0x00, 0x00, 0xbe, 0x02,
    0x00, 0x00, 0x90, 0x02, 0x00, 0x80, 0x6c, 0x02, 0x00, 0x80, 0x3a, 0x02,
    0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0xdc, 0x01, 0x00, 0x80, 0xb7, 0x01,
    0x00, 0x80, 0x78, 0x01, 0x00, 0x80, 0x2d, 0x01, 0x00, 0x00, 0xe6, 0x00,
    0x00, 0x00, 0xa4, 0x00, 0x00, 0x00, 0x6a, 0x00, 0x00, 0x80, 0x29, 0x00,
    0x00, 0x00, 0xed, 0xff, 0x00, 0x80, 0xce, 0xff, 0x00, 0x80, 0xa5, 0xff,
    0x00, 0x80, 0x5d, 0xff, 0x00, 0x00, 0x20, 0xff, 0x00, 0x00, 0xe3, 0xfe,
    0x00, 0x80, 0x98, 0xfe, 0x00, 0x80, 0x66, 0xfe, 0x00, 0x80, 0x44, 0xfe,
    0x00, 0x80, 0x0c, 0xfe, 0x00, 0x00, 0xcd, 0xfd, 0x00, 0x80, 0x88, 0xfd,
    0x00, 0x80, 0x40, 0xfd, 0x00, 0x00, 0x06, 0xfd, 0x00, 0x80, 0xd1, 0xfc,
    0x00, 0x00, 0x93, 0xfc, 0x00, 0x80, 0x53, 0xfc, 0x00, 0x00, 0x14, 0xfc,
    0x00, 0x80, 0xcf, 0xfb, 0x00, 0x80, 0x90, 0xfb, 0x00, 0x80, 0x56, 0xfb,
    0x00, 0x00, 0x1d, 0xfb, 0x00, 0x80, 0xec, 0xfa, 0x00, 0x00, 0xc1, 0xfa,
    0x00, 0x00, 0x8c, 0xfa, 0x00, 0x00, 0x56, 0xfa, 0x00, 0x80, 0x29, 0xfa,
    0x00, 0x00, 0xfa, 0xf9, 0x00, 0x00, 0xcf, 0xf9, 0x00, 0x80, 0xbf, 0xf9,
    0x00, 0x00, 0xb6, 0xf9, 0x00, 0x00, 0x9c, 0xf9, 0x00, 0x80, 0x82, 0xf9,
    0x00, 0x00, 0x79, 0xf9, 0x00, 0x00, 0x7b, 0xf9, 0x00, 0x80, 0x80, 0xf9,
    0x00, 0x80, 0x82, 0xf9, 0x00, 0x80, 0x7e, 0xf9, 0x00, 0x00, 0x7c, 0xf9,
    0x00, 0x80, 0x81, 0xf9, 0x00, 0x00, 0x97, 0xf9, 0x00, 0x00, 0xb9, 0xf9,
    0x00, 0x00, 0xd8, 0xf9, 0x00, 0x80, 0xf0, 0xf9, 0x00, 0x00, 0x09, 0xfa,
    0x00, 0x00, 0x2d, 0xfa, 0x00, 0x80, 0x5b, 0xfa, 0x00, 0x80, 0x82, 0xfa,
    0x00, 0x80, 0xa5, 0xfa, 0x00, 0x80, 0xca, 0xfa, 0x00, 0x00, 0xe9, 0xfa,
    0x00, 0x80, 0x0b, 0xfb, 0x00, 0x80, 0x3f, 0xfb, 0x00, 0x80, 0x73, 0xfb,
    0x00, 0x80, 0x9b, 0xfb, 0x00, 0x00, 0xbf, 0xfb, 0x00, 0x00, 0xe0, 0xfb,
    0x00, 0x00, 0x0c, 0xfc, 0x00, 0x00, 0x44, 0xfc, 0x00, 0x80, 0x6d, 0xfc,
    0x00, 0x00, 0x8b, 0xfc, 0x00, 0x00, 0xa6, 0xfc, 0x00, 0x00, 0xb4, 0xfc,
    0x00, 0x00, 0xc7, 0xfc, 0x00, 0x00, 0xe9, 0xfc, 0x00, 0x00, 0x07, 0xfd,
    0x00, 0x00, 0x2a, 0xfd, 0x00, 0x80, 0x50, 0xfd, 0x00, 0x00, 0x67, 0xfd,
    0x00, 0x00, 0x79, 0xfd, 0x00, 0x00, 0x91, 0xfd, 0x00, 0x80, 0xaa, 0xfd,
    0x00, 0x00, 0xd4, 0xfd, 0x00, 0x80, 0x0b, 0xfe, 0x00, 0x80, 0x46, 0xfe,
    0x00, 0x80, 0x85, 0xfe, 0x00, 0x80, 0xb6, 0xfe, 0x00, 0x80, 0xd8, 0xfe,
    0x00, 0x80, 0x0a, 0xff, 0x00, 0x80, 0x4c, 0xff, 0x00, 0x80, 0x91, 0xff,
    0x00, 0x80, 0xd5, 0xff, 0x00, 0x80, 0x15, 0x00, 0x00, 0x00, 0x53, 0x00,
    0x00, 0x00, 0x8a, 0x00, 0x00, 0x80, 0xb4, 0x00, 0x00, 0x80, 0xe2, 0x00,
    0x00, 0x00, 0x11, 0x01, 0x00, 0x80, 0x3a, 0x01, 0x00, 0x80, 0x6f, 0x01,
    0x00, 0x80, 0xa8, 0x01, 0x00, 0x00, 0xcc, 0x01, 0x00, 0x80, 0xde, 0x01,
    0x00, 0x80, 0xed, 0x01, 0x00, 0x80, 0x05, 0x02, 0x00, 0x00, 0x2a, 0x02,
    0x00, 0x00, 0x5b, 0x02, 0x00, 0x00, 0x93, 0x02, 0x00, 0x80, 0xc6, 0x02,
    0x00, 0x00, 0xef, 0x02, 0x00, 0x80, 0x0e, 0x03, 0x00, 0x00, 0x20, 0x03,
    0x00, 0x00, 0x2f, 0x03, 0x00, 0x80, 0x4a, 0x03, 0x00, 0x00, 0x66, 0x03,
    0x00, 0x00, 0x84, 0x03, 0x00, 0x80, 0x9d, 0x03, 0x00, 0x80, 0x9c, 0x03,
    0x00, 0x80, 0x9c, 0x03, 0x00, 0x00, 0xac, 0x03, 0x00, 0x80, 0xa8, 0x03,
    0x00, 0x80, 0xa1, 0x03, 0x00, 0x80, 0xaa, 0x03, 0x00, 0x80, 0xb1, 0x03,
    0x00, 0x00, 0xb4, 0x03, 0x00, 0x00, 0xb1, 0x03, 0x00, 0x00, 0xa5, 0x03,
    0x00, 0x80, 0x9d, 0x03, 0x00, 0x00, 0x95, 0x03, 0x00, 0x80, 0x85, 0x03,
    0x00, 0x80, 0x7f, 0x03, 0x00, 0x00, 0x7f, 0x03, 0x00, 0x00, 0x7e, 0x03,
    0x00, 0x00, 0x71, 0x03, 0x00, 0x00, 0x4b, 0x03, 0x00, 0x80, 0x16, 0x03,
    0x00, 0x00, 0xe3, 0x02, 0x00, 0x80, 0xb5, 0x02, 0x00, 0x00, 0x99, 0x02,
    0x00, 0x00, 0x8a, 0x02, 0x00, 0x80, 0x72, 0x02, 0x00, 0x80, 0x48, 0x02,
    0x00, 0x80, 0x17, 0x02, 0x00, 0x80, 0xf6, 0x01, 0x00, 0x00, 0xe3, 0x01,
    0x00, 0x00, 0xc5, 0x01, 0x00, 0x80, 0xa5, 0x01, 0x00, 0x00, 0x98, 0x01,
    0x00, 0x00, 0x8f, 0x01, 0x00, 0x00, 0x7e, 0x01, 0x00, 0x80, 0x6e, 0x01,
    0x00, 0x80, 0x6c, 0x01, 0x00, 0x00, 0x66, 0x01, 0x00, 0x80, 0x47, 0x01,
    0x00, 0x00, 0x31, 0x01, 0x00, 0x80, 0x28, 0x01, 0x00, 0x00, 0x03, 0x01,
    0x00, 0x80, 0xd6, 0x00, 0x00, 0x00, 0xba, 0x00, 0x00, 0x00, 0x8a, 0x00,
    0x00, 0x80, 0x56, 0x00, 0x00, 0x00, 0x42, 0x00, 0x00, 0x80, 0x22, 0x00,
    0x00, 0x00, 0xe4, 0xff, 0x00, 0x00, 0xb5, 0xff, 0x00, 0x00, 0x92, 0xff,
    0x00, 0x80, 0x63, 0xff, 0x00, 0x00, 0x31, 0xff, 0x00, 0x00, 0x0b, 0xff,
    0x00, 0x80, 0xed, 0xfe, 0x00, 0x80, 0xcb, 0xfe, 0x00, 0x00, 0xa3, 0xfe,
    0x00, 0x00, 0x85, 0xfe, 0x00, 0x80, 0x70, 0xfe, 0x00, 0x80, 0x58, 0xfe,
    0x00, 0x00, 0x40, 0xfe, 0x00, 0x00, 0x32, 0xfe, 0x00, 0x00, 0x24, 0xfe,
    0x00, 0x00, 0x08, 0xfe, 0x00, 0x00, 0xea, 0xfd, 0x00, 0x80, 0xd3, 0xfd,
    0x00, 0x00, 0xc1, 0xfd, 0x00, 0x80, 0xa5, 0xfd, 0x00, 0x00, 0x83, 0xfd,
    0x00, 0x00, 0x6c, 0xfd, 0x00, 0x00, 0x5d, 0xfd, 0x00, 0x80, 0x43, 0xfd,
    0x00, 0x80, 0x21, 0xfd, 0x00, 0x80, 0xf8, 0xfc, 0x00, 0x00, 0xca, 0xfc,
    0x00, 0x80, 0xa7, 0xfc, 0x00, 0x80, 0x90, 0xfc, 0x00, 0x80, 0x81, 0xfc,
    0x00, 0x00, 0x82, 0xfc, 0x00, 0x00, 0x87, 0xfc, 0x00, 0x00, 0x85, 0xfc,
    0x00, 0x00, 0x85, 0xfc, 0x00, 0x80, 0x84, 0xfc, 0x00, 0x00, 0x82, 0xfc,
    0x00, 0x00, 0x8c, 0xfc, 0x00, 0x80, 0x9a, 0xfc, 0x00, 0x80, 0xa2, 0xfc,
    0x00, 0x00, 0xab, 0xfc, 0x00, 0x00, 0xb3, 0xfc, 0x00, 0x80, 0xb3, 0xfc,
    0x00, 0x00, 0xbc, 0xfc, 0x00, 0x80, 0xcf, 0xfc, 0x00, 0x80, 0xd9, 0xfc,
    0x00, 0x80, 0xe2, 0xfc, 0x00, 0x00, 0xf5, 0xfc, 0x00, 0x00, 0x00, 0xfd,
    0x00, 0x00, 0x12, 0xfd, 0x00, 0x80, 0x3a, 0xfd, 0x00, 0x80, 0x62, 0xfd,
    0x00, 0x80, 0x89, 0xfd, 0x00, 0x00, 0xbe, 0xfd, 0x00, 0x00, 0xea, 0xfd,
    0x00, 0x80, 0x15, 0xfe, 0x00, 0x00, 0x56, 0xfe, 0x00, 0x80, 0x9a, 0xfe,
    0x00, 0x80, 0xd7, 0xfe, 0x00, 0x80, 0x18, 0xff, 0x00, 0x80, 0x5b, 0xff,
    0x00, 0x80, 0xa2, 0xff, 0x00, 0x80, 0xde, 0xff, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x5d, 0x00, 0x00, 0x00, 0x76, 0x00,
    0x00, 0x80, 0x9c, 0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x00, 0xce, 0x00,
    0x00, 0x80, 0xe2, 0x00, 0x00, 0x80, 0xf6, 0x00, 0x00, 0x00, 0xfc, 0x00,
    0x00, 0x00, 0x0c, 0x01, 0x00, 0x80, 0x1c, 0x01, 0x00, 0x80, 0x22, 0x01,
    0x00, 0x80, 0x37, 0x01, 0x00, 0x00, 0x53, 0x01, 0x00, 0x80, 0x65, 0x01,
    0x00, 0x80, 0x83, 0x01, 0x00, 0x80, 0xa5, 0x01, 0x00, 0x00, 0xc0, 0x01,
    0x00, 0x00, 0xe4, 0x01, 0x00, 0x00, 0x0f, 0x02, 0x00, 0x80, 0x32, 0x02,
    0x00, 0x80, 0x54, 0x02, 0x00, 0x00, 0x6b, 0x02, 0x00, 0x80, 0x74, 0x02,
    0x00, 0x00, 0x87, 0x02, 0x00, 0x00, 0x9c, 0x02, 0x00, 0x00, 0xa7, 0x02,
    0x00, 0x80, 0xb5, 0x02, 0x00, 0x00, 0xbc, 0x02, 0x00, 0x00, 0xb1, 0x02,
    0x00, 0x80, 0xae, 0x02, 0x00, 0x80, 0xb5, 0x02, 0x00, 0x80, 0xb7, 0x02,
    0x00, 0x80, 0xbc, 0x02, 0x00, 0x00, 0xc3, 0x02, 0x00, 0x00, 0xcc, 0x02,
    0x00, 0x00, 0xdf, 0x02, 0x00, 0x00, 0xe1, 0x02, 0x00, 0x00, 0xce, 0x02,
    0x00, 0x00, 0xcc, 0x02, 0x00, 0x00, 0xd6, 0x02, 0x00, 0x00, 0xd6, 0x02,
    0x00, 0x80, 0xdc, 0x02, 0x00, 0x00, 0xe8, 0x02, 0x00, 0x00, 0xda, 0x02,
    0x00, 0x00, 0xba, 0x02, 0x00, 0x80, 0xa9, 0x02, 0x00, 0x80, 0xa4, 0x02,
    0x00, 0x80, 0x92, 0x02, 0x00, 0x80, 0x83, 0x02, 0x00, 0x00, 0x7a, 0x02,
    0x00, 0x80, 0x5b, 0x02, 0x00, 0x00, 0x35, 0x02, 0x00, 0x00, 0x1e, 0x02,
    0x00, 0x00, 0x16, 0x02, 0x00, 0x80, 0x12, 0x02, 0x00, 0x80, 0x04, 0x02,
    0x00, 0x80, 0xfe, 0x01, 0x00, 0x00, 0x18, 0x02, 0x00, 0x00, 0x2a, 0x02,
    0x00, 0x80, 0x1d, 0x02, 0x00, 0x80, 0x1c, 0x02, 0x00, 0x80, 0x2e, 0x02,
    0x00, 0x80, 0x40, 0x02, 0x00, 0x00, 0x51, 0x02, 0x00, 0x00, 0x59, 0x02,
    0x00, 0x00, 0x59, 0x02, 0x00, 0x80, 0x5d, 0x02, 0x00, 0x00, 0x62, 0x02,
    0x00, 0x00, 0x60, 0x02, 0x00, 0x00, 0x58, 0x02, 0x00, 0x80, 0x50, 0x02,
    0x00, 0x80, 0x48, 0x02, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0x3e, 0x02,
    0x00, 0x00, 0x32, 0x02, 0x00, 0x80, 0x1b, 0x02, 0x00, 0x00, 0x21, 0x02,
    0x00, 0x80, 0x30, 0x02, 0x00, 0x00, 0x27, 0x02, 0x00, 0x80, 0x25, 0x02,
    0x00, 0x00, 0x31, 0x02, 0x00, 0x00, 0x2f, 0x02, 0x00, 0x80, 0x30, 0x02,
    0x00, 0x00, 0x32, 0x02, 0x00, 0x00, 0x2f, 0x02, 0x00, 0x80, 0x46, 0x02,
    0x00, 0x00, 0x67, 0x02, 0x00, 0x00, 0x7f, 0x02, 0x00, 0x80, 0x9a, 0x02,
    0x00, 0x80, 0xaf, 0x02, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x80, 0xda, 0x02,
    0x00, 0x80, 0xe8, 0x02, 0x00, 0x00, 0xe6, 0x02, 0x00, 0x00, 0xf0, 0x02,
    0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x07, 0x03, 0x00, 0x80, 0x03, 0x03,
    0x00, 0x80, 0x04, 0x03, 0x00, 0x00, 0x0f, 0x03, 0x00, 0x00, 0x1b, 0x03,
    0x00, 0x00, 0x1e, 0x03, 0x00, 0x00, 0x13, 0x03, 0x00, 0x00, 0x05, 0x03,
    0x00, 0x80, 0x06, 0x03, 0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0xf1, 0x02,
    0x00, 0x00, 0xf0, 0x02, 0x00, 0x00, 0xf1, 0x02, 0x00, 0x00, 0xea, 0x02,
    0x00, 0x00, 0xe8, 0x02, 0x00, 0x80, 0xd5, 0x02, 0x00, 0x80, 0xb1, 0x02,
    0x00, 0x80, 0xa0, 0x02, 0x00, 0x00, 0x9a, 0x02, 0x00, 0x00, 0x87, 0x02,
    0x00, 0x80, 0x69, 0x02, 0x00, 0x00, 0x4c, 0x02, 0x00, 0x00, 0x34, 0x02,
    0x00, 0x00, 0x13, 0x02, 0x00, 0x80, 0xe9, 0x01, 0x00, 0x00, 0xcb, 0x01,
    0x00, 0x00, 0xab, 0x01, 0x00, 0x00, 0x8a, 0x01, 0x00, 0x00, 0x72, 0x01,
    0x00, 0x00, 0x48, 0x01, 0x00, 0x00, 0x14, 0x01, 0x00, 0x00, 0xf1, 0x00,
    0x00, 0x80, 0xcb, 0x00, 0x00, 0x80, 0x9a, 0x00, 0x00, 0x00, 0x68, 0x00,
    0x00, 0x00, 0x2e, 0x00, 0x00, 0x00, 0xf7, 0xff, 0x00, 0x80, 0xca, 0xff,
    0x00, 0x80, 0x92, 0xff, 0x00, 0x80, 0x57, 0xff, 0x00, 0x80, 0x2a, 0xff,
    0x00, 0x00, 0xf7, 0xfe, 0x00, 0x80, 0xb4, 0xfe, 0x00, 0x80, 0x7d, 0xfe,
    0x00, 0x00, 0x5a, 0xfe, 0x00, 0x00, 0x35, 0xfe, 0x00, 0x80, 0x03, 0xfe,
    0x00, 0x00, 0xcb, 0xfd, 0x00, 0x00, 0x93, 0xfd, 0x00, 0x00, 0x66, 0xfd,
    0x00, 0x00, 0x47, 0xfd, 0x00, 0x00, 0x27, 0xfd, 0x00, 0x80, 0x01, 0xfd,
    0x00, 0x80, 0xdf, 0xfc, 0x00, 0x80, 0xb9, 0xfc, 0x00, 0x00, 0x8d, 0xfc,
    0x00, 0x00, 0x67, 0xfc, 0x00, 0x00, 0x42, 0xfc, 0x00, 0x80, 0x11, 0xfc,
    0x00, 0x80, 0xdc, 0xfb, 0x00, 0x80, 0xac, 0xfb, 0x00, 0x00, 0x7a, 0xfb,
    0x00, 0x80, 0x43, 0xfb, 0x00, 0x00, 0x17, 0xfb, 0x00, 0x80, 0xf5, 0xfa,
    0x00, 0x80, 0xdc, 0xfa, 0x00, 0x00, 0xc2, 0xfa, 0x00, 0x80, 0x94, 0xfa,
    0x00, 0x80, 0x66, 0xfa, 0x00, 0x80, 0x51, 0xfa, 0x00, 0x00, 0x3b, 0xfa,
    0x00, 0x00, 0x1e, 0xfa, 0x00, 0x00, 0x13, 0xfa, 0x00, 0x00, 0x10, 0xfa,
    0x00, 0x00, 0x09, 0xfa, 0x00, 0x80, 0xff, 0xf9, 0x00, 0x80, 0xf7, 0xf9,
    0x00, 0x80, 0x07, 0xfa, 0x00, 0x00, 0x1d, 0xfa, 0x00, 0x00, 0x1a, 0xfa,
    0x00, 0x80, 0x1e, 0xfa, 0x00, 0x80, 0x39, 0xfa, 0x00, 0x80, 0x4c, 0xfa,
    0x00, 0x80, 0x66, 0xfa, 0x00, 0x80, 0x91, 0xfa, 0x00, 0x80, 0xb3, 0xfa,
    0x00, 0x00, 0xc9, 0xfa, 0x00, 0x00, 0xe4, 0xfa, 0x00, 0x00, 0x13, 0xfb,
    0x00, 0x00, 0x4f, 0xfb, 0x00, 0x00, 0x80, 0xfb, 0x00, 0x00, 0xa1, 0xfb,
    0x00, 0x80, 0xc5, 0xfb, 0x00, 0x80, 0xed, 0xfb, 0x00, 0x00, 0x13, 0xfc,
    0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x73, 0xfc, 0x00, 0x80, 0x99, 0xfc,
    0x00, 0x00, 0xb4, 0xfc, 0x00, 0x80, 0xdc, 0xfc, 0x00, 0x00, 0x02, 0xfd,
    0x00, 0x80, 0x1b, 0xfd, 0x00, 0x00, 0x44, 0xfd, 0x00, 0x80, 0x6b, 0xfd,
    0x00, 0x00, 0x75, 0xfd, 0x00, 0x80, 0x7e, 0xfd, 0x00, 0x00, 0x9f, 0xfd,
    0x00, 0x80, 0xc6, 0xfd, 0x00, 0x80, 0xf1, 0xfd, 0x00, 0x80, 0x1d, 0xfe,
    0x00, 0x80, 0x48, 0xfe, 0x00, 0x80, 0x63, 0xfe, 0x00, 0x80, 0x67, 0xfe,
    0x00, 0x00, 0x74, 0xfe, 0x00, 0x00, 0x94, 0xfe, 0x00, 0x00, 0xb2, 0xfe,
    0x00, 0x00, 0xd3, 0xfe, 0x00, 0x80, 0xf7, 0xfe, 0x00, 0x80, 0x14, 0xff,
    0x00, 0x80, 0x35, 0xff, 0x00, 0x80, 0x5a, 0xff, 0x00, 0x80, 0x7e, 0xff,
    0x00, 0x00, 0xaf, 0xff, 0x00, 0x80, 0xdd, 0xff, 0x00, 0x00, 0xf9, 0xff,
    0x00, 0x00, 0x19, 0x00, 0x00, 0x80, 0x42, 0x00, 0x00, 0x80, 0x65, 0x00,
    0x00, 0x00, 0x88, 0x00, 0x00, 0x80, 0xb7, 0x00, 0x00, 0x80, 0xe3, 0x00,
    0x00, 0x00, 0x07, 0x01, 0x00, 0x00, 0x3b, 0x01, 0x00, 0x00, 0x70, 0x01,
    0x00, 0x00, 0x89, 0x01, 0x00, 0x00, 0x9e, 0x01, 0x00, 0x80, 0xb4, 0x01,
    0x00, 0x80, 0xb8, 0x01, 0x00, 0x80, 0xc9, 0x01, 0x00, 0x80, 0xef, 0x01,
    0x00, 0x00, 0x09, 0x02, 0x00, 0x80, 0x19, 0x02, 0x00, 0x00, 0x21, 0x02,
    0x00, 0x80, 0x17, 0x02, 0x00, 0x00, 0x0b, 0x02, 0x00, 0x80, 0xfe, 0x01,
    0x00, 0x00, 0xfc, 0x01, 0x00, 0x80, 0x07, 0x02, 0x00, 0x80, 0x0d, 0x02,
    0x00, 0x80, 0x11, 0x02, 0x00, 0x00, 0x1c, 0x02, 0x00, 0x80, 0x1f, 0x02,
    0x00, 0x00, 0x2a, 0x02, 0x00, 0x00, 0x3e, 0x02, 0x00, 0x80, 0x3f, 0x02,
    0x00, 0x80, 0x41, 0x02, 0x00, 0x00, 0x52, 0x02, 0x00, 0x80, 0x57, 0x02,
    0x00, 0x00, 0x59, 0x02, 0x00, 0x80, 0x5f, 0x02, 0x00, 0x00, 0x52, 0x02,
    0x00, 0x00, 0x36, 0x02, 0x00, 0x80, 0x22, 0x02, 0x00, 0x80, 0x0d, 0x02,
    0x00, 0x80, 0xf1, 0x01, 0x00, 0x80, 0xd6, 0x01, 0x00, 0x00, 0xb5, 0x01,
    0x00, 0x80, 0x7d, 0x01, 0x00, 0x00, 0x3e, 0x01, 0x00, 0x80, 0x0c, 0x01,
    0x00, 0x00, 0xe4, 0x00, 0x00, 0x80, 0xc1, 0x00, 0x00, 0x80, 0xb1, 0x00,
    0x00, 0x00, 0xa6, 0x00, 0x00, 0x80, 0x8a, 0x00, 0x00, 0x80, 0x6f, 0x00,
    0x00, 0x80, 0x5c, 0x00, 0x00, 0x80, 0x4d, 0x00, 0x00, 0x80, 0x41, 0x00,
    0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x4e, 0x00,
    0x00, 0x80, 0x48, 0x00, 0x00, 0x00, 0x36, 0x00, 0x00, 0x80, 0x2a, 0x00,
    0x00, 0x80, 0x1f, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0xeb, 0xff,
    0x00, 0x00, 0xcc, 0xff, 0x00, 0x80, 0xac, 0xff, 0x00, 0x80, 0x89, 0xff,
    0x00, 0x00, 0x5b, 0xff, 0x00, 0x80, 0x2e, 0xff, 0x00, 0x80, 0x12, 0xff,
    0x00, 0x00, 0xfc, 0xfe, 0x00, 0x00, 0xe5, 0xfe, 0x00, 0x00, 0xce, 0xfe,
    0x00, 0x00, 0xb5, 0xfe, 0x00, 0x80, 0x98, 0xfe, 0x00, 0x00, 0x7a, 0xfe,
    0x00, 0x00, 0x66, 0xfe, 0x00, 0x00, 0x60, 0xfe, 0x00, 0x00, 0x59, 0xfe,
    0x00, 0x00, 0x56, 0xfe, 0x00, 0x80, 0x5e, 0xfe, 0x00, 0x80, 0x5c, 0xfe,
    0x00, 0x80, 0x4b, 0xfe, 0x00, 0x00, 0x42, 0xfe, 0x00, 0x80, 0x40, 0xfe,
    0x00, 0x80, 0x35, 0xfe, 0x00, 0x00, 0x19, 0xfe, 0x00, 0x00, 0xfb, 0xfd,
    0x00, 0x00, 0xe3, 0xfd, 0x00, 0x80, 0xc7, 0xfd, 0x00, 0x00, 0xb0, 0xfd,
    0x00, 0x00, 0xa3, 0xfd, 0x00, 0x00, 0x86, 0xfd, 0x00, 0x00, 0x63, 0xfd,
    0x00, 0x00, 0x51, 0xfd, 0x00, 0x00, 0x3e, 0xfd, 0x00, 0x00, 0x2a, 0xfd,
    0x00, 0x80, 0x20, 0xfd, 0x00, 0x00, 0x07, 0xfd, 0x00, 0x80, 0xef, 0xfc,
    0x00, 0x00, 0x01, 0xfd, 0x00, 0x00, 0x17, 0xfd, 0x00, 0x00, 0x1f, 0xfd,
    0x00, 0x80, 0x2f, 0xfd, 0x00, 0x00, 0x38, 0xfd, 0x00, 0x00, 0x31, 0xfd,
    0x00, 0x80, 0x33, 0xfd, 0x00, 0x00, 0x37, 0xfd, 0x00, 0x80, 0x36, 0xfd,
    0x00, 0x80, 0x3f, 0xfd, 0x00, 0x00, 0x42, 0xfd, 0x00, 0x80, 0x30, 0xfd,
    0x00, 0x80, 0x20, 0xfd, 0x00, 0x00, 0x1d, 0xfd, 0x00, 0x00, 0x20, 0xfd,
    0x00, 0x00, 0x26, 0xfd, 0x00, 0x00, 0x2e, 0xfd, 0x00, 0x00, 0x35, 0xfd,
    0x00, 0x80, 0x41, 0xfd, 0x00, 0x00, 0x5a, 0xfd, 0x00, 0x00, 0x7a, 0xfd,
    0x00, 0x80, 0x99, 0xfd, 0x00, 0x80, 0xbe, 0xfd, 0x00, 0x80, 0xe7, 0xfd,
    0x00, 0x00, 0x10, 0xfe, 0x00, 0x80, 0x46, 0xfe, 0x00, 0x00, 0x8b, 0xfe,
    0x00, 0x00, 0xcd, 0xfe, 0x00, 0x80, 0x09, 0xff, 0x00, 0x00, 0x45, 0xff,
    0x00, 0x80, 0x77, 0xff, 0x00, 0x00, 0xa9, 0xff, 0x00, 0x80, 0xe3, 0xff,
    0x00, 0x00, 0x19, 0x00, 0x00, 0x80, 0x41, 0x00, 0x00, 0x00, 0x5f, 0x00,
    0x00, 0x00, 0x6b, 0x00, 0x00, 0x80, 0x74, 0x00, 0x00, 0x00, 0x81, 0x00,
    0x00, 0x80, 0x83, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x80, 0x99, 0x00,
    0x00, 0x80, 0x9f, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x9e, 0x00,
    0x00, 0x80, 0xa9, 0x00, 0x00, 0x00, 0xb1, 0x00, 0x00, 0x00, 0xc6, 0x00,
    0x00, 0x00, 0xe8, 0x00, 0x00, 0x00, 0x03, 0x01, 0x00, 0x00, 0x1b, 0x01,
    0x00, 0x80, 0x46, 0x01, 0x00, 0x00, 0x6c, 0x01, 0x00, 0x80, 0x7e, 0x01,
    0x00, 0x80, 0x9f, 0x01, 0x00, 0x80, 0xbc, 0x01, 0x00, 0x00, 0xb4, 0x01,
    0x00, 0x00, 0xb3, 0x01, 0x00, 0x00, 0xc5, 0x01, 0x00, 0x00, 0xc0, 0x01,
    0x00, 0x80, 0xb6, 0x01, 0x00, 0x80, 0xbf, 0x01, 0x00, 0x00, 0xc1, 0x01,
    0x00, 0x80, 0xb8, 0x01, 0x00, 0x00, 0xaa, 0x01, 0x00, 0x00, 0x9b, 0x01,
    0x00, 0x00, 0x9f, 0x01, 0x00, 0x80, 0xa9, 0x01, 0x00, 0x00, 0xb6, 0x01,
    0x00, 0x00, 0xce, 0x01, 0x00, 0x80, 0xdd, 0x01, 0x00, 0x00, 0xe1, 0x01,
    0x00, 0x80, 0xee, 0x01, 0x00, 0x80, 0xf7, 0x01, 0x00, 0x80, 0xf7, 0x01,
    0x00, 0x00, 0xfe, 0x01, 0x00, 0x80, 0x04, 0x02, 0x00, 0x80, 0x0f, 0x02,
    0x00, 0x80, 0x1b, 0x02, 0x00, 0x80, 0x0e, 0x02, 0x00, 0x00, 0xec, 0x01,
    0x00, 0x80, 0xc9, 0x01, 0x00, 0x80, 0xa4, 0x01, 0x00, 0x80, 0x89, 0x01,
    0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x73, 0x01,
    0x00, 0x00, 0x65, 0x01, 0x00, 0x00, 0x5d, 0x01, 0x00, 0x00, 0x5c, 0x01,
    0x00, 0x80, 0x68, 0x01, 0x00, 0x00, 0x7c, 0x01, 0x00, 0x80, 0x85, 0x01,
    0x00, 0x80, 0x93, 0x01, 0x00, 0x00, 0xaf, 0x01, 0x00, 0x80, 0xba, 0x01,
    0x00, 0x00, 0xb3, 0x01, 0x00, 0x00, 0xbd, 0x01, 0x00, 0x80, 0xdf, 0x01,
    0x00, 0x80, 0xfd, 0x01, 0x00, 0x80, 0x08, 0x02, 0x00, 0x00, 0x0d, 0x02,
    0x00, 0x80, 0x14, 0x02, 0x00, 0x80, 0x19, 0x02, 0x00, 0x80, 0x1b, 0x02,
    0x00, 0x00, 0x25, 0x02, 0x00, 0x80, 0x31, 0x02, 0x00, 0x00, 0x36, 0x02,
    0x00, 0x80, 0x37, 0x02, 0x00, 0x00, 0x42, 0x02, 0x00, 0x00, 0x45, 0x02,
    0x00, 0x00, 0x3f, 0x02, 0x00, 0x00, 0x49, 0x02, 0x00, 0x80, 0x5d, 0x02,
    0x00, 0x80, 0x60, 0x02, 0x00, 0x00, 0x66, 0x02, 0x00, 0x00, 0x78, 0x02,
    0x00, 0x80, 0x87, 0x02, 0x00, 0x00, 0x95, 0x02, 0x00, 0x00, 0xa2, 0x02,
    0x00, 0x00, 0xb1, 0x02, 0x00, 0x80, 0xcb, 0x02, 0x00, 0x80, 0xe8, 0x02,
    0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x1c, 0x03, 0x00, 0x80, 0x32, 0x03,
    0x00, 0x80, 0x57, 0x03, 0x00, 0x00, 0x88, 0x03, 0x00, 0x80, 0xa2, 0x03,
    0x00, 0x00, 0xb9, 0x03, 0x00, 0x80, 0xd9, 0x03, 0x00, 0x80, 0xee, 0x03,
    0x00, 0x80, 0x08, 0x04, 0x00, 0x80, 0x1d, 0x04, 0x00, 0x00, 0x21, 0x04,
    0x00, 0x00, 0x3a, 0x04, 0x00, 0x80, 0x56, 0x04, 0x00, 0x80, 0x4f, 0x04,
    0x00, 0x80, 0x54, 0x04, 0x00, 0x80, 0x5a, 0x04, 0x00, 0x80, 0x45, 0x04,
    0x00, 0x00, 0x40, 0x04, 0x00, 0x00, 0x41, 0x04, 0x00, 0x00, 0x2f, 0x04,
    0x00, 0x80, 0x24, 0x04, 0x00, 0x80, 0x20, 0x04, 0x00, 0x80, 0x16, 0x04,
    0x00, 0x80, 0x0a, 0x04, 0x00, 0x80, 0xea, 0x03, 0x00, 0x80, 0xcb, 0x03,
    0x00, 0x80, 0xc3, 0x03, 0x00, 0x00, 0xbd, 0x03, 0x00, 0x00, 0xb0, 0x03,
    0x00, 0x80, 0x9e, 0x03, 0x00, 0x00, 0x8f, 0x03, 0x00, 0x00, 0x79, 0x03,
    0x00, 0x00, 0x4c, 0x03, 0x00, 0x80, 0x1b, 0x03, 0x00, 0x00, 0xff, 0x02,
    0x00, 0x80, 0xe2, 0x02, 0x00, 0x00, 0xc0, 0x02, 0x00, 0x00, 0x8b, 0x02,
    0x00, 0x80, 0x3f, 0x02, 0x00, 0x00, 0x04, 0x02, 0x00, 0x80, 0xcb, 0x01,
    0x00, 0x00, 0x7a, 0x01, 0x00, 0x80, 0x38, 0x01, 0x00, 0x80, 0xfc, 0x00,
    0x00, 0x00, 0xb1, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x80, 0x46, 0x00,
    0x00, 0x80, 0x03, 0x00, 0x00, 0x80, 0xce, 0xff, 0x00, 0x80, 0x97, 0xff,
    0x00, 0x80, 0x55, 0xff, 0x00, 0x80, 0x28, 0xff, 0x00, 0x00, 0x07, 0xff,
    0x00, 0x80, 0xe2, 0xfe, 0x00, 0x80, 0xb7, 0xfe, 0x00, 0x80, 0x7c, 0xfe,
    0x00, 0x00, 0x40, 0xfe, 0x00, 0x00, 0x06, 0xfe, 0x00, 0x00, 0xc6, 0xfd,
    0x00, 0x00, 0x8b, 0xfd, 0x00, 0x80, 0x58, 0xfd, 0x00, 0x80, 0x22, 0xfd,
    0x00, 0x80, 0xdb, 0xfc, 0x00, 0x00, 0x89, 0xfc, 0x00, 0x80, 0x47, 0xfc,
    0x00, 0x00, 0x0b, 0xfc, 0x00, 0x00, 0xc1, 0xfb, 0x00, 0x80, 0x82, 0xfb,
    0x00, 0x00, 0x4d, 0xfb, 0x00, 0x80, 0x10, 0xfb, 0x00, 0x00, 0xdf, 0xfa,
    0x00, 0x00, 0xb1, 0xfa, 0x00, 0x80, 0x87, 0xfa, 0x00, 0x00, 0x74, 0xfa,
    0x00, 0x00, 0x4f, 0xfa, 0x00, 0x00, 0x13, 0xfa, 0x00, 0x80, 0xeb, 0xf9,
    0x00, 0x00, 0xcb, 0xf9, 0x00, 0x00, 0xa9, 0xf9, 0x00, 0x00, 0x8d, 0xf9,
    0x00, 0x80, 0x61, 0xf9, 0x00, 0x80, 0x3c, 0xf9, 0x00, 0x00, 0x30, 0xf9,
    0x00, 0x00, 0x11, 0xf9, 0x00, 0x80, 0xe8, 0xf8, 0x00, 0x80, 0xde, 0xf8,
    0x00, 0x80, 0xda, 0xf8, 0x00, 0x80, 0xce, 0xf8, 0x00, 0x80, 0xca, 0xf8,
    0x00, 0x00, 0xcf, 0xf8, 0x00, 0x00, 0xd8, 0xf8, 0x00, 0x80, 0xf3, 0xf8,
    0x00, 0x80, 0x22, 0xf9, 0x00, 0x00, 0x50, 0xf9, 0x00, 0x00, 0x73, 0xf9,
    0x00, 0x00, 0xa0, 0xf9, 0x00, 0x80, 0xda, 0xf9, 0x00, 0x80, 0x10, 0xfa,
    0x00, 0x00, 0x43, 0xfa, 0x00, 0x00, 0x78, 0xfa, 0x00, 0x00, 0xa3, 0xfa,
    0x00, 0x00, 0xbb, 0xfa, 0x00, 0x80, 0xdd, 0xfa, 0x00, 0x00, 0x16, 0xfb,
    0x00, 0x80, 0x45, 0xfb, 0x00, 0x00, 0x69, 0xfb, 0x00, 0x80, 0x8f, 0xfb,
    0x00, 0x00, 0xa5, 0xfb, 0x00, 0x00, 0xb4, 0xfb, 0x00, 0x00, 0xdb, 0xfb,
    0x00, 0x80, 0x02, 0xfc, 0x00, 0x80, 0x1e, 0xfc, 0x00, 0x00, 0x3b, 0xfc,
    0x00, 0x80, 0x51, 0xfc, 0x00, 0x00, 0x6d, 0xfc, 0x00, 0x80, 0x9c, 0xfc,
    0x00, 0x80, 0xcf, 0xfc, 0x00, 0x00, 0x0b, 0xfd, 0x00, 0x00, 0x49, 0xfd,
    0x00, 0x80, 0x7e, 0xfd, 0x00, 0x80, 0xb1, 0xfd, 0x00, 0x00, 0xde, 0xfd,
    0x00, 0x00, 0x09, 0xfe, 0x00, 0x00, 0x45, 0xfe, 0x00, 0x80, 0x7c, 0xfe,
    0x00, 0x00, 0xa8, 0xfe, 0x00, 0x00, 0xdc, 0xfe, 0x00, 0x80, 0x0b, 0xff,
    0x00, 0x00, 0x30, 0xff, 0x00, 0x00, 0x5d, 0xff, 0x00, 0x00, 0x8b, 0xff,
    0x00, 0x00, 0xb8, 0xff, 0x00, 0x80, 0xea, 0xff, 0x00, 0x00, 0x18, 0x00,
    0x00, 0x00, 0x4b, 0x00, 0x00, 0x80, 0x8b, 0x00, 0x00, 0x80, 0xc5, 0x00,
    0x00, 0x00, 0xfd, 0x00, 0x00, 0x00, 0x3f, 0x01, 0x00, 0x00, 0x80, 0x01,
    0x00, 0x80, 0xbf, 0x01, 0x00, 0x00, 0x07, 0x02, 0x00, 0x00, 0x52, 0x02,
    0x00, 0x00, 0x8d, 0x02, 0x00, 0x80, 0xb0, 0x02, 0x00, 0x00, 0xcf, 0x02,
    0x00, 0x80, 0xf4, 0x02, 0x00, 0x00, 0x19, 0x03, 0x00, 0x80, 0x37, 0x03,
    0x00, 0x00, 0x50, 0x03, 0x00, 0x80, 0x61, 0x03, 0x00, 0x00, 0x73, 0x03,
    0x00, 0x80, 0x7f, 0x03, 0x00, 0x00, 0x7f, 0x03, 0x00, 0x00, 0x84, 0x03,
    0x00, 0x80, 0x96, 0x03, 0x00, 0x80, 0xa8, 0x03, 0x00, 0x80, 0xc1, 0x03,
    0x00, 0x80, 0xe0, 0x03, 0x00, 0x00, 0xf6, 0x03, 0x00, 0x80, 0x07, 0x04,
    0x00, 0x00, 0x1d, 0x04, 0x00, 0x00, 0x34, 0x04, 0x00, 0x00, 0x4c, 0x04,
    0x00, 0x00, 0x5d, 0x04, 0x00, 0x00, 0x70, 0x04, 0x00, 0x00, 0x87, 0x04,
    0x00, 0x00, 0x8e, 0x04, 0x00, 0x00, 0x89, 0x04, 0x00, 0x00, 0x84, 0x04,
    0x00, 0x80, 0x69, 0x04, 0x00, 0x80, 0x4e, 0x04, 0x00, 0x80, 0x42, 0x04,
    0x00, 0x80, 0x20, 0x04, 0x00, 0x00, 0xef, 0x03, 0x00, 0x80, 0xc4, 0x03,
    0x00, 0x80, 0x8e, 0x03, 0x00, 0x00, 0x57, 0x03, 0x00, 0x80, 0x2d, 0x03,
    0x00, 0x80, 0x00, 0x03, 0x00, 0x80, 0xde, 0x02, 0x00, 0x00, 0xd2, 0x02,
    0x00, 0x00, 0xbc, 0x02, 0x00, 0x80, 0x9e, 0x02, 0x00, 0x00, 0x8a, 0x02,
    0x00, 0x00, 0x79, 0x02, 0x00, 0x00, 0x6e, 0x02, 0x00, 0x80, 0x65, 0x02,
    0x00, 0x00, 0x54, 0x02, 0x00, 0x00, 0x46, 0x02, 0x00, 0x00, 0x3d, 0x02,
    0x00, 0x00, 0x30, 0x02, 0x00, 0x00, 0x1b, 0x02, 0x00, 0x00, 0x05, 0x02,
    0x00, 0x80, 0xe5, 0x01, 0x00, 0x00, 0xb6, 0x01, 0x00, 0x80, 0x8b, 0x01,
    0x00, 0x80, 0x6c, 0x01, 0x00, 0x80, 0x3d, 0x01, 0x00, 0x80, 0x07, 0x01,
    0x00, 0x00, 0xdd, 0x00, 0x00, 0x00, 0xac, 0x00, 0x00, 0x00, 0x7b, 0x00,
    0x00, 0x00, 0x53, 0x00, 0x00, 0x80, 0x2a, 0x00, 0x00, 0x80, 0x03, 0x00,
    0x00, 0x80, 0xd7, 0xff, 0x00, 0x80, 0xa6, 0xff, 0x00, 0x80, 0x88, 0xff,
    0x00, 0x80, 0x70, 0xff, 0x00, 0x00, 0x53, 0xff, 0x00, 0x80, 0x49, 0xff,
    0x00, 0x80, 0x37, 0xff, 0x00, 0x80, 0x08, 0xff, 0x00, 0x80, 0xe5, 0xfe,
    0x00, 0x80, 0xcc, 0xfe, 0x00, 0x80, 0xa7, 0xfe, 0x00, 0x80, 0x82, 0xfe,
    0x00, 0x80, 0x60, 0xfe, 0x00, 0x00, 0x3c, 0xfe, 0x00, 0x80, 0x18, 0xfe,
    0x00, 0x80, 0xef, 0xfd, 0x00, 0x80, 0xcb, 0xfd, 0x00, 0x80, 0xad, 0xfd,
    0x00, 0x00, 0x8f, 0xfd, 0x00, 0x80, 0x75, 0xfd, 0x00, 0x80, 0x5e, 0xfd,
    0x00, 0x00, 0x4c, 0xfd, 0x00, 0x00, 0x40, 0xfd, 0x00, 0x00, 0x28, 0xfd,
    0x00, 0x80, 0x0b, 0xfd, 0x00, 0x80, 0xfe, 0xfc, 0x00, 0x80, 0xeb, 0xfc,
    0x00, 0x00, 0xdc, 0xfc, 0x00, 0x00, 0xe2, 0xfc, 0x00, 0x80, 0xdd, 0xfc,
    0x00, 0x00, 0xca, 0xfc, 0x00, 0x80, 0xc1, 0xfc, 0x00, 0x80, 0xb0, 0xfc,
    0x00, 0x00, 0x9a, 0xfc, 0x00, 0x80, 0x9a, 0xfc, 0x00, 0x80, 0x9e, 0xfc,
    0x00, 0x80, 0x8e, 0xfc, 0x00, 0x80, 0x7f, 0xfc, 0x00, 0x00, 0x77, 0xfc,
    0x00, 0x00, 0x61, 0xfc, 0x00, 0x00, 0x4f, 0xfc, 0x00, 0x00, 0x5c, 0xfc,
    0x00, 0x00, 0x73, 0xfc, 0x00, 0x80, 0x7f, 0xfc, 0x00, 0x00, 0x94, 0xfc,
    0x00, 0x00, 0xb5, 0xfc, 0x00, 0x00, 0xcd, 0xfc, 0x00, 0x00, 0xe9, 0xfc,
    0x00, 0x00, 0x23, 0xfd, 0x00, 0x00, 0x5f, 0xfd, 0x00, 0x00, 0x92, 0xfd,
    0x00, 0x80, 0xd1, 0xfd, 0x00, 0x80, 0x14, 0xfe, 0x00, 0x80, 0x48, 0xfe,
    0x00, 0x80, 0x84, 0xfe, 0x00, 0x00, 0xc0, 0xfe, 0x00, 0x80, 0xe4, 0xfe,
    0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x46, 0xff, 0x00, 0x80, 0x73, 0xff,
    0x00, 0x00, 0x9a, 0xff, 0x00, 0x00, 0xbc, 0xff, 0x00, 0x00, 0xd3, 0xff,
    0x00, 0x00, 0xe9, 0xff, 0x00, 0x80, 0x08, 0x00, 0x00, 0x00, 0x30, 0x00,
    0x00, 0x80, 0x56, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x80, 0x92, 0x00,
    0x00, 0x80, 0xb6, 0x00, 0x00, 0x00, 0xd2, 0x00, 0x00, 0x00, 0xf6, 0x00,
    0x00, 0x00, 0x25, 0x01, 0x00, 0x80, 0x4f, 0x01, 0x00, 0x80, 0x77, 0x01,
    0x00, 0x80, 0x98, 0x01, 0x00, 0x80, 0xb2, 0x01, 0x00, 0x80, 0xd3, 0x01,
    0x00, 0x00, 0xf2, 0x01, 0x00, 0x00, 0x0d, 0x02, 0x00, 0x00, 0x32, 0x02,
    0x00, 0x80, 0x45, 0x02, 0x00, 0x00, 0x4a, 0x02, 0x00, 0x00, 0x5d, 0x02,
    0x00, 0x80, 0x6d, 0x02, 0x00, 0x00, 0x72, 0x02, 0x00, 0x00, 0x7d, 0x02,
    0x00, 0x00, 0x89, 0x02, 0x00, 0x80, 0x94, 0x02, 0x00, 0x00, 0xa8, 0x02,
    0x00, 0x00, 0xbb, 0x02, 0x00, 0x00, 0xcf, 0x02, 0x00, 0x00, 0xe9, 0x02,
    0x00, 0x00, 0x01, 0x03, 0x00, 0x00, 0x16, 0x03, 0x00, 0x00, 0x25, 0x03,
    0x00, 0x80, 0x32, 0x03, 0x00, 0x80, 0x49, 0x03, 0x00, 0x00, 0x5d, 0x03,
    0x00, 0x00, 0x62, 0x03, 0x00, 0x80, 0x63, 0x03, 0x00, 0x00, 0x63, 0x03,
    0x00, 0x00, 0x5b, 0x03, 0x00, 0x80, 0x4e, 0x03, 0x00, 0x80, 0x3e, 0x03,
    0x00, 0x00, 0x2a, 0x03, 0x00, 0x00, 0x1a, 0x03, 0x00, 0x00, 0x0a, 0x03,
    0x00, 0x00, 0xfd, 0x02, 0x00, 0x80, 0xfd, 0x02, 0x00, 0x80, 0x02, 0x03,
    0x00, 0x00, 0xfb, 0x02, 0x00, 0x80, 0xf3, 0x02, 0x00, 0x80, 0xee, 0x02,
    0x00, 0x80, 0xe2, 0x02, 0x00, 0x80, 0xdf, 0x02, 0x00, 0x00, 0xf3, 0x02,
    0x00, 0x80, 0x06, 0x03, 0x00, 0x80, 0x0c, 0x03, 0x00, 0x00, 0x10, 0x03,
    0x00, 0x80, 0x0d, 0x03, 0x00, 0x00, 0x0b, 0x03, 0x00, 0x00, 0x12, 0x03,
    0x00, 0x00, 0x14, 0x03, 0x00, 0x80, 0x16, 0x03, 0x00, 0x00, 0x2a, 0x03,
    0x00, 0x00, 0x33, 0x03, 0x00, 0x00, 0x21, 0x03, 0x00, 0x00, 0x16, 0x03,
    0x00, 0x80, 0x10, 0x03, 0x00, 0x00, 0xfe, 0x02, 0x00, 0x00, 0xf6, 0x02,
    0x00, 0x00, 0xff, 0x02, 0x00, 0x00, 0x02, 0x03, 0x00, 0x00, 0x09, 0x03,
    0x00, 0x00, 0x11, 0x03, 0x00, 0x00, 0x0e, 0x03, 0x00, 0x80, 0x0d, 0x03,
    0x00, 0x00, 0x10, 0x03, 0x00, 0x00, 0x0e, 0x03, 0x00, 0x00, 0x13, 0x03,
    0x00, 0x80, 0x0f, 0x03, 0x00, 0x00, 0x03, 0x03, 0x00, 0x80, 0x0b, 0x03,
    0x00, 0x00, 0x13, 0x03, 0x00, 0x80, 0x07, 0x03, 0x00, 0x00, 0x06, 0x03,
    0x00, 0x00, 0x11, 0x03, 0x00, 0x00, 0x1d, 0x03, 0x00, 0x80, 0x31, 0x03,
    0x00, 0x80, 0x46, 0x03, 0x00, 0x00, 0x5a, 0x03, 0x00, 0x00, 0x6e, 0x03,
    0x00, 0x00, 0x7a, 0x03, 0x00, 0x00, 0x8e, 0x03, 0x00, 0x80, 0xac, 0x03,
    0x00, 0x00, 0xbd, 0x03, 0x00, 0x80, 0xd2, 0x03, 0x00, 0x80, 0xf2, 0x03,
    0x00, 0x80, 0x02, 0x04, 0x00, 0x00, 0x10, 0x04, 0x00, 0x80, 0x1e, 0x04,
    0x00, 0x00, 0x23, 0x04, 0x00, 0x00, 0x2e, 0x04, 0x00, 0x00, 0x39, 0x04,
    0x00, 0x80, 0x29, 0x04, 0x00, 0x00, 0x14, 0x04, 0x00, 0x00, 0x0b, 0x04,
    0x00, 0x00, 0x01, 0x04, 0x00, 0x80, 0xef, 0x03, 0x00, 0x00, 0xdb, 0x03,
    0x00, 0x00, 0xc6, 0x03, 0x00, 0x00, 0xb3, 0x03, 0x00, 0x00, 0x9e, 0x03,
    0x00, 0x80, 0x8a, 0x03, 0x00, 0x00, 0x81, 0x03, 0x00, 0x00, 0x7a, 0x03,
    0x00, 0x00, 0x75, 0x03, 0x00, 0x80, 0x71, 0x03, 0x00, 0x80, 0x63, 0x03,
    0x00, 0x00, 0x52, 0x03, 0x00, 0x80, 0x49, 0x03, 0x00, 0x00, 0x37, 0x03,
    0x00, 0x00, 0x14, 0x03, 0x00, 0x80, 0xf3, 0x02, 0x00, 0x80, 0xd3, 0x02,
    0x00, 0x00, 0xa8, 0x02, 0x00, 0x80, 0x77, 0x02, 0x00, 0x00, 0x46, 0x02,
    0x00, 0x80, 0x0d, 0x02, 0x00, 0x80, 0xd6, 0x01, 0x00, 0x80, 0xa0, 0x01,
    0x00, 0x80, 0x69, 0x01, 0x00, 0x80, 0x34, 0x01, 0x00, 0x00, 0x01, 0x01,
    0x00, 0x80, 0xc9, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x6b, 0x00,
    0x00, 0x00, 0x3a, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0xff,
    0x00, 0x80, 0xcd, 0xff, 0x00, 0x00, 0xa7, 0xff, 0x00, 0x00, 0x8b, 0xff,
    0x00, 0x80, 0x6a, 0xff, 0x00, 0x00, 0x3a, 0xff, 0x00, 0x00, 0x0e, 0xff,
    0x00, 0x00, 0xe2, 0xfe, 0x00, 0x00, 0xa8, 0xfe, 0x00, 0x80, 0x71, 0xfe,
    0x00, 0x80, 0x3e, 0xfe, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0xc9, 0xfd,
    0x00, 0x00, 0x92, 0xfd, 0x00, 0x00, 0x4b, 0xfd, 0x00, 0x80, 0x0e, 0xfd,
    0x00, 0x00, 0xdf, 0xfc, 0x00, 0x00, 0xa8, 0xfc, 0x00, 0x00, 0x7d, 0xfc,
    0x00, 0x00, 0x61, 0xfc, 0x00, 0x80, 0x3d, 0xfc, 0x00, 0x00, 0x1c, 0xfc,
    0x00, 0x80, 0xfd, 0xfb, 0x00, 0x00, 0xdb, 0xfb, 0x00, 0x80, 0xc8, 0xfb,
    0x00, 0x80, 0xb5, 0xfb, 0x00, 0x00, 0x8f, 0xfb, 0x00, 0x80, 0x75, 0xfb,
    0x00, 0x00, 0x63, 0xfb, 0x00, 0x00, 0x45, 0xfb, 0x00, 0x00, 0x2e, 0xfb,
    0x00, 0x80, 0x15, 0xfb, 0x00, 0x00, 0xee, 0xfa, 0x00, 0x00, 0xd1, 0xfa,
    0x00, 0x80, 0xae, 0xfa, 0x00, 0x80, 0x84, 0xfa, 0x00, 0x00, 0x7b, 0xfa,
    0x00, 0x00, 0x7a, 0xfa, 0x00, 0x80, 0x6d, 0xfa, 0x00, 0x80, 0x75, 0xfa,
    0x00, 0x80, 0x86, 0xfa, 0x00, 0x00, 0x90, 0xfa, 0x00, 0x00, 0xad, 0xfa,
    0x00, 0x00, 0xd7, 0xfa, 0x00, 0x80, 0xfe, 0xfa, 0x00, 0x00, 0x2c, 0xfb,
    0x00, 0x80, 0x5c, 0xfb, 0x00, 0x00, 0x95, 0xfb, 0x00, 0x00, 0xd1, 0xfb,
    0x00, 0x00, 0xf9, 0xfb, 0x00, 0x00, 0x15, 0xfc, 0x00, 0x80, 0x3b, 0xfc,
    0x00, 0x80, 0x60, 0xfc, 0x00, 0x80, 0x85, 0xfc, 0x00, 0x00, 0xa7, 0xfc,
    0x00, 0x00, 0xb4, 0xfc, 0x00, 0x80, 0xbe, 0xfc, 0x00, 0x00, 0xd2, 0xfc,
    0x00, 0x00, 0xd9, 0xfc, 0x00, 0x80, 0xe0, 0xfc, 0x00, 0x00, 0x03, 0xfd,
    0x00, 0x00, 0x2f, 0xfd, 0x00, 0x00, 0x44, 0xfd, 0x00, 0x80, 0x48, 0xfd,
    0x00, 0x00, 0x60, 0xfd, 0x00, 0x00, 0x86, 0xfd, 0x00, 0x00, 0xa1, 0xfd,
    0x00, 0x80, 0xc7, 0xfd, 0x00, 0x00, 0x03, 0xfe, 0x00, 0x00, 0x33, 0xfe,
    0x00, 0x00, 0x51, 0xfe, 0x00, 0x80, 0x6b, 0xfe, 0x00, 0x00, 0x84, 0xfe,
    0x00, 0x80, 0xa4, 0xfe, 0x00, 0x80, 0xc4, 0xfe, 0x00, 0x00, 0xd3, 0xfe,
    0x00, 0x80, 0xe6, 0xfe, 0x00, 0x00, 0x02, 0xff, 0x00, 0x00, 0x0e, 0xff,
    0x00, 0x80, 0x1d, 0xff, 0x00, 0x00, 0x41, 0xff, 0x00, 0x80, 0x64, 0xff,
    0x00, 0x00, 0x89, 0xff, 0x00, 0x80, 0xb9, 0xff, 0x00, 0x00, 0xeb, 0xff,
    0x00, 0x80, 0x14, 0x00, 0x00, 0x80, 0x42, 0x00, 0x00, 0x80, 0x76, 0x00,
    0x00, 0x80, 0xa4, 0x00, 0x00, 0x00, 0xcd, 0x00, 0x00, 0x80, 0xfa, 0x00,
    0x00, 0x80, 0x1f, 0x01, 0x00, 0x00, 0x39, 0x01, 0x00, 0x00, 0x60, 0x01,
    0x00, 0x00, 0x8a, 0x01, 0x00, 0x00, 0x9b, 0x01, 0x00, 0x00, 0xab, 0x01,
    0x00, 0x00, 0xc2, 0x01, 0x00, 0x80, 0xcb, 0x01, 0x00, 0x80, 0xd4, 0x01,
    0x00, 0x80, 0xeb, 0x01, 0x00, 0x80, 0xfd, 0x01, 0x00, 0x00, 0x00, 0x02,
    0x00, 0x00, 0x04, 0x02, 0x00, 0x00, 0x13, 0x02, 0x00, 0x80, 0x1e, 0x02,
    0x00, 0x80, 0x2f, 0x02, 0x00, 0x80, 0x50, 0x02, 0x00, 0x80, 0x68, 0x02,
    0x00, 0x00, 0x6f, 0x02, 0x00, 0x80, 0x7b, 0x02, 0x00, 0x00, 0x89, 0x02,
    0x00, 0x80, 0x8a, 0x02, 0x00, 0x00, 0x95, 0x02, 0x00, 0x80, 0x9e, 0x02,
    0x00, 0x80, 0x93, 0x02, 0x00, 0x00, 0x8e, 0x02, 0x00, 0x00, 0x95, 0x02,
    0x00, 0x00, 0x8c, 0x02, 0x00, 0x00, 0x79, 0x02, 0x00, 0x00, 0x6c, 0x02,
    0x00, 0x80, 0x54, 0x02, 0x00, 0x80, 0x35, 0x02, 0x00, 0x00, 0x1b, 0x02,
    0x00, 0x80, 0xfe, 0x01, 0x00, 0x00, 0xe5, 0x01, 0x00, 0x00, 0xce, 0x01,
    0x00, 0x00, 0xaf, 0x01, 0x00, 0x00, 0x8f, 0x01, 0x00, 0x00, 0x77, 0x01,
    0x00, 0x00, 0x5a, 0x01, 0x00, 0x80, 0x46, 0x01, 0x00, 0x80, 0x3f, 0x01,
    0x00, 0x00, 0x2e, 0x01, 0x00, 0x00, 0x22, 0x01, 0x00, 0x00, 0x25, 0x01,
    0x00, 0x00, 0x21, 0x01, 0x00, 0x00, 0x21, 0x01, 0x00, 0x00, 0x32, 0x01,
    0x00, 0x00, 0x36, 0x01, 0x00, 0x00, 0x31, 0x01, 0x00, 0x80, 0x2e, 0x01,
    0x00, 0x00, 0x17, 0x01, 0x00, 0x00, 0xfd, 0x00, 0x00, 0x00, 0xfa, 0x00,
    0x00, 0x80, 0xec, 0x00, 0x00, 0x00, 0xd5, 0x00, 0x00, 0x00, 0xca, 0x00,
    0x00, 0x00, 0xb8, 0x00, 0x00, 0x00, 0x98, 0x00, 0x00, 0x00, 0x82, 0x00,
    0x00, 0x00, 0x71, 0x00, 0x00, 0x80, 0x5d, 0x00, 0x00, 0x00, 0x4b, 0x00,
    0x00, 0x80, 0x38, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0x23, 0x00,
    0x00, 0x80, 0x1c, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0xff, 0xff,
    0x00, 0x00, 0xf3, 0xff, 0x00, 0x80, 0xed, 0xff, 0x00, 0x80, 0xe7, 0xff,
    0x00, 0x80, 0xdc, 0xff, 0x00, 0x00, 0xce, 0xff, 0x00, 0x80, 0xc0, 0xff,
    0x00, 0x00, 0xb2, 0xff, 0x00, 0x00, 0x9e, 0xff, 0x00, 0x00, 0x84, 0xff,
    0x00, 0x00, 0x70, 0xff, 0x00, 0x80, 0x57, 0xff, 0x00, 0x80, 0x38, 0xff,
    0x00, 0x80, 0x26, 0xff, 0x00, 0x00, 0x27, 0xff, 0x00, 0x00, 0x1c, 0xff,
    0x00, 0x00, 0x01, 0xff, 0x00, 0x80, 0xee, 0xfe, 0x00, 0x00, 0xec, 0xfe,
    0x00, 0x80, 0xec, 0xfe, 0x00, 0x80, 0xe8, 0xfe, 0x00, 0x00, 0xdf, 0xfe,
    0x00, 0x80, 0xd2, 0xfe, 0x00, 0x00, 0xc9, 0xfe, 0x00, 0x80, 0xc0, 0xfe,
    0x00, 0x00, 0xb8, 0xfe, 0x00, 0x80, 0xb1, 0xfe, 0x00, 0x00, 0xa4, 0xfe,
    0x00, 0x00, 0x8e, 0xfe, 0x00, 0x00, 0x78, 0xfe, 0x00, 0x00, 0x61, 0xfe,
    0x00, 0x00, 0x47, 0xfe, 0x00, 0x00, 0x32, 0xfe, 0x00, 0x00, 0x1f, 0xfe,
    0x00, 0x80, 0x0a, 0xfe, 0x00, 0x80, 0xf7, 0xfd, 0x00, 0x80, 0xe7, 0xfd,
    0x00, 0x80, 0xdf, 0xfd, 0x00, 0x80, 0xe4, 0xfd, 0x00, 0x80, 0xf1, 0xfd,
    0x00, 0x00, 0xfe, 0xfd, 0x00, 0x00, 0x0a, 0xfe, 0x00, 0x80, 0x21, 0xfe,
    0x00, 0x80, 0x48, 0xfe, 0x00, 0x00, 0x71, 0xfe, 0x00, 0x00, 0x98, 0xfe,
    0x00, 0x80, 0xc4, 0xfe, 0x00, 0x80, 0xee, 0xfe, 0x00, 0x00, 0x10, 0xff,
    0x00, 0x80, 0x32, 0xff, 0x00, 0x00, 0x55, 0xff, 0x00, 0x80, 0x70, 0xff,
};
const std::string kAudioPCMS32LETestInput(
        (const char*)kAudioPCMS32LETestInputChars,
        sizeof(kAudioPCMS32LETestInputChars));

ZL_GraphID addConversionToGraph(
        ZL_Compressor* cgraph,
        ZL_GraphID graph,
        ZL_Type inStreamType,
        int eltWidth)
{
    ZL_Type const graphInStreamType =
            ZL_Compressor_Graph_getInput0Mask(cgraph, graph);
    if (graphInStreamType == inStreamType) {
        return graph;
    }
    if (graphInStreamType == ZL_Type_serial) {
        // Implicit conversion
        return graph;
    }
    if (inStreamType == ZL_Type_numeric) {
        // Implicit conversion
        return graph;
    }

    if (inStreamType == ZL_Type_serial) {
        if (graphInStreamType == ZL_Type_struct) {
            ZL_REQUIRE_NE(eltWidth, 0);
            ZL_IntParam intParams = { ZL_trlip_tokenSize, (int)eltWidth };
            ZL_LocalParams params = { .intParams = { &intParams, 1 } };
            auto const node       = ZL_Compressor_cloneNode(
                    cgraph, ZL_NODE_CONVERT_SERIAL_TO_TOKENX, &params);
            return ZL_Compressor_registerStaticGraph_fromNode1o(
                    cgraph, node, graph);
        }
        ZL_REQUIRE(graphInStreamType == ZL_Type_numeric);
        auto const node = [eltWidth] {
            switch (eltWidth) {
                case 1:
                    return ZL_NODE_INTERPRET_AS_LE8;
                case 2:
                    return ZL_NODE_INTERPRET_AS_LE16;
                case 4:
                    return ZL_NODE_INTERPRET_AS_LE32;
                case 8:
                    return ZL_NODE_INTERPRET_AS_LE64;
                default:
                    throw std::runtime_error{ "Bad elt width" };
            }
        }();
        return ZL_Compressor_registerStaticGraph_fromNode1o(
                cgraph, node, graph);
    }

    ZL_REQUIRE(inStreamType == ZL_Type_struct);
    ZL_REQUIRE(graphInStreamType == ZL_Type_numeric);

    return ZL_Compressor_registerStaticGraph_fromNode1o(
            cgraph, ZL_NODE_INTERPRET_TOKEN_AS_LE, graph);
}

ZL_GraphID buildTrivialGraph(ZL_Compressor* cgraph, ZL_NodeID node)
{
    size_t const nbOutcomes = ZL_Compressor_Node_getNumOutcomes(cgraph, node);
    std::vector<ZL_GraphID> dsts(nbOutcomes, ZL_GRAPH_STORE);
    return ZL_Compressor_registerStaticGraph_fromNode(
            cgraph, node, dsts.data(), dsts.size());
}

} // namespace tests
} // namespace zstrong
