// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/certificatemanager/logging/v1/logs.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Expiration state of the certificate.
type CertificatesExpiry_State int32

const (
	// Unspecified state, should never be reported.
	CertificatesExpiry_STATE_UNSPECIFIED CertificatesExpiry_State = 0
	// Certificate will expire soon.
	CertificatesExpiry_CLOSE_TO_EXPIRY CertificatesExpiry_State = 1
	// Certificate is expired.
	CertificatesExpiry_EXPIRED CertificatesExpiry_State = 2
)

// Enum value maps for CertificatesExpiry_State.
var (
	CertificatesExpiry_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CLOSE_TO_EXPIRY",
		2: "EXPIRED",
	}
	CertificatesExpiry_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CLOSE_TO_EXPIRY":   1,
		"EXPIRED":           2,
	}
)

func (x CertificatesExpiry_State) Enum() *CertificatesExpiry_State {
	p := new(CertificatesExpiry_State)
	*p = x
	return p
}

func (x CertificatesExpiry_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificatesExpiry_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_logging_v1_logs_proto_enumTypes[0].Descriptor()
}

func (CertificatesExpiry_State) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_logging_v1_logs_proto_enumTypes[0]
}

func (x CertificatesExpiry_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificatesExpiry_State.Descriptor instead.
func (CertificatesExpiry_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescGZIP(), []int{0, 0}
}

// Log message which notifies about expired or close to
// expiry certificates.
type CertificatesExpiry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of reported certificates.
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// Names of reported certificates. If there are too many, the list is sampled.
	Certificates []string `protobuf:"bytes,2,rep,name=certificates,proto3" json:"certificates,omitempty"`
	// State of reported certificates.
	State CertificatesExpiry_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.certificatemanager.logging.v1.CertificatesExpiry_State" json:"state,omitempty"`
	// Approximated expire time of reported certificates.
	// Multiple certificates with close expire time are batched together in a
	// single log, so the timestamp is not precise.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *CertificatesExpiry) Reset() {
	*x = CertificatesExpiry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_logging_v1_logs_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificatesExpiry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificatesExpiry) ProtoMessage() {}

func (x *CertificatesExpiry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_logging_v1_logs_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificatesExpiry.ProtoReflect.Descriptor instead.
func (*CertificatesExpiry) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescGZIP(), []int{0}
}

func (x *CertificatesExpiry) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *CertificatesExpiry) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

func (x *CertificatesExpiry) GetState() CertificatesExpiry_State {
	if x != nil {
		return x.State
	}
	return CertificatesExpiry_STATE_UNSPECIFIED
}

func (x *CertificatesExpiry) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

var File_google_cloud_certificatemanager_logging_v1_logs_proto protoreflect.FileDescriptor

var file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa9, 0x02, 0x0a, 0x12, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x45, 0x78, 0x70, 0x69, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x22, 0x0a, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x40,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13,
	0x0a, 0x0f, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x45, 0x58, 0x50, 0x49, 0x52,
	0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02,
	0x42, 0x9b, 0x02, 0x0a, 0x2e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2e, 0x76, 0x31, 0x42, 0x09, 0x4c, 0x6f, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x51, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0xaa, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescOnce sync.Once
	file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescData = file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDesc
)

func file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescGZIP() []byte {
	file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescOnce.Do(func() {
		file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescData)
	})
	return file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDescData
}

var file_google_cloud_certificatemanager_logging_v1_logs_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_certificatemanager_logging_v1_logs_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_certificatemanager_logging_v1_logs_proto_goTypes = []interface{}{
	(CertificatesExpiry_State)(0), // 0: google.cloud.certificatemanager.logging.v1.CertificatesExpiry.State
	(*CertificatesExpiry)(nil),    // 1: google.cloud.certificatemanager.logging.v1.CertificatesExpiry
	(*timestamppb.Timestamp)(nil), // 2: google.protobuf.Timestamp
}
var file_google_cloud_certificatemanager_logging_v1_logs_proto_depIdxs = []int32{
	0, // 0: google.cloud.certificatemanager.logging.v1.CertificatesExpiry.state:type_name -> google.cloud.certificatemanager.logging.v1.CertificatesExpiry.State
	2, // 1: google.cloud.certificatemanager.logging.v1.CertificatesExpiry.expire_time:type_name -> google.protobuf.Timestamp
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_certificatemanager_logging_v1_logs_proto_init() }
func file_google_cloud_certificatemanager_logging_v1_logs_proto_init() {
	if File_google_cloud_certificatemanager_logging_v1_logs_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_certificatemanager_logging_v1_logs_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CertificatesExpiry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_certificatemanager_logging_v1_logs_proto_goTypes,
		DependencyIndexes: file_google_cloud_certificatemanager_logging_v1_logs_proto_depIdxs,
		EnumInfos:         file_google_cloud_certificatemanager_logging_v1_logs_proto_enumTypes,
		MessageInfos:      file_google_cloud_certificatemanager_logging_v1_logs_proto_msgTypes,
	}.Build()
	File_google_cloud_certificatemanager_logging_v1_logs_proto = out.File
	file_google_cloud_certificatemanager_logging_v1_logs_proto_rawDesc = nil
	file_google_cloud_certificatemanager_logging_v1_logs_proto_goTypes = nil
	file_google_cloud_certificatemanager_logging_v1_logs_proto_depIdxs = nil
}
