// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/notebooks/v2/instance.proto

package notebookspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The definition of the states of this instance.
type State int32

const (
	// State is not specified.
	State_STATE_UNSPECIFIED State = 0
	// The control logic is starting the instance.
	State_STARTING State = 1
	// The control logic is installing required frameworks and registering the
	// instance with notebook proxy
	State_PROVISIONING State = 2
	// The instance is running.
	State_ACTIVE State = 3
	// The control logic is stopping the instance.
	State_STOPPING State = 4
	// The instance is stopped.
	State_STOPPED State = 5
	// The instance is deleted.
	State_DELETED State = 6
	// The instance is upgrading.
	State_UPGRADING State = 7
	// The instance is being created.
	State_INITIALIZING State = 8
	// The instance is suspending.
	State_SUSPENDING State = 9
	// The instance is suspended.
	State_SUSPENDED State = 10
)

// Enum value maps for State.
var (
	State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "STARTING",
		2:  "PROVISIONING",
		3:  "ACTIVE",
		4:  "STOPPING",
		5:  "STOPPED",
		6:  "DELETED",
		7:  "UPGRADING",
		8:  "INITIALIZING",
		9:  "SUSPENDING",
		10: "SUSPENDED",
	}
	State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTING":          1,
		"PROVISIONING":      2,
		"ACTIVE":            3,
		"STOPPING":          4,
		"STOPPED":           5,
		"DELETED":           6,
		"UPGRADING":         7,
		"INITIALIZING":      8,
		"SUSPENDING":        9,
		"SUSPENDED":         10,
	}
)

func (x State) Enum() *State {
	p := new(State)
	*p = x
	return p
}

func (x State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_instance_proto_enumTypes[0].Descriptor()
}

func (State) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_instance_proto_enumTypes[0]
}

func (x State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use State.Descriptor instead.
func (State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP(), []int{0}
}

// The instance health state.
type HealthState int32

const (
	// The instance substate is unknown.
	HealthState_HEALTH_STATE_UNSPECIFIED HealthState = 0
	// The instance is known to be in an healthy state
	// (for example, critical daemons are running)
	// Applies to ACTIVE state.
	HealthState_HEALTHY HealthState = 1
	// The instance is known to be in an unhealthy state
	// (for example, critical daemons are not running)
	// Applies to ACTIVE state.
	HealthState_UNHEALTHY HealthState = 2
	// The instance has not installed health monitoring agent.
	// Applies to ACTIVE state.
	HealthState_AGENT_NOT_INSTALLED HealthState = 3
	// The instance health monitoring agent is not running.
	// Applies to ACTIVE state.
	HealthState_AGENT_NOT_RUNNING HealthState = 4
)

// Enum value maps for HealthState.
var (
	HealthState_name = map[int32]string{
		0: "HEALTH_STATE_UNSPECIFIED",
		1: "HEALTHY",
		2: "UNHEALTHY",
		3: "AGENT_NOT_INSTALLED",
		4: "AGENT_NOT_RUNNING",
	}
	HealthState_value = map[string]int32{
		"HEALTH_STATE_UNSPECIFIED": 0,
		"HEALTHY":                  1,
		"UNHEALTHY":                2,
		"AGENT_NOT_INSTALLED":      3,
		"AGENT_NOT_RUNNING":        4,
	}
)

func (x HealthState) Enum() *HealthState {
	p := new(HealthState)
	*p = x
	return p
}

func (x HealthState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HealthState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_instance_proto_enumTypes[1].Descriptor()
}

func (HealthState) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_instance_proto_enumTypes[1]
}

func (x HealthState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HealthState.Descriptor instead.
func (HealthState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP(), []int{1}
}

// The definition of the states of this upgrade history entry.
type UpgradeHistoryEntry_State int32

const (
	// State is not specified.
	UpgradeHistoryEntry_STATE_UNSPECIFIED UpgradeHistoryEntry_State = 0
	// The instance upgrade is started.
	UpgradeHistoryEntry_STARTED UpgradeHistoryEntry_State = 1
	// The instance upgrade is succeeded.
	UpgradeHistoryEntry_SUCCEEDED UpgradeHistoryEntry_State = 2
	// The instance upgrade is failed.
	UpgradeHistoryEntry_FAILED UpgradeHistoryEntry_State = 3
)

// Enum value maps for UpgradeHistoryEntry_State.
var (
	UpgradeHistoryEntry_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	UpgradeHistoryEntry_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x UpgradeHistoryEntry_State) Enum() *UpgradeHistoryEntry_State {
	p := new(UpgradeHistoryEntry_State)
	*p = x
	return p
}

func (x UpgradeHistoryEntry_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeHistoryEntry_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_instance_proto_enumTypes[2].Descriptor()
}

func (UpgradeHistoryEntry_State) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_instance_proto_enumTypes[2]
}

func (x UpgradeHistoryEntry_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeHistoryEntry_State.Descriptor instead.
func (UpgradeHistoryEntry_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP(), []int{0, 0}
}

// The definition of operations of this upgrade history entry.
type UpgradeHistoryEntry_Action int32

const (
	// Operation is not specified.
	UpgradeHistoryEntry_ACTION_UNSPECIFIED UpgradeHistoryEntry_Action = 0
	// Upgrade.
	UpgradeHistoryEntry_UPGRADE UpgradeHistoryEntry_Action = 1
	// Rollback.
	UpgradeHistoryEntry_ROLLBACK UpgradeHistoryEntry_Action = 2
)

// Enum value maps for UpgradeHistoryEntry_Action.
var (
	UpgradeHistoryEntry_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "UPGRADE",
		2: "ROLLBACK",
	}
	UpgradeHistoryEntry_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"UPGRADE":            1,
		"ROLLBACK":           2,
	}
)

func (x UpgradeHistoryEntry_Action) Enum() *UpgradeHistoryEntry_Action {
	p := new(UpgradeHistoryEntry_Action)
	*p = x
	return p
}

func (x UpgradeHistoryEntry_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeHistoryEntry_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_notebooks_v2_instance_proto_enumTypes[3].Descriptor()
}

func (UpgradeHistoryEntry_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_notebooks_v2_instance_proto_enumTypes[3]
}

func (x UpgradeHistoryEntry_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeHistoryEntry_Action.Descriptor instead.
func (UpgradeHistoryEntry_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP(), []int{0, 1}
}

// The entry of VM image upgrade history.
type UpgradeHistoryEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The snapshot of the boot disk of this notebook instance before
	// upgrade.
	Snapshot string `protobuf:"bytes,1,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
	// Optional. The VM image before this instance upgrade.
	VmImage string `protobuf:"bytes,2,opt,name=vm_image,json=vmImage,proto3" json:"vm_image,omitempty"`
	// Optional. The container image before this instance upgrade.
	ContainerImage string `protobuf:"bytes,3,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
	// Optional. The framework of this notebook instance.
	Framework string `protobuf:"bytes,4,opt,name=framework,proto3" json:"framework,omitempty"`
	// Optional. The version of the notebook instance before this upgrade.
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The state of this instance upgrade history entry.
	State UpgradeHistoryEntry_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.notebooks.v2.UpgradeHistoryEntry_State" json:"state,omitempty"`
	// Immutable. The time that this instance upgrade history entry is created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. Action. Rolloback or Upgrade.
	Action UpgradeHistoryEntry_Action `protobuf:"varint,8,opt,name=action,proto3,enum=google.cloud.notebooks.v2.UpgradeHistoryEntry_Action" json:"action,omitempty"`
	// Optional. Target VM Version, like m63.
	TargetVersion string `protobuf:"bytes,9,opt,name=target_version,json=targetVersion,proto3" json:"target_version,omitempty"`
}

func (x *UpgradeHistoryEntry) Reset() {
	*x = UpgradeHistoryEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v2_instance_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpgradeHistoryEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeHistoryEntry) ProtoMessage() {}

func (x *UpgradeHistoryEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_instance_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeHistoryEntry.ProtoReflect.Descriptor instead.
func (*UpgradeHistoryEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP(), []int{0}
}

func (x *UpgradeHistoryEntry) GetSnapshot() string {
	if x != nil {
		return x.Snapshot
	}
	return ""
}

func (x *UpgradeHistoryEntry) GetVmImage() string {
	if x != nil {
		return x.VmImage
	}
	return ""
}

func (x *UpgradeHistoryEntry) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

func (x *UpgradeHistoryEntry) GetFramework() string {
	if x != nil {
		return x.Framework
	}
	return ""
}

func (x *UpgradeHistoryEntry) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *UpgradeHistoryEntry) GetState() UpgradeHistoryEntry_State {
	if x != nil {
		return x.State
	}
	return UpgradeHistoryEntry_STATE_UNSPECIFIED
}

func (x *UpgradeHistoryEntry) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UpgradeHistoryEntry) GetAction() UpgradeHistoryEntry_Action {
	if x != nil {
		return x.Action
	}
	return UpgradeHistoryEntry_ACTION_UNSPECIFIED
}

func (x *UpgradeHistoryEntry) GetTargetVersion() string {
	if x != nil {
		return x.TargetVersion
	}
	return ""
}

// The definition of a notebook instance.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of this notebook instance. Format:
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Setup for the Notebook instance.
	//
	// Types that are assignable to Infrastructure:
	//
	//	*Instance_GceSetup
	Infrastructure isInstance_Infrastructure `protobuf_oneof:"infrastructure"`
	// Output only. The proxy endpoint that is used to access the Jupyter
	// notebook.
	ProxyUri string `protobuf:"bytes,3,opt,name=proxy_uri,json=proxyUri,proto3" json:"proxy_uri,omitempty"`
	// Optional. Input only. The owner of this instance after creation. Format:
	// `alias@example.com`
	//
	// Currently supports one owner only. If not specified, all of the service
	// account users of your VM instance's service account can use
	// the instance.
	InstanceOwners []string `protobuf:"bytes,4,rep,name=instance_owners,json=instanceOwners,proto3" json:"instance_owners,omitempty"`
	// Output only. Email address of entity that sent original CreateInstance
	// request.
	Creator string `protobuf:"bytes,5,opt,name=creator,proto3" json:"creator,omitempty"`
	// Output only. The state of this instance.
	State State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.notebooks.v2.State" json:"state,omitempty"`
	// Output only. The upgrade history of this instance.
	UpgradeHistory []*UpgradeHistoryEntry `protobuf:"bytes,7,rep,name=upgrade_history,json=upgradeHistory,proto3" json:"upgrade_history,omitempty"`
	// Output only. Unique ID of the resource.
	Id string `protobuf:"bytes,8,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. Instance health_state.
	HealthState HealthState `protobuf:"varint,9,opt,name=health_state,json=healthState,proto3,enum=google.cloud.notebooks.v2.HealthState" json:"health_state,omitempty"`
	// Output only. Additional information about instance health.
	// Example:
	//
	//	healthInfo": {
	//	  "docker_proxy_agent_status": "1",
	//	  "docker_status": "1",
	//	  "jupyterlab_api_status": "-1",
	//	  "jupyterlab_status": "-1",
	//	  "updated": "2020-10-18 09:40:03.573409"
	//	}
	HealthInfo map[string]string `protobuf:"bytes,10,rep,name=health_info,json=healthInfo,proto3" json:"health_info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Instance creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Instance update time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. If true, the notebook instance will not register with the proxy.
	DisableProxyAccess bool `protobuf:"varint,13,opt,name=disable_proxy_access,json=disableProxyAccess,proto3" json:"disable_proxy_access,omitempty"`
	// Optional. Labels to apply to this instance.
	// These can be later modified by the UpdateInstance method.
	Labels map[string]string `protobuf:"bytes,14,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_notebooks_v2_instance_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_notebooks_v2_instance_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP(), []int{1}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (m *Instance) GetInfrastructure() isInstance_Infrastructure {
	if m != nil {
		return m.Infrastructure
	}
	return nil
}

func (x *Instance) GetGceSetup() *GceSetup {
	if x, ok := x.GetInfrastructure().(*Instance_GceSetup); ok {
		return x.GceSetup
	}
	return nil
}

func (x *Instance) GetProxyUri() string {
	if x != nil {
		return x.ProxyUri
	}
	return ""
}

func (x *Instance) GetInstanceOwners() []string {
	if x != nil {
		return x.InstanceOwners
	}
	return nil
}

func (x *Instance) GetCreator() string {
	if x != nil {
		return x.Creator
	}
	return ""
}

func (x *Instance) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Instance) GetUpgradeHistory() []*UpgradeHistoryEntry {
	if x != nil {
		return x.UpgradeHistory
	}
	return nil
}

func (x *Instance) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Instance) GetHealthState() HealthState {
	if x != nil {
		return x.HealthState
	}
	return HealthState_HEALTH_STATE_UNSPECIFIED
}

func (x *Instance) GetHealthInfo() map[string]string {
	if x != nil {
		return x.HealthInfo
	}
	return nil
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Instance) GetDisableProxyAccess() bool {
	if x != nil {
		return x.DisableProxyAccess
	}
	return false
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

type isInstance_Infrastructure interface {
	isInstance_Infrastructure()
}

type Instance_GceSetup struct {
	// Optional. Compute Engine setup for the notebook. Uses notebook-defined
	// fields.
	GceSetup *GceSetup `protobuf:"bytes,2,opt,name=gce_setup,json=gceSetup,proto3,oneof"`
}

func (*Instance_GceSetup) isInstance_Infrastructure() {}

var File_google_cloud_notebooks_v2_instance_proto protoreflect.FileDescriptor

var file_google_cloud_notebooks_v2_instance_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x76, 0x32, 0x2f, 0x67, 0x63, 0x65,
	0x5f, 0x73, 0x65, 0x74, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xde, 0x04,
	0x0a, 0x13, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x6d, 0x5f, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76,
	0x6d, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x66, 0x72,
	0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x48, 0x69, 0x73,
	0x74, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a,
	0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x22, 0x3b, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x02, 0x22, 0xc9,
	0x08, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x09, 0x67, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x75,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73,
	0x2e, 0x76, 0x32, 0x2e, 0x47, 0x63, 0x65, 0x53, 0x65, 0x74, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x08, 0x67, 0x63, 0x65, 0x53, 0x65, 0x74, 0x75, 0x70, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x55, 0x72, 0x69, 0x12,
	0x2f, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6f, 0x77, 0x6e, 0x65,
	0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4f, 0x77, 0x6e, 0x65, 0x72, 0x73,
	0x12, 0x1d, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12,
	0x3b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x20,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x5c, 0x0a, 0x0f,
	0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x75, 0x70, 0x67, 0x72,
	0x61, 0x64, 0x65, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x13, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x4e, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x59, 0x0a, 0x0b, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68,
	0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x78, 0x79, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x1a, 0x3d, 0x0a, 0x0f, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x49, 0x6e, 0x66,
	0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x79, 0xea,
	0x41, 0x76, 0x0a, 0x21, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x69, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x2a, 0xb2, 0x01, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x52, 0x4f,
	0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45, 0x44,
	0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12,
	0x0d, 0x0a, 0x09, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x07, 0x12, 0x10,
	0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x08,
	0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x09,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x0a, 0x2a,
	0x77, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x48,
	0x45, 0x41, 0x4c, 0x54, 0x48, 0x59, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x47, 0x45, 0x4e,
	0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x42, 0xc4, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2e, 0x76, 0x32, 0x42, 0x0d, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32,
	0x2f, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x70, 0x62, 0x3b, 0x6e, 0x6f, 0x74,
	0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b,
	0x73, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x5c, 0x56, 0x32,
	0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x73, 0x3a, 0x3a, 0x56, 0x32, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_notebooks_v2_instance_proto_rawDescOnce sync.Once
	file_google_cloud_notebooks_v2_instance_proto_rawDescData = file_google_cloud_notebooks_v2_instance_proto_rawDesc
)

func file_google_cloud_notebooks_v2_instance_proto_rawDescGZIP() []byte {
	file_google_cloud_notebooks_v2_instance_proto_rawDescOnce.Do(func() {
		file_google_cloud_notebooks_v2_instance_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_notebooks_v2_instance_proto_rawDescData)
	})
	return file_google_cloud_notebooks_v2_instance_proto_rawDescData
}

var file_google_cloud_notebooks_v2_instance_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_notebooks_v2_instance_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_cloud_notebooks_v2_instance_proto_goTypes = []interface{}{
	(State)(0),                      // 0: google.cloud.notebooks.v2.State
	(HealthState)(0),                // 1: google.cloud.notebooks.v2.HealthState
	(UpgradeHistoryEntry_State)(0),  // 2: google.cloud.notebooks.v2.UpgradeHistoryEntry.State
	(UpgradeHistoryEntry_Action)(0), // 3: google.cloud.notebooks.v2.UpgradeHistoryEntry.Action
	(*UpgradeHistoryEntry)(nil),     // 4: google.cloud.notebooks.v2.UpgradeHistoryEntry
	(*Instance)(nil),                // 5: google.cloud.notebooks.v2.Instance
	nil,                             // 6: google.cloud.notebooks.v2.Instance.HealthInfoEntry
	nil,                             // 7: google.cloud.notebooks.v2.Instance.LabelsEntry
	(*timestamppb.Timestamp)(nil),   // 8: google.protobuf.Timestamp
	(*GceSetup)(nil),                // 9: google.cloud.notebooks.v2.GceSetup
}
var file_google_cloud_notebooks_v2_instance_proto_depIdxs = []int32{
	2,  // 0: google.cloud.notebooks.v2.UpgradeHistoryEntry.state:type_name -> google.cloud.notebooks.v2.UpgradeHistoryEntry.State
	8,  // 1: google.cloud.notebooks.v2.UpgradeHistoryEntry.create_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.notebooks.v2.UpgradeHistoryEntry.action:type_name -> google.cloud.notebooks.v2.UpgradeHistoryEntry.Action
	9,  // 3: google.cloud.notebooks.v2.Instance.gce_setup:type_name -> google.cloud.notebooks.v2.GceSetup
	0,  // 4: google.cloud.notebooks.v2.Instance.state:type_name -> google.cloud.notebooks.v2.State
	4,  // 5: google.cloud.notebooks.v2.Instance.upgrade_history:type_name -> google.cloud.notebooks.v2.UpgradeHistoryEntry
	1,  // 6: google.cloud.notebooks.v2.Instance.health_state:type_name -> google.cloud.notebooks.v2.HealthState
	6,  // 7: google.cloud.notebooks.v2.Instance.health_info:type_name -> google.cloud.notebooks.v2.Instance.HealthInfoEntry
	8,  // 8: google.cloud.notebooks.v2.Instance.create_time:type_name -> google.protobuf.Timestamp
	8,  // 9: google.cloud.notebooks.v2.Instance.update_time:type_name -> google.protobuf.Timestamp
	7,  // 10: google.cloud.notebooks.v2.Instance.labels:type_name -> google.cloud.notebooks.v2.Instance.LabelsEntry
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_notebooks_v2_instance_proto_init() }
func file_google_cloud_notebooks_v2_instance_proto_init() {
	if File_google_cloud_notebooks_v2_instance_proto != nil {
		return
	}
	file_google_cloud_notebooks_v2_gce_setup_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_notebooks_v2_instance_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpgradeHistoryEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_notebooks_v2_instance_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_notebooks_v2_instance_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Instance_GceSetup)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_notebooks_v2_instance_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_notebooks_v2_instance_proto_goTypes,
		DependencyIndexes: file_google_cloud_notebooks_v2_instance_proto_depIdxs,
		EnumInfos:         file_google_cloud_notebooks_v2_instance_proto_enumTypes,
		MessageInfos:      file_google_cloud_notebooks_v2_instance_proto_msgTypes,
	}.Build()
	File_google_cloud_notebooks_v2_instance_proto = out.File
	file_google_cloud_notebooks_v2_instance_proto_rawDesc = nil
	file_google_cloud_notebooks_v2_instance_proto_goTypes = nil
	file_google_cloud_notebooks_v2_instance_proto_depIdxs = nil
}
