// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/chat/v1/message.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/apps/card/v1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of Chat app response.
type ActionResponse_ResponseType int32

const (
	// Default type that's handled as `NEW_MESSAGE`.
	ActionResponse_TYPE_UNSPECIFIED ActionResponse_ResponseType = 0
	// Post as a new message in the topic.
	ActionResponse_NEW_MESSAGE ActionResponse_ResponseType = 1
	// Update the Chat app's message. This is only permitted on a `CARD_CLICKED`
	// event where the message sender type is `BOT`.
	ActionResponse_UPDATE_MESSAGE ActionResponse_ResponseType = 2
	// Update the cards on a user's message. This is only permitted as a
	// response to a `MESSAGE` event with a matched url, or a `CARD_CLICKED`
	// event where the message sender type is `HUMAN`. Text is ignored.
	ActionResponse_UPDATE_USER_MESSAGE_CARDS ActionResponse_ResponseType = 6
	// Privately ask the user for additional authentication or configuration.
	ActionResponse_REQUEST_CONFIG ActionResponse_ResponseType = 3
	// Presents a
	// [dialog](https://developers.google.com/workspace/chat/dialogs).
	ActionResponse_DIALOG ActionResponse_ResponseType = 4
	// Widget text autocomplete options query.
	ActionResponse_UPDATE_WIDGET ActionResponse_ResponseType = 7
)

// Enum value maps for ActionResponse_ResponseType.
var (
	ActionResponse_ResponseType_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NEW_MESSAGE",
		2: "UPDATE_MESSAGE",
		6: "UPDATE_USER_MESSAGE_CARDS",
		3: "REQUEST_CONFIG",
		4: "DIALOG",
		7: "UPDATE_WIDGET",
	}
	ActionResponse_ResponseType_value = map[string]int32{
		"TYPE_UNSPECIFIED":          0,
		"NEW_MESSAGE":               1,
		"UPDATE_MESSAGE":            2,
		"UPDATE_USER_MESSAGE_CARDS": 6,
		"REQUEST_CONFIG":            3,
		"DIALOG":                    4,
		"UPDATE_WIDGET":             7,
	}
)

func (x ActionResponse_ResponseType) Enum() *ActionResponse_ResponseType {
	p := new(ActionResponse_ResponseType)
	*p = x
	return p
}

func (x ActionResponse_ResponseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActionResponse_ResponseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_message_proto_enumTypes[0].Descriptor()
}

func (ActionResponse_ResponseType) Type() protoreflect.EnumType {
	return &file_google_chat_v1_message_proto_enumTypes[0]
}

func (x ActionResponse_ResponseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActionResponse_ResponseType.Descriptor instead.
func (ActionResponse_ResponseType) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{4, 0}
}

// Specifies how to reply to a message.
// More states might be added in the future.
type CreateMessageRequest_MessageReplyOption int32

const (
	// Default. Starts a new thread. Using this option ignores any [thread
	// ID][google.chat.v1.Thread.name] or
	// [`thread_key`][google.chat.v1.Thread.thread_key] that's included.
	CreateMessageRequest_MESSAGE_REPLY_OPTION_UNSPECIFIED CreateMessageRequest_MessageReplyOption = 0
	// Creates the message as a reply to the thread specified by [thread
	// ID][google.chat.v1.Thread.name] or
	// [`thread_key`][google.chat.v1.Thread.thread_key]. If it fails, the
	// message starts a new thread instead.
	CreateMessageRequest_REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD CreateMessageRequest_MessageReplyOption = 1
	// Creates the message as a reply to the thread specified by [thread
	// ID][google.chat.v1.Thread.name] or
	// [`thread_key`][google.chat.v1.Thread.thread_key]. If a new `thread_key`
	// is used, a new thread is created. If the message creation fails, a
	// `NOT_FOUND` error is returned instead.
	CreateMessageRequest_REPLY_MESSAGE_OR_FAIL CreateMessageRequest_MessageReplyOption = 2
)

// Enum value maps for CreateMessageRequest_MessageReplyOption.
var (
	CreateMessageRequest_MessageReplyOption_name = map[int32]string{
		0: "MESSAGE_REPLY_OPTION_UNSPECIFIED",
		1: "REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD",
		2: "REPLY_MESSAGE_OR_FAIL",
	}
	CreateMessageRequest_MessageReplyOption_value = map[string]int32{
		"MESSAGE_REPLY_OPTION_UNSPECIFIED":     0,
		"REPLY_MESSAGE_FALLBACK_TO_NEW_THREAD": 1,
		"REPLY_MESSAGE_OR_FAIL":                2,
	}
)

func (x CreateMessageRequest_MessageReplyOption) Enum() *CreateMessageRequest_MessageReplyOption {
	p := new(CreateMessageRequest_MessageReplyOption)
	*p = x
	return p
}

func (x CreateMessageRequest_MessageReplyOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateMessageRequest_MessageReplyOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_message_proto_enumTypes[1].Descriptor()
}

func (CreateMessageRequest_MessageReplyOption) Type() protoreflect.EnumType {
	return &file_google_chat_v1_message_proto_enumTypes[1]
}

func (x CreateMessageRequest_MessageReplyOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateMessageRequest_MessageReplyOption.Descriptor instead.
func (CreateMessageRequest_MessageReplyOption) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{9, 0}
}

// A message in a Google Chat space.
type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the message.
	//
	// Format: `spaces/{space}/messages/{message}`
	//
	// Where `{space}` is the ID of the space where the message is posted and
	// `{message}` is a system-assigned ID for the message. For example,
	// `spaces/AAAAAAAAAAA/messages/BBBBBBBBBBB.BBBBBBBBBBB`.
	//
	// If you set a custom ID when you create a message, you can use this ID to
	// specify the message in a request by replacing `{message}` with the value
	// from the `clientAssignedMessageId` field. For example,
	// `spaces/AAAAAAAAAAA/messages/client-custom-name`. For details, see [Name
	// a
	// message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The user who created the message.
	// If your Chat app [authenticates as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// the output populates the
	// [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
	// `name` and `type`.
	Sender *User `protobuf:"bytes,2,opt,name=sender,proto3" json:"sender,omitempty"`
	// Optional. Immutable. For spaces created in Chat, the time at which the
	// message was created. This field is output only, except when used in import
	// mode spaces.
	//
	// For import mode spaces, set this field to the historical timestamp at which
	// the message was created in the source in order to preserve the original
	// creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the message was last edited by a user. If
	// the message has never been edited, this field is empty.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,23,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Output only. The time at which the message was deleted in
	// Google Chat. If the message is never deleted, this field is empty.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,26,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Plain-text body of the message. The first link to an image, video, or web
	// page generates a
	// [preview chip](https://developers.google.com/workspace/chat/preview-links).
	// You can also [@mention a Google Chat
	// user](https://developers.google.com/workspace/chat/format-messages#messages-@mention),
	// or everyone in the space.
	//
	// To learn about creating text messages, see [Send a text
	// message](https://developers.google.com/workspace/chat/create-messages#create-text-messages).
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	// Output only. Contains the message `text` with markups added to communicate
	// formatting. This field might not capture all formatting visible in the UI,
	// but includes the following:
	//
	// * [Markup
	// syntax](https://developers.google.com/workspace/chat/format-messages)
	// for bold, italic, strikethrough, monospace, monospace block, and bulleted
	// list.
	//
	// * [User
	// mentions](https://developers.google.com/workspace/chat/format-messages#messages-@mention)
	// using the format `<users/{user}>`.
	//
	// * Custom hyperlinks using the format `<{url}|{rendered_text}>` where the
	// first string is the URL and the second is the rendered text—for example,
	// `<http://example.com|custom text>`.
	//
	// * Custom emoji using the format `:{emoji_name}:`—for example, `:smile:`.
	// This doesn't apply to Unicode emoji, such as `U+1F600` for a grinning
	// face emoji.
	//
	// For more information, see [View text formatting sent in a
	// message](https://developers.google.com/workspace/chat/format-messages#view_text_formatting_sent_in_a_message)
	FormattedText string `protobuf:"bytes,43,opt,name=formatted_text,json=formattedText,proto3" json:"formatted_text,omitempty"`
	// Deprecated: Use `cards_v2` instead.
	//
	// Rich, formatted, and interactive cards that you can use to display UI
	// elements such as: formatted texts, buttons, and clickable images. Cards are
	// normally displayed below the plain-text body of the message. `cards` and
	// `cards_v2` can have a maximum size of 32 KB.
	//
	// Deprecated: Marked as deprecated in google/chat/v1/message.proto.
	Cards []*ContextualAddOnMarkup_Card `protobuf:"bytes,5,rep,name=cards,proto3" json:"cards,omitempty"`
	// An array of
	// [cards](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards).
	//
	// Only Chat apps can create cards. If your Chat app [authenticates as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// the messages can't contain cards.
	//
	// To learn about cards and how to create them, see [Send card
	// messages](https://developers.google.com/workspace/chat/create-messages#create).
	//
	// [Card builder](https://addons.gsuite.google.com/uikit/builder)
	CardsV2 []*CardWithId `protobuf:"bytes,22,rep,name=cards_v2,json=cardsV2,proto3" json:"cards_v2,omitempty"`
	// Output only. Annotations associated with the `text` in this message.
	Annotations []*Annotation `protobuf:"bytes,10,rep,name=annotations,proto3" json:"annotations,omitempty"`
	// The thread the message belongs to. For example usage, see
	// [Start or reply to a message
	// thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
	Thread *Thread `protobuf:"bytes,11,opt,name=thread,proto3" json:"thread,omitempty"`
	// If your Chat app [authenticates as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
	// the output populates the
	// [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
	// `name`.
	Space *Space `protobuf:"bytes,12,opt,name=space,proto3" json:"space,omitempty"`
	// A plain-text description of the message's cards, used when the actual cards
	// can't be displayed—for example, mobile notifications.
	FallbackText string `protobuf:"bytes,13,opt,name=fallback_text,json=fallbackText,proto3" json:"fallback_text,omitempty"`
	// Input only. Parameters that a Chat app can use to configure how its
	// response is posted.
	ActionResponse *ActionResponse `protobuf:"bytes,14,opt,name=action_response,json=actionResponse,proto3" json:"action_response,omitempty"`
	// Output only. Plain-text body of the message with all Chat app mentions
	// stripped out.
	ArgumentText string `protobuf:"bytes,15,opt,name=argument_text,json=argumentText,proto3" json:"argument_text,omitempty"`
	// Output only. Slash command information, if applicable.
	SlashCommand *SlashCommand `protobuf:"bytes,17,opt,name=slash_command,json=slashCommand,proto3" json:"slash_command,omitempty"`
	// User-uploaded attachment.
	Attachment []*Attachment `protobuf:"bytes,18,rep,name=attachment,proto3" json:"attachment,omitempty"`
	// Output only. A URL in `spaces.messages.text` that matches a link preview
	// pattern. For more information, see [Preview
	// links](https://developers.google.com/workspace/chat/preview-links).
	MatchedUrl *MatchedUrl `protobuf:"bytes,20,opt,name=matched_url,json=matchedUrl,proto3" json:"matched_url,omitempty"`
	// Output only. When `true`, the message is a response in a reply thread. When
	// `false`, the message is visible in the space's top-level conversation as
	// either the first message of a thread or a message with no threaded replies.
	//
	// If the space doesn't support reply in threads, this field is always
	// `false`.
	ThreadReply bool `protobuf:"varint,25,opt,name=thread_reply,json=threadReply,proto3" json:"thread_reply,omitempty"`
	// Optional. A custom ID for the message. You can use field to identify a
	// message, or to get, delete, or update a message. To set a custom ID,
	// specify the
	// [`messageId`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#body.QUERY_PARAMETERS.message_id)
	// field when you create the message. For details, see [Name a
	// message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
	ClientAssignedMessageId string `protobuf:"bytes,32,opt,name=client_assigned_message_id,json=clientAssignedMessageId,proto3" json:"client_assigned_message_id,omitempty"`
	// Output only. The list of emoji reaction summaries on the message.
	EmojiReactionSummaries []*EmojiReactionSummary `protobuf:"bytes,33,rep,name=emoji_reaction_summaries,json=emojiReactionSummaries,proto3" json:"emoji_reaction_summaries,omitempty"`
	// Immutable. Input for creating a message, otherwise output only. The user
	// that can view the message. When set, the message is private and only
	// visible to the specified user and the Chat app. Link previews and
	// attachments aren't supported for private messages.
	//
	// Only Chat apps can send private messages. If your Chat app [authenticates
	// as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user)
	// to send a message, the message can't be private and must omit this field.
	//
	// For details, see [Send private messages to Google Chat
	// users](https://developers.google.com/workspace/chat/private-messages).
	PrivateMessageViewer *User `protobuf:"bytes,36,opt,name=private_message_viewer,json=privateMessageViewer,proto3" json:"private_message_viewer,omitempty"`
	// Output only. Information about a deleted message. A message is deleted when
	// `delete_time` is set.
	DeletionMetadata *DeletionMetadata `protobuf:"bytes,38,opt,name=deletion_metadata,json=deletionMetadata,proto3" json:"deletion_metadata,omitempty"`
	// Output only. Information about a message that's quoted by a Google Chat
	// user in a space. Google Chat users can quote a message to reply to it.
	QuotedMessageMetadata *QuotedMessageMetadata `protobuf:"bytes,39,opt,name=quoted_message_metadata,json=quotedMessageMetadata,proto3" json:"quoted_message_metadata,omitempty"`
	// Output only. GIF images that are attached to the message.
	AttachedGifs []*AttachedGif `protobuf:"bytes,42,rep,name=attached_gifs,json=attachedGifs,proto3" json:"attached_gifs,omitempty"`
	// One or more interactive widgets that appear at the bottom of a message.
	// You can add accessory widgets to messages that contain text, cards, or both
	// text and cards. Not supported for messages that contain dialogs. For
	// details, see [Add interactive widgets at the bottom of a
	// message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
	//
	// Creating a message with accessory widgets requires [app
	// authentication]
	// (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
	AccessoryWidgets []*AccessoryWidget `protobuf:"bytes,44,rep,name=accessory_widgets,json=accessoryWidgets,proto3" json:"accessory_widgets,omitempty"`
}

func (x *Message) Reset() {
	*x = Message{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{0}
}

func (x *Message) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Message) GetSender() *User {
	if x != nil {
		return x.Sender
	}
	return nil
}

func (x *Message) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Message) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *Message) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Message) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *Message) GetFormattedText() string {
	if x != nil {
		return x.FormattedText
	}
	return ""
}

// Deprecated: Marked as deprecated in google/chat/v1/message.proto.
func (x *Message) GetCards() []*ContextualAddOnMarkup_Card {
	if x != nil {
		return x.Cards
	}
	return nil
}

func (x *Message) GetCardsV2() []*CardWithId {
	if x != nil {
		return x.CardsV2
	}
	return nil
}

func (x *Message) GetAnnotations() []*Annotation {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *Message) GetThread() *Thread {
	if x != nil {
		return x.Thread
	}
	return nil
}

func (x *Message) GetSpace() *Space {
	if x != nil {
		return x.Space
	}
	return nil
}

func (x *Message) GetFallbackText() string {
	if x != nil {
		return x.FallbackText
	}
	return ""
}

func (x *Message) GetActionResponse() *ActionResponse {
	if x != nil {
		return x.ActionResponse
	}
	return nil
}

func (x *Message) GetArgumentText() string {
	if x != nil {
		return x.ArgumentText
	}
	return ""
}

func (x *Message) GetSlashCommand() *SlashCommand {
	if x != nil {
		return x.SlashCommand
	}
	return nil
}

func (x *Message) GetAttachment() []*Attachment {
	if x != nil {
		return x.Attachment
	}
	return nil
}

func (x *Message) GetMatchedUrl() *MatchedUrl {
	if x != nil {
		return x.MatchedUrl
	}
	return nil
}

func (x *Message) GetThreadReply() bool {
	if x != nil {
		return x.ThreadReply
	}
	return false
}

func (x *Message) GetClientAssignedMessageId() string {
	if x != nil {
		return x.ClientAssignedMessageId
	}
	return ""
}

func (x *Message) GetEmojiReactionSummaries() []*EmojiReactionSummary {
	if x != nil {
		return x.EmojiReactionSummaries
	}
	return nil
}

func (x *Message) GetPrivateMessageViewer() *User {
	if x != nil {
		return x.PrivateMessageViewer
	}
	return nil
}

func (x *Message) GetDeletionMetadata() *DeletionMetadata {
	if x != nil {
		return x.DeletionMetadata
	}
	return nil
}

func (x *Message) GetQuotedMessageMetadata() *QuotedMessageMetadata {
	if x != nil {
		return x.QuotedMessageMetadata
	}
	return nil
}

func (x *Message) GetAttachedGifs() []*AttachedGif {
	if x != nil {
		return x.AttachedGifs
	}
	return nil
}

func (x *Message) GetAccessoryWidgets() []*AccessoryWidget {
	if x != nil {
		return x.AccessoryWidgets
	}
	return nil
}

// A GIF image that's specified by a URL.
type AttachedGif struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The URL that hosts the GIF image.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *AttachedGif) Reset() {
	*x = AttachedGif{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttachedGif) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttachedGif) ProtoMessage() {}

func (x *AttachedGif) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttachedGif.ProtoReflect.Descriptor instead.
func (*AttachedGif) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{1}
}

func (x *AttachedGif) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Information about a quoted message.
type QuotedMessageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the quoted message.
	//
	// Format: `spaces/{space}/messages/{message}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the quoted message was created or when the
	// quoted message was last updated.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
}

func (x *QuotedMessageMetadata) Reset() {
	*x = QuotedMessageMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QuotedMessageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuotedMessageMetadata) ProtoMessage() {}

func (x *QuotedMessageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuotedMessageMetadata.ProtoReflect.Descriptor instead.
func (*QuotedMessageMetadata) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{2}
}

func (x *QuotedMessageMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *QuotedMessageMetadata) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

// A thread in a Google Chat space. For example usage, see
// [Start or reply to a message
// thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
//
// If you specify a thread when creating a message, you can set the
// [`messageReplyOption`](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages/create#messagereplyoption)
// field to determine what happens if no matching thread is found.
type Thread struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the thread.
	//
	// Example: `spaces/{space}/threads/{thread}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Input for creating or updating a thread. Otherwise, output only.
	// ID for the thread. Supports up to 4000 characters.
	//
	// This ID is unique to the Chat app that sets it. For example, if
	// multiple Chat apps create a message using the same thread key,
	// the messages are posted in different threads. To reply in a
	// thread created by a person or another Chat app, specify the thread `name`
	// field instead.
	ThreadKey string `protobuf:"bytes,3,opt,name=thread_key,json=threadKey,proto3" json:"thread_key,omitempty"`
}

func (x *Thread) Reset() {
	*x = Thread{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Thread) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Thread) ProtoMessage() {}

func (x *Thread) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Thread.ProtoReflect.Descriptor instead.
func (*Thread) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{3}
}

func (x *Thread) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Thread) GetThreadKey() string {
	if x != nil {
		return x.ThreadKey
	}
	return ""
}

// Parameters that a Chat app can use to configure how its response is posted.
type ActionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. The type of Chat app response.
	Type ActionResponse_ResponseType `protobuf:"varint,1,opt,name=type,proto3,enum=google.chat.v1.ActionResponse_ResponseType" json:"type,omitempty"`
	// Input only. URL for users to authenticate or configure. (Only for
	// `REQUEST_CONFIG` response types.)
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Input only. A response to an interaction event related to a
	// [dialog](https://developers.google.com/workspace/chat/dialogs). Must be
	// accompanied by `ResponseType.Dialog`.
	DialogAction *DialogAction `protobuf:"bytes,3,opt,name=dialog_action,json=dialogAction,proto3" json:"dialog_action,omitempty"`
	// Input only. The response of the updated widget.
	UpdatedWidget *ActionResponse_UpdatedWidget `protobuf:"bytes,4,opt,name=updated_widget,json=updatedWidget,proto3" json:"updated_widget,omitempty"`
}

func (x *ActionResponse) Reset() {
	*x = ActionResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionResponse) ProtoMessage() {}

func (x *ActionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionResponse.ProtoReflect.Descriptor instead.
func (*ActionResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{4}
}

func (x *ActionResponse) GetType() ActionResponse_ResponseType {
	if x != nil {
		return x.Type
	}
	return ActionResponse_TYPE_UNSPECIFIED
}

func (x *ActionResponse) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *ActionResponse) GetDialogAction() *DialogAction {
	if x != nil {
		return x.DialogAction
	}
	return nil
}

func (x *ActionResponse) GetUpdatedWidget() *ActionResponse_UpdatedWidget {
	if x != nil {
		return x.UpdatedWidget
	}
	return nil
}

// One or more interactive widgets that appear at the bottom of a message. For
// details, see [Add interactive widgets at the bottom of a
// message](https://developers.google.com/workspace/chat/create-messages#add-accessory-widgets).
type AccessoryWidget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of action.
	//
	// Types that are assignable to Action:
	//
	//	*AccessoryWidget_ButtonList
	Action isAccessoryWidget_Action `protobuf_oneof:"action"`
}

func (x *AccessoryWidget) Reset() {
	*x = AccessoryWidget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessoryWidget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessoryWidget) ProtoMessage() {}

func (x *AccessoryWidget) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessoryWidget.ProtoReflect.Descriptor instead.
func (*AccessoryWidget) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{5}
}

func (m *AccessoryWidget) GetAction() isAccessoryWidget_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *AccessoryWidget) GetButtonList() *v1.ButtonList {
	if x, ok := x.GetAction().(*AccessoryWidget_ButtonList); ok {
		return x.ButtonList
	}
	return nil
}

type isAccessoryWidget_Action interface {
	isAccessoryWidget_Action()
}

type AccessoryWidget_ButtonList struct {
	// A list of buttons.
	ButtonList *v1.ButtonList `protobuf:"bytes,1,opt,name=button_list,json=buttonList,proto3,oneof"`
}

func (*AccessoryWidget_ButtonList) isAccessoryWidget_Action() {}

// Request to get a message.
type GetMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the message.
	//
	// Format: `spaces/{space}/messages/{message}`
	//
	// If you've set a custom ID for your message, you can use the value from the
	// `clientAssignedMessageId` field for `{message}`. For details, see [Name a
	// message]
	// (https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMessageRequest) Reset() {
	*x = GetMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMessageRequest) ProtoMessage() {}

func (x *GetMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMessageRequest.ProtoReflect.Descriptor instead.
func (*GetMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{6}
}

func (x *GetMessageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to delete a message.
type DeleteMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the message.
	//
	// Format: `spaces/{space}/messages/{message}`
	//
	// If you've set a custom ID for your message, you can use the value from the
	// `clientAssignedMessageId` field for `{message}`. For details, see [Name a
	// message]
	// (https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// When `true`, deleting a message also deletes its threaded replies. When
	// `false`, if a message has threaded replies, deletion fails.
	//
	// Only applies when [authenticating as a
	// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user).
	// Has no effect when [authenticating as a Chat app]
	// (https://developers.google.com/workspace/chat/authenticate-authorize-chat-app).
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteMessageRequest) Reset() {
	*x = DeleteMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMessageRequest) ProtoMessage() {}

func (x *DeleteMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMessageRequest.ProtoReflect.Descriptor instead.
func (*DeleteMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteMessageRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteMessageRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request to update a message.
type UpdateMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Message with fields updated.
	Message *Message `protobuf:"bytes,1,opt,name=message,proto3" json:"message,omitempty"`
	// Required. The field paths to update. Separate multiple values with commas
	// or use `*` to update all field paths.
	//
	// Currently supported field paths:
	//
	// - `text`
	//
	// - `attachment`
	//
	// - `cards` (Requires [app
	// authentication](/chat/api/guides/auth/service-accounts).)
	//
	// - `cards_v2`  (Requires [app
	// authentication](/chat/api/guides/auth/service-accounts).)
	//
	// - `accessory_widgets`  (Requires [app
	// authentication](/chat/api/guides/auth/service-accounts).)
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. If `true` and the message isn't found, a new message is created
	// and `updateMask` is ignored. The specified message ID must be
	// [client-assigned](https://developers.google.com/workspace/chat/create-messages#name_a_created_message)
	// or the request fails.
	AllowMissing bool `protobuf:"varint,4,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateMessageRequest) Reset() {
	*x = UpdateMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMessageRequest) ProtoMessage() {}

func (x *UpdateMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMessageRequest.ProtoReflect.Descriptor instead.
func (*UpdateMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateMessageRequest) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *UpdateMessageRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMessageRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Creates a message.
type CreateMessageRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the space in which to create a message.
	//
	// Format: `spaces/{space}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Message body.
	Message *Message `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	// Optional. Deprecated: Use
	// [thread.thread_key][google.chat.v1.Thread.thread_key] instead. ID for the
	// thread. Supports up to 4000 characters. To start or add to a thread, create
	// a message and specify a `threadKey` or the
	// [thread.name][google.chat.v1.Thread.name]. For example usage, see [Start or
	// reply to a message
	// thread](https://developers.google.com/workspace/chat/create-messages#create-message-thread).
	//
	// Deprecated: Marked as deprecated in google/chat/v1/message.proto.
	ThreadKey string `protobuf:"bytes,6,opt,name=thread_key,json=threadKey,proto3" json:"thread_key,omitempty"`
	// Optional. A unique request ID for this message. Specifying an existing
	// request ID returns the message created with that ID instead of creating a
	// new message.
	RequestId string `protobuf:"bytes,7,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. Specifies whether a message starts a thread or replies to one.
	// Only supported in named spaces.
	MessageReplyOption CreateMessageRequest_MessageReplyOption `protobuf:"varint,8,opt,name=message_reply_option,json=messageReplyOption,proto3,enum=google.chat.v1.CreateMessageRequest_MessageReplyOption" json:"message_reply_option,omitempty"`
	// Optional. A custom ID for a message. Lets Chat apps get, update, or delete
	// a message without needing to store the system-assigned ID in the message's
	// resource name (represented in the message `name` field).
	//
	// The value for this field must meet the following requirements:
	//
	//   - Begins with `client-`. For example, `client-custom-name` is a valid
	//     custom ID, but `custom-name` is not.
	//   - Contains up to 63 characters and only lowercase letters, numbers, and
	//     hyphens.
	//   - Is unique within a space. A Chat app can't use the same custom ID for
	//
	// different messages.
	//
	// For details, see [Name a
	// message](https://developers.google.com/workspace/chat/create-messages#name_a_created_message).
	MessageId string `protobuf:"bytes,9,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
}

func (x *CreateMessageRequest) Reset() {
	*x = CreateMessageRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMessageRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMessageRequest) ProtoMessage() {}

func (x *CreateMessageRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMessageRequest.ProtoReflect.Descriptor instead.
func (*CreateMessageRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{9}
}

func (x *CreateMessageRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMessageRequest) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

// Deprecated: Marked as deprecated in google/chat/v1/message.proto.
func (x *CreateMessageRequest) GetThreadKey() string {
	if x != nil {
		return x.ThreadKey
	}
	return ""
}

func (x *CreateMessageRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateMessageRequest) GetMessageReplyOption() CreateMessageRequest_MessageReplyOption {
	if x != nil {
		return x.MessageReplyOption
	}
	return CreateMessageRequest_MESSAGE_REPLY_OPTION_UNSPECIFIED
}

func (x *CreateMessageRequest) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

// Lists messages in the specified space, that the user is a member of.
type ListMessagesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the space to list messages from.
	//
	// Format: `spaces/{space}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of messages returned. The service might return fewer
	// messages than this value.
	//
	// If unspecified, at most 25 are returned.
	//
	// The maximum value is 1000. If you use a value more than 1000, it's
	// automatically changed to 1000.
	//
	// Negative values return an `INVALID_ARGUMENT` error.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional, if resuming from a previous query.
	//
	// A page token received from a previous list messages call. Provide this
	// parameter to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided should match the call that
	// provided the page token. Passing different values to the other parameters
	// might lead to unexpected results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A query filter.
	//
	// You can filter messages by date (`create_time`) and thread (`thread.name`).
	//
	// To filter messages by the date they were created, specify the `create_time`
	// with a timestamp in [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339)
	// format and double quotation marks. For example,
	// `"2023-04-21T11:30:00-04:00"`. You can use the greater than operator `>` to
	// list messages that were created after a timestamp, or the less than
	// operator `<` to list messages that were created before a timestamp. To
	// filter messages within a time interval, use the `AND` operator between two
	// timestamps.
	//
	// To filter by thread, specify the `thread.name`, formatted as
	// `spaces/{space}/threads/{thread}`. You can only specify one
	// `thread.name` per query.
	//
	// To filter by both thread and date, use the `AND` operator in your query.
	//
	// For example, the following queries are valid:
	//
	// ```
	// create_time > "2012-04-21T11:30:00-04:00"
	//
	// create_time > "2012-04-21T11:30:00-04:00" AND
	//
	//	thread.name = spaces/AAAAAAAAAAA/threads/123
	//
	// create_time > "2012-04-21T11:30:00+00:00" AND
	//
	// create_time < "2013-01-01T00:00:00+00:00" AND
	//
	//	thread.name = spaces/AAAAAAAAAAA/threads/123
	//
	// thread.name = spaces/AAAAAAAAAAA/threads/123
	// ```
	//
	// Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
	// error.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional, if resuming from a previous query.
	//
	// How the list of messages is ordered. Specify a value to order by an
	// ordering operation. Valid ordering operation values are as follows:
	//
	// - `ASC` for ascending.
	//
	// - `DESC` for descending.
	//
	// The default ordering is `create_time ASC`.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Whether to include deleted messages. Deleted messages include deleted time
	// and metadata about their deletion, but message content is unavailable.
	ShowDeleted bool `protobuf:"varint,6,opt,name=show_deleted,json=showDeleted,proto3" json:"show_deleted,omitempty"`
}

func (x *ListMessagesRequest) Reset() {
	*x = ListMessagesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMessagesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMessagesRequest) ProtoMessage() {}

func (x *ListMessagesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMessagesRequest.ProtoReflect.Descriptor instead.
func (*ListMessagesRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{10}
}

func (x *ListMessagesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMessagesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMessagesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMessagesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMessagesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListMessagesRequest) GetShowDeleted() bool {
	if x != nil {
		return x.ShowDeleted
	}
	return false
}

// Response message for listing messages.
type ListMessagesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of messages.
	Messages []*Message `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
	// You can send a token as `pageToken` to retrieve the next page of
	// results. If empty, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMessagesResponse) Reset() {
	*x = ListMessagesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMessagesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMessagesResponse) ProtoMessage() {}

func (x *ListMessagesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMessagesResponse.ProtoReflect.Descriptor instead.
func (*ListMessagesResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{11}
}

func (x *ListMessagesResponse) GetMessages() []*Message {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *ListMessagesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Contains a
// [dialog](https://developers.google.com/workspace/chat/dialogs) and request
// status code.
type DialogAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action to perform.
	//
	// Types that are assignable to Action:
	//
	//	*DialogAction_Dialog
	Action isDialogAction_Action `protobuf_oneof:"action"`
	// Input only. Status for a request to either invoke or submit a
	// [dialog](https://developers.google.com/workspace/chat/dialogs). Displays
	// a status and message to users, if necessary.
	// For example, in case of an error or success.
	ActionStatus *ActionStatus `protobuf:"bytes,2,opt,name=action_status,json=actionStatus,proto3" json:"action_status,omitempty"`
}

func (x *DialogAction) Reset() {
	*x = DialogAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DialogAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogAction) ProtoMessage() {}

func (x *DialogAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogAction.ProtoReflect.Descriptor instead.
func (*DialogAction) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{12}
}

func (m *DialogAction) GetAction() isDialogAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *DialogAction) GetDialog() *Dialog {
	if x, ok := x.GetAction().(*DialogAction_Dialog); ok {
		return x.Dialog
	}
	return nil
}

func (x *DialogAction) GetActionStatus() *ActionStatus {
	if x != nil {
		return x.ActionStatus
	}
	return nil
}

type isDialogAction_Action interface {
	isDialogAction_Action()
}

type DialogAction_Dialog struct {
	// Input only.
	// [Dialog](https://developers.google.com/workspace/chat/dialogs) for the
	// request.
	Dialog *Dialog `protobuf:"bytes,1,opt,name=dialog,proto3,oneof"`
}

func (*DialogAction_Dialog) isDialogAction_Action() {}

// Wrapper around the card body of the dialog.
type Dialog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. Body of the dialog, which is rendered in a modal.
	// Google Chat apps don't support the following card entities:
	// `DateTimePicker`, `OnChangeAction`.
	Body *v1.Card `protobuf:"bytes,1,opt,name=body,proto3" json:"body,omitempty"`
}

func (x *Dialog) Reset() {
	*x = Dialog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dialog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dialog) ProtoMessage() {}

func (x *Dialog) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dialog.ProtoReflect.Descriptor instead.
func (*Dialog) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{13}
}

func (x *Dialog) GetBody() *v1.Card {
	if x != nil {
		return x.Body
	}
	return nil
}

// A
// [card](https://developers.google.com/workspace/chat/api/reference/rest/v1/cards)
// in a Google Chat message.
//
// Only Chat apps can create cards. If your Chat app [authenticates as a
// user](https://developers.google.com/workspace/chat/authenticate-authorize-chat-user),
// the message can't contain cards.
//
// [Card builder](https://addons.gsuite.google.com/uikit/builder)
type CardWithId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required if the message contains multiple cards. A unique identifier for
	// a card in a message.
	CardId string `protobuf:"bytes,1,opt,name=card_id,json=cardId,proto3" json:"card_id,omitempty"`
	// A card. Maximum size is 32 KB.
	Card *v1.Card `protobuf:"bytes,2,opt,name=card,proto3" json:"card,omitempty"`
}

func (x *CardWithId) Reset() {
	*x = CardWithId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CardWithId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CardWithId) ProtoMessage() {}

func (x *CardWithId) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CardWithId.ProtoReflect.Descriptor instead.
func (*CardWithId) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{14}
}

func (x *CardWithId) GetCardId() string {
	if x != nil {
		return x.CardId
	}
	return ""
}

func (x *CardWithId) GetCard() *v1.Card {
	if x != nil {
		return x.Card
	}
	return nil
}

// List of widget autocomplete results.
type ActionResponse_SelectionItems struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An array of the SelectionItem objects.
	Items []*v1.SelectionInput_SelectionItem `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *ActionResponse_SelectionItems) Reset() {
	*x = ActionResponse_SelectionItems{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionResponse_SelectionItems) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionResponse_SelectionItems) ProtoMessage() {}

func (x *ActionResponse_SelectionItems) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionResponse_SelectionItems.ProtoReflect.Descriptor instead.
func (*ActionResponse_SelectionItems) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ActionResponse_SelectionItems) GetItems() []*v1.SelectionInput_SelectionItem {
	if x != nil {
		return x.Items
	}
	return nil
}

// The response of the updated widget.
// Used to provide autocomplete options for a widget.
type ActionResponse_UpdatedWidget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The widget updated in response to a user action.
	//
	// Types that are assignable to UpdatedWidget:
	//
	//	*ActionResponse_UpdatedWidget_Suggestions
	UpdatedWidget isActionResponse_UpdatedWidget_UpdatedWidget `protobuf_oneof:"updated_widget"`
	// The ID of the updated widget. The ID must match the one for the
	// widget that triggered the update request.
	Widget string `protobuf:"bytes,2,opt,name=widget,proto3" json:"widget,omitempty"`
}

func (x *ActionResponse_UpdatedWidget) Reset() {
	*x = ActionResponse_UpdatedWidget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_chat_v1_message_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionResponse_UpdatedWidget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionResponse_UpdatedWidget) ProtoMessage() {}

func (x *ActionResponse_UpdatedWidget) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_message_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionResponse_UpdatedWidget.ProtoReflect.Descriptor instead.
func (*ActionResponse_UpdatedWidget) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_message_proto_rawDescGZIP(), []int{4, 1}
}

func (m *ActionResponse_UpdatedWidget) GetUpdatedWidget() isActionResponse_UpdatedWidget_UpdatedWidget {
	if m != nil {
		return m.UpdatedWidget
	}
	return nil
}

func (x *ActionResponse_UpdatedWidget) GetSuggestions() *ActionResponse_SelectionItems {
	if x, ok := x.GetUpdatedWidget().(*ActionResponse_UpdatedWidget_Suggestions); ok {
		return x.Suggestions
	}
	return nil
}

func (x *ActionResponse_UpdatedWidget) GetWidget() string {
	if x != nil {
		return x.Widget
	}
	return ""
}

type isActionResponse_UpdatedWidget_UpdatedWidget interface {
	isActionResponse_UpdatedWidget_UpdatedWidget()
}

type ActionResponse_UpdatedWidget_Suggestions struct {
	// List of widget autocomplete results
	Suggestions *ActionResponse_SelectionItems `protobuf:"bytes,1,opt,name=suggestions,proto3,oneof"`
}

func (*ActionResponse_UpdatedWidget_Suggestions) isActionResponse_UpdatedWidget_UpdatedWidget() {}

var File_google_chat_v1_message_proto protoreflect.FileDescriptor

var file_google_chat_v1_message_proto_rawDesc = []byte{
	0x0a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x70, 0x73, 0x2f, 0x63, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31, 0x2f,
	0x63, 0x61, 0x72, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76,
	0x31, 0x2f, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x6c, 0x61, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61,
	0x74, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8f,
	0x0d, 0x0a, 0x07, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x31,
	0x0a, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x12, 0x43, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x74, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x54,
	0x65, 0x78, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x63, 0x61, 0x72, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x64,
	0x64, 0x4f, 0x6e, 0x4d, 0x61, 0x72, 0x6b, 0x75, 0x70, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x05, 0x63, 0x61, 0x72, 0x64, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x63, 0x61, 0x72,
	0x64, 0x73, 0x5f, 0x76, 0x32, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x72,
	0x64, 0x57, 0x69, 0x74, 0x68, 0x49, 0x64, 0x52, 0x07, 0x63, 0x61, 0x72, 0x64, 0x73, 0x56, 0x32,
	0x12, 0x41, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x2e, 0x0a, 0x06, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x52, 0x06, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x12, 0x2b, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x05, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63,
	0x6b, 0x54, 0x65, 0x78, 0x74, 0x12, 0x4c, 0x0a, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x04, 0x52, 0x0e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x65, 0x78, 0x74, 0x12, 0x46, 0x0a,
	0x0d, 0x73, 0x6c, 0x61, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x18, 0x11,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x6c, 0x61, 0x73, 0x68, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x3a, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x55,
	0x72, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64,
	0x55, 0x72, 0x6c, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x72, 0x65,
	0x70, 0x6c, 0x79, 0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x3b, 0x0a, 0x1a, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x20, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x17, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49, 0x64, 0x12, 0x63, 0x0a, 0x18, 0x65, 0x6d, 0x6f, 0x6a,
	0x69, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x21, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6d, 0x6f, 0x6a,
	0x69, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x65, 0x6d, 0x6f, 0x6a, 0x69, 0x52, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x4f, 0x0a,
	0x16, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x18, 0x24, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x73, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x14, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x56, 0x69, 0x65, 0x77, 0x65, 0x72, 0x12, 0x52,
	0x0a, 0x11, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x10, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x62, 0x0a, 0x17, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x27, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x15, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x45, 0x0a, 0x0d, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68,
	0x65, 0x64, 0x5f, 0x67, 0x69, 0x66, 0x73, 0x18, 0x2a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x47, 0x69, 0x66, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x47, 0x69, 0x66, 0x73, 0x12, 0x4c, 0x0a,
	0x11, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x79, 0x5f, 0x77, 0x69, 0x64, 0x67, 0x65,
	0x74, 0x73, 0x18, 0x2c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6f, 0x72, 0x79, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x79, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x3a, 0x43, 0xea, 0x41, 0x40,
	0x0a, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x7d,
	0x22, 0x24, 0x0a, 0x0b, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x47, 0x69, 0x66, 0x12,
	0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x9f, 0x02, 0x0a, 0x15, 0x51, 0x75, 0x6f, 0x74, 0x65,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x29, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x51, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x51, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x7d, 0x2f, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2f, 0x7b,
	0x71, 0x75, 0x6f, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x7d, 0x22, 0x82, 0x01, 0x0a, 0x06, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x64, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x4b, 0x65, 0x79, 0x3a, 0x40, 0xea, 0x41, 0x3d,
	0x0a, 0x1a, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x12, 0x1f, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x7b, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x7d, 0x22, 0x97, 0x05,
	0x0a, 0x0e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x46, 0x0a,
	0x0d, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x52, 0x0d, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x1a,
	0x59, 0x0a, 0x0e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d,
	0x73, 0x12, 0x47, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x63,
	0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x1a, 0x8c, 0x01, 0x0a, 0x0d, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x0b,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x73,
	0x48, 0x00, 0x52, 0x0b, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x16, 0x0a, 0x06, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x5f, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x22, 0x9b, 0x01, 0x0a, 0x0c, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x45, 0x57, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x10,
	0x01, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x4d, 0x45, 0x53, 0x53,
	0x41, 0x47, 0x45, 0x10, 0x02, 0x12, 0x1d, 0x0a, 0x19, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x53, 0x45, 0x52, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x41, 0x52,
	0x44, 0x53, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x49, 0x41, 0x4c,
	0x4f, 0x47, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x57,
	0x49, 0x44, 0x47, 0x45, 0x54, 0x10, 0x07, 0x22, 0x5f, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x79, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x12, 0x42, 0x0a, 0x0b, 0x62, 0x75,
	0x74, 0x74, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x63, 0x61,
	0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x0a, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x08,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4c, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x37,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xb5, 0x01,
	0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x22, 0xea, 0x03, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1d, 0x12, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x24, 0x0a, 0x0a, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x09,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x4b, 0x65, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x6e, 0x0a,
	0x14, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a,
	0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x49,
	0x64, 0x22, 0x7f, 0x0a, 0x12, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x20, 0x4d, 0x45, 0x53, 0x53, 0x41,
	0x47, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x28, 0x0a,
	0x24, 0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x46,
	0x41, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x54, 0x4f, 0x5f, 0x4e, 0x45, 0x57, 0x5f, 0x54,
	0x48, 0x52, 0x45, 0x41, 0x44, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x50, 0x4c, 0x59,
	0x5f, 0x4d, 0x45, 0x53, 0x53, 0x41, 0x47, 0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x46, 0x41, 0x49, 0x4c,
	0x10, 0x02, 0x22, 0xe4, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1d, 0x12, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x6f, 0x77, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x68,
	0x6f, 0x77, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x22, 0x73, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x08, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97,
	0x01, 0x0a, 0x0c, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x35, 0x0a, 0x06, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x06,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x12, 0x46, 0x0a, 0x0d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x52, 0x0c, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x08,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3c, 0x0a, 0x06, 0x44, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x12, 0x32, 0x0a, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x63,
	0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x04,
	0x52, 0x04, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x54, 0x0a, 0x0a, 0x43, 0x61, 0x72, 0x64, 0x57, 0x69,
	0x74, 0x68, 0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x63, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x63, 0x61, 0x72, 0x64, 0x49, 0x64, 0x12, 0x2d, 0x0a,
	0x04, 0x63, 0x61, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x70, 0x73, 0x2e, 0x63, 0x61, 0x72, 0x64, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x72, 0x64, 0x52, 0x04, 0x63, 0x61, 0x72, 0x64, 0x42, 0xa5, 0x01, 0x0a,
	0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x42, 0x0c, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70,
	0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50, 0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa,
	0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68,
	0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41,
	0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_message_proto_rawDescOnce sync.Once
	file_google_chat_v1_message_proto_rawDescData = file_google_chat_v1_message_proto_rawDesc
)

func file_google_chat_v1_message_proto_rawDescGZIP() []byte {
	file_google_chat_v1_message_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_message_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_message_proto_rawDescData)
	})
	return file_google_chat_v1_message_proto_rawDescData
}

var file_google_chat_v1_message_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_chat_v1_message_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_chat_v1_message_proto_goTypes = []interface{}{
	(ActionResponse_ResponseType)(0),             // 0: google.chat.v1.ActionResponse.ResponseType
	(CreateMessageRequest_MessageReplyOption)(0), // 1: google.chat.v1.CreateMessageRequest.MessageReplyOption
	(*Message)(nil),                         // 2: google.chat.v1.Message
	(*AttachedGif)(nil),                     // 3: google.chat.v1.AttachedGif
	(*QuotedMessageMetadata)(nil),           // 4: google.chat.v1.QuotedMessageMetadata
	(*Thread)(nil),                          // 5: google.chat.v1.Thread
	(*ActionResponse)(nil),                  // 6: google.chat.v1.ActionResponse
	(*AccessoryWidget)(nil),                 // 7: google.chat.v1.AccessoryWidget
	(*GetMessageRequest)(nil),               // 8: google.chat.v1.GetMessageRequest
	(*DeleteMessageRequest)(nil),            // 9: google.chat.v1.DeleteMessageRequest
	(*UpdateMessageRequest)(nil),            // 10: google.chat.v1.UpdateMessageRequest
	(*CreateMessageRequest)(nil),            // 11: google.chat.v1.CreateMessageRequest
	(*ListMessagesRequest)(nil),             // 12: google.chat.v1.ListMessagesRequest
	(*ListMessagesResponse)(nil),            // 13: google.chat.v1.ListMessagesResponse
	(*DialogAction)(nil),                    // 14: google.chat.v1.DialogAction
	(*Dialog)(nil),                          // 15: google.chat.v1.Dialog
	(*CardWithId)(nil),                      // 16: google.chat.v1.CardWithId
	(*ActionResponse_SelectionItems)(nil),   // 17: google.chat.v1.ActionResponse.SelectionItems
	(*ActionResponse_UpdatedWidget)(nil),    // 18: google.chat.v1.ActionResponse.UpdatedWidget
	(*User)(nil),                            // 19: google.chat.v1.User
	(*timestamppb.Timestamp)(nil),           // 20: google.protobuf.Timestamp
	(*ContextualAddOnMarkup_Card)(nil),      // 21: google.chat.v1.ContextualAddOnMarkup.Card
	(*Annotation)(nil),                      // 22: google.chat.v1.Annotation
	(*Space)(nil),                           // 23: google.chat.v1.Space
	(*SlashCommand)(nil),                    // 24: google.chat.v1.SlashCommand
	(*Attachment)(nil),                      // 25: google.chat.v1.Attachment
	(*MatchedUrl)(nil),                      // 26: google.chat.v1.MatchedUrl
	(*EmojiReactionSummary)(nil),            // 27: google.chat.v1.EmojiReactionSummary
	(*DeletionMetadata)(nil),                // 28: google.chat.v1.DeletionMetadata
	(*v1.ButtonList)(nil),                   // 29: google.apps.card.v1.ButtonList
	(*fieldmaskpb.FieldMask)(nil),           // 30: google.protobuf.FieldMask
	(*ActionStatus)(nil),                    // 31: google.chat.v1.ActionStatus
	(*v1.Card)(nil),                         // 32: google.apps.card.v1.Card
	(*v1.SelectionInput_SelectionItem)(nil), // 33: google.apps.card.v1.SelectionInput.SelectionItem
}
var file_google_chat_v1_message_proto_depIdxs = []int32{
	19, // 0: google.chat.v1.Message.sender:type_name -> google.chat.v1.User
	20, // 1: google.chat.v1.Message.create_time:type_name -> google.protobuf.Timestamp
	20, // 2: google.chat.v1.Message.last_update_time:type_name -> google.protobuf.Timestamp
	20, // 3: google.chat.v1.Message.delete_time:type_name -> google.protobuf.Timestamp
	21, // 4: google.chat.v1.Message.cards:type_name -> google.chat.v1.ContextualAddOnMarkup.Card
	16, // 5: google.chat.v1.Message.cards_v2:type_name -> google.chat.v1.CardWithId
	22, // 6: google.chat.v1.Message.annotations:type_name -> google.chat.v1.Annotation
	5,  // 7: google.chat.v1.Message.thread:type_name -> google.chat.v1.Thread
	23, // 8: google.chat.v1.Message.space:type_name -> google.chat.v1.Space
	6,  // 9: google.chat.v1.Message.action_response:type_name -> google.chat.v1.ActionResponse
	24, // 10: google.chat.v1.Message.slash_command:type_name -> google.chat.v1.SlashCommand
	25, // 11: google.chat.v1.Message.attachment:type_name -> google.chat.v1.Attachment
	26, // 12: google.chat.v1.Message.matched_url:type_name -> google.chat.v1.MatchedUrl
	27, // 13: google.chat.v1.Message.emoji_reaction_summaries:type_name -> google.chat.v1.EmojiReactionSummary
	19, // 14: google.chat.v1.Message.private_message_viewer:type_name -> google.chat.v1.User
	28, // 15: google.chat.v1.Message.deletion_metadata:type_name -> google.chat.v1.DeletionMetadata
	4,  // 16: google.chat.v1.Message.quoted_message_metadata:type_name -> google.chat.v1.QuotedMessageMetadata
	3,  // 17: google.chat.v1.Message.attached_gifs:type_name -> google.chat.v1.AttachedGif
	7,  // 18: google.chat.v1.Message.accessory_widgets:type_name -> google.chat.v1.AccessoryWidget
	20, // 19: google.chat.v1.QuotedMessageMetadata.last_update_time:type_name -> google.protobuf.Timestamp
	0,  // 20: google.chat.v1.ActionResponse.type:type_name -> google.chat.v1.ActionResponse.ResponseType
	14, // 21: google.chat.v1.ActionResponse.dialog_action:type_name -> google.chat.v1.DialogAction
	18, // 22: google.chat.v1.ActionResponse.updated_widget:type_name -> google.chat.v1.ActionResponse.UpdatedWidget
	29, // 23: google.chat.v1.AccessoryWidget.button_list:type_name -> google.apps.card.v1.ButtonList
	2,  // 24: google.chat.v1.UpdateMessageRequest.message:type_name -> google.chat.v1.Message
	30, // 25: google.chat.v1.UpdateMessageRequest.update_mask:type_name -> google.protobuf.FieldMask
	2,  // 26: google.chat.v1.CreateMessageRequest.message:type_name -> google.chat.v1.Message
	1,  // 27: google.chat.v1.CreateMessageRequest.message_reply_option:type_name -> google.chat.v1.CreateMessageRequest.MessageReplyOption
	2,  // 28: google.chat.v1.ListMessagesResponse.messages:type_name -> google.chat.v1.Message
	15, // 29: google.chat.v1.DialogAction.dialog:type_name -> google.chat.v1.Dialog
	31, // 30: google.chat.v1.DialogAction.action_status:type_name -> google.chat.v1.ActionStatus
	32, // 31: google.chat.v1.Dialog.body:type_name -> google.apps.card.v1.Card
	32, // 32: google.chat.v1.CardWithId.card:type_name -> google.apps.card.v1.Card
	33, // 33: google.chat.v1.ActionResponse.SelectionItems.items:type_name -> google.apps.card.v1.SelectionInput.SelectionItem
	17, // 34: google.chat.v1.ActionResponse.UpdatedWidget.suggestions:type_name -> google.chat.v1.ActionResponse.SelectionItems
	35, // [35:35] is the sub-list for method output_type
	35, // [35:35] is the sub-list for method input_type
	35, // [35:35] is the sub-list for extension type_name
	35, // [35:35] is the sub-list for extension extendee
	0,  // [0:35] is the sub-list for field type_name
}

func init() { file_google_chat_v1_message_proto_init() }
func file_google_chat_v1_message_proto_init() {
	if File_google_chat_v1_message_proto != nil {
		return
	}
	file_google_chat_v1_action_status_proto_init()
	file_google_chat_v1_annotation_proto_init()
	file_google_chat_v1_attachment_proto_init()
	file_google_chat_v1_contextual_addon_proto_init()
	file_google_chat_v1_deletion_metadata_proto_init()
	file_google_chat_v1_matched_url_proto_init()
	file_google_chat_v1_reaction_proto_init()
	file_google_chat_v1_slash_command_proto_init()
	file_google_chat_v1_space_proto_init()
	file_google_chat_v1_user_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_chat_v1_message_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Message); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttachedGif); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QuotedMessageMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Thread); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessoryWidget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMessageRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMessagesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMessagesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DialogAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Dialog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CardWithId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionResponse_SelectionItems); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_chat_v1_message_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionResponse_UpdatedWidget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_chat_v1_message_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*AccessoryWidget_ButtonList)(nil),
	}
	file_google_chat_v1_message_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*DialogAction_Dialog)(nil),
	}
	file_google_chat_v1_message_proto_msgTypes[16].OneofWrappers = []interface{}{
		(*ActionResponse_UpdatedWidget_Suggestions)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_message_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_message_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_message_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_message_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_message_proto_msgTypes,
	}.Build()
	File_google_chat_v1_message_proto = out.File
	file_google_chat_v1_message_proto_rawDesc = nil
	file_google_chat_v1_message_proto_goTypes = nil
	file_google_chat_v1_message_proto_depIdxs = nil
}
