//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datashare/armdatashare"
	"net/http"
	"net/url"
	"regexp"
)

// ConsumerInvitationsServer is a fake server for instances of the armdatashare.ConsumerInvitationsClient type.
type ConsumerInvitationsServer struct {
	// Get is the fake for method ConsumerInvitationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, location string, invitationID string, options *armdatashare.ConsumerInvitationsClientGetOptions) (resp azfake.Responder[armdatashare.ConsumerInvitationsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListInvitationsPager is the fake for method ConsumerInvitationsClient.NewListInvitationsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListInvitationsPager func(options *armdatashare.ConsumerInvitationsClientListInvitationsOptions) (resp azfake.PagerResponder[armdatashare.ConsumerInvitationsClientListInvitationsResponse])

	// RejectInvitation is the fake for method ConsumerInvitationsClient.RejectInvitation
	// HTTP status codes to indicate success: http.StatusOK
	RejectInvitation func(ctx context.Context, location string, invitation armdatashare.ConsumerInvitation, options *armdatashare.ConsumerInvitationsClientRejectInvitationOptions) (resp azfake.Responder[armdatashare.ConsumerInvitationsClientRejectInvitationResponse], errResp azfake.ErrorResponder)
}

// NewConsumerInvitationsServerTransport creates a new instance of ConsumerInvitationsServerTransport with the provided implementation.
// The returned ConsumerInvitationsServerTransport instance is connected to an instance of armdatashare.ConsumerInvitationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewConsumerInvitationsServerTransport(srv *ConsumerInvitationsServer) *ConsumerInvitationsServerTransport {
	return &ConsumerInvitationsServerTransport{
		srv:                     srv,
		newListInvitationsPager: newTracker[azfake.PagerResponder[armdatashare.ConsumerInvitationsClientListInvitationsResponse]](),
	}
}

// ConsumerInvitationsServerTransport connects instances of armdatashare.ConsumerInvitationsClient to instances of ConsumerInvitationsServer.
// Don't use this type directly, use NewConsumerInvitationsServerTransport instead.
type ConsumerInvitationsServerTransport struct {
	srv                     *ConsumerInvitationsServer
	newListInvitationsPager *tracker[azfake.PagerResponder[armdatashare.ConsumerInvitationsClientListInvitationsResponse]]
}

// Do implements the policy.Transporter interface for ConsumerInvitationsServerTransport.
func (c *ConsumerInvitationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ConsumerInvitationsClient.Get":
		resp, err = c.dispatchGet(req)
	case "ConsumerInvitationsClient.NewListInvitationsPager":
		resp, err = c.dispatchNewListInvitationsPager(req)
	case "ConsumerInvitationsClient.RejectInvitation":
		resp, err = c.dispatchRejectInvitation(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ConsumerInvitationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.DataShare/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/consumerInvitations/(?P<invitationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	invitationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("invitationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), locationParam, invitationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConsumerInvitation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *ConsumerInvitationsServerTransport) dispatchNewListInvitationsPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListInvitationsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListInvitationsPager not implemented")}
	}
	newListInvitationsPager := c.newListInvitationsPager.get(req)
	if newListInvitationsPager == nil {
		qp := req.URL.Query()
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armdatashare.ConsumerInvitationsClientListInvitationsOptions
		if skipTokenParam != nil {
			options = &armdatashare.ConsumerInvitationsClientListInvitationsOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListInvitationsPager(options)
		newListInvitationsPager = &resp
		c.newListInvitationsPager.add(req, newListInvitationsPager)
		server.PagerResponderInjectNextLinks(newListInvitationsPager, req, func(page *armdatashare.ConsumerInvitationsClientListInvitationsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListInvitationsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListInvitationsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListInvitationsPager) {
		c.newListInvitationsPager.remove(req)
	}
	return resp, nil
}

func (c *ConsumerInvitationsServerTransport) dispatchRejectInvitation(req *http.Request) (*http.Response, error) {
	if c.srv.RejectInvitation == nil {
		return nil, &nonRetriableError{errors.New("fake for method RejectInvitation not implemented")}
	}
	const regexStr = `/providers/Microsoft\.DataShare/locations/(?P<location>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/rejectInvitation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armdatashare.ConsumerInvitation](req)
	if err != nil {
		return nil, err
	}
	locationParam, err := url.PathUnescape(matches[regex.SubexpIndex("location")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.RejectInvitation(req.Context(), locationParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ConsumerInvitation, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
