// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package tests

import (
	"testing"

	filesystem_options "code.forgejo.org/f3/gof3/v3/forges/filesystem/options"
	"code.forgejo.org/f3/gof3/v3/logger"
	"code.forgejo.org/f3/gof3/v3/options"
)

func newTestOptions(t *testing.T) options.Interface {
	t.Helper()
	o := options.GetFactory(filesystem_options.Name)().(*filesystem_options.Options)
	o.Directory = t.TempDir()
	l := logger.NewLogger()
	l.SetLevel(logger.Trace)
	o.SetLogger(l)
	return o
}
