# frozen_string_literal: true

class AddTmpBackfillIndexForPipelineIdsToVulnerabilityOccurrences < Gitlab::Database::Migration[2.2]
  milestone '17.0'

  TABLE_NAME = :vulnerability_occurrences
  INITIAL_PIPELINE_INDEX = 'tmp_index_vulnerability_occurrences_id_and_initial_pipline_id'
  LATEST_PIPELINE_INDEX = 'tmp_index_vulnerability_occurrences_id_and_latest_pipeline_id'

  INITIAL_PIPELINE_COLUMNS = [:id, :initial_pipeline_id]
  LATEST_PIPELINE_COLUMNS = [:id, :latest_pipeline_id]

  disable_ddl_transaction!

  # TODO remove in https://gitlab.com/gitlab-org/gitlab/-/issues/454243
  def up
    add_concurrent_index TABLE_NAME, INITIAL_PIPELINE_COLUMNS, name: INITIAL_PIPELINE_INDEX,
      where: 'initial_pipeline_id IS NULL'
    add_concurrent_index TABLE_NAME, LATEST_PIPELINE_COLUMNS, name: LATEST_PIPELINE_INDEX,
      where: 'latest_pipeline_id IS NULL'
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, name: INITIAL_PIPELINE_INDEX,
      where: 'initial_pipeline_id IS NULL'
    remove_concurrent_index_by_name TABLE_NAME, name: LATEST_PIPELINE_INDEX,
      where: 'latest_pipeline_id IS NULL'
  end
end
