/*****************************************************************
 * gavl - a general purpose audio/video processing library
 *
 * Copyright (c) 2001 - 2024 Members of the Gmerlin project
 * http://github.com/bplaum
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * *****************************************************************/




#ifndef GAVL_LANGUAGE_TABLE_H
#define GAVL_LANGUAGE_TABLE_H
// Generated by utils/make_language_table.sh
static const struct

  {
  const char * ISO_639_2_B;
  const char * ISO_639_2_T;
  const char * ISO_639_1;
  const char * label;
  }
languages[] =
  {
    { "abk", NULL, "ab", "Abkhazian" },
    { "ace", NULL, NULL, "Achinese" },
    { "ach", NULL, NULL, "Acoli" },
    { "ada", NULL, NULL, "Adangme" },
    { "ady", NULL, NULL, "Adyghe; Adygei" },
    { "aar", NULL, "aa", "Afar" },
    { "afh", NULL, NULL, "Afrihili" },
    { "afr", NULL, "af", "Afrikaans" },
    { "afa", NULL, NULL, "Afro-Asiatic languages" },
    { "ain", NULL, NULL, "Ainu" },
    { "aka", NULL, "ak", "Akan" },
    { "akk", NULL, NULL, "Akkadian" },
    { "alb", "sqi", "sq", "Albanian" },
    { "ale", NULL, NULL, "Aleut" },
    { "alg", NULL, NULL, "Algonquian languages" },
    { "tut", NULL, NULL, "Altaic languages" },
    { "amh", NULL, "am", "Amharic" },
    { "anp", NULL, NULL, "Angika" },
    { "apa", NULL, NULL, "Apache languages" },
    { "ara", NULL, "ar", "Arabic" },
    { "arg", NULL, "an", "Aragonese" },
    { "arp", NULL, NULL, "Arapaho" },
    { "arw", NULL, NULL, "Arawak" },
    { "arm", "hye", "hy", "Armenian" },
    { "rup", NULL, NULL, "Aromanian; Arumanian; Macedo-Romanian" },
    { "art", NULL, NULL, "Artificial languages" },
    { "asm", NULL, "as", "Assamese" },
    { "ast", NULL, NULL, "Asturian; Bable; Leonese; Asturleonese" },
    { "ath", NULL, NULL, "Athapascan languages" },
    { "aus", NULL, NULL, "Australian languages" },
    { "map", NULL, NULL, "Austronesian languages" },
    { "ava", NULL, "av", "Avaric" },
    { "ave", NULL, "ae", "Avestan" },
    { "awa", NULL, NULL, "Awadhi" },
    { "aym", NULL, "ay", "Aymara" },
    { "aze", NULL, "az", "Azerbaijani" },
    { "ban", NULL, NULL, "Balinese" },
    { "bat", NULL, NULL, "Baltic languages" },
    { "bal", NULL, NULL, "Baluchi" },
    { "bam", NULL, "bm", "Bambara" },
    { "bai", NULL, NULL, "Bamileke languages" },
    { "bad", NULL, NULL, "Banda languages" },
    { "bnt", NULL, NULL, "Bantu languages" },
    { "bas", NULL, NULL, "Basa" },
    { "bak", NULL, "ba", "Bashkir" },
    { "baq", "eus", "eu", "Basque" },
    { "btk", NULL, NULL, "Batak languages" },
    { "bej", NULL, NULL, "Beja; Bedawiyet" },
    { "bel", NULL, "be", "Belarusian" },
    { "bem", NULL, NULL, "Bemba" },
    { "ben", NULL, "bn", "Bengali" },
    { "ber", NULL, NULL, "Berber languages" },
    { "bho", NULL, NULL, "Bhojpuri" },
    { "bih", NULL, "bh", "Bihari languages" },
    { "bik", NULL, NULL, "Bikol" },
    { "bin", NULL, NULL, "Bini; Edo" },
    { "bis", NULL, "bi", "Bislama" },
    { "byn", NULL, NULL, "Blin; Bilin" },
    { "zbl", NULL, NULL, "Blissymbols; Blissymbolics; Bliss" },
    { "nob", NULL, "nb", "Bokmål, Norwegian; Norwegian Bokmål" },
    { "bos", NULL, "bs", "Bosnian" },
    { "bra", NULL, NULL, "Braj" },
    { "bre", NULL, "br", "Breton" },
    { "bug", NULL, NULL, "Buginese" },
    { "bul", NULL, "bg", "Bulgarian" },
    { "bua", NULL, NULL, "Buriat" },
    { "bur", "mya", "my", "Burmese" },
    { "cad", NULL, NULL, "Caddo" },
    { "cat", NULL, "ca", "Catalan; Valencian" },
    { "cau", NULL, NULL, "Caucasian languages" },
    { "ceb", NULL, NULL, "Cebuano" },
    { "cel", NULL, NULL, "Celtic languages" },
    { "cai", NULL, NULL, "Central American Indian languages" },
    { "khm", NULL, "km", "Central Khmer" },
    { "chg", NULL, NULL, "Chagatai" },
    { "cmc", NULL, NULL, "Chamic languages" },
    { "cha", NULL, "ch", "Chamorro" },
    { "che", NULL, "ce", "Chechen" },
    { "chr", NULL, NULL, "Cherokee" },
    { "chy", NULL, NULL, "Cheyenne" },
    { "chb", NULL, NULL, "Chibcha" },
    { "nya", NULL, "ny", "Chichewa; Chewa; Nyanja" },
    { "chi", "zho", "zh", "Chinese" },
    { "chn", NULL, NULL, "Chinook jargon" },
    { "chp", NULL, NULL, "Chipewyan; Dene Suline" },
    { "cho", NULL, NULL, "Choctaw" },
    { "chu", NULL, "cu", "Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic" },
    { "chk", NULL, NULL, "Chuukese" },
    { "chv", NULL, "cv", "Chuvash" },
    { "nwc", NULL, NULL, "Classical Newari; Old Newari; Classical Nepal Bhasa" },
    { "syc", NULL, NULL, "Classical Syriac" },
    { "cop", NULL, NULL, "Coptic" },
    { "cor", NULL, "kw", "Cornish" },
    { "cos", NULL, "co", "Corsican" },
    { "cre", NULL, "cr", "Cree" },
    { "mus", NULL, NULL, "Creek" },
    { "crp", NULL, NULL, "Creoles and pidgins" },
    { "cpe", NULL, NULL, "Creoles and pidgins, English based" },
    { "cpf", NULL, NULL, "Creoles and pidgins, French-based" },
    { "cpp", NULL, NULL, "Creoles and pidgins, Portuguese-based" },
    { "crh", NULL, NULL, "Crimean Tatar; Crimean Turkish" },
    { "hrv", NULL, "hr", "Croatian" },
    { "cus", NULL, NULL, "Cushitic languages" },
    { "cze", "ces", "cs", "Czech" },
    { "dak", NULL, NULL, "Dakota" },
    { "dan", NULL, "da", "Danish" },
    { "dar", NULL, NULL, "Dargwa" },
    { "del", NULL, NULL, "Delaware" },
    { "din", NULL, NULL, "Dinka" },
    { "div", NULL, "dv", "Divehi; Dhivehi; Maldivian" },
    { "dgr", NULL, NULL, "Dogrib" },
    { "doi", NULL, NULL, "Dogri" },
    { "dra", NULL, NULL, "Dravidian languages" },
    { "dua", NULL, NULL, "Duala" },
    { "dut", "nld", "nl", "Dutch; Flemish" },
    { "dum", NULL, NULL, "Dutch, Middle (ca.1050-1350)" },
    { "dyu", NULL, NULL, "Dyula" },
    { "dzo", NULL, "dz", "Dzongkha" },
    { "frs", NULL, NULL, "Eastern Frisian" },
    { "efi", NULL, NULL, "Efik" },
    { "egy", NULL, NULL, "Egyptian (Ancient)" },
    { "eka", NULL, NULL, "Ekajuk" },
    { "elx", NULL, NULL, "Elamite" },
    { "eng", NULL, "en", "English" },
    { "enm", NULL, NULL, "English, Middle (1100-1500)" },
    { "ang", NULL, NULL, "English, Old (ca.450-1100)" },
    { "myv", NULL, NULL, "Erzya" },
    { "epo", NULL, "eo", "Esperanto" },
    { "est", NULL, "et", "Estonian" },
    { "ewe", NULL, "ee", "Ewe" },
    { "ewo", NULL, NULL, "Ewondo" },
    { "fan", NULL, NULL, "Fang" },
    { "fat", NULL, NULL, "Fanti" },
    { "fao", NULL, "fo", "Faroese" },
    { "fij", NULL, "fj", "Fijian" },
    { "fil", NULL, NULL, "Filipino; Pilipino" },
    { "fin", NULL, "fi", "Finnish" },
    { "fiu", NULL, NULL, "Finno-Ugrian languages" },
    { "fon", NULL, NULL, "Fon" },
    { "fre", "fra", "fr", "French" },
    { "frm", NULL, NULL, "French, Middle (ca.1400-1600)" },
    { "fro", NULL, NULL, "French, Old (842-ca.1400)" },
    { "fur", NULL, NULL, "Friulian" },
    { "ful", NULL, "ff", "Fulah" },
    { "gla", NULL, "gd", "Gaelic; Scottish Gaelic" },
    { "gaa", NULL, NULL, "Ga" },
    { "car", NULL, NULL, "Galibi Carib" },
    { "glg", NULL, "gl", "Galician" },
    { "lug", NULL, "lg", "Ganda" },
    { "gay", NULL, NULL, "Gayo" },
    { "gba", NULL, NULL, "Gbaya" },
    { "gez", NULL, NULL, "Geez" },
    { "geo", "kat", "ka", "Georgian" },
    { "ger", "deu", "de", "German" },
    { "gem", NULL, NULL, "Germanic languages" },
    { "gmh", NULL, NULL, "German, Middle High (ca.1050-1500)" },
    { "goh", NULL, NULL, "German, Old High (ca.750-1050)" },
    { "gil", NULL, NULL, "Gilbertese" },
    { "gon", NULL, NULL, "Gondi" },
    { "gor", NULL, NULL, "Gorontalo" },
    { "got", NULL, NULL, "Gothic" },
    { "grb", NULL, NULL, "Grebo" },
    { "grc", NULL, NULL, "Greek, Ancient (to 1453)" },
    { "gre", "ell", "el", "Greek, Modern (1453-)" },
    { "grn", NULL, "gn", "Guarani" },
    { "guj", NULL, "gu", "Gujarati" },
    { "gwi", NULL, NULL, "Gwich'in" },
    { "hai", NULL, NULL, "Haida" },
    { "hat", NULL, "ht", "Haitian; Haitian Creole" },
    { "hau", NULL, "ha", "Hausa" },
    { "haw", NULL, NULL, "Hawaiian" },
    { "heb", NULL, "he", "Hebrew" },
    { "her", NULL, "hz", "Herero" },
    { "hil", NULL, NULL, "Hiligaynon" },
    { "him", NULL, NULL, "Himachali languages; Western Pahari languages" },
    { "hin", NULL, "hi", "Hindi" },
    { "hmo", NULL, "ho", "Hiri Motu" },
    { "hit", NULL, NULL, "Hittite" },
    { "hmn", NULL, NULL, "Hmong; Mong" },
    { "hun", NULL, "hu", "Hungarian" },
    { "hup", NULL, NULL, "Hupa" },
    { "iba", NULL, NULL, "Iban" },
    { "ice", "isl", "is", "Icelandic" },
    { "ido", NULL, "io", "Ido" },
    { "ibo", NULL, "ig", "Igbo" },
    { "ijo", NULL, NULL, "Ijo languages" },
    { "ilo", NULL, NULL, "Iloko" },
    { "smn", NULL, NULL, "Inari Sami" },
    { "inc", NULL, NULL, "Indic languages" },
    { "ine", NULL, NULL, "Indo-European languages" },
    { "ind", NULL, "id", "Indonesian" },
    { "inh", NULL, NULL, "Ingush" },
    { "ina", NULL, "ia", "Interlingua (International Auxiliary Language Association)" },
    { "ile", NULL, "ie", "Interlingue; Occidental" },
    { "iku", NULL, "iu", "Inuktitut" },
    { "ipk", NULL, "ik", "Inupiaq" },
    { "ira", NULL, NULL, "Iranian languages" },
    { "gle", NULL, "ga", "Irish" },
    { "mga", NULL, NULL, "Irish, Middle (900-1200)" },
    { "sga", NULL, NULL, "Irish, Old (to 900)" },
    { "iro", NULL, NULL, "Iroquoian languages" },
    { "ita", NULL, "it", "Italian" },
    { "jpn", NULL, "ja", "Japanese" },
    { "jav", NULL, "jv", "Javanese" },
    { "jrb", NULL, NULL, "Judeo-Arabic" },
    { "jpr", NULL, NULL, "Judeo-Persian" },
    { "kbd", NULL, NULL, "Kabardian" },
    { "kab", NULL, NULL, "Kabyle" },
    { "kac", NULL, NULL, "Kachin; Jingpho" },
    { "kal", NULL, "kl", "Kalaallisut; Greenlandic" },
    { "xal", NULL, NULL, "Kalmyk; Oirat" },
    { "kam", NULL, NULL, "Kamba" },
    { "kan", NULL, "kn", "Kannada" },
    { "kau", NULL, "kr", "Kanuri" },
    { "krc", NULL, NULL, "Karachay-Balkar" },
    { "kaa", NULL, NULL, "Kara-Kalpak" },
    { "krl", NULL, NULL, "Karelian" },
    { "kar", NULL, NULL, "Karen languages" },
    { "kas", NULL, "ks", "Kashmiri" },
    { "csb", NULL, NULL, "Kashubian" },
    { "kaw", NULL, NULL, "Kawi" },
    { "kaz", NULL, "kk", "Kazakh" },
    { "kha", NULL, NULL, "Khasi" },
    { "khi", NULL, NULL, "Khoisan languages" },
    { "kho", NULL, NULL, "Khotanese; Sakan" },
    { "kik", NULL, "ki", "Kikuyu; Gikuyu" },
    { "kmb", NULL, NULL, "Kimbundu" },
    { "kin", NULL, "rw", "Kinyarwanda" },
    { "kir", NULL, "ky", "Kirghiz; Kyrgyz" },
    { "tlh", NULL, NULL, "Klingon; tlhIngan-Hol" },
    { "kom", NULL, "kv", "Komi" },
    { "kon", NULL, "kg", "Kongo" },
    { "kok", NULL, NULL, "Konkani" },
    { "kor", NULL, "ko", "Korean" },
    { "kos", NULL, NULL, "Kosraean" },
    { "kpe", NULL, NULL, "Kpelle" },
    { "kro", NULL, NULL, "Kru languages" },
    { "kua", NULL, "kj", "Kuanyama; Kwanyama" },
    { "kum", NULL, NULL, "Kumyk" },
    { "kur", NULL, "ku", "Kurdish" },
    { "kru", NULL, NULL, "Kurukh" },
    { "kut", NULL, NULL, "Kutenai" },
    { "lad", NULL, NULL, "Ladino" },
    { "lah", NULL, NULL, "Lahnda" },
    { "lam", NULL, NULL, "Lamba" },
    { "day", NULL, NULL, "Land Dayak languages" },
    { "lao", NULL, "lo", "Lao" },
    { "lat", NULL, "la", "Latin" },
    { "lav", NULL, "lv", "Latvian" },
    { "lez", NULL, NULL, "Lezghian" },
    { "lim", NULL, "li", "Limburgan; Limburger; Limburgish" },
    { "lin", NULL, "ln", "Lingala" },
    { "lit", NULL, "lt", "Lithuanian" },
    { "jbo", NULL, NULL, "Lojban" },
    { "dsb", NULL, NULL, "Lower Sorbian" },
    { "nds", NULL, NULL, "Low German; Low Saxon; German, Low; Saxon, Low" },
    { "loz", NULL, NULL, "Lozi" },
    { "lub", NULL, "lu", "Luba-Katanga" },
    { "lua", NULL, NULL, "Luba-Lulua" },
    { "lui", NULL, NULL, "Luiseno" },
    { "smj", NULL, NULL, "Lule Sami" },
    { "lun", NULL, NULL, "Lunda" },
    { "luo", NULL, NULL, "Luo (Kenya and Tanzania)" },
    { "lus", NULL, NULL, "Lushai" },
    { "ltz", NULL, "lb", "Luxembourgish; Letzeburgesch" },
    { "mac", "mkd", "mk", "Macedonian" },
    { "mad", NULL, NULL, "Madurese" },
    { "mag", NULL, NULL, "Magahi" },
    { "mai", NULL, NULL, "Maithili" },
    { "mak", NULL, NULL, "Makasar" },
    { "mlg", NULL, "mg", "Malagasy" },
    { "mal", NULL, "ml", "Malayalam" },
    { "may", "msa", "ms", "Malay" },
    { "mlt", NULL, "mt", "Maltese" },
    { "mnc", NULL, NULL, "Manchu" },
    { "mdr", NULL, NULL, "Mandar" },
    { "man", NULL, NULL, "Mandingo" },
    { "mni", NULL, NULL, "Manipuri" },
    { "mno", NULL, NULL, "Manobo languages" },
    { "glv", NULL, "gv", "Manx" },
    { "mao", "mri", "mi", "Maori" },
    { "arn", NULL, NULL, "Mapudungun; Mapuche" },
    { "mar", NULL, "mr", "Marathi" },
    { "chm", NULL, NULL, "Mari" },
    { "mah", NULL, "mh", "Marshallese" },
    { "mwr", NULL, NULL, "Marwari" },
    { "mas", NULL, NULL, "Masai" },
    { "myn", NULL, NULL, "Mayan languages" },
    { "men", NULL, NULL, "Mende" },
    { "mic", NULL, NULL, "Mi'kmaq; Micmac" },
    { "min", NULL, NULL, "Minangkabau" },
    { "mwl", NULL, NULL, "Mirandese" },
    { "moh", NULL, NULL, "Mohawk" },
    { "mdf", NULL, NULL, "Moksha" },
    { "mon", NULL, "mn", "Mongolian" },
    { "lol", NULL, NULL, "Mongo" },
    { "mkh", NULL, NULL, "Mon-Khmer languages" },
    { "cnr", NULL, NULL, "Montenegrin" },
    { "mos", NULL, NULL, "Mossi" },
    { "mul", NULL, NULL, "Multiple languages" },
    { "mun", NULL, NULL, "Munda languages" },
    { "nah", NULL, NULL, "Nahuatl languages" },
    { "nau", NULL, "na", "Nauru" },
    { "nav", NULL, "nv", "Navajo; Navaho" },
    { "nde", NULL, "nd", "Ndebele, North; North Ndebele" },
    { "nbl", NULL, "nr", "Ndebele, South; South Ndebele" },
    { "ndo", NULL, "ng", "Ndonga" },
    { "nap", NULL, NULL, "Neapolitan" },
    { "new", NULL, NULL, "Nepal Bhasa; Newari" },
    { "nep", NULL, "ne", "Nepali" },
    { "nia", NULL, NULL, "Nias" },
    { "nic", NULL, NULL, "Niger-Kordofanian languages" },
    { "ssa", NULL, NULL, "Nilo-Saharan languages" },
    { "niu", NULL, NULL, "Niuean" },
    { "nqo", NULL, NULL, "N'Ko" },
    { "nog", NULL, NULL, "Nogai" },
    { "zxx", NULL, NULL, "No linguistic content; Not applicable" },
    { "non", NULL, NULL, "Norse, Old" },
    { "nai", NULL, NULL, "North American Indian languages" },
    { "frr", NULL, NULL, "Northern Frisian" },
    { "sme", NULL, "se", "Northern Sami" },
    { "nor", NULL, "no", "Norwegian" },
    { "nno", NULL, "nn", "Norwegian Nynorsk; Nynorsk, Norwegian" },
    { "nub", NULL, NULL, "Nubian languages" },
    { "nym", NULL, NULL, "Nyamwezi" },
    { "nyn", NULL, NULL, "Nyankole" },
    { "nyo", NULL, NULL, "Nyoro" },
    { "nzi", NULL, NULL, "Nzima" },
    { "oci", NULL, "oc", "Occitan (post 1500)" },
    { "arc", NULL, NULL, "Official Aramaic (700-300 BCE); Imperial Aramaic (700-300 BCE)" },
    { "oji", NULL, "oj", "Ojibwa" },
    { "ori", NULL, "or", "Oriya" },
    { "orm", NULL, "om", "Oromo" },
    { "osa", NULL, NULL, "Osage" },
    { "oss", NULL, "os", "Ossetian; Ossetic" },
    { "oto", NULL, NULL, "Otomian languages" },
    { "pal", NULL, NULL, "Pahlavi" },
    { "pau", NULL, NULL, "Palauan" },
    { "pli", NULL, "pi", "Pali" },
    { "pam", NULL, NULL, "Pampanga; Kapampangan" },
    { "pag", NULL, NULL, "Pangasinan" },
    { "pan", NULL, "pa", "Panjabi; Punjabi" },
    { "pap", NULL, NULL, "Papiamento" },
    { "paa", NULL, NULL, "Papuan languages" },
    { "nso", NULL, NULL, "Pedi; Sepedi; Northern Sotho" },
    { "peo", NULL, NULL, "Persian, Old (ca.600-400 B.C.)" },
    { "per", "fas", "fa", "Persian" },
    { "phi", NULL, NULL, "Philippine languages" },
    { "phn", NULL, NULL, "Phoenician" },
    { "pon", NULL, NULL, "Pohnpeian" },
    { "pol", NULL, "pl", "Polish" },
    { "por", NULL, "pt", "Portuguese" },
    { "pra", NULL, NULL, "Prakrit languages" },
    { "pro", NULL, NULL, "Provençal, Old (to 1500); Occitan, Old (to 1500)" },
    { "pus", NULL, "ps", "Pushto; Pashto" },
    { "que", NULL, "qu", "Quechua" },
    { "raj", NULL, NULL, "Rajasthani" },
    { "rap", NULL, NULL, "Rapanui" },
    { "rar", NULL, NULL, "Rarotongan; Cook Islands Maori" },
    { "roa", NULL, NULL, "Romance languages" },
    { "rum", "ron", "ro", "Romanian; Moldavian; Moldovan" },
    { "roh", NULL, "rm", "Romansh" },
    { "rom", NULL, NULL, "Romany" },
    { "run", NULL, "rn", "Rundi" },
    { "rus", NULL, "ru", "Russian" },
    { "sal", NULL, NULL, "Salishan languages" },
    { "sam", NULL, NULL, "Samaritan Aramaic" },
    { "smi", NULL, NULL, "Sami languages" },
    { "smo", NULL, "sm", "Samoan" },
    { "sad", NULL, NULL, "Sandawe" },
    { "sag", NULL, "sg", "Sango" },
    { "san", NULL, "sa", "Sanskrit" },
    { "sat", NULL, NULL, "Santali" },
    { "srd", NULL, "sc", "Sardinian" },
    { "sas", NULL, NULL, "Sasak" },
    { "sco", NULL, NULL, "Scots" },
    { "sel", NULL, NULL, "Selkup" },
    { "sem", NULL, NULL, "Semitic languages" },
    { "srp", NULL, "sr", "Serbian" },
    { "srr", NULL, NULL, "Serer" },
    { "shn", NULL, NULL, "Shan" },
    { "sna", NULL, "sn", "Shona" },
    { "iii", NULL, "ii", "Sichuan Yi; Nuosu" },
    { "scn", NULL, NULL, "Sicilian" },
    { "sid", NULL, NULL, "Sidamo" },
    { "sgn", NULL, NULL, "Sign Languages" },
    { "bla", NULL, NULL, "Siksika" },
    { "snd", NULL, "sd", "Sindhi" },
    { "sin", NULL, "si", "Sinhala; Sinhalese" },
    { "sit", NULL, NULL, "Sino-Tibetan languages" },
    { "sio", NULL, NULL, "Siouan languages" },
    { "sms", NULL, NULL, "Skolt Sami" },
    { "den", NULL, NULL, "Slave (Athapascan)" },
    { "sla", NULL, NULL, "Slavic languages" },
    { "slo", "slk", "sk", "Slovak" },
    { "slv", NULL, "sl", "Slovenian" },
    { "sog", NULL, NULL, "Sogdian" },
    { "som", NULL, "so", "Somali" },
    { "son", NULL, NULL, "Songhai languages" },
    { "snk", NULL, NULL, "Soninke" },
    { "wen", NULL, NULL, "Sorbian languages" },
    { "sot", NULL, "st", "Sotho, Southern" },
    { "sai", NULL, NULL, "South American Indian languages" },
    { "alt", NULL, NULL, "Southern Altai" },
    { "sma", NULL, NULL, "Southern Sami" },
    { "spa", NULL, "es", "Spanish; Castilian" },
    { "srn", NULL, NULL, "Sranan Tongo" },
    { "zgh", NULL, NULL, "Standard Moroccan Tamazight" },
    { "suk", NULL, NULL, "Sukuma" },
    { "sux", NULL, NULL, "Sumerian" },
    { "sun", NULL, "su", "Sundanese" },
    { "sus", NULL, NULL, "Susu" },
    { "swa", NULL, "sw", "Swahili" },
    { "ssw", NULL, "ss", "Swati" },
    { "swe", NULL, "sv", "Swedish" },
    { "gsw", NULL, NULL, "Swiss German; Alemannic; Alsatian" },
    { "syr", NULL, NULL, "Syriac" },
    { "tgl", NULL, "tl", "Tagalog" },
    { "tah", NULL, "ty", "Tahitian" },
    { "tai", NULL, NULL, "Tai languages" },
    { "tgk", NULL, "tg", "Tajik" },
    { "tmh", NULL, NULL, "Tamashek" },
    { "tam", NULL, "ta", "Tamil" },
    { "tat", NULL, "tt", "Tatar" },
    { "tel", NULL, "te", "Telugu" },
    { "ter", NULL, NULL, "Tereno" },
    { "tet", NULL, NULL, "Tetum" },
    { "tha", NULL, "th", "Thai" },
    { "tib", "bod", "bo", "Tibetan" },
    { "tig", NULL, NULL, "Tigre" },
    { "tir", NULL, "ti", "Tigrinya" },
    { "tem", NULL, NULL, "Timne" },
    { "tiv", NULL, NULL, "Tiv" },
    { "tli", NULL, NULL, "Tlingit" },
    { "tkl", NULL, NULL, "Tokelau" },
    { "tpi", NULL, NULL, "Tok Pisin" },
    { "tog", NULL, NULL, "Tonga (Nyasa)" },
    { "ton", NULL, "to", "Tonga (Tonga Islands)" },
    { "tsi", NULL, NULL, "Tsimshian" },
    { "tso", NULL, "ts", "Tsonga" },
    { "tsn", NULL, "tn", "Tswana" },
    { "tum", NULL, NULL, "Tumbuka" },
    { "tup", NULL, NULL, "Tupi languages" },
    { "ota", NULL, NULL, "Turkish, Ottoman (1500-1928)" },
    { "tur", NULL, "tr", "Turkish" },
    { "tuk", NULL, "tk", "Turkmen" },
    { "tvl", NULL, NULL, "Tuvalu" },
    { "tyv", NULL, NULL, "Tuvinian" },
    { "twi", NULL, "tw", "Twi" },
    { "udm", NULL, NULL, "Udmurt" },
    { "uga", NULL, NULL, "Ugaritic" },
    { "uig", NULL, "ug", "Uighur; Uyghur" },
    { "ukr", NULL, "uk", "Ukrainian" },
    { "umb", NULL, NULL, "Umbundu" },
    { "mis", NULL, NULL, "Uncoded languages" },
    { "und", NULL, NULL, "Undetermined" },
    { "hsb", NULL, NULL, "Upper Sorbian" },
    { "urd", NULL, "ur", "Urdu" },
    { "uzb", NULL, "uz", "Uzbek" },
    { "vai", NULL, NULL, "Vai" },
    { "ven", NULL, "ve", "Venda" },
    { "vie", NULL, "vi", "Vietnamese" },
    { "vol", NULL, "vo", "Volapük" },
    { "vot", NULL, NULL, "Votic" },
    { "wak", NULL, NULL, "Wakashan languages" },
    { "wln", NULL, "wa", "Walloon" },
    { "war", NULL, NULL, "Waray" },
    { "was", NULL, NULL, "Washo" },
    { "wel", "cym", "cy", "Welsh" },
    { "fry", NULL, "fy", "Western Frisian" },
    { "wal", NULL, NULL, "Wolaitta; Wolaytta" },
    { "wol", NULL, "wo", "Wolof" },
    { "xho", NULL, "xh", "Xhosa" },
    { "sah", NULL, NULL, "Yakut" },
    { "yao", NULL, NULL, "Yao" },
    { "yap", NULL, NULL, "Yapese" },
    { "yid", NULL, "yi", "Yiddish" },
    { "yor", NULL, "yo", "Yoruba" },
    { "ypk", NULL, NULL, "Yupik languages" },
    { "znd", NULL, NULL, "Zande languages" },
    { "zap", NULL, NULL, "Zapotec" },
    { "zza", NULL, NULL, "Zaza; Dimili; Dimli; Kirdki; Kirmanjki; Zazaki" },
    { "zen", NULL, NULL, "Zenaga" },
    { "zha", NULL, "za", "Zhuang; Chuang" },
    { "zul", NULL, "zu", "Zulu" },
    { "zun", NULL, NULL, "Zuni" },
  };
#endif // GAVL_LANGUAGE_TABLE_H
