/* $Id$ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __JE_HPP_INCLUDED
#define __JE_HPP_INCLUDED

#include "intermediate/opcodes/OpCode.hpp"
#include "intermediate/operands/Operand.hpp"
#include "intermediate/container/Label.hpp"
#include <cassert>

namespace intermediate {

//! jump equal
/** This class will perform a jump to given CodeContainer, if 
 *  the left operand is equal to the right operand.
 *
 *  Read Operands: left, right, trg
 *  Changes: /PC/
 *
 *  left operand: one comparison operand (any type allowed) (FIXME integer
 *  only?)
 *  right operand: idempotent comparision operand (any type allowed)
 *  trg: destination address (label only).
 *
 *  Operation: if (left == right) /PC/=trg
 */
class Je : public OpCode {
public:
	//! c'tor
	/** @param l left operand to compare
	 *  @param r right operand to compare
	 *  @param target jump to target, if l==r.
	 */
	Je(
		Operand *l, 
		Operand *r, 
		Label *target
		) :	left(l), right(r), trg(target) {

		assert(l->type == r->type);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! left operand
	Operand *left;
	//! right operand
	Operand *right;
	//! destination, if left==right.
	Label *trg;
}; 


}; /* namespace intermediate */

#endif /* __JE_HPP_INCLUDED */
