# SPDX-License-Identifier: MIT
# SPDX-FileCopyrightText: © 2004 Tristan Seligmann and Jonathan Jacobs
# SPDX-FileCopyrightText: © 2012 Bastian Kleineidam
# SPDX-FileCopyrightText: © 2015 Tobias Gruetzmacher
# SPDX-FileCopyrightText: © 2019 Daniel Ring
from ..scraper import Scraper


class Removed(Scraper):
    REASONS = {
        'jsh': 'Site is very JavaScript-heavy, writing a module would be' +
               ' very complicated.',
        'del': 'Comic was removed from the web.',
        'block': 'The comic site is blocking us.',
        'deny': "The comic doesn't want to be listed in Dosage (request from owner or robots.txt",
        'unk': 'Comic was removed for an unknown reason.',
        'brk': 'Comic navigation is broken.',
        'mov': 'Comic moved to a new hoster and no new module was written.',
        'mis': 'Pages are missing from the comic.',
        'acc': 'Account is needed to access site.',
        'legal': 'Comic was removed for legal reasons (fanrip, scanlation, etc.).',
    }

    def __init__(self, name, reason='del'):
        super(Removed, self).__init__(name)
        self.reason = reason

    def getDisabledReasons(self):
        return {'rem-' + self.reason: self.REASONS[self.reason]}

    @classmethod
    def getmodules(cls):
        return (
            # Removed in 2.16
            cls('AbleAndBaker'),
            cls('AlsoBagels'),
            cls('Antics'),
            cls('Arcamax/BleekerTheRechargeableDog'),
            cls('Arcamax/DeFlocked'),
            cls('Arcamax/TinasGroove'),
            cls('ASkeweredParadise'),
            cls('ASofterWorld', 'block'),
            cls('BackwaterPlanet'),
            cls('BigFatWhale'),
            cls('BizarreUprising'),
            cls('Blip'),
            cls('BoxerHockey'),
            cls('BoyOnAStickAndSlither', 'jsh'),
            cls('BrentalFloss'),
            cls('BrentalFloss/FlossedInTime'),
            cls('BrentalFloss/GuestComics'),
            cls('BrightlyWound'),
            cls('Caggage'),
            cls('Carciphona', 'jsh'),
            cls('Champ2010'),
            cls('CheckerboardNightmare'),
            # Patreon & Pixiv (https://www.patreon.com/Collar6)
            cls('Collar6', 'mov'),
            cls('ComicFury/30years'),
            cls('ComicFury/AAB'),
            cls('ComicFury/AdventuresofMaggie'),
            cls('ComicFury/Aether'),
            cls('ComicFury/Afairtrade'),
            cls('ComicFury/Afrodays'),
            cls('ComicFury/Albinobros'),
            cls('ComicFury/Alexanderandlucas'),
            cls('ComicFury/Alittlebitofeverything'),
            cls('ComicFury/Americanextremists'),
            cls('ComicFury/AmericanNerd'),
            cls('ComicFury/Amtheatre'),
            cls('ComicFury/Angstcomic'),
            cls('ComicFury/Applepine'),
            cls('ComicFury/Area42', 'mis'),
            cls('ComicFury/Atm'),
            cls('ComicFury/Atomicmonkey'),
            cls('ComicFury/Baseballcapsandtiaras'),
            cls('ComicFury/BATB'),
            cls('ComicFury/BetweenRounds'),
            cls('ComicFury/BigBookOfLameJokes'),
            cls('ComicFury/BiMorphon'),
            cls('ComicFury/Blessings'),
            cls('ComicFury/BrokenReality'),
            cls('ComicFury/BTTF'),
            cls('ComicFury/Cannonadeofhogwash'),
            cls('ComicFury/CatHero'),
            cls('ComicFury/Chocolava'),
            cls('ComicFury/ChristianHumberReloaded'),
            cls('ComicFury/Cockeyed'),
            cls('ComicFury/CoftheA'),
            cls('ComicFury/CompanyMan'),
            cls('ComicFury/Complicatedd'),
            cls('ComicFury/Conplicated'),
            cls('ComicFury/Crowbar'),
            cls('ComicFury/Crowbars'),
            cls('ComicFury/Curvyboneyosis'),
            cls('ComicFury/Dandk'),
            cls('ComicFury/Davidandtherobot'),
            cls('ComicFury/DenizensAttentionComic'),
            cls('ComicFury/Disturbingcomics'),
            cls('ComicFury/Docapoc'),
            cls('ComicFury/DucksMisery'),
            cls('ComicFury/Elfcomic'),
            cls('ComicFury/EMT'),
            cls('ComicFury/EternityC'),
            cls('ComicFury/Fathead'),
            cls('ComicFury/Fexpression'),
            cls('ComicFury/FireBorn2'),
            cls('ComicFury/Foxtales'),
            cls('ComicFury/Fpk'),
            cls('ComicFury/Ghostassassin'),
            cls('ComicFury/Gillimurphy'),
            cls('ComicFury/Glomshire'),
            cls('ComicFury/GodGames', 'mov'),
            cls('ComicFury/Goldrushdynllewcomics'),
            cls('ComicFury/Grandline3point5'),
            cls('ComicFury/Halloween2012'),
            cls('ComicFury/Halloween2013'),
            cls('ComicFury/HIRI'),
            cls('ComicFury/Hitmen'),
            cls('ComicFury/Honeyvenom'),
            cls('ComicFury/Insanitycorp'),
            cls('ComicFury/Inviziblecomixgroup'),
            cls('ComicFury/Isb'),
            cls('ComicFury/Its'),
            cls('ComicFury/Jenfferscartoonphotomanipulaion'),
            cls('ComicFury/Jenffersshow'),
            cls('ComicFury/Jeremy'),
            cls('ComicFury/Joysworldcomic'),
            cls('ComicFury/Judgedred'),
            cls('ComicFury/Jump2'),
            cls('ComicFury/Kachingcomic'),
            cls('ComicFury/Kazaandgwenna'),
            cls('ComicFury/Kevinzombie'),
            cls('ComicFury/Kindergardencrisis'),
            cls('ComicFury/Kirahitogame'),
            cls('ComicFury/Ladyspectra'),
            cls('ComicFury/Lastcallcomic'),
            cls('ComicFury/Lazy'),
            cls('ComicFury/Lena'),
            cls('ComicFury/Letitride'),
            cls('ComicFury/Lola2'),
            cls('ComicFury/LORDDARKE'),
            cls('ComicFury/Lp'),
            cls('ComicFury/LucidsDream'),
            cls('ComicFury/Lvl30psy'),
            cls('ComicFury/Maddog'),
            cls('ComicFury/Magisa'),
            cls('ComicFury/Midnightpeanutbutter'),
            cls('ComicFury/Minarga'),
            cls('ComicFury/MoizmadComix'),
            cls('ComicFury/Moths'),
            cls('ComicFury/MuttInTheMiddle'),
            cls('ComicFury/MyHorribleSite'),
            cls('ComicFury/Neighborscomic'),
            cls('ComicFury/Nojetpack'),
            cls('ComicFury/NoSongs'),
            cls('ComicFury/Nostalgiaofeden'),
            cls('ComicFury/Ocarinaoftim'),
            cls('ComicFury/OffHours'),
            cls('ComicFury/OldSchoolRasputinCatamite'),
            cls('ComicFury/Pandemonium'),
            cls('ComicFury/Paperstreamer'),
            cls('ComicFury/Peepsnperks'),
            cls('ComicFury/PersonaFTW'),
            cls('ComicFury/Pilgrimsprogress'),
            cls('ComicFury/PiratesLife'),
            cls('ComicFury/PobrePucho'),
            cls('ComicFury/Poussiere'),
            cls('ComicFury/Pt'),
            cls('ComicFury/Punch'),
            cls('ComicFury/Rangerrandom'),
            cls('ComicFury/Raspcat'),
            cls('ComicFury/RealLifeTrips'),
            cls('ComicFury/ReiketsuouNoKimi'),
            cls('ComicFury/RIDDICKQLOSSTALES'),
            cls('ComicFury/Romanjack'),
            cls('ComicFury/RPS'),
            cls('ComicFury/RPT'),
            cls('ComicFury/Rvr'),
            cls('ComicFury/Sarakleeyo'),
            cls('ComicFury/Sawbladersblacknuzlocke'),
            cls('ComicFury/Schizmatic'),
            cls('ComicFury/Seconds'),
            cls('ComicFury/Serengetti'),
            cls('ComicFury/SHADOWQUEEN'),
            cls('ComicFury/Shonenpunkremix'),
            cls('ComicFury/Sinjetpack'),
            cls('ComicFury/Spf1337'),
            cls('ComicFury/Sscomic'),
            cls('ComicFury/SteamSword'),
            cls('ComicFury/Teenagedragon'),
            cls('ComicFury/Theashes'),
            cls('ComicFury/TheButterflyEffect'),
            cls('ComicFury/Thecrease'),
            cls('ComicFury/TheGuardiansOfGrey'),
            cls('ComicFury/Tiziana'),
            cls('ComicFury/TwentyQuidAmusements'),
            cls('ComicFury/Underscore'),
            cls('ComicFury/ValtersRebellion'),
            cls('ComicFury/Wowwithatwistdamaclesandkejallcomic'),
            cls('ComicFury/YouAreNowEnteringAshburg'),
            cls('ComicGenesis/CryHavoc'),
            cls('ComicGenesis/IBlameDanny'),
            cls('ComicGenesis/SueosdelSur'),
            cls('Commissioned'),
            cls('CoolCatStudio'),
            cls('CowboyJedi', 'brk'),
            cls('Creators/BCinSpanish'),
            cls('Creators/GirlsandSportsinSpanish'),
            cls('Creators/Recess'),
            cls('Creators/RugratsinSpanish'),
            cls('CtrlAltDel/Sillies'),
            cls('DailyDose'),
            cls('DamnLol'),
            cls('DeathToTheExtremist'),
            cls('DoctorCat', 'brk'),
            cls('EerieCuties'),
            cls('Ellerbisms'),
            cls('Eriadan'),
            cls('EverydayBlues'),
            cls('FeyWinds'),
            cls('FilibusterCartoons'),
            cls('FowlLanguage', 'block'),
            cls('GlassHalfEmpty'),
            cls('GoComics/ABootsAndPupComic'),
            cls('GoComics/AdventuresofDaisy'),
            cls('GoComics/AdventuresofMartyandTurkey'),
            cls('GoComics/AdventuresofMikeAndSimon'),
            cls('GoComics/AgentGates'),
            cls('GoComics/AlisonWard'),
            cls('GoComics/AmaZnEvents'),
            cls('GoComics/AnythingGoes'),
            cls('GoComics/BCEnEspaol'),
            cls('GoComics/BenAndSeymour'),
            cls('GoComics/BeneaththeFerns'),
            cls('GoComics/BenSargent'),
            cls('GoComics/BERSERKALERT'),
            cls('GoComics/BestInShow'),
            cls('GoComics/BiffAndRiley'),
            cls('GoComics/BillyAndCo'),
            cls('GoComics/BlackboardDaze'),
            cls('GoComics/BobtheGroanUP'),
            cls('GoComics/Boogerbrain'),
            cls('GoComics/BotBrothers'),
            cls('GoComics/BrilliantMines'),
            cls('GoComics/BuffaloChips'),
            cls('GoComics/BuzzaWuzza'),
            cls('GoComics/CafConLeche'),
            cls('GoComics/CalAndOzz'),
            cls('GoComics/CandyPills'),
            cls('GoComics/Cartertoons'),
            cls('GoComics/ChanLowe'),
            cls('GoComics/ChasingUnicorns'),
            cls('GoComics/ChubbyGirlComics'),
            cls('GoComics/Classifudds'),
            cls('GoComics/CleoandCompany'),
            cls('GoComics/CockroachComix'),
            cls('GoComics/CoffeeShopTidbits'),
            cls('GoComics/Cortoons'),
            cls('GoComics/CowSheepandaGnomeNamedHelga'),
            cls('GoComics/DabneyandDad'),
            cls('GoComics/DevinCraneComicStripGhostwriter'),
            cls('GoComics/DialHforHBomb'),
            cls('GoComics/DitzAbledPrincess'),
            cls('GoComics/DoodleDaysComics'),
            cls('GoComics/Dromo'),
            cls('GoComics/EBEJeebie'),
            cls('GoComics/EDITORIALPASTANDPRESENT'),
            cls('GoComics/ElephantintheRoom'),
            cls('GoComics/EleriMaiHarrisCartoons'),
            cls('GoComics/ElfandMotorbelly'),
            cls('GoComics/ElMundoDeBeakman'),
            cls('GoComics/EngagAndNevets'),
            cls('GoComics/EspressoCity'),
            cls('GoComics/EttoreandBaldo'),
            cls('GoComics/FantasticMegaLeague'),
            cls('GoComics/FarcesofNature'),
            cls('GoComics/Featherweight'),
            cls('GoComics/FrankBlunt'),
            cls('GoComics/FrizziToons'),
            cls('GoComics/FundayMorning'),
            cls('GoComics/GatorsAndSuch'),
            cls('GoComics/GenerationMute'),
            cls('GoComics/GentleCreatures'),
            cls('GoComics/GetAGrip'),
            cls('GoComics/GlennMcCoy'),
            cls('GoComics/GoComicsontheRoad'),
            cls('GoComics/HamShears'),
            cls('GoComics/HanginOut'),
            cls('GoComics/HankandDalesOurWorld'),
            cls('GoComics/HanktheSock'),
            cls('GoComics/HarambeeHills'),
            cls('GoComics/Hbenson7'),
            cls('GoComics/HeadComics'),
            cls('GoComics/HIP'),
            cls('GoComics/HolidayDoodles'),
            cls('GoComics/HolySchnark'),
            cls('GoComics/HoodootheUnwiseOwl'),
            cls('GoComics/Humoresque'),
            cls('GoComics/ImaDillo'),
            cls('GoComics/ImTellingMom'),
            cls('GoComics/InheritTheMirth'),
            cls('GoComics/JackRadioComics'),
            cls('GoComics/JayAndBoneheadTheMunkysMrCowhide'),
            cls('GoComics/JustPosted'),
            cls('GoComics/KatetheGreat'),
            cls('GoComics/KirbysTreehouse'),
            cls('GoComics/KozmooftheCosmos'),
            cls('GoComics/LardWantsWorldPeace'),
            cls('GoComics/LarryvilleBlue'),
            cls('GoComics/Leadbellies'),
            cls('GoComics/LegendofBill'),
            cls('GoComics/LeGooseyLu'),
            cls('GoComics/LeighLunaComics'),
            cls('GoComics/LIGHTERSIDE'),
            cls('GoComics/LostInTranslation'),
            cls('GoComics/Lucan'),
            cls('GoComics/LucasLuminous'),
            cls('GoComics/Mac'),
            cls('GoComics/Markonpaper'),
            cls('GoComics/MaryBWary'),
            cls('GoComics/MassiveFalls'),
            cls('GoComics/McArroni'),
            cls('GoComics/Mick'),
            cls('GoComics/MidLifewAlan'),
            cls('GoComics/Millennialhood'),
            cls('GoComics/MinimumSecurity'),
            cls('GoComics/MixedMedications'),
            cls('GoComics/Molebashed'),
            cls('GoComics/Mortimer'),
            cls('GoComics/MrGigiAndTheSquid'),
            cls('GoComics/MrMorris'),
            cls('GoComics/Mulligan'),
            cls('GoComics/MyGuardianGrandpa'),
            cls('GoComics/NavyBean'),
            cls('GoComics/NeatStep'),
            cls('GoComics/NedAndLarry'),
            cls('GoComics/NeighborhoodZone'),
            cls('GoComics/NobodysHome'),
            cls('GoComics/NoPlaceLikeHolmes'),
            cls('GoComics/Norman'),
            cls('GoComics/Oat'),
            cls('GoComics/ObamaandtheFatman'),
            cls('GoComics/OntheQuad'),
            cls('GoComics/OrangesareFunny'),
            cls('GoComics/Outnumbered'),
            cls('GoComics/ParisDoodles'),
            cls('GoComics/Peanizles'),
            cls('GoComics/PetFood'),
            cls('GoComics/Pi'),
            cls('GoComics/PigtimesCartoon'),
            cls('GoComics/PipethePelican'),
            cls('GoComics/PlanB'),
            cls('GoComics/PlasticBabyHeadsfromOuterSpace'),
            cls('GoComics/PlentyofPenguins'),
            cls('GoComics/Poptropica'),
            cls('GoComics/Putz'),
            cls('GoComics/QuestionsForKids'),
            cls('GoComics/RandomActsofNancy'),
            cls('GoComics/RicigsToonTrivia'),
            cls('GoComics/RogueSymmetry'),
            cls('GoComics/Sabine'),
            cls('GoComics/SantavsDracula'),
            cls('GoComics/SCAIRYTALESTheNotSoScaryFairyTales'),
            cls('GoComics/Scurvyville'),
            cls('GoComics/SecondPrize'),
            cls('GoComics/Skooled'),
            cls('GoComics/SNAFU'),
            cls('GoComics/SouptoNutz'),
            cls('GoComics/SpaceNutz'),
            cls('GoComics/SPACESLUGS'),
            cls('GoComics/SpaceTimeFunnies'),
            cls('GoComics/Starslip'),
            cls('GoComics/STEPDAD'),
            cls('GoComics/Stookie'),
            cls('GoComics/SuburbanWilderness'),
            cls('GoComics/SuckerHeadSmack'),
            cls('GoComics/TeacherInk'),
            cls('GoComics/ThatMonkeyTune'),
            cls('GoComics/TheAcerbicCaf'),
            cls('GoComics/TheAdventuresofTeetyBallerina'),
            cls('GoComics/TheEdperiment'),
            cls('GoComics/TheFruitBowl'),
            cls('GoComics/TheGoldenKid'),
            cls('GoComics/TheInsolentLemon'),
            cls('GoComics/TheLightedLab'),
            cls('GoComics/TheLilMiesters'),
            cls('GoComics/TheOdderLimits'),
            cls('GoComics/THESILVERLINING'),
            cls('GoComics/TheSingleDadDiaries'),
            cls('GoComics/TheVernalPool'),
            cls('GoComics/TheWorstThingIveEverDone'),
            cls('GoComics/ThrompTM'),
            cls('GoComics/ToBeNamed'),
            cls('GoComics/TodaysDogg'),
            cls('GoComics/TonyAuth'),
            cls('GoComics/Toocrazy'),
            cls('GoComics/TOWHOMITMAYCONCERN'),
            cls('GoComics/Twaggies'),
            cls('GoComics/TwoBits'),
            cls('GoComics/Vernscartoons'),
            cls('GoComics/WayOutInLeftField'),
            cls('GoComics/WendlesLife'),
            cls('GoComics/Whatcatscanandcantdo'),
            cls('GoComics/WickedCrispy'),
            cls('GoComics/WindingRoads'),
            cls('GoComics/WitoftheWorld'),
            cls('GoComics/YouCanWithBeakmanAndJax'),
            cls('GoComics/YouGuysAreMyFriendsTheComic'),
            cls('GoComics/ZacharyNixonJohnson'),
            cls('GunnerkrigCourt'),
            cls('HorribleVille'),
            cls('JerkCity'),
            cls('KatzenfutterGeleespritzer'),
            cls('KeenSpot/Adventurers', 'mov'),
            cls('KeenSpot/Landis'),
            cls('Key'),
            cls('KillerKomics'),
            cls('Kukuburi'),
            cls('Lint'),
            cls('LinuxComFridayFunnies'),
            cls('NekkoAndJoruba'),
            cls('NekoTheKitty'),
            cls('NewAdventuresOfBobbin'),
            cls('Nnewts'),
            cls('OddFish'),
            cls('OneQuestion'),
            cls('OrnerBoy'),
            cls('PensAndTales/Evilish'),
            cls('PensAndTales/FireflyCross'),
            cls('PetiteSymphony/Kickinrad'),
            cls('PetiteSymphony/Orangegrind'),
            cls('PetiteSymphony/Seed'),
            cls('Pimpette'),
            cls('PunksAndNerds', 'mis'),
            cls('PunksAndNerdsOld'),
            cls('RedsPlanet'),
            cls('RedString'),
            cls('SmackJeeves/Aarrevaara'),
            cls('SmackJeeves/AchievementStuck'),
            cls('SmackJeeves/AGirlAndHerShadow'),
            cls('SmackJeeves/Allthatglitters'),
            cls('SmackJeeves/AloversRule'),
            cls('SmackJeeves/Anathemacomics'),
            cls('SmackJeeves/AngelBeast'),
            cls('SmackJeeves/ArchportCityChronicles'),
            # moved to www.mgcomics.com, which has a robots.txt for everything
            cls('SmackJeeves/Aware', 'block'),
            cls('SmackJeeves/AwesomeSauce'),
            cls('SmackJeeves/Babywhatsyoursign'),
            cls('SmackJeeves/BetweenLightandDark'),
            cls('SmackJeeves/BetweenWorlds'),
            cls('SmackJeeves/BeyondTemptation'),
            cls('SmackJeeves/BLDShortComics'),
            cls('SmackJeeves/Bloodyfairytale'),
            cls('SmackJeeves/BLOT'),
            cls('SmackJeeves/BlueWell'),
            cls('SmackJeeves/BreakfastonaCliff'),
            cls('SmackJeeves/CafeAmargo'),
            cls('SmackJeeves/Captor'),
            cls('SmackJeeves/ChaosTheory2005'),
            cls('SmackJeeves/CleanCure'),
            cls('SmackJeeves/DaddysGirl'),
            cls('SmackJeeves/DeadtoDay'),
            cls('SmackJeeves/Debtsettlement'),
            cls('SmackJeeves/DebtSettlement2OperationExtinction'),
            cls('SmackJeeves/DefyingGravityTheFourGreatGuardians'),
            cls('SmackJeeves/Destinationunknown'),
            cls('SmackJeeves/DevilTrainee'),
            cls('SmackJeeves/DevilTraineeSpanish'),
            cls('SmackJeeves/Diexemor'),
            cls('SmackJeeves/DigisRandomSpriteshack'),
            cls('SmackJeeves/DontDie'),
            cls('SmackJeeves/ElfenLiedDifferences'),
            cls('SmackJeeves/Entuthrie'),
            cls('SmackJeeves/EozinKadonnutKuningas'),
            cls('SmackJeeves/EpicChaos'),
            cls('SmackJeeves/EternalKnights'),
            cls('SmackJeeves/EvD'),
            cls('SmackJeeves/FatetheAnthologyofKaienandhisfuckingmagicfriends'),
            cls('SmackJeeves/FeathersPI'),
            cls('SmackJeeves/FemmeSchism'),
            cls('SmackJeeves/FireWire'),
            cls('SmackJeeves/FrenzyRedux'),
            cls('SmackJeeves/FrogKing'),
            cls('SmackJeeves/FuckMyLife'),
            cls('SmackJeeves/FurtherDowntheRabbitHole'),
            cls('SmackJeeves/GATEKEEPER'),
            cls('SmackJeeves/GearTheTakedown'),
            cls('SmackJeeves/GoldenSunGenerationsAftermathVolume1'),
            cls('SmackJeeves/GoldenSunGenerationsColossoVolume6'),
            cls('SmackJeeves/GraveImpressions'),
            cls('SmackJeeves/GreenKirbyandabunchofotherpeopledoinstuff'),
            cls('SmackJeeves/GuardianGhost'),
            cls('SmackJeeves/Harfang'),
            cls('SmackJeeves/HIPS'),
            cls('SmackJeeves/HitandMiss'),
            cls('SmackJeeves/HotChocolate'),
            cls('SmackJeeves/Hybristorific'),
            cls('SmackJeeves/Ianua'),
            cls('SmackJeeves/ImminentMoose'),
            cls('SmackJeeves/InthePride'),
            cls('SmackJeeves/Intoxicated'),
            cls('SmackJeeves/Jantarpol'),
            cls('SmackJeeves/Knife'),
            cls('SmackJeeves/Kranburn'),
            cls('SmackJeeves/KuroNeko'),
            cls('SmackJeeves/LastLivingSouls'),
            cls('SmackJeeves/LegendsofMobiusBookOne'),
            cls('SmackJeeves/LetsBreakitforReals'),
            cls('SmackJeeves/LiliBleu'),
            cls('SmackJeeves/LoveTwister'),
            cls('SmackJeeves/MagicalGirlAlice'),
            cls('SmackJeeves/MasqueradeWTTM'),
            cls('SmackJeeves/MegaManBattleNetwork7'),
            cls('SmackJeeves/MegaManiacs'),
            cls('SmackJeeves/MerirosvotSeikkailumerella'),
            cls('SmackJeeves/MewsDynasty'),
            cls('SmackJeeves/MixupofallMixups'),
            cls('SmackJeeves/MomthegamestorerippedusoffAGAIN'),
            cls('SmackJeeves/MoonlitDawnAMythicalTale'),
            cls('SmackJeeves/MUTE', 'mov'),
            cls('SmackJeeves/MyBoyfriendisaMobBoss'),
            cls('SmackJeeves/MyTrollLife'),
            cls('SmackJeeves/MyTwoCentsPlusTax'),
            cls('SmackJeeves/NeoCrystalAdventures'),
            cls('SmackJeeves/NihilWandasJourney'),
            cls('SmackJeeves/OddContact'),
            cls('SmackJeeves/Ohman', 'brk'),
            cls('SmackJeeves/OneFrameGags'),
            cls('SmackJeeves/Pahantekija'),
            cls('SmackJeeves/Paradox'),
            cls('SmackJeeves/Paripety'),
            cls('SmackJeeves/Perinto'),
            cls('SmackJeeves/PerplexingMagnoliaDisruption', 'mov'),
            cls('SmackJeeves/PlatonicBoyfriends'),
            cls('SmackJeeves/Plotlessnesses'),
            cls('SmackJeeves/PokemonGleamingCrystal', 'mis'),
            cls('SmackJeeves/PokemonMysteryDungeonTeamCrystal'),
            cls('SmackJeeves/PRAGUERACE'),
            cls('SmackJeeves/PumpkinFlower'),
            cls('SmackJeeves/Razor'),
            cls('SmackJeeves/RedVelvetRequiem'),
            cls('SmackJeeves/RuderiQuest'),
            cls('SmackJeeves/SAKANA'),
            cls('SmackJeeves/SenoireDelirium'),
            cls('SmackJeeves/SerendipityAnEquestrianTale'),
            cls('SmackJeeves/ShacklesInstallment02'),
            cls('SmackJeeves/SimonSues'),
            cls('SmackJeeves/SimplySarah'),
            cls('SmackJeeves/SomebodyShootMe'),
            cls('SmackJeeves/SonicUniverseAsk'),
            cls('SmackJeeves/SoulGuardian'),
            cls('SmackJeeves/SpaghettiAndMeatballs'),
            cls('SmackJeeves/SparkStory', 'mis'),
            cls('SmackJeeves/Spidersilk', 'mov'),
            cls('SmackJeeves/Symbios'),
            cls('SmackJeeves/TechnicolorLondon'),
            cls('SmackJeeves/TeKscloset'),
            cls('SmackJeeves/TheAttackoftheRecoloursSeason1'),
            cls('SmackJeeves/TheAvianStories'),
            cls('SmackJeeves/TheCurtandTonyShow'),
            cls('SmackJeeves/TheDarkAgeofMobius'),
            cls('SmackJeeves/TheHobbitbic'),
            cls('SmackJeeves/ThehumanBEing'),
            cls('SmackJeeves/TheKeyToReality'),
            cls('SmackJeeves/TheLostland'),
            cls('SmackJeeves/TheMewExperiment'),
            cls('SmackJeeves/TheMoistTouch'),
            cls('SmackJeeves/TheRandomObscureFairyTaleNoOnesEverReallyHeardOf'),
            cls('SmackJeeves/TheSomewhereOther'),
            cls('SmackJeeves/TheWastelands', 'mis'),
            cls('SmackJeeves/ThinkBeforeYouThink', 'mov'),
            cls('SmackJeeves/ThroughTheWonkyEye'),
            cls('SmackJeeves/TitleUnrelated'),
            cls('SmackJeeves/TotalPokemonIsland'),
            cls('SmackJeeves/TrillyAndSilly'),
            cls('SmackJeeves/TRIPP'),
            cls('SmackJeeves/VampireFetish'),
            cls('SmackJeeves/WolfWolf'),
            cls('SmackJeeves/WonderTheatre'),
            cls('SmackJeeves/YouAreTheReasonForTheEndOfTheWorld'),
            cls('SnowFlakes'),
            cls('StrawberryDeathCake'),
            cls('Stubble'),
            cls('SuburbanTribe'),
            cls('TheOuterQuarter'),
            cls('TheParkingLotIsFull'),
            cls('TheThinHLine', 'acc'),
            cls('ThunderAndLightning'),
            cls('TinyKittenTeeth'),
            cls('TwoTwoOneFour'),
            cls('VampireCheerleaders'),
            cls('WayfarersMoon'),
            cls('WebcomicEu/Talandor'),
            cls('WebcomicEu/TheBessEffect'),
            cls('WebcomicEu/TheBessEffectEnglish'),
            cls('WebcomicsNation/AgnesQuill'),
            cls('WebcomicsNation/MyMuse'),
            cls('WebcomicsNation/NekkoAndJoruba'),
            cls('WeCanSleepTomorrow'),
            cls('WhiteNinja'),
            cls('WLP/ShadowChasers'),
            cls('WotNow'),

            # Removed in 3.0
            cls('ComicFury/AdventuresOftheGreatCaptainMaggieandCrew'),
            cls('ComicFury/AWAKENING'),
            cls('ComicFury/Beebleville'),
            cls('ComicFury/BloodLegaciesEternity'),
            cls('ComicFury/CharlesAndViktor'),
            cls('ComicFury/DemonWings'),
            cls('ComicFury/DnDDumbAndDumber'),
            cls('ComicFury/DoodlelandComics'),
            cls('ComicFury/Elements'),
            cls('ComicFury/FairyDust'),
            cls('ComicFury/FandomMisadventures'),
            cls('ComicFury/GreenerGrass'),
            cls('ComicFury/HelloWanderingStar'),
            cls('ComicFury/HINATATheDemonSlayer'),
            cls('ComicFury/Hodgemosh'),
            cls('ComicFury/Imp'),
            cls('ComicFury/Kitsune'),
            cls('ComicFury/LaszloAndEdgar'),
            cls('ComicFury/Maluk'),
            cls('ComicFury/MegamanComic'),
            cls('ComicFury/Mischeif'),
            cls('ComicFury/OceanLabyrinth'),
            cls('ComicFury/PatchworkPeople'),
            cls('ComicFury/PlanetChaser'),
            cls('ComicFury/PornographyInFiveActs'),
            cls('ComicFury/PoussireDeFe'),
            cls('ComicFury/RadioMustard'),
            cls('ComicFury/RaytoonsKids'),
            cls('ComicFury/RED'),
            cls('ComicFury/ResNullius'),
            cls('ComicFury/ResNulliusCS'),
            cls('ComicFury/Seed'),
            cls('ComicFury/SixteenCandlesHuntersAgency'),
            cls('ComicFury/TheAcryden'),
            cls('ComicFury/TheHourlyComic'),
            cls('ComicFury/TheKAMics'),
            cls('ComicFury/TheUnthinkableHybrid'),
            cls('ComicFury/TwentyFourSeven'),
            cls('ComicFury/TwentyFourSevenFans'),
            cls('ComicSherpa/060'),
            cls('ComicSherpa/AaronGuile'),
            cls('ComicSherpa/ABCStreet'),
            cls('ComicSherpa/ABitSketch'),
            cls('ComicSherpa/ABomb'),
            cls('ComicSherpa/ACMEINKD'),
            cls('ComicSherpa/AcornPark'),
            cls('ComicSherpa/Adulting'),
            cls('ComicSherpa/AllInGoodTime'),
            cls('ComicSherpa/AmandaTheGreat'),
            cls('ComicSherpa/AndNow'),
            cls('ComicSherpa/Anecdote'),
            cls('ComicSherpa/AnimalMitchell'),
            cls('ComicSherpa/AnneAndPythagoras'),
            cls('ComicSherpa/AppleCreekComics'),
            cls('ComicSherpa/ATasteOfTimes'),
            cls('ComicSherpa/BatchRejection'),
            cls('ComicSherpa/Bazoobee'),
            cls('ComicSherpa/BeMisery'),
            cls('ComicSherpa/BigJim'),
            cls('ComicSherpa/Bluebonnets'),
            cls('ComicSherpa/BlueSkiesToons'),
            cls('ComicSherpa/BobsYourUncle'),
            cls('ComicSherpa/BoltsAndNuts'),
            cls('ComicSherpa/Bork'),
            cls('ComicSherpa/BottAuto'),
            cls('ComicSherpa/BUNS'),
            cls('ComicSherpa/Bushscrubs'),
            cls('ComicSherpa/CAFFEINATED'),
            cls('ComicSherpa/CandacenCompany'),
            cls('ComicSherpa/CarteBlanche'),
            cls('ComicSherpa/CharmysArmy'),
            cls('ComicSherpa/Complex'),
            cls('ComicSherpa/CourageousManAdventures'),
            cls('ComicSherpa/DadsDay'),
            cls('ComicSherpa/DBCartoons'),
            cls('ComicSherpa/DoghouseInYourSoul'),
            cls('ComicSherpa/DoingTime'),
            cls('ComicSherpa/DontPickTheFlowers'),
            cls('ComicSherpa/Dragin'),
            cls('ComicSherpa/DumbQuestionBadAnswer'),
            cls('ComicSherpa/DungeonHordes'),
            cls('ComicSherpa/DustSpecks'),
            cls('ComicSherpa/DutchnPals'),
            cls('ComicSherpa/Econogirl'),
            cls('ComicSherpa/EightballEyeball'),
            cls('ComicSherpa/Elmo'),
            cls('ComicSherpa/Endangered'),
            cls('ComicSherpa/FamousAndNotSoFamousQuotes'),
            cls('ComicSherpa/FarOut'),
            cls('ComicSherpa/FatherOfTheBrood'),
            cls('ComicSherpa/FoxTheCat'),
            cls('ComicSherpa/FrankAndSteinway'),
            cls('ComicSherpa/FriedCritter'),
            cls('ComicSherpa/GarciaCartoonCo'),
            cls('ComicSherpa/GIRTH'),
            cls('ComicSherpa/GrandmaSnoops'),
            cls('ComicSherpa/GrannyAnny'),
            cls('ComicSherpa/GreenPieces'),
            cls('ComicSherpa/GunstonStreet'),
            cls('ComicSherpa/HallEditorialCartoons'),
            cls('ComicSherpa/HaphazardHumor'),
            cls('ComicSherpa/Headcheese'),
            cls('ComicSherpa/Hogwashed'),
            cls('ComicSherpa/HomeLife'),
            cls('ComicSherpa/Hubbel'),
            cls('ComicSherpa/HugoComics'),
            cls('ComicSherpa/HurrieTheMisManager'),
            cls('ComicSherpa/HuskyTales'),
            cls('ComicSherpa/InkwellForest'),
            cls('ComicSherpa/IronyOr'),
            cls('ComicSherpa/ItsJustJim'),
            cls('ComicSherpa/JolleyStuffBrowser'),
            cls('ComicSherpa/KALEECHIKORNERS'),
            cls('ComicSherpa/KartoonsByKline'),
            cls('ComicSherpa/LaffToons'),
            cls('ComicSherpa/LiliAndDerek'),
            cls('ComicSherpa/LilleysSillies'),
            cls('ComicSherpa/LimboRoad'),
            cls('ComicSherpa/LumAndAbner'),
            cls('ComicSherpa/MarysNature'),
            cls('ComicSherpa/Millennialville'),
            cls('ComicSherpa/Milton50'),
            cls('ComicSherpa/Mindframe'),
            cls('ComicSherpa/Minihahas'),
            cls('ComicSherpa/MiscSoup'),
            cls('ComicSherpa/MisterAndMe'),
            cls('ComicSherpa/MockAll'),
            cls('ComicSherpa/Moments'),
            cls('ComicSherpa/Mongrels'),
            cls('ComicSherpa/MortsIsland'),
            cls('ComicSherpa/MySonIsADog'),
            cls('ComicSherpa/NoAmbiguity'),
            cls('ComicSherpa/NoBusinessIKnow'),
            cls('ComicSherpa/NoOrdinaryLife'),
            cls('ComicSherpa/Npchumorcom'),
            cls('ComicSherpa/OneFunnyGoldenRetriever'),
            cls('ComicSherpa/ONIONAndPEA'),
            cls('ComicSherpa/OscarAndAnnie'),
            cls('ComicSherpa/OverQuirked'),
            cls('ComicSherpa/PaddedCell'),
            cls('ComicSherpa/Painterly'),
            cls('ComicSherpa/PalAndBuddy'),
            cls('ComicSherpa/PawsForThoughtComics'),
            cls('ComicSherpa/Peeples'),
            cls('ComicSherpa/PeopleOfEarth'),
            cls('ComicSherpa/PicpakDog'),
            cls('ComicSherpa/PirateMike'),
            cls('ComicSherpa/PoliceLimit'),
            cls('ComicSherpa/PoliticularJokesAndRuffus'),
            cls('ComicSherpa/Prideland'),
            cls('ComicSherpa/PrimusTheBadPhilosopher'),
            cls('ComicSherpa/ProfessorHerbertAndGEO'),
            cls('ComicSherpa/QueenBlackbeard'),
            cls('ComicSherpa/QuickDraw'),
            cls('ComicSherpa/RandysRationale'),
            cls('ComicSherpa/Ringers'),
            cls('ComicSherpa/RonWarren'),
            cls('ComicSherpa/SandSharkBeach'),
            cls('ComicSherpa/SharpCurveComics'),
            cls('ComicSherpa/SherpaAid'),
            cls('ComicSherpa/SignGarden'),
            cls('ComicSherpa/SignsOfAFrustratedGolfer'),
            cls('ComicSherpa/Skull'),
            cls('ComicSherpa/Skylarking'),
            cls('ComicSherpa/SleepytownBeagles'),
            cls('ComicSherpa/SmallNerdyCreatures'),
            cls('ComicSherpa/Smith'),
            cls('ComicSherpa/Snootle'),
            cls('ComicSherpa/SoccerDude'),
            cls('ComicSherpa/SoccerEarth'),
            cls('ComicSherpa/SOD'),
            cls('ComicSherpa/SomethingAboutCeleste'),
            cls('ComicSherpa/SookyRottweiler'),
            cls('ComicSherpa/Spaceport51'),
            cls('ComicSherpa/SportsByVoort'),
            cls('ComicSherpa/StaleCrackers'),
            cls('ComicSherpa/StankoAndTibor'),
            cls('ComicSherpa/Strangeville'),
            cls('ComicSherpa/SubSub'),
            cls('ComicSherpa/SuburbanFairyTales'),
            cls('ComicSherpa/SUITSANDGUARDERS'),
            cls('ComicSherpa/SuperSiblings'),
            cls('ComicSherpa/TheBeauforts'),
            cls('ComicSherpa/TheBellies'),
            cls('ComicSherpa/TheBoobiehatch'),
            cls('ComicSherpa/TheCardinal'),
            cls('ComicSherpa/TheDinkledorfs'),
            cls('ComicSherpa/TheFabulousBushPigs'),
            cls('ComicSherpa/TheGrayZone'),
            cls('ComicSherpa/TheGreenMonkeys'),
            cls('ComicSherpa/TheMagicForest'),
            cls('ComicSherpa/TheMothManAndLarvaeBoy'),
            cls('ComicSherpa/TheMountainMen'),
            cls('ComicSherpa/TheNeighborhood'),
            cls('ComicSherpa/TheNevilleYouKnow'),
            cls('ComicSherpa/TheNonsenseNewz'),
            cls('ComicSherpa/TheOldManAndHisDog'),
            cls('ComicSherpa/TheQuinnAndFinnShow'),
            cls('ComicSherpa/TheRocks'),
            cls('ComicSherpa/TheUnemployed'),
            cls('ComicSherpa/Thingsesque'),
            cls('ComicSherpa/TodaysTrump'),
            cls('ComicSherpa/TopicToons'),
            cls('ComicSherpa/ToughTown'),
            cls('ComicSherpa/ToxicValues'),
            cls('ComicSherpa/TruthBeKnown'),
            cls('ComicSherpa/TuesdaysWithCory'),
            cls('ComicSherpa/Underdone'),
            cls('ComicSherpa/UnMannerlyWays'),
            cls('ComicSherpa/ViewFromTheCouch'),
            cls('ComicSherpa/VoicesInTheDark'),
            cls('ComicSherpa/WarpedAndDemented'),
            cls('ComicSherpa/Waskataskahiskewaskewan'),
            cls('ComicSherpa/WayOutComics'),
            cls('ComicSherpa/WeaselInk'),
            cls('ComicSherpa/WhiskeyFalls'),
            cls('ComicSherpa/Windsock'),
            cls('ComicSherpa/WrobbertCartoons'),
            cls('ComicSherpa/YinYangster'),
            cls('ComicSherpa/ZombieHeights'),
            cls('ComicSherpa/Zootopia'),
            cls('ComicsKingdom/BabyBlues'),
            cls('ComicsKingdom/BettyBoopSundays'),
            cls('ComicsKingdom/Buckles'),
            cls('ComicsKingdom/JohnnyHazardSundays'),
            cls('ComicsKingdom/Redeye'),
            cls('ComicsKingdom/RedeyeSundays'),
            cls('CrapIDrewOnMyLunchBreak'),
            cls('GoComics/060'),
            cls('GoComics/2CowsAndAChicken'),
            cls('GoComics/ABitSketch'),
            cls('GoComics/AmericanChopSuey'),
            cls('GoComics/Andnow'),
            cls('GoComics/Anecdote'),
            cls('GoComics/AppleCreekComics'),
            cls('GoComics/AskACat'),
            cls('GoComics/AskAPortlySyndicatePerson'),
            cls('GoComics/BabyTrump'),
            cls('GoComics/BadReporter'),
            cls('GoComics/BarkingCrayon'),
            cls('GoComics/Bazoobee'),
            cls('GoComics/Bewley'),
            cls('GoComics/Biographic'),
            cls('GoComics/Bluebonnets'),
            cls('GoComics/BlueSkiesToons'),
            cls('GoComics/BottAuto'),
            cls('GoComics/BrainSquirts'),
            cls('GoComics/BUNS'),
            cls('GoComics/BushyTales'),
            cls('GoComics/CAFFEINATED'),
            cls('GoComics/CapsulasMedicas'),
            cls('GoComics/CharmysArmy'),
            cls('GoComics/CheapThrillsCuisine'),
            cls('GoComics/ClearBlueWater'),
            cls('GoComics/Committed'),
            cls('GoComics/ConnieToTheWonnie'),
            cls('GoComics/CourageousManAdventures'),
            cls('GoComics/DanWasserman'),
            cls('GoComics/DontPicktheFlowers'),
            cls('GoComics/DorrisMcComics'),
            cls('GoComics/Dragin'),
            cls('GoComics/DragonGirl'),
            cls('GoComics/Drive'),
            cls('GoComics/DudeAndDude'),
            cls('GoComics/DumbQuestionBadAnswer'),
            cls('GoComics/DustSpecks'),
            cls('GoComics/Econogirl'),
            cls('GoComics/EdgeOfAdventure'),
            cls('GoComics/Elmo'),
            cls('GoComics/EricTheCircle'),
            cls('GoComics/FacesOfTheNewsByKerryWaghorn'),
            cls('GoComics/FarOut'),
            cls('GoComics/FortKnox'),
            cls('GoComics/FrankAndSteinway'),
            cls('GoComics/FriedCritter'),
            cls('GoComics/GarciaCartoonCo'),
            cls('GoComics/GarfieldMinusGarfield'),
            cls('GoComics/GIRTH'),
            cls('GoComics/GnomeSyndicate'),
            cls('GoComics/GoComicsFanArt'),
            cls('GoComics/Graffiti'),
            cls('GoComics/GrannyAnny'),
            cls('GoComics/GreenPieces'),
            cls('GoComics/GunstonStreet'),
            cls('GoComics/HaikuEwe'),
            cls('GoComics/Headcheese'),
            cls('GoComics/HealthCapsules'),
            cls('GoComics/HowToCat'),
            cls('GoComics/HUBRIS'),
            cls('GoComics/HumanCull'),
            cls('GoComics/InspectorDangersCrimeQuiz'),
            cls('GoComics/ItsjustJim'),
            cls('GoComics/JerryHolbert'),
            cls('GoComics/JillpokeBohemia'),
            cls('GoComics/JimsJournal'),
            cls('GoComics/JoeVanilla'),
            cls('GoComics/JoeyAlisonSayersComics'),
            cls('GoComics/JustSayUncle'),
            cls('GoComics/KartoonsByKline'),
            cls('GoComics/KenCatalino'),
            cls('GoComics/KidSpot'),
            cls('GoComics/KidTown'),
            cls('GoComics/KitNCarlyle'),
            cls('GoComics/LostSideOfSuburbia'),
            cls('GoComics/LumandAbner'),
            cls('GoComics/MagicInAMinute'),
            cls('GoComics/Magnificatz'),
            cls('GoComics/MazeToonsPuzzle'),
            cls('GoComics/MegClassics'),
            cls('GoComics/MichaelAndrew'),
            cls('GoComics/Microcosm'),
            cls('GoComics/Millennialville'),
            cls('GoComics/Milton50'),
            cls('GoComics/Mindframe'),
            cls('GoComics/MiscSoup'),
            cls('GoComics/MisterAndMe'),
            cls('GoComics/Mo'),
            cls('GoComics/MomsCancer'),
            cls('GoComics/MortsIsland'),
            cls('GoComics/MustardAndBoloney'),
            cls('GoComics/MyCage'),
            cls('GoComics/MyCageNewAndOld'),
            cls('GoComics/NoOrdinaryLife'),
            cls('GoComics/ONIONAndPEA'),
            cls('GoComics/PaddedCell'),
            cls('GoComics/PaulSzep'),
            cls('GoComics/Peeples'),
            cls('GoComics/PicturesInBoxes'),
            cls('GoComics/PieComic'),
            cls('GoComics/Pinkerton'),
            cls('GoComics/PirateMike'),
            cls('GoComics/PoliceLimit'),
            cls('GoComics/PopCultureShockTherapy'),
            cls('GoComics/PromisesPromises'),
            cls('GoComics/ReplyAll'),
            cls('GoComics/ReplyAllLite'),
            cls('GoComics/RonWarren'),
            cls('GoComics/Sheldon'),
            cls('GoComics/Shoecabbage'),
            cls('GoComics/Shortcuts'),
            cls('GoComics/ShutterbugFollies'),
            cls('GoComics/SignGarden'),
            cls('GoComics/SleepytownBeagles'),
            cls('GoComics/SmallNerdyCreatures'),
            cls('GoComics/Smith'),
            cls('GoComics/SoccerEarth'),
            cls('GoComics/SookyRottweiler'),
            cls('GoComics/Speechless'),
            cls('GoComics/SportsbyVoort'),
            cls('GoComics/StankoAndTibor'),
            cls('GoComics/Starling'),
            cls('GoComics/SubSub'),
            cls('GoComics/SuburbanFairyTales'),
            cls('GoComics/SuperSiblings'),
            cls('GoComics/ThatsLife'),
            cls('GoComics/TheBeauforts'),
            cls('GoComics/TheBentPinky'),
            cls('GoComics/TheBestMedicineCartoon'),
            cls('GoComics/TheBoobiehatch'),
            cls('GoComics/TheCardinal'),
            cls('GoComics/TheConjurers'),
            cls('GoComics/TheCreeps'),
            cls('GoComics/TheGentlemansArmchair'),
            cls('GoComics/TheGreenMonkeys'),
            cls('GoComics/TheLastMechanicalMonster'),
            cls('GoComics/TheLeftyBoscoPictureShow'),
            cls('GoComics/TheLostBear'),
            cls('GoComics/TheNorm40'),
            cls('GoComics/TheOldManAndHisDog'),
            cls('GoComics/TheOtherEnd'),
            cls('GoComics/TheQuinnAndFinnShow'),
            cls('GoComics/TheQuixoteSyndrome'),
            cls('GoComics/TheSunshineClub'),
            cls('GoComics/Thingsesque'),
            cls('GoComics/TimEagan'),
            cls('GoComics/TOBY'),
            cls('GoComics/ToughTown'),
            cls('GoComics/Trivquiz'),
            cls('GoComics/UncleArtsFunland'),
            cls('GoComics/USAcres'),
            cls('GoComics/WayOutComics'),
            cls('GoComics/WhiskeyFalls'),
            cls('GoComics/WhyattCartoons'),
            cls('GoComics/Winston'),
            cls('GoComics/WorldOfWonder'),
            cls('GoComics/Wrobbertcartoons'),
            cls('GoComics/Zootopia'),
            cls('JustAnotherEscape'),
            cls('Laiyu', 'brk'),
            cls('MangaDex/DrStone', 'legal'),
            cls('MangaDex/HeavensDesignTeam', 'legal'),
            cls('MangaDex/SPYxFAMILY', 'legal'),
            cls('Ryugou'),
            cls('SeelPeel'),
            cls('Shivae/CafeAnime'),
            cls('Shivae/Extras'),
            cls('SmackJeeves/20TimesKirby'),
            cls('SmackJeeves/2Kingdoms'),
            cls('SmackJeeves/355Days'),
            cls('SmackJeeves/_A_'),
            cls('SmackJeeves/AB'),
            cls('SmackJeeves/AceOfHearts'),
            cls('SmackJeeves/AcidMonday'),
            cls('SmackJeeves/Adalsysla'),
            cls('SmackJeeves/ADoodleADay'),
            cls('SmackJeeves/AdventuresOfLumAndFriends'),
            cls('SmackJeeves/AdventuresoftheWeird'),
            cls('SmackJeeves/AetherTheories'),
            cls('SmackJeeves/AgeOfTheGray'),
            cls('SmackJeeves/AGirlOnTheServer'),
            cls('SmackJeeves/AKirbyKomic'),
            cls('SmackJeeves/ALaMode'),
            cls('SmackJeeves/AllInLOVE'),
            cls('SmackJeeves/AllStarHeroes'),
            cls('SmackJeeves/AlmostTouching'),
            cls('SmackJeeves/AlwaysDamnedWebcomic'),
            cls('SmackJeeves/AlwaysRainingHere'),
            cls('SmackJeeves/Amaravati'),
            cls('SmackJeeves/AmorVincitOmnia'),
            cls('SmackJeeves/AmsdenEstate'),
            cls('SmackJeeves/AngelGuardian'),
            cls('SmackJeeves/ANGELOU'),
            cls('SmackJeeves/AnimalAdventures'),
            cls('SmackJeeves/Animayhem'),
            cls('SmackJeeves/AnythingAboutNothing'),
            cls('SmackJeeves/APTComic'),
            cls('SmackJeeves/AQuestionOfCharacter'),
            cls('SmackJeeves/Area9'),
            cls('SmackJeeves/AroundTheBlock'),
            cls('SmackJeeves/ArtOfAFantasy'),
            cls('SmackJeeves/ASongforElise'),
            cls('SmackJeeves/AtArmsLength'),
            cls('SmackJeeves/Atlaswebcomic'),
            cls('SmackJeeves/Autophobia'),
            cls('SmackJeeves/AyaTakeo'),
            cls('SmackJeeves/AYuriCollab'),
            cls('SmackJeeves/BabysittingFourDemons'),
            cls('SmackJeeves/BadassRiz'),
            cls('SmackJeeves/BallandChain'),
            cls('SmackJeeves/Bard'),
            cls('SmackJeeves/BassComicAdventures'),
            cls('SmackJeeves/BattleSequence'),
            cls('SmackJeeves/Bearhoney'),
            cls('SmackJeeves/BearlyAbel'),
            cls('SmackJeeves/BeautifulLies'),
            cls('SmackJeeves/BehindTheGlassCurtain'),
            cls('SmackJeeves/BehindTheObsidianMirror'),
            cls('SmackJeeves/BeretCatComics'),
            cls('SmackJeeves/Bestbrosforever'),
            cls('SmackJeeves/Betovering'),
            cls('SmackJeeves/BettencourtHotel'),
            cls('SmackJeeves/BeTwin'),
            cls('SmackJeeves/BeyondTheOrdinary'),
            cls('SmackJeeves/BioRevelation'),
            cls('SmackJeeves/Bl3'),
            cls('SmackJeeves/BlackAndBlue'),
            cls('SmackJeeves/Blackdemon'),
            cls('SmackJeeves/BlackDragon'),
            cls('SmackJeeves/BlackFridayRule'),
            cls('SmackJeeves/BlackSheepcomic'),
            cls('SmackJeeves/BleachRedux'),
            cls('SmackJeeves/BlindandBlue'),
            cls('SmackJeeves/BloodhuntersBirthOfAVampire'),
            cls('SmackJeeves/BloomAPokemonConquestComic'),
            cls('SmackJeeves/BlueHair'),
            cls('SmackJeeves/BoilingPointofBrain'),
            cls('SmackJeeves/BoogeyDancingMonkeyPot'),
            cls('SmackJeeves/BreachOfAgency'),
            cls('SmackJeeves/Burn'),
            cls('SmackJeeves/CafeSuada'),
            cls('SmackJeeves/Cambion'),
            cls('SmackJeeves/CaptiveSoul'),
            cls('SmackJeeves/Captured'),
            cls('SmackJeeves/CaravanaTaleofGodsandMen'),
            cls('SmackJeeves/Cataclysm'),
            cls('SmackJeeves/Catnip'),
            cls('SmackJeeves/Cerintha'),
            cls('SmackJeeves/ChampionofChampions'),
            cls('SmackJeeves/ChampionsAndHeroesAgeOfDragons'),
            cls('SmackJeeves/ChannelDDDNews'),
            cls('SmackJeeves/ChaosAdventuresII'),
            cls('SmackJeeves/ChaoticNation'),
            cls('SmackJeeves/Charaktermaske'),
            cls('SmackJeeves/Chatuplines'),
            cls('SmackJeeves/CheneysGotaGun'),
            cls('SmackJeeves/ChickenScratches'),
            cls('SmackJeeves/ChildrenOfTheNight'),
            cls('SmackJeeves/ChimiMouryou'),
            cls('SmackJeeves/ChocolatewithPepper'),
            cls('SmackJeeves/ClairetheFlare'),
            cls('SmackJeeves/ClockworkAtrium'),
            cls('SmackJeeves/CloeRemembrance'),
            cls('SmackJeeves/CockroachTheater'),
            cls('SmackJeeves/Cogs'),
            cls('SmackJeeves/ColorBlind'),
            cls('SmackJeeves/ConventionalWisdom'),
            cls('SmackJeeves/CosmicDash'),
            cls('SmackJeeves/Cramberries'),
            cls('SmackJeeves/CrimsonWings'),
            cls('SmackJeeves/CrocodileTears'),
            cls('SmackJeeves/CupOfOlea'),
            cls('SmackJeeves/CurseLineage'),
            cls('SmackJeeves/DanielleDark'),
            cls('SmackJeeves/Dasien'),
            cls('SmackJeeves/DavidDoesntGetIt'),
            cls('SmackJeeves/DBON'),
            cls('SmackJeeves/DeathNoteIridescent'),
            cls('SmackJeeves/DEGAF'),
            cls('SmackJeeves/DEMENTED'),
            cls('SmackJeeves/DemonBattles'),
            cls('SmackJeeves/DemonCat'),
            cls('SmackJeeves/DemonEater'),
            cls('SmackJeeves/DenizensAttention'),
            cls('SmackJeeves/DevilsCake'),
            cls('SmackJeeves/DevotoMusicinHell'),
            cls('SmackJeeves/Diaz'),
            cls('SmackJeeves/DigimonSaviors'),
            cls('SmackJeeves/DigimonTamersMiraiProject'),
            cls('SmackJeeves/DigitalInsanity'),
            cls('SmackJeeves/DoItYourself'),
            cls('SmackJeeves/DoodleBeans'),
            cls('SmackJeeves/DoodlingAround'),
            cls('SmackJeeves/Dragonet'),
            cls('SmackJeeves/DragonKid'),
            cls('SmackJeeves/DreamCatcher'),
            cls('SmackJeeves/DumpofManyPeople'),
            cls('SmackJeeves/DungeonHordes'),
            cls('SmackJeeves/EATATAU'),
            cls('SmackJeeves/EDepthAngel'),
            cls('SmackJeeves/EidolonWhispersOfEternity'),
            cls('SmackJeeves/ElementalSpirits'),
            cls('SmackJeeves/EnkeltenKentta'),
            cls('SmackJeeves/Enthrall'),
            cls('SmackJeeves/EntreEuxDeux'),
            cls('SmackJeeves/Eorah'),
            cls('SmackJeeves/Equsopia'),
            cls('SmackJeeves/ERAConvergence'),
            cls('SmackJeeves/ERAIbuki'),
            cls('SmackJeeves/ERRORERROR'),
            cls('SmackJeeves/EuphemisticEephus'),
            cls('SmackJeeves/EvilPlan'),
            cls('SmackJeeves/ExperimentalMegaman'),
            cls('SmackJeeves/EyesOfADigimon'),
            cls('SmackJeeves/FailureConfetti'),
            cls('SmackJeeves/FairyTaleRejects'),
            cls('SmackJeeves/FaithlessDigitals'),
            cls('SmackJeeves/FalconersDailyStrips'),
            cls('SmackJeeves/FallenAngelslove'),
            cls('SmackJeeves/FarOutMantic'),
            cls('SmackJeeves/FarOutThere'),
            cls('SmackJeeves/FeralGentry'),
            cls('SmackJeeves/FinalArcanum'),
            cls('SmackJeeves/FireredLisasReise'),
            cls('SmackJeeves/FlyorFail'),
            cls('SmackJeeves/ForcedSeduction'),
            cls('SmackJeeves/ForgetTheDistance'),
            cls('SmackJeeves/Fortheloveofabrokenstring'),
            cls('SmackJeeves/FramebyFrame'),
            cls('SmackJeeves/FrobertTheDemon'),
            cls('SmackJeeves/FromnowonImagirl'),
            cls('SmackJeeves/FruitloopAndMrDownbeat'),
            cls('SmackJeeves/FullSpectrumTherapy'),
            cls('SmackJeeves/GamerCafe'),
            cls('SmackJeeves/GamesPeoplePlayUpdatedWeekly'),
            cls('SmackJeeves/GardenofHearts'),
            cls('SmackJeeves/GayBacon'),
            cls('SmackJeeves/GayTimesWithRyanAndJay'),
            cls('SmackJeeves/GetUpAndGo'),
            cls('SmackJeeves/GigisNuzlockeRuns'),
            cls('SmackJeeves/Gloomverse'),
            cls('SmackJeeves/Gnoph'),
            cls('SmackJeeves/GoodGame'),
            cls('SmackJeeves/GoodnightMrsGoose'),
            cls('SmackJeeves/Grayscale'),
            cls('SmackJeeves/GuardiansoftheGalaxialSpaceways'),
            cls('SmackJeeves/Habibahssong'),
            cls('SmackJeeves/HarvestMoonParadiseFound'),
            cls('SmackJeeves/HateThePlayer'),
            cls('SmackJeeves/HatShop'),
            cls('SmackJeeves/Helix'),
            cls('SmackJeeves/HeltonShelton'),
            cls('SmackJeeves/Hephaestus'),
            cls('SmackJeeves/HereBeVoodoo'),
            cls('SmackJeeves/HiddenStrengthAWhiteNuzlocke'),
            cls('SmackJeeves/Hinata'),
            cls('SmackJeeves/Holocrash'),
            cls('SmackJeeves/HolyBlasphemy'),
            cls('SmackJeeves/HolyCrap'),
            cls('SmackJeeves/HopeForABreeze'),
            cls('SmackJeeves/HouseOfCraziness'),
            cls('SmackJeeves/HurrocksFardel'),
            cls('SmackJeeves/IciVontLesMorts'),
            cls('SmackJeeves/Inchoatica'),
            cls('SmackJeeves/Ingloriousbasterds'),
            cls('SmackJeeves/InHouseHumor'),
            cls('SmackJeeves/Inhuman'),
            cls('SmackJeeves/InsideOuTAYuriTale'),
            cls('SmackJeeves/InspiredByADream'),
            cls('SmackJeeves/ItsAn8BitWorldBlankWorld'),
            cls('SmackJeeves/IWishIggysWish'),
            cls('SmackJeeves/JackiesStory'),
            cls('SmackJeeves/Jantar'),
            cls('SmackJeeves/Jason'),
            cls('SmackJeeves/JoeysAdventure'),
            cls('SmackJeeves/JourneyMan'),
            cls('SmackJeeves/JoyToTheWorld'),
            cls('SmackJeeves/June'),
            cls('SmackJeeves/JustAnotherLife'),
            cls('SmackJeeves/JustCrazy'),
            cls('SmackJeeves/Justmyluck'),
            cls('SmackJeeves/KaitoShuno'),
            cls('SmackJeeves/KasaKeira'),
            cls('SmackJeeves/KazanatoFuneralPlanningService'),
            cls('SmackJeeves/KCNO'),
            cls('SmackJeeves/KezroChroniclesPhantomOps'),
            cls('SmackJeeves/Kirbandfriendsshowcase'),
            cls('SmackJeeves/KirbiesoftheAlternateDimension'),
            cls('SmackJeeves/KirbyAdventure'),
            cls('SmackJeeves/KirbyDreamTeam'),
            cls('SmackJeeves/KirbyFunfestTheOriginals'),
            cls('SmackJeeves/KirbysDreamAdventure'),
            cls('SmackJeeves/KirbysDreamlandAdventures'),
            cls('SmackJeeves/KirbyTheDeeArmy'),
            cls('SmackJeeves/KissmeSnow'),
            cls('SmackJeeves/KissoftheDevil'),
            cls('SmackJeeves/Knightface'),
            cls('SmackJeeves/KnightsRequiem'),
            cls('SmackJeeves/KojiX5'),
            cls('SmackJeeves/Kreetor'),
            cls('SmackJeeves/Kruptos'),
            cls('SmackJeeves/KuronaFlutterandLylaSpamTime'),
            cls('SmackJeeves/LastBlockStanding'),
            cls('SmackJeeves/LavenderLegend'),
            cls('SmackJeeves/LeCirquedObscure'),
            cls('SmackJeeves/LedbyaMadMan'),
            cls('SmackJeeves/LegendOfZeldaAHerosStory'),
            cls('SmackJeeves/LegendOfZeldaStaffOfPower'),
            cls('SmackJeeves/LegendOfZeldaTheEdgeAndTheLight'),
            cls('SmackJeeves/LegendOfZeldaTheWindWaker'),
            cls('SmackJeeves/Lemongrass'),
            cls('SmackJeeves/LesCendresdelHiver'),
            cls('SmackJeeves/LethalDose'),
            cls('SmackJeeves/LetLoveRule'),
            cls('SmackJeeves/LicensedHeroes'),
            cls('SmackJeeves/LifeAsACutOut'),
            cls('SmackJeeves/LifeAsItWas'),
            cls('SmackJeeves/LifeLessOrdinary'),
            cls('SmackJeeves/Lifeonpaper'),
            cls('SmackJeeves/LightLovers'),
            cls('SmackJeeves/LightwithinShadow'),
            cls('SmackJeeves/LilLevi'),
            cls('SmackJeeves/LOGOS'),
            cls('SmackJeeves/LOKI'),
            cls('SmackJeeves/LondonUnderworld'),
            cls('SmackJeeves/LostNova'),
            cls('SmackJeeves/LoveandIcecream'),
            cls('SmackJeeves/LoveHarbor'),
            cls('SmackJeeves/LoveMeLoveMyTeddyBear'),
            cls('SmackJeeves/LoveroftheSunandMoon'),
            cls('SmackJeeves/LsEmpire'),
            cls('SmackJeeves/LuffinpuffandEric'),
            cls('SmackJeeves/LumasParadise'),
            cls('SmackJeeves/MagicalMisfits'),
            cls('SmackJeeves/Magipunk'),
            cls('SmackJeeves/Manifestedpart1'),
            cls('SmackJeeves/MarioandLuigiMisadventures'),
            cls('SmackJeeves/MariosDayJob'),
            cls('SmackJeeves/MarioVsSonicVsMegaMan'),
            cls('SmackJeeves/MarsMind'),
            cls('SmackJeeves/MarXistemTWC'),
            cls('SmackJeeves/Mascara'),
            cls('SmackJeeves/MatildasSweetCakeCafe'),
            cls('SmackJeeves/MayTheRainCome'),
            cls('SmackJeeves/Mazscara'),
            cls('SmackJeeves/MegaManTales'),
            cls('SmackJeeves/MegaPain'),
            cls('SmackJeeves/MelodyAndMacabre'),
            cls('SmackJeeves/MetroJack'),
            cls('SmackJeeves/MidnightPrince'),
            cls('SmackJeeves/MineS'),
            cls('SmackJeeves/Minibot'),
            cls('SmackJeeves/MinorActsOfHeroism'),
            cls('SmackJeeves/Missing'),
            cls('SmackJeeves/Missingversionfrancaise'),
            cls('SmackJeeves/MobianChaos'),
            cls('SmackJeeves/Mokepon'),
            cls('SmackJeeves/Monstar'),
            cls('SmackJeeves/MoonValley'),
            cls('SmackJeeves/MorphE'),
            cls('SmackJeeves/Mortifer'),
            cls('SmackJeeves/MrFactory'),
            cls('SmackJeeves/MyFakeHeart'),
            cls('SmackJeeves/MySisterTheDragon'),
            cls('SmackJeeves/MySparklingPrincesama'),
            cls('SmackJeeves/MyStereoBot'),
            cls('SmackJeeves/MysticanDreams'),
            cls('SmackJeeves/MYth'),
            cls('SmackJeeves/MythsOfUnovaAWhiteNuzlockeRunHardMode'),
            cls('SmackJeeves/Nah'),
            cls('SmackJeeves/Negligence'),
            cls('SmackJeeves/NeonGlow'),
            cls('SmackJeeves/NeverTheHero'),
            cls('SmackJeeves/Nexus'),
            cls('SmackJeeves/NiceKitty'),
            cls('SmackJeeves/NighHeavenandHell'),
            cls('SmackJeeves/NightSpace'),
            cls('SmackJeeves/NIK'),
            cls('SmackJeeves/NissiesDragonPrincess'),
            cls('SmackJeeves/NixsFireRedNuzlocke'),
            cls('SmackJeeves/NobleHeartsHiruandMerroug'),
            cls('SmackJeeves/NoEnd'),
            cls('SmackJeeves/NormalcyisforWimps'),
            cls('SmackJeeves/NotyoursamI'),
            cls('SmackJeeves/ObnoxiousHerokun'),
            cls('SmackJeeves/ObsidianHeart'),
            cls('SmackJeeves/October20th'),
            cls('SmackJeeves/OddPlaceOddTime'),
            cls('SmackJeeves/OldElastikid'),
            cls('SmackJeeves/OneRainyDay'),
            cls('SmackJeeves/Onlyonelovesong'),
            cls('SmackJeeves/OperationTheater'),
            cls('SmackJeeves/OriginBook1Codearth'),
            cls('SmackJeeves/OurTimeInEden'),
            cls('SmackJeeves/Outbreak'),
            cls('SmackJeeves/OutofKey'),
            cls('SmackJeeves/OverSync'),
            cls('SmackJeeves/Panacea'),
            cls('SmackJeeves/PantsParty'),
            cls('SmackJeeves/PanzerDragonandEnigmaCompleteEdition'),
            cls('SmackJeeves/Pause'),
            cls('SmackJeeves/PencilviewUpdatesMondayscough'),
            cls('SmackJeeves/PeterPan'),
            cls('SmackJeeves/Phantomland'),
            cls('SmackJeeves/PhotoShootNarusasuDoujinshi'),
            cls('SmackJeeves/PlasticKings'),
            cls('SmackJeeves/PlayTime'),
            cls('SmackJeeves/PleaseBeMyBoytoy'),
            cls('SmackJeeves/PMDExplorersOfHeart'),
            cls('SmackJeeves/PMDTeamFirefox'),
            cls('SmackJeeves/PMDVictoryFire'),
            cls('SmackJeeves/PokemonBeta'),
            cls('SmackJeeves/PokemonCrystalDoubleNuzlockeChallenge'),
            cls('SmackJeeves/PokemonLANDSKY'),
            cls('SmackJeeves/PokemonNoRakuen'),
            cls('SmackJeeves/PokemonParallel'),
            cls('SmackJeeves/PokemonSAKOHJU'),
            cls('SmackJeeves/Pokeventurous'),
            cls('SmackJeeves/Ponzi'),
            cls('SmackJeeves/PrettyMouth'),
            cls('SmackJeeves/PrincessChroma'),
            cls('SmackJeeves/ProfessorDolphinpresentsPokemon'),
            cls('SmackJeeves/ProjectCAPLimit'),
            cls('SmackJeeves/PTO'),
            cls('SmackJeeves/Puck'),
            cls('SmackJeeves/PullingYouUnder'),
            cls('SmackJeeves/PulseandBolt'),
            cls('SmackJeeves/PurpureaNoxa'),
            cls('SmackJeeves/QueerQueen'),
            cls('SmackJeeves/RainbowMansion'),
            cls('SmackJeeves/RainLGBT'),
            cls('SmackJeeves/RainxSasori'),
            cls('SmackJeeves/RANDOM'),
            cls('SmackJeeves/RareCandyTreatment'),
            cls('SmackJeeves/RavenWolf'),
            cls('SmackJeeves/Regina'),
            cls('SmackJeeves/ReidyAndFriendsShowcase'),
            cls('SmackJeeves/RemoteAngel'),
            cls('SmackJeeves/Replica'),
            cls('SmackJeeves/Respectable'),
            cls('SmackJeeves/ReturntoEden'),
            cls('SmackJeeves/ROSIER'),
            cls('SmackJeeves/RottenApple'),
            cls('SmackJeeves/RoyalIcing'),
            cls('SmackJeeves/RubyNation'),
            cls('SmackJeeves/RuneSpark'),
            cls('SmackJeeves/RUScrewed'),
            cls('SmackJeeves/RyuManwebcomicVersion'),
            cls('SmackJeeves/SabishiiGhost'),
            cls('SmackJeeves/SaintforRent'),
            cls('SmackJeeves/SakuraDAY'),
            cls('SmackJeeves/SakuraMishzo'),
            cls('SmackJeeves/SalemUncommons'),
            cls('SmackJeeves/SallySprocketAndPistonPete'),
            cls('SmackJeeves/SaltyKiss'),
            cls('SmackJeeves/SayWhatYouMean'),
            cls('SmackJeeves/SChIzO'),
            cls('SmackJeeves/SchoolOfRejectsSoRe'),
            cls('SmackJeeves/ScionsoftheSeraph'),
            cls('SmackJeeves/ScrappedProject'),
            cls('SmackJeeves/SecretPowerbk1'),
            cls('SmackJeeves/SecretPowerbk2'),
            cls('SmackJeeves/Seki'),
            cls('SmackJeeves/SeriousTimes'),
            cls('SmackJeeves/SFCBlackjackBay'),
            cls('SmackJeeves/SFCForestofDreams'),
            cls('SmackJeeves/Shameless'),
            cls('SmackJeeves/ShamelessAdvertisements'),
            cls('SmackJeeves/ShotoutofCanon'),
            cls('SmackJeeves/ShroudofLight'),
            cls('SmackJeeves/Signifikat'),
            cls('SmackJeeves/SimpleBear'),
            cls('SmackJeeves/Sire'),
            cls('SmackJeeves/Skeptical'),
            cls('SmackJeeves/Slackmatic'),
            cls('SmackJeeves/SLightlyAbOVeAvErage'),
            cls('SmackJeeves/SlipstreamSingularity'),
            cls('SmackJeeves/SmallPressAdventures'),
            cls('SmackJeeves/SocksMittensandScarfs'),
            cls('SmackJeeves/SomethingLikeaPhenomenon'),
            cls('SmackJeeves/SonicAuthorAdventII'),
            cls('SmackJeeves/SonicBoom'),
            cls('SmackJeeves/SonicClub'),
            cls('SmackJeeves/SonicDashly'),
            cls('SmackJeeves/SonicFuture'),
            cls('SmackJeeves/SonicSchoolRedo'),
            cls('SmackJeeves/SOSRadio'),
            cls('SmackJeeves/SouthernCross'),
            cls('SmackJeeves/SovereignTheMostAmazingComicEver'),
            cls('SmackJeeves/SparElricsExtras'),
            cls('SmackJeeves/Spellcross'),
            cls('SmackJeeves/SpiderWings'),
            cls('SmackJeeves/SplitScreen'),
            cls('SmackJeeves/SPRITEDHeroesofDobalia'),
            cls('SmackJeeves/Spriterschaos'),
            cls('SmackJeeves/Sprytts'),
            cls('SmackJeeves/Stay'),
            cls('SmackJeeves/StellaInChrome'),
            cls('SmackJeeves/Stereophonic'),
            cls('SmackJeeves/StolenGeneration'),
            cls('SmackJeeves/Storyofadamnedlove'),
            cls('SmackJeeves/StrangersandFriends'),
            cls('SmackJeeves/Striped'),
            cls('SmackJeeves/StuntRayWalterswish'),
            cls('SmackJeeves/SubjecttoChangeCollegeWoes'),
            cls('SmackJeeves/Sunfall'),
            cls('SmackJeeves/SunmeetsMoon'),
            cls('SmackJeeves/SUNRISESTORY'),
            cls('SmackJeeves/SuperDimensionAfterTheHero'),
            cls('SmackJeeves/SuperMarioBros3'),
            cls('SmackJeeves/SuperMarjoBros'),
            cls('SmackJeeves/SupermassiveBlackHoleA'),
            cls('SmackJeeves/SurvivorFanCharacters'),
            cls('SmackJeeves/SweetestPoison'),
            cls('SmackJeeves/SwitchMechanism'),
            cls('SmackJeeves/TaikiTheWebcomic'),
            cls('SmackJeeves/TailsAdventureThroughTimeandOtherWorlds'),
            cls('SmackJeeves/TakingPicturesofStrangers'),
            cls('SmackJeeves/TalesFromAaronsWings'),
            cls('SmackJeeves/TEN'),
            cls('SmackJeeves/ThatWasntThereYesterday'),
            cls('SmackJeeves/The13thWorld'),
            cls('SmackJeeves/TheAdventuresOfBanjoZ'),
            cls('SmackJeeves/TheAntihero'),
            cls('SmackJeeves/TheArchipelago'),
            cls('SmackJeeves/Theatrics'),
            cls('SmackJeeves/TheBattleInTheSky'),
            cls('SmackJeeves/TheBookOfNosferatu'),
            cls('SmackJeeves/TheBrideoftheShark'),
            cls('SmackJeeves/TheBucket'),
            cls('SmackJeeves/TheCafedAlizee'),
            cls('SmackJeeves/TheCavernOfSecrets'),
            cls('SmackJeeves/TheColony'),
            cls('SmackJeeves/TheContract'),
            cls('SmackJeeves/TheCrawl'),
            cls('SmackJeeves/TheDarkLegacy'),
            cls('SmackJeeves/TheDemonicAdventuresOfAngelWitchPita'),
            cls('SmackJeeves/TheDestroyer'),
            cls('SmackJeeves/TheDragonAndTheLemur'),
            cls('SmackJeeves/TheDreaming'),
            cls('SmackJeeves/TheDrifter'),
            cls('SmackJeeves/TheElectricRose'),
            cls('SmackJeeves/TheForestofWhispers'),
            cls('SmackJeeves/TheGhostWithTheMost'),
            cls('SmackJeeves/TheGoldRiderofPern'),
            cls('SmackJeeves/TheGrayZone'),
            cls('SmackJeeves/TheHeadhunters'),
            cls('SmackJeeves/TheHeartofEarth'),
            cls('SmackJeeves/TheiaMania'),
            cls('SmackJeeves/TheJosephComics'),
            cls('SmackJeeves/TheKeyHotelEnding'),
            cls('SmackJeeves/TheKwiddexProtocol'),
            cls('SmackJeeves/TheLastBloodCafe'),
            cls('SmackJeeves/ThelaughingDeath'),
            cls('SmackJeeves/TheLegendaryQueen'),
            cls('SmackJeeves/TheLifeofMagFlamequill'),
            cls('SmackJeeves/TheLoneSwordsman'),
            cls('SmackJeeves/TheMadMan'),
            cls('SmackJeeves/TheMegaManandSonicSpriteShowcase'),
            cls('SmackJeeves/TheNightSurfers'),
            cls('SmackJeeves/TheNocheComicSeries'),
            cls('SmackJeeves/TheNOMEDSEGA'),
            cls('SmackJeeves/ThePirateBalthasar'),
            cls('SmackJeeves/ThePremise'),
            cls('SmackJeeves/ThePrincessAndTheGiant'),
            cls('SmackJeeves/ThePropertyofHate'),
            cls('SmackJeeves/TheReborn'),
            cls('SmackJeeves/TheSearchForHenryJekyll'),
            cls('SmackJeeves/TheSilverLeague'),
            cls('SmackJeeves/TheSummerofBlakeSinclair'),
            cls('SmackJeeves/Theswordsmanandtheamnesiac'),
            cls('SmackJeeves/TheTimeDog'),
            cls('SmackJeeves/TheTytonNuzlockeChallengeEmeraldEdition'),
            cls('SmackJeeves/TheWhiteTower'),
            cls('SmackJeeves/TheWinterCampaign'),
            cls('SmackJeeves/TheYoshiHerd'),
            cls('SmackJeeves/ThiefCatcherRingTail'),
            cls('SmackJeeves/ThornsComic'),
            cls('SmackJeeves/ThornTopia'),
            cls('SmackJeeves/TLAAOK'),
            cls('SmackJeeves/ToddAllisonAndThePetuniaViolet'),
            cls('SmackJeeves/TosiHuonoYaoiSarjis'),
            cls('SmackJeeves/TotallyCrossover'),
            cls('SmackJeeves/TPTruePower'),
            cls('SmackJeeves/TrainerWantsToFight'),
            cls('SmackJeeves/Transfusions'),
            cls('SmackJeeves/TransUMan'),
            cls('SmackJeeves/TroubleNextDoor'),
            cls('SmackJeeves/UglyBoysLove'),
            cls('SmackJeeves/Uglygame'),
            cls('SmackJeeves/UnderTheDeadSkies'),
            cls('SmackJeeves/UnicampaLapis'),
            cls('SmackJeeves/UpDown'),
            cls('SmackJeeves/UshalaatWorldsEnd'),
            cls('SmackJeeves/Vacan7'),
            cls('SmackJeeves/VACANT'),
            cls('SmackJeeves/VerloreGeleentheid'),
            cls('SmackJeeves/VoidMisadventures'),
            cls('SmackJeeves/VoyageoftheBrokenPromise'),
            cls('SmackJeeves/WakeEcho'),
            cls('SmackJeeves/Wander'),
            cls('SmackJeeves/WantedDeadorDead'),
            cls('SmackJeeves/Wayfar'),
            cls('SmackJeeves/Waysoftheheart'),
            cls('SmackJeeves/WeAreGolden'),
            cls('SmackJeeves/WelcomeToFreakshow'),
            cls('SmackJeeves/WelcomeToThePCA'),
            cls('SmackJeeves/WhatAboutLove'),
            cls('SmackJeeves/WHATAboutSHADOWS'),
            cls('SmackJeeves/WhatIsDeepInOnesHeart'),
            cls('SmackJeeves/WhatWeRememberTheMost'),
            cls('SmackJeeves/WhenSheWasBad'),
            cls('SmackJeeves/Whenweweresilent'),
            cls('SmackJeeves/WhereaboutsOfTime'),
            cls('SmackJeeves/WhiteHeart'),
            cls('SmackJeeves/WhiteNoise'),
            cls('SmackJeeves/Wildflowers'),
            cls('SmackJeeves/WildWingBoys'),
            cls('SmackJeeves/WildWingBoysKoathArc'),
            cls('SmackJeeves/WingsOverEthereal'),
            cls('SmackJeeves/WingsTurnedtoDust'),
            cls('SmackJeeves/Wootlabs'),
            cls('SmackJeeves/XXMoralityXx'),
            cls('SmackJeeves/YadotCakeShop'),
            cls('SmackJeeves/YamanaokiHighSchool'),
            cls('SmackJeeves/YoungCannibals'),
            cls('SmackJeeves/ZaenWell'),
            cls('SmackJeeves/ZeldaTheNewAdventureofLinkIIMajorasMask'),
            cls('SnafuComics/KOF'),
            cls('SnafuComics/MyPanda'),
            cls('SnafuComics/SF'),
            cls('SnafuComics/Snafu'),
            cls('SnafuComics/Tin'),
            cls('SnafuComics/Titan'),
            cls('StudioKhimera/Eorah', 'mov'),
            cls('StuffNoOneToldMe'),
            cls('TaleOfTenThousand'),
            cls('TheCyantianChronicles/CookieCaper'),
            cls('TheCyantianChronicles/Pawprints'),
            cls('VGCats/Adventure'),
            cls('VGCats/Super'),
            cls('VictimsOfTheSystem'),
            cls('WebDesignerCOTW'),
            cls('WebToons/Adamsville'),
            cls('WebToons/CrapIDrewOnMyLunchBreak'),
            cls('WintersLight'),

            # Removed in 3.1
            cls('AbbysAgency', 'brk'),
            cls('AcademyVale'),
            cls('AhoyEarth', 'block'),
            cls('Anaria', 'del'),
            cls('Angels2200', 'del'),
            cls('BlackRose', 'brk'),
            cls('BloodBound', 'deny'),
            cls('CatenaManor/CatenaCafe'),
            cls('ComicsKingdom/AmazingSpiderman'),
            cls('ComicsKingdom/AmazingSpidermanSpanish'),
            cls('ComicsKingdom/BigBenBoltSundays'),
            cls('ComicsKingdom/BonersArkSundays'),
            cls('ComicsKingdom/BrianDuffy'),
            cls('ComicsKingdom/Crankshaft'),
            cls('ComicsKingdom/FlashGordonSundays'),
            cls('ComicsKingdom/FunkyWinkerbean'),
            cls('ComicsKingdom/FunkyWinkerbeanSunday'),
            cls('ComicsKingdom/FunkyWinkerbeanSundays'),
            cls('ComicsKingdom/FunkyWinkerbeanVintage'),
            cls('ComicsKingdom/HeartOfJulietJonesSundays'),
            cls('ComicsKingdom/KatzenjammerKidsSundays'),
            cls('ComicsKingdom/Lockhorns'),
            cls('ComicsKingdom/MandrakeTheMagicianSundays'),
            cls('ComicsKingdom/MikePeters'),
            cls('ComicsKingdom/MotherGooseAndGrimm'),
            cls('ComicsKingdom/PhantomSundays'),
            cls('ComicsKingdom/PrinceValiantSundays'),
            cls('ComicsKingdom/Retail'),
            cls('ComicsKingdom/TigerSundays'),
            cls('Everblue', 'block'),
            cls('FalseStart'),
            cls('FireflyCross'),
            cls('Ginpu'),
            cls('GoComics/9ChickweedLaneClassics'),
            cls('GoComics/Badlands'),
            cls('GoComics/BeanieTheBrownie'),
            cls('GoComics/BearWithMe'),
            cls('GoComics/BigNateFirstClass'),
            cls('GoComics/BreakOfDay'),
            cls('GoComics/Candorville'),
            cls('GoComics/DilbertClassics'),
            cls('GoComics/DilbertEnEspanol'),
            cls('GoComics/DumbwichCastle'),
            cls('GoComics/EyebeamClassic'),
            cls('GoComics/GarfieldClassics'),
            cls('GoComics/LaloAlcarazEnEspanol'),
            cls('GoComics/MakingIt'),
            cls('GoComics/MtPleasant'),
            cls('GoComics/PCAndPixel'),
            cls('GoComics/PetuniaAndDre'),
            cls('GoComics/RosebudsEnEspanol'),
            cls('GoComics/RudyPark'),
            cls('GoComics/SaltNPepper'),
            cls('GoComics/SigneWilkinson'),
            cls('GoComics/Snowflakes'),
            cls('GoComics/StoneSoupClassics'),
            cls('GoComics/StuartCarlson'),
            cls('GoComics/SunshineState'),
            cls('GoComics/TruthFacts'),
            cls('GoComics/Wannabe'),
            cls('KemonoCafe/PrincessBunny'),
            cls('Lackadaisy', 'block'),
            cls('MangaDex/AttackOnTitan', 'legal'),
            cls('MangaDex/DeliciousinDungeon', 'legal'),
            cls('MangaDex/FuguushokuKajishiDakedoSaikyouDesu', 'legal'),
            cls('MangaDex/ImTheMaxLevelNewbie', 'legal'),
            cls('MangaDex/KaetteKudasaiAkutsuSan', 'legal'),
            cls('MangaDex/PashiriNaBokuToKoisuruBanchouSan', 'legal'),
            cls('MangaDex/PleaseDontBullyMeNagatoro', 'legal'),
            cls('MangaDex/SaekiSanWaNemutteru', 'legal'),
            cls('MangaDex/SoloLeveling', 'legal'),
            cls('MangaDex/SousouNoFrieren', 'legal'),
            cls('MangaDex/TenseiShitaraSlimeDattaKen', 'legal'),
            cls('MangaDex/YuYuHakusho', 'legal'),
            cls('MrLovenstein', 'jsh'),
            cls('MyCartoons'),
            cls('RickGriffinStudios/TracesOfThePastNSFW'),
            cls('Shivae/BlackRose', 'brk'),
            cls('SoloLeveling', 'legal'),
            cls('StudioKhimera/Mousechevious'),
            cls('TalesAndTactics'),
            cls('Tapas/HoneyAndTheMoon'),
            cls('TracesOfThePast/NSFW'),
            cls('VampireHunterBoyfriends'),
            cls('WebToons/ABudgiesLife'),
            cls('WebToons/Anthronauts'),
            cls('WebToons/AssassinRoommate'),
            cls('WebToons/ChocoLatte'),
            cls('WebToons/CrystalVirus'),
            cls('WebToons/NightmareFactory'),
            cls('WebToons/OVERPOWERED'),

            # Removed in 3.2
            cls('ComicsKingdom/BeetleMoses'),
            cls('ComicsKingdom/BobMankoffPresentsShowMeTheFunny'),
            cls('ComicsKingdom/BobMankoffPresentsShowMeTheFunnyAnimalEdition'),
            cls('ComicsKingdom/Candorville'),
            cls('ComicsKingdom/DarrinBell'),
            cls('ComicsKingdom/FunnyOnlineAnimals'),
            cls('ComicsKingdom/GodsHands'),
            cls('ComicsKingdom/MaraLlaveKeeperOfTime'),
            cls('Dilbert'),
            cls('GoComics/DarrinBell'),
            cls('GoComics/EverydayPeopleCartoons'),
        )


class Renamed(Scraper):
    MSG = 'Comic module was renamed/moved to "%s", please use the new name instead.'
    count = 0

    @classmethod
    def counter(cls):
        cls.count += 1
        return cls.count

    def __init__(self, name, newname):
        super(Renamed, self).__init__(name)
        self.newname = newname
        self.i = self.counter()

    def getDisabledReasons(self):
        return {'ren-%i' % self.i: self.MSG % self.newname}

    @classmethod
    def getmodules(cls):
        return (
            # Renamed in 2.16
            cls('1997', '1977'),
            cls('ApartmentForTwo', 'NamirDeiter/ApartmentForTwo'),
            cls('Catena', 'CatenaManor'),
            cls('ComicFury/Alya', 'ComicFury/AlyaTheLastChildOfLight'),
            cls('ComicFury/Boatcrash', 'ComicFury/BoatcrashChronicles'),
            cls('ComicFury/Crimsonpixel', 'ComicFury/CrimsonPixelComics'),
            cls('ComicFury/Doublejump', 'ComicFury/DoubleJumpGameComics'),
            cls('ComicFury/Elektroanthology', 'ComicFury/ElektrosComicAnthology'),
            cls('ComicFury/ICanSeeYourFeels', 'ComicFury/SeeYourFeels'),
            cls('ComicFury/MAGISAupdatesMonWedFri', 'ComicFury/MAGISAPARASAYOupdatesMonFri'),
            cls('ComicFury/MonsterSoup', 'MonsterSoup'),
            cls('ComicFury/OopsComicAdventure', 'OopsComicAdventure'),
            cls('ComicFury/ThomasAndZachary', 'ComicFury/ThomasAndZacharyArchives'),
            cls('ComicGenesis/TheLounge', 'KeenSpot/TheLounge'),
            cls('Creators/ArchieinSpanish', 'Creators/ArchieSpanish'),
            cls('Creators/HeathcliffinSpanish', 'Creators/HeathcliffSpanish'),
            cls('Creators/TheWizardofIdinSpanish', 'Creators/WizardOfIdSpanish'),
            cls('DarkWings', 'Eryl'),
            cls('EyeOfRamalach', 'KemonoCafe/TheEyeOfRamalach'),
            cls('FoulLanguage', 'GoComics/FowlLanguage'),
            cls('KeenSpot/AntiheroForHire', 'AntiheroForHire'),
            cls('KeenSpot/ElGoonishShive', 'ElGoonishShive'),
            cls('KeenSpot/ElGoonishShiveNP', 'ElGoonishShiveNP'),
            cls('KeenSpot/Newshounds', 'Newshounds'),
            cls('KeenSpot/SinFest', 'SinFest'),
            cls('KeenSpot/TheGodChild', 'GodChild'),
            cls('LasLindas', 'KemonoCafe/LasLindas'),
            cls('NicoleAndDerek', 'NamirDeiter/NicoleAndDerek'),
            cls('OnTheFasttrack', 'ComicsKingdom/OnTheFastrack'),
            cls('PetiteSymphony/Djandora', 'ComicsBreak/Djandora'),
            cls('PetiteSymphony/Generation17', 'ComicsBreak/Generation17'),
            cls('PetiteSymphony/Rascals', 'KemonoCafe/Rascals'),
            cls('QuentynQuinnSpaceRanger', 'RHJunior/QuentynQuinnSpaceRanger'),
            cls('ShermansLagoon', 'GoComics/ShermansLagoon'),
            cls('SmackJeeves/AddictiveScience', 'KemonoCafe/AddictiveScience'),
            cls('SmackJeeves/CityFolk', 'ComicFury/CityFolk'),
            cls('SmackJeeves/DoomsdayMyDear', 'DoomsdayMyDear'),
            cls('SmackJeeves/ForestHill', 'ForestHill'),
            cls('SmackJeeves/Katran', 'ComicFury/KATRAN'),
            cls('SmackJeeves/LatchkeyKingdom', 'ComicFury/LatchkeyKingdom'),
            cls('SmackJeeves/Magience', 'ComicFury/Magience'),
            cls('SmackJeeves/RiversideExtras', 'RiversideExtras'),
            cls('SmackJeeves/StarTrip', 'StarTrip'),
            cls('TalesOfTheQuestor', 'RHJunior/TalesOfTheQuestor'),
            cls('TheProbabilityBomb', 'RHJunior/TheProbabilityBomb'),
            cls('TracyAndTristan', 'ComicFury/TracyAndTristan'),
            cls('UnlikeMinerva', 'NamirDeiter/UnlikeMinerva'),
            cls('Wulffmorgenthaler', 'WuMo'),
            cls('YouSayItFirst', 'NamirDeiter/YouSayItFirst'),
            cls('ZebraGirl', 'ComicFury/ZebraGirl'),

            # Renamed in 3.0
            cls('AHClub', 'RickGriffinStudios/AHClub'),
            cls('ComicFury/MuddlemarchMudCompany', 'ComicFury/MudCompany'),
            cls('ComicsKingdom/ShermansLagoon', 'GoComics/ShermansLagoon'),
            cls('ComicsKingdom/TheLittleKing', 'ComicsKingdom/LittleKing'),
            cls('GoComics/BloomCounty2017', 'GoComics/BloomCountyContinues'),
            cls('GoComics/Owlturd', 'GoComics/ShenComix'),
            cls('GoComics/RipleysBelieveItOrNotSpanish', 'GoComics/RipleysAunqueUstedNoLoCrea'),
            cls('GoComics/WebcomicName', 'WebcomicName'),
            cls('GoComics/Widdershins', 'Widdershins'),
            cls('Guardia', 'ComicFury/Guardia'),
            cls('RadioactivePanda', 'Tapas/RadioactivePanda'),
            cls('SmackJeeves/BlackTapestries', 'ComicFury/BlackTapestries'),
            cls('SmackJeeves/ByTheBook', 'ByTheBook'),
            cls('SmackJeeves/FurryExperience', 'ComicFury/FurryExperience'),
            cls('SmackJeeves/GrowingTroubles', 'ComicFury/GrowingTroubles'),
            cls('SmackJeeves/TheRealmOfKaerwyn', 'ComicFury/TheRealmOfKaerwyn'),
            cls('StudioKhimera/Draconia', 'Draconia'),
            cls('StudioKhimera/UberQuest', 'UberQuest'),
            cls('TracesOfThePast', 'RickGriffinStudios/TracesOfThePast'),

            # Renamed in 3.1
            cls('ComicsKingdom/SlylockFoxAndComicsForKids', 'ComicsKingdom/SlylockFox'),
            cls('ComicsKingdom/SlylockFoxAndComicsForKidsSpanish',
                'ComicsKingdom/SlylockFoxSpanish'),
            cls('Derideal/LRE', 'Derideal/RLE'),
            cls('Exiern', 'ComicFury/Exiern'),
            cls('GoComics/FalseKnees', 'WebToons/FalseKnees'),
            cls('GoComics/HeavenlyNostrils', 'GoComics/PhoebeAndHerUnicorn'),
            cls('GoComics/Rosebuds', 'ComicsKingdom/Rosebuds'),
            cls('MangaDex/TheWolfAndRedRidingHood', 'WebToons/TheWolfAndRedRidingHood'),
            cls('MaxOveracts', 'OccasionalComicsDisorder'),
            cls('SafelyEndangered', 'WebToons/SafelyEndangered'),

            # Renamed in 3.2
            cls('ComicsKingdom/WillyBlacksSpanish', 'ComicsKingdom/WillyBlackSpanish'),
            cls('GoComics/BloomCounty2019', 'GoComics/BloomCountyContinues'),
            cls('GoComics/CathyClassics', 'GoComics/Cathy'),
            cls('GoComics/OutOfTheGenePoolReRuns', 'GoComics/OutOfTheGenePool'),
            cls('GoComics/SnoopyEnEspanol', 'GoComics/PeanutsEnEspanol'),
            cls('GoComics/TheWizardOfIdSpanish', 'GoComics/WizardOfIdEnEspanol'),
            cls('PiledHigherAndDeeper', 'PHDComics'),
        )
