/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef SOC_MEDIATEK_COMMON_CLKBUF_H
#define SOC_MEDIATEK_COMMON_CLKBUF_H

#include <device/mmio.h>

enum {
	PMIC_RG_DCXO_CW00 = 0x0788,
	PMIC_RG_DCXO_CW02 = 0x0790,
	PMIC_RG_DCXO_CW08 = 0x079C,
	PMIC_RG_DCXO_CW09 = 0x079E,
	PMIC_RG_DCXO_CW09_CLR = 0x07A2,
	PMIC_RG_DCXO_CW10 = 0x07A4,
	PMIC_RG_DCXO_CW12 = 0x07A8,
	PMIC_RG_DCXO_CW13 = 0x07AA,
	PMIC_RG_DCXO_CW15 = 0x07AE,
	PMIC_RG_DCXO_CW19 = 0x07B6,
};

enum {
	PMIC_TOP_TMA_KEY = 0x3A8,
	PMIC_RG_TOP_SPI_CON1 = 0x458,
};

enum {
	PMIC_TOP_TMA_KEY_UNLOCK = 0x9CA6,
};

enum {
	PMIC_RG_LDO_VRFCK_ELR		= 0x1B40,
	PMIC_RG_LDO_VRFCK_CON0		= 0x1D1C,
	PMIC_RG_LDO_VRFCK_OP_EN		= 0x1D22,
	PMIC_RG_LDO_VRFCK_OP_EN_SET	= 0x1D24,
	PMIC_RG_LDO_VBBCK_CON0		= 0x1D2E,
	PMIC_RG_LDO_VBBCK_OP_EN		= 0x1D34,
	PMIC_RG_LDO_VBBCK_OP_EN_SET	= 0x1D36,
};

enum {
	PMIC_RG_DCXO_ADLDO_BIAS_ELR_0 = 0x209C,
	PMIC_RG_DCXO_ADLDO_BIAS_ELR_1 = 0x209E,
};

enum {
	PMIC_RG_XO_BUF_CTL0 = 0x54C,
	PMIC_RG_XO_BUF_CTL1 = 0x54E,
	PMIC_RG_XO_BUF_CTL2 = 0x550,
	PMIC_RG_XO_BUF_CTL3 = 0x552,
	PMIC_RG_XO_BUF_CTL4 = 0x554,
	PMIC_RG_XO_CONN_BT0 = 0x556,
};

DEFINE_BITFIELD(PMIC_REG_COMMON, 15, 0)
DEFINE_BIT(PMIC_RG_VRFCK_HV_EN, 9)
DEFINE_BIT(PMIC_RG_LDO_VRFCK_EN, 0)
DEFINE_BIT(PMIC_RG_LDO_VRFCK_ANA_SEL, 0)
DEFINE_BIT(PMIC_RG_LDO_VBBCK_EN, 0)
DEFINE_BIT(PMIC_RG_VRFCK_NDIS_EN, 11)
DEFINE_BIT(PMIC_RG_VRFCK_1_NDIS_EN, 0)
DEFINE_BIT(PMIC_RG_LDO_VRFCK_HW14_OP_EN, 14)
DEFINE_BIT(PMIC_RG_LDO_VBBCK_HW14_OP_EN, 14)
DEFINE_BIT(PMIC_RG_SRCLKEN_IN3_EN, 0)
DEFINE_BIT(PMIC_RG_XO_PMIC_TOP_DIG_SW, 2)
DEFINE_BITFIELD(PMIC_RG_XO_VOTE, 10, 0)

int clk_buf_init(void);

#endif /* SOC_MEDIATEK_COMMON_CLKBUF_H */
